// SPDX-License-Identifier: GPL-2.0-only
/*
 * SSM4567 amplifier audio driver
 *
 * Copyright 2014 Google Chromium project.
 *  Author: Anatol Pomozov <anatol@chromium.org>
 *
 * Based on code copyright/by:
 *   Copyright 2013 Analog Devices Inc.
 */

#include <linux/acpi.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/i2c.h>
#include <linux/regmap.h>
#include <linux/slab.h>
#include <sound/core.h>
#include <sound/pcm.h>
#include <sound/pcm_params.h>
#include <sound/soc.h>
#include <sound/initval.h>
#include <sound/tlv.h>

#define SSM4567_REG_POWER_CTRL		0x00
#define SSM4567_REG_AMP_SNS_CTRL		0x01
#define SSM4567_REG_DAC_CTRL		0x02
#define SSM4567_REG_DAC_VOLUME		0x03
#define SSM4567_REG_SAI_CTRL_1		0x04
#define SSM4567_REG_SAI_CTRL_2		0x05
#define SSM4567_REG_SAI_PLACEMENT_1		0x06
#define SSM4567_REG_SAI_PLACEMENT_2		0x07
#define SSM4567_REG_SAI_PLACEMENT_3		0x08
#define SSM4567_REG_SAI_PLACEMENT_4		0x09
#define SSM4567_REG_SAI_PLACEMENT_5		0x0a
#define SSM4567_REG_SAI_PLACEMENT_6		0x0b
#define SSM4567_REG_BATTERY_V_OUT		0x0c
#define SSM4567_REG_LIMITER_CTRL_1		0x0d
#define SSM4567_REG_LIMITER_CTRL_2		0x0e
#define SSM4567_REG_LIMITER_CTRL_3		0x0f
#define SSM4567_REG_STATUS_1		0x10
#define SSM4567_REG_STATUS_2		0x11
#define SSM4567_REG_FAULT_CTRL		0x12
#define SSM4567_REG_PDM_CTRL		0x13
#define SSM4567_REG_MCLK_RATIO		0x14
#define SSM4567_REG_BOOST_CTRL_1		0x15
#define SSM4567_REG_BOOST_CTRL_2		0x16
#define SSM4567_REG_SOFT_RESET		0xff

/* POWER_CTRL */
#define SSM4567_POWER_APWDN_EN		BIT(7