// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright 2018, Breno Leitao, IBM Corp.
 * Licensed under GPLv2.
 *
 * Sigfuz(tm): A PowerPC TM-aware signal fuzzer.
 *
 * This is a new selftest that raises SIGUSR1 signals and handles it in a set
 * of different ways, trying to create different scenario for testing
 * purpose.
 *
 * This test works raising a signal and calling sigreturn interleaved with
 * TM operations, as starting, suspending and terminating a transaction. The
 * test depends on random numbers, and, based on them, it sets different TM
 * states.
 *
 * Other than that, the test fills out the user context struct that is passed
 * to the sigreturn system call with random data, in order to make sure that
 * the signal handler syscall can handle different and invalid states
 * properly.
 *
 * This selftest has command line parameters to control what kind of tests the
 * user wants to run, as for example, if a transaction should be started prior
 * to signal being raised, or, after the signal being raised and before the
 * sigreturn. If no parameter is given, the default is enabling all options.
 *
 * This test does not check if the user context is being read and set
 * properly by the kernel. Its purpose, at this time, is basically
 * guaranteeing that the kernel does not crash on invalid scenarios.
 */

#include <stdio.h>
#include <limits.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <ucontext.h>
#include <sys/mman.h>
#include <pthread.h>
#include "utils.h"

/* Selftest defaults */
#define COUNT_MAX	600		/* Number of interactions */
#define THREADS		16		/* Number of threads */

/* Arguments options */
#define ARG_MESS_WITH_TM_AT	0x1
#define ARG_MESS_WITH_TM_BEFORE	0x2
#define ARG_MESS_WITH_MSR_AT	0x4
#define ARG_FOREVER		0x10
#define ARG_COMPLETE		(ARG_MESS_WITH_TM_AT |		\
				ARG_MESS_WITH_TM_BEFORE |	\
				ARG_MESS_WITH_MSR_AT)

static int args;
static int nthread = THREADS;
static int count_max = COUNT_MAX;

/* checkpoint context */
st