---
layout: post
title: Polyglot 1.8.0 - Liberação de contribuições comunitárias
lang: pt-BR
---

Fique animado com o Jekyll-Polyglot 1.8.0, que tem algumas melhorias de recursos e reconhece a documentação e contribuições da comunidade!

## links permanentes específicos idoma

Um novo recurso é fornecer links permanentes específicos ao idioma das páginas e manter sua associação com outras páginas relativas. Este novo recurso foi novamente aprimorado por **[antoniovazquezblanco](https://github.com/antoniovazquezblanco)**, que é um cavalheiro e estudioso.

## geração de mapa de site e SEO i18n

Este lançamento também reconhece a qualidade [sitemap.xml]({{ site.url }}/sitemap.xml) y [robots.txt]({{ site.url }}/robots.txt) solução fornecida por **[jerturowetz](https://github.com/jerturowetz)**. Este site agora demonstra e captura mais poder de SEO ao usá-los para ser rastreável como um site jekyll estático por provedores de pesquisa. Veja os arquivos do site de exemplo [aqui](https://github.com/untra/polyglot/tree/master/site).

## jekyll :polyglot :post_write hook

Github user **[obfusk](https://github.com/obfusk)** contribuiu com [pequeno PRs](https://github.com/untra/polyglot/pull/142) alguns anos atrás:

Com o poliglota `:site, :post_write` como estes são executados para cada processo filho:

```rb
Jekyll::Hooks.register :site, :post_write do |site|
  ...
end
```

Esta versão adiciona um personalizado `:post_write` hook que é executado exatamente uma vez, depois que todos os idiomas foram processados (whether or not `parallel_localization` is used):

```rb
Jekyll::Hooks.register :polyglot, :post_write do |site|
  # faça algo incrível aqui!
end
```

This feature is helpful for complex jekyll static sites that make additional use of [jekyll hook plugins](https://jekyllrb.com/docs/plugins/hooks/).

Obfusk also contributed a fix for [additional logging when language subprocesses crash](https://github.com/untra/polyglot/pull/145). Thanks for this contribution!

## localized variables and portuguese translation.

**[george-gca](https://github.com/george-gca)** is a talented and awesome guy, contributing [an entire blogpost](/2024/02/29/localized-variables/) on how best to localize rich text from site data. He also provided a [site brazilian translation](https://polyglot.untra.io/pt-BR/). 

