# 1.7.4 (future)

# 1.7.3
- AUDIO: Audio mixer supports FLAC/MP3 file types now!
- COMMON: Fixed bug 'crashing in cores that don't range check retro_set_controller_type'. Some people were having crashes when device is set to RETRO_DEVICE_NONE and the cores don't check the number of ports, in VBAM's case it was overflowing and crashing. QuickNES was crashing too.
- COMMON: Fixed buffer overflow in url encoding (affecting MSVC2010/2013).
- COMMON: (QuickMenu) Added Configuration Override submenu.
- HID: Merge new HID subsystem.
- HID: Fix WaveBird support for the Wii U GCA.
- HID/OSX: Fix regression with IODHIDManager - gamepads which are connected later would not be autoconfigured.
- LOCALIZATION: Update Italian translation.
- LOCALIZATION: Update Japanese translation.
- LOCALIZATION: Update Portuguese translation.
- MENU: Audio mixer now works in the menu without any cores loaded. You have to enable the setting 'Enable menu audio' for this to work.
- REMAPPING/OVERLAYS: Fix regression - overlays could no longer be remapped.
- SCANNER: Add Wii Backup File WBFS support.
- X11: CRT SwitchRes support for X11/Linux.

# 1.7.2
- ANDROID/OPENSL: Prevent crashes when setting audio latency too low (buffer count can never be lower than 2 now).
- CRT: Added CRT SwitchRes.
- COMMON: Hide the 'Core delete' option if the 'Core updater' is also hidden.
- COMMON: Add way to reset core association for playlist entry.
- COMMON: Fix invalid long command line options causing infinite loop on Windows
- COMMON: Add OSD statistics for video/audio/core.
- COMMON: Added runahead system; allows you to drive down latency even further.
- COMMON: Fix buggy behavior that could happen with ZIP file reading on some platforms as a result of not initializing struct.
- CHEEVOS: Support Atari 2600, Virtual Boy, and Arcade (only Neo Geo, CPS-1, CPS-2 and CPS-3 and only with fbalpha core).
- CHEEVOS: Add option to automatically take a screenshot when an achievement is triggered.
- CHEEVOS: Fixed incompatibilities with Neo Geo Pocket achievement sets.
- CHEEVOS: Store only login token, not password.
- D3D10: Added D3D10 driver to release build. Has working shaders (Slang), overlay, and menu display driver support. Should be on par capabilities wise
with D3D11 driver except for there being no hardware rendering right now.
- D3D11: Experimental hardware renderer. Allows for libretro cores to use D3D11 for hardware rendering. First core to use this is PPSSPP.
- D3D11: Increase backwards compatibility, shaders compile with Shader Model 4.0 now, added support for more feature levels.
- D3D10/D3D11/D3D12: Fix crashes with completely black or white thumbnail textures in XMB.
- GUI: Support disabling window decorations on Windows and Linux.
- LIBRETRO: Addition - Functions to enable and disable audio and video, and an environment function to query status of audio and video enables.
- LOCALIZATION: Update Italian translation.
- LOCALIZATION: Update Polish translation.
- MENU: Add Rewind/Latency/Overlay settings to Quick Menu, add options to show/hide them (User Interface -> Views -> Quick Menu)
- MENU/RGUI: Only show Menu Linear Filter for RGUI and only show it for
video drivers that implement it (D3D8/9/10/11/12/GL)
- MENU/RGUI: Add User Interface -> Appearance options.
- MENU/RGUI: D3D8/D3D9: Hookup Menu Linear Filter
- MENU/XMB: Disable XMB shadow icons by default for PowerPC and ARM for performance reasons.
- MENU/XMB: Left/right thumbnails are now automatically scaled according to layout.
- MENU/XMB: Add Left Thumbnails (additional to the right). 
- MENU/XMB: Fixed left/right tab regression.
- MENU/XMB: Fix scaling of tall images that were cut on bottom previously.
- MENU/XMB: Menu scale factor setting now changes texts length, image scaling and margins.
- MENU/XMB: Mouse cursor scales correctly now.
- MENU/XMB: Add toggle to show/hide Playlist tabs.
- MENU/XMB: Add menu layout - can switch between Desktop, Handheld and Auto.
- MENU/XMB: Don't load menu pipeline shaders unless XMB is selected (D3D10/D3D11/D3D12/GL/Vulkan)
- MENU/VIDEO: Only show black frame insertion for the video drivers/context drivers
that support it (so far this includes - D3D8/D3D9, OpenGL, Vulkan)
- MENU/VIDEO:  Only show max swapchain images if supported by video driver and/or context driver (so far this includes - DRM EGL context driver, VideoCore EGL context driver, Vulkan)
- MENU/MaterialUI: Automatic DPI Scaling should be much improved now, now scales as expected at 1440p and 4K resolutions.
- MENU/MaterialUI: Fix wrong calculation of an entry height causing long playlists to end up outside of screen range. This also could cause crashes on low DPI screens.
- IOS: Fixed crash when opening downloaded roms from Safari or using the "Open in.." functionality. Added the compiler flag to support keyboard remapping to controls.
- IOS: Fixed buffer overlap that caused a crash while trying to download GLSL shaders from the buildbot.
- PS3: fix URLS
- REMAPS: Mapping keyboard keys from more than one gamepad (works with dosbox)
- REMAPS: Mapping more than one button to the same action
- REMAPS: Unmapping buttons
- REMAPS: Unmapping analogs
- REMAPS: Mapping a button to trigger an analog response (tested with mupen, can run on SM64 with the d-pad now, triggers a full analog tilt)
- REMAPS: Mapping an analog to another analog (having more than one analog mapped to the same output causes issues)
- REMAPS: Mapping an analog to produce a button response
- SCANNER: Should be able to scan dual-layer Wii disc images now, filestream code now supports files larger than 4GB.
- SHADERS/SLANG: Slang shaders should work again on Android version and MSVC versions (basically all the Griffin-based versions).
- SHADERS: If GL context is GLES2/3/Core context, Cg shaders are unavailable. Applies to shader list too.
- SHADERS: Hide cg/glsl shaders from being able to be selected if D3D8/9/10/11/Vulkan video drivers are selected.
- SHADERS: Hide slang shaders from being able to be selected if D3D8/9/OpenGL video drivers are selected.
- SHADERS: Prevent crashes from occurring if we have the GL video driver in use and we try to skip to a slang shader through next/previous hotkeys
- SHADERS: Fix shader parameter increase / decrease functions
- SUBSYSTEM: handle savestates properly (cart1 + cart2.state0)
- VULKAN/X11: Fix X11 Vulkan bug from Wayland driver.
- VULKAN: Fix multi-line text spacing in menus with Vulkan driver.
- WINDOWS XP: Add Cheevos support.
- WINDOWS/MSVC 2003/2005/2010/2013/2015/2017: Add Cheevos support.
- VITA: Bugfix for 'PS Vita takes many time to start to accept input' issue.
- X11: Allow compositor disabling on X11 fullscreen through _NET_WM_BYPASS_COMPOSITOR
- X11: Prioritize _NET_WM_STATE_FULLSCREEN_ in true fullscreen mode
- WIIU: Fix OOB read/write in keyboard driver.

# 1.7.1
- 3DS: Now correctly reports amount of CPU cores.
- 3DS: Frontend rating is now correctly implemented for both New 3DS/2DS and Old 3DS/2DS.
- 3DS: Initial networking support, HTTP requests won't work yet.
- 3DS: Now reports memory and battery state.
- AUDIO: Added 'Audio Resampler Quality' setting to Audio Settings. Setting this higher will increase sound quality at the expense of sound latency and/or performance. Setting this value lower will improve sound latency/performance at the expense of sound quality. Only has an effect if the Sinc resampler is used, and you have to restart the game for changes to take effect.
- CHEEVOS: Fix unofficial achievements not being loaded.
- CHEEVOS: Show savestate menu entries when no achievements are found even if hardcore mode is enabled.
- CHEEVOS: Support Neo Geo Pocket.
- COMMON: Bugfix for issue related to 'Windows mouse pointer visible when running MESS or MAME cores'.
- COMMON: Fix bug 'Last item in a Playlist is ignored'.
- COMMON: New LED API. Driver implemented for Raspberry Pi, proof of concept implemented for core MAME 2003.
- COMMON: Add quick menu option to watch shader files for changes and recompile them automatically (Linux only for now).
- D3D8: Direct3D 8 can now work on systems that have Direct3D 8 installed.
- D3D9: Add menu support for MaterialUI/XMB.
- D3D10: Initial video driver implementation.
- D3D11: Initial video driver implementation.
- D3D11: SPIRV-Cross/slang shader support for D3D11.
- D3D12: Initial video driver implementation.
- DINPUT: don't reinitialize input driver on network events / media insertion / network drive connection
- INPUT: show friendly names when available under input binds and system information
- INPUT: show the config name when available under system information
- GUI: Allow changing menu font color.
- GUI: Menu visibility options for RGUI and MaterialUI.
- GUI/MaterialUI: Works now with D3D8, D3D9 Cg, D3D11 and D3D12 drivers.
- GUI/XMB: Add Monochrome Inverted icon theme.
- GUI/XMB: Allow changing menu scale to 200%.
- GUI/XMB: Works now with D3D8, D3D9 Cg, D3D11 and D3D12 drivers. Menu shader effects currently don't work on D3D8/D3D9 Cg.
- HAIKU: Restored port.
- KEYMAPPER: prevent a condition that caused input_menu_toggle to stop working when a RETRO_DEVICE_KEYBOARD type device is enabled
- GL: ignore hard gpu sync when fast-forwarding
- IOS10/11: Handle hardware keyboards and iCade controllers
- LOCALIZATION: Update Italian translation.
- LOCALIZATION: Update Japanese translation.
- LOCALIZATION: Update Portuguese-Brazilian translation.
- LOCALIZATION: Update Spanish translation.
- NETPLAY: Add menu option to select different MITM (relay) server locations.
- OSX: Modify HID buttons detection algorithm.
- QB: Added --datarootdir, --sysconfdir, --bindir, --docdir and --mandir.
- QB: Deprecated --global-config-dir, --with-bin_dir and --with-man_dir.
- SHADERS: Allow saving of shader presets based on the parent directory (Saving one for */foo/bar/mario.sfc* would result in *shaders/presets/corename/bar.ext*). We decided it's safer to still isolate the presets to a single core because different cores may treat video output differently.
- SHADERS: Don't save the path to the current preset to the main config. This was causing weird behavior, instead it will try to load *currentconfig.ext* and it will save a preset with that name when select *apply shader preset*. The resulting shader will restore properly after restarting and even after core/parent/game specific presets are loaded
- SOLARIS: Initial port.
- SWITCH: Initial Nintendo Switch port, based on libtransistor SDK.
- PS3: Enable Cheevos.
- PSP: Enable threading support through pthreads.
- SHADERS: SPIRV-Cross/slang shader support for D3D11.
- SHIELD ATV: Allow the remote / gamepad takeover hack to work with the 2017 gamepad
- SUBSYSTEM: Subsystem saves now respect the save directory
- SUBSYSTEM: You can now load subsystem games from the menu (see https://github.com/libretro/RetroArch/pull/6282 for caveats)
- VULKAN: Fix swapchain recreation bug on Nvidia GPUs with Windows 10 (resolved in Windows Nvidia driver version 390.77).
- WINDOWS: Improved Unicode support (for cores/directory creation and 7zip archives).
- WINDOWS: Show progress meter on taskbar for downloads (Windows 7 and up).
- WINDOWS: WS_EX_LAYERED drastically decreases performance, so only set it when needed (transparency in windowed mode).
- WIIU: Overlay support.
- WIIU: Transparency support in menu + overlays.
- WIIU: Increased stability during core switching.
- WIIU: Shader support.
- WIIU: Menu shader effects added (shaders).
- WIIU: Add missing time/clock support. (also fixes RTC [Real Time Clock] in Gambatte)
- XBOX OG: Restored port.

# 1.7.0
- CHEEVOS: Add badges for achievements, shows thumbnail images of achievements.
- CHEEVOS: Leaderboard support.
- CHEEVOS: Only disable savestates on hardcore mode if achievements are not available.
- COMMANDLINE: Fix fullscreen toggle switch.
- COMMON: Add 'Automatically Load Content To Playlist' feature, enabled by default.
- COMMON: Fix slowmotion ratio always being reset back to 1.
- COMMON: Optimized NBIO implementations now for Apple, Windows, and Linux. Uses mmap for Linux/Windows/BSD if/when available. File I/O should now be much faster for loading images inside the menu.
- COMMON: Native Blissbox support now for latest firmware as of writing (2.0). Implementation through libusb and/or native Windows HID.
- COMMON: New lightgun API.
- COMMON: New VFS (Virtual File System) API.
- COMMON: Fixed some playlist bugs.
- COMMON: New snow shader.
- COMMON: Fix Quick Menu title, no longer shows 'Select File'.
- COMMON: Fix loading cores that require no content one after another.
- COMMON: Map Delete key to Y button for non-unified menu keyboard controls.
- COMMON: Fix for relative paths being normalised and generating a duplicate history entry.
- EMSCRIPTEN: Fix references to browserfs.
- FREEBSD: Support libusb HID input driver.
- HAIKU: Buildfix.
- INPUT: Map clear button to DEL key.
- LINUX/X11: Add RetroArch logo to window title bar.
- LINUX/X11: Input driver now supports new lightgun code.
- LINUX/X11: Support window transparency (requires a compositing window manager).
- LOBBIES: Fix for crash on join netplay rooms via touch / glui.
- LOCALIZATION: Update Italian translation.
- LOCALIZATION: Update Japanese translation.
- LOCALIZATION: Update Portuguese-Brazilian translation.
- LOCALIZATION: Update Polish translation.
- LOCALIZATION: Update Russian translation.
- MENU: Snowflake menu shader effect.
- OSX/PPC: Fix the GL2 renderchain, had to use EXT versions of framebuffer/renderbuffer functions.
- PS3: HTTP requests / downloads should now work.
- PS3: Core Updater now works.
- PS3: Improved font rendering, enable STB Unicode font renderer.
- PSP: Make it work with Vita's Adrenaline.
- PSP: Fix audio sync.
- PSP: Fix content loading, port should be functional again.
- PSP: Use 64MB when available.
- SCANNER: Fix crash from Windows-incompatible format string.
- VITA: Improve packaging, installation times.
- WIIU: Disabled the controller patcher for now since it was the source of many stability issues.
- VULKAN: Various stability fixes for WSI.
- WINDOWS: Add MSVC 2017 solution.
- WINDOWS: Get rid of the empty console window in MSVC 2010 builds.
- WINDOWS: Raw input driver now supports new lightgun code.
- WINDOWS: Use configured OSD/text message color on GDI driver.
- WINDOWS/XINPUT: Populate XInput VID/PID from DInput so autoconfig doesn't rely solely on joypad names
- WINDOWS/XINPUT: Fix crash that occurs in some situations with Steam running and a Steam Controller plugged in.
- WINDOWS: Improve version reporting under System Information.
- WINDOWS: Support window transparency.
- WINDOWS: Correct usage of GetWindowPlacement per MS docs, fixes game window position on Win95/98.
- WINDOWS: Added Visual Studio 2017 support.

# 1.6.9
- COMMON: Small memory leak.
- NETPLAY: Fix network command only working once.

# 1.6.8
- Audio: Fix the Audio DSP picker
- CHEEVOS: Add support for Atari Lynx cheevos.
- CHEEVOS: Add support for RetroAchievements Leaderboards.
- GUI: (MaterialUI) Fix crash that happened on context reset with Vulkan.
- GUI: (MaterialUI) Skip querying and drawing items that are not visible; Cache content height and bbox calculation.
- GUI: (MaterialUI) Fix entry box highlight calculation.
- GUI: (XMB) Skip drawing the fading list when it is already transparent. Optimization.
- GUI: (XMB) Comment out visible item calculation in xmb_draw_items().
- GUI: (RGUI) Prevent crashes when using a non-English language reliant on UTF8.
- GUI: Add menu option for OSD background color.
- GUI: Add menu option for OSD text color.
- GUI: Add menu option to remove frame count from OSD.
- GUI: Allow wraparound of int/float settings when pressing the left key
- INPUT/LIBRETRO: Add support for more mouse buttons (buttons 4/5)
- INPUT/LIBRETRO: Add support for analog buttons
- INPUT: Always show the controls menu even if descriptors are not set
- INPUT: Fix input descriptors not being set on cores that don't implement the controllers interface
- INPUT: Apply descriptors only for the amount of cores the core supports
- INPUT: Implement keyboard to gamepad input remapping (limited to one gamepad device for now)
- INPUT: Fix absolute mouse move handling on the winraw driver
- INPUT: Ignore keyboard input if window is not active on udev driver
- INPUT: Sanitize the filenames of autoconfig profiles before saving
- LOBBIES: Fix crash on navigating left / right from the lobby menu
- LOCALIZATION: Update Dutch translation
- LOCALIZATION: Update Italian translation.
- LOCALIZATION: Update Japanese translation.
- LOCALIZATION: Update Portuguese-Brazilian translation.
- LOCALIZATION: Update Russian translation.
- LINUX/ARMHF: Set buildbot updater URL to armhf location instead of blank string
- LINUX/PI: Broadcom VC4: Add Videocore config option
- LINUX/UDEV: Fix - RetroArch reads keyboard input when not focused with the udev input driver.
- NETPLAY: Fix disconnection not fully deinitializing Netplay.
- NETPLAY: Fix lan rooms when there is more than one room
- NETPLAY: Fix lan rooms on systems where all addresses are treated as IPv6
- COMMON: Fix clear/free loop conditionals in playlists.
- WINDOWS/GDI: Fix flickering of text.
- WINDOWS/GDI: Fix graphics corruption on Windows 98
- WINDOWS/GDI: Allow compiling without DirectInput8 for NT support
- WINDOWS/WGL: Try to use wglSwapLayerBuffers instead of SwapBuffers if possible (for more optimal performance).
- WINDOWS: Fix menubar text corruption on Japanese locale systems
- WINDOWS: Support Unicode file I/O (can now display CJK characters in file browser for example).
- WINDOWS: Support Windows 95, NT3.51, NT4
- WINDOWS: add Makefile.griffin targets for msvc6,2003,2005,2010,2012,2013
- WII: Use custom, embedded libogc SDK.
- WIIU: Initial touchscreen support for WiiU gamepad.
- WIIU: Add Cheevos support.
- SCANNER: Fix archive scanning.
- SCANNER: Support CHD files.
- SCANNER: Support Gamecube ISO scanning.
- SCANNER: Use primary data track of disc images for CRC lookups rather than cue files.  This is slower but finds matches more reliably, and is necessary for CHD files to work at all.  Update your databases!
- SCANNER: Fall back on looking inside archives when matching MAME/FBA content (most recent cores only).  If you had difficulty with content being detected before, you may have better luck now.  Update your databases and core info!

# 1.6.7
- SCANNER: Fix directory scanning.
- SCANNER: Fix file scanning.
- COMMON: Fix 'Disk Image Append' option.
- FREEBSD: Compatibility fixes for Video4Linux2 camera driver.
- GUI: (MaterialUI) Add disk image append icons.
- GUI: (MaterialUI) Improve word wrapping when menu icons are enabled.
- GUI: (MaterialUI) Add User Interface -> Appearance -> Menu Icons Enable. You can turn on/off the icons on the lefthand side of the menu entries.
- GUI: Performance optimizations for XMB menu driver - only calculates visible items.
- LOCALIZATION: Update Italian translation.

# 1.6.6
- 3DS: Fixes serious performance regression that affected every core; rewind was always implicitly enabled.
- AUDIO: MOD/S3M/XM sound should now be properly mixed in with the core's sound.
- GUI: Visual makeover of MaterialUI.
- GUI: Added 'Music', 'Images' and 'Video' collection options to RGUI/MaterialUI.
- GUI: Allow the user to add 'Favorites'.
- GUI: Allow the user to rename entries.
- GUI: Performance optimizations for XMB menu driver.
- LOCALIZATION: Update Italian translation
- INPUT: Overlay controller response - when we press buttons on the gamepad or keyboard, the corresponding buttons on the overlay will be highlighted as well.
- NETBSD: Silence some compilation warnings.
- COMMON: Fixed bug 'Deleting an entry from a playlist would not update the list view inside XMB'.
- COMMON: Fix inet_ntop_compat on Unix
- LOBBY: Add skeleton to add help descriptions to lobbies

# 1.6.5
Skipped this one.

# 1.6.4

- ANDROID: Fire Stick & Fire TV remote overrides gamepad port 0 on button press and viceversa like SHIELD devices
- ANDROID: Provide default save / system / state / screenshot locations
- AUDIO: Audio mixer supports MOD/S3M/XM file types now!
- INPUT: input swap override flag (for remotes) is cleared correctly
- INPUT: allow specifying libretro device in remap files
- INPUT: allow specifying analog dpad mode in remap files
- INPUT: allow saving libretro device to remap files
- INPUT: allow saving analog dpad mode to remap files
- INPUT: allow removing core and game remap files from the menu
- COMMON: Cores can now request to set a 'shared context'. You no longer need to explicitly enable 'Shared Hardware Context' for Citra/OpenLara/Dolphin.
- COMMON: Add 'Delete Core' option to Core Information menu.
- COMMON: Allow Max Timing Skew to be set to 0.
- COMMON: Change the "content dir" behavior so it works on either a flag or an empty directory setting, now platform drivers can provide defaults for save / system / state / screenshot dirs and still allow the content dir functionality, these settings are under settings / saving and flagged as advanced
- GUI: You can turn on/off 'Horizontal Animation' now for the XMB menu. Turning animations off can result in a performance boost.
- GUI: Fix sublabel word-wrapping in XMB where multi-byte languages were cut off too soon
- LOCALIZATION: Update Dutch translation
- LOCALIZATION: Update Traditional Chinese translation
- LOCALIZATION: Update Italian translation
- LOCALIZATION: Update Russian translation
- WINDOWS: Provide default save / system / state / screenshot locations
- LOBBIES: Show what country the host is in
- MENU: Enable OSD text rendering for gdi and libcaca drivers
- WINDOWS 98/ME/2K: Set default directory for MSVC 2005 RetroArch version.
- WII: Better V-Sync handling, backported from SuperrSonic.
- WIIU: Exception handler rewritten.

# 1.6.3
- IOS: Fix GL regression - 32bit color format cores were no longer rendering
- CHEEVOS: Add support for N64 cheevos and other small fixes.
- CHEEVOS: Add 'Achievements -> Achievements Verbose Mode'. Ability to display cheevos related messages in OSD, useful for RetroAchievements users.
- AUDIO: Audio mixer's volume can now be independently increased/decreased, and muted.
- AUDIO: Mute now no longer disables/enables audio but instead properly mutes the audio volume. Mute is also independent from the audio mixer volume.
- INPUT: Add mouse index selection; ability now to select between different mice
- INPUT: Fix 'All Users Control Menu' setting
- LINUX: Add a tinyalsa audio driver. Doesn't require asoundlib, should be self-contained and lower-level.
- LOBBIES: Announce the RetroArch version too
- LOCALIZATION: Add Traditional Chinese translation
- LOCALIZATION: Update French translation
- LOCALIZATION: Update Italian translation
- LOCALIZATION: Update Japanese translation
- LOCALIZATION: Update Russian translation
- MENU: Add 'User Interface -> Views'. Ability to display/hide online updater and core updater options.
- NETPLAY: Disconnecting one client shouldn't cause everyone to disconnect anymore
- NETWORK: SSL/TLS support, disabled by default
- SCANNER: Fix PS1 game scanning
- SCANNER: Move content list builder into scanner task with progress, fixes menu freeze with large playlists
- SDL2: Fix 'SDL2 driver does not see the hat on wired Xbox 360 controller"
- SETTINGS: Fix regression 'Custom Viewport is no longer overridable per-core or per-game'
- VITA: Add cheevos support
- VITA: Add support for external USB if mounted
- WAYLAND: Fix menu mouse input
- WII: Add support for single-port 'PS1/PS2 to USB controller adapter

# 1.6.0
- ANDROID: Allow remotes to retain OK/Cancel position when menu_swap_ok_cancel is enabled
- ANDROID: Improve autoconf fallback
- ANDROID: Improve shield portable/gamepad device grouping workaround
- ANDROID: Runtime permission checking
- AUDIO: Audio mixer support. Mix up to 8 streams with the game's audio.
- AUTOSAVE/SRAM - Fix bug #3829 / #4820 (https://github.com/libretro/RetroArch/issues/3829)
- ENDIANNESS: Fixed database scanning. Should fix scanning on PS3/WiiU/Wii, etc.
- LOBBIES: Fallback to filename based matching if no CRC matches are found (for people making playlists by hand)
- LOBBIES: GUI refinement, show stop hosting when a host has been started, show disconnect when playing as client
- LOBBIES: if the game is already loaded it will try to connect directly instead of re-loading content (non-fullpath cores only)
- LOBBIES: unify both netplay menus
- LOCALIZATION/GUI: Korean font should display properly now with XMB/MaterialUI's default font
- LOCALIZATION: Update German translation
- LOCALIZATION: Update Japanese translation
- LOCALIZATION: Update Russian translation
- LOCALIZATION: Update/finish French translation
- MENU: Improved rendering for XMB ribbon; using additive blending (Vulkan/GL)
- MISC: Various frontend optimizations.
- NET: Fix bug #4703 (https://github.com/libretro/RetroArch/issues/4703)
- OSX/MACOS: Fixes serious memory leak
- THUMBNAILS: Thumbnails show up now in Load Content -> Collection, Information -> Database
- VIDEO: Fix threaded video regression; tickering of menu entries would no longer work.
- VITA: Fix 30fps menu (poke into input now instead of reading the entire input buffer which apparently is slow)
- VITA: Fix frame throttle
- VITA: Fix slow I/O
- VULKAN: Fix some crashes on loading some thumbnails
- VULKAN: Unicode font rendering support. Should fix bad character encoding for French characters, etc.
- WII: Fix crashing issues which could occur with the dummy core
- WIIU: HID Controller support
- WIIU: Initial network/netplay support
- WIIU: XMB/MaterialUI menu driver support
- WINDOWS: Added RawInput input driver for low-latency, low-level input.
- WINDOWS: Added WASAPI audio driver for low-latency audio. Both shared and exclusive mode.
- WINDOWS: Core mouse input should be relative again in cores

# 1.5.0
- ANDROID: Autoconf fallback
- ANDROID: Mouse support / Emulated mouse support
- AUTOCONF: Fix partial matches for pad name
- CHEEVOS: Fix crashes in the cheevos description menu
- CHEEVOS: WIP leaderboards support
- COMMON: 9-slice texture drawing support
- COMMON: Threading fixes
- CORETEXT/APPLE: Ability to load menu display font drivers and loading of custom font.
- DOS: Add keyboard driver
- DOS: Improve color accuracy and scaling
- GUI: Add a symbol page in the OSK
- GUI: Allow changing icon theme on the fly
- GUI: Better dialogs for XMB
- GUI: Various settings are now only visible when advanced settings is enabled
- LOCALIZATION: Add/update Korean translation
- LOCALIZATION: Rewrite German translation
- LOCALIZATION: Update several English sublabels
- LOCALIZATION: Update several Japanese labels
- MOBILE: Long-tap a setting to reset to default
- MOBILE: Single-tap for menu entry selection
- NET: Allow manual netplay content loading
- NET: Announcing network games to the public lobby is optional now
- NET: Bake in miniupnpc
- NET: Fix netplay join for contentless cores
- NET: Fix netplay rooms being pushed on the wrong tab
- NET: Lan games show next to lobbies with (lan) and connect via the private IP address
- NET: Use new lobby system with MITM support
- NUKLEAR: Update to current version
- SCANNER: Always add 7z & zip to supported extensions
- VULKAN: Add snow/bokeh shader pipeline effects - at parity with GL now
- VULKAN: Find supported composite alpha in swapchain
- WIIU: Keyboard support
- WINDOWS: Fix loading of core/content via file menu
- WINDOWS: Logging to file no longer spawns an empty window

# 1.4.1
