% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devutils.R
\name{packageData}
\alias{packageData}
\alias{ldata}
\title{Loading Package Data}
\usage{
packageData(list, envir = .GlobalEnv, ..., options = NULL,
  stringsAsFactors = getOption("stringsAsFactors", TRUE))

ldata(list, ..., package = NULL, error = TRUE, simplify = TRUE)
}
\arguments{
\item{list}{character vector containing the names of the data to load.}

\item{envir}{the \link{environment} where the data should be loaded.}

\item{...}{other arguments eventually passed to \code{\link[utils]{data}}.}

\item{options}{list of R options to set before calling \code{\link[utils]{data}}.
This may be useful the data is shipped as an R script.}

\item{stringsAsFactors}{logical that indicates if character columns of tabular data should be
converted into factors.}

\item{package}{
    a character vector giving the package(s) to look
    in for data sets, or \code{NULL}.

    By default, all packages in the search path are used, then
    the \file{data} subdirectory (if present) of the current working
    directory.
  }

\item{error}{a logical that indicates whether an error should be thrown if
the requested data cannot be found.}

\item{simplify}{logical that indicates if queries of one object only (i.e. argument \code{list}
is of length one) should return the data object itself.}
}
\value{
the loaded data.
}
\description{
Loads package data using \code{\link[utils]{data}}, but allows the user to avoid
NOTEs for a \sQuote{non visible binding variable} to be thrown when checking a package.
This is possible because this function returns the loaded data.
}
\section{Functions}{
\itemize{
\item \code{ldata}: loads a package data in the parent frame.
It is a shortcut for \code{packageData(list, ..., envir=parent.frame())}.
}}

\examples{
\dontshow{
options(R_CHECK_RUNNING_EXAMPLES_=TRUE) ## roxygen generated flag
}


\dontrun{ mydata <- packageData('mydata') }


\dontrun{ 
# in a package' source => won't issue a NOTE
myfunction function(){
	mydata <- ldata('mydata') 
}
}

}
