% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitClu.R
\encoding{UTF-8}
\name{splitClu}
\alias{splitClu}
\alias{splitCluRes}
\title{Functions creating a list of partitions based on a single partition and information on the number of units in each set.}
\usage{
splitClu(clu, n, renumber = FALSE)

splitCluRes(res, renumber = FALSE)
}
\arguments{
\item{clu}{A vector representing a partition of units from different sets. Result of some legacy code for \code{\link{optRandomParC}} or \code{\link{optParC}} or similar functions.}

\item{n}{A vector with number of units per set. The assuption is that the first \code{n[1]} elements of \code{clu} are for the first set, the second \code{n[2]} elements of \code{clu} are for the second set and so on. \code{sum(n)} must be equal to \code{length(clu)}.}

\item{renumber}{If \code{TRUE} (default), dimensions that have only one level are dropped (\code{drop} function is applied to the final result).}

\item{res}{Result of  (old versions of) functions \code{\link{critFunC}}, \code{\link{optParC}}, \code{\link{optRandomParC}} or similar.}
}
\value{
A list of partitions if \code{clu}, one for each set of units. A single vector if only one set of units is present.
}
\description{
Function \code{splitClu} creates a list of partitions based on a single partition (\code{clu}) and information on the number of units in each set (\code{n}).

Function \code{splitCluRes} does the same but extracts the information from the result of (old versions of) functions \code{\link{critFunC}}, \code{\link{optParC}}, \code{\link{optRandomParC}} or similar (newer versions should already return a list of partitions in case they are used on networks with more sets of units.
}
\examples{
n <- c(8,8) 
clu <- c(rep(1:2, times = c(3, 5)), rep(3:4, times = c(3, 5)))
splitClu(clu = clu, n = n )
splitClu(clu = clu, n = n, renumber = TRUE)
 
}
\seealso{
\code{\link{clu}}
}
\author{
\enc{Aleš Žiberna}{Ales Ziberna}
}
\keyword{manip}
