# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-785-1 (ipsec-tools)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64198);
 script_cve_id("CVE-2009-1574", "CVE-2009-1632", "CVE-2009-0558", "CVE-2009-0561", "CVE-2009-1151", "CVE-2009-2011", "CVE-2009-1140", "CVE-2007-3091", "CVE-2008-2321", "CVE-2009-1684");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Ubuntu USN-785-1 (ipsec-tools)";
 script_name(name);

 desc = "The remote host is missing an update to ipsec-tools
announced via advisory USN-785-1.

Details follow:

It was discovered that ipsec-tools did not properly handle certain
fragmented packets. A remote attacker could send specially crafted packets
to the server and cause a denial of service. (CVE-2009-1574)

It was discovered that ipsec-tools did not properly handle memory usage
when verifying certificate signatures or processing nat-traversal
keep-alive messages. A remote attacker could send specially crafted packets
to the server and exhaust available memory, leading to a denial of service.
(CVE-2009-1632)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  racoon                          1:0.6.5-4ubuntu1.3

Ubuntu 8.04 LTS:
  racoon                          1:0.6.7-1.1ubuntu1.2

Ubuntu 8.10:
  racoon                          1:0.7-2.1ubuntu1.8.10.1

Ubuntu 9.04:
  racoon                          1:0.7-2.1ubuntu1.9.04.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-785-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-785-1 (ipsec-tools)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ipsec-tools", ver:"0.6.5-4ubuntu1.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"racoon", ver:"0.6.5-4ubuntu1.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ipsec-tools", ver:"0.6.7-1.1ubuntu1.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"racoon", ver:"0.6.7-1.1ubuntu1.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ipsec-tools", ver:"0.7-2.1ubuntu1.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"racoon", ver:"0.7-2.1ubuntu1.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ipsec-tools", ver:"0.7-2.1ubuntu1.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"racoon", ver:"0.7-2.1ubuntu1.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"quagga-doc", ver:"0.99.2-1ubuntu3.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"quagga", ver:"0.99.2-1ubuntu3.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"quagga-doc", ver:"0.99.9-2ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"quagga", ver:"0.99.9-2ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"quagga-doc", ver:"0.99.9-6ubuntu0.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"quagga", ver:"0.99.9-6ubuntu0.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
