###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_netscape_select_obj_dos_vuln_win.nasl 3578 2009-07-28 21:30:29Z jul $
#
# Netscape 'selecti()' Object Denial Of Service Vulnerability (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900393);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2542", "CVE-2009-1692");
  script_bugtraq_id(35446);
  script_name("Netscape 'select()' Object Denial Of Service Vulnerability (Win)");
  desc = "

  Overview: This host is installed with Netscape browser and is prone to Denial
  of Service vulnerability.

  Vulnerability Insight:
  Error occurs while calling the 'select()' method with a large integer that
  results in continuous allocation of x+n bytes of memory exhausting memory
  after a while.

  Impact:
  Successful exploitation will let the attacker to cause a denial of service.

  Impact Level: System/Application

  Affected Software/OS:
  Netscape version 6 and 8 on Windows

  Fix:
  No solution or patch is available as on 28th July, 2009, Information regarding
  this issue will be updated once the solution details are available.
  For updates refer, http://browser.netscape.com/

  References:
  http://www.milw0rm.com/exploits/9160
  http://www.g-sec.lu/one-bug-to-rule-them-all.html
  http://www.securityfocus.com/archive/1/archive/1/504969/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Netscape");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_netscape_detect_win.nasl");
  script_require_keys("Netscape/Win/Ver");
  exit(0);
}


netscapeVer = get_kb_item("Netscape/Win/Ver");
if(netscapeVer =~ "^(6|8)\..*"){
  security_warning(0);
}
