###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for net-snmp vulnerabilities USN-685-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840244);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "USN", value: "685-1");
  script_cve_id("CVE-2008-0960", "CVE-2008-2292", "CVE-2008-4309");
  script_name( "Ubuntu Update for net-snmp vulnerabilities USN-685-1");
  desc = "

  Vulnerability Insight:

  Wes Hardaker discovered that the SNMP service did not correctly validate
  HMAC authentication requests.  An unauthenticated remote attacker
  could send specially crafted SNMPv3 traffic with a valid username
  and gain access to the user's views without a valid authentication
  passphrase. (CVE-2008-0960)
  
  John Kortink discovered that the Net-SNMP Perl module did not correctly
  check the size of returned values.  If a user or automated system were
  tricked into querying a malicious SNMP server, the application using
  the Perl module could be made to crash, leading to a denial of service.
  This did not affect Ubuntu 8.10. (CVE-2008-2292)
  
  It was discovered that the SNMP service did not correctly handle large
  GETBULK requests.  If an unauthenticated remote attacker sent a specially
  crafted request, the SNMP service could be made to crash, leading to a
  denial of service. (CVE-2008-4309)

  Affected Software/OS:
  net-snmp vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-December/000796.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of net-snmp vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libsnmp-perl", ver:"5.2.1.2-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsnmp9-dev", ver:"5.2.1.2-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsnmp9", ver:"5.2.1.2-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"snmp", ver:"5.2.1.2-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"snmpd", ver:"5.2.1.2-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsnmp-base", ver:"5.2.1.2-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tkmib", ver:"5.2.1.2-4ubuntu2.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"libsnmp-dev", ver:"5.4.1~dfsg-7.1ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsnmp-perl", ver:"5.4.1~dfsg-7.1ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsnmp15", ver:"5.4.1~dfsg-7.1ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"snmp", ver:"5.4.1~dfsg-7.1ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"snmpd", ver:"5.4.1~dfsg-7.1ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsnmp-python", ver:"5.4.1~dfsg-7.1ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsnmp-base", ver:"5.4.1~dfsg-7.1ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tkmib", ver:"5.4.1~dfsg-7.1ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"libsnmp-dev", ver:"5.4.1~dfsg-4ubuntu4.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsnmp-perl", ver:"5.4.1~dfsg-4ubuntu4.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsnmp15", ver:"5.4.1~dfsg-4ubuntu4.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"snmp", ver:"5.4.1~dfsg-4ubuntu4.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"snmpd", ver:"5.4.1~dfsg-4ubuntu4.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsnmp-python", ver:"5.4.1~dfsg-4ubuntu4.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsnmp-base", ver:"5.4.1~dfsg-4ubuntu4.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tkmib", ver:"5.4.1~dfsg-4ubuntu4.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libsnmp-dev", ver:"5.3.1-6ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsnmp-perl", ver:"5.3.1-6ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsnmp10", ver:"5.3.1-6ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"snmp", ver:"5.3.1-6ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"snmpd", ver:"5.3.1-6ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsnmp-base", ver:"5.3.1-6ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tkmib", ver:"5.3.1-6ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}