#
#VID 3e3c860d-7dae-11d9-a9e7-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52188);
 script_cve_id("CVE-2005-0100");
 script_bugtraq_id(12462);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: zh-emacs, emacs";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   zh-emacs
   emacs
   xemacs
   xemacs-mule
   zh-xemacs
   zh-xemacs-mule
   xemacs-devel
   xemacs-devel-21.5
   xemacs-devel-mule
   mule-common
   hanemacs

CVE-2005-0100
Format string vulnerability in the movemail utility in (1) Emacs 20.x,
21.3, and possibly other versions, and (2) XEmacs 21.4 and earlier,
allows remote malicious POP3 servers to execute arbitrary code via
crafted packets.

Solution:
Update your system with the appropriate patches or
software upgrades.


Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: zh-emacs, emacs";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"zh-emacs");
if(!isnull(bver) && revcomp(a:bver, b:"20.7_4")<0) {
    security_note(0, data:"Package zh-emacs version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"21")>0 && revcomp(a:bver, b:"21.3_4")<0) {
    security_note(0, data:"Package zh-emacs version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"emacs");
if(!isnull(bver) && revcomp(a:bver, b:"20.7_4")<0) {
    security_note(0, data:"Package emacs version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"21")>0 && revcomp(a:bver, b:"21.3_4")<0) {
    security_note(0, data:"Package emacs version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"xemacs");
if(!isnull(bver) && revcomp(a:bver, b:"21.4.17")<0) {
    security_note(0, data:"Package xemacs version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"xemacs-mule");
if(!isnull(bver) && revcomp(a:bver, b:"21.4.17")<0) {
    security_note(0, data:"Package xemacs-mule version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"zh-xemacs");
if(!isnull(bver) && revcomp(a:bver, b:"21.4.17")<0) {
    security_note(0, data:"Package zh-xemacs version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"zh-xemacs-mule");
if(!isnull(bver) && revcomp(a:bver, b:"21.4.17")<0) {
    security_note(0, data:"Package zh-xemacs-mule version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"xemacs-devel");
if(!isnull(bver) && revcomp(a:bver, b:"21.5.b19,1")<0) {
    security_note(0, data:"Package xemacs-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"xemacs-devel-21.5");
if(!isnull(bver) && revcomp(a:bver, b:"b11")==0) {
    security_note(0, data:"Package xemacs-devel-21.5 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"xemacs-devel-mule");
if(!isnull(bver) && revcomp(a:bver, b:"21.5.b19")<0) {
    security_note(0, data:"Package xemacs-devel-mule version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mule-common");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package mule-common version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"hanemacs");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package hanemacs version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
