# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7924 (pdfedit)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64538);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 11 FEDORA-2009-7924 (pdfedit)");

 desc = "The remote host is missing an update to pdfedit
announced via advisory FEDORA-2009-7924.

Free pdf editing using PdfEdit. Complete editing of pdf documents is made
possible with PDFedit. You can change either raw pdf objects (for advanced
users) or use predefined gui functions. Functions can be easily added as
everything is based on a script.

Update Information:

Update to new upstream version 0.4.3 fixing multiple issues:
* xpdf code base updated to 3.02pl3 patch which fixes
  several serious remote vulnerabilities
* French translation update (bug 275)
* Fix for [33853] Secunia advisory backported from poppler
* Flattener class implemented (bt#289)
* Bugs 248, 256, 285, ...

ChangeLog:

* Tue Jul 21 2009 Bernard Johnson - 0.4.3-1

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update pdfedit' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7924

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-7924 (pdfedit)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"pdfedit", rpm:"pdfedit~0.4.3~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pdfedit-debuginfo", rpm:"pdfedit-debuginfo~0.4.3~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
