# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 957-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56217);
 script_cve_id("CVE-2005-4601");
 script_bugtraq_id(16093);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 957-2 (imagemagick)";
 script_name(name);

 desc = "The remote host is missing an update to imagemagick
announced via advisory DSA 957-2.

Florian Weimer discovered that delegate code in ImageMagick is
vulnerable to shell command injection using specially crafted file
names.  This allows attackers to encode commands inside of graphic
commands.  With some user interaction, this is exploitable through
Gnus and Thunderbird.  This update filters out the '$' character as
well, which was forgotton in the former update.

For the old stable distribution (woody) this problem has been fixed in
version 5.4.4.5-1woody8.

For the stable distribution (sarge) this problem has been fixed in
version 6.0.6.2-2.6.

For the unstable distribution (sid) this problem has been fixed in
version 6.2.4.5-0.6.

We recommend that you upgrade your imagemagick packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20957-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 957-2 (imagemagick)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"imagemagick", ver:"5.4.4.5-1woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++5", ver:"5.4.4.5-1woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++5-dev", ver:"5.4.4.5-1woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick5", ver:"5.4.4.5-1woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick5-dev", ver:"5.4.4.5-1woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perlmagick", ver:"5.4.4.5-1woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"imagemagick", ver:"6.0.6.2-2.6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++6", ver:"6.0.6.2-2.6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++6-dev", ver:"6.0.6.2-2.6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick6", ver:"6.0.6.2-2.6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick6-dev", ver:"6.0.6.2-2.6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perlmagick", ver:"6.0.6.2-2.6", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
