# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 899-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55886);
 script_cve_id("CVE-2005-0870", "CVE-2005-2600", "CVE-2005-3347", "CVE-2005-3348");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 899-1 (egroupware)";
 script_name(name);

 desc = "The remote host is missing an update to egroupware
announced via advisory DSA 899-1.

Several vulnerabilities have been discovered in egroupware, a
web-based groupware suite.  The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2005-0870

Maksymilian Arciemowicz discoverd several cross site scripting
problems in phpsysinfo, which are also present in the imported
version in egroupware and of which not all were fixed in DSA 724.

CVE-2005-2600

Alexander Heidenreich discovered a cross-site scripting problem in
the tree view of FUD Forum Bulletin Board Software, which is also
present in egroupwre and allows remote attackers to read private
posts via a modified mid parameter.

CVE-2005-3347

Christopher Kunz discovered that local variables get overwritten
unconditionally in phpsyinfo, which are also present in
egroupware, and are trusted later, which could lead to the
inclusion of arbitrary files.

CVE-2005-3348

Christopher Kunz discovered that user-supplied input is used
unsanitised in phpsyinfo and imported in egroupware, causing a
HTTP Response splitting problem.

The old stable distribution (woody) does not contain egroupware packages.

For the stable distribution (sarge) this problem has been fixed in
version 1.0.0.007-2.dfsg-2sarge4.

For the unstable distribution (sid) this problem has been fixed in
version 1.0.0.009.dfsg-3-3.

We recommend that you upgrade your egroupware packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20899-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 899-1 (egroupware)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"egroupware-addressbook", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-bookmarks", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-calendar", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-comic", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-core", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-developer-tools", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-email", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-emailadmin", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-etemplate", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-felamimail", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-filemanager", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-forum", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-ftp", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-fudforum", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-headlines", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-infolog", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-jinn", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-ldap", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-manual", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-messenger", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-news-admin", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-phpbrain", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-phpldapadmin", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-phpsysinfo", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-polls", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-projects", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-registration", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-sitemgr", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-stocks", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-tts", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-wiki", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware", ver:"1.0.0.007-2.dfsg-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
