# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 713-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53541);
 script_cve_id("CVE-2005-1108", "CVE-2005-1109");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 713-1 (junkbuster)";
 script_name(name);

 desc = "The remote host is missing an update to junkbuster
announced via advisory DSA 713-1.

Several bugs have been found in junkbuster, a HTTP proxy and filter.
The Common Vulnerability and Exposures project identifies the
following vulnerabilities:

CVE-2005-1108

James Ranson discovered that an attacker can modify the referrer
setting with a carefully crafted URL by accidently overwriting a
global variable.

CVE-2005-1109

Tavis Ormandy from the Gentoo Security Team discovered several
heap corruptions due to inconsistent use of an internal function
that can crash the daemon or possibly lead to the execution of
arbitrary code.

For the stable distribution (woody) these problems have been fixed in
version 2.0.2-0.2woody1.

The unstable distribution (sid) doesn't contain the junkbuster package
anymore.

We recommend that you upgrade your junkbuster package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20713-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 713-1 (junkbuster)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"junkbuster", ver:"2.0.2-0.2woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
