# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 567-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53258);
 script_cve_id("CVE-2004-0803", "CVE-2004-0804", "CVE-2004-0886");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 567-1 (tiff)";
 script_name(name);

 desc = "The remote host is missing an update to tiff
announced via advisory DSA 567-1.

Several problems have been discovered in libtiff, the Tag Image File
Format library for processing TIFF graphics files.  An attacker could
prepare a specially crafted TIFF graphic that would cause the client
to execute arbitrary code or crash.  The Common Vulnerabilities and
Exposures Project has identified the following problems:

CVE-2004-0803

Chris Evans discovered several problems in the RLE (run length
encoding) decoders that could lead to arbitrary code execution.

CVE-2004-0804

Matthias Clasen discovered a division by zero through an integer
overflow.

CVE-2004-0886

Dmitry V. Levin discovered several integer overflows that caused
malloc issues which can result to either plain crash or memory
corruption.


For the stable distribution (woody) these problems have been fixed in
version 3.5.5-6woody1.

For the unstable distribution (sid) these problems have been fixed in
version 3.6.1-2.

We recommend that you upgrade your libtiff package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20567-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 567-1 (tiff)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libtiff-tools", ver:"3.5.5-6woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff3g", ver:"3.5.5-6woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff3g-dev", ver:"3.5.5-6woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
