# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 280-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53349);
 script_cve_id("CVE-2003-0201", "CVE-2003-0196");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 280-1 (samba)";
 script_name(name);

 desc = "The remote host is missing an update to samba
announced via advisory DSA 280-1.

Digital Defense, Inc. has alerted the Samba Team to a serious
vulnerability in, a LanManager-like file and printer server for Unix.
This vulnerability can lead to an anonymous user gaining root access
on a Samba serving system.  An exploit for this problem is already
circulating and in use.

Since the packags for potato are quite old it is likely that they
contain more security-relevant bugs that we know of.  You are
therefore advised to upgrade your systems running Samba to woody
soon.

Unofficial backported packages from the Samba maintainers for version
2.2.8 of Samba for woody are available at
<http://poeple.debian.org/~peloy/> and
<http://poeple.debian.org/~vorlon/>.

For the stable distribution (woody) this problem has been fixed in
version 2.2.3a-12.3.

For the old stable distribution (potato) this problem has been fixed in
version 2.0.7-5.1.

The unstable distribution (sid) is not affected since it contains
version 3.0 packages already.

We recommend that you upgrade your Samba packages immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20280-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 280-1 (samba)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"samba-doc", ver:"2.0.7-5.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"2.0.7-5.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"2.0.7-5.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"2.0.7-5.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"2.0.7-5.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"2.0.7-5.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc", ver:"2.2.3a-12.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"2.2.3a-12.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"2.2.3a-12.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"2.2.3a-12.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"2.2.3a-12.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"2.2.3a-12.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"2.2.3a-12.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"2.2.3a-12.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"2.2.3a-12.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"2.2.3a-12.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
