# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1150-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57267);
 script_cve_id("CVE-2006-2194");
 script_bugtraq_id(18849);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1150-1 (shadow)";
 script_name(name);

 desc = "The remote host is missing an update to shadow
announced via advisory DSA 1150-1.

A bug has been discovered in several packages that execute teh
setuid() system call without checking for sucess when trying to drop
privileges, which may fail with some PAM configurations.

For the stable distribution (sarge) this problem has been fixed in
version 4.0.3-31sarge8.

For the unstable distribution (sid) this problem has been fixed in
version 4.0.17-2.

We recommend that you upgrade your passwd package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201150-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1150-1 (shadow)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"login", ver:"4.0.3-31sarge8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"passwd", ver:"4.0.3-31sarge8", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
