#if   !defined(__ARGUMENTCONTEXT_HPP)
#define  __ARGUMENTCONTEXT_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__THREADCONTEXT_HPP)
#include <ThreadContext.hpp>
#endif

typedef  int (*ArgumentFunctionPtr)( const int & );  

DECLARE_CLASS( ArgumentContext )

/**
ArgumentContext shows off how by extending ThreadContext we can add 
arguments to the call and use any method not just those prototyped
by the system. 
*/

class ArgumentContext : public CORELINUX(ThreadContext)
{

public:

   //
   // Constructors and destructor
   //

                        /// Default

                        ArgumentContext( ArgumentFunctionPtr, int arg=0 )
                           throw ( CORELINUX( Assertion ) );

                        /// With stack

                        ArgumentContext
                           ( 
                              ArgumentFunctionPtr, 
                              CORELINUX(Size), 
                              int arg=0 
                           )
                           throw ( CORELINUX( Assertion ) );

                        /// Copy constructor

                        ArgumentContext( ArgumentContextCref )
                           throw ( CORELINUX( Assertion ) );

                        /// Virtual destructor

   virtual              ~ArgumentContext( void );

   //
   // Operator overloads
   //

            /**
            Assignment operator changes the context
            @param ArgumentContext reference to existing context
            @return ArgumentContext reference
            @exception ThreadNotWaitingException if the
            argument context is not in a THREAD_WAITING_TO_START
            state.
            */
         
            ArgumentContextRef  operator=( ArgumentContextCref )
               throw( CORELINUX( Assertion ) );
         

            /**
            Equality operator compares contexts
            @param ArgumentContext reference to existing context
            @return bool true if same
            */
         
            bool  operator==( ArgumentContextCref ) const;

   //
   // Accessors
   //

            /// Return the argument to the caller

            const int &  getArgument( void ) const;   


   //
   // Mutators
   //

            /// Sets the argument after initialization

            void  setArgument( const int & ) ;


protected:

   //
   // Constructor
   //

                        /// Can't use!

                        ArgumentContext( void )
                           throw ( CORELINUX( Assertion ) );

   //
   // Accessor
   //
            /// Return the function to invoke

            ArgumentFunctionPtr    getArgumentFunction( void );

private:

               /**
               The default allocation routine for the managers ThreadContext.
               The copy constructor is called with the argument reference
               @param ThreadContext reference to the context supplied in the
               startThread method.
               @return The newly allocated managed context
               */

      static   CORELINUX(ThreadContextPtr)  argumentContextCreate
                  ( 
                     CORELINUX(ThreadContextRef) 
                  );

               /**
               The default destroyer of managed ThreadContexts.
               @param ThreadContext pointer to managed object.
               */

      static   void  argumentContextDestroy( CORELINUX(ThreadContextPtr) );

      static   Int   argumentFrame( CORELINUX(ThreadContextPtr) );


private:

            /// The callers argument

            int      theArgument;
};


#endif

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.3 $
   $Date: 2000/04/06 12:41:12 $
   $Locker:  $
*/

