#!/bin/sh

set -e

DESTDIR=${DESTDIR:-../tarballs}
MODULE=CGI-Application
PACKAGE=libcgi-application-perl
VERSION=4.61
REDIRECT_VERS=1.00
STDCFG_VERS=1.01
ERROR_VERS=1.21
FD=--force-download
NS=--no-symlink
RE=--rename
DD="--destdir ${DESTDIR}"
RS=--report-status
DC=-"-watch debian/components"
US=--upstream-version

if [ $1 ]
then
    echo update;
    rm -f ${DESTDIR}/${MODULE}*.tar.gz
    uscan ${FD} ${RE} ${DD} && true;
    uscan ${DC}/ep/watch ${FD} ${NS} ${DD} ${US} ${ERROR_VERS} && true;
    uscan ${DC}/r/watch ${FD} ${NS} ${DD} ${US} ${REDIRECT_VERS} && true;
    uscan ${DC}/sc/watch ${FD} ${NS} ${DD} ${US} ${STDCFG_VERS} && true;
    cd ${DESTDIR}
    REDIRECT=`ls CGI-Application-Plugin-Redirect*.tar.gz`
    mv ${REDIRECT} ${PACKAGE}_${VERSION}.orig-r.tar.gz
    STDCFG=`ls CGI-Application-Standard-Config*.tar.gz`
    mv ${STDCFG} ${PACKAGE}_${VERSION}.orig-sc.tar.gz
    ERROR=`ls CGI-Application-Plugin-ErrorPage*.tar.gz`
    mv ${ERROR} ${PACKAGE}_${VERSION}.orig-ep.tar.gz
    cd -
else
    echo report;
    uscan ${RS} && true;
    uscan ${DC}/ep/watch ${RS} ${DD} ${US} ${ERROR_VERS} && true;
    uscan ${DC}/sc/watch ${RS} ${DD} ${US} ${STDCFG_VERS} && true;
    uscan ${DC}/r/watch ${RS} ${DD} ${US} ${REDIRECT_VERS} && true;
fi
