// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file core_types.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__EPROSIMA_FASTDDS_RTPS_CORE_CORE_TYPES_HPP
#define FAST_DDS_GENERATED__EPROSIMA_FASTDDS_RTPS_CORE_CORE_TYPES_HPP

#include <array>
#include <cstdint>
#include <functional>
#include <string>
#include <utility>
#include <vector>

#include <fastcdr/cdr/fixed_size_string.hpp>
#include <fastcdr/exceptions/BadParamException.h>


#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(CORE_TYPES_SOURCE)
#define CORE_TYPES_DllAPI __declspec( dllexport )
#else
#define CORE_TYPES_DllAPI __declspec( dllimport )
#endif // CORE_TYPES_SOURCE
#else
#define CORE_TYPES_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define CORE_TYPES_DllAPI
#endif // _WIN32

namespace eprosima {

namespace fastdds {

namespace rtps {

namespace core {

namespace detail {

/*!
 * @brief This class represents the structure EntityId_t defined by the user in the IDL file.
 * @ingroup core_types
 */
class EntityId_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport EntityId_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~EntityId_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object EntityId_t that will be copied.
     */
    eProsima_user_DllExport EntityId_t(
            const EntityId_t& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object EntityId_t that will be copied.
     */
    eProsima_user_DllExport EntityId_t(
            EntityId_t&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object EntityId_t that will be copied.
     */
    eProsima_user_DllExport EntityId_t& operator =(
            const EntityId_t& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object EntityId_t that will be copied.
     */
    eProsima_user_DllExport EntityId_t& operator =(
            EntityId_t&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x EntityId_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const EntityId_t& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x EntityId_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const EntityId_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const std::array<uint8_t, 4>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            std::array<uint8_t, 4>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const std::array<uint8_t, 4>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport std::array<uint8_t, 4>& value()
    {
        return m_value;
    }



private:

    std::array<uint8_t, 4> m_value{0};

};
/*!
 * @brief This class represents the structure ProtocolVersion_t defined by the user in the IDL file.
 * @ingroup core_types
 */
class ProtocolVersion_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ProtocolVersion_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ProtocolVersion_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ProtocolVersion_t that will be copied.
     */
    eProsima_user_DllExport ProtocolVersion_t(
            const ProtocolVersion_t& x)
    {
                    m_major = x.m_major;

                    m_minor = x.m_minor;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ProtocolVersion_t that will be copied.
     */
    eProsima_user_DllExport ProtocolVersion_t(
            ProtocolVersion_t&& x) noexcept
    {
        m_major = x.m_major;
        m_minor = x.m_minor;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ProtocolVersion_t that will be copied.
     */
    eProsima_user_DllExport ProtocolVersion_t& operator =(
            const ProtocolVersion_t& x)
    {

                    m_major = x.m_major;

                    m_minor = x.m_minor;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ProtocolVersion_t that will be copied.
     */
    eProsima_user_DllExport ProtocolVersion_t& operator =(
            ProtocolVersion_t&& x) noexcept
    {

        m_major = x.m_major;
        m_minor = x.m_minor;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ProtocolVersion_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ProtocolVersion_t& x) const
    {
        return (m_major == x.m_major &&
           m_minor == x.m_minor);
    }

    /*!
     * @brief Comparison operator.
     * @param x ProtocolVersion_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ProtocolVersion_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member major
     * @param _major New value for member major
     */
    eProsima_user_DllExport void major(
            uint8_t _major)
    {
        m_major = _major;
    }

    /*!
     * @brief This function returns the value of member major
     * @return Value of member major
     */
    eProsima_user_DllExport uint8_t major() const
    {
        return m_major;
    }

    /*!
     * @brief This function returns a reference to member major
     * @return Reference to member major
     */
    eProsima_user_DllExport uint8_t& major()
    {
        return m_major;
    }


    /*!
     * @brief This function sets a value in member minor
     * @param _minor New value for member minor
     */
    eProsima_user_DllExport void minor(
            uint8_t _minor)
    {
        m_minor = _minor;
    }

    /*!
     * @brief This function returns the value of member minor
     * @return Value of member minor
     */
    eProsima_user_DllExport uint8_t minor() const
    {
        return m_minor;
    }

    /*!
     * @brief This function returns a reference to member minor
     * @return Reference to member minor
     */
    eProsima_user_DllExport uint8_t& minor()
    {
        return m_minor;
    }



private:

    uint8_t m_major{0};
    uint8_t m_minor{0};

};
/*!
 * @brief This class represents the structure VendorId_t defined by the user in the IDL file.
 * @ingroup core_types
 */
class VendorId_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport VendorId_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~VendorId_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object VendorId_t that will be copied.
     */
    eProsima_user_DllExport VendorId_t(
            const VendorId_t& x)
    {
                    m_vendorId = x.m_vendorId;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object VendorId_t that will be copied.
     */
    eProsima_user_DllExport VendorId_t(
            VendorId_t&& x) noexcept
    {
        m_vendorId = std::move(x.m_vendorId);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object VendorId_t that will be copied.
     */
    eProsima_user_DllExport VendorId_t& operator =(
            const VendorId_t& x)
    {

                    m_vendorId = x.m_vendorId;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object VendorId_t that will be copied.
     */
    eProsima_user_DllExport VendorId_t& operator =(
            VendorId_t&& x) noexcept
    {

        m_vendorId = std::move(x.m_vendorId);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x VendorId_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const VendorId_t& x) const
    {
        return (m_vendorId == x.m_vendorId);
    }

    /*!
     * @brief Comparison operator.
     * @param x VendorId_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const VendorId_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member vendorId
     * @param _vendorId New value to be copied in member vendorId
     */
    eProsima_user_DllExport void vendorId(
            const std::array<uint8_t, 2>& _vendorId)
    {
        m_vendorId = _vendorId;
    }

    /*!
     * @brief This function moves the value in member vendorId
     * @param _vendorId New value to be moved in member vendorId
     */
    eProsima_user_DllExport void vendorId(
            std::array<uint8_t, 2>&& _vendorId)
    {
        m_vendorId = std::move(_vendorId);
    }

    /*!
     * @brief This function returns a constant reference to member vendorId
     * @return Constant reference to member vendorId
     */
    eProsima_user_DllExport const std::array<uint8_t, 2>& vendorId() const
    {
        return m_vendorId;
    }

    /*!
     * @brief This function returns a reference to member vendorId
     * @return Reference to member vendorId
     */
    eProsima_user_DllExport std::array<uint8_t, 2>& vendorId()
    {
        return m_vendorId;
    }



private:

    std::array<uint8_t, 2> m_vendorId{0};

};
/*!
 * @brief This class represents the structure GuidPrefix_t defined by the user in the IDL file.
 * @ingroup core_types
 */
class GuidPrefix_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport GuidPrefix_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~GuidPrefix_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object GuidPrefix_t that will be copied.
     */
    eProsima_user_DllExport GuidPrefix_t(
            const GuidPrefix_t& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object GuidPrefix_t that will be copied.
     */
    eProsima_user_DllExport GuidPrefix_t(
            GuidPrefix_t&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object GuidPrefix_t that will be copied.
     */
    eProsima_user_DllExport GuidPrefix_t& operator =(
            const GuidPrefix_t& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object GuidPrefix_t that will be copied.
     */
    eProsima_user_DllExport GuidPrefix_t& operator =(
            GuidPrefix_t&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x GuidPrefix_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const GuidPrefix_t& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x GuidPrefix_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const GuidPrefix_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const std::array<uint8_t, 12>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            std::array<uint8_t, 12>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const std::array<uint8_t, 12>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport std::array<uint8_t, 12>& value()
    {
        return m_value;
    }



private:

    std::array<uint8_t, 12> m_value{0};

};
/*!
 * @brief This class represents the structure GUID_t defined by the user in the IDL file.
 * @ingroup core_types
 */
class GUID_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport GUID_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~GUID_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object GUID_t that will be copied.
     */
    eProsima_user_DllExport GUID_t(
            const GUID_t& x)
    {
                    m_guidPrefix = x.m_guidPrefix;

                    m_entityId = x.m_entityId;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object GUID_t that will be copied.
     */
    eProsima_user_DllExport GUID_t(
            GUID_t&& x) noexcept
    {
        m_guidPrefix = std::move(x.m_guidPrefix);
        m_entityId = std::move(x.m_entityId);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object GUID_t that will be copied.
     */
    eProsima_user_DllExport GUID_t& operator =(
            const GUID_t& x)
    {

                    m_guidPrefix = x.m_guidPrefix;

                    m_entityId = x.m_entityId;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object GUID_t that will be copied.
     */
    eProsima_user_DllExport GUID_t& operator =(
            GUID_t&& x) noexcept
    {

        m_guidPrefix = std::move(x.m_guidPrefix);
        m_entityId = std::move(x.m_entityId);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x GUID_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const GUID_t& x) const
    {
        return (m_guidPrefix == x.m_guidPrefix &&
           m_entityId == x.m_entityId);
    }

    /*!
     * @brief Comparison operator.
     * @param x GUID_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const GUID_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member guidPrefix
     * @param _guidPrefix New value to be copied in member guidPrefix
     */
    eProsima_user_DllExport void guidPrefix(
            const GuidPrefix_t& _guidPrefix)
    {
        m_guidPrefix = _guidPrefix;
    }

    /*!
     * @brief This function moves the value in member guidPrefix
     * @param _guidPrefix New value to be moved in member guidPrefix
     */
    eProsima_user_DllExport void guidPrefix(
            GuidPrefix_t&& _guidPrefix)
    {
        m_guidPrefix = std::move(_guidPrefix);
    }

    /*!
     * @brief This function returns a constant reference to member guidPrefix
     * @return Constant reference to member guidPrefix
     */
    eProsima_user_DllExport const GuidPrefix_t& guidPrefix() const
    {
        return m_guidPrefix;
    }

    /*!
     * @brief This function returns a reference to member guidPrefix
     * @return Reference to member guidPrefix
     */
    eProsima_user_DllExport GuidPrefix_t& guidPrefix()
    {
        return m_guidPrefix;
    }


    /*!
     * @brief This function copies the value in member entityId
     * @param _entityId New value to be copied in member entityId
     */
    eProsima_user_DllExport void entityId(
            const EntityId_t& _entityId)
    {
        m_entityId = _entityId;
    }

    /*!
     * @brief This function moves the value in member entityId
     * @param _entityId New value to be moved in member entityId
     */
    eProsima_user_DllExport void entityId(
            EntityId_t&& _entityId)
    {
        m_entityId = std::move(_entityId);
    }

    /*!
     * @brief This function returns a constant reference to member entityId
     * @return Constant reference to member entityId
     */
    eProsima_user_DllExport const EntityId_t& entityId() const
    {
        return m_entityId;
    }

    /*!
     * @brief This function returns a reference to member entityId
     * @return Reference to member entityId
     */
    eProsima_user_DllExport EntityId_t& entityId()
    {
        return m_entityId;
    }



private:

    GuidPrefix_t m_guidPrefix;
    EntityId_t m_entityId;

};
/*!
 * @brief This class represents the structure SequenceNumber_t defined by the user in the IDL file.
 * @ingroup core_types
 */
class SequenceNumber_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceNumber_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceNumber_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceNumber_t that will be copied.
     */
    eProsima_user_DllExport SequenceNumber_t(
            const SequenceNumber_t& x)
    {
                    m_high = x.m_high;

                    m_low = x.m_low;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceNumber_t that will be copied.
     */
    eProsima_user_DllExport SequenceNumber_t(
            SequenceNumber_t&& x) noexcept
    {
        m_high = x.m_high;
        m_low = x.m_low;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceNumber_t that will be copied.
     */
    eProsima_user_DllExport SequenceNumber_t& operator =(
            const SequenceNumber_t& x)
    {

                    m_high = x.m_high;

                    m_low = x.m_low;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceNumber_t that will be copied.
     */
    eProsima_user_DllExport SequenceNumber_t& operator =(
            SequenceNumber_t&& x) noexcept
    {

        m_high = x.m_high;
        m_low = x.m_low;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceNumber_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceNumber_t& x) const
    {
        return (m_high == x.m_high &&
           m_low == x.m_low);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceNumber_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceNumber_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member high
     * @param _high New value for member high
     */
    eProsima_user_DllExport void high(
            int32_t _high)
    {
        m_high = _high;
    }

    /*!
     * @brief This function returns the value of member high
     * @return Value of member high
     */
    eProsima_user_DllExport int32_t high() const
    {
        return m_high;
    }

    /*!
     * @brief This function returns a reference to member high
     * @return Reference to member high
     */
    eProsima_user_DllExport int32_t& high()
    {
        return m_high;
    }


    /*!
     * @brief This function sets a value in member low
     * @param _low New value for member low
     */
    eProsima_user_DllExport void low(
            uint32_t _low)
    {
        m_low = _low;
    }

    /*!
     * @brief This function returns the value of member low
     * @return Value of member low
     */
    eProsima_user_DllExport uint32_t low() const
    {
        return m_low;
    }

    /*!
     * @brief This function returns a reference to member low
     * @return Reference to member low
     */
    eProsima_user_DllExport uint32_t& low()
    {
        return m_low;
    }



private:

    int32_t m_high{0};
    uint32_t m_low{0};

};
/*!
 * @brief This class represents the structure Count_t defined by the user in the IDL file.
 * @ingroup core_types
 */
class Count_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Count_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Count_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Count_t that will be copied.
     */
    eProsima_user_DllExport Count_t(
            const Count_t& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Count_t that will be copied.
     */
    eProsima_user_DllExport Count_t(
            Count_t&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Count_t that will be copied.
     */
    eProsima_user_DllExport Count_t& operator =(
            const Count_t& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Count_t that will be copied.
     */
    eProsima_user_DllExport Count_t& operator =(
            Count_t&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Count_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Count_t& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x Count_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Count_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            int32_t _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport int32_t value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport int32_t& value()
    {
        return m_value;
    }



private:

    int32_t m_value{0};

};
/*!
 * @brief This class represents the structure Time_t defined by the user in the IDL file.
 * @ingroup core_types
 */
class Time_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Time_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Time_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Time_t that will be copied.
     */
    eProsima_user_DllExport Time_t(
            const Time_t& x)
    {
                    m_seconds = x.m_seconds;

                    m_fraction = x.m_fraction;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Time_t that will be copied.
     */
    eProsima_user_DllExport Time_t(
            Time_t&& x) noexcept
    {
        m_seconds = x.m_seconds;
        m_fraction = x.m_fraction;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Time_t that will be copied.
     */
    eProsima_user_DllExport Time_t& operator =(
            const Time_t& x)
    {

                    m_seconds = x.m_seconds;

                    m_fraction = x.m_fraction;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Time_t that will be copied.
     */
    eProsima_user_DllExport Time_t& operator =(
            Time_t&& x) noexcept
    {

        m_seconds = x.m_seconds;
        m_fraction = x.m_fraction;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Time_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Time_t& x) const
    {
        return (m_seconds == x.m_seconds &&
           m_fraction == x.m_fraction);
    }

    /*!
     * @brief Comparison operator.
     * @param x Time_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Time_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member seconds
     * @param _seconds New value for member seconds
     */
    eProsima_user_DllExport void seconds(
            uint32_t _seconds)
    {
        m_seconds = _seconds;
    }

    /*!
     * @brief This function returns the value of member seconds
     * @return Value of member seconds
     */
    eProsima_user_DllExport uint32_t seconds() const
    {
        return m_seconds;
    }

    /*!
     * @brief This function returns a reference to member seconds
     * @return Reference to member seconds
     */
    eProsima_user_DllExport uint32_t& seconds()
    {
        return m_seconds;
    }


    /*!
     * @brief This function sets a value in member fraction
     * @param _fraction New value for member fraction
     */
    eProsima_user_DllExport void fraction(
            uint32_t _fraction)
    {
        m_fraction = _fraction;
    }

    /*!
     * @brief This function returns the value of member fraction
     * @return Value of member fraction
     */
    eProsima_user_DllExport uint32_t fraction() const
    {
        return m_fraction;
    }

    /*!
     * @brief This function returns a reference to member fraction
     * @return Reference to member fraction
     */
    eProsima_user_DllExport uint32_t& fraction()
    {
        return m_fraction;
    }



private:

    uint32_t m_seconds{0};
    uint32_t m_fraction{0};

};
typedef Time_t Timestamp;

/*!
 * @brief This class represents the structure SequenceNumberSet defined by the user in the IDL file.
 * @ingroup core_types
 */
class SequenceNumberSet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceNumberSet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceNumberSet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceNumberSet that will be copied.
     */
    eProsima_user_DllExport SequenceNumberSet(
            const SequenceNumberSet& x)
    {
                    m_bitmapBase = x.m_bitmapBase;

                    m_numBits = x.m_numBits;

                    m_bitmap = x.m_bitmap;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceNumberSet that will be copied.
     */
    eProsima_user_DllExport SequenceNumberSet(
            SequenceNumberSet&& x) noexcept
    {
        m_bitmapBase = std::move(x.m_bitmapBase);
        m_numBits = x.m_numBits;
        m_bitmap = std::move(x.m_bitmap);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceNumberSet that will be copied.
     */
    eProsima_user_DllExport SequenceNumberSet& operator =(
            const SequenceNumberSet& x)
    {

                    m_bitmapBase = x.m_bitmapBase;

                    m_numBits = x.m_numBits;

                    m_bitmap = x.m_bitmap;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceNumberSet that will be copied.
     */
    eProsima_user_DllExport SequenceNumberSet& operator =(
            SequenceNumberSet&& x) noexcept
    {

        m_bitmapBase = std::move(x.m_bitmapBase);
        m_numBits = x.m_numBits;
        m_bitmap = std::move(x.m_bitmap);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceNumberSet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceNumberSet& x) const
    {
        return (m_bitmapBase == x.m_bitmapBase &&
           m_numBits == x.m_numBits &&
           m_bitmap == x.m_bitmap);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceNumberSet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceNumberSet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member bitmapBase
     * @param _bitmapBase New value to be copied in member bitmapBase
     */
    eProsima_user_DllExport void bitmapBase(
            const SequenceNumber_t& _bitmapBase)
    {
        m_bitmapBase = _bitmapBase;
    }

    /*!
     * @brief This function moves the value in member bitmapBase
     * @param _bitmapBase New value to be moved in member bitmapBase
     */
    eProsima_user_DllExport void bitmapBase(
            SequenceNumber_t&& _bitmapBase)
    {
        m_bitmapBase = std::move(_bitmapBase);
    }

    /*!
     * @brief This function returns a constant reference to member bitmapBase
     * @return Constant reference to member bitmapBase
     */
    eProsima_user_DllExport const SequenceNumber_t& bitmapBase() const
    {
        return m_bitmapBase;
    }

    /*!
     * @brief This function returns a reference to member bitmapBase
     * @return Reference to member bitmapBase
     */
    eProsima_user_DllExport SequenceNumber_t& bitmapBase()
    {
        return m_bitmapBase;
    }


    /*!
     * @brief This function sets a value in member numBits
     * @param _numBits New value for member numBits
     */
    eProsima_user_DllExport void numBits(
            uint32_t _numBits)
    {
        m_numBits = _numBits;
    }

    /*!
     * @brief This function returns the value of member numBits
     * @return Value of member numBits
     */
    eProsima_user_DllExport uint32_t numBits() const
    {
        return m_numBits;
    }

    /*!
     * @brief This function returns a reference to member numBits
     * @return Reference to member numBits
     */
    eProsima_user_DllExport uint32_t& numBits()
    {
        return m_numBits;
    }


    /*!
     * @brief This function copies the value in member bitmap
     * @param _bitmap New value to be copied in member bitmap
     */
    eProsima_user_DllExport void bitmap(
            const std::array<uint8_t, 8>& _bitmap)
    {
        m_bitmap = _bitmap;
    }

    /*!
     * @brief This function moves the value in member bitmap
     * @param _bitmap New value to be moved in member bitmap
     */
    eProsima_user_DllExport void bitmap(
            std::array<uint8_t, 8>&& _bitmap)
    {
        m_bitmap = std::move(_bitmap);
    }

    /*!
     * @brief This function returns a constant reference to member bitmap
     * @return Constant reference to member bitmap
     */
    eProsima_user_DllExport const std::array<uint8_t, 8>& bitmap() const
    {
        return m_bitmap;
    }

    /*!
     * @brief This function returns a reference to member bitmap
     * @return Reference to member bitmap
     */
    eProsima_user_DllExport std::array<uint8_t, 8>& bitmap()
    {
        return m_bitmap;
    }



private:

    SequenceNumber_t m_bitmapBase;
    uint32_t m_numBits{0};
    std::array<uint8_t, 8> m_bitmap{0};

};
/*!
 * @brief This class represents the structure Locator_t defined by the user in the IDL file.
 * @ingroup core_types
 */
class Locator_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Locator_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Locator_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Locator_t that will be copied.
     */
    eProsima_user_DllExport Locator_t(
            const Locator_t& x)
    {
                    m_kind = x.m_kind;

                    m_port = x.m_port;

                    m_address = x.m_address;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Locator_t that will be copied.
     */
    eProsima_user_DllExport Locator_t(
            Locator_t&& x) noexcept
    {
        m_kind = x.m_kind;
        m_port = x.m_port;
        m_address = std::move(x.m_address);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Locator_t that will be copied.
     */
    eProsima_user_DllExport Locator_t& operator =(
            const Locator_t& x)
    {

                    m_kind = x.m_kind;

                    m_port = x.m_port;

                    m_address = x.m_address;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Locator_t that will be copied.
     */
    eProsima_user_DllExport Locator_t& operator =(
            Locator_t&& x) noexcept
    {

        m_kind = x.m_kind;
        m_port = x.m_port;
        m_address = std::move(x.m_address);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Locator_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Locator_t& x) const
    {
        return (m_kind == x.m_kind &&
           m_port == x.m_port &&
           m_address == x.m_address);
    }

    /*!
     * @brief Comparison operator.
     * @param x Locator_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Locator_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member kind
     * @param _kind New value for member kind
     */
    eProsima_user_DllExport void kind(
            int32_t _kind)
    {
        m_kind = _kind;
    }

    /*!
     * @brief This function returns the value of member kind
     * @return Value of member kind
     */
    eProsima_user_DllExport int32_t kind() const
    {
        return m_kind;
    }

    /*!
     * @brief This function returns a reference to member kind
     * @return Reference to member kind
     */
    eProsima_user_DllExport int32_t& kind()
    {
        return m_kind;
    }


    /*!
     * @brief This function sets a value in member port
     * @param _port New value for member port
     */
    eProsima_user_DllExport void port(
            uint32_t _port)
    {
        m_port = _port;
    }

    /*!
     * @brief This function returns the value of member port
     * @return Value of member port
     */
    eProsima_user_DllExport uint32_t port() const
    {
        return m_port;
    }

    /*!
     * @brief This function returns a reference to member port
     * @return Reference to member port
     */
    eProsima_user_DllExport uint32_t& port()
    {
        return m_port;
    }


    /*!
     * @brief This function copies the value in member address
     * @param _address New value to be copied in member address
     */
    eProsima_user_DllExport void address(
            const std::array<uint8_t, 16>& _address)
    {
        m_address = _address;
    }

    /*!
     * @brief This function moves the value in member address
     * @param _address New value to be moved in member address
     */
    eProsima_user_DllExport void address(
            std::array<uint8_t, 16>&& _address)
    {
        m_address = std::move(_address);
    }

    /*!
     * @brief This function returns a constant reference to member address
     * @return Constant reference to member address
     */
    eProsima_user_DllExport const std::array<uint8_t, 16>& address() const
    {
        return m_address;
    }

    /*!
     * @brief This function returns a reference to member address
     * @return Reference to member address
     */
    eProsima_user_DllExport std::array<uint8_t, 16>& address()
    {
        return m_address;
    }



private:

    int32_t m_kind{0};
    uint32_t m_port{0};
    std::array<uint8_t, 16> m_address{0};

};
/*!
 * @brief This class represents the structure Duration_t defined by the user in the IDL file.
 * @ingroup core_types
 */
class Duration_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Duration_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Duration_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Duration_t that will be copied.
     */
    eProsima_user_DllExport Duration_t(
            const Duration_t& x)
    {
                    m_seconds = x.m_seconds;

                    m_fraction = x.m_fraction;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Duration_t that will be copied.
     */
    eProsima_user_DllExport Duration_t(
            Duration_t&& x) noexcept
    {
        m_seconds = x.m_seconds;
        m_fraction = x.m_fraction;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Duration_t that will be copied.
     */
    eProsima_user_DllExport Duration_t& operator =(
            const Duration_t& x)
    {

                    m_seconds = x.m_seconds;

                    m_fraction = x.m_fraction;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Duration_t that will be copied.
     */
    eProsima_user_DllExport Duration_t& operator =(
            Duration_t&& x) noexcept
    {

        m_seconds = x.m_seconds;
        m_fraction = x.m_fraction;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Duration_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Duration_t& x) const
    {
        return (m_seconds == x.m_seconds &&
           m_fraction == x.m_fraction);
    }

    /*!
     * @brief Comparison operator.
     * @param x Duration_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Duration_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member seconds
     * @param _seconds New value for member seconds
     */
    eProsima_user_DllExport void seconds(
            int32_t _seconds)
    {
        m_seconds = _seconds;
    }

    /*!
     * @brief This function returns the value of member seconds
     * @return Value of member seconds
     */
    eProsima_user_DllExport int32_t seconds() const
    {
        return m_seconds;
    }

    /*!
     * @brief This function returns a reference to member seconds
     * @return Reference to member seconds
     */
    eProsima_user_DllExport int32_t& seconds()
    {
        return m_seconds;
    }


    /*!
     * @brief This function sets a value in member fraction
     * @param _fraction New value for member fraction
     */
    eProsima_user_DllExport void fraction(
            uint32_t _fraction)
    {
        m_fraction = _fraction;
    }

    /*!
     * @brief This function returns the value of member fraction
     * @return Value of member fraction
     */
    eProsima_user_DllExport uint32_t fraction() const
    {
        return m_fraction;
    }

    /*!
     * @brief This function returns a reference to member fraction
     * @return Reference to member fraction
     */
    eProsima_user_DllExport uint32_t& fraction()
    {
        return m_fraction;
    }



private:

    int32_t m_seconds{0};
    uint32_t m_fraction{0};

};
typedef uint32_t DomainId_t;

typedef uint32_t BuiltinEndpointQos_t;

/*!
 * @brief This class represents the structure StatusInfo_t defined by the user in the IDL file.
 * @ingroup core_types
 */
class StatusInfo_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StatusInfo_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StatusInfo_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StatusInfo_t that will be copied.
     */
    eProsima_user_DllExport StatusInfo_t(
            const StatusInfo_t& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StatusInfo_t that will be copied.
     */
    eProsima_user_DllExport StatusInfo_t(
            StatusInfo_t&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StatusInfo_t that will be copied.
     */
    eProsima_user_DllExport StatusInfo_t& operator =(
            const StatusInfo_t& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StatusInfo_t that will be copied.
     */
    eProsima_user_DllExport StatusInfo_t& operator =(
            StatusInfo_t&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StatusInfo_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StatusInfo_t& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x StatusInfo_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StatusInfo_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const std::array<uint8_t, 4>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            std::array<uint8_t, 4>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const std::array<uint8_t, 4>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport std::array<uint8_t, 4>& value()
    {
        return m_value;
    }



private:

    std::array<uint8_t, 4> m_value{0};

};
/*!
 * @brief This class represents the structure KeyHash_t defined by the user in the IDL file.
 * @ingroup core_types
 */
class KeyHash_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyHash_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyHash_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyHash_t that will be copied.
     */
    eProsima_user_DllExport KeyHash_t(
            const KeyHash_t& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyHash_t that will be copied.
     */
    eProsima_user_DllExport KeyHash_t(
            KeyHash_t&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyHash_t that will be copied.
     */
    eProsima_user_DllExport KeyHash_t& operator =(
            const KeyHash_t& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyHash_t that will be copied.
     */
    eProsima_user_DllExport KeyHash_t& operator =(
            KeyHash_t&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyHash_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyHash_t& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyHash_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyHash_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const std::array<uint8_t, 16>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            std::array<uint8_t, 16>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const std::array<uint8_t, 16>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport std::array<uint8_t, 16>& value()
    {
        return m_value;
    }



private:

    std::array<uint8_t, 16> m_value{0};

};
/*!
 * @brief This class represents the structure EntityName_t defined by the user in the IDL file.
 * @ingroup core_types
 */
class EntityName_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport EntityName_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~EntityName_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object EntityName_t that will be copied.
     */
    eProsima_user_DllExport EntityName_t(
            const EntityName_t& x)
    {
                    m_name = x.m_name;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object EntityName_t that will be copied.
     */
    eProsima_user_DllExport EntityName_t(
            EntityName_t&& x) noexcept
    {
        m_name = std::move(x.m_name);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object EntityName_t that will be copied.
     */
    eProsima_user_DllExport EntityName_t& operator =(
            const EntityName_t& x)
    {

                    m_name = x.m_name;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object EntityName_t that will be copied.
     */
    eProsima_user_DllExport EntityName_t& operator =(
            EntityName_t&& x) noexcept
    {

        m_name = std::move(x.m_name);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x EntityName_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const EntityName_t& x) const
    {
        return (m_name == x.m_name);
    }

    /*!
     * @brief Comparison operator.
     * @param x EntityName_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const EntityName_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member name
     * @param _name New value to be copied in member name
     */
    eProsima_user_DllExport void name(
            const std::string& _name)
    {
        m_name = _name;
    }

    /*!
     * @brief This function moves the value in member name
     * @param _name New value to be moved in member name
     */
    eProsima_user_DllExport void name(
            std::string&& _name)
    {
        m_name = std::move(_name);
    }

    /*!
     * @brief This function returns a constant reference to member name
     * @return Constant reference to member name
     */
    eProsima_user_DllExport const std::string& name() const
    {
        return m_name;
    }

    /*!
     * @brief This function returns a reference to member name
     * @return Reference to member name
     */
    eProsima_user_DllExport std::string& name()
    {
        return m_name;
    }



private:

    std::string m_name;

};

} // namespace detail
/*!
 * @brief This class represents the structure Header defined by the user in the IDL file.
 * @ingroup core_types
 */
class Header
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Header()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Header()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Header that will be copied.
     */
    eProsima_user_DllExport Header(
            const Header& x)
    {
                    m_prefix = x.m_prefix;

                    m_version = x.m_version;

                    m_vendorId = x.m_vendorId;

                    m_guidPrefix = x.m_guidPrefix;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Header that will be copied.
     */
    eProsima_user_DllExport Header(
            Header&& x) noexcept
    {
        m_prefix = std::move(x.m_prefix);
        m_version = std::move(x.m_version);
        m_vendorId = std::move(x.m_vendorId);
        m_guidPrefix = std::move(x.m_guidPrefix);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Header that will be copied.
     */
    eProsima_user_DllExport Header& operator =(
            const Header& x)
    {

                    m_prefix = x.m_prefix;

                    m_version = x.m_version;

                    m_vendorId = x.m_vendorId;

                    m_guidPrefix = x.m_guidPrefix;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Header that will be copied.
     */
    eProsima_user_DllExport Header& operator =(
            Header&& x) noexcept
    {

        m_prefix = std::move(x.m_prefix);
        m_version = std::move(x.m_version);
        m_vendorId = std::move(x.m_vendorId);
        m_guidPrefix = std::move(x.m_guidPrefix);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Header object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Header& x) const
    {
        return (m_prefix == x.m_prefix &&
           m_version == x.m_version &&
           m_vendorId == x.m_vendorId &&
           m_guidPrefix == x.m_guidPrefix);
    }

    /*!
     * @brief Comparison operator.
     * @param x Header object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Header& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member prefix
     * @param _prefix New value to be copied in member prefix
     */
    eProsima_user_DllExport void prefix(
            const std::array<uint8_t, 4>& _prefix)
    {
        m_prefix = _prefix;
    }

    /*!
     * @brief This function moves the value in member prefix
     * @param _prefix New value to be moved in member prefix
     */
    eProsima_user_DllExport void prefix(
            std::array<uint8_t, 4>&& _prefix)
    {
        m_prefix = std::move(_prefix);
    }

    /*!
     * @brief This function returns a constant reference to member prefix
     * @return Constant reference to member prefix
     */
    eProsima_user_DllExport const std::array<uint8_t, 4>& prefix() const
    {
        return m_prefix;
    }

    /*!
     * @brief This function returns a reference to member prefix
     * @return Reference to member prefix
     */
    eProsima_user_DllExport std::array<uint8_t, 4>& prefix()
    {
        return m_prefix;
    }


    /*!
     * @brief This function copies the value in member version
     * @param _version New value to be copied in member version
     */
    eProsima_user_DllExport void version(
            const detail::ProtocolVersion_t& _version)
    {
        m_version = _version;
    }

    /*!
     * @brief This function moves the value in member version
     * @param _version New value to be moved in member version
     */
    eProsima_user_DllExport void version(
            detail::ProtocolVersion_t&& _version)
    {
        m_version = std::move(_version);
    }

    /*!
     * @brief This function returns a constant reference to member version
     * @return Constant reference to member version
     */
    eProsima_user_DllExport const detail::ProtocolVersion_t& version() const
    {
        return m_version;
    }

    /*!
     * @brief This function returns a reference to member version
     * @return Reference to member version
     */
    eProsima_user_DllExport detail::ProtocolVersion_t& version()
    {
        return m_version;
    }


    /*!
     * @brief This function copies the value in member vendorId
     * @param _vendorId New value to be copied in member vendorId
     */
    eProsima_user_DllExport void vendorId(
            const detail::VendorId_t& _vendorId)
    {
        m_vendorId = _vendorId;
    }

    /*!
     * @brief This function moves the value in member vendorId
     * @param _vendorId New value to be moved in member vendorId
     */
    eProsima_user_DllExport void vendorId(
            detail::VendorId_t&& _vendorId)
    {
        m_vendorId = std::move(_vendorId);
    }

    /*!
     * @brief This function returns a constant reference to member vendorId
     * @return Constant reference to member vendorId
     */
    eProsima_user_DllExport const detail::VendorId_t& vendorId() const
    {
        return m_vendorId;
    }

    /*!
     * @brief This function returns a reference to member vendorId
     * @return Reference to member vendorId
     */
    eProsima_user_DllExport detail::VendorId_t& vendorId()
    {
        return m_vendorId;
    }


    /*!
     * @brief This function copies the value in member guidPrefix
     * @param _guidPrefix New value to be copied in member guidPrefix
     */
    eProsima_user_DllExport void guidPrefix(
            const detail::GuidPrefix_t& _guidPrefix)
    {
        m_guidPrefix = _guidPrefix;
    }

    /*!
     * @brief This function moves the value in member guidPrefix
     * @param _guidPrefix New value to be moved in member guidPrefix
     */
    eProsima_user_DllExport void guidPrefix(
            detail::GuidPrefix_t&& _guidPrefix)
    {
        m_guidPrefix = std::move(_guidPrefix);
    }

    /*!
     * @brief This function returns a constant reference to member guidPrefix
     * @return Constant reference to member guidPrefix
     */
    eProsima_user_DllExport const detail::GuidPrefix_t& guidPrefix() const
    {
        return m_guidPrefix;
    }

    /*!
     * @brief This function returns a reference to member guidPrefix
     * @return Reference to member guidPrefix
     */
    eProsima_user_DllExport detail::GuidPrefix_t& guidPrefix()
    {
        return m_guidPrefix;
    }



private:

    std::array<uint8_t, 4> m_prefix{0};
    detail::ProtocolVersion_t m_version;
    detail::VendorId_t m_vendorId;
    detail::GuidPrefix_t m_guidPrefix;

};
/*!
 * @brief This class represents the structure SubmessageHeader defined by the user in the IDL file.
 * @ingroup core_types
 */
class SubmessageHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SubmessageHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SubmessageHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SubmessageHeader that will be copied.
     */
    eProsima_user_DllExport SubmessageHeader(
            const SubmessageHeader& x)
    {
                    m_submessageId = x.m_submessageId;

                    m_flags = x.m_flags;

                    m_submessageLength = x.m_submessageLength;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SubmessageHeader that will be copied.
     */
    eProsima_user_DllExport SubmessageHeader(
            SubmessageHeader&& x) noexcept
    {
        m_submessageId = x.m_submessageId;
        m_flags = x.m_flags;
        m_submessageLength = x.m_submessageLength;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SubmessageHeader that will be copied.
     */
    eProsima_user_DllExport SubmessageHeader& operator =(
            const SubmessageHeader& x)
    {

                    m_submessageId = x.m_submessageId;

                    m_flags = x.m_flags;

                    m_submessageLength = x.m_submessageLength;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SubmessageHeader that will be copied.
     */
    eProsima_user_DllExport SubmessageHeader& operator =(
            SubmessageHeader&& x) noexcept
    {

        m_submessageId = x.m_submessageId;
        m_flags = x.m_flags;
        m_submessageLength = x.m_submessageLength;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SubmessageHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SubmessageHeader& x) const
    {
        return (m_submessageId == x.m_submessageId &&
           m_flags == x.m_flags &&
           m_submessageLength == x.m_submessageLength);
    }

    /*!
     * @brief Comparison operator.
     * @param x SubmessageHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SubmessageHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member submessageId
     * @param _submessageId New value for member submessageId
     */
    eProsima_user_DllExport void submessageId(
            uint8_t _submessageId)
    {
        m_submessageId = _submessageId;
    }

    /*!
     * @brief This function returns the value of member submessageId
     * @return Value of member submessageId
     */
    eProsima_user_DllExport uint8_t submessageId() const
    {
        return m_submessageId;
    }

    /*!
     * @brief This function returns a reference to member submessageId
     * @return Reference to member submessageId
     */
    eProsima_user_DllExport uint8_t& submessageId()
    {
        return m_submessageId;
    }


    /*!
     * @brief This function sets a value in member flags
     * @param _flags New value for member flags
     */
    eProsima_user_DllExport void flags(
            uint8_t _flags)
    {
        m_flags = _flags;
    }

    /*!
     * @brief This function returns the value of member flags
     * @return Value of member flags
     */
    eProsima_user_DllExport uint8_t flags() const
    {
        return m_flags;
    }

    /*!
     * @brief This function returns a reference to member flags
     * @return Reference to member flags
     */
    eProsima_user_DllExport uint8_t& flags()
    {
        return m_flags;
    }


    /*!
     * @brief This function sets a value in member submessageLength
     * @param _submessageLength New value for member submessageLength
     */
    eProsima_user_DllExport void submessageLength(
            uint16_t _submessageLength)
    {
        m_submessageLength = _submessageLength;
    }

    /*!
     * @brief This function returns the value of member submessageLength
     * @return Value of member submessageLength
     */
    eProsima_user_DllExport uint16_t submessageLength() const
    {
        return m_submessageLength;
    }

    /*!
     * @brief This function returns a reference to member submessageLength
     * @return Reference to member submessageLength
     */
    eProsima_user_DllExport uint16_t& submessageLength()
    {
        return m_submessageLength;
    }



private:

    uint8_t m_submessageId{0};
    uint8_t m_flags{0};
    uint16_t m_submessageLength{0};

};
namespace SubmessageKind {

const char RTPS_HE = 0x00;
const char PAD = 0x01;
const char ACKNACK = 0x06;
const char HEARTBEAT = 0x07;
const char GAP = 0x08;
const char INFO_TS = 0x09;
const char INFO_SRC = 0x0c;
const char INFO_REPLY_IP4 = 0x0d;
const char INFO_DST = 0x0e;
const char INFO_REPLY = 0x0f;
const char NACK_FRAG = 0x12;
const char HEARTBEAT_FRAG = 0x13;
const char DATA = 0x15;
const char DATA_FRAG = 0x16;

} // namespace SubmessageKind
/*!
 * @brief This class represents the structure AckNackSubmessage defined by the user in the IDL file.
 * @ingroup core_types
 */
class AckNackSubmessage
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AckNackSubmessage()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AckNackSubmessage()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AckNackSubmessage that will be copied.
     */
    eProsima_user_DllExport AckNackSubmessage(
            const AckNackSubmessage& x)
    {
                    m_submsgHeader = x.m_submsgHeader;

                    m_readerId = x.m_readerId;

                    m_writerId = x.m_writerId;

                    m_readerSNState = x.m_readerSNState;

                    m_count = x.m_count;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AckNackSubmessage that will be copied.
     */
    eProsima_user_DllExport AckNackSubmessage(
            AckNackSubmessage&& x) noexcept
    {
        m_submsgHeader = std::move(x.m_submsgHeader);
        m_readerId = std::move(x.m_readerId);
        m_writerId = std::move(x.m_writerId);
        m_readerSNState = std::move(x.m_readerSNState);
        m_count = std::move(x.m_count);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AckNackSubmessage that will be copied.
     */
    eProsima_user_DllExport AckNackSubmessage& operator =(
            const AckNackSubmessage& x)
    {

                    m_submsgHeader = x.m_submsgHeader;

                    m_readerId = x.m_readerId;

                    m_writerId = x.m_writerId;

                    m_readerSNState = x.m_readerSNState;

                    m_count = x.m_count;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AckNackSubmessage that will be copied.
     */
    eProsima_user_DllExport AckNackSubmessage& operator =(
            AckNackSubmessage&& x) noexcept
    {

        m_submsgHeader = std::move(x.m_submsgHeader);
        m_readerId = std::move(x.m_readerId);
        m_writerId = std::move(x.m_writerId);
        m_readerSNState = std::move(x.m_readerSNState);
        m_count = std::move(x.m_count);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AckNackSubmessage object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AckNackSubmessage& x) const
    {
        return (m_submsgHeader == x.m_submsgHeader &&
           m_readerId == x.m_readerId &&
           m_writerId == x.m_writerId &&
           m_readerSNState == x.m_readerSNState &&
           m_count == x.m_count);
    }

    /*!
     * @brief Comparison operator.
     * @param x AckNackSubmessage object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AckNackSubmessage& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member submsgHeader
     * @param _submsgHeader New value to be copied in member submsgHeader
     */
    eProsima_user_DllExport void submsgHeader(
            const SubmessageHeader& _submsgHeader)
    {
        m_submsgHeader = _submsgHeader;
    }

    /*!
     * @brief This function moves the value in member submsgHeader
     * @param _submsgHeader New value to be moved in member submsgHeader
     */
    eProsima_user_DllExport void submsgHeader(
            SubmessageHeader&& _submsgHeader)
    {
        m_submsgHeader = std::move(_submsgHeader);
    }

    /*!
     * @brief This function returns a constant reference to member submsgHeader
     * @return Constant reference to member submsgHeader
     */
    eProsima_user_DllExport const SubmessageHeader& submsgHeader() const
    {
        return m_submsgHeader;
    }

    /*!
     * @brief This function returns a reference to member submsgHeader
     * @return Reference to member submsgHeader
     */
    eProsima_user_DllExport SubmessageHeader& submsgHeader()
    {
        return m_submsgHeader;
    }


    /*!
     * @brief This function copies the value in member readerId
     * @param _readerId New value to be copied in member readerId
     */
    eProsima_user_DllExport void readerId(
            const detail::EntityId_t& _readerId)
    {
        m_readerId = _readerId;
    }

    /*!
     * @brief This function moves the value in member readerId
     * @param _readerId New value to be moved in member readerId
     */
    eProsima_user_DllExport void readerId(
            detail::EntityId_t&& _readerId)
    {
        m_readerId = std::move(_readerId);
    }

    /*!
     * @brief This function returns a constant reference to member readerId
     * @return Constant reference to member readerId
     */
    eProsima_user_DllExport const detail::EntityId_t& readerId() const
    {
        return m_readerId;
    }

    /*!
     * @brief This function returns a reference to member readerId
     * @return Reference to member readerId
     */
    eProsima_user_DllExport detail::EntityId_t& readerId()
    {
        return m_readerId;
    }


    /*!
     * @brief This function copies the value in member writerId
     * @param _writerId New value to be copied in member writerId
     */
    eProsima_user_DllExport void writerId(
            const detail::EntityId_t& _writerId)
    {
        m_writerId = _writerId;
    }

    /*!
     * @brief This function moves the value in member writerId
     * @param _writerId New value to be moved in member writerId
     */
    eProsima_user_DllExport void writerId(
            detail::EntityId_t&& _writerId)
    {
        m_writerId = std::move(_writerId);
    }

    /*!
     * @brief This function returns a constant reference to member writerId
     * @return Constant reference to member writerId
     */
    eProsima_user_DllExport const detail::EntityId_t& writerId() const
    {
        return m_writerId;
    }

    /*!
     * @brief This function returns a reference to member writerId
     * @return Reference to member writerId
     */
    eProsima_user_DllExport detail::EntityId_t& writerId()
    {
        return m_writerId;
    }


    /*!
     * @brief This function copies the value in member readerSNState
     * @param _readerSNState New value to be copied in member readerSNState
     */
    eProsima_user_DllExport void readerSNState(
            const detail::SequenceNumberSet& _readerSNState)
    {
        m_readerSNState = _readerSNState;
    }

    /*!
     * @brief This function moves the value in member readerSNState
     * @param _readerSNState New value to be moved in member readerSNState
     */
    eProsima_user_DllExport void readerSNState(
            detail::SequenceNumberSet&& _readerSNState)
    {
        m_readerSNState = std::move(_readerSNState);
    }

    /*!
     * @brief This function returns a constant reference to member readerSNState
     * @return Constant reference to member readerSNState
     */
    eProsima_user_DllExport const detail::SequenceNumberSet& readerSNState() const
    {
        return m_readerSNState;
    }

    /*!
     * @brief This function returns a reference to member readerSNState
     * @return Reference to member readerSNState
     */
    eProsima_user_DllExport detail::SequenceNumberSet& readerSNState()
    {
        return m_readerSNState;
    }


    /*!
     * @brief This function copies the value in member count
     * @param _count New value to be copied in member count
     */
    eProsima_user_DllExport void count(
            const detail::Count_t& _count)
    {
        m_count = _count;
    }

    /*!
     * @brief This function moves the value in member count
     * @param _count New value to be moved in member count
     */
    eProsima_user_DllExport void count(
            detail::Count_t&& _count)
    {
        m_count = std::move(_count);
    }

    /*!
     * @brief This function returns a constant reference to member count
     * @return Constant reference to member count
     */
    eProsima_user_DllExport const detail::Count_t& count() const
    {
        return m_count;
    }

    /*!
     * @brief This function returns a reference to member count
     * @return Reference to member count
     */
    eProsima_user_DllExport detail::Count_t& count()
    {
        return m_count;
    }



private:

    SubmessageHeader m_submsgHeader;
    detail::EntityId_t m_readerId;
    detail::EntityId_t m_writerId;
    detail::SequenceNumberSet m_readerSNState;
    detail::Count_t m_count;

};
/*!
 * @brief This class represents the structure HeartBeatSubmessage defined by the user in the IDL file.
 * @ingroup core_types
 */
class HeartBeatSubmessage
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport HeartBeatSubmessage()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~HeartBeatSubmessage()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object HeartBeatSubmessage that will be copied.
     */
    eProsima_user_DllExport HeartBeatSubmessage(
            const HeartBeatSubmessage& x)
    {
                    m_submsgHeader = x.m_submsgHeader;

                    m_readerId = x.m_readerId;

                    m_writerId = x.m_writerId;

                    m_firstSN = x.m_firstSN;

                    m_lastSN = x.m_lastSN;

                    m_count = x.m_count;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object HeartBeatSubmessage that will be copied.
     */
    eProsima_user_DllExport HeartBeatSubmessage(
            HeartBeatSubmessage&& x) noexcept
    {
        m_submsgHeader = std::move(x.m_submsgHeader);
        m_readerId = std::move(x.m_readerId);
        m_writerId = std::move(x.m_writerId);
        m_firstSN = std::move(x.m_firstSN);
        m_lastSN = std::move(x.m_lastSN);
        m_count = std::move(x.m_count);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object HeartBeatSubmessage that will be copied.
     */
    eProsima_user_DllExport HeartBeatSubmessage& operator =(
            const HeartBeatSubmessage& x)
    {

                    m_submsgHeader = x.m_submsgHeader;

                    m_readerId = x.m_readerId;

                    m_writerId = x.m_writerId;

                    m_firstSN = x.m_firstSN;

                    m_lastSN = x.m_lastSN;

                    m_count = x.m_count;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object HeartBeatSubmessage that will be copied.
     */
    eProsima_user_DllExport HeartBeatSubmessage& operator =(
            HeartBeatSubmessage&& x) noexcept
    {

        m_submsgHeader = std::move(x.m_submsgHeader);
        m_readerId = std::move(x.m_readerId);
        m_writerId = std::move(x.m_writerId);
        m_firstSN = std::move(x.m_firstSN);
        m_lastSN = std::move(x.m_lastSN);
        m_count = std::move(x.m_count);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x HeartBeatSubmessage object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const HeartBeatSubmessage& x) const
    {
        return (m_submsgHeader == x.m_submsgHeader &&
           m_readerId == x.m_readerId &&
           m_writerId == x.m_writerId &&
           m_firstSN == x.m_firstSN &&
           m_lastSN == x.m_lastSN &&
           m_count == x.m_count);
    }

    /*!
     * @brief Comparison operator.
     * @param x HeartBeatSubmessage object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const HeartBeatSubmessage& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member submsgHeader
     * @param _submsgHeader New value to be copied in member submsgHeader
     */
    eProsima_user_DllExport void submsgHeader(
            const SubmessageHeader& _submsgHeader)
    {
        m_submsgHeader = _submsgHeader;
    }

    /*!
     * @brief This function moves the value in member submsgHeader
     * @param _submsgHeader New value to be moved in member submsgHeader
     */
    eProsima_user_DllExport void submsgHeader(
            SubmessageHeader&& _submsgHeader)
    {
        m_submsgHeader = std::move(_submsgHeader);
    }

    /*!
     * @brief This function returns a constant reference to member submsgHeader
     * @return Constant reference to member submsgHeader
     */
    eProsima_user_DllExport const SubmessageHeader& submsgHeader() const
    {
        return m_submsgHeader;
    }

    /*!
     * @brief This function returns a reference to member submsgHeader
     * @return Reference to member submsgHeader
     */
    eProsima_user_DllExport SubmessageHeader& submsgHeader()
    {
        return m_submsgHeader;
    }


    /*!
     * @brief This function copies the value in member readerId
     * @param _readerId New value to be copied in member readerId
     */
    eProsima_user_DllExport void readerId(
            const detail::EntityId_t& _readerId)
    {
        m_readerId = _readerId;
    }

    /*!
     * @brief This function moves the value in member readerId
     * @param _readerId New value to be moved in member readerId
     */
    eProsima_user_DllExport void readerId(
            detail::EntityId_t&& _readerId)
    {
        m_readerId = std::move(_readerId);
    }

    /*!
     * @brief This function returns a constant reference to member readerId
     * @return Constant reference to member readerId
     */
    eProsima_user_DllExport const detail::EntityId_t& readerId() const
    {
        return m_readerId;
    }

    /*!
     * @brief This function returns a reference to member readerId
     * @return Reference to member readerId
     */
    eProsima_user_DllExport detail::EntityId_t& readerId()
    {
        return m_readerId;
    }


    /*!
     * @brief This function copies the value in member writerId
     * @param _writerId New value to be copied in member writerId
     */
    eProsima_user_DllExport void writerId(
            const detail::EntityId_t& _writerId)
    {
        m_writerId = _writerId;
    }

    /*!
     * @brief This function moves the value in member writerId
     * @param _writerId New value to be moved in member writerId
     */
    eProsima_user_DllExport void writerId(
            detail::EntityId_t&& _writerId)
    {
        m_writerId = std::move(_writerId);
    }

    /*!
     * @brief This function returns a constant reference to member writerId
     * @return Constant reference to member writerId
     */
    eProsima_user_DllExport const detail::EntityId_t& writerId() const
    {
        return m_writerId;
    }

    /*!
     * @brief This function returns a reference to member writerId
     * @return Reference to member writerId
     */
    eProsima_user_DllExport detail::EntityId_t& writerId()
    {
        return m_writerId;
    }


    /*!
     * @brief This function copies the value in member firstSN
     * @param _firstSN New value to be copied in member firstSN
     */
    eProsima_user_DllExport void firstSN(
            const detail::SequenceNumber_t& _firstSN)
    {
        m_firstSN = _firstSN;
    }

    /*!
     * @brief This function moves the value in member firstSN
     * @param _firstSN New value to be moved in member firstSN
     */
    eProsima_user_DllExport void firstSN(
            detail::SequenceNumber_t&& _firstSN)
    {
        m_firstSN = std::move(_firstSN);
    }

    /*!
     * @brief This function returns a constant reference to member firstSN
     * @return Constant reference to member firstSN
     */
    eProsima_user_DllExport const detail::SequenceNumber_t& firstSN() const
    {
        return m_firstSN;
    }

    /*!
     * @brief This function returns a reference to member firstSN
     * @return Reference to member firstSN
     */
    eProsima_user_DllExport detail::SequenceNumber_t& firstSN()
    {
        return m_firstSN;
    }


    /*!
     * @brief This function copies the value in member lastSN
     * @param _lastSN New value to be copied in member lastSN
     */
    eProsima_user_DllExport void lastSN(
            const detail::SequenceNumber_t& _lastSN)
    {
        m_lastSN = _lastSN;
    }

    /*!
     * @brief This function moves the value in member lastSN
     * @param _lastSN New value to be moved in member lastSN
     */
    eProsima_user_DllExport void lastSN(
            detail::SequenceNumber_t&& _lastSN)
    {
        m_lastSN = std::move(_lastSN);
    }

    /*!
     * @brief This function returns a constant reference to member lastSN
     * @return Constant reference to member lastSN
     */
    eProsima_user_DllExport const detail::SequenceNumber_t& lastSN() const
    {
        return m_lastSN;
    }

    /*!
     * @brief This function returns a reference to member lastSN
     * @return Reference to member lastSN
     */
    eProsima_user_DllExport detail::SequenceNumber_t& lastSN()
    {
        return m_lastSN;
    }


    /*!
     * @brief This function copies the value in member count
     * @param _count New value to be copied in member count
     */
    eProsima_user_DllExport void count(
            const detail::Count_t& _count)
    {
        m_count = _count;
    }

    /*!
     * @brief This function moves the value in member count
     * @param _count New value to be moved in member count
     */
    eProsima_user_DllExport void count(
            detail::Count_t&& _count)
    {
        m_count = std::move(_count);
    }

    /*!
     * @brief This function returns a constant reference to member count
     * @return Constant reference to member count
     */
    eProsima_user_DllExport const detail::Count_t& count() const
    {
        return m_count;
    }

    /*!
     * @brief This function returns a reference to member count
     * @return Reference to member count
     */
    eProsima_user_DllExport detail::Count_t& count()
    {
        return m_count;
    }



private:

    SubmessageHeader m_submsgHeader;
    detail::EntityId_t m_readerId;
    detail::EntityId_t m_writerId;
    detail::SequenceNumber_t m_firstSN;
    detail::SequenceNumber_t m_lastSN;
    detail::Count_t m_count;

};
/*!
 * @brief This class represents the structure InfoDestinationSubmessage defined by the user in the IDL file.
 * @ingroup core_types
 */
class InfoDestinationSubmessage
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport InfoDestinationSubmessage()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~InfoDestinationSubmessage()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object InfoDestinationSubmessage that will be copied.
     */
    eProsima_user_DllExport InfoDestinationSubmessage(
            const InfoDestinationSubmessage& x)
    {
                    m_submsgHeader = x.m_submsgHeader;

                    m_guidPrefix = x.m_guidPrefix;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object InfoDestinationSubmessage that will be copied.
     */
    eProsima_user_DllExport InfoDestinationSubmessage(
            InfoDestinationSubmessage&& x) noexcept
    {
        m_submsgHeader = std::move(x.m_submsgHeader);
        m_guidPrefix = std::move(x.m_guidPrefix);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object InfoDestinationSubmessage that will be copied.
     */
    eProsima_user_DllExport InfoDestinationSubmessage& operator =(
            const InfoDestinationSubmessage& x)
    {

                    m_submsgHeader = x.m_submsgHeader;

                    m_guidPrefix = x.m_guidPrefix;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object InfoDestinationSubmessage that will be copied.
     */
    eProsima_user_DllExport InfoDestinationSubmessage& operator =(
            InfoDestinationSubmessage&& x) noexcept
    {

        m_submsgHeader = std::move(x.m_submsgHeader);
        m_guidPrefix = std::move(x.m_guidPrefix);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x InfoDestinationSubmessage object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InfoDestinationSubmessage& x) const
    {
        return (m_submsgHeader == x.m_submsgHeader &&
           m_guidPrefix == x.m_guidPrefix);
    }

    /*!
     * @brief Comparison operator.
     * @param x InfoDestinationSubmessage object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InfoDestinationSubmessage& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member submsgHeader
     * @param _submsgHeader New value to be copied in member submsgHeader
     */
    eProsima_user_DllExport void submsgHeader(
            const SubmessageHeader& _submsgHeader)
    {
        m_submsgHeader = _submsgHeader;
    }

    /*!
     * @brief This function moves the value in member submsgHeader
     * @param _submsgHeader New value to be moved in member submsgHeader
     */
    eProsima_user_DllExport void submsgHeader(
            SubmessageHeader&& _submsgHeader)
    {
        m_submsgHeader = std::move(_submsgHeader);
    }

    /*!
     * @brief This function returns a constant reference to member submsgHeader
     * @return Constant reference to member submsgHeader
     */
    eProsima_user_DllExport const SubmessageHeader& submsgHeader() const
    {
        return m_submsgHeader;
    }

    /*!
     * @brief This function returns a reference to member submsgHeader
     * @return Reference to member submsgHeader
     */
    eProsima_user_DllExport SubmessageHeader& submsgHeader()
    {
        return m_submsgHeader;
    }


    /*!
     * @brief This function copies the value in member guidPrefix
     * @param _guidPrefix New value to be copied in member guidPrefix
     */
    eProsima_user_DllExport void guidPrefix(
            const detail::GuidPrefix_t& _guidPrefix)
    {
        m_guidPrefix = _guidPrefix;
    }

    /*!
     * @brief This function moves the value in member guidPrefix
     * @param _guidPrefix New value to be moved in member guidPrefix
     */
    eProsima_user_DllExport void guidPrefix(
            detail::GuidPrefix_t&& _guidPrefix)
    {
        m_guidPrefix = std::move(_guidPrefix);
    }

    /*!
     * @brief This function returns a constant reference to member guidPrefix
     * @return Constant reference to member guidPrefix
     */
    eProsima_user_DllExport const detail::GuidPrefix_t& guidPrefix() const
    {
        return m_guidPrefix;
    }

    /*!
     * @brief This function returns a reference to member guidPrefix
     * @return Reference to member guidPrefix
     */
    eProsima_user_DllExport detail::GuidPrefix_t& guidPrefix()
    {
        return m_guidPrefix;
    }



private:

    SubmessageHeader m_submsgHeader;
    detail::GuidPrefix_t m_guidPrefix;

};
/*!
 * @brief This class represents the structure InfoSourceSubmessage defined by the user in the IDL file.
 * @ingroup core_types
 */
class InfoSourceSubmessage
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport InfoSourceSubmessage()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~InfoSourceSubmessage()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object InfoSourceSubmessage that will be copied.
     */
    eProsima_user_DllExport InfoSourceSubmessage(
            const InfoSourceSubmessage& x)
    {
                    m_submsgHeader = x.m_submsgHeader;

                    m_unused = x.m_unused;

                    m_version = x.m_version;

                    m_vendorId = x.m_vendorId;

                    m_guidPrefix = x.m_guidPrefix;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object InfoSourceSubmessage that will be copied.
     */
    eProsima_user_DllExport InfoSourceSubmessage(
            InfoSourceSubmessage&& x) noexcept
    {
        m_submsgHeader = std::move(x.m_submsgHeader);
        m_unused = x.m_unused;
        m_version = std::move(x.m_version);
        m_vendorId = std::move(x.m_vendorId);
        m_guidPrefix = std::move(x.m_guidPrefix);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object InfoSourceSubmessage that will be copied.
     */
    eProsima_user_DllExport InfoSourceSubmessage& operator =(
            const InfoSourceSubmessage& x)
    {

                    m_submsgHeader = x.m_submsgHeader;

                    m_unused = x.m_unused;

                    m_version = x.m_version;

                    m_vendorId = x.m_vendorId;

                    m_guidPrefix = x.m_guidPrefix;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object InfoSourceSubmessage that will be copied.
     */
    eProsima_user_DllExport InfoSourceSubmessage& operator =(
            InfoSourceSubmessage&& x) noexcept
    {

        m_submsgHeader = std::move(x.m_submsgHeader);
        m_unused = x.m_unused;
        m_version = std::move(x.m_version);
        m_vendorId = std::move(x.m_vendorId);
        m_guidPrefix = std::move(x.m_guidPrefix);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x InfoSourceSubmessage object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InfoSourceSubmessage& x) const
    {
        return (m_submsgHeader == x.m_submsgHeader &&
           m_unused == x.m_unused &&
           m_version == x.m_version &&
           m_vendorId == x.m_vendorId &&
           m_guidPrefix == x.m_guidPrefix);
    }

    /*!
     * @brief Comparison operator.
     * @param x InfoSourceSubmessage object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InfoSourceSubmessage& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member submsgHeader
     * @param _submsgHeader New value to be copied in member submsgHeader
     */
    eProsima_user_DllExport void submsgHeader(
            const SubmessageHeader& _submsgHeader)
    {
        m_submsgHeader = _submsgHeader;
    }

    /*!
     * @brief This function moves the value in member submsgHeader
     * @param _submsgHeader New value to be moved in member submsgHeader
     */
    eProsima_user_DllExport void submsgHeader(
            SubmessageHeader&& _submsgHeader)
    {
        m_submsgHeader = std::move(_submsgHeader);
    }

    /*!
     * @brief This function returns a constant reference to member submsgHeader
     * @return Constant reference to member submsgHeader
     */
    eProsima_user_DllExport const SubmessageHeader& submsgHeader() const
    {
        return m_submsgHeader;
    }

    /*!
     * @brief This function returns a reference to member submsgHeader
     * @return Reference to member submsgHeader
     */
    eProsima_user_DllExport SubmessageHeader& submsgHeader()
    {
        return m_submsgHeader;
    }


    /*!
     * @brief This function sets a value in member unused
     * @param _unused New value for member unused
     */
    eProsima_user_DllExport void unused(
            int32_t _unused)
    {
        m_unused = _unused;
    }

    /*!
     * @brief This function returns the value of member unused
     * @return Value of member unused
     */
    eProsima_user_DllExport int32_t unused() const
    {
        return m_unused;
    }

    /*!
     * @brief This function returns a reference to member unused
     * @return Reference to member unused
     */
    eProsima_user_DllExport int32_t& unused()
    {
        return m_unused;
    }


    /*!
     * @brief This function copies the value in member version
     * @param _version New value to be copied in member version
     */
    eProsima_user_DllExport void version(
            const detail::ProtocolVersion_t& _version)
    {
        m_version = _version;
    }

    /*!
     * @brief This function moves the value in member version
     * @param _version New value to be moved in member version
     */
    eProsima_user_DllExport void version(
            detail::ProtocolVersion_t&& _version)
    {
        m_version = std::move(_version);
    }

    /*!
     * @brief This function returns a constant reference to member version
     * @return Constant reference to member version
     */
    eProsima_user_DllExport const detail::ProtocolVersion_t& version() const
    {
        return m_version;
    }

    /*!
     * @brief This function returns a reference to member version
     * @return Reference to member version
     */
    eProsima_user_DllExport detail::ProtocolVersion_t& version()
    {
        return m_version;
    }


    /*!
     * @brief This function copies the value in member vendorId
     * @param _vendorId New value to be copied in member vendorId
     */
    eProsima_user_DllExport void vendorId(
            const detail::VendorId_t& _vendorId)
    {
        m_vendorId = _vendorId;
    }

    /*!
     * @brief This function moves the value in member vendorId
     * @param _vendorId New value to be moved in member vendorId
     */
    eProsima_user_DllExport void vendorId(
            detail::VendorId_t&& _vendorId)
    {
        m_vendorId = std::move(_vendorId);
    }

    /*!
     * @brief This function returns a constant reference to member vendorId
     * @return Constant reference to member vendorId
     */
    eProsima_user_DllExport const detail::VendorId_t& vendorId() const
    {
        return m_vendorId;
    }

    /*!
     * @brief This function returns a reference to member vendorId
     * @return Reference to member vendorId
     */
    eProsima_user_DllExport detail::VendorId_t& vendorId()
    {
        return m_vendorId;
    }


    /*!
     * @brief This function copies the value in member guidPrefix
     * @param _guidPrefix New value to be copied in member guidPrefix
     */
    eProsima_user_DllExport void guidPrefix(
            const detail::GuidPrefix_t& _guidPrefix)
    {
        m_guidPrefix = _guidPrefix;
    }

    /*!
     * @brief This function moves the value in member guidPrefix
     * @param _guidPrefix New value to be moved in member guidPrefix
     */
    eProsima_user_DllExport void guidPrefix(
            detail::GuidPrefix_t&& _guidPrefix)
    {
        m_guidPrefix = std::move(_guidPrefix);
    }

    /*!
     * @brief This function returns a constant reference to member guidPrefix
     * @return Constant reference to member guidPrefix
     */
    eProsima_user_DllExport const detail::GuidPrefix_t& guidPrefix() const
    {
        return m_guidPrefix;
    }

    /*!
     * @brief This function returns a reference to member guidPrefix
     * @return Reference to member guidPrefix
     */
    eProsima_user_DllExport detail::GuidPrefix_t& guidPrefix()
    {
        return m_guidPrefix;
    }



private:

    SubmessageHeader m_submsgHeader;
    int32_t m_unused{0};
    detail::ProtocolVersion_t m_version;
    detail::VendorId_t m_vendorId;
    detail::GuidPrefix_t m_guidPrefix;

};
/*!
 * @brief This class represents the structure InfoTimestampSubmessage defined by the user in the IDL file.
 * @ingroup core_types
 */
class InfoTimestampSubmessage
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport InfoTimestampSubmessage()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~InfoTimestampSubmessage()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object InfoTimestampSubmessage that will be copied.
     */
    eProsima_user_DllExport InfoTimestampSubmessage(
            const InfoTimestampSubmessage& x)
    {
                    m_submsgHeader = x.m_submsgHeader;

                    m_timestamp = x.m_timestamp;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object InfoTimestampSubmessage that will be copied.
     */
    eProsima_user_DllExport InfoTimestampSubmessage(
            InfoTimestampSubmessage&& x) noexcept
    {
        m_submsgHeader = std::move(x.m_submsgHeader);
        m_timestamp = std::move(x.m_timestamp);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object InfoTimestampSubmessage that will be copied.
     */
    eProsima_user_DllExport InfoTimestampSubmessage& operator =(
            const InfoTimestampSubmessage& x)
    {

                    m_submsgHeader = x.m_submsgHeader;

                    m_timestamp = x.m_timestamp;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object InfoTimestampSubmessage that will be copied.
     */
    eProsima_user_DllExport InfoTimestampSubmessage& operator =(
            InfoTimestampSubmessage&& x) noexcept
    {

        m_submsgHeader = std::move(x.m_submsgHeader);
        m_timestamp = std::move(x.m_timestamp);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x InfoTimestampSubmessage object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InfoTimestampSubmessage& x) const
    {
        return (m_submsgHeader == x.m_submsgHeader &&
           m_timestamp == x.m_timestamp);
    }

    /*!
     * @brief Comparison operator.
     * @param x InfoTimestampSubmessage object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InfoTimestampSubmessage& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member submsgHeader
     * @param _submsgHeader New value to be copied in member submsgHeader
     */
    eProsima_user_DllExport void submsgHeader(
            const SubmessageHeader& _submsgHeader)
    {
        m_submsgHeader = _submsgHeader;
    }

    /*!
     * @brief This function moves the value in member submsgHeader
     * @param _submsgHeader New value to be moved in member submsgHeader
     */
    eProsima_user_DllExport void submsgHeader(
            SubmessageHeader&& _submsgHeader)
    {
        m_submsgHeader = std::move(_submsgHeader);
    }

    /*!
     * @brief This function returns a constant reference to member submsgHeader
     * @return Constant reference to member submsgHeader
     */
    eProsima_user_DllExport const SubmessageHeader& submsgHeader() const
    {
        return m_submsgHeader;
    }

    /*!
     * @brief This function returns a reference to member submsgHeader
     * @return Reference to member submsgHeader
     */
    eProsima_user_DllExport SubmessageHeader& submsgHeader()
    {
        return m_submsgHeader;
    }


    /*!
     * @brief This function copies the value in member timestamp
     * @param _timestamp New value to be copied in member timestamp
     */
    eProsima_user_DllExport void timestamp(
            const detail::Timestamp& _timestamp)
    {
        m_timestamp = _timestamp;
    }

    /*!
     * @brief This function moves the value in member timestamp
     * @param _timestamp New value to be moved in member timestamp
     */
    eProsima_user_DllExport void timestamp(
            detail::Timestamp&& _timestamp)
    {
        m_timestamp = std::move(_timestamp);
    }

    /*!
     * @brief This function returns a constant reference to member timestamp
     * @return Constant reference to member timestamp
     */
    eProsima_user_DllExport const detail::Timestamp& timestamp() const
    {
        return m_timestamp;
    }

    /*!
     * @brief This function returns a reference to member timestamp
     * @return Reference to member timestamp
     */
    eProsima_user_DllExport detail::Timestamp& timestamp()
    {
        return m_timestamp;
    }



private:

    SubmessageHeader m_submsgHeader;
    detail::Timestamp m_timestamp;

};
/*!
 * @brief This class represents the union Submessage defined by the user in the IDL file.
 * @ingroup core_types
 */
class Submessage
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Submessage()
    {
        selected_member_ = 0x00000005;
        member_destructor_ = [&]() {m_unknown_submsg.~SubmessageHeader();};
        new(&m_unknown_submsg) SubmessageHeader();

    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Submessage()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Submessage that will be copied.
     */
    eProsima_user_DllExport Submessage(
            const Submessage& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            heartbeat_submsg_() = x.m_heartbeat_submsg;
                            break;

                        case 0x00000002:
                            info_ts_submsg_() = x.m_info_ts_submsg;
                            break;

                        case 0x00000003:
                            info_src_submsg_() = x.m_info_src_submsg;
                            break;

                        case 0x00000004:
                            info_dst_submsg_() = x.m_info_dst_submsg;
                            break;

                        case 0x00000005:
                            unknown_submsg_() = x.m_unknown_submsg;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Submessage that will be copied.
     */
    eProsima_user_DllExport Submessage(
            Submessage&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            heartbeat_submsg_() = std::move(x.m_heartbeat_submsg);
                            break;

                        case 0x00000002:
                            info_ts_submsg_() = std::move(x.m_info_ts_submsg);
                            break;

                        case 0x00000003:
                            info_src_submsg_() = std::move(x.m_info_src_submsg);
                            break;

                        case 0x00000004:
                            info_dst_submsg_() = std::move(x.m_info_dst_submsg);
                            break;

                        case 0x00000005:
                            unknown_submsg_() = std::move(x.m_unknown_submsg);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Submessage that will be copied.
     */
    eProsima_user_DllExport Submessage& operator =(
            const Submessage& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            heartbeat_submsg_() = x.m_heartbeat_submsg;
                            break;

                        case 0x00000002:
                            info_ts_submsg_() = x.m_info_ts_submsg;
                            break;

                        case 0x00000003:
                            info_src_submsg_() = x.m_info_src_submsg;
                            break;

                        case 0x00000004:
                            info_dst_submsg_() = x.m_info_dst_submsg;
                            break;

                        case 0x00000005:
                            unknown_submsg_() = x.m_unknown_submsg;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Submessage that will be copied.
     */
    eProsima_user_DllExport Submessage& operator =(
            Submessage&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            heartbeat_submsg_() = std::move(x.m_heartbeat_submsg);
                            break;

                        case 0x00000002:
                            info_ts_submsg_() = std::move(x.m_info_ts_submsg);
                            break;

                        case 0x00000003:
                            info_src_submsg_() = std::move(x.m_info_src_submsg);
                            break;

                        case 0x00000004:
                            info_dst_submsg_() = std::move(x.m_info_dst_submsg);
                            break;

                        case 0x00000005:
                            unknown_submsg_() = std::move(x.m_unknown_submsg);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Submessage object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Submessage& x) const
    {
        bool ret_value {false};

        if (m__d == x.m__d &&
                selected_member_ == x.selected_member_)
        {
            switch (selected_member_)
            {
                                case 0x00000001:
                                    ret_value = (m_heartbeat_submsg == x.m_heartbeat_submsg);
                                    break;

                                case 0x00000002:
                                    ret_value = (m_info_ts_submsg == x.m_info_ts_submsg);
                                    break;

                                case 0x00000003:
                                    ret_value = (m_info_src_submsg == x.m_info_src_submsg);
                                    break;

                                case 0x00000004:
                                    ret_value = (m_info_dst_submsg == x.m_info_dst_submsg);
                                    break;

                                case 0x00000005:
                                    ret_value = (m_unknown_submsg == x.m_unknown_submsg);
                                    break;

            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Submessage object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Submessage& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            char __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case SubmessageKind::HEARTBEAT:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case SubmessageKind::INFO_TS:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case SubmessageKind::INFO_SRC:
                            if (0x00000003 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case SubmessageKind::INFO_DST:
                            if (0x00000004 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        default:
                            if (0x00000005 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport char _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member heartbeat_submsg
     * @param _heartbeat_submsg New value to be copied in member heartbeat_submsg
     */
    eProsima_user_DllExport void heartbeat_submsg(
            const HeartBeatSubmessage& _heartbeat_submsg)
    {
        heartbeat_submsg_() = _heartbeat_submsg;
        m__d = SubmessageKind::HEARTBEAT;
    }

    /*!
     * @brief This function moves the value in member heartbeat_submsg
     * @param _heartbeat_submsg New value to be moved in member heartbeat_submsg
     */
    eProsima_user_DllExport void heartbeat_submsg(
            HeartBeatSubmessage&& _heartbeat_submsg)
    {
        heartbeat_submsg_() = _heartbeat_submsg;
        m__d = SubmessageKind::HEARTBEAT;
    }

    /*!
     * @brief This function returns a constant reference to member heartbeat_submsg
     * @return Constant reference to member heartbeat_submsg
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const HeartBeatSubmessage& heartbeat_submsg() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_heartbeat_submsg;
    }

    /*!
     * @brief This function returns a reference to member heartbeat_submsg
     * @return Reference to member heartbeat_submsg
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport HeartBeatSubmessage& heartbeat_submsg()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_heartbeat_submsg;
    }


    /*!
     * @brief This function copies the value in member info_ts_submsg
     * @param _info_ts_submsg New value to be copied in member info_ts_submsg
     */
    eProsima_user_DllExport void info_ts_submsg(
            const InfoTimestampSubmessage& _info_ts_submsg)
    {
        info_ts_submsg_() = _info_ts_submsg;
        m__d = SubmessageKind::INFO_TS;
    }

    /*!
     * @brief This function moves the value in member info_ts_submsg
     * @param _info_ts_submsg New value to be moved in member info_ts_submsg
     */
    eProsima_user_DllExport void info_ts_submsg(
            InfoTimestampSubmessage&& _info_ts_submsg)
    {
        info_ts_submsg_() = _info_ts_submsg;
        m__d = SubmessageKind::INFO_TS;
    }

    /*!
     * @brief This function returns a constant reference to member info_ts_submsg
     * @return Constant reference to member info_ts_submsg
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const InfoTimestampSubmessage& info_ts_submsg() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_info_ts_submsg;
    }

    /*!
     * @brief This function returns a reference to member info_ts_submsg
     * @return Reference to member info_ts_submsg
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InfoTimestampSubmessage& info_ts_submsg()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_info_ts_submsg;
    }


    /*!
     * @brief This function copies the value in member info_src_submsg
     * @param _info_src_submsg New value to be copied in member info_src_submsg
     */
    eProsima_user_DllExport void info_src_submsg(
            const InfoSourceSubmessage& _info_src_submsg)
    {
        info_src_submsg_() = _info_src_submsg;
        m__d = SubmessageKind::INFO_SRC;
    }

    /*!
     * @brief This function moves the value in member info_src_submsg
     * @param _info_src_submsg New value to be moved in member info_src_submsg
     */
    eProsima_user_DllExport void info_src_submsg(
            InfoSourceSubmessage&& _info_src_submsg)
    {
        info_src_submsg_() = _info_src_submsg;
        m__d = SubmessageKind::INFO_SRC;
    }

    /*!
     * @brief This function returns a constant reference to member info_src_submsg
     * @return Constant reference to member info_src_submsg
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const InfoSourceSubmessage& info_src_submsg() const
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_info_src_submsg;
    }

    /*!
     * @brief This function returns a reference to member info_src_submsg
     * @return Reference to member info_src_submsg
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InfoSourceSubmessage& info_src_submsg()
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_info_src_submsg;
    }


    /*!
     * @brief This function copies the value in member info_dst_submsg
     * @param _info_dst_submsg New value to be copied in member info_dst_submsg
     */
    eProsima_user_DllExport void info_dst_submsg(
            const InfoDestinationSubmessage& _info_dst_submsg)
    {
        info_dst_submsg_() = _info_dst_submsg;
        m__d = SubmessageKind::INFO_DST;
    }

    /*!
     * @brief This function moves the value in member info_dst_submsg
     * @param _info_dst_submsg New value to be moved in member info_dst_submsg
     */
    eProsima_user_DllExport void info_dst_submsg(
            InfoDestinationSubmessage&& _info_dst_submsg)
    {
        info_dst_submsg_() = _info_dst_submsg;
        m__d = SubmessageKind::INFO_DST;
    }

    /*!
     * @brief This function returns a constant reference to member info_dst_submsg
     * @return Constant reference to member info_dst_submsg
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const InfoDestinationSubmessage& info_dst_submsg() const
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_info_dst_submsg;
    }

    /*!
     * @brief This function returns a reference to member info_dst_submsg
     * @return Reference to member info_dst_submsg
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InfoDestinationSubmessage& info_dst_submsg()
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_info_dst_submsg;
    }


    /*!
     * @brief This function copies the value in member unknown_submsg
     * @param _unknown_submsg New value to be copied in member unknown_submsg
     */
    eProsima_user_DllExport void unknown_submsg(
            const SubmessageHeader& _unknown_submsg)
    {
        unknown_submsg_() = _unknown_submsg;
        m__d = 127;
    }

    /*!
     * @brief This function moves the value in member unknown_submsg
     * @param _unknown_submsg New value to be moved in member unknown_submsg
     */
    eProsima_user_DllExport void unknown_submsg(
            SubmessageHeader&& _unknown_submsg)
    {
        unknown_submsg_() = _unknown_submsg;
        m__d = 127;
    }

    /*!
     * @brief This function returns a constant reference to member unknown_submsg
     * @return Constant reference to member unknown_submsg
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const SubmessageHeader& unknown_submsg() const
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_unknown_submsg;
    }

    /*!
     * @brief This function returns a reference to member unknown_submsg
     * @return Reference to member unknown_submsg
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport SubmessageHeader& unknown_submsg()
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_unknown_submsg;
    }



private:

            HeartBeatSubmessage& heartbeat_submsg_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]() {m_heartbeat_submsg.~HeartBeatSubmessage();};
                    new(&m_heartbeat_submsg) HeartBeatSubmessage();

                }

                return m_heartbeat_submsg;
            }

            InfoTimestampSubmessage& info_ts_submsg_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = [&]() {m_info_ts_submsg.~InfoTimestampSubmessage();};
                    new(&m_info_ts_submsg) InfoTimestampSubmessage();

                }

                return m_info_ts_submsg;
            }

            InfoSourceSubmessage& info_src_submsg_()
            {
                if (0x00000003 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000003;
                    member_destructor_ = [&]() {m_info_src_submsg.~InfoSourceSubmessage();};
                    new(&m_info_src_submsg) InfoSourceSubmessage();

                }

                return m_info_src_submsg;
            }

            InfoDestinationSubmessage& info_dst_submsg_()
            {
                if (0x00000004 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000004;
                    member_destructor_ = [&]() {m_info_dst_submsg.~InfoDestinationSubmessage();};
                    new(&m_info_dst_submsg) InfoDestinationSubmessage();

                }

                return m_info_dst_submsg;
            }

            SubmessageHeader& unknown_submsg_()
            {
                if (0x00000005 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000005;
                    member_destructor_ = [&]() {m_unknown_submsg.~SubmessageHeader();};
                    new(&m_unknown_submsg) SubmessageHeader();

                }

                return m_unknown_submsg;
            }


    char m__d {127};

    union
    {
        HeartBeatSubmessage m_heartbeat_submsg;
        InfoTimestampSubmessage m_info_ts_submsg;
        InfoSourceSubmessage m_info_src_submsg;
        InfoDestinationSubmessage m_info_dst_submsg;
        SubmessageHeader m_unknown_submsg;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the structure RTPSMessage defined by the user in the IDL file.
 * @ingroup core_types
 */
class RTPSMessage
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport RTPSMessage()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~RTPSMessage()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object RTPSMessage that will be copied.
     */
    eProsima_user_DllExport RTPSMessage(
            const RTPSMessage& x)
    {
                    m_msg_header = x.m_msg_header;

                    m_submessages = x.m_submessages;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object RTPSMessage that will be copied.
     */
    eProsima_user_DllExport RTPSMessage(
            RTPSMessage&& x) noexcept
    {
        m_msg_header = std::move(x.m_msg_header);
        m_submessages = std::move(x.m_submessages);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object RTPSMessage that will be copied.
     */
    eProsima_user_DllExport RTPSMessage& operator =(
            const RTPSMessage& x)
    {

                    m_msg_header = x.m_msg_header;

                    m_submessages = x.m_submessages;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object RTPSMessage that will be copied.
     */
    eProsima_user_DllExport RTPSMessage& operator =(
            RTPSMessage&& x) noexcept
    {

        m_msg_header = std::move(x.m_msg_header);
        m_submessages = std::move(x.m_submessages);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x RTPSMessage object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const RTPSMessage& x) const
    {
        return (m_msg_header == x.m_msg_header &&
           m_submessages == x.m_submessages);
    }

    /*!
     * @brief Comparison operator.
     * @param x RTPSMessage object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const RTPSMessage& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member msg_header
     * @param _msg_header New value to be copied in member msg_header
     */
    eProsima_user_DllExport void msg_header(
            const Header& _msg_header)
    {
        m_msg_header = _msg_header;
    }

    /*!
     * @brief This function moves the value in member msg_header
     * @param _msg_header New value to be moved in member msg_header
     */
    eProsima_user_DllExport void msg_header(
            Header&& _msg_header)
    {
        m_msg_header = std::move(_msg_header);
    }

    /*!
     * @brief This function returns a constant reference to member msg_header
     * @return Constant reference to member msg_header
     */
    eProsima_user_DllExport const Header& msg_header() const
    {
        return m_msg_header;
    }

    /*!
     * @brief This function returns a reference to member msg_header
     * @return Reference to member msg_header
     */
    eProsima_user_DllExport Header& msg_header()
    {
        return m_msg_header;
    }


    /*!
     * @brief This function copies the value in member submessages
     * @param _submessages New value to be copied in member submessages
     */
    eProsima_user_DllExport void submessages(
            const std::vector<Submessage>& _submessages)
    {
        m_submessages = _submessages;
    }

    /*!
     * @brief This function moves the value in member submessages
     * @param _submessages New value to be moved in member submessages
     */
    eProsima_user_DllExport void submessages(
            std::vector<Submessage>&& _submessages)
    {
        m_submessages = std::move(_submessages);
    }

    /*!
     * @brief This function returns a constant reference to member submessages
     * @return Constant reference to member submessages
     */
    eProsima_user_DllExport const std::vector<Submessage>& submessages() const
    {
        return m_submessages;
    }

    /*!
     * @brief This function returns a reference to member submessages
     * @return Reference to member submessages
     */
    eProsima_user_DllExport std::vector<Submessage>& submessages()
    {
        return m_submessages;
    }



private:

    Header m_msg_header;
    std::vector<Submessage> m_submessages;

};

} // namespace core

} // namespace rtps

} // namespace fastdds

} // namespace eprosima

#endif // _FAST_DDS_GENERATED_EPROSIMA_FASTDDS_RTPS_CORE_CORE_TYPES_HPP_


