// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file TypeLookupTypes.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__EPROSIMA_FASTDDS_DDS_BUILTIN_TYPELOOKUPTYPES_HPP
#define FAST_DDS_GENERATED__EPROSIMA_FASTDDS_DDS_BUILTIN_TYPELOOKUPTYPES_HPP

#include <cstdint>
#include <functional>
#include <utility>
#include <vector>

#include <fastcdr/exceptions/BadParamException.h>

#include "rpc_types.hpp"
#include <fastdds/dds/core/ReturnCode.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(TYPELOOKUPTYPES_SOURCE)
#define TYPELOOKUPTYPES_DllAPI __declspec( dllexport )
#else
#define TYPELOOKUPTYPES_DllAPI __declspec( dllimport )
#endif // TYPELOOKUPTYPES_SOURCE
#else
#define TYPELOOKUPTYPES_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define TYPELOOKUPTYPES_DllAPI
#endif // _WIN32

namespace eprosima {

namespace fastdds {

namespace dds {


namespace builtin {

const uint32_t TypeLookup_getTypes_HashId = 0x018252d3;
const uint32_t TypeLookup_getDependencies_HashId = 0x05aafb31;
/*!
 * @brief This class represents the structure TypeLookup_getTypes_In defined by the user in the IDL file.
 * @ingroup TypeLookupTypes
 */
class TypeLookup_getTypes_In
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeLookup_getTypes_In()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeLookup_getTypes_In()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeLookup_getTypes_In that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypes_In(
            const TypeLookup_getTypes_In& x)
    {
                    m_type_ids = x.m_type_ids;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeLookup_getTypes_In that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypes_In(
            TypeLookup_getTypes_In&& x) noexcept
    {
        m_type_ids = std::move(x.m_type_ids);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeLookup_getTypes_In that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypes_In& operator =(
            const TypeLookup_getTypes_In& x)
    {

                    m_type_ids = x.m_type_ids;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeLookup_getTypes_In that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypes_In& operator =(
            TypeLookup_getTypes_In&& x) noexcept
    {

        m_type_ids = std::move(x.m_type_ids);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_getTypes_In object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeLookup_getTypes_In& x) const
    {
        return (m_type_ids == x.m_type_ids);
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_getTypes_In object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeLookup_getTypes_In& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member type_ids
     * @param _type_ids New value to be copied in member type_ids
     */
    eProsima_user_DllExport void type_ids(
            const std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifier>& _type_ids)
    {
        m_type_ids = _type_ids;
    }

    /*!
     * @brief This function moves the value in member type_ids
     * @param _type_ids New value to be moved in member type_ids
     */
    eProsima_user_DllExport void type_ids(
            std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifier>&& _type_ids)
    {
        m_type_ids = std::move(_type_ids);
    }

    /*!
     * @brief This function returns a constant reference to member type_ids
     * @return Constant reference to member type_ids
     */
    eProsima_user_DllExport const std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifier>& type_ids() const
    {
        return m_type_ids;
    }

    /*!
     * @brief This function returns a reference to member type_ids
     * @return Reference to member type_ids
     */
    eProsima_user_DllExport std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifier>& type_ids()
    {
        return m_type_ids;
    }



private:

    std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifier> m_type_ids;

};
/*!
 * @brief This class represents the structure TypeLookup_getTypes_Out defined by the user in the IDL file.
 * @ingroup TypeLookupTypes
 */
class TypeLookup_getTypes_Out
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeLookup_getTypes_Out()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeLookup_getTypes_Out()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeLookup_getTypes_Out that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypes_Out(
            const TypeLookup_getTypes_Out& x)
    {
                    m_types = x.m_types;

                    m_complete_to_minimal = x.m_complete_to_minimal;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeLookup_getTypes_Out that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypes_Out(
            TypeLookup_getTypes_Out&& x) noexcept
    {
        m_types = std::move(x.m_types);
        m_complete_to_minimal = std::move(x.m_complete_to_minimal);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeLookup_getTypes_Out that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypes_Out& operator =(
            const TypeLookup_getTypes_Out& x)
    {

                    m_types = x.m_types;

                    m_complete_to_minimal = x.m_complete_to_minimal;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeLookup_getTypes_Out that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypes_Out& operator =(
            TypeLookup_getTypes_Out&& x) noexcept
    {

        m_types = std::move(x.m_types);
        m_complete_to_minimal = std::move(x.m_complete_to_minimal);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_getTypes_Out object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeLookup_getTypes_Out& x) const
    {
        return (m_types == x.m_types &&
           m_complete_to_minimal == x.m_complete_to_minimal);
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_getTypes_Out object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeLookup_getTypes_Out& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member types
     * @param _types New value to be copied in member types
     */
    eProsima_user_DllExport void types(
            const std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifierTypeObjectPair>& _types)
    {
        m_types = _types;
    }

    /*!
     * @brief This function moves the value in member types
     * @param _types New value to be moved in member types
     */
    eProsima_user_DllExport void types(
            std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifierTypeObjectPair>&& _types)
    {
        m_types = std::move(_types);
    }

    /*!
     * @brief This function returns a constant reference to member types
     * @return Constant reference to member types
     */
    eProsima_user_DllExport const std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifierTypeObjectPair>& types() const
    {
        return m_types;
    }

    /*!
     * @brief This function returns a reference to member types
     * @return Reference to member types
     */
    eProsima_user_DllExport std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifierTypeObjectPair>& types()
    {
        return m_types;
    }


    /*!
     * @brief This function copies the value in member complete_to_minimal
     * @param _complete_to_minimal New value to be copied in member complete_to_minimal
     */
    eProsima_user_DllExport void complete_to_minimal(
            const std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifierPair>& _complete_to_minimal)
    {
        m_complete_to_minimal = _complete_to_minimal;
    }

    /*!
     * @brief This function moves the value in member complete_to_minimal
     * @param _complete_to_minimal New value to be moved in member complete_to_minimal
     */
    eProsima_user_DllExport void complete_to_minimal(
            std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifierPair>&& _complete_to_minimal)
    {
        m_complete_to_minimal = std::move(_complete_to_minimal);
    }

    /*!
     * @brief This function returns a constant reference to member complete_to_minimal
     * @return Constant reference to member complete_to_minimal
     */
    eProsima_user_DllExport const std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifierPair>& complete_to_minimal() const
    {
        return m_complete_to_minimal;
    }

    /*!
     * @brief This function returns a reference to member complete_to_minimal
     * @return Reference to member complete_to_minimal
     */
    eProsima_user_DllExport std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifierPair>& complete_to_minimal()
    {
        return m_complete_to_minimal;
    }



private:

    std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifierTypeObjectPair> m_types;
    std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifierPair> m_complete_to_minimal;

};
/*!
 * @brief This class represents the union TypeLookup_getTypes_Result defined by the user in the IDL file.
 * @ingroup TypeLookupTypes
 */
class TypeLookup_getTypes_Result
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeLookup_getTypes_Result()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeLookup_getTypes_Result()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeLookup_getTypes_Result that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypes_Result(
            const TypeLookup_getTypes_Result& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            result_() = x.m_result;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeLookup_getTypes_Result that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypes_Result(
            TypeLookup_getTypes_Result&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            result_() = std::move(x.m_result);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeLookup_getTypes_Result that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypes_Result& operator =(
            const TypeLookup_getTypes_Result& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            result_() = x.m_result;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeLookup_getTypes_Result that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypes_Result& operator =(
            TypeLookup_getTypes_Result&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            result_() = std::move(x.m_result);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_getTypes_Result object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeLookup_getTypes_Result& x) const
    {
        bool ret_value {false};

        if (m__d == x.m__d &&
                selected_member_ == x.selected_member_)
        {
            switch (selected_member_)
            {
                                case 0x00000001:
                                    ret_value = (m_result == x.m_result);
                                    break;

            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_getTypes_Result object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeLookup_getTypes_Result& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case eprosima::fastdds::dds::RETCODE_OK:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member result
     * @param _result New value to be copied in member result
     */
    eProsima_user_DllExport void result(
            const TypeLookup_getTypes_Out& _result)
    {
        result_() = _result;
        m__d = eprosima::fastdds::dds::RETCODE_OK;
    }

    /*!
     * @brief This function moves the value in member result
     * @param _result New value to be moved in member result
     */
    eProsima_user_DllExport void result(
            TypeLookup_getTypes_Out&& _result)
    {
        result_() = _result;
        m__d = eprosima::fastdds::dds::RETCODE_OK;
    }

    /*!
     * @brief This function returns a constant reference to member result
     * @return Constant reference to member result
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const TypeLookup_getTypes_Out& result() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_result;
    }

    /*!
     * @brief This function returns a reference to member result
     * @return Reference to member result
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport TypeLookup_getTypes_Out& result()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_result;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            TypeLookup_getTypes_Out& result_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]() {m_result.~TypeLookup_getTypes_Out();};
                    new(&m_result) TypeLookup_getTypes_Out();

                }

                return m_result;
            }


    int32_t m__d {2147483647};

    union
    {
        TypeLookup_getTypes_Out m_result;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the structure TypeLookup_getTypeDependencies_In defined by the user in the IDL file.
 * @ingroup TypeLookupTypes
 */
class TypeLookup_getTypeDependencies_In
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_In()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeLookup_getTypeDependencies_In()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeLookup_getTypeDependencies_In that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_In(
            const TypeLookup_getTypeDependencies_In& x)
    {
                    m_type_ids = x.m_type_ids;

                    m_continuation_point = x.m_continuation_point;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeLookup_getTypeDependencies_In that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_In(
            TypeLookup_getTypeDependencies_In&& x) noexcept
    {
        m_type_ids = std::move(x.m_type_ids);
        m_continuation_point = std::move(x.m_continuation_point);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeLookup_getTypeDependencies_In that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_In& operator =(
            const TypeLookup_getTypeDependencies_In& x)
    {

                    m_type_ids = x.m_type_ids;

                    m_continuation_point = x.m_continuation_point;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeLookup_getTypeDependencies_In that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_In& operator =(
            TypeLookup_getTypeDependencies_In&& x) noexcept
    {

        m_type_ids = std::move(x.m_type_ids);
        m_continuation_point = std::move(x.m_continuation_point);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_getTypeDependencies_In object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeLookup_getTypeDependencies_In& x) const
    {
        return (m_type_ids == x.m_type_ids &&
           m_continuation_point == x.m_continuation_point);
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_getTypeDependencies_In object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeLookup_getTypeDependencies_In& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member type_ids
     * @param _type_ids New value to be copied in member type_ids
     */
    eProsima_user_DllExport void type_ids(
            const std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifier>& _type_ids)
    {
        m_type_ids = _type_ids;
    }

    /*!
     * @brief This function moves the value in member type_ids
     * @param _type_ids New value to be moved in member type_ids
     */
    eProsima_user_DllExport void type_ids(
            std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifier>&& _type_ids)
    {
        m_type_ids = std::move(_type_ids);
    }

    /*!
     * @brief This function returns a constant reference to member type_ids
     * @return Constant reference to member type_ids
     */
    eProsima_user_DllExport const std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifier>& type_ids() const
    {
        return m_type_ids;
    }

    /*!
     * @brief This function returns a reference to member type_ids
     * @return Reference to member type_ids
     */
    eProsima_user_DllExport std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifier>& type_ids()
    {
        return m_type_ids;
    }


    /*!
     * @brief This function copies the value in member continuation_point
     * @param _continuation_point New value to be copied in member continuation_point
     */
    eProsima_user_DllExport void continuation_point(
            const std::vector<uint8_t>& _continuation_point)
    {
        m_continuation_point = _continuation_point;
    }

    /*!
     * @brief This function moves the value in member continuation_point
     * @param _continuation_point New value to be moved in member continuation_point
     */
    eProsima_user_DllExport void continuation_point(
            std::vector<uint8_t>&& _continuation_point)
    {
        m_continuation_point = std::move(_continuation_point);
    }

    /*!
     * @brief This function returns a constant reference to member continuation_point
     * @return Constant reference to member continuation_point
     */
    eProsima_user_DllExport const std::vector<uint8_t>& continuation_point() const
    {
        return m_continuation_point;
    }

    /*!
     * @brief This function returns a reference to member continuation_point
     * @return Reference to member continuation_point
     */
    eProsima_user_DllExport std::vector<uint8_t>& continuation_point()
    {
        return m_continuation_point;
    }



private:

    std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifier> m_type_ids;
    std::vector<uint8_t> m_continuation_point;

};
/*!
 * @brief This class represents the structure TypeLookup_getTypeDependencies_Out defined by the user in the IDL file.
 * @ingroup TypeLookupTypes
 */
class TypeLookup_getTypeDependencies_Out
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_Out()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeLookup_getTypeDependencies_Out()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeLookup_getTypeDependencies_Out that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_Out(
            const TypeLookup_getTypeDependencies_Out& x)
    {
                    m_dependent_typeids = x.m_dependent_typeids;

                    m_continuation_point = x.m_continuation_point;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeLookup_getTypeDependencies_Out that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_Out(
            TypeLookup_getTypeDependencies_Out&& x) noexcept
    {
        m_dependent_typeids = std::move(x.m_dependent_typeids);
        m_continuation_point = std::move(x.m_continuation_point);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeLookup_getTypeDependencies_Out that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_Out& operator =(
            const TypeLookup_getTypeDependencies_Out& x)
    {

                    m_dependent_typeids = x.m_dependent_typeids;

                    m_continuation_point = x.m_continuation_point;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeLookup_getTypeDependencies_Out that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_Out& operator =(
            TypeLookup_getTypeDependencies_Out&& x) noexcept
    {

        m_dependent_typeids = std::move(x.m_dependent_typeids);
        m_continuation_point = std::move(x.m_continuation_point);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_getTypeDependencies_Out object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeLookup_getTypeDependencies_Out& x) const
    {
        return (m_dependent_typeids == x.m_dependent_typeids &&
           m_continuation_point == x.m_continuation_point);
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_getTypeDependencies_Out object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeLookup_getTypeDependencies_Out& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member dependent_typeids
     * @param _dependent_typeids New value to be copied in member dependent_typeids
     */
    eProsima_user_DllExport void dependent_typeids(
            const std::vector<eprosima::fastdds::dds::xtypes::TypeIdentfierWithSize>& _dependent_typeids)
    {
        m_dependent_typeids = _dependent_typeids;
    }

    /*!
     * @brief This function moves the value in member dependent_typeids
     * @param _dependent_typeids New value to be moved in member dependent_typeids
     */
    eProsima_user_DllExport void dependent_typeids(
            std::vector<eprosima::fastdds::dds::xtypes::TypeIdentfierWithSize>&& _dependent_typeids)
    {
        m_dependent_typeids = std::move(_dependent_typeids);
    }

    /*!
     * @brief This function returns a constant reference to member dependent_typeids
     * @return Constant reference to member dependent_typeids
     */
    eProsima_user_DllExport const std::vector<eprosima::fastdds::dds::xtypes::TypeIdentfierWithSize>& dependent_typeids() const
    {
        return m_dependent_typeids;
    }

    /*!
     * @brief This function returns a reference to member dependent_typeids
     * @return Reference to member dependent_typeids
     */
    eProsima_user_DllExport std::vector<eprosima::fastdds::dds::xtypes::TypeIdentfierWithSize>& dependent_typeids()
    {
        return m_dependent_typeids;
    }


    /*!
     * @brief This function copies the value in member continuation_point
     * @param _continuation_point New value to be copied in member continuation_point
     */
    eProsima_user_DllExport void continuation_point(
            const std::vector<uint8_t>& _continuation_point)
    {
        m_continuation_point = _continuation_point;
    }

    /*!
     * @brief This function moves the value in member continuation_point
     * @param _continuation_point New value to be moved in member continuation_point
     */
    eProsima_user_DllExport void continuation_point(
            std::vector<uint8_t>&& _continuation_point)
    {
        m_continuation_point = std::move(_continuation_point);
    }

    /*!
     * @brief This function returns a constant reference to member continuation_point
     * @return Constant reference to member continuation_point
     */
    eProsima_user_DllExport const std::vector<uint8_t>& continuation_point() const
    {
        return m_continuation_point;
    }

    /*!
     * @brief This function returns a reference to member continuation_point
     * @return Reference to member continuation_point
     */
    eProsima_user_DllExport std::vector<uint8_t>& continuation_point()
    {
        return m_continuation_point;
    }



private:

    std::vector<eprosima::fastdds::dds::xtypes::TypeIdentfierWithSize> m_dependent_typeids;
    std::vector<uint8_t> m_continuation_point;

};
/*!
 * @brief This class represents the union TypeLookup_getTypeDependencies_Result defined by the user in the IDL file.
 * @ingroup TypeLookupTypes
 */
class TypeLookup_getTypeDependencies_Result
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_Result()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeLookup_getTypeDependencies_Result()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeLookup_getTypeDependencies_Result that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_Result(
            const TypeLookup_getTypeDependencies_Result& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            result_() = x.m_result;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeLookup_getTypeDependencies_Result that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_Result(
            TypeLookup_getTypeDependencies_Result&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            result_() = std::move(x.m_result);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeLookup_getTypeDependencies_Result that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_Result& operator =(
            const TypeLookup_getTypeDependencies_Result& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            result_() = x.m_result;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeLookup_getTypeDependencies_Result that will be copied.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_Result& operator =(
            TypeLookup_getTypeDependencies_Result&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            result_() = std::move(x.m_result);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_getTypeDependencies_Result object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeLookup_getTypeDependencies_Result& x) const
    {
        bool ret_value {false};

        if (m__d == x.m__d &&
                selected_member_ == x.selected_member_)
        {
            switch (selected_member_)
            {
                                case 0x00000001:
                                    ret_value = (m_result == x.m_result);
                                    break;

            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_getTypeDependencies_Result object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeLookup_getTypeDependencies_Result& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case eprosima::fastdds::dds::RETCODE_OK:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member result
     * @param _result New value to be copied in member result
     */
    eProsima_user_DllExport void result(
            const TypeLookup_getTypeDependencies_Out& _result)
    {
        result_() = _result;
        m__d = eprosima::fastdds::dds::RETCODE_OK;
    }

    /*!
     * @brief This function moves the value in member result
     * @param _result New value to be moved in member result
     */
    eProsima_user_DllExport void result(
            TypeLookup_getTypeDependencies_Out&& _result)
    {
        result_() = _result;
        m__d = eprosima::fastdds::dds::RETCODE_OK;
    }

    /*!
     * @brief This function returns a constant reference to member result
     * @return Constant reference to member result
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const TypeLookup_getTypeDependencies_Out& result() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_result;
    }

    /*!
     * @brief This function returns a reference to member result
     * @return Reference to member result
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_Out& result()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_result;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            TypeLookup_getTypeDependencies_Out& result_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]() {m_result.~TypeLookup_getTypeDependencies_Out();};
                    new(&m_result) TypeLookup_getTypeDependencies_Out();

                }

                return m_result;
            }


    int32_t m__d {2147483647};

    union
    {
        TypeLookup_getTypeDependencies_Out m_result;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union TypeLookup_Call defined by the user in the IDL file.
 * @ingroup TypeLookupTypes
 */
class TypeLookup_Call
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeLookup_Call()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeLookup_Call()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeLookup_Call that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Call(
            const TypeLookup_Call& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            getTypes_() = x.m_getTypes;
                            break;

                        case 0x00000002:
                            getTypeDependencies_() = x.m_getTypeDependencies;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeLookup_Call that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Call(
            TypeLookup_Call&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            getTypes_() = std::move(x.m_getTypes);
                            break;

                        case 0x00000002:
                            getTypeDependencies_() = std::move(x.m_getTypeDependencies);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeLookup_Call that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Call& operator =(
            const TypeLookup_Call& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            getTypes_() = x.m_getTypes;
                            break;

                        case 0x00000002:
                            getTypeDependencies_() = x.m_getTypeDependencies;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeLookup_Call that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Call& operator =(
            TypeLookup_Call&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            getTypes_() = std::move(x.m_getTypes);
                            break;

                        case 0x00000002:
                            getTypeDependencies_() = std::move(x.m_getTypeDependencies);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_Call object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeLookup_Call& x) const
    {
        bool ret_value {false};

        if (m__d == x.m__d &&
                selected_member_ == x.selected_member_)
        {
            switch (selected_member_)
            {
                                case 0x00000001:
                                    ret_value = (m_getTypes == x.m_getTypes);
                                    break;

                                case 0x00000002:
                                    ret_value = (m_getTypeDependencies == x.m_getTypeDependencies);
                                    break;

            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_Call object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeLookup_Call& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case TypeLookup_getTypes_HashId:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TypeLookup_getDependencies_HashId:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member getTypes
     * @param _getTypes New value to be copied in member getTypes
     */
    eProsima_user_DllExport void getTypes(
            const TypeLookup_getTypes_In& _getTypes)
    {
        getTypes_() = _getTypes;
        m__d = TypeLookup_getTypes_HashId;
    }

    /*!
     * @brief This function moves the value in member getTypes
     * @param _getTypes New value to be moved in member getTypes
     */
    eProsima_user_DllExport void getTypes(
            TypeLookup_getTypes_In&& _getTypes)
    {
        getTypes_() = _getTypes;
        m__d = TypeLookup_getTypes_HashId;
    }

    /*!
     * @brief This function returns a constant reference to member getTypes
     * @return Constant reference to member getTypes
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const TypeLookup_getTypes_In& getTypes() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_getTypes;
    }

    /*!
     * @brief This function returns a reference to member getTypes
     * @return Reference to member getTypes
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport TypeLookup_getTypes_In& getTypes()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_getTypes;
    }


    /*!
     * @brief This function copies the value in member getTypeDependencies
     * @param _getTypeDependencies New value to be copied in member getTypeDependencies
     */
    eProsima_user_DllExport void getTypeDependencies(
            const TypeLookup_getTypeDependencies_In& _getTypeDependencies)
    {
        getTypeDependencies_() = _getTypeDependencies;
        m__d = TypeLookup_getDependencies_HashId;
    }

    /*!
     * @brief This function moves the value in member getTypeDependencies
     * @param _getTypeDependencies New value to be moved in member getTypeDependencies
     */
    eProsima_user_DllExport void getTypeDependencies(
            TypeLookup_getTypeDependencies_In&& _getTypeDependencies)
    {
        getTypeDependencies_() = _getTypeDependencies;
        m__d = TypeLookup_getDependencies_HashId;
    }

    /*!
     * @brief This function returns a constant reference to member getTypeDependencies
     * @return Constant reference to member getTypeDependencies
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const TypeLookup_getTypeDependencies_In& getTypeDependencies() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_getTypeDependencies;
    }

    /*!
     * @brief This function returns a reference to member getTypeDependencies
     * @return Reference to member getTypeDependencies
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_In& getTypeDependencies()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_getTypeDependencies;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            TypeLookup_getTypes_In& getTypes_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]() {m_getTypes.~TypeLookup_getTypes_In();};
                    new(&m_getTypes) TypeLookup_getTypes_In();

                }

                return m_getTypes;
            }

            TypeLookup_getTypeDependencies_In& getTypeDependencies_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = [&]() {m_getTypeDependencies.~TypeLookup_getTypeDependencies_In();};
                    new(&m_getTypeDependencies) TypeLookup_getTypeDependencies_In();

                }

                return m_getTypeDependencies;
            }


    int32_t m__d {2147483647};

    union
    {
        TypeLookup_getTypes_In m_getTypes;
        TypeLookup_getTypeDependencies_In m_getTypeDependencies;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the structure TypeLookup_Request defined by the user in the IDL file.
 * @ingroup TypeLookupTypes
 */
class TypeLookup_Request
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeLookup_Request()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeLookup_Request()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeLookup_Request that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Request(
            const TypeLookup_Request& x)
    {
                    m_header = x.m_header;

                    m_data = x.m_data;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeLookup_Request that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Request(
            TypeLookup_Request&& x) noexcept
    {
        m_header = std::move(x.m_header);
        m_data = std::move(x.m_data);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeLookup_Request that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Request& operator =(
            const TypeLookup_Request& x)
    {

                    m_header = x.m_header;

                    m_data = x.m_data;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeLookup_Request that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Request& operator =(
            TypeLookup_Request&& x) noexcept
    {

        m_header = std::move(x.m_header);
        m_data = std::move(x.m_data);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_Request object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeLookup_Request& x) const
    {
        return (m_header == x.m_header &&
           m_data == x.m_data);
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_Request object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeLookup_Request& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const eprosima::fastdds::dds::rpc::RequestHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            eprosima::fastdds::dds::rpc::RequestHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const eprosima::fastdds::dds::rpc::RequestHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport eprosima::fastdds::dds::rpc::RequestHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member data
     * @param _data New value to be copied in member data
     */
    eProsima_user_DllExport void data(
            const TypeLookup_Call& _data)
    {
        m_data = _data;
    }

    /*!
     * @brief This function moves the value in member data
     * @param _data New value to be moved in member data
     */
    eProsima_user_DllExport void data(
            TypeLookup_Call&& _data)
    {
        m_data = std::move(_data);
    }

    /*!
     * @brief This function returns a constant reference to member data
     * @return Constant reference to member data
     */
    eProsima_user_DllExport const TypeLookup_Call& data() const
    {
        return m_data;
    }

    /*!
     * @brief This function returns a reference to member data
     * @return Reference to member data
     */
    eProsima_user_DllExport TypeLookup_Call& data()
    {
        return m_data;
    }



private:

    eprosima::fastdds::dds::rpc::RequestHeader m_header;
    TypeLookup_Call m_data;

};
/*!
 * @brief This class represents the union TypeLookup_Return defined by the user in the IDL file.
 * @ingroup TypeLookupTypes
 */
class TypeLookup_Return
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeLookup_Return()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeLookup_Return()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeLookup_Return that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Return(
            const TypeLookup_Return& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            getType_() = x.m_getType;
                            break;

                        case 0x00000002:
                            getTypeDependencies_() = x.m_getTypeDependencies;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeLookup_Return that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Return(
            TypeLookup_Return&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            getType_() = std::move(x.m_getType);
                            break;

                        case 0x00000002:
                            getTypeDependencies_() = std::move(x.m_getTypeDependencies);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeLookup_Return that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Return& operator =(
            const TypeLookup_Return& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            getType_() = x.m_getType;
                            break;

                        case 0x00000002:
                            getTypeDependencies_() = x.m_getTypeDependencies;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeLookup_Return that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Return& operator =(
            TypeLookup_Return&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            getType_() = std::move(x.m_getType);
                            break;

                        case 0x00000002:
                            getTypeDependencies_() = std::move(x.m_getTypeDependencies);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_Return object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeLookup_Return& x) const
    {
        bool ret_value {false};

        if (m__d == x.m__d &&
                selected_member_ == x.selected_member_)
        {
            switch (selected_member_)
            {
                                case 0x00000001:
                                    ret_value = (m_getType == x.m_getType);
                                    break;

                                case 0x00000002:
                                    ret_value = (m_getTypeDependencies == x.m_getTypeDependencies);
                                    break;

            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_Return object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeLookup_Return& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case TypeLookup_getTypes_HashId:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TypeLookup_getDependencies_HashId:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member getType
     * @param _getType New value to be copied in member getType
     */
    eProsima_user_DllExport void getType(
            const TypeLookup_getTypes_Result& _getType)
    {
        getType_() = _getType;
        m__d = TypeLookup_getTypes_HashId;
    }

    /*!
     * @brief This function moves the value in member getType
     * @param _getType New value to be moved in member getType
     */
    eProsima_user_DllExport void getType(
            TypeLookup_getTypes_Result&& _getType)
    {
        getType_() = _getType;
        m__d = TypeLookup_getTypes_HashId;
    }

    /*!
     * @brief This function returns a constant reference to member getType
     * @return Constant reference to member getType
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const TypeLookup_getTypes_Result& getType() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_getType;
    }

    /*!
     * @brief This function returns a reference to member getType
     * @return Reference to member getType
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport TypeLookup_getTypes_Result& getType()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_getType;
    }


    /*!
     * @brief This function copies the value in member getTypeDependencies
     * @param _getTypeDependencies New value to be copied in member getTypeDependencies
     */
    eProsima_user_DllExport void getTypeDependencies(
            const TypeLookup_getTypeDependencies_Result& _getTypeDependencies)
    {
        getTypeDependencies_() = _getTypeDependencies;
        m__d = TypeLookup_getDependencies_HashId;
    }

    /*!
     * @brief This function moves the value in member getTypeDependencies
     * @param _getTypeDependencies New value to be moved in member getTypeDependencies
     */
    eProsima_user_DllExport void getTypeDependencies(
            TypeLookup_getTypeDependencies_Result&& _getTypeDependencies)
    {
        getTypeDependencies_() = _getTypeDependencies;
        m__d = TypeLookup_getDependencies_HashId;
    }

    /*!
     * @brief This function returns a constant reference to member getTypeDependencies
     * @return Constant reference to member getTypeDependencies
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const TypeLookup_getTypeDependencies_Result& getTypeDependencies() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_getTypeDependencies;
    }

    /*!
     * @brief This function returns a reference to member getTypeDependencies
     * @return Reference to member getTypeDependencies
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport TypeLookup_getTypeDependencies_Result& getTypeDependencies()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_getTypeDependencies;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            TypeLookup_getTypes_Result& getType_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]() {m_getType.~TypeLookup_getTypes_Result();};
                    new(&m_getType) TypeLookup_getTypes_Result();

                }

                return m_getType;
            }

            TypeLookup_getTypeDependencies_Result& getTypeDependencies_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = [&]() {m_getTypeDependencies.~TypeLookup_getTypeDependencies_Result();};
                    new(&m_getTypeDependencies) TypeLookup_getTypeDependencies_Result();

                }

                return m_getTypeDependencies;
            }


    int32_t m__d {2147483647};

    union
    {
        TypeLookup_getTypes_Result m_getType;
        TypeLookup_getTypeDependencies_Result m_getTypeDependencies;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the structure TypeLookup_Reply defined by the user in the IDL file.
 * @ingroup TypeLookupTypes
 */
class TypeLookup_Reply
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeLookup_Reply()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeLookup_Reply()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeLookup_Reply that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Reply(
            const TypeLookup_Reply& x)
    {
                    m_header = x.m_header;

                    m_return_value = x.m_return_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeLookup_Reply that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Reply(
            TypeLookup_Reply&& x) noexcept
    {
        m_header = std::move(x.m_header);
        m_return_value = std::move(x.m_return_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeLookup_Reply that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Reply& operator =(
            const TypeLookup_Reply& x)
    {

                    m_header = x.m_header;

                    m_return_value = x.m_return_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeLookup_Reply that will be copied.
     */
    eProsima_user_DllExport TypeLookup_Reply& operator =(
            TypeLookup_Reply&& x) noexcept
    {

        m_header = std::move(x.m_header);
        m_return_value = std::move(x.m_return_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_Reply object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeLookup_Reply& x) const
    {
        return (m_header == x.m_header &&
           m_return_value == x.m_return_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeLookup_Reply object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeLookup_Reply& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const eprosima::fastdds::dds::rpc::ReplyHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            eprosima::fastdds::dds::rpc::ReplyHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const eprosima::fastdds::dds::rpc::ReplyHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport eprosima::fastdds::dds::rpc::ReplyHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member return_value
     * @param _return_value New value to be copied in member return_value
     */
    eProsima_user_DllExport void return_value(
            const TypeLookup_Return& _return_value)
    {
        m_return_value = _return_value;
    }

    /*!
     * @brief This function moves the value in member return_value
     * @param _return_value New value to be moved in member return_value
     */
    eProsima_user_DllExport void return_value(
            TypeLookup_Return&& _return_value)
    {
        m_return_value = std::move(_return_value);
    }

    /*!
     * @brief This function returns a constant reference to member return_value
     * @return Constant reference to member return_value
     */
    eProsima_user_DllExport const TypeLookup_Return& return_value() const
    {
        return m_return_value;
    }

    /*!
     * @brief This function returns a reference to member return_value
     * @return Reference to member return_value
     */
    eProsima_user_DllExport TypeLookup_Return& return_value()
    {
        return m_return_value;
    }



private:

    eprosima::fastdds::dds::rpc::ReplyHeader m_header;
    TypeLookup_Return m_return_value;

};

} // namespace builtin

} // namespace dds

} // namespace fastdds

} // namespace eprosima


#endif // _FAST_DDS_GENERATED_EPROSIMA_FASTDDS_DDS_BUILTIN_TYPELOOKUPTYPES_HPP_


