dh-clojure - debhelper extension to assist with Debian Clojure packaging
========================================================================

The `example-clojure/` directory contains a trivial dh-clojure based
package that provides an example, is handy for testing during
development, and is also used to test dh-clojure itself via
`dh_auto_test`.

Much of the code can be exercised/diagnosed via
```
debian/rules clean
fakeroot debian/rules binary
```
This will also build the `example-clojure` package.

Environment variables
---------------------

`DH_CLOJURE_INSTALL_TEST_JAR`: if the project is built to generate a
"test" jar artifact, setting this environment variable to `1` will
instruct dh-clojure to include it in the package

dh-clojure internals
--------------------

Everything is driven by the `leiningen.pm` debhelper "buildsystem"
(see `/usr/share/doc/debhelper/PROGRAMMING.md.gz`).  It implements
subroutines for `dh_auto_*` packaging command sequences for building
Leiningen-based Clojure projects.

`debian/dh-clojure/` is reserved for dh-clojure's use.  If possible,
keep all of the paths that dh-clojure generates during the build in
`debian/dh-clojure/tmp` so that `dh_auto_clean` only has to remove
that directory, and for now, an empty `debian/dh-clojure` will always
be removed on clean.

Certain environment variables are also modified during the build:

 - `LEIN_OFFLINE` is set to `true` to ensure that `lein` doesn't
    attempt to retrieve any dependencies from the network

 - `LEIN_HOME` is set to `$(pwd)/debian/dh-clojure/tmp/lein-home`

Source
------

The `dh-clojure-lein` directory contains the
`org.debian/dh-clojure-lein` Leiningen middleware that handles
Debian-related project file adjustments.

Testing
-------

"All" the tests are run during the package build, but you can also run
the `dh-clojure-lein` tests directly, e.g. `cd dh-clojure-lein && lein
test`.
