/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public class TiffProfileEP
extends TiffProfile {
    public TiffProfileEP() {
        this._profileText = "TIFF/EP (ISO 12234-2:2001)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD iFD) {
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        if (nisoImageMetadata.getImageWidth() == -1L || nisoImageMetadata.getImageLength() == -1L || nisoImageMetadata.getBitsPerSample() == null || tiffIFD.getImageDescription() == null || nisoImageMetadata.getXSamplingFrequency() == null || nisoImageMetadata.getYSamplingFrequency() == null || nisoImageMetadata.getScannerManufacturer() == null || nisoImageMetadata.getScannerModelName() == null && nisoImageMetadata.getScannerModelNumber() == null || nisoImageMetadata.getScanningSoftware() == null || tiffIFD.getImageDescription() == null || tiffIFD.getCopyright() == null || nisoImageMetadata.getDateTimeCreated() == null || tiffIFD.getDateTime() == null || tiffIFD.getTIFFEPStandardID() == null) {
            return false;
        }
        if (!(nisoImageMetadata.getStripOffsets() != null && nisoImageMetadata.getRowsPerStrip() != -1L && nisoImageMetadata.getStripByteCounts() != null || nisoImageMetadata.getTileWidth() != -1L && nisoImageMetadata.getTileLength() != -1L && nisoImageMetadata.getTileOffsets() != null && nisoImageMetadata.getTileByteCounts() != null)) {
            return false;
        }
        long l = tiffIFD.getNewSubfileType();
        if (l != 0L && l != 1L) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tiffIFD, new int[]{1, 2, 3})) {
            return false;
        }
        if (!this.satisfiesOrientation(tiffIFD, new int[]{-1, 1, 3, 6, 8, 9})) {
            return false;
        }
        int n = nisoImageMetadata.getColorSpace();
        if (n != 1 && n != 2 && n != 6 && n != 32803 && n <= Short.MAX_VALUE) {
            return false;
        }
        int n2 = nisoImageMetadata.getPlanarConfiguration();
        if (n2 != 1 && n2 != 2) {
            return false;
        }
        int n3 = nisoImageMetadata.getSensor();
        if (n3 == -1 || n3 < 0 || n3 > 8) {
            return false;
        }
        if (n == 32803) {
            if (tiffIFD.getCFARepeatPatternDim() == null) {
                return false;
            }
            if (tiffIFD.getCFAPattern() == null) {
                return false;
            }
        }
        int n4 = nisoImageMetadata.getSamplesPerPixel();
        if ((n == 1 || n == 32803) && n4 != 1) {
            return false;
        }
        if ((n == 2 || n == 6) && n4 != 3) {
            return false;
        }
        if (n == 6 && (nisoImageMetadata.getYCbCrCoefficients() == null || nisoImageMetadata.getYCbCrSubSampling() == null || nisoImageMetadata.getYCbCrPositioning() == -1 || nisoImageMetadata.getReferenceBlackWhite() == null)) {
            return false;
        }
        int n5 = nisoImageMetadata.getCompressionScheme();
        return n5 == -1 || n5 == 1 || n5 == 7 || n5 > Short.MAX_VALUE;
    }
}

