/* Photo.c generated by valac 0.40.4, the Vala compiler
 * generated from Photo.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Specifies how pixel data is fetched from the backing file on disk.  MASTER is the original*/
/* backing photo of any supported photo file format; SOURCE is either the master or the editable*/
/* file, that is, the appropriate reference file for user display; BASELINE is an appropriate*/
/* file with the proviso that it may be a suitable substitute for the master and/or the editable.*/
/* UNMODIFIED represents the photo with no edits, i.e. the head of the pipeline.*/
/**/
/* In general, callers want to use the BASELINE unless requirements are specific.*/


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <time.h>
#include "shotwell-graphics-processor.h"
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BACKING_FETCH_MODE (backing_fetch_mode_get_type ())

#define TYPE_PHOTO_IMPORT_PARAMS (photo_import_params_get_type ())
#define PHOTO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParams))
#define PHOTO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParamsClass))
#define IS_PHOTO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_IMPORT_PARAMS))
#define IS_PHOTO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_IMPORT_PARAMS))
#define PHOTO_IMPORT_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParamsClass))

typedef struct _PhotoImportParams PhotoImportParams;
typedef struct _PhotoImportParamsClass PhotoImportParamsClass;
typedef struct _PhotoImportParamsPrivate PhotoImportParamsPrivate;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_THUMBNAILS (thumbnails_get_type ())
#define THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAILS, Thumbnails))
#define THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAILS, ThumbnailsClass))
#define IS_THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAILS))
#define IS_THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAILS))
#define THUMBNAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAILS, ThumbnailsClass))

typedef struct _Thumbnails Thumbnails;
typedef struct _ThumbnailsClass ThumbnailsClass;

#define TYPE_PHOTO_ROW (photo_row_get_type ())
#define PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_ROW, PhotoRow))
#define PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_ROW, PhotoRowClass))
#define IS_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_ROW))
#define IS_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_ROW))
#define PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_ROW, PhotoRowClass))

typedef struct _PhotoRow PhotoRow;
typedef struct _PhotoRowClass PhotoRowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _thumbnails_unref0(var) ((var == NULL) ? NULL : (var = (thumbnails_unref (var), NULL)))
#define _photo_row_unref0(var) ((var == NULL) ? NULL : (var = (photo_row_unref (var), NULL)))
typedef struct _ParamSpecPhotoImportParams ParamSpecPhotoImportParams;

#define TYPE_PHOTO_TRANSFORMATION_STATE (photo_transformation_state_get_type ())
#define PHOTO_TRANSFORMATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState))
#define PHOTO_TRANSFORMATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationStateClass))
#define IS_PHOTO_TRANSFORMATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TRANSFORMATION_STATE))
#define IS_PHOTO_TRANSFORMATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TRANSFORMATION_STATE))
#define PHOTO_TRANSFORMATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationStateClass))

typedef struct _PhotoTransformationState PhotoTransformationState;
typedef struct _PhotoTransformationStateClass PhotoTransformationStateClass;
typedef struct _PhotoTransformationStatePrivate PhotoTransformationStatePrivate;
enum  {
	PHOTO_TRANSFORMATION_STATE_0_PROPERTY,
	PHOTO_TRANSFORMATION_STATE_NUM_PROPERTIES
};
static GParamSpec* photo_transformation_state_properties[PHOTO_TRANSFORMATION_STATE_NUM_PROPERTIES];
enum  {
	PHOTO_TRANSFORMATION_STATE_BROKEN_SIGNAL,
	PHOTO_TRANSFORMATION_STATE_NUM_SIGNALS
};
static guint photo_transformation_state_signals[PHOTO_TRANSFORMATION_STATE_NUM_SIGNALS] = {0};

#define TYPE_RATING (rating_get_type ())

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef struct _ThumbnailSourcePrivate ThumbnailSourcePrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef struct _MediaSourcePrivate MediaSourcePrivate;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;
typedef struct _PhotoSourcePrivate PhotoSourcePrivate;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DATEABLE (dateable_get_type ())
#define DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATEABLE, Dateable))
#define IS_DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATEABLE))
#define DATEABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATEABLE, DateableIface))

typedef struct _Dateable Dateable;
typedef struct _DateableIface DateableIface;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;
typedef struct _PhotoPrivate PhotoPrivate;

#define TYPE_ROTATION (rotation_get_type ())

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;

#define PHOTO_TYPE_BACKING_READERS (photo_backing_readers_get_type ())
#define PHOTO_BACKING_READERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_BACKING_READERS, PhotoBackingReaders))
#define PHOTO_BACKING_READERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_BACKING_READERS, PhotoBackingReadersClass))
#define PHOTO_IS_BACKING_READERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_BACKING_READERS))
#define PHOTO_IS_BACKING_READERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_BACKING_READERS))
#define PHOTO_BACKING_READERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_BACKING_READERS, PhotoBackingReadersClass))

typedef struct _PhotoBackingReaders PhotoBackingReaders;
typedef struct _PhotoBackingReadersClass PhotoBackingReadersClass;

#define TYPE_ONE_SHOT_SCHEDULER (one_shot_scheduler_get_type ())
#define ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler))
#define ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))
#define IS_ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ONE_SHOT_SCHEDULER))
#define IS_ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ONE_SHOT_SCHEDULER))
#define ONE_SHOT_SCHEDULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))

typedef struct _OneShotScheduler OneShotScheduler;
typedef struct _OneShotSchedulerClass OneShotSchedulerClass;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
enum  {
	PHOTO_0_PROPERTY,
	PHOTO_NUM_PROPERTIES
};
static GParamSpec* photo_properties[PHOTO_NUM_PROPERTIES];

#define PHOTO_TYPE_CACHED_PIXBUF (photo_cached_pixbuf_get_type ())
#define PHOTO_CACHED_PIXBUF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_CACHED_PIXBUF, PhotoCachedPixbuf))
#define PHOTO_CACHED_PIXBUF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_CACHED_PIXBUF, PhotoCachedPixbufClass))
#define PHOTO_IS_CACHED_PIXBUF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_CACHED_PIXBUF))
#define PHOTO_IS_CACHED_PIXBUF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_CACHED_PIXBUF))
#define PHOTO_CACHED_PIXBUF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_CACHED_PIXBUF, PhotoCachedPixbufClass))

typedef struct _PhotoCachedPixbuf PhotoCachedPixbuf;
typedef struct _PhotoCachedPixbufClass PhotoCachedPixbufClass;
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
#define _photo_backing_readers_unref0(var) ((var == NULL) ? NULL : (var = (photo_backing_readers_unref (var), NULL)))
#define _pixel_transformer_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformer_unref (var), NULL)))
#define _pixel_transformation_bundle_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_bundle_unref (var), NULL)))
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))
typedef struct _PhotoRowPrivate PhotoRowPrivate;

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;

#define TYPE_ORIENTATION (orientation_get_type ())

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;
typedef struct _PhotoBackingReadersPrivate PhotoBackingReadersPrivate;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_PHOTO_TABLE (photo_table_get_type ())
#define PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TABLE, PhotoTable))
#define PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TABLE, PhotoTableClass))
#define IS_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TABLE))
#define IS_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TABLE))
#define PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TABLE, PhotoTableClass))

typedef struct _PhotoTable PhotoTable;
typedef struct _PhotoTableClass PhotoTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_BACKING_PHOTO_TABLE (backing_photo_table_get_type ())
#define BACKING_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTable))
#define BACKING_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTableClass))
#define IS_BACKING_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_TABLE))
#define IS_BACKING_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_TABLE))
#define BACKING_PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTableClass))

typedef struct _BackingPhotoTable BackingPhotoTable;
typedef struct _BackingPhotoTableClass BackingPhotoTableClass;

#define TYPE_PHOTO_PREVIEW (photo_preview_get_type ())
#define PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_PREVIEW, PhotoPreview))
#define PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))
#define IS_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_PREVIEW))
#define IS_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_PREVIEW))
#define PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))

typedef struct _PhotoPreview PhotoPreview;
typedef struct _PhotoPreviewClass PhotoPreviewClass;
#define _photo_preview_unref0(var) ((var == NULL) ? NULL : (var = (photo_preview_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))

#define TYPE_PHOTO_FILE_INTERROGATOR (photo_file_interrogator_get_type ())
#define PHOTO_FILE_INTERROGATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogator))
#define PHOTO_FILE_INTERROGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogatorClass))
#define IS_PHOTO_FILE_INTERROGATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_INTERROGATOR))
#define IS_PHOTO_FILE_INTERROGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_INTERROGATOR))
#define PHOTO_FILE_INTERROGATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogatorClass))

typedef struct _PhotoFileInterrogator PhotoFileInterrogator;
typedef struct _PhotoFileInterrogatorClass PhotoFileInterrogatorClass;
#define _photo_file_interrogator_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_interrogator_unref (var), NULL)))

#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define TYPE_PHOTO_FILE_METADATA_WRITER (photo_file_metadata_writer_get_type ())
#define PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter))
#define PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))
#define IS_PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_METADATA_WRITER))
#define IS_PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_METADATA_WRITER))
#define PHOTO_FILE_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))

typedef struct _PhotoFileMetadataWriter PhotoFileMetadataWriter;
typedef struct _PhotoFileMetadataWriterClass PhotoFileMetadataWriterClass;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;

#define TYPE_IMPORT_RESULT (import_result_get_type ())

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))

#define PHOTO_FILE_READER_TYPE_ROLE (photo_file_reader_role_get_type ())

#define PHOTO_TYPE_REIMPORT_MASTER_STATE (photo_reimport_master_state_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState))
#define PHOTO_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_IS_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_REIMPORT_MASTER_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))

typedef struct _PhotoReimportMasterState PhotoReimportMasterState;
typedef struct _PhotoReimportMasterStateClass PhotoReimportMasterStateClass;
#define _photo_reimport_master_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_master_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL (photo_reimport_master_state_impl_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl))
#define PHOTO_REIMPORT_MASTER_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImplClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL))
#define PHOTO_IS_REIMPORT_MASTER_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL))
#define PHOTO_REIMPORT_MASTER_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImplClass))

typedef struct _PhotoReimportMasterStateImpl PhotoReimportMasterStateImpl;
typedef struct _PhotoReimportMasterStateImplClass PhotoReimportMasterStateImplClass;
typedef struct _PhotoReimportMasterStatePrivate PhotoReimportMasterStatePrivate;
typedef struct _PhotoReimportMasterStateImplPrivate PhotoReimportMasterStateImplPrivate;

#define PHOTO_TYPE_REIMPORT_EDITABLE_STATE (photo_reimport_editable_state_get_type ())
#define PHOTO_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState))
#define PHOTO_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_REIMPORT_EDITABLE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))

typedef struct _PhotoReimportEditableState PhotoReimportEditableState;
typedef struct _PhotoReimportEditableStateClass PhotoReimportEditableStateClass;
#define _photo_reimport_editable_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_editable_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL (photo_reimport_editable_state_impl_get_type ())
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl))
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImplClass))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL))
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImplClass))

typedef struct _PhotoReimportEditableStateImpl PhotoReimportEditableStateImpl;
typedef struct _PhotoReimportEditableStateImplClass PhotoReimportEditableStateImplClass;
typedef struct _PhotoReimportEditableStatePrivate PhotoReimportEditableStatePrivate;
typedef struct _PhotoReimportEditableStateImplPrivate PhotoReimportEditableStateImplPrivate;

#define PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE (photo_reimport_raw_development_state_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentState))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentStateClass))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentStateClass))

typedef struct _PhotoReimportRawDevelopmentState PhotoReimportRawDevelopmentState;
typedef struct _PhotoReimportRawDevelopmentStateClass PhotoReimportRawDevelopmentStateClass;
#define _photo_reimport_raw_development_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_raw_development_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL (photo_reimport_raw_development_state_impl_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImpl))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImplClass))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImplClass))

typedef struct _PhotoReimportRawDevelopmentStateImpl PhotoReimportRawDevelopmentStateImpl;
typedef struct _PhotoReimportRawDevelopmentStateImplClass PhotoReimportRawDevelopmentStateImplClass;

#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT (photo_reimport_raw_development_state_impl_dev_to_reimport_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimport))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimportClass))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_IS_DEV_TO_REIMPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_IS_DEV_TO_REIMPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimportClass))

typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimport PhotoReimportRawDevelopmentStateImplDevToReimport;
typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimportClass PhotoReimportRawDevelopmentStateImplDevToReimportClass;
typedef struct _PhotoReimportRawDevelopmentStatePrivate PhotoReimportRawDevelopmentStatePrivate;
typedef struct _PhotoReimportRawDevelopmentStateImplPrivate PhotoReimportRawDevelopmentStateImplPrivate;
typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimportPrivate PhotoReimportRawDevelopmentStateImplDevToReimportPrivate;
#define _photo_reimport_raw_development_state_impl_dev_to_reimport_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_raw_development_state_impl_dev_to_reimport_unref (var), NULL)))

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define PHOTO_METADATA_TYPE_SET_OPTION (photo_metadata_set_option_get_type ())

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
#define _key_value_map_unref0(var) ((var == NULL) ? NULL : (var = (key_value_map_unref (var), NULL)))
#define _pixel_transformation_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_unref (var), NULL)))

#define PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL (photo_photo_transformation_state_impl_get_type ())
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImpl))
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImplClass))
#define PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL))
#define PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL))
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImplClass))

typedef struct _PhotoPhotoTransformationStateImpl PhotoPhotoTransformationStateImpl;
typedef struct _PhotoPhotoTransformationStateImplClass PhotoPhotoTransformationStateImplClass;

#define EDITING_TOOLS_TYPE_REDEYE_INSTANCE (editing_tools_redeye_instance_get_type ())
typedef struct _EditingToolsRedeyeInstance EditingToolsRedeyeInstance;
typedef struct _PhotoCachedPixbufPrivate PhotoCachedPixbufPrivate;
#define _photo_cached_pixbuf_unref0(var) ((var == NULL) ? NULL : (var = (photo_cached_pixbuf_unref (var), NULL)))

#define TYPE_PHOTO_FILE_FORMAT_PROPERTIES (photo_file_format_properties_get_type ())
#define PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties))
#define PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))

typedef struct _PhotoFileFormatProperties PhotoFileFormatProperties;
typedef struct _PhotoFileFormatPropertiesClass PhotoFileFormatPropertiesClass;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _PhotoPhotoTransformationStateImplPrivate PhotoPhotoTransformationStateImplPrivate;
enum  {
	PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_0_PROPERTY,
	PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_NUM_PROPERTIES
};
static GParamSpec* photo_photo_transformation_state_impl_properties[PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_NUM_PROPERTIES];
typedef struct _PhotoParamSpecBackingReaders PhotoParamSpecBackingReaders;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _PhotoParamSpecCachedPixbuf PhotoParamSpecCachedPixbuf;
typedef struct _PhotoParamSpecReimportMasterState PhotoParamSpecReimportMasterState;
typedef struct _PhotoParamSpecReimportEditableState PhotoParamSpecReimportEditableState;
typedef struct _PhotoParamSpecReimportRawDevelopmentState PhotoParamSpecReimportRawDevelopmentState;
typedef struct _PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport;
enum  {
	PHOTO_EDITABLE_REPLACED_SIGNAL,
	PHOTO_RAW_DEVELOPMENT_MODIFIED_SIGNAL,
	PHOTO_BASELINE_REPLACED_SIGNAL,
	PHOTO_MASTER_REIMPORTED_SIGNAL,
	PHOTO_EDITABLE_REIMPORTED_SIGNAL,
	PHOTO_BASELINE_REIMPORTED_SIGNAL,
	PHOTO_SOURCE_REIMPORTED_SIGNAL,
	PHOTO_NUM_SIGNALS
};
static guint photo_signals[PHOTO_NUM_SIGNALS] = {0};
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;
typedef struct _MediaSourceCollectionPrivate MediaSourceCollectionPrivate;

#define TYPE_DATABASE_SOURCE_HOLDING_TANK (database_source_holding_tank_get_type ())
#define DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank))
#define DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))
#define IS_DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define IS_DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define DATABASE_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))

typedef struct _DatabaseSourceHoldingTank DatabaseSourceHoldingTank;
typedef struct _DatabaseSourceHoldingTankClass DatabaseSourceHoldingTankClass;

#define TYPE_MEDIA_SOURCE_HOLDING_TANK (media_source_holding_tank_get_type ())
#define MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank))
#define MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))
#define IS_MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define IS_MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define MEDIA_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))

typedef struct _MediaSourceHoldingTank MediaSourceHoldingTank;
typedef struct _MediaSourceHoldingTankClass MediaSourceHoldingTankClass;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;

#define TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION (library_photo_source_collection_get_type ())
#define LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))

typedef struct _LibraryPhotoSourceCollection LibraryPhotoSourceCollection;
typedef struct _LibraryPhotoSourceCollectionClass LibraryPhotoSourceCollectionClass;
typedef struct _LibraryPhotoSourceCollectionPrivate LibraryPhotoSourceCollectionPrivate;

#define LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE (library_photo_source_collection_state_get_type ())
#define _transaction_controller_unref0(var) ((var == NULL) ? NULL : (var = (transaction_controller_unref (var), NULL)))
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))

#define TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK (library_photo_source_holding_tank_get_type ())
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTank))
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTankClass))
#define IS_LIBRARY_PHOTO_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK))
#define IS_LIBRARY_PHOTO_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK))
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTankClass))

typedef struct _LibraryPhotoSourceHoldingTank LibraryPhotoSourceHoldingTank;
typedef struct _LibraryPhotoSourceHoldingTankClass LibraryPhotoSourceHoldingTankClass;

#define TYPE_PHOTO_MONITOR (photo_monitor_get_type ())
#define PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_MONITOR, PhotoMonitor))
#define PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_MONITOR, PhotoMonitorClass))
#define IS_PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_MONITOR))
#define IS_PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_MONITOR))
#define PHOTO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_MONITOR, PhotoMonitorClass))

typedef struct _PhotoMonitor PhotoMonitor;
typedef struct _PhotoMonitorClass PhotoMonitorClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_HIERARCHICAL_TAG_INDEX (hierarchical_tag_index_get_type ())
#define HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndex))
#define HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))
#define IS_HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_TAG_INDEX))
#define IS_HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_TAG_INDEX))
#define HIERARCHICAL_TAG_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))

typedef struct _HierarchicalTagIndex HierarchicalTagIndex;
typedef struct _HierarchicalTagIndexClass HierarchicalTagIndexClass;
#define _hierarchical_tag_index_unref0(var) ((var == NULL) ? NULL : (var = (hierarchical_tag_index_unref (var), NULL)))

#define TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER (media_source_transaction_controller_get_type ())
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))

typedef struct _MediaSourceTransactionController MediaSourceTransactionController;
typedef struct _MediaSourceTransactionControllerClass MediaSourceTransactionControllerClass;
enum  {
	LIBRARY_PHOTO_SOURCE_COLLECTION_MASTER_REIMPORTED_SIGNAL,
	LIBRARY_PHOTO_SOURCE_COLLECTION_EDITABLE_REIMPORTED_SIGNAL,
	LIBRARY_PHOTO_SOURCE_COLLECTION_BASELINE_REIMPORTED_SIGNAL,
	LIBRARY_PHOTO_SOURCE_COLLECTION_SOURCE_REIMPORTED_SIGNAL,
	LIBRARY_PHOTO_SOURCE_COLLECTION_NUM_SIGNALS
};
static guint library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_NUM_SIGNALS] = {0};

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;
typedef struct _LibraryPhotoPrivate LibraryPhotoPrivate;
enum  {
	LIBRARY_PHOTO_0_PROPERTY,
	LIBRARY_PHOTO_NUM_PROPERTIES
};
static GParamSpec* library_photo_properties[LIBRARY_PHOTO_NUM_PROPERTIES];
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;
typedef struct _SourceHoldingTankPrivate SourceHoldingTankPrivate;
typedef struct _DatabaseSourceHoldingTankPrivate DatabaseSourceHoldingTankPrivate;
typedef struct _MediaSourceHoldingTankPrivate MediaSourceHoldingTankPrivate;
typedef struct _LibraryPhotoSourceHoldingTankPrivate LibraryPhotoSourceHoldingTankPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	BACKING_FETCH_MODE_SOURCE,
	BACKING_FETCH_MODE_BASELINE,
	BACKING_FETCH_MODE_MASTER,
	BACKING_FETCH_MODE_UNMODIFIED
} BackingFetchMode;

struct _ImportID {
	gint64 id;
};

typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

struct _PhotoImportParams {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoImportParamsPrivate * priv;
	GFile* file;
	GFile* final_associated_file;
	ImportID import_id;
	PhotoFileSnifferOptions sniffer_options;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* full_md5;
	Thumbnails* thumbnails;
	PhotoRow* row;
	GeeCollection* keywords;
};

struct _PhotoImportParamsClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoImportParams *self);
};

struct _ParamSpecPhotoImportParams {
	GParamSpec parent_instance;
};

struct _PhotoTransformationState {
	GObject parent_instance;
	PhotoTransformationStatePrivate * priv;
};

struct _PhotoTransformationStateClass {
	GObjectClass parent_class;
	void (*broken) (PhotoTransformationState* self);
};

struct _PhotoTransformationStatePrivate {
	gboolean is_broke;
};

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _ThumbnailSource {
	DataSource parent_instance;
	ThumbnailSourcePrivate * priv;
};

struct _ThumbnailSourceClass {
	DataSourceClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailSource* self);
	GdkPixbuf* (*get_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	GdkPixbuf* (*create_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	gchar* (*get_representative_id) (ThumbnailSource* self);
	PhotoFileFormat (*get_preferred_thumbnail_format) (ThumbnailSource* self);
	void (*thumbnail_altered) (ThumbnailSource* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _EventID {
	gint64 id;
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _MediaSource {
	ThumbnailSource parent_instance;
	MediaSourcePrivate * priv;
};

struct _MediaSourceClass {
	ThumbnailSourceClass parent_class;
	void (*notify_master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
	gboolean (*set_event_id) (MediaSource* self, EventID* id);
	gchar* (*get_basename) (MediaSource* self);
	GFile* (*get_file) (MediaSource* self);
	GFile* (*get_master_file) (MediaSource* self);
	guint64 (*get_master_filesize) (MediaSource* self);
	guint64 (*get_filesize) (MediaSource* self);
	time_t (*get_timestamp) (MediaSource* self);
	BackingFileState** (*get_backing_files_state) (MediaSource* self, int* result_length1);
	gchar* (*get_title) (MediaSource* self);
	gchar* (*get_comment) (MediaSource* self);
	void (*set_title) (MediaSource* self, const gchar* title);
	gboolean (*set_comment) (MediaSource* self, const gchar* comment);
	Rating (*get_rating) (MediaSource* self);
	void (*set_rating) (MediaSource* self, Rating rating);
	void (*increase_rating) (MediaSource* self);
	void (*decrease_rating) (MediaSource* self);
	void (*get_dimensions) (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
	GdkPixbuf* (*get_preview_pixbuf) (MediaSource* self, Scaling* scaling, GError** error);
	gboolean (*is_trashed) (MediaSource* self);
	void (*trash) (MediaSource* self);
	void (*untrash) (MediaSource* self);
	gboolean (*is_offline) (MediaSource* self);
	void (*mark_offline) (MediaSource* self);
	void (*mark_online) (MediaSource* self);
	gchar* (*get_master_md5) (MediaSource* self);
	void (*get_event_id) (MediaSource* self, EventID* result);
	time_t (*get_exposure_time) (MediaSource* self);
	void (*get_import_id) (MediaSource* self, ImportID* result);
	void (*master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
};

struct _PhotoSource {
	MediaSource parent_instance;
	PhotoSourcePrivate * priv;
};

struct _PhotoSourceClass {
	MediaSourceClass parent_class;
	PhotoMetadata* (*get_metadata) (PhotoSource* self);
	GdkPixbuf* (*get_pixbuf) (PhotoSource* self, Scaling* scaling, GError** error);
};

struct _DateableIface {
	GTypeInterface parent_iface;
	void (*set_exposure_time) (Dateable* self, time_t target_time);
	time_t (*get_exposure_time) (Dateable* self);
};

typedef enum  {
	ROTATION_CLOCKWISE,
	ROTATION_COUNTERCLOCKWISE,
	ROTATION_MIRROR,
	ROTATION_UPSIDE_DOWN
} Rotation;

struct _Photo {
	PhotoSource parent_instance;
	PhotoPrivate * priv;
	PhotoRow* row;
	gboolean can_rotate_now;
	BackingPhotoRow* backing_photo_row;
};

struct _PhotoClass {
	PhotoSourceClass parent_class;
	void (*notify_editable_replaced) (Photo* self, GFile* old_file, GFile* new_file);
	void (*notify_raw_development_modified) (Photo* self);
	void (*notify_baseline_replaced) (Photo* self);
	void (*notify_master_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_editable_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_source_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_baseline_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*apply_user_metadata_for_reimport) (Photo* self, PhotoMetadata* metadata);
	void (*rotate) (Photo* self, Rotation rotation);
	gboolean (*has_user_generated_metadata) (Photo* self);
	void (*set_user_metadata_for_export) (Photo* self, PhotoMetadata* metadata);
	void (*editable_replaced) (Photo* self, GFile* old_file, GFile* new_file);
	void (*raw_development_modified) (Photo* self);
	void (*baseline_replaced) (Photo* self);
	void (*master_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*editable_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*baseline_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*source_reimported) (Photo* self, PhotoMetadata* metadata);
};

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _PhotoPrivate {
	time_t cached_exposure_time;
	GRecMutex __lock_row;
	BackingPhotoRow* editable;
	PhotoBackingReaders* readers;
	GRecMutex __lock_readers;
	PixelTransformer* transformer;
	PixelTransformationBundle* adjustments;
	gchar* file_title;
	GFileMonitor* editable_monitor;
	OneShotScheduler* reimport_editable_scheduler;
	OneShotScheduler* update_editable_attributes_scheduler;
	OneShotScheduler* remove_editable_scheduler;
	GeeHashMap* developments;
	GRecMutex __lock_developments;
};

struct _PhotoID {
	gint64 id;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

struct _BackingPhotoID {
	gint64 id;
};

struct _PhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoRowPrivate * priv;
	PhotoID photo_id;
	BackingPhotoRow* master;
	time_t exposure_time;
	ImportID import_id;
	EventID event_id;
	Orientation orientation;
	GeeHashMap* transformations;
	gchar* md5;
	gchar* thumbnail_md5;
	gchar* exif_md5;
	time_t time_created;
	guint64 flags;
	Rating rating;
	gchar* title;
	gchar* comment;
	gchar* backlinks;
	time_t time_reimported;
	BackingPhotoID editable_id;
	gboolean metadata_dirty;
	RawDeveloper developer;
	BackingPhotoID* development_ids;
	gint development_ids_length1;
};

struct _PhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoRow *self);
};

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	time_t time_created;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

struct _PhotoBackingReaders {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoBackingReadersPrivate * priv;
	PhotoFileReader* master;
	PhotoFileReader* developer;
	PhotoFileReader* editable;
};

struct _PhotoBackingReadersClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoBackingReaders *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};

typedef enum  {
	PHOTO_FORMAT_ERROR_READ_ONLY
} PhotoFormatError;
#define PHOTO_FORMAT_ERROR photo_format_error_quark ()
typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};

typedef enum  {
	IMPORT_RESULT_SUCCESS,
	IMPORT_RESULT_FILE_ERROR,
	IMPORT_RESULT_DECODE_ERROR,
	IMPORT_RESULT_DATABASE_ERROR,
	IMPORT_RESULT_USER_ABORT,
	IMPORT_RESULT_NOT_A_FILE,
	IMPORT_RESULT_PHOTO_EXISTS,
	IMPORT_RESULT_UNSUPPORTED_FORMAT,
	IMPORT_RESULT_NOT_AN_IMAGE,
	IMPORT_RESULT_DISK_FAILURE,
	IMPORT_RESULT_DISK_FULL,
	IMPORT_RESULT_CAMERA_ERROR,
	IMPORT_RESULT_FILE_WRITE_ERROR,
	IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE
} ImportResult;

typedef enum  {
	PHOTO_FILE_READER_ROLE_DEFAULT,
	PHOTO_FILE_READER_ROLE_THUMBNAIL
} PhotoFileReaderRole;

struct _PhotoReimportMasterState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportMasterStatePrivate * priv;
};

struct _PhotoReimportMasterStateClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportMasterState *self);
};

struct _PhotoReimportMasterStateImpl {
	PhotoReimportMasterState parent_instance;
	PhotoReimportMasterStateImplPrivate * priv;
	PhotoRow* row;
	PhotoMetadata* metadata;
	gchar** alterations;
	gint alterations_length1;
	gint _alterations_size_;
	gboolean metadata_only;
};

struct _PhotoReimportMasterStateImplClass {
	PhotoReimportMasterStateClass parent_class;
};

struct _PhotoReimportEditableState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportEditableStatePrivate * priv;
};

struct _PhotoReimportEditableStateClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportEditableState *self);
};

struct _PhotoReimportEditableStateImpl {
	PhotoReimportEditableState parent_instance;
	PhotoReimportEditableStateImplPrivate * priv;
	BackingPhotoRow* backing_state;
	PhotoMetadata* metadata;
	gboolean metadata_only;
};

struct _PhotoReimportEditableStateImplClass {
	PhotoReimportEditableStateClass parent_class;
};

struct _PhotoReimportRawDevelopmentState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportRawDevelopmentStatePrivate * priv;
};

struct _PhotoReimportRawDevelopmentStateClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportRawDevelopmentState *self);
};

struct _PhotoReimportRawDevelopmentStateImpl {
	PhotoReimportRawDevelopmentState parent_instance;
	PhotoReimportRawDevelopmentStateImplPrivate * priv;
	GeeCollection* list;
	gboolean metadata_only;
};

struct _PhotoReimportRawDevelopmentStateImplClass {
	PhotoReimportRawDevelopmentStateClass parent_class;
};

struct _PhotoReimportRawDevelopmentStateImplDevToReimport {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportRawDevelopmentStateImplDevToReimportPrivate * priv;
	BackingPhotoRow* backing;
	PhotoMetadata* metadata;
};

struct _PhotoReimportRawDevelopmentStateImplDevToReimportClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportRawDevelopmentStateImplDevToReimport *self);
};

typedef enum  {
	PHOTO_METADATA_SET_OPTION_ALL_DOMAINS,
	PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT,
	PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN
} PhotoMetadataSetOption;

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};

struct _EditingToolsRedeyeInstance {
	GdkPoint center;
	gint radius;
};

struct _PhotoCachedPixbuf {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoCachedPixbufPrivate * priv;
	Photo* photo;
	GdkPixbuf* pixbuf;
	GTimer* last_touched;
};

struct _PhotoCachedPixbufClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoCachedPixbuf *self);
};

typedef void (*OneShotCallback) (void* user_data);
struct _PhotoPhotoTransformationStateImpl {
	PhotoTransformationState parent_instance;
	PhotoPhotoTransformationStateImplPrivate * priv;
};

struct _PhotoPhotoTransformationStateImplClass {
	PhotoTransformationStateClass parent_class;
};

struct _PhotoPhotoTransformationStateImplPrivate {
	Photo* photo;
	Orientation orientation;
	GeeHashMap* transformations;
	PixelTransformer* transformer;
	PixelTransformationBundle* adjustments;
};

struct _PhotoParamSpecBackingReaders {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecCachedPixbuf {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportMasterState {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportEditableState {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportRawDevelopmentState {
	GParamSpec parent_instance;
};

struct _PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport {
	GParamSpec parent_instance;
};

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _MediaSourceCollection {
	DatabaseSourceCollection parent_instance;
	MediaSourceCollectionPrivate * priv;
};

struct _MediaSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
	MediaSourceHoldingTank* (*create_trashcan) (MediaSourceCollection* self);
	MediaSourceHoldingTank* (*create_offline_bin) (MediaSourceCollection* self);
	MediaMonitor* (*create_media_monitor) (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable);
	gchar* (*get_typename) (MediaSourceCollection* self);
	gboolean (*is_file_recognized) (MediaSourceCollection* self, GFile* file);
	MediaSource* (*fetch_by_numeric_id) (MediaSourceCollection* self, gint64 numeric_id);
	void (*notify_import_roll_altered) (MediaSourceCollection* self);
	void (*notify_flagged_contents_altered) (MediaSourceCollection* self);
	void (*notify_media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*notify_media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	MediaSource* (*fetch_by_source_id) (MediaSourceCollection* self, const gchar* source_id);
	GeeCollection* (*get_event_source_ids) (MediaSourceCollection* self, EventID* event_id);
	void (*import_many) (MediaSourceCollection* self, GeeCollection* media);
	void (*postprocess_imported_media) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	void (*master_file_replaced) (MediaSourceCollection* self, MediaSource* media, GFile* old_file, GFile* new_file);
	void (*trashcan_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*import_roll_altered) (MediaSourceCollection* self);
	void (*offline_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*flagged_contents_altered) (MediaSourceCollection* self);
	TransactionController* (*get_transaction_controller) (MediaSourceCollection* self);
};

struct _LibraryPhotoSourceCollection {
	MediaSourceCollection parent_instance;
	LibraryPhotoSourceCollectionPrivate * priv;
};

struct _LibraryPhotoSourceCollectionClass {
	MediaSourceCollectionClass parent_class;
	void (*notify_master_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*notify_editable_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*notify_source_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*notify_baseline_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*master_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*editable_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*baseline_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*source_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
};

struct _LibraryPhotoSourceCollectionPrivate {
	TransactionController* _transaction_controller;
	GeeHashMap* by_editable_file;
	GeeHashMap* by_raw_development_file;
	GeeMultiMap* filesize_to_photo;
	GeeHashMap* photo_to_master_filesize;
	GeeHashMap* photo_to_editable_filesize;
	GeeMultiMap* photo_to_raw_development_filesize;
};

typedef enum  {
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_UNKNOWN,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER
} LibraryPhotoSourceCollectionState;

typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, void* user_data);
typedef gboolean (*SourceHoldingTankCheckToKeep) (DataSource* source, Alteration* alteration, void* user_data);
struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _LibraryPhoto {
	Photo parent_instance;
	LibraryPhotoPrivate * priv;
};

struct _LibraryPhotoClass {
	PhotoClass parent_class;
};

struct _LibraryPhotoPrivate {
	gboolean block_thumbnail_generation;
	OneShotScheduler* thumbnail_scheduler;
	GeeCollection* import_keywords;
};

typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 360,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

struct _SourceHoldingTank {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceHoldingTankPrivate * priv;
};

struct _SourceHoldingTankClass {
	GTypeClass parent_class;
	void (*finalize) (SourceHoldingTank *self);
	void (*notify_contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
	void (*contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
};

struct _DatabaseSourceHoldingTank {
	SourceHoldingTank parent_instance;
	DatabaseSourceHoldingTankPrivate * priv;
};

struct _DatabaseSourceHoldingTankClass {
	SourceHoldingTankClass parent_class;
};

struct _MediaSourceHoldingTank {
	DatabaseSourceHoldingTank parent_instance;
	MediaSourceHoldingTankPrivate * priv;
};

struct _MediaSourceHoldingTankClass {
	DatabaseSourceHoldingTankClass parent_class;
};

struct _LibraryPhotoSourceHoldingTank {
	MediaSourceHoldingTank parent_instance;
	LibraryPhotoSourceHoldingTankPrivate * priv;
};

struct _LibraryPhotoSourceHoldingTankClass {
	MediaSourceHoldingTankClass parent_class;
};

struct _LibraryPhotoSourceHoldingTankPrivate {
	GeeHashMap* editable_file_map;
	GeeHashMap* development_file_map;
	GeeMultiMap* reverse_editable_file_map;
	GeeMultiMap* reverse_development_file_map;
};


static gpointer photo_import_params_parent_class = NULL;
static gpointer photo_transformation_state_parent_class = NULL;
static gpointer photo_parent_class = NULL;
static GeeLinkedList* photo_source_pixbuf_cache;
static GRecMutex __lock_photo_source_pixbuf_cache = {0};
static GeeLinkedList* photo_source_pixbuf_cache = NULL;
static guint photo_discard_source_id;
static guint photo_discard_source_id = (guint) 0;
static gboolean photo__develop_raw_photos_to_files;
static gboolean photo__develop_raw_photos_to_files = FALSE;
static gpointer photo_photo_transformation_state_impl_parent_class = NULL;
static gpointer photo_backing_readers_parent_class = NULL;
static gpointer photo_cached_pixbuf_parent_class = NULL;
static gpointer photo_reimport_master_state_parent_class = NULL;
static gpointer photo_reimport_master_state_impl_parent_class = NULL;
static gpointer photo_reimport_editable_state_parent_class = NULL;
static gpointer photo_reimport_editable_state_impl_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_impl_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_impl_dev_to_reimport_parent_class = NULL;
static DateableIface * photo_dateable_parent_iface = NULL;
static gpointer library_photo_source_collection_parent_class = NULL;
static gpointer library_photo_parent_class = NULL;
extern LibraryPhotoSourceCollection* library_photo_global;
LibraryPhotoSourceCollection* library_photo_global = NULL;
extern TagSourceCollection* tag_global;
static FlaggableIface * library_photo_flaggable_parent_iface = NULL;
static MonitorableIface * library_photo_monitorable_parent_iface = NULL;
static gpointer library_photo_source_holding_tank_parent_class = NULL;

GType backing_fetch_mode_get_type (void) G_GNUC_CONST;
gpointer photo_import_params_ref (gpointer instance);
void photo_import_params_unref (gpointer instance);
GParamSpec* param_spec_photo_import_params (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void value_set_photo_import_params (GValue* value,
                                    gpointer v_object);
void value_take_photo_import_params (GValue* value,
                                     gpointer v_object);
gpointer value_get_photo_import_params (const GValue* value);
GType photo_import_params_get_type (void) G_GNUC_CONST;
GType import_id_get_type (void) G_GNUC_CONST;
ImportID* import_id_dup (const ImportID* self);
void import_id_free (ImportID* self);
GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST;
gpointer thumbnails_ref (gpointer instance);
void thumbnails_unref (gpointer instance);
GParamSpec* param_spec_thumbnails (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_thumbnails (GValue* value,
                           gpointer v_object);
void value_take_thumbnails (GValue* value,
                            gpointer v_object);
gpointer value_get_thumbnails (const GValue* value);
GType thumbnails_get_type (void) G_GNUC_CONST;
gpointer photo_row_ref (gpointer instance);
void photo_row_unref (gpointer instance);
GParamSpec* param_spec_photo_row (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_photo_row (GValue* value,
                          gpointer v_object);
void value_take_photo_row (GValue* value,
                           gpointer v_object);
gpointer value_get_photo_row (const GValue* value);
GType photo_row_get_type (void) G_GNUC_CONST;
PhotoRow* photo_row_new (void);
PhotoRow* photo_row_construct (GType object_type);
PhotoImportParams* photo_import_params_new (GFile* file,
                                            GFile* final_associated_file,
                                            ImportID* import_id,
                                            PhotoFileSnifferOptions sniffer_options,
                                            const gchar* exif_md5,
                                            const gchar* thumbnail_md5,
                                            const gchar* full_md5,
                                            Thumbnails* thumbnails);
PhotoImportParams* photo_import_params_construct (GType object_type,
                                                  GFile* file,
                                                  GFile* final_associated_file,
                                                  ImportID* import_id,
                                                  PhotoFileSnifferOptions sniffer_options,
                                                  const gchar* exif_md5,
                                                  const gchar* thumbnail_md5,
                                                  const gchar* full_md5,
                                                  Thumbnails* thumbnails);
PhotoImportParams* photo_import_params_new_create_placeholder (GFile* file,
                                                               ImportID* import_id);
PhotoImportParams* photo_import_params_construct_create_placeholder (GType object_type,
                                                                     GFile* file,
                                                                     ImportID* import_id);
static void photo_import_params_finalize (PhotoImportParams * obj);
GType photo_transformation_state_get_type (void) G_GNUC_CONST;
#define PHOTO_TRANSFORMATION_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationStatePrivate))
PhotoTransformationState* photo_transformation_state_construct (GType object_type);
gboolean photo_transformation_state_is_broken (PhotoTransformationState* self);
static void photo_transformation_state_real_broken (PhotoTransformationState* self);
static void photo_transformation_state_finalize (GObject * obj);
GType rating_get_type (void) G_GNUC_CONST;
gboolean rating_can_increase (Rating self);
gboolean rating_can_decrease (Rating self);
gboolean rating_is_valid (Rating self);
Rating rating_increase (Rating self);
Rating rating_decrease (Rating self);
gint rating_serialize (Rating self);
Rating rating_unserialize (gint value);
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_alteration (GValue* value,
                           gpointer v_object);
void value_take_alteration (GValue* value,
                            gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void value_set_source_holding_tank (GValue* value,
                                    gpointer v_object);
void value_take_source_holding_tank (GValue* value,
                                     gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
gpointer source_snapshot_ref (gpointer instance);
void source_snapshot_unref (gpointer instance);
GParamSpec* param_spec_source_snapshot (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_source_snapshot (GValue* value,
                                gpointer v_object);
void value_take_source_snapshot (GValue* value,
                                 gpointer v_object);
gpointer value_get_source_snapshot (const GValue* value);
GType source_snapshot_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType indexable_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
gpointer backing_file_state_ref (gpointer instance);
void backing_file_state_unref (gpointer instance);
GParamSpec* param_spec_backing_file_state (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_backing_file_state (GValue* value,
                                   gpointer v_object);
void value_take_backing_file_state (GValue* value,
                                    gpointer v_object);
gpointer value_get_backing_file_state (const GValue* value);
GType backing_file_state_get_type (void) G_GNUC_CONST;
GType photo_exception_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
GType photo_source_get_type (void) G_GNUC_CONST;
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_media_metadata (GValue* value,
                               gpointer v_object);
void value_take_media_metadata (GValue* value,
                                gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
GType dateable_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType rotation_get_type (void) G_GNUC_CONST;
gpointer backing_photo_row_ref (gpointer instance);
void backing_photo_row_unref (gpointer instance);
GParamSpec* param_spec_backing_photo_row (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
void value_set_backing_photo_row (GValue* value,
                                  gpointer v_object);
void value_take_backing_photo_row (GValue* value,
                                   gpointer v_object);
gpointer value_get_backing_photo_row (const GValue* value);
GType backing_photo_row_get_type (void) G_GNUC_CONST;
static gpointer photo_backing_readers_ref (gpointer instance);
static void photo_backing_readers_unref (gpointer instance);
static GParamSpec* photo_param_spec_backing_readers (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags) G_GNUC_UNUSED;
static void photo_value_set_backing_readers (GValue* value,
                                      gpointer v_object) G_GNUC_UNUSED;
static void photo_value_take_backing_readers (GValue* value,
                                       gpointer v_object) G_GNUC_UNUSED;
static gpointer photo_value_get_backing_readers (const GValue* value) G_GNUC_UNUSED;
static GType photo_backing_readers_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
gpointer one_shot_scheduler_ref (gpointer instance);
void one_shot_scheduler_unref (gpointer instance);
GParamSpec* param_spec_one_shot_scheduler (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_one_shot_scheduler (GValue* value,
                                   gpointer v_object);
void value_take_one_shot_scheduler (GValue* value,
                                    gpointer v_object);
gpointer value_get_one_shot_scheduler (const GValue* value);
GType one_shot_scheduler_get_type (void) G_GNUC_CONST;
GType raw_developer_get_type (void) G_GNUC_CONST;
#define PHOTO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO, PhotoPrivate))
gboolean photo_exception_prohibits (PhotoException self,
                                    PhotoException exception);
gboolean photo_exception_allows (PhotoException self,
                                 PhotoException exception);
static gpointer photo_cached_pixbuf_ref (gpointer instance);
static void photo_cached_pixbuf_unref (gpointer instance);
static GParamSpec* photo_param_spec_cached_pixbuf (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags) G_GNUC_UNUSED;
static void photo_value_set_cached_pixbuf (GValue* value,
                                    gpointer v_object) G_GNUC_UNUSED;
static void photo_value_take_cached_pixbuf (GValue* value,
                                     gpointer v_object) G_GNUC_UNUSED;
static gpointer photo_value_get_cached_pixbuf (const GValue* value) G_GNUC_UNUSED;
static GType photo_cached_pixbuf_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
BackingPhotoRow* backing_photo_row_new (void);
BackingPhotoRow* backing_photo_row_construct (GType object_type);
static PhotoBackingReaders* photo_backing_readers_new (void);
static PhotoBackingReaders* photo_backing_readers_construct (GType object_type);
#define PHOTO_TYPENAME "thumb"
#define PHOTO_SCALING_FUDGE 64
#define PHOTO_SOURCE_PIXBUF_TIME_TO_LIVE_SEC 10
#define PHOTO_SOURCE_PIXBUF_MIN_LRU_COUNT 1
#define PHOTO_SOURCE_PIXBUF_MAX_LRU_COUNT 3
#define PHOTO_MIN_EMBEDDED_SIZE 1024
Photo* photo_construct (GType object_type,
                        PhotoRow* row);
#define DATA_OBJECT_INVALID_OBJECT_ID ((gint64) -1)
PhotoSource* photo_source_construct (GType object_type,
                                     gint64 object_id);
gchar* media_source_prep_title (const gchar* title);
GType photo_id_get_type (void) G_GNUC_CONST;
PhotoID* photo_id_dup (const PhotoID* self);
void photo_id_free (PhotoID* self);
GType orientation_get_type (void) G_GNUC_CONST;
GType backing_photo_id_get_type (void) G_GNUC_CONST;
BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
void backing_photo_id_free (BackingPhotoID* self);
gchar* media_source_prep_comment (const gchar* comment);
gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_photo_file_adapter (GValue* value,
                                   gpointer v_object);
void value_take_photo_file_adapter (GValue* value,
                                    gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_reader_get_type (void) G_GNUC_CONST;
PhotoFileReader* photo_file_format_create_reader (PhotoFileFormat self,
                                                  const gchar* filepath);
gchar* string_sliced_at_last_char (const gchar* haystack,
                                   gunichar ch,
                                   gint start_index);
gchar* string_sliced_at (const gchar* str,
                         gint index);
gboolean is_string_empty (const gchar* s);
#define BACKING_PHOTO_ID_INVALID ((gint64) -1)
static BackingPhotoRow* photo_get_backing_row (Photo* self,
                                        BackingPhotoID* id);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_database_table (GValue* value,
                               gpointer v_object);
void value_take_database_table (GValue* value,
                                gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType photo_table_get_type (void) G_GNUC_CONST;
PhotoTable* photo_table_get_instance (void);
GQuark database_error_quark (void);
void photo_table_detach_editable (PhotoTable* self,
                                  PhotoRow* row,
                                  GError** error);
static void photo_internal_remove_all_transformations (Photo* self,
                                                gboolean notify);
RawDeveloper* raw_developer_as_array (int* result_length1);
void photo_init_photo (void);
void photo_terminate_photo (void);
void photo_notify_editable_replaced (Photo* self,
                                     GFile* old_file,
                                     GFile* new_file);
static void photo_real_notify_editable_replaced (Photo* self,
                                          GFile* old_file,
                                          GFile* new_file);
void photo_notify_raw_development_modified (Photo* self);
static void photo_real_notify_raw_development_modified (Photo* self);
void photo_notify_baseline_replaced (Photo* self);
static void photo_real_notify_baseline_replaced (Photo* self);
void photo_notify_master_reimported (Photo* self,
                                     PhotoMetadata* metadata);
static void photo_real_notify_master_reimported (Photo* self,
                                          PhotoMetadata* metadata);
void photo_notify_editable_reimported (Photo* self,
                                       PhotoMetadata* metadata);
static void photo_real_notify_editable_reimported (Photo* self,
                                            PhotoMetadata* metadata);
void photo_notify_source_reimported (Photo* self,
                                     PhotoMetadata* metadata);
static void photo_real_notify_source_reimported (Photo* self,
                                          PhotoMetadata* metadata);
void photo_notify_baseline_reimported (Photo* self,
                                       PhotoMetadata* metadata);
static void photo_real_notify_baseline_reimported (Photo* self,
                                            PhotoMetadata* metadata);
static gboolean photo_real_internal_delete_backing (DataSource* base,
                                             GError** error);
GFile* photo_file_adapter_get_file (PhotoFileAdapter* self);
static void photo_detach_editable (Photo* self,
                            gboolean delete_editable,
                            gboolean remove_transformations,
                            gboolean notify);
PhotoFileFormat photo_get_master_file_format (Photo* self);
static gboolean photo_delete_raw_development (Photo* self,
                                       RawDeveloper d);
gchar* data_object_to_string (DataObject* self);
gboolean data_source_internal_delete_backing (DataSource* self,
                                              GError** error);
GType backing_photo_table_get_type (void) G_GNUC_CONST;
BackingPhotoTable* backing_photo_table_get_instance (void);
BackingPhotoRow* backing_photo_table_fetch (BackingPhotoTable* self,
                                            BackingPhotoID* id,
                                            GError** error);
void backing_photo_table_remove (BackingPhotoTable* self,
                                 BackingPhotoID* backing_id,
                                 GError** error);
gboolean photo_is_raw_developer_complete (Photo* self,
                                          RawDeveloper d);
gboolean photo_is_raw_developer_available (Photo* self,
                                           RawDeveloper d);
PhotoMetadata* photo_get_master_metadata (Photo* self,
                                          GError** error);
guint photo_metadata_get_preview_count (PhotoMetadata* self);
gpointer photo_preview_ref (gpointer instance);
void photo_preview_unref (gpointer instance);
GParamSpec* param_spec_photo_preview (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void value_set_photo_preview (GValue* value,
                              gpointer v_object);
void value_take_photo_preview (GValue* value,
                               gpointer v_object);
gpointer value_get_photo_preview (const GValue* value);
GType photo_preview_get_type (void) G_GNUC_CONST;
PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self,
                                          guint number);
void photo_preview_get_pixel_dimensions (PhotoPreview* self,
                                         Dimensions* result);
void photo_add_backing_photo_for_development (Photo* self,
                                              RawDeveloper d,
                                              BackingPhotoRow* bpr,
                                              gboolean notify,
                                              GError** error);
void photo_import_developed_backing_photo (PhotoRow* row,
                                           RawDeveloper d,
                                           BackingPhotoRow* bpr,
                                           GError** error);
void data_object_notify_altered (DataObject* self,
                                 Alteration* alteration);
Alteration* alteration_new (const gchar* subject,
                            const gchar* detail);
Alteration* alteration_construct (GType object_type,
                                  const gchar* subject,
                                  const gchar* detail);
#define UTIL_FILE_ATTRIBUTES "standard::*,time::*,id::file,id::filesystem,etag::value"
#define DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES UTIL_FILE_ATTRIBUTES
gpointer photo_file_interrogator_ref (gpointer instance);
void photo_file_interrogator_unref (gpointer instance);
GParamSpec* param_spec_photo_file_interrogator (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
void value_set_photo_file_interrogator (GValue* value,
                                        gpointer v_object);
void value_take_photo_file_interrogator (GValue* value,
                                         gpointer v_object);
gpointer value_get_photo_file_interrogator (const GValue* value);
GType photo_file_interrogator_get_type (void) G_GNUC_CONST;
PhotoFileInterrogator* photo_file_interrogator_new (GFile* file,
                                                    PhotoFileSnifferOptions options);
PhotoFileInterrogator* photo_file_interrogator_construct (GType object_type,
                                                          GFile* file,
                                                          PhotoFileSnifferOptions options);
void photo_file_interrogator_interrogate (PhotoFileInterrogator* self,
                                          GError** error);
gpointer detected_photo_information_ref (gpointer instance);
void detected_photo_information_unref (gpointer instance);
GParamSpec* param_spec_detected_photo_information (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
void value_set_detected_photo_information (GValue* value,
                                           gpointer v_object);
void value_take_detected_photo_information (GValue* value,
                                            gpointer v_object);
gpointer value_get_detected_photo_information (const GValue* value);
GType detected_photo_information_get_type (void) G_GNUC_CONST;
DetectedPhotoInformation* photo_file_interrogator_get_detected_photo_information (PhotoFileInterrogator* self);
gboolean photo_file_interrogator_get_is_photo_corrupted (PhotoFileInterrogator* self);
Orientation photo_metadata_get_orientation (PhotoMetadata* self);
void backing_photo_table_add (BackingPhotoTable* self,
                              BackingPhotoRow* state,
                              GError** error);
void photo_table_update_raw_development (PhotoTable* self,
                                         PhotoRow* row,
                                         RawDeveloper rd,
                                         BackingPhotoID* backing_photo_id,
                                         GError** error);
static void photo_develop_photo (Photo* self,
                          RawDeveloper d,
                          gboolean notify);
BackingPhotoRow* raw_developer_create_backing_row_for_development (RawDeveloper self,
                                                                   const gchar* raw_filepath,
                                                                   const gchar* camera_development_filename,
                                                                   GError** error);
GdkPixbuf* photo_get_master_pixbuf (Photo* self,
                                    Scaling* scaling,
                                    gboolean rotate,
                                    GError** error);
void scaling_for_original (Scaling* result);
GType photo_file_writer_get_type (void) G_GNUC_CONST;
GQuark photo_format_error_quark (void);
PhotoFileWriter* photo_file_format_create_writer (PhotoFileFormat self,
                                                  const gchar* filepath,
                                                  GError** error);
GType jpeg_quality_get_type (void) G_GNUC_CONST;
void photo_file_writer_write (PhotoFileWriter* self,
                              GdkPixbuf* pixbuf,
                              JpegQuality quality,
                              GError** error);
GType photo_file_metadata_writer_get_type (void) G_GNUC_CONST;
PhotoFileMetadataWriter* photo_file_format_create_metadata_writer (PhotoFileFormat self,
                                                                   const gchar* filepath,
                                                                   GError** error);
void photo_file_metadata_writer_write_metadata (PhotoFileMetadataWriter* self,
                                                PhotoMetadata* metadata,
                                                GError** error);
GBytes* photo_preview_flatten (PhotoPreview* self,
                               GError** error);
gboolean jpeg_is_jpeg_bytes (GBytes* bytes,
                             GError** error);
GdkPixbuf* photo_preview_get_pixbuf (PhotoPreview* self,
                                     GError** error);
void photo_set_default_raw_developer (Photo* self,
                                      RawDeveloper d);
void photo_set_raw_developer (Photo* self,
                              RawDeveloper d,
                              gboolean notify);
void photo_revert_to_master (Photo* self,
                             gboolean notify);
GdkPixbuf* photo_get_prefetched_copy (Photo* self,
                                      GError** error);
gboolean photo_set_orientation (Photo* self,
                                Orientation orientation);
void photo_discard_prefetched (Photo* self);
RawDeveloper photo_get_raw_developer (Photo* self);
gchar* raw_developer_to_string (RawDeveloper self);
void photo_table_remove_development (PhotoTable* self,
                                     PhotoRow* row,
                                     RawDeveloper rd,
                                     GError** error);
void photo_redevelop_raw (Photo* self,
                          RawDeveloper d);
static BackingFileState** photo_real_get_backing_files_state (MediaSource* base,
                                                       int* result_length1);
BackingFileState* backing_file_state_new_from_photo_row (BackingPhotoRow* photo_row,
                                                         const gchar* md5);
BackingFileState* backing_file_state_construct_from_photo_row (GType object_type,
                                                               BackingPhotoRow* photo_row,
                                                               const gchar* md5);
static void _vala_array_add88 (BackingFileState** * array,
                        int* length,
                        int* size,
                        BackingFileState* value);
gboolean photo_has_editable (Photo* self);
static void _vala_array_add89 (BackingFileState** * array,
                        int* length,
                        int* size,
                        BackingFileState* value);
gboolean photo_is_developed (Photo* self);
GeeCollection* photo_get_raw_development_photo_rows (Photo* self);
static void _vala_array_add90 (BackingFileState** * array,
                        int* length,
                        int* size,
                        BackingFileState* value);
static PhotoFileReader* photo_get_backing_reader (Photo* self,
                                           BackingFetchMode mode);
static PhotoFileReader* photo_get_master_reader (Photo* self);
static PhotoFileReader* photo_get_baseline_reader (Photo* self);
static PhotoFileReader* photo_get_source_reader (Photo* self);
static PhotoFileReader* photo_get_raw_developer_reader (Photo* self);
const gchar* backing_fetch_mode_to_string (BackingFetchMode self);
PhotoFileReader* photo_get_editable_reader (Photo* self);
gboolean photo_does_master_exist (Photo* self);
gboolean photo_file_adapter_file_exists (PhotoFileAdapter* self);
gboolean photo_does_editable_exist (Photo* self);
gboolean photo_is_master_baseline (Photo* self);
gboolean photo_is_master_source (Photo* self);
gboolean photo_is_editable_baseline (Photo* self);
gboolean photo_is_editable_source (Photo* self);
BackingPhotoRow* photo_get_master_photo_row (Photo* self);
BackingPhotoRow* photo_get_editable_photo_row (Photo* self);
gboolean backing_photo_id_is_valid (BackingPhotoID *self);
BackingPhotoRow* photo_get_raw_development_photo_row (Photo* self,
                                                      RawDeveloper d);
PhotoFileFormat* photo_get_editable_file_format (Photo* self);
PhotoFileFormat photo_file_adapter_get_file_format (PhotoFileAdapter* self);
static PhotoFileFormat* _photo_file_format_dup (PhotoFileFormat* self);
GType export_format_parameters_get_type (void) G_GNUC_CONST;
GType export_format_mode_get_type (void) G_GNUC_CONST;
ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
void export_format_parameters_free (ExportFormatParameters* self);
PhotoFileFormat photo_get_export_format_for_parameters (Photo* self,
                                                        ExportFormatParameters* params);
PhotoFileFormat photo_file_format_get_system_default_format (void);
PhotoFileFormat photo_get_best_export_file_format (Photo* self);
gchar* photo_get_export_basename_for_parameters (Photo* self,
                                                 ExportFormatParameters* params);
GFile* media_source_get_master_file (MediaSource* self);
gchar* photo_get_export_basename (Photo* self,
                                  PhotoFileFormat* file_format);
GType import_result_get_type (void) G_GNUC_CONST;
ImportResult photo_prepare_for_import (PhotoImportParams* params);
gboolean photo_is_file_image (GFile* file);
gboolean photo_file_format_is_file_supported (GFile* file);
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_metadata_date_time (GValue* value,
                                   gpointer v_object);
void value_take_metadata_date_time (GValue* value,
                                    gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self);
time_t metadata_date_time_get_timestamp (MetadataDateTime* self);
gchar* media_metadata_get_title (MediaMetadata* self);
gchar* media_metadata_get_comment (MediaMetadata* self);
GeeSet* photo_metadata_get_keywords (PhotoMetadata* self,
                                     GCompareDataFunc compare_func,
                                     void* compare_func_target,
                                     GDestroyNotify compare_func_target_destroy_notify);
Rating photo_metadata_get_rating (PhotoMetadata* self);
#define PHOTO_ID_INVALID ((gint64) -1)
void photo_id_init (PhotoID *self,
                    gint64 id);
#define EVENT_ID_INVALID ((gint64) -1)
void event_id_init (EventID *self,
                    gint64 id);
GType photo_file_reader_role_get_type (void) G_GNUC_CONST;
void photo_file_reader_set_role (PhotoFileReader* self,
                                 PhotoFileReaderRole role);
void thumbnail_cache_generate_for_photo (Thumbnails* thumbnails,
                                         PhotoFileReader* reader,
                                         Orientation orientation,
                                         Dimensions* original_dim,
                                         GError** error);
ImportResult import_result_convert_error (GError* err,
                                          ImportResult default_result);
void photo_create_pre_import (PhotoImportParams* params);
void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
BackingPhotoRow* photo_query_backing_photo_row (Photo* self,
                                                GFile* file,
                                                PhotoFileSnifferOptions options,
                                                DetectedPhotoInformation* * detected,
                                                GError** error);
gpointer photo_reimport_master_state_ref (gpointer instance);
void photo_reimport_master_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_master_state (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
void photo_value_set_reimport_master_state (GValue* value,
                                            gpointer v_object);
void photo_value_take_reimport_master_state (GValue* value,
                                             gpointer v_object);
gpointer photo_value_get_reimport_master_state (const GValue* value);
GType photo_reimport_master_state_get_type (void) G_GNUC_CONST;
gboolean photo_prepare_for_reimport_master (Photo* self,
                                            PhotoReimportMasterState* * reimport_state,
                                            GError** error);
static void _vala_array_add91 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add92 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add93 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add94 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add95 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add96 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static PhotoReimportMasterStateImpl* photo_reimport_master_state_impl_new (PhotoRow* row,
                                                                    PhotoMetadata* metadata,
                                                                    gchar** alterations,
                                                                    int alterations_length1);
static PhotoReimportMasterStateImpl* photo_reimport_master_state_impl_construct (GType object_type,
                                                                          PhotoRow* row,
                                                                          PhotoMetadata* metadata,
                                                                          gchar** alterations,
                                                                          int alterations_length1);
static GType photo_reimport_master_state_impl_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void photo_apply_user_metadata_for_reimport (Photo* self,
                                             PhotoMetadata* metadata);
static void photo_real_apply_user_metadata_for_reimport (Photo* self,
                                                  PhotoMetadata* metadata);
void photo_finish_reimport_master (Photo* self,
                                   PhotoReimportMasterState* state,
                                   GError** error);
void photo_table_reimport (PhotoTable* self,
                           PhotoRow* row,
                           GError** error);
void backing_photo_row_copy_from (BackingPhotoRow* self,
                                  BackingPhotoRow* from);
static void _vala_array_add97 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add98 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
Alteration* alteration_new_from_array (gchar** array,
                                       int array_length1);
Alteration* alteration_construct_from_array (GType object_type,
                                             gchar** array,
                                             int array_length1);
static gboolean photo_verify_file_for_reimport (Photo* self,
                                         GFile* file,
                                         BackingPhotoRow* * backing,
                                         DetectedPhotoInformation* * detected,
                                         GError** error);
gpointer photo_reimport_editable_state_ref (gpointer instance);
void photo_reimport_editable_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_editable_state (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags);
void photo_value_set_reimport_editable_state (GValue* value,
                                              gpointer v_object);
void photo_value_take_reimport_editable_state (GValue* value,
                                               gpointer v_object);
gpointer photo_value_get_reimport_editable_state (const GValue* value);
GType photo_reimport_editable_state_get_type (void) G_GNUC_CONST;
gboolean photo_prepare_for_reimport_editable (Photo* self,
                                              PhotoReimportEditableState* * state,
                                              GError** error);
GFile* photo_get_editable_file (Photo* self);
static PhotoReimportEditableStateImpl* photo_reimport_editable_state_impl_new (BackingPhotoRow* backing_state,
                                                                        PhotoMetadata* metadata);
static PhotoReimportEditableStateImpl* photo_reimport_editable_state_impl_construct (GType object_type,
                                                                              BackingPhotoRow* backing_state,
                                                                              PhotoMetadata* metadata);
static GType photo_reimport_editable_state_impl_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void photo_finish_reimport_editable (Photo* self,
                                     PhotoReimportEditableState* state,
                                     GError** error);
void photo_get_editable_id (Photo* self,
                            BackingPhotoID* result);
gboolean backing_photo_id_is_invalid (BackingPhotoID *self);
void backing_photo_table_update (BackingPhotoTable* self,
                                 BackingPhotoRow* row,
                                 GError** error);
void media_source_set_title (MediaSource* self,
                             const gchar* title);
gboolean media_source_set_comment (MediaSource* self,
                                   const gchar* comment);
void media_source_set_rating (MediaSource* self,
                              Rating rating);
Alteration* alteration_new_from_list (const gchar* list);
Alteration* alteration_construct_from_list (GType object_type,
                                            const gchar* list);
gpointer photo_reimport_raw_development_state_ref (gpointer instance);
void photo_reimport_raw_development_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_raw_development_state (const gchar* name,
                                                             const gchar* nick,
                                                             const gchar* blurb,
                                                             GType object_type,
                                                             GParamFlags flags);
void photo_value_set_reimport_raw_development_state (GValue* value,
                                                     gpointer v_object);
void photo_value_take_reimport_raw_development_state (GValue* value,
                                                      gpointer v_object);
gpointer photo_value_get_reimport_raw_development_state (const GValue* value);
GType photo_reimport_raw_development_state_get_type (void) G_GNUC_CONST;
gboolean photo_prepare_for_reimport_raw_development (Photo* self,
                                                     PhotoReimportRawDevelopmentState* * state,
                                                     GError** error);
GeeCollection* photo_get_raw_developer_files (Photo* self);
static GType photo_reimport_raw_development_state_impl_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static PhotoReimportRawDevelopmentStateImpl* photo_reimport_raw_development_state_impl_new (void);
static PhotoReimportRawDevelopmentStateImpl* photo_reimport_raw_development_state_impl_construct (GType object_type);
static void photo_reimport_raw_development_state_impl_add (PhotoReimportRawDevelopmentStateImpl* self,
                                                    BackingPhotoRow* backing,
                                                    PhotoMetadata* metadata);
static gint photo_reimport_raw_development_state_impl_get_size (PhotoReimportRawDevelopmentStateImpl* self);
void photo_finish_reimport_raw_development (Photo* self,
                                            PhotoReimportRawDevelopmentState* state,
                                            GError** error);
static gpointer photo_reimport_raw_development_state_impl_dev_to_reimport_ref (gpointer instance);
static void photo_reimport_raw_development_state_impl_dev_to_reimport_unref (gpointer instance);
static GParamSpec* photo_reimport_raw_development_state_impl_param_spec_dev_to_reimport (const gchar* name,
                                                                                  const gchar* nick,
                                                                                  const gchar* blurb,
                                                                                  GType object_type,
                                                                                  GParamFlags flags) G_GNUC_UNUSED;
static void photo_reimport_raw_development_state_impl_value_set_dev_to_reimport (GValue* value,
                                                                          gpointer v_object) G_GNUC_UNUSED;
static void photo_reimport_raw_development_state_impl_value_take_dev_to_reimport (GValue* value,
                                                                           gpointer v_object) G_GNUC_UNUSED;
static gpointer photo_reimport_raw_development_state_impl_value_get_dev_to_reimport (const GValue* value) G_GNUC_UNUSED;
GType photo_reimport_raw_development_state_impl_dev_to_reimport_get_type (void) G_GNUC_CONST;
static gchar* photo_real_get_typename (DataSource* base);
static gint64 photo_real_get_instance_id (DataSource* base);
void photo_get_photo_id (Photo* self,
                         PhotoID* result);
static gchar* photo_real_get_source_id (DataSource* base);
gchar* data_source_get_typename (DataSource* self);
gint64 data_source_get_instance_id (DataSource* self);
void photo_set_master_timestamp (Photo* self,
                                 GFileInfo* info);
void photo_table_update_timestamp (PhotoTable* self,
                                   PhotoID* photo_id,
                                   time_t timestamp,
                                   GError** error);
void app_window_database_error (GError* err);
void photo_update_editable_modification_time (Photo* self,
                                              GFileInfo* info,
                                              GError** error);
void backing_photo_table_update_timestamp (BackingPhotoTable* self,
                                           BackingPhotoID* id,
                                           time_t timestamp,
                                           GError** error);
void photo_update_many_editable_timestamps (GeeMap* map,
                                            GError** error);
void database_table_begin_transaction (void);
void database_table_commit_transaction (GError** error);
static PhotoFileFormat photo_real_get_preferred_thumbnail_format (ThumbnailSource* base);
PhotoFileFormat photo_get_file_format (Photo* self);
gboolean photo_file_format_can_write_image (PhotoFileFormat self);
static GdkPixbuf* photo_real_create_thumbnail (ThumbnailSource* base,
                                        gint scale,
                                        GError** error);
GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self,
                                    Scaling* scaling,
                                    GError** error);
void scaling_for_best_fit (gint pixels,
                           gboolean scale_up,
                           Scaling* result);
static gboolean photo_is_extension_found (const gchar* basename,
                                   gchar** extensions,
                                   int extensions_length1);
void disassemble_filename (const gchar* basename,
                           gchar* * name,
                           gchar* * ext);
gboolean photo_is_duplicate (GFile* file,
                             const gchar* thumbnail_md5,
                             const gchar* full_md5,
                             PhotoFileFormat file_format);
gboolean photo_table_has_duplicate (PhotoTable* self,
                                    GFile* file,
                                    const gchar* thumbnail_md5,
                                    const gchar* md5,
                                    PhotoFileFormat file_format);
PhotoID* photo_get_duplicate_ids (GFile* file,
                                  const gchar* thumbnail_md5,
                                  const gchar* full_md5,
                                  PhotoFileFormat file_format,
                                  int* result_length1);
PhotoID* photo_table_get_duplicate_ids (PhotoTable* self,
                                        GFile* file,
                                        const gchar* thumbnail_md5,
                                        const gchar* md5,
                                        PhotoFileFormat file_format,
                                        int* result_length1);
gint64 photo_get_photo_key (DataSource* source);
GType library_photo_get_type (void) G_GNUC_CONST;
static GFile* photo_real_get_file (MediaSource* base);
void photo_set_master_file (Photo* self,
                            GFile* file);
void photo_table_set_filepath (PhotoTable* self,
                               PhotoID* photo_id,
                               const gchar* filepath,
                               GError** error);
void media_source_notify_master_replaced (MediaSource* self,
                                          GFile* old_file,
                                          GFile* new_file);
static void _vala_array_add99 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add100 (gchar** * array,
                         int* length,
                         int* size,
                         gchar* value);
static void _vala_array_add101 (gchar** * array,
                         int* length,
                         int* size,
                         gchar* value);
static void _vala_array_add102 (gchar** * array,
                         int* length,
                         int* size,
                         gchar* value);
void photo_set_editable_file (Photo* self,
                              GFile* file);
void backing_photo_table_set_filepath (BackingPhotoTable* self,
                                       BackingPhotoID* id,
                                       const gchar* filepath,
                                       GError** error);
static void _vala_array_add103 (gchar** * array,
                         int* length,
                         int* size,
                         gchar* value);
static void _vala_array_add104 (gchar** * array,
                         int* length,
                         int* size,
                         gchar* value);
static void _vala_array_add105 (gchar** * array,
                         int* length,
                         int* size,
                         gchar* value);
void photo_set_many_editable_file (GeeMap* map,
                                   GError** error);
GFile* photo_get_actual_file (Photo* self);
static GFile* photo_real_get_master_file (MediaSource* base);
GFile* photo_get_source_file (Photo* self);
gboolean photo_file_format_can_write (PhotoFileFormat self);
static time_t photo_real_get_timestamp (MediaSource* base);
static inline void photo_real_get_event_id (MediaSource* base,
                              EventID* result);
gint64 photo_get_raw_event_id (Photo* self);
static void photo_real_get_import_id (MediaSource* base,
                               ImportID* result);
static gchar* photo_real_get_master_md5 (MediaSource* base);
guint64 photo_get_flags (Photo* self);
static void photo_notify_flags_altered (Photo* self,
                                 Alteration* additional_alteration);
Alteration* alteration_compress (Alteration* self,
                                 Alteration* other);
guint64 photo_replace_flags (Photo* self,
                             guint64 flags,
                             Alteration* additional_alteration);
gboolean photo_table_replace_flags (PhotoTable* self,
                                    PhotoID* photo_id,
                                    guint64 flags);
gboolean photo_is_flag_set (Photo* self,
                            guint64 mask);
gboolean media_source_internal_is_flag_set (guint64 flags,
                                            guint64 selector);
guint64 photo_add_flags (Photo* self,
                         guint64 mask,
                         Alteration* additional_alteration);
guint64 media_source_internal_add_flags (guint64 flags,
                                         guint64 selector);
guint64 photo_remove_flags (Photo* self,
                            guint64 mask,
                            Alteration* additional_alteration);
guint64 media_source_internal_remove_flags (guint64 flags,
                                            guint64 selector);
guint64 photo_add_remove_flags (Photo* self,
                                guint64 add,
                                guint64 remove,
                                Alteration* additional_alteration);
void photo_add_remove_many_flags (GeeCollection* add,
                                  guint64 add_mask,
                                  Alteration* additional_add_alteration,
                                  GeeCollection* remove,
                                  guint64 remove_mask,
                                  Alteration* additional_remove_alteration,
                                  GError** error);
guint64 photo_toggle_flags (Photo* self,
                            guint64 mask,
                            Alteration* additional_alteration);
gboolean photo_is_master_metadata_dirty (Photo* self);
void photo_set_master_metadata_dirty (Photo* self,
                                      gboolean dirty,
                                      GError** error);
void photo_table_set_metadata_dirty (PhotoTable* self,
                                     PhotoID* photo_id,
                                     gboolean dirty,
                                     GError** error);
static Rating photo_real_get_rating (MediaSource* base);
static void photo_real_set_rating (MediaSource* base,
                            Rating rating);
gboolean photo_table_set_rating (PhotoTable* self,
                                 PhotoID* photo_id,
                                 Rating rating);
static void photo_real_increase_rating (MediaSource* base);
static void photo_real_decrease_rating (MediaSource* base);
static void photo_real_commit_backlinks (DataSource* base,
                                  SourceCollection* sources,
                                  const gchar* backlinks);
void photo_table_update_backlinks (PhotoTable* self,
                                   PhotoID* photo_id,
                                   const gchar* backlinks,
                                   GError** error);
static gboolean photo_real_set_event_id (MediaSource* base,
                                  EventID* event_id);
gboolean photo_table_set_event (PhotoTable* self,
                                PhotoID* photo_id,
                                EventID* event_id);
static gchar* photo_real_to_string (DataObject* base);
gchar* photo_file_adapter_get_filepath (PhotoFileAdapter* self);
static gboolean photo_real_equals (DataSource* base,
                            DataSource* source);
gboolean data_source_equals (DataSource* self,
                             DataSource* source);
static void photo_file_exif_updated (Photo* self);
GFile* media_source_get_file (MediaSource* self);
gboolean photo_table_master_exif_updated (PhotoTable* self,
                                          PhotoID* photoID,
                                          gint64 filesize,
                                          glong timestamp,
                                          const gchar* md5,
                                          const gchar* exif_md5,
                                          const gchar* thumbnail_md5,
                                          PhotoRow* row);
static guint64 photo_real_get_filesize (MediaSource* base);
static guint64 photo_real_get_master_filesize (MediaSource* base);
guint64 photo_get_editable_filesize (Photo* self);
static time_t photo_real_get_exposure_time (Dateable* base);
static gchar* photo_real_get_basename (MediaSource* base);
static gchar* photo_real_get_title (MediaSource* base);
static gchar* photo_real_get_comment (MediaSource* base);
static void photo_real_set_title (MediaSource* base,
                           const gchar* title);
gboolean photo_table_set_title (PhotoTable* self,
                                PhotoID* photo_id,
                                const gchar* new_title);
static gboolean photo_real_set_comment (MediaSource* base,
                                 const gchar* comment);
gboolean photo_table_set_comment (PhotoTable* self,
                                  PhotoID* photo_id,
                                  const gchar* new_comment);
void photo_set_import_id (Photo* self,
                          ImportID* import_id);
void photo_table_set_import_id (PhotoTable* self,
                                PhotoID* photo_id,
                                ImportID* import_id,
                                GError** error);
void photo_set_title_persistent (Photo* self,
                                 const gchar* title,
                                 GError** error);
gboolean photo_file_format_can_write_metadata (PhotoFileFormat self);
PhotoMetadata* photo_file_reader_read_metadata (PhotoFileReader* self,
                                                GError** error);
GType photo_metadata_set_option_get_type (void) G_GNUC_CONST;
void photo_metadata_set_title (PhotoMetadata* self,
                               const gchar* title,
                               PhotoMetadataSetOption option);
PhotoFileMetadataWriter* photo_file_reader_create_metadata_writer (PhotoFileReader* self,
                                                                   GError** error);
void library_monitor_blacklist_file (GFile* file,
                                     const gchar* reason);
void library_monitor_unblacklist_file (GFile* file);
void photo_set_comment_persistent (Photo* self,
                                   const gchar* comment,
                                   GError** error);
void photo_metadata_set_comment (PhotoMetadata* self,
                                 const gchar* comment,
                                 PhotoMetadataSetOption option);
static void photo_real_set_exposure_time (Dateable* base,
                                   time_t time);
gboolean photo_table_set_exposure_time (PhotoTable* self,
                                        PhotoID* photo_id,
                                        time_t time);
void photo_set_exposure_time_persistent (Photo* self,
                                         time_t time,
                                         GError** error);
void dateable_set_exposure_time (Dateable* self,
                                 time_t target_time);
void photo_metadata_set_exposure_date_time (PhotoMetadata* self,
                                            MetadataDateTime* date_time,
                                            PhotoMetadataSetOption option);
MetadataDateTime* metadata_date_time_new (time_t timestamp);
MetadataDateTime* metadata_date_time_construct (GType object_type,
                                                time_t timestamp);
static void photo_real_get_dimensions (MediaSource* base,
                                PhotoException disallowed_steps,
                                Dimensions* result);
void photo_get_raw_dimensions (Photo* self,
                               Dimensions* result);
Orientation photo_get_orientation (Photo* self);
gboolean photo_get_straighten (Photo* self,
                               gdouble* theta);
void compute_arb_rotated_size (gdouble src_width,
                               gdouble src_height,
                               gdouble angle,
                               gdouble* dest_width,
                               gdouble* dest_height);
GType box_get_type (void) G_GNUC_CONST;
Box* box_dup (const Box* self);
void box_free (Box* self);
gboolean photo_get_crop (Photo* self,
                         Box* crop,
                         PhotoException exceptions);
void box_get_dimensions (Box *self,
                         Dimensions* result);
static void photo_locked_create_adjustments_from_data (Photo* self);
static KeyValueMap* photo_get_transformation (Photo* self,
                                       const gchar* name);
PixelTransformationBundle* photo_get_color_adjustments (Photo* self);
PixelTransformer* photo_get_pixel_transformer (Photo* self);
gboolean photo_has_color_adjustments (Photo* self);
static gboolean photo_has_transformation (Photo* self,
                                   const gchar* name);
PixelTransformation* photo_get_color_adjustment (Photo* self,
                                                 PixelTransformationType type);
void photo_set_color_adjustments (Photo* self,
                                  PixelTransformationBundle* new_adjustments);
static gboolean photo_remove_transformation (Photo* self,
                                      const gchar* name);
static gboolean photo_set_transformation (Photo* self,
                                   KeyValueMap* trans);
static PhotoMetadata* photo_real_get_metadata (PhotoSource* base);
PhotoMetadata* photo_get_editable_metadata (Photo* self,
                                            GError** error);
gboolean photo_persist_master_metadata (Photo* self,
                                        PhotoMetadata* metadata,
                                        PhotoReimportMasterState* * state,
                                        GError** error);
void photo_finish_update_master_metadata (Photo* self,
                                          PhotoReimportMasterState* state,
                                          GError** error);
gboolean photo_persist_editable_metadata (Photo* self,
                                          PhotoMetadata* metadata,
                                          PhotoReimportEditableState* * state,
                                          GError** error);
void photo_finish_update_editable_metadata (Photo* self,
                                            PhotoReimportEditableState* state,
                                            GError** error);
gboolean photo_has_transformations (Photo* self);
gboolean photo_only_metadata_changed (Photo* self);
PhotoMetadata* photo_source_get_metadata (PhotoSource* self);
gboolean photo_has_alterations (Photo* self);
gchar* media_source_get_comment (MediaSource* self);
gchar* media_source_get_title (MediaSource* self);
PhotoTransformationState* photo_save_transformation_state (Photo* self);
static PhotoPhotoTransformationStateImpl* photo_photo_transformation_state_impl_new (Photo* photo,
                                                                              Orientation orientation,
                                                                              GeeHashMap* transformations,
                                                                              PixelTransformer* transformer,
                                                                              PixelTransformationBundle* adjustments);
static PhotoPhotoTransformationStateImpl* photo_photo_transformation_state_impl_construct (GType object_type,
                                                                                    Photo* photo,
                                                                                    Orientation orientation,
                                                                                    GeeHashMap* transformations,
                                                                                    PixelTransformer* transformer,
                                                                                    PixelTransformationBundle* adjustments);
static GType photo_photo_transformation_state_impl_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
gboolean photo_load_transformation_state (Photo* self,
                                          PhotoTransformationState* state);
static Orientation photo_photo_transformation_state_impl_get_orientation (PhotoPhotoTransformationStateImpl* self);
static GeeHashMap* photo_photo_transformation_state_impl_get_transformations (PhotoPhotoTransformationStateImpl* self);
static PixelTransformer* photo_photo_transformation_state_impl_get_transformer (PhotoPhotoTransformationStateImpl* self);
static PixelTransformationBundle* photo_photo_transformation_state_impl_get_color_adjustments (PhotoPhotoTransformationStateImpl* self);
gboolean photo_table_set_transformation_state (PhotoTable* self,
                                               PhotoID* photo_id,
                                               Orientation orientation,
                                               GeeHashMap* transformations);
void photo_remove_all_transformations (Photo* self);
gboolean photo_table_remove_all_transformations (PhotoTable* self,
                                                 PhotoID* photo_id);
gboolean photo_table_set_orientation (PhotoTable* self,
                                      PhotoID* photo_id,
                                      Orientation orientation);
Orientation photo_get_original_orientation (Photo* self);
gboolean photo_check_can_rotate (Photo* self);
void photo_rotate (Photo* self,
                   Rotation rotation);
static void photo_real_rotate (Photo* self,
                        Rotation rotation);
Orientation orientation_perform (Orientation self,
                                 Rotation rotation);
gboolean photo_table_set_transformation (PhotoTable* self,
                                         PhotoID* photo_id,
                                         KeyValueMap* map);
gboolean photo_table_remove_transformation (PhotoTable* self,
                                            PhotoID* photo_id,
                                            const gchar* object);
gboolean photo_has_crop (Photo* self);
gboolean photo_get_raw_crop (Photo* self,
                             Box* crop);
void box_init (Box *self,
               gint left,
               gint top,
               gint right,
               gint bottom);
static void photo_set_raw_crop (Photo* self,
                         Box* crop);
static gboolean photo_get_raw_straighten (Photo* self,
                                   gdouble* angle);
static void photo_set_raw_straighten (Photo* self,
                               gdouble theta);
GType editing_tools_redeye_instance_get_type (void) G_GNUC_CONST;
EditingToolsRedeyeInstance* editing_tools_redeye_instance_dup (const EditingToolsRedeyeInstance* self);
void editing_tools_redeye_instance_free (EditingToolsRedeyeInstance* self);
static EditingToolsRedeyeInstance* photo_get_raw_redeye_instances (Photo* self,
                                                            int* result_length1);
gboolean photo_has_redeye_transformations (Photo* self);
void photo_add_redeye_instance (Photo* self,
                                EditingToolsRedeyeInstance* redeye);
static gboolean photo_calculate_pixbuf_dimensions (Photo* self,
                                            Scaling* scaling,
                                            PhotoException exceptions,
                                            Dimensions* scaled_image,
                                            Dimensions* scaled_to_viewport);
static gboolean photo_locked_calculate_pixbuf_dimensions (Photo* self,
                                                   Scaling* scaling,
                                                   PhotoException exceptions,
                                                   Dimensions* scaled_image,
                                                   Dimensions* scaled_to_viewport);
gboolean scaling_is_unscaled (Scaling *self);
void orientation_rotate_box (Orientation self,
                             Dimensions* space,
                             Box* box,
                             Box* result);
void orientation_rotate_dimensions (Orientation self,
                                    Dimensions* dim,
                                    Dimensions* result);
void box_get_scaled (Box *self,
                     Dimensions* scaled,
                     Box* result);
void scaling_get_scaled_dimensions (Scaling *self,
                                    Dimensions* original,
                                    Dimensions* result);
gint box_get_width (Box *self);
gint box_get_height (Box *self);
void dimensions_get_scaled_similar (Dimensions *self,
                                    Dimensions* original,
                                    Dimensions* scaled,
                                    Dimensions* result);
void orientation_derotate_dimensions (Orientation self,
                                      Dimensions* dim,
                                      Dimensions* result);
gboolean dimensions_has_area (Dimensions *self);
static GdkPixbuf* photo_load_raw_pixbuf (Photo* self,
                                  Scaling* scaling,
                                  PhotoException exceptions,
                                  BackingFetchMode fetch_mode,
                                  GError** error);
GdkPixbuf* photo_file_reader_unscaled_read (PhotoFileReader* self,
                                            GError** error);
GdkPixbuf* photo_file_reader_scaled_read (PhotoFileReader* self,
                                          Dimensions* full,
                                          Dimensions* scaled,
                                          GError** error);
gboolean dimensions_approx_equals (Dimensions *self,
                                   Dimensions* dim,
                                   gint fudge);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
static GdkPixbuf* photo_get_untransformed_pixbuf (Photo* self,
                                           Scaling* scaling,
                                           gboolean rotate,
                                           BackingFetchMode fetch_mode,
                                           GError** error);
GdkPixbuf* photo_get_unmodified_pixbuf (Photo* self,
                                        Scaling* scaling,
                                        gboolean rotate,
                                        GError** error);
GdkPixbuf* orientation_rotate_pixbuf (Orientation self,
                                      GdkPixbuf* pixbuf);
static GdkPixbuf* photo_real_get_pixbuf (PhotoSource* base,
                                  Scaling* scaling,
                                  GError** error);
GdkPixbuf* photo_get_pixbuf_with_options (Photo* self,
                                          Scaling* scaling,
                                          PhotoException exceptions,
                                          BackingFetchMode fetch_mode,
                                          GError** error);
static GdkPixbuf* photo_run_source_pixbuf_cache (Photo* locate,
                                          gboolean keep,
                                          GError** error);
static PhotoCachedPixbuf* photo_cached_pixbuf_new (Photo* photo,
                                            GdkPixbuf* pixbuf);
static PhotoCachedPixbuf* photo_cached_pixbuf_construct (GType object_type,
                                                  Photo* photo,
                                                  GdkPixbuf* pixbuf);
static gboolean photo_trim_source_pixbuf_cache (void);
static gboolean _photo_trim_source_pixbuf_cache_gsource_func (gpointer self);
gboolean photo_get_develop_raw_photos_to_files (void);
void media_source_get_dimensions (MediaSource* self,
                                  PhotoException disallowed_steps,
                                  Dimensions* result);
gboolean dimensions_equals (Dimensions *self,
                            Dimensions* dim);
static GdkPixbuf* photo_do_redeye (Photo* self,
                            GdkPixbuf* pixbuf,
                            EditingToolsRedeyeInstance* inst);
GdkPixbuf* rotate_arb (GdkPixbuf* source_pixbuf,
                       gdouble angle);
gboolean photo_has_user_generated_metadata (Photo* self);
static gboolean photo_real_has_user_generated_metadata (Photo* self);
void photo_set_user_metadata_for_export (Photo* self,
                                         PhotoMetadata* metadata);
static void photo_real_set_user_metadata_for_export (Photo* self,
                                              PhotoMetadata* metadata);
gpointer photo_file_format_properties_ref (gpointer instance);
void photo_file_format_properties_unref (gpointer instance);
GParamSpec* param_spec_photo_file_format_properties (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags);
void value_set_photo_file_format_properties (GValue* value,
                                             gpointer v_object);
void value_take_photo_file_format_properties (GValue* value,
                                              gpointer v_object);
gpointer value_get_photo_file_format_properties (const GValue* value);
GType photo_file_format_properties_get_type (void) G_GNUC_CONST;
PhotoFileFormatProperties* photo_file_format_get_properties (PhotoFileFormat self);
GFile* photo_file_format_properties_convert_file_extension (PhotoFileFormatProperties* self,
                                                            GFile* file);
static gboolean photo_export_fullsized_backing (Photo* self,
                                         GFile* file,
                                         gboolean export_metadata,
                                         GError** error);
PhotoMetadata* photo_file_format_create_metadata (PhotoFileFormat self);
time_t media_source_get_exposure_time (MediaSource* self);
void photo_metadata_set_pixel_dimensions (PhotoMetadata* self,
                                          Dimensions* dim,
                                          PhotoMetadataSetOption option);
void photo_metadata_set_orientation (PhotoMetadata* self,
                                     Orientation orientation);
void photo_metadata_set_software (PhotoMetadata* self,
                                  const gchar* software,
                                  const gchar* version);
#define RESOURCES_APP_TITLE "Shotwell"
#define RESOURCES_APP_VERSION _VERSION
void photo_metadata_remove_exif_thumbnail (PhotoMetadata* self);
void photo_metadata_clear (PhotoMetadata* self);
gboolean photo_is_export_required (Photo* self,
                                   Scaling* scaling,
                                   PhotoFileFormat export_format);
void photo_export (Photo* self,
                   GFile* dest_file,
                   Scaling* scaling,
                   JpegQuality quality,
                   PhotoFileFormat export_format,
                   gboolean direct_copy_unmodified,
                   gboolean export_metadata,
                   GError** error);
const gchar* photo_file_format_to_string (PhotoFileFormat self);
void photo_metadata_remove_tag (PhotoMetadata* self,
                                const gchar* tag);
static GFile* photo_generate_new_editable_file (Photo* self,
                                         PhotoFileFormat* file_format,
                                         GError** error);
gboolean photo_file_format_properties_is_recognized_extension (PhotoFileFormatProperties* self,
                                                               const gchar* ext);
gchar* photo_file_format_properties_get_default_extension (PhotoFileFormatProperties* self);
GFile* generate_unique_file (GFile* dir,
                             const gchar* basename,
                             gboolean* collision,
                             GError** error);
static gboolean photo_launch_editor (GFile* file,
                              PhotoFileFormat file_format,
                              GError** error);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self);
gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
void photo_open_with_raw_external_editor (Photo* self,
                                          GError** error);
void photo_open_with_external_editor (Photo* self,
                                      GError** error);
static void photo_halt_monitoring_editable (Photo* self);
static void photo_attach_editable (Photo* self,
                            PhotoFileFormat file_format,
                            GFile* file,
                            GError** error);
static void photo_start_monitoring_editable (Photo* self,
                                      GFile* file,
                                      GError** error);
static void photo_on_editable_file_changed (Photo* self,
                                     GFile* file,
                                     GFile* other_file,
                                     GFileMonitorEvent event);
static void _photo_on_editable_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                             GFile* file,
                                                             GFile* other_file,
                                                             GFileMonitorEvent event_type,
                                                             gpointer self);
static void photo_update_editable (Photo* self,
                            gboolean only_attributes,
                            PhotoFileReader* new_reader,
                            GError** error);
static void photo_update_editable_attributes (Photo* self,
                                       GError** error);
void photo_reimport_editable (Photo* self,
                              GError** error);
void photo_table_attach_editable (PhotoTable* self,
                                  PhotoRow* row,
                                  BackingPhotoID* editable_id,
                                  GError** error);
void backing_photo_table_update_attributes (BackingPhotoTable* self,
                                            BackingPhotoID* id,
                                            time_t timestamp,
                                            gint64 filesize,
                                            GError** error);
static void _vala_array_add106 (gchar** * array,
                         int* length,
                         int* size,
                         gchar* value);
static void _vala_array_add107 (gchar** * array,
                         int* length,
                         int* size,
                         gchar* value);
static void _vala_array_add108 (gchar** * array,
                         int* length,
                         int* size,
                         gchar* value);
static void _vala_array_add109 (gchar** * array,
                         int* length,
                         int* size,
                         gchar* value);
static void _vala_array_add110 (gchar** * array,
                         int* length,
                         int* size,
                         gchar* value);
static void _vala_array_add111 (gchar** * array,
                         int* length,
                         int* size,
                         gchar* value);
void backing_photo_id_init (BackingPhotoID *self,
                            gint64 id);
const gchar* g_file_monitor_event_to_string (GFileMonitorEvent self);
static void photo_on_reimport_editable (Photo* self);
static void _photo_on_reimport_editable_one_shot_callback (gpointer self);
OneShotScheduler* one_shot_scheduler_new (const gchar* name,
                                          OneShotCallback callback,
                                          void* callback_target);
OneShotScheduler* one_shot_scheduler_construct (GType object_type,
                                                const gchar* name,
                                                OneShotCallback callback,
                                                void* callback_target);
void one_shot_scheduler_after_timeout (OneShotScheduler* self,
                                       guint msec,
                                       gboolean reschedule);
static void photo_on_update_editable_attributes (Photo* self);
static void _photo_on_update_editable_attributes_one_shot_callback (gpointer self);
static void photo_on_remove_editable (Photo* self);
static void _photo_on_remove_editable_one_shot_callback (gpointer self);
void photo_get_original_dimensions (Photo* self,
                                    Dimensions* result);
void photo_get_master_dimensions (Photo* self,
                                  Dimensions* result);
void photo_set_crop (Photo* self,
                     Box* crop);
void orientation_derotate_box (Orientation self,
                               Dimensions* space,
                               Box* box,
                               Box* result);
void photo_set_straighten (Photo* self,
                           gdouble theta);
static GdkPixbuf* photo_red_reduce_pixel (Photo* self,
                                   GdkPixbuf* pixbuf,
                                   gint x,
                                   gint y);
void photo_unscaled_to_raw_point (Photo* self,
                                  GdkPoint* unscaled_point,
                                  GdkPoint* result);
void orientation_derotate_point (Orientation self,
                                 Dimensions* space,
                                 GdkPoint* point,
                                 GdkPoint* result);
void photo_unscaled_to_raw_rect (Photo* self,
                                 GdkRectangle* unscaled_rect,
                                 GdkRectangle* result);
PixelTransformationBundle* photo_get_enhance_transformations (Photo* self);
gboolean photo_enhance (Photo* self);
void photo_set_develop_raw_photos_to_files (gboolean value);
static void photo_real_editable_replaced (Photo* self,
                                   GFile* old_file,
                                   GFile* new_file);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void photo_real_raw_development_modified (Photo* self);
static void photo_real_baseline_replaced (Photo* self);
static void photo_real_master_reimported (Photo* self,
                                   PhotoMetadata* metadata);
static void g_cclosure_user_marshal_VOID__MEDIA_METADATA (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void photo_real_editable_reimported (Photo* self,
                                     PhotoMetadata* metadata);
static void photo_real_baseline_reimported (Photo* self,
                                     PhotoMetadata* metadata);
static void photo_real_source_reimported (Photo* self,
                                   PhotoMetadata* metadata);
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImplPrivate))
static void photo_photo_transformation_state_impl_on_photo_baseline_replaced (PhotoPhotoTransformationStateImpl* self);
static void _photo_photo_transformation_state_impl_on_photo_baseline_replaced_photo_baseline_replaced (Photo* _sender,
                                                                                                gpointer self);
static GeeHashMap* photo_photo_transformation_state_impl_copy_transformations (GeeHashMap* original);
static void photo_photo_transformation_state_impl_finalize (GObject * obj);
static void photo_backing_readers_finalize (PhotoBackingReaders * obj);
static void photo_cached_pixbuf_finalize (PhotoCachedPixbuf * obj);
PhotoReimportMasterState* photo_reimport_master_state_construct (GType object_type);
static void photo_reimport_master_state_finalize (PhotoReimportMasterState * obj);
static gchar** _vala_array_dup24 (gchar** self,
                           int length);
static void photo_reimport_master_state_impl_finalize (PhotoReimportMasterState * obj);
PhotoReimportEditableState* photo_reimport_editable_state_construct (GType object_type);
static void photo_reimport_editable_state_finalize (PhotoReimportEditableState * obj);
static void photo_reimport_editable_state_impl_finalize (PhotoReimportEditableState * obj);
PhotoReimportRawDevelopmentState* photo_reimport_raw_development_state_construct (GType object_type);
static void photo_reimport_raw_development_state_finalize (PhotoReimportRawDevelopmentState * obj);
static PhotoReimportRawDevelopmentStateImplDevToReimport* photo_reimport_raw_development_state_impl_dev_to_reimport_new (BackingPhotoRow* backing,
                                                                                                                  PhotoMetadata* metadata);
static PhotoReimportRawDevelopmentStateImplDevToReimport* photo_reimport_raw_development_state_impl_dev_to_reimport_construct (GType object_type,
                                                                                                                        BackingPhotoRow* backing,
                                                                                                                        PhotoMetadata* metadata);
static void photo_reimport_raw_development_state_impl_dev_to_reimport_finalize (PhotoReimportRawDevelopmentStateImplDevToReimport * obj);
static void photo_reimport_raw_development_state_impl_finalize (PhotoReimportRawDevelopmentState * obj);
static void photo_finalize (GObject * obj);
static void _vala_photo_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec);
static void _vala_photo_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec);
GType marker_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_source_backlink (GValue* value,
                                gpointer v_object);
void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType media_source_collection_get_type (void) G_GNUC_CONST;
GType database_source_holding_tank_get_type (void) G_GNUC_CONST;
GType media_source_holding_tank_get_type (void) G_GNUC_CONST;
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_workers (GValue* value,
                        gpointer v_object);
void value_take_workers (GValue* value,
                         gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
GType media_monitor_get_type (void) G_GNUC_CONST;
gpointer transaction_controller_ref (gpointer instance);
void transaction_controller_unref (gpointer instance);
GParamSpec* param_spec_transaction_controller (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void value_set_transaction_controller (GValue* value,
                                       gpointer v_object);
void value_take_transaction_controller (GValue* value,
                                        gpointer v_object);
gpointer value_get_transaction_controller (const GValue* value);
GType transaction_controller_get_type (void) G_GNUC_CONST;
GType library_photo_source_collection_get_type (void) G_GNUC_CONST;
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionPrivate))
GType library_photo_source_collection_state_get_type (void) G_GNUC_CONST;
guint file_hash (GFile* file);
static guint _file_hash_gee_hash_data_func (gconstpointer v,
                                     gpointer self);
gboolean file_equal (GFile* a,
                     GFile* b);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a,
                                          gconstpointer b,
                                          gpointer self);
gint int64_compare (gint64* a,
                    gint64* b);
static gint _int64_compare_gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self);
static gint64* _int64_dup (gint64* self);
gboolean int64_equal (gint64* a,
                      gint64* b);
static gboolean _int64_equal_gee_equal_data_func (gconstpointer a,
                                           gconstpointer b,
                                           gpointer self);
LibraryPhotoSourceCollection* library_photo_source_collection_new (void);
LibraryPhotoSourceCollection* library_photo_source_collection_construct (GType object_type);
static gint64 _photo_get_photo_key_get_source_database_key (DataSource* source,
                                                     gpointer self);
MediaSourceCollection* media_source_collection_construct (GType object_type,
                                                          const gchar* name,
                                                          GetSourceDatabaseKey source_key_func,
                                                          void* source_key_func_target);
MediaSourceHoldingTank* media_source_collection_get_trashcan (MediaSourceCollection* self);
static void library_photo_source_collection_on_trashcan_contents_altered (LibraryPhotoSourceCollection* self,
                                                                   GeeCollection* added,
                                                                   GeeCollection* removed);
static void _library_photo_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                         GeeCollection* added,
                                                                                                         GeeCollection* removed,
                                                                                                         gpointer self);
MediaSourceHoldingTank* media_source_collection_get_offline_bin (MediaSourceCollection* self);
static void library_photo_source_collection_on_offline_contents_altered (LibraryPhotoSourceCollection* self,
                                                                  GeeCollection* added,
                                                                  GeeCollection* removed);
static void _library_photo_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                        GeeCollection* added,
                                                                                                        GeeCollection* removed,
                                                                                                        gpointer self);
static MediaSourceHoldingTank* library_photo_source_collection_real_create_trashcan (MediaSourceCollection* base);
static gboolean library_photo_source_collection_check_if_trashed_photo (LibraryPhotoSourceCollection* self,
                                                                 DataSource* source,
                                                                 Alteration* alteration);
static gboolean _library_photo_source_collection_check_if_trashed_photo_source_holding_tank_check_to_keep (DataSource* source,
                                                                                                    Alteration* alteration,
                                                                                                    gpointer self);
LibraryPhotoSourceHoldingTank* library_photo_source_holding_tank_new (LibraryPhotoSourceCollection* sources,
                                                                      SourceHoldingTankCheckToKeep check_to_keep,
                                                                      void* check_to_keep_target,
                                                                      GetSourceDatabaseKey get_key,
                                                                      void* get_key_target);
LibraryPhotoSourceHoldingTank* library_photo_source_holding_tank_construct (GType object_type,
                                                                            LibraryPhotoSourceCollection* sources,
                                                                            SourceHoldingTankCheckToKeep check_to_keep,
                                                                            void* check_to_keep_target,
                                                                            GetSourceDatabaseKey get_key,
                                                                            void* get_key_target);
GType library_photo_source_holding_tank_get_type (void) G_GNUC_CONST;
static MediaSourceHoldingTank* library_photo_source_collection_real_create_offline_bin (MediaSourceCollection* base);
static gboolean library_photo_source_collection_check_if_offline_photo (LibraryPhotoSourceCollection* self,
                                                                 DataSource* source,
                                                                 Alteration* alteration);
static gboolean _library_photo_source_collection_check_if_offline_photo_source_holding_tank_check_to_keep (DataSource* source,
                                                                                                    Alteration* alteration,
                                                                                                    gpointer self);
static MediaMonitor* library_photo_source_collection_real_create_media_monitor (MediaSourceCollection* base,
                                                                         Workers* workers,
                                                                         GCancellable* cancellable);
PhotoMonitor* photo_monitor_new (Workers* workers,
                                 GCancellable* cancellable);
PhotoMonitor* photo_monitor_construct (GType object_type,
                                       Workers* workers,
                                       GCancellable* cancellable);
GType photo_monitor_get_type (void) G_GNUC_CONST;
static gboolean library_photo_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                                    DataSource* source);
static gchar* library_photo_source_collection_real_get_typename (MediaSourceCollection* base);
static gboolean library_photo_source_collection_real_is_file_recognized (MediaSourceCollection* base,
                                                                  GFile* file);
static void library_photo_source_collection_real_notify_contents_altered (DataCollection* base,
                                                                   GeeIterable* added,
                                                                   GeeIterable* removed);
static void library_photo_source_collection_on_editable_replaced (LibraryPhotoSourceCollection* self,
                                                           Photo* photo,
                                                           GFile* old_file,
                                                           GFile* new_file);
static void _library_photo_source_collection_on_editable_replaced_photo_editable_replaced (Photo* _sender,
                                                                                    GFile* old_file,
                                                                                    GFile* new_file,
                                                                                    gpointer self);
static void library_photo_source_collection_on_raw_development_modified (LibraryPhotoSourceCollection* self,
                                                                  Photo* _photo);
static void _library_photo_source_collection_on_raw_development_modified_photo_raw_development_modified (Photo* _sender,
                                                                                                  gpointer self);
void data_collection_notify_contents_altered (DataCollection* self,
                                              GeeIterable* added,
                                              GeeIterable* removed);
static void library_photo_source_collection_real_items_altered (DataCollection* base,
                                                         GeeMap* items);
gboolean alteration_has_detail (Alteration* self,
                                const gchar* subject,
                                const gchar* detail);
static void library_photo_source_collection_real_postprocess_imported_media (MediaSourceCollection* base,
                                                                      GeeCollection* media_sources);
GType tag_get_type (void) G_GNUC_CONST;
gpointer hierarchical_tag_index_ref (gpointer instance);
void hierarchical_tag_index_unref (gpointer instance);
GParamSpec* param_spec_hierarchical_tag_index (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void value_set_hierarchical_tag_index (GValue* value,
                                       gpointer v_object);
void value_take_hierarchical_tag_index (GValue* value,
                                        gpointer v_object);
gpointer value_get_hierarchical_tag_index (const GValue* value);
GType hierarchical_tag_index_get_type (void) G_GNUC_CONST;
HierarchicalTagIndex* hierarchical_tag_index_get_global_index (void);
gboolean photo_metadata_has_hierarchical_keywords (PhotoMetadata* self);
HierarchicalTagIndex* hierarchical_tag_utilities_process_hierarchical_import_keywords (GeeCollection* h_keywords);
GeeSet* photo_metadata_get_hierarchical_keywords (PhotoMetadata* self);
GeeCollection* library_photo_get_import_keywords (LibraryPhoto* self);
gboolean hierarchical_tag_index_is_tag_in_index (HierarchicalTagIndex* self,
                                                 const gchar* tag);
gchar* tag_prep_tag_name (const gchar* name);
gchar* hierarchical_tag_index_get_path_for_name (HierarchicalTagIndex* self,
                                                 const gchar* name);
Tag* tag_for_path (const gchar* name);
GeeCollection* hierarchical_tag_index_get_all_paths (HierarchicalTagIndex* self);
void library_photo_clear_import_keywords (LibraryPhoto* self);
void tag_attach_many (Tag* self,
                      GeeCollection* sources);
void media_source_collection_postprocess_imported_media (MediaSourceCollection* self,
                                                         GeeCollection* media);
void library_photo_source_collection_notify_master_reimported (LibraryPhotoSourceCollection* self,
                                                               LibraryPhoto* photo,
                                                               PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_master_reimported (LibraryPhotoSourceCollection* self,
                                                                    LibraryPhoto* photo,
                                                                    PhotoMetadata* metadata);
void library_photo_source_collection_notify_editable_reimported (LibraryPhotoSourceCollection* self,
                                                                 LibraryPhoto* photo,
                                                                 PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_editable_reimported (LibraryPhotoSourceCollection* self,
                                                                      LibraryPhoto* photo,
                                                                      PhotoMetadata* metadata);
void library_photo_source_collection_notify_source_reimported (LibraryPhotoSourceCollection* self,
                                                               LibraryPhoto* photo,
                                                               PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_source_reimported (LibraryPhotoSourceCollection* self,
                                                                    LibraryPhoto* photo,
                                                                    PhotoMetadata* metadata);
void library_photo_source_collection_notify_baseline_reimported (LibraryPhotoSourceCollection* self,
                                                                 LibraryPhoto* photo,
                                                                 PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_baseline_reimported (LibraryPhotoSourceCollection* self,
                                                                      LibraryPhoto* photo,
                                                                      PhotoMetadata* metadata);
static MediaSource* library_photo_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base,
                                                                       gint64 numeric_id);
LibraryPhoto* library_photo_source_collection_fetch (LibraryPhotoSourceCollection* self,
                                                     PhotoID* photo_id);
gboolean media_source_is_trashed (MediaSource* self);
gboolean media_source_is_offline (MediaSource* self);
static MediaSource* library_photo_source_collection_real_fetch_by_source_id (MediaSourceCollection* base,
                                                                      const gchar* source_id);
MediaSource* media_source_collection_fetch_by_numeric_id (MediaSourceCollection* self,
                                                          gint64 numeric_id);
gint64 parse_int64 (const gchar* str,
                    gint num_base);
static GeeCollection* library_photo_source_collection_real_get_event_source_ids (MediaSourceCollection* base,
                                                                          EventID* event_id);
GeeArrayList* photo_table_get_event_source_ids (PhotoTable* self,
                                                EventID* event_id);
DataSource* database_source_collection_fetch_by_key (DatabaseSourceCollection* self,
                                                     gint64 key);
LibraryPhoto* library_photo_source_collection_fetch_by_editable_file (LibraryPhotoSourceCollection* self,
                                                                      GFile* file);
LibraryPhoto* library_photo_source_collection_fetch_by_raw_development_file (LibraryPhotoSourceCollection* self,
                                                                             GFile* file);
static void library_photo_source_collection_compare_backing (LibraryPhotoSourceCollection* self,
                                                      LibraryPhoto* photo,
                                                      GFileInfo* info,
                                                      GeeCollection* matches_master,
                                                      GeeCollection* matches_editable,
                                                      GeeCollection* matches_development);
gboolean backing_photo_row_matches_file_info (BackingPhotoRow* self,
                                              GFileInfo* info);
void library_photo_source_collection_fetch_by_matching_backing (LibraryPhotoSourceCollection* self,
                                                                GFileInfo* info,
                                                                GeeCollection* matches_master,
                                                                GeeCollection* matches_editable,
                                                                GeeCollection* matched_development);
GeeCollection* media_source_collection_get_offline_bin_contents (MediaSourceCollection* self);
void library_photo_source_collection_get_basename_filesize_duplicate (LibraryPhotoSourceCollection* self,
                                                                      const gchar* basename,
                                                                      gint64 filesize,
                                                                      PhotoID* result);
gint utf8_ci_compare (void* a,
                      void* b);
gboolean library_photo_source_collection_has_basename_filesize_duplicate (LibraryPhotoSourceCollection* self,
                                                                          const gchar* basename,
                                                                          gint64 filesize);
gboolean photo_id_is_valid (PhotoID *self);
LibraryPhoto* library_photo_source_collection_get_trashed_by_file (LibraryPhotoSourceCollection* self,
                                                                   GFile* file);
MediaSource* media_source_holding_tank_fetch_by_master_file (MediaSourceHoldingTank* self,
                                                             GFile* file);
LibraryPhoto* library_photo_source_holding_tank_fetch_by_backing_file (LibraryPhotoSourceHoldingTank* self,
                                                                       GFile* file);
LibraryPhoto* library_photo_source_collection_get_trashed_by_md5 (LibraryPhotoSourceCollection* self,
                                                                  const gchar* md5);
MediaSource* media_source_holding_tank_fetch_by_md5 (MediaSourceHoldingTank* self,
                                                     const gchar* md5);
LibraryPhoto* library_photo_source_collection_get_offline_by_file (LibraryPhotoSourceCollection* self,
                                                                   GFile* file);
LibraryPhoto* library_photo_source_collection_get_offline_by_md5 (LibraryPhotoSourceCollection* self,
                                                                  const gchar* md5);
gint library_photo_source_collection_get_offline_count (LibraryPhotoSourceCollection* self);
gint source_holding_tank_get_count (SourceHoldingTank* self);
LibraryPhoto* library_photo_source_collection_get_state_by_file (LibraryPhotoSourceCollection* self,
                                                                 GFile* file,
                                                                 LibraryPhotoSourceCollectionState* state);
MediaSource* media_source_collection_fetch_by_master_file (MediaSourceCollection* self,
                                                           GFile* file);
static gboolean library_photo_source_collection_real_has_backlink (SourceCollection* base,
                                                            SourceBacklink* backlink);
gboolean source_collection_has_backlink (SourceCollection* self,
                                         SourceBacklink* backlink);
gboolean source_holding_tank_has_backlink (SourceHoldingTank* self,
                                           SourceBacklink* backlink);
static void library_photo_source_collection_real_remove_backlink (SourceCollection* base,
                                                           SourceBacklink* backlink);
void source_holding_tank_remove_backlink (SourceHoldingTank* self,
                                          SourceBacklink* backlink);
void source_collection_remove_backlink (SourceCollection* self,
                                        SourceBacklink* backlink);
MediaSourceTransactionController* media_source_transaction_controller_new (MediaSourceCollection* sources);
MediaSourceTransactionController* media_source_transaction_controller_construct (GType object_type,
                                                                                 MediaSourceCollection* sources);
GType media_source_transaction_controller_get_type (void) G_GNUC_CONST;
static void library_photo_source_collection_real_master_reimported (LibraryPhotoSourceCollection* self,
                                                             LibraryPhoto* photo,
                                                             PhotoMetadata* metadata);
static void g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA (GClosure * closure,
                                                          GValue * return_value,
                                                          guint n_param_values,
                                                          const GValue * param_values,
                                                          gpointer invocation_hint,
                                                          gpointer marshal_data);
static void library_photo_source_collection_real_editable_reimported (LibraryPhotoSourceCollection* self,
                                                               LibraryPhoto* photo,
                                                               PhotoMetadata* metadata);
static void library_photo_source_collection_real_baseline_reimported (LibraryPhotoSourceCollection* self,
                                                               LibraryPhoto* photo,
                                                               PhotoMetadata* metadata);
static void library_photo_source_collection_real_source_reimported (LibraryPhotoSourceCollection* self,
                                                             LibraryPhoto* photo,
                                                             PhotoMetadata* metadata);
static void library_photo_source_collection_finalize (DataCollection * obj);
GType flaggable_get_type (void) G_GNUC_CONST;
GType monitorable_get_type (void) G_GNUC_CONST;
#define LIBRARY_PHOTO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIBRARY_PHOTO, LibraryPhotoPrivate))
#define LIBRARY_PHOTO_FLAG_HIDDEN ((guint64) 0x0000000000000001)
#define LIBRARY_PHOTO_FLAG_FAVORITE ((guint64) 0x0000000000000002)
#define LIBRARY_PHOTO_FLAG_TRASH ((guint64) 0x0000000000000004)
#define LIBRARY_PHOTO_FLAG_OFFLINE ((guint64) 0x0000000000000008)
#define LIBRARY_PHOTO_FLAG_FLAGGED ((guint64) 0x0000000000000010)
static LibraryPhoto* library_photo_new (PhotoRow* row);
static LibraryPhoto* library_photo_construct (GType object_type,
                                       PhotoRow* row);
static void library_photo_generate_thumbnails (LibraryPhoto* self);
static void _library_photo_generate_thumbnails_one_shot_callback (gpointer self);
void data_source_rehydrate_backlinks (DataSource* self,
                                      SourceCollection* unlinked_from,
                                      const gchar* dehydrated);
static void library_photo_upgrade_rating_flags (LibraryPhoto* self,
                                         guint64 flags);
static LibraryPhoto* library_photo_new_from_import_params (PhotoImportParams* import_params);
static LibraryPhoto* library_photo_construct_from_import_params (GType object_type,
                                                          PhotoImportParams* import_params);
void library_photo_init (ProgressMonitor monitor,
                         void* monitor_target);
GeeArrayList* photo_table_get_all (PhotoTable* self);
GeeCollection* data_collection_add_many (DataCollection* self,
                                         GeeCollection* objects,
                                         ProgressMonitor monitor,
                                         void* monitor_target);
void media_source_collection_add_many_to_trash (MediaSourceCollection* self,
                                                GeeCollection* sources);
void media_source_collection_add_many_to_offline (MediaSourceCollection* self,
                                                  GeeCollection* sources);
void library_photo_terminate (void);
ImportResult library_photo_import_create (PhotoImportParams* params,
                                          LibraryPhoto* * photo);
void photo_table_add (PhotoTable* self,
                      PhotoRow* photo_row,
                      PhotoID* result);
gboolean photo_id_is_invalid (PhotoID *self);
void library_photo_import_failed (LibraryPhoto* photo);
void photo_table_remove (PhotoTable* self,
                         PhotoID* photo_id,
                         GError** error);
static void library_photo_real_notify_master_reimported (Photo* base,
                                                  PhotoMetadata* metadata);
static void library_photo_real_notify_editable_reimported (Photo* base,
                                                    PhotoMetadata* metadata);
static void library_photo_real_notify_source_reimported (Photo* base,
                                                  PhotoMetadata* metadata);
static void library_photo_real_notify_baseline_reimported (Photo* base,
                                                    PhotoMetadata* metadata);
void thumbnail_cache_import_from_source (ThumbnailSource* source,
                                         gboolean force,
                                         GError** error);
void thumbnail_source_notify_thumbnail_altered (ThumbnailSource* self);
static void library_photo_real_notify_altered (DataObject* base,
                                        Alteration* alteration);
gboolean alteration_has_subject (Alteration* self,
                                 const gchar* subject);
void one_shot_scheduler_at_priority_idle (OneShotScheduler* self,
                                          gint priority);
static GdkPixbuf* library_photo_real_get_preview_pixbuf (MediaSource* base,
                                                  Scaling* scaling,
                                                  GError** error);
GdkPixbuf* thumbnail_source_get_thumbnail (ThumbnailSource* self,
                                           gint scale,
                                           GError** error);
GType thumbnail_cache_size_get_type (void) G_GNUC_CONST;
GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self,
                                      GdkPixbuf* pixbuf,
                                      GdkInterpType interp,
                                      gboolean scale_up);
static void library_photo_real_rotate (Photo* base,
                                Rotation rotation);
void thumbnail_cache_rotate (ThumbnailSource* source,
                             Rotation rotation,
                             GError** error);
static GdkPixbuf* library_photo_real_get_thumbnail (ThumbnailSource* base,
                                             gint scale,
                                             GError** error);
GdkPixbuf* thumbnail_cache_fetch (ThumbnailSource* source,
                                  gint scale,
                                  GError** error);
static void library_photo_duplicate_backing_photo (LibraryPhoto* self,
                                            BackingPhotoRow* backing,
                                            BackingPhotoID* result,
                                            GError** error);
GFile* library_files_duplicate (GFile* src,
                                GFileProgressCallback progress_callback,
                                void* progress_callback_target,
                                gboolean blacklist,
                                GError** error);
static void library_photo_on_duplicate_progress (LibraryPhoto* self,
                                          gint64 current,
                                          gint64 total);
static void _library_photo_on_duplicate_progress_gfile_progress_callback (gint64 current_num_bytes,
                                                                   gint64 total_num_bytes,
                                                                   gpointer self);
LibraryPhoto* library_photo_duplicate (LibraryPhoto* self,
                                       GError** error);
void photo_table_duplicate (PhotoTable* self,
                            PhotoID* photo_id,
                            const gchar* new_filename,
                            BackingPhotoID* editable_id,
                            BackingPhotoID* develop_shotwell,
                            BackingPhotoID* develop_camera_id,
                            BackingPhotoID* develop_embedded_id,
                            PhotoID* result);
PhotoRow* photo_table_get_row (PhotoTable* self,
                               PhotoID* photo_id);
void thumbnail_cache_duplicate (ThumbnailSource* src_source,
                                ThumbnailSource* dest_source);
gboolean data_collection_add (DataCollection* self,
                              DataObject* object);
GType event_source_get_type (void) G_GNUC_CONST;
GType event_get_type (void) G_GNUC_CONST;
Event* media_source_get_event (MediaSource* self);
void event_attach (Event* self,
                   MediaSource* source);
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType tag_source_collection_get_type (void) G_GNUC_CONST;
GeeList* tag_source_collection_fetch_for_source (TagSourceCollection* self,
                                                 MediaSource* source);
void tag_attach (Tag* self,
                 MediaSource* source);
void spin_event_loop (void);
static gboolean library_photo_real_is_trashed (MediaSource* base);
static void library_photo_real_trash (MediaSource* base);
static void library_photo_real_untrash (MediaSource* base);
static gboolean library_photo_real_is_offline (Monitorable* base);
static void library_photo_real_mark_offline (Monitorable* base);
static void library_photo_real_mark_online (Monitorable* base);
static gboolean library_photo_real_is_flagged (Flaggable* base);
static void library_photo_real_mark_flagged (Flaggable* base);
static void library_photo_real_mark_unflagged (Flaggable* base);
static gboolean library_photo_real_internal_delete_backing (DataSource* base,
                                                     GError** error);
gboolean media_source_delete_original_file (MediaSource* self);
static void library_photo_real_destroy (DataSource* base);
void thumbnail_cache_remove (ThumbnailSource* source);
void data_source_destroy (DataSource* self);
gboolean library_photo_has_nontrash_duplicate (GFile* file,
                                               const gchar* thumbnail_md5,
                                               const gchar* full_md5,
                                               PhotoFileFormat file_format);
void library_photo_get_nontrash_duplicate (GFile* file,
                                           const gchar* thumbnail_md5,
                                           const gchar* full_md5,
                                           PhotoFileFormat file_format,
                                           PhotoID* result);
static gboolean library_photo_real_has_user_generated_metadata (Photo* base);
Rating media_source_get_rating (MediaSource* self);
gchar* data_object_get_name (DataObject* self);
static void library_photo_real_set_user_metadata_for_export (Photo* base,
                                                      PhotoMetadata* metadata);
void photo_metadata_set_keywords (PhotoMetadata* self,
                                  GeeCollection* keywords,
                                  PhotoMetadataSetOption option);
void photo_metadata_set_rating (PhotoMetadata* self,
                                Rating rating);
static void library_photo_real_apply_user_metadata_for_reimport (Photo* base,
                                                          PhotoMetadata* metadata);
gchar* hierarchical_tag_utilities_make_flat_tag_safe (const gchar* in_tag);
gchar* hierarchical_tag_utilities_flat_to_hierarchical (const gchar* name);
gboolean tag_source_collection_exists (TagSourceCollection* self,
                                       const gchar* name,
                                       gboolean treat_htags_as_root);
static void library_photo_finalize (GObject * obj);
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTankPrivate))
MediaSourceHoldingTank* media_source_holding_tank_new (MediaSourceCollection* sources,
                                                       SourceHoldingTankCheckToKeep check_to_keep,
                                                       void* check_to_keep_target,
                                                       GetSourceDatabaseKey get_key,
                                                       void* get_key_target);
MediaSourceHoldingTank* media_source_holding_tank_construct (GType object_type,
                                                             MediaSourceCollection* sources,
                                                             SourceHoldingTankCheckToKeep check_to_keep,
                                                             void* check_to_keep_target,
                                                             GetSourceDatabaseKey get_key,
                                                             void* get_key_target);
static void library_photo_source_holding_tank_real_notify_contents_altered (SourceHoldingTank* base,
                                                                     GeeCollection* added,
                                                                     GeeCollection* removed);
static void library_photo_source_holding_tank_on_editable_replaced (LibraryPhotoSourceHoldingTank* self,
                                                             Photo* _photo,
                                                             GFile* old_file,
                                                             GFile* new_file);
static void _library_photo_source_holding_tank_on_editable_replaced_photo_editable_replaced (Photo* _sender,
                                                                                      GFile* old_file,
                                                                                      GFile* new_file,
                                                                                      gpointer self);
static void library_photo_source_holding_tank_on_raw_development_modified (LibraryPhotoSourceHoldingTank* self,
                                                                    Photo* _photo);
static void _library_photo_source_holding_tank_on_raw_development_modified_photo_raw_development_modified (Photo* _sender,
                                                                                                    gpointer self);
void source_holding_tank_notify_contents_altered (SourceHoldingTank* self,
                                                  GeeCollection* added,
                                                  GeeCollection* removed);
static void library_photo_source_holding_tank_finalize (SourceHoldingTank * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const gchar* PHOTO_IMAGE_EXTENSIONS[69] = {"jpg", "jpeg", "jpe", "tiff", "tif", "png", "gif", "bmp", "ppm", "pgm", "pbm", "pnm", "thm", "tga", "ilbm", "pcx", "ecw", "img", "sid", "cd5", "fits", "pgf", "cgm", "svg", "odg", "eps", "pdf", "swf", "wmf", "emf", "xps", "pns", "jps", "mpo", "3fr", "arw", "srf", "sr2", "bay", "crw", "cr2", "cap", "iiq", "eip", "dcs", "dcr", "drf", "k25", "kdc", "dng", "erf", "fff", "mef", "mos", "mrw", "nef", "nrw", "orf", "ptx", "pef", "pxn", "r3d", "raf", "raw", "rw2", "rwl", "rwz", "x3f", "srw"};

GType
backing_fetch_mode_get_type (void)
{
	static volatile gsize backing_fetch_mode_type_id__volatile = 0;
	if (g_once_init_enter (&backing_fetch_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{BACKING_FETCH_MODE_SOURCE, "BACKING_FETCH_MODE_SOURCE", "source"}, {BACKING_FETCH_MODE_BASELINE, "BACKING_FETCH_MODE_BASELINE", "baseline"}, {BACKING_FETCH_MODE_MASTER, "BACKING_FETCH_MODE_MASTER", "master"}, {BACKING_FETCH_MODE_UNMODIFIED, "BACKING_FETCH_MODE_UNMODIFIED", "unmodified"}, {0, NULL, NULL}};
		GType backing_fetch_mode_type_id;
		backing_fetch_mode_type_id = g_enum_register_static ("BackingFetchMode", values);
		g_once_init_leave (&backing_fetch_mode_type_id__volatile, backing_fetch_mode_type_id);
	}
	return backing_fetch_mode_type_id__volatile;
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 41 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? g_object_ref (self) : NULL;
#line 3803 "Photo.c"
}


static gpointer
_thumbnails_ref0 (gpointer self)
{
#line 48 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? thumbnails_ref (self) : NULL;
#line 3812 "Photo.c"
}


PhotoImportParams*
photo_import_params_construct (GType object_type,
                               GFile* file,
                               GFile* final_associated_file,
                               ImportID* import_id,
                               PhotoFileSnifferOptions sniffer_options,
                               const gchar* exif_md5,
                               const gchar* thumbnail_md5,
                               const gchar* full_md5,
                               Thumbnails* thumbnails)
{
	PhotoImportParams* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	ImportID _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	Thumbnails* _tmp6_;
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((final_associated_file == NULL) || G_IS_FILE (final_associated_file), NULL);
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (import_id != NULL, NULL);
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((thumbnails == NULL) || IS_THUMBNAILS (thumbnails), NULL);
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	self = (PhotoImportParams*) g_type_create_instance (object_type);
#line 41 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _g_object_ref0 (file);
#line 41 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->file);
#line 41 "/home/jens/Source/shotwell/src/Photo.vala"
	self->file = _tmp0_;
#line 42 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _g_object_ref0 (final_associated_file);
#line 42 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->final_associated_file);
#line 42 "/home/jens/Source/shotwell/src/Photo.vala"
	self->final_associated_file = _tmp1_;
#line 43 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = *import_id;
#line 43 "/home/jens/Source/shotwell/src/Photo.vala"
	self->import_id = _tmp2_;
#line 44 "/home/jens/Source/shotwell/src/Photo.vala"
	self->sniffer_options = sniffer_options;
#line 45 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = g_strdup (exif_md5);
#line 45 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->exif_md5);
#line 45 "/home/jens/Source/shotwell/src/Photo.vala"
	self->exif_md5 = _tmp3_;
#line 46 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = g_strdup (thumbnail_md5);
#line 46 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->thumbnail_md5);
#line 46 "/home/jens/Source/shotwell/src/Photo.vala"
	self->thumbnail_md5 = _tmp4_;
#line 47 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = g_strdup (full_md5);
#line 47 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->full_md5);
#line 47 "/home/jens/Source/shotwell/src/Photo.vala"
	self->full_md5 = _tmp5_;
#line 48 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = _thumbnails_ref0 (thumbnails);
#line 48 "/home/jens/Source/shotwell/src/Photo.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 48 "/home/jens/Source/shotwell/src/Photo.vala"
	self->thumbnails = _tmp6_;
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	return self;
#line 3889 "Photo.c"
}


PhotoImportParams*
photo_import_params_new (GFile* file,
                         GFile* final_associated_file,
                         ImportID* import_id,
                         PhotoFileSnifferOptions sniffer_options,
                         const gchar* exif_md5,
                         const gchar* thumbnail_md5,
                         const gchar* full_md5,
                         Thumbnails* thumbnails)
{
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	return photo_import_params_construct (TYPE_PHOTO_IMPORT_PARAMS, file, final_associated_file, import_id, sniffer_options, exif_md5, thumbnail_md5, full_md5, thumbnails);
#line 3905 "Photo.c"
}


PhotoImportParams*
photo_import_params_construct_create_placeholder (GType object_type,
                                                  GFile* file,
                                                  ImportID* import_id)
{
	PhotoImportParams* self = NULL;
	GFile* _tmp0_;
	ImportID _tmp1_;
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (import_id != NULL, NULL);
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	self = (PhotoImportParams*) g_type_create_instance (object_type);
#line 53 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _g_object_ref0 (file);
#line 53 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->file);
#line 53 "/home/jens/Source/shotwell/src/Photo.vala"
	self->file = _tmp0_;
#line 54 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = *import_id;
#line 54 "/home/jens/Source/shotwell/src/Photo.vala"
	self->import_id = _tmp1_;
#line 55 "/home/jens/Source/shotwell/src/Photo.vala"
	self->sniffer_options = PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5;
#line 56 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->exif_md5);
#line 56 "/home/jens/Source/shotwell/src/Photo.vala"
	self->exif_md5 = NULL;
#line 57 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->thumbnail_md5);
#line 57 "/home/jens/Source/shotwell/src/Photo.vala"
	self->thumbnail_md5 = NULL;
#line 58 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->full_md5);
#line 58 "/home/jens/Source/shotwell/src/Photo.vala"
	self->full_md5 = NULL;
#line 59 "/home/jens/Source/shotwell/src/Photo.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 59 "/home/jens/Source/shotwell/src/Photo.vala"
	self->thumbnails = NULL;
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	return self;
#line 3953 "Photo.c"
}


PhotoImportParams*
photo_import_params_new_create_placeholder (GFile* file,
                                            ImportID* import_id)
{
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	return photo_import_params_construct_create_placeholder (TYPE_PHOTO_IMPORT_PARAMS, file, import_id);
#line 3963 "Photo.c"
}


static void
value_photo_import_params_init (GValue* value)
{
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	value->data[0].v_pointer = NULL;
#line 3972 "Photo.c"
}


static void
value_photo_import_params_free_value (GValue* value)
{
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_import_params_unref (value->data[0].v_pointer);
#line 3983 "Photo.c"
	}
}


static void
value_photo_import_params_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		dest_value->data[0].v_pointer = photo_import_params_ref (src_value->data[0].v_pointer);
#line 3996 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4000 "Photo.c"
	}
}


static gpointer
value_photo_import_params_peek_pointer (const GValue* value)
{
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return value->data[0].v_pointer;
#line 4010 "Photo.c"
}


static gchar*
value_photo_import_params_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (collect_values[0].v_pointer) {
#line 4022 "Photo.c"
		PhotoImportParams * object;
		object = collect_values[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4029 "Photo.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4033 "Photo.c"
		}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = photo_import_params_ref (object);
#line 4037 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = NULL;
#line 4041 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return NULL;
#line 4045 "Photo.c"
}


static gchar*
value_photo_import_params_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	PhotoImportParams ** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!object_p) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4061 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		*object_p = NULL;
#line 4067 "Photo.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		*object_p = value->data[0].v_pointer;
#line 4071 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		*object_p = photo_import_params_ref (value->data[0].v_pointer);
#line 4075 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return NULL;
#line 4079 "Photo.c"
}


GParamSpec*
param_spec_photo_import_params (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecPhotoImportParams* spec;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_IMPORT_PARAMS), NULL);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return G_PARAM_SPEC (spec);
#line 4099 "Photo.c"
}


gpointer
value_get_photo_import_params (const GValue* value)
{
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS), NULL);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return value->data[0].v_pointer;
#line 4110 "Photo.c"
}


void
value_set_photo_import_params (GValue* value,
                               gpointer v_object)
{
	PhotoImportParams * old;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (v_object) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_IMPORT_PARAMS));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = v_object;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_import_params_ref (value->data[0].v_pointer);
#line 4133 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = NULL;
#line 4137 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (old) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_import_params_unref (old);
#line 4143 "Photo.c"
	}
}


void
value_take_photo_import_params (GValue* value,
                                gpointer v_object)
{
	PhotoImportParams * old;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (v_object) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_IMPORT_PARAMS));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = v_object;
#line 4165 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = NULL;
#line 4169 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (old) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_import_params_unref (old);
#line 4175 "Photo.c"
	}
}


static void
photo_import_params_class_init (PhotoImportParamsClass * klass)
{
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_import_params_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	((PhotoImportParamsClass *) klass)->finalize = photo_import_params_finalize;
#line 4187 "Photo.c"
}


static void
photo_import_params_instance_init (PhotoImportParams * self)
{
	PhotoRow* _tmp0_;
#line 24 "/home/jens/Source/shotwell/src/Photo.vala"
	self->final_associated_file = NULL;
#line 35 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_row_new ();
#line 35 "/home/jens/Source/shotwell/src/Photo.vala"
	self->row = _tmp0_;
#line 36 "/home/jens/Source/shotwell/src/Photo.vala"
	self->keywords = NULL;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	self->ref_count = 1;
#line 4205 "Photo.c"
}


static void
photo_import_params_finalize (PhotoImportParams * obj)
{
	PhotoImportParams * self;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParams);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_handlers_destroy (self);
#line 23 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->file);
#line 24 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->final_associated_file);
#line 27 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->exif_md5);
#line 28 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->thumbnail_md5);
#line 29 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->full_md5);
#line 32 "/home/jens/Source/shotwell/src/Photo.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 35 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_row_unref0 (self->row);
#line 36 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->keywords);
#line 4233 "Photo.c"
}


GType
photo_import_params_get_type (void)
{
	static volatile gsize photo_import_params_type_id__volatile = 0;
	if (g_once_init_enter (&photo_import_params_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_photo_import_params_init, value_photo_import_params_free_value, value_photo_import_params_copy_value, value_photo_import_params_peek_pointer, "p", value_photo_import_params_collect_value, "p", value_photo_import_params_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PhotoImportParamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_import_params_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoImportParams), 0, (GInstanceInitFunc) photo_import_params_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType photo_import_params_type_id;
		photo_import_params_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoImportParams", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&photo_import_params_type_id__volatile, photo_import_params_type_id);
	}
	return photo_import_params_type_id__volatile;
}


gpointer
photo_import_params_ref (gpointer instance)
{
	PhotoImportParams * self;
	self = instance;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return instance;
#line 4262 "Photo.c"
}


void
photo_import_params_unref (gpointer instance)
{
	PhotoImportParams * self;
	self = instance;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		PHOTO_IMPORT_PARAMS_GET_CLASS (self)->finalize (self);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4277 "Photo.c"
	}
}


PhotoTransformationState*
photo_transformation_state_construct (GType object_type)
{
	PhotoTransformationState * self = NULL;
#line 72 "/home/jens/Source/shotwell/src/Photo.vala"
	self = (PhotoTransformationState*) g_object_new (object_type, NULL);
#line 72 "/home/jens/Source/shotwell/src/Photo.vala"
	return self;
#line 4290 "Photo.c"
}


gboolean
photo_transformation_state_is_broken (PhotoTransformationState* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 75 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_TRANSFORMATION_STATE (self), FALSE);
#line 76 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->priv->is_broke;
#line 76 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 76 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 4307 "Photo.c"
}


static void
photo_transformation_state_real_broken (PhotoTransformationState* self)
{
#line 69 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->is_broke = TRUE;
#line 4316 "Photo.c"
}


static void
photo_transformation_state_class_init (PhotoTransformationStateClass * klass)
{
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_transformation_state_parent_class = g_type_class_peek_parent (klass);
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	g_type_class_add_private (klass, sizeof (PhotoTransformationStatePrivate));
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	((PhotoTransformationStateClass *) klass)->broken = photo_transformation_state_real_broken;
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	G_OBJECT_CLASS (klass)->finalize = photo_transformation_state_finalize;
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_transformation_state_signals[PHOTO_TRANSFORMATION_STATE_BROKEN_SIGNAL] = g_signal_new ("broken", TYPE_PHOTO_TRANSFORMATION_STATE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoTransformationStateClass, broken), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 4333 "Photo.c"
}


static void
photo_transformation_state_instance_init (PhotoTransformationState * self)
{
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv = PHOTO_TRANSFORMATION_STATE_GET_PRIVATE (self);
#line 64 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->is_broke = FALSE;
#line 4344 "Photo.c"
}


static void
photo_transformation_state_finalize (GObject * obj)
{
	PhotoTransformationState * self;
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState);
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	G_OBJECT_CLASS (photo_transformation_state_parent_class)->finalize (obj);
#line 4356 "Photo.c"
}


GType
photo_transformation_state_get_type (void)
{
	static volatile gsize photo_transformation_state_type_id__volatile = 0;
	if (g_once_init_enter (&photo_transformation_state_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoTransformationStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_transformation_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoTransformationState), 0, (GInstanceInitFunc) photo_transformation_state_instance_init, NULL };
		GType photo_transformation_state_type_id;
		photo_transformation_state_type_id = g_type_register_static (G_TYPE_OBJECT, "PhotoTransformationState", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&photo_transformation_state_type_id__volatile, photo_transformation_state_type_id);
	}
	return photo_transformation_state_type_id__volatile;
}


gboolean
rating_can_increase (Rating self)
{
	gboolean result = FALSE;
#line 90 "/home/jens/Source/shotwell/src/Photo.vala"
	result = self < RATING_FIVE;
#line 90 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 4382 "Photo.c"
}


gboolean
rating_can_decrease (Rating self)
{
	gboolean result = FALSE;
#line 94 "/home/jens/Source/shotwell/src/Photo.vala"
	result = self > RATING_REJECTED;
#line 94 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 4394 "Photo.c"
}


gboolean
rating_is_valid (Rating self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
	if (self >= RATING_REJECTED) {
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self <= RATING_FIVE;
#line 4407 "Photo.c"
	} else {
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = FALSE;
#line 4411 "Photo.c"
	}
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 4417 "Photo.c"
}


Rating
rating_increase (Rating self)
{
	Rating result = 0;
	Rating _tmp0_ = 0;
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
	if (rating_can_increase (self)) {
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self + 1;
#line 4430 "Photo.c"
	} else {
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self;
#line 4434 "Photo.c"
	}
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 4440 "Photo.c"
}


Rating
rating_decrease (Rating self)
{
	Rating result = 0;
	Rating _tmp0_ = 0;
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
	if (rating_can_decrease (self)) {
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self - 1;
#line 4453 "Photo.c"
	} else {
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self;
#line 4457 "Photo.c"
	}
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 4463 "Photo.c"
}


gint
rating_serialize (Rating self)
{
	gint result = 0;
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (self) {
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_REJECTED:
#line 4475 "Photo.c"
		{
#line 112 "/home/jens/Source/shotwell/src/Photo.vala"
			result = -1;
#line 112 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4481 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_UNRATED:
#line 4485 "Photo.c"
		{
#line 114 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 0;
#line 114 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4491 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_ONE:
#line 4495 "Photo.c"
		{
#line 116 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 1;
#line 116 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4501 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_TWO:
#line 4505 "Photo.c"
		{
#line 118 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 2;
#line 118 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4511 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_THREE:
#line 4515 "Photo.c"
		{
#line 120 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 3;
#line 120 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4521 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_FOUR:
#line 4525 "Photo.c"
		{
#line 122 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 4;
#line 122 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4531 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_FIVE:
#line 4535 "Photo.c"
		{
#line 124 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 5;
#line 124 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4541 "Photo.c"
		}
		default:
		{
#line 126 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 0;
#line 126 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4549 "Photo.c"
		}
	}
}


Rating
rating_unserialize (gint value)
{
	Rating result = 0;
#line 131 "/home/jens/Source/shotwell/src/Photo.vala"
	if (value > ((gint) RATING_FIVE)) {
#line 132 "/home/jens/Source/shotwell/src/Photo.vala"
		result = RATING_FIVE;
#line 132 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 4565 "Photo.c"
	} else {
#line 133 "/home/jens/Source/shotwell/src/Photo.vala"
		if (value < ((gint) RATING_REJECTED)) {
#line 134 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_REJECTED;
#line 134 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4573 "Photo.c"
		}
	}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (value) {
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case -1:
#line 4580 "Photo.c"
		{
#line 138 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_REJECTED;
#line 138 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4586 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 0:
#line 4590 "Photo.c"
		{
#line 140 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_UNRATED;
#line 140 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4596 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 1:
#line 4600 "Photo.c"
		{
#line 142 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_ONE;
#line 142 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4606 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 2:
#line 4610 "Photo.c"
		{
#line 144 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_TWO;
#line 144 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4616 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 3:
#line 4620 "Photo.c"
		{
#line 146 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_THREE;
#line 146 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4626 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 4:
#line 4630 "Photo.c"
		{
#line 148 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_FOUR;
#line 148 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4636 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 5:
#line 4640 "Photo.c"
		{
#line 150 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_FIVE;
#line 150 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4646 "Photo.c"
		}
		default:
		{
#line 152 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_UNRATED;
#line 152 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4654 "Photo.c"
		}
	}
}


GType
rating_get_type (void)
{
	static volatile gsize rating_type_id__volatile = 0;
	if (g_once_init_enter (&rating_type_id__volatile)) {
		static const GEnumValue values[] = {{RATING_REJECTED, "RATING_REJECTED", "rejected"}, {RATING_UNRATED, "RATING_UNRATED", "unrated"}, {RATING_ONE, "RATING_ONE", "one"}, {RATING_TWO, "RATING_TWO", "two"}, {RATING_THREE, "RATING_THREE", "three"}, {RATING_FOUR, "RATING_FOUR", "four"}, {RATING_FIVE, "RATING_FIVE", "five"}, {0, NULL, NULL}};
		GType rating_type_id;
		rating_type_id = g_enum_register_static ("Rating", values);
		g_once_init_leave (&rating_type_id__volatile, rating_type_id);
	}
	return rating_type_id__volatile;
}


gboolean
photo_exception_prohibits (PhotoException self,
                           PhotoException exception)
{
	gboolean result = FALSE;
#line 228 "/home/jens/Source/shotwell/src/Photo.vala"
	result = (self & exception) != 0;
#line 228 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 4683 "Photo.c"
}


gboolean
photo_exception_allows (PhotoException self,
                        PhotoException exception)
{
	gboolean result = FALSE;
#line 232 "/home/jens/Source/shotwell/src/Photo.vala"
	result = (self & exception) == 0;
#line 232 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 4696 "Photo.c"
}


GType
photo_exception_get_type (void)
{
	static volatile gsize photo_exception_type_id__volatile = 0;
	if (g_once_init_enter (&photo_exception_type_id__volatile)) {
		static const GEnumValue values[] = {{PHOTO_EXCEPTION_NONE, "PHOTO_EXCEPTION_NONE", "none"}, {PHOTO_EXCEPTION_ORIENTATION, "PHOTO_EXCEPTION_ORIENTATION", "orientation"}, {PHOTO_EXCEPTION_CROP, "PHOTO_EXCEPTION_CROP", "crop"}, {PHOTO_EXCEPTION_REDEYE, "PHOTO_EXCEPTION_REDEYE", "redeye"}, {PHOTO_EXCEPTION_ADJUST, "PHOTO_EXCEPTION_ADJUST", "adjust"}, {PHOTO_EXCEPTION_STRAIGHTEN, "PHOTO_EXCEPTION_STRAIGHTEN", "straighten"}, {PHOTO_EXCEPTION_ALL, "PHOTO_EXCEPTION_ALL", "all"}, {0, NULL, NULL}};
		GType photo_exception_type_id;
		photo_exception_type_id = g_enum_register_static ("PhotoException", values);
		g_once_init_leave (&photo_exception_type_id__volatile, photo_exception_type_id);
	}
	return photo_exception_type_id__volatile;
}


static gpointer
_photo_row_ref0 (gpointer self)
{
#line 400 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_row_ref (self) : NULL;
#line 4719 "Photo.c"
}


static gpointer
_backing_photo_row_ref0 (gpointer self)
{
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? backing_photo_row_ref (self) : NULL;
#line 4728 "Photo.c"
}


Photo*
photo_construct (GType object_type,
                 PhotoRow* row)
{
	Photo * self = NULL;
	PhotoRow* _tmp0_;
	PhotoRow* _tmp1_;
	PhotoRow* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	PhotoRow* _tmp5_;
	PhotoRow* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	PhotoBackingReaders* _tmp9_;
	BackingPhotoRow* _tmp10_;
	PhotoFileFormat _tmp11_;
	BackingPhotoRow* _tmp12_;
	const gchar* _tmp13_;
	PhotoFileReader* _tmp14_;
	gchar* basename = NULL;
	BackingPhotoRow* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp21_;
	BackingPhotoID _tmp25_;
	gint64 _tmp26_;
	BackingPhotoRow* _tmp41_;
	PhotoFileFormat _tmp42_;
	gboolean _tmp57_ = FALSE;
	BackingPhotoRow* _tmp58_;
	PhotoFileFormat _tmp59_;
	PhotoBackingReaders* _tmp71_;
	PhotoFileReader* _tmp72_;
	PhotoRow* _tmp88_;
	time_t _tmp89_;
	GError * _inner_error_ = NULL;
#line 399 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_ROW (row), NULL);
#line 399 "/home/jens/Source/shotwell/src/Photo.vala"
	self = (Photo*) photo_source_construct (object_type, DATA_OBJECT_INVALID_OBJECT_ID);
#line 400 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _photo_row_ref0 (row);
#line 400 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_row_unref0 (self->row);
#line 400 "/home/jens/Source/shotwell/src/Photo.vala"
	self->row = _tmp0_;
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = self->row;
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = self->row;
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_->title;
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = media_source_prep_title (_tmp3_);
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp1_->title);
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_->title = _tmp4_;
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = self->row;
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = self->row;
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = _tmp6_->comment;
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = media_source_prep_comment (_tmp7_);
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp5_->comment);
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_->comment = _tmp8_;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = self->priv->readers;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = row->master;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = _tmp10_->file_format;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = row->master;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = _tmp12_->filepath;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = photo_file_format_create_reader (_tmp11_, _tmp13_);
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp9_->master);
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_->master = _tmp14_;
#line 411 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = row->master;
#line 411 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = _tmp15_->filepath;
#line 411 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = string_sliced_at_last_char (_tmp16_, (gunichar) G_DIR_SEPARATOR, 0);
#line 411 "/home/jens/Source/shotwell/src/Photo.vala"
	basename = _tmp17_;
#line 412 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = basename;
#line 412 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp18_ != NULL) {
#line 4832 "Photo.c"
		const gchar* _tmp19_;
		gchar* _tmp20_;
#line 413 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = basename;
#line 413 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = string_sliced_at (_tmp19_, 1);
#line 413 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (self->priv->file_title);
#line 413 "/home/jens/Source/shotwell/src/Photo.vala"
		self->priv->file_title = _tmp20_;
#line 4843 "Photo.c"
	}
#line 415 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = self->priv->file_title;
#line 415 "/home/jens/Source/shotwell/src/Photo.vala"
	if (is_string_empty (_tmp21_)) {
#line 4849 "Photo.c"
		BackingPhotoRow* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = row->master;
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = _tmp22_->filepath;
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = g_strdup (_tmp23_);
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (self->priv->file_title);
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		self->priv->file_title = _tmp24_;
#line 4863 "Photo.c"
	}
#line 418 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp25_ = row->editable_id;
#line 418 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_ = _tmp25_.id;
#line 418 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp26_ != BACKING_PHOTO_ID_INVALID) {
#line 4871 "Photo.c"
		BackingPhotoRow* e = NULL;
		BackingPhotoID _tmp27_;
		BackingPhotoRow* _tmp28_;
		BackingPhotoRow* _tmp29_;
#line 419 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp27_ = row->editable_id;
#line 419 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp28_ = photo_get_backing_row (self, &_tmp27_);
#line 419 "/home/jens/Source/shotwell/src/Photo.vala"
		e = _tmp28_;
#line 420 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = e;
#line 420 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp29_ != NULL) {
#line 4886 "Photo.c"
			BackingPhotoRow* _tmp30_;
			BackingPhotoRow* _tmp31_;
			PhotoBackingReaders* _tmp32_;
			BackingPhotoRow* _tmp33_;
			PhotoFileFormat _tmp34_;
			BackingPhotoRow* _tmp35_;
			const gchar* _tmp36_;
			PhotoFileReader* _tmp37_;
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp30_ = e;
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp31_ = _backing_photo_row_ref0 (_tmp30_);
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (self->priv->editable);
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
			self->priv->editable = _tmp31_;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp32_ = self->priv->readers;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp33_ = self->priv->editable;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp34_ = _tmp33_->file_format;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp35_ = self->priv->editable;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp36_ = _tmp35_->filepath;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp37_ = photo_file_format_create_reader (_tmp34_, _tmp36_);
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (_tmp32_->editable);
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp32_->editable = _tmp37_;
#line 4919 "Photo.c"
		} else {
			{
				PhotoTable* _tmp38_;
				PhotoTable* _tmp39_;
				PhotoRow* _tmp40_;
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_ = photo_table_get_instance ();
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = _tmp38_;
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp40_ = self->row;
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_detach_editable (_tmp39_, _tmp40_, &_inner_error_);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp39_);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 4939 "Photo.c"
						goto __catch268_database_error;
					}
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (e);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (basename);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					return NULL;
#line 4952 "Photo.c"
				}
			}
			goto __finally268;
			__catch268_database_error:
			{
				GError* err = NULL;
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				err = _inner_error_;
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (err);
#line 4965 "Photo.c"
			}
			__finally268:
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (e);
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (basename);
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				return NULL;
#line 4980 "Photo.c"
			}
#line 432 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_internal_remove_all_transformations (self, FALSE);
#line 4984 "Photo.c"
		}
#line 418 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (e);
#line 4988 "Photo.c"
	}
#line 436 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp41_ = row->master;
#line 436 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp42_ = _tmp41_->file_format;
#line 436 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp42_ == PHOTO_FILE_FORMAT_RAW) {
#line 4996 "Photo.c"
		GeeHashMap* _tmp43_;
		gint _tmp44_;
		RawDeveloper* _tmp45_;
#line 438 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp43_ = gee_hash_map_new (TYPE_RAW_DEVELOPER, NULL, NULL, TYPE_BACKING_PHOTO_ROW, (GBoxedCopyFunc) backing_photo_row_ref, (GDestroyNotify) backing_photo_row_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 438 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (self->priv->developments);
#line 438 "/home/jens/Source/shotwell/src/Photo.vala"
		self->priv->developments = _tmp43_;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp45_ = raw_developer_as_array (&_tmp44_);
#line 5008 "Photo.c"
		{
			RawDeveloper* d_collection = NULL;
			gint d_collection_length1 = 0;
			gint _d_collection_size_ = 0;
			gint d_it = 0;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection = _tmp45_;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection_length1 = _tmp44_;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
			for (d_it = 0; d_it < _tmp44_; d_it = d_it + 1) {
#line 5020 "Photo.c"
				RawDeveloper d = 0;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
				d = d_collection[d_it];
#line 5024 "Photo.c"
				{
					BackingPhotoID id = {0};
					BackingPhotoID* _tmp46_;
					gint _tmp46__length1;
					RawDeveloper _tmp47_;
					BackingPhotoID _tmp48_;
					BackingPhotoID _tmp49_;
					gint64 _tmp50_;
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp46_ = row->development_ids;
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp46__length1 = row->development_ids_length1;
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp47_ = d;
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp48_ = _tmp46_[_tmp47_];
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					id = _tmp48_;
#line 441 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp49_ = id;
#line 441 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp50_ = _tmp49_.id;
#line 441 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp50_ != BACKING_PHOTO_ID_INVALID) {
#line 5049 "Photo.c"
						BackingPhotoRow* bpr = NULL;
						BackingPhotoID _tmp51_;
						BackingPhotoRow* _tmp52_;
						BackingPhotoRow* _tmp53_;
#line 442 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp51_ = id;
#line 442 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp52_ = photo_get_backing_row (self, &_tmp51_);
#line 442 "/home/jens/Source/shotwell/src/Photo.vala"
						bpr = _tmp52_;
#line 443 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp53_ = bpr;
#line 443 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp53_ != NULL) {
#line 5064 "Photo.c"
							GeeHashMap* _tmp54_;
							RawDeveloper _tmp55_;
							BackingPhotoRow* _tmp56_;
#line 444 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp54_ = self->priv->developments;
#line 444 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp55_ = d;
#line 444 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp56_ = bpr;
#line 444 "/home/jens/Source/shotwell/src/Photo.vala"
							gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp55_), _tmp56_);
#line 5076 "Photo.c"
						}
#line 441 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (bpr);
#line 5080 "Photo.c"
					}
				}
			}
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection = (g_free (d_collection), NULL);
#line 5086 "Photo.c"
		}
	}
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp58_ = row->master;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp59_ = _tmp58_->file_format;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp59_ == PHOTO_FILE_FORMAT_RAW) {
#line 5095 "Photo.c"
		GeeHashMap* _tmp60_;
		RawDeveloper _tmp61_;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp60_ = self->priv->developments;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp61_ = row->developer;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp57_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp61_));
#line 5104 "Photo.c"
	} else {
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp57_ = FALSE;
#line 5108 "Photo.c"
	}
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp57_) {
#line 5112 "Photo.c"
		BackingPhotoRow* r = NULL;
		GeeHashMap* _tmp62_;
		RawDeveloper _tmp63_;
		gpointer _tmp64_;
		PhotoBackingReaders* _tmp65_;
		BackingPhotoRow* _tmp66_;
		PhotoFileFormat _tmp67_;
		BackingPhotoRow* _tmp68_;
		const gchar* _tmp69_;
		PhotoFileReader* _tmp70_;
#line 451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp62_ = self->priv->developments;
#line 451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp63_ = row->developer;
#line 451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp64_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp63_));
#line 451 "/home/jens/Source/shotwell/src/Photo.vala"
		r = (BackingPhotoRow*) _tmp64_;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp65_ = self->priv->readers;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp66_ = r;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp67_ = _tmp66_->file_format;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp68_ = r;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp69_ = _tmp68_->filepath;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp70_ = photo_file_format_create_reader (_tmp67_, _tmp69_);
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp65_->developer);
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp65_->developer = _tmp70_;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (r);
#line 5149 "Photo.c"
	}
#line 456 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp71_ = self->priv->readers;
#line 456 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp72_ = _tmp71_->editable;
#line 456 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp72_ != NULL) {
#line 5157 "Photo.c"
		BackingPhotoRow* _tmp73_;
		BackingPhotoRow* _tmp74_;
#line 457 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp73_ = self->priv->editable;
#line 457 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp74_ = _backing_photo_row_ref0 (_tmp73_);
#line 457 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (self->backing_photo_row);
#line 457 "/home/jens/Source/shotwell/src/Photo.vala"
		self->backing_photo_row = _tmp74_;
#line 5168 "Photo.c"
	} else {
		BackingPhotoRow* _tmp75_;
		PhotoFileFormat _tmp76_;
#line 458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp75_ = row->master;
#line 458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp76_ = _tmp75_->file_format;
#line 458 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp76_ != PHOTO_FILE_FORMAT_RAW) {
#line 5178 "Photo.c"
			PhotoRow* _tmp77_;
			BackingPhotoRow* _tmp78_;
			BackingPhotoRow* _tmp79_;
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp77_ = self->row;
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp78_ = _tmp77_->master;
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp79_ = _backing_photo_row_ref0 (_tmp78_);
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (self->backing_photo_row);
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			self->backing_photo_row = _tmp79_;
#line 5192 "Photo.c"
		} else {
			GeeHashMap* _tmp80_;
			RawDeveloper _tmp81_;
#line 463 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp80_ = self->priv->developments;
#line 463 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp81_ = row->developer;
#line 463 "/home/jens/Source/shotwell/src/Photo.vala"
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp81_))) {
#line 5202 "Photo.c"
				GeeHashMap* _tmp82_;
				RawDeveloper _tmp83_;
				gpointer _tmp84_;
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp82_ = self->priv->developments;
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp83_ = row->developer;
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp84_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp83_));
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (self->backing_photo_row);
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				self->backing_photo_row = (BackingPhotoRow*) _tmp84_;
#line 5216 "Photo.c"
			} else {
				PhotoRow* _tmp85_;
				BackingPhotoRow* _tmp86_;
				BackingPhotoRow* _tmp87_;
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp85_ = self->row;
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp86_ = _tmp85_->master;
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp87_ = _backing_photo_row_ref0 (_tmp86_);
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (self->backing_photo_row);
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				self->backing_photo_row = _tmp87_;
#line 5231 "Photo.c"
			}
		}
	}
#line 471 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp88_ = self->row;
#line 471 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp89_ = _tmp88_->exposure_time;
#line 471 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->cached_exposure_time = _tmp89_;
#line 399 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (basename);
#line 399 "/home/jens/Source/shotwell/src/Photo.vala"
	return self;
#line 5245 "Photo.c"
}


void
photo_init_photo (void)
{
	GeeLinkedList* _tmp0_;
#line 475 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = gee_linked_list_new (PHOTO_TYPE_CACHED_PIXBUF, (GBoxedCopyFunc) photo_cached_pixbuf_ref, (GDestroyNotify) photo_cached_pixbuf_unref, NULL, NULL, NULL);
#line 475 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (photo_source_pixbuf_cache);
#line 475 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_source_pixbuf_cache = _tmp0_;
#line 5259 "Photo.c"
}


void
photo_terminate_photo (void)
{
	guint _tmp0_;
#line 479 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (photo_source_pixbuf_cache);
#line 479 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_source_pixbuf_cache = NULL;
#line 481 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_discard_source_id;
#line 481 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 5275 "Photo.c"
		guint _tmp1_;
#line 482 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = photo_discard_source_id;
#line 482 "/home/jens/Source/shotwell/src/Photo.vala"
		g_source_remove (_tmp1_);
#line 483 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_discard_source_id = (guint) 0;
#line 5283 "Photo.c"
	}
}


static void
photo_real_notify_editable_replaced (Photo* self,
                                     GFile* old_file,
                                     GFile* new_file)
{
#line 487 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((old_file == NULL) || G_IS_FILE (old_file));
#line 487 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((new_file == NULL) || G_IS_FILE (new_file));
#line 488 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit (self, photo_signals[PHOTO_EDITABLE_REPLACED_SIGNAL], 0, old_file, new_file);
#line 5299 "Photo.c"
}


void
photo_notify_editable_replaced (Photo* self,
                                GFile* old_file,
                                GFile* new_file)
{
#line 487 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 487 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_editable_replaced (self, old_file, new_file);
#line 5312 "Photo.c"
}


static void
photo_real_notify_raw_development_modified (Photo* self)
{
#line 492 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit (self, photo_signals[PHOTO_RAW_DEVELOPMENT_MODIFIED_SIGNAL], 0);
#line 5321 "Photo.c"
}


void
photo_notify_raw_development_modified (Photo* self)
{
#line 491 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 491 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_raw_development_modified (self);
#line 5332 "Photo.c"
}


static void
photo_real_notify_baseline_replaced (Photo* self)
{
#line 496 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit (self, photo_signals[PHOTO_BASELINE_REPLACED_SIGNAL], 0);
#line 5341 "Photo.c"
}


void
photo_notify_baseline_replaced (Photo* self)
{
#line 495 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 495 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_baseline_replaced (self);
#line 5352 "Photo.c"
}


static void
photo_real_notify_master_reimported (Photo* self,
                                     PhotoMetadata* metadata)
{
#line 499 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
#line 500 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit (self, photo_signals[PHOTO_MASTER_REIMPORTED_SIGNAL], 0, metadata);
#line 5364 "Photo.c"
}


void
photo_notify_master_reimported (Photo* self,
                                PhotoMetadata* metadata)
{
#line 499 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 499 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_master_reimported (self, metadata);
#line 5376 "Photo.c"
}


static void
photo_real_notify_editable_reimported (Photo* self,
                                       PhotoMetadata* metadata)
{
#line 503 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
#line 504 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit (self, photo_signals[PHOTO_EDITABLE_REIMPORTED_SIGNAL], 0, metadata);
#line 5388 "Photo.c"
}


void
photo_notify_editable_reimported (Photo* self,
                                  PhotoMetadata* metadata)
{
#line 503 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 503 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_editable_reimported (self, metadata);
#line 5400 "Photo.c"
}


static void
photo_real_notify_source_reimported (Photo* self,
                                     PhotoMetadata* metadata)
{
#line 507 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
#line 508 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit (self, photo_signals[PHOTO_SOURCE_REIMPORTED_SIGNAL], 0, metadata);
#line 5412 "Photo.c"
}


void
photo_notify_source_reimported (Photo* self,
                                PhotoMetadata* metadata)
{
#line 507 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 507 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_source_reimported (self, metadata);
#line 5424 "Photo.c"
}


static void
photo_real_notify_baseline_reimported (Photo* self,
                                       PhotoMetadata* metadata)
{
#line 511 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
#line 512 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit (self, photo_signals[PHOTO_BASELINE_REIMPORTED_SIGNAL], 0, metadata);
#line 5436 "Photo.c"
}


void
photo_notify_baseline_reimported (Photo* self,
                                  PhotoMetadata* metadata)
{
#line 511 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 511 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_baseline_reimported (self, metadata);
#line 5448 "Photo.c"
}


static gboolean
photo_real_internal_delete_backing (DataSource* base,
                                    GError** error)
{
	Photo * self;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GFile* file = NULL;
	GFile* _tmp11_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GError * _inner_error_ = NULL;
#line 515 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 516 "/home/jens/Source/shotwell/src/Photo.vala"
	ret = TRUE;
#line 517 "/home/jens/Source/shotwell/src/Photo.vala"
	file = NULL;
#line 5470 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_;
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 5477 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
#line 519 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 519 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 519 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 5487 "Photo.c"
				PhotoBackingReaders* _tmp3_;
				PhotoFileReader* _tmp4_;
				GFile* _tmp5_;
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->editable;
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (file);
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				file = _tmp5_;
#line 5501 "Photo.c"
			}
		}
		__finally269:
		{
			PhotoBackingReaders* _tmp6_;
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->priv->readers;
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 5511 "Photo.c"
		}
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5515 "Photo.c"
			gboolean _tmp7_ = FALSE;
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp7_;
#line 5523 "Photo.c"
		}
	}
#line 523 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_detach_editable (self, TRUE, FALSE, TRUE);
#line 525 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_get_master_file_format (self) == PHOTO_FILE_FORMAT_RAW) {
#line 5530 "Photo.c"
		gint _tmp8_;
		RawDeveloper* _tmp9_;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = raw_developer_as_array (&_tmp8_);
#line 5535 "Photo.c"
		{
			RawDeveloper* d_collection = NULL;
			gint d_collection_length1 = 0;
			gint _d_collection_size_ = 0;
			gint d_it = 0;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection = _tmp9_;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection_length1 = _tmp8_;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
			for (d_it = 0; d_it < _tmp8_; d_it = d_it + 1) {
#line 5547 "Photo.c"
				RawDeveloper d = 0;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
				d = d_collection[d_it];
#line 5551 "Photo.c"
				{
					RawDeveloper _tmp10_;
#line 527 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp10_ = d;
#line 527 "/home/jens/Source/shotwell/src/Photo.vala"
					photo_delete_raw_development (self, _tmp10_);
#line 5558 "Photo.c"
				}
			}
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection = (g_free (d_collection), NULL);
#line 5563 "Photo.c"
		}
	}
#line 531 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = file;
#line 531 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp11_ != NULL) {
#line 5570 "Photo.c"
		{
			gboolean _tmp12_ = FALSE;
			GFile* _tmp13_;
#line 533 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = file;
#line 533 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = g_file_trash (_tmp13_, NULL, &_inner_error_);
#line 533 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5580 "Photo.c"
				goto __catch270_g_error;
			}
#line 533 "/home/jens/Source/shotwell/src/Photo.vala"
			ret = _tmp12_;
#line 5585 "Photo.c"
		}
		goto __finally270;
		__catch270_g_error:
		{
			GError* err = NULL;
			GFile* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			GError* _tmp19_;
			const gchar* _tmp20_;
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			err = _inner_error_;
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			_inner_error_ = NULL;
#line 535 "/home/jens/Source/shotwell/src/Photo.vala"
			ret = FALSE;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = file;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = g_file_get_path (_tmp14_);
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = _tmp15_;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp18_ = _tmp17_;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = err;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp20_ = _tmp19_->message;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			g_message ("Photo.vala:536: Unable to move editable %s for %s to trash: %s", _tmp16_, _tmp18_, _tmp20_);
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp18_);
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp16_);
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_error_free0 (err);
#line 5626 "Photo.c"
		}
		__finally270:
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5631 "Photo.c"
			gboolean _tmp21_ = FALSE;
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp21_;
#line 5639 "Photo.c"
		}
	}
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = DATA_SOURCE_CLASS (photo_parent_class)->internal_delete_backing (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_DATA_SOURCE, DataSource), &_inner_error_);
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5646 "Photo.c"
		gboolean _tmp24_ = FALSE;
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp24_;
#line 5654 "Photo.c"
	}
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp23_) {
#line 5658 "Photo.c"
		gboolean _tmp25_;
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = ret;
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = _tmp25_;
#line 5664 "Photo.c"
	} else {
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = FALSE;
#line 5668 "Photo.c"
	}
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp22_;
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 5676 "Photo.c"
}


static BackingPhotoRow*
photo_get_backing_row (Photo* self,
                       BackingPhotoID* id)
{
	BackingPhotoRow* result = NULL;
	BackingPhotoID _tmp0_;
	gint64 _tmp1_;
	BackingPhotoRow* backing_row = NULL;
	BackingPhotoRow* _tmp13_;
	GError * _inner_error_ = NULL;
#line 547 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 547 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 548 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = *id;
#line 548 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_.id;
#line 548 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == BACKING_PHOTO_ID_INVALID) {
#line 549 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 549 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 5704 "Photo.c"
	}
#line 551 "/home/jens/Source/shotwell/src/Photo.vala"
	backing_row = NULL;
#line 5708 "Photo.c"
	{
		BackingPhotoRow* _tmp2_ = NULL;
		BackingPhotoTable* _tmp3_;
		BackingPhotoTable* _tmp4_;
		BackingPhotoID _tmp5_;
		BackingPhotoRow* _tmp6_;
		BackingPhotoRow* _tmp7_;
		BackingPhotoRow* _tmp8_;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = backing_photo_table_get_instance ();
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp3_;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = *id;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = backing_photo_table_fetch (_tmp4_, &_tmp5_, &_inner_error_);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp6_;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_database_table_unref0 (_tmp4_);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = _tmp7_;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 5735 "Photo.c"
				goto __catch271_database_error;
			}
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing_row);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 5746 "Photo.c"
		}
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = _tmp2_;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = NULL;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing_row);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		backing_row = _tmp8_;
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (_tmp2_);
#line 5758 "Photo.c"
	}
	goto __finally271;
	__catch271_database_error:
	{
		GError* err = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _tmp9_;
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = err;
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _tmp11_->message;
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:555: Unable to fetch backing state for %s: %s", _tmp10_, _tmp12_);
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp10_);
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 5786 "Photo.c"
	}
	__finally271:
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing_row);
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 5799 "Photo.c"
	}
#line 558 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = backing_row;
#line 558 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp13_ == NULL) {
#line 5805 "Photo.c"
		{
			BackingPhotoTable* _tmp14_;
			BackingPhotoTable* _tmp15_;
			BackingPhotoID _tmp16_;
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = backing_photo_table_get_instance ();
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _tmp14_;
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = *id;
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			backing_photo_table_remove (_tmp15_, &_tmp16_, &_inner_error_);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp15_);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 5824 "Photo.c"
					goto __catch272_database_error;
				}
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (backing_row);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				return NULL;
#line 5835 "Photo.c"
			}
		}
		goto __finally272;
		__catch272_database_error:
		{
			GError* err = NULL;
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			err = _inner_error_;
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			_inner_error_ = NULL;
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_error_free0 (err);
#line 5848 "Photo.c"
		}
		__finally272:
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing_row);
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 5861 "Photo.c"
		}
#line 564 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 564 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing_row);
#line 564 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 5869 "Photo.c"
	}
#line 567 "/home/jens/Source/shotwell/src/Photo.vala"
	result = backing_row;
#line 567 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 5875 "Photo.c"
}


gboolean
photo_is_raw_developer_complete (Photo* self,
                                 RawDeveloper d)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 572 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 5887 "Photo.c"
	{
		GeeHashMap* _tmp0_;
		gboolean _tmp9_ = FALSE;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->developments;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 5895 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			GeeHashMap* _tmp2_;
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->developments;
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d))) {
#line 5903 "Photo.c"
				GeeHashMap* _tmp3_;
				gpointer _tmp4_;
				BackingPhotoRow* _tmp5_;
				const gchar* _tmp6_;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->developments;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d));
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = (BackingPhotoRow*) _tmp4_;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = _tmp5_->filepath;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = g_file_test (_tmp6_, G_FILE_TEST_EXISTS);
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp5_);
#line 5920 "Photo.c"
			} else {
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = FALSE;
#line 5924 "Photo.c"
			}
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 5928 "Photo.c"
			{
				GeeHashMap* _tmp7_;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = self->priv->developments;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 5935 "Photo.c"
			}
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 5939 "Photo.c"
		}
		__finally273:
		{
			GeeHashMap* _tmp8_;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = self->priv->developments;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 5948 "Photo.c"
		}
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp9_;
#line 5956 "Photo.c"
	}
}


gboolean
photo_is_raw_developer_available (Photo* self,
                                  RawDeveloper d)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 580 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 5969 "Photo.c"
	{
		GeeHashMap* _tmp0_;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->developments;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 5976 "Photo.c"
		{
			GeeHashMap* _tmp1_;
#line 582 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->developments;
#line 582 "/home/jens/Source/shotwell/src/Photo.vala"
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d))) {
#line 583 "/home/jens/Source/shotwell/src/Photo.vala"
				result = TRUE;
#line 5985 "Photo.c"
				{
					GeeHashMap* _tmp2_;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp2_ = self->priv->developments;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 5992 "Photo.c"
				}
#line 583 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 5996 "Photo.c"
			}
		}
		__finally274:
		{
			GeeHashMap* _tmp3_;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->priv->developments;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 6006 "Photo.c"
		}
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6010 "Photo.c"
			gboolean _tmp4_ = FALSE;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp4_;
#line 6018 "Photo.c"
		}
	}
#line 586 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (d) {
#line 586 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_SHOTWELL:
#line 6025 "Photo.c"
		{
#line 588 "/home/jens/Source/shotwell/src/Photo.vala"
			result = TRUE;
#line 588 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 6031 "Photo.c"
		}
#line 586 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_CAMERA:
#line 6035 "Photo.c"
		{
#line 591 "/home/jens/Source/shotwell/src/Photo.vala"
			result = FALSE;
#line 591 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 6041 "Photo.c"
		}
#line 586 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_EMBEDDED:
#line 6045 "Photo.c"
		{
			{
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp5_;
				guint num_previews = 0U;
				PhotoMetadata* _tmp6_;
				guint _tmp7_;
#line 595 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = photo_get_master_metadata (self, &_inner_error_);
#line 595 "/home/jens/Source/shotwell/src/Photo.vala"
				meta = _tmp5_;
#line 595 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6059 "Photo.c"
					goto __catch275_g_error;
				}
#line 596 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = meta;
#line 596 "/home/jens/Source/shotwell/src/Photo.vala"
				num_previews = photo_metadata_get_preview_count (_tmp6_);
#line 598 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = num_previews;
#line 598 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp7_ > ((guint) 0)) {
#line 6070 "Photo.c"
					PhotoPreview* prev = NULL;
					PhotoMetadata* _tmp8_;
					guint _tmp9_;
					PhotoPreview* _tmp10_;
					PhotoPreview* _tmp11_;
					Dimensions dims = {0};
					PhotoPreview* _tmp12_;
					Dimensions _tmp13_ = {0};
					gint _tmp14_ = 0;
					Dimensions _tmp15_;
					gint _tmp16_;
					Dimensions _tmp17_;
					gint _tmp18_;
					gint preview_major_axis = 0;
					gint _tmp23_;
#line 599 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = meta;
#line 599 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp9_ = num_previews;
#line 599 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp10_ = photo_metadata_get_preview (_tmp8_, _tmp9_ - 1);
#line 599 "/home/jens/Source/shotwell/src/Photo.vala"
					prev = _tmp10_;
#line 602 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = prev;
#line 602 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp11_ == NULL) {
#line 603 "/home/jens/Source/shotwell/src/Photo.vala"
						result = FALSE;
#line 603 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_preview_unref0 (prev);
#line 603 "/home/jens/Source/shotwell/src/Photo.vala"
						_media_metadata_unref0 (meta);
#line 603 "/home/jens/Source/shotwell/src/Photo.vala"
						return result;
#line 6106 "Photo.c"
					}
#line 605 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = prev;
#line 605 "/home/jens/Source/shotwell/src/Photo.vala"
					photo_preview_get_pixel_dimensions (_tmp12_, &_tmp13_);
#line 605 "/home/jens/Source/shotwell/src/Photo.vala"
					dims = _tmp13_;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = dims;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp16_ = _tmp15_.width;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp17_ = dims;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp18_ = _tmp17_.height;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp16_ > _tmp18_) {
#line 6124 "Photo.c"
						Dimensions _tmp19_;
						gint _tmp20_;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp19_ = dims;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp20_ = _tmp19_.width;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp14_ = _tmp20_;
#line 6133 "Photo.c"
					} else {
						Dimensions _tmp21_;
						gint _tmp22_;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp21_ = dims;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp22_ = _tmp21_.height;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp14_ = _tmp22_;
#line 6143 "Photo.c"
					}
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					preview_major_axis = _tmp14_;
#line 609 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp23_ = preview_major_axis;
#line 609 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp23_ < PHOTO_MIN_EMBEDDED_SIZE) {
#line 610 "/home/jens/Source/shotwell/src/Photo.vala"
						result = FALSE;
#line 610 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_preview_unref0 (prev);
#line 610 "/home/jens/Source/shotwell/src/Photo.vala"
						_media_metadata_unref0 (meta);
#line 610 "/home/jens/Source/shotwell/src/Photo.vala"
						return result;
#line 6159 "Photo.c"
					}
#line 613 "/home/jens/Source/shotwell/src/Photo.vala"
					result = TRUE;
#line 613 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 613 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 613 "/home/jens/Source/shotwell/src/Photo.vala"
					return result;
#line 6169 "Photo.c"
				}
#line 617 "/home/jens/Source/shotwell/src/Photo.vala"
				result = FALSE;
#line 617 "/home/jens/Source/shotwell/src/Photo.vala"
				_media_metadata_unref0 (meta);
#line 617 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 6177 "Photo.c"
			}
			goto __finally275;
			__catch275_g_error:
			{
				GError* e = NULL;
				GError* _tmp24_;
				const gchar* _tmp25_;
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				e = _inner_error_;
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 619 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = e;
#line 619 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = _tmp24_->message;
#line 619 "/home/jens/Source/shotwell/src/Photo.vala"
				g_debug ("Photo.vala:619: Error accessing embedded preview. Message: %s", _tmp25_);
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (e);
#line 6197 "Photo.c"
			}
			__finally275:
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6202 "Photo.c"
				gboolean _tmp26_ = FALSE;
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				return _tmp26_;
#line 6210 "Photo.c"
			}
#line 621 "/home/jens/Source/shotwell/src/Photo.vala"
			result = FALSE;
#line 621 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 6216 "Photo.c"
		}
		default:
		{
#line 624 "/home/jens/Source/shotwell/src/Photo.vala"
			g_assert_not_reached ();
#line 6222 "Photo.c"
		}
	}
}


void
photo_add_backing_photo_for_development (Photo* self,
                                         RawDeveloper d,
                                         BackingPhotoRow* bpr,
                                         gboolean notify,
                                         GError** error)
{
	PhotoRow* _tmp0_;
	GError * _inner_error_ = NULL;
#line 631 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 631 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_BACKING_PHOTO_ROW (bpr));
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->row;
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_import_developed_backing_photo (_tmp0_, d, bpr, &_inner_error_);
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 6251 "Photo.c"
	}
	{
		GeeHashMap* _tmp1_;
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = self->priv->developments;
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 6259 "Photo.c"
		{
			GeeHashMap* _tmp2_;
#line 634 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->developments;
#line 634 "/home/jens/Source/shotwell/src/Photo.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d), bpr);
#line 6266 "Photo.c"
		}
		__finally276:
		{
			GeeHashMap* _tmp3_;
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->priv->developments;
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 6275 "Photo.c"
		}
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 6283 "Photo.c"
		}
	}
#line 637 "/home/jens/Source/shotwell/src/Photo.vala"
	if (notify) {
#line 6288 "Photo.c"
		Alteration* _tmp4_;
		Alteration* _tmp5_;
#line 638 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = alteration_new ("image", "developer");
#line 638 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp4_;
#line 638 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp5_);
#line 638 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp5_);
#line 6299 "Photo.c"
	}
}


void
photo_import_developed_backing_photo (PhotoRow* row,
                                      RawDeveloper d,
                                      BackingPhotoRow* bpr,
                                      GError** error)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* info = NULL;
	GFile* _tmp2_;
	GFileInfo* _tmp3_;
	GTimeVal timestamp = {0};
	GFileInfo* _tmp4_;
	GTimeVal _tmp5_ = {0};
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp6_;
	PhotoFileInterrogator* _tmp7_;
	PhotoFileInterrogator* _tmp8_;
	DetectedPhotoInformation* detected = NULL;
	PhotoFileInterrogator* _tmp9_;
	DetectedPhotoInformation* _tmp10_;
	gboolean _tmp11_ = FALSE;
	DetectedPhotoInformation* _tmp12_;
	DetectedPhotoInformation* _tmp14_;
	Dimensions _tmp15_;
	GFileInfo* _tmp16_;
	GTimeVal _tmp17_;
	glong _tmp18_;
	Orientation _tmp19_ = 0;
	DetectedPhotoInformation* _tmp20_;
	PhotoMetadata* _tmp21_;
	BackingPhotoTable* _tmp24_;
	BackingPhotoTable* _tmp25_;
	PhotoTable* _tmp26_;
	PhotoTable* _tmp27_;
	BackingPhotoID _tmp28_;
	GError * _inner_error_ = NULL;
#line 641 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 641 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_BACKING_PHOTO_ROW (bpr));
#line 643 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = bpr->filepath;
#line 643 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = g_file_new_for_path (_tmp0_);
#line 643 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp1_;
#line 644 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = file;
#line 644 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = g_file_query_info (_tmp2_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 644 "/home/jens/Source/shotwell/src/Photo.vala"
	info = _tmp3_;
#line 644 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 644 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 644 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 644 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 6366 "Photo.c"
	}
#line 646 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = info;
#line 646 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp4_, &_tmp5_);
#line 646 "/home/jens/Source/shotwell/src/Photo.vala"
	timestamp = _tmp5_;
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = file;
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = photo_file_interrogator_new (_tmp6_, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL);
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp7_;
#line 650 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = interrogator;
#line 650 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_interrogator_interrogate (_tmp8_, &_inner_error_);
#line 650 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 650 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 650 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 650 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 650 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 650 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 6396 "Photo.c"
	}
#line 652 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = interrogator;
#line 652 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = photo_file_interrogator_get_detected_photo_information (_tmp9_);
#line 652 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp10_;
#line 653 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = detected;
#line 653 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp12_ == NULL) {
#line 653 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = TRUE;
#line 6410 "Photo.c"
	} else {
		PhotoFileInterrogator* _tmp13_;
#line 653 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = interrogator;
#line 653 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = photo_file_interrogator_get_is_photo_corrupted (_tmp13_);
#line 6417 "Photo.c"
	}
#line 653 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp11_) {
#line 656 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 656 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 656 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 656 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 656 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 6431 "Photo.c"
	}
#line 659 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = detected;
#line 659 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = _tmp14_->image_dim;
#line 659 "/home/jens/Source/shotwell/src/Photo.vala"
	bpr->dim = _tmp15_;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = info;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
	bpr->filesize = g_file_info_get_size (_tmp16_);
#line 661 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = timestamp;
#line 661 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = _tmp17_.tv_sec;
#line 661 "/home/jens/Source/shotwell/src/Photo.vala"
	bpr->timestamp = (time_t) _tmp18_;
#line 662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = detected;
#line 662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = _tmp20_->metadata;
#line 662 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp21_ != NULL) {
#line 6455 "Photo.c"
		DetectedPhotoInformation* _tmp22_;
		PhotoMetadata* _tmp23_;
#line 662 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = detected;
#line 662 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = _tmp22_->metadata;
#line 662 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = photo_metadata_get_orientation (_tmp23_);
#line 6464 "Photo.c"
	} else {
#line 663 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = ORIENTATION_TOP_LEFT;
#line 6468 "Photo.c"
	}
#line 662 "/home/jens/Source/shotwell/src/Photo.vala"
	bpr->original_orientation = _tmp19_;
#line 666 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = backing_photo_table_get_instance ();
#line 666 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp25_ = _tmp24_;
#line 666 "/home/jens/Source/shotwell/src/Photo.vala"
	backing_photo_table_add (_tmp25_, bpr, &_inner_error_);
#line 666 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp25_);
#line 666 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 666 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 666 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 666 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 666 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 666 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 666 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 6494 "Photo.c"
	}
#line 667 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_ = photo_table_get_instance ();
#line 667 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_ = _tmp26_;
#line 667 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28_ = bpr->id;
#line 667 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_table_update_raw_development (_tmp27_, row, d, &_tmp28_, &_inner_error_);
#line 667 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp27_);
#line 667 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 667 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 667 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 667 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 667 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 667 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 667 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 6520 "Photo.c"
	}
#line 641 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 641 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 641 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (info);
#line 641 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 6530 "Photo.c"
}


static void
photo_develop_photo (Photo* self,
                     RawDeveloper d,
                     gboolean notify)
{
	gboolean wrote_img_to_disk = FALSE;
	BackingPhotoRow* bps = NULL;
	GError * _inner_error_ = NULL;
#line 672 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 673 "/home/jens/Source/shotwell/src/Photo.vala"
	wrote_img_to_disk = FALSE;
#line 674 "/home/jens/Source/shotwell/src/Photo.vala"
	bps = NULL;
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (d) {
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_SHOTWELL:
#line 6552 "Photo.c"
		{
			{
				BackingPhotoRow* _tmp0_ = NULL;
				PhotoRow* _tmp1_;
				BackingPhotoRow* _tmp2_;
				const gchar* _tmp3_;
				BackingPhotoRow* _tmp4_;
				BackingPhotoRow* _tmp5_;
				GdkPixbuf* pix = NULL;
				GdkPixbuf* _tmp12_;
				PhotoFileWriter* writer = NULL;
				BackingPhotoRow* _tmp17_;
				const gchar* _tmp18_;
				PhotoFileWriter* _tmp19_;
				PhotoFileWriter* _tmp20_;
				GdkPixbuf* _tmp21_;
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp22_;
				PhotoFileMetadataWriter* mwriter = NULL;
				BackingPhotoRow* _tmp23_;
				const gchar* _tmp24_;
				PhotoFileMetadataWriter* _tmp25_;
				PhotoFileMetadataWriter* _tmp26_;
				PhotoMetadata* _tmp27_;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = self->row;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp2_ = _tmp1_->master;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = _tmp2_->filepath;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = raw_developer_create_backing_row_for_development (d, _tmp3_, NULL, &_inner_error_);
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp0_ = _tmp4_;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6589 "Photo.c"
					goto __catch277_g_error;
				}
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp0_;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp0_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
				bps = _tmp5_;
#line 681 "/home/jens/Source/shotwell/src/Photo.vala"
				pix = NULL;
#line 6602 "Photo.c"
				{
					PhotoBackingReaders* _tmp6_;
#line 682 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp6_ = self->priv->readers;
#line 682 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_lock (&self->priv->__lock_readers);
#line 6609 "Photo.c"
					{
						GdkPixbuf* _tmp7_ = NULL;
						Scaling _tmp8_ = {0};
						GdkPixbuf* _tmp9_;
						GdkPixbuf* _tmp10_;
#line 687 "/home/jens/Source/shotwell/src/Photo.vala"
						scaling_for_original (&_tmp8_);
#line 687 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp9_ = photo_get_master_pixbuf (self, &_tmp8_, FALSE, &_inner_error_);
#line 687 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp7_ = _tmp9_;
#line 687 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6623 "Photo.c"
							goto __finally278;
						}
#line 687 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp10_ = _tmp7_;
#line 687 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp7_ = NULL;
#line 687 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (pix);
#line 687 "/home/jens/Source/shotwell/src/Photo.vala"
						pix = _tmp10_;
#line 682 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_tmp7_);
#line 6636 "Photo.c"
					}
					__finally278:
					{
						PhotoBackingReaders* _tmp11_;
#line 682 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp11_ = self->priv->readers;
#line 682 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 6645 "Photo.c"
					}
#line 682 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 682 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (pix);
#line 682 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (_tmp0_);
#line 6653 "Photo.c"
						goto __catch277_g_error;
					}
				}
#line 690 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = pix;
#line 690 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp12_ == NULL) {
#line 691 "/home/jens/Source/shotwell/src/Photo.vala"
					g_debug ("Photo.vala:691: Could not get preview pixbuf");
#line 692 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 692 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp0_);
#line 6667 "Photo.c"
					{
						gboolean _tmp13_;
#line 716 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp13_ = wrote_img_to_disk;
#line 716 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp13_) {
#line 6674 "Photo.c"
							{
								BackingPhotoRow* _tmp14_;
#line 719 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp14_ = bps;
#line 719 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_add_backing_photo_for_development (self, d, _tmp14_, notify, &_inner_error_);
#line 719 "/home/jens/Source/shotwell/src/Photo.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6683 "Photo.c"
									goto __catch279_g_error;
								}
#line 721 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_notify_raw_development_modified (self);
#line 6688 "Photo.c"
							}
							goto __finally279;
							__catch279_g_error:
							{
								GError* e = NULL;
								GError* _tmp15_;
								const gchar* _tmp16_;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
								e = _inner_error_;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
								_inner_error_ = NULL;
#line 723 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp15_ = e;
#line 723 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp16_ = _tmp15_->message;
#line 723 "/home/jens/Source/shotwell/src/Photo.vala"
								g_debug ("Photo.vala:723: Error adding backing photo as development. Message: %s", _tmp16_);
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_error_free0 (e);
#line 6708 "Photo.c"
							}
							__finally279:
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6713 "Photo.c"
								goto __catch277_g_error;
							}
						}
					}
#line 692 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bps);
#line 692 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 6722 "Photo.c"
				}
#line 696 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = bps;
#line 696 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = _tmp17_->filepath;
#line 696 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = photo_file_format_create_writer (PHOTO_FILE_FORMAT_JFIF, _tmp18_, &_inner_error_);
#line 696 "/home/jens/Source/shotwell/src/Photo.vala"
				writer = _tmp19_;
#line 696 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 696 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 696 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp0_);
#line 6738 "Photo.c"
					goto __catch277_g_error;
				}
#line 697 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = writer;
#line 697 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp21_ = pix;
#line 697 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_file_writer_write (_tmp20_, _tmp21_, JPEG_QUALITY_HIGH, &_inner_error_);
#line 697 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 697 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 697 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 697 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp0_);
#line 6755 "Photo.c"
					goto __catch277_g_error;
				}
#line 705 "/home/jens/Source/shotwell/src/Photo.vala"
				wrote_img_to_disk = TRUE;
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp22_ = photo_get_master_metadata (self, &_inner_error_);
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
				meta = _tmp22_;
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp0_);
#line 6772 "Photo.c"
					goto __catch277_g_error;
				}
#line 711 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = bps;
#line 711 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = _tmp23_->filepath;
#line 711 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = photo_file_format_create_metadata_writer (PHOTO_FILE_FORMAT_JFIF, _tmp24_, &_inner_error_);
#line 711 "/home/jens/Source/shotwell/src/Photo.vala"
				mwriter = _tmp25_;
#line 711 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 711 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 711 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 711 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 711 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp0_);
#line 6793 "Photo.c"
					goto __catch277_g_error;
				}
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = mwriter;
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = meta;
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_file_metadata_writer_write_metadata (_tmp26_, _tmp27_, &_inner_error_);
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (mwriter);
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp0_);
#line 6814 "Photo.c"
					goto __catch277_g_error;
				}
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_file_adapter_unref0 (mwriter);
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_media_metadata_unref0 (meta);
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_file_adapter_unref0 (writer);
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (pix);
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp0_);
#line 6827 "Photo.c"
			}
			goto __finally277;
			__catch277_g_error:
			{
				GError* err = NULL;
				GError* _tmp28_;
				const gchar* _tmp29_;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				err = _inner_error_;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 714 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = err;
#line 714 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = _tmp28_->message;
#line 714 "/home/jens/Source/shotwell/src/Photo.vala"
				g_debug ("Photo.vala:714: Error developing photo: %s", _tmp29_);
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (err);
#line 6847 "Photo.c"
			}
			__finally277:
			{
				gboolean _tmp30_;
#line 716 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = wrote_img_to_disk;
#line 716 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp30_) {
#line 6856 "Photo.c"
					{
						BackingPhotoRow* _tmp31_;
#line 719 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp31_ = bps;
#line 719 "/home/jens/Source/shotwell/src/Photo.vala"
						photo_add_backing_photo_for_development (self, d, _tmp31_, notify, &_inner_error_);
#line 719 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6865 "Photo.c"
							goto __catch280_g_error;
						}
#line 721 "/home/jens/Source/shotwell/src/Photo.vala"
						photo_notify_raw_development_modified (self);
#line 6870 "Photo.c"
					}
					goto __finally280;
					__catch280_g_error:
					{
						GError* e = NULL;
						GError* _tmp32_;
						const gchar* _tmp33_;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						e = _inner_error_;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						_inner_error_ = NULL;
#line 723 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp32_ = e;
#line 723 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp33_ = _tmp32_->message;
#line 723 "/home/jens/Source/shotwell/src/Photo.vala"
						g_debug ("Photo.vala:723: Error adding backing photo as development. Message: %s", _tmp33_);
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_error_free0 (e);
#line 6890 "Photo.c"
					}
					__finally280:
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (bps);
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						g_clear_error (&_inner_error_);
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						return;
#line 6903 "Photo.c"
					}
				}
			}
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 6917 "Photo.c"
			}
#line 729 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 6921 "Photo.c"
		}
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_CAMERA:
#line 6925 "Photo.c"
		{
#line 733 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 6929 "Photo.c"
		}
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_EMBEDDED:
#line 6933 "Photo.c"
		{
			{
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp34_;
				guint c = 0U;
				PhotoMetadata* _tmp35_;
				guint _tmp36_;
				PhotoPreview* prev = NULL;
				PhotoMetadata* _tmp41_;
				guint _tmp42_;
				PhotoPreview* _tmp43_;
				PhotoPreview* _tmp44_;
				GBytes* pix = NULL;
				PhotoPreview* _tmp49_;
				GBytes* _tmp50_;
				GBytes* _tmp51_;
				BackingPhotoRow* _tmp56_ = NULL;
				PhotoRow* _tmp57_;
				BackingPhotoRow* _tmp58_;
				const gchar* _tmp59_;
				BackingPhotoRow* _tmp60_;
				BackingPhotoRow* _tmp61_;
				gboolean _tmp62_ = FALSE;
				GBytes* _tmp63_;
				PhotoFileMetadataWriter* mwriter = NULL;
				BackingPhotoRow* _tmp83_;
				const gchar* _tmp84_;
				PhotoFileMetadataWriter* _tmp85_;
				PhotoFileMetadataWriter* _tmp86_;
				PhotoMetadata* _tmp87_;
#line 738 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = photo_get_master_metadata (self, &_inner_error_);
#line 738 "/home/jens/Source/shotwell/src/Photo.vala"
				meta = _tmp34_;
#line 738 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6970 "Photo.c"
					goto __catch281_g_error;
				}
#line 739 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = meta;
#line 739 "/home/jens/Source/shotwell/src/Photo.vala"
				c = photo_metadata_get_preview_count (_tmp35_);
#line 740 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp36_ = c;
#line 740 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp36_ <= ((guint) 0)) {
#line 741 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6983 "Photo.c"
					{
						gboolean _tmp37_;
#line 786 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp37_ = wrote_img_to_disk;
#line 786 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp37_) {
#line 6990 "Photo.c"
							{
								BackingPhotoRow* _tmp38_;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp38_ = bps;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_add_backing_photo_for_development (self, d, _tmp38_, notify, &_inner_error_);
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6999 "Photo.c"
									goto __catch282_g_error;
								}
#line 791 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_notify_raw_development_modified (self);
#line 7004 "Photo.c"
							}
							goto __finally282;
							__catch282_g_error:
							{
								GError* e = NULL;
								GError* _tmp39_;
								const gchar* _tmp40_;
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
								e = _inner_error_;
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
								_inner_error_ = NULL;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp39_ = e;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp40_ = _tmp39_->message;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
								g_debug ("Photo.vala:793: Error adding backing photo as development. Message: %s", _tmp40_);
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_error_free0 (e);
#line 7024 "Photo.c"
							}
							__finally282:
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7029 "Photo.c"
								goto __catch281_g_error;
							}
						}
					}
#line 741 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bps);
#line 741 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 7038 "Photo.c"
				}
#line 742 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp41_ = meta;
#line 742 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp42_ = c;
#line 742 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp43_ = photo_metadata_get_preview (_tmp41_, _tmp42_ - 1);
#line 742 "/home/jens/Source/shotwell/src/Photo.vala"
				prev = _tmp43_;
#line 743 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp44_ = prev;
#line 743 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp44_ == NULL) {
#line 744 "/home/jens/Source/shotwell/src/Photo.vala"
					g_debug ("Photo.vala:744: Could not get preview from metadata");
#line 745 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 745 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 7058 "Photo.c"
					{
						gboolean _tmp45_;
#line 786 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp45_ = wrote_img_to_disk;
#line 786 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp45_) {
#line 7065 "Photo.c"
							{
								BackingPhotoRow* _tmp46_;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp46_ = bps;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_add_backing_photo_for_development (self, d, _tmp46_, notify, &_inner_error_);
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7074 "Photo.c"
									goto __catch283_g_error;
								}
#line 791 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_notify_raw_development_modified (self);
#line 7079 "Photo.c"
							}
							goto __finally283;
							__catch283_g_error:
							{
								GError* e = NULL;
								GError* _tmp47_;
								const gchar* _tmp48_;
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
								e = _inner_error_;
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
								_inner_error_ = NULL;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp47_ = e;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp48_ = _tmp47_->message;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
								g_debug ("Photo.vala:793: Error adding backing photo as development. Message: %s", _tmp48_);
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_error_free0 (e);
#line 7099 "Photo.c"
							}
							__finally283:
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7104 "Photo.c"
								goto __catch281_g_error;
							}
						}
					}
#line 745 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bps);
#line 745 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 7113 "Photo.c"
				}
#line 748 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp49_ = prev;
#line 748 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp50_ = photo_preview_flatten (_tmp49_, &_inner_error_);
#line 748 "/home/jens/Source/shotwell/src/Photo.vala"
				pix = _tmp50_;
#line 748 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 748 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 748 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 7127 "Photo.c"
					goto __catch281_g_error;
				}
#line 749 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp51_ = pix;
#line 749 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp51_ == NULL) {
#line 750 "/home/jens/Source/shotwell/src/Photo.vala"
					g_debug ("Photo.vala:750: Could not get preview pixbuf");
#line 751 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_bytes_unref0 (pix);
#line 751 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 751 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 7142 "Photo.c"
					{
						gboolean _tmp52_;
#line 786 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp52_ = wrote_img_to_disk;
#line 786 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp52_) {
#line 7149 "Photo.c"
							{
								BackingPhotoRow* _tmp53_;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp53_ = bps;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_add_backing_photo_for_development (self, d, _tmp53_, notify, &_inner_error_);
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7158 "Photo.c"
									goto __catch284_g_error;
								}
#line 791 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_notify_raw_development_modified (self);
#line 7163 "Photo.c"
							}
							goto __finally284;
							__catch284_g_error:
							{
								GError* e = NULL;
								GError* _tmp54_;
								const gchar* _tmp55_;
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
								e = _inner_error_;
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
								_inner_error_ = NULL;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp54_ = e;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp55_ = _tmp54_->message;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
								g_debug ("Photo.vala:793: Error adding backing photo as development. Message: %s", _tmp55_);
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_error_free0 (e);
#line 7183 "Photo.c"
							}
							__finally284:
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7188 "Photo.c"
								goto __catch281_g_error;
							}
						}
					}
#line 751 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bps);
#line 751 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 7197 "Photo.c"
				}
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp57_ = self->row;
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp58_ = _tmp57_->master;
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp59_ = _tmp58_->filepath;
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp60_ = raw_developer_create_backing_row_for_development (d, _tmp59_, NULL, &_inner_error_);
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp56_ = _tmp60_;
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_bytes_unref0 (pix);
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 7217 "Photo.c"
					goto __catch281_g_error;
				}
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp61_ = _tmp56_;
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp56_ = NULL;
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				bps = _tmp61_;
#line 759 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp63_ = pix;
#line 759 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp62_ = jpeg_is_jpeg_bytes (_tmp63_, &_inner_error_);
#line 759 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 759 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp56_);
#line 759 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_bytes_unref0 (pix);
#line 759 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 759 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 7242 "Photo.c"
					goto __catch281_g_error;
				}
#line 759 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp62_) {
#line 7247 "Photo.c"
					GFile* outfile = NULL;
					BackingPhotoRow* _tmp64_;
					const gchar* _tmp65_;
					GFile* _tmp66_;
					GFile* _tmp67_;
					GBytes* _tmp68_;
					gsize _tmp69_;
					guint8* _tmp70_;
#line 760 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp64_ = bps;
#line 760 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp65_ = _tmp64_->filepath;
#line 760 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp66_ = g_file_new_for_path (_tmp65_);
#line 760 "/home/jens/Source/shotwell/src/Photo.vala"
					outfile = _tmp66_;
#line 761 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp67_ = outfile;
#line 761 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp68_ = pix;
#line 761 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp70_ = g_bytes_get_data (_tmp68_, &_tmp69_);
#line 761 "/home/jens/Source/shotwell/src/Photo.vala"
					g_file_replace_contents (_tmp67_, _tmp70_, (gsize) _tmp69_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
#line 761 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 761 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (outfile);
#line 761 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (_tmp56_);
#line 761 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_bytes_unref0 (pix);
#line 761 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_preview_unref0 (prev);
#line 761 "/home/jens/Source/shotwell/src/Photo.vala"
						_media_metadata_unref0 (meta);
#line 7284 "Photo.c"
						goto __catch281_g_error;
					}
#line 759 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (outfile);
#line 7289 "Photo.c"
				} else {
					GdkPixbuf* pixbuf = NULL;
					PhotoPreview* _tmp71_;
					GdkPixbuf* _tmp72_;
					GdkPixbuf* _tmp73_;
					PhotoFileWriter* writer = NULL;
					BackingPhotoRow* _tmp78_;
					const gchar* _tmp79_;
					PhotoFileWriter* _tmp80_;
					PhotoFileWriter* _tmp81_;
					GdkPixbuf* _tmp82_;
#line 764 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp71_ = prev;
#line 764 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp72_ = photo_preview_get_pixbuf (_tmp71_, &_inner_error_);
#line 764 "/home/jens/Source/shotwell/src/Photo.vala"
					pixbuf = _tmp72_;
#line 764 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 764 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (_tmp56_);
#line 764 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_bytes_unref0 (pix);
#line 764 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_preview_unref0 (prev);
#line 764 "/home/jens/Source/shotwell/src/Photo.vala"
						_media_metadata_unref0 (meta);
#line 7317 "Photo.c"
						goto __catch281_g_error;
					}
#line 765 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp73_ = pixbuf;
#line 765 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp73_ == NULL) {
#line 766 "/home/jens/Source/shotwell/src/Photo.vala"
						g_debug ("Photo.vala:766: Could not get preview pixbuf");
#line 767 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (pixbuf);
#line 767 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (_tmp56_);
#line 767 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_bytes_unref0 (pix);
#line 767 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_preview_unref0 (prev);
#line 767 "/home/jens/Source/shotwell/src/Photo.vala"
						_media_metadata_unref0 (meta);
#line 7336 "Photo.c"
						{
							gboolean _tmp74_;
#line 786 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp74_ = wrote_img_to_disk;
#line 786 "/home/jens/Source/shotwell/src/Photo.vala"
							if (_tmp74_) {
#line 7343 "Photo.c"
								{
									BackingPhotoRow* _tmp75_;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp75_ = bps;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
									photo_add_backing_photo_for_development (self, d, _tmp75_, notify, &_inner_error_);
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
									if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7352 "Photo.c"
										goto __catch285_g_error;
									}
#line 791 "/home/jens/Source/shotwell/src/Photo.vala"
									photo_notify_raw_development_modified (self);
#line 7357 "Photo.c"
								}
								goto __finally285;
								__catch285_g_error:
								{
									GError* e = NULL;
									GError* _tmp76_;
									const gchar* _tmp77_;
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
									e = _inner_error_;
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
									_inner_error_ = NULL;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp76_ = e;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp77_ = _tmp76_->message;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
									g_debug ("Photo.vala:793: Error adding backing photo as development. Message: %s", _tmp77_);
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
									_g_error_free0 (e);
#line 7377 "Photo.c"
								}
								__finally285:
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7382 "Photo.c"
									goto __catch281_g_error;
								}
							}
						}
#line 767 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (bps);
#line 767 "/home/jens/Source/shotwell/src/Photo.vala"
						return;
#line 7391 "Photo.c"
					}
#line 770 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp78_ = bps;
#line 770 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp79_ = _tmp78_->filepath;
#line 770 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp80_ = photo_file_format_create_writer (PHOTO_FILE_FORMAT_JFIF, _tmp79_, &_inner_error_);
#line 770 "/home/jens/Source/shotwell/src/Photo.vala"
					writer = _tmp80_;
#line 770 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 770 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (pixbuf);
#line 770 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (_tmp56_);
#line 770 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_bytes_unref0 (pix);
#line 770 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_preview_unref0 (prev);
#line 770 "/home/jens/Source/shotwell/src/Photo.vala"
						_media_metadata_unref0 (meta);
#line 7413 "Photo.c"
						goto __catch281_g_error;
					}
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp81_ = writer;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp82_ = pixbuf;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
					photo_file_writer_write (_tmp81_, _tmp82_, JPEG_QUALITY_HIGH, &_inner_error_);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_file_adapter_unref0 (writer);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (pixbuf);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (_tmp56_);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_bytes_unref0 (pix);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_preview_unref0 (prev);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
						_media_metadata_unref0 (meta);
#line 7436 "Photo.c"
						goto __catch281_g_error;
					}
#line 759 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 759 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pixbuf);
#line 7443 "Photo.c"
				}
#line 777 "/home/jens/Source/shotwell/src/Photo.vala"
				wrote_img_to_disk = TRUE;
#line 780 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp83_ = bps;
#line 780 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp84_ = _tmp83_->filepath;
#line 780 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp85_ = photo_file_format_create_metadata_writer (PHOTO_FILE_FORMAT_JFIF, _tmp84_, &_inner_error_);
#line 780 "/home/jens/Source/shotwell/src/Photo.vala"
				mwriter = _tmp85_;
#line 780 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 780 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp56_);
#line 780 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_bytes_unref0 (pix);
#line 780 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 780 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 7465 "Photo.c"
					goto __catch281_g_error;
				}
#line 781 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp86_ = mwriter;
#line 781 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp87_ = meta;
#line 781 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_file_metadata_writer_write_metadata (_tmp86_, _tmp87_, &_inner_error_);
#line 781 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 781 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (mwriter);
#line 781 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp56_);
#line 781 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_bytes_unref0 (pix);
#line 781 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 781 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 7486 "Photo.c"
					goto __catch281_g_error;
				}
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_file_adapter_unref0 (mwriter);
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp56_);
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_bytes_unref0 (pix);
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_preview_unref0 (prev);
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				_media_metadata_unref0 (meta);
#line 7499 "Photo.c"
			}
			goto __finally281;
			__catch281_g_error:
			{
				GError* e = NULL;
				GError* _tmp88_;
				const gchar* _tmp89_;
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				e = _inner_error_;
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 783 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp88_ = e;
#line 783 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp89_ = _tmp88_->message;
#line 783 "/home/jens/Source/shotwell/src/Photo.vala"
				g_debug ("Photo.vala:783: Error accessing embedded preview. Message: %s", _tmp89_);
#line 784 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (e);
#line 7519 "Photo.c"
				{
					gboolean _tmp90_;
#line 786 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp90_ = wrote_img_to_disk;
#line 786 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp90_) {
#line 7526 "Photo.c"
						{
							BackingPhotoRow* _tmp91_;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp91_ = bps;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
							photo_add_backing_photo_for_development (self, d, _tmp91_, notify, &_inner_error_);
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7535 "Photo.c"
								goto __catch286_g_error;
							}
#line 791 "/home/jens/Source/shotwell/src/Photo.vala"
							photo_notify_raw_development_modified (self);
#line 7540 "Photo.c"
						}
						goto __finally286;
						__catch286_g_error:
						{
							GError* e = NULL;
							GError* _tmp92_;
							const gchar* _tmp93_;
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
							e = _inner_error_;
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
							_inner_error_ = NULL;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp92_ = e;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp93_ = _tmp92_->message;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
							g_debug ("Photo.vala:793: Error adding backing photo as development. Message: %s", _tmp93_);
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_error_free0 (e);
#line 7560 "Photo.c"
						}
						__finally286:
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
							_backing_photo_row_unref0 (bps);
#line 7567 "Photo.c"
						}
					}
				}
#line 784 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 784 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 7575 "Photo.c"
			}
			__finally281:
			{
				gboolean _tmp94_;
#line 786 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp94_ = wrote_img_to_disk;
#line 786 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp94_) {
#line 7584 "Photo.c"
					{
						BackingPhotoRow* _tmp95_;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp95_ = bps;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
						photo_add_backing_photo_for_development (self, d, _tmp95_, notify, &_inner_error_);
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7593 "Photo.c"
							goto __catch287_g_error;
						}
#line 791 "/home/jens/Source/shotwell/src/Photo.vala"
						photo_notify_raw_development_modified (self);
#line 7598 "Photo.c"
					}
					goto __finally287;
					__catch287_g_error:
					{
						GError* e = NULL;
						GError* _tmp96_;
						const gchar* _tmp97_;
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
						e = _inner_error_;
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
						_inner_error_ = NULL;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp96_ = e;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp97_ = _tmp96_->message;
#line 793 "/home/jens/Source/shotwell/src/Photo.vala"
						g_debug ("Photo.vala:793: Error adding backing photo as development. Message: %s", _tmp97_);
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_error_free0 (e);
#line 7618 "Photo.c"
					}
					__finally287:
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (bps);
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
						g_clear_error (&_inner_error_);
#line 787 "/home/jens/Source/shotwell/src/Photo.vala"
						return;
#line 7631 "Photo.c"
					}
				}
			}
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 7645 "Photo.c"
			}
#line 798 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 7649 "Photo.c"
		}
		default:
		{
#line 801 "/home/jens/Source/shotwell/src/Photo.vala"
			g_assert_not_reached ();
#line 7655 "Photo.c"
		}
	}
#line 672 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (bps);
#line 7660 "Photo.c"
}


void
photo_set_default_raw_developer (Photo* self,
                                 RawDeveloper d)
{
	GError * _inner_error_ = NULL;
#line 806 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 7671 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 807 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 807 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 7678 "Photo.c"
		{
			PhotoRow* _tmp1_;
#line 808 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 808 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_->developer = d;
#line 7685 "Photo.c"
		}
		__finally288:
		{
			PhotoRow* _tmp2_;
#line 807 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 807 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 7694 "Photo.c"
		}
#line 807 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 807 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 807 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 807 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 7704 "Photo.c"
		}
	}
}


void
photo_set_raw_developer (Photo* self,
                         RawDeveloper d,
                         gboolean notify)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 813 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 814 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_get_master_file_format (self) != PHOTO_FILE_FORMAT_RAW) {
#line 815 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 7724 "Photo.c"
	}
#line 820 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_is_raw_developer_available (self, RAW_DEVELOPER_CAMERA)) {
#line 820 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = d == RAW_DEVELOPER_EMBEDDED;
#line 7730 "Photo.c"
	} else {
#line 820 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = FALSE;
#line 7734 "Photo.c"
	}
#line 820 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_) {
#line 821 "/home/jens/Source/shotwell/src/Photo.vala"
		d = RAW_DEVELOPER_CAMERA;
#line 7740 "Photo.c"
	}
#line 825 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!photo_is_raw_developer_available (self, RAW_DEVELOPER_EMBEDDED)) {
#line 825 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = d != RAW_DEVELOPER_CAMERA;
#line 7746 "Photo.c"
	} else {
#line 825 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = FALSE;
#line 7750 "Photo.c"
	}
#line 825 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_) {
#line 826 "/home/jens/Source/shotwell/src/Photo.vala"
		d = RAW_DEVELOPER_SHOTWELL;
#line 7756 "Photo.c"
	}
	{
		GeeHashMap* _tmp2_;
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = self->priv->developments;
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 7764 "Photo.c"
		{
			RawDeveloper stale_raw_developer = 0;
			PhotoRow* _tmp3_;
			RawDeveloper _tmp4_;
			GeeHashMap* _tmp5_;
			PhotoRow* _tmp7_;
			GeeHashMap* _tmp8_;
			gpointer _tmp9_;
			PhotoBackingReaders* _tmp10_;
			BackingPhotoRow* _tmp11_;
			PhotoFileFormat _tmp12_;
			BackingPhotoRow* _tmp13_;
			const gchar* _tmp14_;
			PhotoFileReader* _tmp15_;
			BackingPhotoRow* _tmp20_;
			Orientation _tmp21_;
			gboolean _tmp30_ = FALSE;
			RawDeveloper _tmp31_;
#line 829 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 829 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->developer;
#line 829 "/home/jens/Source/shotwell/src/Photo.vala"
			stale_raw_developer = _tmp4_;
#line 832 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!photo_is_raw_developer_complete (self, d)) {
#line 833 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_develop_photo (self, d, notify);
#line 7793 "Photo.c"
			}
#line 835 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->developments;
#line 835 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d))) {
#line 7799 "Photo.c"
				{
					GeeHashMap* _tmp6_;
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp6_ = self->priv->developments;
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 7806 "Photo.c"
				}
#line 836 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 7810 "Photo.c"
			}
#line 839 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_revert_to_master (self, FALSE);
#line 842 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 842 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_->developer = d;
#line 843 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = self->priv->developments;
#line 843 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d));
#line 843 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (self->backing_photo_row);
#line 843 "/home/jens/Source/shotwell/src/Photo.vala"
			self->backing_photo_row = (BackingPhotoRow*) _tmp9_;
#line 844 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = self->priv->readers;
#line 844 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = self->backing_photo_row;
#line 844 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = _tmp11_->file_format;
#line 844 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->backing_photo_row;
#line 844 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = _tmp13_->filepath;
#line 844 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = photo_file_format_create_reader (_tmp12_, _tmp14_);
#line 844 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (_tmp10_->developer);
#line 844 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_->developer = _tmp15_;
#line 7842 "Photo.c"
			{
				GdkPixbuf* _tmp16_;
				GdkPixbuf* _tmp17_;
#line 847 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = photo_get_prefetched_copy (self, &_inner_error_);
#line 847 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = _tmp16_;
#line 847 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp17_);
#line 847 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7854 "Photo.c"
					goto __catch290_g_error;
				}
			}
			goto __finally290;
			__catch290_g_error:
			{
				GError* e = NULL;
#line 846 "/home/jens/Source/shotwell/src/Photo.vala"
				e = _inner_error_;
#line 846 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 850 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (e);
#line 7868 "Photo.c"
				{
					GeeHashMap* _tmp18_;
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp18_ = self->priv->developments;
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 7875 "Photo.c"
				}
#line 850 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 7879 "Photo.c"
			}
			__finally290:
#line 846 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7884 "Photo.c"
				{
					GeeHashMap* _tmp19_;
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp19_ = self->priv->developments;
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 7891 "Photo.c"
				}
#line 846 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 846 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 846 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 7899 "Photo.c"
			}
#line 853 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp20_ = self->backing_photo_row;
#line 853 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp21_ = _tmp20_->original_orientation;
#line 853 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_set_orientation (self, _tmp21_);
#line 7907 "Photo.c"
			{
				PhotoTable* _tmp22_;
				PhotoTable* _tmp23_;
				PhotoRow* _tmp24_;
				BackingPhotoRow* _tmp25_;
				BackingPhotoID _tmp26_;
#line 856 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp22_ = photo_table_get_instance ();
#line 856 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = _tmp22_;
#line 856 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = self->row;
#line 856 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = self->backing_photo_row;
#line 856 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = _tmp25_->id;
#line 856 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_update_raw_development (_tmp23_, _tmp24_, d, &_tmp26_, &_inner_error_);
#line 856 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp23_);
#line 856 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7930 "Photo.c"
					goto __catch291_g_error;
				}
			}
			goto __finally291;
			__catch291_g_error:
			{
				GError* e = NULL;
				GError* _tmp27_;
				const gchar* _tmp28_;
#line 855 "/home/jens/Source/shotwell/src/Photo.vala"
				e = _inner_error_;
#line 855 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 858 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = e;
#line 858 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = _tmp27_->message;
#line 858 "/home/jens/Source/shotwell/src/Photo.vala"
				g_warning ("Photo.vala:858: Error updating database: %s", _tmp28_);
#line 855 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (e);
#line 7952 "Photo.c"
			}
			__finally291:
#line 855 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7957 "Photo.c"
				{
					GeeHashMap* _tmp29_;
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp29_ = self->priv->developments;
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 7964 "Photo.c"
				}
#line 855 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 855 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 855 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 7972 "Photo.c"
			}
#line 865 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp31_ = stale_raw_developer;
#line 865 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp31_ != RAW_DEVELOPER_CAMERA) {
#line 7978 "Photo.c"
				RawDeveloper _tmp32_;
				PhotoRow* _tmp33_;
				RawDeveloper _tmp34_;
#line 866 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp32_ = stale_raw_developer;
#line 866 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = self->row;
#line 866 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = _tmp33_->developer;
#line 866 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = _tmp32_ != _tmp34_;
#line 7990 "Photo.c"
			} else {
#line 865 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = FALSE;
#line 7994 "Photo.c"
			}
#line 865 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp30_) {
#line 7998 "Photo.c"
				RawDeveloper _tmp35_;
#line 869 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = stale_raw_developer;
#line 869 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_delete_raw_development (self, _tmp35_);
#line 8004 "Photo.c"
			}
		}
		__finally289:
		{
			GeeHashMap* _tmp36_;
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp36_ = self->priv->developments;
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 8014 "Photo.c"
		}
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 8024 "Photo.c"
		}
	}
#line 876 "/home/jens/Source/shotwell/src/Photo.vala"
	if (notify) {
#line 8029 "Photo.c"
		Alteration* _tmp37_;
		Alteration* _tmp38_;
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp37_ = alteration_new ("image", "developer");
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp38_ = _tmp37_;
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp38_);
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp38_);
#line 8040 "Photo.c"
	}
#line 878 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_discard_prefetched (self);
#line 8044 "Photo.c"
}


RawDeveloper
photo_get_raw_developer (Photo* self)
{
	RawDeveloper result = 0;
	PhotoRow* _tmp0_;
	RawDeveloper _tmp1_;
#line 881 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 882 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->row;
#line 882 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->developer;
#line 882 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp1_;
#line 882 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 8064 "Photo.c"
}


static gboolean
photo_delete_raw_development (Photo* self,
                              RawDeveloper d)
{
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
#line 887 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 888 "/home/jens/Source/shotwell/src/Photo.vala"
	ret = FALSE;
#line 8079 "Photo.c"
	{
		GeeHashMap* _tmp0_;
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->developments;
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 8086 "Photo.c"
		{
			GeeHashMap* _tmp1_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			BackingPhotoRow* bpr = NULL;
			GeeHashMap* _tmp7_;
			gpointer _tmp8_;
			BackingPhotoRow* _tmp9_;
			const gchar* _tmp10_;
			GeeHashMap* _tmp33_;
			gboolean _tmp34_;
#line 891 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->developments;
#line 891 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d))) {
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				result = FALSE;
#line 8106 "Photo.c"
				{
					GeeHashMap* _tmp2_;
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp2_ = self->priv->developments;
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 8113 "Photo.c"
				}
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 8117 "Photo.c"
			}
#line 896 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 896 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_;
#line 896 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = raw_developer_to_string (d);
#line 896 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_;
#line 896 "/home/jens/Source/shotwell/src/Photo.vala"
			g_debug ("Photo.vala:896: Delete raw development: %s %s", _tmp4_, _tmp6_);
#line 896 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp6_);
#line 896 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp4_);
#line 897 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->priv->developments;
#line 897 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d));
#line 897 "/home/jens/Source/shotwell/src/Photo.vala"
			bpr = (BackingPhotoRow*) _tmp8_;
#line 898 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = bpr;
#line 898 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = _tmp9_->filepath;
#line 898 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp10_ != NULL) {
#line 8145 "Photo.c"
				GFile* f = NULL;
				BackingPhotoRow* _tmp11_;
				const gchar* _tmp12_;
				GFile* _tmp13_;
#line 899 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = bpr;
#line 899 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = _tmp11_->filepath;
#line 899 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = g_file_new_for_path (_tmp12_);
#line 899 "/home/jens/Source/shotwell/src/Photo.vala"
				f = _tmp13_;
#line 8158 "Photo.c"
				{
#line 901 "/home/jens/Source/shotwell/src/Photo.vala"
					if (d == RAW_DEVELOPER_CAMERA) {
#line 8162 "Photo.c"
						GFile* _tmp14_;
#line 902 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp14_ = f;
#line 902 "/home/jens/Source/shotwell/src/Photo.vala"
						g_file_trash (_tmp14_, NULL, &_inner_error_);
#line 902 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8170 "Photo.c"
							goto __catch293_g_error;
						}
					} else {
						GFile* _tmp15_;
#line 904 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp15_ = f;
#line 904 "/home/jens/Source/shotwell/src/Photo.vala"
						g_file_delete (_tmp15_, NULL, &_inner_error_);
#line 904 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8181 "Photo.c"
							goto __catch293_g_error;
						}
					}
				}
				goto __finally293;
				__catch293_g_error:
				{
					GError* e = NULL;
					BackingPhotoRow* _tmp16_;
					const gchar* _tmp17_;
					GError* _tmp18_;
					const gchar* _tmp19_;
#line 900 "/home/jens/Source/shotwell/src/Photo.vala"
					e = _inner_error_;
#line 900 "/home/jens/Source/shotwell/src/Photo.vala"
					_inner_error_ = NULL;
#line 906 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp16_ = bpr;
#line 906 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp17_ = _tmp16_->filepath;
#line 906 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp18_ = e;
#line 906 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp19_ = _tmp18_->message;
#line 906 "/home/jens/Source/shotwell/src/Photo.vala"
					g_warning ("Photo.vala:906: Unable to delete RAW development: %s error: %s", _tmp17_, _tmp19_);
#line 900 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_error_free0 (e);
#line 8210 "Photo.c"
				}
				__finally293:
#line 900 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8215 "Photo.c"
					gboolean _tmp21_ = FALSE;
#line 900 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (f);
#line 900 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bpr);
#line 900 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (f);
#line 900 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bpr);
#line 8225 "Photo.c"
					{
						GeeHashMap* _tmp20_;
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp20_ = self->priv->developments;
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 8232 "Photo.c"
					}
#line 900 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 900 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 900 "/home/jens/Source/shotwell/src/Photo.vala"
					return _tmp21_;
#line 8240 "Photo.c"
				}
#line 898 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (f);
#line 8244 "Photo.c"
			}
			{
				PhotoTable* _tmp22_;
				PhotoTable* _tmp23_;
				PhotoRow* _tmp24_;
				BackingPhotoTable* _tmp25_;
				BackingPhotoTable* _tmp26_;
				BackingPhotoRow* _tmp27_;
				BackingPhotoID _tmp28_;
#line 912 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp22_ = photo_table_get_instance ();
#line 912 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = _tmp22_;
#line 912 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = self->row;
#line 912 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_remove_development (_tmp23_, _tmp24_, d, &_inner_error_);
#line 912 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp23_);
#line 912 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8266 "Photo.c"
					goto __catch294_g_error;
				}
#line 913 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = backing_photo_table_get_instance ();
#line 913 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = _tmp25_;
#line 913 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = bpr;
#line 913 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = _tmp27_->id;
#line 913 "/home/jens/Source/shotwell/src/Photo.vala"
				backing_photo_table_remove (_tmp26_, &_tmp28_, &_inner_error_);
#line 913 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp26_);
#line 913 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8283 "Photo.c"
					goto __catch294_g_error;
				}
			}
			goto __finally294;
			__catch294_g_error:
			{
				GError* e = NULL;
				GError* _tmp29_;
				const gchar* _tmp30_;
#line 911 "/home/jens/Source/shotwell/src/Photo.vala"
				e = _inner_error_;
#line 911 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 915 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = e;
#line 915 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = _tmp29_->message;
#line 915 "/home/jens/Source/shotwell/src/Photo.vala"
				g_warning ("Photo.vala:915: Database error while deleting RAW development: %s", _tmp30_);
#line 911 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (e);
#line 8305 "Photo.c"
			}
			__finally294:
#line 911 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8310 "Photo.c"
				gboolean _tmp32_ = FALSE;
#line 911 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bpr);
#line 911 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bpr);
#line 8316 "Photo.c"
				{
					GeeHashMap* _tmp31_;
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp31_ = self->priv->developments;
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 8323 "Photo.c"
				}
#line 911 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 911 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 911 "/home/jens/Source/shotwell/src/Photo.vala"
				return _tmp32_;
#line 8331 "Photo.c"
			}
#line 918 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp33_ = self->priv->developments;
#line 918 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp34_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d), NULL);
#line 918 "/home/jens/Source/shotwell/src/Photo.vala"
			ret = _tmp34_;
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (bpr);
#line 8341 "Photo.c"
		}
		__finally292:
		{
			GeeHashMap* _tmp35_;
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp35_ = self->priv->developments;
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 8350 "Photo.c"
		}
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8354 "Photo.c"
			gboolean _tmp36_ = FALSE;
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 890 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp36_;
#line 8362 "Photo.c"
		}
	}
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_notify_raw_development_modified (self);
#line 922 "/home/jens/Source/shotwell/src/Photo.vala"
	result = ret;
#line 922 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 8371 "Photo.c"
}


void
photo_redevelop_raw (Photo* self,
                     RawDeveloper d)
{
	GError * _inner_error_ = NULL;
#line 926 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 8382 "Photo.c"
	{
		GeeHashMap* _tmp0_;
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->developments;
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 8389 "Photo.c"
		{
			RawDeveloper dev = 0;
			RawDeveloper _tmp1_;
			RawDeveloper _tmp2_;
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_delete_raw_development (self, d);
#line 929 "/home/jens/Source/shotwell/src/Photo.vala"
			dev = d;
#line 930 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = dev;
#line 930 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp1_ == RAW_DEVELOPER_CAMERA) {
#line 931 "/home/jens/Source/shotwell/src/Photo.vala"
				dev = RAW_DEVELOPER_EMBEDDED;
#line 8404 "Photo.c"
			}
#line 933 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = dev;
#line 933 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_set_raw_developer (self, _tmp2_, TRUE);
#line 8410 "Photo.c"
		}
		__finally295:
		{
			GeeHashMap* _tmp3_;
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->priv->developments;
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 8419 "Photo.c"
		}
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 8429 "Photo.c"
		}
	}
}


static void
_vala_array_add88 (BackingFileState** * array,
                   int* length,
                   int* size,
                   BackingFileState* value)
{
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
#line 8447 "Photo.c"
	}
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 8453 "Photo.c"
}


static void
_vala_array_add89 (BackingFileState** * array,
                   int* length,
                   int* size,
                   BackingFileState* value)
{
#line 942 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 942 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 942 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
#line 8469 "Photo.c"
	}
#line 942 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 942 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 8475 "Photo.c"
}


static void
_vala_array_add90 (BackingFileState** * array,
                   int* length,
                   int* size,
                   BackingFileState* value)
{
#line 949 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 949 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 949 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
#line 8491 "Photo.c"
	}
#line 949 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 949 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 8497 "Photo.c"
}


static BackingFileState**
photo_real_get_backing_files_state (MediaSource* base,
                                    int* result_length1)
{
	Photo * self;
	BackingFileState** result = NULL;
	BackingFileState** backing = NULL;
	BackingFileState** _tmp0_;
	gint backing_length1;
	gint _backing_size_;
	BackingFileState** _tmp24_;
	gint _tmp24__length1;
	GError * _inner_error_ = NULL;
#line 937 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 938 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = g_new0 (BackingFileState*, 0 + 1);
#line 938 "/home/jens/Source/shotwell/src/Photo.vala"
	backing = _tmp0_;
#line 938 "/home/jens/Source/shotwell/src/Photo.vala"
	backing_length1 = 0;
#line 938 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_size_ = backing_length1;
#line 8524 "Photo.c"
	{
		PhotoRow* _tmp1_;
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = self->row;
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 8531 "Photo.c"
		{
			BackingFileState** _tmp2_;
			gint _tmp2__length1;
			PhotoRow* _tmp3_;
			BackingPhotoRow* _tmp4_;
			PhotoRow* _tmp5_;
			const gchar* _tmp6_;
			BackingFileState* _tmp7_;
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = backing;
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2__length1 = backing_length1;
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->master;
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_->md5;
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = backing_file_state_new_from_photo_row (_tmp4_, _tmp6_);
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add88 (&backing, &backing_length1, &_backing_size_, _tmp7_);
#line 941 "/home/jens/Source/shotwell/src/Photo.vala"
			if (photo_has_editable (self)) {
#line 8558 "Photo.c"
				BackingFileState** _tmp8_;
				gint _tmp8__length1;
				BackingPhotoRow* _tmp9_;
				BackingFileState* _tmp10_;
#line 942 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = backing;
#line 942 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8__length1 = backing_length1;
#line 942 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = self->priv->editable;
#line 942 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = backing_file_state_new_from_photo_row (_tmp9_, NULL);
#line 942 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_array_add89 (&backing, &backing_length1, &_backing_size_, _tmp10_);
#line 8573 "Photo.c"
			}
#line 944 "/home/jens/Source/shotwell/src/Photo.vala"
			if (photo_is_developed (self)) {
#line 8577 "Photo.c"
				GeeCollection* dev_rows = NULL;
				GeeCollection* _tmp11_;
				GeeCollection* _tmp12_;
#line 945 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = photo_get_raw_development_photo_rows (self);
#line 945 "/home/jens/Source/shotwell/src/Photo.vala"
				dev_rows = _tmp11_;
#line 946 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = dev_rows;
#line 946 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp12_ != NULL) {
#line 8589 "Photo.c"
					{
						GeeIterator* _r_it = NULL;
						GeeCollection* _tmp13_;
						GeeIterator* _tmp14_;
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp13_ = dev_rows;
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp14_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
						_r_it = _tmp14_;
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
						while (TRUE) {
#line 8602 "Photo.c"
							GeeIterator* _tmp15_;
							BackingPhotoRow* r = NULL;
							GeeIterator* _tmp16_;
							gpointer _tmp17_;
							BackingPhotoRow* _tmp18_;
							const gchar* _tmp19_;
							BackingFileState** _tmp20_;
							gint _tmp20__length1;
							BackingPhotoRow* _tmp21_;
							BackingFileState* _tmp22_;
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp15_ = _r_it;
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
							if (!gee_iterator_next (_tmp15_)) {
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
								break;
#line 8619 "Photo.c"
							}
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp16_ = _r_it;
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp17_ = gee_iterator_get (_tmp16_);
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
							r = (BackingPhotoRow*) _tmp17_;
#line 948 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp18_ = r;
#line 948 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp19_ = _tmp18_->filepath;
#line 948 "/home/jens/Source/shotwell/src/Photo.vala"
							g_debug ("Photo.vala:948: adding: %s", _tmp19_);
#line 949 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp20_ = backing;
#line 949 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp20__length1 = backing_length1;
#line 949 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp21_ = r;
#line 949 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp22_ = backing_file_state_new_from_photo_row (_tmp21_, NULL);
#line 949 "/home/jens/Source/shotwell/src/Photo.vala"
							_vala_array_add90 (&backing, &backing_length1, &_backing_size_, _tmp22_);
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
							_backing_photo_row_unref0 (r);
#line 8645 "Photo.c"
						}
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_r_it);
#line 8649 "Photo.c"
					}
				}
#line 944 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (dev_rows);
#line 8654 "Photo.c"
			}
		}
		__finally296:
		{
			PhotoRow* _tmp23_;
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp23_ = self->row;
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8664 "Photo.c"
		}
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
			backing = (_vala_array_free (backing, backing_length1, (GDestroyNotify) backing_file_state_unref), NULL);
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 8676 "Photo.c"
		}
	}
#line 955 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = backing;
#line 955 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24__length1 = backing_length1;
#line 955 "/home/jens/Source/shotwell/src/Photo.vala"
	if (result_length1) {
#line 955 "/home/jens/Source/shotwell/src/Photo.vala"
		*result_length1 = _tmp24__length1;
#line 8687 "Photo.c"
	}
#line 955 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp24_;
#line 955 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 8693 "Photo.c"
}


static PhotoFileReader*
photo_get_backing_reader (Photo* self,
                          BackingFetchMode mode)
{
	PhotoFileReader* result = NULL;
#line 958 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 959 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (mode) {
#line 959 "/home/jens/Source/shotwell/src/Photo.vala"
		case BACKING_FETCH_MODE_MASTER:
#line 8708 "Photo.c"
		{
			PhotoFileReader* _tmp0_;
#line 961 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp0_ = photo_get_master_reader (self);
#line 961 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp0_;
#line 961 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8717 "Photo.c"
		}
#line 959 "/home/jens/Source/shotwell/src/Photo.vala"
		case BACKING_FETCH_MODE_BASELINE:
#line 8721 "Photo.c"
		{
			PhotoFileReader* _tmp1_;
#line 964 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_get_baseline_reader (self);
#line 964 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 964 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8730 "Photo.c"
		}
#line 959 "/home/jens/Source/shotwell/src/Photo.vala"
		case BACKING_FETCH_MODE_SOURCE:
#line 8734 "Photo.c"
		{
			PhotoFileReader* _tmp2_;
#line 967 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = photo_get_source_reader (self);
#line 967 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 967 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8743 "Photo.c"
		}
#line 959 "/home/jens/Source/shotwell/src/Photo.vala"
		case BACKING_FETCH_MODE_UNMODIFIED:
#line 8747 "Photo.c"
		{
#line 970 "/home/jens/Source/shotwell/src/Photo.vala"
			if (photo_get_master_file_format (self) == PHOTO_FILE_FORMAT_RAW) {
#line 8751 "Photo.c"
				PhotoFileReader* _tmp3_;
#line 971 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = photo_get_raw_developer_reader (self);
#line 971 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp3_;
#line 971 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 8759 "Photo.c"
			} else {
				PhotoFileReader* _tmp4_;
#line 973 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = photo_get_master_reader (self);
#line 973 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp4_;
#line 973 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 8768 "Photo.c"
			}
		}
		default:
		{
			GEnumValue* _tmp5_;
#line 976 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = g_enum_get_value (g_type_class_ref (TYPE_BACKING_FETCH_MODE), mode);
#line 976 "/home/jens/Source/shotwell/src/Photo.vala"
			g_error ("Photo.vala:976: Unknown backing fetch mode %s", (_tmp5_ != NULL) ? _tmp5_->value_name : NULL);
#line 8778 "Photo.c"
		}
	}
}


static gpointer
_photo_file_adapter_ref0 (gpointer self)
{
#line 982 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_file_adapter_ref (self) : NULL;
#line 8789 "Photo.c"
}


static PhotoFileReader*
photo_get_master_reader (Photo* self)
{
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 980 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8800 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_;
#line 981 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 981 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8807 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoFileReader* _tmp3_;
#line 982 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 982 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 982 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
#line 982 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 8820 "Photo.c"
			{
				PhotoBackingReaders* _tmp4_;
#line 981 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->readers;
#line 981 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8827 "Photo.c"
			}
#line 982 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8831 "Photo.c"
		}
		__finally297:
		{
			PhotoBackingReaders* _tmp5_;
#line 981 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->readers;
#line 981 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8840 "Photo.c"
		}
#line 981 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 981 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 981 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8848 "Photo.c"
	}
}


PhotoFileReader*
photo_get_editable_reader (Photo* self)
{
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 986 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8860 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8867 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoFileReader* _tmp3_;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 8880 "Photo.c"
			{
				PhotoBackingReaders* _tmp4_;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->readers;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8887 "Photo.c"
			}
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8891 "Photo.c"
		}
		__finally298:
		{
			PhotoBackingReaders* _tmp5_;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->readers;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8900 "Photo.c"
		}
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8908 "Photo.c"
	}
}


static PhotoFileReader*
photo_get_baseline_reader (Photo* self)
{
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 993 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8920 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_;
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8927 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoBackingReaders* _tmp7_;
			PhotoFileReader* _tmp8_;
			PhotoBackingReaders* _tmp13_;
			PhotoFileReader* _tmp14_;
			PhotoFileReader* _tmp15_;
#line 995 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 995 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 995 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 8942 "Photo.c"
				PhotoBackingReaders* _tmp3_;
				PhotoFileReader* _tmp4_;
				PhotoFileReader* _tmp5_;
#line 996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->editable;
#line 996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _photo_file_adapter_ref0 (_tmp4_);
#line 996 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp5_;
#line 8954 "Photo.c"
				{
					PhotoBackingReaders* _tmp6_;
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp6_ = self->priv->readers;
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8961 "Photo.c"
				}
#line 996 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 8965 "Photo.c"
			}
#line 998 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->priv->readers;
#line 998 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_->developer;
#line 998 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp8_ != NULL) {
#line 8973 "Photo.c"
				PhotoBackingReaders* _tmp9_;
				PhotoFileReader* _tmp10_;
				PhotoFileReader* _tmp11_;
#line 999 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = self->priv->readers;
#line 999 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_->developer;
#line 999 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _photo_file_adapter_ref0 (_tmp10_);
#line 999 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp11_;
#line 8985 "Photo.c"
				{
					PhotoBackingReaders* _tmp12_;
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = self->priv->readers;
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8992 "Photo.c"
				}
#line 999 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 8996 "Photo.c"
			}
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->priv->readers;
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = _tmp13_->master;
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _photo_file_adapter_ref0 (_tmp14_);
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp15_;
#line 9006 "Photo.c"
			{
				PhotoBackingReaders* _tmp16_;
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = self->priv->readers;
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9013 "Photo.c"
			}
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 9017 "Photo.c"
		}
		__finally299:
		{
			PhotoBackingReaders* _tmp17_;
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = self->priv->readers;
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9026 "Photo.c"
		}
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 9034 "Photo.c"
	}
}


static PhotoFileReader*
photo_get_source_reader (Photo* self)
{
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 1006 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 9046 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 9053 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoBackingReaders* _tmp7_;
			PhotoFileReader* _tmp8_;
			PhotoBackingReaders* _tmp13_;
			PhotoFileReader* _tmp14_;
			PhotoFileReader* _tmp15_;
#line 1008 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1008 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 1008 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 9068 "Photo.c"
				PhotoBackingReaders* _tmp3_;
				PhotoFileReader* _tmp4_;
				PhotoFileReader* _tmp5_;
#line 1009 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 1009 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->editable;
#line 1009 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _photo_file_adapter_ref0 (_tmp4_);
#line 1009 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp5_;
#line 9080 "Photo.c"
				{
					PhotoBackingReaders* _tmp6_;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp6_ = self->priv->readers;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9087 "Photo.c"
				}
#line 1009 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 9091 "Photo.c"
			}
#line 1011 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->priv->readers;
#line 1011 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_->developer;
#line 1011 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp8_ != NULL) {
#line 9099 "Photo.c"
				PhotoBackingReaders* _tmp9_;
				PhotoFileReader* _tmp10_;
				PhotoFileReader* _tmp11_;
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = self->priv->readers;
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_->developer;
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _photo_file_adapter_ref0 (_tmp10_);
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp11_;
#line 9111 "Photo.c"
				{
					PhotoBackingReaders* _tmp12_;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = self->priv->readers;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9118 "Photo.c"
				}
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 9122 "Photo.c"
			}
#line 1014 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->priv->readers;
#line 1014 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = _tmp13_->master;
#line 1014 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _photo_file_adapter_ref0 (_tmp14_);
#line 1014 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp15_;
#line 9132 "Photo.c"
			{
				PhotoBackingReaders* _tmp16_;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = self->priv->readers;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9139 "Photo.c"
			}
#line 1014 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 9143 "Photo.c"
		}
		__finally300:
		{
			PhotoBackingReaders* _tmp17_;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = self->priv->readers;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9152 "Photo.c"
		}
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 9160 "Photo.c"
	}
}


static PhotoFileReader*
photo_get_raw_developer_reader (Photo* self)
{
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 9172 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_;
#line 1020 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1020 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 9179 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoFileReader* _tmp3_;
#line 1021 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1021 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->developer;
#line 1021 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
#line 1021 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 9192 "Photo.c"
			{
				PhotoBackingReaders* _tmp4_;
#line 1020 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->readers;
#line 1020 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9199 "Photo.c"
			}
#line 1021 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 9203 "Photo.c"
		}
		__finally301:
		{
			PhotoBackingReaders* _tmp5_;
#line 1020 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->readers;
#line 1020 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9212 "Photo.c"
		}
#line 1020 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1020 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1020 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 9220 "Photo.c"
	}
}


gboolean
photo_is_developed (Photo* self)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1025 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 9232 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 9240 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
#line 1027 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1027 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->developer;
#line 1027 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_ != NULL;
#line 9250 "Photo.c"
			{
				PhotoBackingReaders* _tmp3_;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9257 "Photo.c"
			}
#line 1027 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 9261 "Photo.c"
		}
		__finally302:
		{
			PhotoBackingReaders* _tmp4_;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->readers;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9270 "Photo.c"
		}
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 9278 "Photo.c"
	}
}


gboolean
photo_has_editable (Photo* self)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1031 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 9290 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 9298 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
#line 1033 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1033 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 1033 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_ != NULL;
#line 9308 "Photo.c"
			{
				PhotoBackingReaders* _tmp3_;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9315 "Photo.c"
			}
#line 1033 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 9319 "Photo.c"
		}
		__finally303:
		{
			PhotoBackingReaders* _tmp4_;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->readers;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9328 "Photo.c"
		}
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 9336 "Photo.c"
	}
}


gboolean
photo_does_master_exist (Photo* self)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1037 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 9348 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
#line 1038 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1038 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 9356 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
#line 1039 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1039 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 1039 "/home/jens/Source/shotwell/src/Photo.vala"
			result = photo_file_adapter_file_exists (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 9366 "Photo.c"
			{
				PhotoBackingReaders* _tmp3_;
#line 1038 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 1038 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9373 "Photo.c"
			}
#line 1039 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 9377 "Photo.c"
		}
		__finally304:
		{
			PhotoBackingReaders* _tmp4_;
#line 1038 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->readers;
#line 1038 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9386 "Photo.c"
		}
#line 1038 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1038 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1038 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 9394 "Photo.c"
	}
}


gboolean
photo_does_editable_exist (Photo* self)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1044 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 9406 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp8_ = FALSE;
#line 1045 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1045 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 9414 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			PhotoBackingReaders* _tmp2_;
			PhotoFileReader* _tmp3_;
#line 1046 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->readers;
#line 1046 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_->editable;
#line 1046 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_ != NULL) {
#line 9425 "Photo.c"
				PhotoBackingReaders* _tmp4_;
				PhotoFileReader* _tmp5_;
#line 1046 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->readers;
#line 1046 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_->editable;
#line 1046 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = photo_file_adapter_file_exists (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 9434 "Photo.c"
			} else {
#line 1046 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = FALSE;
#line 9438 "Photo.c"
			}
#line 1046 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 9442 "Photo.c"
			{
				PhotoBackingReaders* _tmp6_;
#line 1045 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->priv->readers;
#line 1045 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9449 "Photo.c"
			}
#line 1046 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 9453 "Photo.c"
		}
		__finally305:
		{
			PhotoBackingReaders* _tmp7_;
#line 1045 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->priv->readers;
#line 1045 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9462 "Photo.c"
		}
#line 1045 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1045 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1045 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp8_;
#line 9470 "Photo.c"
	}
}


gboolean
photo_is_master_baseline (Photo* self)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1050 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 9482 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 9490 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_ == NULL;
#line 9500 "Photo.c"
			{
				PhotoBackingReaders* _tmp3_;
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9507 "Photo.c"
			}
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 9511 "Photo.c"
		}
		__finally306:
		{
			PhotoBackingReaders* _tmp4_;
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->readers;
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9520 "Photo.c"
		}
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 9528 "Photo.c"
	}
}


gboolean
photo_is_master_source (Photo* self)
{
	gboolean result = FALSE;
#line 1056 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1057 "/home/jens/Source/shotwell/src/Photo.vala"
	result = !photo_has_editable (self);
#line 1057 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 9543 "Photo.c"
}


gboolean
photo_is_editable_baseline (Photo* self)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1060 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 9554 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
#line 1061 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1061 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 9562 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
#line 1062 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1062 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 1062 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_ != NULL;
#line 9572 "Photo.c"
			{
				PhotoBackingReaders* _tmp3_;
#line 1061 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 1061 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9579 "Photo.c"
			}
#line 1062 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 9583 "Photo.c"
		}
		__finally307:
		{
			PhotoBackingReaders* _tmp4_;
#line 1061 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->readers;
#line 1061 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 9592 "Photo.c"
		}
#line 1061 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1061 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1061 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 9600 "Photo.c"
	}
}


gboolean
photo_is_editable_source (Photo* self)
{
	gboolean result = FALSE;
#line 1066 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1067 "/home/jens/Source/shotwell/src/Photo.vala"
	result = photo_has_editable (self);
#line 1067 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 9615 "Photo.c"
}


BackingPhotoRow*
photo_get_master_photo_row (Photo* self)
{
	BackingPhotoRow* result = NULL;
	GError * _inner_error_ = NULL;
#line 1070 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 9626 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 1071 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1071 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 9633 "Photo.c"
		{
			PhotoRow* _tmp1_;
			BackingPhotoRow* _tmp2_;
			BackingPhotoRow* _tmp3_;
#line 1072 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 1072 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 1072 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _backing_photo_row_ref0 (_tmp2_);
#line 1072 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 9646 "Photo.c"
			{
				PhotoRow* _tmp4_;
#line 1071 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 1071 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 9653 "Photo.c"
			}
#line 1072 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 9657 "Photo.c"
		}
		__finally308:
		{
			PhotoRow* _tmp5_;
#line 1071 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 1071 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 9666 "Photo.c"
		}
#line 1071 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1071 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1071 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 9674 "Photo.c"
	}
}


BackingPhotoRow*
photo_get_editable_photo_row (Photo* self)
{
	BackingPhotoRow* result = NULL;
	GError * _inner_error_ = NULL;
#line 1076 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 9686 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 1077 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1077 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 9693 "Photo.c"
		{
			PhotoRow* _tmp1_;
#line 1079 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 1079 "/home/jens/Source/shotwell/src/Photo.vala"
			if (backing_photo_id_is_valid (&_tmp1_->editable_id)) {
#line 9700 "Photo.c"
				BackingPhotoRow* _tmp2_;
				BackingPhotoRow* _tmp3_;
#line 1080 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp2_ = self->priv->editable;
#line 1080 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = _backing_photo_row_ref0 (_tmp2_);
#line 1080 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp3_;
#line 9709 "Photo.c"
				{
					PhotoRow* _tmp4_;
#line 1077 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp4_ = self->row;
#line 1077 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 9716 "Photo.c"
				}
#line 1080 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 9720 "Photo.c"
			} else {
#line 1082 "/home/jens/Source/shotwell/src/Photo.vala"
				result = NULL;
#line 9724 "Photo.c"
				{
					PhotoRow* _tmp5_;
#line 1077 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp5_ = self->row;
#line 1077 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 9731 "Photo.c"
				}
#line 1082 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 9735 "Photo.c"
			}
		}
		__finally309:
		{
			PhotoRow* _tmp6_;
#line 1077 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 1077 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 9745 "Photo.c"
		}
#line 1077 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1077 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1077 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 9753 "Photo.c"
	}
}


GeeCollection*
photo_get_raw_development_photo_rows (Photo* self)
{
	GeeCollection* result = NULL;
	GError * _inner_error_ = NULL;
#line 1086 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 9765 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 1087 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1087 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 9772 "Photo.c"
		{
			GeeCollection* _tmp1_ = NULL;
			GeeHashMap* _tmp2_;
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->developments;
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 9780 "Photo.c"
				GeeHashMap* _tmp3_;
				GeeCollection* _tmp4_;
				GeeCollection* _tmp5_;
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->developments;
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_;
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp1_);
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp5_;
#line 9794 "Photo.c"
			} else {
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp1_);
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = NULL;
#line 9800 "Photo.c"
			}
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 9804 "Photo.c"
			{
				PhotoRow* _tmp6_;
#line 1087 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 1087 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 9811 "Photo.c"
			}
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 9815 "Photo.c"
		}
		__finally310:
		{
			PhotoRow* _tmp7_;
#line 1087 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 1087 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 9824 "Photo.c"
		}
#line 1087 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1087 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1087 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 9832 "Photo.c"
	}
}


BackingPhotoRow*
photo_get_raw_development_photo_row (Photo* self,
                                     RawDeveloper d)
{
	BackingPhotoRow* result = NULL;
	GError * _inner_error_ = NULL;
#line 1092 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 9845 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 1093 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1093 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 9852 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			GeeHashMap* _tmp2_;
#line 1094 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->developments;
#line 1094 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 9860 "Photo.c"
				GeeHashMap* _tmp3_;
				gpointer _tmp4_;
#line 1094 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->developments;
#line 1094 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d));
#line 1094 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp1_);
#line 1094 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = (BackingPhotoRow*) _tmp4_;
#line 9871 "Photo.c"
			} else {
#line 1094 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp1_);
#line 1094 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = NULL;
#line 9877 "Photo.c"
			}
#line 1094 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 9881 "Photo.c"
			{
				PhotoRow* _tmp5_;
#line 1093 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = self->row;
#line 1093 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 9888 "Photo.c"
			}
#line 1094 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 9892 "Photo.c"
		}
		__finally311:
		{
			PhotoRow* _tmp6_;
#line 1093 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 1093 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 9901 "Photo.c"
		}
#line 1093 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1093 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1093 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 9909 "Photo.c"
	}
}


static PhotoFileFormat*
_photo_file_format_dup (PhotoFileFormat* self)
{
	PhotoFileFormat* dup;
#line 1104 "/home/jens/Source/shotwell/src/Photo.vala"
	dup = g_new0 (PhotoFileFormat, 1);
#line 1104 "/home/jens/Source/shotwell/src/Photo.vala"
	memcpy (dup, self, sizeof (PhotoFileFormat));
#line 1104 "/home/jens/Source/shotwell/src/Photo.vala"
	return dup;
#line 9924 "Photo.c"
}


static gpointer
__photo_file_format_dup0 (gpointer self)
{
#line 1104 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? _photo_file_format_dup (self) : NULL;
#line 9933 "Photo.c"
}


PhotoFileFormat*
photo_get_editable_file_format (Photo* self)
{
	PhotoFileFormat* result = NULL;
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoFileReader* _tmp2_;
	PhotoFileFormat _tmp3_;
	PhotoFileFormat* _tmp4_;
#line 1098 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1099 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_reader (self);
#line 1099 "/home/jens/Source/shotwell/src/Photo.vala"
	reader = _tmp0_;
#line 1100 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = reader;
#line 1100 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 1101 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 1101 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (reader);
#line 1101 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9963 "Photo.c"
	}
#line 1104 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = reader;
#line 1104 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1104 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = __photo_file_format_dup0 (&_tmp3_);
#line 1104 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp4_;
#line 1104 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (reader);
#line 1104 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 9977 "Photo.c"
}


PhotoFileFormat
photo_get_export_format_for_parameters (Photo* self,
                                        ExportFormatParameters* params)
{
	PhotoFileFormat result = 0;
	PhotoFileFormat _result_ = 0;
	ExportFormatParameters _tmp0_;
	ExportFormatMode _tmp1_;
#line 1107 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 1107 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (params != NULL, 0);
#line 1108 "/home/jens/Source/shotwell/src/Photo.vala"
	_result_ = photo_file_format_get_system_default_format ();
#line 1110 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = *params;
#line 1110 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_.mode;
#line 1110 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (_tmp1_) {
#line 1110 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_UNMODIFIED:
#line 10003 "Photo.c"
		{
#line 1112 "/home/jens/Source/shotwell/src/Photo.vala"
			_result_ = photo_get_master_file_format (self);
#line 1113 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 10009 "Photo.c"
		}
#line 1110 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_CURRENT:
#line 10013 "Photo.c"
		{
#line 1116 "/home/jens/Source/shotwell/src/Photo.vala"
			_result_ = photo_get_best_export_file_format (self);
#line 1117 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 10019 "Photo.c"
		}
#line 1110 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_SPECIFIED:
#line 10023 "Photo.c"
		{
			ExportFormatParameters _tmp2_;
			PhotoFileFormat _tmp3_;
#line 1120 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = *params;
#line 1120 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_.specified_format;
#line 1120 "/home/jens/Source/shotwell/src/Photo.vala"
			_result_ = _tmp3_;
#line 1121 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 10035 "Photo.c"
		}
		default:
		{
#line 1124 "/home/jens/Source/shotwell/src/Photo.vala"
			g_error ("Photo.vala:1124: get_export_format_for_parameters: unsupported export " \
"format mode");
#line 10041 "Photo.c"
		}
	}
#line 1127 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _result_;
#line 1127 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 10048 "Photo.c"
}


gchar*
photo_get_export_basename_for_parameters (Photo* self,
                                          ExportFormatParameters* params)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	ExportFormatParameters _tmp0_;
	ExportFormatMode _tmp1_;
	const gchar* _tmp8_;
#line 1130 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1130 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (params != NULL, NULL);
#line 1131 "/home/jens/Source/shotwell/src/Photo.vala"
	_result_ = NULL;
#line 1133 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = *params;
#line 1133 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_.mode;
#line 1133 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (_tmp1_) {
#line 1133 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_UNMODIFIED:
#line 10075 "Photo.c"
		{
			GFile* _tmp2_;
			GFile* _tmp3_;
			gchar* _tmp4_;
#line 1135 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 1135 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_;
#line 1135 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = g_file_get_basename (_tmp3_);
#line 1135 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_result_);
#line 1135 "/home/jens/Source/shotwell/src/Photo.vala"
			_result_ = _tmp4_;
#line 1135 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_tmp3_);
#line 1136 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 10094 "Photo.c"
		}
#line 1133 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_CURRENT:
#line 1133 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_SPECIFIED:
#line 10100 "Photo.c"
		{
			ExportFormatParameters _tmp5_;
			PhotoFileFormat _tmp6_;
			gchar* _tmp7_;
#line 1140 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = *params;
#line 1140 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = photo_get_export_format_for_parameters (self, &_tmp5_);
#line 1140 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = photo_get_export_basename (self, &_tmp6_);
#line 1140 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp7_;
#line 1140 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_result_);
#line 1140 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 10117 "Photo.c"
		}
		default:
		{
#line 1143 "/home/jens/Source/shotwell/src/Photo.vala"
			g_error ("Photo.vala:1143: get_export_basename_for_parameters: unsupported expor" \
"t format mode");
#line 10123 "Photo.c"
		}
	}
#line 1146 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = _result_;
#line 1146 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp8_ != NULL, "result != null");
#line 1147 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _result_;
#line 1147 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 10134 "Photo.c"
}


ImportResult
photo_prepare_for_import (PhotoImportParams* params)
{
	ImportResult result = 0;
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* info = NULL;
	GFileInfo* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp11_;
	GTimeVal timestamp = {0};
	GFileInfo* _tmp15_;
	GTimeVal _tmp16_ = {0};
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp23_;
	PhotoFileSnifferOptions _tmp24_;
	PhotoFileInterrogator* _tmp25_;
	PhotoFileInterrogator* _tmp32_;
	DetectedPhotoInformation* detected = NULL;
	PhotoFileInterrogator* _tmp33_;
	DetectedPhotoInformation* _tmp34_;
	gboolean _tmp35_ = FALSE;
	DetectedPhotoInformation* _tmp36_;
	PhotoFileSnifferOptions _tmp39_;
	Orientation orientation = 0;
	time_t exposure_time = 0;
	gchar* title = NULL;
	gchar* _tmp49_;
	gchar* comment = NULL;
	gchar* _tmp50_;
	Rating rating = 0;
	DetectedPhotoInformation* _tmp51_;
	PhotoMetadata* _tmp52_;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	DetectedPhotoInformation* _tmp73_;
	GdkColorspace _tmp74_;
	PhotoRow* _tmp82_;
	PhotoRow* _tmp83_;
	BackingPhotoRow* _tmp84_;
	GFile* _tmp85_;
	gchar* _tmp86_;
	PhotoRow* _tmp87_;
	BackingPhotoRow* _tmp88_;
	DetectedPhotoInformation* _tmp89_;
	Dimensions _tmp90_;
	PhotoRow* _tmp91_;
	BackingPhotoRow* _tmp92_;
	GFileInfo* _tmp93_;
	PhotoRow* _tmp94_;
	BackingPhotoRow* _tmp95_;
	GTimeVal _tmp96_;
	glong _tmp97_;
	PhotoRow* _tmp98_;
	time_t _tmp99_;
	PhotoRow* _tmp100_;
	Orientation _tmp101_;
	PhotoRow* _tmp102_;
	BackingPhotoRow* _tmp103_;
	Orientation _tmp104_;
	PhotoRow* _tmp105_;
	ImportID _tmp106_;
	PhotoRow* _tmp107_;
	PhotoRow* _tmp108_;
	PhotoRow* _tmp109_;
	DetectedPhotoInformation* _tmp110_;
	const gchar* _tmp111_;
	gchar* _tmp112_;
	PhotoRow* _tmp113_;
	DetectedPhotoInformation* _tmp114_;
	const gchar* _tmp115_;
	gchar* _tmp116_;
	PhotoRow* _tmp117_;
	DetectedPhotoInformation* _tmp118_;
	const gchar* _tmp119_;
	gchar* _tmp120_;
	PhotoRow* _tmp121_;
	PhotoRow* _tmp122_;
	PhotoRow* _tmp123_;
	BackingPhotoRow* _tmp124_;
	DetectedPhotoInformation* _tmp125_;
	PhotoFileFormat _tmp126_;
	PhotoRow* _tmp127_;
	const gchar* _tmp128_;
	gchar* _tmp129_;
	PhotoRow* _tmp130_;
	const gchar* _tmp131_;
	gchar* _tmp132_;
	PhotoRow* _tmp133_;
	Rating _tmp134_;
	Thumbnails* _tmp135_;
	GError * _inner_error_ = NULL;
#line 1162 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_IMPORT_PARAMS (params), 0);
#line 1166 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = params->file;
#line 1166 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 1166 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp1_;
#line 1168 "/home/jens/Source/shotwell/src/Photo.vala"
	info = NULL;
#line 10244 "Photo.c"
	{
		GFileInfo* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFileInfo* _tmp4_;
		GFileInfo* _tmp5_;
#line 1170 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = file;
#line 1170 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = g_file_query_info (_tmp3_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 1170 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = _tmp4_;
#line 1170 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10258 "Photo.c"
			goto __catch312_g_error;
		}
#line 1170 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp2_;
#line 1170 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = NULL;
#line 1170 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1170 "/home/jens/Source/shotwell/src/Photo.vala"
		info = _tmp5_;
#line 1169 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp2_);
#line 10271 "Photo.c"
	}
	goto __finally312;
	__catch312_g_error:
	{
		GError* err = NULL;
#line 1169 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1169 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1173 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_FILE_ERROR;
#line 1173 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 1173 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1173 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1173 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 10291 "Photo.c"
	}
	__finally312:
#line 1169 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1169 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1169 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1169 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1169 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1169 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 10306 "Photo.c"
	}
#line 1176 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = info;
#line 1176 "/home/jens/Source/shotwell/src/Photo.vala"
	if (g_file_info_get_file_type (_tmp6_) != G_FILE_TYPE_REGULAR) {
#line 1177 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_NOT_A_FILE;
#line 1177 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1177 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1177 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 10320 "Photo.c"
	}
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = file;
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!photo_is_file_image (_tmp7_)) {
#line 10326 "Photo.c"
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = file;
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = g_file_get_path (_tmp8_);
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _tmp9_;
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		g_message ("Photo.vala:1180: Not importing %s: Not an image file", _tmp10_);
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp10_);
#line 1182 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_NOT_AN_IMAGE;
#line 1182 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1182 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1182 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 10348 "Photo.c"
	}
#line 1185 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = file;
#line 1185 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!photo_file_format_is_file_supported (_tmp11_)) {
#line 10354 "Photo.c"
		GFile* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
#line 1186 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = file;
#line 1186 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = g_file_get_path (_tmp12_);
#line 1186 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = _tmp13_;
#line 1186 "/home/jens/Source/shotwell/src/Photo.vala"
		g_message ("Photo.vala:1186: Not importing %s: Unsupported extension", _tmp14_);
#line 1186 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp14_);
#line 1188 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
#line 1188 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1188 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1188 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 10376 "Photo.c"
	}
#line 1191 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = info;
#line 1191 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp15_, &_tmp16_);
#line 1191 "/home/jens/Source/shotwell/src/Photo.vala"
	timestamp = _tmp16_;
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = params->exif_md5;
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp19_ != NULL) {
#line 10388 "Photo.c"
		const gchar* _tmp20_;
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = params->thumbnail_md5;
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = _tmp20_ != NULL;
#line 10394 "Photo.c"
	} else {
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = FALSE;
#line 10398 "Photo.c"
	}
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp18_) {
#line 10402 "Photo.c"
		const gchar* _tmp21_;
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = params->full_md5;
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = _tmp21_ != NULL;
#line 10408 "Photo.c"
	} else {
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = FALSE;
#line 10412 "Photo.c"
	}
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp17_) {
#line 10416 "Photo.c"
		PhotoFileSnifferOptions _tmp22_;
#line 1195 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = params->sniffer_options;
#line 1195 "/home/jens/Source/shotwell/src/Photo.vala"
		params->sniffer_options = _tmp22_ | PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5;
#line 10422 "Photo.c"
	}
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = file;
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = params->sniffer_options;
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp25_ = photo_file_interrogator_new (_tmp23_, _tmp24_);
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp25_;
#line 10432 "Photo.c"
	{
		PhotoFileInterrogator* _tmp26_;
#line 1200 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp26_ = interrogator;
#line 1200 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_interrogator_interrogate (_tmp26_, &_inner_error_);
#line 1200 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10441 "Photo.c"
			goto __catch313_g_error;
		}
	}
	goto __finally313;
	__catch313_g_error:
	{
		GError* err = NULL;
		GFile* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		GError* _tmp30_;
		const gchar* _tmp31_;
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1202 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp27_ = file;
#line 1202 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp28_ = g_file_get_path (_tmp27_);
#line 1202 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = _tmp28_;
#line 1202 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = err;
#line 1202 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp31_ = _tmp30_->message;
#line 1202 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:1202: Unable to interrogate photo file %s: %s", _tmp29_, _tmp31_);
#line 1202 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp29_);
#line 1204 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_DECODE_ERROR;
#line 1204 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 1204 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1204 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1204 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1204 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 10484 "Photo.c"
	}
	__finally313:
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 10501 "Photo.c"
	}
#line 1207 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = interrogator;
#line 1207 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_file_interrogator_get_is_photo_corrupted (_tmp32_)) {
#line 1208 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_NOT_AN_IMAGE;
#line 1208 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1208 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1208 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1208 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 10517 "Photo.c"
	}
#line 1211 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = interrogator;
#line 1211 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = photo_file_interrogator_get_detected_photo_information (_tmp33_);
#line 1211 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp34_;
#line 1212 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_ = detected;
#line 1212 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp36_ == NULL) {
#line 1212 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = TRUE;
#line 10531 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp37_;
		PhotoFileFormat _tmp38_;
#line 1212 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp37_ = detected;
#line 1212 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp38_ = _tmp37_->file_format;
#line 1212 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = _tmp38_ == PHOTO_FILE_FORMAT_UNKNOWN;
#line 10541 "Photo.c"
	}
#line 1212 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp35_) {
#line 1213 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
#line 1213 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1213 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1213 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1213 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1213 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 10557 "Photo.c"
	}
#line 1216 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp39_ = params->sniffer_options;
#line 1216 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((_tmp39_ & PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5) != 0) {
#line 10563 "Photo.c"
		DetectedPhotoInformation* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		DetectedPhotoInformation* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		DetectedPhotoInformation* _tmp46_;
		const gchar* _tmp47_;
		gchar* _tmp48_;
#line 1217 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_ = detected;
#line 1217 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41_ = params->exif_md5;
#line 1217 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp42_ = g_strdup (_tmp41_);
#line 1217 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp40_->exif_md5);
#line 1217 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_->exif_md5 = _tmp42_;
#line 1218 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp43_ = detected;
#line 1218 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_ = params->thumbnail_md5;
#line 1218 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp45_ = g_strdup (_tmp44_);
#line 1218 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp43_->thumbnail_md5);
#line 1218 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp43_->thumbnail_md5 = _tmp45_;
#line 1219 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp46_ = detected;
#line 1219 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp47_ = params->full_md5;
#line 1219 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp48_ = g_strdup (_tmp47_);
#line 1219 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp46_->md5);
#line 1219 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp46_->md5 = _tmp48_;
#line 10603 "Photo.c"
	}
#line 1222 "/home/jens/Source/shotwell/src/Photo.vala"
	orientation = ORIENTATION_TOP_LEFT;
#line 1223 "/home/jens/Source/shotwell/src/Photo.vala"
	exposure_time = (time_t) 0;
#line 1224 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp49_ = g_strdup ("");
#line 1224 "/home/jens/Source/shotwell/src/Photo.vala"
	title = _tmp49_;
#line 1225 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp50_ = g_strdup ("");
#line 1225 "/home/jens/Source/shotwell/src/Photo.vala"
	comment = _tmp50_;
#line 1226 "/home/jens/Source/shotwell/src/Photo.vala"
	rating = RATING_UNRATED;
#line 1233 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp51_ = detected;
#line 1233 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp52_ = _tmp51_->metadata;
#line 1233 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp52_ != NULL) {
#line 10625 "Photo.c"
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp53_;
		PhotoMetadata* _tmp54_;
		MetadataDateTime* _tmp55_;
		MetadataDateTime* _tmp56_;
		DetectedPhotoInformation* _tmp58_;
		PhotoMetadata* _tmp59_;
		DetectedPhotoInformation* _tmp60_;
		PhotoMetadata* _tmp61_;
		gchar* _tmp62_;
		DetectedPhotoInformation* _tmp63_;
		PhotoMetadata* _tmp64_;
		gchar* _tmp65_;
		DetectedPhotoInformation* _tmp66_;
		PhotoMetadata* _tmp67_;
		GeeSet* _tmp68_;
		DetectedPhotoInformation* _tmp69_;
		PhotoMetadata* _tmp70_;
#line 1234 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp53_ = detected;
#line 1234 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp54_ = _tmp53_->metadata;
#line 1234 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp55_ = photo_metadata_get_exposure_date_time (_tmp54_);
#line 1234 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp55_;
#line 1235 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp56_ = date_time;
#line 1235 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp56_ != NULL) {
#line 10656 "Photo.c"
			MetadataDateTime* _tmp57_;
#line 1236 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp57_ = date_time;
#line 1236 "/home/jens/Source/shotwell/src/Photo.vala"
			exposure_time = metadata_date_time_get_timestamp (_tmp57_);
#line 10662 "Photo.c"
		}
#line 1238 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp58_ = detected;
#line 1238 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp59_ = _tmp58_->metadata;
#line 1238 "/home/jens/Source/shotwell/src/Photo.vala"
		orientation = photo_metadata_get_orientation (_tmp59_);
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp60_ = detected;
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp61_ = _tmp60_->metadata;
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp62_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (title);
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
		title = _tmp62_;
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp63_ = detected;
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp64_ = _tmp63_->metadata;
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp65_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (comment);
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
		comment = _tmp65_;
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp66_ = detected;
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp67_ = _tmp66_->metadata;
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp68_ = photo_metadata_get_keywords (_tmp67_, NULL, NULL, NULL);
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (params->keywords);
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
		params->keywords = G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1242 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp69_ = detected;
#line 1242 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp70_ = _tmp69_->metadata;
#line 1242 "/home/jens/Source/shotwell/src/Photo.vala"
		rating = photo_metadata_get_rating (_tmp70_);
#line 1233 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 10708 "Photo.c"
	}
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp73_ = detected;
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp74_ = _tmp73_->colorspace;
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp74_ != GDK_COLORSPACE_RGB) {
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp72_ = TRUE;
#line 10718 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp75_;
		gint _tmp76_;
#line 1247 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp75_ = detected;
#line 1247 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp76_ = _tmp75_->channels;
#line 1247 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp72_ = _tmp76_ < 3;
#line 10728 "Photo.c"
	}
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp72_) {
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp71_ = TRUE;
#line 10734 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp77_;
		gint _tmp78_;
#line 1248 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp77_ = detected;
#line 1248 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp78_ = _tmp77_->bits_per_channel;
#line 1248 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp71_ = _tmp78_ != 8;
#line 10744 "Photo.c"
	}
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp71_) {
#line 10748 "Photo.c"
		GFile* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp79_ = file;
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp80_ = g_file_get_path (_tmp79_);
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp81_ = _tmp80_;
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
		g_message ("Photo.vala:1249: Not importing %s: Unsupported color format", _tmp81_);
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp81_);
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (comment);
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (title);
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 10778 "Photo.c"
	}
#line 1257 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp82_ = params->row;
#line 1257 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_id_init (&_tmp82_->photo_id, PHOTO_ID_INVALID);
#line 1258 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp83_ = params->row;
#line 1258 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp84_ = _tmp83_->master;
#line 1258 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp85_ = file;
#line 1258 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp86_ = g_file_get_path (_tmp85_);
#line 1258 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp84_->filepath);
#line 1258 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp84_->filepath = _tmp86_;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp87_ = params->row;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp88_ = _tmp87_->master;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp89_ = detected;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp90_ = _tmp89_->image_dim;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp88_->dim = _tmp90_;
#line 1260 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp91_ = params->row;
#line 1260 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp92_ = _tmp91_->master;
#line 1260 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp93_ = info;
#line 1260 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp92_->filesize = g_file_info_get_size (_tmp93_);
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp94_ = params->row;
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp95_ = _tmp94_->master;
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp96_ = timestamp;
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp97_ = _tmp96_.tv_sec;
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp95_->timestamp = (time_t) _tmp97_;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp98_ = params->row;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp99_ = exposure_time;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp98_->exposure_time = _tmp99_;
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp100_ = params->row;
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp101_ = orientation;
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp100_->orientation = _tmp101_;
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp102_ = params->row;
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp103_ = _tmp102_->master;
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp104_ = orientation;
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp103_->original_orientation = _tmp104_;
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp105_ = params->row;
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp106_ = params->import_id;
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp105_->import_id = _tmp106_;
#line 1266 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp107_ = params->row;
#line 1266 "/home/jens/Source/shotwell/src/Photo.vala"
	event_id_init (&_tmp107_->event_id, EVENT_ID_INVALID);
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp108_ = params->row;
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp108_->transformations);
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp108_->transformations = NULL;
#line 1268 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp109_ = params->row;
#line 1268 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp110_ = detected;
#line 1268 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp111_ = _tmp110_->md5;
#line 1268 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp112_ = g_strdup (_tmp111_);
#line 1268 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp109_->md5);
#line 1268 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp109_->md5 = _tmp112_;
#line 1269 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp113_ = params->row;
#line 1269 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp114_ = detected;
#line 1269 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp115_ = _tmp114_->thumbnail_md5;
#line 1269 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp116_ = g_strdup (_tmp115_);
#line 1269 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp113_->thumbnail_md5);
#line 1269 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp113_->thumbnail_md5 = _tmp116_;
#line 1270 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp117_ = params->row;
#line 1270 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp118_ = detected;
#line 1270 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp119_ = _tmp118_->exif_md5;
#line 1270 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp120_ = g_strdup (_tmp119_);
#line 1270 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp117_->exif_md5);
#line 1270 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp117_->exif_md5 = _tmp120_;
#line 1271 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp121_ = params->row;
#line 1271 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp121_->time_created = (time_t) 0;
#line 1272 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp122_ = params->row;
#line 1272 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp122_->flags = (guint64) 0;
#line 1273 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp123_ = params->row;
#line 1273 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp124_ = _tmp123_->master;
#line 1273 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp125_ = detected;
#line 1273 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp126_ = _tmp125_->file_format;
#line 1273 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp124_->file_format = _tmp126_;
#line 1274 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp127_ = params->row;
#line 1274 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp128_ = title;
#line 1274 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp129_ = g_strdup (_tmp128_);
#line 1274 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp127_->title);
#line 1274 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp127_->title = _tmp129_;
#line 1275 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp130_ = params->row;
#line 1275 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp131_ = comment;
#line 1275 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp132_ = g_strdup (_tmp131_);
#line 1275 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp130_->comment);
#line 1275 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp130_->comment = _tmp132_;
#line 1276 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp133_ = params->row;
#line 1276 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp134_ = rating;
#line 1276 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp133_->rating = _tmp134_;
#line 1278 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp135_ = params->thumbnails;
#line 1278 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp135_ != NULL) {
#line 10944 "Photo.c"
		PhotoFileReader* reader = NULL;
		PhotoRow* _tmp136_;
		BackingPhotoRow* _tmp137_;
		PhotoFileFormat _tmp138_;
		PhotoRow* _tmp139_;
		BackingPhotoRow* _tmp140_;
		const gchar* _tmp141_;
		PhotoFileReader* _tmp142_;
		PhotoFileReader* _tmp143_;
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp136_ = params->row;
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp137_ = _tmp136_->master;
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp138_ = _tmp137_->file_format;
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp139_ = params->row;
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp140_ = _tmp139_->master;
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp141_ = _tmp140_->filepath;
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp142_ = photo_file_format_create_reader (_tmp138_, _tmp141_);
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
		reader = _tmp142_;
#line 1281 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp143_ = reader;
#line 1281 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_reader_set_role (_tmp143_, PHOTO_FILE_READER_ROLE_THUMBNAIL);
#line 10974 "Photo.c"
		{
			Thumbnails* _tmp144_;
			PhotoFileReader* _tmp145_;
			PhotoRow* _tmp146_;
			Orientation _tmp147_;
			PhotoRow* _tmp148_;
			BackingPhotoRow* _tmp149_;
			Dimensions _tmp150_;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp144_ = params->thumbnails;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp145_ = reader;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp146_ = params->row;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp147_ = _tmp146_->orientation;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp148_ = params->row;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp149_ = _tmp148_->master;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp150_ = _tmp149_->dim;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
			thumbnail_cache_generate_for_photo (_tmp144_, _tmp145_, _tmp147_, &_tmp150_, &_inner_error_);
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11001 "Photo.c"
				goto __catch314_g_error;
			}
		}
		goto __finally314;
		__catch314_g_error:
		{
			GError* err = NULL;
			GError* _tmp151_;
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
			err = _inner_error_;
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
			_inner_error_ = NULL;
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp151_ = err;
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
			result = import_result_convert_error (_tmp151_, IMPORT_RESULT_FILE_ERROR);
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_error_free0 (err);
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (reader);
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (comment);
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (title);
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_interrogator_unref0 (interrogator);
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (info);
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 11036 "Photo.c"
		}
		__finally314:
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (reader);
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (comment);
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (title);
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_interrogator_unref0 (interrogator);
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (info);
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
			return 0;
#line 11061 "Photo.c"
		}
#line 1278 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (reader);
#line 11065 "Photo.c"
	}
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	result = IMPORT_RESULT_SUCCESS;
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (comment);
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (title);
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (info);
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 11083 "Photo.c"
}


void
photo_create_pre_import (PhotoImportParams* params)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	PhotoRow* _tmp2_;
	PhotoRow* _tmp3_;
	BackingPhotoRow* _tmp4_;
	gchar* _tmp5_;
	PhotoRow* _tmp6_;
	BackingPhotoRow* _tmp7_;
	PhotoRow* _tmp8_;
	BackingPhotoRow* _tmp9_;
	PhotoRow* _tmp10_;
	BackingPhotoRow* _tmp11_;
	PhotoRow* _tmp12_;
	PhotoRow* _tmp13_;
	PhotoRow* _tmp14_;
	BackingPhotoRow* _tmp15_;
	PhotoRow* _tmp16_;
	ImportID _tmp17_;
	PhotoRow* _tmp18_;
	PhotoRow* _tmp19_;
	PhotoRow* _tmp20_;
	PhotoRow* _tmp21_;
	PhotoRow* _tmp22_;
	PhotoRow* _tmp23_;
	PhotoRow* _tmp24_;
	PhotoRow* _tmp25_;
	BackingPhotoRow* _tmp26_;
	PhotoRow* _tmp27_;
	PhotoRow* _tmp28_;
	PhotoRow* _tmp29_;
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp30_;
	PhotoFileSnifferOptions _tmp31_;
	PhotoFileInterrogator* _tmp32_;
	GError * _inner_error_ = NULL;
#line 1296 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO_IMPORT_PARAMS (params));
#line 1297 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = params->file;
#line 1297 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 1297 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp1_;
#line 1298 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = params->row;
#line 1298 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_id_init (&_tmp2_->photo_id, PHOTO_ID_INVALID);
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = params->row;
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp3_->master;
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = g_file_get_path (file);
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp4_->filepath);
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_->filepath = _tmp5_;
#line 1300 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = params->row;
#line 1300 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = _tmp6_->master;
#line 1300 "/home/jens/Source/shotwell/src/Photo.vala"
	dimensions_init (&_tmp7_->dim, 0, 0);
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = params->row;
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp8_->master;
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_->filesize = (gint64) 0;
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = params->row;
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = _tmp10_->master;
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_->timestamp = (time_t) 0;
#line 1303 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = params->row;
#line 1303 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_->exposure_time = (time_t) 0;
#line 1304 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = params->row;
#line 1304 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_->orientation = ORIENTATION_TOP_LEFT;
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = params->row;
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = _tmp14_->master;
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_->original_orientation = ORIENTATION_TOP_LEFT;
#line 1306 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = params->row;
#line 1306 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = params->import_id;
#line 1306 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_->import_id = _tmp17_;
#line 1307 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = params->row;
#line 1307 "/home/jens/Source/shotwell/src/Photo.vala"
	event_id_init (&_tmp18_->event_id, EVENT_ID_INVALID);
#line 1308 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = params->row;
#line 1308 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp19_->transformations);
#line 1308 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_->transformations = NULL;
#line 1309 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = params->row;
#line 1309 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp20_->md5);
#line 1309 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_->md5 = NULL;
#line 1310 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = params->row;
#line 1310 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp21_->thumbnail_md5);
#line 1310 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_->thumbnail_md5 = NULL;
#line 1311 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = params->row;
#line 1311 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp22_->exif_md5);
#line 1311 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_->exif_md5 = NULL;
#line 1312 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = params->row;
#line 1312 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_->time_created = (time_t) 0;
#line 1313 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = params->row;
#line 1313 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_->flags = (guint64) 0;
#line 1314 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp25_ = params->row;
#line 1314 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_ = _tmp25_->master;
#line 1314 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_->file_format = PHOTO_FILE_FORMAT_JFIF;
#line 1315 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_ = params->row;
#line 1315 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp27_->title);
#line 1315 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_->title = NULL;
#line 1316 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28_ = params->row;
#line 1316 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp28_->comment);
#line 1316 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28_->comment = NULL;
#line 1317 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp29_ = params->row;
#line 1317 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp29_->rating = RATING_UNRATED;
#line 1319 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp30_ = params->file;
#line 1319 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = params->sniffer_options;
#line 1319 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = photo_file_interrogator_new (_tmp30_, _tmp31_);
#line 1319 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp32_;
#line 11252 "Photo.c"
	{
		DetectedPhotoInformation* detected = NULL;
		DetectedPhotoInformation* _tmp33_;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		DetectedPhotoInformation* _tmp36_;
#line 1321 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_interrogator_interrogate (interrogator, &_inner_error_);
#line 1321 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11263 "Photo.c"
			goto __catch315_g_error;
		}
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp33_ = photo_file_interrogator_get_detected_photo_information (interrogator);
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		detected = _tmp33_;
#line 1323 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = detected;
#line 1323 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp36_ != NULL) {
#line 1323 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp35_ = !photo_file_interrogator_get_is_photo_corrupted (interrogator);
#line 11276 "Photo.c"
		} else {
#line 1323 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp35_ = FALSE;
#line 11280 "Photo.c"
		}
#line 1323 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp35_) {
#line 11284 "Photo.c"
			DetectedPhotoInformation* _tmp37_;
			PhotoFileFormat _tmp38_;
#line 1323 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp37_ = detected;
#line 1323 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp38_ = _tmp37_->file_format;
#line 1323 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp34_ = _tmp38_ != PHOTO_FILE_FORMAT_UNKNOWN;
#line 11293 "Photo.c"
		} else {
#line 1323 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp34_ = FALSE;
#line 11297 "Photo.c"
		}
#line 1323 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp34_) {
#line 11301 "Photo.c"
			PhotoRow* _tmp39_;
			BackingPhotoRow* _tmp40_;
			DetectedPhotoInformation* _tmp41_;
			PhotoFileFormat _tmp42_;
#line 1324 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp39_ = params->row;
#line 1324 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp40_ = _tmp39_->master;
#line 1324 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp41_ = detected;
#line 1324 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp42_ = _tmp41_->file_format;
#line 1324 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp40_->file_format = _tmp42_;
#line 11316 "Photo.c"
		}
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 11320 "Photo.c"
	}
	goto __finally315;
	__catch315_g_error:
	{
		GError* err = NULL;
		gchar* _tmp43_;
		gchar* _tmp44_;
		GError* _tmp45_;
		const gchar* _tmp46_;
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1326 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp43_ = g_file_get_path (file);
#line 1326 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_ = _tmp43_;
#line 1326 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp45_ = err;
#line 1326 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp46_ = _tmp45_->message;
#line 1326 "/home/jens/Source/shotwell/src/Photo.vala"
		g_debug ("Photo.vala:1326: Unable to interrogate photo file %s: %s", _tmp44_, _tmp46_);
#line 1326 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp44_);
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 11348 "Photo.c"
	}
	__finally315:
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 11363 "Photo.c"
	}
#line 1296 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 1296 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 11369 "Photo.c"
}


BackingPhotoRow*
photo_query_backing_photo_row (Photo* self,
                               GFile* file,
                               PhotoFileSnifferOptions options,
                               DetectedPhotoInformation* * detected,
                               GError** error)
{
	DetectedPhotoInformation* _vala_detected = NULL;
	BackingPhotoRow* result = NULL;
	BackingPhotoRow* backing = NULL;
	BackingPhotoRow* _tmp0_;
	GFileInfo* info = NULL;
	PhotoFileInterrogator* interrogator = NULL;
	PhotoFileInterrogator* _tmp8_;
	PhotoFileInterrogator* _tmp9_;
	PhotoFileInterrogator* _tmp10_;
	DetectedPhotoInformation* _tmp11_;
	gboolean _tmp12_ = FALSE;
	DetectedPhotoInformation* _tmp13_;
	GTimeVal modification_time = {0};
	GFileInfo* _tmp17_;
	GTimeVal _tmp18_ = {0};
	BackingPhotoRow* _tmp19_;
	gchar* _tmp20_;
	BackingPhotoRow* _tmp21_;
	GTimeVal _tmp22_;
	glong _tmp23_;
	BackingPhotoRow* _tmp24_;
	GFileInfo* _tmp25_;
	BackingPhotoRow* _tmp26_;
	DetectedPhotoInformation* _tmp27_;
	PhotoFileFormat _tmp28_;
	BackingPhotoRow* _tmp29_;
	DetectedPhotoInformation* _tmp30_;
	Dimensions _tmp31_;
	Orientation _tmp32_ = 0;
	DetectedPhotoInformation* _tmp33_;
	PhotoMetadata* _tmp34_;
	BackingPhotoRow* _tmp37_;
	GError * _inner_error_ = NULL;
#line 1330 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1330 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 1332 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (_vala_detected);
#line 1332 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_detected = NULL;
#line 1334 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = backing_photo_row_new ();
#line 1334 "/home/jens/Source/shotwell/src/Photo.vala"
	backing = _tmp0_;
#line 1336 "/home/jens/Source/shotwell/src/Photo.vala"
	info = NULL;
#line 11427 "Photo.c"
	{
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
#line 1338 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = g_file_query_info (file, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 1338 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp2_;
#line 1338 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11438 "Photo.c"
			goto __catch316_g_error;
		}
#line 1338 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp1_;
#line 1338 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = NULL;
#line 1338 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1338 "/home/jens/Source/shotwell/src/Photo.vala"
		info = _tmp3_;
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 11451 "Photo.c"
	}
	goto __finally316;
	__catch316_g_error:
	{
		GError* err = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1341 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = g_file_get_path (file);
#line 1341 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp4_;
#line 1341 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = err;
#line 1341 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp6_->message;
#line 1341 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("Photo.vala:1341: Unable to read file information for %s: %s", _tmp5_, _tmp7_);
#line 1341 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp5_);
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
		if (detected) {
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
			*detected = _vala_detected;
#line 11489 "Photo.c"
		} else {
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (_vala_detected);
#line 11493 "Photo.c"
		}
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 11497 "Photo.c"
	}
	__finally316:
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 11510 "Photo.c"
	}
#line 1347 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = photo_file_interrogator_new (file, options);
#line 1347 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp8_;
#line 1348 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = interrogator;
#line 1348 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_interrogator_interrogate (_tmp9_, &_inner_error_);
#line 1348 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1348 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1348 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1348 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1348 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1348 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 11532 "Photo.c"
	}
#line 1349 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = interrogator;
#line 1349 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = photo_file_interrogator_get_detected_photo_information (_tmp10_);
#line 1349 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (_vala_detected);
#line 1349 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_detected = _tmp11_;
#line 1350 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = _vala_detected;
#line 1350 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp13_ == NULL) {
#line 1350 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = TRUE;
#line 11548 "Photo.c"
	} else {
		PhotoFileInterrogator* _tmp14_;
#line 1350 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = interrogator;
#line 1350 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = photo_file_interrogator_get_is_photo_corrupted (_tmp14_);
#line 11555 "Photo.c"
	}
#line 1350 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp12_) {
#line 11559 "Photo.c"
		gchar* _tmp15_;
		gchar* _tmp16_;
#line 1351 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 1351 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = _tmp15_;
#line 1351 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("Photo.vala:1351: Photo update: %s no longer a recognized image", _tmp16_);
#line 1351 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp16_);
#line 1353 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 1353 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1353 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1353 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1353 "/home/jens/Source/shotwell/src/Photo.vala"
		if (detected) {
#line 1353 "/home/jens/Source/shotwell/src/Photo.vala"
			*detected = _vala_detected;
#line 11582 "Photo.c"
		} else {
#line 1353 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (_vala_detected);
#line 11586 "Photo.c"
		}
#line 1353 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 11590 "Photo.c"
	}
#line 1356 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = info;
#line 1356 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp17_, &_tmp18_);
#line 1356 "/home/jens/Source/shotwell/src/Photo.vala"
	modification_time = _tmp18_;
#line 1358 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = backing;
#line 1358 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = g_file_get_path (file);
#line 1358 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp19_->filepath);
#line 1358 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_->filepath = _tmp20_;
#line 1359 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = backing;
#line 1359 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = modification_time;
#line 1359 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = _tmp22_.tv_sec;
#line 1359 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_->timestamp = (time_t) _tmp23_;
#line 1360 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = backing;
#line 1360 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp25_ = info;
#line 1360 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_->filesize = g_file_info_get_size (_tmp25_);
#line 1361 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_ = backing;
#line 1361 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_ = _vala_detected;
#line 1361 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28_ = _tmp27_->file_format;
#line 1361 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_->file_format = _tmp28_;
#line 1362 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp29_ = backing;
#line 1362 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp30_ = _vala_detected;
#line 1362 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = _tmp30_->image_dim;
#line 1362 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp29_->dim = _tmp31_;
#line 1363 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = _vala_detected;
#line 1363 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = _tmp33_->metadata;
#line 1363 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp34_ != NULL) {
#line 11642 "Photo.c"
		DetectedPhotoInformation* _tmp35_;
		PhotoMetadata* _tmp36_;
#line 1364 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = _vala_detected;
#line 1364 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = _tmp35_->metadata;
#line 1364 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp32_ = photo_metadata_get_orientation (_tmp36_);
#line 11651 "Photo.c"
	} else {
#line 1364 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp32_ = ORIENTATION_TOP_LEFT;
#line 11655 "Photo.c"
	}
#line 1363 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = backing;
#line 1363 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_->original_orientation = _tmp32_;
#line 1366 "/home/jens/Source/shotwell/src/Photo.vala"
	result = backing;
#line 1366 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 1366 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (info);
#line 1366 "/home/jens/Source/shotwell/src/Photo.vala"
	if (detected) {
#line 1366 "/home/jens/Source/shotwell/src/Photo.vala"
		*detected = _vala_detected;
#line 11671 "Photo.c"
	} else {
#line 1366 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (_vala_detected);
#line 11675 "Photo.c"
	}
#line 1366 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 11679 "Photo.c"
}


static void
_vala_array_add91 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 11695 "Photo.c"
	}
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 11701 "Photo.c"
}


static void
_vala_array_add92 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 11717 "Photo.c"
	}
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 11723 "Photo.c"
}


static void
_vala_array_add93 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 11739 "Photo.c"
	}
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 11745 "Photo.c"
}


static void
_vala_array_add94 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 1475 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1475 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1475 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 11761 "Photo.c"
	}
#line 1475 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1475 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 11767 "Photo.c"
}


static void
_vala_array_add95 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 11783 "Photo.c"
	}
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 11789 "Photo.c"
}


static void
_vala_array_add96 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 11805 "Photo.c"
	}
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 11811 "Photo.c"
}


static gpointer
_media_metadata_ref0 (gpointer self)
{
#line 1491 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? media_metadata_ref (self) : NULL;
#line 11820 "Photo.c"
}


gboolean
photo_prepare_for_reimport_master (Photo* self,
                                   PhotoReimportMasterState* * reimport_state,
                                   GError** error)
{
	PhotoReimportMasterState* _vala_reimport_state = NULL;
	gboolean result = FALSE;
	GFile* file = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	DetectedPhotoInformation* detected = NULL;
	BackingPhotoRow* backing = NULL;
	GFile* _tmp4_;
	DetectedPhotoInformation* _tmp5_ = NULL;
	BackingPhotoRow* _tmp6_;
	BackingPhotoRow* _tmp8_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	DetectedPhotoInformation* _tmp14_;
	GdkColorspace _tmp15_;
	PhotoRow* updated_row = NULL;
	PhotoRow* _tmp23_;
	gchar** list = NULL;
	gchar** _tmp29_;
	gint list_length1;
	gint _list_size_;
	PhotoRow* _tmp30_;
	const gchar* _tmp31_;
	DetectedPhotoInformation* _tmp32_;
	const gchar* _tmp33_;
	PhotoRow* _tmp36_;
	BackingPhotoRow* _tmp37_;
	Orientation _tmp38_;
	BackingPhotoRow* _tmp39_;
	Orientation _tmp40_;
	DetectedPhotoInformation* _tmp47_;
	PhotoMetadata* _tmp48_;
	PhotoRow* _tmp83_;
	BackingPhotoRow* _tmp84_;
	BackingPhotoRow* _tmp85_;
	PhotoRow* _tmp86_;
	DetectedPhotoInformation* _tmp87_;
	const gchar* _tmp88_;
	gchar* _tmp89_;
	PhotoRow* _tmp90_;
	DetectedPhotoInformation* _tmp91_;
	const gchar* _tmp92_;
	gchar* _tmp93_;
	PhotoRow* _tmp94_;
	DetectedPhotoInformation* _tmp95_;
	const gchar* _tmp96_;
	gchar* _tmp97_;
	PhotoMetadata* metadata = NULL;
	DetectedPhotoInformation* _tmp98_;
	PhotoMetadata* _tmp99_;
	PhotoRow* _tmp120_;
	PhotoMetadata* _tmp121_;
	gchar** _tmp122_;
	gint _tmp122__length1;
	PhotoReimportMasterStateImpl* _tmp123_;
	GError * _inner_error_ = NULL;
#line 1430 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1431 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 1431 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_reimport_state = NULL;
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_reader (self);
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp3_;
#line 1436 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = file;
#line 1436 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_query_backing_photo_row (self, _tmp4_, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL, &_tmp5_, &_inner_error_);
#line 1436 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1436 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp5_;
#line 1436 "/home/jens/Source/shotwell/src/Photo.vala"
	backing = _tmp6_;
#line 1436 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11917 "Photo.c"
		gboolean _tmp7_ = FALSE;
#line 1436 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1436 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1436 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1436 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp7_;
#line 11927 "Photo.c"
	}
#line 1438 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = backing;
#line 1438 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp8_ == NULL) {
#line 11933 "Photo.c"
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
#line 1439 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = file;
#line 1439 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = g_file_get_path (_tmp9_);
#line 1439 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = _tmp10_;
#line 1439 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:1439: Unable to retrieve photo state from %s for reimport", _tmp11_);
#line 1439 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp11_);
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
		if (reimport_state) {
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
			*reimport_state = _vala_reimport_state;
#line 11959 "Photo.c"
		} else {
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 11963 "Photo.c"
		}
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 11967 "Photo.c"
	}
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = detected;
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = _tmp14_->colorspace;
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp15_ != GDK_COLORSPACE_RGB) {
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = TRUE;
#line 11977 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp16_;
		gint _tmp17_;
#line 1445 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = detected;
#line 1445 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = _tmp16_->channels;
#line 1445 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp17_ < 3;
#line 11987 "Photo.c"
	}
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp13_) {
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = TRUE;
#line 11993 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp18_;
		gint _tmp19_;
#line 1446 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = detected;
#line 1446 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = _tmp18_->bits_per_channel;
#line 1446 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _tmp19_ != 8;
#line 12003 "Photo.c"
	}
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp12_) {
#line 12007 "Photo.c"
		GFile* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
#line 1447 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = file;
#line 1447 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = g_file_get_path (_tmp20_);
#line 1447 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = _tmp21_;
#line 1447 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:1447: Not re-importing %s: Unsupported color format", _tmp22_);
#line 1447 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp22_);
#line 1449 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1449 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1449 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1449 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1449 "/home/jens/Source/shotwell/src/Photo.vala"
		if (reimport_state) {
#line 1449 "/home/jens/Source/shotwell/src/Photo.vala"
			*reimport_state = _vala_reimport_state;
#line 12033 "Photo.c"
		} else {
#line 1449 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 12037 "Photo.c"
		}
#line 1449 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 12041 "Photo.c"
	}
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = photo_row_new ();
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
	updated_row = _tmp23_;
#line 12047 "Photo.c"
	{
		PhotoRow* _tmp24_;
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = self->row;
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 12054 "Photo.c"
		{
			PhotoRow* _tmp25_;
			PhotoRow* _tmp26_;
#line 1455 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp25_ = self->row;
#line 1455 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26_ = _photo_row_ref0 (_tmp25_);
#line 1455 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_row_unref0 (updated_row);
#line 1455 "/home/jens/Source/shotwell/src/Photo.vala"
			updated_row = _tmp26_;
#line 12066 "Photo.c"
		}
		__finally317:
		{
			PhotoRow* _tmp27_;
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp27_ = self->row;
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 12075 "Photo.c"
		}
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12079 "Photo.c"
			gboolean _tmp28_ = FALSE;
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_row_unref0 (updated_row);
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing);
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp28_;
#line 12093 "Photo.c"
		}
	}
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp29_ = g_new0 (gchar*, 0 + 1);
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
	list = _tmp29_;
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
	list_length1 = 0;
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
	_list_size_ = list_length1;
#line 1461 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp30_ = updated_row;
#line 1461 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = _tmp30_->md5;
#line 1461 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = detected;
#line 1461 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = _tmp32_->md5;
#line 1461 "/home/jens/Source/shotwell/src/Photo.vala"
	if (g_strcmp0 (_tmp31_, _tmp33_) != 0) {
#line 12114 "Photo.c"
		gchar** _tmp34_;
		gint _tmp34__length1;
		gchar* _tmp35_;
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp34_ = list;
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp34__length1 = list_length1;
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = g_strdup ("metadata:md5");
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add91 (&list, &list_length1, &_list_size_, _tmp35_);
#line 12126 "Photo.c"
	}
#line 1464 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_ = updated_row;
#line 1464 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = _tmp36_->master;
#line 1464 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = _tmp37_->original_orientation;
#line 1464 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp39_ = backing;
#line 1464 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp40_ = _tmp39_->original_orientation;
#line 1464 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp38_ != _tmp40_) {
#line 12140 "Photo.c"
		gchar** _tmp41_;
		gint _tmp41__length1;
		gchar* _tmp42_;
		PhotoRow* _tmp43_;
		BackingPhotoRow* _tmp44_;
		BackingPhotoRow* _tmp45_;
		Orientation _tmp46_;
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41_ = list;
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41__length1 = list_length1;
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp42_ = g_strdup ("image:orientation");
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add92 (&list, &list_length1, &_list_size_, _tmp42_);
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp43_ = updated_row;
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_ = _tmp43_->master;
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp45_ = backing;
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp46_ = _tmp45_->original_orientation;
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_->original_orientation = _tmp46_;
#line 12166 "Photo.c"
	}
#line 1469 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp47_ = detected;
#line 1469 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp48_ = _tmp47_->metadata;
#line 1469 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp48_ != NULL) {
#line 12174 "Photo.c"
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp49_;
		PhotoMetadata* _tmp50_;
		MetadataDateTime* _tmp51_;
		gboolean _tmp52_ = FALSE;
		MetadataDateTime* _tmp53_;
		PhotoRow* _tmp59_;
		const gchar* _tmp60_;
		DetectedPhotoInformation* _tmp61_;
		PhotoMetadata* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		gboolean _tmp65_;
		PhotoRow* _tmp68_;
		const gchar* _tmp69_;
		DetectedPhotoInformation* _tmp70_;
		PhotoMetadata* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		gboolean _tmp74_;
		PhotoRow* _tmp77_;
		Rating _tmp78_;
		DetectedPhotoInformation* _tmp79_;
		PhotoMetadata* _tmp80_;
#line 1470 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp49_ = detected;
#line 1470 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp50_ = _tmp49_->metadata;
#line 1470 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp51_ = photo_metadata_get_exposure_date_time (_tmp50_);
#line 1470 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp51_;
#line 1471 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp53_ = date_time;
#line 1471 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp53_ != NULL) {
#line 12211 "Photo.c"
			PhotoRow* _tmp54_;
			time_t _tmp55_;
			MetadataDateTime* _tmp56_;
#line 1471 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp54_ = updated_row;
#line 1471 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp55_ = _tmp54_->exposure_time;
#line 1471 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp56_ = date_time;
#line 1471 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp52_ = _tmp55_ != metadata_date_time_get_timestamp (_tmp56_);
#line 12223 "Photo.c"
		} else {
#line 1471 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp52_ = FALSE;
#line 12227 "Photo.c"
		}
#line 1471 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp52_) {
#line 12231 "Photo.c"
			gchar** _tmp57_;
			gint _tmp57__length1;
			gchar* _tmp58_;
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp57_ = list;
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp57__length1 = list_length1;
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp58_ = g_strdup ("metadata:exposure-time");
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add93 (&list, &list_length1, &_list_size_, _tmp58_);
#line 12243 "Photo.c"
		}
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp59_ = updated_row;
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp60_ = _tmp59_->title;
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp61_ = detected;
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp62_ = _tmp61_->metadata;
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp63_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp64_ = _tmp63_;
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp65_ = g_strcmp0 (_tmp60_, _tmp64_) != 0;
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp64_);
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp65_) {
#line 12263 "Photo.c"
			gchar** _tmp66_;
			gint _tmp66__length1;
			gchar* _tmp67_;
#line 1475 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp66_ = list;
#line 1475 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp66__length1 = list_length1;
#line 1475 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp67_ = g_strdup ("metadata:name");
#line 1475 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add94 (&list, &list_length1, &_list_size_, _tmp67_);
#line 12275 "Photo.c"
		}
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp68_ = updated_row;
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp69_ = _tmp68_->comment;
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp70_ = detected;
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp71_ = _tmp70_->metadata;
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp72_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp73_ = _tmp72_;
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp74_ = g_strcmp0 (_tmp69_, _tmp73_) != 0;
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp73_);
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp74_) {
#line 12295 "Photo.c"
			gchar** _tmp75_;
			gint _tmp75__length1;
			gchar* _tmp76_;
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp75_ = list;
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp75__length1 = list_length1;
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp76_ = g_strdup ("metadata:comment");
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add95 (&list, &list_length1, &_list_size_, _tmp76_);
#line 12307 "Photo.c"
		}
#line 1480 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp77_ = updated_row;
#line 1480 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp78_ = _tmp77_->rating;
#line 1480 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp79_ = detected;
#line 1480 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp80_ = _tmp79_->metadata;
#line 1480 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp78_ != photo_metadata_get_rating (_tmp80_)) {
#line 12319 "Photo.c"
			gchar** _tmp81_;
			gint _tmp81__length1;
			gchar* _tmp82_;
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp81_ = list;
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp81__length1 = list_length1;
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp82_ = g_strdup ("metadata:rating");
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add96 (&list, &list_length1, &_list_size_, _tmp82_);
#line 12331 "Photo.c"
		}
#line 1469 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 12335 "Photo.c"
	}
#line 1484 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp83_ = updated_row;
#line 1484 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp84_ = backing;
#line 1484 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp85_ = _backing_photo_row_ref0 (_tmp84_);
#line 1484 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (_tmp83_->master);
#line 1484 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp83_->master = _tmp85_;
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp86_ = updated_row;
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp87_ = detected;
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp88_ = _tmp87_->md5;
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp89_ = g_strdup (_tmp88_);
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp86_->md5);
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp86_->md5 = _tmp89_;
#line 1486 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp90_ = updated_row;
#line 1486 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp91_ = detected;
#line 1486 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp92_ = _tmp91_->exif_md5;
#line 1486 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp93_ = g_strdup (_tmp92_);
#line 1486 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp90_->exif_md5);
#line 1486 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp90_->exif_md5 = _tmp93_;
#line 1487 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp94_ = updated_row;
#line 1487 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp95_ = detected;
#line 1487 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp96_ = _tmp95_->thumbnail_md5;
#line 1487 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp97_ = g_strdup (_tmp96_);
#line 1487 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp94_->thumbnail_md5);
#line 1487 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp94_->thumbnail_md5 = _tmp97_;
#line 1489 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = NULL;
#line 1490 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp98_ = detected;
#line 1490 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp99_ = _tmp98_->metadata;
#line 1490 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp99_ != NULL) {
#line 12391 "Photo.c"
		DetectedPhotoInformation* _tmp100_;
		PhotoMetadata* _tmp101_;
		PhotoMetadata* _tmp102_;
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp103_;
		PhotoMetadata* _tmp104_;
		MetadataDateTime* _tmp105_;
		MetadataDateTime* _tmp106_;
		PhotoRow* _tmp109_;
		DetectedPhotoInformation* _tmp110_;
		PhotoMetadata* _tmp111_;
		gchar* _tmp112_;
		PhotoRow* _tmp113_;
		DetectedPhotoInformation* _tmp114_;
		PhotoMetadata* _tmp115_;
		gchar* _tmp116_;
		PhotoRow* _tmp117_;
		DetectedPhotoInformation* _tmp118_;
		PhotoMetadata* _tmp119_;
#line 1491 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp100_ = detected;
#line 1491 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp101_ = _tmp100_->metadata;
#line 1491 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp102_ = _media_metadata_ref0 (_tmp101_);
#line 1491 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 1491 "/home/jens/Source/shotwell/src/Photo.vala"
		metadata = _tmp102_;
#line 1493 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp103_ = detected;
#line 1493 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp104_ = _tmp103_->metadata;
#line 1493 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp105_ = photo_metadata_get_exposure_date_time (_tmp104_);
#line 1493 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp105_;
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp106_ = date_time;
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp106_ != NULL) {
#line 12433 "Photo.c"
			PhotoRow* _tmp107_;
			MetadataDateTime* _tmp108_;
#line 1495 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp107_ = updated_row;
#line 1495 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp108_ = date_time;
#line 1495 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp107_->exposure_time = metadata_date_time_get_timestamp (_tmp108_);
#line 12442 "Photo.c"
		}
#line 1497 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp109_ = updated_row;
#line 1497 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp110_ = detected;
#line 1497 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp111_ = _tmp110_->metadata;
#line 1497 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp112_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1497 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp109_->title);
#line 1497 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp109_->title = _tmp112_;
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp113_ = updated_row;
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp114_ = detected;
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp115_ = _tmp114_->metadata;
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp116_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp113_->comment);
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp113_->comment = _tmp116_;
#line 1499 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp117_ = updated_row;
#line 1499 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp118_ = detected;
#line 1499 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp119_ = _tmp118_->metadata;
#line 1499 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp117_->rating = photo_metadata_get_rating (_tmp119_);
#line 1490 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 12478 "Photo.c"
	}
#line 1502 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp120_ = updated_row;
#line 1502 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp121_ = metadata;
#line 1502 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp122_ = list;
#line 1502 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp122__length1 = list_length1;
#line 1502 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp123_ = photo_reimport_master_state_impl_new (_tmp120_, _tmp121_, _tmp122_, _tmp122__length1);
#line 1502 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 1502 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_reimport_state = G_TYPE_CHECK_INSTANCE_CAST (_tmp123_, PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState);
#line 1504 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 1504 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 1504 "/home/jens/Source/shotwell/src/Photo.vala"
	list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
#line 1504 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_row_unref0 (updated_row);
#line 1504 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (backing);
#line 1504 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1504 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 1504 "/home/jens/Source/shotwell/src/Photo.vala"
	if (reimport_state) {
#line 1504 "/home/jens/Source/shotwell/src/Photo.vala"
		*reimport_state = _vala_reimport_state;
#line 12512 "Photo.c"
	} else {
#line 1504 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 12516 "Photo.c"
	}
#line 1504 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 12520 "Photo.c"
}


static void
photo_real_apply_user_metadata_for_reimport (Photo* self,
                                             PhotoMetadata* metadata)
{
#line 1507 "/home/jens/Source/shotwell/src/Photo.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_apply_user_metadata_for_reimport'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 1507 "/home/jens/Source/shotwell/src/Photo.vala"
	return;
#line 12532 "Photo.c"
}


void
photo_apply_user_metadata_for_reimport (Photo* self,
                                        PhotoMetadata* metadata)
{
#line 1507 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1507 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->apply_user_metadata_for_reimport (self, metadata);
#line 12544 "Photo.c"
}


static gpointer
_photo_reimport_master_state_ref0 (gpointer self)
{
#line 1511 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_reimport_master_state_ref (self) : NULL;
#line 12553 "Photo.c"
}


static void
_vala_array_add97 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 1529 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1529 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1529 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 12569 "Photo.c"
	}
#line 1529 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1529 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 12575 "Photo.c"
}


static void
_vala_array_add98 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 12591 "Photo.c"
	}
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 12597 "Photo.c"
}


void
photo_finish_reimport_master (Photo* self,
                              PhotoReimportMasterState* state,
                              GError** error)
{
	PhotoReimportMasterStateImpl* reimport_state = NULL;
	PhotoReimportMasterStateImpl* _tmp0_;
	PhotoTable* _tmp1_;
	PhotoTable* _tmp2_;
	PhotoRow* _tmp3_;
	PhotoMetadata* _tmp19_;
	gboolean _tmp21_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	PhotoMetadata* _tmp30_;
	GError * _inner_error_ = NULL;
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_MASTER_STATE (state));
#line 1511 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _photo_reimport_master_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (state, PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl));
#line 1511 "/home/jens/Source/shotwell/src/Photo.vala"
	reimport_state = _tmp0_;
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_table_get_instance ();
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp1_;
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = reimport_state->row;
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_table_reimport (_tmp2_, _tmp3_, &_inner_error_);
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp2_);
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (reimport_state);
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 12645 "Photo.c"
		} else {
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (reimport_state);
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 12655 "Photo.c"
		}
	}
	{
		PhotoRow* _tmp4_;
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = self->row;
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 12664 "Photo.c"
		{
			BackingPhotoRow* original_master = NULL;
			PhotoRow* _tmp5_;
			BackingPhotoRow* _tmp6_;
			BackingPhotoRow* _tmp7_;
			PhotoRow* _tmp8_;
			PhotoRow* _tmp9_;
			PhotoRow* _tmp10_;
			BackingPhotoRow* _tmp11_;
			BackingPhotoRow* _tmp12_;
			PhotoRow* _tmp13_;
			BackingPhotoRow* _tmp14_;
			PhotoRow* _tmp15_;
			BackingPhotoRow* _tmp16_;
			gboolean _tmp17_;
#line 1517 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 1517 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_->master;
#line 1517 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _backing_photo_row_ref0 (_tmp6_);
#line 1517 "/home/jens/Source/shotwell/src/Photo.vala"
			original_master = _tmp7_;
#line 1518 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = reimport_state->row;
#line 1518 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = _photo_row_ref0 (_tmp8_);
#line 1518 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_row_unref0 (self->row);
#line 1518 "/home/jens/Source/shotwell/src/Photo.vala"
			self->row = _tmp9_;
#line 1519 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = self->row;
#line 1519 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = original_master;
#line 1519 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = _backing_photo_row_ref0 (_tmp11_);
#line 1519 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (_tmp10_->master);
#line 1519 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_->master = _tmp12_;
#line 1520 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->row;
#line 1520 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = _tmp13_->master;
#line 1520 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = reimport_state->row;
#line 1520 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = _tmp15_->master;
#line 1520 "/home/jens/Source/shotwell/src/Photo.vala"
			backing_photo_row_copy_from (_tmp14_, _tmp16_);
#line 1521 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = reimport_state->metadata_only;
#line 1521 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp17_) {
#line 1522 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_internal_remove_all_transformations (self, FALSE);
#line 12722 "Photo.c"
			}
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (original_master);
#line 12726 "Photo.c"
		}
		__finally318:
		{
			PhotoRow* _tmp18_;
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp18_ = self->row;
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 12735 "Photo.c"
		}
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_master_state_unref0 (reimport_state);
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 12747 "Photo.c"
			} else {
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_master_state_unref0 (reimport_state);
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 12757 "Photo.c"
			}
		}
	}
#line 1525 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = reimport_state->metadata;
#line 1525 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp19_ != NULL) {
#line 12765 "Photo.c"
		PhotoMetadata* _tmp20_;
#line 1526 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = reimport_state->metadata;
#line 1526 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_apply_user_metadata_for_reimport (self, _tmp20_);
#line 12771 "Photo.c"
	}
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = reimport_state->metadata_only;
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp21_) {
#line 12777 "Photo.c"
		gchar** _tmp22_;
		gint _tmp22__length1;
		gchar* _tmp23_;
#line 1529 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = reimport_state->alterations;
#line 1529 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22__length1 = reimport_state->alterations_length1;
#line 1529 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = g_strdup ("image:master");
#line 1529 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add97 (&reimport_state->alterations, &reimport_state->alterations_length1, &reimport_state->_alterations_size_, _tmp23_);
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
		if (photo_is_master_baseline (self)) {
#line 12791 "Photo.c"
			gchar** _tmp24_;
			gint _tmp24__length1;
			gchar* _tmp25_;
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp24_ = reimport_state->alterations;
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp24__length1 = reimport_state->alterations_length1;
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp25_ = g_strdup ("image:baseline");
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add98 (&reimport_state->alterations, &reimport_state->alterations_length1, &reimport_state->_alterations_size_, _tmp25_);
#line 12803 "Photo.c"
		}
	}
#line 1534 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_ = reimport_state->alterations;
#line 1534 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26__length1 = reimport_state->alterations_length1;
#line 1534 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp26__length1 > 0) {
#line 12812 "Photo.c"
		gchar** _tmp27_;
		gint _tmp27__length1;
		Alteration* _tmp28_;
		Alteration* _tmp29_;
#line 1535 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp27_ = reimport_state->alterations;
#line 1535 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp27__length1 = reimport_state->alterations_length1;
#line 1535 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp28_ = alteration_new_from_array (_tmp27_, _tmp27__length1);
#line 1535 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = _tmp28_;
#line 1535 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp29_);
#line 1535 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp29_);
#line 12829 "Photo.c"
	}
#line 1537 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp30_ = reimport_state->metadata;
#line 1537 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_notify_master_reimported (self, _tmp30_);
#line 1539 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_is_master_baseline (self)) {
#line 12837 "Photo.c"
		PhotoMetadata* _tmp31_;
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp31_ = reimport_state->metadata;
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_baseline_reimported (self, _tmp31_);
#line 12843 "Photo.c"
	}
#line 1542 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_is_master_source (self)) {
#line 12847 "Photo.c"
		PhotoMetadata* _tmp32_;
#line 1543 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp32_ = reimport_state->metadata;
#line 1543 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_source_reimported (self, _tmp32_);
#line 12853 "Photo.c"
	}
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (reimport_state);
#line 12857 "Photo.c"
}


static gboolean
photo_verify_file_for_reimport (Photo* self,
                                GFile* file,
                                BackingPhotoRow* * backing,
                                DetectedPhotoInformation* * detected,
                                GError** error)
{
	BackingPhotoRow* _vala_backing = NULL;
	DetectedPhotoInformation* _vala_detected = NULL;
	gboolean result = FALSE;
	BackingPhotoRow* _tmp0_ = NULL;
	DetectedPhotoInformation* _tmp1_ = NULL;
	BackingPhotoRow* _tmp2_;
	BackingPhotoRow* _tmp4_;
	BackingPhotoRow* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	DetectedPhotoInformation* _tmp8_;
	GdkColorspace _tmp9_;
	GError * _inner_error_ = NULL;
#line 1547 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1547 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 1549 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_query_backing_photo_row (self, file, PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5, &_tmp1_, &_inner_error_);
#line 1549 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (_vala_detected);
#line 1549 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_detected = _tmp1_;
#line 1549 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp2_;
#line 1549 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12895 "Photo.c"
		gboolean _tmp3_ = FALSE;
#line 1549 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1549 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp3_;
#line 12901 "Photo.c"
	}
#line 1549 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp0_;
#line 1549 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 1549 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (_vala_backing);
#line 1549 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_backing = _tmp4_;
#line 1551 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = _vala_backing;
#line 1551 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp5_ == NULL) {
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (_tmp0_);
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
		if (backing) {
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
			*backing = _vala_backing;
#line 12923 "Photo.c"
		} else {
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (_vala_backing);
#line 12927 "Photo.c"
		}
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
		if (detected) {
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
			*detected = _vala_detected;
#line 12933 "Photo.c"
		} else {
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (_vala_detected);
#line 12937 "Photo.c"
		}
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 12941 "Photo.c"
	}
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = _vala_detected;
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp8_->colorspace;
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp9_ != GDK_COLORSPACE_RGB) {
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = TRUE;
#line 12951 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp10_;
		gint _tmp11_;
#line 1557 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _vala_detected;
#line 1557 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = _tmp10_->channels;
#line 1557 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp11_ < 3;
#line 12961 "Photo.c"
	}
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp7_) {
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = TRUE;
#line 12967 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp12_;
		gint _tmp13_;
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _vala_detected;
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp12_->bits_per_channel;
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp13_ != 8;
#line 12977 "Photo.c"
	}
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp6_) {
#line 12981 "Photo.c"
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = g_file_get_path (file);
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = _tmp14_;
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:1559: Not re-importing %s: Unsupported color format", _tmp15_);
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp15_);
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (_tmp0_);
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
		if (backing) {
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
			*backing = _vala_backing;
#line 13000 "Photo.c"
		} else {
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (_vala_backing);
#line 13004 "Photo.c"
		}
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
		if (detected) {
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
			*detected = _vala_detected;
#line 13010 "Photo.c"
		} else {
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (_vala_detected);
#line 13014 "Photo.c"
		}
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 13018 "Photo.c"
	}
#line 1564 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 1564 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (_tmp0_);
#line 1564 "/home/jens/Source/shotwell/src/Photo.vala"
	if (backing) {
#line 1564 "/home/jens/Source/shotwell/src/Photo.vala"
		*backing = _vala_backing;
#line 13028 "Photo.c"
	} else {
#line 1564 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (_vala_backing);
#line 13032 "Photo.c"
	}
#line 1564 "/home/jens/Source/shotwell/src/Photo.vala"
	if (detected) {
#line 1564 "/home/jens/Source/shotwell/src/Photo.vala"
		*detected = _vala_detected;
#line 13038 "Photo.c"
	} else {
#line 1564 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (_vala_detected);
#line 13042 "Photo.c"
	}
#line 1564 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13046 "Photo.c"
}


gboolean
photo_prepare_for_reimport_editable (Photo* self,
                                     PhotoReimportEditableState* * state,
                                     GError** error)
{
	PhotoReimportEditableState* _vala_state = NULL;
	gboolean result = FALSE;
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	DetectedPhotoInformation* detected = NULL;
	BackingPhotoRow* backing = NULL;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_;
	BackingPhotoRow* _tmp4_ = NULL;
	DetectedPhotoInformation* _tmp5_ = NULL;
	gboolean _tmp6_;
	BackingPhotoRow* _tmp8_;
	DetectedPhotoInformation* _tmp9_;
	PhotoMetadata* _tmp10_;
	PhotoReimportEditableStateImpl* _tmp11_;
	GError * _inner_error_ = NULL;
#line 1568 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1569 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (_vala_state);
#line 1569 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = NULL;
#line 1571 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_file (self);
#line 1571 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp0_;
#line 1572 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = file;
#line 1572 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 13094 "Photo.c"
		} else {
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 13098 "Photo.c"
		}
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 13102 "Photo.c"
	}
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = file;
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_verify_file_for_reimport (self, _tmp3_, &_tmp4_, &_tmp5_, &_inner_error_);
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (backing);
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
	backing = _tmp4_;
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp5_;
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp6_;
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 13120 "Photo.c"
		gboolean _tmp7_ = FALSE;
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp7_;
#line 13132 "Photo.c"
	}
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp2_) {
#line 1578 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1578 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1578 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1578 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1578 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 1578 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 13148 "Photo.c"
		} else {
#line 1578 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 13152 "Photo.c"
		}
#line 1578 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 13156 "Photo.c"
	}
#line 1580 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = backing;
#line 1580 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = detected;
#line 1580 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = _tmp9_->metadata;
#line 1580 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = photo_reimport_editable_state_impl_new (_tmp8_, _tmp10_);
#line 1580 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (_vala_state);
#line 1580 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState);
#line 1582 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 1582 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (backing);
#line 1582 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1582 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 1582 "/home/jens/Source/shotwell/src/Photo.vala"
	if (state) {
#line 1582 "/home/jens/Source/shotwell/src/Photo.vala"
		*state = _vala_state;
#line 13182 "Photo.c"
	} else {
#line 1582 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_editable_state_unref0 (_vala_state);
#line 13186 "Photo.c"
	}
#line 1582 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13190 "Photo.c"
}


static gpointer
_photo_reimport_editable_state_ref0 (gpointer self)
{
#line 1591 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_reimport_editable_state_ref (self) : NULL;
#line 13199 "Photo.c"
}


void
photo_finish_reimport_editable (Photo* self,
                                PhotoReimportEditableState* state,
                                GError** error)
{
	BackingPhotoID editable_id = {0};
	BackingPhotoID _tmp0_ = {0};
	PhotoReimportEditableStateImpl* reimport_state = NULL;
	PhotoReimportEditableStateImpl* _tmp1_;
	PhotoReimportEditableStateImpl* _tmp2_;
	gboolean _tmp3_;
	PhotoReimportEditableStateImpl* _tmp19_;
	PhotoMetadata* _tmp20_;
	gchar* list = NULL;
	gchar* _tmp33_;
	PhotoReimportEditableStateImpl* _tmp34_;
	gboolean _tmp35_;
	const gchar* _tmp38_;
	Alteration* _tmp39_;
	Alteration* _tmp40_;
	PhotoReimportEditableStateImpl* _tmp41_;
	PhotoMetadata* _tmp42_;
	GError * _inner_error_ = NULL;
#line 1586 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1586 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_EDITABLE_STATE (state));
#line 1587 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_editable_id (self, &_tmp0_);
#line 1587 "/home/jens/Source/shotwell/src/Photo.vala"
	editable_id = _tmp0_;
#line 1588 "/home/jens/Source/shotwell/src/Photo.vala"
	if (backing_photo_id_is_invalid (&editable_id)) {
#line 1589 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 13238 "Photo.c"
	}
#line 1591 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _photo_reimport_editable_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (state, PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl));
#line 1591 "/home/jens/Source/shotwell/src/Photo.vala"
	reimport_state = _tmp1_;
#line 1593 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = reimport_state;
#line 1593 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_->metadata_only;
#line 1593 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp3_) {
#line 13250 "Photo.c"
		BackingPhotoTable* _tmp4_;
		BackingPhotoTable* _tmp5_;
		PhotoReimportEditableStateImpl* _tmp6_;
		BackingPhotoRow* _tmp7_;
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = backing_photo_table_get_instance ();
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp4_;
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = reimport_state;
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp6_->backing_state;
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
		backing_photo_table_update (_tmp5_, _tmp7_, &_inner_error_);
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
		_database_table_unref0 (_tmp5_);
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_editable_state_unref0 (reimport_state);
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 13277 "Photo.c"
			} else {
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_editable_state_unref0 (reimport_state);
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 13287 "Photo.c"
			}
		}
		{
			PhotoRow* _tmp8_;
#line 1596 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = self->row;
#line 1596 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 13296 "Photo.c"
			{
				PhotoReimportEditableStateImpl* _tmp9_;
				BackingPhotoRow* _tmp10_;
				BackingPhotoRow* _tmp11_;
				PhotoReimportEditableStateImpl* _tmp12_;
				BackingPhotoRow* _tmp13_;
				Orientation _tmp14_;
#line 1597 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = reimport_state;
#line 1597 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_->backing_state;
#line 1597 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _backing_photo_row_ref0 (_tmp10_);
#line 1597 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (self->priv->editable);
#line 1597 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->editable = _tmp11_;
#line 1598 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = reimport_state;
#line 1598 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _tmp12_->backing_state;
#line 1598 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = _tmp13_->original_orientation;
#line 1598 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_set_orientation (self, _tmp14_);
#line 1599 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_internal_remove_all_transformations (self, FALSE);
#line 13324 "Photo.c"
			}
			__finally319:
			{
				PhotoRow* _tmp15_;
#line 1596 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = self->row;
#line 1596 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 13333 "Photo.c"
			}
#line 1596 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1596 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 1596 "/home/jens/Source/shotwell/src/Photo.vala"
					g_propagate_error (error, _inner_error_);
#line 1596 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_reimport_editable_state_unref0 (reimport_state);
#line 1596 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 13345 "Photo.c"
				} else {
#line 1596 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_reimport_editable_state_unref0 (reimport_state);
#line 1596 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1596 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 1596 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 13355 "Photo.c"
				}
			}
		}
	} else {
		PhotoReimportEditableStateImpl* _tmp16_;
		BackingPhotoRow* _tmp17_;
		Orientation _tmp18_;
#line 1602 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = reimport_state;
#line 1602 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = _tmp16_->backing_state;
#line 1602 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = _tmp17_->original_orientation;
#line 1602 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_set_orientation (self, _tmp18_);
#line 13371 "Photo.c"
	}
#line 1605 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = reimport_state;
#line 1605 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = _tmp19_->metadata;
#line 1605 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp20_ != NULL) {
#line 13379 "Photo.c"
		PhotoReimportEditableStateImpl* _tmp21_;
		PhotoMetadata* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		PhotoReimportEditableStateImpl* _tmp25_;
		PhotoMetadata* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		PhotoReimportEditableStateImpl* _tmp29_;
		PhotoMetadata* _tmp30_;
		PhotoReimportEditableStateImpl* _tmp31_;
		PhotoMetadata* _tmp32_;
#line 1606 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = reimport_state;
#line 1606 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = _tmp21_->metadata;
#line 1606 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1606 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = _tmp23_;
#line 1606 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp24_);
#line 1606 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp24_);
#line 1607 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = reimport_state;
#line 1607 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp26_ = _tmp25_->metadata;
#line 1607 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp27_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1607 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp28_ = _tmp27_;
#line 1607 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp28_);
#line 1607 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp28_);
#line 1608 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = reimport_state;
#line 1608 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = _tmp29_->metadata;
#line 1608 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), photo_metadata_get_rating (_tmp30_));
#line 1609 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp31_ = reimport_state;
#line 1609 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp32_ = _tmp31_->metadata;
#line 1609 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_apply_user_metadata_for_reimport (self, _tmp32_);
#line 13428 "Photo.c"
	}
#line 1612 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = g_strdup ("metadata:name,image:orientation,metadata:rating,metadata:exposure-time");
#line 1612 "/home/jens/Source/shotwell/src/Photo.vala"
	list = _tmp33_;
#line 1613 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = reimport_state;
#line 1613 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp35_ = _tmp34_->metadata_only;
#line 1613 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp35_) {
#line 13440 "Photo.c"
		const gchar* _tmp36_;
		gchar* _tmp37_;
#line 1614 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = list;
#line 1614 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp37_ = g_strconcat (_tmp36_, "image:editable,image:baseline", NULL);
#line 1614 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (list);
#line 1614 "/home/jens/Source/shotwell/src/Photo.vala"
		list = _tmp37_;
#line 13451 "Photo.c"
	}
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = list;
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp39_ = alteration_new_from_list (_tmp38_);
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp40_ = _tmp39_;
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp40_);
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
	_alteration_unref0 (_tmp40_);
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp41_ = reimport_state;
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp42_ = _tmp41_->metadata;
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_notify_editable_reimported (self, _tmp42_);
#line 1620 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_is_editable_baseline (self)) {
#line 13471 "Photo.c"
		PhotoReimportEditableStateImpl* _tmp43_;
		PhotoMetadata* _tmp44_;
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp43_ = reimport_state;
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_ = _tmp43_->metadata;
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_baseline_reimported (self, _tmp44_);
#line 13480 "Photo.c"
	}
#line 1623 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_is_editable_source (self)) {
#line 13484 "Photo.c"
		PhotoReimportEditableStateImpl* _tmp45_;
		PhotoMetadata* _tmp46_;
#line 1624 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp45_ = reimport_state;
#line 1624 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp46_ = _tmp45_->metadata;
#line 1624 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_source_reimported (self, _tmp46_);
#line 13493 "Photo.c"
	}
#line 1586 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (list);
#line 1586 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (reimport_state);
#line 13499 "Photo.c"
}


static gpointer
_photo_reimport_raw_development_state_ref0 (gpointer self)
{
#line 1646 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_reimport_raw_development_state_ref (self) : NULL;
#line 13508 "Photo.c"
}


gboolean
photo_prepare_for_reimport_raw_development (Photo* self,
                                            PhotoReimportRawDevelopmentState* * state,
                                            GError** error)
{
	PhotoReimportRawDevelopmentState* _vala_state = NULL;
	gboolean result = FALSE;
	GeeCollection* files = NULL;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	PhotoReimportRawDevelopmentStateImpl* reimport_state = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp2_;
	PhotoReimportRawDevelopmentStateImpl* _tmp18_;
	PhotoReimportRawDevelopmentState* _tmp19_;
	PhotoReimportRawDevelopmentStateImpl* _tmp20_;
	GError * _inner_error_ = NULL;
#line 1628 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1629 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_raw_development_state_unref0 (_vala_state);
#line 1629 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = NULL;
#line 1631 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_raw_developer_files (self);
#line 1631 "/home/jens/Source/shotwell/src/Photo.vala"
	files = _tmp0_;
#line 1632 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = files;
#line 1632 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 1633 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1633 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (files);
#line 1633 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 1633 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 13550 "Photo.c"
		} else {
#line 1633 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_raw_development_state_unref0 (_vala_state);
#line 13554 "Photo.c"
		}
#line 1633 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 13558 "Photo.c"
	}
#line 1635 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_reimport_raw_development_state_impl_new ();
#line 1635 "/home/jens/Source/shotwell/src/Photo.vala"
	reimport_state = _tmp2_;
#line 13564 "Photo.c"
	{
		GeeIterator* _file_it = NULL;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = files;
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
		_file_it = _tmp4_;
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
		while (TRUE) {
#line 13577 "Photo.c"
			GeeIterator* _tmp5_;
			GFile* file = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			DetectedPhotoInformation* detected = NULL;
			BackingPhotoRow* backing = NULL;
			gboolean _tmp8_ = FALSE;
			GFile* _tmp9_;
			BackingPhotoRow* _tmp10_ = NULL;
			DetectedPhotoInformation* _tmp11_ = NULL;
			gboolean _tmp12_;
			PhotoReimportRawDevelopmentStateImpl* _tmp14_;
			BackingPhotoRow* _tmp15_;
			DetectedPhotoInformation* _tmp16_;
			PhotoMetadata* _tmp17_;
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _file_it;
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!gee_iterator_next (_tmp5_)) {
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 13599 "Photo.c"
			}
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _file_it;
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
			file = (GFile*) _tmp7_;
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = file;
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = photo_verify_file_for_reimport (self, _tmp9_, &_tmp10_, &_tmp11_, &_inner_error_);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
			backing = _tmp10_;
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
			detected = _tmp11_;
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp12_;
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 13623 "Photo.c"
				gboolean _tmp13_ = FALSE;
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (backing);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				_detected_photo_information_unref0 (detected);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (file);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_file_it);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (files);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				return _tmp13_;
#line 13641 "Photo.c"
			}
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp8_) {
#line 1641 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (backing);
#line 1641 "/home/jens/Source/shotwell/src/Photo.vala"
				_detected_photo_information_unref0 (detected);
#line 1641 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (file);
#line 1641 "/home/jens/Source/shotwell/src/Photo.vala"
				continue;
#line 13653 "Photo.c"
			}
#line 1643 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = reimport_state;
#line 1643 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = backing;
#line 1643 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = detected;
#line 1643 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = _tmp16_->metadata;
#line 1643 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_reimport_raw_development_state_impl_add (_tmp14_, _tmp15_, _tmp17_);
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing);
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 13671 "Photo.c"
		}
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_file_it);
#line 13675 "Photo.c"
	}
#line 1646 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = reimport_state;
#line 1646 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = _photo_reimport_raw_development_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentState));
#line 1646 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_raw_development_state_unref0 (_vala_state);
#line 1646 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = _tmp19_;
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = reimport_state;
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
	result = photo_reimport_raw_development_state_impl_get_size (_tmp20_) > 0;
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (files);
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
	if (state) {
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
		*state = _vala_state;
#line 13697 "Photo.c"
	} else {
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_raw_development_state_unref0 (_vala_state);
#line 13701 "Photo.c"
	}
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13705 "Photo.c"
}


void
photo_finish_reimport_raw_development (Photo* self,
                                       PhotoReimportRawDevelopmentState* state,
                                       GError** error)
{
	PhotoReimportRawDevelopmentStateImpl* reimport_state = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp0_;
	gchar* list = NULL;
	gchar* _tmp29_;
	PhotoReimportRawDevelopmentStateImpl* _tmp30_;
	gboolean _tmp31_;
	const gchar* _tmp34_;
	Alteration* _tmp35_;
	Alteration* _tmp36_;
	GError * _inner_error_ = NULL;
#line 1651 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1651 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE (state));
#line 1652 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_get_master_file_format (self) != PHOTO_FILE_FORMAT_RAW) {
#line 1653 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 13732 "Photo.c"
	}
#line 1655 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _photo_reimport_raw_development_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (state, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImpl));
#line 1655 "/home/jens/Source/shotwell/src/Photo.vala"
	reimport_state = _tmp0_;
#line 13738 "Photo.c"
	{
		GeeIterator* _dev_it = NULL;
		PhotoReimportRawDevelopmentStateImpl* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = reimport_state;
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = _tmp1_->list;
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
		_dev_it = _tmp3_;
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
		while (TRUE) {
#line 13754 "Photo.c"
			GeeIterator* _tmp4_;
			PhotoReimportRawDevelopmentStateImplDevToReimport* dev = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			PhotoReimportRawDevelopmentStateImpl* _tmp7_;
			gboolean _tmp8_;
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _dev_it;
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 13767 "Photo.c"
			}
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _dev_it;
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
			dev = (PhotoReimportRawDevelopmentStateImplDevToReimport*) _tmp6_;
#line 1658 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = reimport_state;
#line 1658 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_->metadata_only;
#line 1658 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp8_) {
#line 13781 "Photo.c"
				BackingPhotoTable* _tmp9_;
				BackingPhotoTable* _tmp10_;
				PhotoReimportRawDevelopmentStateImplDevToReimport* _tmp11_;
				BackingPhotoRow* _tmp12_;
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = backing_photo_table_get_instance ();
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_;
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = dev;
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = _tmp11_->backing;
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
				backing_photo_table_update (_tmp10_, _tmp12_, &_inner_error_);
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp10_);
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
						g_propagate_error (error, _inner_error_);
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_dev_it);
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
						return;
#line 13812 "Photo.c"
					} else {
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_dev_it);
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
						g_clear_error (&_inner_error_);
#line 1659 "/home/jens/Source/shotwell/src/Photo.vala"
						return;
#line 13826 "Photo.c"
					}
				}
				{
					PhotoRow* _tmp13_;
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_ = self->row;
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_lock (&self->priv->__lock_row);
#line 13835 "Photo.c"
					{
						gint _tmp14_;
						RawDeveloper* _tmp15_;
#line 1663 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp15_ = raw_developer_as_array (&_tmp14_);
#line 13841 "Photo.c"
						{
							RawDeveloper* d_collection = NULL;
							gint d_collection_length1 = 0;
							gint _d_collection_size_ = 0;
							gint d_it = 0;
#line 1663 "/home/jens/Source/shotwell/src/Photo.vala"
							d_collection = _tmp15_;
#line 1663 "/home/jens/Source/shotwell/src/Photo.vala"
							d_collection_length1 = _tmp14_;
#line 1663 "/home/jens/Source/shotwell/src/Photo.vala"
							for (d_it = 0; d_it < _tmp14_; d_it = d_it + 1) {
#line 13853 "Photo.c"
								RawDeveloper d = 0;
#line 1663 "/home/jens/Source/shotwell/src/Photo.vala"
								d = d_collection[d_it];
#line 13857 "Photo.c"
								{
									BackingPhotoID id = {0};
									PhotoRow* _tmp16_;
									BackingPhotoID* _tmp17_;
									gint _tmp17__length1;
									RawDeveloper _tmp18_;
									BackingPhotoID _tmp19_;
									BackingPhotoID _tmp20_;
									gint64 _tmp21_;
#line 1664 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp16_ = self->row;
#line 1664 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp17_ = _tmp16_->development_ids;
#line 1664 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp17__length1 = _tmp16_->development_ids_length1;
#line 1664 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp18_ = d;
#line 1664 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp19_ = _tmp17_[_tmp18_];
#line 1664 "/home/jens/Source/shotwell/src/Photo.vala"
									id = _tmp19_;
#line 1665 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp20_ = id;
#line 1665 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp21_ = _tmp20_.id;
#line 1665 "/home/jens/Source/shotwell/src/Photo.vala"
									if (_tmp21_ != BACKING_PHOTO_ID_INVALID) {
#line 13885 "Photo.c"
										BackingPhotoRow* bpr = NULL;
										BackingPhotoID _tmp22_;
										BackingPhotoRow* _tmp23_;
										BackingPhotoRow* _tmp24_;
#line 1666 "/home/jens/Source/shotwell/src/Photo.vala"
										_tmp22_ = id;
#line 1666 "/home/jens/Source/shotwell/src/Photo.vala"
										_tmp23_ = photo_get_backing_row (self, &_tmp22_);
#line 1666 "/home/jens/Source/shotwell/src/Photo.vala"
										bpr = _tmp23_;
#line 1667 "/home/jens/Source/shotwell/src/Photo.vala"
										_tmp24_ = bpr;
#line 1667 "/home/jens/Source/shotwell/src/Photo.vala"
										if (_tmp24_ != NULL) {
#line 13900 "Photo.c"
											GeeHashMap* _tmp25_;
											RawDeveloper _tmp26_;
											BackingPhotoRow* _tmp27_;
#line 1668 "/home/jens/Source/shotwell/src/Photo.vala"
											_tmp25_ = self->priv->developments;
#line 1668 "/home/jens/Source/shotwell/src/Photo.vala"
											_tmp26_ = d;
#line 1668 "/home/jens/Source/shotwell/src/Photo.vala"
											_tmp27_ = bpr;
#line 1668 "/home/jens/Source/shotwell/src/Photo.vala"
											gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp26_), _tmp27_);
#line 13912 "Photo.c"
										}
#line 1665 "/home/jens/Source/shotwell/src/Photo.vala"
										_backing_photo_row_unref0 (bpr);
#line 13916 "Photo.c"
									}
								}
							}
#line 1663 "/home/jens/Source/shotwell/src/Photo.vala"
							d_collection = (g_free (d_collection), NULL);
#line 13922 "Photo.c"
						}
					}
					__finally320:
					{
						PhotoRow* _tmp28_;
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp28_ = self->row;
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_row);
#line 13932 "Photo.c"
					}
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
							g_propagate_error (error, _inner_error_);
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_object_unref0 (_dev_it);
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
							return;
#line 13948 "Photo.c"
						} else {
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_object_unref0 (_dev_it);
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
							g_clear_error (&_inner_error_);
#line 1661 "/home/jens/Source/shotwell/src/Photo.vala"
							return;
#line 13962 "Photo.c"
						}
					}
				}
			}
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 13969 "Photo.c"
		}
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_dev_it);
#line 13973 "Photo.c"
	}
#line 1675 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp29_ = g_strdup ("metadata:name,image:orientation,metadata:rating,metadata:exposure-time");
#line 1675 "/home/jens/Source/shotwell/src/Photo.vala"
	list = _tmp29_;
#line 1676 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp30_ = reimport_state;
#line 1676 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = _tmp30_->metadata_only;
#line 1676 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp31_) {
#line 13985 "Photo.c"
		const gchar* _tmp32_;
		gchar* _tmp33_;
#line 1677 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp32_ = list;
#line 1677 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp33_ = g_strconcat (_tmp32_, "image:editable,image:baseline", NULL);
#line 1677 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (list);
#line 1677 "/home/jens/Source/shotwell/src/Photo.vala"
		list = _tmp33_;
#line 13996 "Photo.c"
	}
#line 1679 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = list;
#line 1679 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp35_ = alteration_new_from_list (_tmp34_);
#line 1679 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_ = _tmp35_;
#line 1679 "/home/jens/Source/shotwell/src/Photo.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp36_);
#line 1679 "/home/jens/Source/shotwell/src/Photo.vala"
	_alteration_unref0 (_tmp36_);
#line 1681 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_notify_raw_development_modified (self);
#line 1651 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (list);
#line 1651 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 14014 "Photo.c"
}


static gchar*
photo_real_get_typename (DataSource* base)
{
	Photo * self;
	gchar* result = NULL;
	gchar* _tmp0_;
#line 1684 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = g_strdup (PHOTO_TYPENAME);
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14032 "Photo.c"
}


static gint64
photo_real_get_instance_id (DataSource* base)
{
	Photo * self;
	gint64 result = 0LL;
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_;
#line 1688 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1689 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_photo_id (self, &_tmp0_);
#line 1689 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_.id;
#line 1689 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp1_;
#line 1689 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14053 "Photo.c"
}


static gchar*
photo_real_get_source_id (DataSource* base)
{
	Photo * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1692 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1696 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = data_source_get_typename (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource));
#line 1696 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1696 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = g_strdup_printf ("%s%016" G_GINT64_MODIFIER "x", _tmp1_, data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource)));
#line 1696 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1696 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp1_);
#line 1696 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 1696 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14082 "Photo.c"
}


void
photo_set_master_timestamp (Photo* self,
                            GFileInfo* info)
{
	GTimeVal modification = {0};
	GTimeVal _tmp0_ = {0};
	GError * _inner_error_ = NULL;
#line 1700 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1700 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 1701 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (info, &_tmp0_);
#line 1701 "/home/jens/Source/shotwell/src/Photo.vala"
	modification = _tmp0_;
#line 14101 "Photo.c"
	{
		{
			PhotoRow* _tmp1_;
#line 1704 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 1704 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 14109 "Photo.c"
			{
				PhotoRow* _tmp2_;
				BackingPhotoRow* _tmp3_;
				time_t _tmp4_;
				GTimeVal _tmp5_;
				glong _tmp6_;
				PhotoTable* _tmp8_;
				PhotoTable* _tmp9_;
				PhotoRow* _tmp10_;
				PhotoID _tmp11_;
				GTimeVal _tmp12_;
				glong _tmp13_;
				PhotoRow* _tmp14_;
				BackingPhotoRow* _tmp15_;
				GTimeVal _tmp16_;
				glong _tmp17_;
#line 1705 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp2_ = self->row;
#line 1705 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = _tmp2_->master;
#line 1705 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->timestamp;
#line 1705 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = modification;
#line 1705 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = _tmp5_.tv_sec;
#line 1705 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp4_ == ((time_t) _tmp6_)) {
#line 14138 "Photo.c"
					{
						PhotoRow* _tmp7_;
#line 1704 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp7_ = self->row;
#line 1704 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_row);
#line 14145 "Photo.c"
					}
#line 1706 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 14149 "Photo.c"
				}
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = photo_table_get_instance ();
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = _tmp8_;
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = self->row;
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _tmp10_->photo_id;
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = modification;
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _tmp12_.tv_sec;
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_update_timestamp (_tmp9_, &_tmp11_, (time_t) _tmp13_, &_inner_error_);
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp9_);
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 14169 "Photo.c"
					goto __finally322;
				}
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = self->row;
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = _tmp14_->master;
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = modification;
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = _tmp16_.tv_sec;
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_->timestamp = (time_t) _tmp17_;
#line 14182 "Photo.c"
			}
			__finally322:
			{
				PhotoRow* _tmp18_;
#line 1704 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = self->row;
#line 1704 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 14191 "Photo.c"
			}
#line 1704 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1704 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 14197 "Photo.c"
					goto __catch321_database_error;
				}
#line 1704 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1704 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1704 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 14206 "Photo.c"
			}
		}
	}
	goto __finally321;
	__catch321_database_error:
	{
		GError* err = NULL;
		GError* _tmp19_;
#line 1703 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1703 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1712 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = err;
#line 1712 "/home/jens/Source/shotwell/src/Photo.vala"
		app_window_database_error (_tmp19_);
#line 1714 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 1714 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 14227 "Photo.c"
	}
	__finally321:
#line 1703 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1703 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1703 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1703 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 14238 "Photo.c"
	}
#line 1717 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_is_master_baseline (self)) {
#line 14242 "Photo.c"
		Alteration* _tmp20_;
		Alteration* _tmp21_;
#line 1718 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = alteration_new_from_list ("metadata:master-timestamp,metadata:baseline-timestamp");
#line 1718 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = _tmp20_;
#line 1718 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp21_);
#line 1718 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp21_);
#line 14253 "Photo.c"
	} else {
		Alteration* _tmp22_;
		Alteration* _tmp23_;
#line 1720 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = alteration_new ("metadata", "master-timestamp");
#line 1720 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = _tmp22_;
#line 1720 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp23_);
#line 1720 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp23_);
#line 14265 "Photo.c"
	}
}


void
photo_update_editable_modification_time (Photo* self,
                                         GFileInfo* info,
                                         GError** error)
{
	GTimeVal modification = {0};
	GTimeVal _tmp0_ = {0};
	gboolean altered = FALSE;
	gboolean _tmp18_;
	GError * _inner_error_ = NULL;
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (info, &_tmp0_);
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
	modification = _tmp0_;
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
	altered = FALSE;
#line 14290 "Photo.c"
	{
		PhotoRow* _tmp1_;
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = self->row;
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 14297 "Photo.c"
		{
			gboolean _tmp2_ = FALSE;
			PhotoRow* _tmp3_;
#line 1729 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 1729 "/home/jens/Source/shotwell/src/Photo.vala"
			if (backing_photo_id_is_valid (&_tmp3_->editable_id)) {
#line 14305 "Photo.c"
				BackingPhotoRow* _tmp4_;
				time_t _tmp5_;
				GTimeVal _tmp6_;
				glong _tmp7_;
#line 1729 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->editable;
#line 1729 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_->timestamp;
#line 1729 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = modification;
#line 1729 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_.tv_sec;
#line 1729 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp2_ = _tmp5_ != ((time_t) _tmp7_);
#line 14320 "Photo.c"
			} else {
#line 1729 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp2_ = FALSE;
#line 14324 "Photo.c"
			}
#line 1729 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_) {
#line 14328 "Photo.c"
				BackingPhotoTable* _tmp8_;
				BackingPhotoTable* _tmp9_;
				PhotoRow* _tmp10_;
				BackingPhotoID _tmp11_;
				GTimeVal _tmp12_;
				glong _tmp13_;
				BackingPhotoRow* _tmp14_;
				GTimeVal _tmp15_;
				glong _tmp16_;
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = backing_photo_table_get_instance ();
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = _tmp8_;
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = self->row;
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _tmp10_->editable_id;
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = modification;
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _tmp12_.tv_sec;
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
				backing_photo_table_update_timestamp (_tmp9_, &_tmp11_, (time_t) _tmp13_, &_inner_error_);
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp9_);
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 14356 "Photo.c"
					goto __finally323;
				}
#line 1732 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = self->priv->editable;
#line 1732 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = modification;
#line 1732 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = _tmp15_.tv_sec;
#line 1732 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_->timestamp = (time_t) _tmp16_;
#line 1733 "/home/jens/Source/shotwell/src/Photo.vala"
				altered = TRUE;
#line 14369 "Photo.c"
			}
		}
		__finally323:
		{
			PhotoRow* _tmp17_;
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = self->row;
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 14379 "Photo.c"
		}
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 14389 "Photo.c"
			} else {
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 14397 "Photo.c"
			}
		}
	}
#line 1737 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = altered;
#line 1737 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp18_) {
#line 14405 "Photo.c"
		Alteration* _tmp19_;
		Alteration* _tmp20_;
#line 1738 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = alteration_new_from_list ("metadata:editable-timestamp,metadata:baseline-timestamp");
#line 1738 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = _tmp19_;
#line 1738 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp20_);
#line 1738 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp20_);
#line 14416 "Photo.c"
	}
}


void
photo_update_many_editable_timestamps (GeeMap* map,
                                       GError** error)
{
	GError * _inner_error_ = NULL;
#line 1742 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 1744 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_begin_transaction ();
#line 14430 "Photo.c"
	{
		GeeIterator* _photo_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = gee_map_get_keys (map);
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp0_;
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = _tmp1_;
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp3_;
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp2_);
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_it = _tmp4_;
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		while (TRUE) {
#line 14454 "Photo.c"
			GeeIterator* _tmp5_;
			Photo* photo = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Photo* _tmp8_;
			Photo* _tmp9_;
			gpointer _tmp10_;
			GFileInfo* _tmp11_;
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _photo_it;
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!gee_iterator_next (_tmp5_)) {
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 14469 "Photo.c"
			}
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _photo_it;
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
			photo = (Photo*) _tmp7_;
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = photo;
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = photo;
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = gee_map_get (map, _tmp9_);
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = (GFileInfo*) _tmp10_;
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_update_editable_modification_time (_tmp8_, _tmp11_, &_inner_error_);
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_tmp11_);
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
					g_propagate_error (error, _inner_error_);
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (photo);
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_photo_it);
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 14501 "Photo.c"
				} else {
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (photo);
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_photo_it);
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 14513 "Photo.c"
				}
			}
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (photo);
#line 14518 "Photo.c"
		}
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_photo_it);
#line 14522 "Photo.c"
	}
#line 1747 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_commit_transaction (&_inner_error_);
#line 1747 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1747 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1747 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 1747 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 14534 "Photo.c"
		} else {
#line 1747 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1747 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1747 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 14542 "Photo.c"
		}
	}
}


static PhotoFileFormat
photo_real_get_preferred_thumbnail_format (ThumbnailSource* base)
{
	Photo * self;
	PhotoFileFormat result = 0;
	PhotoFileFormat _tmp0_ = 0;
#line 1750 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1751 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_file_format_can_write_image (photo_get_file_format (self))) {
#line 1751 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_get_file_format (self);
#line 14560 "Photo.c"
	} else {
#line 1752 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_file_format_get_system_default_format ();
#line 14564 "Photo.c"
	}
#line 1751 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 1751 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14570 "Photo.c"
}


static GdkPixbuf*
photo_real_create_thumbnail (ThumbnailSource* base,
                             gint scale,
                             GError** error)
{
	Photo * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_ = {0};
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError * _inner_error_ = NULL;
#line 1755 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
	scaling_for_best_fit (scale, TRUE, &_tmp1_);
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp1_, &_inner_error_);
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp2_;
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 14600 "Photo.c"
	}
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp0_;
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14612 "Photo.c"
}


gboolean
photo_is_file_image (GFile* file)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1759 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 1763 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_file_format_is_file_supported (file)) {
#line 1764 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = TRUE;
#line 14627 "Photo.c"
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
#line 1764 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = g_file_get_basename (file);
#line 1764 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = _tmp1_;
#line 1764 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_is_extension_found (_tmp2_, PHOTO_IMAGE_EXTENSIONS, G_N_ELEMENTS (PHOTO_IMAGE_EXTENSIONS));
#line 1764 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp2_);
#line 14639 "Photo.c"
	}
#line 1763 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 1763 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14645 "Photo.c"
}


static gboolean
photo_is_extension_found (const gchar* basename,
                          gchar** extensions,
                          int extensions_length1)
{
	gboolean result = FALSE;
	gchar* name = NULL;
	gchar* ext = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 1767 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (basename != NULL, FALSE);
#line 1769 "/home/jens/Source/shotwell/src/Photo.vala"
	disassemble_filename (basename, &_tmp0_, &_tmp1_);
#line 1769 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (name);
#line 1769 "/home/jens/Source/shotwell/src/Photo.vala"
	name = _tmp0_;
#line 1769 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (ext);
#line 1769 "/home/jens/Source/shotwell/src/Photo.vala"
	ext = _tmp1_;
#line 1770 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = ext;
#line 1770 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_ == NULL) {
#line 1771 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1771 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (ext);
#line 1771 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (name);
#line 1771 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 14686 "Photo.c"
	}
#line 1774 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = ext;
#line 1774 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
#line 1774 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (ext);
#line 1774 "/home/jens/Source/shotwell/src/Photo.vala"
	ext = _tmp4_;
#line 14696 "Photo.c"
	{
		gchar** extension_collection = NULL;
		gint extension_collection_length1 = 0;
		gint _extension_collection_size_ = 0;
		gint extension_it = 0;
#line 1777 "/home/jens/Source/shotwell/src/Photo.vala"
		extension_collection = extensions;
#line 1777 "/home/jens/Source/shotwell/src/Photo.vala"
		extension_collection_length1 = extensions_length1;
#line 1777 "/home/jens/Source/shotwell/src/Photo.vala"
		for (extension_it = 0; extension_it < extensions_length1; extension_it = extension_it + 1) {
#line 14708 "Photo.c"
			gchar* _tmp5_;
			gchar* extension = NULL;
#line 1777 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = g_strdup (extension_collection[extension_it]);
#line 1777 "/home/jens/Source/shotwell/src/Photo.vala"
			extension = _tmp5_;
#line 14715 "Photo.c"
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
#line 1778 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = ext;
#line 1778 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = extension;
#line 1778 "/home/jens/Source/shotwell/src/Photo.vala"
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
					result = TRUE;
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (extension);
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (ext);
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (name);
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
					return result;
#line 14735 "Photo.c"
				}
#line 1777 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (extension);
#line 14739 "Photo.c"
			}
		}
	}
#line 1782 "/home/jens/Source/shotwell/src/Photo.vala"
	result = FALSE;
#line 1782 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (ext);
#line 1782 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (name);
#line 1782 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14751 "Photo.c"
}


gboolean
photo_is_duplicate (GFile* file,
                    const gchar* thumbnail_md5,
                    const gchar* full_md5,
                    PhotoFileFormat file_format)
{
	gboolean result = FALSE;
	PhotoTable* _tmp0_;
	PhotoTable* _tmp1_;
	gboolean _tmp2_;
#line 1788 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), FALSE);
#line 1791 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_table_get_instance ();
#line 1791 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1791 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_table_has_duplicate (_tmp1_, file, thumbnail_md5, full_md5, file_format);
#line 1791 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp1_);
#line 1791 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp2_;
#line 1791 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14779 "Photo.c"
}


PhotoID*
photo_get_duplicate_ids (GFile* file,
                         const gchar* thumbnail_md5,
                         const gchar* full_md5,
                         PhotoFileFormat file_format,
                         int* result_length1)
{
	PhotoID* result = NULL;
	PhotoTable* _tmp0_;
	PhotoTable* _tmp1_;
	gint _tmp2_;
	PhotoID* _tmp3_;
	PhotoID* _tmp4_;
	gint _tmp4__length1;
	PhotoID* _tmp5_;
	gint _tmp5__length1;
#line 1797 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), NULL);
#line 1800 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_table_get_instance ();
#line 1800 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1800 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_table_get_duplicate_ids (_tmp1_, file, thumbnail_md5, full_md5, file_format, &_tmp2_);
#line 1800 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp3_;
#line 1800 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4__length1 = _tmp2_;
#line 1800 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp1_);
#line 1800 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = _tmp4_;
#line 1800 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5__length1 = _tmp4__length1;
#line 1800 "/home/jens/Source/shotwell/src/Photo.vala"
	if (result_length1) {
#line 1800 "/home/jens/Source/shotwell/src/Photo.vala"
		*result_length1 = _tmp5__length1;
#line 14821 "Photo.c"
	}
#line 1800 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp5_;
#line 1800 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14827 "Photo.c"
}


gint64
photo_get_photo_key (DataSource* source)
{
	gint64 result = 0LL;
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_;
#line 1807 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0LL);
#line 1808 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_photo_id (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto), TYPE_PHOTO, Photo), &_tmp0_);
#line 1808 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_.id;
#line 1808 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp1_;
#line 1808 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14847 "Photo.c"
}


static GFile*
photo_real_get_file (MediaSource* base)
{
	Photo * self;
	GFile* result = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
#line 1826 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1827 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 1827 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1827 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1827 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1827 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1827 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 1827 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14876 "Photo.c"
}


static void
_vala_array_add99 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 1870 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1870 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1870 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14892 "Photo.c"
	}
#line 1870 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1870 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14898 "Photo.c"
}


static void
_vala_array_add100 (gchar** * array,
                    int* length,
                    int* size,
                    gchar* value)
{
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14914 "Photo.c"
	}
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14920 "Photo.c"
}


static void
_vala_array_add101 (gchar** * array,
                    int* length,
                    int* size,
                    gchar* value)
{
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14936 "Photo.c"
	}
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14942 "Photo.c"
}


static void
_vala_array_add102 (gchar** * array,
                    int* length,
                    int* size,
                    gchar* value)
{
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14958 "Photo.c"
	}
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14964 "Photo.c"
}


void
photo_set_master_file (Photo* self,
                       GFile* file)
{
	gchar* filepath = NULL;
	gchar* _tmp0_;
	gboolean altered = FALSE;
	gboolean is_baseline = FALSE;
	gboolean is_source = FALSE;
	gboolean name_changed = FALSE;
	GFile* old_file = NULL;
	gboolean _tmp33_;
	GError * _inner_error_ = NULL;
#line 1832 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1832 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 1833 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = g_file_get_path (file);
#line 1833 "/home/jens/Source/shotwell/src/Photo.vala"
	filepath = _tmp0_;
#line 1835 "/home/jens/Source/shotwell/src/Photo.vala"
	altered = FALSE;
#line 1836 "/home/jens/Source/shotwell/src/Photo.vala"
	is_baseline = FALSE;
#line 1837 "/home/jens/Source/shotwell/src/Photo.vala"
	is_source = FALSE;
#line 1838 "/home/jens/Source/shotwell/src/Photo.vala"
	name_changed = FALSE;
#line 1839 "/home/jens/Source/shotwell/src/Photo.vala"
	old_file = NULL;
#line 14999 "Photo.c"
	{
		{
			PhotoRow* _tmp1_;
#line 1841 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 1841 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 15007 "Photo.c"
			{
				{
					PhotoBackingReaders* _tmp2_;
#line 1842 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp2_ = self->priv->readers;
#line 1842 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_lock (&self->priv->__lock_readers);
#line 15015 "Photo.c"
					{
						PhotoBackingReaders* _tmp3_;
						PhotoFileReader* _tmp4_;
						GFile* _tmp5_;
						GFile* _tmp6_;
#line 1843 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp3_ = self->priv->readers;
#line 1843 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp4_ = _tmp3_->master;
#line 1843 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp5_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1843 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (old_file);
#line 1843 "/home/jens/Source/shotwell/src/Photo.vala"
						old_file = _tmp5_;
#line 1844 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp6_ = old_file;
#line 1844 "/home/jens/Source/shotwell/src/Photo.vala"
						if (!g_file_equal (file, _tmp6_)) {
#line 15035 "Photo.c"
							PhotoTable* _tmp7_;
							PhotoTable* _tmp8_;
							PhotoID _tmp9_ = {0};
							const gchar* _tmp10_;
							PhotoRow* _tmp11_;
							BackingPhotoRow* _tmp12_;
							const gchar* _tmp13_;
							gchar* _tmp14_;
							gchar* _tmp15_;
							PhotoBackingReaders* _tmp16_;
							PhotoRow* _tmp17_;
							BackingPhotoRow* _tmp18_;
							PhotoFileFormat _tmp19_;
							const gchar* _tmp20_;
							PhotoFileReader* _tmp21_;
							gboolean _tmp22_ = FALSE;
							PhotoRow* _tmp23_;
							const gchar* _tmp24_;
#line 1845 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp7_ = photo_table_get_instance ();
#line 1845 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp8_ = _tmp7_;
#line 1845 "/home/jens/Source/shotwell/src/Photo.vala"
							photo_get_photo_id (self, &_tmp9_);
#line 1845 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp10_ = filepath;
#line 1845 "/home/jens/Source/shotwell/src/Photo.vala"
							photo_table_set_filepath (_tmp8_, &_tmp9_, _tmp10_, &_inner_error_);
#line 1845 "/home/jens/Source/shotwell/src/Photo.vala"
							_database_table_unref0 (_tmp8_);
#line 1845 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 15068 "Photo.c"
								goto __finally326;
							}
#line 1847 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp11_ = self->row;
#line 1847 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp12_ = _tmp11_->master;
#line 1847 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp13_ = filepath;
#line 1847 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp14_ = g_strdup (_tmp13_);
#line 1847 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_free0 (_tmp12_->filepath);
#line 1847 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp12_->filepath = _tmp14_;
#line 1848 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp15_ = g_file_get_basename (file);
#line 1848 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_free0 (self->priv->file_title);
#line 1848 "/home/jens/Source/shotwell/src/Photo.vala"
							self->priv->file_title = _tmp15_;
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp16_ = self->priv->readers;
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp17_ = self->row;
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp18_ = _tmp17_->master;
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp19_ = _tmp18_->file_format;
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp20_ = filepath;
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp21_ = photo_file_format_create_reader (_tmp19_, _tmp20_);
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_file_adapter_unref0 (_tmp16_->master);
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp16_->master = _tmp21_;
#line 1851 "/home/jens/Source/shotwell/src/Photo.vala"
							altered = TRUE;
#line 1852 "/home/jens/Source/shotwell/src/Photo.vala"
							is_baseline = photo_is_master_baseline (self);
#line 1853 "/home/jens/Source/shotwell/src/Photo.vala"
							is_source = photo_is_master_source (self);
#line 1854 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp23_ = self->row;
#line 1854 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp24_ = _tmp23_->title;
#line 1854 "/home/jens/Source/shotwell/src/Photo.vala"
							if (is_string_empty (_tmp24_)) {
#line 15117 "Photo.c"
								GFile* _tmp25_;
								gchar* _tmp26_;
								gchar* _tmp27_;
								gchar* _tmp28_;
								gchar* _tmp29_;
#line 1855 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp25_ = old_file;
#line 1855 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp26_ = g_file_get_basename (_tmp25_);
#line 1855 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp27_ = _tmp26_;
#line 1855 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp28_ = g_file_get_basename (file);
#line 1855 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp29_ = _tmp28_;
#line 1855 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp22_ = g_strcmp0 (_tmp27_, _tmp29_) != 0;
#line 1855 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_free0 (_tmp29_);
#line 1855 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_free0 (_tmp27_);
#line 15139 "Photo.c"
							} else {
#line 1854 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp22_ = FALSE;
#line 15143 "Photo.c"
							}
#line 1854 "/home/jens/Source/shotwell/src/Photo.vala"
							name_changed = _tmp22_;
#line 15147 "Photo.c"
						}
					}
					__finally326:
					{
						PhotoBackingReaders* _tmp30_;
#line 1842 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp30_ = self->priv->readers;
#line 1842 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 15157 "Photo.c"
					}
#line 1842 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 15161 "Photo.c"
						goto __finally325;
					}
				}
			}
			__finally325:
			{
				PhotoRow* _tmp31_;
#line 1841 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp31_ = self->row;
#line 1841 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15173 "Photo.c"
			}
#line 1841 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1841 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 15179 "Photo.c"
					goto __catch324_database_error;
				}
#line 1841 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (old_file);
#line 1841 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (filepath);
#line 1841 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1841 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1841 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 15192 "Photo.c"
			}
		}
	}
	goto __finally324;
	__catch324_database_error:
	{
		GError* err = NULL;
		GError* _tmp32_;
#line 1840 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1840 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1860 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp32_ = err;
#line 1860 "/home/jens/Source/shotwell/src/Photo.vala"
		app_window_database_error (_tmp32_);
#line 1840 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 15211 "Photo.c"
	}
	__finally324:
#line 1840 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1840 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (old_file);
#line 1840 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (filepath);
#line 1840 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1840 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1840 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 15226 "Photo.c"
	}
#line 1863 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = altered;
#line 1863 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp33_) {
#line 15232 "Photo.c"
		GFile* _tmp34_;
		gboolean _tmp35_;
		gchar** alteration_list = NULL;
		gchar** _tmp36_;
		gint alteration_list_length1;
		gint _alteration_list_size_;
		gchar** _tmp37_;
		gint _tmp37__length1;
		gchar* _tmp38_;
		gboolean _tmp39_;
		gboolean _tmp42_;
		gboolean _tmp45_;
		gchar** _tmp48_;
		gint _tmp48__length1;
		Alteration* _tmp49_;
		Alteration* _tmp50_;
#line 1864 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp34_ = old_file;
#line 1864 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_notify_master_replaced (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp34_, file);
#line 1866 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = is_baseline;
#line 1866 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp35_) {
#line 1867 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_notify_baseline_replaced (self);
#line 15259 "Photo.c"
		}
#line 1869 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = g_new0 (gchar*, 0 + 1);
#line 1869 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list = _tmp36_;
#line 1869 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list_length1 = 0;
#line 1869 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_list_size_ = alteration_list_length1;
#line 1870 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp37_ = alteration_list;
#line 1870 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp37__length1 = alteration_list_length1;
#line 1870 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp38_ = g_strdup ("backing:master");
#line 1870 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add99 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp38_);
#line 1874 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = name_changed;
#line 1874 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp39_) {
#line 15281 "Photo.c"
			gchar** _tmp40_;
			gint _tmp40__length1;
			gchar* _tmp41_;
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp40_ = alteration_list;
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp40__length1 = alteration_list_length1;
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp41_ = g_strdup ("metadata:name");
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add100 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp41_);
#line 15293 "Photo.c"
		}
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp42_ = is_source;
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp42_) {
#line 15299 "Photo.c"
			gchar** _tmp43_;
			gint _tmp43__length1;
			gchar* _tmp44_;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp43_ = alteration_list;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp43__length1 = alteration_list_length1;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp44_ = g_strdup ("backing:source");
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add101 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp44_);
#line 15311 "Photo.c"
		}
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp45_ = is_baseline;
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp45_) {
#line 15317 "Photo.c"
			gchar** _tmp46_;
			gint _tmp46__length1;
			gchar* _tmp47_;
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp46_ = alteration_list;
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp46__length1 = alteration_list_length1;
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp47_ = g_strdup ("backing:baseline");
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add102 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp47_);
#line 15329 "Photo.c"
		}
#line 1883 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp48_ = alteration_list;
#line 1883 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp48__length1 = alteration_list_length1;
#line 1883 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp49_ = alteration_new_from_array (_tmp48_, _tmp48__length1);
#line 1883 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp50_ = _tmp49_;
#line 1883 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp50_);
#line 1883 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp50_);
#line 1863 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list = (_vala_array_free (alteration_list, alteration_list_length1, (GDestroyNotify) g_free), NULL);
#line 15345 "Photo.c"
	}
#line 1832 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (old_file);
#line 1832 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (filepath);
#line 15351 "Photo.c"
}


static void
_vala_array_add103 (gchar** * array,
                    int* length,
                    int* size,
                    gchar* value)
{
#line 1923 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1923 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1923 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 15367 "Photo.c"
	}
#line 1923 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1923 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 15373 "Photo.c"
}


static void
_vala_array_add104 (gchar** * array,
                    int* length,
                    int* size,
                    gchar* value)
{
#line 1926 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1926 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1926 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 15389 "Photo.c"
	}
#line 1926 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1926 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 15395 "Photo.c"
}


static void
_vala_array_add105 (gchar** * array,
                    int* length,
                    int* size,
                    gchar* value)
{
#line 1929 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1929 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1929 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 15411 "Photo.c"
	}
#line 1929 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1929 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 15417 "Photo.c"
}


void
photo_set_editable_file (Photo* self,
                         GFile* file)
{
	gchar* filepath = NULL;
	gchar* _tmp0_;
	gboolean altered = FALSE;
	gboolean is_baseline = FALSE;
	gboolean is_source = FALSE;
	GFile* old_file = NULL;
	gboolean _tmp29_;
	GError * _inner_error_ = NULL;
#line 1889 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1889 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 1890 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = g_file_get_path (file);
#line 1890 "/home/jens/Source/shotwell/src/Photo.vala"
	filepath = _tmp0_;
#line 1892 "/home/jens/Source/shotwell/src/Photo.vala"
	altered = FALSE;
#line 1893 "/home/jens/Source/shotwell/src/Photo.vala"
	is_baseline = FALSE;
#line 1894 "/home/jens/Source/shotwell/src/Photo.vala"
	is_source = FALSE;
#line 1895 "/home/jens/Source/shotwell/src/Photo.vala"
	old_file = NULL;
#line 15449 "Photo.c"
	{
		{
			PhotoRow* _tmp1_;
#line 1897 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 1897 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 15457 "Photo.c"
			{
				{
					PhotoBackingReaders* _tmp2_;
#line 1898 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp2_ = self->priv->readers;
#line 1898 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_lock (&self->priv->__lock_readers);
#line 15465 "Photo.c"
					{
						GFile* _tmp3_ = NULL;
						PhotoBackingReaders* _tmp4_;
						PhotoFileReader* _tmp5_;
						GFile* _tmp9_;
						gboolean _tmp10_ = FALSE;
						GFile* _tmp11_;
#line 1899 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp4_ = self->priv->readers;
#line 1899 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp5_ = _tmp4_->editable;
#line 1899 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp5_ != NULL) {
#line 15479 "Photo.c"
							PhotoBackingReaders* _tmp6_;
							PhotoFileReader* _tmp7_;
							GFile* _tmp8_;
#line 1899 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp6_ = self->priv->readers;
#line 1899 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp7_ = _tmp6_->editable;
#line 1899 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp8_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1899 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_object_unref0 (_tmp3_);
#line 1899 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp3_ = _tmp8_;
#line 15493 "Photo.c"
						} else {
#line 1899 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_object_unref0 (_tmp3_);
#line 1899 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp3_ = NULL;
#line 15499 "Photo.c"
						}
#line 1899 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp9_ = _g_object_ref0 (_tmp3_);
#line 1899 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (old_file);
#line 1899 "/home/jens/Source/shotwell/src/Photo.vala"
						old_file = _tmp9_;
#line 1900 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp11_ = old_file;
#line 1900 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp11_ != NULL) {
#line 15511 "Photo.c"
							GFile* _tmp12_;
#line 1900 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp12_ = old_file;
#line 1900 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp10_ = !g_file_equal (_tmp12_, file);
#line 15517 "Photo.c"
						} else {
#line 1900 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp10_ = FALSE;
#line 15521 "Photo.c"
						}
#line 1900 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp10_) {
#line 15525 "Photo.c"
							BackingPhotoTable* _tmp13_;
							BackingPhotoTable* _tmp14_;
							PhotoRow* _tmp15_;
							BackingPhotoID _tmp16_;
							const gchar* _tmp17_;
							BackingPhotoRow* _tmp18_;
							const gchar* _tmp19_;
							gchar* _tmp20_;
							PhotoBackingReaders* _tmp21_;
							BackingPhotoRow* _tmp22_;
							PhotoFileFormat _tmp23_;
							const gchar* _tmp24_;
							PhotoFileReader* _tmp25_;
#line 1901 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp13_ = backing_photo_table_get_instance ();
#line 1901 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp14_ = _tmp13_;
#line 1901 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp15_ = self->row;
#line 1901 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp16_ = _tmp15_->editable_id;
#line 1901 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp17_ = filepath;
#line 1901 "/home/jens/Source/shotwell/src/Photo.vala"
							backing_photo_table_set_filepath (_tmp14_, &_tmp16_, _tmp17_, &_inner_error_);
#line 1901 "/home/jens/Source/shotwell/src/Photo.vala"
							_database_table_unref0 (_tmp14_);
#line 1901 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1901 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_object_unref0 (_tmp3_);
#line 15557 "Photo.c"
								goto __finally329;
							}
#line 1903 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp18_ = self->priv->editable;
#line 1903 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp19_ = filepath;
#line 1903 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp20_ = g_strdup (_tmp19_);
#line 1903 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_free0 (_tmp18_->filepath);
#line 1903 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp18_->filepath = _tmp20_;
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp21_ = self->priv->readers;
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp22_ = self->priv->editable;
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp23_ = _tmp22_->file_format;
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp24_ = filepath;
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp25_ = photo_file_format_create_reader (_tmp23_, _tmp24_);
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_file_adapter_unref0 (_tmp21_->editable);
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp21_->editable = _tmp25_;
#line 1906 "/home/jens/Source/shotwell/src/Photo.vala"
							altered = TRUE;
#line 1907 "/home/jens/Source/shotwell/src/Photo.vala"
							is_baseline = photo_is_editable_baseline (self);
#line 1908 "/home/jens/Source/shotwell/src/Photo.vala"
							is_source = photo_is_editable_source (self);
#line 15590 "Photo.c"
						}
#line 1898 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_tmp3_);
#line 15594 "Photo.c"
					}
					__finally329:
					{
						PhotoBackingReaders* _tmp26_;
#line 1898 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp26_ = self->priv->readers;
#line 1898 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 15603 "Photo.c"
					}
#line 1898 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 15607 "Photo.c"
						goto __finally328;
					}
				}
			}
			__finally328:
			{
				PhotoRow* _tmp27_;
#line 1897 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = self->row;
#line 1897 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15619 "Photo.c"
			}
#line 1897 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1897 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 15625 "Photo.c"
					goto __catch327_database_error;
				}
#line 1897 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (old_file);
#line 1897 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (filepath);
#line 1897 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1897 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1897 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 15638 "Photo.c"
			}
		}
	}
	goto __finally327;
	__catch327_database_error:
	{
		GError* err = NULL;
		GError* _tmp28_;
#line 1896 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1896 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1913 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp28_ = err;
#line 1913 "/home/jens/Source/shotwell/src/Photo.vala"
		app_window_database_error (_tmp28_);
#line 1896 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 15657 "Photo.c"
	}
	__finally327:
#line 1896 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1896 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (old_file);
#line 1896 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (filepath);
#line 1896 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1896 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1896 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 15672 "Photo.c"
	}
#line 1916 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp29_ = altered;
#line 1916 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp29_) {
#line 15678 "Photo.c"
		GFile* _tmp30_;
		gboolean _tmp31_;
		gchar** alteration_list = NULL;
		gchar** _tmp32_;
		gint alteration_list_length1;
		gint _alteration_list_size_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		gchar* _tmp34_;
		gboolean _tmp35_;
		gboolean _tmp38_;
		gchar** _tmp41_;
		gint _tmp41__length1;
		Alteration* _tmp42_;
		Alteration* _tmp43_;
#line 1917 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = old_file;
#line 1917 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_editable_replaced (self, _tmp30_, file);
#line 1919 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp31_ = is_baseline;
#line 1919 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp31_) {
#line 1920 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_notify_baseline_replaced (self);
#line 15704 "Photo.c"
		}
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp32_ = g_new0 (gchar*, 0 + 1);
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list = _tmp32_;
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list_length1 = 0;
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_list_size_ = alteration_list_length1;
#line 1923 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp33_ = alteration_list;
#line 1923 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp33__length1 = alteration_list_length1;
#line 1923 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp34_ = g_strdup ("backing:editable");
#line 1923 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add103 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp34_);
#line 1925 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = is_baseline;
#line 1925 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp35_) {
#line 15726 "Photo.c"
			gchar** _tmp36_;
			gint _tmp36__length1;
			gchar* _tmp37_;
#line 1926 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp36_ = alteration_list;
#line 1926 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp36__length1 = alteration_list_length1;
#line 1926 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp37_ = g_strdup ("backing:baseline");
#line 1926 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add104 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp37_);
#line 15738 "Photo.c"
		}
#line 1928 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp38_ = is_source;
#line 1928 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp38_) {
#line 15744 "Photo.c"
			gchar** _tmp39_;
			gint _tmp39__length1;
			gchar* _tmp40_;
#line 1929 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp39_ = alteration_list;
#line 1929 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp39__length1 = alteration_list_length1;
#line 1929 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp40_ = g_strdup ("backing:source");
#line 1929 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add105 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp40_);
#line 15756 "Photo.c"
		}
#line 1931 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41_ = alteration_list;
#line 1931 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41__length1 = alteration_list_length1;
#line 1931 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp42_ = alteration_new_from_array (_tmp41_, _tmp41__length1);
#line 1931 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp43_ = _tmp42_;
#line 1931 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp43_);
#line 1931 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp43_);
#line 1916 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list = (_vala_array_free (alteration_list, alteration_list_length1, (GDestroyNotify) g_free), NULL);
#line 15772 "Photo.c"
	}
#line 1889 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (old_file);
#line 1889 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (filepath);
#line 15778 "Photo.c"
}


void
photo_set_many_editable_file (GeeMap* map,
                              GError** error)
{
	GeeMapIterator* map_iter = NULL;
	GeeMapIterator* _tmp0_;
	GError * _inner_error_ = NULL;
#line 1936 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 1937 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_begin_transaction ();
#line 1939 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = gee_map_map_iterator (map);
#line 1939 "/home/jens/Source/shotwell/src/Photo.vala"
	map_iter = _tmp0_;
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
	while (TRUE) {
#line 15799 "Photo.c"
		GeeMapIterator* _tmp1_;
		GeeMapIterator* _tmp2_;
		gpointer _tmp3_;
		Photo* _tmp4_;
		GeeMapIterator* _tmp5_;
		gpointer _tmp6_;
		GFile* _tmp7_;
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = map_iter;
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
		if (!gee_map_iterator_next (_tmp1_)) {
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 15813 "Photo.c"
		}
#line 1941 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = map_iter;
#line 1941 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = gee_map_iterator_get_key (_tmp2_);
#line 1941 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = (Photo*) _tmp3_;
#line 1941 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = map_iter;
#line 1941 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = gee_map_iterator_get_value (_tmp5_);
#line 1941 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = (GFile*) _tmp6_;
#line 1941 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_set_editable_file (_tmp4_, _tmp7_);
#line 1941 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp7_);
#line 1941 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp4_);
#line 15833 "Photo.c"
	}
#line 1943 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_commit_transaction (&_inner_error_);
#line 1943 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1943 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1943 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 1943 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (map_iter);
#line 1943 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 15847 "Photo.c"
		} else {
#line 1943 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (map_iter);
#line 1943 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1943 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1943 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 15857 "Photo.c"
		}
	}
#line 1936 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (map_iter);
#line 15862 "Photo.c"
}


GFile*
photo_get_actual_file (Photo* self)
{
	GFile* result = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_baseline_reader (self);
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15890 "Photo.c"
}


static GFile*
photo_real_get_master_file (MediaSource* base)
{
	Photo * self;
	GFile* result = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
#line 1952 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1953 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_reader (self);
#line 1953 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1953 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1953 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1953 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1953 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 1953 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15919 "Photo.c"
}


GFile*
photo_get_editable_file (Photo* self)
{
	GFile* result = NULL;
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_;
	GFile* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_;
#line 1956 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1957 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_reader (self);
#line 1957 "/home/jens/Source/shotwell/src/Photo.vala"
	reader = _tmp0_;
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = reader;
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_ != NULL) {
#line 15941 "Photo.c"
		PhotoFileReader* _tmp3_;
		GFile* _tmp4_;
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = reader;
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp4_;
#line 15952 "Photo.c"
	} else {
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = NULL;
#line 15958 "Photo.c"
	}
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp1_;
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (reader);
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15966 "Photo.c"
}


GeeCollection*
photo_get_raw_developer_files (Photo* self)
{
	GeeCollection* result = NULL;
	GeeArrayList* ret = NULL;
	GeeArrayList* _tmp0_;
	GError * _inner_error_ = NULL;
#line 1962 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1963 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_get_master_file_format (self) != PHOTO_FILE_FORMAT_RAW) {
#line 1964 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 1964 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 15985 "Photo.c"
	}
#line 1966 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 1966 "/home/jens/Source/shotwell/src/Photo.vala"
	ret = _tmp0_;
#line 15991 "Photo.c"
	{
		PhotoRow* _tmp1_;
#line 1967 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = self->row;
#line 1967 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15998 "Photo.c"
		{
			{
				GeeIterator* _row_it = NULL;
				GeeHashMap* _tmp2_;
				GeeCollection* _tmp3_;
				GeeCollection* _tmp4_;
				GeeCollection* _tmp5_;
				GeeIterator* _tmp6_;
				GeeIterator* _tmp7_;
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp2_ = self->priv->developments;
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_;
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_;
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_;
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp5_);
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
				_row_it = _tmp7_;
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
				while (TRUE) {
#line 16026 "Photo.c"
					GeeIterator* _tmp8_;
					BackingPhotoRow* row = NULL;
					GeeIterator* _tmp9_;
					gpointer _tmp10_;
					GeeArrayList* _tmp11_;
					BackingPhotoRow* _tmp12_;
					const gchar* _tmp13_;
					GFile* _tmp14_;
					GFile* _tmp15_;
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = _row_it;
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
					if (!gee_iterator_next (_tmp8_)) {
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
						break;
#line 16042 "Photo.c"
					}
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp9_ = _row_it;
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp10_ = gee_iterator_get (_tmp9_);
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
					row = (BackingPhotoRow*) _tmp10_;
#line 1969 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = ret;
#line 1969 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = row;
#line 1969 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_ = _tmp12_->filepath;
#line 1969 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = g_file_new_for_path (_tmp13_);
#line 1969 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = _tmp14_;
#line 1969 "/home/jens/Source/shotwell/src/Photo.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp15_);
#line 1969 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_tmp15_);
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (row);
#line 16066 "Photo.c"
				}
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_row_it);
#line 16070 "Photo.c"
			}
		}
		__finally330:
		{
			PhotoRow* _tmp16_;
#line 1967 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = self->row;
#line 1967 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16080 "Photo.c"
		}
#line 1967 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1967 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (ret);
#line 1967 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1967 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1967 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 16092 "Photo.c"
		}
	}
#line 1972 "/home/jens/Source/shotwell/src/Photo.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (ret, GEE_TYPE_COLLECTION, GeeCollection);
#line 1972 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16099 "Photo.c"
}


GFile*
photo_get_source_file (Photo* self)
{
	GFile* result = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
#line 1975 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1976 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 1976 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1976 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1976 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1976 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1976 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 1976 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16127 "Photo.c"
}


PhotoFileFormat
photo_get_file_format (Photo* self)
{
	PhotoFileFormat result = 0;
	GError * _inner_error_ = NULL;
#line 1979 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 16138 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 1980 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1980 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16145 "Photo.c"
		{
			BackingPhotoRow* _tmp1_;
			PhotoFileFormat _tmp2_;
#line 1981 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 1981 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->file_format;
#line 1981 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 16155 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 1980 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 1980 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16162 "Photo.c"
			}
#line 1981 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 16166 "Photo.c"
		}
		__finally331:
		{
			PhotoRow* _tmp4_;
#line 1980 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 1980 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16175 "Photo.c"
		}
#line 1980 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1980 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1980 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 16183 "Photo.c"
	}
}


PhotoFileFormat
photo_get_best_export_file_format (Photo* self)
{
	PhotoFileFormat result = 0;
	PhotoFileFormat file_format = 0;
	PhotoFileFormat _tmp0_;
#line 1985 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 1986 "/home/jens/Source/shotwell/src/Photo.vala"
	file_format = photo_get_file_format (self);
#line 1987 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = file_format;
#line 1987 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!photo_file_format_can_write (_tmp0_)) {
#line 1988 "/home/jens/Source/shotwell/src/Photo.vala"
		file_format = photo_file_format_get_system_default_format ();
#line 16204 "Photo.c"
	}
#line 1990 "/home/jens/Source/shotwell/src/Photo.vala"
	result = file_format;
#line 1990 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16210 "Photo.c"
}


PhotoFileFormat
photo_get_master_file_format (Photo* self)
{
	PhotoFileFormat result = 0;
	GError * _inner_error_ = NULL;
#line 1993 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 16221 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 1994 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1994 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16228 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
#line 1995 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1995 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 1995 "/home/jens/Source/shotwell/src/Photo.vala"
			result = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 16238 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 1994 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 1994 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16245 "Photo.c"
			}
#line 1995 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 16249 "Photo.c"
		}
		__finally332:
		{
			PhotoRow* _tmp4_;
#line 1994 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 1994 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16258 "Photo.c"
		}
#line 1994 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1994 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1994 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 16266 "Photo.c"
	}
}


static time_t
photo_real_get_timestamp (MediaSource* base)
{
	Photo * self;
	time_t result = 0;
	GError * _inner_error_ = NULL;
#line 1999 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 16279 "Photo.c"
	{
		PhotoRow* _tmp0_;
		time_t _tmp5_ = 0;
#line 2000 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2000 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16287 "Photo.c"
		{
			BackingPhotoRow* _tmp1_;
			time_t _tmp2_;
#line 2001 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 2001 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->timestamp;
#line 2001 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 16297 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 2000 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2000 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16304 "Photo.c"
			}
#line 2001 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 16308 "Photo.c"
		}
		__finally333:
		{
			PhotoRow* _tmp4_;
#line 2000 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2000 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16317 "Photo.c"
		}
#line 2000 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2000 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2000 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 16325 "Photo.c"
	}
}


void
photo_get_photo_id (Photo* self,
                    PhotoID* result)
{
	GError * _inner_error_ = NULL;
#line 2005 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 16337 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2006 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2006 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16344 "Photo.c"
		{
			PhotoRow* _tmp1_;
			PhotoID _tmp2_;
#line 2007 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2007 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->photo_id;
#line 2007 "/home/jens/Source/shotwell/src/Photo.vala"
			*result = _tmp2_;
#line 16354 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 2006 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2006 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16361 "Photo.c"
			}
#line 2007 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 16365 "Photo.c"
		}
		__finally334:
		{
			PhotoRow* _tmp4_;
#line 2006 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2006 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16374 "Photo.c"
		}
#line 2006 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2006 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2006 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 16382 "Photo.c"
	}
}


static inline void
photo_real_get_event_id (MediaSource* base,
                         EventID* result)
{
	Photo * self;
	PhotoRow* _tmp0_;
	EventID _tmp1_;
#line 2012 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2013 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->row;
#line 2013 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->event_id;
#line 2013 "/home/jens/Source/shotwell/src/Photo.vala"
	*result = _tmp1_;
#line 2013 "/home/jens/Source/shotwell/src/Photo.vala"
	return;
#line 16404 "Photo.c"
}


inline gint64
photo_get_raw_event_id (Photo* self)
{
	gint64 result = 0LL;
	PhotoRow* _tmp0_;
	EventID _tmp1_;
	gint64 _tmp2_;
#line 2017 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0LL);
#line 2018 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->row;
#line 2018 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->event_id;
#line 2018 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp1_.id;
#line 2018 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp2_;
#line 2018 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16427 "Photo.c"
}


static void
photo_real_get_import_id (MediaSource* base,
                          ImportID* result)
{
	Photo * self;
	GError * _inner_error_ = NULL;
#line 2021 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 16439 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2022 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2022 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16446 "Photo.c"
		{
			PhotoRow* _tmp1_;
			ImportID _tmp2_;
#line 2023 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2023 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->import_id;
#line 2023 "/home/jens/Source/shotwell/src/Photo.vala"
			*result = _tmp2_;
#line 16456 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 2022 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2022 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16463 "Photo.c"
			}
#line 2023 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 16467 "Photo.c"
		}
		__finally335:
		{
			PhotoRow* _tmp4_;
#line 2022 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2022 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16476 "Photo.c"
		}
#line 2022 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2022 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2022 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 16484 "Photo.c"
	}
}


void
photo_get_editable_id (Photo* self,
                       BackingPhotoID* result)
{
	GError * _inner_error_ = NULL;
#line 2027 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 16496 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2028 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2028 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16503 "Photo.c"
		{
			PhotoRow* _tmp1_;
			BackingPhotoID _tmp2_;
#line 2029 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2029 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable_id;
#line 2029 "/home/jens/Source/shotwell/src/Photo.vala"
			*result = _tmp2_;
#line 16513 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 2028 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2028 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16520 "Photo.c"
			}
#line 2029 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 16524 "Photo.c"
		}
		__finally336:
		{
			PhotoRow* _tmp4_;
#line 2028 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2028 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16533 "Photo.c"
		}
#line 2028 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2028 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2028 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 16541 "Photo.c"
	}
}


static gchar*
photo_real_get_master_md5 (MediaSource* base)
{
	Photo * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 2033 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 16554 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2034 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2034 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16561 "Photo.c"
		{
			PhotoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
#line 2035 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2035 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->md5;
#line 2035 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 2035 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 16574 "Photo.c"
			{
				PhotoRow* _tmp4_;
#line 2034 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2034 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16581 "Photo.c"
			}
#line 2035 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 16585 "Photo.c"
		}
		__finally337:
		{
			PhotoRow* _tmp5_;
#line 2034 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2034 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16594 "Photo.c"
		}
#line 2034 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2034 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2034 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 16602 "Photo.c"
	}
}


guint64
photo_get_flags (Photo* self)
{
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 2041 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 16614 "Photo.c"
	{
		PhotoRow* _tmp0_;
		guint64 _tmp5_ = 0ULL;
#line 2042 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2042 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16622 "Photo.c"
		{
			PhotoRow* _tmp1_;
			guint64 _tmp2_;
#line 2043 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2043 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2043 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 16632 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 2042 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2042 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16639 "Photo.c"
			}
#line 2043 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 16643 "Photo.c"
		}
		__finally338:
		{
			PhotoRow* _tmp4_;
#line 2042 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2042 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16652 "Photo.c"
		}
#line 2042 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2042 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2042 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 16660 "Photo.c"
	}
}


static void
photo_notify_flags_altered (Photo* self,
                            Alteration* additional_alteration)
{
	Alteration* alteration = NULL;
	Alteration* _tmp0_;
	Alteration* _tmp3_;
#line 2047 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2047 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration));
#line 2048 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = alteration_new ("metadata", "flags");
#line 2048 "/home/jens/Source/shotwell/src/Photo.vala"
	alteration = _tmp0_;
#line 2049 "/home/jens/Source/shotwell/src/Photo.vala"
	if (additional_alteration != NULL) {
#line 16682 "Photo.c"
		Alteration* _tmp1_;
		Alteration* _tmp2_;
#line 2050 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = alteration;
#line 2050 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = alteration_compress (_tmp1_, additional_alteration);
#line 2050 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (alteration);
#line 2050 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration = _tmp2_;
#line 16693 "Photo.c"
	}
#line 2052 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = alteration;
#line 2052 "/home/jens/Source/shotwell/src/Photo.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp3_);
#line 2047 "/home/jens/Source/shotwell/src/Photo.vala"
	_alteration_unref0 (alteration);
#line 16701 "Photo.c"
}


guint64
photo_replace_flags (Photo* self,
                     guint64 flags,
                     Alteration* additional_alteration)
{
	guint64 result = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
#line 2055 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2055 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 16718 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2057 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2057 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16725 "Photo.c"
		{
			PhotoTable* _tmp1_;
			PhotoTable* _tmp2_;
			PhotoID _tmp3_ = {0};
			gboolean _tmp4_;
#line 2058 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_table_get_instance ();
#line 2058 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_;
#line 2058 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_get_photo_id (self, &_tmp3_);
#line 2058 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = photo_table_replace_flags (_tmp2_, &_tmp3_, flags);
#line 2058 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp2_);
#line 2059 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = committed;
#line 2059 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp4_) {
#line 16745 "Photo.c"
				PhotoRow* _tmp5_;
#line 2060 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = self->row;
#line 2060 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_->flags = flags;
#line 16751 "Photo.c"
			}
		}
		__finally339:
		{
			PhotoRow* _tmp6_;
#line 2057 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 2057 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16761 "Photo.c"
		}
#line 2057 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 16765 "Photo.c"
			guint64 _tmp7_ = 0ULL;
#line 2057 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2057 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2057 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp7_;
#line 16773 "Photo.c"
		}
	}
#line 2063 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = committed;
#line 2063 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp8_) {
#line 2064 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, additional_alteration);
#line 16782 "Photo.c"
	}
#line 2066 "/home/jens/Source/shotwell/src/Photo.vala"
	result = flags;
#line 2066 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16788 "Photo.c"
}


gboolean
photo_is_flag_set (Photo* self,
                   guint64 mask)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2069 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 16800 "Photo.c"
	{
		PhotoRow* _tmp0_;
		gboolean _tmp5_ = FALSE;
#line 2070 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2070 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16808 "Photo.c"
		{
			PhotoRow* _tmp1_;
			guint64 _tmp2_;
#line 2071 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2071 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2071 "/home/jens/Source/shotwell/src/Photo.vala"
			result = media_source_internal_is_flag_set (_tmp2_, mask);
#line 16818 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 2070 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2070 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16825 "Photo.c"
			}
#line 2071 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 16829 "Photo.c"
		}
		__finally340:
		{
			PhotoRow* _tmp4_;
#line 2070 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2070 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16838 "Photo.c"
		}
#line 2070 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2070 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2070 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 16846 "Photo.c"
	}
}


guint64
photo_add_flags (Photo* self,
                 guint64 mask,
                 Alteration* additional_alteration)
{
	guint64 result = 0ULL;
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp15_;
	GError * _inner_error_ = NULL;
#line 2075 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2075 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 2076 "/home/jens/Source/shotwell/src/Photo.vala"
	flags = (guint64) 0;
#line 2078 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 16869 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16876 "Photo.c"
		{
			PhotoRow* _tmp1_;
			guint64 _tmp2_;
			PhotoRow* _tmp3_;
			guint64 _tmp4_;
			guint64 _tmp5_;
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
			flags = media_source_internal_add_flags (_tmp2_, mask);
#line 2081 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2081 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->flags;
#line 2081 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = flags;
#line 2081 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp4_ != _tmp5_) {
#line 16897 "Photo.c"
				PhotoTable* _tmp6_;
				PhotoTable* _tmp7_;
				PhotoID _tmp8_ = {0};
				guint64 _tmp9_;
				gboolean _tmp10_;
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = photo_table_get_instance ();
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_;
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp8_);
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = flags;
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = photo_table_replace_flags (_tmp7_, &_tmp8_, _tmp9_);
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp7_);
#line 2083 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = committed;
#line 2083 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp10_) {
#line 16919 "Photo.c"
					PhotoRow* _tmp11_;
					guint64 _tmp12_;
#line 2084 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = self->row;
#line 2084 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = flags;
#line 2084 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_->flags = _tmp12_;
#line 16928 "Photo.c"
				}
			}
		}
		__finally341:
		{
			PhotoRow* _tmp13_;
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->row;
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16939 "Photo.c"
		}
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 16943 "Photo.c"
			guint64 _tmp14_ = 0ULL;
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp14_;
#line 16951 "Photo.c"
		}
	}
#line 2088 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = committed;
#line 2088 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp15_) {
#line 2089 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, additional_alteration);
#line 16960 "Photo.c"
	}
#line 2091 "/home/jens/Source/shotwell/src/Photo.vala"
	result = flags;
#line 2091 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16966 "Photo.c"
}


guint64
photo_remove_flags (Photo* self,
                    guint64 mask,
                    Alteration* additional_alteration)
{
	guint64 result = 0ULL;
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp15_;
	GError * _inner_error_ = NULL;
#line 2094 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2094 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 2095 "/home/jens/Source/shotwell/src/Photo.vala"
	flags = (guint64) 0;
#line 2097 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 16988 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16995 "Photo.c"
		{
			PhotoRow* _tmp1_;
			guint64 _tmp2_;
			PhotoRow* _tmp3_;
			guint64 _tmp4_;
			guint64 _tmp5_;
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
			flags = media_source_internal_remove_flags (_tmp2_, mask);
#line 2100 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2100 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->flags;
#line 2100 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = flags;
#line 2100 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp4_ != _tmp5_) {
#line 17016 "Photo.c"
				PhotoTable* _tmp6_;
				PhotoTable* _tmp7_;
				PhotoID _tmp8_ = {0};
				guint64 _tmp9_;
				gboolean _tmp10_;
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = photo_table_get_instance ();
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_;
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp8_);
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = flags;
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = photo_table_replace_flags (_tmp7_, &_tmp8_, _tmp9_);
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp7_);
#line 2102 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = committed;
#line 2102 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp10_) {
#line 17038 "Photo.c"
					PhotoRow* _tmp11_;
					guint64 _tmp12_;
#line 2103 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = self->row;
#line 2103 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = flags;
#line 2103 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_->flags = _tmp12_;
#line 17047 "Photo.c"
				}
			}
		}
		__finally342:
		{
			PhotoRow* _tmp13_;
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->row;
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17058 "Photo.c"
		}
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 17062 "Photo.c"
			guint64 _tmp14_ = 0ULL;
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp14_;
#line 17070 "Photo.c"
		}
	}
#line 2107 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = committed;
#line 2107 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp15_) {
#line 2108 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, additional_alteration);
#line 17079 "Photo.c"
	}
#line 2110 "/home/jens/Source/shotwell/src/Photo.vala"
	result = flags;
#line 2110 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 17085 "Photo.c"
}


guint64
photo_add_remove_flags (Photo* self,
                        guint64 add,
                        guint64 remove,
                        Alteration* additional_alteration)
{
	guint64 result = 0ULL;
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp15_;
	GError * _inner_error_ = NULL;
#line 2113 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2113 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 2114 "/home/jens/Source/shotwell/src/Photo.vala"
	flags = (guint64) 0;
#line 2116 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 17108 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17115 "Photo.c"
		{
			PhotoRow* _tmp1_;
			guint64 _tmp2_;
			PhotoRow* _tmp3_;
			guint64 _tmp4_;
			guint64 _tmp5_;
#line 2118 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2118 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2118 "/home/jens/Source/shotwell/src/Photo.vala"
			flags = (_tmp2_ | add) & (~remove);
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->flags;
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = flags;
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp4_ != _tmp5_) {
#line 17136 "Photo.c"
				PhotoTable* _tmp6_;
				PhotoTable* _tmp7_;
				PhotoID _tmp8_ = {0};
				guint64 _tmp9_;
				gboolean _tmp10_;
#line 2120 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = photo_table_get_instance ();
#line 2120 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_;
#line 2120 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp8_);
#line 2120 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = flags;
#line 2120 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = photo_table_replace_flags (_tmp7_, &_tmp8_, _tmp9_);
#line 2120 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp7_);
#line 2121 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = committed;
#line 2121 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp10_) {
#line 17158 "Photo.c"
					PhotoRow* _tmp11_;
					guint64 _tmp12_;
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = self->row;
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = flags;
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_->flags = _tmp12_;
#line 17167 "Photo.c"
				}
			}
		}
		__finally343:
		{
			PhotoRow* _tmp13_;
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->row;
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17178 "Photo.c"
		}
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 17182 "Photo.c"
			guint64 _tmp14_ = 0ULL;
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp14_;
#line 17190 "Photo.c"
		}
	}
#line 2126 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = committed;
#line 2126 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp15_) {
#line 2127 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, additional_alteration);
#line 17199 "Photo.c"
	}
#line 2129 "/home/jens/Source/shotwell/src/Photo.vala"
	result = flags;
#line 2129 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 17205 "Photo.c"
}


void
photo_add_remove_many_flags (GeeCollection* add,
                             guint64 add_mask,
                             Alteration* additional_add_alteration,
                             GeeCollection* remove,
                             guint64 remove_mask,
                             Alteration* additional_remove_alteration,
                             GError** error)
{
	GError * _inner_error_ = NULL;
#line 2132 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((add == NULL) || GEE_IS_COLLECTION (add));
#line 2132 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((additional_add_alteration == NULL) || IS_ALTERATION (additional_add_alteration));
#line 2132 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((remove == NULL) || GEE_IS_COLLECTION (remove));
#line 2132 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((additional_remove_alteration == NULL) || IS_ALTERATION (additional_remove_alteration));
#line 2135 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_begin_transaction ();
#line 2137 "/home/jens/Source/shotwell/src/Photo.vala"
	if (add != NULL) {
#line 17231 "Photo.c"
		{
			GeeIterator* _photo_it = NULL;
			GeeIterator* _tmp0_;
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (add, GEE_TYPE_ITERABLE, GeeIterable));
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_it = _tmp0_;
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
			while (TRUE) {
#line 17241 "Photo.c"
				GeeIterator* _tmp1_;
				Photo* photo = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				Photo* _tmp4_;
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _photo_it;
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!gee_iterator_next (_tmp1_)) {
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
					break;
#line 17253 "Photo.c"
				}
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp2_ = _photo_it;
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = gee_iterator_get (_tmp2_);
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
				photo = (Photo*) _tmp3_;
#line 2139 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = photo;
#line 2139 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_add_flags (_tmp4_, add_mask, additional_add_alteration);
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (photo);
#line 17267 "Photo.c"
			}
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_photo_it);
#line 17271 "Photo.c"
		}
	}
#line 2142 "/home/jens/Source/shotwell/src/Photo.vala"
	if (remove != NULL) {
#line 17276 "Photo.c"
		{
			GeeIterator* _photo_it = NULL;
			GeeIterator* _tmp5_;
#line 2143 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (remove, GEE_TYPE_ITERABLE, GeeIterable));
#line 2143 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_it = _tmp5_;
#line 2143 "/home/jens/Source/shotwell/src/Photo.vala"
			while (TRUE) {
#line 17286 "Photo.c"
				GeeIterator* _tmp6_;
				Photo* photo = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				Photo* _tmp9_;
#line 2143 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = _photo_it;
#line 2143 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!gee_iterator_next (_tmp6_)) {
#line 2143 "/home/jens/Source/shotwell/src/Photo.vala"
					break;
#line 17298 "Photo.c"
				}
#line 2143 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _photo_it;
#line 2143 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = gee_iterator_get (_tmp7_);
#line 2143 "/home/jens/Source/shotwell/src/Photo.vala"
				photo = (Photo*) _tmp8_;
#line 2144 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = photo;
#line 2144 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_remove_flags (_tmp9_, remove_mask, additional_remove_alteration);
#line 2143 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (photo);
#line 17312 "Photo.c"
			}
#line 2143 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_photo_it);
#line 17316 "Photo.c"
		}
	}
#line 2147 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_commit_transaction (&_inner_error_);
#line 2147 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2147 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 2147 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 2147 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17329 "Photo.c"
		} else {
#line 2147 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2147 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2147 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17337 "Photo.c"
		}
	}
}


guint64
photo_toggle_flags (Photo* self,
                    guint64 mask,
                    Alteration* additional_alteration)
{
	guint64 result = 0ULL;
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp15_;
	GError * _inner_error_ = NULL;
#line 2150 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2150 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 2151 "/home/jens/Source/shotwell/src/Photo.vala"
	flags = (guint64) 0;
#line 2153 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 17361 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2154 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2154 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17368 "Photo.c"
		{
			PhotoRow* _tmp1_;
			guint64 _tmp2_;
			PhotoRow* _tmp3_;
			guint64 _tmp4_;
			guint64 _tmp5_;
#line 2155 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2155 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2155 "/home/jens/Source/shotwell/src/Photo.vala"
			flags = _tmp2_ ^ mask;
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->flags;
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = flags;
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp4_ != _tmp5_) {
#line 17389 "Photo.c"
				PhotoTable* _tmp6_;
				PhotoTable* _tmp7_;
				PhotoID _tmp8_ = {0};
				guint64 _tmp9_;
				gboolean _tmp10_;
#line 2157 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = photo_table_get_instance ();
#line 2157 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_;
#line 2157 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp8_);
#line 2157 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = flags;
#line 2157 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = photo_table_replace_flags (_tmp7_, &_tmp8_, _tmp9_);
#line 2157 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp7_);
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = committed;
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp10_) {
#line 17411 "Photo.c"
					PhotoRow* _tmp11_;
					guint64 _tmp12_;
#line 2159 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = self->row;
#line 2159 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = flags;
#line 2159 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_->flags = _tmp12_;
#line 17420 "Photo.c"
				}
			}
		}
		__finally344:
		{
			PhotoRow* _tmp13_;
#line 2154 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->row;
#line 2154 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17431 "Photo.c"
		}
#line 2154 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 17435 "Photo.c"
			guint64 _tmp14_ = 0ULL;
#line 2154 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2154 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2154 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp14_;
#line 17443 "Photo.c"
		}
	}
#line 2163 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = committed;
#line 2163 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp15_) {
#line 2164 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, additional_alteration);
#line 17452 "Photo.c"
	}
#line 2166 "/home/jens/Source/shotwell/src/Photo.vala"
	result = flags;
#line 2166 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 17458 "Photo.c"
}


gboolean
photo_is_master_metadata_dirty (Photo* self)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2169 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 17469 "Photo.c"
	{
		PhotoRow* _tmp0_;
		gboolean _tmp5_ = FALSE;
#line 2170 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2170 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17477 "Photo.c"
		{
			PhotoRow* _tmp1_;
			gboolean _tmp2_;
#line 2171 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2171 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->metadata_dirty;
#line 2171 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 17487 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 2170 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2170 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17494 "Photo.c"
			}
#line 2171 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 17498 "Photo.c"
		}
		__finally345:
		{
			PhotoRow* _tmp4_;
#line 2170 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2170 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17507 "Photo.c"
		}
#line 2170 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2170 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2170 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 17515 "Photo.c"
	}
}


void
photo_set_master_metadata_dirty (Photo* self,
                                 gboolean dirty,
                                 GError** error)
{
	gboolean committed = FALSE;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
#line 2175 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2176 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 17532 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17539 "Photo.c"
		{
			PhotoRow* _tmp1_;
			gboolean _tmp2_;
#line 2178 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2178 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->metadata_dirty;
#line 2178 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != dirty) {
#line 17549 "Photo.c"
				PhotoTable* _tmp3_;
				PhotoTable* _tmp4_;
				PhotoID _tmp5_ = {0};
				PhotoRow* _tmp6_;
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = photo_table_get_instance ();
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_;
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp5_);
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_set_metadata_dirty (_tmp4_, &_tmp5_, dirty, &_inner_error_);
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp4_);
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 17566 "Photo.c"
					goto __finally346;
				}
#line 2180 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 2180 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_->metadata_dirty = dirty;
#line 2181 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = TRUE;
#line 17575 "Photo.c"
			}
		}
		__finally346:
		{
			PhotoRow* _tmp7_;
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17585 "Photo.c"
		}
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 17595 "Photo.c"
			} else {
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 17603 "Photo.c"
			}
		}
	}
#line 2185 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = committed;
#line 2185 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp8_) {
#line 17611 "Photo.c"
		Alteration* _tmp9_;
		Alteration* _tmp10_;
#line 2186 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = alteration_new ("metadata", "master-dirty");
#line 2186 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _tmp9_;
#line 2186 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp10_);
#line 2186 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp10_);
#line 17622 "Photo.c"
	}
}


static Rating
photo_real_get_rating (MediaSource* base)
{
	Photo * self;
	Rating result = 0;
	GError * _inner_error_ = NULL;
#line 2189 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 17635 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17642 "Photo.c"
		{
			PhotoRow* _tmp1_;
			Rating _tmp2_;
#line 2191 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2191 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->rating;
#line 2191 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 17652 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17659 "Photo.c"
			}
#line 2191 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 17663 "Photo.c"
		}
		__finally347:
		{
			PhotoRow* _tmp4_;
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17672 "Photo.c"
		}
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 17680 "Photo.c"
	}
}


static void
photo_real_set_rating (MediaSource* base,
                       Rating rating)
{
	Photo * self;
	gboolean committed = FALSE;
	gboolean _tmp10_;
	GError * _inner_error_ = NULL;
#line 2195 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2196 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 17697 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17704 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			PhotoRow* _tmp2_;
			Rating _tmp3_;
#line 2199 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 2199 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_->rating;
#line 2199 "/home/jens/Source/shotwell/src/Photo.vala"
			if (rating != _tmp3_) {
#line 2199 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = rating_is_valid (rating);
#line 17717 "Photo.c"
			} else {
#line 2199 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = FALSE;
#line 17721 "Photo.c"
			}
#line 2199 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp1_) {
#line 17725 "Photo.c"
				PhotoTable* _tmp4_;
				PhotoTable* _tmp5_;
				PhotoID _tmp6_ = {0};
				gboolean _tmp7_;
#line 2200 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = photo_table_get_instance ();
#line 2200 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_;
#line 2200 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp6_);
#line 2200 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = photo_table_set_rating (_tmp5_, &_tmp6_, rating);
#line 2200 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp5_);
#line 2201 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = committed;
#line 2201 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp7_) {
#line 17744 "Photo.c"
					PhotoRow* _tmp8_;
#line 2202 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = self->row;
#line 2202 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_->rating = rating;
#line 17750 "Photo.c"
				}
			}
		}
		__finally348:
		{
			PhotoRow* _tmp9_;
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17761 "Photo.c"
		}
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17771 "Photo.c"
		}
	}
#line 2206 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = committed;
#line 2206 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp10_) {
#line 17778 "Photo.c"
		Alteration* _tmp11_;
		Alteration* _tmp12_;
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = alteration_new ("metadata", "rating");
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _tmp11_;
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp12_);
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp12_);
#line 17789 "Photo.c"
	}
}


static void
photo_real_increase_rating (MediaSource* base)
{
	Photo * self;
	GError * _inner_error_ = NULL;
#line 2210 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 17801 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2211 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2211 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17808 "Photo.c"
		{
			PhotoRow* _tmp1_;
			Rating _tmp2_;
#line 2212 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2212 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->rating;
#line 2212 "/home/jens/Source/shotwell/src/Photo.vala"
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), rating_increase (_tmp2_));
#line 17818 "Photo.c"
		}
		__finally349:
		{
			PhotoRow* _tmp3_;
#line 2211 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2211 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17827 "Photo.c"
		}
#line 2211 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2211 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2211 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2211 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17837 "Photo.c"
		}
	}
}


static void
photo_real_decrease_rating (MediaSource* base)
{
	Photo * self;
	GError * _inner_error_ = NULL;
#line 2216 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 17850 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2217 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2217 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17857 "Photo.c"
		{
			PhotoRow* _tmp1_;
			Rating _tmp2_;
#line 2218 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2218 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->rating;
#line 2218 "/home/jens/Source/shotwell/src/Photo.vala"
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), rating_decrease (_tmp2_));
#line 17867 "Photo.c"
		}
		__finally350:
		{
			PhotoRow* _tmp3_;
#line 2217 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2217 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17876 "Photo.c"
		}
#line 2217 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2217 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2217 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2217 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17886 "Photo.c"
		}
	}
}


static void
photo_real_commit_backlinks (DataSource* base,
                             SourceCollection* sources,
                             const gchar* backlinks)
{
	Photo * self;
	GError * _inner_error_ = NULL;
#line 2222 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2222 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((sources == NULL) || IS_SOURCE_COLLECTION (sources));
#line 17903 "Photo.c"
	{
		PhotoTable* _tmp0_;
		PhotoTable* _tmp1_;
		PhotoID _tmp2_ = {0};
#line 2227 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_table_get_instance ();
#line 2227 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp0_;
#line 2227 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_get_photo_id (self, &_tmp2_);
#line 2227 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_table_update_backlinks (_tmp1_, &_tmp2_, backlinks, &_inner_error_);
#line 2227 "/home/jens/Source/shotwell/src/Photo.vala"
		_database_table_unref0 (_tmp1_);
#line 2227 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2227 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 17922 "Photo.c"
				goto __catch351_database_error;
			}
#line 2227 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2227 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2227 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17931 "Photo.c"
		}
		{
			PhotoRow* _tmp3_;
#line 2228 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2228 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 17939 "Photo.c"
			{
				PhotoRow* _tmp4_;
				gchar* _tmp5_;
#line 2229 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2229 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = g_strdup (backlinks);
#line 2229 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp4_->backlinks);
#line 2229 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_->backlinks = _tmp5_;
#line 17951 "Photo.c"
			}
			__finally352:
			{
				PhotoRow* _tmp6_;
#line 2228 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 2228 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17960 "Photo.c"
			}
#line 2228 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2228 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 17966 "Photo.c"
					goto __catch351_database_error;
				}
#line 2228 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2228 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2228 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 17975 "Photo.c"
			}
		}
	}
	goto __finally351;
	__catch351_database_error:
	{
		GError* err = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
#line 2226 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 2226 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = _tmp7_;
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = err;
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _tmp9_->message;
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2232: Unable to update link state for %s: %s", _tmp8_, _tmp10_);
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp8_);
#line 2226 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 18005 "Photo.c"
	}
	__finally351:
#line 2226 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2226 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2226 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2226 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18016 "Photo.c"
	}
}


static gboolean
photo_real_set_event_id (MediaSource* base,
                         EventID* event_id)
{
	Photo * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2240 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2240 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 18032 "Photo.c"
	{
		PhotoRow* _tmp0_;
		gboolean _tmp12_ = FALSE;
#line 2241 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2241 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18040 "Photo.c"
		{
			gboolean committed = FALSE;
			PhotoTable* _tmp1_;
			PhotoTable* _tmp2_;
			PhotoRow* _tmp3_;
			PhotoID _tmp4_;
			EventID _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_table_get_instance ();
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_;
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->photo_id;
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = *event_id;
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = photo_table_set_event (_tmp2_, &_tmp4_, &_tmp5_);
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp2_);
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp6_;
#line 2244 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = committed;
#line 2244 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp7_) {
#line 18070 "Photo.c"
				PhotoRow* _tmp8_;
				EventID _tmp9_;
#line 2245 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = self->row;
#line 2245 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = *event_id;
#line 2245 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_->event_id = _tmp9_;
#line 18079 "Photo.c"
			}
#line 2247 "/home/jens/Source/shotwell/src/Photo.vala"
			result = committed;
#line 18083 "Photo.c"
			{
				PhotoRow* _tmp10_;
#line 2241 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = self->row;
#line 2241 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18090 "Photo.c"
			}
#line 2247 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18094 "Photo.c"
		}
		__finally353:
		{
			PhotoRow* _tmp11_;
#line 2241 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = self->row;
#line 2241 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18103 "Photo.c"
		}
#line 2241 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2241 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2241 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp12_;
#line 18111 "Photo.c"
	}
}


static gchar*
photo_real_to_string (DataObject* base)
{
	Photo * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	PhotoID _tmp9_ = {0};
	gint64 _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	PhotoFileReader* _tmp13_;
	PhotoFileReader* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
#line 2251 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!photo_is_master_baseline (self)) {
#line 18136 "Photo.c"
		GFile* _tmp1_;
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = photo_get_actual_file (self);
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = _tmp1_;
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = g_file_get_path (_tmp2_);
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp3_;
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = g_strconcat (" (", _tmp4_, NULL);
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp5_;
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = g_strconcat (_tmp6_, ")", NULL);
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp0_);
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp7_;
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp6_);
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp4_);
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp2_);
#line 18168 "Photo.c"
	} else {
		gchar* _tmp8_;
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = g_strdup ("");
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp0_);
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp8_;
#line 18177 "Photo.c"
	}
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_photo_id (self, &_tmp9_);
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = _tmp9_.id;
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp10_);
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = _tmp11_;
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = photo_get_master_reader (self);
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = _tmp13_;
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = _tmp15_;
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = g_strdup_printf ("[%s] %s%s", _tmp12_, _tmp16_, _tmp0_);
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = _tmp17_;
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp16_);
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp14_);
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp12_);
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp18_;
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp0_);
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 18211 "Photo.c"
}


static gboolean
photo_real_equals (DataSource* base,
                   DataSource* source)
{
	Photo * self;
	gboolean result = FALSE;
	Photo* photo = NULL;
	Photo* _tmp0_;
	Photo* _tmp1_;
#line 2256 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2256 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((source == NULL) || IS_DATA_SOURCE (source), FALSE);
#line 2258 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (source, TYPE_PHOTO) ? ((Photo*) source) : NULL);
#line 2258 "/home/jens/Source/shotwell/src/Photo.vala"
	photo = _tmp0_;
#line 2259 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo;
#line 2259 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ != NULL) {
#line 18236 "Photo.c"
		PhotoID photo_id = {0};
		PhotoID _tmp2_ = {0};
		PhotoID other_photo_id = {0};
		Photo* _tmp3_;
		PhotoID _tmp4_ = {0};
		gboolean _tmp5_ = FALSE;
		Photo* _tmp6_;
#line 2260 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_get_photo_id (self, &_tmp2_);
#line 2260 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_id = _tmp2_;
#line 2261 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo;
#line 2261 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_get_photo_id (_tmp3_, &_tmp4_);
#line 2261 "/home/jens/Source/shotwell/src/Photo.vala"
		other_photo_id = _tmp4_;
#line 2263 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = photo;
#line 2263 "/home/jens/Source/shotwell/src/Photo.vala"
		if (self != _tmp6_) {
#line 18258 "Photo.c"
			PhotoID _tmp7_;
			gint64 _tmp8_;
#line 2263 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = photo_id;
#line 2263 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_.id;
#line 2263 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _tmp8_ != PHOTO_ID_INVALID;
#line 18267 "Photo.c"
		} else {
#line 2263 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = FALSE;
#line 18271 "Photo.c"
		}
#line 2263 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp5_) {
#line 18275 "Photo.c"
			PhotoID _tmp9_;
			gint64 _tmp10_;
			PhotoID _tmp11_;
			gint64 _tmp12_;
#line 2264 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = photo_id;
#line 2264 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = _tmp9_.id;
#line 2264 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = other_photo_id;
#line 2264 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = _tmp11_.id;
#line 2264 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_assert (_tmp10_ != _tmp12_, "photo_id.id != other_photo_id.id");
#line 18290 "Photo.c"
		}
	}
#line 2268 "/home/jens/Source/shotwell/src/Photo.vala"
	result = DATA_SOURCE_CLASS (photo_parent_class)->equals (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_DATA_SOURCE, DataSource), source);
#line 2268 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (photo);
#line 2268 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 18299 "Photo.c"
}


static void
photo_file_exif_updated (Photo* self)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFileInfo* info = NULL;
	GTimeVal timestamp = {0};
	GFileInfo* _tmp7_;
	GTimeVal _tmp8_ = {0};
	PhotoFileInterrogator* interrogator = NULL;
	PhotoFileInterrogator* _tmp9_;
	DetectedPhotoInformation* detected = NULL;
	DetectedPhotoInformation* _tmp14_;
	gboolean _tmp15_ = FALSE;
	DetectedPhotoInformation* _tmp16_;
	gboolean success = FALSE;
	gboolean _tmp34_;
	GError * _inner_error_ = NULL;
#line 2272 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2273 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 2273 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp0_;
#line 2275 "/home/jens/Source/shotwell/src/Photo.vala"
	info = NULL;
#line 18329 "Photo.c"
	{
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
#line 2277 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = g_file_query_info (file, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 2277 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp2_;
#line 2277 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 18340 "Photo.c"
			goto __catch354_g_error;
		}
#line 2277 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp1_;
#line 2277 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = NULL;
#line 2277 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 2277 "/home/jens/Source/shotwell/src/Photo.vala"
		info = _tmp3_;
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 18353 "Photo.c"
	}
	goto __finally354;
	__catch354_g_error:
	{
		GError* err = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp4_;
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = err->message;
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
		g_error ("Photo.vala:2280: Unable to read file information for %s: %s", _tmp5_, _tmp6_);
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp5_);
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 18378 "Photo.c"
	}
	__finally354:
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18393 "Photo.c"
	}
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = info;
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp7_, &_tmp8_);
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
	timestamp = _tmp8_;
#line 2286 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = photo_file_interrogator_new (file, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL);
#line 2286 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp9_;
#line 18405 "Photo.c"
	{
#line 2288 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_interrogator_interrogate (interrogator, &_inner_error_);
#line 2288 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 18411 "Photo.c"
			goto __catch355_g_error;
		}
	}
	goto __finally355;
	__catch355_g_error:
	{
		GError* err = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
#line 2287 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 2287 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 2290 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = g_file_get_path (file);
#line 2290 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = _tmp10_;
#line 2290 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = err;
#line 2290 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp12_->message;
#line 2290 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2290: Unable to interrogate photo file %s: %s", _tmp11_, _tmp13_);
#line 2290 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp11_);
#line 2287 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 18441 "Photo.c"
	}
	__finally355:
#line 2287 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2287 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 2287 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 2287 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 2287 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2287 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2287 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18458 "Photo.c"
	}
#line 2293 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = photo_file_interrogator_get_detected_photo_information (interrogator);
#line 2293 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp14_;
#line 2294 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = detected;
#line 2294 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp16_ == NULL) {
#line 2294 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = TRUE;
#line 18470 "Photo.c"
	} else {
#line 2294 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = photo_file_interrogator_get_is_photo_corrupted (interrogator);
#line 18474 "Photo.c"
	}
#line 2294 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp15_) {
#line 18478 "Photo.c"
		gchar* _tmp17_;
		gchar* _tmp18_;
#line 2295 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 2295 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = _tmp17_;
#line 2295 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("Photo.vala:2295: file_exif_updated: %s no longer an image", _tmp18_);
#line 2295 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp18_);
#line 2297 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 2297 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 2297 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 2297 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 2297 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18499 "Photo.c"
	}
	{
		PhotoRow* _tmp19_;
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = self->row;
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18507 "Photo.c"
		{
			PhotoTable* _tmp20_;
			PhotoTable* _tmp21_;
			PhotoID _tmp22_ = {0};
			GFileInfo* _tmp23_;
			GTimeVal _tmp24_;
			glong _tmp25_;
			DetectedPhotoInformation* _tmp26_;
			const gchar* _tmp27_;
			DetectedPhotoInformation* _tmp28_;
			const gchar* _tmp29_;
			DetectedPhotoInformation* _tmp30_;
			const gchar* _tmp31_;
			PhotoRow* _tmp32_;
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp20_ = photo_table_get_instance ();
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp21_ = _tmp20_;
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_get_photo_id (self, &_tmp22_);
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp23_ = info;
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp24_ = timestamp;
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp25_ = _tmp24_.tv_sec;
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26_ = detected;
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp27_ = _tmp26_->md5;
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp28_ = detected;
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp29_ = _tmp28_->exif_md5;
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp30_ = detected;
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp31_ = _tmp30_->thumbnail_md5;
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp32_ = self->row;
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			success = photo_table_master_exif_updated (_tmp21_, &_tmp22_, g_file_info_get_size (_tmp23_), _tmp25_, _tmp27_, _tmp29_, _tmp31_, _tmp32_);
#line 2302 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp21_);
#line 18552 "Photo.c"
		}
		__finally356:
		{
			PhotoRow* _tmp33_;
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp33_ = self->row;
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18561 "Photo.c"
		}
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_interrogator_unref0 (interrogator);
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (info);
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 18579 "Photo.c"
		}
	}
#line 2306 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = success;
#line 2306 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp34_) {
#line 18586 "Photo.c"
		Alteration* _tmp35_;
		Alteration* _tmp36_;
#line 2307 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = alteration_new_from_list ("metadata:exif,metadata:md5");
#line 2307 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = _tmp35_;
#line 2307 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp36_);
#line 2307 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp36_);
#line 18597 "Photo.c"
	}
#line 2272 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 2272 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 2272 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (info);
#line 2272 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 18607 "Photo.c"
}


static guint64
photo_real_get_filesize (MediaSource* base)
{
	Photo * self;
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 2312 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 18619 "Photo.c"
	{
		PhotoRow* _tmp0_;
		guint64 _tmp5_ = 0ULL;
#line 2313 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2313 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18627 "Photo.c"
		{
			BackingPhotoRow* _tmp1_;
			gint64 _tmp2_;
#line 2314 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 2314 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->filesize;
#line 2314 "/home/jens/Source/shotwell/src/Photo.vala"
			result = (guint64) _tmp2_;
#line 18637 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 2313 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2313 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18644 "Photo.c"
			}
#line 2314 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18648 "Photo.c"
		}
		__finally357:
		{
			PhotoRow* _tmp4_;
#line 2313 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2313 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18657 "Photo.c"
		}
#line 2313 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2313 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2313 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 18665 "Photo.c"
	}
}


static guint64
photo_real_get_master_filesize (MediaSource* base)
{
	Photo * self;
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 2318 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 18678 "Photo.c"
	{
		PhotoRow* _tmp0_;
		guint64 _tmp6_ = 0ULL;
#line 2319 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2319 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18686 "Photo.c"
		{
			PhotoRow* _tmp1_;
			BackingPhotoRow* _tmp2_;
			gint64 _tmp3_;
#line 2320 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2320 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 2320 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_->filesize;
#line 2320 "/home/jens/Source/shotwell/src/Photo.vala"
			result = (guint64) _tmp3_;
#line 18699 "Photo.c"
			{
				PhotoRow* _tmp4_;
#line 2319 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2319 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18706 "Photo.c"
			}
#line 2320 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18710 "Photo.c"
		}
		__finally358:
		{
			PhotoRow* _tmp5_;
#line 2319 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2319 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18719 "Photo.c"
		}
#line 2319 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2319 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2319 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp6_;
#line 18727 "Photo.c"
	}
}


guint64
photo_get_editable_filesize (Photo* self)
{
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 2324 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 18739 "Photo.c"
	{
		PhotoRow* _tmp0_;
		guint64 _tmp5_ = 0ULL;
#line 2325 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2325 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18747 "Photo.c"
		{
			BackingPhotoRow* _tmp1_;
			gint64 _tmp2_;
#line 2326 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->editable;
#line 2326 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->filesize;
#line 2326 "/home/jens/Source/shotwell/src/Photo.vala"
			result = (guint64) _tmp2_;
#line 18757 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 2325 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2325 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18764 "Photo.c"
			}
#line 2326 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18768 "Photo.c"
		}
		__finally359:
		{
			PhotoRow* _tmp4_;
#line 2325 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2325 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18777 "Photo.c"
		}
#line 2325 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2325 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2325 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 18785 "Photo.c"
	}
}


static time_t
photo_real_get_exposure_time (Dateable* base)
{
	Photo * self;
	time_t result = 0;
	time_t _tmp0_;
#line 2330 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2331 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->priv->cached_exposure_time;
#line 2331 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 2331 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 18804 "Photo.c"
}


static gchar*
photo_real_get_basename (MediaSource* base)
{
	Photo * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 2334 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 18816 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18823 "Photo.c"
		{
			const gchar* _tmp1_;
			gchar* _tmp2_;
#line 2336 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->file_title;
#line 2336 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = g_strdup (_tmp1_);
#line 2336 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 18833 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18840 "Photo.c"
			}
#line 2336 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18844 "Photo.c"
		}
		__finally360:
		{
			PhotoRow* _tmp4_;
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18853 "Photo.c"
		}
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 18861 "Photo.c"
	}
}


static gchar*
photo_real_get_title (MediaSource* base)
{
	Photo * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 2340 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 18874 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18881 "Photo.c"
		{
			PhotoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
#line 2342 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2342 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->title;
#line 2342 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 2342 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 18894 "Photo.c"
			{
				PhotoRow* _tmp4_;
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18901 "Photo.c"
			}
#line 2342 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18905 "Photo.c"
		}
		__finally361:
		{
			PhotoRow* _tmp5_;
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18914 "Photo.c"
		}
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 18922 "Photo.c"
	}
}


static gchar*
photo_real_get_comment (MediaSource* base)
{
	Photo * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 2346 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 18935 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2347 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2347 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18942 "Photo.c"
		{
			PhotoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
#line 2348 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2348 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->comment;
#line 2348 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 2348 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 18955 "Photo.c"
			{
				PhotoRow* _tmp4_;
#line 2347 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2347 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18962 "Photo.c"
			}
#line 2348 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18966 "Photo.c"
		}
		__finally362:
		{
			PhotoRow* _tmp5_;
#line 2347 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2347 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18975 "Photo.c"
		}
#line 2347 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2347 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2347 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 18983 "Photo.c"
	}
}


static void
photo_real_set_title (MediaSource* base,
                      const gchar* title)
{
	Photo * self;
	gchar* new_title = NULL;
	gchar* _tmp0_;
	gboolean committed = FALSE;
	gboolean _tmp16_;
	GError * _inner_error_ = NULL;
#line 2352 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2353 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = media_source_prep_title (title);
#line 2353 "/home/jens/Source/shotwell/src/Photo.vala"
	new_title = _tmp0_;
#line 2355 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 19006 "Photo.c"
	{
		PhotoRow* _tmp1_;
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = self->row;
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 19013 "Photo.c"
		{
			const gchar* _tmp2_;
			PhotoRow* _tmp3_;
			const gchar* _tmp4_;
			PhotoTable* _tmp6_;
			PhotoTable* _tmp7_;
			PhotoRow* _tmp8_;
			PhotoID _tmp9_;
			const gchar* _tmp10_;
			gboolean _tmp11_;
#line 2357 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = new_title;
#line 2357 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2357 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->title;
#line 2357 "/home/jens/Source/shotwell/src/Photo.vala"
			if (g_strcmp0 (_tmp2_, _tmp4_) == 0) {
#line 19032 "Photo.c"
				{
					PhotoRow* _tmp5_;
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp5_ = self->row;
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19039 "Photo.c"
				}
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (new_title);
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 19045 "Photo.c"
			}
#line 2360 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = photo_table_get_instance ();
#line 2360 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _tmp6_;
#line 2360 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = self->row;
#line 2360 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = _tmp8_->photo_id;
#line 2360 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = new_title;
#line 2360 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = photo_table_set_title (_tmp7_, &_tmp9_, _tmp10_);
#line 2360 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp7_);
#line 2361 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = committed;
#line 2361 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp11_) {
#line 19065 "Photo.c"
				PhotoRow* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
#line 2362 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = self->row;
#line 2362 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = new_title;
#line 2362 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 2362 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp12_->title);
#line 2362 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_->title = _tmp14_;
#line 19079 "Photo.c"
			}
		}
		__finally363:
		{
			PhotoRow* _tmp15_;
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = self->row;
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19089 "Photo.c"
		}
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (new_title);
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 19101 "Photo.c"
		}
	}
#line 2365 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = committed;
#line 2365 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp16_) {
#line 19108 "Photo.c"
		Alteration* _tmp17_;
		Alteration* _tmp18_;
#line 2366 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = alteration_new ("metadata", "name");
#line 2366 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = _tmp17_;
#line 2366 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp18_);
#line 2366 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp18_);
#line 19119 "Photo.c"
	}
#line 2352 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (new_title);
#line 19123 "Photo.c"
}


static gboolean
photo_real_set_comment (MediaSource* base,
                        const gchar* comment)
{
	Photo * self;
	gboolean result = FALSE;
	gchar* new_comment = NULL;
	gchar* _tmp0_;
	gboolean committed = FALSE;
	gboolean _tmp17_;
	GError * _inner_error_ = NULL;
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2370 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = media_source_prep_comment (comment);
#line 2370 "/home/jens/Source/shotwell/src/Photo.vala"
	new_comment = _tmp0_;
#line 2372 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 19146 "Photo.c"
	{
		PhotoRow* _tmp1_;
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = self->row;
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 19153 "Photo.c"
		{
			const gchar* _tmp2_;
			PhotoRow* _tmp3_;
			const gchar* _tmp4_;
			PhotoTable* _tmp6_;
			PhotoTable* _tmp7_;
			PhotoRow* _tmp8_;
			PhotoID _tmp9_;
			const gchar* _tmp10_;
			gboolean _tmp11_;
#line 2374 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = new_comment;
#line 2374 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2374 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->comment;
#line 2374 "/home/jens/Source/shotwell/src/Photo.vala"
			if (g_strcmp0 (_tmp2_, _tmp4_) == 0) {
#line 2375 "/home/jens/Source/shotwell/src/Photo.vala"
				result = TRUE;
#line 19174 "Photo.c"
				{
					PhotoRow* _tmp5_;
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp5_ = self->row;
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19181 "Photo.c"
				}
#line 2375 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (new_comment);
#line 2375 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 19187 "Photo.c"
			}
#line 2377 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = photo_table_get_instance ();
#line 2377 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _tmp6_;
#line 2377 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = self->row;
#line 2377 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = _tmp8_->photo_id;
#line 2377 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = new_comment;
#line 2377 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = photo_table_set_comment (_tmp7_, &_tmp9_, _tmp10_);
#line 2377 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp7_);
#line 2378 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = committed;
#line 2378 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp11_) {
#line 19207 "Photo.c"
				PhotoRow* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
#line 2379 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = self->row;
#line 2379 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = new_comment;
#line 2379 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 2379 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp12_->comment);
#line 2379 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_->comment = _tmp14_;
#line 19221 "Photo.c"
			}
		}
		__finally364:
		{
			PhotoRow* _tmp15_;
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = self->row;
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19231 "Photo.c"
		}
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 19235 "Photo.c"
			gboolean _tmp16_ = FALSE;
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (new_comment);
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp16_;
#line 19245 "Photo.c"
		}
	}
#line 2382 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = committed;
#line 2382 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp17_) {
#line 19252 "Photo.c"
		Alteration* _tmp18_;
		Alteration* _tmp19_;
#line 2383 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = alteration_new ("metadata", "comment");
#line 2383 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = _tmp18_;
#line 2383 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp19_);
#line 2383 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp19_);
#line 19263 "Photo.c"
	}
#line 2385 "/home/jens/Source/shotwell/src/Photo.vala"
	result = committed;
#line 2385 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (new_comment);
#line 2385 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 19271 "Photo.c"
}


static gpointer
_g_error_copy0 (gpointer self)
{
#line 2395 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? g_error_copy (self) : NULL;
#line 19280 "Photo.c"
}


void
photo_set_import_id (Photo* self,
                     ImportID* import_id)
{
	GError* dberr = NULL;
	GError* _tmp13_;
	GError * _inner_error_ = NULL;
#line 2388 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2388 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (import_id != NULL);
#line 2389 "/home/jens/Source/shotwell/src/Photo.vala"
	dberr = NULL;
#line 19297 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 19304 "Photo.c"
		{
			{
				PhotoTable* _tmp1_;
				PhotoTable* _tmp2_;
				PhotoRow* _tmp3_;
				PhotoID _tmp4_;
				ImportID _tmp5_;
				PhotoRow* _tmp7_;
				ImportID _tmp8_;
#line 2392 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = photo_table_get_instance ();
#line 2392 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp2_ = _tmp1_;
#line 2392 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2392 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->photo_id;
#line 2392 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = *import_id;
#line 2392 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_set_import_id (_tmp2_, &_tmp4_, &_tmp5_, &_inner_error_);
#line 2392 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp2_);
#line 2392 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2392 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 19332 "Photo.c"
						goto __catch366_database_error;
					}
					{
						PhotoRow* _tmp6_;
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp6_ = self->row;
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19341 "Photo.c"
					}
#line 2392 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_error_free0 (dberr);
#line 2392 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2392 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 2392 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 19351 "Photo.c"
				}
#line 2393 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = self->row;
#line 2393 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = *import_id;
#line 2393 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_->import_id = _tmp8_;
#line 19359 "Photo.c"
			}
			goto __finally366;
			__catch366_database_error:
			{
				GError* err = NULL;
				GError* _tmp9_;
				GError* _tmp10_;
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
				err = _inner_error_;
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 2395 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = err;
#line 2395 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _g_error_copy0 (_tmp9_);
#line 2395 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (dberr);
#line 2395 "/home/jens/Source/shotwell/src/Photo.vala"
				dberr = _tmp10_;
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (err);
#line 19381 "Photo.c"
			}
			__finally366:
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 19386 "Photo.c"
				{
					PhotoRow* _tmp11_;
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = self->row;
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19393 "Photo.c"
				}
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (dberr);
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 19403 "Photo.c"
			}
		}
		__finally365:
		{
			PhotoRow* _tmp12_;
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = self->row;
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19413 "Photo.c"
		}
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_error_free0 (dberr);
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 19425 "Photo.c"
		}
	}
#line 2399 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = dberr;
#line 2399 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp13_ == NULL) {
#line 19432 "Photo.c"
		Alteration* _tmp14_;
		Alteration* _tmp15_;
#line 2400 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = alteration_new ("metadata", "import-id");
#line 2400 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = _tmp14_;
#line 2400 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp15_);
#line 2400 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp15_);
#line 19443 "Photo.c"
	} else {
		gchar* _tmp16_;
		gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = _tmp16_;
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = dberr;
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = _tmp18_->message;
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2402: Unable to write import ID for %s: %s", _tmp17_, _tmp19_);
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp17_);
#line 19461 "Photo.c"
	}
#line 2388 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_error_free0 (dberr);
#line 19465 "Photo.c"
}


void
photo_set_title_persistent (Photo* self,
                            const gchar* title,
                            GError** error)
{
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp5_;
	PhotoMetadata* _tmp6_;
	PhotoMetadata* _tmp7_;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp8_;
	PhotoFileMetadataWriter* _tmp9_;
	PhotoFileReader* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GError * _inner_error_ = NULL;
#line 2405 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2406 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 2406 "/home/jens/Source/shotwell/src/Photo.vala"
	source = _tmp0_;
#line 2409 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = source;
#line 2409 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)))) {
#line 19498 "Photo.c"
		PhotoFileReader* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 2410 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = source;
#line 2410 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2410 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp3_;
#line 2410 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2410: No photo file writer available for %s", _tmp4_);
#line 2410 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp4_);
#line 2412 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), title);
#line 2414 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2414 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19518 "Photo.c"
	}
#line 2417 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = source;
#line 2417 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_file_reader_read_metadata (_tmp5_, &_inner_error_);
#line 2417 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp6_;
#line 2417 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2417 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2417 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2417 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19534 "Photo.c"
	}
#line 2418 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = metadata;
#line 2418 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_metadata_set_title (_tmp7_, title, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 2420 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = source;
#line 2420 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = photo_file_reader_create_metadata_writer (_tmp8_, &_inner_error_);
#line 2420 "/home/jens/Source/shotwell/src/Photo.vala"
	writer = _tmp9_;
#line 2420 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2420 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2420 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2420 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2420 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19556 "Photo.c"
	}
#line 2421 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = source;
#line 2421 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2421 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = _tmp11_;
#line 2421 "/home/jens/Source/shotwell/src/Photo.vala"
	library_monitor_blacklist_file (_tmp12_, "Photo.set_persistent_title");
#line 2421 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp12_);
#line 19568 "Photo.c"
	{
		PhotoFileMetadataWriter* _tmp13_;
		PhotoMetadata* _tmp14_;
#line 2423 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = writer;
#line 2423 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = metadata;
#line 2423 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_metadata_writer_write_metadata (_tmp13_, _tmp14_, &_inner_error_);
#line 2423 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 19580 "Photo.c"
			goto __finally367;
		}
	}
	__finally367:
	{
		PhotoFileReader* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
#line 2425 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = source;
#line 2425 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2425 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = _tmp16_;
#line 2425 "/home/jens/Source/shotwell/src/Photo.vala"
		library_monitor_unblacklist_file (_tmp17_);
#line 2425 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp17_);
#line 19599 "Photo.c"
	}
#line 2422 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2422 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2422 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (writer);
#line 2422 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2422 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2422 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19613 "Photo.c"
	}
#line 2428 "/home/jens/Source/shotwell/src/Photo.vala"
	media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), title);
#line 2430 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_exif_updated (self);
#line 2405 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (writer);
#line 2405 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2405 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (source);
#line 19625 "Photo.c"
}


void
photo_set_comment_persistent (Photo* self,
                              const gchar* comment,
                              GError** error)
{
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp5_;
	PhotoMetadata* _tmp6_;
	PhotoMetadata* _tmp7_;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp8_;
	PhotoFileMetadataWriter* _tmp9_;
	PhotoFileReader* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GError * _inner_error_ = NULL;
#line 2433 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2434 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 2434 "/home/jens/Source/shotwell/src/Photo.vala"
	source = _tmp0_;
#line 2437 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = source;
#line 2437 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)))) {
#line 19658 "Photo.c"
		PhotoFileReader* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 2438 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = source;
#line 2438 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2438 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp3_;
#line 2438 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2438: No photo file writer available for %s", _tmp4_);
#line 2438 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp4_);
#line 2440 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), comment);
#line 2442 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2442 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19678 "Photo.c"
	}
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = source;
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_file_reader_read_metadata (_tmp5_, &_inner_error_);
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp6_;
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19694 "Photo.c"
	}
#line 2446 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = metadata;
#line 2446 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_metadata_set_comment (_tmp7_, comment, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 2448 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = source;
#line 2448 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = photo_file_reader_create_metadata_writer (_tmp8_, &_inner_error_);
#line 2448 "/home/jens/Source/shotwell/src/Photo.vala"
	writer = _tmp9_;
#line 2448 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2448 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2448 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2448 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2448 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19716 "Photo.c"
	}
#line 2449 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = source;
#line 2449 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2449 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = _tmp11_;
#line 2449 "/home/jens/Source/shotwell/src/Photo.vala"
	library_monitor_blacklist_file (_tmp12_, "Photo.set_persistent_comment");
#line 2449 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp12_);
#line 19728 "Photo.c"
	{
		PhotoFileMetadataWriter* _tmp13_;
		PhotoMetadata* _tmp14_;
#line 2451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = writer;
#line 2451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = metadata;
#line 2451 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_metadata_writer_write_metadata (_tmp13_, _tmp14_, &_inner_error_);
#line 2451 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 19740 "Photo.c"
			goto __finally368;
		}
	}
	__finally368:
	{
		PhotoFileReader* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
#line 2453 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = source;
#line 2453 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2453 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = _tmp16_;
#line 2453 "/home/jens/Source/shotwell/src/Photo.vala"
		library_monitor_unblacklist_file (_tmp17_);
#line 2453 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp17_);
#line 19759 "Photo.c"
	}
#line 2450 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2450 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2450 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (writer);
#line 2450 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2450 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2450 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19773 "Photo.c"
	}
#line 2456 "/home/jens/Source/shotwell/src/Photo.vala"
	media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), comment);
#line 2458 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_exif_updated (self);
#line 2433 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (writer);
#line 2433 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2433 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (source);
#line 19785 "Photo.c"
}


static void
photo_real_set_exposure_time (Dateable* base,
                              time_t time)
{
	Photo * self;
	gboolean committed = FALSE;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
#line 2461 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 19799 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2463 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2463 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 19806 "Photo.c"
		{
			PhotoTable* _tmp1_;
			PhotoTable* _tmp2_;
			PhotoRow* _tmp3_;
			PhotoID _tmp4_;
			gboolean _tmp5_;
#line 2464 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_table_get_instance ();
#line 2464 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_;
#line 2464 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2464 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->photo_id;
#line 2464 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = photo_table_set_exposure_time (_tmp2_, &_tmp4_, time);
#line 2464 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp2_);
#line 2465 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = committed;
#line 2465 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp5_) {
#line 19829 "Photo.c"
				PhotoRow* _tmp6_;
#line 2466 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 2466 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_->exposure_time = time;
#line 2467 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->cached_exposure_time = time;
#line 19837 "Photo.c"
			}
		}
		__finally369:
		{
			PhotoRow* _tmp7_;
#line 2463 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 2463 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19847 "Photo.c"
		}
#line 2463 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2463 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2463 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2463 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 19857 "Photo.c"
		}
	}
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = committed;
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp8_) {
#line 19864 "Photo.c"
		Alteration* _tmp9_;
		Alteration* _tmp10_;
#line 2472 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = alteration_new ("metadata", "exposure-time");
#line 2472 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _tmp9_;
#line 2472 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp10_);
#line 2472 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp10_);
#line 19875 "Photo.c"
	}
}


void
photo_set_exposure_time_persistent (Photo* self,
                                    time_t time,
                                    GError** error)
{
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp5_;
	PhotoMetadata* _tmp6_;
	PhotoMetadata* _tmp7_;
	MetadataDateTime* _tmp8_;
	MetadataDateTime* _tmp9_;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp10_;
	PhotoFileMetadataWriter* _tmp11_;
	PhotoFileReader* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GError * _inner_error_ = NULL;
#line 2475 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2476 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 2476 "/home/jens/Source/shotwell/src/Photo.vala"
	source = _tmp0_;
#line 2479 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = source;
#line 2479 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)))) {
#line 19911 "Photo.c"
		PhotoFileReader* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 2480 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = source;
#line 2480 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2480 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp3_;
#line 2480 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2480: No photo file writer available for %s", _tmp4_);
#line 2480 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp4_);
#line 2482 "/home/jens/Source/shotwell/src/Photo.vala"
		dateable_set_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATEABLE, Dateable), time);
#line 2484 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2484 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19931 "Photo.c"
	}
#line 2487 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = source;
#line 2487 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_file_reader_read_metadata (_tmp5_, &_inner_error_);
#line 2487 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp6_;
#line 2487 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2487 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2487 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2487 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19947 "Photo.c"
	}
#line 2488 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = metadata;
#line 2488 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = metadata_date_time_new (time);
#line 2488 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp8_;
#line 2488 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_metadata_set_exposure_date_time (_tmp7_, _tmp9_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 2488 "/home/jens/Source/shotwell/src/Photo.vala"
	_metadata_date_time_unref0 (_tmp9_);
#line 2490 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = source;
#line 2490 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = photo_file_reader_create_metadata_writer (_tmp10_, &_inner_error_);
#line 2490 "/home/jens/Source/shotwell/src/Photo.vala"
	writer = _tmp11_;
#line 2490 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2490 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2490 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2490 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2490 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19975 "Photo.c"
	}
#line 2491 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = source;
#line 2491 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2491 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = _tmp13_;
#line 2491 "/home/jens/Source/shotwell/src/Photo.vala"
	library_monitor_blacklist_file (_tmp14_, "Photo.set_exposure_time_persistent");
#line 2491 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp14_);
#line 19987 "Photo.c"
	{
		PhotoFileMetadataWriter* _tmp15_;
		PhotoMetadata* _tmp16_;
#line 2493 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = writer;
#line 2493 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = metadata;
#line 2493 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_metadata_writer_write_metadata (_tmp15_, _tmp16_, &_inner_error_);
#line 2493 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 19999 "Photo.c"
			goto __finally370;
		}
	}
	__finally370:
	{
		PhotoFileReader* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
#line 2495 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = source;
#line 2495 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2495 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = _tmp18_;
#line 2495 "/home/jens/Source/shotwell/src/Photo.vala"
		library_monitor_unblacklist_file (_tmp19_);
#line 2495 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp19_);
#line 20018 "Photo.c"
	}
#line 2492 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2492 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2492 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (writer);
#line 2492 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2492 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2492 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 20032 "Photo.c"
	}
#line 2498 "/home/jens/Source/shotwell/src/Photo.vala"
	dateable_set_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATEABLE, Dateable), time);
#line 2500 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_exif_updated (self);
#line 2475 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (writer);
#line 2475 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2475 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (source);
#line 20044 "Photo.c"
}


/**
     * @brief Returns the width and height of the Photo after various
     * arbitrary stages of the pipeline have been applied in
     * the same order they're applied in get_pixbuf_with_options.
     * With no argument passed, it works exactly like the
     * previous incarnation did.
     *
     * @param disallowed_steps Which pipeline steps should NOT
     *      be taken into account when computing image dimensions
     *      (matching the convention set by get_pixbuf_with_options()).
     *      Pipeline steps that do not affect the image geometry are
     *      ignored.
     */
static void
photo_real_get_dimensions (MediaSource* base,
                           PhotoException disallowed_steps,
                           Dimensions* result)
{
	Photo * self;
	Dimensions returned_dims = {0};
	Dimensions _tmp0_ = {0};
#line 2516 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2518 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_raw_dimensions (self, &_tmp0_);
#line 2518 "/home/jens/Source/shotwell/src/Photo.vala"
	returned_dims = _tmp0_;
#line 2521 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_exception_allows (disallowed_steps, PHOTO_EXCEPTION_ORIENTATION)) {
#line 20077 "Photo.c"
		Orientation ori_tmp = 0;
		Orientation _tmp1_;
#line 2522 "/home/jens/Source/shotwell/src/Photo.vala"
		ori_tmp = photo_get_orientation (self);
#line 2525 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = ori_tmp;
#line 2525 "/home/jens/Source/shotwell/src/Photo.vala"
		switch (_tmp1_) {
#line 2525 "/home/jens/Source/shotwell/src/Photo.vala"
			case ORIENTATION_LEFT_TOP:
#line 2525 "/home/jens/Source/shotwell/src/Photo.vala"
			case ORIENTATION_RIGHT_TOP:
#line 2525 "/home/jens/Source/shotwell/src/Photo.vala"
			case ORIENTATION_LEFT_BOTTOM:
#line 2525 "/home/jens/Source/shotwell/src/Photo.vala"
			case ORIENTATION_RIGHT_BOTTOM:
#line 20094 "Photo.c"
			{
				gint width_tmp = 0;
				Dimensions _tmp2_;
				gint _tmp3_;
				Dimensions _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
#line 2531 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp2_ = returned_dims;
#line 2531 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = _tmp2_.width;
#line 2531 "/home/jens/Source/shotwell/src/Photo.vala"
				width_tmp = _tmp3_;
#line 2533 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = returned_dims;
#line 2533 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_.height;
#line 2533 "/home/jens/Source/shotwell/src/Photo.vala"
				returned_dims.width = _tmp5_;
#line 2534 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = width_tmp;
#line 2534 "/home/jens/Source/shotwell/src/Photo.vala"
				returned_dims.height = _tmp6_;
#line 2535 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 20120 "Photo.c"
			}
			default:
			{
#line 2539 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 20126 "Photo.c"
			}
		}
	}
#line 2544 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_exception_allows (disallowed_steps, PHOTO_EXCEPTION_STRAIGHTEN)) {
#line 20132 "Photo.c"
		gdouble x_size = 0.0;
		gdouble y_size = 0.0;
		gdouble angle = 0.0;
		gdouble _tmp7_ = 0.0;
		Dimensions _tmp8_;
		gint _tmp9_;
		Dimensions _tmp10_;
		gint _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_;
		gdouble _tmp16_;
#line 2546 "/home/jens/Source/shotwell/src/Photo.vala"
		angle = 0.0;
#line 2548 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_get_straighten (self, &_tmp7_);
#line 2548 "/home/jens/Source/shotwell/src/Photo.vala"
		angle = _tmp7_;
#line 2550 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = returned_dims;
#line 2550 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = _tmp8_.width;
#line 2550 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = returned_dims;
#line 2550 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = _tmp10_.height;
#line 2550 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = angle;
#line 2550 "/home/jens/Source/shotwell/src/Photo.vala"
		compute_arb_rotated_size ((gdouble) _tmp9_, (gdouble) _tmp11_, _tmp12_, &_tmp13_, &_tmp14_);
#line 2550 "/home/jens/Source/shotwell/src/Photo.vala"
		x_size = _tmp13_;
#line 2550 "/home/jens/Source/shotwell/src/Photo.vala"
		y_size = _tmp14_;
#line 2552 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = x_size;
#line 2552 "/home/jens/Source/shotwell/src/Photo.vala"
		returned_dims.width = (gint) _tmp15_;
#line 2553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = y_size;
#line 2553 "/home/jens/Source/shotwell/src/Photo.vala"
		returned_dims.height = (gint) _tmp16_;
#line 20176 "Photo.c"
	}
#line 2557 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_exception_allows (disallowed_steps, PHOTO_EXCEPTION_CROP)) {
#line 20180 "Photo.c"
		Box crop = {0};
		Box _tmp17_ = {0};
		gboolean _tmp18_;
#line 2559 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = photo_get_crop (self, &_tmp17_, disallowed_steps);
#line 2559 "/home/jens/Source/shotwell/src/Photo.vala"
		crop = _tmp17_;
#line 2559 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp18_) {
#line 20190 "Photo.c"
			Dimensions _tmp19_ = {0};
#line 2560 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&crop, &_tmp19_);
#line 2560 "/home/jens/Source/shotwell/src/Photo.vala"
			returned_dims = _tmp19_;
#line 20196 "Photo.c"
		}
	}
#line 2563 "/home/jens/Source/shotwell/src/Photo.vala"
	*result = returned_dims;
#line 2563 "/home/jens/Source/shotwell/src/Photo.vala"
	return;
#line 20203 "Photo.c"
}


static void
photo_locked_create_adjustments_from_data (Photo* self)
{
	PixelTransformationBundle* _tmp0_;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp1_;
	KeyValueMap* _tmp2_;
	PixelTransformationBundle* _tmp6_;
	PixelTransformer* _tmp7_;
#line 2567 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2568 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = pixel_transformation_bundle_new ();
#line 2568 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2568 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->adjustments = _tmp0_;
#line 2570 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_get_transformation (self, "adjustments");
#line 2570 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp1_;
#line 2571 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = map;
#line 2571 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_ == NULL) {
#line 20232 "Photo.c"
		PixelTransformationBundle* _tmp3_;
#line 2572 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = self->priv->adjustments;
#line 2572 "/home/jens/Source/shotwell/src/Photo.vala"
		pixel_transformation_bundle_set_to_identity (_tmp3_);
#line 20238 "Photo.c"
	} else {
		PixelTransformationBundle* _tmp4_;
		KeyValueMap* _tmp5_;
#line 2574 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = self->priv->adjustments;
#line 2574 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = map;
#line 2574 "/home/jens/Source/shotwell/src/Photo.vala"
		pixel_transformation_bundle_load (_tmp4_, _tmp5_);
#line 20248 "Photo.c"
	}
#line 2576 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = self->priv->adjustments;
#line 2576 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = pixel_transformation_bundle_generate_transformer (_tmp6_);
#line 2576 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformer_unref0 (self->priv->transformer);
#line 2576 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->transformer = _tmp7_;
#line 2567 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 20260 "Photo.c"
}


PixelTransformationBundle*
photo_get_color_adjustments (Photo* self)
{
	PixelTransformationBundle* result = NULL;
	GError * _inner_error_ = NULL;
#line 2580 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 20271 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2581 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2581 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 20278 "Photo.c"
		{
			PixelTransformationBundle* _tmp1_;
			PixelTransformationBundle* _tmp2_;
			PixelTransformationBundle* _tmp3_;
#line 2582 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->adjustments;
#line 2582 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp1_ == NULL) {
#line 2583 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_locked_create_adjustments_from_data (self);
#line 20289 "Photo.c"
			}
#line 2585 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->adjustments;
#line 2585 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = pixel_transformation_bundle_copy (_tmp2_);
#line 2585 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 20297 "Photo.c"
			{
				PhotoRow* _tmp4_;
#line 2581 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2581 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20304 "Photo.c"
			}
#line 2585 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 20308 "Photo.c"
		}
		__finally371:
		{
			PhotoRow* _tmp5_;
#line 2581 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2581 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20317 "Photo.c"
		}
#line 2581 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2581 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2581 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 20325 "Photo.c"
	}
}


PixelTransformer*
photo_get_pixel_transformer (Photo* self)
{
	PixelTransformer* result = NULL;
	GError * _inner_error_ = NULL;
#line 2589 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 20337 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 20344 "Photo.c"
		{
			PixelTransformer* _tmp1_;
			PixelTransformer* _tmp2_;
			PixelTransformer* _tmp3_;
#line 2591 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->transformer;
#line 2591 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp1_ == NULL) {
#line 2592 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_locked_create_adjustments_from_data (self);
#line 20355 "Photo.c"
			}
#line 2594 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->transformer;
#line 2594 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = pixel_transformer_copy (_tmp2_);
#line 2594 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 20363 "Photo.c"
			{
				PhotoRow* _tmp4_;
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20370 "Photo.c"
			}
#line 2594 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 20374 "Photo.c"
		}
		__finally372:
		{
			PhotoRow* _tmp5_;
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20383 "Photo.c"
		}
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 20391 "Photo.c"
	}
}


gboolean
photo_has_color_adjustments (Photo* self)
{
	gboolean result = FALSE;
#line 2598 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2599 "/home/jens/Source/shotwell/src/Photo.vala"
	result = photo_has_transformation (self, "adjustments");
#line 2599 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 20406 "Photo.c"
}


PixelTransformation*
photo_get_color_adjustment (Photo* self,
                            PixelTransformationType type)
{
	PixelTransformation* result = NULL;
	PixelTransformationBundle* _tmp0_;
	PixelTransformationBundle* _tmp1_;
	PixelTransformation* _tmp2_;
	PixelTransformation* _tmp3_;
#line 2602 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2603 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_color_adjustments (self);
#line 2603 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 2603 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = pixel_transformation_bundle_get_transformation (_tmp1_, type);
#line 2603 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 2603 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformation_bundle_unref0 (_tmp1_);
#line 2603 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 2603 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 20435 "Photo.c"
}


void
photo_set_color_adjustments (Photo* self,
                             PixelTransformationBundle* new_adjustments)
{
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp5_;
	gboolean committed = FALSE;
	gboolean _tmp28_;
	GError * _inner_error_ = NULL;
#line 2606 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2606 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION_BUNDLE (new_adjustments));
#line 2609 "/home/jens/Source/shotwell/src/Photo.vala"
	if (pixel_transformation_bundle_is_identity (new_adjustments)) {
#line 20454 "Photo.c"
		gboolean _result_ = FALSE;
		gboolean _tmp2_;
		{
			PhotoRow* _tmp0_;
#line 2611 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp0_ = self->row;
#line 2611 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 20463 "Photo.c"
			{
#line 2612 "/home/jens/Source/shotwell/src/Photo.vala"
				_result_ = photo_remove_transformation (self, "adjustments");
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->adjustments = NULL;
#line 2614 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (self->priv->transformer);
#line 2614 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->transformer = NULL;
#line 20475 "Photo.c"
			}
			__finally373:
			{
				PhotoRow* _tmp1_;
#line 2611 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = self->row;
#line 2611 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20484 "Photo.c"
			}
#line 2611 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2611 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2611 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2611 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 20494 "Photo.c"
			}
		}
#line 2617 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = _result_;
#line 2617 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp2_) {
#line 20501 "Photo.c"
			Alteration* _tmp3_;
			Alteration* _tmp4_;
#line 2618 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = alteration_new ("image", "color-adjustments");
#line 2618 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_;
#line 2618 "/home/jens/Source/shotwell/src/Photo.vala"
			data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp4_);
#line 2618 "/home/jens/Source/shotwell/src/Photo.vala"
			_alteration_unref0 (_tmp4_);
#line 20512 "Photo.c"
		}
#line 2620 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 20516 "Photo.c"
	}
#line 2624 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = pixel_transformation_bundle_save (new_adjustments, "adjustments");
#line 2624 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp5_;
#line 20522 "Photo.c"
	{
		PhotoRow* _tmp6_;
#line 2627 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = self->row;
#line 2627 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 20529 "Photo.c"
		{
			gboolean _tmp7_ = FALSE;
			PixelTransformer* _tmp8_;
			KeyValueMap* _tmp26_;
#line 2628 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = self->priv->transformer;
#line 2628 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp8_ == NULL) {
#line 2628 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = TRUE;
#line 20540 "Photo.c"
			} else {
				PixelTransformationBundle* _tmp9_;
#line 2628 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = self->priv->adjustments;
#line 2628 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp9_ == NULL;
#line 20547 "Photo.c"
			}
#line 2628 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp7_) {
#line 20551 "Photo.c"
				PixelTransformationBundle* _tmp10_;
				PixelTransformer* _tmp11_;
#line 2630 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = pixel_transformation_bundle_copy (new_adjustments);
#line 2630 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2630 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->adjustments = _tmp10_;
#line 2631 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = pixel_transformation_bundle_generate_transformer (new_adjustments);
#line 2631 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (self->priv->transformer);
#line 2631 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->transformer = _tmp11_;
#line 20566 "Photo.c"
			} else {
				PixelTransformationBundle* _tmp25_;
				{
					GeeIterator* _transformation_it = NULL;
					GeeIterable* _tmp12_;
					GeeIterable* _tmp13_;
					GeeIterator* _tmp14_;
					GeeIterator* _tmp15_;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = pixel_transformation_bundle_get_transformations (new_adjustments);
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_ = _tmp12_;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = gee_iterable_iterator (_tmp13_);
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = _tmp14_;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_tmp13_);
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
					_transformation_it = _tmp15_;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
					while (TRUE) {
#line 20589 "Photo.c"
						GeeIterator* _tmp16_;
						PixelTransformation* transformation = NULL;
						GeeIterator* _tmp17_;
						gpointer _tmp18_;
						PixelTransformer* _tmp19_;
						PixelTransformationBundle* _tmp20_;
						PixelTransformation* _tmp21_;
						PixelTransformation* _tmp22_;
						PixelTransformation* _tmp23_;
						PixelTransformation* _tmp24_;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp16_ = _transformation_it;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
						if (!gee_iterator_next (_tmp16_)) {
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
							break;
#line 20606 "Photo.c"
						}
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp17_ = _transformation_it;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp18_ = gee_iterator_get (_tmp17_);
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
						transformation = (PixelTransformation*) _tmp18_;
#line 2635 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp19_ = self->priv->transformer;
#line 2635 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp20_ = self->priv->adjustments;
#line 2635 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp21_ = transformation;
#line 2635 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp22_ = pixel_transformation_bundle_get_transformation (_tmp20_, pixel_transformation_get_transformation_type (_tmp21_));
#line 2635 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp23_ = _tmp22_;
#line 2635 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp24_ = transformation;
#line 2635 "/home/jens/Source/shotwell/src/Photo.vala"
						pixel_transformer_replace_transformation (_tmp19_, _tmp23_, _tmp24_);
#line 2635 "/home/jens/Source/shotwell/src/Photo.vala"
						_pixel_transformation_unref0 (_tmp23_);
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
						_pixel_transformation_unref0 (transformation);
#line 20632 "Photo.c"
					}
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_transformation_it);
#line 20636 "Photo.c"
				}
#line 2640 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = pixel_transformation_bundle_copy (new_adjustments);
#line 2640 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2640 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->adjustments = _tmp25_;
#line 20644 "Photo.c"
			}
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26_ = map;
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = photo_set_transformation (self, _tmp26_);
#line 20650 "Photo.c"
		}
		__finally374:
		{
			PhotoRow* _tmp27_;
#line 2627 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp27_ = self->row;
#line 2627 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20659 "Photo.c"
		}
#line 2627 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2627 "/home/jens/Source/shotwell/src/Photo.vala"
			_key_value_map_unref0 (map);
#line 2627 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2627 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2627 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 20671 "Photo.c"
		}
	}
#line 2646 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28_ = committed;
#line 2646 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp28_) {
#line 20678 "Photo.c"
		Alteration* _tmp29_;
		Alteration* _tmp30_;
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = alteration_new ("image", "color-adjustments");
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = _tmp29_;
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp30_);
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp30_);
#line 20689 "Photo.c"
	}
#line 2606 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 20693 "Photo.c"
}


static PhotoMetadata*
photo_real_get_metadata (PhotoSource* base)
{
	Photo * self;
	PhotoMetadata* result = NULL;
	GError * _inner_error_ = NULL;
#line 2651 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 20705 "Photo.c"
	{
		PhotoMetadata* _tmp0_ = NULL;
		PhotoFileReader* _tmp1_;
		PhotoFileReader* _tmp2_;
		PhotoMetadata* _tmp3_;
		PhotoMetadata* _tmp4_;
		PhotoMetadata* _tmp5_;
#line 2653 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = photo_get_source_reader (self);
#line 2653 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = _tmp1_;
#line 2653 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_file_reader_read_metadata (_tmp2_, &_inner_error_);
#line 2653 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp3_;
#line 2653 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp2_);
#line 2653 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp4_;
#line 2653 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20727 "Photo.c"
			goto __catch375_g_error;
		}
#line 2653 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp0_;
#line 2653 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = NULL;
#line 2653 "/home/jens/Source/shotwell/src/Photo.vala"
		result = _tmp5_;
#line 2653 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (_tmp0_);
#line 2653 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20740 "Photo.c"
	}
	goto __finally375;
	__catch375_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 2652 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 2652 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 2655 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = err;
#line 2655 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp6_->message;
#line 2655 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2655: Unable to load metadata: %s", _tmp7_);
#line 2657 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 2657 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 2657 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20764 "Photo.c"
	}
	__finally375:
#line 2652 "/home/jens/Source/shotwell/src/Photo.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2652 "/home/jens/Source/shotwell/src/Photo.vala"
	g_clear_error (&_inner_error_);
#line 2652 "/home/jens/Source/shotwell/src/Photo.vala"
	return NULL;
#line 20773 "Photo.c"
}


PhotoMetadata*
photo_get_master_metadata (Photo* self,
                           GError** error)
{
	PhotoMetadata* result = NULL;
	PhotoMetadata* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_;
	PhotoFileReader* _tmp2_;
	PhotoMetadata* _tmp3_;
	PhotoMetadata* _tmp4_;
	PhotoMetadata* _tmp5_;
	GError * _inner_error_ = NULL;
#line 2661 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_get_master_reader (self);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp1_;
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_reader_read_metadata (_tmp2_, &_inner_error_);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp3_;
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp2_);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp4_;
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 20809 "Photo.c"
	}
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = _tmp0_;
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp5_;
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (_tmp0_);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 20821 "Photo.c"
}


PhotoMetadata*
photo_get_editable_metadata (Photo* self,
                             GError** error)
{
	PhotoMetadata* result = NULL;
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_;
	PhotoMetadata* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_;
	GError * _inner_error_ = NULL;
#line 2665 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2666 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_reader (self);
#line 2666 "/home/jens/Source/shotwell/src/Photo.vala"
	reader = _tmp0_;
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = reader;
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_ != NULL) {
#line 20845 "Photo.c"
		PhotoFileReader* _tmp3_;
		PhotoMetadata* _tmp4_;
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = reader;
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = photo_file_reader_read_metadata (_tmp3_, &_inner_error_);
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (_tmp1_);
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp4_;
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
			_media_metadata_unref0 (_tmp1_);
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (reader);
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 20866 "Photo.c"
		}
	} else {
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (_tmp1_);
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = NULL;
#line 20873 "Photo.c"
	}
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp1_;
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (reader);
#line 2668 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 20881 "Photo.c"
}


gboolean
photo_persist_master_metadata (Photo* self,
                               PhotoMetadata* metadata,
                               PhotoReimportMasterState* * state,
                               GError** error)
{
	PhotoReimportMasterState* _vala_state = NULL;
	gboolean result = FALSE;
	PhotoFileReader* master_reader = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoFileMetadataWriter* _tmp2_ = NULL;
	PhotoFileReader* _tmp3_;
	PhotoFileMetadataWriter* _tmp4_;
	gboolean _tmp7_ = FALSE;
	PhotoReimportMasterState* _tmp8_ = NULL;
	gboolean _tmp9_;
	PhotoReimportMasterState* _tmp11_;
	GError * _inner_error_ = NULL;
#line 2674 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2674 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (metadata), FALSE);
#line 2676 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (_vala_state);
#line 2676 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = NULL;
#line 2678 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_reader (self);
#line 2678 "/home/jens/Source/shotwell/src/Photo.vala"
	master_reader = _tmp0_;
#line 2680 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = master_reader;
#line 2680 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)))) {
#line 2681 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2681 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2681 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2681 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 20928 "Photo.c"
		} else {
#line 2681 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (_vala_state);
#line 20932 "Photo.c"
		}
#line 2681 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20936 "Photo.c"
	}
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = master_reader;
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = photo_file_reader_create_metadata_writer (_tmp3_, &_inner_error_);
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp4_;
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20946 "Photo.c"
		gboolean _tmp5_ = FALSE;
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 20954 "Photo.c"
	}
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_metadata_writer_write_metadata (_tmp2_, metadata, &_inner_error_);
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20960 "Photo.c"
		gboolean _tmp6_ = FALSE;
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp2_);
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp6_;
#line 20970 "Photo.c"
	}
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = photo_prepare_for_reimport_master (self, &_tmp8_, &_inner_error_);
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (_vala_state);
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = _tmp8_;
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = _tmp9_;
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20982 "Photo.c"
		gboolean _tmp10_ = FALSE;
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp2_);
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp10_;
#line 20992 "Photo.c"
	}
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp7_) {
#line 2686 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2686 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp2_);
#line 2686 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2686 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2686 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 21006 "Photo.c"
		} else {
#line 2686 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (_vala_state);
#line 21010 "Photo.c"
		}
#line 2686 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 21014 "Photo.c"
	}
#line 2688 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = _vala_state;
#line 2688 "/home/jens/Source/shotwell/src/Photo.vala"
	G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl)->metadata_only = TRUE;
#line 2690 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 2690 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp2_);
#line 2690 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (master_reader);
#line 2690 "/home/jens/Source/shotwell/src/Photo.vala"
	if (state) {
#line 2690 "/home/jens/Source/shotwell/src/Photo.vala"
		*state = _vala_state;
#line 21030 "Photo.c"
	} else {
#line 2690 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_master_state_unref0 (_vala_state);
#line 21034 "Photo.c"
	}
#line 2690 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 21038 "Photo.c"
}


void
photo_finish_update_master_metadata (Photo* self,
                                     PhotoReimportMasterState* state,
                                     GError** error)
{
	GError * _inner_error_ = NULL;
#line 2693 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2693 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_MASTER_STATE (state));
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_finish_reimport_master (self, state, &_inner_error_);
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 21062 "Photo.c"
		} else {
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 21070 "Photo.c"
		}
	}
}


gboolean
photo_persist_editable_metadata (Photo* self,
                                 PhotoMetadata* metadata,
                                 PhotoReimportEditableState* * state,
                                 GError** error)
{
	PhotoReimportEditableState* _vala_state = NULL;
	gboolean result = FALSE;
	PhotoFileReader* editable_reader = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoFileReader* _tmp2_;
	PhotoFileMetadataWriter* _tmp3_ = NULL;
	PhotoFileReader* _tmp4_;
	PhotoFileMetadataWriter* _tmp5_;
	gboolean _tmp8_ = FALSE;
	PhotoReimportEditableState* _tmp9_ = NULL;
	gboolean _tmp10_;
	PhotoReimportEditableState* _tmp12_;
	GError * _inner_error_ = NULL;
#line 2697 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2697 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (metadata), FALSE);
#line 2699 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (_vala_state);
#line 2699 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = NULL;
#line 2701 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_reader (self);
#line 2701 "/home/jens/Source/shotwell/src/Photo.vala"
	editable_reader = _tmp0_;
#line 2702 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = editable_reader;
#line 2702 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 2703 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2703 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2703 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2703 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 21120 "Photo.c"
		} else {
#line 2703 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 21124 "Photo.c"
		}
#line 2703 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 21128 "Photo.c"
	}
#line 2705 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = editable_reader;
#line 2705 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)))) {
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 21142 "Photo.c"
		} else {
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 21146 "Photo.c"
		}
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 21150 "Photo.c"
	}
#line 2708 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = editable_reader;
#line 2708 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = photo_file_reader_create_metadata_writer (_tmp4_, &_inner_error_);
#line 2708 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp5_;
#line 2708 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 21160 "Photo.c"
		gboolean _tmp6_ = FALSE;
#line 2708 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2708 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2708 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp6_;
#line 21168 "Photo.c"
	}
#line 2708 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_metadata_writer_write_metadata (_tmp3_, metadata, &_inner_error_);
#line 2708 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 21174 "Photo.c"
		gboolean _tmp7_ = FALSE;
#line 2708 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2708 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp3_);
#line 2708 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2708 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp7_;
#line 21184 "Photo.c"
	}
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = photo_prepare_for_reimport_editable (self, &_tmp9_, &_inner_error_);
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (_vala_state);
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = _tmp9_;
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = _tmp10_;
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 21196 "Photo.c"
		gboolean _tmp11_ = FALSE;
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp3_);
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp11_;
#line 21206 "Photo.c"
	}
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp8_) {
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp3_);
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 21220 "Photo.c"
		} else {
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 21224 "Photo.c"
		}
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 21228 "Photo.c"
	}
#line 2713 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = _vala_state;
#line 2713 "/home/jens/Source/shotwell/src/Photo.vala"
	G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl)->metadata_only = TRUE;
#line 2715 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 2715 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp3_);
#line 2715 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (editable_reader);
#line 2715 "/home/jens/Source/shotwell/src/Photo.vala"
	if (state) {
#line 2715 "/home/jens/Source/shotwell/src/Photo.vala"
		*state = _vala_state;
#line 21244 "Photo.c"
	} else {
#line 2715 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_editable_state_unref0 (_vala_state);
#line 21248 "Photo.c"
	}
#line 2715 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 21252 "Photo.c"
}


void
photo_finish_update_editable_metadata (Photo* self,
                                       PhotoReimportEditableState* state,
                                       GError** error)
{
	GError * _inner_error_ = NULL;
#line 2718 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2718 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_EDITABLE_STATE (state));
#line 2719 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_finish_reimport_editable (self, state, &_inner_error_);
#line 2719 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2719 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 2719 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 2719 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 21276 "Photo.c"
		} else {
#line 2719 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2719 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2719 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 21284 "Photo.c"
		}
	}
}


void
photo_get_raw_dimensions (Photo* self,
                          Dimensions* result)
{
	GError * _inner_error_ = NULL;
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 21297 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21304 "Photo.c"
		{
			BackingPhotoRow* _tmp1_;
			Dimensions _tmp2_;
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->dim;
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
			*result = _tmp2_;
#line 21314 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21321 "Photo.c"
			}
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 21325 "Photo.c"
		}
		__finally376:
		{
			PhotoRow* _tmp4_;
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21334 "Photo.c"
		}
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 21342 "Photo.c"
	}
}


gboolean
photo_has_transformations (Photo* self)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2730 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 21354 "Photo.c"
	{
		PhotoRow* _tmp0_;
		gboolean _tmp10_ = FALSE;
#line 2731 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2731 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21362 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			PhotoRow* _tmp2_;
			Orientation _tmp3_;
			BackingPhotoRow* _tmp4_;
			Orientation _tmp5_;
#line 2732 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 2732 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_->orientation;
#line 2732 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->backing_photo_row;
#line 2732 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _tmp4_->original_orientation;
#line 2732 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_ != _tmp5_) {
#line 2733 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = TRUE;
#line 21381 "Photo.c"
			} else {
				PhotoRow* _tmp6_;
				GeeHashMap* _tmp7_;
#line 2734 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 2734 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_->transformations;
#line 2734 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp7_ != NULL;
#line 21391 "Photo.c"
			}
#line 2732 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 21395 "Photo.c"
			{
				PhotoRow* _tmp8_;
#line 2731 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = self->row;
#line 2731 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21402 "Photo.c"
			}
#line 2732 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 21406 "Photo.c"
		}
		__finally377:
		{
			PhotoRow* _tmp9_;
#line 2731 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2731 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21415 "Photo.c"
		}
#line 2731 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2731 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2731 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp10_;
#line 21423 "Photo.c"
	}
}


gboolean
photo_only_metadata_changed (Photo* self)
{
	gboolean result = FALSE;
	MetadataDateTime* date_time = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* _tmp1_;
	GError * _inner_error_ = NULL;
#line 2738 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2739 "/home/jens/Source/shotwell/src/Photo.vala"
	date_time = NULL;
#line 2741 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource));
#line 2741 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp0_;
#line 2742 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = metadata;
#line 2742 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ != NULL) {
#line 21449 "Photo.c"
		PhotoMetadata* _tmp2_;
		MetadataDateTime* _tmp3_;
#line 2743 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = metadata;
#line 2743 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_metadata_get_exposure_date_time (_tmp2_);
#line 2743 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 2743 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp3_;
#line 21460 "Photo.c"
	}
	{
		PhotoRow* _tmp4_;
		gboolean _tmp20_ = FALSE;
#line 2745 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = self->row;
#line 2745 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21469 "Photo.c"
		{
			gboolean _tmp5_ = FALSE;
			PhotoRow* _tmp6_;
			GeeHashMap* _tmp7_;
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _tmp6_->transformations;
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp7_ == NULL) {
#line 21480 "Photo.c"
				gboolean _tmp8_ = FALSE;
				PhotoRow* _tmp9_;
				Orientation _tmp10_;
				BackingPhotoRow* _tmp11_;
				Orientation _tmp12_;
#line 2747 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = self->row;
#line 2747 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_->orientation;
#line 2747 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = self->backing_photo_row;
#line 2747 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = _tmp11_->original_orientation;
#line 2747 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp10_ != _tmp12_) {
#line 2747 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = TRUE;
#line 21498 "Photo.c"
				} else {
					gboolean _tmp13_ = FALSE;
					MetadataDateTime* _tmp14_;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = date_time;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp14_ != NULL) {
#line 21506 "Photo.c"
						PhotoRow* _tmp15_;
						time_t _tmp16_;
						MetadataDateTime* _tmp17_;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp15_ = self->row;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp16_ = _tmp15_->exposure_time;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp17_ = date_time;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp13_ = _tmp16_ != metadata_date_time_get_timestamp (_tmp17_);
#line 21518 "Photo.c"
					} else {
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp13_ = FALSE;
#line 21522 "Photo.c"
					}
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = _tmp13_;
#line 21526 "Photo.c"
				}
#line 2747 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp8_;
#line 21530 "Photo.c"
			} else {
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = FALSE;
#line 21534 "Photo.c"
			}
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp5_;
#line 21538 "Photo.c"
			{
				PhotoRow* _tmp18_;
#line 2745 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = self->row;
#line 2745 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21545 "Photo.c"
			}
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
			_media_metadata_unref0 (metadata);
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
			_metadata_date_time_unref0 (date_time);
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 21553 "Photo.c"
		}
		__finally378:
		{
			PhotoRow* _tmp19_;
#line 2745 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = self->row;
#line 2745 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21562 "Photo.c"
		}
#line 2745 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2745 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 2745 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2745 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2745 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp20_;
#line 21574 "Photo.c"
	}
#line 2738 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2738 "/home/jens/Source/shotwell/src/Photo.vala"
	_metadata_date_time_unref0 (date_time);
#line 21580 "Photo.c"
}


gboolean
photo_has_alterations (Photo* self)
{
	gboolean result = FALSE;
	MetadataDateTime* date_time = NULL;
	gchar* title = NULL;
	gchar* comment = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* _tmp1_;
	MetadataDateTime* _tmp8_;
	GError * _inner_error_ = NULL;
#line 2752 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2753 "/home/jens/Source/shotwell/src/Photo.vala"
	date_time = NULL;
#line 2754 "/home/jens/Source/shotwell/src/Photo.vala"
	title = NULL;
#line 2755 "/home/jens/Source/shotwell/src/Photo.vala"
	comment = NULL;
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource));
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp0_;
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = metadata;
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ != NULL) {
#line 21612 "Photo.c"
		PhotoMetadata* _tmp2_;
		MetadataDateTime* _tmp3_;
		PhotoMetadata* _tmp4_;
		gchar* _tmp5_;
		PhotoMetadata* _tmp6_;
		gchar* _tmp7_;
#line 2759 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = metadata;
#line 2759 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_metadata_get_exposure_date_time (_tmp2_);
#line 2759 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 2759 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp3_;
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = metadata;
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (title);
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
		title = _tmp5_;
#line 2761 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = metadata;
#line 2761 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 2761 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (comment);
#line 2761 "/home/jens/Source/shotwell/src/Photo.vala"
		comment = _tmp7_;
#line 21643 "Photo.c"
	}
#line 2765 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = date_time;
#line 2765 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp8_ == NULL) {
#line 21649 "Photo.c"
		{
			PhotoRow* _tmp9_;
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 21656 "Photo.c"
			{
				BackingPhotoRow* _tmp10_;
				time_t _tmp11_;
				PhotoRow* _tmp12_;
				time_t _tmp13_;
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = self->backing_photo_row;
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _tmp10_->timestamp;
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = self->row;
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _tmp12_->exposure_time;
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp11_ != _tmp13_) {
#line 2771 "/home/jens/Source/shotwell/src/Photo.vala"
					result = TRUE;
#line 21674 "Photo.c"
					{
						PhotoRow* _tmp14_;
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp14_ = self->row;
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21681 "Photo.c"
					}
#line 2771 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (metadata);
#line 2771 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (comment);
#line 2771 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (title);
#line 2771 "/home/jens/Source/shotwell/src/Photo.vala"
					_metadata_date_time_unref0 (date_time);
#line 2771 "/home/jens/Source/shotwell/src/Photo.vala"
					return result;
#line 21693 "Photo.c"
				}
			}
			__finally379:
			{
				PhotoRow* _tmp15_;
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = self->row;
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21703 "Photo.c"
			}
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 21707 "Photo.c"
				gboolean _tmp16_ = FALSE;
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
				_media_metadata_unref0 (metadata);
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (comment);
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (title);
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
				_metadata_date_time_unref0 (date_time);
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
				return _tmp16_;
#line 21723 "Photo.c"
			}
		}
	}
	{
		PhotoRow* _tmp17_;
		gboolean _tmp41_ = FALSE;
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = self->row;
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21734 "Photo.c"
		{
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			PhotoRow* _tmp22_;
			GeeHashMap* _tmp23_;
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp22_ = self->row;
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp23_ = _tmp22_->transformations;
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp23_ != NULL) {
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp21_ = TRUE;
#line 21750 "Photo.c"
			} else {
				PhotoRow* _tmp24_;
				Orientation _tmp25_;
				BackingPhotoRow* _tmp26_;
				Orientation _tmp27_;
#line 2778 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = self->row;
#line 2778 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = _tmp24_->orientation;
#line 2778 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = self->backing_photo_row;
#line 2778 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = _tmp26_->original_orientation;
#line 2778 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp21_ = _tmp25_ != _tmp27_;
#line 21766 "Photo.c"
			}
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp21_) {
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = TRUE;
#line 21772 "Photo.c"
			} else {
				gboolean _tmp28_ = FALSE;
				MetadataDateTime* _tmp29_;
#line 2779 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = date_time;
#line 2779 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp29_ != NULL) {
#line 21780 "Photo.c"
					PhotoRow* _tmp30_;
					time_t _tmp31_;
					MetadataDateTime* _tmp32_;
#line 2779 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp30_ = self->row;
#line 2779 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp31_ = _tmp30_->exposure_time;
#line 2779 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp32_ = date_time;
#line 2779 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp28_ = _tmp31_ != metadata_date_time_get_timestamp (_tmp32_);
#line 21792 "Photo.c"
				} else {
#line 2779 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp28_ = FALSE;
#line 21796 "Photo.c"
				}
#line 2779 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = _tmp28_;
#line 21800 "Photo.c"
			}
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp20_) {
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = TRUE;
#line 21806 "Photo.c"
			} else {
				gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
#line 2780 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = media_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 2780 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = _tmp33_;
#line 2780 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = comment;
#line 2780 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = g_strcmp0 (_tmp34_, _tmp35_) != 0;
#line 2780 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp34_);
#line 21821 "Photo.c"
			}
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp19_) {
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = TRUE;
#line 21827 "Photo.c"
			} else {
				gchar* _tmp36_;
				gchar* _tmp37_;
				const gchar* _tmp38_;
#line 2781 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp36_ = media_source_get_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 2781 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp37_ = _tmp36_;
#line 2781 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_ = title;
#line 2781 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = g_strcmp0 (_tmp37_, _tmp38_) != 0;
#line 2781 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp37_);
#line 21842 "Photo.c"
			}
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp18_;
#line 21846 "Photo.c"
			{
				PhotoRow* _tmp39_;
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = self->row;
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21853 "Photo.c"
			}
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
			_media_metadata_unref0 (metadata);
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (comment);
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (title);
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
			_metadata_date_time_unref0 (date_time);
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 21865 "Photo.c"
		}
		__finally380:
		{
			PhotoRow* _tmp40_;
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp40_ = self->row;
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21874 "Photo.c"
		}
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (comment);
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (title);
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp41_;
#line 21890 "Photo.c"
	}
#line 2752 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2752 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (comment);
#line 2752 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (title);
#line 2752 "/home/jens/Source/shotwell/src/Photo.vala"
	_metadata_date_time_unref0 (date_time);
#line 21900 "Photo.c"
}


PhotoTransformationState*
photo_save_transformation_state (Photo* self)
{
	PhotoTransformationState* result = NULL;
	GError * _inner_error_ = NULL;
#line 2786 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 21911 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21918 "Photo.c"
		{
			PixelTransformer* _tmp1_ = NULL;
			PixelTransformer* _tmp2_;
			PixelTransformationBundle* _tmp5_ = NULL;
			PixelTransformationBundle* _tmp6_;
			PhotoRow* _tmp9_;
			Orientation _tmp10_;
			PhotoRow* _tmp11_;
			GeeHashMap* _tmp12_;
			PhotoPhotoTransformationStateImpl* _tmp13_;
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->transformer;
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 21933 "Photo.c"
				PixelTransformer* _tmp3_;
				PixelTransformer* _tmp4_;
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->transformer;
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = pixel_transformer_copy (_tmp3_);
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (_tmp1_);
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp4_;
#line 21944 "Photo.c"
			} else {
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (_tmp1_);
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = NULL;
#line 21950 "Photo.c"
			}
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->priv->adjustments;
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp6_ != NULL) {
#line 21956 "Photo.c"
				PixelTransformationBundle* _tmp7_;
				PixelTransformationBundle* _tmp8_;
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = self->priv->adjustments;
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = pixel_transformation_bundle_copy (_tmp7_);
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (_tmp5_);
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp8_;
#line 21967 "Photo.c"
			} else {
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (_tmp5_);
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = NULL;
#line 21973 "Photo.c"
			}
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = _tmp9_->orientation;
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = self->row;
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = _tmp11_->transformations;
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = photo_photo_transformation_state_impl_new (self, _tmp10_, _tmp12_, _tmp1_, _tmp5_);
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState);
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformation_bundle_unref0 (_tmp5_);
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformer_unref0 (_tmp1_);
#line 21991 "Photo.c"
			{
				PhotoRow* _tmp14_;
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = self->row;
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21998 "Photo.c"
			}
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 22002 "Photo.c"
		}
		__finally381:
		{
			PhotoRow* _tmp15_;
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = self->row;
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22011 "Photo.c"
		}
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 22019 "Photo.c"
	}
}


static gpointer
_pixel_transformer_ref0 (gpointer self)
{
#line 2812 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? pixel_transformer_ref (self) : NULL;
#line 22029 "Photo.c"
}


static gpointer
_pixel_transformation_bundle_ref0 (gpointer self)
{
#line 2813 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? pixel_transformation_bundle_ref (self) : NULL;
#line 22038 "Photo.c"
}


gboolean
photo_load_transformation_state (Photo* self,
                                 PhotoTransformationState* state)
{
	gboolean result = FALSE;
	PhotoPhotoTransformationStateImpl* state_impl = NULL;
	PhotoPhotoTransformationStateImpl* _tmp0_;
	PhotoPhotoTransformationStateImpl* _tmp1_;
	Orientation saved_orientation = 0;
	PhotoPhotoTransformationStateImpl* _tmp2_;
	GeeHashMap* saved_transformations = NULL;
	PhotoPhotoTransformationStateImpl* _tmp3_;
	GeeHashMap* _tmp4_;
	PixelTransformer* saved_transformer = NULL;
	PhotoPhotoTransformationStateImpl* _tmp5_;
	PixelTransformer* _tmp6_;
	PixelTransformationBundle* saved_adjustments = NULL;
	PhotoPhotoTransformationStateImpl* _tmp7_;
	PixelTransformationBundle* _tmp8_;
	gboolean committed = FALSE;
	gboolean _tmp28_;
	GError * _inner_error_ = NULL;
#line 2795 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2795 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_TRANSFORMATION_STATE (state), FALSE);
#line 2796 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (state, PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL) ? ((PhotoPhotoTransformationStateImpl*) state) : NULL);
#line 2796 "/home/jens/Source/shotwell/src/Photo.vala"
	state_impl = _tmp0_;
#line 2797 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = state_impl;
#line 2797 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 2798 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2798 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (state_impl);
#line 2798 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 22082 "Photo.c"
	}
#line 2800 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = state_impl;
#line 2800 "/home/jens/Source/shotwell/src/Photo.vala"
	saved_orientation = photo_photo_transformation_state_impl_get_orientation (_tmp2_);
#line 2801 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = state_impl;
#line 2801 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = photo_photo_transformation_state_impl_get_transformations (_tmp3_);
#line 2801 "/home/jens/Source/shotwell/src/Photo.vala"
	saved_transformations = _tmp4_;
#line 2802 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = state_impl;
#line 2802 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_photo_transformation_state_impl_get_transformer (_tmp5_);
#line 2802 "/home/jens/Source/shotwell/src/Photo.vala"
	saved_transformer = _tmp6_;
#line 2803 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = state_impl;
#line 2803 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = photo_photo_transformation_state_impl_get_color_adjustments (_tmp7_);
#line 2803 "/home/jens/Source/shotwell/src/Photo.vala"
	saved_adjustments = _tmp8_;
#line 22106 "Photo.c"
	{
		PhotoRow* _tmp9_;
#line 2806 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = self->row;
#line 2806 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22113 "Photo.c"
		{
			PhotoTable* _tmp10_;
			PhotoTable* _tmp11_;
			PhotoRow* _tmp12_;
			PhotoID _tmp13_;
			Orientation _tmp14_;
			GeeHashMap* _tmp15_;
			gboolean _tmp16_;
#line 2807 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = photo_table_get_instance ();
#line 2807 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = _tmp10_;
#line 2807 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = self->row;
#line 2807 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = _tmp12_->photo_id;
#line 2807 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = saved_orientation;
#line 2807 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = saved_transformations;
#line 2807 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = photo_table_set_transformation_state (_tmp11_, &_tmp13_, _tmp14_, _tmp15_);
#line 2807 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp11_);
#line 2809 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = committed;
#line 2809 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp16_) {
#line 22142 "Photo.c"
				PhotoRow* _tmp17_;
				Orientation _tmp18_;
				PhotoRow* _tmp19_;
				GeeHashMap* _tmp20_;
				GeeHashMap* _tmp21_;
				PixelTransformer* _tmp22_;
				PixelTransformer* _tmp23_;
				PixelTransformationBundle* _tmp24_;
				PixelTransformationBundle* _tmp25_;
#line 2810 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = self->row;
#line 2810 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = saved_orientation;
#line 2810 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_->orientation = _tmp18_;
#line 2811 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = self->row;
#line 2811 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = saved_transformations;
#line 2811 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp21_ = _g_object_ref0 (_tmp20_);
#line 2811 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp19_->transformations);
#line 2811 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_->transformations = _tmp21_;
#line 2812 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp22_ = saved_transformer;
#line 2812 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = _pixel_transformer_ref0 (_tmp22_);
#line 2812 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (self->priv->transformer);
#line 2812 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->transformer = _tmp23_;
#line 2813 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = saved_adjustments;
#line 2813 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = _pixel_transformation_bundle_ref0 (_tmp24_);
#line 2813 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2813 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->adjustments = _tmp25_;
#line 22184 "Photo.c"
			}
		}
		__finally382:
		{
			PhotoRow* _tmp26_;
#line 2806 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26_ = self->row;
#line 2806 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22194 "Photo.c"
		}
#line 2806 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 22198 "Photo.c"
			gboolean _tmp27_ = FALSE;
#line 2806 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformation_bundle_unref0 (saved_adjustments);
#line 2806 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformer_unref0 (saved_transformer);
#line 2806 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (saved_transformations);
#line 2806 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (state_impl);
#line 2806 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2806 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2806 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp27_;
#line 22214 "Photo.c"
		}
	}
#line 2817 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28_ = committed;
#line 2817 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp28_) {
#line 22221 "Photo.c"
		Alteration* _tmp29_;
		Alteration* _tmp30_;
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = alteration_new ("image", "transformation-state");
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = _tmp29_;
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp30_);
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp30_);
#line 22232 "Photo.c"
	}
#line 2820 "/home/jens/Source/shotwell/src/Photo.vala"
	result = committed;
#line 2820 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformation_bundle_unref0 (saved_adjustments);
#line 2820 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformer_unref0 (saved_transformer);
#line 2820 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (saved_transformations);
#line 2820 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (state_impl);
#line 2820 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22246 "Photo.c"
}


void
photo_remove_all_transformations (Photo* self)
{
#line 2823 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2824 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_internal_remove_all_transformations (self, TRUE);
#line 22257 "Photo.c"
}


static void
photo_internal_remove_all_transformations (Photo* self,
                                           gboolean notify)
{
	gboolean is_altered = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_;
	GError * _inner_error_ = NULL;
#line 2827 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2828 "/home/jens/Source/shotwell/src/Photo.vala"
	is_altered = FALSE;
#line 22273 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2829 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2829 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22280 "Photo.c"
		{
			PhotoTable* _tmp1_;
			PhotoTable* _tmp2_;
			PhotoRow* _tmp3_;
			PhotoID _tmp4_;
			PhotoRow* _tmp5_;
			PhotoRow* _tmp6_;
			Orientation _tmp7_;
			BackingPhotoRow* _tmp8_;
			Orientation _tmp9_;
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_table_get_instance ();
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_;
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->photo_id;
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
			is_altered = photo_table_remove_all_transformations (_tmp2_, &_tmp4_);
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp2_);
#line 2831 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2831 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_tmp5_->transformations);
#line 2831 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_->transformations = NULL;
#line 2833 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformer_unref0 (self->priv->transformer);
#line 2833 "/home/jens/Source/shotwell/src/Photo.vala"
			self->priv->transformer = NULL;
#line 2834 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2834 "/home/jens/Source/shotwell/src/Photo.vala"
			self->priv->adjustments = NULL;
#line 2836 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 2836 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _tmp6_->orientation;
#line 2836 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = self->backing_photo_row;
#line 2836 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = _tmp8_->original_orientation;
#line 2836 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp7_ != _tmp9_) {
#line 22327 "Photo.c"
				PhotoTable* _tmp10_;
				PhotoTable* _tmp11_;
				PhotoRow* _tmp12_;
				PhotoID _tmp13_;
				BackingPhotoRow* _tmp14_;
				Orientation _tmp15_;
				PhotoRow* _tmp16_;
				BackingPhotoRow* _tmp17_;
				Orientation _tmp18_;
#line 2837 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = photo_table_get_instance ();
#line 2837 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _tmp10_;
#line 2837 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = self->row;
#line 2837 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _tmp12_->photo_id;
#line 2837 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = self->backing_photo_row;
#line 2837 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = _tmp14_->original_orientation;
#line 2837 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_set_orientation (_tmp11_, &_tmp13_, _tmp15_);
#line 2837 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp11_);
#line 2839 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = self->row;
#line 2839 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = self->backing_photo_row;
#line 2839 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = _tmp17_->original_orientation;
#line 2839 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_->orientation = _tmp18_;
#line 2840 "/home/jens/Source/shotwell/src/Photo.vala"
				is_altered = TRUE;
#line 22363 "Photo.c"
			}
		}
		__finally383:
		{
			PhotoRow* _tmp19_;
#line 2829 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = self->row;
#line 2829 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22373 "Photo.c"
		}
#line 2829 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2829 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2829 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2829 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 22383 "Photo.c"
		}
	}
#line 2844 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = is_altered;
#line 2844 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp21_) {
#line 2844 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = notify;
#line 22392 "Photo.c"
	} else {
#line 2844 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = FALSE;
#line 22396 "Photo.c"
	}
#line 2844 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp20_) {
#line 22400 "Photo.c"
		Alteration* _tmp22_;
		Alteration* _tmp23_;
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = alteration_new ("image", "revert");
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = _tmp22_;
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp23_);
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp23_);
#line 22411 "Photo.c"
	}
}


Orientation
photo_get_original_orientation (Photo* self)
{
	Orientation result = 0;
	GError * _inner_error_ = NULL;
#line 2848 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 22423 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2849 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2849 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22430 "Photo.c"
		{
			BackingPhotoRow* _tmp1_;
			Orientation _tmp2_;
#line 2850 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 2850 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->original_orientation;
#line 2850 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 22440 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 2849 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2849 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22447 "Photo.c"
			}
#line 2850 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 22451 "Photo.c"
		}
		__finally384:
		{
			PhotoRow* _tmp4_;
#line 2849 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2849 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22460 "Photo.c"
		}
#line 2849 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2849 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2849 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 22468 "Photo.c"
	}
}


Orientation
photo_get_orientation (Photo* self)
{
	Orientation result = 0;
	GError * _inner_error_ = NULL;
#line 2854 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 22480 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2855 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2855 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22487 "Photo.c"
		{
			PhotoRow* _tmp1_;
			Orientation _tmp2_;
#line 2856 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2856 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->orientation;
#line 2856 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 22497 "Photo.c"
			{
				PhotoRow* _tmp3_;
#line 2855 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2855 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22504 "Photo.c"
			}
#line 2856 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 22508 "Photo.c"
		}
		__finally385:
		{
			PhotoRow* _tmp4_;
#line 2855 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2855 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22517 "Photo.c"
		}
#line 2855 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2855 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2855 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 22525 "Photo.c"
	}
}


gboolean
photo_set_orientation (Photo* self,
                       Orientation orientation)
{
	gboolean result = FALSE;
	gboolean committed = FALSE;
	gboolean _tmp11_;
	GError * _inner_error_ = NULL;
#line 2860 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2861 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 22542 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22549 "Photo.c"
		{
			PhotoRow* _tmp1_;
			Orientation _tmp2_;
#line 2863 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2863 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->orientation;
#line 2863 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != orientation) {
#line 22559 "Photo.c"
				PhotoTable* _tmp3_;
				PhotoTable* _tmp4_;
				PhotoRow* _tmp5_;
				PhotoID _tmp6_;
				gboolean _tmp7_;
#line 2864 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = photo_table_get_instance ();
#line 2864 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_;
#line 2864 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = self->row;
#line 2864 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = _tmp5_->photo_id;
#line 2864 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = photo_table_set_orientation (_tmp4_, &_tmp6_, orientation);
#line 2864 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp4_);
#line 2865 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = committed;
#line 2865 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp7_) {
#line 22581 "Photo.c"
					PhotoRow* _tmp8_;
#line 2866 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = self->row;
#line 2866 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_->orientation = orientation;
#line 22587 "Photo.c"
				}
			}
		}
		__finally386:
		{
			PhotoRow* _tmp9_;
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22598 "Photo.c"
		}
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 22602 "Photo.c"
			gboolean _tmp10_ = FALSE;
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp10_;
#line 22610 "Photo.c"
		}
	}
#line 2870 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = committed;
#line 2870 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp11_) {
#line 22617 "Photo.c"
		Alteration* _tmp12_;
		Alteration* _tmp13_;
#line 2871 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = alteration_new ("image", "orientation");
#line 2871 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp12_;
#line 2871 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp13_);
#line 2871 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp13_);
#line 22628 "Photo.c"
	}
#line 2873 "/home/jens/Source/shotwell/src/Photo.vala"
	result = committed;
#line 2873 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22634 "Photo.c"
}


gboolean
photo_check_can_rotate (Photo* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 2876 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2877 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->can_rotate_now;
#line 2877 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 2877 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22651 "Photo.c"
}


static void
photo_real_rotate (Photo* self,
                   Rotation rotation)
{
	GError * _inner_error_ = NULL;
	{
		PhotoRow* _tmp0_;
#line 2881 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2881 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22666 "Photo.c"
		{
#line 2882 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_set_orientation (self, orientation_perform (photo_get_orientation (self), rotation));
#line 22670 "Photo.c"
		}
		__finally387:
		{
			PhotoRow* _tmp1_;
#line 2881 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2881 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22679 "Photo.c"
		}
#line 2881 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2881 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2881 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2881 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 22689 "Photo.c"
		}
	}
}


void
photo_rotate (Photo* self,
              Rotation rotation)
{
#line 2880 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2880 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->rotate (self, rotation);
#line 22703 "Photo.c"
}


static gboolean
photo_has_transformation (Photo* self,
                          const gchar* name)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2886 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2886 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 22717 "Photo.c"
	{
		PhotoRow* _tmp0_;
		gboolean _tmp8_ = FALSE;
#line 2887 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2887 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22725 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			PhotoRow* _tmp2_;
			GeeHashMap* _tmp3_;
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_->transformations;
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_ != NULL) {
#line 22736 "Photo.c"
				PhotoRow* _tmp4_;
				GeeHashMap* _tmp5_;
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_->transformations;
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name);
#line 22745 "Photo.c"
			} else {
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = FALSE;
#line 22749 "Photo.c"
			}
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 22753 "Photo.c"
			{
				PhotoRow* _tmp6_;
#line 2887 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 2887 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22760 "Photo.c"
			}
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 22764 "Photo.c"
		}
		__finally388:
		{
			PhotoRow* _tmp7_;
#line 2887 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 2887 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22773 "Photo.c"
		}
#line 2887 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2887 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2887 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp8_;
#line 22781 "Photo.c"
	}
}


static KeyValueMap*
photo_get_transformation (Photo* self,
                          const gchar* name)
{
	KeyValueMap* result = NULL;
	KeyValueMap* map = NULL;
	GError * _inner_error_ = NULL;
#line 2895 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2895 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 2896 "/home/jens/Source/shotwell/src/Photo.vala"
	map = NULL;
#line 22799 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2897 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2897 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22806 "Photo.c"
		{
			PhotoRow* _tmp1_;
			GeeHashMap* _tmp2_;
#line 2898 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2898 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->transformations;
#line 2898 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 22816 "Photo.c"
				PhotoRow* _tmp3_;
				GeeHashMap* _tmp4_;
				gpointer _tmp5_;
				KeyValueMap* _tmp6_;
#line 2899 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2899 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->transformations;
#line 2899 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name);
#line 2899 "/home/jens/Source/shotwell/src/Photo.vala"
				_key_value_map_unref0 (map);
#line 2899 "/home/jens/Source/shotwell/src/Photo.vala"
				map = (KeyValueMap*) _tmp5_;
#line 2900 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = map;
#line 2900 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp6_ != NULL) {
#line 22835 "Photo.c"
					KeyValueMap* _tmp7_;
					KeyValueMap* _tmp8_;
#line 2901 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp7_ = map;
#line 2901 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = key_value_map_copy (_tmp7_);
#line 2901 "/home/jens/Source/shotwell/src/Photo.vala"
					_key_value_map_unref0 (map);
#line 2901 "/home/jens/Source/shotwell/src/Photo.vala"
					map = _tmp8_;
#line 22846 "Photo.c"
				}
			}
		}
		__finally389:
		{
			PhotoRow* _tmp9_;
#line 2897 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2897 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22857 "Photo.c"
		}
#line 2897 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2897 "/home/jens/Source/shotwell/src/Photo.vala"
			_key_value_map_unref0 (map);
#line 2897 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2897 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2897 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 22869 "Photo.c"
		}
	}
#line 2905 "/home/jens/Source/shotwell/src/Photo.vala"
	result = map;
#line 2905 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22876 "Photo.c"
}


static gboolean
photo_set_transformation (Photo* self,
                          KeyValueMap* trans)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2908 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2908 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_KEY_VALUE_MAP (trans), FALSE);
#line 22890 "Photo.c"
	{
		PhotoRow* _tmp0_;
		gboolean _tmp16_ = FALSE;
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22898 "Photo.c"
		{
			PhotoRow* _tmp1_;
			GeeHashMap* _tmp2_;
			PhotoRow* _tmp5_;
			GeeHashMap* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			PhotoTable* _tmp9_;
			PhotoTable* _tmp10_;
			PhotoRow* _tmp11_;
			PhotoID _tmp12_;
			gboolean _tmp13_;
#line 2910 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2910 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->transformations;
#line 2910 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ == NULL) {
#line 22917 "Photo.c"
				PhotoRow* _tmp3_;
				GeeHashMap* _tmp4_;
#line 2911 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2911 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_KEY_VALUE_MAP, (GBoxedCopyFunc) key_value_map_ref, (GDestroyNotify) key_value_map_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 2911 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp3_->transformations);
#line 2911 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_->transformations = _tmp4_;
#line 22928 "Photo.c"
			}
#line 2913 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2913 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_->transformations;
#line 2913 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = key_value_map_get_group (trans);
#line 2913 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_;
#line 2913 "/home/jens/Source/shotwell/src/Photo.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_, trans);
#line 2913 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp8_);
#line 2915 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = photo_table_get_instance ();
#line 2915 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = _tmp9_;
#line 2915 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = self->row;
#line 2915 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = _tmp11_->photo_id;
#line 2915 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = photo_table_set_transformation (_tmp10_, &_tmp12_, trans);
#line 2915 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp10_);
#line 2915 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp13_;
#line 22956 "Photo.c"
			{
				PhotoRow* _tmp14_;
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = self->row;
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22963 "Photo.c"
			}
#line 2915 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 22967 "Photo.c"
		}
		__finally390:
		{
			PhotoRow* _tmp15_;
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = self->row;
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22976 "Photo.c"
		}
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp16_;
#line 22984 "Photo.c"
	}
}


static gboolean
photo_remove_transformation (Photo* self,
                             const gchar* name)
{
	gboolean result = FALSE;
	gboolean altered_cache = FALSE;
	gboolean altered_persistent = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_;
	GError * _inner_error_ = NULL;
#line 2919 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2919 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 23003 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 2921 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2921 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 23010 "Photo.c"
		{
			PhotoRow* _tmp1_;
			GeeHashMap* _tmp2_;
			PhotoTable* _tmp11_;
			PhotoTable* _tmp12_;
			PhotoRow* _tmp13_;
			PhotoID _tmp14_;
#line 2922 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2922 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->transformations;
#line 2922 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 23024 "Photo.c"
				PhotoRow* _tmp3_;
				GeeHashMap* _tmp4_;
				gboolean _tmp5_;
				PhotoRow* _tmp6_;
				GeeHashMap* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
#line 2923 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2923 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->transformations;
#line 2923 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name, NULL);
#line 2923 "/home/jens/Source/shotwell/src/Photo.vala"
				altered_cache = _tmp5_;
#line 2924 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 2924 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_->transformations;
#line 2924 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 2924 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = _tmp8_;
#line 2924 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp9_ == 0) {
#line 23050 "Photo.c"
					PhotoRow* _tmp10_;
#line 2925 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp10_ = self->row;
#line 2925 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_tmp10_->transformations);
#line 2925 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp10_->transformations = NULL;
#line 23058 "Photo.c"
				}
			} else {
#line 2927 "/home/jens/Source/shotwell/src/Photo.vala"
				altered_cache = FALSE;
#line 23063 "Photo.c"
			}
#line 2930 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = photo_table_get_instance ();
#line 2930 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = _tmp11_;
#line 2930 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->row;
#line 2930 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = _tmp13_->photo_id;
#line 2930 "/home/jens/Source/shotwell/src/Photo.vala"
			altered_persistent = photo_table_remove_transformation (_tmp12_, &_tmp14_, name);
#line 2930 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp12_);
#line 23077 "Photo.c"
		}
		__finally391:
		{
			PhotoRow* _tmp15_;
#line 2921 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = self->row;
#line 2921 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 23086 "Photo.c"
		}
#line 2921 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 23090 "Photo.c"
			gboolean _tmp16_ = FALSE;
#line 2921 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2921 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2921 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp16_;
#line 23098 "Photo.c"
		}
	}
#line 2934 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = altered_cache;
#line 2934 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp18_) {
#line 2934 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = TRUE;
#line 23107 "Photo.c"
	} else {
#line 2934 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = altered_persistent;
#line 23111 "Photo.c"
	}
#line 2934 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp17_;
#line 2934 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23117 "Photo.c"
}


gboolean
photo_has_crop (Photo* self)
{
	gboolean result = FALSE;
#line 2937 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2938 "/home/jens/Source/shotwell/src/Photo.vala"
	result = photo_has_transformation (self, "crop");
#line 2938 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23131 "Photo.c"
}


gboolean
photo_get_raw_crop (Photo* self,
                    Box* crop)
{
	Box _vala_crop = {0};
	gboolean result = FALSE;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	gint left = 0;
	KeyValueMap* _tmp2_;
	gint top = 0;
	KeyValueMap* _tmp3_;
	gint right = 0;
	KeyValueMap* _tmp4_;
	gint bottom = 0;
	KeyValueMap* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
#line 2942 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2943 "/home/jens/Source/shotwell/src/Photo.vala"
	box_init (&_vala_crop, 0, 0, 0, 0);
#line 2945 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_transformation (self, "crop");
#line 2945 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2946 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2946 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 2947 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2947 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 2947 "/home/jens/Source/shotwell/src/Photo.vala"
		if (crop) {
#line 2947 "/home/jens/Source/shotwell/src/Photo.vala"
			*crop = _vala_crop;
#line 23180 "Photo.c"
		}
#line 2947 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 23184 "Photo.c"
	}
#line 2949 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = map;
#line 2949 "/home/jens/Source/shotwell/src/Photo.vala"
	left = key_value_map_get_int (_tmp2_, "left", -1);
#line 2950 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = map;
#line 2950 "/home/jens/Source/shotwell/src/Photo.vala"
	top = key_value_map_get_int (_tmp3_, "top", -1);
#line 2951 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = map;
#line 2951 "/home/jens/Source/shotwell/src/Photo.vala"
	right = key_value_map_get_int (_tmp4_, "right", -1);
#line 2952 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = map;
#line 2952 "/home/jens/Source/shotwell/src/Photo.vala"
	bottom = key_value_map_get_int (_tmp5_, "bottom", -1);
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = left;
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp9_ == -1) {
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = TRUE;
#line 23208 "Photo.c"
	} else {
		gint _tmp10_;
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = top;
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = _tmp10_ == -1;
#line 23215 "Photo.c"
	}
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp8_) {
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = TRUE;
#line 23221 "Photo.c"
	} else {
		gint _tmp11_;
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = right;
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp11_ == -1;
#line 23228 "Photo.c"
	}
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp7_) {
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = TRUE;
#line 23234 "Photo.c"
	} else {
		gint _tmp12_;
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = bottom;
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp12_ == -1;
#line 23241 "Photo.c"
	}
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp6_) {
#line 2955 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2955 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 2955 "/home/jens/Source/shotwell/src/Photo.vala"
		if (crop) {
#line 2955 "/home/jens/Source/shotwell/src/Photo.vala"
			*crop = _vala_crop;
#line 23253 "Photo.c"
		}
#line 2955 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 23257 "Photo.c"
	}
#line 2957 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = left;
#line 2957 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = top;
#line 2957 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = right;
#line 2957 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = bottom;
#line 2957 "/home/jens/Source/shotwell/src/Photo.vala"
	box_init (&_vala_crop, _tmp13_, _tmp14_, _tmp15_, _tmp16_);
#line 2959 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 2959 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 2959 "/home/jens/Source/shotwell/src/Photo.vala"
	if (crop) {
#line 2959 "/home/jens/Source/shotwell/src/Photo.vala"
		*crop = _vala_crop;
#line 23277 "Photo.c"
	}
#line 2959 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23281 "Photo.c"
}


static void
photo_set_raw_crop (Photo* self,
                    Box* crop)
{
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	Box _tmp2_;
	gint _tmp3_;
	KeyValueMap* _tmp4_;
	Box _tmp5_;
	gint _tmp6_;
	KeyValueMap* _tmp7_;
	Box _tmp8_;
	gint _tmp9_;
	KeyValueMap* _tmp10_;
	Box _tmp11_;
	gint _tmp12_;
	KeyValueMap* _tmp13_;
#line 2963 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2963 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (crop != NULL);
#line 2964 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = key_value_map_new ("crop");
#line 2964 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2965 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2965 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = *crop;
#line 2965 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_.left;
#line 2965 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp1_, "left", _tmp3_);
#line 2966 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = map;
#line 2966 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = *crop;
#line 2966 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = _tmp5_.top;
#line 2966 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp4_, "top", _tmp6_);
#line 2967 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = map;
#line 2967 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = *crop;
#line 2967 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp8_.right;
#line 2967 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp7_, "right", _tmp9_);
#line 2968 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = map;
#line 2968 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = *crop;
#line 2968 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = _tmp11_.bottom;
#line 2968 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp10_, "bottom", _tmp12_);
#line 2970 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = map;
#line 2970 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_set_transformation (self, _tmp13_)) {
#line 23348 "Photo.c"
		Alteration* _tmp14_;
		Alteration* _tmp15_;
#line 2971 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = alteration_new ("image", "crop");
#line 2971 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = _tmp14_;
#line 2971 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp15_);
#line 2971 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp15_);
#line 23359 "Photo.c"
	}
#line 2963 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 23363 "Photo.c"
}


static gboolean
photo_get_raw_straighten (Photo* self,
                          gdouble* angle)
{
	gdouble _vala_angle = 0.0;
	gboolean result = FALSE;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	KeyValueMap* _tmp2_;
#line 2974 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2975 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_transformation (self, "straighten");
#line 2975 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2976 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2976 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 2977 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_angle = 0.0;
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
		if (angle) {
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
			*angle = _vala_angle;
#line 23397 "Photo.c"
		}
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 23401 "Photo.c"
	}
#line 2982 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = map;
#line 2982 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_angle = key_value_map_get_double (_tmp2_, "angle", 0.0);
#line 2984 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 2984 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 2984 "/home/jens/Source/shotwell/src/Photo.vala"
	if (angle) {
#line 2984 "/home/jens/Source/shotwell/src/Photo.vala"
		*angle = _vala_angle;
#line 23415 "Photo.c"
	}
#line 2984 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23419 "Photo.c"
}


static void
photo_set_raw_straighten (Photo* self,
                          gdouble theta)
{
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	KeyValueMap* _tmp2_;
#line 2987 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2988 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = key_value_map_new ("straighten");
#line 2988 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2989 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2989 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_double (_tmp1_, "angle", theta);
#line 2991 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = map;
#line 2991 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_set_transformation (self, _tmp2_)) {
#line 23445 "Photo.c"
		Alteration* _tmp3_;
		Alteration* _tmp4_;
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = alteration_new ("image", "straighten");
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp3_;
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp4_);
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp4_);
#line 23456 "Photo.c"
	}
#line 2987 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 23460 "Photo.c"
}


static EditingToolsRedeyeInstance*
photo_get_raw_redeye_instances (Photo* self,
                                int* result_length1)
{
	EditingToolsRedeyeInstance* result = NULL;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	gint num_points = 0;
	KeyValueMap* _tmp4_;
	gint _tmp5_;
	EditingToolsRedeyeInstance* res = NULL;
	gint _tmp6_;
	EditingToolsRedeyeInstance* _tmp7_;
	gint res_length1;
	gint _res_size_;
	GdkPoint default_point = {0};
	GdkPoint _tmp8_ = {0};
	EditingToolsRedeyeInstance* _tmp45_;
	gint _tmp45__length1;
#line 2997 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_transformation (self, "redeye");
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2999 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2999 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 23494 "Photo.c"
		EditingToolsRedeyeInstance* _tmp2_;
		EditingToolsRedeyeInstance* _tmp3_;
		gint _tmp3__length1;
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = g_new0 (EditingToolsRedeyeInstance, 0);
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp2_;
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3__length1 = 0;
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
		if (result_length1) {
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
			*result_length1 = _tmp3__length1;
#line 23508 "Photo.c"
		}
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
		result = _tmp3_;
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 23516 "Photo.c"
	}
#line 3002 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = map;
#line 3002 "/home/jens/Source/shotwell/src/Photo.vala"
	num_points = key_value_map_get_int (_tmp4_, "num_points", -1);
#line 3003 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = num_points;
#line 3003 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp5_ > 0, "num_points > 0");
#line 3005 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = num_points;
#line 3005 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = g_new0 (EditingToolsRedeyeInstance, _tmp6_);
#line 3005 "/home/jens/Source/shotwell/src/Photo.vala"
	res = _tmp7_;
#line 3005 "/home/jens/Source/shotwell/src/Photo.vala"
	res_length1 = _tmp6_;
#line 3005 "/home/jens/Source/shotwell/src/Photo.vala"
	_res_size_ = res_length1;
#line 3007 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_.x = 0;
#line 3007 "/home/jens/Source/shotwell/src/Photo.vala"
	default_point = _tmp8_;
#line 3008 "/home/jens/Source/shotwell/src/Photo.vala"
	default_point.x = -1;
#line 3009 "/home/jens/Source/shotwell/src/Photo.vala"
	default_point.y = -1;
#line 23544 "Photo.c"
	{
		gint i = 0;
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
		i = 0;
#line 23549 "Photo.c"
		{
			gboolean _tmp9_ = FALSE;
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = TRUE;
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
			while (TRUE) {
#line 23556 "Photo.c"
				gint _tmp11_;
				gint _tmp12_;
				gchar* center_key = NULL;
				gint _tmp13_;
				gchar* _tmp14_;
				gchar* radius_key = NULL;
				gint _tmp15_;
				gchar* _tmp16_;
				EditingToolsRedeyeInstance* _tmp17_;
				gint _tmp17__length1;
				gint _tmp18_;
				KeyValueMap* _tmp19_;
				const gchar* _tmp20_;
				GdkPoint _tmp21_;
				GdkPoint _tmp22_ = {0};
				EditingToolsRedeyeInstance* _tmp23_;
				gint _tmp23__length1;
				gint _tmp24_;
				EditingToolsRedeyeInstance _tmp25_;
				GdkPoint _tmp26_;
				gint _tmp27_;
				GdkPoint _tmp28_;
				gint _tmp29_;
				EditingToolsRedeyeInstance* _tmp30_;
				gint _tmp30__length1;
				gint _tmp31_;
				EditingToolsRedeyeInstance _tmp32_;
				GdkPoint _tmp33_;
				gint _tmp34_;
				GdkPoint _tmp35_;
				gint _tmp36_;
				EditingToolsRedeyeInstance* _tmp37_;
				gint _tmp37__length1;
				gint _tmp38_;
				KeyValueMap* _tmp39_;
				const gchar* _tmp40_;
				EditingToolsRedeyeInstance* _tmp41_;
				gint _tmp41__length1;
				gint _tmp42_;
				EditingToolsRedeyeInstance _tmp43_;
				gint _tmp44_;
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!_tmp9_) {
#line 23600 "Photo.c"
					gint _tmp10_;
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp10_ = i;
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
					i = _tmp10_ + 1;
#line 23606 "Photo.c"
				}
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = FALSE;
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = i;
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = num_points;
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!(_tmp11_ < _tmp12_)) {
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
					break;
#line 23618 "Photo.c"
				}
#line 3012 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = i;
#line 3012 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = g_strdup_printf ("center%d", _tmp13_);
#line 3012 "/home/jens/Source/shotwell/src/Photo.vala"
				center_key = _tmp14_;
#line 3013 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = i;
#line 3013 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = g_strdup_printf ("radius%d", _tmp15_);
#line 3013 "/home/jens/Source/shotwell/src/Photo.vala"
				radius_key = _tmp16_;
#line 3015 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = res;
#line 3015 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17__length1 = res_length1;
#line 3015 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = i;
#line 3015 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = map;
#line 3015 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = center_key;
#line 3015 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp21_ = default_point;
#line 3015 "/home/jens/Source/shotwell/src/Photo.vala"
				key_value_map_get_point (_tmp19_, _tmp20_, &_tmp21_, &_tmp22_);
#line 3015 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_[_tmp18_].center = _tmp22_;
#line 3016 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = res;
#line 3016 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23__length1 = res_length1;
#line 3016 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = i;
#line 3016 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = _tmp23_[_tmp24_];
#line 3016 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = _tmp25_.center;
#line 3016 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = _tmp26_.x;
#line 3016 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = default_point;
#line 3016 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = _tmp28_.x;
#line 3016 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_assert (_tmp27_ != _tmp29_, "res[i].center.x != default_point.x");
#line 3017 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = res;
#line 3017 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30__length1 = res_length1;
#line 3017 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp31_ = i;
#line 3017 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp32_ = _tmp30_[_tmp31_];
#line 3017 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = _tmp32_.center;
#line 3017 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = _tmp33_.y;
#line 3017 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = default_point;
#line 3017 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp36_ = _tmp35_.y;
#line 3017 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_assert (_tmp34_ != _tmp36_, "res[i].center.y != default_point.y");
#line 3019 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp37_ = res;
#line 3019 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp37__length1 = res_length1;
#line 3019 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_ = i;
#line 3019 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = map;
#line 3019 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp40_ = radius_key;
#line 3019 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp37_[_tmp38_].radius = key_value_map_get_int (_tmp39_, _tmp40_, -1);
#line 3020 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp41_ = res;
#line 3020 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp41__length1 = res_length1;
#line 3020 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp42_ = i;
#line 3020 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp43_ = _tmp41_[_tmp42_];
#line 3020 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp44_ = _tmp43_.radius;
#line 3020 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_assert (_tmp44_ != -1, "res[i].radius != -1");
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (radius_key);
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (center_key);
#line 23712 "Photo.c"
			}
		}
	}
#line 3023 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45_ = res;
#line 3023 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45__length1 = res_length1;
#line 3023 "/home/jens/Source/shotwell/src/Photo.vala"
	if (result_length1) {
#line 3023 "/home/jens/Source/shotwell/src/Photo.vala"
		*result_length1 = _tmp45__length1;
#line 23724 "Photo.c"
	}
#line 3023 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp45_;
#line 3023 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 3023 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23732 "Photo.c"
}


gboolean
photo_has_redeye_transformations (Photo* self)
{
	gboolean result = FALSE;
#line 3026 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 3027 "/home/jens/Source/shotwell/src/Photo.vala"
	result = photo_has_transformation (self, "redeye");
#line 3027 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23746 "Photo.c"
}


void
photo_add_redeye_instance (Photo* self,
                           EditingToolsRedeyeInstance* redeye)
{
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	gint num_points = 0;
	KeyValueMap* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gchar* radius_key = NULL;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* center_key = NULL;
	gint _tmp9_;
	gchar* _tmp10_;
	KeyValueMap* _tmp11_;
	const gchar* _tmp12_;
	EditingToolsRedeyeInstance _tmp13_;
	gint _tmp14_;
	KeyValueMap* _tmp15_;
	const gchar* _tmp16_;
	EditingToolsRedeyeInstance _tmp17_;
	GdkPoint _tmp18_;
	KeyValueMap* _tmp19_;
	gint _tmp20_;
	KeyValueMap* _tmp21_;
#line 3031 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 3031 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (redeye != NULL);
#line 3032 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_transformation (self, "redeye");
#line 3032 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 3033 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 3033 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 23790 "Photo.c"
		KeyValueMap* _tmp2_;
		KeyValueMap* _tmp3_;
#line 3034 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = key_value_map_new ("redeye");
#line 3034 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 3034 "/home/jens/Source/shotwell/src/Photo.vala"
		map = _tmp2_;
#line 3035 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = map;
#line 3035 "/home/jens/Source/shotwell/src/Photo.vala"
		key_value_map_set_int (_tmp3_, "num_points", 0);
#line 23803 "Photo.c"
	}
#line 3038 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = map;
#line 3038 "/home/jens/Source/shotwell/src/Photo.vala"
	num_points = key_value_map_get_int (_tmp4_, "num_points", -1);
#line 3039 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = num_points;
#line 3039 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp5_ >= 0, "num_points >= 0");
#line 3041 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = num_points;
#line 3041 "/home/jens/Source/shotwell/src/Photo.vala"
	num_points = _tmp6_ + 1;
#line 3043 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = num_points;
#line 3043 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = g_strdup_printf ("radius%d", _tmp7_ - 1);
#line 3043 "/home/jens/Source/shotwell/src/Photo.vala"
	radius_key = _tmp8_;
#line 3044 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = num_points;
#line 3044 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = g_strdup_printf ("center%d", _tmp9_ - 1);
#line 3044 "/home/jens/Source/shotwell/src/Photo.vala"
	center_key = _tmp10_;
#line 3046 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = map;
#line 3046 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = radius_key;
#line 3046 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = *redeye;
#line 3046 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = _tmp13_.radius;
#line 3046 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp11_, _tmp12_, _tmp14_);
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = map;
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = center_key;
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = *redeye;
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = _tmp17_.center;
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_point (_tmp15_, _tmp16_, &_tmp18_);
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = map;
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = num_points;
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp19_, "num_points", _tmp20_);
#line 3051 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = map;
#line 3051 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_set_transformation (self, _tmp21_)) {
#line 23859 "Photo.c"
		Alteration* _tmp22_;
		Alteration* _tmp23_;
#line 3052 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = alteration_new ("image", "redeye");
#line 3052 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = _tmp22_;
#line 3052 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp23_);
#line 3052 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp23_);
#line 23870 "Photo.c"
	}
#line 3031 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (center_key);
#line 3031 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (radius_key);
#line 3031 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 23878 "Photo.c"
}


static gboolean
photo_calculate_pixbuf_dimensions (Photo* self,
                                   Scaling* scaling,
                                   PhotoException exceptions,
                                   Dimensions* scaled_image,
                                   Dimensions* scaled_to_viewport)
{
	Dimensions _vala_scaled_image = {0};
	Dimensions _vala_scaled_to_viewport = {0};
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 3066 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 3066 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, FALSE);
#line 23897 "Photo.c"
	{
		PhotoRow* _tmp0_;
		gboolean _tmp7_ = FALSE;
#line 3068 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 3068 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 23905 "Photo.c"
		{
			Scaling _tmp1_;
			Dimensions _tmp2_ = {0};
			Dimensions _tmp3_ = {0};
			gboolean _tmp4_;
#line 3070 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = *scaling;
#line 3070 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = photo_locked_calculate_pixbuf_dimensions (self, &_tmp1_, exceptions, &_tmp2_, &_tmp3_);
#line 3070 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_image = _tmp2_;
#line 3070 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_to_viewport = _tmp3_;
#line 3070 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp4_;
#line 23921 "Photo.c"
			{
				PhotoRow* _tmp5_;
#line 3068 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = self->row;
#line 3068 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 23928 "Photo.c"
			}
#line 3070 "/home/jens/Source/shotwell/src/Photo.vala"
			if (scaled_image) {
#line 3070 "/home/jens/Source/shotwell/src/Photo.vala"
				*scaled_image = _vala_scaled_image;
#line 23934 "Photo.c"
			}
#line 3070 "/home/jens/Source/shotwell/src/Photo.vala"
			if (scaled_to_viewport) {
#line 3070 "/home/jens/Source/shotwell/src/Photo.vala"
				*scaled_to_viewport = _vala_scaled_to_viewport;
#line 23940 "Photo.c"
			}
#line 3070 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 23944 "Photo.c"
		}
		__finally392:
		{
			PhotoRow* _tmp6_;
#line 3068 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 3068 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 23953 "Photo.c"
		}
#line 3068 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 3068 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 3068 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp7_;
#line 23961 "Photo.c"
	}
#line 3066 "/home/jens/Source/shotwell/src/Photo.vala"
	if (scaled_image) {
#line 3066 "/home/jens/Source/shotwell/src/Photo.vala"
		*scaled_image = _vala_scaled_image;
#line 23967 "Photo.c"
	}
#line 3066 "/home/jens/Source/shotwell/src/Photo.vala"
	if (scaled_to_viewport) {
#line 3066 "/home/jens/Source/shotwell/src/Photo.vala"
		*scaled_to_viewport = _vala_scaled_to_viewport;
#line 23973 "Photo.c"
	}
}


static gboolean
photo_locked_calculate_pixbuf_dimensions (Photo* self,
                                          Scaling* scaling,
                                          PhotoException exceptions,
                                          Dimensions* scaled_image,
                                          Dimensions* scaled_to_viewport)
{
	Dimensions _vala_scaled_image = {0};
	Dimensions _vala_scaled_to_viewport = {0};
	gboolean result = FALSE;
	Dimensions raw = {0};
	Dimensions _tmp0_ = {0};
	Orientation orientation = 0;
	gboolean _tmp36_ = FALSE;
	Dimensions _tmp37_;
	gint _tmp38_;
	Dimensions _tmp39_;
	gint _tmp40_;
#line 3076 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 3076 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, FALSE);
#line 3078 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_raw_dimensions (self, &_tmp0_);
#line 3078 "/home/jens/Source/shotwell/src/Photo.vala"
	raw = _tmp0_;
#line 3080 "/home/jens/Source/shotwell/src/Photo.vala"
	if (scaling_is_unscaled (scaling)) {
#line 24006 "Photo.c"
		Dimensions _tmp1_;
		Dimensions _tmp2_;
#line 3081 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = raw;
#line 3081 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_image = _tmp1_;
#line 3082 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = raw;
#line 3082 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_to_viewport = _tmp2_;
#line 3084 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 3084 "/home/jens/Source/shotwell/src/Photo.vala"
		if (scaled_image) {
#line 3084 "/home/jens/Source/shotwell/src/Photo.vala"
			*scaled_image = _vala_scaled_image;
#line 24023 "Photo.c"
		}
#line 3084 "/home/jens/Source/shotwell/src/Photo.vala"
		if (scaled_to_viewport) {
#line 3084 "/home/jens/Source/shotwell/src/Photo.vala"
			*scaled_to_viewport = _vala_scaled_to_viewport;
#line 24029 "Photo.c"
		}
#line 3084 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 24033 "Photo.c"
	}
#line 3087 "/home/jens/Source/shotwell/src/Photo.vala"
	orientation = photo_get_orientation (self);
#line 3092 "/home/jens/Source/shotwell/src/Photo.vala"
	dimensions_init (&_vala_scaled_image, 0, 0);
#line 3093 "/home/jens/Source/shotwell/src/Photo.vala"
	dimensions_init (&_vala_scaled_to_viewport, 0, 0);
#line 3095 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_CROP)) {
#line 24043 "Photo.c"
		Box crop = {0};
		Box _tmp3_ = {0};
		gboolean _tmp4_;
#line 3097 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = photo_get_raw_crop (self, &_tmp3_);
#line 3097 "/home/jens/Source/shotwell/src/Photo.vala"
		crop = _tmp3_;
#line 3097 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp4_) {
#line 24053 "Photo.c"
			Dimensions rotated_raw = {0};
			Dimensions _tmp5_;
			Box scaled_crop = {0};
			Dimensions _tmp13_ = {0};
			Dimensions _tmp14_ = {0};
			Box _tmp15_ = {0};
			Dimensions _tmp16_ = {0};
			gboolean _tmp17_ = FALSE;
			Dimensions _tmp20_ = {0};
			Dimensions _tmp21_ = {0};
			Dimensions _tmp22_ = {0};
#line 3100 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = raw;
#line 3100 "/home/jens/Source/shotwell/src/Photo.vala"
			rotated_raw = _tmp5_;
#line 3101 "/home/jens/Source/shotwell/src/Photo.vala"
			if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
#line 24071 "Photo.c"
				Orientation _tmp6_;
				Dimensions _tmp7_;
				Box _tmp8_;
				Box _tmp9_ = {0};
				Orientation _tmp10_;
				Dimensions _tmp11_;
				Dimensions _tmp12_ = {0};
#line 3102 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = orientation;
#line 3102 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = raw;
#line 3102 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = crop;
#line 3102 "/home/jens/Source/shotwell/src/Photo.vala"
				orientation_rotate_box (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
#line 3102 "/home/jens/Source/shotwell/src/Photo.vala"
				crop = _tmp9_;
#line 3103 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = orientation;
#line 3103 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = raw;
#line 3103 "/home/jens/Source/shotwell/src/Photo.vala"
				orientation_rotate_dimensions (_tmp10_, &_tmp11_, &_tmp12_);
#line 3103 "/home/jens/Source/shotwell/src/Photo.vala"
				rotated_raw = _tmp12_;
#line 24097 "Photo.c"
			}
#line 3107 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&crop, &_tmp13_);
#line 3107 "/home/jens/Source/shotwell/src/Photo.vala"
			scaling_get_scaled_dimensions (scaling, &_tmp13_, &_tmp14_);
#line 3107 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_scaled (&crop, &_tmp14_, &_tmp15_);
#line 3107 "/home/jens/Source/shotwell/src/Photo.vala"
			scaled_crop = _tmp15_;
#line 3110 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&scaled_crop, &_tmp16_);
#line 3110 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_to_viewport = _tmp16_;
#line 3113 "/home/jens/Source/shotwell/src/Photo.vala"
			if (box_get_width (&crop) <= box_get_width (&scaled_crop)) {
#line 3114 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = box_get_height (&crop) <= box_get_height (&scaled_crop);
#line 24115 "Photo.c"
			} else {
#line 3113 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = FALSE;
#line 24119 "Photo.c"
			}
#line 3113 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp17_) {
#line 24123 "Photo.c"
				Dimensions _tmp18_;
				Dimensions _tmp19_ = {0};
#line 3115 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = raw;
#line 3115 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_scaled_image = _tmp18_;
#line 3116 "/home/jens/Source/shotwell/src/Photo.vala"
				box_get_dimensions (&crop, &_tmp19_);
#line 3116 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_scaled_to_viewport = _tmp19_;
#line 3118 "/home/jens/Source/shotwell/src/Photo.vala"
				result = FALSE;
#line 3118 "/home/jens/Source/shotwell/src/Photo.vala"
				if (scaled_image) {
#line 3118 "/home/jens/Source/shotwell/src/Photo.vala"
					*scaled_image = _vala_scaled_image;
#line 24140 "Photo.c"
				}
#line 3118 "/home/jens/Source/shotwell/src/Photo.vala"
				if (scaled_to_viewport) {
#line 3118 "/home/jens/Source/shotwell/src/Photo.vala"
					*scaled_to_viewport = _vala_scaled_to_viewport;
#line 24146 "Photo.c"
				}
#line 3118 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 24150 "Photo.c"
			}
#line 3123 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&crop, &_tmp20_);
#line 3123 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&scaled_crop, &_tmp21_);
#line 3123 "/home/jens/Source/shotwell/src/Photo.vala"
			dimensions_get_scaled_similar (&rotated_raw, &_tmp20_, &_tmp21_, &_tmp22_);
#line 3123 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_image = _tmp22_;
#line 3127 "/home/jens/Source/shotwell/src/Photo.vala"
			if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
#line 24162 "Photo.c"
				Orientation _tmp23_;
				Dimensions _tmp24_;
				Dimensions _tmp25_ = {0};
#line 3128 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = orientation;
#line 3128 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = _vala_scaled_image;
#line 3128 "/home/jens/Source/shotwell/src/Photo.vala"
				orientation_derotate_dimensions (_tmp23_, &_tmp24_, &_tmp25_);
#line 3128 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_scaled_image = _tmp25_;
#line 24174 "Photo.c"
			}
		}
	}
#line 3133 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!dimensions_has_area (&_vala_scaled_image)) {
#line 24180 "Photo.c"
		Dimensions rotated_raw = {0};
		Dimensions _tmp26_;
		Dimensions _tmp30_;
		Dimensions _tmp31_ = {0};
		Dimensions _tmp32_;
#line 3135 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp26_ = raw;
#line 3135 "/home/jens/Source/shotwell/src/Photo.vala"
		rotated_raw = _tmp26_;
#line 3136 "/home/jens/Source/shotwell/src/Photo.vala"
		if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
#line 24192 "Photo.c"
			Orientation _tmp27_;
			Dimensions _tmp28_;
			Dimensions _tmp29_ = {0};
#line 3137 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp27_ = orientation;
#line 3137 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp28_ = raw;
#line 3137 "/home/jens/Source/shotwell/src/Photo.vala"
			orientation_rotate_dimensions (_tmp27_, &_tmp28_, &_tmp29_);
#line 3137 "/home/jens/Source/shotwell/src/Photo.vala"
			rotated_raw = _tmp29_;
#line 24204 "Photo.c"
		}
#line 3139 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = rotated_raw;
#line 3139 "/home/jens/Source/shotwell/src/Photo.vala"
		scaling_get_scaled_dimensions (scaling, &_tmp30_, &_tmp31_);
#line 3139 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_image = _tmp31_;
#line 3140 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp32_ = _vala_scaled_image;
#line 3140 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_to_viewport = _tmp32_;
#line 3143 "/home/jens/Source/shotwell/src/Photo.vala"
		if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
#line 24218 "Photo.c"
			Orientation _tmp33_;
			Dimensions _tmp34_;
			Dimensions _tmp35_ = {0};
#line 3144 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp33_ = orientation;
#line 3144 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp34_ = _vala_scaled_image;
#line 3144 "/home/jens/Source/shotwell/src/Photo.vala"
			orientation_derotate_dimensions (_tmp33_, &_tmp34_, &_tmp35_);
#line 3144 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_image = _tmp35_;
#line 24230 "Photo.c"
		}
	}
#line 3148 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = _vala_scaled_image;
#line 3148 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = _tmp37_.width;
#line 3148 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp39_ = raw;
#line 3148 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp40_ = _tmp39_.width;
#line 3148 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp38_ >= _tmp40_) {
#line 24243 "Photo.c"
		Dimensions _tmp41_;
		gint _tmp42_;
		Dimensions _tmp43_;
		gint _tmp44_;
#line 3148 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41_ = _vala_scaled_image;
#line 3148 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp42_ = _tmp41_.height;
#line 3148 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp43_ = raw;
#line 3148 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_ = _tmp43_.height;
#line 3148 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = _tmp42_ >= _tmp44_;
#line 24258 "Photo.c"
	} else {
#line 3148 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = FALSE;
#line 24262 "Photo.c"
	}
#line 3148 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp36_) {
#line 24266 "Photo.c"
		Dimensions _tmp45_;
#line 3149 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp45_ = raw;
#line 3149 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_image = _tmp45_;
#line 3151 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 3151 "/home/jens/Source/shotwell/src/Photo.vala"
		if (scaled_image) {
#line 3151 "/home/jens/Source/shotwell/src/Photo.vala"
			*scaled_image = _vala_scaled_image;
#line 24278 "Photo.c"
		}
#line 3151 "/home/jens/Source/shotwell/src/Photo.vala"
		if (scaled_to_viewport) {
#line 3151 "/home/jens/Source/shotwell/src/Photo.vala"
			*scaled_to_viewport = _vala_scaled_to_viewport;
#line 24284 "Photo.c"
		}
#line 3151 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 24288 "Photo.c"
	}
#line 3154 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (dimensions_has_area (&_vala_scaled_image), "scaled_image.has_area()");
#line 3155 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (dimensions_has_area (&_vala_scaled_to_viewport), "scaled_to_viewport.has_area()");
#line 3157 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 3157 "/home/jens/Source/shotwell/src/Photo.vala"
	if (scaled_image) {
#line 3157 "/home/jens/Source/shotwell/src/Photo.vala"
		*scaled_image = _vala_scaled_image;
#line 24300 "Photo.c"
	}
#line 3157 "/home/jens/Source/shotwell/src/Photo.vala"
	if (scaled_to_viewport) {
#line 3157 "/home/jens/Source/shotwell/src/Photo.vala"
		*scaled_to_viewport = _vala_scaled_to_viewport;
#line 24306 "Photo.c"
	}
#line 3157 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24310 "Photo.c"
}


static GdkPixbuf*
photo_load_raw_pixbuf (Photo* self,
                       Scaling* scaling,
                       PhotoException exceptions,
                       BackingFetchMode fetch_mode,
                       GError** error)
{
	GdkPixbuf* result = NULL;
	PhotoFileReader* loader = NULL;
	PhotoFileReader* _tmp0_;
	Dimensions scaled_image = {0};
	Dimensions scaled_to_viewport = {0};
	gboolean is_scaled = FALSE;
	Scaling _tmp5_;
	Dimensions _tmp6_ = {0};
	Dimensions _tmp7_ = {0};
	gboolean _tmp8_;
	gboolean _tmp9_;
	GdkPixbuf* pixbuf = NULL;
	PhotoFileReader* _tmp14_;
	Dimensions _tmp15_ = {0};
	Dimensions _tmp16_;
	GdkPixbuf* _tmp17_;
	GdkPixbuf* _tmp18_;
	Dimensions _tmp19_ = {0};
	GError * _inner_error_ = NULL;
#line 3163 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3163 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 3166 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_backing_reader (self, fetch_mode);
#line 3166 "/home/jens/Source/shotwell/src/Photo.vala"
	loader = _tmp0_;
#line 3169 "/home/jens/Source/shotwell/src/Photo.vala"
	if (scaling_is_unscaled (scaling)) {
#line 24350 "Photo.c"
		GdkPixbuf* _tmp1_ = NULL;
		PhotoFileReader* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
#line 3174 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = loader;
#line 3174 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_file_reader_unscaled_read (_tmp2_, &_inner_error_);
#line 3174 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp3_;
#line 3174 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3174 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 3174 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (loader);
#line 3174 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 24369 "Photo.c"
		}
#line 3174 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp1_;
#line 3174 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = NULL;
#line 3174 "/home/jens/Source/shotwell/src/Photo.vala"
		result = _tmp4_;
#line 3174 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 3174 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (loader);
#line 3174 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 24383 "Photo.c"
	}
#line 3179 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = *scaling;
#line 3179 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = photo_calculate_pixbuf_dimensions (self, &_tmp5_, exceptions, &_tmp6_, &_tmp7_);
#line 3179 "/home/jens/Source/shotwell/src/Photo.vala"
	scaled_image = _tmp6_;
#line 3179 "/home/jens/Source/shotwell/src/Photo.vala"
	scaled_to_viewport = _tmp7_;
#line 3179 "/home/jens/Source/shotwell/src/Photo.vala"
	is_scaled = _tmp8_;
#line 3181 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = is_scaled;
#line 3181 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp9_) {
#line 24399 "Photo.c"
		GdkPixbuf* _tmp10_ = NULL;
		PhotoFileReader* _tmp11_;
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp13_;
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = loader;
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = photo_file_reader_unscaled_read (_tmp11_, &_inner_error_);
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _tmp12_;
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (loader);
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 24418 "Photo.c"
		}
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp10_;
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = NULL;
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
		result = _tmp13_;
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp10_);
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (loader);
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 24432 "Photo.c"
	}
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = loader;
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_raw_dimensions (self, &_tmp15_);
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = scaled_image;
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = photo_file_reader_scaled_read (_tmp14_, &_tmp15_, &_tmp16_, &_inner_error_);
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	pixbuf = _tmp17_;
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (loader);
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24452 "Photo.c"
	}
#line 3197 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = pixbuf;
#line 3197 "/home/jens/Source/shotwell/src/Photo.vala"
	dimensions_for_pixbuf (_tmp18_, &_tmp19_);
#line 3197 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (dimensions_approx_equals (&scaled_image, &_tmp19_, PHOTO_SCALING_FUDGE), "scaled_image.approx_equals(Dimensions.for_pixbuf(pixbuf), SCALING_FUDGE)");
#line 3199 "/home/jens/Source/shotwell/src/Photo.vala"
	result = pixbuf;
#line 3199 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (loader);
#line 3199 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24466 "Photo.c"
}


GdkPixbuf*
photo_get_master_pixbuf (Photo* self,
                         Scaling* scaling,
                         gboolean rotate,
                         GError** error)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError * _inner_error_ = NULL;
#line 3204 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3204 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 3205 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = *scaling;
#line 3205 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_get_untransformed_pixbuf (self, &_tmp1_, rotate, BACKING_FETCH_MODE_MASTER, &_inner_error_);
#line 3205 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp2_;
#line 3205 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3205 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3205 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24498 "Photo.c"
	}
#line 3205 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp0_;
#line 3205 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 3205 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 3205 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 3205 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24510 "Photo.c"
}


GdkPixbuf*
photo_get_unmodified_pixbuf (Photo* self,
                             Scaling* scaling,
                             gboolean rotate,
                             GError** error)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError * _inner_error_ = NULL;
#line 3209 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3209 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = *scaling;
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_get_untransformed_pixbuf (self, &_tmp1_, rotate, BACKING_FETCH_MODE_UNMODIFIED, &_inner_error_);
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp2_;
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24542 "Photo.c"
	}
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp0_;
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24554 "Photo.c"
}


static GdkPixbuf*
photo_get_untransformed_pixbuf (Photo* self,
                                Scaling* scaling,
                                gboolean rotate,
                                BackingFetchMode fetch_mode,
                                GError** error)
{
	GdkPixbuf* result = NULL;
	Dimensions scaled_image = {0};
	Dimensions scaled_to_viewport = {0};
	Orientation original_orientation = 0;
	GdkPixbuf* pixbuf = NULL;
	Scaling _tmp5_;
	GdkPixbuf* _tmp6_;
	GError * _inner_error_ = NULL;
#line 3214 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3214 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 24577 "Photo.c"
	{
		PhotoRow* _tmp0_;
#line 3228 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 3228 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 24584 "Photo.c"
		{
			Scaling _tmp1_;
			Dimensions _tmp2_ = {0};
			Dimensions _tmp3_ = {0};
#line 3229 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = *scaling;
#line 3229 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_calculate_pixbuf_dimensions (self, &_tmp1_, PHOTO_EXCEPTION_NONE, &_tmp2_, &_tmp3_);
#line 3229 "/home/jens/Source/shotwell/src/Photo.vala"
			scaled_image = _tmp2_;
#line 3229 "/home/jens/Source/shotwell/src/Photo.vala"
			scaled_to_viewport = _tmp3_;
#line 3231 "/home/jens/Source/shotwell/src/Photo.vala"
			original_orientation = photo_get_original_orientation (self);
#line 24599 "Photo.c"
		}
		__finally393:
		{
			PhotoRow* _tmp4_;
#line 3228 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 3228 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 24608 "Photo.c"
		}
#line 3228 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3228 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 3228 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 24616 "Photo.c"
		}
	}
#line 3235 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = *scaling;
#line 3235 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_load_raw_pixbuf (self, &_tmp5_, PHOTO_EXCEPTION_NONE, fetch_mode, &_inner_error_);
#line 3235 "/home/jens/Source/shotwell/src/Photo.vala"
	pixbuf = _tmp6_;
#line 3235 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3235 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3235 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24631 "Photo.c"
	}
#line 3241 "/home/jens/Source/shotwell/src/Photo.vala"
	if (rotate) {
#line 24635 "Photo.c"
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
#line 3242 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = pixbuf;
#line 3242 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = orientation_rotate_pixbuf (original_orientation, _tmp7_);
#line 3242 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (pixbuf);
#line 3242 "/home/jens/Source/shotwell/src/Photo.vala"
		pixbuf = _tmp8_;
#line 24646 "Photo.c"
	}
#line 3251 "/home/jens/Source/shotwell/src/Photo.vala"
	result = pixbuf;
#line 3251 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24652 "Photo.c"
}


static GdkPixbuf*
photo_real_get_pixbuf (PhotoSource* base,
                       Scaling* scaling,
                       GError** error)
{
	Photo * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError * _inner_error_ = NULL;
#line 3254 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 3254 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = *scaling;
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_get_pixbuf_with_options (self, &_tmp1_, PHOTO_EXCEPTION_NONE, BACKING_FETCH_MODE_BASELINE, &_inner_error_);
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp2_;
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24684 "Photo.c"
	}
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp0_;
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24696 "Photo.c"
}


/**
     * One-stop shopping for the source pixbuf cache.
     *
     * The source pixbuf cache holds untransformed, unscaled (full-sized) pixbufs of Photo objects.
     * These can be rather large and shouldn't be held in memory for too long, nor should many be
     * allowed to stack up.
     *
     * If locate is non-null, a source pixbuf is returned for the Photo.  If keep is true, the
     * pixbuf is stored in the cache.  (Thus, passing a Photo w/ keep == false will drop the cached
     * pixbuf.)  If Photo is non-null but keep is false, null is returned.
     *
     * Whether locate is null or not, the cache is walked in its entirety, dropping expired pixbufs
     * and dropping excessive pixbufs from the LRU.  Locating a Photo "touches" the pixbuf, i.e.
     * it moves to the head of the LRU.
     */
static gpointer
_photo_cached_pixbuf_ref0 (gpointer self)
{
#line 3290 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_cached_pixbuf_ref (self) : NULL;
#line 24720 "Photo.c"
}


static gboolean
_photo_trim_source_pixbuf_cache_gsource_func (gpointer self)
{
	gboolean result;
	result = photo_trim_source_pixbuf_cache ();
#line 3342 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24731 "Photo.c"
}


static GdkPixbuf*
photo_run_source_pixbuf_cache (Photo* locate,
                               gboolean keep,
                               GError** error)
{
	GdkPixbuf* result = NULL;
	GError * _inner_error_ = NULL;
#line 3273 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((locate == NULL) || IS_PHOTO (locate), NULL);
#line 24744 "Photo.c"
	{
		GeeLinkedList* _tmp0_;
#line 3274 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_source_pixbuf_cache;
#line 3274 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&__lock_photo_source_pixbuf_cache);
#line 24751 "Photo.c"
		{
			PhotoCachedPixbuf* found = NULL;
			gdouble min_elapsed = 0.0;
			gint count = 0;
			GeeIterator* iter = NULL;
			GeeLinkedList* _tmp1_;
			GeeIterator* _tmp2_;
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_ = FALSE;
			PhotoCachedPixbuf* _tmp25_;
			gboolean _tmp33_ = FALSE;
			PhotoCachedPixbuf* _tmp34_;
			guint _tmp47_;
			GeeLinkedList* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			GdkPixbuf* _tmp55_ = NULL;
			PhotoCachedPixbuf* _tmp56_;
			GdkPixbuf* _tmp59_;
#line 3275 "/home/jens/Source/shotwell/src/Photo.vala"
			found = NULL;
#line 3279 "/home/jens/Source/shotwell/src/Photo.vala"
			min_elapsed = DBL_MAX;
#line 3280 "/home/jens/Source/shotwell/src/Photo.vala"
			count = 0;
#line 3281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_source_pixbuf_cache;
#line 3281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 3281 "/home/jens/Source/shotwell/src/Photo.vala"
			iter = _tmp2_;
#line 3282 "/home/jens/Source/shotwell/src/Photo.vala"
			while (TRUE) {
#line 24785 "Photo.c"
				GeeIterator* _tmp3_;
				PhotoCachedPixbuf* cached_pixbuf = NULL;
				GeeIterator* _tmp4_;
				gpointer _tmp5_;
				gdouble elapsed = 0.0;
				PhotoCachedPixbuf* _tmp6_;
				GTimer* _tmp7_;
				gdouble _tmp8_;
				gboolean _tmp9_ = FALSE;
#line 3282 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = iter;
#line 3282 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!gee_iterator_next (_tmp3_)) {
#line 3282 "/home/jens/Source/shotwell/src/Photo.vala"
					break;
#line 24801 "Photo.c"
				}
#line 3283 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = iter;
#line 3283 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = gee_iterator_get (_tmp4_);
#line 3283 "/home/jens/Source/shotwell/src/Photo.vala"
				cached_pixbuf = (PhotoCachedPixbuf*) _tmp5_;
#line 3285 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = cached_pixbuf;
#line 3285 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_->last_touched;
#line 3285 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = g_timer_elapsed (_tmp7_, NULL);
#line 3285 "/home/jens/Source/shotwell/src/Photo.vala"
				elapsed = trunc (_tmp8_) + 1;
#line 3287 "/home/jens/Source/shotwell/src/Photo.vala"
				if (locate != NULL) {
#line 24819 "Photo.c"
					PhotoCachedPixbuf* _tmp10_;
					Photo* _tmp11_;
#line 3287 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp10_ = cached_pixbuf;
#line 3287 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = _tmp10_->photo;
#line 3287 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp9_ = data_source_equals (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_SOURCE, DataSource), G_TYPE_CHECK_INSTANCE_CAST (locate, TYPE_DATA_SOURCE, DataSource));
#line 24828 "Photo.c"
				} else {
#line 3287 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp9_ = FALSE;
#line 24832 "Photo.c"
				}
#line 3287 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp9_) {
#line 24836 "Photo.c"
					GeeIterator* _tmp12_;
					PhotoCachedPixbuf* _tmp13_;
					PhotoCachedPixbuf* _tmp14_;
					gint _tmp15_;
#line 3289 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = iter;
#line 3289 "/home/jens/Source/shotwell/src/Photo.vala"
					gee_iterator_remove (_tmp12_);
#line 3290 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_ = cached_pixbuf;
#line 3290 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = _photo_cached_pixbuf_ref0 (_tmp13_);
#line 3290 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_cached_pixbuf_unref0 (found);
#line 3290 "/home/jens/Source/shotwell/src/Photo.vala"
					found = _tmp14_;
#line 3293 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = count;
#line 3293 "/home/jens/Source/shotwell/src/Photo.vala"
					count = _tmp15_ + 1;
#line 24857 "Photo.c"
				} else {
					gdouble _tmp16_;
#line 3294 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp16_ = elapsed;
#line 3294 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp16_ >= ((gdouble) PHOTO_SOURCE_PIXBUF_TIME_TO_LIVE_SEC)) {
#line 24864 "Photo.c"
						GeeIterator* _tmp17_;
#line 3295 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp17_ = iter;
#line 3295 "/home/jens/Source/shotwell/src/Photo.vala"
						gee_iterator_remove (_tmp17_);
#line 24870 "Photo.c"
					} else {
						gint _tmp18_;
#line 3296 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp18_ = count;
#line 3296 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp18_ >= PHOTO_SOURCE_PIXBUF_MAX_LRU_COUNT) {
#line 24877 "Photo.c"
							GeeIterator* _tmp19_;
#line 3297 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp19_ = iter;
#line 3297 "/home/jens/Source/shotwell/src/Photo.vala"
							gee_iterator_remove (_tmp19_);
#line 24883 "Photo.c"
						} else {
							gdouble _tmp20_;
							gdouble _tmp21_;
							gint _tmp22_;
#line 3301 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp20_ = elapsed;
#line 3301 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp21_ = min_elapsed;
#line 3301 "/home/jens/Source/shotwell/src/Photo.vala"
							min_elapsed = MIN (_tmp20_, _tmp21_);
#line 3302 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp22_ = count;
#line 3302 "/home/jens/Source/shotwell/src/Photo.vala"
							count = _tmp22_ + 1;
#line 24898 "Photo.c"
						}
					}
				}
#line 3282 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_cached_pixbuf_unref0 (cached_pixbuf);
#line 24904 "Photo.c"
			}
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp25_ = found;
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp25_ == NULL) {
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = locate != NULL;
#line 24912 "Photo.c"
			} else {
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = FALSE;
#line 24916 "Photo.c"
			}
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp24_) {
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = keep;
#line 24922 "Photo.c"
			} else {
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = FALSE;
#line 24926 "Photo.c"
			}
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp23_) {
#line 24930 "Photo.c"
				GdkPixbuf* _tmp26_ = NULL;
				Scaling _tmp27_ = {0};
				GdkPixbuf* _tmp28_;
				PhotoCachedPixbuf* _tmp29_;
#line 3309 "/home/jens/Source/shotwell/src/Photo.vala"
				scaling_for_original (&_tmp27_);
#line 3309 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = photo_load_raw_pixbuf (locate, &_tmp27_, PHOTO_EXCEPTION_ALL, BACKING_FETCH_MODE_SOURCE, &_inner_error_);
#line 3309 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = _tmp28_;
#line 3309 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3309 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (iter);
#line 3309 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_cached_pixbuf_unref0 (found);
#line 24947 "Photo.c"
					goto __finally394;
				}
#line 3308 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = photo_cached_pixbuf_new (locate, _tmp26_);
#line 3308 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_cached_pixbuf_unref0 (found);
#line 3308 "/home/jens/Source/shotwell/src/Photo.vala"
				found = _tmp29_;
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp26_);
#line 24958 "Photo.c"
			} else {
				PhotoCachedPixbuf* _tmp30_;
#line 3310 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = found;
#line 3310 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp30_ != NULL) {
#line 24965 "Photo.c"
					PhotoCachedPixbuf* _tmp31_;
					GTimer* _tmp32_;
#line 3312 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp31_ = found;
#line 3312 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp32_ = _tmp31_->last_touched;
#line 3312 "/home/jens/Source/shotwell/src/Photo.vala"
					g_timer_start (_tmp32_);
#line 24974 "Photo.c"
				}
			}
#line 3316 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp34_ = found;
#line 3316 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp34_ != NULL) {
#line 3316 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = keep;
#line 24983 "Photo.c"
			} else {
#line 3316 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = FALSE;
#line 24987 "Photo.c"
			}
#line 3316 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp33_) {
#line 24991 "Photo.c"
				GeeLinkedList* _tmp35_;
				PhotoCachedPixbuf* _tmp36_;
				PhotoCachedPixbuf* _tmp37_;
				GTimer* _tmp38_;
				gdouble _tmp39_;
				gdouble _tmp40_;
#line 3317 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = photo_source_pixbuf_cache;
#line 3317 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp36_ = found;
#line 3317 "/home/jens/Source/shotwell/src/Photo.vala"
				gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0, _tmp36_);
#line 3322 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp37_ = found;
#line 3322 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_ = _tmp37_->last_touched;
#line 3322 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = g_timer_elapsed (_tmp38_, NULL);
#line 3322 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp40_ = min_elapsed;
#line 3322 "/home/jens/Source/shotwell/src/Photo.vala"
				min_elapsed = MIN (_tmp39_, _tmp40_);
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
				while (TRUE) {
#line 25016 "Photo.c"
					GeeLinkedList* _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					GeeLinkedList* _tmp44_;
					gpointer _tmp45_;
					PhotoCachedPixbuf* _tmp46_;
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp41_ = photo_source_pixbuf_cache;
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp42_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp43_ = _tmp42_;
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
					if (!(_tmp43_ > PHOTO_SOURCE_PIXBUF_MAX_LRU_COUNT)) {
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
						break;
#line 25033 "Photo.c"
					}
#line 3327 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp44_ = photo_source_pixbuf_cache;
#line 3327 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp45_ = gee_deque_poll_tail (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, GEE_TYPE_DEQUE, GeeDeque));
#line 3327 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp46_ = (PhotoCachedPixbuf*) _tmp45_;
#line 3327 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_cached_pixbuf_unref0 (_tmp46_);
#line 25043 "Photo.c"
				}
			}
#line 3331 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp47_ = photo_discard_source_id;
#line 3331 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp47_ != ((guint) 0)) {
#line 25050 "Photo.c"
				guint _tmp48_;
#line 3332 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp48_ = photo_discard_source_id;
#line 3332 "/home/jens/Source/shotwell/src/Photo.vala"
				g_source_remove (_tmp48_);
#line 3333 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_discard_source_id = (guint) 0;
#line 25058 "Photo.c"
			}
#line 3337 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp49_ = photo_source_pixbuf_cache;
#line 3337 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp50_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 3337 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp51_ = _tmp50_;
#line 3337 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp51_ > PHOTO_SOURCE_PIXBUF_MIN_LRU_COUNT) {
#line 25068 "Photo.c"
				gdouble _tmp52_;
				guint retry_sec = 0U;
				gdouble _tmp53_;
				guint _tmp54_;
#line 3338 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp52_ = min_elapsed;
#line 3338 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_assert (_tmp52_ >= 0.0, "min_elapsed >= 0.0");
#line 3341 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp53_ = min_elapsed;
#line 3341 "/home/jens/Source/shotwell/src/Photo.vala"
				retry_sec = PHOTO_SOURCE_PIXBUF_TIME_TO_LIVE_SEC - ((guint) trunc (_tmp53_));
#line 3342 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp54_ = retry_sec;
#line 3342 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_discard_source_id = g_timeout_add_seconds_full (G_PRIORITY_LOW, _tmp54_, _photo_trim_source_pixbuf_cache_gsource_func, NULL, NULL);
#line 25085 "Photo.c"
			}
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp56_ = found;
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp56_ != NULL) {
#line 25091 "Photo.c"
				PhotoCachedPixbuf* _tmp57_;
				GdkPixbuf* _tmp58_;
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp57_ = found;
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp58_ = _tmp57_->pixbuf;
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp55_ = _tmp58_;
#line 25100 "Photo.c"
			} else {
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp55_ = NULL;
#line 25104 "Photo.c"
			}
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp59_ = _g_object_ref0 (_tmp55_);
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp59_;
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (iter);
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_cached_pixbuf_unref0 (found);
#line 25114 "Photo.c"
			{
				GeeLinkedList* _tmp60_;
#line 3274 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp60_ = photo_source_pixbuf_cache;
#line 3274 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&__lock_photo_source_pixbuf_cache);
#line 25121 "Photo.c"
			}
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 25125 "Photo.c"
		}
		__finally394:
		{
			GeeLinkedList* _tmp61_;
#line 3274 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp61_ = photo_source_pixbuf_cache;
#line 3274 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&__lock_photo_source_pixbuf_cache);
#line 25134 "Photo.c"
		}
#line 3274 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3274 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 25140 "Photo.c"
	}
}


static gboolean
photo_trim_source_pixbuf_cache (void)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp1_;
#line 3351 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_run_source_pixbuf_cache (NULL, FALSE, &_inner_error_);
#line 3351 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp0_;
#line 3351 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 3351 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 25161 "Photo.c"
			goto __catch395_g_error;
		}
	}
	goto __finally395;
	__catch395_g_error:
	{
		GError* err = NULL;
#line 3350 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 3350 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 3350 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 25175 "Photo.c"
	}
	__finally395:
#line 3350 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 25180 "Photo.c"
		gboolean _tmp2_ = FALSE;
#line 3350 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 3350 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 3350 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp2_;
#line 25188 "Photo.c"
	}
#line 3355 "/home/jens/Source/shotwell/src/Photo.vala"
	result = FALSE;
#line 3355 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 25194 "Photo.c"
}


/**
     * @brief Get a copy of what's in the cache.
     *
     * @return A copy of the Pixbuf with the image data from unmodified_precached.
     */
GdkPixbuf*
photo_get_prefetched_copy (Photo* self,
                           GError** error)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GError * _inner_error_ = NULL;
#line 3363 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3364 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_run_source_pixbuf_cache (self, TRUE, &_inner_error_);
#line 3364 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp1_;
#line 3364 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3364 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3364 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 25224 "Photo.c"
	}
#line 3364 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = gdk_pixbuf_copy (_tmp0_);
#line 3364 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp2_;
#line 3364 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 3364 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 25234 "Photo.c"
}


/**
     * @brief Discards the cached version of the unmodified image.
     */
void
photo_discard_prefetched (Photo* self)
{
	GError * _inner_error_ = NULL;
#line 3370 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 25247 "Photo.c"
	{
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp1_;
#line 3372 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_run_source_pixbuf_cache (self, FALSE, &_inner_error_);
#line 3372 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp0_;
#line 3372 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 3372 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 25259 "Photo.c"
			goto __catch396_g_error;
		}
	}
	goto __finally396;
	__catch396_g_error:
	{
		GError* err = NULL;
#line 3371 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 3371 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 3371 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 25273 "Photo.c"
	}
	__finally396:
#line 3371 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3371 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 3371 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 3371 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 25284 "Photo.c"
	}
}


/**
     * @brief Returns a fully transformed and scaled pixbuf.  Transformations may be excluded via
     * the mask. If the image is smaller than the scaling, it will be returned in its actual size.
     * The caller is responsible for scaling thereafter.
     *
     * @param scaling A scaling object that describes the size the output pixbuf should be.
     * @param exceptions The parts of the pipeline that should be skipped; defaults to NONE if
     *      left unset.
     * @param fetch_mode The fetch mode; if left unset, defaults to BASELINE so that
     *      we get the image exactly as it is in the file.
     */
GdkPixbuf*
photo_get_pixbuf_with_options (Photo* self,
                               Scaling* scaling,
                               PhotoException exceptions,
                               BackingFetchMode fetch_mode,
                               GError** error)
{
	GdkPixbuf* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean is_scaled = FALSE;
	gboolean is_cropped = FALSE;
	gboolean is_straightened = FALSE;
	Dimensions scaled_to_viewport = {0};
	Dimensions original = {0};
	Dimensions scaled = {0};
	EditingToolsRedeyeInstance* redeye_instances = NULL;
	gint redeye_instances_length1;
	gint _redeye_instances_size_;
	Box crop = {0};
	gdouble straightening_angle = 0.0;
	PixelTransformer* transformer = NULL;
	Orientation orientation = 0;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp22_;
	gboolean _tmp64_;
	gboolean _tmp74_ = FALSE;
	gboolean _tmp75_;
	GError * _inner_error_ = NULL;
#line 3388 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3388 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 3401 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_get_develop_raw_photos_to_files ();
#line 3401 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp3_;
#line 3401 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp4_) {
#line 3402 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = photo_get_master_file_format (self) == PHOTO_FILE_FORMAT_RAW;
#line 25344 "Photo.c"
	} else {
#line 3401 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = FALSE;
#line 25348 "Photo.c"
	}
#line 3401 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_) {
#line 25352 "Photo.c"
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 3403 "/home/jens/Source/shotwell/src/Photo.vala"
		if (fetch_mode == BACKING_FETCH_MODE_BASELINE) {
#line 3403 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = TRUE;
#line 25359 "Photo.c"
		} else {
#line 3403 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = fetch_mode == BACKING_FETCH_MODE_UNMODIFIED;
#line 25363 "Photo.c"
		}
#line 3403 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp6_) {
#line 3403 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = TRUE;
#line 25369 "Photo.c"
		} else {
#line 3404 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = fetch_mode == BACKING_FETCH_MODE_SOURCE;
#line 25373 "Photo.c"
		}
#line 3403 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp5_;
#line 25377 "Photo.c"
	} else {
#line 3401 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = FALSE;
#line 25381 "Photo.c"
	}
#line 3401 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_) {
#line 3405 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = !photo_is_raw_developer_complete (self, photo_get_raw_developer (self));
#line 25387 "Photo.c"
	} else {
#line 3401 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = FALSE;
#line 25391 "Photo.c"
	}
#line 3401 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_) {
#line 3406 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_set_raw_developer (self, photo_get_raw_developer (self), TRUE);
#line 25397 "Photo.c"
	}
#line 3411 "/home/jens/Source/shotwell/src/Photo.vala"
	dimensions_init (&original, 0, 0);
#line 3412 "/home/jens/Source/shotwell/src/Photo.vala"
	dimensions_init (&scaled, 0, 0);
#line 3413 "/home/jens/Source/shotwell/src/Photo.vala"
	redeye_instances = NULL;
#line 3413 "/home/jens/Source/shotwell/src/Photo.vala"
	redeye_instances_length1 = 0;
#line 3413 "/home/jens/Source/shotwell/src/Photo.vala"
	_redeye_instances_size_ = redeye_instances_length1;
#line 3416 "/home/jens/Source/shotwell/src/Photo.vala"
	transformer = NULL;
#line 25411 "Photo.c"
	{
		PhotoRow* _tmp7_;
#line 3419 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = self->row;
#line 3419 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 25418 "Photo.c"
		{
			Dimensions _tmp8_ = {0};
			Dimensions _tmp9_ = {0};
			Dimensions _tmp10_ = {0};
			Dimensions _tmp11_;
			Dimensions _tmp12_ = {0};
			Dimensions _tmp13_;
			gint _tmp14_;
			EditingToolsRedeyeInstance* _tmp15_;
			Box _tmp16_ = {0};
			gboolean _tmp17_;
			gdouble _tmp18_ = 0.0;
			gboolean _tmp19_;
#line 3420 "/home/jens/Source/shotwell/src/Photo.vala"
			media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_ALL, &_tmp8_);
#line 3420 "/home/jens/Source/shotwell/src/Photo.vala"
			original = _tmp8_;
#line 3421 "/home/jens/Source/shotwell/src/Photo.vala"
			media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), exceptions, &_tmp9_);
#line 3421 "/home/jens/Source/shotwell/src/Photo.vala"
			scaling_get_scaled_dimensions (scaling, &_tmp9_, &_tmp10_);
#line 3421 "/home/jens/Source/shotwell/src/Photo.vala"
			scaled = _tmp10_;
#line 3422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = scaled;
#line 3422 "/home/jens/Source/shotwell/src/Photo.vala"
			scaled_to_viewport = _tmp11_;
#line 3424 "/home/jens/Source/shotwell/src/Photo.vala"
			media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp12_);
#line 3424 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = scaled;
#line 3424 "/home/jens/Source/shotwell/src/Photo.vala"
			is_scaled = !dimensions_equals (&_tmp12_, &_tmp13_);
#line 3426 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = photo_get_raw_redeye_instances (self, &_tmp14_);
#line 3426 "/home/jens/Source/shotwell/src/Photo.vala"
			redeye_instances = (g_free (redeye_instances), NULL);
#line 3426 "/home/jens/Source/shotwell/src/Photo.vala"
			redeye_instances = _tmp15_;
#line 3426 "/home/jens/Source/shotwell/src/Photo.vala"
			redeye_instances_length1 = _tmp14_;
#line 3426 "/home/jens/Source/shotwell/src/Photo.vala"
			_redeye_instances_size_ = redeye_instances_length1;
#line 3428 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = photo_get_raw_crop (self, &_tmp16_);
#line 3428 "/home/jens/Source/shotwell/src/Photo.vala"
			crop = _tmp16_;
#line 3428 "/home/jens/Source/shotwell/src/Photo.vala"
			is_cropped = _tmp17_;
#line 3430 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = photo_get_raw_straighten (self, &_tmp18_);
#line 3430 "/home/jens/Source/shotwell/src/Photo.vala"
			straightening_angle = _tmp18_;
#line 3430 "/home/jens/Source/shotwell/src/Photo.vala"
			is_straightened = _tmp19_;
#line 3432 "/home/jens/Source/shotwell/src/Photo.vala"
			if (photo_has_color_adjustments (self)) {
#line 25476 "Photo.c"
				PixelTransformer* _tmp20_;
#line 3433 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = photo_get_pixel_transformer (self);
#line 3433 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (transformer);
#line 3433 "/home/jens/Source/shotwell/src/Photo.vala"
				transformer = _tmp20_;
#line 25484 "Photo.c"
			}
#line 3435 "/home/jens/Source/shotwell/src/Photo.vala"
			orientation = photo_get_orientation (self);
#line 25488 "Photo.c"
		}
		__finally397:
		{
			PhotoRow* _tmp21_;
#line 3419 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp21_ = self->row;
#line 3419 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 25497 "Photo.c"
		}
#line 3419 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3419 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 3419 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformer_unref0 (transformer);
#line 3419 "/home/jens/Source/shotwell/src/Photo.vala"
			redeye_instances = (g_free (redeye_instances), NULL);
#line 3419 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 25509 "Photo.c"
		}
	}
#line 3442 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = photo_get_prefetched_copy (self, &_inner_error_);
#line 3442 "/home/jens/Source/shotwell/src/Photo.vala"
	pixbuf = _tmp22_;
#line 3442 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3442 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3442 "/home/jens/Source/shotwell/src/Photo.vala"
		_pixel_transformer_unref0 (transformer);
#line 3442 "/home/jens/Source/shotwell/src/Photo.vala"
		redeye_instances = (g_free (redeye_instances), NULL);
#line 3442 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 25526 "Photo.c"
	}
#line 3449 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_REDEYE)) {
#line 25530 "Photo.c"
		EditingToolsRedeyeInstance* _tmp23_;
		gint _tmp23__length1;
#line 3454 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = redeye_instances;
#line 3454 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23__length1 = redeye_instances_length1;
#line 25537 "Photo.c"
		{
			EditingToolsRedeyeInstance* instance_collection = NULL;
			gint instance_collection_length1 = 0;
			gint _instance_collection_size_ = 0;
			gint instance_it = 0;
#line 3454 "/home/jens/Source/shotwell/src/Photo.vala"
			instance_collection = _tmp23_;
#line 3454 "/home/jens/Source/shotwell/src/Photo.vala"
			instance_collection_length1 = _tmp23__length1;
#line 3454 "/home/jens/Source/shotwell/src/Photo.vala"
			for (instance_it = 0; instance_it < _tmp23__length1; instance_it = instance_it + 1) {
#line 25549 "Photo.c"
				EditingToolsRedeyeInstance instance = {0};
#line 3454 "/home/jens/Source/shotwell/src/Photo.vala"
				instance = instance_collection[instance_it];
#line 25553 "Photo.c"
				{
					GdkPixbuf* _tmp24_;
					EditingToolsRedeyeInstance _tmp25_;
					GdkPixbuf* _tmp26_;
#line 3455 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp24_ = pixbuf;
#line 3455 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp25_ = instance;
#line 3455 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp26_ = photo_do_redeye (self, _tmp24_, &_tmp25_);
#line 3455 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pixbuf);
#line 3455 "/home/jens/Source/shotwell/src/Photo.vala"
					pixbuf = _tmp26_;
#line 25568 "Photo.c"
				}
			}
		}
	}
#line 3463 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_STRAIGHTEN)) {
#line 25575 "Photo.c"
		gboolean _tmp27_;
#line 3467 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp27_ = is_straightened;
#line 3467 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp27_) {
#line 25581 "Photo.c"
			GdkPixbuf* _tmp28_;
			gdouble _tmp29_;
			GdkPixbuf* _tmp30_;
#line 3468 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp28_ = pixbuf;
#line 3468 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp29_ = straightening_angle;
#line 3468 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp30_ = rotate_arb (_tmp28_, _tmp29_);
#line 3468 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (pixbuf);
#line 3468 "/home/jens/Source/shotwell/src/Photo.vala"
			pixbuf = _tmp30_;
#line 25595 "Photo.c"
		}
	}
#line 3477 "/home/jens/Source/shotwell/src/Photo.vala"
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_CROP)) {
#line 25600 "Photo.c"
		gboolean _tmp31_;
#line 3481 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp31_ = is_cropped;
#line 3481 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp31_) {
#line 25606 "Photo.