/*
 * This file is part of roccat-tools.
 *
 * roccat-tools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Macro Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * roccat-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Macro Public License for more details.
 *
 * You should have received a copy of the GNU Macro Public License
 * along with roccat-tools. If not, see <http://www.gnu.org/licenses/>.
 */

#include "ryosmkfx.h"

/* least significant byte is pwm value, lower nibble of higher byte is brightness */
static guint16 const rgb_to_hardware[256] = {
	/*   0 */	0xf00, 0x001, 0x002, 0x003, 0x004, 0x005, 0x006, 0x007, 0x008, 0x009, 0x00a, 0x00b, 0x00c, 0x00d, 0x00e, 0x00f,
	/*  16 */	0x010, 0x011, 0x012, 0x013, 0x014, 0x015, 0x016, 0x017, 0x018, 0x019, 0x01a, 0x01b, 0x01c, 0x01d, 0x01e, 0x01f,
	/*  32 */	0x020, 0x021, 0x022, 0x023, 0x024, 0x025, 0x026, 0x027, 0x028, 0x029, 0x02a, 0x02b, 0x02c, 0x02d, 0x02e, 0x02f,
	/*  48 */	0x030, 0x031, 0x032, 0x033, 0x034, 0x035, 0x036, 0x037, 0x038, 0x039, 0x03a, 0x03b, 0x03c, 0x03d, 0x03e, 0x03f,
	/*  64 */	0x120, 0x40d, 0x121, 0x122, 0x217, 0x123, 0x124, 0x125, 0x219, 0x126, 0x60b, 0x127, 0x128, 0x21b, 0x129, 0x12a,
	/*  80 */	0x411, 0x12b, 0x21d, 0x12c, 0x12d, 0x60d, 0x12e, 0x413, 0x131, 0x221, 0x133, 0x134, 0x136, 0x137, 0x138, 0x417,
	/*  96 */	0x13b, 0x13c, 0x229, 0x13f, 0x22b, 0x22c, 0x22d, 0x22e, 0x323, 0xa0d, 0x231, 0x232, 0x326, 0x41f, 0x235, 0x236,
	/* 112 */	0x237, 0x238, 0x239, 0x423, 0x23b, 0x61a, 0x425, 0x32f, 0x330, 0x331, 0x332, 0x61d, 0x817, 0x42a, 0x42b, 0x61f,
	/* 128 */	0xc11, 0x42d, 0x339, 0x33a, 0x33b, 0x33c, 0x431, 0x33e, 0xa17, 0x720, 0x81d, 0x435, 0x436, 0x627, 0x81f, 0x52f,
	/* 144 */	0x629, 0x43a, 0x725, 0x43c, 0x43d, 0x43e, 0x43f, 0x535, 0x62e, 0x729, 0x825, 0xc1a, 0x539, 0x53a, 0x72c, 0x633,
	/* 160 */	0xa21, 0x53d, 0x53e, 0xc1d, 0x926, 0x82b, 0x638, 0x82c, 0xc1f, 0x733, 0x63b, 0xa26, 0x735, 0xa27, 0xe1d, 0x737,
	/* 176 */	0xb25, 0xa29, 0x739, 0xa2a, 0x834, 0xa2b, 0x73c, 0x836, 0xb29, 0x73e, 0x73f, 0x933, 0xb2b, 0x83a, 0xa30, 0xc29,
	/* 192 */	0x83c, 0xc2a, 0xb2e, 0xc2b, 0xb2f, 0xa34, 0xb30, 0xc2d, 0x93b, 0xc2e, 0xa37, 0x93d, 0xa38, 0xb34, 0x93f, 0xc31,
	/* 208 */	0xd2e, 0xc32, 0xd2f, 0xc33, 0xa3d, 0xc34, 0xd31, 0xa3f, 0xd32, 0xb3b, 0xd33, 0xb3c, 0xc38, 0xf2e, 0xb3e, 0xe32,
	/* 224 */	0xb3f, 0xe33, 0xd37, 0xc3c, 0xd38, 0xe35, 0xc3e, 0xe36, 0xc3f, 0xd3b, 0xf34, 0xd3c, 0xf35, 0xe39, 0xf36, 0xd3e,
	/* 240 */	0xe3a, 0xf37, 0xd3f, 0xe3b, 0xf38, 0xe3c, 0xf39, 0xe3d, 0xf3a, 0xe3e, 0xf3b, 0xe3f, 0xf3c, 0xf3d, 0xf3e, 0xf3f,
};

guint16 ryosmkfx_color_to_hardware(guint8 color) {
	return rgb_to_hardware[color];
}

static guint8 const level_to_rgb[1009] =  {
	/*   0 */	  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
	/*  20 */	 20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,
	/*  40 */	 40,  41,  42,  43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
	/*  60 */	 60,  61,  62,  63,  64,  65,  66,  66,  67,  68,  69,  69,  70,  70,  71,  72,  73,  74,  75,  75,
	/*  80 */	 76,  77,  78,  78,  79,  80,  81,  82,  83,  83,  84,  85,  86,  86,  87,  87,  87,  88,  88,  89,
	/* 100 */	 89,  90,  90,  90,  91,  91,  91,  92,  92,  92,  93,  93,  94,  94,  95,  95,  95,  96,  96,  96,
	/* 120 */	 97,  97,  98,  98,  98,  99,  99,  99, 100, 100, 100, 101, 101, 101, 102, 102, 102, 103, 103, 103,
	/* 140 */	104, 104, 105, 105, 105, 105, 106, 106, 106, 107, 107, 107, 108, 108, 109, 109, 109, 109, 110, 110,
	/* 160 */	110, 111, 111, 111, 112, 112, 112, 113, 113, 113, 114, 114, 114, 114, 115, 115, 115, 116, 116, 116,
	/* 180 */	117, 117, 117, 117, 118, 118, 118, 119, 119, 119, 119, 120, 120, 120, 120, 121, 121, 121, 121, 122,
	/* 200 */	122, 122, 123, 123, 123, 123, 124, 124, 124, 125, 125, 125, 125, 126, 126, 126, 126, 127, 127, 127,
	/* 220 */	128, 128, 128, 128, 129, 129, 129, 130, 130, 130, 130, 131, 131, 131, 131, 132, 132, 132, 132, 133,
	/* 240 */	133, 133, 133, 134, 134, 134, 134, 135, 135, 135, 135, 136, 136, 136, 136, 137, 137, 137, 137, 138,
	/* 260 */	138, 138, 138, 138, 139, 139, 139, 139, 140, 140, 140, 140, 141, 141, 141, 141, 141, 142, 142, 142,
	/* 280 */	142, 143, 143, 143, 143, 144, 144, 144, 144, 145, 145, 145, 145, 145, 146, 146, 146, 146, 146, 147,
	/* 300 */	147, 147, 147, 148, 148, 148, 148, 148, 149, 149, 149, 149, 149, 150, 150, 150, 150, 151, 151, 151,
	/* 320 */	151, 152, 152, 152, 152, 152, 153, 153, 153, 153, 153, 154, 154, 154, 154, 154, 155, 155, 155, 155,
	/* 340 */	155, 156, 156, 156, 156, 156, 157, 157, 157, 157, 157, 158, 158, 158, 158, 159, 159, 159, 159, 159,
	/* 360 */	159, 160, 160, 160, 160, 161, 161, 161, 161, 161, 162, 162, 162, 162, 162, 163, 163, 163, 163, 164,
	/* 380 */	164, 164, 164, 164, 165, 165, 165, 165, 165, 165, 166, 166, 166, 166, 166, 167, 167, 167, 167, 167,
	/* 400 */	168, 168, 168, 168, 168, 168, 169, 169, 169, 169, 169, 170, 170, 170, 170, 170, 171, 171, 171, 171,
	/* 420 */	171, 171, 172, 172, 172, 172, 172, 173, 173, 173, 173, 173, 173, 174, 174, 174, 174, 174, 175, 175,
	/* 440 */	175, 175, 175, 176, 176, 176, 176, 176, 177, 177, 177, 177, 177, 177, 178, 178, 178, 178, 178, 178,
	/* 460 */	179, 179, 179, 179, 179, 179, 180, 180, 180, 180, 180, 181, 181, 181, 181, 181, 181, 182, 182, 182,
	/* 480 */	182, 182, 182, 182, 183, 183, 183, 183, 183, 183, 184, 184, 184, 184, 184, 185, 185, 185, 185, 185,
	/* 500 */	185, 186, 186, 186, 186, 186, 186, 186, 187, 187, 187, 187, 187, 187, 188, 188, 188, 188, 188, 188,
	/* 520 */	189, 189, 189, 189, 189, 189, 190, 190, 190, 190, 190, 191, 191, 191, 191, 191, 191, 192, 192, 192,
	/* 540 */	192, 192, 192, 192, 193, 193, 193, 193, 193, 193, 194, 194, 194, 194, 194, 194, 195, 195, 195, 195,
	/* 560 */	195, 195, 196, 196, 196, 196, 196, 196, 196, 197, 197, 197, 197, 197, 197, 198, 198, 198, 198, 198,
	/* 580 */	198, 199, 199, 199, 199, 199, 199, 199, 200, 200, 200, 200, 200, 200, 200, 201, 201, 201, 201, 201,
	/* 600 */	201, 201, 202, 202, 202, 202, 202, 202, 203, 203, 203, 203, 203, 203, 204, 204, 204, 204, 204, 204,
	/* 620 */	204, 205, 205, 205, 205, 205, 205, 205, 206, 206, 206, 206, 206, 206, 207, 207, 207, 207, 207, 207,
	/* 640 */	207, 208, 208, 208, 208, 208, 208, 208, 209, 209, 209, 209, 209, 209, 209, 210, 210, 210, 210, 210,
	/* 660 */	210, 211, 211, 211, 211, 211, 211, 211, 212, 212, 212, 212, 212, 212, 213, 213, 213, 213, 213, 213,
	/* 680 */	213, 213, 214, 214, 214, 214, 214, 214, 214, 214, 215, 215, 215, 215, 215, 215, 215, 216, 216, 216,
	/* 700 */	216, 216, 216, 216, 216, 217, 217, 217, 217, 217, 217, 217, 218, 218, 218, 218, 218, 218, 219, 219,
	/* 720 */	219, 219, 219, 219, 219, 220, 220, 220, 220, 220, 220, 220, 220, 221, 221, 221, 221, 221, 221, 221,
	/* 740 */	221, 222, 222, 222, 222, 222, 222, 222, 223, 223, 223, 223, 223, 223, 224, 224, 224, 224, 224, 224,
	/* 760 */	224, 225, 225, 225, 225, 225, 225, 225, 226, 226, 226, 226, 226, 226, 226, 226, 227, 227, 227, 227,
	/* 780 */	227, 227, 227, 228, 228, 228, 228, 228, 228, 228, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
	/* 800 */	229, 230, 230, 230, 230, 230, 230, 230, 230, 231, 231, 231, 231, 231, 231, 232, 232, 232, 232, 232,
	/* 820 */	232, 232, 232, 233, 233, 233, 233, 233, 233, 233, 234, 234, 234, 234, 234, 234, 234, 235, 235, 235,
	/* 840 */	235, 235, 235, 235, 235, 236, 236, 236, 236, 236, 236, 236, 237, 237, 237, 237, 237, 237, 237, 237,
	/* 860 */	238, 238, 238, 238, 238, 238, 238, 239, 239, 239, 240, 240, 240, 240, 240, 240, 241, 241, 241, 241,
	/* 880 */	241, 241, 242, 242, 243, 243, 243, 243, 243, 243, 243, 244, 244, 244, 244, 244, 244, 244, 244, 245,
	/* 900 */	245, 245, 245, 245, 245, 245, 245, 246, 246, 246, 246, 246, 246, 246, 247, 247, 247, 247, 247, 247,
	/* 920 */	247, 247, 248, 248, 248, 248, 248, 248, 248, 248, 249, 249, 249, 249, 249, 249, 249, 249, 250, 250,
	/* 940 */	250, 250, 250, 250, 250, 251, 251, 251, 251, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 252,
	/* 960 */	252, 252, 252, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
	/* 980 */	253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
	/* 1000 */	254, 255, 255, 255, 255, 255, 255, 255, 255,
};

guint8 ryosmkfx_hardware_to_color(guint16 hardware) {
	guint8 pwm = ryosmkfx_hardware_color_get_pwm(hardware);
	guint8 brightness = ryosmkfx_hardware_color_get_brightness(hardware);
	guint level = pwm * (brightness + 1);

	return level_to_rgb[level];
}
