#ifndef __ROCCAT_NYTH_SPECIAL_H__
#define __ROCCAT_NYTH_SPECIAL_H__

/*
 * This file is part of roccat-tools.
 *
 * roccat-tools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * roccat-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with roccat-tools. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>

G_BEGIN_DECLS

typedef struct _NythSpecial NythSpecial;

struct _NythSpecial {
	guint8 report_id; /* NYTH_REPORT_ID_SPECIAL */
	guint8 unused;
	guint8 type;
	guint8 data1;
	guint8 data2;
} __attribute__ ((packed));

typedef enum {
	/* profile_number, 0 */
	NYTH_SPECIAL_TYPE_PROFILE = 0x20,
	/* 1, 0 */
	NYTH_SPECIAL_TYPE_TCU = 0x30,
	/* button_number, action */
	NYTH_SPECIAL_TYPE_OPEN_APPLICATION = 0x60,
	/* button_number, action */
	NYTH_SPECIAL_TYPE_TIMER_START = 0x80,
	/* 0, action */
	NYTH_SPECIAL_TYPE_TIMER_STOP = 0x90,
	/* action, 0 */
	NYTH_SPECIAL_TYPE_OPEN_DRIVER = 0xa0,
	/* cpi_number, 0 */
	NYTH_SPECIAL_TYPE_CPI = 0xb0,
	/* x_sensitivity_number, y_sensitivity_number */
	NYTH_SPECIAL_TYPE_SENSITIVITY = 0xc0,
	/* subtype, action */
	NYTH_SPECIAL_TYPE_MULTIMEDIA = 0xf0,
	/* subtype, action */
	NYTH_SPECIAL_TYPE_WINDOWS = 0xf2,
	/* subtype, button_number */
	NYTH_SPECIAL_TYPE_OPEN = 0xf3,
	/* button_number, action */
	NYTH_SPECIAL_TYPE_EASYSHIFT = 0xff,

} NythSpecialType;

typedef enum {
	NYTH_SPECIAL_SUBTYPE_MULTIMEDIA_PREV_TRACK = 0x21,
	NYTH_SPECIAL_SUBTYPE_MULTIMEDIA_NEXT_TRACK = 0x22,
	NYTH_SPECIAL_SUBTYPE_MULTIMEDIA_PLAY_PAUSE = 0x23,
	NYTH_SPECIAL_SUBTYPE_MULTIMEDIA_STOP = 0x24,
	NYTH_SPECIAL_SUBTYPE_MULTIMEDIA_MUTE_MASTER = 0x25,
	NYTH_SPECIAL_SUBTYPE_MULTIMEDIA_VOLUME_UP = 0x26,
	NYTH_SPECIAL_SUBTYPE_MULTIMEDIA_VOLUME_DOWN = 0x27,
} NythSpecialSubtypeMultimedia;

typedef enum {
	NYTH_SPECIAL_SUBTYPE_WINDOWS_MUTE_MICROPHONE = 0x01,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FOLDER_DESKTOP = 0x02,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FOLDER_FAVORITES = 0x03,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FOLDER_FONTS = 0x04,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FOLDER_MY_DOCUMENTS = 0x05,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FOLDER_MY_DOWNLOADS = 0x06,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FOLDER_MY_MUSIC = 0x07,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FOLDER_MY_PICTURES = 0x08,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FOLDER_NETWORK = 0x09,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FOLDER_PRINTERS = 0x0a,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FOLDER_SYSTEM = 0x0b,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_CONTROL_PANEL = 0x20,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_SYSTEM_PANEL = 0x21,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_TASK_MANAGER = 0x22,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_SCREEN_SETTINGS = 0x23,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_SCREENSAVER = 0x24,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_THEMES = 0x25,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_DATE_TIME = 0x26,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_NETWORK_SETTINGS = 0x27,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_ADMIN_PANEL = 0x28,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_FIREWALL = 0x29,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_REGEDIT = 0x2a,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_EVENT_MONITOR = 0x2b,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_PERFORMANCE_MONITOR = 0x2c,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_SOUND_SETTINGS = 0x2d,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_INTERNET_SETTINGS = 0x2e,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_DIREKTX_DIAG = 0x2f,
	NYTH_SPECIAL_SUBTYPE_WINDOWS_FUNCTION_COMMAND_LINE = 0x30,
} NythSpecialSubtypeWindows;

typedef enum {
	NYTH_SPECIAL_SUBTYPE_OPEN_DOCUMENT = 0x01,
	NYTH_SPECIAL_SUBTYPE_OPEN_FOLDER = 0x02,
	NYTH_SPECIAL_SUBTYPE_OPEN_WEBSITE = 0x03,
} NythSpecialSubtypeOpen;

typedef enum {
	NYTH_SPECIAL_ACTION_PRESS = 0x00,
	NYTH_SPECIAL_ACTION_RELEASE = 0x01,
} NythSpecialAction;

#endif
