// AsmJit - Machine code generation for C++
//
//  * Official AsmJit Home Page: https://asmjit.com
//  * Official Github Repository: https://github.com/asmjit/asmjit
//
// Copyright (c) 2008-2020 The AsmJit Authors
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 3. This notice may not be removed or altered from any source distribution.

#ifndef ASMJIT_CORE_ARCH_H_INCLUDED
#define ASMJIT_CORE_ARCH_H_INCLUDED

#include "../core/environment.h"
#include "../core/operand.h"

ASMJIT_BEGIN_NAMESPACE

//! \addtogroup asmjit_core
//! \{

// ============================================================================
// [asmjit::ArchRegs]
// ============================================================================

//! Information about registers of a CPU architecture.
struct ArchRegs {
  //! Register information and signatures indexed by `BaseReg::RegType`.
  RegInfo regInfo[BaseReg::kTypeMax + 1];
  //! Count (maximum) of registers per `BaseReg::RegType`.
  uint8_t regCount[BaseReg::kTypeMax + 1];
  //! Converts RegType to TypeId, see `Type::Id`.
  uint8_t regTypeToTypeId[BaseReg::kTypeMax + 1];
};

// ============================================================================
// [asmjit::ArchUtils]
// ============================================================================

//! Architecture utilities.
namespace ArchUtils {

ASMJIT_API Error typeIdToRegInfo(uint32_t arch, uint32_t typeId, uint32_t* typeIdOut, RegInfo* regInfo) noexcept;

} // {ArchUtils}

//! \}

ASMJIT_END_NAMESPACE

#endif // ASMJIT_CORE_ARCH_H_INCLUDED
