﻿/* Premake's Lua scripts, as static data buffers for release mode builds */
/* DO NOT EDIT - this file is autogenerated - see BUILD.txt */
/* To regenerate this file, run: premake4 embed */ 

const char* builtin_scripts[] = {
	/* base/os.lua */
	"function os.executef(cmd, ...)\nlocal arg={...}\ncmd = string.format(cmd, table.unpack(arg))\nreturn os.execute(cmd)\nend\nlocal function parse_ld_so_conf(conf_file)\nlocal first, last\nlocal dirs = { }\nlocal file = io.open(conf_file)\nif file == nil then\nreturn dirs\nend\nfor line in file:lines() do\nfirst = line:find(\"#\", 1, true)\nif first ~= nil then\nline = line:sub(1, first - 1)\nend\nif line ~= \"\" then\nfirst, last = line:find(\"include%s+\")\nif first ~= nil then\nlocal include_glob = line:sub(last + 1)\nlocal includes = os.matchfiles(include_glob)\nfor _, v in ipairs(includes) do\ndirs = table.join(dirs, parse_ld_so_conf(v))\nend\nelse\ntable.insert(dirs, line)\nend\nend\nend\nreturn dirs\nend\nfunction os.findlib(libname)\nlocal path, formats\nif os.is(\"windows\") then\nformats = { \"%s.dll\", \"%s\" }\npath = os.getenv(\"PATH\")\nelse\nif os.is(\"macosx\") then\nformats = { \"lib%s.dylib\", \"%s.dylib\" }\npath = os.getenv(\"DYLD_LIBRARY_PATH\")\nelse\nformats = { \"lib%s.so\", \"%s.so\" }\np"
	"ath = os.getenv(\"LD_LIBRARY_PATH\") or \"\"\nfor _, v in ipairs(parse_ld_so_conf(\"/etc/ld.so.conf\")) do\npath = path .. \":\" .. v\nend\nend\ntable.insert(formats, \"%s\")\npath = path or \"\"\nif os.is64bit() then\npath = path .. \":/lib64:/usr/lib64/:usr/local/lib64\"\nend\npath = path .. \":/lib:/usr/lib:/usr/local/lib\"\nend\nfor _, fmt in ipairs(formats) do\nlocal name = string.format(fmt, libname)\nlocal result = os.pathsearch(name, path)\nif result then return result end\nend\nend\nfunction os.get()\nreturn _OPTIONS.os or _OS\nend\nfunction os.is(id)\nreturn (os.get():lower() == id:lower())\nend\nlocal _64BitHostTypes = {\n\"x86_64\",\n\"ia64\",\n\"amd64\",\n\"ppc64\",\n\"powerpc64\",\n\"sparc64\"\n}\nfunction os.is64bit()\nif (os._is64bit()) then\nreturn true\nend\nlocal arch\nif _OS == \"windows\" then\narch = os.getenv(\"PROCESSOR_ARCHITECTURE\")\nelseif _OS == \"macosx\" then\narch = os.outputof(\"echo $HOSTTYPE\")\nelse\narch = os.outputof(\"uname -m\")\nend\narch = arch:lower()\nfor _, hosttype"
	" in ipairs(_64BitHostTypes) do\nif arch:find(hosttype) then\nreturn true\nend\nend\nreturn false\nend\nlocal function domatch(result, mask, wantfiles)\nif mask:startswith(\"./\") then\nmask = mask:sub(3)\nend\nlocal basedir = mask\nlocal starpos = mask:find(\"%*\")\nif starpos then\nbasedir = basedir:sub(1, starpos - 1)\nend\nbasedir = path.getdirectory(basedir)\nif (basedir == \".\") then basedir = \"\" end\nlocal recurse = mask:find(\"**\", nil, true)\nmask = path.wildcards(mask)\nlocal function matchwalker(basedir)\nlocal wildcard = path.join(basedir, \"*\")\nlocal m = os.matchstart(wildcard)\nwhile (os.matchnext(m)) do\nlocal isfile = os.matchisfile(m)\nif ((wantfiles and isfile) or (not wantfiles and not isfile)) then\nlocal fname = path.join(basedir, os.matchname(m))\nif fname:match(mask) == fname then\ntable.insert(result, fname)\nend\nend\nend\nos.matchdone(m)\nif recurse then\nm = os.matchstart(wildcard)\nwhile (os.matchnext(m)) do\nif not os.matchisfile(m) then\nlocal dirname = os.matchname(m)\nmatch"
	"walker(path.join(basedir, dirname))\nend\nend\nos.matchdone(m)\nend\nend\nmatchwalker(basedir)\nend\nfunction os.matchdirs(...)\nlocal arg={...}\nlocal result = { }\nfor _, mask in ipairs(arg) do\ndomatch(result, mask, false)\nend\nreturn result\nend\nfunction os.matchfiles(...)\nlocal arg={...}\nlocal result = { }\nfor _, mask in ipairs(arg) do\ndomatch(result, mask, true)\nend\nreturn result\nend\nlocal builtin_mkdir = os.mkdir\nfunction os.mkdir(p)\nlocal dir = iif(p:startswith(\"/\"), \"/\", \"\")\nfor part in p:gmatch(\"[^/]+\") do\ndir = dir .. part\nif (part ~= \"\" and not path.isabsolute(part) and not os.isdir(dir)) then\nlocal ok, err = builtin_mkdir(dir)\nif (not ok) then\nreturn nil, err\nend\nend\ndir = dir .. \"/\"\nend\nreturn true\nend\nfunction os.outputof(cmd)\nlocal pipe = io.popen(cmd)\nlocal result = pipe:read('*a')\npipe:close()\nreturn result\nend\nlocal builtin_rmdir = os.rmdir\nfunction os.rmdir(p)\nlocal dirs = os.matchdirs(p .. \"/*\")\nfor _, dname in ipairs(dirs) do\nos.rmdir(dname"
	")\nend\nlocal files = os.matchfiles(p .. \"/*\")\nfor _, fname in ipairs(files) do\nos.remove(fname)\nend\nbuiltin_rmdir(p)\nend\n",

	/* base/path.lua */
	"function path.getbasename(p)\nlocal name = path.getname(p)\nlocal i = name:findlast(\".\", true)\nif (i) then\nreturn name:sub(1, i - 1)\nelse\nreturn name\nend\nend\nfunction path.removeext(name)\nlocal i = name:findlast(\".\", true)\nif (i) then\nreturn name:sub(1, i - 1)\nelse\nreturn name\nend\nend\nfunction path.getdirectory(p)\nlocal i = p:findlast(\"/\", true)\nif (i) then\nif i > 1 then i = i - 1 end\nreturn p:sub(1, i)\nelse\nreturn \".\"\nend\nend\nfunction path.getdrive(p)\nlocal ch1 = p:sub(1,1)\nlocal ch2 = p:sub(2,2)\nif ch2 == \":\" then\nreturn ch1\nend\nend\nfunction path.getextension(p)\nlocal i = p:findlast(\".\", true)\nif (i) then\nreturn p:sub(i)\nelse\nreturn \"\"\nend\nend\nfunction path.getname(p)\nlocal i = p:findlast(\"[/\\\\]\")\nif (i) then\nreturn p:sub(i + 1)\nelse\nreturn p\nend\nend\nfunction path.getcommonbasedir(a, b)\na = path.getdirectory(a)..'/'\nb = path.getdirectory(b)..'/'\nlocal idx = 0\nwhile (true) do\nlocal tst = a:find('/', idx + 1, true)\nif tst then\nif a:sub(1,t"
	"st) == b:sub(1,tst) then\nidx = tst\nelse\nbreak\nend\nelse\nbreak\nend\nend\nlocal result = ''\nif idx > 1 then\nresult = a:sub(1, idx - 1)-- Remove the trailing slash to be consistent with other functions.\nend\nreturn result\nend\nfunction path.hasextension(fname, extensions)\nlocal fext = path.getextension(fname):lower()\nif type(extensions) == \"table\" then\nfor _, extension in pairs(extensions) do\nif fext == extension then\nreturn true\nend\nend\nreturn false\nelse\nreturn (fext == extensions)\nend\nend\nfunction path.iscfile(fname)\nreturn path.hasextension(fname, { \".c\", \".m\" })\nend\nfunction path.iscppfile(fname)\nreturn path.hasextension(fname, { \".cc\", \".cpp\", \".cxx\", \".c\", \".m\", \".mm\" })\nend\nfunction path.iscxfile(fname)\nreturn path.hasextension(fname, \".cx\")\nend\nfunction path.isobjcfile(fname)\nreturn path.hasextension(fname, { \".m\", \".mm\" })\nend\nfunction path.iscppheader(fname)\nreturn path.hasextension(fname, { \".h\", \".hh\", \".hpp\", \".hxx\" })\nend\nfunction"
	" path.isappxmanifest(fname)\nreturn path.hasextension(fname, \".appxmanifest\")\nend\nfunction path.isnatvis(fname)\nreturn path.hasextension(fname, \".natvis\")\nend\nfunction path.isasmfile(fname)\nreturn path.hasextension(fname, { \".asm\", \".s\", \".S\" })\nend\nfunction path.isvalafile(fname)\nreturn path.hasextension(fname, \".vala\")\nend\nfunction path.isswiftfile(fname)\nreturn path.hasextension(fname, \".swift\")\nend\nfunction path.issourcefile(fname)\nreturn path.iscfile(fname)\nor path.iscppfile(fname)\nor path.iscxfile(fname)\nor path.isasmfile(fname)\nor path.isvalafile(fname)\nor path.isswiftfile(fname)\nend\nfunction path.issourcefilevs(fname)\nreturn path.hasextension(fname, { \".cc\", \".cpp\", \".cxx\", \".c\" })\nor path.iscxfile(fname)\nend\nfunction path.isresourcefile(fname)\nreturn path.hasextension(fname, \".rc\")\nend\nfunction path.isimagefile(fname)\nlocal extensions = { \".png\" }\nlocal ext = path.getextension(fname):lower()\nreturn table.contains(extensions, ext)\nend\nfunction"
	" path.join(...)\nlocal arg={...}\nlocal numargs = select(\"#\", ...)\nif numargs == 0 then\nreturn \"\";\nend\nlocal allparts = {}\nfor i = numargs, 1, -1 do\nlocal part = select(i, ...)\nif part and #part > 0 and part ~= \".\" then\nwhile part:endswith(\"/\") do\npart = part:sub(1, -2)\nend\ntable.insert(allparts, 1, part)\nif path.isabsolute(part) then\nbreak\nend\nend\nend\nreturn table.concat(allparts, \"/\")\nend\nfunction path.rebase(p, oldbase, newbase)\np = path.getabsolute(path.join(oldbase, p))\np = path.getrelative(newbase, p)\nreturn p\nend\nfunction path.translate(p, sep)\nif (type(p) == \"table\") then\nlocal result = { }\nfor _, value in ipairs(p) do\ntable.insert(result, path.translate(value))\nend\nreturn result\nelse\nif (not sep) then\nif (os.is(\"windows\")) then\nsep = \"\\\\\"\nelse\nsep = \"/\"\nend\nend\nlocal result = p:gsub(\"[/\\\\]\", sep)\nreturn result\nend\nend\nfunction path.wildcards(pattern)\npattern = pattern:gsub(\"([%+%.%-%^%$%(%)%%])\", \"%%%1\")\npattern = pattern:gsub(\""
	"%*%*\", \"\\001\")\npattern = pattern:gsub(\"%*\", \"\\002\")\npattern = pattern:gsub(\"\\001\", \".*\")\npattern = pattern:gsub(\"\\002\", \"[^/]*\")\nreturn pattern\nend\nfunction path.trimdots(p)\nlocal changed\nrepeat\nchanged = true\nif p:startswith(\"./\") then\np = p:sub(3)\nelseif p:startswith(\"../\") then\np = p:sub(4)\nelse\nchanged = false\nend\nuntil not changed\nreturn p\nend\nfunction path.rebase(p, oldbase, newbase)\np = path.getabsolute(path.join(oldbase, p))\np = path.getrelative(newbase, p)\nreturn p\nend\nfunction path.replaceextension(p, newext)\nlocal ext = path.getextension(p)\nif not ext then\nreturn p\nend\nif #newext > 0 and not newext:findlast(\".\", true) then\nnewext = \".\"..newext\nend\nreturn p:match(\"^(.*)\"..ext..\"$\")..newext\nend\n",

	/* base/string.lua */
	"function string.explode(s, pattern, plain)\nif (pattern == '') then return false end\nlocal pos = 0\nlocal arr = { }\nfor st,sp in function() return s:find(pattern, pos, plain) end do\ntable.insert(arr, s:sub(pos, st-1))\npos = sp + 1\nend\ntable.insert(arr, s:sub(pos))\nreturn arr\nend\nfunction string.findlast(s, pattern, plain)\nlocal curr = 0\nlocal term = nil\nrepeat\nlocal next, nextterm = s:find(pattern, curr + 1, plain)\nif (next) then\ncurr = next\nterm = nextterm\nend\nuntil (not next)\nif (curr > 0) then\nreturn curr, term\nend\nend\nfunction string.startswith(haystack, needle)\nreturn (haystack:find(needle, 1, true) == 1)\nend\nfunction string.trim(s)\nreturn (s:gsub(\"^%s*(.-)%s*$\", \"%1\"))\nend\n",

	/* base/table.lua */
	"function table.contains(t, value)\nfor _, v in pairs(t) do\nif v == value then return true end\nend\nreturn false\nend\nfunction table.icontains(t, value)\nfor _, v in ipairs(t) do\nif v == value then return true end\nend\nreturn false\nend\nfunction table.deepcopy(object)\nlocal seen = {}\nlocal function copy(object)\nif type(object) ~= \"table\" then\nreturn object\nelseif seen[object] then\nreturn seen[object]\nend\nlocal clone = {}\nseen[object] = clone\nfor key, value in pairs(object) do\nclone[key] = copy(value)\nend\nsetmetatable(clone, getmetatable(object))\nreturn clone\nend\nreturn copy(object)\nend\nfunction table.extract(arr, fname)\nlocal result = { }\nfor _,v in ipairs(arr) do\ntable.insert(result, v[fname])\nend\nreturn result\nend\nfunction table.flatten(arr)\nlocal result = { }\nlocal function flatten(arr)\nfor _, v in ipairs(arr) do\nif type(v) == \"table\" then\nflatten(v)\nelse\ntable.insert(result, v)\nend\nend\nend\nflatten(arr)\nreturn result\nend\nfunction table.implode(arr, before, aft"
	"er, between)\nlocal result = \"\"\nfor _,v in ipairs(arr) do\nif (result ~= \"\" and between) then\nresult = result .. between\nend\nresult = result .. before .. v .. after\nend\nreturn result\nend\nfunction table.insertflat(tbl, values)\nif type(values) == \"table\" then\nfor _, value in ipairs(values) do\ntable.insertflat(tbl, value)\nend\nelse\ntable.insert(tbl, values)\nend\nend\nfunction table.isempty(t)\nreturn next(t) == nil\nend\nfunction table.join(...)\nlocal arg={...}\nlocal result = { }\nfor _,t in ipairs(arg) do\nif type(t) == \"table\" then\nfor _,v in ipairs(t) do\ntable.insert(result, v)\nend\nelse\ntable.insert(result, t)\nend\nend\nreturn result\nend\nfunction table.keys(tbl)\nlocal keys = {}\nfor k, _ in pairs(tbl) do\ntable.insert(keys, k)\nend\nreturn keys\nend\nfunction table.merge(...)\nlocal arg={...}\nlocal result = { }\nfor _,t in ipairs(arg) do\nif type(t) == \"table\" then\nfor k,v in pairs(t) do\nresult[k] = v\nend\nelse\nerror(\"invalid value\")\nend\nend\nreturn result\nend\nfunc"
	"tion table.translate(arr, translation)\nlocal result = { }\nfor _, value in ipairs(arr) do\nlocal tvalue\nif type(translation) == \"function\" then\ntvalue = translation(value)\nelse\ntvalue = translation[value]\nend\nif (tvalue) then\ntable.insert(result, tvalue)\nend\nend\nreturn result\nend\nfunction table.reverse(arr)\nfor i=1, math.floor(#arr / 2) do\narr[i], arr[#arr - i + 1] = arr[#arr - i + 1], arr[i]\nend\nreturn arr\nend\nfunction table.arglist(arg, value)\nif #value > 0 then\nlocal args = {}\nfor _, val in ipairs(value) do\ntable.insert(args, string.format(\"%s %s\", arg, val))\nend\nreturn table.concat(args, \" \")\nelse\nreturn \"\"\nend\nend\n",

	/* base/io.lua */
	"io.eol         = \"\\n\"\nio.indent      = \"\\t\"\nio.indentLevel = 0\nlocal function _escaper(v) return v end\n_esc = _escaper\nfunction io.capture()\nio.captured = ''\nend\nfunction io.endcapture()\nlocal captured = io.captured\nio.captured = nil\nreturn captured\nend\nlocal builtin_open = io.open\nfunction io.open(fname, mode)\nif (mode) then\nif (mode:find(\"w\")) then\nlocal dir = path.getdirectory(fname)\nok, err = os.mkdir(dir)\nif (not ok) then\nerror(err, 0)\nend\nend\nend\nreturn builtin_open(fname, mode)\nend\nfunction io.printf(msg, ...)\nlocal arg={...}\nif not io.eol then\nio.eol = \"\\n\"\nend\nif not io.indent then\nio.indent = \"\\t\"\nend\nif type(msg) == \"number\" then\ns = string.rep(io.indent, msg) .. string.format(table.unpack(arg))\nelse\ns = string.format(msg, table.unpack(arg))\nend\nif io.captured then\nio.captured = io.captured .. s .. io.eol\nelse\nio.write(s)\nio.write(io.eol)\nend\nend\nfunction io.xprintf(msg, ...)\nlocal arg = {...}\nfor i = 1, #arg do\narg[i] = io.esc(arg[i])"
	"\nend\nio.printf(msg, unpack(arg))\nend\nfunction io.esc(value)\nif type(value) == \"table\" then\nlocal result = {}\nlocal n = #value\nfor i = 1, n do\ntable.insert(result, io.esc(value[i]))\nend\nreturn result\nend\nreturn _esc(value or \"\")\nend\nfunction io.escaper(func)\n_esc = func or _escaper\nend\n_p = io.printf\n_x = io.xprintf\n",

	/* base/globals.lua */
	"premake = { }\npremake.platforms =\n{\nNative =\n{\ncfgsuffix       = \"\",\n},\nx32 =\n{\ncfgsuffix       = \"32\",\n},\nx64 =\n{\ncfgsuffix       = \"64\",\n},\nUniversal =\n{\ncfgsuffix       = \"univ\",\n},\nUniversal32 =\n{\ncfgsuffix       = \"univ32\",\n},\nUniversal64 =\n{\ncfgsuffix       = \"univ64\",\n},\nPS3 =\n{\ncfgsuffix       = \"ps3\",\niscrosscompiler = true,\nnosharedlibs    = true,\nnamestyle       = \"PS3\",\n},\nWiiDev =\n{\ncfgsuffix       = \"wii\",\niscrosscompiler = true,\nnamestyle       = \"PS3\",\n},\nXbox360 =\n{\ncfgsuffix       = \"xbox360\",\niscrosscompiler = true,\nnamestyle       = \"windows\",\n},\nPowerPC =\n{\ncfgsuffix       = \"ppc\",\niscrosscompiler = true,\n},\nARM =\n{\ncfgsuffix       = \"ARM\",\niscrosscompiler = true,\n},\nOrbis =\n{\ncfgsuffix       = \"orbis\",\niscrosscompiler = true,\nnamestyle       = \"Orbis\",\n},\nDurango =\n{\ncfgsuffix       = \"durango\",\niscrosscompiler = true,\nnosharedlibs    = true,\nnamestyle       = \"windows\",\n},\n}\nlocal bu"
	"iltin_dofile = dofile\nfunction dofile(fname)\nlocal oldcwd = os.getcwd()\nlocal oldfile = _SCRIPT\nif (not os.isfile(fname)) then\nlocal path = os.pathsearch(fname, _OPTIONS[\"scripts\"], os.getenv(\"PREMAKE_PATH\"))\nif (path) then\nfname = path..\"/\"..fname\nend\nend\n_SCRIPT = path.getabsolute(fname)\nlocal newcwd = path.getdirectory(_SCRIPT)\nos.chdir(newcwd)\nlocal a, b, c, d, e, f = builtin_dofile(_SCRIPT)\n_SCRIPT = oldfile\nos.chdir(oldcwd)\nreturn a, b, c, d, e, f\nend\nfunction iif(expr, trueval, falseval)\nif (expr) then\nreturn trueval\nelse\nreturn falseval\nend\nend\nfunction include(fname)\nlocal dir, name = premake.findDefaultScript(fname, false)\nif dir ~= nil then\nreturn dofile(dir .. \"/\" .. name)\nend\nreturn nil\nend\nfunction printf(msg, ...)\nlocal arg={...}\nprint(string.format(msg, table.unpack(arg)))\nend\nfunction typex(t)\nlocal mt = getmetatable(t)\nif (mt) then\nif (mt.__type) then\nreturn mt.__type\nend\nend\nreturn type(t)\nend\n",

	/* base/action.lua */
	"premake.action = { }\npremake.action.list = { }\nfunction premake.action.add(a)\nlocal missing\nfor _, field in ipairs({\"description\", \"trigger\"}) do\nif (not a[field]) then\nmissing = field\nend\nend\nif (missing) then\nerror(\"action needs a \" .. missing, 3)\nend\npremake.action.list[a.trigger] = a\nend\nfunction premake.action.call(name)\nlocal a = premake.action.list[name]\nfor sln in premake.solution.each() do\nif a.onsolution then\na.onsolution(sln)\nend\nfor prj in premake.solution.eachproject(sln) do\nif a.onproject then\na.onproject(prj)\nend\nend\nend\nif a.execute then\na.execute()\nend\nend\nfunction premake.action.current()\nreturn premake.action.get(_ACTION)\nend\nfunction premake.action.get(name)\nreturn premake.action.list[name]\nend\nfunction premake.action.each()\nlocal keys = { }\nfor _, action in pairs(premake.action.list) do\ntable.insert(keys, action.trigger)\nend\ntable.sort(keys)\nlocal i = 0\nreturn function()\ni = i + 1\nreturn premake.action.list[keys[i]]\nend\nend\nfunction pre"
	"make.action.set(name)\n_ACTION = name\nlocal action = premake.action.get(name)\nif action then\n_OS = action.os or _OS\nend\nend\nfunction premake.action.supports(action, feature)\nif not action then\nreturn false\nend\nif action.valid_languages then\nif table.contains(action.valid_languages, feature) then\nreturn true\nend\nend\nif action.valid_kinds then\nif table.contains(action.valid_kinds, feature) then\nreturn true\nend\nend\nreturn false\nend\n",

	/* base/option.lua */
	"premake.option = { }\npremake.option.list = { }\nfunction premake.option.add(opt)\nlocal missing\nfor _, field in ipairs({ \"description\", \"trigger\" }) do\nif (not opt[field]) then\nmissing = field\nend\nend\nif (missing) then\nerror(\"option needs a \" .. missing, 3)\nend\npremake.option.list[opt.trigger] = opt\nend\nfunction premake.option.get(name)\nreturn premake.option.list[name]\nend\nfunction premake.option.each()\nlocal keys = { }\nfor _, option in pairs(premake.option.list) do\ntable.insert(keys, option.trigger)\nend\ntable.sort(keys)\nlocal i = 0\nreturn function()\ni = i + 1\nreturn premake.option.list[keys[i]]\nend\nend\nfunction premake.option.validate(values)\nfor key, value in pairs(values) do\nlocal opt = premake.option.get(key)\nif (not opt) then\nreturn false, \"invalid option '\" .. key .. \"'\"\nend\nif (opt.value and value == \"\") then\nreturn false, \"no value specified for option '\" .. key .. \"'\"\nend\nif opt.allowed then\nlocal found = false\nfor _, match in ipairs(opt.allowed) d"
	"o\nif match[1] == value then\nfound = true\nbreak\nend\nend\nif not found then\nreturn false, string.format(\"invalid value '%s' for option '%s'\", value, key)\nend\nend\nend\nreturn true\nend\n",

	/* base/tree.lua */
	"premake.tree = { }\nlocal tree = premake.tree\nfunction premake.tree.new(n)\nlocal t = {\nname = n,\nchildren = { }\n}\nreturn t\nend\nfunction premake.tree.add(tr, p, onaddfunc)\nif p == \".\" then\nreturn tr\nend\nif p == \"/\" then\nreturn tr\nend\nlocal parentnode = tree.add(tr, path.getdirectory(p), onaddfunc)\nlocal childname = path.getname(p)\nif childname == \"..\" then\nreturn parentnode\nend\nlocal childnode = parentnode.children[childname]\nif not childnode or childnode.path ~= p then\nchildnode = tree.insert(parentnode, tree.new(childname))\nchildnode.path = p\nif onaddfunc then\nonaddfunc(childnode)\nend\nend\nreturn childnode\nend\nfunction premake.tree.insert(parent, child)\ntable.insert(parent.children, child)\nif child.name then\nparent.children[child.name] = child\nend\nchild.parent = parent\nreturn child\nend\nfunction premake.tree.getlocalpath(node)\nif node.parent.path then\nreturn node.name\nelseif node.cfg then\nreturn node.cfg.name\nelse\nreturn node.path\nend\nend\nfunction premake.tre"
	"e.remove(node)\nlocal children = node.parent.children\nfor i = 1, #children do\nif children[i] == node then\ntable.remove(children, i)\nend\nend\nnode.children = {}\nend\nfunction premake.tree.sort(tr)\ntree.traverse(tr, {\nonnode = function(node)\ntable.sort(node.children, function(a,b)\nreturn a.name < b.name\nend)\nend\n}, true)\nend\nfunction premake.tree.traverse(t, fn, includeroot, initialdepth)\nlocal donode, dochildren\ndonode = function(node, fn, depth)\nif node.isremoved then\nreturn\nend\nif fn.onnode then\nfn.onnode(node, depth)\nend\nif #node.children > 0 then\nif fn.onbranchenter then\nfn.onbranchenter(node, depth)\nend\nif fn.onbranch then\nfn.onbranch(node, depth)\nend\ndochildren(node, fn, depth + 1)\nif fn.onbranchexit then\nfn.onbranchexit(node, depth)\nend\nelse\nif fn.onleaf then\nfn.onleaf(node, depth)\nend\nend\nend\ndochildren = function(parent, fn, depth)\nlocal i = 1\nwhile i <= #parent.children do\nlocal node = parent.children[i]\ndonode(node, fn, depth)\nif node == parent.children[i"
	"] then\ni = i + 1\nend\nend\nend\nif not initialdepth then\ninitialdepth = 0\nend\nif includeroot then\ndonode(t, fn, initialdepth)\nelse\ndochildren(t, fn, initialdepth)\nend\nend\n",

	/* base/solution.lua */
	"premake.solution = { }\npremake.solution.list = { }\nfunction premake.solution.new(name)\nlocal sln = { }\ntable.insert(premake.solution.list, sln)\npremake.solution.list[name] = sln\nsetmetatable(sln, { __type=\"solution\" })\nsln.name           = name\nsln.basedir        = os.getcwd()\nsln.projects       = { }\nsln.blocks         = { }\nsln.configurations = { }\nsln.groups         = { }\nsln.importedprojects = { }\nreturn sln\nend\nfunction premake.solution.each()\nlocal i = 0\nreturn function ()\ni = i + 1\nif i <= #premake.solution.list then\nreturn premake.solution.list[i]\nend\nend\nend\nfunction premake.solution.eachproject(sln)\nlocal i = 0\nreturn function ()\ni = i + 1\nif (i <= #sln.projects) then\nreturn premake.solution.getproject(sln, i)\nend\nend\nend\nfunction premake.solution.eachgroup(sln)\nlocal i = 0\nreturn function()\ni = i + 1\nif(i <= #sln.groups) then\nreturn premake.solution.getgroup(sln, i)\nend\nend\nend\nfunction premake.solution.get(key)\nreturn premake.solution.list[key]\nend\nfu"
	"nction premake.solution.getproject(sln, idx)\nlocal prj = sln.projects[idx]\nlocal cfg = premake.getconfig(prj)\ncfg.name = prj.name\nreturn cfg\nend\nfunction premake.solution.getgroup(sln, idx)\nlocal grp = sln.groups[idx]\nreturn grp\nend",

	/* base/project.lua */
	"premake.project = { }\nfunction premake.project.buildsourcetree(prj, allfiles)\nlocal tr = premake.tree.new(prj.name)\ntr.project = prj\nlocal isvpath\nlocal function onadd(node)\nnode.isvpath = isvpath\nend\nfor fcfg in premake.project.eachfile(prj, allfiles) do\nisvpath = (fcfg.name ~= fcfg.vpath)\nlocal node = premake.tree.add(tr, fcfg.vpath, onadd)\nnode.cfg = fcfg\nend\npremake.tree.sort(tr)\nreturn tr\nend\nfunction premake.eachconfig(prj, platform)\nif prj.project then prj = prj.project end\nlocal cfgs = prj.solution.configurations\nlocal i = 0\nreturn function ()\ni = i + 1\nif i <= #cfgs then\nreturn premake.getconfig(prj, cfgs[i], platform)\nend\nend\nend\nfunction premake.project.eachfile(prj, allfiles)\nif not prj.project then prj = premake.getconfig(prj) end\nlocal i = 0\nlocal t = iif(allfiles, prj.allfiles, prj.files)\nlocal c = iif(allfiles, prj.__allfileconfigs, prj.__fileconfigs)\nreturn function ()\ni = i + 1\nif (i <= #t) then\nlocal fcfg = c[t[i]]\nfcfg.vpath = premake.project.getvpath(prj"
	", fcfg.name)\nreturn fcfg\nend\nend\nend\nfunction premake.esc(value)\nif (type(value) == \"table\") then\nlocal result = { }\nfor _,v in ipairs(value) do\ntable.insert(result, premake.esc(v))\nend\nreturn result\nelse\nvalue = value:gsub('&',  \"&amp;\")\nvalue = value:gsub('\"',  \"&quot;\")\nvalue = value:gsub(\"'\",  \"&apos;\")\nvalue = value:gsub('<',  \"&lt;\")\nvalue = value:gsub('>',  \"&gt;\")\nvalue = value:gsub('\\r', \"&#x0D;\")\nvalue = value:gsub('\\n', \"&#x0A;\")\nreturn value\nend\nend\nfunction premake.filterplatforms(sln, map, default)\nlocal result = { }\nlocal keys = { }\nif sln.platforms then\nfor _, p in ipairs(sln.platforms) do\nif map[p] and not table.contains(keys, map[p]) then\ntable.insert(result, p)\ntable.insert(keys, map[p])\nend\nend\nend\nif #result == 0 and default then\ntable.insert(result, default)\nend\nreturn result\nend\nfunction premake.findproject(name)\nfor sln in premake.solution.each() do\nfor prj in premake.solution.eachproject(sln) do\nif (prj.name == name) then\n"
	"return  prj\nend\nend\nend\nend\nfunction premake.findfile(prj, extension)\nfor _, fname in ipairs(prj.files) do\nif fname:endswith(extension) then return fname end\nend\nend\nfunction premake.getconfig(prj, cfgname, pltname)\nprj = prj.project or prj\nif pltname == \"Native\" or not table.contains(prj.solution.platforms or {}, pltname) then\npltname = nil\nend\nlocal key = (cfgname or \"\")\nif pltname then key = key .. pltname end\nreturn prj.__configs[key]\nend\nfunction premake.getconfigname(cfgname, platform, useshortname)\nif cfgname then\nlocal name = cfgname\nif platform and platform ~= \"Native\" then\nif useshortname then\nname = name .. premake.platforms[platform].cfgsuffix\nelse\nname = name .. \"|\" .. platform\nend\nend\nreturn iif(useshortname, name:lower(), name)\nend\nend\nfunction premake.getdependencies(prj)\nprj = prj.project or prj\nlocal results = { }\nfor _, cfg in pairs(prj.__configs) do\nfor _, link in ipairs(cfg.links) do\nlocal dep = premake.findproject(link)\nif dep and not table.co"
	"ntains(results, dep) then\ntable.insert(results, dep)\nend\nend\nend\nreturn results\nend\nfunction premake.project.getbasename(prjname, pattern)\nreturn pattern:gsub(\"%%%%\", prjname)\nend\nfunction premake.project.getfilename(prj, pattern)\nlocal fname = premake.project.getbasename(prj.name, pattern)\nfname = path.join(prj.location, fname)\nreturn path.getrelative(os.getcwd(), fname)\nend\n function premake.getlinks(cfg, kind, part)\nlocal result = iif (part == \"directory\" and kind == \"all\", cfg.libdirs, {})\nlocal cfgname = iif(cfg.name == cfg.project.name, \"\", cfg.name)\nlocal pathstyle = premake.getpathstyle(cfg)\nlocal namestyle = premake.getnamestyle(cfg)\nlocal function canlink(source, target)\nif (target.kind ~= \"SharedLib\" and target.kind ~= \"StaticLib\") then\nreturn false\nend\nif premake.iscppproject(source) then\nreturn premake.iscppproject(target)\nelseif premake.isdotnetproject(source) then\nreturn premake.isdotnetproject(target)\nelseif premake.isswiftproject(source) then\nreturn pre"
	"make.isswiftproject(source) or premake.iscppproject(source)\nend\nend\nfor _, link in ipairs(cfg.links) do\nlocal item\nlocal prj = premake.findproject(link)\nif prj and kind ~= \"system\" then\nlocal prjcfg = premake.getconfig(prj, cfgname, cfg.platform)\nif kind == \"dependencies\" or canlink(cfg, prjcfg) then\nif (part == \"directory\") then\nitem = path.rebase(prjcfg.linktarget.directory, prjcfg.location, cfg.location)\nelseif (part == \"basename\") then\nitem = prjcfg.linktarget.basename\nelseif (part == \"fullpath\") then\nitem = path.rebase(prjcfg.linktarget.fullpath, prjcfg.location, cfg.location)\nelseif (part == \"object\") then\nitem = prjcfg\nend\nend\nelseif not prj and (kind == \"system\" or kind == \"all\") then\nif (part == \"directory\") then\nitem = path.getdirectory(link)\nelseif (part == \"fullpath\") then\nitem = link\nif namestyle == \"windows\" then\nif premake.iscppproject(cfg) then\nitem = item .. \".lib\"\nelseif premake.isdotnetproject(cfg) then\nitem = item .. \".dll\"\nend\nend\nel"
	"seif part == \"name\" then\nitem = path.getname(link)\nelseif part == \"basename\" then\nitem = path.getbasename(link)\nelse\nitem = link\nend\nif item:find(\"/\", nil, true) then\nitem = path.getrelative(cfg.project.location, item)\nend\nend\nif item then\nif pathstyle == \"windows\" and part ~= \"object\" then\nitem = path.translate(item, \"\\\\\")\nend\nif not table.contains(result, item) then\ntable.insert(result, item)\nend\nend\nend\nreturn result\nend\nfunction premake.getnamestyle(cfg)\nreturn premake.platforms[cfg.platform].namestyle or premake.gettool(cfg).namestyle or \"posix\"\nend\nfunction premake.getpathstyle(cfg)\nif premake.action.current().os == \"windows\" then\nreturn \"windows\"\nelse\nreturn \"posix\"\nend\nend\nfunction premake.gettarget(cfg, direction, pathstyle, namestyle, system)\nif system == \"bsd\" then\nsystem = \"linux\"\nend\nlocal kind = cfg.kind\nif premake.iscppproject(cfg) then\nif (namestyle == \"windows\" or system == \"windows\")\nand kind == \"SharedLib\" and direction ="
	"= \"link\"\nand not cfg.flags.NoImportLib\nthen\nkind = \"StaticLib\"\nend\nif namestyle == \"posix\" and system == \"windows\" and kind ~= \"StaticLib\" then\nnamestyle = \"windows\"\nend\nend\nlocal field   = \"build\"\nif direction == \"link\" and cfg.kind == \"SharedLib\" then\nfield = \"implib\"\nend\nlocal name    = cfg[field..\"name\"] or cfg.targetname or cfg.project.name\nlocal dir     = cfg[field..\"dir\"] or cfg.targetdir or path.getrelative(cfg.location, cfg.basedir)\nlocal subdir  = cfg[field..\"subdir\"] or cfg.targetsubdir or \".\"\nlocal prefix  = \"\"\nlocal suffix  = \"\"\nlocal ext     = \"\"\nlocal bundlepath, bundlename\ndir = path.join(dir, subdir)\nif namestyle == \"windows\" then\nif kind == \"ConsoleApp\" or kind == \"WindowedApp\" then\next = \".exe\"\nelseif kind == \"SharedLib\" then\next = \".dll\"\nelseif kind == \"StaticLib\" then\next = \".lib\"\nend\nelseif namestyle == \"posix\" then\nif kind == \"WindowedApp\" and system == \"macosx\" then\nbundlename = name .. \".app\"\nbund"
	"lepath = path.join(dir, bundlename)\ndir = path.join(bundlepath, \"Contents/MacOS\")\nelseif (kind == \"ConsoleApp\" or kind == \"WindowedApp\") and system == \"os2\" then\next = \".exe\"\nelseif kind == \"SharedLib\" then\nprefix = \"lib\"\next = iif(system == \"macosx\", \".dylib\", \".so\")\nelseif kind == \"StaticLib\" then\nprefix = \"lib\"\next = \".a\"\nend\nelseif namestyle == \"PS3\" then\nif kind == \"ConsoleApp\" or kind == \"WindowedApp\" then\next = \".elf\"\nelseif kind == \"StaticLib\" then\nprefix = \"lib\"\next = \".a\"\nend\nelseif namestyle == \"Orbis\" then\nif kind == \"ConsoleApp\" or kind == \"WindowedApp\" then\next = \".elf\"\nelseif kind == \"StaticLib\" then\nprefix = \"lib\"\next = \".a\"\nelseif kind == \"SharedLib\" then\next = \".prx\"\nend\nend\nprefix = cfg[field..\"prefix\"] or cfg.targetprefix or prefix\nsuffix = cfg[field..\"suffix\"] or cfg.targetsuffix or suffix\next    = cfg[field..\"extension\"] or cfg.targetextension or ext\nlocal result = { }\nresult.basename     = nam"
	"e .. suffix\nresult.name         = prefix .. name .. suffix .. ext\nresult.directory    = dir\nresult.subdirectory = subdir\nresult.prefix       = prefix\nresult.suffix       = suffix\nresult.fullpath     = path.join(result.directory, result.name)\nresult.bundlepath   = bundlepath or result.fullpath\nif pathstyle == \"windows\" then\nresult.directory    = path.translate(result.directory, \"\\\\\")\nresult.subdirectory = path.translate(result.subdirectory, \"\\\\\")\nresult.fullpath     = path.translate(result.fullpath,  \"\\\\\")\nend\nreturn result\nend\nfunction premake.gettool(cfg)\nif premake.iscppproject(cfg) then\nif _OPTIONS.cc then\nreturn premake[_OPTIONS.cc]\nend\nlocal action = premake.action.current()\nif action.valid_tools then\nreturn premake[action.valid_tools.cc[1]]\nend\nreturn premake.gcc\nelseif premake.isdotnetproject(cfg) then\nreturn premake.dotnet\nelseif premake.isswiftproject(cfg) then\nreturn premake.swift\nelse\nreturn premake.valac\nend\nend\nfunction premake.project.getvpath(prj, a"
	"bspath)\nlocal vpath = abspath\nlocal fname = path.getname(abspath)\nlocal max = abspath:len() - fname:len()\n        \n        -- First check for an exact match from the inverse vpaths\n        if prj.inversevpaths and prj.inversevpaths[abspath] then\n            return path.join(prj.inversevpaths[abspath], fname)\n        end\n        local matches = {}\nfor replacement, patterns in pairs(prj.vpaths or {}) do\nfor _, pattern in ipairs(patterns) do\nlocal i = abspath:find(path.wildcards(pattern))\nif i == 1 then\ni = pattern:find(\"*\", 1, true) or (pattern:len() + 1)\nlocal leaf\nif i < max then\nleaf = abspath:sub(i)\nelse\nleaf = fname\nend\nif leaf:startswith(\"/\") then\nleaf = leaf:sub(2)\nend\nlocal stem = \"\"\nif replacement:len() > 0 then\nstem, stars = replacement:gsub(\"%*\", \"\")\nif stars == 0 then\nleaf = path.getname(leaf)\nend\nelse\nleaf = path.getname(leaf)\nend\ntable.insert(matches, path.join(stem, leaf))\nend\nend\nend\n        \n        if #matches > 0 then\n            -- for the sake"
	" of determinism, return the first alphabetically\n            table.sort(matches)\n            vpath = matches[1]\n        end\nreturn path.trimdots(vpath)\nend\nfunction premake.hascppproject(sln)\nfor prj in premake.solution.eachproject(sln) do\nif premake.iscppproject(prj) then\nreturn true\nend\nend\nend\nfunction premake.hasdotnetproject(sln)\nfor prj in premake.solution.eachproject(sln) do\nif premake.isdotnetproject(prj) then\nreturn true\nend\nend\nend\nfunction premake.project.iscproject(prj)\nreturn prj.language == \"C\"\nend\nfunction premake.iscppproject(prj)\nreturn (prj.language == \"C\" or prj.language == \"C++\")\nend\nfunction premake.isdotnetproject(prj)\nreturn (prj.language == \"C#\")\nend\nfunction premake.isvalaproject(prj)\nreturn (prj.language == \"Vala\")\nend\nfunction premake.isswiftproject(prj)\nreturn (prj.language == \"Swift\")\nend\n",

	/* base/config.lua */
	"premake.config = { }\nlocal config = premake.config\nfunction premake.config.isdebugbuild(cfg)\nif cfg.flags.DebugRuntime then\nreturn true\nend\nif cfg.flags.ReleaseRuntime then\nreturn false\nend\nif cfg.flags.Optimize or cfg.flags.OptimizeSize or cfg.flags.OptimizeSpeed then\nreturn false\nend\nif not cfg.flags.Symbols then\nreturn false\nend\nreturn true\nend\nfunction premake.config.eachfile(cfg)\nlocal i = 0\nlocal t = cfg.files\nreturn function ()\ni = i + 1\nif (i <= #t) then\nlocal fcfg = cfg.__fileconfigs[t[i]]\nfcfg.vpath = premake.project.getvpath(cfg.project, fcfg.name)\nreturn fcfg\nend\nend\nend\nfunction premake.config.isincrementallink(cfg)\nif cfg.kind == \"StaticLib\"\nor config.isoptimizedbuild(cfg.flags)\nor cfg.flags.NoIncrementalLink then\nreturn false\nend\nreturn true\nend\nfunction premake.config.isoptimizedbuild(flags)\nreturn flags.Optimize or flags.OptimizeSize or flags.OptimizeSpeed\nend\n",

	/* base/bake.lua */
	"premake.bake = { }\nlocal bake = premake.bake\nlocal nocopy =\n{\nblocks    = true,\nkeywords  = true,\nprojects  = true,\n__configs = true,\n}\nlocal nocascade =\n{\nmakesettings = true,\n}\nlocal keeprelative =\n{\nbasedir  = true,\nlocation = true,\n}\nfunction premake.getactiveterms()\nlocal terms = { _action = _ACTION:lower(), os = os.get() }\nfor key, value in pairs(_OPTIONS) do\nif value ~= \"\" then\ntable.insert(terms, value:lower())\nelse\ntable.insert(terms, key:lower())\nend\nend\nreturn terms\nend\nfunction premake.iskeywordmatch(keyword, terms)\nif keyword:startswith(\"not \") then\nreturn not premake.iskeywordmatch(keyword:sub(5), terms)\nend\nfor _, pattern in ipairs(keyword:explode(\" or \")) do\nfor termkey, term in pairs(terms) do\nif term:match(pattern) == term then\nreturn termkey\nend\nend\nend\nend\nfunction premake.iskeywordsmatch(keywords, terms)\nlocal hasrequired = false\nfor _, keyword in ipairs(keywords) do\nlocal matched = premake.iskeywordmatch(keyword, terms)\nif not matched the"
	"n\nreturn false\nend\nif matched == \"required\" then\nhasrequired = true\nend\nend\nif terms.required and not hasrequired then\nreturn false\nelse\nreturn true\nend\nend\nlocal function adjustpaths(location, obj)\nfunction adjustpathlist(list)\nfor i, p in ipairs(list) do\nlist[i] = path.getrelative(location, p)\nend\nend\nif obj.allfiles ~= nil then\nadjustpathlist(obj.allfiles)\nend\nfor name, value in pairs(obj) do\nlocal field = premake.fields[name]\nif field and value and not keeprelative[name] then\nif field.kind == \"path\" then\nobj[name] = path.getrelative(location, value)\nelseif field.kind == \"dirlist\" or field.kind == \"filelist\" then\nadjustpathlist(value)\nelseif field.kind == \"keypath\" then\nfor k,v in pairs(value) do\nadjustpathlist(v)\nend\nend\nend\nend\nend\nlocal function removevalue(tbl, remove)\nfor index, item in ipairs(tbl) do\nif item == remove then\ntable.remove(tbl, index)\nbreak\nend\nend\nend\nlocal function removevalues(tbl, removes)\nfor k, v in pairs(tbl) do\nfor _, patter"
	"n in ipairs(removes) do\nif pattern == tbl[k] then\nif type(k) == \"number\" then\ntable.remove(tbl, k)\nelse\ntbl[k] = nil\nend\nbreak\nend\nend\nend\nend\nlocal function mergefield(kind, dest, src, mergecopiestotail)\nlocal tbl = dest or { }\nif kind == \"keyvalue\" or kind == \"keypath\" then\nfor key, value in pairs(src) do\ntbl[key] = mergefield(\"list\", tbl[key], value, mergecopiestotail)\nend\nelse\nfor _, item in ipairs(src) do\nif tbl[item] then\nif mergecopiestotail then\nremovevalue(tbl, item)\ntable.insert(tbl, item)\ntbl[item] = item\nend\nelse\ntable.insert(tbl, item)\ntbl[item] = item\nend\nend\nend\nreturn tbl\nend\nlocal function mergeobject(dest, src)\nif not src then\nreturn\nend\nfor fieldname, value in pairs(src) do\nif not nocopy[fieldname] then\nlocal field = premake.fields[fieldname]\nif field then\nif type(value) == \"table\" then\ndest[fieldname] = mergefield(field.kind, dest[fieldname], value, field.mergecopiestotail)\nif src.removes then\nremoves = src.removes[fieldname]\nif remove"
	"s then\nremovevalues(dest[fieldname], removes)\nend\nend\nelse\ndest[fieldname] = value\nend\nelse\ndest[fieldname] = value\nend\nend\nend\nend\nlocal function merge(dest, obj, basis, terms, cfgname, pltname)\nlocal key = cfgname or \"\"\npltname = pltname or \"Native\"\nif pltname ~= \"Native\" then\nkey = key .. pltname\nend\nterms.config = (cfgname or \"\"):lower()\nterms.platform = pltname:lower()\nlocal cfg = {}\nmergeobject(cfg, basis[key])\nadjustpaths(obj.location, cfg)\nmergeobject(cfg, obj)\nif (cfg.kind) then\nterms['kind']=cfg.kind:lower()\nend\nfor _, blk in ipairs(obj.blocks) do\nif (premake.iskeywordsmatch(blk.keywords, terms))then\nmergeobject(cfg, blk)\nif (cfg.kind and not cfg.terms.kind) then\ncfg.terms['kind'] = cfg.kind:lower()\nterms['kind'] = cfg.kind:lower()\nend\nend\nend\ncfg.name      = cfgname\ncfg.platform  = pltname\nfor k,v in pairs(terms) do\ncfg.terms[k] =v\nend\ndest[key] = cfg\nend\nlocal function collapse(obj, basis)\nlocal result = {}\nbasis = basis or {}\nlocal sln = obj.s"
	"olution or obj\nlocal terms = premake.getactiveterms()\nmerge(result, obj, basis, terms)--this adjusts terms\nfor _, cfgname in ipairs(sln.configurations) do\nlocal terms_local = {}\nfor k,v in pairs(terms)do terms_local[k]=v end\nmerge(result, obj, basis, terms_local, cfgname, \"Native\")--terms cam also be adjusted here\nfor _, pltname in ipairs(sln.platforms or {}) do\nif pltname ~= \"Native\" then\nmerge(result, obj, basis,terms_local, cfgname, pltname)--terms also here\nend\nend\nend\nreturn result\nend\nlocal function builduniquedirs()\nlocal num_variations = 4\nlocal cfg_dirs = {}\nlocal hit_counts = {}\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nfor _, cfg in pairs(prj.__configs) do\nlocal dirs = { }\ndirs[1] = path.getabsolute(path.join(cfg.location, cfg.objdir or cfg.project.objdir or \"obj\"))\ndirs[2] = path.join(dirs[1], iif(cfg.platform == \"Native\", \"\", cfg.platform))\ndirs[3] = path.join(dirs[2], cfg.name)\ndirs[4] = path.join(dirs[3], cfg.project.name)\ncf"
	"g_dirs[cfg] = dirs\nlocal start = iif(cfg.name, 2, 1)\nfor v = start, num_variations do\nlocal d = dirs[v]\nhit_counts[d] = (hit_counts[d] or 0) + 1\nend\nend\nend\nend\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nfor _, cfg in pairs(prj.__configs) do\nlocal dir\nlocal start = iif(cfg.name, 2, 1)\nfor v = start, iif(cfg.flags.SingleOutputDir==true,num_variations-1,num_variations) do\ndir = cfg_dirs[cfg][v]\nif hit_counts[dir] == 1 then break end\nend\ncfg.objectsdir = path.getrelative(cfg.location, dir)\nend\nend\nend\nend\nlocal function buildtargets()\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nfor _, cfg in pairs(prj.__configs) do\nlocal pathstyle = premake.getpathstyle(cfg)\nlocal namestyle = premake.getnamestyle(cfg)\ncfg.buildtarget = premake.gettarget(cfg, \"build\", pathstyle, namestyle, cfg.system)\ncfg.linktarget  = premake.gettarget(cfg, \"link\",  pathstyle, namestyle, cfg.system)\nif pathstyle == \"windows\" then\ncfg.objectsdir "
	"= path.translate(cfg.objectsdir, \"\\\\\")\nend\nend\nend\nend\nend\n  local function getCfgKind(cfg)\n  if(cfg.kind) then\n  return cfg.kind;\n  end\n  if(cfg.project.__configs[\"\"] and cfg.project.__configs[\"\"].kind) then\n  return cfg.project.__configs[\"\"].kind;\n  end\n  return nil\n  end\n  local function getprojrec(dstArray, foundList, cfg, cfgname, searchField, bLinkage)\n  if(not cfg) then return end\n  local foundUsePrjs = {};\n  for _, useName in ipairs(cfg[searchField]) do\n  local testName = useName:lower();\n  if((not foundList[testName])) then\n  local theProj = nil;\n  local theUseProj = nil;\n  for _, prj in ipairs(cfg.project.solution.projects) do\n  if (prj.name:lower() == testName) then\n  if(prj.usage) then\n  theUseProj = prj;\n  else\n  theProj = prj;\n  end\n  end\n  end\n  --Must connect to a usage project.\n  if(theUseProj) then\n  foundList[testName] = true;\n  local prjEntry = {\n  name = testName,\n  proj = theProj,\n  usageProj = theUseProj,\n  bLinkageOnly = bLinkage,\n  };\n"
	"  dstArray[testName] = prjEntry;\n  table.insert(foundUsePrjs, theUseProj);\n  end\n  end\n  end\n  for _, usePrj in ipairs(foundUsePrjs) do\n  --Links can only recurse through static libraries.\n  if((searchField ~= \"links\") or\n  (getCfgKind(usePrj.__configs[cfgname]) == \"StaticLib\")) then\n  getprojrec(dstArray, foundList, usePrj.__configs[cfgname],\n  cfgname, searchField, bLinkage);\n  end\n  end\n  end\n  --\n  -- This function will recursively get all projects that the given configuration has in its \"uses\"\n  -- field. The return values are a list of tables. Each table in that list contains the following:\n  --name = The lowercase name of the project.\n  --proj = The project. Can be nil if it is usage-only.\n  --usageProj = The usage project. Can't be nil, as using a project that has no\n  -- usage project is not put into the list.\n  --bLinkageOnly = If this is true, then only the linkage information should be copied.\n  -- The recursion will only look at the \"uses\" field on *usage* projects.\n"
	"  -- This function will also add projects to the list that are mentioned in the \"links\"\n  -- field of usage projects. These will only copy linker information, but they will recurse.\n  -- through other \"links\" fields.\n  --\n  local function getprojectsconnections(cfg, cfgname)\n  local dstArray = {};\n  local foundList = {};\n  foundList[cfg.project.name:lower()] = true;\n  --First, follow the uses recursively.\n  getprojrec(dstArray, foundList, cfg, cfgname, \"uses\", false);\n  --Next, go through all of the usage projects and recursively get their links.\n  --But only if they're not already there. Get the links as linkage-only.\n  local linkArray = {};\n  for prjName, prjEntry in pairs(dstArray) do\n  getprojrec(linkArray, foundList, prjEntry.usageProj.__configs[cfgname], cfgname,\n  \"links\", true);\n  end\n  --Copy from linkArray into dstArray.\n  for prjName, prjEntry in pairs(linkArray) do\n  dstArray[prjName] = prjEntry;\n  end\n  return dstArray;\n  end\n  local function isnameofproj(cfg, strNam"
	"e)\n  local sln = cfg.project.solution;\n  local strTest = strName:lower();\n  for prjIx, prj in ipairs(sln.projects) do\n  if (prj.name:lower() == strTest) then\n  return true;\n  end\n  end\n  return false;\n  end\n  --\n  -- Copies the field from dstCfg to srcCfg.\n  --\n  local function copydependentfield(srcCfg, dstCfg, strSrcField)\n  local srcField = premake.fields[strSrcField];\n  local strDstField = strSrcField;\n  if type(srcCfg[strSrcField]) == \"table\" then\n  --handle paths.\n  if (srcField.kind == \"dirlist\" or srcField.kind == \"filelist\") and\n  (not keeprelative[strSrcField]) then\n  for i,p in ipairs(srcCfg[strSrcField]) do\n  table.insert(dstCfg[strDstField],\n  path.rebase(p, srcCfg.project.location, dstCfg.project.location))\n  end\n  else\n  if(strSrcField == \"links\") then\n  for i,p in ipairs(srcCfg[strSrcField]) do\n  if(not isnameofproj(dstCfg, p)) then\n  table.insert(dstCfg[strDstField], p)\n  else\n  printf(\"Failed to copy '%s' from proj '%s'.\",\n  p, srcCfg.project.name);\n "
	" end\n  end\n  else\n  for i,p in ipairs(srcCfg[strSrcField]) do\n  table.insert(dstCfg[strDstField], p)\n  end\n  end\n  end\n  else\n  if(srcField.kind == \"path\" and (not keeprelative[strSrcField])) then\n  dstCfg[strDstField] = path.rebase(srcCfg[strSrcField],\n  prj.location, dstCfg.project.location);\n  else\n  dstCfg[strDstField] = srcCfg[strSrcField];\n  end\n  end\n  end\n  --\n  -- This function will take the list of project entries and apply their usage project data\n  -- to the given configuration. It will copy compiling information for the projects that are\n  -- not listed as linkage-only. It will copy the linking information for projects only if\n  -- the source project is not a static library. It won't copy linking information\n  -- if the project is in this solution; instead it will add that project to the configuration's\n  -- links field, expecting that Premake will handle the rest.\n  --\n  local function copyusagedata(cfg, cfgname, linkToProjs)\n  local myPrj = cfg.project;\n  local bIsSt"
	"aticLib = (getCfgKind(cfg) == \"StaticLib\");\n  for prjName, prjEntry in pairs(linkToProjs) do\n  local srcPrj = prjEntry.usageProj;\n  local srcCfg = srcPrj.__configs[cfgname];\n  for name, field in pairs(premake.fields) do\n  if(srcCfg[name]) then\n  if(field.usagecopy) then\n  if(not prjEntry.bLinkageOnly) then\n  copydependentfield(srcCfg, cfg, name)\n  end\n  elseif(field.linkagecopy) then\n  --Copy the linkage data if we're building a non-static thing\n  --and this is a pure usage project. If it's not pure-usage, then\n  --we will simply put the project's name in the links field later.\n  if((not bIsStaticLib) and (not prjEntry.proj)) then\n  copydependentfield(srcCfg, cfg, name)\n  end\n  end\n  end\n  end\n  if((not bIsStaticLib) and prjEntry.proj) then\n  table.insert(cfg.links, prjEntry.proj.name);\n  end\n  end\n  end\n    local function inverseliteralvpaths()\n        for sln in premake.solution.each() do\n            for _,prj in ipairs(sln.projects) do\n                prj.inversevpaths = {}\n  "
	"              for replacement, patterns in pairs(prj.vpaths or {}) do\n                    for _, pattern in ipairs(patterns) do\n                        if string.find(pattern, \"*\") == nil then\n                            prj.inversevpaths[pattern] = replacement\n                        end\n                    end\n                end\n            end\n        end\n    end\nfunction premake.bake.buildconfigs()\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nprj.location = prj.location or sln.location or prj.basedir\nadjustpaths(prj.location, prj)\nfor _, blk in ipairs(prj.blocks) do\nadjustpaths(prj.location, blk)\nend\nend\nsln.location = sln.location or sln.basedir\nend\n        -- convert paths for imported projects to be relative to solution location\nfor sln in premake.solution.each() do\nfor _, iprj in ipairs(sln.importedprojects) do\niprj.location = path.getabsolute(iprj.location)\nend\nend\n        inverseliteralvpaths()\nfor sln in premake.solution.each() do\nlocal "
	"basis = collapse(sln)\nfor _, prj in ipairs(sln.projects) do\nprj.__configs = collapse(prj, basis)\nfor _, cfg in pairs(prj.__configs) do\nbake.postprocess(prj, cfg)\nend\nend\nend\nfor sln in premake.solution.each() do\nfor prjIx, prj in ipairs(sln.projects) do\nif(not prj.usage) then\nfor cfgname, cfg in pairs(prj.__configs) do\nlocal usesPrjs = getprojectsconnections(cfg, cfgname);\ncopyusagedata(cfg, cfgname, usesPrjs)\nend\nend\nend\nend\nfor sln in premake.solution.each() do\nfor prjIx, prj in ipairs(sln.projects) do\nfor cfgName, cfg in pairs(prj.__configs) do\ncfg.build = true\nlocal removes = nil\nif cfg.removes ~= nil then\nremoves = cfg.removes[\"platforms\"];\nend\nif removes ~= nil  then\nfor _,p in ipairs(removes) do\nif p == cfg.platform then\ncfg.build = false\nend\nend\nend\nend\nend\nend\nfor sln in premake.solution.each() do\nlocal removeList = {};\nfor index, prj in ipairs(sln.projects) do\nif(prj.usage) then\ntable.insert(removeList, 1, index); --Add in reverse order.\nend\nend\nfor _, ind"
	"ex in ipairs(removeList) do\ntable.remove(sln.projects, index);\nend\nend\nbuilduniquedirs()\nbuildtargets(cfg)\nend\nfunction premake.bake.postprocess(prj, cfg)\ncfg.project   = prj\ncfg.shortname = premake.getconfigname(cfg.name, cfg.platform, true)\ncfg.longname  = premake.getconfigname(cfg.name, cfg.platform)\ncfg.location = cfg.location or cfg.basedir\nlocal platform = premake.platforms[cfg.platform]\nif platform.iscrosscompiler then\ncfg.system = cfg.platform\nelse\ncfg.system = os.get()\nend\nif cfg.kind == \"Bundle\" and not _ACTION:match(\"xcode[0-9]\") then\ncfg.kind = \"SharedLib\"\nend\nif cfg.kind == \"SharedLib\" and platform.nosharedlibs then\ncfg.kind = \"StaticLib\"\nend\nlocal removefiles = cfg.removefiles\nif _ACTION == 'gmake' or _ACTION == 'ninja' then\nremovefiles = table.join(removefiles, cfg.excludes)\nend\nlocal removefilesDict = {}\nfor _, fname in ipairs(removefiles) do\nremovefilesDict[fname] = true\nend\nlocal files = {}\nfor _, fname in ipairs(cfg.files) do\nif removefilesDict[fna"
	"me] == nil then\ntable.insert(files, fname)\nend\nend\ncfg.files = files\nlocal allfiles = {}\nlocal allfilesDict = {}\nfor _, fname in ipairs(cfg.allfiles) do\nif allfilesDict[fname] == nil then\nif removefilesDict[fname] == nil then\nallfilesDict[fname] = true\ntable.insert(allfiles, fname)\nend\nend\nend\ncfg.allfiles = allfiles\nfor name, field in pairs(premake.fields) do\nif field.isflags then\nlocal values = cfg[name]\nfor _, flag in ipairs(values) do values[flag] = true end\nend\nend\nlocal cfgfields = {\n{\"__fileconfigs\",    cfg.files},\n{\"__allfileconfigs\", cfg.allfiles},\n}\nfor _, cfgfield in ipairs(cfgfields) do\nlocal fieldname = cfgfield[1]\nlocal field     = cfgfield[2]\ncfg[fieldname] = { }\nfor _, fname in ipairs(field) do\nlocal fcfg = {}\nif premake._filelevelconfig then\ncfg.terms.required = fname:lower()\nfor _, blk in ipairs(cfg.project.blocks) do\nif (premake.iskeywordsmatch(blk.keywords, cfg.terms)) then\nmergeobject(fcfg, blk)\nend\nend\nend\nfcfg.name = fname\ncfg[fieldname][fname"
	"] = fcfg\ntable.insert(cfg[fieldname], fcfg)\nend\nend\nend\n",

	/* base/api.lua */
	"premake.fields =\n{\narchivesplit_size =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nbasedir =\n{\nkind  = \"path\",\nscope = \"container\",\n},\nbuildaction =\n{\nkind  = \"string\",\nscope = \"config\",\nallowed = {\n\"Compile\",\n\"Copy\",\n\"Embed\",\n\"None\"\n}\n},\nbuildoptions =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nbuildoptions_asm =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nbuildoptions_c =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nbuildoptions_cpp =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nbuildoptions_objc =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nbuildoptions_objcpp =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nbuildoptions_vala =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nclrreferences =\n{\nkind = \"list\",\nscope = \"container\",\n},\nconfigurations =\n{\nkind  = \"list\",\nscope = \"solution\",\n},\ncustombuildtask =\n{\nkind  = \"table\",\nscope = \"config\",\n},\ndebugargs =\n{\nkind = \"list\",\nscope = \"config\",\n},\ndebugdir =\n{\nkind"
	" = \"path\",\nscope = \"config\",\n},\ndebugenvs  =\n{\nkind = \"list\",\nscope = \"config\",\n},\ndefines =\n{\nkind  = \"list\",\nscope = \"config\",\n},\ndeploymentoptions =\n{\nkind  = \"list\",\nscope = \"config\",\nusagecopy = true,\n},\ndependency =\n{\nkind  = \"table\",\nscope = \"config\",\n},\ndeploymode =\n{\nkind = \"string\",\nscope = \"config\",\n},\nexcludes =\n{\nkind  = \"filelist\",\nscope = \"config\",\n},\nforcenative =\n{\nkind = \"filelist\",\nscope = \"config\",\n},\nnopch =\n{\nkind  = \"filelist\",\nscope = \"config\",\n},\nfiles =\n{\nkind  = \"filelist\",\nscope = \"config\",\n},\nremovefiles =\n{\nkind  = \"filelist\",\nscope = \"config\",\n},\nflags =\n{\nkind  = \"list\",\nscope = \"config\",\nisflags = true,\nusagecopy = true,\nallowed = function(value)\nlocal allowed_flags = {\nATL = 1,\nC7DebugInfo = 1,\nDebugEnvsDontMerge = 1,\nDebugEnvsInherit = 1,\nDeploymentContent = 1,\nEnableMinimalRebuild = 1,\nEnableSSE = 1,\nEnableSSE2 = 1,\nEnableAVX = 1,\nEnableAVX2 = 1,\nPedanticWa"
	"rnings = 1,\nExtraWarnings = 1,\nFatalWarnings = 1,\nFloatFast = 1,\nFloatStrict = 1,\nManaged = 1,\nMinimumWarnings = 1,\nMFC = 1,\nNativeWChar = 1,\nNo64BitChecks = 1,\nNoBufferSecurityCheck = 1,\nNoEditAndContinue = 1,\nNoExceptions = 1,\nNoFramePointer = 1,\nNoImportLib = 1,\nNoIncrementalLink = 1,\nNoManifest = 1,\nNoMultiProcessorCompilation = 1,\nNoNativeWChar = 1,\nNoPCH = 1,\nNoRTTI = 1,\nNoWinMD = 1,    -- explicitly disables Windows Metadata\nNoWinRT = 1,    -- explicitly disables Windows Runtime Extension\nFastCall = 1,\nStdCall = 1,\nSingleOutputDir = 1,\nObjcARC = 1,\nOptimize = 1,\nOptimizeSize = 1,\nOptimizeSpeed = 1,\nDebugRuntime = 1,\nReleaseRuntime = 1,\nSEH = 1,\nStaticATL = 1,\nStaticRuntime = 1,\nSymbols = 1,\nUnicode = 1,\nUnsafe = 1,\nUnsignedChar = 1,\nUseFullPaths = 1,\nWinMain = 1,\n}\nlocal englishToAmericanSpelling =\n{\noptimise = 'optimize',\noptimisesize = 'optimizesize',\noptimisespeed = 'optimizespeed',\n}\nlocal lowervalue = value:lower()\nlowervalue = englishToAmericanSpell"
	"ing[lowervalue] or lowervalue\nfor v, _ in pairs(allowed_flags) do\nif v:lower() == lowervalue then\nreturn v\nend\nend\nreturn nil, \"invalid flag\"\nend,\n},\nframework =\n{\nkind = \"string\",\nscope = \"container\",\nallowed = {\n\"1.0\",\n\"1.1\",\n\"2.0\",\n\"3.0\",\n\"3.5\",\n\"4.0\",\n\"4.5\",\n\"4.5.1\",\n\"4.5.2\",\n\"4.6\",\n\"4.6.1\",\n\"4.6.2\",\n}\n},\nwindowstargetplatformversion =\n{\nkind  = \"string\",\nscope = \"project\",\n},\nwindowstargetplatformminversion =\n{\nkind = \"string\",\nscope = \"project\",\n},\nforcedincludes =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nimagepath =\n{\nkind = \"path\",\nscope = \"config\",\n},\nimageoptions =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nimplibdir =\n{\nkind  = \"path\",\nscope = \"config\",\n},\nimplibextension =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nimplibname =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nimplibprefix =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nimplibsuffix =\n{\nkind  = \"string\",\nscope ="
	" \"config\",\n},\nincludedirs =\n{\nkind  = \"dirlist\",\nscope = \"config\",\nusagecopy = true,\n},\nuserincludedirs =\n{\nkind  = \"dirlist\",\nscope = \"config\",\nusagecopy = true,\n},\nusingdirs =\n{\nkind  = \"dirlist\",\nscope = \"config\",\nusagecopy = true,\n},\nkind =\n{\nkind  = \"string\",\nscope = \"config\",\nallowed = {\n\"ConsoleApp\",\n\"WindowedApp\",\n\"StaticLib\",\n\"SharedLib\",\n\"Bundle\",\n}\n},\nlanguage =\n{\nkind  = \"string\",\nscope = \"container\",\nallowed = {\n\"C\",\n\"C++\",\n\"C#\",\n\"Vala\",\n\"Swift\",\n}\n},\nlibdirs =\n{\nkind  = \"dirlist\",\nscope = \"config\",\nlinkagecopy = true,\n},\nlinkoptions =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nlinks =\n{\nkind  = \"list\",\nscope = \"config\",\nallowed = function(value)\nif value:find('/', nil, true) then\nvalue = path.getabsolute(value)\nend\nreturn value\nend,\nlinkagecopy = true,\nmergecopiestotail = true,\n},\nlocation =\n{\nkind  = \"path\",\nscope = \"container\",\n},\nmakesettings =\n{\nkind = \"list\",\nsc"
	"ope = \"config\",\n},\nmessageskip =\n{\nkind  = \"list\",\nscope = \"solution\",\nisflags = true,\nusagecopy = true,\nallowed = function(value)\nlocal allowed_messages = {\nSkipCreatingMessage = 1,\nSkipBuildingMessage = 1,\nSkipCleaningMessage = 1,\n}\nlocal lowervalue = value:lower()\nfor v, _ in pairs(allowed_messages) do\nif v:lower() == lowervalue then\nreturn v\nend\nend\nreturn nil, \"invalid message to skip\"\nend,\n},\nmsgarchiving =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nmsgcompile =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nmsgprecompile =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nmsgcompile_objc =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nmsgresource =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nmsglinking =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nobjdir =\n{\nkind  = \"path\",\nscope = \"config\",\n},\noptions =\n{\nkind  = \"list\",\nscope = \"container\",\nisflags = true,\nusagecopy = true,\nallowed = function(value)\nlocal allowed_options = {"
	"\nForceCPP = 1,\nArchiveSplit = 1\n}\nlocal lowervalue = value:lower()\nfor v, _ in pairs(allowed_options) do\nif v:lower() == lowervalue then\nreturn v\nend\nend\nreturn nil, \"invalid option\"\nend,\n},\npchheader =\n{\nkind  = \"string\",\nscope = \"config\",\n},\npchsource =\n{\nkind  = \"path\",\nscope = \"config\",\n},\nplatforms =\n{\nkind  = \"list\",\nscope = \"solution\",\nallowed = table.keys(premake.platforms),\n},\npostbuildcommands =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nprebuildcommands =\n{\nkind  = \"list\",\nscope = \"config\",\n},\npostcompiletasks =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nprelinkcommands =\n{\nkind  = \"list\",\nscope = \"config\",\n},\npropertysheets =\n{\nkind  = \"dirlist\",\nscope = \"config\",\n},\npullmappingfile =\n{\nkind  = \"path\",\nscope = \"config\",\n},\nresdefines =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nresincludedirs =\n{\nkind  = \"dirlist\",\nscope = \"config\",\n},\nresoptions =\n{\nkind  = \"list\",\nscope = \"config\",\n},\ns"
	"dkreferences =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nstartproject =\n{\nkind  = \"string\",\nscope = \"solution\",\n},\ntargetdir =\n{\nkind  = \"path\",\nscope = \"config\",\n},\ntargetsubdir =\n{\nkind  = \"string\",\nscope = \"config\",\n},\ntargetextension =\n{\nkind  = \"string\",\nscope = \"config\",\n},\ntargetname =\n{\nkind  = \"string\",\nscope = \"config\",\n},\ntargetprefix =\n{\nkind  = \"string\",\nscope = \"config\",\n},\ntargetsuffix =\n{\nkind  = \"string\",\nscope = \"config\",\n},\ntrimpaths =\n{\nkind = \"dirlist\",\nscope = \"config\",\n},\nuuid =\n{\nkind  = \"string\",\nscope = \"container\",\nallowed = function(value)\nlocal ok = true\nif (#value ~= 36) then ok = false end\nfor i=1,36 do\nlocal ch = value:sub(i,i)\nif (not ch:find(\"[ABCDEFabcdef0123456789-]\")) then ok = false end\nend\nif (value:sub(9,9) ~= \"-\")   then ok = false end\nif (value:sub(14,14) ~= \"-\") then ok = false end\nif (value:sub(19,19) ~= \"-\") then ok = false end\nif (value:sub(24,24) ~= \"-\") then "
	"ok = false end\nif (not ok) then\nreturn nil, \"invalid UUID\"\nend\nreturn value:upper()\nend\n},\nuses =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nvapidirs =\n{\nkind  = \"dirlist\",\nscope = \"config\",\n},\nvpaths =\n{\nkind = \"keypath\",\nscope = \"container\",\n},\nvsimportreferences =\n{\nkind = \"filelist\",\nscope = \"container\",\n},\nswiftmodulemaps =\n{\nkind  = \"filelist\",\nscope = \"config\",\n},\nbuildoptions_swift =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nlinkoptions_swift =\n{\nkind  = \"list\",\nscope = \"config\",\n},\n}\npremake.check_paths = false\nfunction premake.checkvalue(value, allowed)\nif (allowed) then\nif (type(allowed) == \"function\") then\nreturn allowed(value)\nelse\nfor _,v in ipairs(allowed) do\nif (value:lower() == v:lower()) then\nreturn v\nend\nend\nreturn nil, \"invalid value '\" .. value .. \"'\"\nend\nelse\nreturn value\nend\nend\nfunction premake.getobject(t)\nlocal container\nif (t == \"container\" or t == \"solution\") then\ncontainer = premake.Curr"
	"entContainer\nelse\ncontainer = premake.CurrentConfiguration\nend\nif t == \"solution\" then\nif typex(container) == \"project\" then\ncontainer = container.solution\nend\nif typex(container) ~= \"solution\" then\ncontainer = nil\nend\nend\nlocal msg\nif (not container) then\nif (t == \"container\") then\nmsg = \"no active solution or project\"\nelseif (t == \"solution\") then\nmsg = \"no active solution\"\nelse\nmsg = \"no active solution, project, or configuration\"\nend\nend\nreturn container, msg\nend\nfunction premake.setarray(obj, fieldname, value, allowed)\nobj[fieldname] = obj[fieldname] or {}\nlocal function add(value, depth)\nif type(value) == \"table\" then\nfor _,v in ipairs(value) do\nadd(v, depth + 1)\nend\nelse\nvalue, err = premake.checkvalue(value, allowed)\nif not value then\nerror(err, depth)\nend\ntable.insert(obj[fieldname], value)\nend\nend\nif value then\nadd(value, 5)\nend\nreturn obj[fieldname]\nend\nfunction premake.settable(obj, fieldname, value, allowed)\nobj[fieldname] = obj[fieldn"
	"ame] or {}\ntable.insert(obj[fieldname], value)\nreturn obj[fieldname]\nend\nlocal function domatchedarray(fields, value, matchfunc)\nlocal result = { }\nfunction makeabsolute(value, depth)\nif (type(value) == \"table\") then\nfor _, item in ipairs(value) do\nmakeabsolute(item, depth + 1)\nend\nelseif type(value) == \"string\" then\nif value:find(\"*\") then\nlocal arr = matchfunc(value);\nif (premake.check_paths) and (#arr == 0) then\nerror(\"Can't find matching files for pattern :\" .. value)\nend\nmakeabsolute(arr, depth + 1)\nelse\ntable.insert(result, path.getabsolute(value))\nend\nelse\nerror(\"Invalid value in list: expected string, got \" .. type(value), depth)\nend\nend\nmakeabsolute(value, 3)\nlocal retval = {}\nfor index, field in ipairs(fields) do\nlocal ctype = field[1]\nlocal fieldname = field[2]\nlocal array = premake.setarray(ctype, fieldname, result)\nif index == 1 then\nretval = array\nend\nend\nreturn retval\nend\nfunction premake.setdirarray(fields, value)\nreturn domatchedarray(fields, val"
	"ue, os.matchdirs)\nend\nfunction premake.setfilearray(fields, value)\nreturn domatchedarray(fields, value, os.matchfiles)\nend\nfunction premake.setkeyvalue(ctype, fieldname, values)\nlocal container, err = premake.getobject(ctype)\nif not container then\nerror(err, 4)\nend\nif not container[fieldname] then\ncontainer[fieldname] = {}\nend\nif type(values) ~= \"table\" then\nerror(\"invalid value; table expected\", 4)\nend\nlocal field = container[fieldname]\nfor key,value in pairs(values) do\nif not field[key] then\nfield[key] = {}\nend\ntable.insertflat(field[key], value)\nend\nreturn field\nend\nfunction premake.setstring(ctype, fieldname, value, allowed)\nlocal container, err = premake.getobject(ctype)\nif (not container) then\nerror(err, 4)\nend\nif (value) then\nvalue, err = premake.checkvalue(value, allowed)\nif (not value) then\nerror(err, 4)\nend\ncontainer[fieldname] = value\nend\nreturn container[fieldname]\nend\nfunction premake.remove(fieldname, value)\nlocal cfg = premake.CurrentConfiguration\ncfg"
	".removes = cfg.removes or {}\ncfg.removes[fieldname] = premake.setarray(cfg.removes, fieldname, value)\nend\nlocal function accessor(name, value)\nlocal kind    = premake.fields[name].kind\nlocal scope   = premake.fields[name].scope\nlocal allowed = premake.fields[name].allowed\nif (kind == \"string\" or kind == \"path\") and value then\nif type(value) ~= \"string\" then\nerror(\"string value expected\", 3)\nend\nend\nlocal container, err = premake.getobject(scope)\nif (not container) then\nerror(err, 3)\nend\nif kind == \"string\" then\nreturn premake.setstring(scope, name, value, allowed)\nelseif kind == \"path\" then\nif value then value = path.getabsolute(value) end\nreturn premake.setstring(scope, name, value)\nelseif kind == \"list\" then\nreturn premake.setarray(container, name, value, allowed)\nelseif kind == \"table\" then\nreturn premake.settable(container, name, value, allowed)\nelseif kind == \"dirlist\" then\nreturn premake.setdirarray({{container, name}}, value)\nelseif kind == \"filelist\" or ki"
	"nd == \"absolutefilelist\" then\nlocal fields = {{container, name}}\nif name == \"files\" then\nlocal prj, err = premake.getobject(\"container\")\nif (not prj) then\nerror(err, 2)\nend\ntable.insert(fields, {prj.blocks[1], \"allfiles\"})\nend\nreturn premake.setfilearray(fields, value)\nelseif kind == \"keyvalue\" or kind == \"keypath\" then\nreturn premake.setkeyvalue(scope, name, value)\nend\nend\nfor name, info in pairs(premake.fields) do\n_G[name] = function(value)\nreturn accessor(name, value)\nend\nif info.kind == \"list\"\nor info.kind == \"dirlist\"\nor info.kind == \"filelist\"\nor info.kind == \"absolutefilelist\"\nthen\nif  name ~= \"removefiles\"\nand name ~= \"files\" then\n_G[\"remove\"..name] = function(value)\npremake.remove(name, value)\nend\nend\nend\nend\nfunction configuration(terms)\nif not terms then\nreturn premake.CurrentConfiguration\nend\nlocal container, err = premake.getobject(\"container\")\nif (not container) then\nerror(err, 2)\nend\nlocal cfg = { }\ncfg.terms = table.flatten({te"
	"rms})\ntable.insert(container.blocks, cfg)\npremake.CurrentConfiguration = cfg\ncfg.keywords = { }\nfor _, word in ipairs(cfg.terms) do\ntable.insert(cfg.keywords, path.wildcards(word):lower())\nend\nfor name, field in pairs(premake.fields) do\nif (field.kind ~= \"string\" and field.kind ~= \"path\") then\ncfg[name] = { }\nend\nend\nreturn cfg\nend\nlocal function creategroup(name, sln, curpath, parent, inpath)\nlocal group = {}\nsetmetatable(group, {\n__type = \"group\"\n})\ntable.insert(sln.groups, group)\nsln.groups[inpath] = group\nif parent ~= nil then\ntable.insert(parent.groups, group)\nend\ngroup.solution = sln\ngroup.name = name\ngroup.uuid = os.uuid(curpath)\ngroup.parent = parent\ngroup.projects = { }\ngroup.groups = { }\nreturn group\nend\nlocal function creategroupsfrompath(inpath, sln)\nif inpath == nil then return nil end\ninpath = path.translate(inpath, \"/\")\nlocal groups = string.explode(inpath, \"/\")\nlocal curpath = \"\"\nlocal lastgroup = nil\nfor i, v in ipairs(groups) do\ncurpath = cur"
	"path .. \"/\" .. v:lower()\nlocal group = sln.groups[curpath]\nif group == nil then\ngroup = creategroup(v, sln, curpath, lastgroup, curpath)\nend\nlastgroup = group\nend\nreturn lastgroup\nend\nlocal function createproject(name, sln, isUsage)\nlocal prj = {}\nsetmetatable(prj, {\n__type = \"project\",\n})\ntable.insert(sln.projects, prj)\nif(isUsage) then\nif(sln.projects[name]) then\nsln.projects[name].usageProj = prj;\nelse\nsln.projects[name] = prj\nend\nelse\nif(sln.projects[name]) then\nprj.usageProj = sln.projects[name];\nend\nsln.projects[name] = prj\nend\nlocal group = creategroupsfrompath(premake.CurrentGroup, sln)\nif group ~= nil then\ntable.insert(group.projects, prj)\nend\nprj.solution       = sln\nprj.name           = name\nprj.basedir        = os.getcwd()\nprj.uuid           = os.uuid(prj.name)\nprj.blocks         = { }\nprj.usage          = isUsage\nprj.group          = group\nreturn prj;\nend\nfunction usage(name)\nif (not name) then\nif(typex(premake.CurrentContainer) ~= \"project\") then re"
	"turn nil end\nif(not premake.CurrentContainer.usage) then return nil end\nreturn premake.CurrentContainer\nend\nlocal sln\nif (typex(premake.CurrentContainer) == \"project\") then\nsln = premake.CurrentContainer.solution\nelse\nsln = premake.CurrentContainer\nend\nif (typex(sln) ~= \"solution\") then\nerror(\"no active solution\", 2)\nend\nif((not sln.projects[name]) or\n((not sln.projects[name].usage) and (not sln.projects[name].usageProj))) then\npremake.CurrentContainer = createproject(name, sln, true)\nelse\npremake.CurrentContainer = iff(sln.projects[name].usage,\nsln.projects[name], sln.projects[name].usageProj)\nend\nconfiguration { }\nreturn premake.CurrentContainer\nend\nfunction project(name)\nif (not name) then\nif(typex(premake.CurrentContainer) ~= \"project\") then return nil end\nif(premake.CurrentContainer.usage) then return nil end\nreturn premake.CurrentContainer\nend\nlocal sln\nif (typex(premake.CurrentContainer) == \"project\") then\nsln = premake.CurrentContainer.solution\nelse\nsln = prem"
	"ake.CurrentContainer\nend\nif (typex(sln) ~= \"solution\") then\nerror(\"no active solution\", 2)\nend\nif((not sln.projects[name]) or sln.projects[name].usage) then\npremake.CurrentContainer = createproject(name, sln)\nelse\npremake.CurrentContainer = sln.projects[name];\nend\nconfiguration { }\nreturn premake.CurrentContainer\nend\nfunction solution(name)\nif not name then\nif typex(premake.CurrentContainer) == \"project\" then\nreturn premake.CurrentContainer.solution\nelse\nreturn premake.CurrentContainer\nend\nend\npremake.CurrentContainer = premake.solution.get(name)\nif (not premake.CurrentContainer) then\npremake.CurrentContainer = premake.solution.new(name)\nend\nconfiguration { }\nreturn premake.CurrentContainer\nend\nfunction group(name)\nif not name then\nreturn premake.CurrentGroup\nend\npremake.CurrentGroup = name\nreturn premake.CurrentGroup\nend\nfunction importvsproject(location)\nif string.find(_ACTION, \"vs\") ~= 1 then\nerror(\"Only available for visual studio actions\")\nend\nsln, err = pr"
	"emake.getobject(\"solution\")\nif not sln then\nerror(err)\nend\nlocal group = creategroupsfrompath(premake.CurrentGroup, sln)\nlocal project = {}\nproject.location = location\nproject.group = group\nproject.flags = {}\ntable.insert(sln.importedprojects, project)\n    end\nfunction newaction(a)\npremake.action.add(a)\nend\nfunction newoption(opt)\npremake.option.add(opt)\nend\nfunction enablefilelevelconfig()\npremake._filelevelconfig = true\nend\n",

	/* base/cmdline.lua */
	"newoption\n{\ntrigger     = \"cc\",\nvalue       = \"VALUE\",\ndescription = \"Choose a C/C++ compiler set\",\nallowed = {\n{ \"gcc\", \"GNU GCC (gcc/g++)\" },\n{ \"ow\",  \"OpenWatcom\"        },\n{ \"ghs\", \"Green Hills Software\" },\n}\n}\nnewoption\n{\ntrigger     = \"dotnet\",\nvalue       = \"VALUE\",\ndescription = \"Choose a .NET compiler set\",\nallowed = {\n{ \"msnet\",   \"Microsoft .NET (csc)\" },\n{ \"mono\",    \"Novell Mono (mcs)\"    },\n{ \"pnet\",    \"Portable.NET (cscc)\"  },\n}\n}\nnewoption\n{\ntrigger     = \"file\",\nvalue       = \"FILE\",\ndescription = \"Read FILE as a Premake script; default is 'premake4.lua'\"\n}\nnewoption\n{\ntrigger     = \"help\",\ndescription = \"Display this information\"\n}\nnewoption\n{\ntrigger     = \"os\",\nvalue       = \"VALUE\",\ndescription = \"Generate files for a different operating system\",\nallowed = {\n{ \"bsd\",      \"OpenBSD, NetBSD, or FreeBSD\" },\n{ \"linux\",    \"Linux\" },\n{ \"macosx\",   \"Apple Mac OS X\" },\n{ \"solaris\",  \"Sola"
	"ris\" },\n{ \"windows\",  \"Microsoft Windows\" },\n}\n}\nnewoption\n{\ntrigger     = \"platform\",\nvalue       = \"VALUE\",\ndescription = \"Add target architecture (if supported by action)\",\nallowed = {\n{ \"x32\",         \"32-bit\" },\n{ \"x64\",         \"64-bit\" },\n{ \"universal\",   \"Mac OS X Universal, 32- and 64-bit\" },\n{ \"universal32\", \"Mac OS X Universal, 32-bit only\" },\n{ \"universal64\", \"Mac OS X Universal, 64-bit only\" },\n{ \"ps3\",         \"Playstation 3\" },\n{ \"orbis\",       \"Playstation 4\" },\n{ \"xbox360\",     \"Xbox 360\" },\n{ \"durango\",     \"Xbox One\" },\n{ \"ARM\",         \"ARM\" },\n{ \"PowerPC\",     \"PowerPC\" },\n}\n}\nnewoption\n{\ntrigger     = \"scripts\",\nvalue       = \"path\",\ndescription = \"Search for additional scripts on the given path\"\n}\nnewoption\n{\ntrigger     = \"debug-profiler\",\ndescription = \"GENie script generation profiler.\"\n}\nnewoption\n{\ntrigger     = \"version\",\ndescription = \"Display version information\"\n}\n",

	/* base/inspect.lua */
	"-- Copyright (c) 2013 Enrique García Cota\nlocal function smartQuote(str)\n  if str:match('\"') and not str:match(\"'\") then\n    return \"'\" .. str .. \"'\"\n  end\n  return '\"' .. str:gsub('\"', '\\\\\"') .. '\"'\nend\nlocal controlCharsTranslation = {\n  [\"\\a\"] = \"\\\\a\",  [\"\\b\"] = \"\\\\b\", [\"\\f\"] = \"\\\\f\",  [\"\\n\"] = \"\\\\n\",\n  [\"\\r\"] = \"\\\\r\",  [\"\\t\"] = \"\\\\t\", [\"\\v\"] = \"\\\\v\"\n}\nlocal function escapeChar(c) return controlCharsTranslation[c] end\nlocal function escape(str)\n  local result = str:gsub(\"\\\\\", \"\\\\\\\\\"):gsub(\"(%c)\", escapeChar)\n  return result\nend\nlocal function isIdentifier(str)\n  return type(str) == 'string' and str:match( \"^[_%a][_%a%d]*$\" )\nend\nlocal function isArrayKey(k, length)\n  return type(k) == 'number' and 1 <= k and k <= length\nend\nlocal function isDictionaryKey(k, length)\n  return not isArrayKey(k, length)\nend\nlocal defaultTypeOrders = {\n  ['number']   = 1, ['boolean']  = 2, ['string'] = 3, ['table'] = 4,\n  ['fu"
	"nction'] = 5, ['userdata'] = 6, ['thread'] = 7\n}\nlocal function sortKeys(a, b)\n  local ta, tb = type(a), type(b)\n  -- strings and numbers are sorted numerically/alphabetically\n  if ta == tb and (ta == 'string' or ta == 'number') then return a < b end\n  local dta, dtb = defaultTypeOrders[ta], defaultTypeOrders[tb]\n  -- Two default types are compared according to the defaultTypeOrders table\n  if dta and dtb then return defaultTypeOrders[ta] < defaultTypeOrders[tb]\n  elseif dta     then return true  -- default types before custom ones\n  elseif dtb     then return false -- custom types after default ones\n  end\n  -- custom types are sorted out alphabetically\n  return ta < tb\nend\nlocal function getDictionaryKeys(t)\n  local keys, length = {}, #t\n  for k,_ in pairs(t) do\n    if isDictionaryKey(k, length) then table.insert(keys, k) end\n  end\n  table.sort(keys, sortKeys)\n  return keys\nend\nlocal function getToStringResultSafely(t, mt)\n  local __tostring = type(mt) == 'table' and rawget(mt, '__tost"
	"ring')\n  local str, ok\n  if type(__tostring) == 'function' then\n    ok, str = pcall(__tostring, t)\n    str = ok and str or 'error: ' .. tostring(str)\n  end\n  if type(str) == 'string' and #str > 0 then return str end\nend\nlocal maxIdsMetaTable = {\n  __index = function(self, typeName)\n    rawset(self, typeName, 0)\n    return 0\n  end\n}\nlocal idsMetaTable = {\n  __index = function (self, typeName)\n    local col = setmetatable({}, {__mode = \"kv\"})\n    rawset(self, typeName, col)\n    return col\n  end\n}\nlocal function countTableAppearances(t, tableAppearances)\n  tableAppearances = tableAppearances or setmetatable({}, {__mode = \"k\"})\n  if type(t) == 'table' then\n    if not tableAppearances[t] then\n      tableAppearances[t] = 1\n      for k,v in pairs(t) do\n        countTableAppearances(k, tableAppearances)\n        countTableAppearances(v, tableAppearances)\n      end\n      countTableAppearances(getmetatable(t), tableAppearances)\n    else\n      tableAppearances[t] = tableAppearances[t] +"
	" 1\n    end\n  end\n  return tableAppearances\nend\nlocal function parse_filter(filter)\n  if type(filter) == 'function' then return filter end\n  -- not a function, so it must be a table or table-like\n  filter = type(filter) == 'table' and filter or {filter}\n  local dictionary = {}\n  for _,v in pairs(filter) do dictionary[v] = true end\n  return function(x) return dictionary[x] end\nend\nlocal function makePath(path, key)\n  local newPath, len = {}, #path\n  for i=1, len do newPath[i] = path[i] end\n  newPath[len+1] = key\n  return newPath\nend\nfunction inspect(rootObject, options)\n  options       = options or {}\n  local depth   = options.depth or math.huge\n  local filter  = parse_filter(options.filter or {})\n  local tableAppearances = countTableAppearances(rootObject)\n  local buffer = {}\n  local maxIds = setmetatable({}, maxIdsMetaTable)\n  local ids    = setmetatable({}, idsMetaTable)\n  local level  = 0\n  local blen   = 0 -- buffer length\n  local function puts(...)\n    local args = {...}\n    "
	"for i=1, #args do\n      blen = blen + 1\n      buffer[blen] = tostring(args[i])\n    end\n  end\n  local function down(f)\n    level = level + 1\n    f()\n    level = level - 1\n  end\n  local function tabify()\n    puts(\"\\n\", string.rep(\"  \", level))\n  end\n  local function commaControl(needsComma)\n    if needsComma then puts(',') end\n    return true\n  end\n  local function alreadyVisited(v)\n    return ids[type(v)][v] ~= nil\n  end\n  local function getId(v)\n    local tv = type(v)\n    local id = ids[tv][v]\n    if not id then\n      id         = maxIds[tv] + 1\n      maxIds[tv] = id\n      ids[tv][v] = id\n    end\n    return id\n  end\n  local putValue -- forward declaration that needs to go before putTable & putKey\n  local function putKey(k)\n    if isIdentifier(k) then return puts(k) end\n    puts( \"[\" )\n    putValue(k, {})\n    puts(\"]\")\n  end\n  local function putTable(t, path)\n    if alreadyVisited(t) then\n      puts('<table ', getId(t), '>')\n    elseif level >= depth then\n      "
	"puts('{...}')\n    else\n      if tableAppearances[t] > 1 then puts('<', getId(t), '>') end\n      local dictKeys          = getDictionaryKeys(t)\n      local length            = #t\n      local mt                = getmetatable(t)\n      local to_string_result  = getToStringResultSafely(t, mt)\n      puts('{')\n      down(function()\n        if to_string_result then\n          puts(' -- ', escape(to_string_result))\n          if length >= 1 then tabify() end -- tabify the array values\n        end\n        local needsComma = false\n        for i=1, length do\n          needsComma = commaControl(needsComma)\n          puts(' ')\n          putValue(t[i], makePath(path, i))\n        end\n        for _,k in ipairs(dictKeys) do\n          needsComma = commaControl(needsComma)\n          tabify()\n          putKey(k)\n          puts(' = ')\n          putValue(t[k], makePath(path, k))\n        end\n        if mt then\n          needsComma = commaControl(needsComma)\n          tabify()\n          puts('<metatable> = '"
	")\n          putValue(mt, makePath(path, '<metatable>'))\n        end\n      end)\n      if #dictKeys > 0 or mt then -- dictionary table. Justify closing }\n        tabify()\n      elseif length > 0 then -- array tables have one extra space before closing }\n        puts(' ')\n      end\n      puts('}')\n    end\n  end\n  -- putvalue is forward-declared before putTable & putKey\n  putValue = function(v, path)\n    if filter(v, path) then\n      puts('<filtered>')\n    else\n      local tv = type(v)\n      if tv == 'string' then\n        puts(smartQuote(escape(v)))\n      elseif tv == 'number' or tv == 'boolean' or tv == 'nil' then\n        puts(tostring(v))\n      elseif tv == 'table' then\n        putTable(v, path)\n      else\n        puts('<',tv,' ',getId(v),'>')\n      end\n    end\n  end\n  putValue(rootObject, {})\n  return table.concat(buffer)\nend\nfunction printtable(name, table)\nprint(\"table: \", name, inspect(table), \"\\n\")\nend\nfunction printstack()\nprint(debug.traceback(), \"\\n\")\nend\n",

	/* base/profiler.lua */
	"_profiler = {}\nfunction newProfiler(variant, sampledelay)\nif _profiler.running then\nprint(\"Profiler already running.\")\nreturn\nend\nvariant = variant or \"time\"\nif variant ~= \"time\" and variant ~= \"call\" then\nprint(\"Profiler method must be 'time' or 'call'.\")\nreturn\nend\nlocal newprof = {}\nfor k,v in pairs(_profiler) do\nnewprof[k] = v\nend\nnewprof.variant = variant\nnewprof.sampledelay = sampledelay or 100000\nreturn newprof\nend\nfunction _profiler.start(self)\nif _profiler.running then\nreturn\nend\n_profiler.running = self\nself.rawstats = {}\nself.callstack = {}\nif self.variant == \"time\" then\nself.lastclock = os.clock()\ndebug.sethook( _profiler_hook_wrapper_by_time, \"\", self.sampledelay )\nelseif self.variant == \"call\" then\ndebug.sethook( _profiler_hook_wrapper_by_call, \"cr\" )\nelse\nprint(\"Profiler method must be 'time' or 'call'.\")\nsys.exit(1)\nend\nend\nfunction _profiler.stop(self)\nif _profiler.running ~= self then\nreturn\nend\ndebug.sethook( nil )\n_profiler.runnin"
	"g = nil\nend\nfunction _profiler_hook_wrapper_by_call(action)\nif _profiler.running == nil then\ndebug.sethook( nil )\nend\n_profiler.running:_internal_profile_by_call(action)\nend\nfunction _profiler_hook_wrapper_by_time(action)\nif _profiler.running == nil then\ndebug.sethook( nil )\nend\n_profiler.running:_internal_profile_by_time(action)\nend\nfunction _profiler._internal_profile_by_call(self,action)\nlocal caller_info = debug.getinfo( 3 )\nif caller_info == nil then\nprint \"No caller_info\"\nreturn\nend\nlocal latest_ar = nil\nif table.getn(self.callstack) > 0 then\nlatest_ar = self.callstack[table.getn(self.callstack)]\nend\nlocal should_not_profile = 0\nfor k,v in pairs(self.prevented_functions) do\nif k == caller_info.func then\nshould_not_profile = v\nend\nend\nif latest_ar then\nif latest_ar.should_not_profile == 2 then\nshould_not_profile = 2\nend\nend\nif action == \"call\" then\nlocal this_ar = {}\nthis_ar.should_not_profile = should_not_profile\nthis_ar.parent_ar = latest_ar\nthis_ar.anon_child "
	"= 0\nthis_ar.name_child = 0\nthis_ar.children = {}\nthis_ar.children_time = {}\nthis_ar.clock_start = os.clock()\ntable.insert( self.callstack, this_ar )\nelse\nlocal this_ar = latest_ar\nif this_ar == nil then\nreturn -- No point in doing anything if no upper activation record\nend\nthis_ar.clock_end = os.clock()\nthis_ar.this_time = this_ar.clock_end - this_ar.clock_start\nif this_ar.parent_ar then\nthis_ar.parent_ar.children[caller_info.func] =\n(this_ar.parent_ar.children[caller_info.func] or 0) + 1\nthis_ar.parent_ar.children_time[caller_info.func] =\n(this_ar.parent_ar.children_time[caller_info.func] or 0 ) +\nthis_ar.this_time\nif caller_info.name == nil then\nthis_ar.parent_ar.anon_child =\nthis_ar.parent_ar.anon_child + this_ar.this_time\nelse\nthis_ar.parent_ar.name_child =\nthis_ar.parent_ar.name_child + this_ar.this_time\nend\nend\nif this_ar.should_not_profile == 0 then\nlocal inforec = self:_get_func_rec(caller_info.func,1)\ninforec.count = inforec.count + 1\ninforec.time = inforec.time + this_ar"
	".this_time\ninforec.anon_child_time = inforec.anon_child_time + this_ar.anon_child\ninforec.name_child_time = inforec.name_child_time + this_ar.name_child\ninforec.func_info = caller_info\nfor k,v in pairs(this_ar.children) do\ninforec.children[k] = (inforec.children[k] or 0) + v\ninforec.children_time[k] =\n(inforec.children_time[k] or 0) + this_ar.children_time[k]\nend\nend\ntable.remove( self.callstack, table.getn( self.callstack ) )\nend\nend\nfunction _profiler._internal_profile_by_time(self,action)\nlocal timetaken = os.clock() - self.lastclock\nlocal depth = 3\nlocal at_top = true\nlocal last_caller\nlocal caller = debug.getinfo(depth)\nwhile caller do\nif not caller.func then caller.func = \"(tail call)\" end\nif self.prevented_functions[caller.func] == nil then\nlocal info = self:_get_func_rec(caller.func, 1, caller)\ninfo.count = info.count + 1\ninfo.time = info.time + timetaken\nif last_caller then\nif last_caller.name then\ninfo.name_child_time = info.name_child_time + timetaken\nelse\ninfo.anon_ch"
	"ild_time = info.anon_child_time + timetaken\nend\ninfo.children[last_caller.func] =\n(info.children[last_caller.func] or 0) + 1\ninfo.children_time[last_caller.func] =\n(info.children_time[last_caller.func] or 0) + timetaken\nend\nend\ndepth = depth + 1\nlast_caller = caller\ncaller = debug.getinfo(depth)\nend\nself.lastclock = os.clock()\nend\nfunction _profiler._get_func_rec(self,func,force,info)\nlocal ret = self.rawstats[func]\nif ret == nil and force ~= 1 then\nreturn nil\nend\nif ret == nil then\nret = {}\nret.func = func\nret.count = 0\nret.time = 0\nret.anon_child_time = 0\nret.name_child_time = 0\nret.children = {}\nret.children_time = {}\nret.func_info = info\nself.rawstats[func] = ret\nend\nreturn ret\nend\nfunction _profiler.report( self, outfile, sort_by_total_time )\noutfile:write\n[[Lua Profile output created by profiler.lua. Copyright Pepperfish 2002+\n]]\nlocal terms = {}\nif self.variant == \"time\" then\nterms.capitalized = \"Sample\"\nterms.single = \"sample\"\nterms.pastverb = \"sampled\""
	"\nelseif self.variant == \"call\" then\nterms.capitalized = \"Call\"\nterms.single = \"call\"\nterms.pastverb = \"called\"\nelse\nassert(false)\nend\nlocal total_time = 0\nlocal ordering = {}\nfor func,record in pairs(self.rawstats) do\ntable.insert(ordering, func)\nend\nif sort_by_total_time then\ntable.sort( ordering,\nfunction(a,b) return self.rawstats[a].time > self.rawstats[b].time end\n)\nelse\ntable.sort( ordering,\nfunction(a,b)\nlocal arec = self.rawstats[a]\nlocal brec = self.rawstats[b]\nlocal atime = arec.time - (arec.anon_child_time + arec.name_child_time)\nlocal btime = brec.time - (brec.anon_child_time + brec.name_child_time)\nreturn atime > btime\nend\n)\nend\nfor i=1,#ordering do\nlocal func = ordering[i]\nlocal record = self.rawstats[func]\nlocal thisfuncname = \" \" .. self:_pretty_name(func) .. \" \"\nif string.len( thisfuncname ) < 42 then\nthisfuncname = string.rep( \"-\", math.floor((42 - string.len(thisfuncname))/2) ) .. thisfuncname\nthisfuncname = thisfuncname .. string.rep( \"-\", 42"
	" - string.len(thisfuncname) )\nend\ntotal_time = total_time + ( record.time - ( record.anon_child_time +\nrecord.name_child_time ) )\noutfile:write( string.rep( \"-\", 19 ) .. thisfuncname ..\nstring.rep( \"-\", 19 ) .. \"\\n\" )\noutfile:write( terms.capitalized..\" count:         \" ..\nstring.format( \"%4d\", record.count ) .. \"\\n\" )\noutfile:write( \"Time spend total:       \" ..\nstring.format( \"%4.3f\", record.time ) .. \"s\\n\" )\noutfile:write( \"Time spent in children: \" ..\nstring.format(\"%4.3f\",record.anon_child_time+record.name_child_time) ..\n\"s\\n\" )\nlocal timeinself =\nrecord.time - (record.anon_child_time + record.name_child_time)\noutfile:write( \"Time spent in self:     \" ..\nstring.format(\"%4.3f\", timeinself) .. \"s\\n\" )\noutfile:write( \"Time spent per \" .. terms.single .. \":  \" ..\nstring.format(\"%4.5f\", record.time/record.count) ..\n\"s/\" .. terms.single .. \"\\n\" )\noutfile:write( \"Time spent in self per \"..terms.single..\": \" ..\nstring.format( \"%4.5f\", timein"
	"self/record.count ) .. \"s/\" ..\nterms.single..\"\\n\" )\nlocal added_blank = 0\nfor k,v in pairs(record.children) do\nif self.prevented_functions[k] == nil or\nself.prevented_functions[k] == 0\nthen\nif added_blank == 0 then\noutfile:write( \"\\n\" ) -- extra separation line\nadded_blank = 1\nend\noutfile:write( \"Child \" .. self:_pretty_name(k) ..\nstring.rep( \" \", 41-string.len(self:_pretty_name(k)) ) .. \" \" ..\nterms.pastverb..\" \" .. string.format(\"%6d\", v) )\noutfile:write( \" times. Took \" ..\nstring.format(\"%4.2f\", record.children_time[k] ) .. \"s\\n\" )\nend\nend\noutfile:write( \"\\n\" ) -- extra separation line\noutfile:flush()\nend\noutfile:write( \"\\n\\n\" )\noutfile:write( \"Total time spent in profiled functions: \" ..\nstring.format(\"%5.3g\",total_time) .. \"s\\n\" )\noutfile:write( [[\nEND\n]] )\noutfile:flush()\nend\nfunction _profiler.lua_report(self,outfile)\nlocal ordering = {}\nlocal functonum = {}\nfor func,record in pairs(self.rawstats) do\ntable.insert(ordering, func)\nfu"
	"nctonum[func] = table.getn(ordering)\nend\noutfile:write(\n\"-- Profile generated by profiler.lua Copyright Pepperfish 2002+\\n\\n\" )\noutfile:write( \"-- Function names\\nfuncnames = {}\\n\" )\nfor i=1,table.getn(ordering) do\nlocal thisfunc = ordering[i]\noutfile:write( \"funcnames[\" .. i .. \"] = \" ..\nstring.format(\"%q\", self:_pretty_name(thisfunc)) .. \"\\n\" )\nend\noutfile:write( \"\\n\" )\noutfile:write( \"-- Function times\\nfunctimes = {}\\n\" )\nfor i=1,table.getn(ordering) do\nlocal thisfunc = ordering[i]\nlocal record = self.rawstats[thisfunc]\noutfile:write( \"functimes[\" .. i .. \"] = { \" )\noutfile:write( \"tot=\" .. record.time .. \", \" )\noutfile:write( \"achild=\" .. record.anon_child_time .. \", \" )\noutfile:write( \"nchild=\" .. record.name_child_time .. \", \" )\noutfile:write( \"count=\" .. record.count .. \" }\\n\" )\nend\noutfile:write( \"\\n\" )\noutfile:write( \"-- Child links\\nchildren = {}\\n\" )\nfor i=1,table.getn(ordering) do\nlocal thisfunc = ordering[i]\nlocal record"
	" = self.rawstats[thisfunc]\noutfile:write( \"children[\" .. i .. \"] = { \" )\nfor k,v in pairs(record.children) do\nif functonum[k] then -- non-recorded functions will be ignored now\noutfile:write( functonum[k] .. \", \" )\nend\nend\noutfile:write( \"}\\n\" )\nend\noutfile:write( \"\\n\" )\noutfile:write( \"-- Child call counts\\nchildcounts = {}\\n\" )\nfor i=1,table.getn(ordering) do\nlocal thisfunc = ordering[i]\nlocal record = self.rawstats[thisfunc]\noutfile:write( \"children[\" .. i .. \"] = { \" )\nfor k,v in record.children do\nif functonum[k] then -- non-recorded functions will be ignored now\noutfile:write( v .. \", \" )\nend\nend\noutfile:write( \"}\\n\" )\nend\noutfile:write( \"\\n\" )\noutfile:write( \"-- Child call time\\nchildtimes = {}\\n\" )\nfor i=1,table.getn(ordering) do\nlocal thisfunc = ordering[i]\nlocal record = self.rawstats[thisfunc];\noutfile:write( \"children[\" .. i .. \"] = { \" )\nfor k,v in pairs(record.children) do\nif functonum[k] then -- non-recorded functions will be ignor"
	"ed now\noutfile:write( record.children_time[k] .. \", \" )\nend\nend\noutfile:write( \"}\\n\" )\nend\noutfile:write( \"\\n\\n-- That is all.\\n\\n\" )\noutfile:flush()\nend\nfunction _profiler._pretty_name(self,func)\nlocal info = self.rawstats[ func ].func_info\nlocal name = \"\"\nif info.what == \"Lua\" then\nname = \"L:\"\nend\nif info.what == \"C\" then\nname = \"C:\"\nend\nif info.what == \"main\" then\nname = \" :\"\nend\nif info.name == nil then\nname = name .. \"<\"..tostring(func) .. \">\"\nelse\nname = name .. info.name\nend\nif info.source then\nname = name\nelse\nif info.what == \"C\" then\nname = name .. \"@?\"\nelse\nname = name .. \"@<string>\"\nend\nend\nname = name .. \":\"\nif info.what == \"C\" then\nname = name .. \"?\"\nelse\nname = name .. info.linedefined\nend\nreturn name\nend\nfunction _profiler.prevent(self, func, level)\nself.prevented_functions[func] = (level or 1)\nend\n_profiler.prevented_functions = {\n[_profiler.start] = 2,\n[_profiler.stop] = 2,\n[_profiler._internal_profile_by"
	"_time] = 2,\n[_profiler._internal_profile_by_call] = 2,\n[_profiler_hook_wrapper_by_time] = 2,\n[_profiler_hook_wrapper_by_call] = 2,\n[_profiler.prevent] = 2,\n[_profiler._get_func_rec] = 2,\n[_profiler.report] = 2,\n[_profiler.lua_report] = 2,\n[_profiler._pretty_name] = 2\n}\n",

	/* tools/dotnet.lua */
	"premake.dotnet = { }\npremake.dotnet.namestyle = \"windows\"\nlocal flags =\n{\nFatalWarning   = \"/warnaserror\",\nOptimize       = \"/optimize\",\nOptimizeSize   = \"/optimize\",\nOptimizeSpeed  = \"/optimize\",\nSymbols        = \"/debug\",\nUnsafe         = \"/unsafe\"\n}\nfunction premake.dotnet.getbuildaction(fcfg)\nlocal ext = path.getextension(fcfg.name):lower()\nif fcfg.buildaction == \"Compile\" or ext == \".cs\" then\nreturn \"Compile\"\nelseif fcfg.buildaction == \"Embed\" or ext == \".resx\" then\nreturn \"EmbeddedResource\"\nelseif fcfg.buildaction == \"Copy\" or ext == \".asax\" or ext == \".aspx\" then\nreturn \"Content\"\nelse\nreturn \"None\"\nend\nend\nfunction premake.dotnet.getcompilervar(cfg)\nif (_OPTIONS.dotnet == \"msnet\") then\nreturn \"csc\"\nelseif (_OPTIONS.dotnet == \"mono\") then\nif (cfg.framework <= \"1.1\") then\nreturn \"mcs\"\nelseif (cfg.framework >= \"4.0\") then\nreturn \"dmcs\"\nelse \nreturn \"gmcs\"\nend\nelse\nreturn \"cscc\"\nend\nend\nfunction premake.dotnet.getfla"
	"gs(cfg)\nlocal result = table.translate(cfg.flags, flags)\nreturn result\nend\nfunction premake.dotnet.getkind(cfg)\nif (cfg.kind == \"ConsoleApp\") then\nreturn \"Exe\"\nelseif (cfg.kind == \"WindowedApp\") then\nreturn \"WinExe\"\nelseif (cfg.kind == \"SharedLib\") then\nreturn \"Library\"\nend\nend",

	/* tools/gcc.lua */
	"premake.gcc = { }\npremake.gcc.cc     = \"gcc\"\npremake.gcc.cxx    = \"g++\"\npremake.gcc.ar     = \"ar\"\npremake.gcc.rc     = \"windres\"\npremake.gcc.llvm   = false\nlocal cflags =\n{\nEnableSSE        = \"-msse\",\nEnableSSE2       = \"-msse2\",\nEnableAVX        = \"-mavx\",\nEnableAVX2       = \"-mavx2\",\nPedanticWarnings = \"-Wall -Wextra -pedantic\",\nExtraWarnings    = \"-Wall -Wextra\",\nFatalWarnings    = \"-Werror\",\nFloatFast        = \"-ffast-math\",\nFloatStrict      = \"-ffloat-store\",\nNoFramePointer   = \"-fomit-frame-pointer\",\nOptimize         = \"-O2\",\nOptimizeSize     = \"-Os\",\nOptimizeSpeed    = \"-O3\",\nSymbols          = \"-g\",\n}\nlocal cxxflags =\n{\nNoExceptions   = \"-fno-exceptions\",\nNoRTTI         = \"-fno-rtti\",\nUnsignedChar   = \"-funsigned-char\",\n}\nlocal objcflags =\n{\nObjcARC     = \"-fobjc-arc\",\n}\npremake.gcc.platforms =\n{\nNative = {\ncppflags = \"-MMD -MP\",\n},\nx32 = {\ncppflags = \"-MMD -MP\",\nflags    = \"-m32\",\n},\nx64 = {\ncppflags = \"-MMD "
	"-MP\",\nflags    = \"-m64\",\n},\nUniversal = {\nar       = \"libtool\",\ncppflags = \"-MMD -MP\",\nflags    = \"-arch i386 -arch x86_64 -arch ppc -arch ppc64\",\n},\nUniversal32 = {\nar       = \"libtool\",\ncppflags = \"-MMD -MP\",\nflags    = \"-arch i386 -arch ppc\",\n},\nUniversal64 = {\nar       = \"libtool\",\ncppflags = \"-MMD -MP\",\nflags    = \"-arch x86_64 -arch ppc64\",\n},\nPS3 = {\ncc         = \"ppu-lv2-g++\",\ncxx        = \"ppu-lv2-g++\",\nar         = \"ppu-lv2-ar\",\ncppflags   = \"-MMD -MP\",\n},\nWiiDev = {\ncppflags    = \"-MMD -MP -I$(LIBOGC_INC) $(MACHDEP)\",\nldflags= \"-L$(LIBOGC_LIB) $(MACHDEP)\",\ncfgsettings = [[\n  ifeq ($(strip $(DEVKITPPC)),)\n    $(error \"DEVKITPPC environment variable is not set\")'\n  endif\n  include $(DEVKITPPC)/wii_rules']],\n},\nOrbis = {\ncc         = \"orbis-clang\",\ncxx        = \"orbis-clang++\",\nar         = \"orbis-ar\",\ncppflags   = \"-MMD -MP\",\n}\n}\nlocal platforms = premake.gcc.platforms\nfunction premake.gcc.getcppflags(cfg)\nlocal flags"
	" = { }\ntable.insert(flags, platforms[cfg.platform].cppflags)\nif flags[1]:startswith(\"-MMD\") then\ntable.insert(flags, \"-MP\")\nend\nreturn flags\nend\nfunction premake.gcc.getcflags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\ntable.insert(result, platforms[cfg.platform].flags)\nif cfg.system ~= \"windows\" and cfg.kind == \"SharedLib\" then\ntable.insert(result, \"-fPIC\")\nend\nreturn result\nend\nfunction premake.gcc.getcxxflags(cfg)\nlocal result = table.translate(cfg.flags, cxxflags)\nreturn result\nend\nfunction premake.gcc.getobjcflags(cfg)\nreturn table.translate(cfg.flags, objcflags)\nend\nfunction premake.gcc.getldflags(cfg)\nlocal result = { }\nif not cfg.flags.Symbols then\nif cfg.system == \"macosx\" then\nelse\ntable.insert(result, \"-s\")\nend\nend\nif cfg.kind == \"SharedLib\" then\nif cfg.system == \"macosx\" then\ntable.insert(result, \"-dynamiclib\")\nelse\ntable.insert(result, \"-shared\")\nend\nif cfg.system == \"windows\" and not cfg.flags.NoImportLib then\ntable.insert(r"
	"esult, '-Wl,--out-implib=\"' .. cfg.linktarget.fullpath .. '\"')\nend\nend\nif cfg.kind == \"WindowedApp\" and cfg.system == \"windows\" then\ntable.insert(result, \"-mwindows\")\nend\nlocal platform = platforms[cfg.platform]\ntable.insert(result, platform.flags)\ntable.insert(result, platform.ldflags)\nreturn result\nend\nfunction premake.gcc.getlibdirflags(cfg)\nlocal result = { }\nfor _, value in ipairs(premake.getlinks(cfg, \"all\", \"directory\")) do\ntable.insert(result, '-L' .. _MAKE.esc(value))\nend\nreturn result\nend\nfunction premake.gcc.islibfile(p)\nif path.getextension(p) == \".a\" then\nreturn true\nend\nreturn false\nend\nfunction premake.gcc.getlibfiles(cfg)\nlocal result = {}\nfor _, value in ipairs(premake.getlinks(cfg, \"system\", \"fullpath\")) do\nif premake.gcc.islibfile(value) then\ntable.insert(result, _MAKE.esc(value))\nend\nend\nreturn result\nend\nfunction premake.gcc.getlinkflags(cfg)\nlocal result = {}\nfor _, value in ipairs(premake.getlinks(cfg, \"system\", \"fullpath\")) do\nif"
	" premake.gcc.islibfile(value) then\nvalue = path.rebase(value, cfg.project.location, cfg.location)\ntable.insert(result, _MAKE.esc(value))\nelseif path.getextension(value) == \".framework\" then\ntable.insert(result, '-framework ' .. _MAKE.esc(path.getbasename(value)))\nelse\ntable.insert(result, '-l' .. _MAKE.esc(path.getname(value)))\nend\nend\nreturn result\nend\nfunction premake.gcc.getarchiveflags(prj, cfg, ndx)\nlocal result = {}\nif cfg.platform:startswith(\"Universal\") then\nif prj.options.ArchiveSplit then\nerror(\"gcc tool 'Universal*' platforms do not support split archives\")\nend\ntable.insert(result, '-o')\nelse\nif (not prj.options.ArchiveSplit) then\nif premake.gcc.llvm then\ntable.insert(result, 'rcs')\nelse\ntable.insert(result, '-rcs')\nend\nelse\nif premake.gcc.llvm then\nif (not ndx) then\ntable.insert(result, 'qc')\nelse\ntable.insert(result, 'cs')\nend\nelse\nif (not ndx) then\ntable.insert(result, '-qc')\nelse\ntable.insert(result, '-cs')\nend\nend\nend\nend\nreturn result\nend\nfuncti"
	"on premake.gcc.getdefines(defines)\nlocal result = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, \"-D\" .. def)\nend\nreturn result\nend\nfunction premake.gcc.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-I\\\"\" .. dir .. \"\\\"\")\nend\nreturn result\nend\nfunction premake.gcc.getquoteincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-iquote \\\"\" .. dir .. \"\\\"\")\nend\nreturn result\nend\nfunction premake.gcc.getcfgsettings(cfg)\nreturn platforms[cfg.platform].cfgsettings\nend\n",

	/* tools/ghs.lua */
	"premake.ghs = { }\npremake.ghs.namestyle = \"PS3\"\npremake.ghs.cc     = \"ccppc\"\npremake.ghs.cxx    = \"cxppc\"\npremake.ghs.ar     = \"cxppc\"\nlocal cflags =\n{\nFatalWarnings  = \"--quit_after_warnings\",\nOptimize       = \"-Ogeneral\",\nOptimizeSize   = \"-Osize\",\nOptimizeSpeed  = \"-Ospeed\",\nSymbols        = \"-g\",\n}\nlocal cxxflags =\n{\nNoExceptions   = \"--no_exceptions\",\nNoRTTI         = \"--no_rtti\",\nUnsignedChar   = \"--unsigned_chars\",\n}\npremake.ghs.platforms =\n{\nNative = {\ncppflags = \"-MMD\",\n},\nPowerPC = {\ncc         = \"ccppc\",\ncxx       = \"cxppc\",\nar       = \"cxppc\",\ncppflags   = \"-MMD\",\narflags    = \"-archive -o\",\n},\nARM = {\ncc         = \"ccarm\",\ncxx        = \"cxarm\",\nar         = \"cxarm\",\ncppflags   = \"-MMD\",\narflags    = \"-archive -o\",\n}\n}\nlocal platforms = premake.ghs.platforms\nfunction premake.ghs.getcppflags(cfg)\nlocal flags = { }\ntable.insert(flags, platforms[cfg.platform].cppflags)\nreturn flags\nend\nfunction premake.ghs.getcf"
	"lags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\ntable.insert(result, platforms[cfg.platform].flags)\nreturn result\nend\nfunction premake.ghs.getcxxflags(cfg)\nlocal result = table.translate(cfg.flags, cxxflags)\nreturn result\nend\nfunction premake.ghs.getldflags(cfg)\nlocal result = { }\nlocal platform = platforms[cfg.platform]\ntable.insert(result, platform.flags)\ntable.insert(result, platform.ldflags)\nreturn result\nend\nfunction premake.ghs.getlibdirflags(cfg)\nlocal result = { }\nfor _, value in ipairs(premake.getlinks(cfg, \"all\", \"directory\")) do\ntable.insert(result, '-L' .. _MAKE.esc(value))\nend\nreturn result\nend\nfunction premake.ghs.getlibfiles(cfg)\nlocal result = {}\nreturn result\nend\nfunction premake.ghs.getlinkflags(cfg)\nlocal result = {}\nfor _, value in ipairs(premake.getlinks(cfg, \"system\", \"name\")) do\ntable.insert(result, '-lnk=' .. _MAKE.esc(value))\nend\nreturn result\nend\nfunction premake.ghs.getarchiveflags(prj, cfg, ndx)\nif prj.options.ArchiveSplit then"
	"\nerror(\"ghs tool does not support split archives\")\nend\nlocal result = {}\nlocal platform = platforms[cfg.platform]\ntable.insert(result, platform.arflags)\nreturn result\nend\nfunction premake.ghs.getdefines(defines)\nlocal result = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, '-D' .. def)\nend\nreturn result\nend\nfunction premake.ghs.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-I\" .. _MAKE.esc(dir))\nend\nreturn result\nend\nfunction premake.ghs.getcfgsettings(cfg)\nreturn platforms[cfg.platform].cfgsettings\nend\n",

	/* tools/msc.lua */
	"premake.msc = { }\npremake.msc.namestyle = \"windows\"\n",

	/* tools/ow.lua */
	"premake.ow = { }\npremake.ow.namestyle = \"windows\"\npremake.ow.cc     = \"WCL386\"\npremake.ow.cxx    = \"WCL386\"\npremake.ow.ar     = \"ar\"\nlocal cflags =\n{\nPedanticWarnings = \"-wx\",\nExtraWarnings    = \"-wx\",\nFatalWarning     = \"-we\",\nFloatFast        = \"-omn\",\nFloatStrict      = \"-op\",\nOptimize         = \"-ox\",\nOptimizeSize     = \"-os\",\nOptimizeSpeed    = \"-ot\",\nSymbols          = \"-d2\",\n}\nlocal cxxflags =\n{\nNoExceptions   = \"-xd\",\nNoRTTI         = \"-xr\",\n}\npremake.ow.platforms =\n{\nNative = {\nflags = \"\"\n},\n}\nfunction premake.ow.getcppflags(cfg)\nreturn {}\nend\nfunction premake.ow.getcflags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\nif (cfg.flags.Symbols) then\ntable.insert(result, \"-hw\")   -- Watcom debug format for Watcom debugger\nend\nreturn result\nend\nfunction premake.ow.getcxxflags(cfg)\nlocal result = table.translate(cfg.flags, cxxflags)\nreturn result\nend\nfunction premake.ow.getldflags(cfg)\nlocal result = { }\nif (cfg.flags.Symb"
	"ols) then\ntable.insert(result, \"op symf\")\nend\nreturn result\nend\nfunction premake.ow.getlibfiles(cfg)\nlocal result = {}\nreturn result\nend\nfunction premake.ow.getlinkflags(cfg)\nlocal result = { }\nreturn result\nend\nfunction premake.ow.getdefines(defines)\nlocal result = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, '-D' .. def)\nend\nreturn result\nend\nfunction premake.ow.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, '-I \"' .. dir .. '\"')\nend\nreturn result\nend\n",

	/* tools/snc.lua */
	"premake.snc = { }\npremake.snc.cc     = \"snc\"\npremake.snc.cxx    = \"g++\"\npremake.snc.ar     = \"ar\"\nlocal cflags =\n{\nPedanticWarnings = \"-Xdiag=2\",\nExtraWarnings    = \"-Xdiag=2\",\nFatalWarnings    = \"-Xquit=2\",\n}\nlocal cxxflags =\n{\nNoExceptions   = \"\", -- No exceptions is the default in the SNC compiler.\nNoRTTI         = \"-Xc-=rtti\",\n}\npremake.snc.platforms =\n{\nPS3 = {\ncc         = \"ppu-lv2-g++\",\ncxx        = \"ppu-lv2-g++\",\nar         = \"ppu-lv2-ar\",\ncppflags   = \"-MMD -MP\",\n}\n}\nlocal platforms = premake.snc.platforms\nfunction premake.snc.getcppflags(cfg)\nlocal result = { }\ntable.insert(result, platforms[cfg.platform].cppflags)\nreturn result\nend\nfunction premake.snc.getcflags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\ntable.insert(result, platforms[cfg.platform].flags)\nif cfg.kind == \"SharedLib\" then\ntable.insert(result, \"-fPIC\")\nend\nreturn result\nend\nfunction premake.snc.getcxxflags(cfg)\nlocal result = table.translate(cfg.flags, cxxfl"
	"ags)\nreturn result\nend\nfunction premake.snc.getldflags(cfg)\nlocal result = { }\nif not cfg.flags.Symbols then\ntable.insert(result, \"-s\")\nend\nif cfg.kind == \"SharedLib\" then\ntable.insert(result, \"-shared\")\nif not cfg.flags.NoImportLib then\ntable.insert(result, '-Wl,--out-implib=\"' .. cfg.linktarget.fullpath .. '\"')\nend\nend\nlocal platform = platforms[cfg.platform]\ntable.insert(result, platform.flags)\ntable.insert(result, platform.ldflags)\nreturn result\nend\nfunction premake.snc.getlibdirflags(cfg)\nlocal result = { }\nfor _, value in ipairs(premake.getlinks(cfg, \"all\", \"directory\")) do\ntable.insert(result, '-L' .. _MAKE.esc(value))\nend\nreturn result\nend\nfunction premake.snc.getlibfiles(cfg)\nlocal result = {}\nreturn result\nend\nfunction premake.snc.getlinkflags(cfg)\nlocal result = {}\nfor _, value in ipairs(premake.getlinks(cfg, \"system\", \"name\")) do\ntable.insert(result, '-l' .. _MAKE.esc(value))\nend\nreturn result\nend\nfunction premake.snc.getdefines(defines)\nlocal r"
	"esult = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, '-D' .. def)\nend\nreturn result\nend\nfunction premake.snc.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-I\" .. _MAKE.esc(dir))\nend\nreturn result\nend\n",

	/* tools/valac.lua */
	"premake.valac = { }\npremake.valac.valac  = \"valac\"\npremake.valac.cc     = \"gcc\"\nlocal valaflags =\n{\nDisableAssert             = \"--disable-assert\",               -- Disable assertions\nDisableSinceCheck         = \"--disable-since-check\",          -- Do not check whether used symbols exist in local packages\nDisableWarnings           = \"--disable-warnings\",             -- Disable warnings\nEnableChecking            = \"--enable-checking\",              -- Enable additional run-time checks\nEnableDeprecated          = \"--enable-deprecated\",            -- Enable deprecated features\nEnableExperimental        = \"--enable-experimental\",          -- Enable experimental features\nEnableExperimentalNonNull = \"--enable-experimental-non-null\", -- Enable experimental enhancements for non-null types\nEnableGObjectTracing      = \"--enable-gobject-tracing\",       -- Enable GObject creation tracing\nEnableMemProfiler         = \"--enable-mem-profiler\",          -- Enable GLib memory profiler\nEnableTh"
	"reading           = \"--thread\",                       -- Enable multithreading support\nFatalWarnings             = \"--fatal-warnings\",               -- Treat warnings as fatal\nHideInternal              = \"--hide-internal\",                -- Hide symbols marked as internal\nNoStdPkg                  = \"--nostdpkg\",                     -- Do not include standard packages\nOptimize                  = \"-X -O2\",\nOptimizeSize              = \"-X -Os\",\nOptimizeSpeed             = \"-X -O3\",\nSymbols                   = \"-g\",                             -- Produce debug information\n}\npremake.valac.platforms = {}\nfunction premake.valac.getvalaflags(cfg)\nreturn table.translate(cfg.flags, valaflags)\nend\nfunction premake.valac.getlinks(links)\nlocal result = { }\nfor _, pkg in ipairs(links) do\ntable.insert(result, '--pkg ' .. pkg)\nend\nreturn result\nend\nfunction premake.valac.getdefines(defines)\nlocal result = { }\nfor _, def in ipairs(defines) do\ntable.insert(result, '-D ' .. def)\nend\nretu"
	"rn result\nend\nfunction premake.valac.getbuildoptions(buildoptions)\nlocal result = { }\nfor _, def in ipairs(buildoptions) do\ntable.insert(result, '-X ' .. def)\nend\nreturn result\nend\nfunction premake.valac.getvapidirs(vapidirs)\nlocal result = { }\nfor _, def in ipairs(vapidirs) do\ntable.insert(result, '--vapidir=' .. def)\nend\nreturn result\nend\n",

	/* tools/swift.lua */
	"premake.swift = { }\npremake.swift.swiftc   = \"swiftc\"\npremake.swift.swift    = \"swift\"\npremake.swift.cc       = \"gcc\"\npremake.swift.ar       = \"ar\"\npremake.swift.ld       = \"ld\"\npremake.swift.dsymutil = \"dsymutil\"\nlocal swiftcflags =\n{\nSymbols                   = \"-g\",                             -- Produce debug information\nDisableWarnings           = \"--suppress-warnings\",            -- Disable warnings\nFatalWarnings             = \"--warnings-as-errors\",           -- Treat warnings as fatal\nOptimize                  = \"-O -whole-module-optimization\",\nOptimizeSize              = \"-O -whole-module-optimization\",\nOptimizeSpeed             = \"-Ounchecked -whole-module-optimization\",\nMinimumWarnings           = \"-minimum-warnings\",\n}\nlocal swiftlinkflags = {\nStaticRuntime             = \"-static-stdlib\",\n}\npremake.swift.platforms = {\nNative = {\nswiftcflags    = \"\",\nswiftlinkflags = \"\",\n},\nx64 = {\nswiftcflags    = \"\",\nswiftlinkflags = \"\",\n}\n}\nlocal p"
	"latforms = premake.swift.platforms\nfunction premake.swift.get_sdk_path(cfg)\nreturn string.trim(os.outputof(\"xcrun --show-sdk-path\"))\nend\nfunction premake.swift.get_sdk_platform_path(cfg)\nreturn string.trim(os.outputof(\"xcrun --show-sdk-platform-path\"))\nend\nfunction premake.swift.get_toolchain_path(cfg)\nreturn string.trim(os.outputof(\"xcode-select -p\")) .. \"/Toolchains/XcodeDefault.xctoolchain\"\nend\nfunction premake.swift.gettarget(cfg)\nreturn \"-target x86_64-apple-macosx10.11\"\nend\nfunction premake.swift.getswiftcflags(cfg)\nlocal result = table.translate(cfg.flags, swiftcflags)\ntable.insert(result, platforms[cfg.platform].swiftcflags)\nresult = table.join(result, cfg.buildoptions_swift)\nif cfg.kind == \"SharedLib\" or cfg.kind == \"StaticLib\" then\ntable.insert(result, \"-parse-as-library\")\nend\ntable.insert(result, premake.swift.gettarget(cfg))\nreturn result\nend\nfunction premake.swift.getswiftlinkflags(cfg)\nlocal result = table.translate(cfg.flags, swiftlinkflags)\ntable.insert("
	"result, platforms[cfg.platform].swiftlinkflags)\nresult = table.join(result, cfg.linkoptions_swift)\nif cfg.kind == \"SharedLib\" or cfg.kind == \"StaticLib\" then\ntable.insert(result, \"-emit-library\")\nelse\ntable.insert(result, \"-emit-executable\")\nend\ntable.insert(result, premake.swift.gettarget(cfg))\nreturn result\nend\nfunction premake.swift.getmodulemaps(cfg)\nlocal maps = {}\nif next(cfg.swiftmodulemaps) then\nfor _, mod in ipairs(cfg.swiftmodulemaps) do\ntable.insert(maps, string.format(\"-Xcc -fmodule-map-file=%s\", mod))\nend\nend\nreturn maps\nend\nfunction premake.swift.getlibdirflags(cfg)\nreturn premake.gcc.getlibdirflags(cfg)\nend\nfunction premake.swift.getldflags(cfg)\nlocal result = { platforms[cfg.platform].ldflags }\nlocal links = premake.getlinks(cfg, \"siblings\", \"basename\")\nfor _,v in ipairs(links) do\nif path.getextension(v) == \".framework\" then\ntable.insert(result, \"-framework \"..v)\nelse\ntable.insert(result, \"-l\"..v)\nend\nend\nreturn result\nend\nfunction premake.s"
	"wift.getlinkflags(cfg)\nreturn premake.gcc.getlinkflags(cfg)\nend\nfunction premake.swift.getarchiveflags(cfg)\nreturn \"\"\nend\n",

	/* base/validate.lua */
	"function premake.checkprojects()\nlocal action = premake.action.current()\nfor sln in premake.solution.each() do\nif (#sln.projects == 0) then\nreturn nil, \"solution '\" .. sln.name .. \"' needs at least one project\"\nend\nif (#sln.configurations == 0) then\nreturn nil, \"solution '\" .. sln.name .. \"' needs configurations\"\nend\nfor prj in premake.solution.eachproject(sln) do\nif (not prj.language) then\nreturn nil, \"project '\" ..prj.name .. \"' needs a language\"\nend\nif (action.valid_languages) then\nif (not table.contains(action.valid_languages, prj.language)) then\nreturn nil, \"the \" .. action.shortname .. \" action does not support \" .. prj.language .. \" projects\"\nend\nend\nfor cfg in premake.eachconfig(prj) do\nif (not cfg.kind) then\nreturn nil, \"project '\" ..prj.name .. \"' needs a kind in configuration '\" .. cfg.name .. \"'\"\nend\nif (action.valid_kinds) then\nif (not table.contains(action.valid_kinds, cfg.kind)) then\nreturn nil, \"the \" .. action.shortname .. \" action does not su"
	"pport \" .. cfg.kind .. \" projects\"\nend\nend\nend\nif action.oncheckproject then\naction.oncheckproject(prj)\nend\nend\nend\nreturn true\nend\nfunction premake.checktools()\nlocal action = premake.action.current()\nif (not action.valid_tools) then \nreturn true \nend\nfor tool, values in pairs(action.valid_tools) do\nif (_OPTIONS[tool]) then\nif (not table.contains(values, _OPTIONS[tool])) then\nreturn nil, \"the \" .. action.shortname .. \" action does not support /\" .. tool .. \"=\" .. _OPTIONS[tool] .. \" (yet)\"\nend\nelse\n_OPTIONS[tool] = values[1]\nend\nend\nreturn true\nend\n",

	/* base/help.lua */
	"function premake.showhelp()\nprintf(\"\")\nprintf(\"Usage: genie [options] action [arguments]\")\nprintf(\"\")\nprintf(\"OPTIONS\")\nprintf(\"\")\nfor option in premake.option.each() do\nlocal trigger = option.trigger\nlocal description = option.description\nif (option.value) then trigger = trigger .. \"=\" .. option.value end\nif (option.allowed) then description = description .. \"; one of:\" end\nprintf(\" --%-15s %s\", trigger, description)\nif (option.allowed) then\nfor _, value in ipairs(option.allowed) do\nprintf(\"     %-14s %s\", value[1], value[2])\nend\nend\nprintf(\"\")\nend\nprintf(\"ACTIONS\")\nprintf(\"\")\nfor action in premake.action.each() do\nprintf(\" %-17s %s\", action.trigger, action.description)\nend\nprintf(\"\")\nprintf(\"For additional information, see https://github.com/bkaradzic/genie\")\nend\n",

	/* base/premake.lua */
	"premake._filelevelconfig = false\npremake._checkgenerate = true\nfunction premake.generate(obj, filename, callback)\nfilename = premake.project.getfilename(obj, filename)\nif (premake._checkgenerate) then\nio.capture()\ncallback(obj)\nlocal new = io.endcapture()\nlocal delta = false\nlocal f, err = io.open(filename, \"rb\")\nif (not f) then\nif string.find(err, \"No such file or directory\") then\ndelta = true\nelse\nerror(err, 0)\nend\nelse\nlocal existing = f:read(\"*all\")\nif existing ~= new then\ndelta = true\nend\nf:close()\nend\nif delta then\nprintf(\"Generating %s...\", filename)\nlocal f, err = io.open(filename, \"wb\")\nif (not f) then\nerror(err, 0)\nend\nf:write(new)\nf:close()\npremake.stats.num_generated = premake.stats.num_generated + 1\nelse\npremake.stats.num_skipped = premake.stats.num_skipped + 1\nend\nelse\nprintf(\"Generating %s...\", filename)\nlocal f, err = io.open(filename, \"wb\")\nif (not f) then\nerror(err, 0)\nend\nio.output(f)\ncallback(obj)\nf:close()\npremake.stats.num_generate"
	"d = premake.stats.num_generated + 1\nend\nend\nfunction premake.findDefaultScript(dir, search_upwards)\nsearch_upwards = search_upwards or true\nlocal last = \"\"\nwhile dir ~= last do\nfor _, name in ipairs({ \"genie.lua\", \"solution.lua\", \"premake4.lua\" }) do\nlocal script0 = dir .. \"/\" .. name\nif (os.isfile(script0)) then\nreturn dir, name\nend\nlocal script1 = dir .. \"/scripts/\" .. name\nif (os.isfile(script1)) then\nreturn dir .. \"/scripts/\", name\nend\nend\nlast = dir\ndir  = path.getabsolute(dir .. \"/..\")\nif dir == \".\" or not search_upwards then break end\nend\nreturn nil, nil\nend\n",

	/* base/iter.lua */
	"iter = {}\nfunction iter.sortByKeys(arr, f)\nlocal a = table.keys(arr)\ntable.sort(a, f)\nlocal i = 0\nreturn function()\ni = i + 1\nif a[i] ~= nil then \nreturn a[i], arr[a[i]]\nend\nend\nend\n",

	/* base/set.lua */
	"Set_mt = {}\nfunction Set(t)\nlocal set = {}\nfor k, l in ipairs(t) do \nset[l] = true \nend\nsetmetatable(set, Set_mt)\nreturn set\nend\nfunction Set_mt.union(a, b)\nlocal res = Set{}\nfor k in pairs(a) do res[k] = true end\nfor k in pairs(b) do res[k] = true end\nreturn res\nend\nfunction Set_mt.intersection(a, b)\nlocal res = Set{}\nfor k in pairs(a) do\nres[k] = b[k]\nend\nreturn res\nend\nlocal function get_cache(a)\nif not rawget(a, \"__cache\") then\nrawset(a, \"__cache\", Set_mt.totable(a))\nend\nreturn rawget(a, \"__cache\")\nend\nfunction Set_mt.len(a)\nreturn #get_cache(a)\nend\nfunction Set_mt.implode(a, sep)\nreturn table.concat(get_cache(a), sep)\nend\nfunction Set_mt.totable(a)\nlocal res = {}\nfor k in pairs(a) do\ntable.insert(res, k)\nend\nreturn res\nend\nfunction Set_mt.difference(a, b)\nif getmetatable(b) ~= Set_mt then\nif type(b) ~= \"table\" then\nerror(type(b)..\" is not a Set or table\")\nend\nb=Set(b)\nend\nlocal res = Set{}\nfor k in pairs(a) do\nres[k] = not b[k] or nil\nend\nrawse"
	"t(res, \"__cache\", nil)\nreturn res\nend\nfunction Set_mt.__index(a, i)\nif type(i) == \"number\" then\nreturn get_cache(a)[i]\nend\nreturn Set_mt[i] or rawget(a, i)\nend\nSet_mt.__add = Set_mt.union\nSet_mt.__mul = Set_mt.intersection\nSet_mt.__sub = Set_mt.difference\nSet_mt.__len = Set_mt.len\nSet_mt.__concat = Set_mt.implode",

	/* actions/cmake/_cmake.lua */
	"premake.cmake = { }\nnewaction {\ntrigger         = \"cmake\",\nshortname       = \"CMake\",\ndescription     = \"Generate CMake project files\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc   = { \"gcc\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"CMakeLists.txt\", premake.cmake.workspace)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%/CMakeLists.txt\", premake.cmake.project)\nend,\noncleansolution = function(sln)\npremake.clean.file(sln, \"CMakeLists.txt\")\nend,\noncleanproject = function(prj)\npremake.clean.file(prj, \"%%/CMakeLists.txt\")\nend\n}",

	/* actions/cmake/cmake_workspace.lua */
	"function premake.cmake.workspace(sln)\nif (sln.location ~= _WORKING_DIR) then\nlocal name = string.format(\"%s/CMakeLists.txt\", _WORKING_DIR)\nlocal f, err = io.open(name, \"wb\")\nif (not f) then\nerror(err, 0)\nend\nf:write('# CMakeLists autogenerated by GENie\\n')\nf:write('cmake_minimum_required(VERSION 2.8.4)\\n')\nf:write('\\n')\nf:write('add_subdirectory('.. path.getrelative(_WORKING_DIR, sln.location) ..')\\n')\nf:close()\nend\n_p('# CMakeLists autogenerated by GENie')\n_p('cmake_minimum_required(VERSION 2.8.4)')\n_p('')\nfor i,prj in ipairs(sln.projects) do\nlocal name = premake.esc(prj.name)\n_p('add_subdirectory(%s)', name)\nend\nend\n",

	/* actions/cmake/cmake_project.lua */
	"local cmake = premake.cmake\nlocal tree = premake.tree\nlocal includestr = 'include_directories(../%s)'\nlocal definestr = 'add_definitions(-D%s)'\nlocal function is_excluded(prj, cfg, file)\n    if table.icontains(prj.excludes, file) then\n        return true\n    end\n    if table.icontains(cfg.excludes, file) then\n        return true\n    end\n    return false\nend\nfunction cmake.excludedFiles(prj, cfg, src)\n    for _, v in ipairs(src) do\n        if (is_excluded(prj, cfg, v)) then\n            _p(1, 'list(REMOVE_ITEM source_list ../%s)', v)\n        end\n    end\nend\nfunction cmake.list(value)\n    if #value > 0 then\n        return \" \" .. table.concat(value, \" \")\n    else\n        return \"\"\n    end\nend\nfunction cmake.files(prj)\n    local ret = {}\n    local tr = premake.project.buildsourcetree(prj)\n    tree.traverse(tr, {\n        onbranchenter = function(node, depth)\n        end,\n        onbranchexit = function(node, depth)\n        end,\n        onleaf = function(node, depth)\n        "
	"    table.insert(ret, node.cfg.name)\n            _p(1, '../%s', node.cfg.name)\n        end,\n    }, true, 1)\n    return ret\nend\nfunction cmake.header(prj)\n    _p('# %s project autogenerated by GENie', premake.action.current().shortname)\n    _p('cmake_minimum_required(VERSION 2.8.4)')\n    _p('')\n    _p('project(%s)', premake.esc(prj.name))\nend\nfunction cmake.customtasks(prj)\n    local dirs = {}\n    local tasks = {}\n    for _, custombuildtask in ipairs(prj.custombuildtask or {}) do\n        for _, buildtask in ipairs(custombuildtask or {}) do\n            table.insert(tasks, buildtask)\n            local d = string.format(\"${CMAKE_CURRENT_SOURCE_DIR}/../%s\", path.getdirectory(path.getrelative(prj.location, buildtask[2])))\n            if not table.contains(dirs, d) then\n                table.insert(dirs, d)\n                _p('file(MAKE_DIRECTORY \\\"%s\\\")', d)\n            end\n        end\n    end\n    _p('')\n    for _, buildtask in ipairs(tasks) do\n        local deps = string.format(\"${"
	"CMAKE_CURRENT_SOURCE_DIR}/../%s \", path.getrelative(prj.location, buildtask[1]))\n        local outputs = string.format(\"${CMAKE_CURRENT_SOURCE_DIR}/../%s \", path.getrelative(prj.location, buildtask[2]))\n        local msg = \"\"\n        for _, depdata in ipairs(buildtask[3] or {}) do\n            deps = deps .. string.format(\"${CMAKE_CURRENT_SOURCE_DIR}/../%s \", path.getrelative(prj.location, depdata))\n        end\n        _p('add_custom_command(')\n        _p(1, 'OUTPUT %s', outputs)\n        _p(1, 'DEPENDS %s', deps)\n        for _, cmdline in ipairs(buildtask[4] or {}) do\n            if (cmdline:sub(1, 1) ~= \"@\") then\n                local cmd = cmdline\n                local num = 1\n                for _, depdata in ipairs(buildtask[3] or {}) do\n                    cmd = string.gsub(cmd, \"%$%(\" .. num .. \"%)\", string.format(\"${CMAKE_CURRENT_SOURCE_DIR}/../%s \", path.getrelative(prj.location, depdata)))\n                    num = num + 1\n                end\n                cmd = string"
	".gsub(cmd, \"%$%(<%)\", string.format(\"${CMAKE_CURRENT_SOURCE_DIR}/../%s \", path.getrelative(prj.location, buildtask[1])))\n                cmd = string.gsub(cmd, \"%$%(@%)\", outputs)\n                _p(1, 'COMMAND %s', cmd)\n            else\n                msg = cmdline\n            end\n        end\n        _p(1, 'COMMENT \\\"%s\\\"', msg)\n        _p(')')\n        _p('')\n    end\nend\nfunction cmake.depRules(prj)\n    local maintable = {}\n    for _, dependency in ipairs(prj.dependency) do\n        for _, dep in ipairs(dependency) do\n            if path.issourcefile(dep[1]) then\n                local dep1 = premake.esc(path.getrelative(prj.location, dep[1]))\n                local dep2 = premake.esc(path.getrelative(prj.location, dep[2]))\n                if not maintable[dep1] then maintable[dep1] = {} end\n                table.insert(maintable[dep1], dep2)\n            end\n        end\n    end\n    for key, _ in pairs(maintable) do\n        local deplist = {}\n        local depsname = string.fo"
	"rmat('%s_deps', path.getname(key))\n        for _, d2 in pairs(maintable[key]) do\n            table.insert(deplist, d2)\n        end\n        _p('set(')\n        _p(1, depsname)\n        for _, v in pairs(deplist) do\n            _p(1, '${CMAKE_CURRENT_SOURCE_DIR}/../%s', v)\n        end\n        _p(')')\n        _p('')\n        _p('set_source_files_properties(')\n        _p(1, '\\\"${CMAKE_CURRENT_SOURCE_DIR}/../%s\\\"', key)\n        _p(1, 'PROPERTIES OBJECT_DEPENDS \\\"${%s}\\\"', depsname)\n        _p(')')\n        _p('')\n    end\nend\nfunction cmake.commonRules(conf, str)\n    local Dupes = {}\n    local t2 = {}\n    for _, cfg in ipairs(conf) do\n        local cfgd = iif(str == includestr, cfg.includedirs, cfg.defines)\n        for _, v in ipairs(cfgd) do\n            if(t2[v] == #conf - 1) then\n                _p(str, v)\n                table.insert(Dupes, v)\n            end\n            if not t2[v] then\n                t2[v] = 1\n            else\n                t2[v] = t2[v] + 1\n            e"
	"nd\n        end\n    end\n    return Dupes\nend\nfunction cmake.cfgRules(cfg, dupes, str)\n    for _, v in ipairs(cfg) do\n        if (not table.icontains(dupes, v)) then\n            _p(1, str, v)\n        end\n    end\nend\nfunction cmake.removeCrosscompiler(platforms)\n    for i = #platforms, 1, -1 do\n        if premake.platforms[platforms[i]].iscrosscompiler then\n            table.remove(platforms, i)\n        end\n    end\nend\nfunction cmake.project(prj)\n    io.indent = \"  \"\n    cmake.header(prj)\n    _p('set(')\n    _p('source_list')\n    local source_files = cmake.files(prj)\n    _p(')')\n    _p('')\n    local nativeplatform = iif(os.is64bit(), \"x64\", \"x32\")\n    local cc = premake.gettool(prj)\n    local platforms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\n    cmake.removeCrosscompiler(platforms)\n    local configurations = {}\n    for _, platform in ipairs(platforms) do\n        for cfg in premake.eachconfig(prj, platform) do\n            -- TODO: Extend support for "
	"32-bit targets on 64-bit hosts\n            if cfg.platform == nativeplatform then\n                table.insert(configurations, cfg)\n            end\n        end\n    end\n    local commonIncludes = cmake.commonRules(configurations, includestr)\n    local commonDefines = cmake.commonRules(configurations, definestr)\n    _p('')\n    for _, cfg in ipairs(configurations) do\n        _p('if(CMAKE_BUILD_TYPE MATCHES \\\"%s\\\")', cfg.name)\n        -- list excluded files\n        cmake.excludedFiles(prj, cfg, source_files)\n        -- add includes directories\n        cmake.cfgRules(cfg.includedirs, commonIncludes, includestr)\n        -- add build defines\n        cmake.cfgRules(cfg.defines, commonDefines, definestr)\n        -- set CXX flags\n        _p(1, 'set(CMAKE_CXX_FLAGS \\\"${CMAKE_CXX_FLAGS} %s\\\")', cmake.list(table.join(cc.getcppflags(cfg), cc.getcflags(cfg), cc.getcxxflags(cfg), cfg.buildoptions, cfg.buildoptions_cpp)))\n        -- set C flags\n        _p(1, 'set(CMAKE_C_FLAGS \\\"${CMAKE_C_FLAGS} %"
	"s\\\")', cmake.list(table.join(cc.getcppflags(cfg), cc.getcflags(cfg), cfg.buildoptions, cfg.buildoptions_c)))\n        _p('endif()')\n        _p('')\n    end\n    -- force CPP if needed\n    if (prj.options.ForceCPP) then\n        _p('set_source_files_properties(${source_list} PROPERTIES LANGUAGE CXX)')\n    end\n    -- add custom tasks\n    cmake.customtasks(prj)\n    -- per-dependency build rules\n    cmake.depRules(prj)\n    for _, cfg in ipairs(configurations) do\n        _p('if(CMAKE_BUILD_TYPE MATCHES \\\"%s\\\")', cfg.name)\n        if (prj.kind == 'StaticLib') then\n            _p(1, 'add_library(%s STATIC ${source_list})', premake.esc(cfg.buildtarget.basename))\n        end\n        if (prj.kind == 'SharedLib') then\n            _p(1, 'add_library(%s SHARED ${source_list})', premake.esc(cfg.buildtarget.basename))\n        end\n        if (prj.kind == 'ConsoleApp' or prj.kind == 'WindowedApp') then\n            _p(1, 'add_executable(%s ${source_list})', premake.esc(cfg.buildtarget.basename))\n        "
	"    _p(1, 'target_link_libraries(%s%s%s)', premake.esc(cfg.buildtarget.basename), cmake.list(premake.esc(premake.getlinks(cfg, \"siblings\", \"basename\"))), cmake.list(cc.getlinkflags(cfg)))\n        end\n        _p('endif()')\n        _p('')\n    end\nend",

	/* actions/make/_make.lua */
	"_MAKE = { }\npremake.make = { }\nlocal make = premake.make\nfunction _MAKE.esc(value)\nlocal result\nif (type(value) == \"table\") then\nresult = { }\nfor _,v in ipairs(value) do\ntable.insert(result, _MAKE.esc(v))\nend\nreturn result\nelse\nresult = value:gsub(\"\\\\\", \"\\\\\\\\\")\nresult = result:gsub(\" \", \"\\\\ \")\nresult = result:gsub(\"%%(\", \"\\\\%(\")\nresult = result:gsub(\"%%)\", \"\\\\%)\")\nresult = result:gsub(\"$\\\\%((.-)\\\\%)\", \"$%(%1%)\")\nreturn result\nend\nend\nfunction premake.make_copyrule(source, target)\n_p('%s: %s', target, source)\n_p('\\t@echo Copying $(notdir %s)', target)\n_p('\\t-$(call COPY,%s,%s)', source, target)\nend\nfunction premake.make_mkdirrule(var)\n_p('\\t@echo Creating %s', var)\n_p('\\t-$(call MKDIR,%s)', var)\n_p('')\nend\nfunction make.list(value)\nif #value > 0 then\nreturn \" \" .. table.concat(value, \" \")\nelse\nreturn \"\"\nend\nend\nfunction _MAKE.getmakefilename(this, searchprjs)\nlocal count = 0\nfor sln in premake.solution.each() do\nif (sln.loca"
	"tion == this.location) then count = count + 1 end\nif (searchprjs) then\nfor _,prj in ipairs(sln.projects) do\nif (prj.location == this.location) then count = count + 1 end\nend\nend\nend\nif (count == 1) then\nreturn \"Makefile\"\nelse\nreturn this.name .. \".make\"\nend\nend\nfunction _MAKE.getnames(tbl)\nlocal result = table.extract(tbl, \"name\")\nfor k,v in pairs(result) do\nresult[k] = _MAKE.esc(v)\nend\nreturn result\nend\nfunction make.settings(cfg, cc)\nif #cfg.makesettings > 0 then\nfor _, value in ipairs(cfg.makesettings) do\n_p(value)\nend\nend\nlocal toolsettings = cc.platforms[cfg.platform].cfgsettings\nif toolsettings then\n_p(toolsettings)\nend\nend\nnewaction {\ntrigger         = \"gmake\",\nshortname       = \"GNU Make\",\ndescription     = \"Generate GNU makefiles for POSIX, MinGW, and Cygwin\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\", \"Vala\", \"Swift\" },\nvalid_tools     = {\ncc     = { "
	"\"gcc\", \"ghs\" },\ndotnet = { \"mono\", \"msnet\", \"pnet\" },\nvalac  = { \"valac\" },\nswift  = { \"swift\" },\n},\nonsolution = function(sln)\npremake.generate(sln, _MAKE.getmakefilename(sln, false), premake.make_solution)\nend,\nonproject = function(prj)\nlocal makefile = _MAKE.getmakefilename(prj, true)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, makefile, premake.make_csharp)\nelseif premake.iscppproject(prj) then\npremake.generate(prj, makefile, premake.make_cpp)\nelseif premake.isswiftproject(prj) then\npremake.generate(prj, makefile, premake.make_swift)\nelse\npremake.generate(prj, makefile, premake.make_vala)\nend\nend,\noncleansolution = function(sln)\npremake.clean.file(sln, _MAKE.getmakefilename(sln, false))\nend,\noncleanproject = function(prj)\npremake.clean.file(prj, _MAKE.getmakefilename(prj, true))\nend\n}\n",

	/* actions/make/make_solution.lua */
	"function premake.make_solution(sln)\nlocal cc = premake[_OPTIONS.cc]\nlocal platforms = premake.filterplatforms(sln, cc.platforms, \"Native\")\n_p('# %s solution makefile autogenerated by GENie', premake.action.current().shortname)\n_p('# Type \"make help\" for usage help')\n_p('')\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(premake.getconfigname(sln.configurations[1], platforms[1], true)))\n_p('endif')\n_p('export config')\n_p('')\nlocal projects = table.extract(sln.projects, \"name\")\ntable.sort(projects)\n_p('PROJECTS := %s', table.concat(_MAKE.esc(projects), \" \"))\n_p('')\n_p('.PHONY: all clean help $(PROJECTS)')\n_p('')\n_p('all: $(PROJECTS)')\n_p('')\nfor _, prj in ipairs(sln.projects) do\n_p('%s: %s', _MAKE.esc(prj.name), table.concat(_MAKE.esc(table.extract(premake.getdependencies(prj), \"name\")), \" \"))\nif (not sln.messageskip) or (not table.contains(sln.messageskip, \"SkipBuildingMessage\")) then\n_p('\\t@echo \"==== Building %s ($(config)) ====\"', prj.name)\nend\n_p('\\t@${MAKE} --no-pr"
	"int-directory -C %s -f %s', _MAKE.esc(path.getrelative(sln.location, prj.location)), _MAKE.esc(_MAKE.getmakefilename(prj, true)))\n_p('')\nend\n_p('clean:')\nfor _ ,prj in ipairs(sln.projects) do\n_p('\\t@${MAKE} --no-print-directory -C %s -f %s clean', _MAKE.esc(path.getrelative(sln.location, prj.location)), _MAKE.esc(_MAKE.getmakefilename(prj, true)))\nend\n_p('')\n_p('help:')\n_p(1,'@echo \"Usage: make [config=name] [target]\"')\n_p(1,'@echo \"\"')\n_p(1,'@echo \"CONFIGURATIONS:\"')\nlocal cfgpairs = { }\nfor _, platform in ipairs(platforms) do\nfor _, cfgname in ipairs(sln.configurations) do\n_p(1,'@echo \"   %s\"', premake.getconfigname(cfgname, platform, true))\nend\nend\n_p(1,'@echo \"\"')\n_p(1,'@echo \"TARGETS:\"')\n_p(1,'@echo \"   all (default)\"')\n_p(1,'@echo \"   clean\"')\nfor _, prj in ipairs(sln.projects) do\n_p(1,'@echo \"   %s\"', prj.name)\nend\n_p(1,'@echo \"\"')\n_p(1,'@echo \"For more information, see https://github.com/bkaradzic/genie\"')\nend\n",

	/* actions/make/make_cpp.lua */
	"premake.make.cpp = { }\npremake.make.override = { }\npremake.make.makefile_ignore = false\nlocal cpp = premake.make.cpp\nlocal make = premake.make\nfunction premake.make_cpp(prj)\nlocal cc = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\npremake.gmake_cpp_header(prj, cc, platforms)\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\npremake.gmake_cpp_config(prj, cfg, cc)\nend\nend\ntable.sort(prj.allfiles)\nlocal objdirs = {}\nlocal additionalobjdirs = {}\nfor _, file in ipairs(prj.allfiles) do\nif path.issourcefile(file) then\nobjdirs[_MAKE.esc(path.getdirectory(path.trimdots(file)))] = 1\nend\nend\nfor _, custombuildtask in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nadditionalobjdirs[_MAKE.esc(path.getdirectory(path.getrelative(prj.location,buildtask[2])))] = 1\nend\nend\n_p('OBJDIRS := \\\\')\n_p('\\t$(OBJDIR) \\\\')\nfor dir, _ in iter.sortByKeys(objdirs) do\n_p("
	"'\\t$(OBJDIR)/%s \\\\', dir)\nend\nfor dir, _ in iter.sortByKeys(additionalobjdirs) do\n_p('\\t%s \\\\', dir)\nend\n_p('')\n_p('RESOURCES := \\\\')\nfor _, file in ipairs(prj.allfiles) do\nif path.isresourcefile(file) then\n_p('\\t$(OBJDIR)/%s.res \\\\', _MAKE.esc(path.getbasename(file)))\nend\nend\n_p('')\n_p('.PHONY: clean prebuild prelink')\n_p('')\nif os.is(\"MacOSX\") and prj.kind == \"WindowedApp\" then\n_p('all: $(OBJDIRS) $(TARGETDIR) prebuild prelink $(TARGET) $(dir $(TARGETDIR))PkgInfo $(dir $(TARGETDIR))Info.plist')\nelse\n_p('all: $(OBJDIRS) $(TARGETDIR) prebuild prelink $(TARGET)')\nend\n_p('\\t@:')\n_p('')\nif (prj.kind == \"StaticLib\" and prj.options.ArchiveSplit) then\n_p('define max_args')\n_p('\\t$(eval _args:=)')\n_p('\\t$(foreach obj,$3,$(eval _args+=$(obj))$(if $(word $2,$(_args)),$1$(_args)$(EOL)$(eval _args:=)))')\n_p('\\t$(if $(_args),$1$(_args))')\n_p('endef')\n_p('')\n_p('define EOL')\n_p('')\n_p('')\n_p('endef')\n_p('')\nend\n_p('$(TARGET): $(GCH) $(OBJECTS) $(LDDEPS) $(EXTERNAL_LIB"
	"S) $(RESOURCES) | $(TARGETDIR) $(OBJDIRS)')\nif prj.kind == \"StaticLib\" then\nif prj.msgarchiving then\n_p('\\t@echo ' .. prj.msgarchiving)\nelse\n_p('\\t@echo Archiving %s', prj.name)\nend\nif (not prj.archivesplit_size) then\nprj.archivesplit_size=200\nend\nif (not prj.options.ArchiveSplit) then\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f  $(TARGET)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGET)) del $(subst /,\\\\\\\\,$(TARGET))')\n_p('endif')\n_p('\\t$(SILENT) $(LINKCMD) $(OBJECTS)' .. (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\"))\nelse\n_p('\\t$(call RM,$(TARGET))')\n_p('\\t@$(call max_args,$(LINKCMD),'.. prj.archivesplit_size ..',$(OBJECTS))' .. (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\"))\n_p('\\t$(SILENT) $(LINKCMD_NDX)')\nend\nelse\nif prj.msglinking then\n_p('\\t@echo ' .. prj.msglinking)\nelse\n_p('\\t@echo Linking %s', prj.name)\nend\n_p('\\t$(SILENT) $(LINKCMD)')\nend\n_p("
	"'\\t$(POSTBUILDCMDS)')\n_p('')\n_p('$(TARGETDIR):')\npremake.make_mkdirrule(\"$(TARGETDIR)\")\n_p('$(OBJDIRS):')\nif (not prj.solution.messageskip) or (not table.contains(prj.solution.messageskip, \"SkipCreatingMessage\")) then\n_p('\\t@echo Creating $(@)')\nend\n_p('\\t-$(call MKDIR,$@)')\n_p('')\nif os.is(\"MacOSX\") and prj.kind == \"WindowedApp\" then\n_p('$(dir $(TARGETDIR))PkgInfo:')\n_p('$(dir $(TARGETDIR))Info.plist:')\n_p('')\nend\n_p('clean:')\nif (not prj.solution.messageskip) or (not table.contains(prj.solution.messageskip, \"SkipCleaningMessage\")) then\n_p('\\t@echo Cleaning %s', prj.name)\nend\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f  $(TARGET)')\n_p('\\t$(SILENT) rm -rf $(OBJDIR)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGET)) del $(subst /,\\\\\\\\,$(TARGET))')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(OBJDIR)) rmdir /s /q $(subst /,\\\\\\\\,$(OBJDIR))')\n_p('endif')\n_p('')\n_p('prebuild:')\n_p('\\t$(PREBUILDCMDS)')\n_p('')\n_p('prelink:')\n_p('\\t"
	"$(PRELINKCMDS)')\n_p('')\ncpp.pchrules(prj)\ncpp.fileRules(prj, cc)\ncpp.dependencyRules(prj)\nfor _, custombuildtask in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nlocal deps =  string.format(\"%s \",path.getrelative(prj.location,buildtask[1]))\nfor _, depdata in ipairs(buildtask[3] or {}) do\ndeps = deps .. string.format(\"%s \",path.getrelative(prj.location,depdata))\nend\n_p('%s: %s | $(TARGETDIR) $(OBJDIRS)'\n,path.getrelative(prj.location,buildtask[2])\n, deps\n)\nfor _, cmdline in ipairs(buildtask[4] or {}) do\nlocal cmd = cmdline\nlocal num = 1\nfor _, depdata in ipairs(buildtask[3] or {}) do\ncmd = string.gsub(cmd,\"%$%(\" .. num ..\"%)\", string.format(\"%s \",path.getrelative(prj.location,depdata)))\nnum = num + 1\nend\ncmd = string.gsub(cmd, \"%$%(<%)\", \"$<\")\ncmd = string.gsub(cmd, \"%$%(@%)\", \"$@\")\n_p('\\t$(SILENT) %s',cmd)\nend\n_p('')\nend\nend\n_p('-include $(OBJECTS:%%.o=%%.d)')\n_p('ifneq (,$(PCH))')\n_p('  -include $(OBJDIR)/$(notdir $("
	"PCH)).d')\n_p('  -include $(OBJDIR)/$(notdir $(PCH))_objc.d')\n_p('endif')\nend\nfunction premake.gmake_cpp_header(prj, cc, platforms)\n_p('# %s project makefile autogenerated by GENie', premake.action.current().shortname)\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(premake.getconfigname(prj.solution.configurations[1], platforms[1], true)))\n_p('endif')\n_p('')\n_p('ifndef verbose')\n_p('  SILENT = @')\n_p('endif')\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(MAKESHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('  MKDIR = $(SILENT) mkdir -p \"$(1)\"')\n_p('  COPY  = $(SILENT) cp -fR \"$(1)\" \"$(2)\"')\n_p('  RM    = $(SILENT) rm -f \"$(1)\"')\n_p('else')\n_p('  MKDIR = $(SILENT) mkdir \"$(subst /,\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p('  COPY  = $(SILENT) copy /Y \"$(s"
	"ubst /,\\\\\\\\,$(1))\" \"$(subst /,\\\\\\\\,$(2))\"')\n_p('  RM    = $(SILENT) del /F \"$(subst /,\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p('endif')\n_p('')\n_p('CC  = %s', cc.cc)\n_p('CXX = %s', cc.cxx)\n_p('AR  = %s', cc.ar)\n_p('')\n_p('ifndef RESCOMP')\n_p('  ifdef WINDRES')\n_p('    RESCOMP = $(WINDRES)')\n_p('  else')\n_p('    RESCOMP = %s', cc.rc or 'windres')\n_p('  endif')\n_p('endif')\n_p('')\nif (not premake.make.makefile_ignore) then\n_p('MAKEFILE = %s', _MAKE.getmakefilename(prj, true))\n_p('')\nend\nend\nlocal function is_excluded(prj, cfg, file)\nif table.icontains(prj.excludes, file) then\nreturn true\nend\nif table.icontains(cfg.excludes, file) then\nreturn true\nend\nreturn false\nend\nfunction premake.gmake_cpp_config(prj, cfg, cc)\n_p('ifeq ($(config),%s)', _MAKE.esc(cfg.shortname))\ncpp.platformtools(cfg, cc)\n_p('  ' .. (table.contains(premake.make.override,\"OBJDIR\") and \"override \" or \"\") ..    'OBJDIR              = %s', _MAKE.esc(cfg.objectsdir))\n_p('  ' .. (table.contains(premak"
	"e.make.override,\"TARGETDIR\") and \"override \" or \"\") .. 'TARGETDIR           = %s', _MAKE.esc(cfg.buildtarget.directory))\n_p('  ' .. (table.contains(premake.make.override,\"TARGET\") and \"override \" or \"\") ..    'TARGET              = $(TARGETDIR)/%s', _MAKE.esc(cfg.buildtarget.name))\n_p('  DEFINES            +=%s', make.list(cc.getdefines(cfg.defines)))\n_p('  INCLUDES           +=%s', make.list(cc.getincludedirs(cfg.includedirs)))\n_p('  INCLUDES           +=%s', make.list(cc.getquoteincludedirs(cfg.userincludedirs)))\ncpp.pchconfig(cfg)\ncpp.flags(cfg, cc)\ncpp.linker(prj, cfg, cc)\ntable.sort(cfg.files)\n_p('  OBJECTS := \\\\')\nfor _, file in ipairs(cfg.files) do\nif path.issourcefile(file) then\nif not is_excluded(prj, cfg, file) then\n_p('\\t$(OBJDIR)/%s.o \\\\'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n)\nend\nend\nend\n_p('')\n_p('  define PREBUILDCMDS')\nif #cfg.prebuildcommands > 0 then\n_p('\\t@echo Running pre-build commands')\n_p('\\t%s', table.implode(cfg.prebuildcommands, \""
	"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define PRELINKCMDS')\nif #cfg.prelinkcommands > 0 then\n_p('\\t@echo Running pre-link commands')\n_p('\\t%s', table.implode(cfg.prelinkcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define POSTBUILDCMDS')\nif #cfg.postbuildcommands > 0 then\n_p('\\t@echo Running post-build commands')\n_p('\\t%s', table.implode(cfg.postbuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\nmake.settings(cfg, cc)\n_p('endif')\n_p('')\nend\nfunction cpp.platformtools(cfg, cc)\nlocal platform = cc.platforms[cfg.platform]\nif platform.cc then\n_p('  CC         = %s', platform.cc)\nend\nif platform.cxx then\n_p('  CXX        = %s', platform.cxx)\nend\nif platform.ar then\n_p('  AR         = %s', platform.ar)\nend\nend\nfunction cpp.flags(cfg, cc)\nif cfg.pchheader and not cfg.flags.NoPCH then\n_p('  FORCE_INCLUDE      += -include $(OBJDIR)/$(notdir $(PCH))')\n_p('  FORCE_INCLUDE_OBJC += -include $(OBJDIR)/$(notdir $(PCH))_objc')\nend\nif #cfg.forcedincludes > 0 t"
	"hen\n_p('  FORCE_INCLUDE      += -include %s'\n,_MAKE.esc(table.concat(cfg.forcedincludes, \";\")))\nend\n_p('  ALL_CPPFLAGS       += $(CPPFLAGS) %s $(DEFINES) $(INCLUDES)', table.concat(cc.getcppflags(cfg), \" \"))\n_p('  ALL_ASMFLAGS       += $(ASMFLAGS) $(CFLAGS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cfg.buildoptions, cfg.buildoptions_asm)))\n_p('  ALL_CFLAGS         += $(CFLAGS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cfg.buildoptions, cfg.buildoptions_c)))\n_p('  ALL_CXXFLAGS       += $(CXXFLAGS) $(CFLAGS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cc.getcxxflags(cfg), cfg.buildoptions, cfg.buildoptions_cpp)))\n_p('  ALL_OBJCFLAGS      += $(CFLAGS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cc.getobjcflags(cfg), cfg.buildoptions, cfg.buildoptions_objc)))\n_p('  ALL_OBJCPPFLAGS    += $(CXXFLAGS) $(CFLAGS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cc.getcxxflags(cfg), cc.geto"
	"bjcflags(cfg), cfg.buildoptions, cfg.buildoptions_objcpp)))\n_p('  ALL_RESFLAGS       += $(RESFLAGS) $(DEFINES) $(INCLUDES)%s',\n        make.list(table.join(cc.getdefines(cfg.resdefines),\n                                cc.getincludedirs(cfg.resincludedirs), cfg.resoptions)))\nend\nfunction cpp.linker(prj, cfg, cc)\n_p('  ALL_LDFLAGS        += $(LDFLAGS)%s', make.list(table.join(cc.getlibdirflags(cfg), cc.getldflags(cfg), cfg.linkoptions)))\n_p('  LDDEPS             +=%s', make.list(_MAKE.esc(premake.getlinks(cfg, \"siblings\", \"fullpath\"))))\n_p('  LIBS               += $(LDDEPS)%s', make.list(cc.getlinkflags(cfg)))\n_p('  EXTERNAL_LIBS      +=%s', make.list(cc.getlibfiles(cfg)))\nif cfg.kind == \"StaticLib\" then\nif (not prj.options.ArchiveSplit) then\n_p('  LINKCMD             = $(AR) %s $(TARGET)', make.list(cc.getarchiveflags(prj, cfg, false)))\nelse\n_p('  LINKCMD             = $(AR) %s $(TARGET)', make.list(cc.getarchiveflags(prj, cfg, false)))\n_p('  LINKCMD_NDX         = $(AR) %s $(TARGET)', make"
	".list(cc.getarchiveflags(prj, cfg, true)))\nend\nelse\nlocal tool = iif(cfg.language == \"C\", \"CC\", \"CXX\")\n_p('  LINKCMD             = $(%s) -o $(TARGET) $(OBJECTS) $(RESOURCES) $(ARCH) $(ALL_LDFLAGS) $(LIBS)', tool)\nend\nend\nfunction cpp.pchconfig(cfg)\nif not cfg.pchheader or cfg.flags.NoPCH then\nreturn\nend\nlocal pch = cfg.pchheader\nfor _, incdir in ipairs(cfg.includedirs) do\nlocal abspath = path.getabsolute(path.join(cfg.project.location, incdir))\nlocal testname = path.join(abspath, pch)\nif os.isfile(testname) then\npch = path.getrelative(cfg.location, testname)\nbreak\nend\nend\n_p('  PCH                 = %s', _MAKE.esc(pch))\n_p('  GCH                 = $(OBJDIR)/$(notdir $(PCH)).gch')\n_p('  GCH_OBJC            = $(OBJDIR)/$(notdir $(PCH))_objc.gch')\nend\nfunction cpp.pchrules(prj)\n_p('ifneq (,$(PCH))')\n_p('$(GCH): $(PCH) $(MAKEFILE) | $(OBJDIR)')\nif prj.msgprecompile then\n_p('\\t@echo ' .. prj.msgprecompile)\nelse\n_p('\\t@echo $(notdir $<)')\nend\nlocal cmd = iif(prj.language == \""
	"C\", \"$(CC) $(ALL_CFLAGS) -x c-header\", \"$(CXX) $(ALL_CXXFLAGS) -x c++-header\")\n_p('\\t$(SILENT) %s $(DEFINES) $(INCLUDES) -o \"$@\" -c \"$<\"', cmd)\n_p('')\n_p('$(GCH_OBJC): $(PCH) $(MAKEFILE) | $(OBJDIR)')\nif prj.msgprecompile then\n_p('\\t@echo ' .. prj.msgprecompile)\nelse\n_p('\\t@echo $(notdir $<)')\nend\nlocal cmd = iif(prj.language == \"C\", \"$(CC) $(ALL_OBJCFLAGS) -x objective-c-header\", \"$(CXX) $(ALL_OBJCPPFLAGS) -x objective-c++-header\")\n_p('\\t$(SILENT) %s $(DEFINES) $(INCLUDES) -o \"$@\" -c \"$<\"', cmd)\n_p('endif')\n_p('')\nend\nfunction cpp.fileRules(prj, cc)\nlocal platforms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\ntable.sort(prj.allfiles)\nfor _, file in ipairs(prj.allfiles or {}) do\nif path.issourcefile(file) then\nif (path.isobjcfile(file)) then\n_p('$(OBJDIR)/%s.o: %s $(GCH_OBJC) $(MAKEFILE)'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n, _MAKE.esc(file)\n)\nelse\n_p('$(OBJDIR)/%s.o: %s $(GCH) $(MAKEFILE)'\n, _MAKE.esc(path.trimdots(path.removee"
	"xt(file)))\n, _MAKE.esc(file)\n)\nend\nif (path.isobjcfile(file) and prj.msgcompile_objc) then\n_p('\\t@echo ' .. prj.msgcompile_objc)\nelseif prj.msgcompile then\n_p('\\t@echo ' .. prj.msgcompile)\nelse\n_p('\\t@echo $(notdir $<)')\nend\nif (path.isobjcfile(file)) then\nif (path.iscfile(file)) then\n_p('\\t$(SILENT) $(CXX) $(ALL_OBJCFLAGS) $(FORCE_INCLUDE_OBJC) -o \"$@\" -c \"$<\"')\nelse\n_p('\\t$(SILENT) $(CXX) $(ALL_OBJCPPFLAGS) $(FORCE_INCLUDE_OBJC) -o \"$@\" -c \"$<\"')\nend\nelseif (path.isasmfile(file)) then\n_p('\\t$(SILENT) $(CC) $(ALL_ASMFLAGS) -o \"$@\" -c \"$<\"')\nelse\ncpp.buildcommand(path.iscfile(file) and not prj.options.ForceCPP, \"o\")\nend\nfor _, task in ipairs(prj.postcompiletasks or {}) do\n_p('\\t$(SILENT) %s', task)\n_p('')\nend\n_p('')\nelseif (path.getextension(file) == \".rc\") then\n_p('$(OBJDIR)/%s.res: %s', _MAKE.esc(path.getbasename(file)), _MAKE.esc(file))\nif prj.msgresource then\n_p('\\t@echo ' .. prj.msgresource)\nelse\n_p('\\t@echo $(notdir $<)')\nend\n_p('\\t$(SILENT) $(R"
	"ESCOMP) $< -O coff -o \"$@\" $(ALL_RESFLAGS)')\n_p('')\nend\nend\nend\nfunction cpp.dependencyRules(prj)\nfor _, dependency in ipairs(prj.dependency or {}) do\nfor _, dep in ipairs(dependency or {}) do\nif (dep[3]==nil or dep[3]==false) then\n_p('$(OBJDIR)/%s.o: %s'\n, _MAKE.esc(path.trimdots(path.removeext(path.getrelative(prj.location, dep[1]))))\n, _MAKE.esc(path.getrelative(prj.location, dep[2]))\n)\nelse\n_p('%s: %s'\n, _MAKE.esc(dep[1])\n, _MAKE.esc(path.getrelative(prj.location, dep[2]))\n)\nend\n_p('')\nend\nend\nend\nfunction cpp.buildcommand(iscfile, objext)\nlocal flags = iif(iscfile, '$(CC) $(ALL_CFLAGS)', '$(CXX) $(ALL_CXXFLAGS)')\n_p('\\t$(SILENT) %s $(FORCE_INCLUDE) -o \"$@\" -c \"$<\"', flags, objext)\nend\n",

	/* actions/make/make_csharp.lua */
	"local function getresourcefilename(cfg, fname)\nif path.getextension(fname) == \".resx\" then\n    local name = cfg.buildtarget.basename .. \".\"\n    local dir = path.getdirectory(fname)\n    if dir ~= \".\" then \nname = name .. path.translate(dir, \".\") .. \".\"\nend\nreturn \"$(OBJDIR)/\" .. _MAKE.esc(name .. path.getbasename(fname)) .. \".resources\"\nelse\nreturn fname\nend\nend\nfunction premake.make_csharp(prj)\nlocal csc = premake.dotnet\nlocal cfglibs = { }\nlocal cfgpairs = { }\nlocal anycfg\nfor cfg in premake.eachconfig(prj) do\nanycfg = cfg\ncfglibs[cfg] = premake.getlinks(cfg, \"siblings\", \"fullpath\")\ncfgpairs[cfg] = { }\nfor _, fname in ipairs(cfglibs[cfg]) do\nif path.getdirectory(fname) ~= cfg.buildtarget.directory then\ncfgpairs[cfg][\"$(TARGETDIR)/\" .. _MAKE.esc(path.getname(fname))] = _MAKE.esc(fname)\nend\nend\nend\nlocal sources = {}\nlocal embedded = { }\nlocal copypairs = { }\nfor fcfg in premake.project.eachfile(prj) do\nlocal action = csc.getbuildaction(fcfg)\nif action == \"Co"
	"mpile\" then\ntable.insert(sources, fcfg.name)\nelseif action == \"EmbeddedResource\" then\ntable.insert(embedded, fcfg.name)\nelseif action == \"Content\" then\ncopypairs[\"$(TARGETDIR)/\" .. _MAKE.esc(path.getname(fcfg.name))] = _MAKE.esc(fcfg.name)\nelseif path.getname(fcfg.name):lower() == \"app.config\" then\ncopypairs[\"$(TARGET).config\"] = _MAKE.esc(fcfg.name)\nend\nend\nlocal paths = table.translate(prj.libdirs, function(v) return path.join(prj.basedir, v) end)\npaths = table.join({prj.basedir}, paths)\nfor _, libname in ipairs(premake.getlinks(prj, \"system\", \"fullpath\")) do\nlocal libdir = os.pathsearch(libname..\".dll\", unpack(paths))\nif (libdir) then\nlocal target = \"$(TARGETDIR)/\" .. _MAKE.esc(path.getname(libname))\nlocal source = path.getrelative(prj.basedir, path.join(libdir, libname))..\".dll\"\ncopypairs[target] = _MAKE.esc(source)\nend\nend\n_p('# %s project makefile autogenerated by GENie', premake.action.current().shortname)\n_p('')\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc"
	"(prj.configurations[1]:lower()))\n_p('endif')\n_p('')\n_p('ifndef verbose')\n_p('  SILENT = @')\n_p('endif')\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(MAKESHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('  MKDIR = $(SILENT) mkdir -p \"$(1)\"')\n_p('  COPY  = $(SILENT) cp -fR \"$(1)\" \"$(2)\"')\n_p('else')\n_p('  MKDIR = $(SILENT) mkdir \"$(subst /,\\\\\\\\,$(1))\" 2> nul')\n_p('  COPY  = $(SILENT) copy /Y \"$(subst /,\\\\\\\\,$(1))\" \"$(subst /,\\\\\\\\,$(2))\"')\n_p('endif')\n_p('')\n_p('ifndef CSC')\n_p('  CSC=%s', csc.getcompilervar(prj))\n_p('endif')\n_p('')\n_p('ifndef RESGEN')\n_p('  RESGEN=resgen')\n_p('endif')\n_p('')\nlocal platforms = premake.filterplatforms(prj.solution, premake[_OPTIONS.cc].platforms)\ntable.insert(platforms, 1, \"\")\nfor cfg in premake.each"
	"config(prj) do\npremake.gmake_cs_config(cfg, csc, cfglibs)\nend\n_p('# To maintain compatibility with VS.NET, these values must be set at the project level')\n_p('TARGET     := $(TARGETDIR)/%s', _MAKE.esc(prj.buildtarget.name))\n_p('FLAGS      += /t:%s %s', csc.getkind(prj):lower(), table.implode(_MAKE.esc(prj.libdirs), \"/lib:\", \"\", \" \"))\n_p('REFERENCES += %s', table.implode(_MAKE.esc(premake.getlinks(prj, \"system\", \"basename\")), \"/r:\", \".dll\", \" \"))\n_p('')\n_p('SOURCES := \\\\')\nfor _, fname in ipairs(sources) do\n_p('\\t%s \\\\', _MAKE.esc(path.translate(fname)))\nend\n_p('')\n_p('EMBEDFILES := \\\\')\nfor _, fname in ipairs(embedded) do\n_p('\\t%s \\\\', getresourcefilename(prj, fname))\nend\n_p('')\n_p('COPYFILES += \\\\')\nfor target, source in pairs(cfgpairs[anycfg]) do\n_p('\\t%s \\\\', target)\nend\nfor target, source in pairs(copypairs) do\n_p('\\t%s \\\\', target)\nend\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p"
	"('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(MAKESHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('.PHONY: clean prebuild prelink')\n_p('')\n_p('all: $(TARGETDIR) $(OBJDIR) prebuild $(EMBEDFILES) $(COPYFILES) prelink $(TARGET)')\n_p('')\n_p('$(TARGET): $(SOURCES) $(EMBEDFILES) $(DEPENDS)')\n_p('\\t$(SILENT) $(CSC) /nologo /out:$@ $(FLAGS) $(REFERENCES) $(SOURCES) $(patsubst %%,/resource:%%,$(EMBEDFILES))')\n_p('\\t$(POSTBUILDCMDS)')\n_p('')\n_p('$(TARGETDIR):')\npremake.make_mkdirrule(\"$(TARGETDIR)\")\n_p('$(OBJDIR):')\npremake.make_mkdirrule(\"$(OBJDIR)\")\n_p('clean:')\n_p('\\t@echo Cleaning %s', prj.name)\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f $(TARGETDIR)/%s.* $(COPYFILES)', prj.buildtarget.basename)\n_p('\\t$(SILENT) rm -rf $(OBJDIR)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGETDIR)/%s.*) del $(subst /,\\\\\\\\,$(TARGETDIR)/%s.*)', prj.buildtarget.basename, prj.buildtarget.b"
	"asename)\nfor target, source in pairs(cfgpairs[anycfg]) do\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,%s) del $(subst /,\\\\\\\\,%s)', target, target)\nend\nfor target, source in pairs(copypairs) do\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,%s) del $(subst /,\\\\\\\\,%s)', target, target)\nend\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(OBJDIR)) rmdir /s /q $(subst /,\\\\\\\\,$(OBJDIR))')\n_p('endif')\n_p('')\n_p('prebuild:')\n_p('\\t$(PREBUILDCMDS)')\n_p('')\n_p('prelink:')\n_p('\\t$(PRELINKCMDS)')\n_p('')\n_p('# Per-configuration copied file rules')\nfor cfg in premake.eachconfig(prj) do\n_p('ifneq (,$(findstring %s,$(config)))', _MAKE.esc(cfg.name:lower()))\nfor target, source in pairs(cfgpairs[cfg]) do\npremake.make_copyrule(source, target)\nend\n_p('endif')\n_p('')\nend\n_p('# Copied file rules')\nfor target, source in pairs(copypairs) do\npremake.make_copyrule(source, target)\nend\n_p('# Embedded file rules')\nfor _, fname in ipairs(embedded) do \nif path.getextension(fname) == \".resx\" then"
	"\n_p('%s: %s', getresourcefilename(prj, fname), _MAKE.esc(fname))\n_p('\\t$(SILENT) $(RESGEN) $^ $@')\nend\n_p('')\nend\nend\nfunction premake.gmake_cs_config(cfg, csc, cfglibs)\n_p('ifneq (,$(findstring %s,$(config)))', _MAKE.esc(cfg.name:lower()))\n_p('  TARGETDIR  := %s', _MAKE.esc(cfg.buildtarget.directory))\n_p('  OBJDIR     := %s', _MAKE.esc(cfg.objectsdir))\n_p('  DEPENDS    := %s', table.concat(_MAKE.esc(premake.getlinks(cfg, \"dependencies\", \"fullpath\")), \" \"))\n_p('  REFERENCES := %s', table.implode(_MAKE.esc(cfglibs[cfg]), \"/r:\", \"\", \" \"))\n_p('  FLAGS      += %s %s', table.implode(cfg.defines, \"/d:\", \"\", \" \"), table.concat(table.join(csc.getflags(cfg), cfg.buildoptions), \" \"))\n_p('  define PREBUILDCMDS')\nif #cfg.prebuildcommands > 0 then\n_p('\\t@echo Running pre-build commands')\n_p('\\t%s', table.implode(cfg.prebuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define PRELINKCMDS')\nif #cfg.prelinkcommands > 0 then\n_p('\\t@echo Running pre-link commands')\n_p"
	"('\\t%s', table.implode(cfg.prelinkcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define POSTBUILDCMDS')\nif #cfg.postbuildcommands > 0 then\n_p('\\t@echo Running post-build commands')\n_p('\\t%s', table.implode(cfg.postbuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('endif')\n_p('')\nend\n",

	/* actions/make/make_vala.lua */
	"local make = premake.make\nfunction premake.make_vala(prj)\nlocal valac = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, valac.platforms, \"Native\")\n_p('# %s project makefile autogenerated by GENie', premake.action.current().shortname)\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(premake.getconfigname(prj.solution.configurations[1], platforms[1], true)))\n_p('endif')\n_p('')\n_p('ifndef verbose')\n_p('  SILENT = @')\n_p('endif')\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(MAKESHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('  MKDIR = $(SILENT) mkdir -p \"$(1)\"')\n_p('  COPY  = $(SILENT) cp -fR \"$(1)\" \"$(2)\"')\n_p('  RM    = $(SILENT) rm -f \"$(1)\"')\n_p('else')\n_p('  MKDIR = $(SILENT) mkdir \"$(subst /,\\\\\\\\,$(1))\" 2> nul || e"
	"xit 0')\n_p('  COPY  = $(SILENT) copy /Y \"$(subst /,\\\\\\\\,$(1))\" \"$(subst /,\\\\\\\\,$(2))\"')\n_p('  RM    = $(SILENT) del /F \"$(subst /,\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p('endif')\n_p('')\n_p('VALAC = %s', valac.valac)\n_p('CC    = %s', valac.cc)\n_p('')\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\npremake.gmake_valac_config(prj, cfg, valac)\nend\nend\n_p('SOURCES := \\\\')\nfor _, file in ipairs(prj.files) do\nif path.issourcefile(file) then\nif not table.icontains(prj.excludes, file) then\n_p('\\t%s \\\\', _MAKE.esc(file))\nend\nend\nend\n_p('')\n_p('.PHONY: clean prebuild prelink')\n_p('')\n_p('all: prebuild prelink $(TARGET) | $(TARGETDIR)')\n_p('\\t@:')\n_p('')\n_p('$(TARGET): $(SOURCES) | $(TARGETDIR)')\n_p('\\t$(SILENT) $(VALAC) -o $(TARGET) --cc=$(CC) $(FLAGS) $(SOURCES)')\n_p('\\t$(POSTBUILDCMDS)')\n_p('')\n_p('$(TARGETDIR):')\npremake.make_mkdirrule(\"$(TARGETDIR)\")\n_p('clean:')\nif (not prj.solution.messageskip) or (not table.contains(prj"
	".solution.messageskip, \"SkipCleaningMessage\")) then\n_p('\\t@echo Cleaning %s', prj.name)\nend\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f  $(TARGET)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGET)) del $(subst /,\\\\\\\\,$(TARGET))')\n_p('endif')\n_p('')\n_p('prebuild:')\n_p('\\t$(PREBUILDCMDS)')\n_p('')\n_p('prelink:')\n_p('\\t$(PRELINKCMDS)')\n_p('')\nend\nfunction premake.gmake_valac_config(prj, cfg, valac)\n_p('ifeq ($(config),%s)', _MAKE.esc(cfg.shortname))\n_p('  TARGETDIR  = %s', _MAKE.esc(cfg.buildtarget.directory))\n_p('  TARGET     = $(TARGETDIR)/%s', _MAKE.esc(cfg.buildtarget.name))\n_p('  DEFINES    +=%s', make.list(valac.getdefines(cfg.defines)))\n_p('  VAPIDIRS   +=%s', make.list(valac.getvapidirs(cfg.vapidirs)))\n_p('  PKGS       +=%s', make.list(valac.getlinks(cfg.links)))\n_p('  FLAGS      += $(DEFINES) $(VAPIDIRS) $(PKGS)%s', make.list(table.join(valac.getvalaflags(cfg), valac.getbuildoptions(cfg.buildoptions), valac.getbuildoptions(cfg.buildoptions_c), c"
	"fg.buildoptions_vala)))\n_p('  define PREBUILDCMDS')\nif #cfg.prebuildcommands > 0 then\n_p('\\t@echo Running pre-build commands')\n_p('\\t%s', table.implode(cfg.prebuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define PRELINKCMDS')\nif #cfg.prelinkcommands > 0 then\n_p('\\t@echo Running pre-link commands')\n_p('\\t%s', table.implode(cfg.prelinkcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define POSTBUILDCMDS')\nif #cfg.postbuildcommands > 0 then\n_p('\\t@echo Running post-build commands')\n_p('\\t%s', table.implode(cfg.postbuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('endif')\n_p('')\nend\n",

	/* actions/make/make_swift.lua */
	"local make = premake.make\nlocal swift = { }\nfunction premake.make_swift(prj)\nlocal tool = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, tool.platforms, \"Native\")\n_p('# %s project makefile autogenerated by GENie', premake.action.current().shortname)\n_p('ifndef config')\n_p(1, 'config=%s', _MAKE.esc(premake.getconfigname(prj.solution.configurations[1], platforms[1], true)))\n_p('endif')\n_p('')\n_p('ifndef verbose')\n_p(1, 'SILENT = @')\n_p('endif')\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p(1, 'SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p(1, 'SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(MAKESHELL)))')\n_p(1, 'SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('ifeq (posix,$(SHELLTYPE))')\n_p(1, 'MKDIR = $(SILENT) mkdir -p \"$(1)\"')\n_p(1, 'COPY  = $(SILENT) cp -fR \"$(1)\" \"$(2)\"')\n_p(1, 'RM    = $(SILENT) rm -f \"$(1)\"')\n_p('else')\n_p(1, 'MKDIR = $(SILENT) mkdir \"$(subst /,"
	"\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p(1, 'COPY  = $(SILENT) copy /Y \"$(subst /,\\\\\\\\,$(1))\" \"$(subst /,\\\\\\\\,$(2))\"')\n_p(1, 'RM    = $(SILENT) del /F \"$(subst /,\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p('endif')\n_p('')\n_p('SWIFTC = %s', tool.swift)\n_p('SWIFTLINK = %s', tool.swiftc)\n_p('DSYMUTIL = %s', tool.dsymutil)\n_p('AR = %s', tool.ar)\n_p('')\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\nswift.generate_config(prj, cfg, tool)\nend\nend\n_p('.PHONY: ')\n_p('')\n_p('all: $(WORK_DIRS) $(TARGET)')\n_p('')\n_p('$(WORK_DIRS):')\n_p(1, '$(SILENT) $(call MKDIR,$@)')\n_p('')\n_p('SOURCES := \\\\')\nfor _, file in ipairs(prj.files) do\nif path.isswiftfile(file) then\n_p(1, '%s \\\\', _MAKE.esc(file))\nend\nend\n_p('')\nlocal objfiles = {}\n_p('OBJECTS_WITNESS := $(OBJDIR)/build.stamp')\n_p('OBJECTS := \\\\')\nfor _, file in ipairs(prj.files) do\nif path.isswiftfile(file) then\nlocal objname = _MAKE.esc(swift.objectname(file))\ntable.insert(objfiles, objnam"
	"e)\n_p(1, '%s \\\\', objname)\nend\nend\n_p('')\nswift.file_rules(prj, objfiles)\nswift.linker(prj, tool)\nswift.generate_clean(prj)\nend\nfunction swift.objectname(file)\nreturn path.join(\"$(OBJDIR)\", path.getname(file)..\".o\")\nend\nfunction swift.file_rules(prj, objfiles)\n_p('$(OBJECTS_WITNESS): $(SOURCES)')\n_p(1, \"@rm -f $(OBJDIR)/data.tmp\")\n_p(1, \"@touch $(OBJDIR)/data.tmp\")\n_p(1, \"$(SILENT) $(SWIFTC) -frontend -c $(SOURCES) -enable-objc-interop $(SDK) -I $(OUT_DIR) $(SWIFTC_FLAGS) -module-cache-path $(MODULECACHE_DIR) -D SWIFT_PACKAGE $(MODULE_MAPS) -emit-module-doc-path $(OUT_DIR)/$(MODULE_NAME).swiftdoc -module-name $(MODULE_NAME) -emit-module-path $(OUT_DIR)/$(MODULE_NAME).swiftmodule -num-threads 8 %s\", table.arglist(\"-o\", objfiles))\n_p(1, \"@mv -f $(OBJDIR)/data.tmp $(OBJECTS_WITNESS)\")\n_p('')\n_p('$(OBJECTS): $(OBJECTS_WITNESS)')\n_p(1, '@if test -f $@; then :; else \\\\')\n_p(2, 'rm -f $(OBJECTS_WITNESS); \\\\')\n_p(2, '$(MAKE) $(AM_MAKEFLAGS) $(OBJECTS_WITNESS); \\\\')\n_p(1, 'f"
	"i')\n_p('')\nend\nfunction swift.linker(prj, tool)\nlocal lddeps = make.list(premake.getlinks(prj, \"siblings\", \"fullpath\")) \nif prj.kind == \"StaticLib\" then\n_p(\"$(TARGET): $(OBJECTS) %s \", lddeps)\n_p(1, \"$(SILENT) $(AR) cr $(AR_FLAGS) $@ $(OBJECTS) %s\", (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\"))\nelse\n_p(\"$(TARGET): $(OBJECTS) $(LDDEPS)\", lddeps)\n_p(1, \"$(SILENT) $(SWIFTLINK) $(SDK) -L $(OUT_DIR) -o $@ $(SWIFTLINK_FLAGS) $(LD_FLAGS) $(OBJECTS)\")\n_p(\"ifdef SYMBOLS\")\n_p(1, \"$(SILENT) $(DSYMUTIL) $(TARGET) -o $(SYMBOLS)\")\n_p(\"endif\")\nend\n_p('')\nend\nfunction swift.generate_clean(prj)\n_p('clean:')\nif (not prj.solution.messageskip) or (not table.contains(prj.solution.messageskip, \"SkipCleaningMessage\")) then\n_p('\\t@echo Cleaning %s', prj.name)\nend\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f  $(TARGET)')\n_p('\\t$(SILENT) rm -rf $(OBJDIR)')\n_p('\\t$(SILENT) rm -rf $(SYMBOLS)')\n_p('\\t$(SILENT) rm -rf $(MODULECACHE_DIR"
	")')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGET)) del $(subst /,\\\\\\\\,$(TARGET))')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(OBJDIR)) rmdir /s /q $(subst /,\\\\\\\\,$(OBJDIR))')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(SYMBOLS)) rmdir /s /q $(subst /,\\\\\\\\,$(SYMBOLS))')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(MODULECACHE_DIR)) rmdir /s /q $(subst /,\\\\\\\\,$(MODULECACHE_DIR))')\n_p('endif')\n_p('')\nend\nfunction swift.generate_config(prj, cfg, tool)\n_p('ifeq ($(config),%s)', _MAKE.esc(cfg.shortname))\n_p(1, \"OUT_DIR = %s\", cfg.buildtarget.directory)\n  _p(1, \"MODULECACHE_DIR = $(OUT_DIR)/ModuleCache\")\n_p(1, \"TARGET = $(OUT_DIR)/%s\", _MAKE.esc(cfg.buildtarget.name))\nlocal objdir = path.join(cfg.objectsdir, prj.name .. \".build\")\n_p(1, \"OBJDIR = %s\", objdir)\n_p(1, \"MODULE_NAME = %s\", prj.name)\n_p(1, \"MODULE_MAPS = %s\", make.list(tool.getmodulemaps(cfg)))\n_p(1, \"SWIFTC_FLAGS = %s\", make.list(tool.getswiftcflags(cfg)))\n_p(1, \"SWIFTLINK_FLA"
	"GS = %s\", make.list(tool.getswiftlinkflags(cfg)))\n_p(1, \"AR_FLAGS = %s\", make.list(tool.getarchiveflags(cfg, cfg, false)))\n_p(1, \"LD_FLAGS = %s\", make.list(tool.getldflags(cfg)))\n_p(1, \"LDDEPS = %s\", make.list(premake.getlinks(cfg, \"siblings\", \"fullpath\")))\nif cfg.flags.Symbols then\n_p(1, \"SYMBOLS = $(TARGET).dSYM\")\nend\nlocal sdk = tool.get_sdk_path(cfg)\nif sdk then\n_p(1, \"TOOLCHAIN_PATH = %s\", tool.get_toolchain_path(cfg))\n_p(1, \"SDK_PATH = %s\", sdk)\n_p(1, \"PLATFORM_PATH = %s\", tool.get_sdk_platform_path(cfg))\n_p(1, \"SDK = -sdk $(SDK_PATH)\")\nelse\n_p(1, \"SDK_PATH =\")\n_p(1, \"SDK =\")\nend\n_p(1,'WORK_DIRS = $(OUT_DIR) $(OBJDIR)')\n_p('endif')\n_p('')\nend",

	/* actions/vstudio/_vstudio.lua */
	"premake.vstudio = { }\nlocal toolsets = {\nvs2010 = \"v100\",\nvs2012 = \"v110\",\nvs2013 = \"v120\",\nvs2015 = \"v140\",\nvs2017 = \"v141\",\nvsllvm = \"llvm\",\n}\npremake.vstudio.toolset = toolsets[_ACTION] or \"unknown?\"\npremake.vstudio.splashpath = ''\nlocal vstudio = premake.vstudio\nvstudio.platforms = {\nany     = \"Any CPU\",\nmixed   = \"Mixed Platforms\",\nNative  = \"Win32\",\nx86     = \"x86\",\nx32     = \"Win32\",\nx64     = \"x64\",\nPS3     = \"PS3\",\nXbox360 = \"Xbox 360\",\nARM     = \"ARM\",\nOrbis   = \"ORBIS\",\nDurango = \"Durango\",\n}\nfunction vstudio.arch(prj)\nif (prj.language == \"C#\") then\nreturn \"Any CPU\"\nelse\nreturn \"Win32\"\nend\nend\nfunction vstudio.iswinrt()\nreturn vstudio.storeapp ~= nil and vstudio.storeapp ~= ''\nend\nfunction vstudio.buildconfigs(sln)\nlocal cfgs = { }\nlocal platforms = premake.filterplatforms(sln, vstudio.platforms, \"Native\")\nlocal hascpp    = premake.hascppproject(sln)\nlocal hasdotnet = premake.hasdotnetproject(sln)\nif hasdotnet and (_"
	"ACTION > \"vs2008\" or hascpp) then\ntable.insert(platforms, 1, \"mixed\")\nend\nif hasdotnet and (_ACTION < \"vs2010\" or not hascpp) then\ntable.insert(platforms, 1, \"any\")\nend\nif _ACTION > \"vs2008\" then\nlocal platforms2010 = { }\nfor _, platform in ipairs(platforms) do\nif vstudio.platforms[platform] == \"Win32\" then\nif hascpp then\ntable.insert(platforms2010, platform)\nend\nif hasdotnet then\ntable.insert(platforms2010, \"x86\")\nend\nelse\ntable.insert(platforms2010, platform)\nend\nend\nplatforms = platforms2010\nend\nfor _, buildcfg in ipairs(sln.configurations) do\nfor _, platform in ipairs(platforms) do\nlocal entry = { }\nentry.src_buildcfg = buildcfg\nentry.src_platform = platform\nif platform ~= \"PS3\" or _ACTION > \"vs2008\" then\nentry.buildcfg = buildcfg\nentry.platform = vstudio.platforms[platform]\nelse\nentry.buildcfg = platform .. \" \" .. buildcfg\nentry.platform = \"Win32\"\nend\nentry.name = entry.buildcfg .. \"|\" .. entry.platform\nentry.isreal = (platform ~= \"any\" and plat"
	"form ~= \"mixed\")\ntable.insert(cfgs, entry)\nend\nend\nreturn cfgs\nend\nfunction premake.vstudio.bakeimports(sln)\nfor _,iprj in ipairs(sln.importedprojects) do\nif string.find(iprj.location, \".csproj\") ~= nil then\niprj.language = \"C#\"\nelse\niprj.language = \"C++\"\nend\nlocal f, err = io.open(iprj.location, \"r\")\nif (not f) then\nerror(err, 1)\nend\nlocal projcontents = f:read(\"*all\")\nf:close()\nlocal found, _, uuid = string.find(projcontents, \"<ProjectGuid>{([%w%-]+)}</ProjectGuid>\")\nif not found then\nerror(\"Could not find ProjectGuid element in project \" .. iprj.location, 1)\nend\niprj.uuid = uuid\nif iprj.language == \"C++\" and string.find(projcontents, \"<CLRSupport>true</CLRSupport>\") then\niprj.flags.Managed = true\nend\niprj.relpath = path.getrelative(sln.location, iprj.location)\nend\nend\nfunction premake.vstudio.getimportprj(prjpath, sln)\nfor _,iprj in ipairs(sln.importedprojects) do\nif prjpath == iprj.relpath then\nreturn iprj\nend\nend\nerror(\"Could not find reference impo"
	"rt project \" .. prjpath, 1)\nend\nfunction vstudio.cleansolution(sln)\npremake.clean.file(sln, \"%%.sln\")\npremake.clean.file(sln, \"%%.suo\")\npremake.clean.file(sln, \"%%.ncb\")\npremake.clean.file(sln, \"%%.userprefs\")\npremake.clean.file(sln, \"%%.usertasks\")\nend\nfunction vstudio.cleanproject(prj)\nlocal fname = premake.project.getfilename(prj, \"%%\")\nos.remove(fname .. \".vcproj\")\nos.remove(fname .. \".vcproj.user\")\nos.remove(fname .. \".vcxproj\")\nos.remove(fname .. \".vcxproj.user\")\nos.remove(fname .. \".vcxproj.filters\")\nos.remove(fname .. \".csproj\")\nos.remove(fname .. \".csproj.user\")\nos.remove(fname .. \".pidb\")\nos.remove(fname .. \".sdf\")\nend\nfunction vstudio.cleantarget(name)\nos.remove(name .. \".pdb\")\nos.remove(name .. \".idb\")\nos.remove(name .. \".ilk\")\nos.remove(name .. \".vshost.exe\")\nos.remove(name .. \".exe.manifest\")\nend\nfunction vstudio.projectfile(prj)\nlocal pattern\nif prj.language == \"C#\" then\npattern = \"%%.csproj\"\nelse\npattern = iif(_ACTION"
	" > \"vs2008\", \"%%.vcxproj\", \"%%.vcproj\")\nend\nlocal fname = premake.project.getbasename(prj.name, pattern)\nfname = path.join(prj.location, fname)\nreturn fname\nend\nfunction vstudio.tool(prj)\nif (prj.language == \"C#\") then\nreturn \"FAE04EC0-301F-11D3-BF4B-00C04F79EFBC\"\nelse\nreturn \"8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942\"\nend\nend\n",

	/* actions/vstudio/vstudio_solution.lua */
	"premake.vstudio.sln2005 = { }\nlocal vstudio = premake.vstudio\nlocal sln2005 = premake.vstudio.sln2005\nfunction sln2005.generate(sln)\nio.eol = '\\r\\n'\nsln.vstudio_configs = premake.vstudio.buildconfigs(sln)\npremake.vstudio.bakeimports(sln)\n_p('\\239\\187\\191')\nsln2005.reorderProjects(sln)\nsln2005.header(sln)\nfor grp in premake.solution.eachgroup(sln) do\nsln2005.group(grp)\nend\nfor prj in premake.solution.eachproject(sln) do\nsln2005.project(prj)\nend\n        \nfor _,iprj in ipairs(sln.importedprojects) do\nsln2005.importproject(iprj)\nend\n_p('Global')\nsln2005.platforms(sln)\nsln2005.project_platforms(sln)\nsln2005.properties(sln)\nsln2005.project_groups(sln)\n_p('EndGlobal')\nend\nfunction sln2005.reorderProjects(sln)\nif sln.startproject then\nfor i, prj in ipairs(sln.projects) do\nif sln.startproject == prj.name then\nlocal cur = prj.group\nwhile cur ~= nil do\nfor j, group in ipairs(sln.groups) do\nif group == cur then\ntable.remove(sln.groups, j)\nbreak\nend\nend\ntable.insert(sln.groups, 1"
	", cur)\ncur = cur.parent\nend\ntable.remove(sln.projects, i)\ntable.insert(sln.projects, 1, prj)\nbreak\nend\nend\nend\nend\nfunction sln2005.header(sln)\nlocal action = premake.action.current()\n_p('Microsoft Visual Studio Solution File, Format Version %d.00', action.vstudio.solutionVersion)\nif(_ACTION:sub(3) == \"2015\" or  _ACTION:sub(3) == \"2017\" or  _ACTION:sub(3) == \"llvm\") then\n_p('# Visual Studio %s', action.vstudio.toolsVersion:sub(1,2))\nelse\n_p('# Visual Studio %s', _ACTION:sub(3))\nend\nend\nfunction sln2005.project(prj)\nlocal projpath = path.translate(path.getrelative(prj.solution.location, vstudio.projectfile(prj)), \"\\\\\")\n_p('Project(\"{%s}\") = \"%s\", \"%s\", \"{%s}\"', vstudio.tool(prj), prj.name, projpath, prj.uuid)\nsln2005.projectdependencies(prj)\n_p('EndProject')\nend\nfunction sln2005.group(grp)\n_p('Project(\"{2150E333-8FDC-42A3-9474-1A3956D46DE8}\") = \"%s\", \"%s\", \"{%s}\"', grp.name, grp.name, grp.uuid)\n_p('EndProject')\nend\n    \nfunction sln2005.importproject(iprj)"
	"\n_p('Project(\"{%s}\") = \"%s\", \"%s\", \"{%s}\"', vstudio.tool(iprj), path.getbasename(iprj.location), iprj.relpath, iprj.uuid)\n_p('EndProject')\nend\nfunction sln2005.projectdependencies(prj)\nlocal deps = premake.getdependencies(prj)\nif #deps > 0 then\n_p('\\tProjectSection(ProjectDependencies) = postProject')\nfor _, dep in ipairs(deps) do\n_p('\\t\\t{%s} = {%s}', dep.uuid, dep.uuid)\nend\n_p('\\tEndProjectSection')\nend\nend\nfunction sln2005.platforms(sln)\n_p('\\tGlobalSection(SolutionConfigurationPlatforms) = preSolution')\nfor _, cfg in ipairs(sln.vstudio_configs) do\n_p('\\t\\t%s = %s', cfg.name, cfg.name)\nend\n_p('\\tEndGlobalSection')\nend\nfunction sln2005.project_platform(prj, sln)\nfor _, cfg in ipairs(sln.vstudio_configs) do\nlocal mapped\nlocal buildfor\nif premake.isdotnetproject(prj) then\nbuildfor = \"x64\"\nmapped = \"Any CPU\"\nelseif prj.flags and prj.flags.Managed then\nmapped = \"x64\"\nelse\nif cfg.platform == \"Any CPU\" or cfg.platform == \"Mixed Platforms\" then\nmapped = sln."
	"vstudio_configs[3].platform\nelse\nmapped = cfg.platform\nend\nend\nlocal build_project = true\nif prj.solution ~= nil then\n    build_project = premake.getconfig(prj, cfg.src_buildcfg, cfg.src_platform).build\nend\n_p('\\t\\t{%s}.%s.ActiveCfg = %s|%s', prj.uuid, cfg.name, cfg.buildcfg, mapped)\nif build_project then\n    if mapped == cfg.platform or cfg.platform == \"Mixed Platforms\" or buildfor == cfg.platform then\n    _p('\\t\\t{%s}.%s.Build.0 = %s|%s',  prj.uuid, cfg.name, cfg.buildcfg, mapped)\n    end\n    if premake.vstudio.iswinrt() and prj.kind == \"WindowedApp\" then\n       _p('\\t\\t{%s}.%s.Deploy.0 = %s|%s',  prj.uuid, cfg.name, cfg.buildcfg, mapped)\n    end\nend\nend\nend\nfunction sln2005.project_platforms(sln)\n_p('\\tGlobalSection(ProjectConfigurationPlatforms) = postSolution')\nfor prj in premake.solution.eachproject(sln) do\nsln2005.project_platform(prj, sln)\nend\nfor _,iprj in ipairs(sln.importedprojects) do\nsln2005.project_platform(iprj, sln)\nend\n_p('\\tEndGlobalSection')\nend\nfunc"
	"tion sln2005.properties(sln)\n_p('\\tGlobalSection(SolutionProperties) = preSolution')\n_p('\\t\\tHideSolutionNode = FALSE')\n_p('\\tEndGlobalSection')\nend\nfunction sln2005.project_groups(sln)\n_p('\\tGlobalSection(NestedProjects) = preSolution')\nfor grp in premake.solution.eachgroup(sln) do\nif grp.parent ~= nil then\n_p('\\t\\t{%s} = {%s}', grp.uuid, grp.parent.uuid)\nend\nend\nfor prj in premake.solution.eachproject(sln) do\nif prj.group ~= nil then\n_p('\\t\\t{%s} = {%s}', prj.uuid, prj.group.uuid)\nend\nend\nfor _,iprj in ipairs(sln.importedprojects) do\nif iprj.group ~= nil then\n_p('\\t\\t{%s} = {%s}', iprj.uuid, iprj.group.uuid)\nend\nend\n        \n_p('\\tEndGlobalSection')\nend",

	/* actions/vstudio/vstudio_vcxproj.lua */
	"premake.vstudio.vc2010 = { }\nlocal vc2010 = premake.vstudio.vc2010\nlocal vstudio = premake.vstudio\nlocal function vs2010_config(prj)\n_p(1,'<ItemGroup Label=\"ProjectConfigurations\">')\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\n_p(2,'<ProjectConfiguration Include=\"%s\">', premake.esc(cfginfo.name))\n_p(3,'<Configuration>%s</Configuration>',cfginfo.buildcfg)\n_p(3,'<Platform>%s</Platform>',cfginfo.platform)\n_p(2,'</ProjectConfiguration>')\nend\n_p(1,'</ItemGroup>')\nend\nlocal function vs2010_globals(prj)\nlocal action = premake.action.current()\n_p(1,'<PropertyGroup Label=\"Globals\">')\n_p(2, '<ProjectGuid>{%s}</ProjectGuid>',prj.uuid)\n_p(2, '<RootNamespace>%s</RootNamespace>',prj.name)\nif vstudio.storeapp ~= \"durango\" then\nlocal windowsTargetPlatformVersion = prj.windowstargetplatformversion or action.vstudio.windowsTargetPlatformVersion\nif windowsTargetPlatformVersion ~= nil then\n_p(2,'<WindowsTargetPlatformVersion>%s</WindowsTargetPlatformVersion>',windowsTargetPlatformVersion"
	")\nif windowsTargetPlatformVersion and string.startswith(windowsTargetPlatformVersion, \"10.\") then\n_p(2,'<WindowsTargetPlatformMinVersion>%s</WindowsTargetPlatformMinVersion>', prj.windowstargetplatformminversion or \"10.0.10240.0\")\nend\nend\nend\nif prj.flags and prj.flags.Managed then\nlocal frameworkVersion = prj.framework or \"4.0\"\n_p(2, '<TargetFrameworkVersion>v%s</TargetFrameworkVersion>', frameworkVersion)\n_p(2, '<Keyword>ManagedCProj</Keyword>')\nelseif vstudio.iswinrt() then\n_p(2, '<DefaultLanguage>en-US</DefaultLanguage>')\nif vstudio.storeapp == \"durango\" then\n_p(2, '<Keyword>Win32Proj</Keyword>')\n_p(2, '<ApplicationEnvironment>title</ApplicationEnvironment>')\n_p(2, '<MinimumVisualStudioVersion>14.0</MinimumVisualStudioVersion>')\n_p(2, '<TargetRuntime>Native</TargetRuntime>')\nelse\n_p(2, '<AppContainerApplication>true</AppContainerApplication>')\n_p(2, '<MinimumVisualStudioVersion>12.0</MinimumVisualStudioVersion>')\nif vstudio.toolset == \"v120_wp81\" then\n_p(2, '<ApplicationType>"
	"Windows Phone</ApplicationType>')\nelse\n_p(2, '<ApplicationType>Windows Store</ApplicationType>')\nend\n_p(2, '<ApplicationTypeRevision>%s</ApplicationTypeRevision>', vstudio.storeapp)\nend\nelse\n_p(2, '<Keyword>Win32Proj</Keyword>')\nend\nif _ACTION:sub(3) == \"2015\" or _ACTION:sub(3) == \"2017\" or _ACTION:sub(3) == \"llvm\" then\n_p(2,'<PreferredToolArchitecture>x64</PreferredToolArchitecture>')\nend\nif (_ACTION:sub(3) == \"2017\" or _ACTION:sub(3) == \"llvm\")\nand os.isdir(path.join(os.getenv(\"VSINSTALLDIR\"), \"VC/Tools/MSVC/14.14.26428\")) then\n_p(2,'<VCToolsVersion>14.14.26428</VCToolsVersion>')\nend\n_p(1,'</PropertyGroup>')\nend\nfunction vc2010.config_type(config)\nlocal t =\n{\nSharedLib = \"DynamicLibrary\",\nStaticLib = \"StaticLibrary\",\nConsoleApp = \"Application\",\nWindowedApp = \"Application\"\n}\nreturn t[config.kind]\nend\nlocal function if_config_and_platform()\nreturn 'Condition=\"\\'$(Configuration)|$(Platform)\\'==\\'%s\\'\"'\nend\nlocal function optimisation(cfg)\nlocal result "
	"= \"Disabled\"\nfor _, value in ipairs(cfg.flags) do\nif (value == \"Optimize\") then\nresult = \"Full\"\nelseif (value == \"OptimizeSize\") then\nresult = \"MinSpace\"\nelseif (value == \"OptimizeSpeed\") then\nresult = \"MaxSpeed\"\nend\nend\nreturn result\nend\nfunction vc2010.configurationPropertyGroup(cfg, cfginfo)\n_p(1,'<PropertyGroup '..if_config_and_platform() ..' Label=\"Configuration\">'\n, premake.esc(cfginfo.name))\n_p(2,'<ConfigurationType>%s</ConfigurationType>',vc2010.config_type(cfg))\n_p(2,'<UseDebugLibraries>%s</UseDebugLibraries>', iif(optimisation(cfg) == \"Disabled\",\"true\",\"false\"))\n_p(2,'<PlatformToolset>%s</PlatformToolset>', premake.vstudio.toolset)\nif cfg.flags.MFC then\n_p(2,'<UseOfMfc>%s</UseOfMfc>', iif(cfg.flags.StaticRuntime, \"Static\", \"Dynamic\"))\nend\nif cfg.flags.ATL or cfg.flags.StaticATL then\n_p(2,'<UseOfAtl>%s</UseOfAtl>', iif(cfg.flags.StaticATL, \"Static\", \"Dynamic\"))\nend\nif cfg.flags.Unicode then\n_p(2,'<CharacterSet>Unicode</CharacterSet>')\nend\nif cfg"
	".flags.Managed then\n_p(2,'<CLRSupport>true</CLRSupport>')\nend\n_p(1,'</PropertyGroup>')\nend\nlocal function import_props(prj)\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\n_p(1,'<ImportGroup '..if_config_and_platform() ..' Label=\"PropertySheets\">'\n,premake.esc(cfginfo.name))\n_p(2,'<Import Project=\"$(UserRootDir)\\\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists(\\'$(UserRootDir)\\\\Microsoft.Cpp.$(Platform).user.props\\')\" Label=\"LocalAppDataPlatform\" />')\nif #cfg.propertysheets > 0 then\nlocal dirs = cfg.propertysheets\nfor _, dir in ipairs(dirs) do\n_p(2,'<Import Project=\"%s\" />', path.translate(dir))\nend\nend\n_p(1,'</ImportGroup>')\nend\nend\nlocal function add_trailing_backslash(dir)\nif dir:len() > 0 and dir:sub(-1) ~= \"\\\\\" then\nreturn dir..\"\\\\\"\nend\nreturn dir\nend\nfunction vc2010.outputProperties(prj)\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = p"
	"remake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\nlocal target = cfg.buildtarget\nlocal outdir = add_trailing_backslash(target.directory)\nlocal intdir = add_trailing_backslash(iif(action.vstudio.intDirAbsolute\n, path.translate(\n  path.join(prj.solution.location, cfg.objectsdir)\n, '\\\\')\n, cfg.objectsdir\n))\n_p(1,'<PropertyGroup '..if_config_and_platform() ..'>', premake.esc(cfginfo.name))\n_p(2,'<OutDir>%s</OutDir>', iif(outdir:len() > 0, premake.esc(outdir), \".\\\\\"))\nif cfg.platform == \"Xbox360\" then\n_p(2,'<OutputFile>$(OutDir)%s</OutputFile>', premake.esc(target.name))\nend\n_p(2,'<IntDir>%s</IntDir>', premake.esc(intdir))\n_p(2,'<TargetName>%s</TargetName>', premake.esc(path.getbasename(target.name)))\n_p(2,'<TargetExt>%s</TargetExt>', premake.esc(path.getextension(target.name)))\nif cfg.kind == \"SharedLib\" then\nlocal ignore = (cfg.flags.NoImportLib ~= nil)\n_p(2,'<IgnoreImportLibrary>%s</IgnoreImportLibrary>', tostring(ignore))\nend\nif cfg.platform == \"Durango\" then\n_p"
	"(2, '<ReferencePath>$(Console_SdkLibPath);$(Console_SdkWindowsMetadataPath)</ReferencePath>')\n_p(2, '<LibraryPath>$(Console_SdkLibPath)</LibraryPath>')\n_p(2, '<LibraryWPath>$(Console_SdkLibPath);$(Console_SdkWindowsMetadataPath)</LibraryWPath>')\n_p(2, '<IncludePath>$(Console_SdkIncludeRoot)</IncludePath>')\n_p(2, '<ExecutablePath>$(Console_SdkRoot)bin;$(VCInstallDir)bin\\\\x86_amd64;$(VCInstallDir)bin;$(WindowsSDK_ExecutablePath_x86);$(VSInstallDir)Common7\\\\Tools\\\\bin;$(VSInstallDir)Common7\\\\tools;$(VSInstallDir)Common7\\\\ide;$(ProgramFiles)\\\\HTML Help Workshop;$(MSBuildToolsPath32);$(FxCopDir);$(PATH);</ExecutablePath>')\nif cfg.imagepath then\n_p(2, '<LayoutDir>%s</LayoutDir>', cfg.imagepath)\nelse\n_p(2, '<LayoutDir>%s</LayoutDir>', prj.name)\nend\nif cfg.pullmappingfile ~= nil then\n_p(2,'<PullMappingFile>%s</PullMappingFile>', premake.esc(cfg.pullmappingfile))\nend\n_p(2, '<LayoutExtensionFilter>*.pdb;*.ilk;*.exp;*.lib;*.winmd;*.appxrecipe;*.pri;*.idb</LayoutExtensionFilter>')\n_p(2, '<Isolate"
	"ConfigurationsOnDeploy>true</IsolateConfigurationsOnDeploy>')\nend\nif cfg.kind ~= \"StaticLib\" then\n_p(2,'<LinkIncremental>%s</LinkIncremental>', tostring(premake.config.isincrementallink(cfg)))\nend\nif cfg.flags.NoManifest then\n_p(2,'<GenerateManifest>false</GenerateManifest>')\nend\n_p(1,'</PropertyGroup>')\nend\nend\nlocal function runtime(cfg)\nlocal runtime\nlocal flags = cfg.flags\nif premake.config.isdebugbuild(cfg) then\nruntime = iif(flags.StaticRuntime and not flags.Managed, \"MultiThreadedDebug\", \"MultiThreadedDebugDLL\")\nelse\nruntime = iif(flags.StaticRuntime and not flags.Managed, \"MultiThreaded\", \"MultiThreadedDLL\")\nend\nreturn runtime\nend\nlocal function precompiled_header(cfg)\n      if not cfg.flags.NoPCH and cfg.pchheader then\n_p(3,'<PrecompiledHeader>Use</PrecompiledHeader>')\n_p(3,'<PrecompiledHeaderFile>%s</PrecompiledHeaderFile>', cfg.pchheader)\nelse\n_p(3,'<PrecompiledHeader></PrecompiledHeader>')\nend\nend\nlocal function preprocessor(indent,cfg)\nif #cfg.defines > 0 th"
	"en\n_p(indent,'<PreprocessorDefinitions>%s;%%(PreprocessorDefinitions)</PreprocessorDefinitions>'\n,premake.esc(table.concat(cfg.defines, \";\")))\nelse\n_p(indent,'<PreprocessorDefinitions></PreprocessorDefinitions>')\nend\nend\nlocal function include_dirs(indent,cfg)\nlocal includedirs = table.join(cfg.userincludedirs, cfg.includedirs)\nif #includedirs> 0 then\n_p(indent,'<AdditionalIncludeDirectories>%s;%%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>'\n,premake.esc(path.translate(table.concat(includedirs, \";\"), '\\\\')))\nend\nend\nlocal function using_dirs(indent,cfg)\nif #cfg.usingdirs > 0 then\n_p(indent,'<AdditionalUsingDirectories>%s;%%(AdditionalUsingDirectories)</AdditionalUsingDirectories>'\n,premake.esc(path.translate(table.concat(cfg.usingdirs, \";\"), '\\\\')))\nend\nend\nlocal function resource_compile(cfg)\n_p(2,'<ResourceCompile>')\npreprocessor(3,cfg)\ninclude_dirs(3,cfg)\n_p(2,'</ResourceCompile>')\nend\nlocal function exceptions(cfg)\nif cfg.flags.NoExceptions then\n_p(3, "
	"'<ExceptionHandling>false</ExceptionHandling>')\nelseif cfg.flags.SEH then\n_p(3, '<ExceptionHandling>Async</ExceptionHandling>')\nend\nend\nlocal function rtti(cfg)\nif cfg.flags.NoRTTI and not cfg.flags.Managed then\n_p(3,'<RuntimeTypeInfo>false</RuntimeTypeInfo>')\nend\nend\nlocal function calling_convention(cfg)\nif cfg.flags.FastCall then\n_p(3,'<CallingConvention>FastCall</CallingConvention>')\nelseif cfg.flags.StdCall then\n_p(3,'<CallingConvention>StdCall</CallingConvention>')\nend\nend\nlocal function wchar_t_builtin(cfg)\nif cfg.flags.NativeWChar then\n_p(3,'<TreatWChar_tAsBuiltInType>true</TreatWChar_tAsBuiltInType>')\nelseif cfg.flags.NoNativeWChar then\n_p(3,'<TreatWChar_tAsBuiltInType>false</TreatWChar_tAsBuiltInType>')\nend\nend\nlocal function sse(cfg)\nif cfg.flags.EnableSSE then\n_p(3, '<EnableEnhancedInstructionSet>StreamingSIMDExtensions</EnableEnhancedInstructionSet>')\nelseif cfg.flags.EnableSSE2 then\n_p(3, '<EnableEnhancedInstructionSet>StreamingSIMDExtensions2</EnableEnhancedInstructio"
	"nSet>')\nelseif cfg.flags.EnableAVX then\n_p(3, '<EnableEnhancedInstructionSet>AdvancedVectorExtensions</EnableEnhancedInstructionSet>')\nelseif cfg.flags.EnableAVX2 then\n_p(3, '<EnableEnhancedInstructionSet>AdvancedVectorExtensions2</EnableEnhancedInstructionSet>')\nend\nend\nlocal function floating_point(cfg)\n     if cfg.flags.FloatFast then\n_p(3,'<FloatingPointModel>Fast</FloatingPointModel>')\nelseif cfg.flags.FloatStrict and not cfg.flags.Managed then\n_p(3,'<FloatingPointModel>Strict</FloatingPointModel>')\nend\nend\nlocal function debug_info(cfg)\nlocal debug_info = ''\nif cfg.flags.Symbols then\nif cfg.flags.C7DebugInfo then\ndebug_info = \"OldStyle\"\nelseif (action.vstudio.supports64bitEditContinue == false and cfg.platform == \"x64\")\nor cfg.flags.Managed\nor premake.config.isoptimizedbuild(cfg.flags)\nor cfg.flags.NoEditAndContinue\nthen\ndebug_info = \"ProgramDatabase\"\nelse\ndebug_info = \"EditAndContinue\"\nend\nend\n_p(3,'<DebugInformationFormat>%s</DebugInformationFormat>',debug_info)\nen"
	"d\nlocal function minimal_build(cfg)\nif premake.config.isdebugbuild(cfg) and cfg.flags.EnableMinimalRebuild then\n_p(3,'<MinimalRebuild>true</MinimalRebuild>')\nelse\n_p(3,'<MinimalRebuild>false</MinimalRebuild>')\nend\nend\nlocal function compile_language(cfg)\nif cfg.options.ForceCPP then\n_p(3,'<CompileAs>CompileAsCpp</CompileAs>')\nelse\nif cfg.language == \"C\" then\n_p(3,'<CompileAs>CompileAsC</CompileAs>')\nend\nend\nend\nlocal function forcedinclude_files(indent,cfg)\nif #cfg.forcedincludes > 0 then\n_p(indent,'<ForcedIncludeFiles>%s</ForcedIncludeFiles>'\n,premake.esc(path.translate(table.concat(cfg.forcedincludes, \";\"), '\\\\')))\nend\nend\nlocal function vs10_clcompile(cfg)\n_p(2,'<ClCompile>')\nlocal unsignedChar = \"/J \"\nlocal buildoptions = cfg.buildoptions\nif cfg.platform == \"Orbis\" then\nunsignedChar = \"-funsigned-char \";\n_p(3,'<GenerateDebugInformation>%s</GenerateDebugInformation>', tostring(cfg.flags.Symbols ~= nil))\nend\nif cfg.language == \"C\" and not cfg.options.ForceCPP then"
	"\nbuildoptions = table.join(buildoptions, cfg.buildoptions_c)\nelse\nbuildoptions = table.join(buildoptions, cfg.buildoptions_cpp)\nend\n_p(3,'<AdditionalOptions>%s %s%%(AdditionalOptions)</AdditionalOptions>'\n, table.concat(premake.esc(buildoptions), \" \")\n, iif(cfg.flags.UnsignedChar, unsignedChar, \" \")\n)\n_p(3,'<Optimization>%s</Optimization>',optimisation(cfg))\ninclude_dirs(3, cfg)\nusing_dirs(3, cfg)\npreprocessor(3, cfg)\nminimal_build(cfg)\nif  not premake.config.isoptimizedbuild(cfg.flags) then\nif not cfg.flags.Managed then\n_p(3, '<BasicRuntimeChecks>EnableFastChecks</BasicRuntimeChecks>')\nend\nif cfg.flags.ExtraWarnings then\nend\nelse\n_p(3, '<StringPooling>true</StringPooling>')\nend\nif cfg.platform == \"Durango\" or cfg.flags.NoWinRT then\n_p(3, '<CompileAsWinRT>false</CompileAsWinRT>')\nend\n_p(3, '<RuntimeLibrary>%s</RuntimeLibrary>', runtime(cfg))\nif cfg.flags.NoBufferSecurityCheck then\n_p(3, '<BufferSecurityCheck>false</BufferSecurityCheck>')\nend\n_p(3,'<FunctionLevelLinking>true<"
	"/FunctionLevelLinking>')\nif not cfg.flags.NoMultiProcessorCompilation and not cfg.flags.EnableMinimalRebuild then\n_p(3, '<MultiProcessorCompilation>true</MultiProcessorCompilation>')\nelse\n_p(3, '<MultiProcessorCompilation>false</MultiProcessorCompilation>')\nend\nprecompiled_header(cfg)\nif cfg.flags.PedanticWarnings then\n_p(3, '<WarningLevel>EnableAllWarnings</WarningLevel>')\nelseif cfg.flags.ExtraWarnings then\n_p(3, '<WarningLevel>Level4</WarningLevel>')\nelseif cfg.flags.MinimumWarnings then\n_p(3, '<WarningLevel>Level1</WarningLevel>')\nelse\n_p(3 ,'<WarningLevel>Level3</WarningLevel>')\nend\nif cfg.flags.FatalWarnings then\n_p(3, '<TreatWarningAsError>true</TreatWarningAsError>')\nend\nexceptions(cfg)\nrtti(cfg)\ncalling_convention(cfg)\nwchar_t_builtin(cfg)\nsse(cfg)\nfloating_point(cfg)\ndebug_info(cfg)\nif _ACTION:sub(3) == \"llvm\" then\n_p(3,'<SupportJustMyCode>false</SupportJustMyCode>')\nend\nif  cfg.flags.Symbols\nand _ACTION:sub(3) ~= \"2017\" and _ACTION:sub(3) ~= \"llvm\"\nthen\n_p(3, '<"
	"ProgramDataBaseFileName>$(OutDir)%s.pdb</ProgramDataBaseFileName>'\n, path.getbasename(cfg.buildtarget.name)\n)\nend\nif cfg.flags.NoFramePointer then\n_p(3, '<OmitFramePointers>true</OmitFramePointers>')\nend\nif cfg.flags.UseFullPaths then\n_p(3, '<UseFullPaths>true</UseFullPaths>')\nend\ncompile_language(cfg)\nforcedinclude_files(3,cfg);\n_p(2,'</ClCompile>')\nend\nlocal function event_hooks(cfg)\nif #cfg.postbuildcommands> 0 then\n    _p(2,'<PostBuildEvent>')\n_p(3,'<Command>%s</Command>',premake.esc(table.implode(cfg.postbuildcommands, \"\", \"\", \"\\r\\n\")))\n_p(2,'</PostBuildEvent>')\nend\nif #cfg.prebuildcommands> 0 then\n    _p(2,'<PreBuildEvent>')\n_p(3,'<Command>%s</Command>',premake.esc(table.implode(cfg.prebuildcommands, \"\", \"\", \"\\r\\n\")))\n_p(2,'</PreBuildEvent>')\nend\nif #cfg.prelinkcommands> 0 then\n    _p(2,'<PreLinkEvent>')\n_p(3,'<Command>%s</Command>',premake.esc(table.implode(cfg.prelinkcommands, \"\", \"\", \"\\r\\n\")))\n_p(2,'</PreLinkEvent>')\nend\nend\nlocal function additio"
	"nal_options(indent,cfg)\nif #cfg.linkoptions > 0 then\n_p(indent,'<AdditionalOptions>%s %%(AdditionalOptions)</AdditionalOptions>',\ntable.concat(premake.esc(cfg.linkoptions), \" \"))\nend\nend\nlocal function link_target_machine(index,cfg)\nlocal platforms = {x32 = 'MachineX86', x64 = 'MachineX64'}\nif platforms[cfg.platform] then\n_p(index,'<TargetMachine>%s</TargetMachine>', platforms[cfg.platform])\nend\nend\nlocal function item_def_lib(prj, cfg)\nif cfg.kind == 'StaticLib' and cfg.platform ~= \"Xbox360\" then\n_p(1,'<Lib>')\n_p(2,'<OutputFile>$(OutDir)%s</OutputFile>',cfg.buildtarget.name)\nadditional_options(2,cfg)\nlink_target_machine(2,cfg)\nif _ACTION:sub(3) == \"llvm\" and prj.name == \"portaudio\" then -- MSVC-LLVM needs special help\n_p(3,'<AdditionalDependencies>ksuser.lib;%%(AdditionalDependencies)</AdditionalDependencies>')\nend\n_p(1,'</Lib>')\nend\nend\nlocal function import_lib(cfg)\nif cfg.kind == \"SharedLib\" then\nlocal implibname = cfg.linktarget.fullpath\n_p(3,'<ImportLibrary>%s</Import"
	"Library>',iif(cfg.flags.NoImportLib, cfg.objectsdir .. \"\\\\\" .. path.getname(implibname), implibname))\nend\nend\nlocal function hasmasmfiles(prj)\nlocal files = vc2010.getfilegroup(prj, \"MASM\")\nreturn #files > 0\nend\nlocal function vs10_masm(prj, cfg)\nif hasmasmfiles(prj) then\n_p(2, '<MASM>')\n_p(3,'<AdditionalOptions>%s %%(AdditionalOptions)</AdditionalOptions>'\n, table.concat(premake.esc(table.join(cfg.buildoptions, cfg.buildoptions_asm)), \" \")\n)\nlocal includedirs = table.join(cfg.userincludedirs, cfg.includedirs)\nif #includedirs > 0 then\n_p(3, '<IncludePaths>%s;%%(IncludePaths)</IncludePaths>'\n, premake.esc(path.translate(table.concat(includedirs, \";\"), '\\\\'))\n)\nend\nlocal defines = table.join(cfg.defines)\ntable.insertflat(defines, iif(premake.config.isdebugbuild(cfg), \"_DEBUG\", {}))\ntable.insert(defines, iif(cfg.platform == \"x64\", \"_WIN64\", \"_WIN32\"))\ntable.insert(defines, iif(prj.kind == \"SharedLib\", \"_EXPORT=EXPORT\", \"_EXPORT=\"))\n_p(3, '<PreprocessorDefinitions>%"
	"s;%%(PreprocessorDefinitions)</PreprocessorDefinitions>'\n, premake.esc(table.concat(defines, \";\"))\n)\nif cfg.flags.FatalWarnings then\n_p(3,'<TreatWarningsAsErrors>true</TreatWarningsAsErrors>')\nend\nif cfg.flags.MinimumWarnings then\n_p(3,'<WarningLevel>0</WarningLevel>')\nelse\n_p(3,'<WarningLevel>3</WarningLevel>')\nend\n_p(2, '</MASM>')\nend\nend\nfunction vc2010.link(cfg)\n_p(2,'<Link>')\n_p(3,'<SubSystem>%s</SubSystem>', iif(cfg.kind == \"ConsoleApp\", \"Console\", \"Windows\"))\n_p(3,'<GenerateDebugInformation>%s</GenerateDebugInformation>',\niif(cfg.flags.Symbols ~= nil, iif(_ACTION:sub(3) ~= \"llvm\", \"true\", \"DebugFull\"), \"false\")\n)\nif  cfg.flags.Symbols\nand (_ACTION:sub(3) == \"2017\" or _ACTION:sub(3) == \"llvm\")\nthen\n_p(3, '<ProgramDataBaseFileName>$(OutDir)%s.pdb</ProgramDataBaseFileName>'\n, path.getbasename(cfg.buildtarget.name)\n)\nend\nif premake.config.isoptimizedbuild(cfg.flags) then\n_p(3,'<EnableCOMDATFolding>true</EnableCOMDATFolding>')\n_p(3,'<OptimizeReferences>true</O"
	"ptimizeReferences>')\nend\nif cfg.kind ~= 'StaticLib' then\nvc2010.additionalDependencies(3,cfg)\n_p(3,'<OutputFile>$(OutDir)%s</OutputFile>', cfg.buildtarget.name)\nif #cfg.libdirs > 0 then\n_p(3,'<AdditionalLibraryDirectories>%s;%%(AdditionalLibraryDirectories)</AdditionalLibraryDirectories>'\n, premake.esc(path.translate(table.concat(cfg.libdirs, ';'), '\\\\'))\n)\nend\nif vc2010.config_type(cfg) == 'Application' and not cfg.flags.WinMain and not cfg.flags.Managed then\nif cfg.flags.Unicode then\n_p(3,'<EntryPointSymbol>wmainCRTStartup</EntryPointSymbol>')\nelse\n_p(3,'<EntryPointSymbol>mainCRTStartup</EntryPointSymbol>')\nend\nend\nimport_lib(cfg)\nlocal deffile = premake.findfile(cfg, \".def\")\nif deffile then\n_p(3,'<ModuleDefinitionFile>%s</ModuleDefinitionFile>', deffile)\nend\nlink_target_machine(3,cfg)\nadditional_options(3,cfg)\nif cfg.flags.NoWinMD and vstudio.iswinrt() and prj.kind == \"WindowedApp\" then\n_p(3,'<GenerateWindowsMetadata>false</GenerateWindowsMetadata>' )\nend\nend\n_p(2,'</Link>'"
	")\nend\nfunction vc2010.additionalDependencies(tab,cfg)\nlocal links = premake.getlinks(cfg, \"system\", \"fullpath\")\nif #links > 0 then\nlocal deps = \"\"\nif cfg.platform == \"Orbis\" then\nfor _, v in ipairs(links) do\ndeps = deps .. \"-l\" .. v .. \";\"\nend\nelse\ndeps = table.concat(links, \";\")\nend\n_p(tab, '<AdditionalDependencies>%s;%s</AdditionalDependencies>'\n, deps\n, iif(cfg.platform == \"Durango\"\n, '%(XboxExtensionsDependencies)'\n, '%(AdditionalDependencies)'\n)\n)\nelseif cfg.platform == \"Durango\" then\n_p(tab, '<AdditionalDependencies>%%(XboxExtensionsDependencies)</AdditionalDependencies>')\nend\nend\nlocal function item_definitions(prj)\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\n_p(1,'<ItemDefinitionGroup ' ..if_config_and_platform() ..'>'\n,premake.esc(cfginfo.name))\nvs10_clcompile(cfg)\nresource_compile(cfg)\nitem_def_lib(prj, cfg)\nvc2010.link(cfg)\nevent_hooks(cfg)\nvs10_masm(prj, c"
	"fg)\n_p(1,'</ItemDefinitionGroup>')\nend\nend\nfunction vc2010.getfilegroup(prj, group)\nlocal sortedfiles = prj.vc2010sortedfiles\nif not sortedfiles then\nsortedfiles = {\nClCompile = {},\nClInclude = {},\nMASM = {},\nNone = {},\nResourceCompile = {},\nAppxManifest = {},\nNatvis = {},\nImage = {},\nDeploymentContent = {}\n}\nlocal foundAppxManifest = false\nfor file in premake.project.eachfile(prj, true) do\nif path.issourcefilevs(file.name) then\ntable.insert(sortedfiles.ClCompile, file)\nelseif path.iscppheader(file.name) then\nif not table.icontains(prj.removefiles, file) then\ntable.insert(sortedfiles.ClInclude, file)\nend\nelseif path.isresourcefile(file.name) then\ntable.insert(sortedfiles.ResourceCompile, file)\nelseif path.isimagefile(file.name) then\ntable.insert(sortedfiles.Image, file)\nelseif path.isappxmanifest(file.name) then\nfoundAppxManifest = true\ntable.insert(sortedfiles.AppxManifest, file)\nelseif path.isnatvis(file.name) then\ntable.insert(sortedfiles.Natvis, file)\nelseif path.isasmfil"
	"e(file.name) then\ntable.insert(sortedfiles.MASM, file)\nelseif file.flags and table.icontains(file.flags, \"DeploymentContent\") then\ntable.insert(sortedfiles.DeploymentContent, file)\nelse\ntable.insert(sortedfiles.None, file)\nend\nend\nif vstudio.iswinrt() and prj.kind == \"WindowedApp\" and not foundAppxManifest then\nvstudio.needAppxManifest = true\nlocal fcfg = {}\nfcfg.name = prj.name .. \"/Package.appxmanifest\"\nfcfg.vpath = premake.project.getvpath(prj, fcfg.name)\ntable.insert(sortedfiles.AppxManifest, fcfg)\nlocal logo = {}\nlogo.name  = prj.name .. \"/Logo.png\"\nlogo.vpath = logo.name\ntable.insert(sortedfiles.Image, logo)\nlocal smallLogo = {}\nsmallLogo.name  = prj.name .. \"/SmallLogo.png\"\nsmallLogo.vpath = smallLogo.name\ntable.insert(sortedfiles.Image, smallLogo)\nlocal storeLogo = {}\nstoreLogo.name  = prj.name .. \"/StoreLogo.png\"\nstoreLogo.vpath = storeLogo.name\ntable.insert(sortedfiles.Image, storeLogo)\nlocal splashScreen = {}\nsplashScreen.name  = prj.name .. \"/SplashScreen.png"
	"\"\nsplashScreen.vpath = splashScreen.name\ntable.insert(sortedfiles.Image, splashScreen)\nend\nprj.vc2010sortedfiles = sortedfiles\nend\nreturn sortedfiles[group]\nend\nfunction vc2010.files(prj)\nvc2010.simplefilesgroup(prj, \"ClInclude\")\nvc2010.compilerfilesgroup(prj)\nvc2010.simplefilesgroup(prj, \"None\")\nvc2010.customtaskgroup(prj)\nvc2010.simplefilesgroup(prj, \"ResourceCompile\")\nvc2010.simplefilesgroup(prj, \"AppxManifest\")\nvc2010.simplefilesgroup(prj, \"Natvis\")\nvc2010.deploymentcontentgroup(prj, \"Image\")\nvc2010.deploymentcontentgroup(prj, \"DeploymentContent\", \"None\")\nend\nfunction vc2010.customtaskgroup(prj)\nlocal files = { }\nfor _, custombuildtask in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nlocal fcfg = { }\nfcfg.name = path.getrelative(prj.location,buildtask[1])\nfcfg.vpath = path.trimdots(fcfg.name)\ntable.insert(files, fcfg)\nend\nend\nif #files > 0  then\n_p(1,'<ItemGroup>')\nlocal groupedBuildTasks = {}\nfor _, custombuildtas"
	"k in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nif (groupedBuildTasks[buildtask[1]] == nil) then\ngroupedBuildTasks[buildtask[1]] = {}\nend\ntable.insert(groupedBuildTasks[buildtask[1]], buildtask)\nend\nend\nfor name, custombuildtask in pairs(groupedBuildTasks or {}) do\n_p(2,'<CustomBuild Include=\\\"%s\\\">', path.translate(path.getrelative(prj.location,name), \"\\\\\"))\n_p(3,'<FileType>Text</FileType>')\nlocal cmd = \"\"\nlocal outputs = \"\"\nfor _, buildtask in ipairs(custombuildtask or {}) do\nfor _, cmdline in ipairs(buildtask[4] or {}) do\ncmd = cmd .. cmdline\nlocal num = 1\nfor _, depdata in ipairs(buildtask[3] or {}) do\ncmd = string.gsub(cmd,\"%$%(\" .. num ..\"%)\", string.format(\"%s \",path.getrelative(prj.location,depdata)))\nnum = num + 1\nend\ncmd = string.gsub(cmd, \"%$%(<%)\", string.format(\"%s \",path.getrelative(prj.location,buildtask[1])))\ncmd = string.gsub(cmd, \"%$%(@%)\", string.format(\"%s \",path.getrelative(prj.location,buildtask"
	"[2])))\ncmd = cmd .. \"\\r\\n\"\nend\noutputs = outputs .. path.getrelative(prj.location,buildtask[2]) .. \";\"\nend\n_p(3,'<Command>%s</Command>',cmd)\n_p(3,'<Outputs>%s%%(Outputs)</Outputs>',outputs)\n_p(3,'<SubType>Designer</SubType>')\n_p(3,'<Message></Message>')\n_p(2,'</CustomBuild>')\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.simplefilesgroup(prj, section, subtype)\nlocal files = vc2010.getfilegroup(prj, section)\nif #files > 0  then\n_p(1,'<ItemGroup>')\nfor _, file in ipairs(files) do\nif subtype then\n_p(2,'<%s Include=\\\"%s\\\">', section, path.translate(file.name, \"\\\\\"))\n_p(3,'<SubType>%s</SubType>', subtype)\n_p(2,'</%s>', section)\nelse\n_p(2,'<%s Include=\\\"%s\\\" />', section, path.translate(file.name, \"\\\\\"))\nend\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.deploymentcontentgroup(prj, section, filetype)\nif filetype == nil then\nfiletype = section\nend\nlocal files = vc2010.getfilegroup(prj, section)\nif #files > 0  then\n_p(1,'<ItemGroup>')\nfor _, file in ipair"
	"s(files) do\n_p(2,'<%s Include=\\\"%s\\\">', filetype, path.translate(file.name, \"\\\\\"))\n_p(3,'<DeploymentContent>true</DeploymentContent>')\n_p(3,'<Link>%s</Link>', path.translate(file.vpath, \"\\\\\"))\n_p(2,'</%s>', filetype)\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.compilerfilesgroup(prj)\nlocal configs = prj.solution.vstudio_configs\nlocal files = vc2010.getfilegroup(prj, \"ClCompile\")\nif #files > 0  then\nlocal config_mappings = {}\nfor _, cfginfo in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\nif cfg.pchheader and cfg.pchsource and not cfg.flags.NoPCH then\nconfig_mappings[cfginfo] = path.translate(cfg.pchsource, \"\\\\\")\nend\nend\n_p(1,'<ItemGroup>')\nfor _, file in ipairs(files) do\nlocal translatedpath = path.translate(file.name, \"\\\\\")\n_p(2, '<ClCompile Include=\\\"%s\\\">', translatedpath)\n_p(3, '<ObjectFileName>$(IntDir)%s\\\\</ObjectFileName>'\n, premake.esc(path.translate(path.trimdots(path.getdirectory(file.name)))"
	")\n)\nif path.iscxfile(file.name) then\n_p(3, '<CompileAsWinRT>true</CompileAsWinRT>')\n_p(3, '<RuntimeTypeInfo>true</RuntimeTypeInfo>')\n_p(3, '<PrecompiledHeader>NotUsing</PrecompiledHeader>')\nend\nif vstudio.iswinrt() and string.len(file.name) > 2 and string.sub(file.name, -2) == \".c\" then\n_p(3,'<CompileAsWinRT>FALSE</CompileAsWinRT>')\nend\nfor _, cfginfo in ipairs(configs) do\nif config_mappings[cfginfo] and translatedpath == config_mappings[cfginfo] then\n_p(3,'<PrecompiledHeader '.. if_config_and_platform() .. '>Create</PrecompiledHeader>', premake.esc(cfginfo.name))\nconfig_mappings[cfginfo] = nil  --only one source file per pch\nend\nend\nlocal nopch = table.icontains(prj.nopch, file.name)\nfor _, vsconfig in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, vsconfig.src_buildcfg, vsconfig.src_platform)\nif nopch or table.icontains(cfg.nopch, file.name) then\n_p(3,'<PrecompiledHeader '.. if_config_and_platform() .. '>NotUsing</PrecompiledHeader>', premake.esc(vsconfig.name))\nend\nend\nlocal "
	"excluded = table.icontains(prj.excludes, file.name)\nfor _, vsconfig in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, vsconfig.src_buildcfg, vsconfig.src_platform)\nlocal fileincfg = table.icontains(cfg.files, file.name)\nlocal cfgexcluded = table.icontains(cfg.excludes, file.name)\nif excluded or not fileincfg or cfgexcluded then\n_p(3, '<ExcludedFromBuild '\n.. if_config_and_platform()\n.. '>true</ExcludedFromBuild>'\n, premake.esc(vsconfig.name)\n)\nend\nend\nif prj.flags and prj.flags.Managed then\nlocal prjforcenative = table.icontains(prj.forcenative, file.name)\nfor _,vsconfig in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, vsconfig.src_buildcfg, vsconfig.src_platform)\nif prjforcenative or table.icontains(cfg.forcenative, file.name) then\n_p(3, '<CompileAsManaged ' .. if_config_and_platform() .. '>false</CompileAsManaged>', premake.esc(vsconfig.name))\nend\nend\nend\n_p(2,'</ClCompile>')\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.masmfiles(prj)\nlocal configs = prj.solutio"
	"n.vstudio_configs\nlocal files = vc2010.getfilegroup(prj, \"MASM\")\nif #files > 0 then\n_p(1, '<ItemGroup>')\nfor _, file in ipairs(files) do\nlocal translatedpath = path.translate(file.name, \"\\\\\")\n_p(2, '<MASM Include=\"%s\">', translatedpath)\nlocal excluded = table.icontains(prj.excludes, file.name)\nfor _, vsconfig in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, vsconfig.src_buildcfg, vsconfig.src_platform)\nlocal fileincfg = table.icontains(cfg.files, file.name)\nlocal cfgexcluded = table.icontains(cfg.excludes, file.name)\nif excluded or not fileincfg or cfgexcluded then\n_p(3, '<ExcludedFromBuild '\n.. if_config_and_platform()\n.. '>true</ExcludedFromBuild>'\n, premake.esc(vsconfig.name)\n)\nend\nend\n_p(2, '</MASM>')\nend\n_p(1, '</ItemGroup>')\nend\nend\nfunction vc2010.header(targets)\nio.eol = \"\\r\\n\"\n_p('<?xml version=\"1.0\" encoding=\"utf-8\"?>')\nlocal t = \"\"\nif targets then\nt = ' DefaultTargets=\"' .. targets .. '\"'\nend\n_p('<Project%s ToolsVersion=\"%s\" xmlns=\"http:"
	"//schemas.microsoft.com/developer/msbuild/2003\">', t, action.vstudio.toolsVersion)\nend\nfunction premake.vs2010_vcxproj(prj)\nlocal usemasm = hasmasmfiles(prj)\nio.indent = \"  \"\nvc2010.header(\"Build\")\nvs2010_config(prj)\nvs2010_globals(prj)\n_p(1,'<Import Project=\"$(VCTargetsPath)\\\\Microsoft.Cpp.Default.props\" />')\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\nvc2010.configurationPropertyGroup(cfg, cfginfo)\nend\n_p(1,'<Import Project=\"$(VCTargetsPath)\\\\Microsoft.Cpp.props\" />')\n_p(1,'<ImportGroup Label=\"ExtensionSettings\">')\nif usemasm then\n_p(2, '<Import Project=\"$(VCTargetsPath)\\\\BuildCustomizations\\\\masm.props\" />')\nend\n_p(1,'</ImportGroup>')\nimport_props(prj)\n_p(1,'<PropertyGroup Label=\"UserMacros\" />')\nvc2010.outputProperties(prj)\nitem_definitions(prj)\nif prj.flags.Managed then\nvc2010.clrReferences(prj)\nend\nvc2010.files(prj)\nvc2010.projectReferences(prj)\nvc2010.sdkReferen"
	"ces(prj)\nvc2010.masmfiles(prj)\n_p(1,'<Import Project=\"$(VCTargetsPath)\\\\Microsoft.Cpp.targets\" />')\n_p(1,'<ImportGroup Label=\"ExtensionTargets\">')\nif usemasm then\n_p(2, '<Import Project=\"$(VCTargetsPath)\\\\BuildCustomizations\\\\masm.targets\" />')\nend\n_p(1,'</ImportGroup>')\n_p('</Project>')\nend\nfunction vc2010.clrReferences(prj)\nif #prj.clrreferences == 0 then\nreturn\nend\n_p(1,'<ItemGroup>')\nfor _, ref in ipairs(prj.clrreferences) do\nif os.isfile(ref) then\nlocal assembly = path.getbasename(ref)\n_p(2,'<Reference Include=\"%s\">', assembly)\n_p(3,'<HintPath>%s</HintPath>', path.getrelative(prj.location, ref))\n_p(2,'</Reference>')\nelse\n_p(2,'<Reference Include=\"%s\" />', ref)\nend\nend\n_p(1,'</ItemGroup>')\nend\nfunction vc2010.projectReferences(prj)\nlocal deps = premake.getdependencies(prj)\nif #deps == 0 and #prj.vsimportreferences == 0 then\nreturn\nend\n_p(1,'<ItemGroup>')\nfor _, dep in ipairs(deps) do\nlocal deppath = path.getrelative(prj.location, vstudio.projectfile(dep))\n"
	"_p(2,'<ProjectReference Include=\\\"%s\\\">', path.translate(deppath, \"\\\\\"))\n_p(3,'<Project>{%s}</Project>', dep.uuid)\nif vstudio.iswinrt() then\n_p(3,'<ReferenceOutputAssembly>false</ReferenceOutputAssembly>')\nend\n_p(2,'</ProjectReference>')\nend\nfor _, ref in ipairs(prj.vsimportreferences) do\nlocal iprj = premake.vstudio.getimportprj(ref, prj.solution)\n_p(2,'<ProjectReference Include=\\\"%s\\\">', iprj.relpath)\n_p(3,'<Project>{%s}</Project>', iprj.uuid)\n_p(2,'</ProjectReference>')\nend\n_p(1,'</ItemGroup>')\nend\nfunction vc2010.sdkReferences(prj)\nlocal refs = prj.sdkreferences\nif #refs > 0 then\n_p(1,'<ItemGroup>')\nfor _, ref in ipairs(refs) do\n_p(2,'<SDKReference Include=\\\"%s\\\" />', ref)\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.debugdir(cfg)\nlocal debuggerFlavor =\n  iif(cfg.platform == \"Orbis\",   'ORBISDebugger'\n, iif(cfg.platform == \"Durango\", 'XboxOneVCppDebugger'\n,                                'WindowsLocalDebugger'\n))\n_p(2, '<DebuggerFlavor>%s</DebuggerFlav"
	"or>', debuggerFlavor)\nif cfg.debugdir and not vstudio.iswinrt() then\n_p(2, '<LocalDebuggerWorkingDirectory>%s</LocalDebuggerWorkingDirectory>'\n, path.translate(cfg.debugdir, '\\\\')\n)\nend\nif cfg.debugargs then\n_p(2, '<LocalDebuggerCommandArguments>%s</LocalDebuggerCommandArguments>'\n, table.concat(cfg.debugargs, \" \")\n)\nend\nif cfg.debugenvs and #cfg.debugenvs > 0 then\n_p(2, '<LocalDebuggerEnvironment>%s%s</LocalDebuggerEnvironment>'\n, table.concat(cfg.debugenvs, \"\\n\")\n, iif(cfg.flags.DebugEnvsInherit,'\\n$(LocalDebuggerEnvironment)', '')\n)\nif cfg.flags.DebugEnvsDontMerge then\n_p(2, '<LocalDebuggerMergeEnvironment>false</LocalDebuggerMergeEnvironment>')\nend\nend\nif cfg.deploymode then\n_p('    <DeployMode>%s</DeployMode>', cfg.deploymode)\nend\nend\nfunction premake.vs2010_vcxproj_user(prj)\nio.indent = \"  \"\nvc2010.header()\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\n_p('  <PropertyGroup '.."
	" if_config_and_platform() ..'>', premake.esc(cfginfo.name))\nvc2010.debugdir(cfg)\n_p('  </PropertyGroup>')\nend\n_p('</Project>')\nend\nlocal png1x1data = {\n0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d, 0x49, 0x48, 0x44, 0x52, -- .PNG........IHDR\n0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x25, 0xdb, 0x56, -- .............%.V\n0xca, 0x00, 0x00, 0x00, 0x03, 0x50, 0x4c, 0x54, 0x45, 0x00, 0x00, 0x00, 0xa7, 0x7a, 0x3d, 0xda, -- .....PLTE....z=.\n0x00, 0x00, 0x00, 0x01, 0x74, 0x52, 0x4e, 0x53, 0x00, 0x40, 0xe6, 0xd8, 0x66, 0x00, 0x00, 0x00, -- ....tRNS.@..f...\n0x0a, 0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63, 0x60, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0xe2, -- .IDAT..c`.......\n0x21, 0xbc, 0x33, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82,       -- !.3....IEND.B`.\n}\nfunction png1x1(obj, filename)\nfilename = premake.project.getfilename(obj, filename)\nlocal f, err = io.open(filename, \"wb\")\nif f then\nfor _, byte in ipairs("
	"png1x1data) do\nf:write(string.char(byte))\nend\nf:close()\nend\nend\nfunction premake.vs2010_appxmanifest(prj)\nio.indent = \"  \"\nio.eol = \"\\r\\n\"\n_p('<?xml version=\"1.0\" encoding=\"utf-8\"?>')\nif vstudio.toolset == \"v120_wp81\" then\n_p('<Package xmlns=\"http://schemas.microsoft.com/appx/2010/manifest\" xmlns:m2=\"http://schemas.microsoft.com/appx/2013/manifest\" xmlns:m3=\"http://schemas.microsoft.com/appx/2014/manifest\" xmlns:mp=\"http://schemas.microsoft.com/appx/2014/phone/manifest\">')\nelseif vstudio.storeapp == \"8.1\" then\n_p('<Package xmlns=\"http://schemas.microsoft.com/appx/2010/manifest\" xmlns:m3=\"http://schemas.microsoft.com/appx/2013/manifest\">')\nelseif vstudio.storeapp == \"durango\" then\n_p('<Package xmlns=\"http://schemas.microsoft.com/appx/2010/manifest\" xmlns:mx=\"http://schemas.microsoft.com/appx/2013/xbox/manifest\" IgnorableNamespaces=\"mx\">')\nelse\n_p('<Package xmlns=\"http://schemas.microsoft.com/appx/manifest/foundation/windows10\" xmlns:mp=\"http://schemas.micros"
	"oft.com/appx/2014/phone/manifest\" xmlns:m3=\"http://schemas.microsoft.com/appx/manifest/uap/windows10\">')\nend\n_p(1,'<Identity Name=\"' .. prj.uuid .. '\"')\n_p(2,'Publisher=\"CN=Publisher\"')\n_p(2,'Version=\"1.0.0.0\" />')\nif vstudio.toolset == \"v120_wp81\" or vstudio.storeapp == \"8.2\" then\n_p(1,'<mp:PhoneIdentity PhoneProductId=\"' .. prj.uuid .. '\" PhonePublisherId=\"00000000-0000-0000-0000-000000000000\"/>')\nend\n_p(1, '<Properties>')\n_p(2, '<DisplayName>' .. prj.name .. '</DisplayName>')\n_p(2, '<PublisherDisplayName>PublisherDisplayName</PublisherDisplayName>')\n_p(2, '<Logo>' .. prj.name .. '\\\\StoreLogo.png</Logo>')\npng1x1(prj, \"%%/StoreLogo.png\")\n_p(2, '<Description>' .. prj.name .. '</Description>')\n_p(1,'</Properties>')\nif vstudio.storeapp == \"8.2\" then\n_p(1, '<Dependencies>')\n_p(2, '<TargetDeviceFamily Name=\"Windows.Universal\" MinVersion=\"10.0.10069.0\" MaxVersionTested=\"10.0.10069.0\" />')\n_p(1, '</Dependencies>')\nelseif vstudio.storeapp == \"durango\" then\n_p(1, '<Pr"
	"erequisites>')\n_p(2, '<OSMinVersion>6.2</OSMinVersion>')\n_p(2, '<OSMaxVersionTested>6.2</OSMaxVersionTested>')\n_p(1, '</Prerequisites>')\nelse\n_p(1, '<Prerequisites>')\n_p(2, '<OSMinVersion>6.3.0</OSMinVersion>')\n_p(2, '<OSMaxVersionTested>6.3.0</OSMaxVersionTested>')\n_p(1, '</Prerequisites>')\nend\n_p(1,'<Resources>')\n_p(2,'<Resource Language=\"en-us\"/>')\n_p(1,'</Resources>')\n_p(1,'<Applications>')\n_p(2,'<Application Id=\"App\"')\n_p(3,'Executable=\"$targetnametoken$.exe\"')\n_p(3,'EntryPoint=\"' .. prj.name .. '.App\">')\nif vstudio.storeapp == \"durango\" then\n_p(3, '<VisualElements')\n_p(4, 'DisplayName=\"' .. prj.name .. '\"')\n_p(4, 'Logo=\"' .. prj.name .. '\\\\Logo.png\"')\npng1x1(prj, \"%%/Logo.png\")\n_p(4, 'SmallLogo=\"' .. prj.name .. '\\\\SmallLogo.png\"')\npng1x1(prj, \"%%/SmallLogo.png\")\n_p(4, 'Description=\"' .. prj.name .. '\"')\n_p(4, 'ForegroundText=\"light\"')\n_p(4, 'BackgroundColor=\"transparent\">')\n_p(5, '<SplashScreen Image=\"' .. prj.name .. '\\\\SplashScreen.png\" />')"
	"\npng1x1(prj, \"%%/SplashScreen.png\")\n_p(3, '</VisualElements>')\n_p(3, '<Extensions>')\n_p(4, '<mx:Extension Category=\"xbox.system.resources\">')\n_p(4, '<mx:XboxSystemResources />')\n_p(4, '</mx:Extension>')\n_p(3, '</Extensions>')\nelse\n_p(3, '<m3:VisualElements')\n_p(4, 'DisplayName=\"' .. prj.name .. '\"')\n_p(4, 'Square150x150Logo=\"' .. prj.name .. '\\\\Logo.png\"')\npng1x1(prj, \"%%/Logo.png\")\nif vstudio.toolset == \"v120_wp81\" or vstudio.storeapp == \"8.2\" then\n_p(4, 'Square44x44Logo=\"' .. prj.name .. '\\\\SmallLogo.png\"')\npng1x1(prj, \"%%/SmallLogo.png\")\nelse\n_p(4, 'Square30x30Logo=\"' .. prj.name .. '\\\\SmallLogo.png\"')\npng1x1(prj, \"%%/SmallLogo.png\")\nend\n_p(4, 'Description=\"' .. prj.name .. '\"')\n_p(4, 'ForegroundText=\"light\"')\n_p(4, 'BackgroundColor=\"transparent\">')\n_p(4, '<m3:SplashScreen Image=\"' .. prj.name .. '\\\\SplashScreen.png\" />')\npng1x1(prj, \"%%/SplashScreen.png\")\n_p(3, '</m3:VisualElements>')\nend\n_p(2,'</Application>')\n_p(1,'</Applications>')\n_p("
	"'</Package>')\nend\n",

	/* actions/vstudio/vstudio_vcxproj_filters.lua */
	"local vc2010 = premake.vstudio.vc2010\nlocal project = premake.project\nfunction vc2010.filteridgroup(prj)\nlocal filters = { }\nlocal filterfound = false\nfor file in premake.project.eachfile(prj, true) do\nlocal folders = string.explode(file.vpath, \"/\", true)\nlocal path = \"\"\nfor i = 1, #folders - 1 do\nif not filterfound then\nfilterfound = true\n_p(1,'<ItemGroup>')\nend\npath = path .. folders[i]\nif not filters[path] then\nfilters[path] = true\n_p(2, '<Filter Include=\"%s\">', path)\n_p(3, '<UniqueIdentifier>{%s}</UniqueIdentifier>', os.uuid(path))\n_p(2, '</Filter>')\nend\npath = path .. \"\\\\\"\nend\nend\nfor _, custombuildtask in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nlocal folders = string.explode(path.trimdots(path.getrelative(prj.location,buildtask[1])), \"/\", true)\nlocal path = \"\"\nfor i = 1, #folders - 1 do\nif not filterfound then\nfilterfound = true\n_p(1,'<ItemGroup>')\nend\npath = path .. folders[i]\nif not filters[path] then\nfilt"
	"ers[path] = true\n_p(2, '<Filter Include=\"%s\">', path)\n_p(3, '<UniqueIdentifier>{%s}</UniqueIdentifier>', os.uuid(path))\n_p(2, '</Filter>')\nend\npath = path .. \"\\\\\"\nend\nend\nend\nif filterfound then\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.filefiltergroup(prj, section, kind)\nlocal files = vc2010.getfilegroup(prj, section) or {}\nif kind == nill then\nkind = section\nend\nif (section == \"CustomBuild\") then\nfor _, custombuildtask in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nlocal fcfg = { }\nfcfg.name = path.getrelative(prj.location,buildtask[1])\nfcfg.vpath = path.trimdots(fcfg.name)\ntable.insert(files, fcfg)\nend\nend\nend\nif #files > 0 then\n_p(1,'<ItemGroup>')\nfor _, file in ipairs(files) do\nlocal filter\nif file.name ~= file.vpath then\nfilter = path.getdirectory(file.vpath)\nelse\nfilter = path.getdirectory(file.name)\nend\nif filter ~= \".\" then\n_p(2,'<%s Include=\\\"%s\\\">', kind, path.translate(file.name, \"\\\\\"))\n_p(3,'<"
	"Filter>%s</Filter>', path.translate(filter, \"\\\\\"))\n_p(2,'</%s>', kind)\nelse\n_p(2,'<%s Include=\\\"%s\\\" />', kind, path.translate(file.name, \"\\\\\"))\nend\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.generate_filters(prj)\nio.indent = \"  \"\nvc2010.header()\nvc2010.filteridgroup(prj)\nvc2010.filefiltergroup(prj, \"None\")\nvc2010.filefiltergroup(prj, \"ClInclude\")\nvc2010.filefiltergroup(prj, \"ClCompile\")\nvc2010.filefiltergroup(prj, \"ResourceCompile\")\nvc2010.filefiltergroup(prj, \"CustomBuild\")\nvc2010.filefiltergroup(prj, \"AppxManifest\")\nvc2010.filefiltergroup(prj, \"Natvis\")\nvc2010.filefiltergroup(prj, \"Image\")\nvc2010.filefiltergroup(prj, \"DeploymentContent\", \"None\")\nvc2010.filefiltergroup(prj, \"MASM\")\n_p('</Project>')\nend\n",

	/* actions/vstudio/vs2010.lua */
	"local vc2010 = premake.vstudio.vc2010\nlocal vstudio = premake.vstudio\nnewaction\n{\ntrigger         = \"vs2010\",\nshortname       = \"Visual Studio 2010\",\ndescription     = \"Generate Microsoft Visual Studio 2010 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\"},\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.vcxproj.filters\", vstudio.vc2010.generate_filters)\nend\nend,\noncleanso"
	"lution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nproductVersion  = \"8.0.30703\",\nsolutionVersion = \"11\",\ntargetFramework = \"4.0\",\ntoolsVersion    = \"4.0\",\nsupports64bitEditContinue = false,\nintDirAbsolute  = false,\n}\n}\n",

	/* actions/vstudio/vs2012.lua */
	"premake.vstudio.vc2012 = {}\nlocal vc2012 = premake.vstudio.vc2012\nlocal vstudio = premake.vstudio\nnewaction\n{\ntrigger         = \"vs2012\",\nshortname       = \"Visual Studio 2012\",\ndescription     = \"Generate Microsoft Visual Studio 2012 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\"},\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.vcxproj.filters\", vstudio.vc2010.generate_f"
	"ilters)\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nsolutionVersion = \"12\",\ntargetFramework = \"4.5\",\ntoolsVersion    = \"4.0\",\nsupports64bitEditContinue = false,\nintDirAbsolute  = false,\n}\n}\n",

	/* actions/vstudio/vs2013.lua */
	"premake.vstudio.vc2013 = {}\nlocal vc2013 = premake.vstudio.vc2013\nlocal vstudio = premake.vstudio\nnewaction\n{\ntrigger         = \"vs2013\",\nshortname       = \"Visual Studio 2013\",\ndescription     = \"Generate Microsoft Visual Studio 2013 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\"},\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.vstudio.needAppxManifest = false\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.vc"
	"xproj.filters\", vstudio.vc2010.generate_filters)\nif premake.vstudio.needAppxManifest then\npremake.generate(prj, \"%%/Package.appxmanifest\", premake.vs2010_appxmanifest)\nend\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nsolutionVersion = \"12\",\ntargetFramework = \"4.5\",\ntoolsVersion    = \"12.0\",\nsupports64bitEditContinue = false,\nintDirAbsolute  = false,\n}\n}\n",

	/* actions/vstudio/vs2015.lua */
	"premake.vstudio.vc2015 = {}\nlocal vc2015 = premake.vstudio.vc2015\nlocal vstudio = premake.vstudio\nnewaction\n{\ntrigger         = \"vs2015\",\nshortname       = \"Visual Studio 2015\",\ndescription     = \"Generate Microsoft Visual Studio 2015 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.vstudio.needAppxManifest = false\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.v"
	"cxproj.filters\", vstudio.vc2010.generate_filters)\nif premake.vstudio.needAppxManifest then\npremake.generate(prj, \"%%/Package.appxmanifest\", premake.vs2010_appxmanifest)\nend\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nsolutionVersion = \"12\",\ntargetFramework = \"4.5\",\ntoolsVersion    = \"14.0\",\nwindowsTargetPlatformVersion = \"8.1\",\nsupports64bitEditContinue    = true,\nintDirAbsolute  = false,\n}\n}\n",

	/* actions/vstudio/vs2017.lua */
	"premake.vstudio.vc2017 = {}\nlocal vc2017 = premake.vstudio.vc2017\nlocal vstudio = premake.vstudio\nnewaction\n{\ntrigger         = \"vs2017\",\nshortname       = \"Visual Studio 2017\",\ndescription     = \"Generate Microsoft Visual Studio 2017 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.vstudio.needAppxManifest = false\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.v"
	"cxproj.filters\", vstudio.vc2010.generate_filters)\nif premake.vstudio.needAppxManifest then\npremake.generate(prj, \"%%/Package.appxmanifest\", premake.vs2010_appxmanifest)\nend\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nsolutionVersion = \"12\",\ntargetFramework = \"4.5.2\",\ntoolsVersion    = \"15.0\",\nwindowsTargetPlatformVersion = \"8.1\",\nsupports64bitEditContinue    = true,\nintDirAbsolute  = true,\n}\n}\n",

	/* actions/vstudio/vsllvm.lua */
	"premake.vstudio.vcllvm = {}\nlocal vcllvm = premake.vstudio.vcllvm\nlocal vstudio = premake.vstudio\nnewaction\n{\ntrigger         = \"vsllvm\",\nshortname       = \"Visual Studio LLVM\",\ndescription     = \"Generate Microsoft Visual Studio LLVM project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.vstudio.needAppxManifest = false\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.v"
	"cxproj.filters\", vstudio.vc2010.generate_filters)\nif premake.vstudio.needAppxManifest then\npremake.generate(prj, \"%%/Package.appxmanifest\", premake.vs2010_appxmanifest)\nend\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nsolutionVersion = \"12\",\ntargetFramework = \"4.5.2\",\ntoolsVersion    = \"15.0\",\nwindowsTargetPlatformVersion = \"8.1\",\nsupports64bitEditContinue    = true,\nintDirAbsolute  = true,\n}\n}\n",

	/* actions/xcode/_xcode.lua */
	"premake.xcode = { }\npremake.xcode.xcode6 = { }\nlocal function checkproject(prj)\nlocal last\nfor cfg in premake.eachconfig(prj) do\nif last and last ~= cfg.kind then\nerror(\"Project '\" .. prj.name .. \"' uses more than one target kind; not supported by Xcode\", 0)\nend\nlast = cfg.kind\nend\nend\npremake.xcode.toolset = \"macosx\"\nnewaction\n{\ntrigger         = \"xcode3\",\nshortname       = \"Xcode 3\",\ndescription     = \"Generate Apple Xcode 3 project files (experimental)\",\nos              = \"macosx\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc     = { \"gcc\" },\n},\nvalid_platforms = {\nNative = \"Native\",\nx32 = \"Native 32-bit\",\nx64 = \"Native 64-bit\",\nUniversal32 = \"32-bit Universal\",\nUniversal64 = \"64-bit Universal\",\nUniversal = \"Universal\",\n},\ndefault_platform = \"Universal\",\nonsolution = function(sln)\npremake.xcode.preparesolution(sln)\nend,\nonproject = "
	"function(prj)\npremake.generate(prj, \"%%.xcodeproj/project.pbxproj\", premake.xcode.project)\nend,\noncleanproject = function(prj)\npremake.clean.directory(prj, \"%%.xcodeproj\")\nend,\noncheckproject = checkproject,\n}\nnewaction\n{\ntrigger         = \"xcode4\",\nshortname       = \"Xcode 4\",\ndescription     = \"Generate Apple Xcode 4 project files (experimental)\",\nos              = \"macosx\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc     = { \"gcc\" },\n},\nvalid_platforms = {\nNative = \"Native\",\nx32 = \"Native 32-bit\",\nx64 = \"Native 64-bit\",\nUniversal32 = \"32-bit Universal\",\nUniversal64 = \"64-bit Universal\",\nUniversal = \"Universal\",\n},\ndefault_platform = \"Universal\",\nonsolution = function(sln)\npremake.generate(sln, \"%%.xcworkspace/contents.xcworkspacedata\", premake.xcode4.workspace_generate)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.xcodepr"
	"oj/project.pbxproj\", premake.xcode.project)\nend,\noncleanproject = function(prj)\npremake.clean.directory(prj, \"%%.xcodeproj\")\npremake.clean.directory(prj, \"%%.xcworkspace\")\nend,\noncheckproject = checkproject,\n}\n",

	/* actions/xcode/xcode_common.lua */
	"premake.xcode.parameters = { }\nlocal xcode = premake.xcode\nlocal tree  = premake.tree\nfunction xcode.getbuildcategory(node)\nlocal categories = {\n[\".a\"] = \"Frameworks\",\n[\".c\"] = \"Sources\",\n[\".cc\"] = \"Sources\",\n[\".cpp\"] = \"Sources\",\n[\".cxx\"] = \"Sources\",\n[\".dylib\"] = \"Frameworks\",\n[\".bundle\"] = \"Frameworks\",\n[\".framework\"] = \"Frameworks\",\n[\".tbd\"] = \"Frameworks\",\n[\".m\"] = \"Sources\",\n[\".mm\"] = \"Sources\",\n[\".S\"] = \"Sources\",\n[\".strings\"] = \"Resources\",\n[\".nib\"] = \"Resources\",\n[\".xib\"] = \"Resources\",\n[\".icns\"] = \"Resources\",\n[\".bmp\"] = \"Resources\",\n[\".wav\"] = \"Resources\",\n[\".xcassets\"]  = \"Resources\",\n[\".xcdatamodeld\"] = \"Sources\",\n[\".swift\"] = \"Sources\",\n}\nreturn categories[path.getextension(node.name)]\nend\nfunction xcode.getconfigname(cfg)\nlocal name = cfg.name\nif #cfg.project.solution.xcode.platforms > 1 then\nname = name .. \" \" .. premake.action.current().valid_platforms[cfg.platform]\nend\nretur"
	"n name\nend\nfunction xcode.getfiletype(node)\nlocal types = {\n[\".c\"]         = \"sourcecode.c.c\",\n[\".cc\"]        = \"sourcecode.cpp.cpp\",\n[\".cpp\"]       = \"sourcecode.cpp.cpp\",\n[\".css\"]       = \"text.css\",\n[\".cxx\"]       = \"sourcecode.cpp.cpp\",\n[\".entitlements\"] = \"text.xml\",\n[\".bundle\"]    = \"wrapper.cfbundle\",\n[\".framework\"] = \"wrapper.framework\",\n[\".tbd\"]       = \"sourcecode.text-based-dylib-definition\",\n[\".gif\"]       = \"image.gif\",\n[\".h\"]         = \"sourcecode.c.h\",\n[\".html\"]      = \"text.html\",\n[\".lua\"]       = \"sourcecode.lua\",\n[\".m\"]         = \"sourcecode.c.objc\",\n[\".mm\"]        = \"sourcecode.cpp.objcpp\",\n[\".S\"]         = \"sourcecode.asm\",\n[\".nib\"]       = \"wrapper.nib\",\n[\".pch\"]       = \"sourcecode.c.h\",\n[\".plist\"]     = \"text.plist.xml\",\n[\".strings\"]   = \"text.plist.strings\",\n[\".xib\"]       = \"file.xib\",\n[\".icns\"]      = \"image.icns\",\n[\".bmp\"]       = \"image.bmp\",\n[\".wav\"]       = \"au"
	"dio.wav\",\n[\".xcassets\"]  = \"folder.assetcatalog\",\n[\".xcdatamodeld\"] = \"wrapper.xcdatamodeld\",\n[\".swift\"]     = \"sourcecode.swift\",\n}\nreturn types[path.getextension(node.path)] or \"text\"\nend\nfunction xcode.getfiletypeForced(node)\nlocal types = {\n[\".c\"]         = \"sourcecode.cpp.cpp\",\n[\".cc\"]        = \"sourcecode.cpp.cpp\",\n[\".cpp\"]       = \"sourcecode.cpp.cpp\",\n[\".css\"]       = \"text.css\",\n[\".cxx\"]       = \"sourcecode.cpp.cpp\",\n[\".entitlements\"] = \"text.xml\",\n[\".bundle\"]    = \"wrapper.cfbundle\",\n[\".framework\"] = \"wrapper.framework\",\n[\".tbd\"]       = \"wrapper.framework\",\n[\".gif\"]       = \"image.gif\",\n[\".h\"]         = \"sourcecode.cpp.h\",\n[\".html\"]      = \"text.html\",\n[\".lua\"]       = \"sourcecode.lua\",\n[\".m\"]         = \"sourcecode.cpp.objcpp\",\n[\".mm\"]        = \"sourcecode.cpp.objcpp\",\n[\".nib\"]       = \"wrapper.nib\",\n[\".pch\"]       = \"sourcecode.cpp.h\",\n[\".plist\"]     = \"text.plist.xml\",\n[\".strings\"]  "
	" = \"text.plist.strings\",\n[\".xib\"]       = \"file.xib\",\n[\".icns\"]      = \"image.icns\",\n[\".bmp\"]       = \"image.bmp\",\n[\".wav\"]       = \"audio.wav\",\n[\".xcassets\"]  = \"folder.assetcatalog\",\n[\".xcdatamodeld\"] = \"wrapper.xcdatamodeld\",\n[\".swift\"]     = \"sourcecode.swift\",\n}\nreturn types[path.getextension(node.path)] or \"text\"\nend\nfunction xcode.getproducttype(node)\nlocal types = {\nConsoleApp  = \"com.apple.product-type.tool\",\nWindowedApp = \"com.apple.product-type.application\",\nStaticLib   = \"com.apple.product-type.library.static\",\nSharedLib   = \"com.apple.product-type.library.dynamic\",\nBundle      = \"com.apple.product-type.bundle\",\n}\nreturn types[node.cfg.kind]\nend\nfunction xcode.gettargettype(node)\nlocal types = {\nConsoleApp  = \"\\\"compiled.mach-o.executable\\\"\",\nWindowedApp = \"wrapper.application\",\nStaticLib   = \"archive.ar\",\nSharedLib   = \"\\\"compiled.mach-o.dylib\\\"\",\nBundle      = \"wrapper.cfbundle\",\n}\nreturn types[node.cfg.kind]"
	"\nend\nfunction xcode.getxcodeprojname(prj)\nlocal fname = premake.project.getfilename(prj, \"%%.xcodeproj\")\nreturn fname\nend\nfunction xcode.isframework(fname)\nreturn (path.getextension(fname) == \".framework\" or path.getextension(fname) == \".tbd\")\nend\nfunction xcode.newid()\nreturn string.format(\"%04X%04X%04X%04X%04X%04X\",\nmath.random(0, 32767),\nmath.random(0, 32767),\nmath.random(0, 32767),\nmath.random(0, 32767),\nmath.random(0, 32767),\nmath.random(0, 32767))\nend\nfunction xcode.preparesolution(sln)\nsln.xcode = { }\nsln.xcode.platforms = premake.filterplatforms(sln, premake.action.current().valid_platforms, \"Universal\")\nfor prj in premake.solution.eachproject(sln) do\nlocal cfg = premake.getconfig(prj, prj.configurations[1], sln.xcode.platforms[1])\nlocal node = premake.tree.new(path.getname(cfg.buildtarget.bundlepath))\nnode.cfg = cfg\nnode.id = premake.xcode.newid(node, \"product\")\nnode.targetid = premake.xcode.newid(node, \"target\")\nprj.xcode = {}\nprj.xcode.projectnode = node\nen"
	"d\nend\nfunction xcode.printlist(list, tag)\nif #list > 0 then\n_p(4,'%s = (', tag)\nfor _, item in ipairs(list) do\nlocal escaped_item = item:gsub(\"\\\"\", \"\\\\\\\"\")\n_p(5, '\"%s\",', escaped_item)\nend\n_p(4,');')\nend\nend\nfunction xcode.Header()\n_p('// !$*UTF8*$!')\n_p('{')\n_p(1,'archiveVersion = 1;')\n_p(1,'classes = {')\n_p(1,'};')\n_p(1,'objectVersion = 45;')\n_p(1,'objects = {')\n_p('')\nend\nfunction xcode.PBXBuildFile(tr)\n_p('/* Begin PBXBuildFile section */')\ntree.traverse(tr, {\nonnode = function(node)\nif node.buildid then\n_p(2,'%s /* %s in %s */ = {isa = PBXBuildFile; fileRef = %s /* %s */; };',\nnode.buildid, node.name, xcode.getbuildcategory(node), node.id, node.name)\nend\nend\n})\n_p('/* End PBXBuildFile section */')\n_p('')\nend\nfunction xcode.PBXContainerItemProxy(tr)\nif #tr.projects.children > 0 then\n_p('/* Begin PBXContainerItemProxy section */')\nfor _, node in ipairs(tr.projects.children) do\n_p(2,'%s /* PBXContainerItemProxy */ = {', node.productproxyid)\n_p(3,'isa = PBXC"
	"ontainerItemProxy;')\n_p(3,'containerPortal = %s /* %s */;', node.id, path.getname(node.path))\n_p(3,'proxyType = 2;')\n_p(3,'remoteGlobalIDString = %s;', node.project.xcode.projectnode.id)\n_p(3,'remoteInfo = \"%s\";', node.project.xcode.projectnode.name)\n_p(2,'};')\n_p(2,'%s /* PBXContainerItemProxy */ = {', node.targetproxyid)\n_p(3,'isa = PBXContainerItemProxy;')\n_p(3,'containerPortal = %s /* %s */;', node.id, path.getname(node.path))\n_p(3,'proxyType = 1;')\n_p(3,'remoteGlobalIDString = %s;', node.project.xcode.projectnode.targetid)\n_p(3,'remoteInfo = \"%s\";', node.project.xcode.projectnode.name)\n_p(2,'};')\nend\n_p('/* End PBXContainerItemProxy section */')\n_p('')\nend\nend\nfunction xcode.PBXFileReference(tr,prj)\n_p('/* Begin PBXFileReference section */')\ntree.traverse(tr, {\nonleaf = function(node)\nif not node.path then\nreturn\nend\nif node.kind == \"product\" then\n_p(2,'%s /* %s */ = {isa = PBXFileReference; explicitFileType = %s; includeInIndex = 0; name = \"%s\"; path = \"%s\"; sourceTree"
	" = BUILT_PRODUCTS_DIR; };',\nnode.id, node.name, xcode.gettargettype(node), node.name, path.getname(node.cfg.buildtarget.bundlepath))\nelseif node.parent.parent == tr.projects then\nlocal relpath = path.getrelative(tr.project.location, node.parent.project.location)\n_p(2,'%s /* %s */ = {isa = PBXFileReference; lastKnownFileType = \"wrapper.pb-project\"; name = \"%s\"; path = \"%s\"; sourceTree = SOURCE_ROOT; };',\nnode.parent.id, node.parent.name, node.parent.name, path.join(relpath, node.parent.name))\nelse\nlocal pth, src\nif xcode.isframework(node.path) then\nlocal nodePath = node.path\nlocal _, matchEnd, variable = string.find(nodePath, \"^%$%((.+)%)/\")\nif variable then\nnodePath = string.sub(nodePath, matchEnd + 1)\nend\nif string.find(nodePath,'/')  then\nif string.find(nodePath,'^%.')then\nerror('relative paths are not currently supported for frameworks')\nend\npth = nodePath\nelseif path.getextension(nodePath)=='.tbd' then\npth = \"/usr/lib/\" .. nodePath\nelse\npth = \"/System/Library/Frameworks/\" "
	".. nodePath\nend\nif variable then\nsrc = variable\nif string.find(pth, '^/') then\npth = string.sub(pth, 2)\nend\nelse\nsrc = \"<absolute>\"\nend\nelse\nsrc = \"<group>\"\nif node.parent.isvpath then\npth = node.cfg.name\nelse\npth = tree.getlocalpath(node)\nend\nend\nif (not prj.options.ForceCPP) then\n_p(2,'%s /* %s */ = {isa = PBXFileReference; lastKnownFileType = %s; name = \"%s\"; path = \"%s\"; sourceTree = \"%s\"; };',\nnode.id, node.name, xcode.getfiletype(node), node.name, pth, src)\nelse\n_p(2,'%s /* %s */ = {isa = PBXFileReference; explicitFileType = %s; name = \"%s\"; path = \"%s\"; sourceTree = \"%s\"; };',\nnode.id, node.name, xcode.getfiletypeForced(node), node.name, pth, src)\nend\nend\nend\n})\n_p('/* End PBXFileReference section */')\n_p('')\nend\nfunction xcode.PBXFrameworksBuildPhase(tr)\n_p('/* Begin PBXFrameworksBuildPhase section */')\n_p(2,'%s /* Frameworks */ = {', tr.products.children[1].fxstageid)\n_p(3,'isa = PBXFrameworksBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'"
	"files = (')\ntree.traverse(tr.frameworks, {\nonleaf = function(node)\n_p(4,'%s /* %s in Frameworks */,', node.buildid, node.name)\nend\n})\ntree.traverse(tr.projects, {\nonleaf = function(node)\n_p(4,'%s /* %s in Frameworks */,', node.buildid, node.name)\nend\n})\n_p(3,');')\n_p(3,'runOnlyForDeploymentPostprocessing = 0;')\n_p(2,'};')\n_p('/* End PBXFrameworksBuildPhase section */')\n_p('')\nend\nfunction xcode.PBXGroup(tr)\n_p('/* Begin PBXGroup section */')\ntree.traverse(tr, {\nonnode = function(node)\nif (node.path and #node.children == 0) or node.kind == \"vgroup\" then\nreturn\nend\nif node.parent == tr.projects then\n_p(2,'%s /* Products */ = {', node.productgroupid)\nelse\n_p(2,'%s /* %s */ = {', node.id, node.name)\nend\n_p(3,'isa = PBXGroup;')\n_p(3,'children = (')\nfor _, childnode in ipairs(node.children) do\n_p(4,'%s /* %s */,', childnode.id, childnode.name)\nend\n_p(3,');')\nif node.parent == tr.projects then\n_p(3,'name = Products;')\nelse\n_p(3,'name = \"%s\";', node.name)\nif node.path and not"
	" node.isvpath then\nlocal p = node.path\nif node.parent.path then\np = path.getrelative(node.parent.path, node.path)\nend\n_p(3,'path = \"%s\";', p)\nend\nend\n_p(3,'sourceTree = \"<group>\";')\n_p(2,'};')\nend\n}, true)\n_p('/* End PBXGroup section */')\n_p('')\nend\nfunction xcode.PBXNativeTarget(tr)\n_p('/* Begin PBXNativeTarget section */')\nfor _, node in ipairs(tr.products.children) do\nlocal name = tr.project.name\nlocal function hasBuildCommands(which)\nif #tr.project[which] > 0 then\nreturn true\nend\nfor _, cfg in ipairs(tr.configs) do\nif #cfg[which] > 0 then\nreturn true\nend\nend\nend\n_p(2,'%s /* %s */ = {', node.targetid, name)\n_p(3,'isa = PBXNativeTarget;')\n_p(3,'buildConfigurationList = %s /* Build configuration list for PBXNativeTarget \"%s\" */;', node.cfgsection, name)\n_p(3,'buildPhases = (')\nif hasBuildCommands('prebuildcommands') then\n_p(4,'9607AE1010C857E500CD1376 /* Prebuild */,')\nend\n_p(4,'%s /* Resources */,', node.resstageid)\n_p(4,'%s /* Sources */,', node.sourcesid)\nif hasB"
	"uildCommands('prelinkcommands') then\n_p(4,'9607AE3510C85E7E00CD1376 /* Prelink */,')\nend\n_p(4,'%s /* Frameworks */,', node.fxstageid)\nif hasBuildCommands('postbuildcommands') then\n_p(4,'9607AE3710C85E8F00CD1376 /* Postbuild */,')\nend\n_p(3,');')\n_p(3,'buildRules = (')\n_p(3,');')\n_p(3,'dependencies = (')\nfor _, node in ipairs(tr.projects.children) do\n_p(4,'%s /* PBXTargetDependency */,', node.targetdependid)\nend\n_p(3,');')\n_p(3,'name = \"%s\";', name)\nlocal p\nif node.cfg.kind == \"ConsoleApp\" then\np = \"$(HOME)/bin\"\nelseif node.cfg.kind == \"WindowedApp\" then\np = \"$(HOME)/Applications\"\nend\nif p then\n_p(3,'productInstallPath = \"%s\";', p)\nend\n_p(3,'productName = \"%s\";', name)\n_p(3,'productReference = %s /* %s */;', node.id, node.name)\n_p(3,'productType = \"%s\";', xcode.getproducttype(node))\n_p(2,'};')\nend\n_p('/* End PBXNativeTarget section */')\n_p('')\nend\nfunction xcode.PBXProject(tr)\n_p('/* Begin PBXProject section */')\n_p(2,'__RootObject_ /* Project object */ = {')\n_"
	"p(3,'isa = PBXProject;')\n_p(3,'buildConfigurationList = 1DEB928908733DD80010E9CD /* Build configuration list for PBXProject \"%s\" */;', tr.name)\n_p(3,'compatibilityVersion = \"Xcode 3.2\";')\n_p(3,'hasScannedForEncodings = 1;')\n_p(3,'mainGroup = %s /* %s */;', tr.id, tr.name)\n_p(3,'projectDirPath = \"\";')\nif #tr.projects.children > 0 then\n_p(3,'projectReferences = (')\nfor _, node in ipairs(tr.projects.children) do\n_p(4,'{')\n_p(5,'ProductGroup = %s /* Products */;', node.productgroupid)\n_p(5,'ProjectRef = %s /* %s */;', node.id, path.getname(node.path))\n_p(4,'},')\nend\n_p(3,');')\nend\n_p(3,'projectRoot = \"\";')\n_p(3,'targets = (')\nfor _, node in ipairs(tr.products.children) do\n_p(4,'%s /* %s */,', node.targetid, node.name)\nend\n_p(3,');')\n_p(2,'};')\n_p('/* End PBXProject section */')\n_p('')\nend\nfunction xcode.PBXReferenceProxy(tr)\nif #tr.projects.children > 0 then\n_p('/* Begin PBXReferenceProxy section */')\ntree.traverse(tr.projects, {\nonleaf = function(node)\n_p(2,'%s /* %s */ = {'"
	", node.id, node.name)\n_p(3,'isa = PBXReferenceProxy;')\n_p(3,'fileType = %s;', xcode.gettargettype(node))\n_p(3,'path = \"%s\";', node.path)\n_p(3,'remoteRef = %s /* PBXContainerItemProxy */;', node.parent.productproxyid)\n_p(3,'sourceTree = BUILT_PRODUCTS_DIR;')\n_p(2,'};')\nend\n})\n_p('/* End PBXReferenceProxy section */')\n_p('')\nend\nend\nfunction xcode.PBXResourcesBuildPhase(tr)\n_p('/* Begin PBXResourcesBuildPhase section */')\nfor _, target in ipairs(tr.products.children) do\n_p(2,'%s /* Resources */ = {', target.resstageid)\n_p(3,'isa = PBXResourcesBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\ntree.traverse(tr, {\nonnode = function(node)\nif xcode.getbuildcategory(node) == \"Resources\" then\n_p(4,'%s /* %s in Resources */,', node.buildid, node.name)\nend\nend\n})\n_p(3,');')\n_p(3,'runOnlyForDeploymentPostprocessing = 0;')\n_p(2,'};')\nend\n_p('/* End PBXResourcesBuildPhase section */')\n_p('')\nend\nfunction xcode.PBXShellScriptBuildPhase(tr)\nlocal wrapperWritten = fals"
	"e\nlocal function doblock(id, name, which)\nlocal commands = {}\nfor _, cfg in ipairs(tr.configs) do\nlocal cfgcmds = cfg[which]\nif #cfgcmds > 0 then\ntable.insert(commands, 'if [ \"${CONFIGURATION}\" = \"' .. xcode.getconfigname(cfg) .. '\" ]; then')\nfor i = 1, #cfgcmds do\nlocal cmd = cfgcmds[i]\ncmd = cmd:gsub('\\\\','\\\\\\\\')\ntable.insert(commands, cmd)\nend\ntable.insert(commands, 'fi')\nend\nend\nif #commands > 0 then\nif not wrapperWritten then\n_p('/* Begin PBXShellScriptBuildPhase section */')\nwrapperWritten = true\nend\n_p(2,'%s /* %s */ = {', id, name)\n_p(3,'isa = PBXShellScriptBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\n_p(3,');')\n_p(3,'inputPaths = (');\n_p(3,');');\n_p(3,'name = %s;', name);\n_p(3,'outputPaths = (');\n_p(3,');');\n_p(3,'runOnlyForDeploymentPostprocessing = 0;');\n_p(3,'shellPath = /bin/sh;');\n_p(3,'shellScript = \"%s\";', table.concat(commands, \"\\\\n\"):gsub('\"', '\\\\\"'))\n_p(2,'};')\nend\nend\ndoblock(\"9607AE1010C857E500CD1376\", \"Pre"
	"build\", \"prebuildcommands\")\ndoblock(\"9607AE3510C85E7E00CD1376\", \"Prelink\", \"prelinkcommands\")\ndoblock(\"9607AE3710C85E8F00CD1376\", \"Postbuild\", \"postbuildcommands\")\nif wrapperWritten then\n_p('/* End PBXShellScriptBuildPhase section */')\nend\nend\nfunction xcode.PBXSourcesBuildPhase(tr,prj)\n_p('/* Begin PBXSourcesBuildPhase section */')\nfor _, target in ipairs(tr.products.children) do\n_p(2,'%s /* Sources */ = {', target.sourcesid)\n_p(3,'isa = PBXSourcesBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\ntree.traverse(tr, {\nonleaf = function(node)\nif xcode.getbuildcategory(node) == \"Sources\" then\nif not table.icontains(prj.excludes, node.cfg.name) then -- if not excluded\n_p(4,'%s /* %s in Sources */,', node.buildid, node.name)\nend\nend\nend\n})\n_p(3,');')\n_p(3,'runOnlyForDeploymentPostprocessing = 0;')\n_p(2,'};')\nend\n_p('/* End PBXSourcesBuildPhase section */')\n_p('')\nend\nfunction xcode.PBXVariantGroup(tr)\n_p('/* Begin PBXVariantGroup section */')\ntree"
	".traverse(tr, {\nonbranch = function(node)\nif node.kind == \"vgroup\" then\n_p(2,'%s /* %s */ = {', node.id, node.name)\n_p(3,'isa = PBXVariantGroup;')\n_p(3,'children = (')\nfor _, lang in ipairs(node.children) do\n_p(4,'%s /* %s */,', lang.id, lang.name)\nend\n_p(3,');')\n_p(3,'name = %s;', node.name)\n_p(3,'sourceTree = \"<group>\";')\n_p(2,'};')\nend\nend\n})\n_p('/* End PBXVariantGroup section */')\n_p('')\nend\nfunction xcode.PBXTargetDependency(tr)\nif #tr.projects.children > 0 then\n_p('/* Begin PBXTargetDependency section */')\ntree.traverse(tr.projects, {\nonleaf = function(node)\n_p(2,'%s /* PBXTargetDependency */ = {', node.parent.targetdependid)\n_p(3,'isa = PBXTargetDependency;')\n_p(3,'name = \"%s\";', node.name)\n_p(3,'targetProxy = %s /* PBXContainerItemProxy */;', node.parent.targetproxyid)\n_p(2,'};')\nend\n})\n_p('/* End PBXTargetDependency section */')\n_p('')\nend\nend\nfunction xcode.XCBuildConfiguration_Target(tr, target, cfg)\nlocal cfgname = xcode.getconfigname(cfg)\n_p(2,'%s /* %s *"
	"/ = {', cfg.xcode.targetid, cfgname)\n_p(3,'isa = XCBuildConfiguration;')\n_p(3,'buildSettings = {')\n_p(4,'ALWAYS_SEARCH_USER_PATHS = NO;')\nif not cfg.flags.Symbols then\n_p(4,'DEBUG_INFORMATION_FORMAT = \"dwarf-with-dsym\";')\nend\nif cfg.kind ~= \"StaticLib\" and cfg.buildtarget.prefix ~= \"\" then\n_p(4,'EXECUTABLE_PREFIX = %s;', cfg.buildtarget.prefix)\nend\nif cfg.targetextension then\nlocal ext = cfg.targetextension\next = iif(ext:startswith(\".\"), ext:sub(2), ext)\n_p(4,'EXECUTABLE_EXTENSION = %s;', ext)\nend\nif cfg.flags.ObjcARC then\n_p(4,'CLANG_ENABLE_OBJC_ARC = YES;')\nend\nlocal outdir = path.getdirectory(cfg.buildtarget.bundlepath)\nif outdir ~= \".\" then\n_p(4,'CONFIGURATION_BUILD_DIR = %s;', outdir)\nend\n_p(4,'GCC_DYNAMIC_NO_PIC = NO;')\n_p(4,'GCC_MODEL_TUNING = G5;')\nif tr.infoplist then\n_p(4,'INFOPLIST_FILE = \"%s\";', tr.infoplist.cfg.name)\nend\ninstallpaths = {\nConsoleApp = '/usr/local/bin',\nWindowedApp = '\"$(HOME)/Applications\"',\nSharedLib = '/usr/local/lib',\nStaticLib = '/us"
	"r/local/lib',\nBundle    = '\"$(LOCAL_LIBRARY_DIR)/Bundles\"',\n}\n_p(4,'INSTALL_PATH = %s;', installpaths[cfg.kind])\nlocal infoplist_file = nil\nfor _, v in ipairs(cfg.files) do\nif (string.find (string.lower (v), 'info.plist') ~= nil) then\ninfoplist_file = string.format('$(SRCROOT)/%s', v)\nend\nend\nif infoplist_file ~= nil then\n_p(4,'INFOPLIST_FILE = \"%s\";', infoplist_file)\nend\nif cfg.kind == \"Bundle\" then\n_p(4, 'PRODUCT_BUNDLE_IDENTIFIER = \"genie.%s\";', cfg.buildtarget.basename:gsub(\"%s+\", '.')) --replace spaces with .\nend\n_p(4,'PRODUCT_NAME = \"%s\";', cfg.buildtarget.basename)\nif cfg.kind == \"Bundle\" then\n_p(4, 'WRAPPER_EXTENSION = bundle;')\nend\n_p(3,'};')\n_p(3,'name = \"%s\";', cfgname)\n_p(2,'};')\nend\nlocal function cfg_excluded_files(prj, cfg)\nlocal excluded = {}\nlocal function exclude_pattern(file)\nif path.isabsolute(file) then\nreturn file\nend\nlocal start, term = file:findlast(\"/%.%./\")\nif term then\nreturn path.join(\"*\", file:sub(term + 1))\nend\nstart, term = fi"
	"le:find(\"%.%./\")\nif start == 1 then\nreturn path.join(\"*\", file:sub(term + 1))\nend\nreturn path.join(\"*\", file)\nend\nlocal function add_file(file)\nlocal name = exclude_pattern(file)\nif not table.icontains(excluded, name) then\ntable.insert(excluded, name)\nend\nend\nlocal function verify_file(file)\nlocal name = exclude_pattern(file)\nif table.icontains(excluded, name) then\nerror(\"'\" .. file .. \"' would be excluded by the rule to exclude '\" .. name .. \"'\")\nend\nend\nfor _, file in ipairs(cfg.excludes) do\nadd_file(file)\nend\nfor _, file in ipairs(prj.allfiles) do\nif not table.icontains(prj.excludes, file) and not table.icontains(cfg.excludes, file) then\nif not table.icontains(cfg.files, file) then\nadd_file(file)\nelse\nverify_file(file)\nend\nend\nend\ntable.sort(excluded)\nreturn excluded\nend\nfunction xcode.XCBuildConfiguration_Project(tr, prj, cfg)\nlocal cfgname = xcode.getconfigname(cfg)\n_p(2,'%s /* %s */ = {', cfg.xcode.projectid, cfgname)\n_p(3,'isa = XCBuildConfiguration;')\n_p"
	"(3,'buildSettings = {')\nlocal archs = {\nNative = \"$(NATIVE_ARCH_ACTUAL)\",\nx32    = \"i386\",\nx64    = \"x86_64\",\nUniversal32 = \"$(ARCHS_STANDARD_32_BIT)\",\nUniversal64 = \"$(ARCHS_STANDARD_64_BIT)\",\nUniversal = \"$(ARCHS_STANDARD_32_64_BIT)\",\n}\n_p(4,'ARCHS = \"%s\";', archs[cfg.platform])\n_p(4,'SDKROOT = \"%s\";', xcode.toolset)\nif tr.entitlements then\n_p(4,'CODE_SIGN_ENTITLEMENTS = \"%s\";', tr.entitlements.cfg.name)\nend\nlocal targetdir = path.getdirectory(cfg.buildtarget.bundlepath)\nif targetdir ~= \".\" then\n_p(4,'CONFIGURATION_BUILD_DIR = \"$(SYMROOT)\";');\nend\n_p(4,'CONFIGURATION_TEMP_DIR = \"$(OBJROOT)\";')\nif cfg.flags.Symbols then\n_p(4,'COPY_PHASE_STRIP = NO;')\nend\nlocal excluded = cfg_excluded_files(prj, cfg)\nif #excluded > 0 then\n_p(4, 'EXCLUDED_SOURCE_FILE_NAMES = (')\nfor _, file in ipairs(excluded) do\n_p(5, '\"' .. file .. '\",')\nend\n_p(4, ');')\nend\n_p(4,'GCC_C_LANGUAGE_STANDARD = gnu99;')\nif cfg.flags.NoExceptions then\n_p(4,'GCC_ENABLE_CPP_EXCEPTIONS = NO;')\n"
	"end\nif cfg.flags.NoRTTI then\n_p(4,'GCC_ENABLE_CPP_RTTI = NO;')\nend\nif _ACTION ~= \"xcode4\" and cfg.flags.Symbols and not cfg.flags.NoEditAndContinue then\n_p(4,'GCC_ENABLE_FIX_AND_CONTINUE = YES;')\nend\nif cfg.flags.NoExceptions then\n_p(4,'GCC_ENABLE_OBJC_EXCEPTIONS = NO;')\nend\nif cfg.flags.Optimize or cfg.flags.OptimizeSize then\n_p(4,'GCC_OPTIMIZATION_LEVEL = s;')\nelseif cfg.flags.OptimizeSpeed then\n_p(4,'GCC_OPTIMIZATION_LEVEL = 3;')\nelse\n_p(4,'GCC_OPTIMIZATION_LEVEL = 0;')\nend\nif cfg.pchheader and not cfg.flags.NoPCH then\n_p(4,'GCC_PRECOMPILE_PREFIX_HEADER = YES;')\n_p(4,'GCC_PREFIX_HEADER = \"%s\";', cfg.pchheader)\nend\nxcode.printlist(cfg.defines, 'GCC_PREPROCESSOR_DEFINITIONS')\n_p(4,'GCC_SYMBOLS_PRIVATE_EXTERN = NO;')\nif cfg.flags.FatalWarnings then\n_p(4,'GCC_TREAT_WARNINGS_AS_ERRORS = YES;')\nend\n_p(4,'GCC_WARN_ABOUT_RETURN_TYPE = YES;')\n_p(4,'GCC_WARN_UNUSED_VARIABLE = YES;')\nxcode.printlist(cfg.includedirs, 'HEADER_SEARCH_PATHS')\nxcode.printlist(cfg.userincludedirs, 'USER_HEAD"
	"ER_SEARCH_PATHS')\nxcode.printlist(cfg.libdirs, 'LIBRARY_SEARCH_PATHS')\n_p(4,'OBJROOT = \"%s\";', cfg.objectsdir)\n_p(4,'ONLY_ACTIVE_ARCH = %s;',iif(premake.config.isdebugbuild(cfg),'YES','NO'))\nlocal checks = {\n[\"-ffast-math\"]          = cfg.flags.FloatFast,\n[\"-ffloat-store\"]        = cfg.flags.FloatStrict,\n[\"-fomit-frame-pointer\"] = cfg.flags.NoFramePointer,\n}\nlocal flags = { }\nfor flag, check in pairs(checks) do\nif check then\ntable.insert(flags, flag)\nend\nend\nfor _, val in ipairs(premake.xcode.parameters) do\n_p(4, val ..';')\nend\nxcode.printlist(table.join(flags, cfg.buildoptions, cfg.buildoptions_c), 'OTHER_CFLAGS')\nxcode.printlist(table.join(flags, cfg.buildoptions, cfg.buildoptions_cpp), 'OTHER_CPLUSPLUSFLAGS')\nflags = { }\nfor _, lib in ipairs(premake.getlinks(cfg, \"system\")) do\nif not xcode.isframework(lib) then\ntable.insert(flags, \"-l\" .. lib)\nend\nend\nflags = table.join(flags, cfg.linkoptions)\nxcode.printlist(flags, 'OTHER_LDFLAGS')\nif cfg.flags.StaticRuntime then\n_p"
	"(4,'STANDARD_C_PLUS_PLUS_LIBRARY_TYPE = static;')\nend\nif targetdir ~= \".\" then\n_p(4,'SYMROOT = \"%s\";', targetdir)\nend\nif cfg.flags.PedanticWarnings\nor cfg.flags.ExtraWarnings\nthen\n_p(4,'WARNING_CFLAGS = \"-Wall\";')\nend\n_p(3,'};')\n_p(3,'name = \"%s\";', cfgname)\n_p(2,'};')\nend\nfunction xcode.XCBuildConfiguration(tr, prj)\n_p('/* Begin XCBuildConfiguration section */')\nfor _, target in ipairs(tr.products.children) do\nfor _, cfg in ipairs(tr.configs) do\nxcode.XCBuildConfiguration_Target(tr, target, cfg)\nend\nend\nfor _, cfg in ipairs(tr.configs) do\nxcode.XCBuildConfiguration_Project(tr, prj, cfg)\nend\n_p('/* End XCBuildConfiguration section */')\n_p('')\nend\nfunction xcode.XCBuildConfigurationList(tr)\nlocal sln = tr.project.solution\n_p('/* Begin XCConfigurationList section */')\nfor _, target in ipairs(tr.products.children) do\n_p(2,'%s /* Build configuration list for PBXNativeTarget \"%s\" */ = {', target.cfgsection, target.name)\n_p(3,'isa = XCConfigurationList;')\n_p(3,'buildConfigu"
	"rations = (')\nfor _, cfg in ipairs(tr.configs) do\n_p(4,'%s /* %s */,', cfg.xcode.targetid, xcode.getconfigname(cfg))\nend\n_p(3,');')\n_p(3,'defaultConfigurationIsVisible = 0;')\n_p(3,'defaultConfigurationName = \"%s\";', xcode.getconfigname(tr.configs[1]))\n_p(2,'};')\nend\n_p(2,'1DEB928908733DD80010E9CD /* Build configuration list for PBXProject \"%s\" */ = {', tr.name)\n_p(3,'isa = XCConfigurationList;')\n_p(3,'buildConfigurations = (')\nfor _, cfg in ipairs(tr.configs) do\n_p(4,'%s /* %s */,', cfg.xcode.projectid, xcode.getconfigname(cfg))\nend\n_p(3,');')\n_p(3,'defaultConfigurationIsVisible = 0;')\n_p(3,'defaultConfigurationName = \"%s\";', xcode.getconfigname(tr.configs[1]))\n_p(2,'};')\n_p('/* End XCConfigurationList section */')\n_p('')\nend\nfunction xcode.Footer()\n_p(1,'};')\n_p('\\trootObject = __RootObject_ /* Project object */;')\n_p('}')\nend\n",

	/* actions/xcode/xcode_project.lua */
	"local xcode = premake.xcode\nlocal tree = premake.tree\nfunction xcode.buildprjtree(prj)\nlocal tr = premake.project.buildsourcetree(prj, true)\ntr.configs = {}\nfor _, cfgname in ipairs(prj.solution.configurations) do\nfor _, platform in ipairs(prj.solution.xcode.platforms) do\nlocal cfg = premake.getconfig(prj, cfgname, platform)\ncfg.xcode = {}\ncfg.xcode.targetid = xcode.newid(prj.xcode.projectnode, cfgname)\ncfg.xcode.projectid = xcode.newid(tr, cfgname)\ntable.insert(tr.configs, cfg)\nend\nend\ntree.traverse(tr, {\nonbranch = function(node)\nif path.getextension(node.name) == \".lproj\" then\nlocal lang = path.getbasename(node.name)  -- \"English\", \"French\", etc.\nfor _, filenode in ipairs(node.children) do\nlocal grpnode = node.parent.children[filenode.name]\nif not grpnode then\ngrpnode = tree.insert(node.parent, tree.new(filenode.name))\ngrpnode.kind = \"vgroup\"\nend\nfilenode.name = path.getbasename(lang)\ntree.insert(grpnode, filenode)\nend\ntree.remove(node)\nend\nend\n})\ntree.traverse(tr, {\n"
	"onbranch = function(node)\nif path.getextension(node.name) == \".xcassets\" then\nnode.children = {}\nend\nend\n})\ntr.frameworks = tree.new(\"Frameworks\")\nfor cfg in premake.eachconfig(prj) do\nfor _, link in ipairs(premake.getlinks(cfg, \"system\", \"fullpath\")) do\nlocal name = path.getname(link)\nif xcode.isframework(name) and not tr.frameworks.children[name] then\nnode = tree.insert(tr.frameworks, tree.new(name))\nnode.path = link\nend\nend\nend\nif #tr.frameworks.children > 0 then\ntree.insert(tr, tr.frameworks)\nend\ntr.products = tree.insert(tr, tree.new(\"Products\"))\ntr.projects = tree.new(\"Projects\")\nfor _, dep in ipairs(premake.getdependencies(prj, \"sibling\", \"object\")) do\nlocal xcpath = xcode.getxcodeprojname(dep)\nlocal xcnode = tree.insert(tr.projects, tree.new(path.getname(xcpath)))\nxcnode.path = xcpath\nxcnode.project = dep\nxcnode.productgroupid = xcode.newid(xcnode, \"prodgrp\")\nxcnode.productproxyid = xcode.newid(xcnode, \"prodprox\")\nxcnode.targetproxyid  = xcode.newid(xcnod"
	"e, \"targprox\")\nxcnode.targetdependid = xcode.newid(xcnode, \"targdep\")\nlocal cfg = premake.getconfig(dep, prj.configurations[1])\nnode = tree.insert(xcnode, tree.new(cfg.linktarget.name))\nnode.path = cfg.linktarget.fullpath\nnode.cfg = cfg\nend\nif #tr.projects.children > 0 then\ntree.insert(tr, tr.projects)\nend\ntree.traverse(tr, {\nonnode = function(node)\nnode.id = xcode.newid(node)\nif xcode.getbuildcategory(node) then\nnode.buildid = xcode.newid(node, \"build\")\nend\nif string.endswith(node.name, \"Info.plist\") then\ntr.infoplist = node\nend\nif string.endswith(node.name, \".entitlements\") then\ntr.entitlements = node\nend\nend\n}, true)\nnode = tree.insert(tr.products, prj.xcode.projectnode)\nnode.kind = \"product\"\nnode.path = node.cfg.buildtarget.fullpath\nnode.cfgsection = xcode.newid(node, \"cfg\")\nnode.resstageid = xcode.newid(node, \"rez\")\nnode.sourcesid  = xcode.newid(node, \"src\")\nnode.fxstageid  = xcode.newid(node, \"fxs\")\nreturn tr\nend\nfunction premake.xcode.project(prj)\nlo"
	"cal tr = xcode.buildprjtree(prj)\nxcode.Header(tr)\nxcode.PBXBuildFile(tr)\nxcode.PBXContainerItemProxy(tr)\nxcode.PBXFileReference(tr,prj)\nxcode.PBXFrameworksBuildPhase(tr)\nxcode.PBXGroup(tr)\nxcode.PBXNativeTarget(tr)\nxcode.PBXProject(tr)\nxcode.PBXReferenceProxy(tr)\nxcode.PBXResourcesBuildPhase(tr)\nxcode.PBXShellScriptBuildPhase(tr)\nxcode.PBXSourcesBuildPhase(tr,prj)\nxcode.PBXVariantGroup(tr)\nxcode.PBXTargetDependency(tr)\nxcode.XCBuildConfiguration(tr, prj)\nxcode.XCBuildConfigurationList(tr)\nxcode.Footer(tr)\nend\n",

	/* actions/xcode/xcode4_workspace.lua */
	"premake.xcode4 = {}\nlocal xcode4 = premake.xcode4\nfunction xcode4.workspace_head()\n_p('<?xml version=\"1.0\" encoding=\"UTF-8\"?>')\n_p('<Workspace')\n_p(1,'version = \"1.0\">')\nend\nfunction xcode4.workspace_tail()\n_p('</Workspace>')\nend\nfunction xcode4.workspace_file_ref(prj, indent)\nlocal projpath = path.getrelative(prj.solution.location, prj.location)\nif projpath == '.' then projpath = ''\nelse projpath = projpath ..'/'\nend\n_p(indent, '<FileRef')\n_p(indent + 1, 'location = \"group:%s\">', projpath .. prj.name .. '.xcodeproj')\n_p(indent, '</FileRef>')\nend\nfunction xcode4.workspace_group(grp, indent)\n_p(indent, '<Group')\n_p(indent + 1, 'location = \"container:\"')\n_p(indent + 1, 'name = \"%s\">', grp.name)\nfor _, child in ipairs(grp.groups) do\nxcode4.workspace_group(child, indent + 1)\nend\nfor _, prj in ipairs(grp.projects) do\nxcode4.workspace_file_ref(prj, indent + 1)\nend\n_p(indent, '</Group>')\nend\nfunction xcode4.workspace_generate(sln)\npremake.xcode.preparesolution(sln)\nxcode4."
	"workspace_head()\nxcode4.reorderProjects(sln)\nfor grp in premake.solution.eachgroup(sln) do\nif grp.parent == nil then\nxcode4.workspace_group(grp, 1)\nend\nend\nfor prj in premake.solution.eachproject(sln) do\nif prj.group == nil then\nxcode4.workspace_file_ref(prj, 1)\nend\nend\nxcode4.workspace_tail()\nend\nfunction xcode4.reorderProjects(sln)\nif sln.startproject then\nfor i, prj in ipairs(sln.projects) do\nif sln.startproject == prj.name then\nlocal cur = prj.group\nwhile cur ~= nil do\nfor j, group in ipairs(sln.groups) do\nif group == cur then\ntable.remove(sln.groups, j)\nbreak\nend\nend\ntable.insert(sln.groups, 1, cur)\ncur = cur.parent\nend\ntable.remove(sln.projects, i)\ntable.insert(sln.projects, 1, prj)\nbreak\nend\nend\nend\nend\n",

	/* actions/xcode/xcode6_project.lua */
	"local xcode  = premake.xcode\nlocal xcode6 = xcode.xcode6\nlocal tree   = premake.tree\nfunction xcode6.buildprjtree(prj)\nlocal tr = premake.project.buildsourcetree(prj)\ntr.configs = {}\nfor _, cfgname in ipairs(prj.solution.configurations) do\nfor _, platform in ipairs(prj.solution.xcode.platforms) do\nlocal cfg = premake.getconfig(prj, cfgname, platform)\ncfg.xcode = {}\ncfg.xcode.targetid = xcode.newid(prj.xcode.projectnode, cfgname)\ncfg.xcode.projectid = xcode.newid(tr, cfgname)\ntable.insert(tr.configs, cfg)\nend\nend\ntree.traverse(tr, {\nonbranch = function(node)\nif path.getextension(node.name) == \".lproj\" then\nlocal lang = path.getbasename(node.name)  -- \"English\", \"French\", etc.\nfor _, filenode in ipairs(node.children) do\nlocal grpnode = node.parent.children[filenode.name]\nif not grpnode then\ngrpnode = tree.insert(node.parent, tree.new(filenode.name))\ngrpnode.kind = \"vgroup\"\nend\nfilenode.name = path.getbasename(lang)\ntree.insert(grpnode, filenode)\nend\ntree.remove(node)\nend\nend"
	"\n})\ntree.traverse(tr, {\nonbranch = function(node)\nif path.getextension(node.name) == \".xcassets\" then\nnode.children = {}\nend\nend\n})\ntr.frameworks = tree.new(\"Frameworks\")\nfor cfg in premake.eachconfig(prj) do\nfor _, link in ipairs(premake.getlinks(cfg, \"system\", \"fullpath\")) do\nlocal name = path.getname(link)\nif xcode.isframework(name) and not tr.frameworks.children[name] then\nnode = tree.insert(tr.frameworks, tree.new(name))\nnode.path = link\nend\nend\nend\nif #tr.frameworks.children > 0 then \ntree.insert(tr, tr.frameworks)\nend\ntr.products = tree.insert(tr, tree.new(\"Products\"))\ntr.projects = tree.new(\"Projects\")\nfor _, dep in ipairs(premake.getdependencies(prj, \"sibling\", \"object\")) do\nlocal xcpath = xcode.getxcodeprojname(dep)\nlocal xcnode = tree.insert(tr.projects, tree.new(path.getname(xcpath)))\nxcnode.path = xcpath\nxcnode.project = dep\nxcnode.productgroupid = xcode.newid(xcnode, \"prodgrp\")\nxcnode.productproxyid = xcode.newid(xcnode, \"prodprox\")\nxcnode.target"
	"proxyid  = xcode.newid(xcnode, \"targprox\")\nxcnode.targetdependid = xcode.newid(xcnode, \"targdep\")\nlocal cfg = premake.getconfig(dep, prj.configurations[1])\nnode = tree.insert(xcnode, tree.new(cfg.linktarget.name))\nnode.path = cfg.linktarget.fullpath\nnode.cfg = cfg\nend\nif #tr.projects.children > 0 then\ntree.insert(tr, tr.projects)\nend\ntree.traverse(tr, {\nonnode = function(node)\nnode.id = xcode.newid(node)\nif xcode.getbuildcategory(node) then\nnode.buildid = xcode.newid(node, \"build\")\nend\nif string.endswith(node.name, \"Info.plist\") then\ntr.infoplist = node\nend\nif string.endswith(node.name, \".entitlements\") then\ntr.entitlements = node\nend\nend\n}, true)\nnode = tree.insert(tr.products, prj.xcode.projectnode)\nnode.kind = \"product\"\nnode.path = node.cfg.buildtarget.fullpath\nnode.cfgsection = xcode.newid(node, \"cfg\")\nnode.resstageid = xcode.newid(node, \"rez\")\nnode.sourcesid  = xcode.newid(node, \"src\")\nnode.fxstageid  = xcode.newid(node, \"fxs\")\nreturn tr\nend\nfunction xc"
	"ode6.project(prj)\nlocal tr = xcode6.buildprjtree(prj)\nxcode6.Header(tr)\nxcode6.PBXProject(tr)\nxcode.PBXBuildFile(tr)\nxcode.PBXContainerItemProxy(tr)\nxcode.PBXFileReference(tr,prj)\nxcode.PBXFrameworksBuildPhase(tr)\nxcode.PBXGroup(tr)\nxcode.PBXNativeTarget(tr)\nxcode.PBXReferenceProxy(tr)\nxcode.PBXResourcesBuildPhase(tr)\nxcode.PBXShellScriptBuildPhase(tr)\nxcode.PBXSourcesBuildPhase(tr,prj)\nxcode.PBXVariantGroup(tr)\nxcode.PBXTargetDependency(tr)\nxcode.XCBuildConfiguration(tr)\nxcode.XCBuildConfigurationList(tr)\nxcode6.PBXConfigsGroup()\nxcode6.Footer(tr)\nend\nfunction xcode6.Header()\n_p('// !$*UTF8*$!')\n_p('{')\n_p(1,'archiveVersion = 1;')\n_p(1,'classes = {}')\n_p(1,'objectVersion = 46;')\n_p(1,'rootObject = __RootObject_;')\n_p(1,'objects = {')\nend\nfunction xcode6.PBXProject(tr)\n_p(2,'__RootObject_ = {')\n_p(3,'isa = PBXProject;')\n_p(3,'attributes = {LastUpgradeCheck = 9999;};')\n_p(3,'buildConfigurationList = ___RootConfs_;', tr.name)\n_p(3,'compatibilityVersion = \"Xcode 3.2\";')\n_p(3,"
	"'developmentRegion = English;')\n_p(3,'hasScannedForEncodings = 0;')\n_p(3,'knownRegions = (en);')\n_p(3,'mainGroup = ___RootGroup_;')\n_p(3,'projectDirPath = \"\";')\n_p(3,'projectRoot = \"\";')\n_p(3,'targets = (')\nfor _, node in ipairs(tr.products.children) do\n_p(4,'%s /* %s */,', node.targetid, node.name)\nend\n_p(3,');')\nif #tr.projects.children > 0 then\n_p(3,'projectReferences = (')\nfor _, node in ipairs(tr.projects.children) do\n_p(4,'{')\n_p(5,'ProductGroup = %s /* Products */;', node.productgroupid)\n_p(5,'ProjectRef = %s /* %s */;', node.id, path.getname(node.path))\n_p(4,'},')\nend\n_p(3,');')\nend\n_p(2,'};')\n_p('')\nend\nfunction xcode6.PBXConfigsGroup()\n_p(2, \"_____Configs_ = {\")\n_p(3, \"isa = PBXGroup;\")\n_p(3, \"children = (\")\n_p(3, \");\")\n_p(3, \"name = Configs;\")\n_p(3, \"sourceTree = '<group>';\")\n_p(2, \"};\")\nend\nfunction xcode6.Footer()\n_p(1,'};')\n_p('}')\nend\n",

	/* actions/xcode/xcode6_config.lua */
	"local xcode6 = premake.xcode.xcode6\nfunction xcode6.generate_project_config(prj)\n_p(\"PRODUCT_NAME = $(TARGET_NAME)\")\nif premake.isswiftproject(prj) then\n_p(\"OTHER_SWIFT_FLAGS = -DXcode\")\n_p(\"USE_HEADERMAP = NO\")\nend\nend",

	/* actions/fastbuild/_fastbuild.lua */
	"premake.fastbuild = { }\nlocal fastbuild = premake.fastbuild\nnewaction\n{\ntrigger = \"vs2015-fastbuild\",\nshortname = \"FASTBuild VS2015\",\ndescription = \"Generate FASTBuild configuration files for Visual Studio 2015.\",\nvalid_kinds = {\n\"ConsoleApp\",\n\"WindowedApp\",\n\"StaticLib\",\n\"SharedLib\",\n\"Bundle\",\n},\nvalid_languages = {\n\"C\",\n\"C++\"\n},\nvalid_tools = {\ncc = {\n\"msc\"\n},\n},\nonsolution = function(sln)\npremake.generate(sln, \"fbuild.bff\", premake.fastbuild.solution)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.bff\", premake.fastbuild.project)\nend,\noncleansolution = function(sln)\npremake.clean.file(sln, \"fbuild.bff\")\nend,\noncleanproject  = function(prj)\npremake.clean.file(prj, \"%%.bff\")\nend,\n}\n",

	/* actions/fastbuild/fastbuild_project.lua */
	"-- Generates a FASTBuild config file for a project.\nlocal function add_trailing_backslash(dir)\nif dir:len() > 0 and dir:sub(-1) ~= \"\\\\\" then\nreturn dir..\"\\\\\"\nend\nreturn dir\nend\nlocal function compile(indentlevel, prj, cfg, commonbasepath)\nlocal firstflag = true\nfor _, cfgexclude in ipairs(cfg.excludes) do\nif path.issourcefile(cfgexclude) then\nif firstflag then\n_p(indentlevel, '// Excluded files:')\nfirstflag = false\nend\n_p(indentlevel, \".CompilerInputFiles - '%s'\", cfgexclude)\nend\nend\nif not firstflag then\n_p('')\nend\n_p(indentlevel, \".CompilerOutputPath = '%s'\", add_trailing_backslash(cfg.objectsdir))\n_p(indentlevel, \".Defines = ''\")\nfor _, define in ipairs(cfg.defines) do\n_p(indentlevel+1, \"+ ' /D%s'\", define)\nend\nif cfg.kind == 'SharedLib' then\n_p(indentlevel+1, \"+ ' /D_WINDLL'\")\nend\n_p(indentlevel, \".IncludeDirs = ''\")\nlocal sortedincdirs = {}\nfor _, includedir in ipairs(cfg.userincludedirs) do\nif includedir ~= nil then\ntable.insert(sortedincdirs, included"
	"ir)\nend\nend\nfor _, includedir in ipairs(cfg.includedirs) do\nif includedir ~= nil then\ntable.insert(sortedincdirs, includedir)\nend\nend\nlocal function getpathnodecount(p)\nlocal nodefinder = string.gmatch(p, \"[^\\\\/]+\")\nlocal result = 0\nlocal node = nodefinder()\nwhile node do\nresult = result + ((node ~= '.' and 1) or 0)\nnode = nodefinder()\nend\nreturn result\nend\nlocal stepsfrombase = {}\nfor _, includedir in ipairs(sortedincdirs) do\nstepsfrombase[includedir] = getpathnodecount(path.getrelative(commonbasepath, includedir))\nend\nlocal function includesort(a, b)\nif stepsfrombase[a] == stepsfrombase[b] then\nreturn a < b\nelse\nreturn stepsfrombase[a] < stepsfrombase[b]\nend\nend\ntable.sort(sortedincdirs, includesort)\nfor _, includedir in ipairs(sortedincdirs) do\n_p(indentlevel+1, \"+ ' /I\\\"%s\\\"'\", includedir)\nend\n_p(indentlevel+1, \"+ .MSVCIncludes\")\nlocal compileroptions = {\n'\"%1\"',\n'/nologo',\n'/c',\n'/Gy',\n'/Gm-',\n'/Zc:inline',\n'/errorReport:prompt',\n'/FS',\n}\nif cfg.op"
	"tions.ForceCPP then\ntable.insert(compileroptions, '/TP')\nend\nif cfg.flags.PedanticWarnings\nor cfg.flags.ExtraWarnings\nthen\ntable.insert(compileroptions, '/W4')\nend\nif (cfg.flags.NativeWChar == false or\ncfg.flags.NoNativeWChar) then\ntable.insert(compileroptions, '/Zc:wchar_t-')\nend\nif (cfg.flags.EnableMinimalRebuild or\ncfg.flags.NoMultiProcessorCompilation) then\nend\nif cfg.flags.FloatFast then\ntable.insert(compileroptions, '/fp:fast')\nelseif cfg.flags.FloatStrict then\ntable.insert(compileroptions, '/fp:strict')\nelse\ntable.insert(compileroptions, '/fp:precise')\nend\nif cfg.flags.FastCall then\ntable.insert(compileroptions, '/Gr')\nelseif cfg.flags.StdCall then\ntable.insert(compileroptions, '/Gd')\nend\nif cfg.flags.UnsignedChar then\ntable.insert(compileroptions, '/J')\nend\nif premake.config.isdebugbuild(cfg) then\nif cfg.flags.StaticRuntime then\ntable.insert(compileroptions, '/MTd')\nelse\ntable.insert(compileroptions, '/MDd')\nend\nelse\nif cfg.flags.StaticRuntime then\ntable.insert(com"
	"pileroptions, '/MT')\nelse\ntable.insert(compileroptions, '/MD')\nend\nend\nif cfg.flags.Symbols then\nif (cfg.flags.C7DebugInfo) then\ntable.insert(compileroptions, '/Z7')\nelse\nif (premake.config.isoptimizedbuild(cfg.flags)\nor cfg.flags.NoEditAndContinue) then\ntable.insert(compileroptions, '/Zi')\nelse\ntable.insert(compileroptions, '/ZI')\nend\nlocal targetdir = add_trailing_backslash(cfg.buildtarget.directory)\ntable.insert(compileroptions, string.format(\"/Fd\\\"%s%s.pdb\\\"\", targetdir, cfg.buildtarget.basename))\nend\nend\nlocal isoptimised = true\nif (cfg.flags.Optimize) then\ntable.insert(compileroptions, '/Ox')\nelseif (cfg.flags.OptimizeSize) then\ntable.insert(compileroptions, '/O1')\nelseif (cfg.flags.OptimizeSpeed) then\ntable.insert(compileroptions, '/O2')\nelse\nisoptimised = false\nend\nif isoptimised then\ntable.insert(compileroptions, '/GF')\nelse\ntable.insert(compileroptions, '/Od')\ntable.insert(compileroptions, '/RTC1')\nend\nif cfg.flags.FatalWarnings then\ntable.insert(compileropti"
	"ons, '/WX')\nelse\ntable.insert(compileroptions, '/WX-')\nend\nif cfg.platform == 'x32' then\nif cfg.flags.EnableSSE2 then\ntable.insert(compileroptions, '/arch:SSE2')\nelseif cfg.flags.EnableSSE then\ntable.insert(compileroptions, '/arch:SSE')\nend\nend\nif cfg.flags.NoExceptions then\nelse\nif cfg.flags.SEH then\ntable.insert(compileroptions, '/EHa')\nelse\ntable.insert(compileroptions, '/EHsc')\nend\nend\nif cfg.flags.NoRTTI then\ntable.insert(compileroptions, '/GR-')\nelse\ntable.insert(compileroptions, '/GR')\nend\nif cfg.flags.NoFramePointer then\ntable.insert(compileroptions, '/Oy-')\nelse\ntable.insert(compileroptions, '/Oy')\nend\nfor _, addloption in ipairs(cfg.buildoptions) do\ntable.insert(compileroptions, addloption)\nend\n_p(indentlevel, \".CompilerOptions = ''\")\nfor _, option in ipairs(compileroptions) do\n_p(indentlevel+1, \"+ ' %s'\", option)\nend\n_p(indentlevel+1, \"+ .IncludeDirs\")\n_p(indentlevel+1, \"+ .Defines\")\nif not cfg.flags.NoPCH and cfg.pchheader then\n_p(indentlevel, \".Compi"
	"lerInputFiles - '%s'\", cfg.pchsource)\n_p(indentlevel, \".PCHInputFile = '%s'\", cfg.pchsource)\n_p(indentlevel, \".PCHOutputFile = .CompilerOutputPath + '%s.pch'\", prj.name)\n_p(indentlevel, \".CompilerOptions + ' /Fp\\\"' + .CompilerOutputPath + '%s.pch\\\"'\", prj.name)\n_p(indentlevel, \".PCHOptions = .CompilerOptions\")\n_p(indentlevel+1, \"+ ' /Yc\\\"%s\\\"'\", cfg.pchheader)\n_p(indentlevel+1, \"+ ' /Fo\\\"%%3\\\"'\")\n_p(indentlevel, \".CompilerOptions + ' /Yu\\\"%s\\\"'\", cfg.pchheader)\nend\n_p(indentlevel+1, \"+ ' /Fo\\\"%%2\\\"'\") -- make sure the previous property is .CompilerOptions\nend\nlocal function library(prj, cfg, useconfig, commonbasepath)\n_p(1, \"Library('%s-%s-%s')\", prj.name, cfg.name, cfg.platform)\n_p(1, '{')\nuseconfig(2)\ncompile(2, prj, cfg, commonbasepath)\nlocal librarianoptions = {\n'\"%1\"',\n'/OUT:\"%2\"',\n'/NOLOGO',\n}\nif cfg.platform == 'x64' then\ntable.insert(librarianoptions, '/MACHINE:X64')\nelse\ntable.insert(librarianoptions, '/MACHINE:X86')\nend\n_p(2, \".Lib"
	"rarianOptions = ''\")\nfor _, option in ipairs(librarianoptions) do\n_p(3, \"+ ' %s'\", option)\nend\n_p(2, \".LibrarianOutput = '%s'\", cfg.buildtarget.fullpath)\n_p(1, '}')\n_p('')\nend\nlocal function binary(prj, cfg, useconfig, bintype, commonbasepath)\n_p(1, \"ObjectList('%s_obj-%s-%s')\", prj.name, cfg.name, cfg.platform)\n_p(1, '{')\nuseconfig(2)\ncompile(2, prj, cfg, commonbasepath)\n_p(1, '}')\n_p('')\n_p(1, \"%s('%s-%s-%s')\", bintype, prj.name, cfg.name, cfg.platform)\n_p(1, '{')\nuseconfig(2)\n_p(2, '.Libraries = {')\n_p(3, \"'%s_obj-%s-%s',\", prj.name, cfg.name, cfg.platform) -- Refer to the ObjectList\nlocal sorteddeplibs = {}\nfor _, deplib in ipairs(premake.getlinks(cfg, \"dependencies\", \"basename\")) do\ntable.insert(sorteddeplibs, string.format(\"'%s-%s-%s',\", deplib, cfg.name, cfg.platform))\nend\ntable.sort(sorteddeplibs)\nfor _, deplib in ipairs(sorteddeplibs) do\n_p(3, deplib)\nend\n_p(3, '}')\n_p(2, '.LinkerLinkObjects = false')\nlocal linkeroptions = {\n'\"%1\"',\n'/OUT:\"%2\"',\n'/"
	"NOLOGO',\n'/errorReport:prompt',\n}\nlocal subsystemversion = '\",5.02\"'\nif cfg.platform == 'x32' then\nsubsystemversion = '\",5.01\"'\nend\nif cfg.kind == 'ConsoleApp' then\ntable.insert(linkeroptions, '/SUBSYSTEM:CONSOLE'..subsystemversion)\nelse\ntable.insert(linkeroptions, '/SUBSYSTEM:WINDOWS'..subsystemversion)\nend\nif cfg.kind == 'SharedLib' then\ntable.insert(linkeroptions, '/DLL')\nend\nif cfg.platform == 'x64' then\ntable.insert(linkeroptions, '/MACHINE:X64')\nelse\ntable.insert(linkeroptions, '/MACHINE:X86')\nend\nfor _, libdir in ipairs(cfg.libdirs) do\ntable.insert(linkeroptions, string.format('/LIBPATH:%s', path.translate(libdir, '\\\\')))\nend\nif not cfg.flags.WinMain and (cfg.kind == 'ConsoleApp' or cfg.kind == 'WindowedApp') then\nif cfg.flags.Unicode then\ntable.insert(linkeroptions, '/ENTRY:wmainCRTStartup')\nelse\ntable.insert(linkeroptions, '/ENTRY:mainCRTStartup')\nend\nend\nlocal deffile = premake.findfile(cfg, \".def\")\nif deffile then\ntable.insert(linkeroptions, '/DEF:%s', deffile"
	")\nend\nif (cfg.flags.Symbols ~= nil) then\ntable.insert(linkeroptions, '/DEBUG')\nend\nif premake.config.isoptimizedbuild(cfg.flags) then\ntable.insert(linkeroptions, '/OPT:REF')\ntable.insert(linkeroptions, '/OPT:ICF')\nend\ntable.insert(linkeroptions, '/INCREMENTAL'..((premake.config.isincrementallink(cfg) and '') or ':NO'))\nfor _, addloption in ipairs(cfg.linkoptions) do\ntable.insert(linkeroptions, addloption)\nend\nlocal linklibs = premake.getlinks(cfg, \"all\", \"fullpath\")\nfor _, linklib in ipairs(linklibs) do\ntable.insert(linkeroptions, path.getname(linklib))\nend\ntable.sort(linkeroptions)\n_p(2, \".LinkerOptions = ''\")\nfor _, option in ipairs(linkeroptions) do\n_p(3, \"+ ' %s'\", option)\nend\n_p(3, \"+ .MSVCLibPaths\")\n_p(2, \".LinkerOutput = '%s'\", cfg.buildtarget.fullpath)\n_p(1, '}')\n_p('')\nend\nlocal function executable(prj, cfg, useconfig, commonbasepath)\nbinary(prj, cfg, useconfig, 'Executable', commonbasepath)\nend\nlocal function dll(prj, cfg, useconfig, commonbasepath)\nbinary(p"
	"rj, cfg, useconfig, 'DLL', commonbasepath)\nend\nlocal function alias(prj, cfg, target)\n_p(1, \"Alias('%s-%s-%s')\", prj.name, cfg.name, cfg.platform)\n_p(1, '{')\n_p(2, \".Targets = '%s'\", target)\n_p(1, '}')\n_p('')\nend\nfunction premake.fastbuild.project(prj)\nio.indent = '    '\n_p('// FASTBuild project configuration file autogenerated by GENie.')\n_p('')\n_p('{')\nlocal cppfiles = {}\nfor file in premake.project.eachfile(prj) do\nif path.issourcefile(file.name) then\ntable.insert(cppfiles, file.name)\nend\nend\nlocal commonbasepath = cppfiles[1]\nfor _, file in ipairs(cppfiles) do\ncommonbasepath = path.getcommonbasedir(commonbasepath..'/', file)\nend\n_p(1, \".CompilerInputFilesRoot = '%s/'\", commonbasepath)\n_p(1, '.CompilerInputFiles = {')\nfor _, file in ipairs(cppfiles) do\n_p(2, \"'%s',\", file)\nend\n_p(1, '}')\n_p('')\nlocal targetkindmap = {\nConsoleApp = executable,\nWindowedApp = executable,\nSharedLib = dll,\nStaticLib = library,\n}\nlocal useconfigmap = {\nx32 = function(indentlevel)\n_p("
	"indentlevel, 'Using(.MSVCx86Config)')\n_p('')\nend,\nx64 = function(indentlevel)\n_p(indentlevel, 'Using(.MSVCx64Config)')\n_p('')\nend,\n}\nlocal nativeplatform = (os.is64bit() and 'x64') or 'x32'\nfor _, platform in ipairs(prj.solution.platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\nif cfg.platform == 'Native' then\nalias(prj, cfg, string.format('%s-%s-%s', prj.name, cfg.name, nativeplatform))\nelse\ntargetkindmap[prj.kind](prj, cfg, useconfigmap[cfg.platform], commonbasepath)\nend\nend\nend\n_p('}')\nend\n",

	/* actions/fastbuild/fastbuild_solution.lua */
	"-- Generates a FASTBuild config file for a solution.\nfunction premake.fastbuild.solution(sln)\nio.indent = '    '\n_p('// FastBuild solution configuration file.  Generated by GENie.')\n_p('//------------------------------------------------------------------------------------')\n_p('// %s', sln.name)\n_p('//------------------------------------------------------------------------------------')\n_p('#import VS140COMNTOOLS')\nlocal is64bit = os.is64bit()\nlocal target64 = (is64bit and ' amd64') or ' x86_amd64'\nlocal target32 = (is64bit and ' amd64_x86') or ''\nlocal getvcvarscontent = [[\n@set INCLUDE=\n@set LIB=\n@set CommandPromptType=\n@set PreferredToolArchitecture=\n@set Platform=\n@set Path=%SystemRoot%\\System32;%SystemRoot%;%SystemRoot%\\System32\\wbem\n@call \"%VS140COMNTOOLS%..\\..\\VC\\vcvarsall.bat\" %1\n@echo %INCLUDE%\n@echo %LIB%\n@echo %CommandPromptType%\n@echo %PreferredToolArchitecture%\n@echo %Platform%\n@echo %Path%\n]]\nlocal getvcvarsfilepath = os.getenv('TEMP')..'\\\\getvcvars.bat'\nlocal"
	" getvcvarsfile = assert(io.open(getvcvarsfilepath, 'w'))\ngetvcvarsfile:write(getvcvarscontent)\ngetvcvarsfile:close()\nlocal vcvarsrawx86 = os.outputof(string.format('call \"%s\"%s', getvcvarsfilepath, target32))\nlocal vcvarsrawx64 = os.outputof(string.format('call \"%s\"%s', getvcvarsfilepath, target64))\nos.remove(getvcvarsfilepath)\nlocal msvcvars = {}\nmsvcvars.x32 = {}\nmsvcvars.x64 = {}\nlocal includeslibssplitter = string.gmatch(vcvarsrawx64, \"[^\\n]+\")\nmsvcvars.x64.includesraw = includeslibssplitter()\nmsvcvars.x64.libpathsraw = includeslibssplitter()\nmsvcvars.x64.commandprompttype = includeslibssplitter()\nmsvcvars.x64.preferredtoolarchitecture = includeslibssplitter()\nmsvcvars.x64.platform = includeslibssplitter()\nmsvcvars.x64.pathraw = includeslibssplitter()\nincludeslibssplitter = string.gmatch(vcvarsrawx86, \"[^\\n]+\")\nmsvcvars.x32.includesraw = includeslibssplitter()\nmsvcvars.x32.libpathsraw = includeslibssplitter()\nmsvcvars.x32.commandprompttype = includeslibssplitter()\nmsvcvars.x32"
	".preferredtoolarchitecture = includeslibssplitter()\nmsvcvars.x32.platform = includeslibssplitter()\nmsvcvars.x32.pathraw = includeslibssplitter()\nlocal function printincludes(includesraw)\n_p(1, \".MSVCIncludes = ''\")\nfor i in string.gmatch(includesraw, \"[^;]+\") do\n_p(2, \"+ ' /I\\\"%s\\\"'\", i)\nend\nend\nlocal function printlibpaths(libpathsraw)\n_p(1, \".MSVCLibPaths = ''\")\nfor i in string.gmatch(libpathsraw, \"[^;]+\") do\n_p(2, \"+ ' /LIBPATH:\\\"%s\\\"'\", i)\nend\nend\nif is64bit then\n_p('.MSVCx64Config =')\n_p('[')\n_p(1, \".Compiler  = '$VS140COMNTOOLS$..\\\\..\\\\VC\\\\bin\\\\amd64\\\\cl.exe'\")\n_p(1, \".Librarian = '$VS140COMNTOOLS$..\\\\..\\\\VC\\\\bin\\\\amd64\\\\lib.exe'\")\n_p(1, \".Linker    = '$VS140COMNTOOLS$..\\\\..\\\\VC\\\\bin\\\\amd64\\\\link.exe'\")\nprintincludes(msvcvars.x64.includesraw)\nprintlibpaths(msvcvars.x64.libpathsraw)\n_p(']')\n_p('')\n_p('.MSVCx86Config =')\n_p('[')\n_p(1, \".Compiler  = '$VS140COMNTOOLS$..\\\\..\\\\VC\\\\bin\\\\amd64_x86\\\\cl.exe'\")\n_p(1, \"."
	"Librarian = '$VS140COMNTOOLS$..\\\\..\\\\VC\\\\bin\\\\amd64_x86\\\\lib.exe'\")\n_p(1, \".Linker    = '$VS140COMNTOOLS$..\\\\..\\\\VC\\\\bin\\\\amd64_x86\\\\link.exe'\")\nprintincludes(msvcvars.x32.includesraw)\nprintlibpaths(msvcvars.x32.libpathsraw)\n_p(']')\n_p('')\nelse\n_p('.MSVCx64Config =')\n_p('[')\n_p(1, \".Compiler  = '$VS140COMNTOOLS$..\\\\..\\\\VC\\\\bin\\\\x86_amd64\\\\cl.exe'\")\n_p(1, \".Librarian = '$VS140COMNTOOLS$..\\\\..\\\\VC\\\\bin\\\\x86_amd64\\\\lib.exe'\")\n_p(1, \".Linker    = '$VS140COMNTOOLS$..\\\\..\\\\VC\\\\bin\\\\x86_amd64\\\\link.exe'\")\nprintincludes(msvcvars.x64.includesraw)\nprintlibpaths(msvcvars.x64.libpathsraw)\n_p(']')\n_p('')\n_p('.MSVCx86Config =')\n_p('[')\n_p(1, \".Compiler  = '$VS140COMNTOOLS$..\\\\..\\\\VC\\\\bin\\\\cl.exe'\")\n_p(1, \".Librarian = '$VS140COMNTOOLS$..\\\\..\\\\VC\\\\bin\\\\lib.exe'\")\n_p(1, \".Linker    = '$VS140COMNTOOLS$..\\\\..\\\\VC\\\\bin\\\\link.exe'\")\nprintincludes(msvcvars.x32.includesraw)\nprintlibpaths(msvcvars.x32.libpathsraw)\n_p(']')"
	"\n_p('')\nend\nlocal msvcbin = '$VS140COMNTOOLS$..\\\\..\\\\VC\\\\bin' .. ((is64bit and '\\\\amd64') or '')\n_p('#import Path')\n_p('#import TMP')\n_p('#import SystemRoot')\n_p('')\n_p('Settings')\n_p('{')\n_p(1, '.Environment = {')\n_p(2, \"'Path=%s;$Path$',\", msvcbin)\n_p(2, \"'TMP=$TMP$',\")\n_p(2, \"'SystemRoot=$SystemRoot$',\")\n_p(2, '}')\n_p('}')\n_p('')\nlocal function projkindsort(a, b)\nlocal projvaluemap = {\nConsoleApp  = 3,\nWindowedApp = 3,\nSharedLib   = 2,\nStaticLib   = 1,\n}\nif projvaluemap[a.kind] == projvaluemap[b.kind] then\nreturn a.name < b.name\nelse\nreturn projvaluemap[a.kind] < projvaluemap[b.kind]\nend\nend\nlocal sortedprojs = {}\nfor prj in premake.solution.eachproject(sln) do\ntable.insert(sortedprojs, prj)\nend\ntable.sort(sortedprojs, projkindsort)\nfor _, prj in ipairs(sortedprojs) do\nlocal fname = premake.project.getbasename(prj.name, '%%.bff')\nfname = path.join(prj.location, fname)\nfname = path.getrelative(sln.location, fname)\n_p('#include \"%s\"', fname)\nend\n_p('')"
	"\n_p('.ProjectVariants = {')\nfor _, plat in ipairs(sln.platforms) do\nfor _, cfg in ipairs(sln.configurations) do\n_p(1, \"'%s-%s',\", cfg, plat)\nend\nend\n_p('}')\n_p('')\n_p('ForEach(.Variant in .ProjectVariants)')\n_p('{')\n_p(1, \"Alias('all-$Variant$')\")\n_p(1, '{')\n_p(2, '.Targets = {')\nfor _, prj in ipairs(sortedprojs) do\n_p(3, \"'%s-$Variant$',\", prj.name)\nend\n_p(2, '}')\n_p(1, '}')\n_p('}')\nend\n",

	/* actions/ninja/_ninja.lua */
	"premake.ninja = { }\nlocal p = premake\nnewaction\n{\ntrigger     = \"ninja\",\nshortname   = \"ninja\",\ndescription = \"Generate Ninja build files\",\nmodule      = \"ninja\",\nvalid_kinds     = {\"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\"},\nvalid_languages = {\"C\", \"C++\", \"Swift\"},\nvalid_tools     = {\ncc    = { \"gcc\" },\nswift = { \"swift\" },\n},\nonsolution = function(sln)\nio.eol    = \"\\r\\n\"\nio.indent = \"\\t\"\nio.escaper(p.ninja.esc)\np.generate(sln, \"Makefile\", p.ninja.generate_solution)\nio.indent = \"  \"\np.ninja.generate_ninja_builds(sln)\nend,\nonproject = function(prj)\nio.eol    = \"\\r\\n\"\nio.indent = \"  \"\nio.escaper(p.ninja.esc)\np.ninja.generate_project(prj)\nend,\noncleansolution = function(sln)\nfor _,name in ipairs(sln.configurations) do\npremake.clean.file(sln, p.ninja.get_solution_name(sln, name))\nend\nend,\noncleanproject = function(prj)\nend,\noncleantarget = function(prj)\nend,\n}\n",

	/* actions/ninja/ninja_base.lua */
	"local ninja = premake.ninja\nfunction ninja.esc(value)\nvalue = value:gsub(\"%$\", \"$$\") -- TODO maybe there is better way\nvalue = value:gsub(\":\", \"$:\")\nvalue = value:gsub(\"\\n\", \"$\\n\")\nvalue = value:gsub(\" \", \"$ \")\nreturn value\nend\nfunction ninja.shesc(value)\nif type(value) == \"table\" then\nlocal result = {}\nlocal n = #value\nfor i = 1, n do\ntable.insert(result, ninja.shesc(value[i]))\nend\nreturn result\nend\nif value:find(\" \") then\nreturn \"\\\"\" .. value .. \"\\\"\"\nend\nreturn value\nend\nfunction ninja.list(value)\nif #value > 0 then\nreturn \" \" .. table.concat(value, \" \")\nelse\nreturn \"\"\nend\nend\nfunction ninja.arglist(arg, value)\nif #value > 0 then\nlocal args = {}\nfor _, val in ipairs(value) do\ntable.insert(args, string.format(\"%s %s\", arg, val))\nend\nreturn table.concat(args, \" \")\nelse\nreturn \"\"\nend\nend\nfunction ninja.generate_project(prj)\nif prj.language == \"Swift\" then\nninja.generate_swift(prj)\nelse\nninja.generate_cpp(prj)\nend\nend\nloca"
	"l function innerget(self, key)\nreturn rawget(getmetatable(self), key) or self.__inner[key]\nend\nlocal prj_proxy = { __index = innerget }\nlocal cfg_proxy = { __index = innerget }\nfunction new_prj_proxy(prj)\nprj = prj.project or prj\nlocal v = { __inner = prj }\nlocal __configs = {}\nfor key, cfg in pairs(prj.__configs) do\nif key ~= \"\" then\n__configs[key] = ninja.get_proxy(\"cfg\", cfg)\nelse\n__configs[key] = cfg\nend\nend\nv.__configs = __configs\nreturn setmetatable(v, prj_proxy)\nend\nlocal function rebasekeys(t, keys, old, new)\nfor _,key in ipairs(keys) do\nt[key] = path.rebase(t[key], old, new)\nend\nreturn t\nend\nlocal function rebasearray(t, old, new)\nlocal res = { }\nfor _,f in ipairs(t) do\ntable.insert(res, path.rebase(f, old, new))\nend\nreturn res\nend\nfunction new_cfg_proxy(cfg)\nlocal keys = { \"directory\", \"fullpath\", \"bundlepath\" }\nlocal old = cfg.location\nlocal new = path.join(cfg.location, cfg.shortname)\nlocal v = {\n__inner     = cfg,\nlocation    = new,\nobjectsdir  = pa"
	"th.rebase(cfg.objectsdir, old, new),\nbuildtarget = rebasekeys(table.deepcopy(cfg.buildtarget), keys, old, new),\nlinktarget  = rebasekeys(table.deepcopy(cfg.buildtarget), keys, old, new),\n}\nv.files           = rebasearray(cfg.files, old, new)\nv.includedirs     = rebasearray(cfg.includedirs, old, new)\nv.userincludedirs = rebasearray(cfg.userincludedirs, old, new)\nv.swiftmodulemaps = rebasearray(cfg.swiftmodulemaps, old, new)\nreturn setmetatable(v, cfg_proxy)\nend\nfunction cfg_proxy:getprojectfilename(fullpath)\nlocal name = self.project.name .. \".ninja\"\nif fullpath ~= nil then\nreturn path.join(self.location, name)\nend\nreturn name\nend\nfunction cfg_proxy:getoutputfilename()\nreturn path.join(self.buildtarget.directory, self.buildtarget.name)\nend\nlocal proxy_cache = { \nprj = { new = new_prj_proxy }, \ncfg = { new = new_cfg_proxy },\n}\nfunction get_proxy(cache, obj)\nif not cache[obj] then\ncache[obj] = cache.new(obj)\nend\nreturn cache[obj]\nend\nfunction ninja.get_proxy(typ, obj)\nif not proxy"
	"_cache[typ] then\nerror(\"invalid proxy type\")\nend\nreturn get_proxy(proxy_cache[typ], obj)\nend\n",

	/* actions/ninja/ninja_solution.lua */
	"local ninja = premake.ninja\nlocal p = premake\nlocal solution = p.solution\nfunction ninja.generate_solution(sln)\nlocal cc = premake[_OPTIONS.cc]\nlocal platforms = premake.filterplatforms(sln, cc.platforms, \"Native\")\n_p('# %s solution makefile autogenerated by GENie', premake.action.current().shortname)\n_p('# Type \"make help\" for usage help')\n_p('')\n_p('NINJA=ninja')\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(premake.getconfigname(sln.configurations[1], platforms[1], true)))\n_p('endif')\n_p('')\nlocal projects = table.extract(sln.projects, \"name\")\ntable.sort(projects)\n_p('')\n_p('.PHONY: all clean help $(PROJECTS)')\n_p('')\n_p('all:')\nif (not sln.messageskip) or (not table.contains(sln.messageskip, \"SkipBuildingMessage\")) then\n_p(1, '@echo \"==== Building all ($(config)) ====\"')\nend\n_p(1, '@${NINJA} -C ${config} all')\n_p('')\nfor _, prj in ipairs(sln.projects) do\nlocal prjx = ninja.get_proxy(\"prj\", prj)\n_p('%s:', _MAKE.esc(prj.name))\nif (not sln.messageskip) or (not table.c"
	"ontains(sln.messageskip, \"SkipBuildingMessage\")) then\n_p(1, '@echo \"==== Building %s ($(config)) ====\"', prj.name)\nend\n_p(1, '@${NINJA} -C ${config} %s', prj.name)\n_p('')\nend\n_p('clean:')\n_p(1, '@${NINJA} -C ${config} -t clean')\n_p('')\n_p('help:')\n_p(1,'@echo \"Usage: make [config=name] [target]\"')\n_p(1,'@echo \"\"')\n_p(1,'@echo \"CONFIGURATIONS:\"')\nlocal cfgpairs = { }\nfor _, platform in ipairs(platforms) do\nfor _, cfgname in ipairs(sln.configurations) do\n_p(1,'@echo \"   %s\"', premake.getconfigname(cfgname, platform, true))\nend\nend\n_p(1,'@echo \"\"')\n_p(1,'@echo \"TARGETS:\"')\n_p(1,'@echo \"   all (default)\"')\n_p(1,'@echo \"   clean\"')\nfor _, prj in ipairs(sln.projects) do\n_p(1,'@echo \"   %s\"', prj.name)\nend\n_p(1,'@echo \"\"')\n_p(1,'@echo \"For more information, see https://github.com/bkaradzic/genie\"')\nend\nlocal generate\nlocal function getconfigs(sln, name, plat)\nlocal cfgs = {}\nfor prj in solution.eachproject(sln) do\nprj = ninja.get_proxy(\"prj\", prj)\nfor cfg "
	"in p.eachconfig(prj, plat) do\nif cfg.name == name then\ntable.insert(cfgs, cfg)\nend\nend\nend\nreturn cfgs\nend\nfunction ninja.generate_ninja_builds(sln)\nlocal cc = premake[_OPTIONS.cc]\nsln.getlocation = function(cfg, plat)\nreturn path.join(sln.location, premake.getconfigname(cfg, plat, true))\nend\nlocal platforms = premake.filterplatforms(sln, cc.platforms, \"Native\")\nfor _,plat in ipairs(platforms) do\nfor _,name in ipairs(sln.configurations) do\np.generate(sln, ninja.get_solution_name(sln, name, plat), function(sln)\ngenerate(getconfigs(sln, name, plat))\nend)\nend\nend\nend\nfunction ninja.get_solution_name(sln, cfg, plat)\nreturn path.join(sln.getlocation(cfg, plat), \"build.ninja\")\nend\nfunction generate(prjcfgs)\nlocal cfgs          = {}\nlocal cfg_first     = nil\nlocal cfg_first_lib = nil\n_p(\"# solution build file\")\n_p(\"# generated with GENie ninja\")\n_p(\"\")\n_p(\"# build projects\")\nfor _,cfg in ipairs(prjcfgs) do\nlocal key  = cfg.project.name\nif not cfgs[key] then cfgs[key] = "
	"\"\" end\ncfgs[key] = cfg:getoutputfilename() .. \" \"\nif not cfgs[\"all\"] then cfgs[\"all\"] = \"\" end\ncfgs[\"all\"] = cfgs[\"all\"] .. cfg:getoutputfilename() .. \" \"\nif (cfg_first == nil) and (cfg.kind == \"ConsoleApp\" or cfg.kind == \"WindowedApp\") then\ncfg_first = key\nend\nif (cfg_first_lib == nil) and (cfg.kind == \"StaticLib\" or cfg.kind == \"SharedLib\") then\ncfg_first_lib = key\nend\n_p(\"subninja \" .. cfg:getprojectfilename())\nend\n_p(\"\")\n_p(\"# targets\")\nfor cfg, outputs in iter.sortByKeys(cfgs) do\n_p(\"build \" .. cfg .. \": phony \" .. outputs)\nend\n_p(\"\")\n_p(\"# default target\")\n_p(\"default \" .. (cfg_first or cfg_first_lib))\n_p(\"\")\nend\n",

	/* actions/ninja/ninja_cpp.lua */
	"premake.ninja.cpp = { }\nlocal ninja = premake.ninja\nlocal cpp   = premake.ninja.cpp\nlocal p     = premake\nfunction ninja.generate_cpp(prj)\nlocal pxy = ninja.get_proxy(\"prj\", prj)\nlocal tool = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, tool.platforms, \"Native\")\nfor _, platform in ipairs(platforms) do\nfor cfg in p.eachconfig(pxy, platform) do\np.generate(cfg, cfg:getprojectfilename(), function() cpp.generate_config(prj, cfg) end)\nend\nend\nend\nfunction cpp.generate_config(prj, cfg)\nlocal tool = premake.gettool(prj)\n_p('# Ninja build project file autogenerated by GENie')\n_p('# https://github.com/bkaradzic/GENie')\n_p(\"\")\n_p(\"ninja_required_version = 1.7\")\n_p(\"\")\nlocal flags = {\ndefines   = ninja.list(tool.getdefines(cfg.defines)),\nincludes  = ninja.list(table.join(tool.getincludedirs(cfg.includedirs), tool.getquoteincludedirs(cfg.userincludedirs))),\ncppflags  = ninja.list(tool.getcppflags(cfg)),\nasmflags  = ninja.list(table.join(tool.getcflags(cfg),"
	" cfg.buildoptions, cfg.buildoptions_asm)),\ncflags    = ninja.list(table.join(tool.getcflags(cfg), cfg.buildoptions, cfg.buildoptions_c)),\ncxxflags  = ninja.list(table.join(tool.getcflags(cfg), tool.getcxxflags(cfg), cfg.buildoptions, cfg.buildoptions_cpp)),\nobjcflags = ninja.list(table.join(tool.getcflags(cfg), tool.getcxxflags(cfg), cfg.buildoptions, cfg.buildoptions_objc)),\n}\n_p(\"\")\n_p(\"# core rules for \" .. cfg.name)\n_p(\"rule cc\")\n_p(\"  command = \" .. tool.cc .. \" $defines $includes $flags -MMD -MF $out.d -c -o $out $in\")\n_p(\"  description = cc $out\")\n_p(\"  depfile = $out.d\")\n_p(\"  deps = gcc\")\n_p(\"\")\n_p(\"rule cxx\")\n_p(\"  command = \" .. tool.cxx .. \" $defines $includes $flags -MMD -MF $out.d -c -o $out $in\")\n_p(\"  description = cxx $out\")\n_p(\"  depfile = $out.d\")\n_p(\"  deps = gcc\")\n_p(\"\")\n_p(\"rule ar\")\n_p(\"  command = \" .. tool.ar .. \" $flags $out $in $libs \" .. (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\"))"
	"\n_p(\"  description = ar $out\")\n_p(\"\")\nlocal link = iif(cfg.language == \"C\", tool.cc, tool.cxx)\n_p(\"rule link\")\n_p(\"  command = \" .. link .. \" -o $out @$out.rsp $all_ldflags $libs\")\n_p(\"  rspfile = $out.rsp\")\n  _p(\"  rspfile_content = $all_outputfiles\")\n_p(\"  description = link $out\")\n_p(\"\")\ncpp.custombuildtask(prj, cfg)\ncpp.dependencyRules(prj, cfg)\ncpp.file_rules(cfg, flags)\nlocal objfiles = {}\nfor _, file in ipairs(cfg.files) do\nif path.issourcefile(file) then\ntable.insert(objfiles, cpp.objectname(cfg, file))\nend\nend\n_p('')\ncpp.linker(prj, cfg, objfiles, tool, flags)\n_p(\"\")\nend\nfunction cpp.custombuildtask(prj, cfg)\nlocal cmd_index = 1\nlocal seen_commands = {}\nlocal command_by_name = {}\nlocal command_files = {}\nfor _, custombuildtask in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nfor _, cmd in ipairs(buildtask[4] or {}) do\nlocal num = 1\nfor _, depdata in ipairs(buildtask[3] or {}) do\ncmd = string.gsub(cmd,\"%"
	"$%(\" .. num ..\"%)\", string.format(\"%s \", path.getrelative(cfg.location, depdata)))\nnum = num + 1\nend\ncmd = string.gsub(cmd, '%$%(<%)', '$in')\ncmd = string.gsub(cmd, '%$%(@%)', '$out')\nlocal cmd_name -- shortened command name\nif seen_commands[cmd] == nil then\nlocal _, _, name = string.find(cmd, '([.%w]+)%s')\nname = 'cmd' .. cmd_index .. '_' .. string.gsub(name, '[^%w]', '_')\nseen_commands[cmd] = {\nname = name,\nindex = cmd_index,\n}\ncmd_index = cmd_index + 1\ncmd_name = name\nelse\ncmd_name = seen_commands[cmd].name\nend\nlocal index = seen_commands[cmd].index\nif command_files[index] == nil then\ncommand_files[index] = {}\nend\nlocal cmd_set = command_files[index]\ntable.insert(cmd_set, {\nbuildtask[1],\nbuildtask[2],\nbuildtask[3],\nseen_commands[cmd].name,\n})\ncommand_files[index] = cmd_set\ncommand_by_name[cmd_name] = cmd\nend\nend\nend\n_p(\"# custom build rules\")\nfor command, details in pairs(seen_commands) do\n_p(\"rule \" .. details.name)\n_p(1, \"command = \" .. command)\nend\nfor cm"
	"d_index, cmdsets in ipairs(command_files) do\nfor _, cmdset in ipairs(cmdsets) do\nlocal file_in = path.getrelative(cfg.location, cmdset[1])\nlocal file_out = path.getrelative(cfg.location, cmdset[2])\nlocal deps = ''\nfor i, dep in ipairs(cmdset[3]) do\ndeps = deps .. path.getrelative(cfg.location, dep) .. ' '\nend\n_p(\"build \" .. file_out .. ': ' .. cmdset[4] .. ' ' .. file_in .. ' | ' .. deps)\n_p(\"\")\nend\nend\nend\nfunction cpp.dependencyRules(prj, cfg)\nlocal extra_deps = {}\nfor _, dependency in ipairs(prj.dependency or {}) do\nfor _, dep in ipairs(dependency or {}) do\nlocal objfilename = cpp.objectname(cfg, path.getrelative(prj.location, dep[1]))\nlocal dependency = path.getrelative(cfg.location, dep[2])\nif extra_deps[objfilename] == nil then\nextra_deps[objfilename] = {}\nend\ntable.insert(extra_deps[objfilename], dependency)\nend\nend\ncfg.extra_deps = extra_deps\nend\nfunction cpp.objectname(cfg, file)\nreturn path.join(cfg.objectsdir, path.trimdots(path.removeext(file)) .. \".o\")\nend\nfunct"
	"ion cpp.file_rules(cfg, flags)\n_p(\"# build files\")\nfor _, file in ipairs(cfg.files) do\n_p(\"# FILE: \" .. file)\nif path.issourcefile(file) then\nlocal objfilename = cpp.objectname(cfg, file)\nlocal extra_deps = #cfg.extra_deps and '| ' .. table.concat(cfg.extra_deps[objfilename] or {}, ' ') or ''\nlocal cflags = \"cflags\"\nif path.isobjcfile(file) then\n_p(\"build \" .. objfilename .. \": cxx \" .. file .. extra_deps)\ncflags = \"objcflags\"\nelseif path.isasmfile(file) then\n_p(\"build \" .. objfilename .. \": cc \" .. file .. extra_deps)\ncflags = \"asmflags\"\nelseif path.iscfile(file) and not cfg.options.ForceCPP then\n_p(\"build \" .. objfilename .. \": cc \" .. file .. extra_deps)\nelse\n_p(\"build \" .. objfilename .. \": cxx \" .. file .. extra_deps)\ncflags = \"cxxflags\"\nend\n_p(1, \"flags    = \" .. flags[cflags])\n_p(1, \"includes = \" .. flags.includes)\n_p(1, \"defines  = \" .. flags.defines)\nelseif path.isresourcefile(file) then\nend\nend\n_p(\"\")\nend\nfunction cpp.linker(prj, cfg, ob"
	"jfiles, tool)\nlocal all_ldflags = ninja.list(table.join(tool.getlibdirflags(cfg), tool.getldflags(cfg), cfg.linkoptions))\nlocal lddeps      = ninja.list(premake.getlinks(cfg, \"siblings\", \"fullpath\"))\nlocal libs        = lddeps .. \" \" .. ninja.list(tool.getlinkflags(cfg))\nlocal function writevars()\n_p(1, \"all_ldflags = \" .. all_ldflags)\n_p(1, \"libs        = \" .. libs)\n_p(1, \"all_outputfiles = \" .. table.concat(objfiles, \" \"))\nend\nif cfg.kind == \"StaticLib\" then\nlocal ar_flags = ninja.list(tool.getarchiveflags(cfg, cfg, false))\n_p(\"# link static lib\")\n_p(\"build \" .. cfg:getoutputfilename() .. \": ar \" .. table.concat(objfiles, \" \") .. \" | \" .. lddeps)\n_p(1, \"flags = \" .. ninja.list(tool.getarchiveflags(cfg, cfg, false)))\n_p(1, \"all_outputfiles = \" .. table.concat(objfiles, \" \"))\nelseif cfg.kind == \"SharedLib\" then\nlocal output = cfg:getoutputfilename()\n_p(\"# link shared lib\")\n_p(\"build \" .. output .. \": link \" .. table.concat(objfiles, \" \") .. \" | \" .."
	" libs)\nwritevars()\nelseif (cfg.kind == \"ConsoleApp\") or (cfg.kind == \"WindowedApp\") then\n_p(\"# link executable\")\n_p(\"build \" .. cfg:getoutputfilename() .. \": link \" .. table.concat(objfiles, \" \") .. \" | \" .. lddeps)\nwritevars()\nelse\np.error(\"ninja action doesn't support this kind of target \" .. cfg.kind)\nend\nend\n",

	/* actions/ninja/ninja_swift.lua */
	"local ninja = premake.ninja\nlocal swift = {}\nlocal p     = premake\nfunction ninja.generate_swift(prj)\nlocal pxy = ninja.get_proxy(\"prj\", prj)\nlocal tool = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, tool.platforms, \"Native\")\nfor _, platform in ipairs(platforms) do\nfor cfg in p.eachconfig(pxy, platform) do\np.generate(cfg, cfg:getprojectfilename(), function() swift.generate_config(prj, cfg) end)\nend\nend\nend\nfunction swift.generate_config(prj, cfg)\nlocal tool = premake.gettool(prj)\nlocal flags = {\nswiftcflags    = ninja.list(tool.getswiftcflags(cfg)),\nswiftlinkflags = ninja.list(tool.getswiftlinkflags(cfg)),\n}\n_p(\"# Swift project build file\")\n_p(\"# generated with GENie ninja\")\n_p(\"\")\n_p(\"ninja_required_version = 1.7\")\n_p(\"\")\n_p(\"out_dir = %s\", cfg.buildtarget.directory)\n_p(\"obj_dir = %s\", path.join(cfg.objectsdir, prj.name .. \".build\"))\n_p(\"target = $out_dir/%s\", cfg.buildtarget.name)\n_p(\"module_name = %s\", prj.name)\n_p(\"module_"
	"maps = %s\", ninja.list(tool.getmodulemaps(cfg)))\n_p(\"swiftc_flags = %s\", flags.swiftcflags)\n_p(\"swiftlink_flags = %s\", flags.swiftlinkflags)\n_p(\"ar_flags = %s\", ninja.list(tool.getarchiveflags(cfg, cfg, false)))\n_p(\"ld_flags = %s\", ninja.list(tool.getldflags(cfg)))\nif cfg.flags.Symbols then\n_p(\"symbols = $target.dSYM\")\nsymbols_command = string.format(\"&& %s $target -o $symbols\", tool.dsymutil)\nelse\n_p(\"symbols = \")\nsymbols_command = \"\"\nend\nlocal sdk = tool.get_sdk_path(cfg)\nif sdk then\n_p(\"toolchain_path = %s\", tool.get_toolchain_path(cfg))\n_p(\"sdk_path = %s\", sdk)\n_p(\"platform_path = %s\", tool.get_sdk_platform_path(cfg))\n_p(\"sdk = -sdk $sdk_path\")\nelse\n_p(\"sdk_path =\")\n_p(\"sdk =\")\nend\n_p(\"\")\n_p(\"# core rules for %s\", cfg.name)\n_p(\"rule swiftc\")\n_p(1, \"command = %s -frontend -c $in -enable-objc-interop $sdk -I $out_dir $swiftc_flags -module-cache-path $out_dir/ModuleCache -D SWIFT_PACKAGE $module_maps -emit-module-doc-path $out_dir/$module_name.swift"
	"doc -module-name $module_name -emit-module-path $out_dir/$module_name.swiftmodule -num-threads 8 $obj_files\", tool.swift)\n_p(1, \"description = compile $out\")\n_p(\"\")\n_p(\"rule swiftlink\")\n_p(1, \"command = %s $sdk -L $out_dir -o $out $swiftlink_flags $ld_flags $in %s\", tool.swiftc, symbols_command)\n_p(1, \"description = create executable\")\n_p(\"\")\n_p(\"rule ar\")\n_p(1, \"command = %s cr $ar_flags $out $in %s\", tool.ar, (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\"))\n_p(1, \"description = ar $out\")\n_p(\"\")\nlocal objfiles = {}\nfor _, file in ipairs(cfg.files) do\nif path.isswiftfile(file) then\ntable.insert(objfiles, swift.objectname(cfg, file))\nend\nend\nswift.file_rules(cfg, objfiles)\n_p(\"\")\nswift.linker(prj, cfg, objfiles, tool)\nend\nfunction swift.objectname(cfg, file)\nreturn path.join(\"$obj_dir\", path.getname(file)..\".o\")\nend\nfunction swift.file_rules(cfg, objfiles)\n_p(\"build %s: swiftc %s\", ninja.list(objfiles), ninja.list(cfg"
	".files))\n_p(1, \"obj_files = %s\", ninja.arglist(\"-o\", objfiles))\nend\nfunction swift.linker(prj, cfg, objfiles, tool)\nlocal lddeps = ninja.list(premake.getlinks(cfg, \"siblings\", \"fullpath\")) \nif cfg.kind == \"StaticLib\" then\n_p(\"build $target: ar %s | %s \", ninja.list(objfiles), lddeps)\nelse\nlocal lddeps = ninja.list(premake.getlinks(cfg, \"siblings\", \"fullpath\"))\n_p(\"build $target: swiftlink %s | %s\", ninja.list(objfiles), lddeps)\nend\nend\n",

	/* actions/ninja/ninja_swift_incremental.lua */
	"local ninja = premake.ninja\nlocal swift = { }\nlocal p     = premake\nfunction ninja.generate_swift_incremental(prj)\nlocal pxy = ninja.get_proxy(\"prj\", prj)\nlocal tool = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, tool.platforms, \"Native\")\nfor _, platform in ipairs(platforms) do\nfor cfg in p.eachconfig(pxy, platform) do\np.generate(cfg, cfg:getprojectfilename(), function() swift.generate_config(prj, cfg) end)\nend\nend\nend\nfunction swift.generate_config(prj, cfg)\nlocal tool = premake.gettool(prj)\nlocal flags = {\nswiftcflags = ninja.list(table.join(tool.getswiftcflags(cfg), cfg.buildoptions_swiftc)),\n}\n_p(\"# Swift project build file\")\n_p(\"# generated with GENie ninja\")\n_p(\"\")\n_p(\"ninja_required_version = 1.7\")\n_p(\"\")\n_p(\"out_dir = %s\", cfg.buildtarget.directory)\n_p(\"obj_dir = %s\", path.join(cfg.objectsdir, prj.name .. \".build\"))\n_p(\"module_name = %s\", prj.name)\n_p(\"module_maps = %s\", ninja.list(tool.getmodulemaps(cfg)))\n_p(\"swiftc_f"
	"lags = %s\", flags.swiftcflags)\n_p(\"swiftlink_flags = %s\", flags.swiftlinkflags)\n_p(\"ar_flags = %s\", ninja.list(tool.getarchiveflags(cfg, cfg, false)))\nlocal sdk = tool.get_sdk_path(cfg)\nif sdk then\n_p(\"toolchain_path = %s\", tool.get_toolchain_path(cfg))\n_p(\"sdk_path = %s\", sdk)\n_p(\"platform_path = %s\", tool.get_sdk_platform_path(cfg))\n_p(\"sdk = -sdk $sdk_path\")\n_p(\"ld_baseflags = -force_load $toolchain_path/usr/lib/arc/libarclite_macosx.a -L $out_dir -F $platform_path/Developer/Library/Frameworks -syslibroot $sdk_path -lobjc -lSystem -L $toolchain_path/usr/lib/swift/macosx -rpath $toolchain_path/usr/lib/swift/macosx -macosx_version_min 10.10.0 -no_objc_category_merging\")\nelse\n_p(\"sdk_path =\")\n_p(\"sdk =\")\n_p(\"ld_baseflags =\")\nend\n_p(\"\")\n_p(\"# core rules for %s\", cfg.name)\n_p(\"rule swiftc\")\n_p(1, \"command = %s -frontend -c -primary-file $in $files $target -enable-objc-interop $sdk -I $out_dir -enable-testing -module-cache-path $out_dir/ModuleCache -D SWIFT_PACKAGE $m"
	"odule_maps -emit-module-doc-path $out_doc_name swiftc_flags -module-name $module_name -emit-module-path $out_module_name -emit-dependencies-path $out.d -emit-reference-dependencies-path $obj_dir/$basename.swiftdeps -o $out\", tool.swiftc)\n_p(1, \"description = compile $out\")\n_p(\"\")\n_p(\"rule swiftm\")\n_p(1, \"command = %s -frontend -emit-module $in $parse_as_library swiftc_flags $target -enable-objc-interop $sdk -I $out_dir -F $platform_path/Developer/Library/Frameworks -enable-testing -module-cache-path $out_dir/ModuleCache -D SWIFT_PACKAGE $module_maps -emit-module-doc-path $out_dir/$module_name.swiftdoc -module-name $module_name -o $out\", tool.swift)\n_p(1, \"description = generate module\")\n_p(\"\")\n_p(\"rule swiftlink\")\n_p(1, \"command = %s $target $sdk $swiftlink_flags -L $out_dir -o $out_dir/$module_name -F $platform_path/Developer/Library/Frameworks $in\", tool.swiftc)\n_p(1, \"description = linking $target\")\n_p(\"\")\n_p(\"rule ar\")\n_p(1, \"command = %s cr $ar_flags $out $in $libs %s\""
	", tool.ar, (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\"))\n_p(1, \"description = ar $out\")\n_p(\"\")\n_p(\"rule link\")\n_p(\"  command = %s $in $ld_baseflags $all_ldflags $libs -o $out\", tool.ld)\n_p(\"  description = link $out\")\n_p(\"\")\nswift.file_rules(cfg, flags)\nlocal objfiles = {}\nlocal modfiles = {}\nlocal docfiles = {}\nfor _, file in ipairs(cfg.files) do\nif path.issourcefile(file) then\ntable.insert(objfiles, swift.objectname(cfg, file))\ntable.insert(modfiles, swift.modulename(cfg, file))\ntable.insert(docfiles, swift.docname(cfg, file))\nend\nend\n_p(\"\")\nswift.linker(prj, cfg, {objfiles, modfiles, docfiles}, tool, flags)\n_p(\"\")\nend\nfunction swift.objectname(cfg, file)\nreturn path.join(\"$obj_dir\", path.getname(file)..\".o\")\nend\nfunction swift.modulename(cfg, file)\nreturn path.join(\"$obj_dir\", path.getname(file)..\".o.swiftmodule\")\nend\nfunction swift.docname(cfg, file)\nreturn path.join(\"$obj_dir\", path.getname(file)..\".o.swift"
	"doc\")\nend\nfunction swift.file_rules(cfg, flags)\n_p(\"# build files\")\nlocal sfiles = Set(cfg.files)\nfor _, file in ipairs(cfg.files) do\nif path.issourcefile(file) then\nif path.isswiftfile(file) then\nlocal objn = swift.objectname(cfg, file)\nlocal modn = swift.modulename(cfg, file)\nlocal docn = swift.docname(cfg, file)\n_p(\"build %s | %s %s: swiftc %s\", objn, modn, docn, file)\n_p(1, \"out_module_name = %s\", modn)\n_p(1, \"out_doc_name = %s\", docn)\n_p(1, \"files = \".. ninja.list(sfiles - {file}))\nbuild_flags = \"swiftcflags\"\nend\n_p(1, \"flags    = \" .. flags[build_flags])\nelseif path.isresourcefile(file) then\nend\nend\n_p(\"\")\nend\nfunction swift.linker(prj, cfg, depfiles, tool)\nlocal all_ldflags = ninja.list(table.join(tool.getlibdirflags(cfg), tool.getldflags(cfg), cfg.linkoptions))\nlocal lddeps      = ninja.list(premake.getlinks(cfg, \"siblings\", \"fullpath\")) \nlocal libs        = lddeps .. \" \" .. ninja.list(tool.getlinkflags(cfg))\nlocal function writevars()\n_p(1, \"all_ldfl"
	"ags = \" .. all_ldflags)\n_p(1, \"libs        = \" .. libs)\nend\nlocal objfiles, modfiles, docfiles = table.unpack(depfiles)\n_p(\"build $out_dir/$module_name.swiftmodule | $out_dir/$module_name.swiftdoc: swiftm %s | %s\", table.concat(modfiles, \" \"), table.concat(docfiles, \" \"))\n_p(\"\")\nlocal output = cfg:getoutputfilename()\nif cfg.kind == \"StaticLib\" then\nlocal ar_flags = ninja.list(tool.getarchiveflags(cfg, cfg, false))\n_p(\"build %s: ar %s | %s $out_dir/$module_name.swiftmodule $out_dir/$module_name.swiftdoc\", output, table.concat(objfiles, \" \"), lddeps)\n_p(1, \"flags = %s\", ninja.list(tool.getarchiveflags(cfg, cfg, false)))\nelseif cfg.kind == \"SharedLib\" then\n_p(\"build %s : swiftlink %s | %s $out_dir/$module_name.swiftmodule $out_dir/$module_name.swiftdoc\", output, table.concat(objfiles, \" \"), libs)\nwritevars()\nelseif (cfg.kind == \"ConsoleApp\") or (cfg.kind == \"WindowedApp\") then\n_p(\"build %s: swiftlink %s | %s $out_dir/$module_name.swiftmodule $out_dir/$module_name.swift"
	"doc\", output, table.concat(objfiles, \" \"), lddeps)\nelse\np.error(\"ninja action doesn't support this kind of target \" .. cfg.kind)\nend\nend\n",

	/* actions/qbs/_qbs.lua */
	"premake.qbs = { }\nlocal qbs = premake.qbs\nnewaction\n{\ntrigger     = \"qbs\",\nshortname   = \"qbs\",\ndescription = \"Generate QBS build files\",\nmodule      = \"qbs\",\nvalid_kinds     = {\"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\"},\nvalid_languages = {\"C\", \"C++\"},\nvalid_tools     = {\ncc = { \"gcc\" },\n},\nonsolution = function(sln)\nio.eol    = \"\\n\"\nio.indent = \"\\t\"\nio.escaper(qbs.esc)\npremake.generate(sln, sln.name .. \".creator.qbs\",      qbs.generate_solution)\nio.indent = \" \"\npremake.generate(sln, sln.name .. \".creator.qbs.user\", qbs.generate_user)\nend,\nonproject = function(prj)\nio.eol    = \"\\n\"\nio.indent = \"\\t\"\nio.escaper(qbs.esc)\npremake.generate(prj, prj.name .. \".qbs\", qbs.generate_project)\nend,\n}\n",

	/* actions/qbs/qbs_base.lua */
	"function premake.qbs.list(indent, name, table)\nif #table > 0 then\n_p(indent, '%s: [', name)\nfor _, item in ipairs(table) do\n_p(indent+1, '\"%s\",', item:gsub('\"', '\\\\\"'))\nend\n_p(indent+1, ']')\nend\nend",

	/* actions/qbs/qbs_solution.lua */
	"local qbs = premake.qbs\nfunction qbs.generate_solution(sln)\n_p('/*')\n_p(' * QBS project file autogenerated by GENie')\n_p(' * https://github.com/bkaradzic/GENie')\n_p(' */')\n_p('')\n_p('import qbs')\n_p('')\n_p(0, 'Project {')\n_p(1, 'references: [')\nfor prj in premake.solution.eachproject(sln) do\n_p(2, '\"' .. prj.name .. '.qbs\",')\nend\n_p(1, ']')\n_p(0, '}')\nend\nlocal function is_app(kind)\nif kind == \"ConsoleApp\" or kind == \"WindowedApp\" then\nreturn true\nend\nreturn false\nend\nfunction qbs.generate_user(sln)\n_p(0, '<?xml version=\"1.0\" encoding=\"UTF-8\"?>')\n_p(0, '<!DOCTYPE QtCreatorProject>')\n_p(0, '<!-- QBS project file autogenerated by GENie https://github.com/bkaradzic/GENie -->')\n_p(0, '<qtcreator>')\nlocal startProject = 0\nlocal idx = 0\nfor prj in premake.solution.eachproject(sln) do\nif is_app(prj.kind) then\nif sln.startproject == prj.name then\nstartProject = idx\nend\nidx = idx + 1\nend\nend\n_p(1, '<data>')\n_p(2, '<variable>ProjectExplorer.Project.Target.0</variable>')\n"
	"_p(2, '<valuemap type=\"QVariantMap\">')\n_p(3, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DefaultDisplayName\">Desktop</value>')\n_p(3, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DisplayName\">Desktop</value>')\nlocal qbsguid    = \"\"\nlocal qbsprofile = \"\"\nlocal qtcreatordir = \"\"\nif _OS == \"windows\" then\nqtcreatordir = path.join(os.getenv(\"APPDATA\"), \"QtProject/qtcreator\")\nelse\nqtcreatordir = path.join(os.getenv(\"HOME\"), \".config/QtProject/qtcreator\")\nend\nlocal file = io.open(path.join(qtcreatordir, \"qbs.conf\"))\nif file == nil then\nfile = io.open(path.join(qtcreatordir, \"qbs/1.6.0/qbs.conf\"))\nend\nif file ~= nil then\nfor line in file:lines() do\nif line == \"[org]\" then\nlocal str = 'qt-project\\\\qbs\\\\preferences\\\\qtcreator\\\\kit\\\\%'\nlocal index = string.len(str)+1\nfor line in file:lines() do\nif index == string.find(line, '7B', index) then\nline = string.sub(line, index+2)\nqbsguid    = string.sub(line, 1, 36)\nqbspro"
	"file = string.sub(line, 41)\nbreak\nend\nend\nelse\nlocal str = '\\t<key>org.qt-project.qbs.preferences.qtcreator.kit.'\nlocal index = string.len(str)+1\nfor line in file:lines() do\nif qbsguid == \"\" and index == string.find(line, '{', index) then\nline = string.sub(line, index+1)\nqbsguid = string.sub(line, 1, 36)\nelseif qbsguid ~= \"\" then\nqbsprofile = string.sub(line, 10, 29)\nbreak\nend\nend\nend\nbreak\nend\nio.close(file)\nend\n_p(3, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.Id\">{%s}</value>', qbsguid)\n_p(3, '<value type=\"int\" key=\"ProjectExplorer.Target.ActiveBuildConfiguration\">0</value>')\n_p(3, '<value type=\"int\" key=\"ProjectExplorer.Target.ActiveDeployConfiguration\">0</value>')\n_p(3, '<value type=\"int\" key=\"ProjectExplorer.Target.ActiveRunConfiguration\">%d</value>', startProject)\nidx = 0\nfor _, cfgname in ipairs(sln.configurations) do\n_p(3, '<valuemap type=\"QVariantMap\" key=\"ProjectExplorer.Target.BuildConfiguration.%d\">', idx)\n_p(4, '<value type"
	"=\"QString\" key=\"ProjectExplorer.BuildConfiguration.BuildDirectory\">build</value>')\n_p(4, '<valuemap type=\"QVariantMap\" key=\"ProjectExplorer.BuildConfiguration.BuildStepList.0\">')\n_p(5, '<valuemap type=\"QVariantMap\" key=\"ProjectExplorer.BuildStepList.Step.0\">')\n_p(6, '<value type=\"bool\" key=\"ProjectExplorer.BuildStep.Enabled\">true</value>')\n_p(6, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DefaultDisplayName\"></value>')\n_p(6, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DisplayName\">Qbs Build</value>')\n_p(6, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.Id\">Qbs.BuildStep</value>')\n_p(6, '<value type=\"bool\" key=\"Qbs.CleanInstallRoot\">false</value>')\n_p(6, '<valuemap type=\"QVariantMap\" key=\"Qbs.Configuration\">')\n_p(7, '<value type=\"QString\" key=\"qbs.buildVariant\">%s</value>', cfgname:lower())\n_p(7, '<value type=\"QString\" key=\"qbs.profile\">%s</value>', qbsprofile)\n_p(6, '</valuemap>')\n_p(5, '</valuem"
	"ap>')\n_p(5, '<value type=\"int\" key=\"ProjectExplorer.BuildStepList.StepsCount\">1</value>')\n_p(5, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DefaultDisplayName\">Build</value>')\n_p(5, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DisplayName\"></value>')\n_p(5, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.Id\">ProjectExplorer.BuildSteps.Build</value>')\n_p(4, '</valuemap>')\n_p(4, '<valuemap type=\"QVariantMap\" key=\"ProjectExplorer.BuildConfiguration.BuildStepList.1\">')\n_p(5, '<valuemap type=\"QVariantMap\" key=\"ProjectExplorer.BuildStepList.Step.0\">')\n_p(6, '<value type=\"bool\" key=\"ProjectExplorer.BuildStep.Enabled\">true</value>')\n_p(6, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DefaultDisplayName\"></value>')\n_p(6, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DisplayName\">Qbs Clean</value>')\n_p(6, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.Id\">Qbs"
	".CleanStep</value>')\n_p(6, '<value type=\"bool\" key=\"Qbs.CleanAll\">true</value>')\n_p(6, '<value type=\"bool\" key=\"Qbs.DryKeepGoing\">false</value>')\n_p(6, '<value type=\"bool\" key=\"Qbs.DryRun\">false</value>')\n_p(5, '</valuemap>')\n_p(5, '<value type=\"int\" key=\"ProjectExplorer.BuildStepList.StepsCount\">1</value>')\n_p(5, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DefaultDisplayName\">Clean</value>')\n_p(5, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DisplayName\"></value>')\n_p(5, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.Id\">ProjectExplorer.BuildSteps.Clean</value>')\n_p(4, '</valuemap>')\n_p(4, '<value type=\"int\" key=\"ProjectExplorer.BuildConfiguration.BuildStepListCount\">2</value>')\n_p(4, '<value type=\"bool\" key=\"ProjectExplorer.BuildConfiguration.ClearSystemEnvironment\">false</value>')\n_p(4, '<valuelist type=\"QVariantList\" key=\"ProjectExplorer.BuildConfiguration.UserEnvironmentChanges\"/>')\n_p(4, '<valu"
	"e type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DefaultDisplayName\">%s</value>', cfgname)\n_p(4, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DisplayName\"></value>')\n_p(4, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.Id\">Qbs.QbsBuildConfiguration</value>')\n_p(3, '</valuemap>')\nidx = idx + 1\nend\n_p(3, '<value type=\"int\" key=\"ProjectExplorer.Target.BuildConfigurationCount\">%d</value>', idx)\n_p(3, '<valuemap type=\"QVariantMap\" key=\"ProjectExplorer.Target.DeployConfiguration.0\">')\n_p(4, '<valuemap type=\"QVariantMap\" key=\"ProjectExplorer.BuildConfiguration.BuildStepList.0\">')\n_p(5, '<value type=\"int\" key=\"ProjectExplorer.BuildStepList.StepsCount\">0</value>')\n_p(5, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DefaultDisplayName\">Deploy</value>')\n_p(5, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DisplayName\"></value>')\n_p(5, '<value type=\"QString\" key=\"ProjectExplorer.ProjectCo"
	"nfiguration.Id\">ProjectExplorer.BuildSteps.Deploy</value>')\n_p(4, '</valuemap>')\n_p(4, '<value type=\"int\" key=\"ProjectExplorer.BuildConfiguration.BuildStepListCount\">1</value>')\n_p(4, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DefaultDisplayName\">Deploy locally</value>')\n_p(4, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DisplayName\">Qbs Install</value>')\n_p(4, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.Id\">Qbs.Deploy</value>')\n_p(3, '</valuemap>')\n_p(3, '<value type=\"int\" key=\"ProjectExplorer.Target.DeployConfigurationCount\">1</value>')\nidx = 0\nfor prj in premake.solution.eachproject(sln) do\nif is_app(prj.kind) then\n_p(3, '<valuemap type=\"QVariantMap\" key=\"ProjectExplorer.Target.RunConfiguration.%d\">', idx)\nif idx == startProject then\n_p(4, '<value type=\"int\" key=\"PE.EnvironmentAspect.Base\">2</value>')\nelse\n_p(4, '<value type=\"int\" key=\"PE.EnvironmentAspect.Base\">-1</value>')\nend\n_p(4, '<valuelist"
	" type=\"QVariantList\" key=\"PE.EnvironmentAspect.Changes\"/>')\n_p(4, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DefaultDisplayName\">%s</value>', prj.name)\n_p(4, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.DisplayName\"></value>')\n_p(4, '<value type=\"QString\" key=\"ProjectExplorer.ProjectConfiguration.Id\">Qbs.RunConfiguration:%s.%s---Qbs.RC.NameSeparator---%s</value>', prj.name, qbsprofile, prj.name)\n_p(4, '<value type=\"QString\" key=\"Qbs.RunConfiguration.CommandLineArguments\"></value>')\nlocal cfg = premake.getconfig(prj, nil, nil)\nif cfg.debugdir ~= nil then\n_p(4, '<value type=\"QString\" key=\"Qbs.RunConfiguration.WorkingDirectory\">%s</value>', cfg.debugdir)\nelse\n_p(4, '<value type=\"QString\" key=\"Qbs.RunConfiguration.WorkingDirectory\"></value>')\nend\n_p(3, '</valuemap>')\nidx = idx + 1\nend\nend\n_p(3, '<value type=\"int\" key=\"ProjectExplorer.Target.RunConfigurationCount\">%d</value>', idx)\n_p(2, '</valuemap>')\n_p(1, '</data>')\n_p(1,"
	" '<data>')\n_p(2, '<variable>ProjectExplorer.Project.TargetCount</variable>')\n_p(2, '<value type=\"int\">1</value>')\n_p(1, '</data>')\n_p(1, '<data>')\n_p(2, '<variable>Version</variable>')\n_p(2, '<value type=\"int\">18</value>')\n_p(1, '</data>')\n_p(0, '</qtcreator>')\nend\n",

	/* actions/qbs/qbs_cpp.lua */
	"local qbs = premake.qbs\nlocal function is_excluded(prj, cfg, file)\nif table.icontains(prj.excludes, file) then\nreturn true\nend\nif table.icontains(cfg.excludes, file) then\nreturn true\nend\nreturn false\nend\nfunction qbs.generate_project(prj)\nlocal indent = 0\n_p(indent, '/*')\n_p(indent, ' * QBS project file autogenerated by GENie')\n_p(indent, ' * https://github.com/bkaradzic/GENie')\n_p(indent, ' */')\n_p(indent, '')\n_p(indent, 'import qbs 1.0')\n_p(indent, '')\nif prj.kind == \"ConsoleApp\" then\n_p(indent, 'CppApplication {')\n_p(indent, 'consoleApplication: true')\nelseif prj.kind == \"WindowedApp\" then\n_p(indent, 'CppApplication {')\nelseif prj.kind == \"StaticLib\" then\n_p(indent, 'StaticLibrary {')\nelseif prj.kind == \"SharedLib\" then\n_p(indent, 'DynamicLibrary {')\nend\nindent = indent + 1\n_p(indent, 'name: \"' .. prj.name .. '\"')\n_p(indent, 'cpp.cxxLanguageVersion: \"c++11\"')\n_p(indent, 'Depends { name: \"cpp\" }')\nlocal deps = premake.getdependencies(prj)\nif #deps > 0 then\nfor"
	" _, depprj in ipairs(deps) do\n_p(indent, 'Depends { name: \"%s\" }', depprj.name)\nend\nend\nlocal cc = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\nif cfg.platform ~= \"Native\" then\n_p('');\n_p(indent, 'Properties { /* %s */', premake.getconfigname(cfg.name, cfg.platform, true))\nindent = indent + 1\nlocal arch = \"\"\nlocal linkerFlags = cfg.linkoptions\nif cfg.platform == \"x32\" then\narch = '&& qbs.architecture == \"x86\"'\nelseif cfg.platform == \"x64\" then\narch = '&& qbs.architecture == \"x86_64\"'\nend\nif cfg.name == \"Debug\" then\n_p(indent, 'condition: qbs.buildVariant == \"debug\" %s', arch)\nelse\n_p(indent, 'condition: qbs.buildVariant == \"release\" %s', arch)\nend\n_p(indent, 'targetName: \"%s\"', cfg.buildtarget.basename)\n_p(indent, 'destinationDirectory: \"%s\"', path.getabsolute('projects/qbs/' .. cfg.buildtarget.directory) .. '/')\nqbs."
	"list(\n  indent\n, \"cpp.commonCompilerFlags\"\n, cfg.buildoptions\n)\nqbs.list(\n  indent\n, \"cpp.cFlags\"\n, cfg.buildoptions_c\n)\nqbs.list(\n  indent\n, \"cpp.cxxFlags\"\n, cfg.buildoptions_cpp\n)\nqbs.list(\n  indent\n, \"cpp.objcFlags\"\n, cfg.buildoptions_objc\n)\nqbs.list(\n  indent\n, \"cpp.objcxxFlags\"\n, cfg.buildoptions_objc\n)\nif cfg.flags.StaticRuntime then\n_p(indent, 'cpp.runtimeLibrary: \"static\"')\nelse\n_p(indent, 'cpp.runtimeLibrary: \"dynamic\"')\nend\nif cfg.flags.PedanticWarnings\nor cfg.flags.ExtraWarnings\nthen\n_p(indent, 'cpp.warningLevel: \"all\"')\nelse\n_p(indent, 'cpp.warningLevel: \"default\"')\nend\nif cfg.flags.FatalWarnings then\n_p(indent, 'cpp.treatWarningsAsErrors: true')\nelse\n_p(indent, 'cpp.treatWarningsAsErrors: false')\nend\nif cfg.flags.NoRTTI then\n_p(indent, 'cpp.enableRtti: false')\nelse\n_p(indent, 'cpp.enableRtti: true')\nend\nif cfg.flags.NoExceptions then\n_p(indent, 'cpp.enableExceptions: false')\nelse\n_p(indent, 'cpp.enableExceptions: true')\nend\nif c"
	"fg.flags.Symbols then\n_p(indent, 'cpp.debugInformation: true')\nelse\n_p(indent, 'cpp.debugInformation: false')\nend\nif cfg.flags.Unicode then\n_p(indent, 'cpp.windowsApiCharacterSet: \"unicode\"')\nelse\n_p(indent, 'cpp.windowsApiCharacterSet: \"\"')\nend\nif not cfg.pchheader or cfg.flags.NoPCH then\n_p(indent, 'cpp.usePrecompiledHeader: false')\nelse\n_p(indent, 'cpp.usePrecompiledHeader: true')\n_p(indent, 'Group {')\n_p(indent+1, 'name: \"PCH\"')\n_p(indent+1, 'files: [\"' .. cfg.pchheader .. '\"]')\n_p(indent+1, 'fileTags: [\"cpp_pch_src\"]')\n_p(indent, '}')\nend\nfor _, value in ipairs(cfg.flags) do\nif (value == \"Optimize\") then\nelseif (value == \"OptimizeSize\") then\n_p(indent, 'cpp.optimization: \"small\"')\nelseif (value == \"OptimizeSpeed\") then\n_p(indent, 'cpp.optimization: \"fast\"')\nend\nend\nqbs.list(\n  indent\n, \"cpp.defines\"\n, cfg.defines\n)\nlocal sortedincdirs = {}\nfor _, includedir in ipairs(cfg.userincludedirs) do\nif includedir ~= nil then\ntable.insert(sortedincdirs, incl"
	"udedir)\nend\nend\nfor _, includedir in ipairs(cfg.includedirs) do\nif includedir ~= nil then\ntable.insert(sortedincdirs, includedir)\nend\nend\ntable.sort(sortedincdirs, includesort)\nqbs.list(\n  indent\n, \"cpp.includePaths\"\n, sortedincdirs\n)\nqbs.list(\n  indent\n, \"cpp.staticLibraries\"\n, premake.getlinks(cfg, \"system\", \"fullpath\")\n)\nqbs.list(\n  indent\n, \"cpp.libraryPaths\"\n, cfg.libdirs\n)\nqbs.list(\n  indent\n, \"cpp.linkerFlags\"\n, linkerFlags\n)\ntable.sort(prj.files)\nif #prj.files > 0 then\n_p(indent, 'files: [')\nfor _, file in ipairs(prj.files) do\nif path.iscfile(file)\nor path.iscppfile(file)\nor path.isobjcfile(file)\nor path.iscppheader(file) then\nif not is_excluded(prj, cfg, file) then\n_p(indent+1, '\"%s\",', file)\nend\nend\nend\n_p(indent+1, ']')\nend\nif #prj.excludes > 0 then\n_p(indent, 'excludeFiles: [')\ntable.sort(prj.excludes)\nfor _, file in ipairs(prj.excludes) do\nif path.issourcefile(file) then\n_p(indent+1, '\"%s\",', file)\nend\nend\n_p(indent+1, ']')\nend\n"
	"indent = indent - 1\n_p(indent, '}');\nend\nend\nend\nindent = indent - 1\n_p(indent, '}')\nend\n",

	/* _premake_main.lua */
	"_WORKING_DIR        = os.getcwd()\nlocal function injectplatform(platform)\nif not platform then return true end\nplatform = premake.checkvalue(platform, premake.fields.platforms.allowed)\nfor sln in premake.solution.each() do\nlocal platforms = sln.platforms or { }\nif #platforms == 0 then\ntable.insert(platforms, \"Native\")\nend\nif not table.contains(platforms, \"Native\") then\nreturn false, sln.name .. \" does not target native platform\\nNative platform settings are required for the --platform feature.\"\nend\nif not table.contains(platforms, platform) then\ntable.insert(platforms, platform)\nend\nsln.platforms = platforms\nend\nreturn true\nend\nfunction _premake_main(scriptpath)\nif (scriptpath) then\nlocal scripts  = dofile(scriptpath .. \"/_manifest.lua\")\nfor _,v in ipairs(scripts) do\ndofile(scriptpath .. \"/\" .. v)\nend\nend\nlocal profiler = newProfiler()\nif (nil ~= _OPTIONS[\"debug-profiler\"]) then\nprofiler:start()\nend\n_PREMAKE_COMMAND = path.getabsolute(_PREMAKE_COMMAND)\npremake.action"
	".set(_ACTION)\nmath.randomseed(os.time())\nif (nil ~= _OPTIONS[\"file\"]) then\nlocal fname = _OPTIONS[\"file\"]\nif (os.isfile(fname)) then\ndofile(fname)\nelse\nerror(\"No genie script '\" .. fname .. \"' found!\", 2)\nend\nelse\nlocal dir, name = premake.findDefaultScript(path.getabsolute(\"./\"))\nif dir ~= nil then\nos.chdir(dir)\ndofile(name)\nend\nend\nif (_OPTIONS[\"version\"] or _OPTIONS[\"help\"] or not _ACTION) then\nprintf(\"GENie - Project generator tool %s\", _GENIE_VERSION_STR)\nprintf(\"https://github.com/bkaradzic/GENie\")\nif (not _OPTIONS[\"version\"]) then\npremake.showhelp()\nend\nreturn 1\nend\naction = premake.action.current()\nif (not action) then\nerror(\"Error: no such action '\" .. _ACTION .. \"'\", 0)\nend\nok, err = premake.option.validate(_OPTIONS)\nif (not ok) then error(\"Error: \" .. err, 0) end\nok, err = premake.checktools()\nif (not ok) then error(\"Error: \" .. err, 0) end\nok, err = injectplatform(_OPTIONS[\"platform\"])\nif (not ok) then error(\"Error: \" .. err, 0) end\n"
	"print(\"Building configurations...\")\npremake.bake.buildconfigs()\nok, err = premake.checkprojects()\nif (not ok) then error(\"Error: \" .. err, 0) end\npremake.stats = { }\npremake.stats.num_generated = 0\npremake.stats.num_skipped   = 0\nprintf(\"Running action '%s'...\", action.trigger)\npremake.action.call(action.trigger)\nif (nil ~= _OPTIONS[\"debug-profiler\"]) then\nprofiler:stop()\nlocal filePath = path.getabsolute(\"GENie-profile.txt\")\nprint(\"Writing debug-profile report to ''\" .. filePath .. \"'.\")\nlocal outfile = io.open(filePath, \"w+\")\nprofiler:report(outfile, true)\noutfile:close()\nend\nprintf(\"Done. Generated %d/%d projects.\"\n, premake.stats.num_generated\n, premake.stats.num_generated+premake.stats.num_skipped\n)\nreturn 0\nend\n",

	0
};
