/*
 * Decompiled with CFR 0.152.
 */
package com.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.IntentFilter;
import android.util.Log;
import com.robotium.solo.Sleeper;
import com.robotium.solo.Solo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.Timer;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActivityUtils {
    private final Solo.Config config;
    private final Instrumentation inst;
    private Instrumentation.ActivityMonitor activityMonitor;
    private Activity activity;
    private final Sleeper sleeper;
    private final String LOG_TAG = "Robotium";
    private final int MINISLEEP = 100;
    private Stack<WeakReference<Activity>> activityStack;
    private WeakReference<Activity> weakActivityReference;
    private Stack<String> activitiesStoredInActivityStack;
    private Timer activitySyncTimer;
    private boolean registerActivities;
    Thread activityThread;

    public ActivityUtils(Solo.Config config, Instrumentation inst, Activity activity, Sleeper sleeper) {
        this.config = config;
        this.inst = inst;
        this.activity = activity;
        this.sleeper = sleeper;
        this.createStackAndPushStartActivity();
        this.activitySyncTimer = new Timer();
        this.activitiesStoredInActivityStack = new Stack();
        this.setupActivityMonitor();
        this.setupActivityStackListener();
    }

    private void createStackAndPushStartActivity() {
        this.activityStack = new Stack();
        if (this.activity != null && this.config.trackActivities) {
            WeakReference<Activity> weakReference = new WeakReference<Activity>(this.activity);
            this.activity = null;
            this.activityStack.push(weakReference);
        }
    }

    public ArrayList<Activity> getAllOpenedActivities() {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        Iterator activityStackIterator = this.activityStack.iterator();
        while (activityStackIterator.hasNext()) {
            Activity activity = (Activity)((WeakReference)activityStackIterator.next()).get();
            if (activity == null) continue;
            activities.add(activity);
        }
        return activities;
    }

    private void setupActivityMonitor() {
        if (this.config.trackActivities) {
            try {
                IntentFilter filter = null;
                this.activityMonitor = this.inst.addMonitor(filter, null, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean shouldRegisterActivities() {
        return this.registerActivities;
    }

    public void setRegisterActivities(boolean registerActivities) {
        this.registerActivities = registerActivities;
    }

    private void setupActivityStackListener() {
        if (this.activityMonitor == null) {
            return;
        }
        this.setRegisterActivities(true);
        Runnable runnable = new Runnable(){

            public void run() {
                while (ActivityUtils.this.shouldRegisterActivities()) {
                    Activity activity;
                    if (ActivityUtils.this.activityMonitor == null || (activity = ActivityUtils.this.activityMonitor.waitForActivityWithTimeout(2000L)) == null) continue;
                    if (ActivityUtils.this.activitiesStoredInActivityStack.remove(activity.toString())) {
                        ActivityUtils.this.removeActivityFromStack(activity);
                    }
                    if (activity.isFinishing()) continue;
                    ActivityUtils.this.addActivityToStack(activity);
                }
            }
        };
        this.activityThread = new Thread(runnable, "activityMonitorThread");
        this.activityThread.start();
    }

    private void removeActivityFromStack(Activity activity) {
        Iterator activityStackIterator = this.activityStack.iterator();
        while (activityStackIterator.hasNext()) {
            Activity activityFromWeakReference = (Activity)((WeakReference)activityStackIterator.next()).get();
            if (activityFromWeakReference == null) {
                activityStackIterator.remove();
            }
            if (activity == null || activityFromWeakReference == null || !activityFromWeakReference.equals(activity)) continue;
            activityStackIterator.remove();
        }
    }

    public Instrumentation.ActivityMonitor getActivityMonitor() {
        return this.activityMonitor;
    }

    public void setActivityOrientation(int orientation) {
        Activity activity = this.getCurrentActivity();
        if (activity != null) {
            activity.setRequestedOrientation(orientation);
        }
    }

    public Activity getCurrentActivity(boolean shouldSleepFirst) {
        return this.getCurrentActivity(shouldSleepFirst, true);
    }

    public Activity getCurrentActivity() {
        return this.getCurrentActivity(true, true);
    }

    private void addActivityToStack(Activity activity) {
        this.activitiesStoredInActivityStack.push(activity.toString());
        this.weakActivityReference = new WeakReference<Activity>(activity);
        activity = null;
        this.activityStack.push(this.weakActivityReference);
    }

    private final void waitForActivityIfNotAvailable() {
        if (this.activityStack.isEmpty() || this.activityStack.peek().get() == null) {
            if (this.activityMonitor != null) {
                Activity activity = this.activityMonitor.getLastActivity();
                while (activity == null) {
                    this.sleeper.sleepMini();
                    activity = this.activityMonitor.getLastActivity();
                }
                this.addActivityToStack(activity);
            } else if (this.config.trackActivities) {
                this.sleeper.sleepMini();
                this.setupActivityMonitor();
                this.waitForActivityIfNotAvailable();
            }
        }
    }

    public String getCurrentActivityName() {
        if (!this.activitiesStoredInActivityStack.isEmpty()) {
            return this.activitiesStoredInActivityStack.peek();
        }
        return "";
    }

    public Activity getCurrentActivity(boolean shouldSleepFirst, boolean waitForActivity) {
        if (shouldSleepFirst) {
            this.sleeper.sleep();
        }
        if (!this.config.trackActivities) {
            return this.activity;
        }
        if (waitForActivity) {
            this.waitForActivityIfNotAvailable();
        }
        if (!this.activityStack.isEmpty()) {
            this.activity = (Activity)this.activityStack.peek().get();
        }
        return this.activity;
    }

    public boolean isActivityStackEmpty() {
        return this.activityStack.isEmpty();
    }

    public void goBackToActivity(String name) {
        int i;
        ArrayList<Activity> activitiesOpened = this.getAllOpenedActivities();
        boolean found = false;
        for (i = 0; i < activitiesOpened.size(); ++i) {
            if (!activitiesOpened.get(i).getClass().getSimpleName().equals(name)) continue;
            found = true;
            break;
        }
        if (found) {
            while (!this.getCurrentActivity().getClass().getSimpleName().equals(name)) {
                try {
                    this.inst.sendKeyDownUpSync(4);
                }
                catch (SecurityException ignored) {}
            }
        } else {
            for (i = 0; i < activitiesOpened.size(); ++i) {
                Log.d((String)"Robotium", (String)("Activity priorly opened: " + activitiesOpened.get(i).getClass().getSimpleName()));
            }
            Assert.fail((String)("No Activity named: '" + name + "' has been priorly opened"));
        }
    }

    public String getString(int resId) {
        Activity activity = this.getCurrentActivity(false);
        if (activity == null) {
            return "";
        }
        return activity.getString(resId);
    }

    public void finalize() throws Throwable {
        this.activitySyncTimer.cancel();
        this.stopActivityMonitor();
        super.finalize();
    }

    private void stopActivityMonitor() {
        try {
            if (this.activityMonitor != null) {
                this.inst.removeMonitor(this.activityMonitor);
                this.activityMonitor = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finishOpenedActivities() {
        this.activitySyncTimer.cancel();
        if (!this.config.trackActivities) {
            this.useGoBack(3);
            return;
        }
        ArrayList<Activity> activitiesOpened = this.getAllOpenedActivities();
        for (int i = activitiesOpened.size() - 1; i >= 0; --i) {
            this.sleeper.sleep(100);
            this.finishActivity(activitiesOpened.get(i));
        }
        activitiesOpened = null;
        this.sleeper.sleep(100);
        this.finishActivity(this.getCurrentActivity(true, false));
        this.stopActivityMonitor();
        this.setRegisterActivities(false);
        this.activity = null;
        this.sleeper.sleepMini();
        this.useGoBack(1);
        this.clearActivityStack();
    }

    private void useGoBack(int numberOfTimes) {
        for (int i = 0; i < numberOfTimes; ++i) {
            try {
                this.inst.sendKeyDownUpSync(4);
                this.sleeper.sleep(100);
                this.inst.sendKeyDownUpSync(4);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void clearActivityStack() {
        this.activityStack.clear();
        this.activitiesStoredInActivityStack.clear();
    }

    private void finishActivity(Activity activity) {
        if (activity != null) {
            try {
                activity.finish();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

