/*
This file is part of Telegram Desktop,
the official desktop application for the Telegram messaging service.

For license and copyright information please follow this link:
https://github.com/telegramdesktop/tdesktop/blob/master/LEGAL
*/
#include "codegen/emoji/data.h"

namespace codegen {
namespace emoji {
namespace {

using uint16 = quint16;
using uint32 = quint32;
using uint64 = quint64;

using std::vector;
using std::map;
using std::set;
using std::find;
using std::make_pair;
using std::move;
using std::begin;
using std::end;

using InputId = vector<uint32>;
using InputCategory = vector<InputId>;

namespace old {
extern InputCategory ColoredEmoji;
extern InputCategory Category1;
extern InputCategory Category2;
extern InputCategory Category3;
extern InputCategory Category4;
extern InputCategory Category5;
extern InputCategory Category6;
extern InputCategory Category7;
} // namespace old

// copied from emoji_box.cpp
struct Replace {
	InputId code;
	const char *replace;
};

Replace Replaces[] = {
	{ { 0xD83DDE0AU }, ":-)" },
	{ { 0xD83DDE0DU }, "8-)" },
	{ { 0x2764U }, "<3" },
//	{ { 0xD83DDC8BU }, ":kiss:" },
//	{ { 0xD83DDE01U }, ":grin:" },
//	{ { 0xD83DDE02U }, ":joy:" },
	{ { 0xD83DDE1AU }, ":-*" },
//	{ { 0xD83DDE06U }, "xD" }, // Conflicts with typing xDDD...
//	{ { 0xD83DDC4DU }, ":like:" },
//	{ { 0xD83DDC4EU }, ":dislike:" },
//	{ { 0x261DU }, ":up:" },
//	{ { 0x270CU }, ":v:" },
//	{ { 0xD83DDC4CU }, ":ok:" },
	{ { 0xD83DDE0EU }, "B-)" },
	{ { 0xD83DDE03U }, ":-D" },
	{ { 0xD83DDE09U }, ";-)" },
	{ { 0xD83DDE1CU }, ";-P" },
	{ { 0xD83DDE0BU }, ":-p" },
	{ { 0xD83DDE14U }, "3(" },
	{ { 0xD83DDE1EU }, ":-(" },
	{ { 0xD83DDE0FU }, ":]" },
	{ { 0xD83DDE22U }, ":'(" },
	{ { 0xD83DDE2DU }, ":_(" },
	{ { 0xD83DDE29U }, ":((" },
//	{ { 0xD83DDE28U }, ":o" }, // Conflicts with typing :ok...
	{ { 0xD83DDE10U }, ":|" },
	{ { 0xD83DDE0CU }, "3-)" },
	{ { 0xD83DDE20U }, ">(" },
	{ { 0xD83DDE21U }, ">((" },
	{ { 0xD83DDE07U }, "O:)" },
	{ { 0xD83DDE30U }, ";o" },
	{ { 0xD83DDE33U }, "8|" },
	{ { 0xD83DDE32U }, "8o" },
	{ { 0xD83DDE37U }, ":X" },
	{ { 0xD83DDE08U }, "}:)" },
};

InputCategory PostfixRequired = {
 { 0x2122U, 0xFE0FU, },
 { 0xA9U, 0xFE0FU, },
 { 0xAEU, 0xFE0FU, },
};

using ColorId = uint32;
ColorId Colors[] = {
	0xD83CDFFBU,
	0xD83CDFFCU,
	0xD83CDFFDU,
	0xD83CDFFEU,
	0xD83CDFFFU,
};

constexpr auto ColorMask = 0xD83CDFFBU;
InputCategory ColoredEmoji = {
 { 0xD83EDD32U, 0xD83CDFFBU, },
 { 0xD83DDC50U, 0xD83CDFFBU, },
 { 0xD83DDE4CU, 0xD83CDFFBU, },
 { 0xD83DDC4FU, 0xD83CDFFBU, },
 { 0xD83DDC4DU, 0xD83CDFFBU, },
 { 0xD83DDC4EU, 0xD83CDFFBU, },
 { 0xD83DDC4AU, 0xD83CDFFBU, },
 { 0x270AU, 0xD83CDFFBU, },
 { 0xD83EDD1BU, 0xD83CDFFBU, },
 { 0xD83EDD1CU, 0xD83CDFFBU, },
 { 0xD83EDD1EU, 0xD83CDFFBU, },
 { 0x270CU, 0xD83CDFFBU, },
 { 0xD83EDD1FU, 0xD83CDFFBU, },
 { 0xD83EDD18U, 0xD83CDFFBU, },
 { 0xD83DDC4CU, 0xD83CDFFBU, },
 { 0xD83DDC48U, 0xD83CDFFBU, },
 { 0xD83DDC49U, 0xD83CDFFBU, },
 { 0xD83DDC46U, 0xD83CDFFBU, },
 { 0xD83DDC47U, 0xD83CDFFBU, },
 { 0x261DU, 0xD83CDFFBU, },
 { 0x270BU, 0xD83CDFFBU, },
 { 0xD83EDD1AU, 0xD83CDFFBU, },
 { 0xD83DDD90U, 0xD83CDFFBU, },
 { 0xD83DDD96U, 0xD83CDFFBU, },
 { 0xD83DDC4BU, 0xD83CDFFBU, },
 { 0xD83EDD19U, 0xD83CDFFBU, },
 { 0xD83DDCAAU, 0xD83CDFFBU, },
 { 0xD83DDD95U, 0xD83CDFFBU, },
 { 0x270DU, 0xD83CDFFBU, },
 { 0xD83DDE4FU, 0xD83CDFFBU, },
 { 0xD83EDDB6U, 0xD83CDFFBU, },
 { 0xD83EDDB5U, 0xD83CDFFBU, },
 { 0xD83DDC42U, 0xD83CDFFBU, },
 { 0xD83DDC43U, 0xD83CDFFBU, },
 { 0xD83DDC76U, 0xD83CDFFBU, },
 { 0xD83DDC67U, 0xD83CDFFBU, },
 { 0xD83EDDD2U, 0xD83CDFFBU, },
 { 0xD83DDC66U, 0xD83CDFFBU, },
 { 0xD83DDC69U, 0xD83CDFFBU, },
 { 0xD83EDDD1U, 0xD83CDFFBU, },
 { 0xD83DDC68U, 0xD83CDFFBU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83EDDB1U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83EDDB1U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83EDDB0U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83EDDB0U, },
 { 0xD83DDC71U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC71U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83EDDB3U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83EDDB3U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83EDDB2U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83EDDB2U, },
 { 0xD83EDDD4U, 0xD83CDFFBU, },
 { 0xD83DDC75U, 0xD83CDFFBU, },
 { 0xD83EDDD3U, 0xD83CDFFBU, },
 { 0xD83DDC74U, 0xD83CDFFBU, },
 { 0xD83DDC72U, 0xD83CDFFBU, },
 { 0xD83DDC73U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC73U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDD5U, 0xD83CDFFBU, },
 { 0xD83DDC6EU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC6EU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC77U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC77U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC82U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC82U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDD75U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDD75U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0x2695U, 0xFE0FU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0x2695U, 0xFE0FU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83CDF3EU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83CDF3EU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83CDF73U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83CDF73U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83CDF93U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83CDF93U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83CDFA4U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83CDFA4U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83CDFEBU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83CDFEBU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83CDFEDU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83CDFEDU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83DDCBBU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83DDCBBU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83DDCBCU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83DDCBCU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83DDD27U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83DDD27U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83DDD2CU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83DDD2CU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83CDFA8U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83CDFA8U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83DDE92U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83DDE92U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0x2708U, 0xFE0FU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0x2708U, 0xFE0FU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83DDE80U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83DDE80U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0x2696U, 0xFE0FU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0x2696U, 0xFE0FU, },
 { 0xD83DDC70U, 0xD83CDFFBU, },
 { 0xD83EDD35U, 0xD83CDFFBU, },
 { 0xD83DDC78U, 0xD83CDFFBU, },
 { 0xD83EDD34U, 0xD83CDFFBU, },
 { 0xD83EDDB8U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDB8U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDB9U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDB9U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD36U, 0xD83CDFFBU, },
 { 0xD83CDF85U, 0xD83CDFFBU, },
 { 0xD83EDDD9U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDD9U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDDDU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDDDU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDDBU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDDBU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDDCU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDDCU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDDAU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDDAU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC7CU, 0xD83CDFFBU, },
 { 0xD83EDD30U, 0xD83CDFFBU, },
 { 0xD83EDD31U, 0xD83CDFFBU, },
 { 0xD83DDE47U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDE47U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC81U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC81U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE45U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDE45U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE46U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDE46U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE4BU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDE4BU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD26U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD26U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD37U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD37U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE4EU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDE4EU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE4DU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDE4DU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC87U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC87U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC86U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC86U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDD6U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDD6U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC85U, 0xD83CDFFBU, },
 { 0xD83EDD33U, 0xD83CDFFBU, },
 { 0xD83DDC83U, 0xD83CDFFBU, },
 { 0xD83DDD7AU, 0xD83CDFFBU, },
 { 0xD83DDD74U, 0xD83CDFFBU, },
 { 0xD83DDEB6U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEB6U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFC3U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFC3U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFCBU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFCBU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD38U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD38U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0x26F9U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0x26F9U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD3EU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD3EU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFCCU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFCCU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFC7U, 0xD83CDFFBU, },
 { 0xD83EDDD8U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDD8U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFC4U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFC4U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFCAU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFCAU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD3DU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD3DU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDEA3U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEA3U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDD7U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDD7U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDEB5U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEB5U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDEB4U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEB4U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD39U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD39U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDEC0U, 0xD83CDFFBU, },
};

InputCategory Category1 = {
 { 0xD83DDE00U, },
 { 0xD83DDE03U, },
 { 0xD83DDE04U, },
 { 0xD83DDE01U, },
 { 0xD83DDE06U, },
 { 0xD83DDE05U, },
 { 0xD83DDE02U, },
 { 0xD83EDD23U, },
 { 0x263AU, 0xFE0FU, },
 { 0xD83DDE0AU, },
 { 0xD83DDE07U, },
 { 0xD83DDE42U, },
 { 0xD83DDE43U, },
 { 0xD83DDE09U, },
 { 0xD83DDE0CU, },
 { 0xD83DDE0DU, },
 { 0xD83EDD70U, },
 { 0xD83DDE18U, },
 { 0xD83DDE17U, },
 { 0xD83DDE19U, },
 { 0xD83DDE1AU, },
 { 0xD83DDE0BU, },
 { 0xD83DDE1BU, },
 { 0xD83DDE1DU, },
 { 0xD83DDE1CU, },
 { 0xD83EDD2AU, },
 { 0xD83EDD28U, },
 { 0xD83EDDD0U, },
 { 0xD83EDD13U, },
 { 0xD83DDE0EU, },
 { 0xD83EDD29U, },
 { 0xD83EDD73U, },
 { 0xD83DDE0FU, },
 { 0xD83DDE12U, },
 { 0xD83DDE1EU, },
 { 0xD83DDE14U, },
 { 0xD83DDE1FU, },
 { 0xD83DDE15U, },
 { 0xD83DDE41U, },
 { 0x2639U, 0xFE0FU, },
 { 0xD83DDE23U, },
 { 0xD83DDE16U, },
 { 0xD83DDE2BU, },
 { 0xD83DDE29U, },
 { 0xD83EDD7AU, },
 { 0xD83DDE22U, },
 { 0xD83DDE2DU, },
 { 0xD83DDE24U, },
 { 0xD83DDE20U, },
 { 0xD83DDE21U, },
 { 0xD83EDD2CU, },
 { 0xD83EDD2FU, },
 { 0xD83DDE33U, },
 { 0xD83EDD75U, },
 { 0xD83EDD76U, },
 { 0xD83DDE31U, },
 { 0xD83DDE28U, },
 { 0xD83DDE30U, },
 { 0xD83DDE25U, },
 { 0xD83DDE13U, },
 { 0xD83EDD17U, },
 { 0xD83EDD14U, },
 { 0xD83EDD2DU, },
 { 0xD83EDD2BU, },
 { 0xD83EDD25U, },
 { 0xD83DDE36U, },
 { 0xD83DDE10U, },
 { 0xD83DDE11U, },
 { 0xD83DDE2CU, },
 { 0xD83DDE44U, },
 { 0xD83DDE2FU, },
 { 0xD83DDE26U, },
 { 0xD83DDE27U, },
 { 0xD83DDE2EU, },
 { 0xD83DDE32U, },
 { 0xD83DDE34U, },
 { 0xD83EDD24U, },
 { 0xD83DDE2AU, },
 { 0xD83DDE35U, },
 { 0xD83EDD10U, },
 { 0xD83EDD74U, },
 { 0xD83EDD22U, },
 { 0xD83EDD2EU, },
 { 0xD83EDD27U, },
 { 0xD83DDE37U, },
 { 0xD83EDD12U, },
 { 0xD83EDD15U, },
 { 0xD83EDD11U, },
 { 0xD83EDD20U, },
 { 0xD83DDE08U, },
 { 0xD83DDC7FU, },
 { 0xD83DDC79U, },
 { 0xD83DDC7AU, },
 { 0xD83EDD21U, },
 { 0xD83DDCA9U, },
 { 0xD83DDC7BU, },
 { 0xD83DDC80U, },
 { 0x2620U, 0xFE0FU, },
 { 0xD83DDC7DU, },
 { 0xD83DDC7EU, },
 { 0xD83EDD16U, },
 { 0xD83CDF83U, },
 { 0xD83DDE3AU, },
 { 0xD83DDE38U, },
 { 0xD83DDE39U, },
 { 0xD83DDE3BU, },
 { 0xD83DDE3CU, },
 { 0xD83DDE3DU, },
 { 0xD83DDE40U, },
 { 0xD83DDE3FU, },
 { 0xD83DDE3EU, },
 { 0xD83EDD32U, },
 { 0xD83DDC50U, },
 { 0xD83DDE4CU, },
 { 0xD83DDC4FU, },
 { 0xD83EDD1DU, },
 { 0xD83DDC4DU, },
 { 0xD83DDC4EU, },
 { 0xD83DDC4AU, },
 { 0x270AU, },
 { 0xD83EDD1BU, },
 { 0xD83EDD1CU, },
 { 0xD83EDD1EU, },
 { 0x270CU, 0xFE0FU, },
 { 0xD83EDD1FU, },
 { 0xD83EDD18U, },
 { 0xD83DDC4CU, },
 { 0xD83DDC48U, },
 { 0xD83DDC49U, },
 { 0xD83DDC46U, },
 { 0xD83DDC47U, },
 { 0x261DU, 0xFE0FU, },
 { 0x270BU, },
 { 0xD83EDD1AU, },
 { 0xD83DDD90U, },
 { 0xD83DDD96U, },
 { 0xD83DDC4BU, },
 { 0xD83EDD19U, },
 { 0xD83DDCAAU, },
 { 0xD83DDD95U, },
 { 0x270DU, 0xFE0FU, },
 { 0xD83DDE4FU, },
 { 0xD83EDDB6U, },
 { 0xD83EDDB5U, },
 { 0xD83DDC84U, },
 { 0xD83DDC8BU, },
 { 0xD83DDC44U, },
 { 0xD83EDDB7U, },
 { 0xD83DDC45U, },
 { 0xD83DDC42U, },
 { 0xD83DDC43U, },
 { 0xD83DDC63U, },
 { 0xD83DDC41U, },
 { 0xD83DDC40U, },
 { 0xD83EDDE0U, },
 { 0xD83DDDE3U, },
 { 0xD83DDC64U, },
 { 0xD83DDC65U, },
 { 0xD83DDC76U, },
 { 0xD83DDC67U, },
 { 0xD83EDDD2U, },
 { 0xD83DDC66U, },
 { 0xD83DDC69U, },
 { 0xD83EDDD1U, },
 { 0xD83DDC68U, },
 { 0xD83DDC69U, 0x200DU, 0xD83EDDB1U, },
 { 0xD83DDC68U, 0x200DU, 0xD83EDDB1U, },
 { 0xD83DDC69U, 0x200DU, 0xD83EDDB0U, },
 { 0xD83DDC68U, 0x200DU, 0xD83EDDB0U, },
 { 0xD83DDC71U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC71U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC69U, 0x200DU, 0xD83EDDB3U, },
 { 0xD83DDC68U, 0x200DU, 0xD83EDDB3U, },
 { 0xD83DDC69U, 0x200DU, 0xD83EDDB2U, },
 { 0xD83DDC68U, 0x200DU, 0xD83EDDB2U, },
 { 0xD83EDDD4U, },
 { 0xD83DDC75U, },
 { 0xD83EDDD3U, },
 { 0xD83DDC74U, },
 { 0xD83DDC72U, },
 { 0xD83DDC73U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC73U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDD5U, },
 { 0xD83DDC6EU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC6EU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC77U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC77U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC82U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC82U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDD75U, 0xFE0FU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDD75U, 0xFE0FU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC69U, 0x200DU, 0x2695U, 0xFE0FU, },
 { 0xD83DDC68U, 0x200DU, 0x2695U, 0xFE0FU, },
 { 0xD83DDC69U, 0x200DU, 0xD83CDF3EU, },
 { 0xD83DDC68U, 0x200DU, 0xD83CDF3EU, },
 { 0xD83DDC69U, 0x200DU, 0xD83CDF73U, },
 { 0xD83DDC68U, 0x200DU, 0xD83CDF73U, },
 { 0xD83DDC69U, 0x200DU, 0xD83CDF93U, },
 { 0xD83DDC68U, 0x200DU, 0xD83CDF93U, },
 { 0xD83DDC69U, 0x200DU, 0xD83CDFA4U, },
 { 0xD83DDC68U, 0x200DU, 0xD83CDFA4U, },
 { 0xD83DDC69U, 0x200DU, 0xD83CDFEBU, },
 { 0xD83DDC68U, 0x200DU, 0xD83CDFEBU, },
 { 0xD83DDC69U, 0x200DU, 0xD83CDFEDU, },
 { 0xD83DDC68U, 0x200DU, 0xD83CDFEDU, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDCBBU, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDCBBU, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDCBCU, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDCBCU, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDD27U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDD27U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDD2CU, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDD2CU, },
 { 0xD83DDC69U, 0x200DU, 0xD83CDFA8U, },
 { 0xD83DDC68U, 0x200DU, 0xD83CDFA8U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDE92U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDE92U, },
 { 0xD83DDC69U, 0x200DU, 0x2708U, 0xFE0FU, },
 { 0xD83DDC68U, 0x200DU, 0x2708U, 0xFE0FU, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDE80U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDE80U, },
 { 0xD83DDC69U, 0x200DU, 0x2696U, 0xFE0FU, },
 { 0xD83DDC68U, 0x200DU, 0x2696U, 0xFE0FU, },
 { 0xD83DDC70U, },
 { 0xD83EDD35U, },
 { 0xD83DDC78U, },
 { 0xD83EDD34U, },
 { 0xD83EDDB8U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDB8U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDB9U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDB9U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD36U, },
 { 0xD83CDF85U, },
 { 0xD83EDDD9U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDD9U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDDDU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDDDU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDDBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDDBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDDFU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDDFU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDDEU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDDEU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDDCU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDDCU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDDAU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDDAU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC7CU, },
 { 0xD83EDD30U, },
 { 0xD83EDD31U, },
 { 0xD83DDE47U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDE47U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC81U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC81U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE45U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDE45U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE46U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDE46U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE4BU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDE4BU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD26U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD26U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD37U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD37U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE4EU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDE4EU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE4DU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDE4DU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC87U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC87U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC86U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC86U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDD6U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDD6U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC85U, },
 { 0xD83EDD33U, },
 { 0xD83DDC83U, },
 { 0xD83DDD7AU, },
 { 0xD83DDC6FU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC6FU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDD74U, },
 { 0xD83DDEB6U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEB6U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFC3U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFC3U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC6BU, },
 { 0xD83DDC6DU, },
 { 0xD83DDC6CU, },
 { 0xD83DDC91U, },
 { 0xD83DDC69U, 0x200DU, 0x2764U, 0xFE0FU, 0x200DU, 0xD83DDC69U, },
 { 0xD83DDC68U, 0x200DU, 0x2764U, 0xFE0FU, 0x200DU, 0xD83DDC68U, },
 { 0xD83DDC8FU, },
 { 0xD83DDC69U, 0x200DU, 0x2764U, 0xFE0FU, 0x200DU, 0xD83DDC8BU, 0x200DU, 0xD83DDC69U, },
 { 0xD83DDC68U, 0x200DU, 0x2764U, 0xFE0FU, 0x200DU, 0xD83DDC8BU, 0x200DU, 0xD83DDC68U, },
 { 0xD83DDC6AU, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC66U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC66U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC68U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC68U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC68U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC68U, 0x200DU, 0xD83DDC66U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC68U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC66U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC66U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC67U, },
 { 0xD83EDDF6U, },
 { 0xD83EDDF5U, },
 { 0xD83EDDE5U, },
 { 0xD83EDD7CU, },
 { 0xD83DDC5AU, },
 { 0xD83DDC55U, },
 { 0xD83DDC56U, },
 { 0xD83DDC54U, },
 { 0xD83DDC57U, },
 { 0xD83DDC59U, },
 { 0xD83DDC58U, },
 { 0xD83EDD7FU, },
 { 0xD83DDC60U, },
 { 0xD83DDC61U, },
 { 0xD83DDC62U, },
 { 0xD83DDC5EU, },
 { 0xD83DDC5FU, },
 { 0xD83EDD7EU, },
 { 0xD83EDDE6U, },
 { 0xD83EDDE4U, },
 { 0xD83EDDE3U, },
 { 0xD83CDFA9U, },
 { 0xD83EDDE2U, },
 { 0xD83DDC52U, },
 { 0xD83CDF93U, },
 { 0x26D1U, },
 { 0xD83DDC51U, },
 { 0xD83DDC8DU, },
 { 0xD83DDC5DU, },
 { 0xD83DDC5BU, },
 { 0xD83DDC5CU, },
 { 0xD83DDCBCU, },
 { 0xD83CDF92U, },
 { 0xD83EDDF3U, },
 { 0xD83DDC53U, },
 { 0xD83DDD76U, },
 { 0xD83EDD7DU, },
 { 0xD83CDF02U, },
};

InputCategory Category2 = {
 { 0xD83DDC36U, },
 { 0xD83DDC31U, },
 { 0xD83DDC2DU, },
 { 0xD83DDC39U, },
 { 0xD83DDC30U, },
 { 0xD83EDD8AU, },
 { 0xD83DDC3BU, },
 { 0xD83DDC3CU, },
 { 0xD83DDC28U, },
 { 0xD83DDC2FU, },
 { 0xD83EDD81U, },
 { 0xD83DDC2EU, },
 { 0xD83DDC37U, },
 { 0xD83DDC3DU, },
 { 0xD83DDC38U, },
 { 0xD83DDC35U, },
 { 0xD83DDE48U, },
 { 0xD83DDE49U, },
 { 0xD83DDE4AU, },
 { 0xD83DDC12U, },
 { 0xD83DDC14U, },
 { 0xD83DDC27U, },
 { 0xD83DDC26U, },
 { 0xD83DDC24U, },
 { 0xD83DDC23U, },
 { 0xD83DDC25U, },
 { 0xD83EDD86U, },
 { 0xD83EDD85U, },
 { 0xD83EDD89U, },
 { 0xD83EDD87U, },
 { 0xD83DDC3AU, },
 { 0xD83DDC17U, },
 { 0xD83DDC34U, },
 { 0xD83EDD84U, },
 { 0xD83DDC1DU, },
 { 0xD83DDC1BU, },
 { 0xD83EDD8BU, },
 { 0xD83DDC0CU, },
 { 0xD83DDC1EU, },
 { 0xD83DDC1CU, },
 { 0xD83EDD9FU, },
 { 0xD83EDD97U, },
 { 0xD83DDD77U, },
 { 0xD83DDD78U, },
 { 0xD83EDD82U, },
 { 0xD83DDC22U, },
 { 0xD83DDC0DU, },
 { 0xD83EDD8EU, },
 { 0xD83EDD96U, },
 { 0xD83EDD95U, },
 { 0xD83DDC19U, },
 { 0xD83EDD91U, },
 { 0xD83EDD90U, },
 { 0xD83EDD9EU, },
 { 0xD83EDD80U, },
 { 0xD83DDC21U, },
 { 0xD83DDC20U, },
 { 0xD83DDC1FU, },
 { 0xD83DDC2CU, },
 { 0xD83DDC33U, },
 { 0xD83DDC0BU, },
 { 0xD83EDD88U, },
 { 0xD83DDC0AU, },
 { 0xD83DDC05U, },
 { 0xD83DDC06U, },
 { 0xD83EDD93U, },
 { 0xD83EDD8DU, },
 { 0xD83DDC18U, },
 { 0xD83EDD9BU, },
 { 0xD83EDD8FU, },
 { 0xD83DDC2AU, },
 { 0xD83DDC2BU, },
 { 0xD83EDD92U, },
 { 0xD83EDD98U, },
 { 0xD83DDC03U, },
 { 0xD83DDC02U, },
 { 0xD83DDC04U, },
 { 0xD83DDC0EU, },
 { 0xD83DDC16U, },
 { 0xD83DDC0FU, },
 { 0xD83DDC11U, },
 { 0xD83EDD99U, },
 { 0xD83DDC10U, },
 { 0xD83EDD8CU, },
 { 0xD83DDC15U, },
 { 0xD83DDC29U, },
 { 0xD83DDC08U, },
 { 0xD83DDC13U, },
 { 0xD83EDD83U, },
 { 0xD83EDD9AU, },
 { 0xD83EDD9CU, },
 { 0xD83EDDA2U, },
 { 0xD83DDD4AU, },
 { 0xD83DDC07U, },
 { 0xD83EDD9DU, },
 { 0xD83EDDA1U, },
 { 0xD83DDC01U, },
 { 0xD83DDC00U, },
 { 0xD83DDC3FU, },
 { 0xD83EDD94U, },
 { 0xD83DDC3EU, },
 { 0xD83DDC09U, },
 { 0xD83DDC32U, },
 { 0xD83CDF35U, },
 { 0xD83CDF84U, },
 { 0xD83CDF32U, },
 { 0xD83CDF33U, },
 { 0xD83CDF34U, },
 { 0xD83CDF31U, },
 { 0xD83CDF3FU, },
 { 0x2618U, 0xFE0FU, },
 { 0xD83CDF40U, },
 { 0xD83CDF8DU, },
 { 0xD83CDF8BU, },
 { 0xD83CDF43U, },
 { 0xD83CDF42U, },
 { 0xD83CDF41U, },
 { 0xD83CDF44U, },
 { 0xD83DDC1AU, },
 { 0xD83CDF3EU, },
 { 0xD83DDC90U, },
 { 0xD83CDF37U, },
 { 0xD83CDF39U, },
 { 0xD83EDD40U, },
 { 0xD83CDF3AU, },
 { 0xD83CDF38U, },
 { 0xD83CDF3CU, },
 { 0xD83CDF3BU, },
 { 0xD83CDF1EU, },
 { 0xD83CDF1DU, },
 { 0xD83CDF1BU, },
 { 0xD83CDF1CU, },
 { 0xD83CDF1AU, },
 { 0xD83CDF15U, },
 { 0xD83CDF16U, },
 { 0xD83CDF17U, },
 { 0xD83CDF18U, },
 { 0xD83CDF11U, },
 { 0xD83CDF12U, },
 { 0xD83CDF13U, },
 { 0xD83CDF14U, },
 { 0xD83CDF19U, },
 { 0xD83CDF0EU, },
 { 0xD83CDF0DU, },
 { 0xD83CDF0FU, },
 { 0xD83DDCABU, },
 { 0x2B50U, 0xFE0FU, },
 { 0xD83CDF1FU, },
 { 0x2728U, },
 { 0x26A1U, 0xFE0FU, },
 { 0x2604U, 0xFE0FU, },
 { 0xD83DDCA5U, },
 { 0xD83DDD25U, },
 { 0xD83CDF2AU, },
 { 0xD83CDF08U, },
 { 0x2600U, 0xFE0FU, },
 { 0xD83CDF24U, },
 { 0x26C5U, 0xFE0FU, },
 { 0xD83CDF25U, },
 { 0x2601U, 0xFE0FU, },
 { 0xD83CDF26U, },
 { 0xD83CDF27U, },
 { 0x26C8U, },
 { 0xD83CDF29U, },
 { 0xD83CDF28U, },
 { 0x2744U, 0xFE0FU, },
 { 0x2603U, 0xFE0FU, },
 { 0x26C4U, 0xFE0FU, },
 { 0xD83CDF2CU, },
 { 0xD83DDCA8U, },
 { 0xD83DDCA7U, },
 { 0xD83DDCA6U, },
 { 0x2614U, 0xFE0FU, },
 { 0x2602U, 0xFE0FU, },
 { 0xD83CDF0AU, },
 { 0xD83CDF2BU, },
};

InputCategory Category3 = {
 { 0xD83CDF4FU, },
 { 0xD83CDF4EU, },
 { 0xD83CDF50U, },
 { 0xD83CDF4AU, },
 { 0xD83CDF4BU, },
 { 0xD83CDF4CU, },
 { 0xD83CDF49U, },
 { 0xD83CDF47U, },
 { 0xD83CDF53U, },
 { 0xD83CDF48U, },
 { 0xD83CDF52U, },
 { 0xD83CDF51U, },
 { 0xD83EDD6DU, },
 { 0xD83CDF4DU, },
 { 0xD83EDD65U, },
 { 0xD83EDD5DU, },
 { 0xD83CDF45U, },
 { 0xD83CDF46U, },
 { 0xD83EDD51U, },
 { 0xD83EDD66U, },
 { 0xD83EDD6CU, },
 { 0xD83EDD52U, },
 { 0xD83CDF36U, },
 { 0xD83CDF3DU, },
 { 0xD83EDD55U, },
 { 0xD83EDD54U, },
 { 0xD83CDF60U, },
 { 0xD83EDD50U, },
 { 0xD83EDD6FU, },
 { 0xD83CDF5EU, },
 { 0xD83EDD56U, },
 { 0xD83EDD68U, },
 { 0xD83EDDC0U, },
 { 0xD83EDD5AU, },
 { 0xD83CDF73U, },
 { 0xD83EDD5EU, },
 { 0xD83EDD53U, },
 { 0xD83EDD69U, },
 { 0xD83CDF57U, },
 { 0xD83CDF56U, },
 { 0xD83EDDB4U, },
 { 0xD83CDF2DU, },
 { 0xD83CDF54U, },
 { 0xD83CDF5FU, },
 { 0xD83CDF55U, },
 { 0xD83EDD6AU, },
 { 0xD83EDD59U, },
 { 0xD83CDF2EU, },
 { 0xD83CDF2FU, },
 { 0xD83EDD57U, },
 { 0xD83EDD58U, },
 { 0xD83EDD6BU, },
 { 0xD83CDF5DU, },
 { 0xD83CDF5CU, },
 { 0xD83CDF72U, },
 { 0xD83CDF5BU, },
 { 0xD83CDF63U, },
 { 0xD83CDF71U, },
 { 0xD83EDD5FU, },
 { 0xD83CDF64U, },
 { 0xD83CDF59U, },
 { 0xD83CDF5AU, },
 { 0xD83CDF58U, },
 { 0xD83CDF65U, },
 { 0xD83EDD60U, },
 { 0xD83EDD6EU, },
 { 0xD83CDF62U, },
 { 0xD83CDF61U, },
 { 0xD83CDF67U, },
 { 0xD83CDF68U, },
 { 0xD83CDF66U, },
 { 0xD83EDD67U, },
 { 0xD83EDDC1U, },
 { 0xD83CDF70U, },
 { 0xD83CDF82U, },
 { 0xD83CDF6EU, },
 { 0xD83CDF6DU, },
 { 0xD83CDF6CU, },
 { 0xD83CDF6BU, },
 { 0xD83CDF7FU, },
 { 0xD83CDF69U, },
 { 0xD83CDF6AU, },
 { 0xD83CDF30U, },
 { 0xD83EDD5CU, },
 { 0xD83CDF6FU, },
 { 0xD83EDD5BU, },
 { 0xD83CDF7CU, },
 { 0x2615U, 0xFE0FU, },
 { 0xD83CDF75U, },
 { 0xD83EDD64U, },
 { 0xD83CDF76U, },
 { 0xD83CDF7AU, },
 { 0xD83CDF7BU, },
 { 0xD83EDD42U, },
 { 0xD83CDF77U, },
 { 0xD83EDD43U, },
 { 0xD83CDF78U, },
 { 0xD83CDF79U, },
 { 0xD83CDF7EU, },
 { 0xD83EDD44U, },
 { 0xD83CDF74U, },
 { 0xD83CDF7DU, },
 { 0xD83EDD63U, },
 { 0xD83EDD61U, },
 { 0xD83EDD62U, },
 { 0xD83EDDC2U, },
};

InputCategory Category4 = {
 { 0x26BDU, 0xFE0FU, },
 { 0xD83CDFC0U, },
 { 0xD83CDFC8U, },
 { 0x26BEU, 0xFE0FU, },
 { 0xD83EDD4EU, },
 { 0xD83CDFBEU, },
 { 0xD83CDFD0U, },
 { 0xD83CDFC9U, },
 { 0xD83EDD4FU, },
 { 0xD83CDFB1U, },
 { 0xD83CDFD3U, },
 { 0xD83CDFF8U, },
 { 0xD83CDFD2U, },
 { 0xD83CDFD1U, },
 { 0xD83EDD4DU, },
 { 0xD83CDFCFU, },
 { 0xD83EDD45U, },
 { 0x26F3U, 0xFE0FU, },
 { 0xD83CDFF9U, },
 { 0xD83CDFA3U, },
 { 0xD83EDD4AU, },
 { 0xD83EDD4BU, },
 { 0xD83CDFBDU, },
 { 0xD83DDEF9U, },
 { 0xD83DDEF7U, },
 { 0x26F8U, },
 { 0xD83EDD4CU, },
 { 0xD83CDFBFU, },
 { 0x26F7U, },
 { 0xD83CDFC2U, },
 { 0xD83CDFCBU, 0xFE0FU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFCBU, 0xFE0FU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD3CU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD3CU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD38U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD38U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0x26F9U, 0xFE0FU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0x26F9U, 0xFE0FU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD3AU, },
 { 0xD83EDD3EU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD3EU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFCCU, 0xFE0FU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFCCU, 0xFE0FU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFC7U, },
 { 0xD83EDDD8U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDD8U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFC4U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFC4U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFCAU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFCAU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD3DU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD3DU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDEA3U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEA3U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDDD7U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDDD7U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDEB5U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEB5U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDEB4U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEB4U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFC6U, },
 { 0xD83EDD47U, },
 { 0xD83EDD48U, },
 { 0xD83EDD49U, },
 { 0xD83CDFC5U, },
 { 0xD83CDF96U, },
 { 0xD83CDFF5U, },
 { 0xD83CDF97U, },
 { 0xD83CDFABU, },
 { 0xD83CDF9FU, },
 { 0xD83CDFAAU, },
 { 0xD83EDD39U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD39U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFADU, },
 { 0xD83CDFA8U, },
 { 0xD83CDFACU, },
 { 0xD83CDFA4U, },
 { 0xD83CDFA7U, },
 { 0xD83CDFBCU, },
 { 0xD83CDFB9U, },
 { 0xD83EDD41U, },
 { 0xD83CDFB7U, },
 { 0xD83CDFBAU, },
 { 0xD83CDFB8U, },
 { 0xD83CDFBBU, },
 { 0xD83CDFB2U, },
 { 0x265FU, },
 { 0xD83CDFAFU, },
 { 0xD83CDFB3U, },
 { 0xD83CDFAEU, },
 { 0xD83CDFB0U, },
 { 0xD83EDDE9U, },
};

InputCategory Category5 = {
 { 0xD83DDE97U, },
 { 0xD83DDE95U, },
 { 0xD83DDE99U, },
 { 0xD83DDE8CU, },
 { 0xD83DDE8EU, },
 { 0xD83CDFCEU, },
 { 0xD83DDE93U, },
 { 0xD83DDE91U, },
 { 0xD83DDE92U, },
 { 0xD83DDE90U, },
 { 0xD83DDE9AU, },
 { 0xD83DDE9BU, },
 { 0xD83DDE9CU, },
 { 0xD83DDEF4U, },
 { 0xD83DDEB2U, },
 { 0xD83DDEF5U, },
 { 0xD83CDFCDU, },
 { 0xD83DDEA8U, },
 { 0xD83DDE94U, },
 { 0xD83DDE8DU, },
 { 0xD83DDE98U, },
 { 0xD83DDE96U, },
 { 0xD83DDEA1U, },
 { 0xD83DDEA0U, },
 { 0xD83DDE9FU, },
 { 0xD83DDE83U, },
 { 0xD83DDE8BU, },
 { 0xD83DDE9EU, },
 { 0xD83DDE9DU, },
 { 0xD83DDE84U, },
 { 0xD83DDE85U, },
 { 0xD83DDE88U, },
 { 0xD83DDE82U, },
 { 0xD83DDE86U, },
 { 0xD83DDE87U, },
 { 0xD83DDE8AU, },
 { 0xD83DDE89U, },
 { 0x2708U, 0xFE0FU, },
 { 0xD83DDEEBU, },
 { 0xD83DDEECU, },
 { 0xD83DDEE9U, },
 { 0xD83DDCBAU, },
 { 0xD83DDEF0U, },
 { 0xD83DDE80U, },
 { 0xD83DDEF8U, },
 { 0xD83DDE81U, },
 { 0xD83DDEF6U, },
 { 0x26F5U, 0xFE0FU, },
 { 0xD83DDEA4U, },
 { 0xD83DDEE5U, },
 { 0xD83DDEF3U, },
 { 0x26F4U, },
 { 0xD83DDEA2U, },
 { 0x2693U, 0xFE0FU, },
 { 0x26FDU, 0xFE0FU, },
 { 0xD83DDEA7U, },
 { 0xD83DDEA6U, },
 { 0xD83DDEA5U, },
 { 0xD83DDE8FU, },
 { 0xD83DDDFAU, },
 { 0xD83DDDFFU, },
 { 0xD83DDDFDU, },
 { 0xD83DDDFCU, },
 { 0xD83CDFF0U, },
 { 0xD83CDFEFU, },
 { 0xD83CDFDFU, },
 { 0xD83CDFA1U, },
 { 0xD83CDFA2U, },
 { 0xD83CDFA0U, },
 { 0x26F2U, 0xFE0FU, },
 { 0x26F1U, },
 { 0xD83CDFD6U, },
 { 0xD83CDFDDU, },
 { 0xD83CDFDCU, },
 { 0xD83CDF0BU, },
 { 0x26F0U, },
 { 0xD83CDFD4U, },
 { 0xD83DDDFBU, },
 { 0xD83CDFD5U, },
 { 0x26FAU, 0xFE0FU, },
 { 0xD83CDFE0U, },
 { 0xD83CDFE1U, },
 { 0xD83CDFD8U, },
 { 0xD83CDFDAU, },
 { 0xD83CDFD7U, },
 { 0xD83CDFEDU, },
 { 0xD83CDFE2U, },
 { 0xD83CDFECU, },
 { 0xD83CDFE3U, },
 { 0xD83CDFE4U, },
 { 0xD83CDFE5U, },
 { 0xD83CDFE6U, },
 { 0xD83CDFE8U, },
 { 0xD83CDFEAU, },
 { 0xD83CDFEBU, },
 { 0xD83CDFE9U, },
 { 0xD83DDC92U, },
 { 0xD83CDFDBU, },
 { 0x26EAU, 0xFE0FU, },
 { 0xD83DDD4CU, },
 { 0xD83DDD4DU, },
 { 0xD83DDD4BU, },
 { 0x26E9U, },
 { 0xD83DDEE4U, },
 { 0xD83DDEE3U, },
 { 0xD83DDDFEU, },
 { 0xD83CDF91U, },
 { 0xD83CDFDEU, },
 { 0xD83CDF05U, },
 { 0xD83CDF04U, },
 { 0xD83CDF20U, },
 { 0xD83CDF87U, },
 { 0xD83CDF86U, },
 { 0xD83CDF07U, },
 { 0xD83CDF06U, },
 { 0xD83CDFD9U, },
 { 0xD83CDF03U, },
 { 0xD83CDF0CU, },
 { 0xD83CDF09U, },
 { 0xD83CDF01U, },
};

InputCategory Category6 = {
 { 0x231AU, 0xFE0FU, },
 { 0xD83DDCF1U, },
 { 0xD83DDCF2U, },
 { 0xD83DDCBBU, },
 { 0x2328U, 0xFE0FU, },
 { 0xD83DDDA5U, },
 { 0xD83DDDA8U, },
 { 0xD83DDDB1U, },
 { 0xD83DDDB2U, },
 { 0xD83DDD79U, },
 { 0xD83DDDDCU, },
 { 0xD83DDCBDU, },
 { 0xD83DDCBEU, },
 { 0xD83DDCBFU, },
 { 0xD83DDCC0U, },
 { 0xD83DDCFCU, },
 { 0xD83DDCF7U, },
 { 0xD83DDCF8U, },
 { 0xD83DDCF9U, },
 { 0xD83CDFA5U, },
 { 0xD83DDCFDU, },
 { 0xD83CDF9EU, },
 { 0xD83DDCDEU, },
 { 0x260EU, 0xFE0FU, },
 { 0xD83DDCDFU, },
 { 0xD83DDCE0U, },
 { 0xD83DDCFAU, },
 { 0xD83DDCFBU, },
 { 0xD83CDF99U, },
 { 0xD83CDF9AU, },
 { 0xD83CDF9BU, },
 { 0xD83EDDEDU, },
 { 0x23F1U, },
 { 0x23F2U, },
 { 0x23F0U, },
 { 0xD83DDD70U, },
 { 0x231BU, 0xFE0FU, },
 { 0x23F3U, },
 { 0xD83DDCE1U, },
 { 0xD83DDD0BU, },
 { 0xD83DDD0CU, },
 { 0xD83DDCA1U, },
 { 0xD83DDD26U, },
 { 0xD83DDD6FU, },
 { 0xD83EDDEFU, },
 { 0xD83DDEE2U, },
 { 0xD83DDCB8U, },
 { 0xD83DDCB5U, },
 { 0xD83DDCB4U, },
 { 0xD83DDCB6U, },
 { 0xD83DDCB7U, },
 { 0xD83DDCB0U, },
 { 0xD83DDCB3U, },
 { 0xD83DDC8EU, },
 { 0x2696U, 0xFE0FU, },
 { 0xD83EDDF0U, },
 { 0xD83DDD27U, },
 { 0xD83DDD28U, },
 { 0x2692U, },
 { 0xD83DDEE0U, },
 { 0x26CFU, },
 { 0xD83DDD29U, },
 { 0x2699U, 0xFE0FU, },
 { 0xD83EDDF1U, },
 { 0x26D3U, },
 { 0xD83EDDF2U, },
 { 0xD83DDD2BU, },
 { 0xD83DDCA3U, },
 { 0xD83EDDE8U, },
 { 0xD83DDD2AU, },
 { 0xD83DDDE1U, },
 { 0x2694U, 0xFE0FU, },
 { 0xD83DDEE1U, },
 { 0xD83DDEACU, },
 { 0x26B0U, 0xFE0FU, },
 { 0x26B1U, 0xFE0FU, },
 { 0xD83CDFFAU, },
 { 0xD83DDD2EU, },
 { 0xD83DDCFFU, },
 { 0xD83EDDFFU, },
 { 0xD83DDC88U, },
 { 0x2697U, 0xFE0FU, },
 { 0xD83DDD2DU, },
 { 0xD83DDD2CU, },
 { 0xD83DDD73U, },
 { 0xD83DDC8AU, },
 { 0xD83DDC89U, },
 { 0xD83EDDECU, },
 { 0xD83EDDA0U, },
 { 0xD83EDDEBU, },
 { 0xD83EDDEAU, },
 { 0xD83CDF21U, },
 { 0xD83EDDF9U, },
 { 0xD83EDDFAU, },
 { 0xD83EDDFBU, },
 { 0xD83DDEBDU, },
 { 0xD83DDEB0U, },
 { 0xD83DDEBFU, },
 { 0xD83DDEC1U, },
 { 0xD83DDEC0U, },
 { 0xD83EDDFCU, },
 { 0xD83EDDFDU, },
 { 0xD83EDDF4U, },
 { 0xD83DDECEU, },
 { 0xD83DDD11U, },
 { 0xD83DDDDDU, },
 { 0xD83DDEAAU, },
 { 0xD83DDECBU, },
 { 0xD83DDECFU, },
 { 0xD83DDECCU, },
 { 0xD83EDDF8U, },
 { 0xD83DDDBCU, },
 { 0xD83DDECDU, },
 { 0xD83DDED2U, },
 { 0xD83CDF81U, },
 { 0xD83CDF88U, },
 { 0xD83CDF8FU, },
 { 0xD83CDF80U, },
 { 0xD83CDF8AU, },
 { 0xD83CDF89U, },
 { 0xD83CDF8EU, },
 { 0xD83CDFEEU, },
 { 0xD83CDF90U, },
 { 0xD83EDDE7U, },
 { 0x2709U, 0xFE0FU, },
 { 0xD83DDCE9U, },
 { 0xD83DDCE8U, },
 { 0xD83DDCE7U, },
 { 0xD83DDC8CU, },
 { 0xD83DDCE5U, },
 { 0xD83DDCE4U, },
 { 0xD83DDCE6U, },
 { 0xD83CDFF7U, },
 { 0xD83DDCEAU, },
 { 0xD83DDCEBU, },
 { 0xD83DDCECU, },
 { 0xD83DDCEDU, },
 { 0xD83DDCEEU, },
 { 0xD83DDCEFU, },
 { 0xD83DDCDCU, },
 { 0xD83DDCC3U, },
 { 0xD83DDCC4U, },
 { 0xD83DDCD1U, },
 { 0xD83EDDFEU, },
 { 0xD83DDCCAU, },
 { 0xD83DDCC8U, },
 { 0xD83DDCC9U, },
 { 0xD83DDDD2U, },
 { 0xD83DDDD3U, },
 { 0xD83DDCC6U, },
 { 0xD83DDCC5U, },
 { 0xD83DDDD1U, },
 { 0xD83DDCC7U, },
 { 0xD83DDDC3U, },
 { 0xD83DDDF3U, },
 { 0xD83DDDC4U, },
 { 0xD83DDCCBU, },
 { 0xD83DDCC1U, },
 { 0xD83DDCC2U, },
 { 0xD83DDDC2U, },
 { 0xD83DDDDEU, },
 { 0xD83DDCF0U, },
 { 0xD83DDCD3U, },
 { 0xD83DDCD4U, },
 { 0xD83DDCD2U, },
 { 0xD83DDCD5U, },
 { 0xD83DDCD7U, },
 { 0xD83DDCD8U, },
 { 0xD83DDCD9U, },
 { 0xD83DDCDAU, },
 { 0xD83DDCD6U, },
 { 0xD83DDD16U, },
 { 0xD83EDDF7U, },
 { 0xD83DDD17U, },
 { 0xD83DDCCEU, },
 { 0xD83DDD87U, },
 { 0xD83DDCD0U, },
 { 0xD83DDCCFU, },
 { 0xD83EDDEEU, },
 { 0xD83DDCCCU, },
 { 0xD83DDCCDU, },
 { 0x2702U, 0xFE0FU, },
 { 0xD83DDD8AU, },
 { 0xD83DDD8BU, },
 { 0x2712U, 0xFE0FU, },
 { 0xD83DDD8CU, },
 { 0xD83DDD8DU, },
 { 0xD83DDCDDU, },
 { 0x270FU, 0xFE0FU, },
 { 0xD83DDD0DU, },
 { 0xD83DDD0EU, },
 { 0xD83DDD0FU, },
 { 0xD83DDD10U, },
 { 0xD83DDD12U, },
 { 0xD83DDD13U, },
};

InputCategory Category7 = {
 { 0x2764U, 0xFE0FU, },
 { 0xD83EDDE1U, },
 { 0xD83DDC9BU, },
 { 0xD83DDC9AU, },
 { 0xD83DDC99U, },
 { 0xD83DDC9CU, },
 { 0xD83DDDA4U, },
 { 0xD83DDC94U, },
 { 0x2763U, 0xFE0FU, },
 { 0xD83DDC95U, },
 { 0xD83DDC9EU, },
 { 0xD83DDC93U, },
 { 0xD83DDC97U, },
 { 0xD83DDC96U, },
 { 0xD83DDC98U, },
 { 0xD83DDC9DU, },
 { 0xD83DDC9FU, },
 { 0x262EU, 0xFE0FU, },
 { 0x271DU, 0xFE0FU, },
 { 0x262AU, 0xFE0FU, },
 { 0xD83DDD49U, },
 { 0x2638U, 0xFE0FU, },
 { 0x2721U, 0xFE0FU, },
 { 0xD83DDD2FU, },
 { 0xD83DDD4EU, },
 { 0x262FU, 0xFE0FU, },
 { 0x2626U, 0xFE0FU, },
 { 0xD83DDED0U, },
 { 0x26CEU, },
 { 0x2648U, 0xFE0FU, },
 { 0x2649U, 0xFE0FU, },
 { 0x264AU, 0xFE0FU, },
 { 0x264BU, 0xFE0FU, },
 { 0x264CU, 0xFE0FU, },
 { 0x264DU, 0xFE0FU, },
 { 0x264EU, 0xFE0FU, },
 { 0x264FU, 0xFE0FU, },
 { 0x2650U, 0xFE0FU, },
 { 0x2651U, 0xFE0FU, },
 { 0x2652U, 0xFE0FU, },
 { 0x2653U, 0xFE0FU, },
 { 0xD83CDD94U, },
 { 0x269BU, 0xFE0FU, },
 { 0xD83CDE51U, },
 { 0x2622U, 0xFE0FU, },
 { 0x2623U, 0xFE0FU, },
 { 0xD83DDCF4U, },
 { 0xD83DDCF3U, },
 { 0xD83CDE36U, },
 { 0xD83CDE1AU, 0xFE0FU, },
 { 0xD83CDE38U, },
 { 0xD83CDE3AU, },
 { 0xD83CDE37U, 0xFE0FU, },
 { 0x2734U, 0xFE0FU, },
 { 0xD83CDD9AU, },
 { 0xD83DDCAEU, },
 { 0xD83CDE50U, },
 { 0x3299U, 0xFE0FU, },
 { 0x3297U, 0xFE0FU, },
 { 0xD83CDE34U, },
 { 0xD83CDE35U, },
 { 0xD83CDE39U, },
 { 0xD83CDE32U, },
 { 0xD83CDD70U, 0xFE0FU, },
 { 0xD83CDD71U, 0xFE0FU, },
 { 0xD83CDD8EU, },
 { 0xD83CDD91U, },
 { 0xD83CDD7EU, 0xFE0FU, },
 { 0xD83CDD98U, },
 { 0x274CU, },
 { 0x2B55U, 0xFE0FU, },
 { 0xD83DDED1U, },
 { 0x26D4U, 0xFE0FU, },
 { 0xD83DDCDBU, },
 { 0xD83DDEABU, },
 { 0xD83DDCAFU, },
 { 0xD83DDCA2U, },
 { 0x2668U, 0xFE0FU, },
 { 0xD83DDEB7U, },
 { 0xD83DDEAFU, },
 { 0xD83DDEB3U, },
 { 0xD83DDEB1U, },
 { 0xD83DDD1EU, },
 { 0xD83DDCF5U, },
 { 0xD83DDEADU, },
 { 0x2757U, 0xFE0FU, },
 { 0x2755U, },
 { 0x2753U, },
 { 0x2754U, },
 { 0x203CU, 0xFE0FU, },
 { 0x2049U, 0xFE0FU, },
 { 0xD83DDD05U, },
 { 0xD83DDD06U, },
 { 0x303DU, 0xFE0FU, },
 { 0x26A0U, 0xFE0FU, },
 { 0xD83DDEB8U, },
 { 0xD83DDD31U, },
 { 0x269CU, 0xFE0FU, },
 { 0xD83DDD30U, },
 { 0x267BU, 0xFE0FU, },
 { 0x2705U, },
 { 0xD83CDE2FU, 0xFE0FU, },
 { 0xD83DDCB9U, },
 { 0x2747U, 0xFE0FU, },
 { 0x2733U, 0xFE0FU, },
 { 0x274EU, },
 { 0xD83CDF10U, },
 { 0xD83DDCA0U, },
 { 0x24C2U, 0xFE0FU, },
 { 0xD83CDF00U, },
 { 0xD83DDCA4U, },
 { 0xD83CDFE7U, },
 { 0xD83DDEBEU, },
 { 0x267FU, 0xFE0FU, },
 { 0xD83CDD7FU, 0xFE0FU, },
 { 0xD83CDE33U, },
 { 0xD83CDE02U, 0xFE0FU, },
 { 0xD83DDEC2U, },
 { 0xD83DDEC3U, },
 { 0xD83DDEC4U, },
 { 0xD83DDEC5U, },
 { 0xD83DDEB9U, },
 { 0xD83DDEBAU, },
 { 0xD83DDEBCU, },
 { 0xD83DDEBBU, },
 { 0xD83DDEAEU, },
 { 0xD83CDFA6U, },
 { 0xD83DDCF6U, },
 { 0xD83CDE01U, },
 { 0xD83DDD23U, },
 { 0x2139U, 0xFE0FU, },
 { 0xD83DDD24U, },
 { 0xD83DDD21U, },
 { 0xD83DDD20U, },
 { 0xD83CDD96U, },
 { 0xD83CDD97U, },
 { 0xD83CDD99U, },
 { 0xD83CDD92U, },
 { 0xD83CDD95U, },
 { 0xD83CDD93U, },
 { 0x30U, 0xFE0FU, 0x20E3U, },
 { 0x31U, 0xFE0FU, 0x20E3U, },
 { 0x32U, 0xFE0FU, 0x20E3U, },
 { 0x33U, 0xFE0FU, 0x20E3U, },
 { 0x34U, 0xFE0FU, 0x20E3U, },
 { 0x35U, 0xFE0FU, 0x20E3U, },
 { 0x36U, 0xFE0FU, 0x20E3U, },
 { 0x37U, 0xFE0FU, 0x20E3U, },
 { 0x38U, 0xFE0FU, 0x20E3U, },
 { 0x39U, 0xFE0FU, 0x20E3U, },
 { 0xD83DDD1FU, },
 { 0xD83DDD22U, },
 { 0x23U, 0xFE0FU, 0x20E3U, },
 { 0x2AU, 0xFE0FU, 0x20E3U, },
 { 0x23CFU, 0xFE0FU, },
 { 0x25B6U, 0xFE0FU, },
 { 0x23F8U, },
 { 0x23EFU, },
 { 0x23F9U, },
 { 0x23FAU, },
 { 0x23EDU, },
 { 0x23EEU, },
 { 0x23E9U, },
 { 0x23EAU, },
 { 0x23EBU, },
 { 0x23ECU, },
 { 0x25C0U, 0xFE0FU, },
 { 0xD83DDD3CU, },
 { 0xD83DDD3DU, },
 { 0x27A1U, 0xFE0FU, },
 { 0x2B05U, 0xFE0FU, },
 { 0x2B06U, 0xFE0FU, },
 { 0x2B07U, 0xFE0FU, },
 { 0x2197U, 0xFE0FU, },
 { 0x2198U, 0xFE0FU, },
 { 0x2199U, 0xFE0FU, },
 { 0x2196U, 0xFE0FU, },
 { 0x2195U, 0xFE0FU, },
 { 0x2194U, 0xFE0FU, },
 { 0x21AAU, 0xFE0FU, },
 { 0x21A9U, 0xFE0FU, },
 { 0x2934U, 0xFE0FU, },
 { 0x2935U, 0xFE0FU, },
 { 0xD83DDD00U, },
 { 0xD83DDD01U, },
 { 0xD83DDD02U, },
 { 0xD83DDD04U, },
 { 0xD83DDD03U, },
 { 0xD83CDFB5U, },
 { 0xD83CDFB6U, },
 { 0x2795U, },
 { 0x2796U, },
 { 0x2797U, },
 { 0x2716U, 0xFE0FU, },
 { 0x267EU, },
 { 0xD83DDCB2U, },
 { 0xD83DDCB1U, },
 { 0x2122U, 0xFE0FU, },
 { 0xA9U, 0xFE0FU, },
 { 0xAEU, 0xFE0FU, },
 { 0xD83DDC41U, 0x200DU, 0xD83DDDE8U, },
 { 0xD83DDD1AU, },
 { 0xD83DDD19U, },
 { 0xD83DDD1BU, },
 { 0xD83DDD1DU, },
 { 0xD83DDD1CU, },
 { 0x3030U, 0xFE0FU, },
 { 0x27B0U, },
 { 0x27BFU, },
 { 0x2714U, 0xFE0FU, },
 { 0x2611U, 0xFE0FU, },
 { 0xD83DDD18U, },
 { 0x26AAU, 0xFE0FU, },
 { 0x26ABU, 0xFE0FU, },
 { 0xD83DDD34U, },
 { 0xD83DDD35U, },
 { 0xD83DDD3AU, },
 { 0xD83DDD3BU, },
 { 0xD83DDD38U, },
 { 0xD83DDD39U, },
 { 0xD83DDD36U, },
 { 0xD83DDD37U, },
 { 0xD83DDD33U, },
 { 0xD83DDD32U, },
 { 0x25AAU, 0xFE0FU, },
 { 0x25ABU, 0xFE0FU, },
 { 0x25FEU, 0xFE0FU, },
 { 0x25FDU, 0xFE0FU, },
 { 0x25FCU, 0xFE0FU, },
 { 0x25FBU, 0xFE0FU, },
 { 0x2B1BU, 0xFE0FU, },
 { 0x2B1CU, 0xFE0FU, },
 { 0xD83DDD08U, },
 { 0xD83DDD07U, },
 { 0xD83DDD09U, },
 { 0xD83DDD0AU, },
 { 0xD83DDD14U, },
 { 0xD83DDD15U, },
 { 0xD83DDCE3U, },
 { 0xD83DDCE2U, },
 { 0xD83DDCACU, },
 { 0xD83DDCADU, },
 { 0xD83DDDEFU, },
 { 0x2660U, 0xFE0FU, },
 { 0x2663U, 0xFE0FU, },
 { 0x2665U, 0xFE0FU, },
 { 0x2666U, 0xFE0FU, },
 { 0xD83CDCCFU, },
 { 0xD83CDFB4U, },
 { 0xD83CDC04U, 0xFE0FU, },
 { 0xD83DDD50U, },
 { 0xD83DDD51U, },
 { 0xD83DDD52U, },
 { 0xD83DDD53U, },
 { 0xD83DDD54U, },
 { 0xD83DDD55U, },
 { 0xD83DDD56U, },
 { 0xD83DDD57U, },
 { 0xD83DDD58U, },
 { 0xD83DDD59U, },
 { 0xD83DDD5AU, },
 { 0xD83DDD5BU, },
 { 0xD83DDD5CU, },
 { 0xD83DDD5DU, },
 { 0xD83DDD5EU, },
 { 0xD83DDD5FU, },
 { 0xD83DDD60U, },
 { 0xD83DDD61U, },
 { 0xD83DDD62U, },
 { 0xD83DDD63U, },
 { 0xD83DDD64U, },
 { 0xD83DDD65U, },
 { 0xD83DDD66U, },
 { 0xD83DDD67U, },

//};
//
//InputCategory Category8 = {

 { 0xD83CDFF3U, 0xFE0FU, },
 { 0xD83CDFF4U, },
 { 0xD83CDFF4U, 0x200DU, 0x2620U, 0xFE0FU, },
 { 0xD83CDFC1U, },
 { 0xD83DDEA9U, },
 { 0xD83CDFF3U, 0xFE0FU, 0x200DU, 0xD83CDF08U, },
 { 0xD83CDDFAU, 0xD83CDDF3U, },
 { 0xD83CDDE6U, 0xD83CDDEBU, },
 { 0xD83CDDE6U, 0xD83CDDFDU, },
 { 0xD83CDDE6U, 0xD83CDDF1U, },
 { 0xD83CDDE9U, 0xD83CDDFFU, },
 { 0xD83CDDE6U, 0xD83CDDF8U, },
 { 0xD83CDDE6U, 0xD83CDDE9U, },
 { 0xD83CDDE6U, 0xD83CDDF4U, },
 { 0xD83CDDE6U, 0xD83CDDEEU, },
 { 0xD83CDDE6U, 0xD83CDDF6U, },
 { 0xD83CDDE6U, 0xD83CDDECU, },
 { 0xD83CDDE6U, 0xD83CDDF7U, },
 { 0xD83CDDE6U, 0xD83CDDF2U, },
 { 0xD83CDDE6U, 0xD83CDDFCU, },
 { 0xD83CDDE6U, 0xD83CDDFAU, },
 { 0xD83CDDE6U, 0xD83CDDF9U, },
 { 0xD83CDDE6U, 0xD83CDDFFU, },
 { 0xD83CDDE7U, 0xD83CDDF8U, },
 { 0xD83CDDE7U, 0xD83CDDEDU, },
 { 0xD83CDDE7U, 0xD83CDDE9U, },
 { 0xD83CDDE7U, 0xD83CDDE7U, },
 { 0xD83CDDE7U, 0xD83CDDFEU, },
 { 0xD83CDDE7U, 0xD83CDDEAU, },
 { 0xD83CDDE7U, 0xD83CDDFFU, },
 { 0xD83CDDE7U, 0xD83CDDEFU, },
 { 0xD83CDDE7U, 0xD83CDDF2U, },
 { 0xD83CDDE7U, 0xD83CDDF9U, },
 { 0xD83CDDE7U, 0xD83CDDF4U, },
 { 0xD83CDDE7U, 0xD83CDDE6U, },
 { 0xD83CDDE7U, 0xD83CDDFCU, },
 { 0xD83CDDE7U, 0xD83CDDF7U, },
 { 0xD83CDDEEU, 0xD83CDDF4U, },
 { 0xD83CDDFBU, 0xD83CDDECU, },
 { 0xD83CDDE7U, 0xD83CDDF3U, },
 { 0xD83CDDE7U, 0xD83CDDECU, },
 { 0xD83CDDE7U, 0xD83CDDEBU, },
 { 0xD83CDDE7U, 0xD83CDDEEU, },
 { 0xD83CDDF0U, 0xD83CDDEDU, },
 { 0xD83CDDE8U, 0xD83CDDF2U, },
 { 0xD83CDDE8U, 0xD83CDDE6U, },
 { 0xD83CDDEEU, 0xD83CDDE8U, },
 { 0xD83CDDE8U, 0xD83CDDFBU, },
 { 0xD83CDDE7U, 0xD83CDDF6U, },
 { 0xD83CDDF0U, 0xD83CDDFEU, },
 { 0xD83CDDE8U, 0xD83CDDEBU, },
 { 0xD83CDDF9U, 0xD83CDDE9U, },
 { 0xD83CDDE8U, 0xD83CDDF1U, },
 { 0xD83CDDE8U, 0xD83CDDF3U, },
 { 0xD83CDDE8U, 0xD83CDDFDU, },
 { 0xD83CDDE8U, 0xD83CDDE8U, },
 { 0xD83CDDE8U, 0xD83CDDF4U, },
 { 0xD83CDDF0U, 0xD83CDDF2U, },
 { 0xD83CDDE8U, 0xD83CDDECU, },
 { 0xD83CDDE8U, 0xD83CDDE9U, },
 { 0xD83CDDE8U, 0xD83CDDF0U, },
 { 0xD83CDDE8U, 0xD83CDDF7U, },
 { 0xD83CDDE8U, 0xD83CDDEEU, },
 { 0xD83CDDEDU, 0xD83CDDF7U, },
 { 0xD83CDDE8U, 0xD83CDDFAU, },
 { 0xD83CDDE8U, 0xD83CDDFCU, },
 { 0xD83CDDE8U, 0xD83CDDFEU, },
 { 0xD83CDDE8U, 0xD83CDDFFU, },
 { 0xD83CDDE9U, 0xD83CDDF0U, },
 { 0xD83CDDE9U, 0xD83CDDEFU, },
 { 0xD83CDDE9U, 0xD83CDDF2U, },
 { 0xD83CDDE9U, 0xD83CDDF4U, },
 { 0xD83CDDEAU, 0xD83CDDE8U, },
 { 0xD83CDDEAU, 0xD83CDDECU, },
 { 0xD83CDDF8U, 0xD83CDDFBU, },
 { 0xD83CDDECU, 0xD83CDDF6U, },
 { 0xD83CDDEAU, 0xD83CDDF7U, },
 { 0xD83CDDEAU, 0xD83CDDEAU, },
 { 0xD83CDDEAU, 0xD83CDDF9U, },
 { 0xD83CDDEAU, 0xD83CDDFAU, },
 { 0xD83CDDEBU, 0xD83CDDF0U, },
 { 0xD83CDDEBU, 0xD83CDDF4U, },
 { 0xD83CDDEBU, 0xD83CDDEFU, },
 { 0xD83CDDEBU, 0xD83CDDEEU, },
 { 0xD83CDDEBU, 0xD83CDDF7U, },
 { 0xD83CDDECU, 0xD83CDDEBU, },
 { 0xD83CDDF5U, 0xD83CDDEBU, },
 { 0xD83CDDF9U, 0xD83CDDEBU, },
 { 0xD83CDDECU, 0xD83CDDE6U, },
 { 0xD83CDDECU, 0xD83CDDF2U, },
 { 0xD83CDDECU, 0xD83CDDEAU, },
 { 0xD83CDDE9U, 0xD83CDDEAU, },
 { 0xD83CDDECU, 0xD83CDDEDU, },
 { 0xD83CDDECU, 0xD83CDDEEU, },
 { 0xD83CDDECU, 0xD83CDDF7U, },
 { 0xD83CDDECU, 0xD83CDDF1U, },
 { 0xD83CDDECU, 0xD83CDDE9U, },
 { 0xD83CDDECU, 0xD83CDDF5U, },
 { 0xD83CDDECU, 0xD83CDDFAU, },
 { 0xD83CDDECU, 0xD83CDDF9U, },
 { 0xD83CDDECU, 0xD83CDDECU, },
 { 0xD83CDDECU, 0xD83CDDF3U, },
 { 0xD83CDDECU, 0xD83CDDFCU, },
 { 0xD83CDDECU, 0xD83CDDFEU, },
 { 0xD83CDDEDU, 0xD83CDDF9U, },
 { 0xD83CDDEDU, 0xD83CDDF3U, },
 { 0xD83CDDEDU, 0xD83CDDF0U, },
 { 0xD83CDDEDU, 0xD83CDDFAU, },
 { 0xD83CDDEEU, 0xD83CDDF8U, },
 { 0xD83CDDEEU, 0xD83CDDF3U, },
 { 0xD83CDDEEU, 0xD83CDDE9U, },
 { 0xD83CDDEEU, 0xD83CDDF7U, },
 { 0xD83CDDEEU, 0xD83CDDF6U, },
 { 0xD83CDDEEU, 0xD83CDDEAU, },
 { 0xD83CDDEEU, 0xD83CDDF2U, },
 { 0xD83CDDEEU, 0xD83CDDF1U, },
 { 0xD83CDDEEU, 0xD83CDDF9U, },
 { 0xD83CDDEFU, 0xD83CDDF2U, },
 { 0xD83CDDEFU, 0xD83CDDF5U, },
 { 0xD83CDF8CU, },
 { 0xD83CDDEFU, 0xD83CDDEAU, },
 { 0xD83CDDEFU, 0xD83CDDF4U, },
 { 0xD83CDDF0U, 0xD83CDDFFU, },
 { 0xD83CDDF0U, 0xD83CDDEAU, },
 { 0xD83CDDF0U, 0xD83CDDEEU, },
 { 0xD83CDDFDU, 0xD83CDDF0U, },
 { 0xD83CDDF0U, 0xD83CDDFCU, },
 { 0xD83CDDF0U, 0xD83CDDECU, },
 { 0xD83CDDF1U, 0xD83CDDE6U, },
 { 0xD83CDDF1U, 0xD83CDDFBU, },
 { 0xD83CDDF1U, 0xD83CDDE7U, },
 { 0xD83CDDF1U, 0xD83CDDF8U, },
 { 0xD83CDDF1U, 0xD83CDDF7U, },
 { 0xD83CDDF1U, 0xD83CDDFEU, },
 { 0xD83CDDF1U, 0xD83CDDEEU, },
 { 0xD83CDDF1U, 0xD83CDDF9U, },
 { 0xD83CDDF1U, 0xD83CDDFAU, },
 { 0xD83CDDF2U, 0xD83CDDF4U, },
 { 0xD83CDDF2U, 0xD83CDDF0U, },
 { 0xD83CDDF2U, 0xD83CDDECU, },
 { 0xD83CDDF2U, 0xD83CDDFCU, },
 { 0xD83CDDF2U, 0xD83CDDFEU, },
 { 0xD83CDDF2U, 0xD83CDDFBU, },
 { 0xD83CDDF2U, 0xD83CDDF1U, },
 { 0xD83CDDF2U, 0xD83CDDF9U, },
 { 0xD83CDDF2U, 0xD83CDDEDU, },
 { 0xD83CDDF2U, 0xD83CDDF6U, },
 { 0xD83CDDF2U, 0xD83CDDF7U, },
 { 0xD83CDDF2U, 0xD83CDDFAU, },
 { 0xD83CDDFEU, 0xD83CDDF9U, },
 { 0xD83CDDF2U, 0xD83CDDFDU, },
 { 0xD83CDDEBU, 0xD83CDDF2U, },
 { 0xD83CDDF2U, 0xD83CDDE9U, },
 { 0xD83CDDF2U, 0xD83CDDE8U, },
 { 0xD83CDDF2U, 0xD83CDDF3U, },
 { 0xD83CDDF2U, 0xD83CDDEAU, },
 { 0xD83CDDF2U, 0xD83CDDF8U, },
 { 0xD83CDDF2U, 0xD83CDDE6U, },
 { 0xD83CDDF2U, 0xD83CDDFFU, },
 { 0xD83CDDF2U, 0xD83CDDF2U, },
 { 0xD83CDDF3U, 0xD83CDDE6U, },
 { 0xD83CDDF3U, 0xD83CDDF7U, },
 { 0xD83CDDF3U, 0xD83CDDF5U, },
 { 0xD83CDDF3U, 0xD83CDDF1U, },
 { 0xD83CDDF3U, 0xD83CDDE8U, },
 { 0xD83CDDF3U, 0xD83CDDFFU, },
 { 0xD83CDDF3U, 0xD83CDDEEU, },
 { 0xD83CDDF3U, 0xD83CDDEAU, },
 { 0xD83CDDF3U, 0xD83CDDECU, },
 { 0xD83CDDF3U, 0xD83CDDFAU, },
 { 0xD83CDDF3U, 0xD83CDDEBU, },
 { 0xD83CDDF0U, 0xD83CDDF5U, },
 { 0xD83CDDF2U, 0xD83CDDF5U, },
 { 0xD83CDDF3U, 0xD83CDDF4U, },
 { 0xD83CDDF4U, 0xD83CDDF2U, },
 { 0xD83CDDF5U, 0xD83CDDF0U, },
 { 0xD83CDDF5U, 0xD83CDDFCU, },
 { 0xD83CDDF5U, 0xD83CDDF8U, },
 { 0xD83CDDF5U, 0xD83CDDE6U, },
 { 0xD83CDDF5U, 0xD83CDDECU, },
 { 0xD83CDDF5U, 0xD83CDDFEU, },
 { 0xD83CDDF5U, 0xD83CDDEAU, },
 { 0xD83CDDF5U, 0xD83CDDEDU, },
 { 0xD83CDDF5U, 0xD83CDDF3U, },
 { 0xD83CDDF5U, 0xD83CDDF1U, },
 { 0xD83CDDF5U, 0xD83CDDF9U, },
 { 0xD83CDDF5U, 0xD83CDDF7U, },
 { 0xD83CDDF6U, 0xD83CDDE6U, },
 { 0xD83CDDF7U, 0xD83CDDEAU, },
 { 0xD83CDDF7U, 0xD83CDDF4U, },
 { 0xD83CDDF7U, 0xD83CDDFAU, },
 { 0xD83CDDF7U, 0xD83CDDFCU, },
 { 0xD83CDDFCU, 0xD83CDDF8U, },
 { 0xD83CDDF8U, 0xD83CDDF2U, },
 { 0xD83CDDF8U, 0xD83CDDF9U, },
 { 0xD83CDDF8U, 0xD83CDDE6U, },
 { 0xD83CDDF8U, 0xD83CDDF3U, },
 { 0xD83CDDF7U, 0xD83CDDF8U, },
 { 0xD83CDDF8U, 0xD83CDDE8U, },
 { 0xD83CDDF8U, 0xD83CDDF1U, },
 { 0xD83CDDF8U, 0xD83CDDECU, },
 { 0xD83CDDF8U, 0xD83CDDFDU, },
 { 0xD83CDDF8U, 0xD83CDDF0U, },
 { 0xD83CDDF8U, 0xD83CDDEEU, },
 { 0xD83CDDECU, 0xD83CDDF8U, },
 { 0xD83CDDF8U, 0xD83CDDE7U, },
 { 0xD83CDDF8U, 0xD83CDDF4U, },
 { 0xD83CDDFFU, 0xD83CDDE6U, },
 { 0xD83CDDF0U, 0xD83CDDF7U, },
 { 0xD83CDDF8U, 0xD83CDDF8U, },
 { 0xD83CDDEAU, 0xD83CDDF8U, },
 { 0xD83CDDF1U, 0xD83CDDF0U, },
 { 0xD83CDDE7U, 0xD83CDDF1U, },
 { 0xD83CDDF8U, 0xD83CDDEDU, },
 { 0xD83CDDF0U, 0xD83CDDF3U, },
 { 0xD83CDDF1U, 0xD83CDDE8U, },
 { 0xD83CDDF5U, 0xD83CDDF2U, },
 { 0xD83CDDFBU, 0xD83CDDE8U, },
 { 0xD83CDDF8U, 0xD83CDDE9U, },
 { 0xD83CDDF8U, 0xD83CDDF7U, },
 { 0xD83CDDF8U, 0xD83CDDFFU, },
 { 0xD83CDDF8U, 0xD83CDDEAU, },
 { 0xD83CDDE8U, 0xD83CDDEDU, },
 { 0xD83CDDF8U, 0xD83CDDFEU, },
 { 0xD83CDDF9U, 0xD83CDDFCU, },
 { 0xD83CDDF9U, 0xD83CDDEFU, },
 { 0xD83CDDF9U, 0xD83CDDFFU, },
 { 0xD83CDDF9U, 0xD83CDDEDU, },
 { 0xD83CDDF9U, 0xD83CDDF1U, },
 { 0xD83CDDF9U, 0xD83CDDECU, },
 { 0xD83CDDF9U, 0xD83CDDF0U, },
 { 0xD83CDDF9U, 0xD83CDDF4U, },
 { 0xD83CDDF9U, 0xD83CDDF9U, },
 { 0xD83CDDF9U, 0xD83CDDF3U, },
 { 0xD83CDDF9U, 0xD83CDDF7U, },
 { 0xD83CDDF9U, 0xD83CDDF2U, },
 { 0xD83CDDF9U, 0xD83CDDE8U, },
 { 0xD83CDDF9U, 0xD83CDDFBU, },
 { 0xD83CDDFBU, 0xD83CDDEEU, },
 { 0xD83CDDFAU, 0xD83CDDECU, },
 { 0xD83CDDFAU, 0xD83CDDE6U, },
 { 0xD83CDDE6U, 0xD83CDDEAU, },
 { 0xD83CDDECU, 0xD83CDDE7U, },
 { 0xD83CDFF4U, 0xDB40DC67U, 0xDB40DC62U, 0xDB40DC65U, 0xDB40DC6EU, 0xDB40DC67U, 0xDB40DC7FU, },
 { 0xD83CDFF4U, 0xDB40DC67U, 0xDB40DC62U, 0xDB40DC73U, 0xDB40DC63U, 0xDB40DC74U, 0xDB40DC7FU, },
 { 0xD83CDFF4U, 0xDB40DC67U, 0xDB40DC62U, 0xDB40DC77U, 0xDB40DC6CU, 0xDB40DC73U, 0xDB40DC7FU, },
 { 0xD83CDDFAU, 0xD83CDDF8U, },
 { 0xD83CDDFAU, 0xD83CDDFEU, },
 { 0xD83CDDFAU, 0xD83CDDFFU, },
 { 0xD83CDDFBU, 0xD83CDDFAU, },
 { 0xD83CDDFBU, 0xD83CDDE6U, },
 { 0xD83CDDFBU, 0xD83CDDEAU, },
 { 0xD83CDDFBU, 0xD83CDDF3U, },
 { 0xD83CDDFCU, 0xD83CDDEBU, },
 { 0xD83CDDEAU, 0xD83CDDEDU, },
 { 0xD83CDDFEU, 0xD83CDDEAU, },
 { 0xD83CDDFFU, 0xD83CDDF2U, },
 { 0xD83CDDFFU, 0xD83CDDFCU, },
};

// Original data has those emoji only with gender symbols.
// But they should be displayed as emoji even without gender symbols.
// So we map which gender symbol to use for an emoji without one.
std::map<InputId, uint32> WithoutGenderAliases = {
 { { 0xD83EDD26U, }, 0x2642U },
 { { 0xD83EDD37U, }, 0x2640U },
 { { 0xD83EDD38U, }, 0x2642U },
 { { 0xD83EDD3CU, }, 0x2640U },
 { { 0xD83EDD3DU, }, 0x2642U },
 { { 0xD83EDD3EU, }, 0x2640U },
 { { 0xD83EDD39U, }, 0x2642U },
 { { 0xD83EDDB8U, }, 0x2640U },
 { { 0xD83EDDB9U, }, 0x2640U },
 { { 0xD83EDDD6U, }, 0x2642U },
 { { 0xD83EDDD7U, }, 0x2640U },
 { { 0xD83EDDD8U, }, 0x2640U },
 { { 0xD83EDDD9U, }, 0x2640U },
 { { 0xD83EDDDAU, }, 0x2640U },
 { { 0xD83EDDDBU, }, 0x2640U },
 { { 0xD83EDDDCU, }, 0x2642U },
 { { 0xD83EDDDDU, }, 0x2642U },
 { { 0xD83EDDDEU, }, 0x2642U },
 { { 0xD83EDDDFU, }, 0x2642U },
};

// Some flags are sent as one string, but are rendered as a different too.
std::map<InputId, InputId> FlagAliases = {
 { { 0xD83CDDE8U, 0xD83CDDF5U, }, { 0xD83CDDEBU, 0xD83CDDF7U, } },
 { { 0xD83CDDE7U, 0xD83CDDFBU, }, { 0xD83CDDF3U, 0xD83CDDF4U, } },
 { { 0xD83CDDE6U, 0xD83CDDE8U, }, { 0xD83CDDF8U, 0xD83CDDEDU, } },

 // This is different flag, but macOS shows that glyph :(
 { { 0xD83CDDE9U, 0xD83CDDECU, }, { 0xD83CDDEEU, 0xD83CDDF4U, } },

 { { 0xD83CDDF9U, 0xD83CDDE6U, }, { 0xD83CDDF8U, 0xD83CDDEDU, } },
 { { 0xD83CDDF2U, 0xD83CDDEBU, }, { 0xD83CDDEBU, 0xD83CDDF7U, } },
 { { 0xD83CDDEAU, 0xD83CDDE6U, }, { 0xD83CDDEAU, 0xD83CDDF8U, } },
};

std::map<Id, std::vector<Id>> Aliases; // original -> list of aliased

void AddAlias(const Id &original, const Id &aliased) {
	Aliases[original].push_back(aliased);
}

constexpr auto kErrorBadData = 401;

void append(Id &id, uint32 code) {
	if (auto first = static_cast<uint16>((code >> 16) & 0xFFFFU)) {
		id.append(QChar(first));
	}
	id.append(QChar(static_cast<uint16>(code & 0xFFFFU)));
}

Id BareIdFromInput(const InputId &id) {
	auto result = Id();
	for (const auto unicode : id) {
		if (unicode != kPostfix) {
			append(result, unicode);
		}
	}
	return result;
}

set<Id> fillVariatedIds() {
	auto result = set<Id>();
	for (const auto &row : ColoredEmoji) {
		auto variatedId = Id();
		if (row.size() < 2) {
			logDataError() << "colored string should have at least two characters.";
			return {};
		}
		for (auto i = size_t(0), size = row.size(); i != size; ++i) {
			auto code = row[i];
			if (i == 1) {
				if (code != ColorMask) {
					logDataError() << "color code should appear at index 1.";
					return {};
				}
			} else if (code == ColorMask) {
				logDataError() << "color code should appear only at index 1.";
				return {};
			} else if (code != kPostfix) {
				append(variatedId, code);
			}
		}
		result.emplace(variatedId);
	}
	return result;
}

set<Id> fillPostfixRequiredIds() {
	auto result = set<Id>();
	for (const auto &row : PostfixRequired) {
		result.emplace(BareIdFromInput(row));
	}
	return result;
}

void appendCategory(
		Data &result,
		const InputCategory &category,
		const set<Id> &variatedIds,
		const set<Id> &postfixRequiredIds) {
	result.categories.emplace_back();
	for (auto &id : category) {
		auto emoji = Emoji();
		auto bareId = BareIdFromInput(id);
		auto from = id.cbegin(), to = id.cend();
		if (to - from == 2 && *(to - 1) == kPostfix) {
			emoji.postfixed = true;
			--to;
		}
		for (auto i = from; i != to; ++i) {
			auto code = *i;
			if (find(begin(Colors), end(Colors), code) != end(Colors)) {
				logDataError() << "color code found in a category emoji.";
				result = Data();
				return;
			}
			append(emoji.id, code);
		}
		if (bareId.isEmpty()) {
			logDataError() << "empty emoji id found.";
			result = Data();
			return;
		}

		auto it = result.map.find(bareId);
		if (it == result.map.cend()) {
			const auto index = result.list.size();
			it = result.map.emplace(bareId, index).first;
			result.list.push_back(move(emoji));
			if (const auto a = Aliases.find(bareId); a != end(Aliases)) {
				for (const auto &alias : a->second) {
					const auto ok = result.map.emplace(alias, index).second;
					if (!ok) {
						logDataError() << "some emoji alias already in the map.";
						result = Data();
						return;
					}
				}
			}
			if (postfixRequiredIds.find(bareId) != end(postfixRequiredIds)) {
				result.postfixRequired.emplace(index);
			}
		} else if (result.list[it->second].postfixed != emoji.postfixed) {
			logDataError() << "same emoji found with different postfixed property.";
			result = Data();
			return;
		} else if (result.list[it->second].id != emoji.id) {
			logDataError() << "same emoji found with different id.";
			result = Data();
			return;
		}
		if (variatedIds.find(bareId) != end(variatedIds)) {
			result.list[it->second].variated = true;

			auto baseId = Id();
			if (*from == kPostfix) {
				logDataError() << "bad first symbol in emoji.";
				result = Data();
				return;
			}
			append(baseId, *from++);
			for (auto color : Colors) {
				auto colored = Emoji();
				colored.id = baseId;
				colored.colored = true;
				append(colored.id, color);
				auto bareColoredId = colored.id;
				for (auto i = from; i != to; ++i) {
					append(colored.id, *i);
					if (*i != kPostfix) {
						append(bareColoredId, *i);
					}
				}
				auto it = result.map.find(bareColoredId);
				if (it == result.map.cend()) {
					const auto index = result.list.size();
					it = result.map.emplace(bareColoredId, index).first;
					result.list.push_back(move(colored));
					if (const auto a = Aliases.find(bareColoredId); a != end(Aliases)) {
						for (const auto &alias : a->second) {
							const auto ok = result.map.emplace(alias, index).second;
							if (!ok) {
								logDataError() << "some emoji alias already in the map.";
								result = Data();
								return;
							}
						}
					}
					if (postfixRequiredIds.find(bareColoredId) != end(postfixRequiredIds)) {
						result.postfixRequired.emplace(index);
					}
				} else if (result.list[it->second].postfixed != colored.postfixed) {
					logDataError() << "same emoji found with different postfixed property.";
					result = Data();
					return;
				} else if (result.list[it->second].id != colored.id) {
					logDataError() << "same emoji found with different id.";
					result = Data();
					return;
				}
			}
		}
		result.categories.back().push_back(it->second);
	}
}

void fillReplaces(Data &result) {
	for (auto &replace : Replaces) {
		auto id = Id();
		for (auto code : replace.code) {
			append(id, code);
		}
		auto it = result.map.find(id);
		if (it == result.map.cend()) {
			logDataError() << "emoji from replaces not found in the map.";
			result = Data();
			return;
		}
		result.replaces.insert(make_pair(QString::fromUtf8(replace.replace), it->second));
	}
}

bool AddItemBeforeItem(const InputId &add, const InputId &before) {
	auto addToCategory = (InputCategory*)nullptr;
	auto addBeforeIterator = InputCategory::iterator();
	for (auto category : {
		&Category1,
		&Category2,
		&Category3,
		&Category4,
		&Category5,
		&Category6,
		&Category7,
	}) {
		for (auto i = category->begin(), e = category->end(); i != e; ++i) {
			if (*i == add) {
				return true;
			} else if (*i == before) {
				addToCategory = category;
				addBeforeIterator = i;
			}
		}
	}
	if (!addToCategory) {
		return false;
	}
	addToCategory->insert(addBeforeIterator, add);
	return true;
}

bool CheckOldInCurrent(std::set<Id> variatedIds) {
	const auto categories = {
		&Category1,
		&Category2,
		&Category3,
		&Category4,
		&Category5,
		&Category6,
		&Category7,
	};
	const auto old = {
		&old::Category1,
		&old::Category2,
		&old::Category3,
		&old::Category4,
		&old::Category5,
		&old::Category6,
		&old::Category7,
	};
	const auto genders = { 0x2640U, 0x2642U };
	const auto addGender = [](const InputId &was, uint32 gender) {
		auto result = was;
		result.push_back(0x200DU);
		result.push_back(gender);
		result.push_back(0xFE0FU);
		return result;
	};
	const auto addGenderByIndex = [&](const InputId &was, int index) {
		return addGender(was, *(begin(genders) + index));
	};
	const auto find = [](
			const InputCategory &list,
			const InputId &id) {
		return (std::find(begin(list), end(list), id) != end(list));
	};
	const auto findInMany = [&](
			auto &&list,
			const InputId &id) {
		for (const auto current : list) {
			if (find(*current, id)) {
				return true;
			}
		}
		return false;
	};
	const auto emplaceColoredAlias = [](const InputId &real, const InputId &alias, uint32_t color) {
		if (real.size() < 2 || alias.size() < 2 || real[1] != Colors[0] || alias[1] != Colors[0]) {
			return false;
		}
		auto key = real;
		key[1] = color;
		auto value = alias;
		value[1] = color;
		AddAlias(BareIdFromInput(key), BareIdFromInput(value));
		return true;
	};
	auto result = true;
	for (auto c = begin(old); c != end(old); ++c) {
		const auto category = *c;
		for (auto i = begin(*category); i != end(*category); ++i) {
			if (findInMany(categories, *i)) {
				continue;
			}

			// Some emoji were ending with 0xFE0FU and now are not.
			if (i->back() == 0xFE0FU) {
				auto other = *i;
				other.pop_back();
				if (findInMany(categories, other)) {
					continue;
				}
			}

			// Some emoji were not ending with 0xFE0FU and now are.
			if (i->back() != 0xFE0FU) {
				auto other = *i;
				other.push_back(0xFE0FU);
				if (findInMany(categories, other)) {
					continue;
				}
			}

			// Some emoji were without gender symbol and now have gender symbol.
			// Try adding 0x200DU, 0x2640U, 0xFE0FU or 0x200DU, 0x2642U, 0xFE0FU.
			const auto otherGenderIndex = [&] {
				for (auto g = begin(genders); g != end(genders); ++g) {
					auto altered = *i;
					altered.push_back(0x200DU);
					altered.push_back(*g);
					altered.push_back(0xFE0FU);
					if (findInMany(old, altered)) {
						return int(g - begin(genders));
					}
				}
				return -1;
			}();
			if (otherGenderIndex < 0) {
				common::logError(kErrorBadData, "input")
					<< "Bad data: old emoji (category "
					<< (c - begin(old))
					<< ", index "
					<< (i - begin(*category))
					<< ") not found in current.";
				result = false;
				continue;
			}

			const auto genderIndex = (1 - otherGenderIndex);
			const auto real = addGenderByIndex(*i, genderIndex);
			const auto bare = BareIdFromInput(real);
			if (!findInMany(categories, real)) {
				common::logError(kErrorBadData, "input")
					<< "Bad data: old emoji (category "
					<< (c - begin(old))
					<< ", index "
					<< (i - begin(*category))
					<< ") not found in current with added gender: "
					<< genderIndex
					<< ".";
				result = false;
			} else {
				AddAlias(bare, BareIdFromInput(*i));
			}
		}
	}
	for (auto i = begin(old::ColoredEmoji); i != end(old::ColoredEmoji); ++i) {
		if (find(ColoredEmoji, *i)) {
			continue;
		}

		const auto otherGenderIndex = [&] {
			for (auto g = begin(genders); g != end(genders); ++g) {
				auto altered = *i;
				altered.push_back(0x200DU);
				altered.push_back(*g);
				altered.push_back(0xFE0FU);
				if (find(old::ColoredEmoji, altered)) {
					return int(g - begin(genders));
				}
			}
			return -1;
		}();
		if (otherGenderIndex < 0) {
			common::logError(kErrorBadData, "input")
				<< "Bad data: old colored emoji (index "
				<< (i - begin(old::ColoredEmoji))
				<< ") not found in current.";
			result = false;
			continue;
		}

		const auto genderIndex = (1 - otherGenderIndex);
		const auto real = addGenderByIndex(*i, genderIndex);
		const auto bare = BareIdFromInput(real);
		if (!find(ColoredEmoji, real)) {
			common::logError(kErrorBadData, "input")
				<< "Bad data: old colored emoji (index "
				<< (i - begin(old::ColoredEmoji))
				<< ") not found in current with added gender: "
				<< genderIndex
				<< ".";
			result = false;
			continue;
		} else {
			for (const auto color : Colors) {
				if (!emplaceColoredAlias(real, *i, color)) {
					common::logError(kErrorBadData, "input")
						<< "Bad data: bad colored emoji.";
					result = false;
					break;
				}
			}
		}
	}

	for (const auto &entry : WithoutGenderAliases) {
		const auto &inputId = entry.first;
		const auto &gender = entry.second;
		if (findInMany(categories, inputId)) {
			continue;
		}
		const auto real = [&] {
			auto result = addGender(inputId, gender);
			if (findInMany(categories, result)) {
				return result;
			}
			result.push_back(kPostfix);
			return result;
		}();
		const auto bare = BareIdFromInput(real);
		if (!findInMany(categories, real)) {
			common::logError(kErrorBadData, "input")
				<< "Bad data: without gender alias not found with gender.";
			result = false;
		} else {
			AddAlias(bare, BareIdFromInput(inputId));
		}
		if (variatedIds.find(bare) != variatedIds.end()) {
			auto colorReal = real;
			colorReal.insert(colorReal.begin() + 1, Colors[0]);
			auto colorInput = inputId;
			colorInput.insert(colorInput.begin() + 1, Colors[0]);
			for (const auto color : Colors) {
				if (!emplaceColoredAlias(colorReal, colorInput, color)) {
					common::logError(kErrorBadData, "input")
						<< "Bad data: bad colored emoji.";
					result = false;
					break;
				}
			}

		}
	}

	for (const auto &[inputId, real] : FlagAliases) {
		AddAlias(BareIdFromInput(real), BareIdFromInput(inputId));
	}

	return result;
}

} // namespace

common::LogStream logDataError() {
	return common::logError(kErrorBadData, "input") << "Bad data: ";
}

Data PrepareData() {
	Data result;

	const auto variatedIds = fillVariatedIds();
	const auto postfixRequiredIds = fillPostfixRequiredIds();
	if (variatedIds.empty() || postfixRequiredIds.empty()) {
		return Data();
	}

	// Manually add :speech_left: emoji before eye-with-speech emoji.
	if (!AddItemBeforeItem({ 0xD83DDDE8U }, { 0xD83DDC41U, 0x200DU, 0xD83DDDE8U })) {
		return Data();
	}

	if (!CheckOldInCurrent(variatedIds)) {
		return Data();
	}

	const auto categories = {
		&Category1,
		&Category2,
		&Category3,
		&Category4,
		&Category5,
		&Category6,
		&Category7,
	};
	for (const auto category : categories) {
		appendCategory(result, *category, variatedIds, postfixRequiredIds);
		if (result.list.empty()) {
			return Data();
		}
	}

	fillReplaces(result);
	if (result.list.empty()) {
		return Data();
	}

	return result;
}

namespace {
namespace old {

InputCategory ColoredEmoji = {
 { 0xD83DDC50U, 0xD83CDFFBU, },
 { 0xD83DDE4CU, 0xD83CDFFBU, },
 { 0xD83DDC4FU, 0xD83CDFFBU, },
 { 0xD83DDE4FU, 0xD83CDFFBU, },
 { 0xD83DDC4DU, 0xD83CDFFBU, },
 { 0xD83DDC4EU, 0xD83CDFFBU, },
 { 0xD83DDC4AU, 0xD83CDFFBU, },
 { 0x270AU, 0xD83CDFFBU, },
 { 0xD83EDD1BU, 0xD83CDFFBU, },
 { 0xD83EDD1CU, 0xD83CDFFBU, },
 { 0xD83EDD1EU, 0xD83CDFFBU, },
 { 0x270CU, 0xD83CDFFBU, },
 { 0xD83EDD18U, 0xD83CDFFBU, },
 { 0xD83DDC4CU, 0xD83CDFFBU, },
 { 0xD83DDC48U, 0xD83CDFFBU, },
 { 0xD83DDC49U, 0xD83CDFFBU, },
 { 0xD83DDC46U, 0xD83CDFFBU, },
 { 0xD83DDC47U, 0xD83CDFFBU, },
 { 0x261DU, 0xD83CDFFBU, },
 { 0x270BU, 0xD83CDFFBU, },
 { 0xD83EDD1AU, 0xD83CDFFBU, },
 { 0xD83DDD90U, 0xD83CDFFBU, },
 { 0xD83DDD96U, 0xD83CDFFBU, },
 { 0xD83DDC4BU, 0xD83CDFFBU, },
 { 0xD83EDD19U, 0xD83CDFFBU, },
 { 0xD83DDCAAU, 0xD83CDFFBU, },
 { 0xD83DDD95U, 0xD83CDFFBU, },
 { 0x270DU, 0xD83CDFFBU, },
 { 0xD83EDD33U, 0xD83CDFFBU, },
 { 0xD83DDC85U, 0xD83CDFFBU, },
 { 0xD83DDC42U, 0xD83CDFFBU, },
 { 0xD83DDC43U, 0xD83CDFFBU, },
 { 0xD83DDC76U, 0xD83CDFFBU, },
 { 0xD83DDC66U, 0xD83CDFFBU, },
 { 0xD83DDC67U, 0xD83CDFFBU, },
 { 0xD83DDC68U, 0xD83CDFFBU, },
 { 0xD83DDC69U, 0xD83CDFFBU, },
 { 0xD83DDC71U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC71U, 0xD83CDFFBU, },
 { 0xD83DDC74U, 0xD83CDFFBU, },
 { 0xD83DDC75U, 0xD83CDFFBU, },
 { 0xD83DDC72U, 0xD83CDFFBU, },
 { 0xD83DDC73U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC73U, 0xD83CDFFBU, },
 { 0xD83DDC6EU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC6EU, 0xD83CDFFBU, },
 { 0xD83DDC77U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC77U, 0xD83CDFFBU, },
 { 0xD83DDC82U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC82U, 0xD83CDFFBU, },
 { 0xD83DDD75U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDD75U, 0xD83CDFFBU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0x2695U, 0xFE0FU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0x2695U, 0xFE0FU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83CDF3EU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83CDF3EU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83CDF73U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83CDF73U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83CDF93U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83CDF93U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83CDFA4U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83CDFA4U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83CDFEBU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83CDFEBU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83CDFEDU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83CDFEDU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83DDCBBU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83DDCBBU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83DDCBCU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83DDCBCU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83DDD27U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83DDD27U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83DDD2CU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83DDD2CU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83CDFA8U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83CDFA8U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83DDE92U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83DDE92U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0x2708U, 0xFE0FU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0x2708U, 0xFE0FU, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0xD83DDE80U, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0xD83DDE80U, },
 { 0xD83DDC69U, 0xD83CDFFBU, 0x200DU, 0x2696U, 0xFE0FU, },
 { 0xD83DDC68U, 0xD83CDFFBU, 0x200DU, 0x2696U, 0xFE0FU, },
 { 0xD83EDD36U, 0xD83CDFFBU, },
 { 0xD83CDF85U, 0xD83CDFFBU, },
 { 0xD83DDC78U, 0xD83CDFFBU, },
 { 0xD83EDD34U, 0xD83CDFFBU, },
 { 0xD83DDC70U, 0xD83CDFFBU, },
 { 0xD83EDD35U, 0xD83CDFFBU, },
 { 0xD83DDC7CU, 0xD83CDFFBU, },
 { 0xD83EDD30U, 0xD83CDFFBU, },
 { 0xD83DDE47U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDE47U, 0xD83CDFFBU, },
 { 0xD83DDC81U, 0xD83CDFFBU, },
 { 0xD83DDC81U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE45U, 0xD83CDFFBU, },
 { 0xD83DDE45U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE46U, 0xD83CDFFBU, },
 { 0xD83DDE46U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE4BU, 0xD83CDFFBU, },
 { 0xD83DDE4BU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD26U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD26U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD37U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD37U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE4EU, 0xD83CDFFBU, },
 { 0xD83DDE4EU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE4DU, 0xD83CDFFBU, },
 { 0xD83DDE4DU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC87U, 0xD83CDFFBU, },
 { 0xD83DDC87U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC86U, 0xD83CDFFBU, },
 { 0xD83DDC86U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDD74U, 0xD83CDFFBU, },
 { 0xD83DDC83U, 0xD83CDFFBU, },
 { 0xD83DDD7AU, 0xD83CDFFBU, },
 { 0xD83DDEB6U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEB6U, 0xD83CDFFBU, },
 { 0xD83CDFC3U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFC3U, 0xD83CDFFBU, },
 { 0xD83CDFCBU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFCBU, 0xD83CDFFBU, },
 { 0xD83EDD38U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD38U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0x26F9U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0x26F9U, 0xD83CDFFBU, },
 { 0xD83EDD3EU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD3EU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFCCU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFCCU, 0xD83CDFFBU, },
 { 0xD83CDFC4U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFC4U, 0xD83CDFFBU, },
 { 0xD83CDFCAU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFCAU, 0xD83CDFFBU, },
 { 0xD83EDD3DU, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD3DU, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDEA3U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEA3U, 0xD83CDFFBU, },
 { 0xD83CDFC7U, 0xD83CDFFBU, },
 { 0xD83DDEB4U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEB4U, 0xD83CDFFBU, },
 { 0xD83DDEB5U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEB5U, 0xD83CDFFBU, },
 { 0xD83EDD39U, 0xD83CDFFBU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD39U, 0xD83CDFFBU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDEC0U, 0xD83CDFFBU, },
};

InputCategory Category1 = {
 { 0xD83DDE00U, },
 { 0xD83DDE03U, },
 { 0xD83DDE04U, },
 { 0xD83DDE01U, },
 { 0xD83DDE06U, },
 { 0xD83DDE05U, },
 { 0xD83DDE02U, },
 { 0xD83EDD23U, },
 { 0x263AU, 0xFE0FU, },
 { 0xD83DDE0AU, },
 { 0xD83DDE07U, },
 { 0xD83DDE42U, },
 { 0xD83DDE43U, },
 { 0xD83DDE09U, },
 { 0xD83DDE0CU, },
 { 0xD83DDE0DU, },
 { 0xD83DDE18U, },
 { 0xD83DDE17U, },
 { 0xD83DDE19U, },
 { 0xD83DDE1AU, },
 { 0xD83DDE0BU, },
 { 0xD83DDE1CU, },
 { 0xD83DDE1DU, },
 { 0xD83DDE1BU, },
 { 0xD83EDD11U, },
 { 0xD83EDD17U, },
 { 0xD83EDD13U, },
 { 0xD83DDE0EU, },
 { 0xD83EDD21U, },
 { 0xD83EDD20U, },
 { 0xD83DDE0FU, },
 { 0xD83DDE12U, },
 { 0xD83DDE1EU, },
 { 0xD83DDE14U, },
 { 0xD83DDE1FU, },
 { 0xD83DDE15U, },
 { 0xD83DDE41U, },
 { 0x2639U, 0xFE0FU, },
 { 0xD83DDE23U, },
 { 0xD83DDE16U, },
 { 0xD83DDE2BU, },
 { 0xD83DDE29U, },
 { 0xD83DDE24U, },
 { 0xD83DDE20U, },
 { 0xD83DDE21U, },
 { 0xD83DDE36U, },
 { 0xD83DDE10U, },
 { 0xD83DDE11U, },
 { 0xD83DDE2FU, },
 { 0xD83DDE26U, },
 { 0xD83DDE27U, },
 { 0xD83DDE2EU, },
 { 0xD83DDE32U, },
 { 0xD83DDE35U, },
 { 0xD83DDE33U, },
 { 0xD83DDE31U, },
 { 0xD83DDE28U, },
 { 0xD83DDE30U, },
 { 0xD83DDE22U, },
 { 0xD83DDE25U, },
 { 0xD83EDD24U, },
 { 0xD83DDE2DU, },
 { 0xD83DDE13U, },
 { 0xD83DDE2AU, },
 { 0xD83DDE34U, },
 { 0xD83DDE44U, },
 { 0xD83EDD14U, },
 { 0xD83EDD25U, },
 { 0xD83DDE2CU, },
 { 0xD83EDD10U, },
 { 0xD83EDD22U, },
 { 0xD83EDD27U, },
 { 0xD83DDE37U, },
 { 0xD83EDD12U, },
 { 0xD83EDD15U, },
 { 0xD83DDE08U, },
 { 0xD83DDC7FU, },
 { 0xD83DDC79U, },
 { 0xD83DDC7AU, },
 { 0xD83DDCA9U, },
 { 0xD83DDC7BU, },
 { 0xD83DDC80U, },
 { 0x2620U, 0xFE0FU, },
 { 0xD83DDC7DU, },
 { 0xD83DDC7EU, },
 { 0xD83EDD16U, },
 { 0xD83CDF83U, },
 { 0xD83DDE3AU, },
 { 0xD83DDE38U, },
 { 0xD83DDE39U, },
 { 0xD83DDE3BU, },
 { 0xD83DDE3CU, },
 { 0xD83DDE3DU, },
 { 0xD83DDE40U, },
 { 0xD83DDE3FU, },
 { 0xD83DDE3EU, },
 { 0xD83DDC50U, },
 { 0xD83DDE4CU, },
 { 0xD83DDC4FU, },
 { 0xD83DDE4FU, },
 { 0xD83EDD1DU, },
 { 0xD83DDC4DU, },
 { 0xD83DDC4EU, },
 { 0xD83DDC4AU, },
 { 0x270AU, 0xFE0FU, },
 { 0xD83EDD1BU, },
 { 0xD83EDD1CU, },
 { 0xD83EDD1EU, },
 { 0x270CU, 0xFE0FU, },
 { 0xD83EDD18U, },
 { 0xD83DDC4CU, },
 { 0xD83DDC48U, },
 { 0xD83DDC49U, },
 { 0xD83DDC46U, },
 { 0xD83DDC47U, },
 { 0x261DU, 0xFE0FU, },
 { 0x270BU, 0xFE0FU, },
 { 0xD83EDD1AU, },
 { 0xD83DDD90U, },
 { 0xD83DDD96U, },
 { 0xD83DDC4BU, },
 { 0xD83EDD19U, },
 { 0xD83DDCAAU, },
 { 0xD83DDD95U, },
 { 0x270DU, 0xFE0FU, },
 { 0xD83EDD33U, },
 { 0xD83DDC85U, },
 { 0xD83DDC8DU, },
 { 0xD83DDC84U, },
 { 0xD83DDC8BU, },
 { 0xD83DDC44U, },
 { 0xD83DDC45U, },
 { 0xD83DDC42U, },
 { 0xD83DDC43U, },
 { 0xD83DDC63U, },
 { 0xD83DDC41U, },
 { 0xD83DDC40U, },
 { 0xD83DDDE3U, },
 { 0xD83DDC64U, },
 { 0xD83DDC65U, },
 { 0xD83DDC76U, },
 { 0xD83DDC66U, },
 { 0xD83DDC67U, },
 { 0xD83DDC68U, },
 { 0xD83DDC69U, },
 { 0xD83DDC71U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC71U, },
 { 0xD83DDC74U, },
 { 0xD83DDC75U, },
 { 0xD83DDC72U, },
 { 0xD83DDC73U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC73U, },
 { 0xD83DDC6EU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC6EU, },
 { 0xD83DDC77U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC77U, },
 { 0xD83DDC82U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDC82U, },
 { 0xD83DDD75U, 0xFE0FU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDD75U, 0xFE0FU, },
 { 0xD83DDC69U, 0x200DU, 0x2695U, 0xFE0FU, },
 { 0xD83DDC68U, 0x200DU, 0x2695U, 0xFE0FU, },
 { 0xD83DDC69U, 0x200DU, 0xD83CDF3EU, },
 { 0xD83DDC68U, 0x200DU, 0xD83CDF3EU, },
 { 0xD83DDC69U, 0x200DU, 0xD83CDF73U, },
 { 0xD83DDC68U, 0x200DU, 0xD83CDF73U, },
 { 0xD83DDC69U, 0x200DU, 0xD83CDF93U, },
 { 0xD83DDC68U, 0x200DU, 0xD83CDF93U, },
 { 0xD83DDC69U, 0x200DU, 0xD83CDFA4U, },
 { 0xD83DDC68U, 0x200DU, 0xD83CDFA4U, },
 { 0xD83DDC69U, 0x200DU, 0xD83CDFEBU, },
 { 0xD83DDC68U, 0x200DU, 0xD83CDFEBU, },
 { 0xD83DDC69U, 0x200DU, 0xD83CDFEDU, },
 { 0xD83DDC68U, 0x200DU, 0xD83CDFEDU, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDCBBU, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDCBBU, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDCBCU, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDCBCU, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDD27U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDD27U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDD2CU, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDD2CU, },
 { 0xD83DDC69U, 0x200DU, 0xD83CDFA8U, },
 { 0xD83DDC68U, 0x200DU, 0xD83CDFA8U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDE92U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDE92U, },
 { 0xD83DDC69U, 0x200DU, 0x2708U, 0xFE0FU, },
 { 0xD83DDC68U, 0x200DU, 0x2708U, 0xFE0FU, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDE80U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDE80U, },
 { 0xD83DDC69U, 0x200DU, 0x2696U, 0xFE0FU, },
 { 0xD83DDC68U, 0x200DU, 0x2696U, 0xFE0FU, },
 { 0xD83EDD36U, },
 { 0xD83CDF85U, },
 { 0xD83DDC78U, },
 { 0xD83EDD34U, },
 { 0xD83DDC70U, },
 { 0xD83EDD35U, },
 { 0xD83DDC7CU, },
 { 0xD83EDD30U, },
 { 0xD83DDE47U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDE47U, },
 { 0xD83DDC81U, },
 { 0xD83DDC81U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE45U, },
 { 0xD83DDE45U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE46U, },
 { 0xD83DDE46U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE4BU, },
 { 0xD83DDE4BU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD26U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD26U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD37U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD37U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE4EU, },
 { 0xD83DDE4EU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDE4DU, },
 { 0xD83DDE4DU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC87U, },
 { 0xD83DDC87U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDC86U, },
 { 0xD83DDC86U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDD74U, },
 { 0xD83DDC83U, },
 { 0xD83DDD7AU, },
 { 0xD83DDC6FU, },
 { 0xD83DDC6FU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDEB6U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEB6U, },
 { 0xD83CDFC3U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFC3U, },
 { 0xD83DDC6BU, },
 { 0xD83DDC6DU, },
 { 0xD83DDC6CU, },
 { 0xD83DDC91U, },
 { 0xD83DDC69U, 0x200DU, 0x2764U, 0xFE0FU, 0x200DU, 0xD83DDC69U, },
 { 0xD83DDC68U, 0x200DU, 0x2764U, 0xFE0FU, 0x200DU, 0xD83DDC68U, },
 { 0xD83DDC8FU, },
 { 0xD83DDC69U, 0x200DU, 0x2764U, 0xFE0FU, 0x200DU, 0xD83DDC8BU, 0x200DU, 0xD83DDC69U, },
 { 0xD83DDC68U, 0x200DU, 0x2764U, 0xFE0FU, 0x200DU, 0xD83DDC8BU, 0x200DU, 0xD83DDC68U, },
 { 0xD83DDC6AU, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC66U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC66U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC69U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC68U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC68U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC68U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC68U, 0x200DU, 0xD83DDC66U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC68U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC66U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC69U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC66U, 0x200DU, 0xD83DDC66U, },
 { 0xD83DDC68U, 0x200DU, 0xD83DDC67U, 0x200DU, 0xD83DDC67U, },
 { 0xD83DDC5AU, },
 { 0xD83DDC55U, },
 { 0xD83DDC56U, },
 { 0xD83DDC54U, },
 { 0xD83DDC57U, },
 { 0xD83DDC59U, },
 { 0xD83DDC58U, },
 { 0xD83DDC60U, },
 { 0xD83DDC61U, },
 { 0xD83DDC62U, },
 { 0xD83DDC5EU, },
 { 0xD83DDC5FU, },
 { 0xD83DDC52U, },
 { 0xD83CDFA9U, },
 { 0xD83CDF93U, },
 { 0xD83DDC51U, },
 { 0x26D1U, },
 { 0xD83CDF92U, },
 { 0xD83DDC5DU, },
 { 0xD83DDC5BU, },
 { 0xD83DDC5CU, },
 { 0xD83DDCBCU, },
 { 0xD83DDC53U, },
 { 0xD83DDD76U, },
 { 0xD83CDF02U, },
 { 0x2602U, 0xFE0FU, },
};

InputCategory Category2 = {
 { 0xD83DDC36U, },
 { 0xD83DDC31U, },
 { 0xD83DDC2DU, },
 { 0xD83DDC39U, },
 { 0xD83DDC30U, },
 { 0xD83EDD8AU, },
 { 0xD83DDC3BU, },
 { 0xD83DDC3CU, },
 { 0xD83DDC28U, },
 { 0xD83DDC2FU, },
 { 0xD83EDD81U, },
 { 0xD83DDC2EU, },
 { 0xD83DDC37U, },
 { 0xD83DDC3DU, },
 { 0xD83DDC38U, },
 { 0xD83DDC35U, },
 { 0xD83DDE48U, },
 { 0xD83DDE49U, },
 { 0xD83DDE4AU, },
 { 0xD83DDC12U, },
 { 0xD83DDC14U, },
 { 0xD83DDC27U, },
 { 0xD83DDC26U, },
 { 0xD83DDC24U, },
 { 0xD83DDC23U, },
 { 0xD83DDC25U, },
 { 0xD83EDD86U, },
 { 0xD83EDD85U, },
 { 0xD83EDD89U, },
 { 0xD83EDD87U, },
 { 0xD83DDC3AU, },
 { 0xD83DDC17U, },
 { 0xD83DDC34U, },
 { 0xD83EDD84U, },
 { 0xD83DDC1DU, },
 { 0xD83DDC1BU, },
 { 0xD83EDD8BU, },
 { 0xD83DDC0CU, },
 { 0xD83DDC1AU, },
 { 0xD83DDC1EU, },
 { 0xD83DDC1CU, },
 { 0xD83DDD77U, },
 { 0xD83DDD78U, },
 { 0xD83DDC22U, },
 { 0xD83DDC0DU, },
 { 0xD83EDD8EU, },
 { 0xD83EDD82U, },
 { 0xD83EDD80U, },
 { 0xD83EDD91U, },
 { 0xD83DDC19U, },
 { 0xD83EDD90U, },
 { 0xD83DDC20U, },
 { 0xD83DDC1FU, },
 { 0xD83DDC21U, },
 { 0xD83DDC2CU, },
 { 0xD83EDD88U, },
 { 0xD83DDC33U, },
 { 0xD83DDC0BU, },
 { 0xD83DDC0AU, },
 { 0xD83DDC06U, },
 { 0xD83DDC05U, },
 { 0xD83DDC03U, },
 { 0xD83DDC02U, },
 { 0xD83DDC04U, },
 { 0xD83EDD8CU, },
 { 0xD83DDC2AU, },
 { 0xD83DDC2BU, },
 { 0xD83DDC18U, },
 { 0xD83EDD8FU, },
 { 0xD83EDD8DU, },
 { 0xD83DDC0EU, },
 { 0xD83DDC16U, },
 { 0xD83DDC10U, },
 { 0xD83DDC0FU, },
 { 0xD83DDC11U, },
 { 0xD83DDC15U, },
 { 0xD83DDC29U, },
 { 0xD83DDC08U, },
 { 0xD83DDC13U, },
 { 0xD83EDD83U, },
 { 0xD83DDD4AU, },
 { 0xD83DDC07U, },
 { 0xD83DDC01U, },
 { 0xD83DDC00U, },
 { 0xD83DDC3FU, },
 { 0xD83DDC3EU, },
 { 0xD83DDC09U, },
 { 0xD83DDC32U, },
 { 0xD83CDF35U, },
 { 0xD83CDF84U, },
 { 0xD83CDF32U, },
 { 0xD83CDF33U, },
 { 0xD83CDF34U, },
 { 0xD83CDF31U, },
 { 0xD83CDF3FU, },
 { 0x2618U, 0xFE0FU, },
 { 0xD83CDF40U, },
 { 0xD83CDF8DU, },
 { 0xD83CDF8BU, },
 { 0xD83CDF43U, },
 { 0xD83CDF42U, },
 { 0xD83CDF41U, },
 { 0xD83CDF44U, },
 { 0xD83CDF3EU, },
 { 0xD83DDC90U, },
 { 0xD83CDF37U, },
 { 0xD83CDF39U, },
 { 0xD83EDD40U, },
 { 0xD83CDF3BU, },
 { 0xD83CDF3CU, },
 { 0xD83CDF38U, },
 { 0xD83CDF3AU, },
 { 0xD83CDF0EU, },
 { 0xD83CDF0DU, },
 { 0xD83CDF0FU, },
 { 0xD83CDF15U, },
 { 0xD83CDF16U, },
 { 0xD83CDF17U, },
 { 0xD83CDF18U, },
 { 0xD83CDF11U, },
 { 0xD83CDF12U, },
 { 0xD83CDF13U, },
 { 0xD83CDF14U, },
 { 0xD83CDF1AU, },
 { 0xD83CDF1DU, },
 { 0xD83CDF1EU, },
 { 0xD83CDF1BU, },
 { 0xD83CDF1CU, },
 { 0xD83CDF19U, },
 { 0xD83DDCABU, },
 { 0x2B50U, 0xFE0FU, },
 { 0xD83CDF1FU, },
 { 0x2728U, },
 { 0x26A1U, 0xFE0FU, },
 { 0xD83DDD25U, },
 { 0xD83DDCA5U, },
 { 0x2604U, 0xFE0FU, },
 { 0x2600U, 0xFE0FU, },
 { 0xD83CDF24U, },
 { 0x26C5U, 0xFE0FU, },
 { 0xD83CDF25U, },
 { 0xD83CDF26U, },
 { 0xD83CDF08U, },
 { 0x2601U, 0xFE0FU, },
 { 0xD83CDF27U, },
 { 0x26C8U, },
 { 0xD83CDF29U, },
 { 0xD83CDF28U, },
 { 0x2603U, 0xFE0FU, },
 { 0x26C4U, 0xFE0FU, },
 { 0x2744U, 0xFE0FU, },
 { 0xD83CDF2CU, },
 { 0xD83DDCA8U, },
 { 0xD83CDF2AU, },
 { 0xD83CDF2BU, },
 { 0xD83CDF0AU, },
 { 0xD83DDCA7U, },
 { 0xD83DDCA6U, },
 { 0x2614U, 0xFE0FU, },
};

InputCategory Category3 = {
 { 0xD83CDF4FU, },
 { 0xD83CDF4EU, },
 { 0xD83CDF50U, },
 { 0xD83CDF4AU, },
 { 0xD83CDF4BU, },
 { 0xD83CDF4CU, },
 { 0xD83CDF49U, },
 { 0xD83CDF47U, },
 { 0xD83CDF53U, },
 { 0xD83CDF48U, },
 { 0xD83CDF52U, },
 { 0xD83CDF51U, },
 { 0xD83CDF4DU, },
 { 0xD83EDD5DU, },
 { 0xD83EDD51U, },
 { 0xD83CDF45U, },
 { 0xD83CDF46U, },
 { 0xD83EDD52U, },
 { 0xD83EDD55U, },
 { 0xD83CDF3DU, },
 { 0xD83CDF36U, },
 { 0xD83EDD54U, },
 { 0xD83CDF60U, },
 { 0xD83CDF30U, },
 { 0xD83EDD5CU, },
 { 0xD83CDF6FU, },
 { 0xD83EDD50U, },
 { 0xD83CDF5EU, },
 { 0xD83EDD56U, },
 { 0xD83EDDC0U, },
 { 0xD83EDD5AU, },
 { 0xD83CDF73U, },
 { 0xD83EDD53U, },
 { 0xD83EDD5EU, },
 { 0xD83CDF64U, },
 { 0xD83CDF57U, },
 { 0xD83CDF56U, },
 { 0xD83CDF55U, },
 { 0xD83CDF2DU, },
 { 0xD83CDF54U, },
 { 0xD83CDF5FU, },
 { 0xD83EDD59U, },
 { 0xD83CDF2EU, },
 { 0xD83CDF2FU, },
 { 0xD83EDD57U, },
 { 0xD83EDD58U, },
 { 0xD83CDF5DU, },
 { 0xD83CDF5CU, },
 { 0xD83CDF72U, },
 { 0xD83CDF65U, },
 { 0xD83CDF63U, },
 { 0xD83CDF71U, },
 { 0xD83CDF5BU, },
 { 0xD83CDF59U, },
 { 0xD83CDF5AU, },
 { 0xD83CDF58U, },
 { 0xD83CDF62U, },
 { 0xD83CDF61U, },
 { 0xD83CDF67U, },
 { 0xD83CDF68U, },
 { 0xD83CDF66U, },
 { 0xD83CDF70U, },
 { 0xD83CDF82U, },
 { 0xD83CDF6EU, },
 { 0xD83CDF6DU, },
 { 0xD83CDF6CU, },
 { 0xD83CDF6BU, },
 { 0xD83CDF7FU, },
 { 0xD83CDF69U, },
 { 0xD83CDF6AU, },
 { 0xD83EDD5BU, },
 { 0xD83CDF7CU, },
 { 0x2615U, 0xFE0FU, },
 { 0xD83CDF75U, },
 { 0xD83CDF76U, },
 { 0xD83CDF7AU, },
 { 0xD83CDF7BU, },
 { 0xD83EDD42U, },
 { 0xD83CDF77U, },
 { 0xD83EDD43U, },
 { 0xD83CDF78U, },
 { 0xD83CDF79U, },
 { 0xD83CDF7EU, },
 { 0xD83EDD44U, },
 { 0xD83CDF74U, },
 { 0xD83CDF7DU, },
};

InputCategory Category4 = {
 { 0x26BDU, 0xFE0FU, },
 { 0xD83CDFC0U, },
 { 0xD83CDFC8U, },
 { 0x26BEU, 0xFE0FU, },
 { 0xD83CDFBEU, },
 { 0xD83CDFD0U, },
 { 0xD83CDFC9U, },
 { 0xD83CDFB1U, },
 { 0xD83CDFD3U, },
 { 0xD83CDFF8U, },
 { 0xD83EDD45U, },
 { 0xD83CDFD2U, },
 { 0xD83CDFD1U, },
 { 0xD83CDFCFU, },
 { 0x26F3U, 0xFE0FU, },
 { 0xD83CDFF9U, },
 { 0xD83CDFA3U, },
 { 0xD83EDD4AU, },
 { 0xD83EDD4BU, },
 { 0x26F8U, },
 { 0xD83CDFBFU, },
 { 0x26F7U, },
 { 0xD83CDFC2U, },
 { 0xD83CDFCBU, 0xFE0FU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFCBU, 0xFE0FU, },
 { 0xD83EDD3AU, },
 { 0xD83EDD3CU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD3CU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83EDD38U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD38U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0x26F9U, 0xFE0FU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0x26F9U, 0xFE0FU, },
 { 0xD83EDD3EU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD3EU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFCCU, 0xFE0FU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFCCU, 0xFE0FU, },
 { 0xD83CDFC4U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFC4U, },
 { 0xD83CDFCAU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83CDFCAU, },
 { 0xD83EDD3DU, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD3DU, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83DDEA3U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEA3U, },
 { 0xD83CDFC7U, },
 { 0xD83DDEB4U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEB4U, },
 { 0xD83DDEB5U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83DDEB5U, },
 { 0xD83CDFBDU, },
 { 0xD83CDFC5U, },
 { 0xD83CDF96U, },
 { 0xD83EDD47U, },
 { 0xD83EDD48U, },
 { 0xD83EDD49U, },
 { 0xD83CDFC6U, },
 { 0xD83CDFF5U, },
 { 0xD83CDF97U, },
 { 0xD83CDFABU, },
 { 0xD83CDF9FU, },
 { 0xD83CDFAAU, },
 { 0xD83EDD39U, 0x200DU, 0x2640U, 0xFE0FU, },
 { 0xD83EDD39U, 0x200DU, 0x2642U, 0xFE0FU, },
 { 0xD83CDFADU, },
 { 0xD83CDFA8U, },
 { 0xD83CDFACU, },
 { 0xD83CDFA4U, },
 { 0xD83CDFA7U, },
 { 0xD83CDFBCU, },
 { 0xD83CDFB9U, },
 { 0xD83EDD41U, },
 { 0xD83CDFB7U, },
 { 0xD83CDFBAU, },
 { 0xD83CDFB8U, },
 { 0xD83CDFBBU, },
 { 0xD83CDFB2U, },
 { 0xD83CDFAFU, },
 { 0xD83CDFB3U, },
 { 0xD83CDFAEU, },
 { 0xD83CDFB0U, },
};

InputCategory Category5 = {
 { 0xD83DDE97U, },
 { 0xD83DDE95U, },
 { 0xD83DDE99U, },
 { 0xD83DDE8CU, },
 { 0xD83DDE8EU, },
 { 0xD83CDFCEU, },
 { 0xD83DDE93U, },
 { 0xD83DDE91U, },
 { 0xD83DDE92U, },
 { 0xD83DDE90U, },
 { 0xD83DDE9AU, },
 { 0xD83DDE9BU, },
 { 0xD83DDE9CU, },
 { 0xD83DDEF4U, },
 { 0xD83DDEB2U, },
 { 0xD83DDEF5U, },
 { 0xD83CDFCDU, },
 { 0xD83DDEA8U, },
 { 0xD83DDE94U, },
 { 0xD83DDE8DU, },
 { 0xD83DDE98U, },
 { 0xD83DDE96U, },
 { 0xD83DDEA1U, },
 { 0xD83DDEA0U, },
 { 0xD83DDE9FU, },
 { 0xD83DDE83U, },
 { 0xD83DDE8BU, },
 { 0xD83DDE9EU, },
 { 0xD83DDE9DU, },
 { 0xD83DDE84U, },
 { 0xD83DDE85U, },
 { 0xD83DDE88U, },
 { 0xD83DDE82U, },
 { 0xD83DDE86U, },
 { 0xD83DDE87U, },
 { 0xD83DDE8AU, },
 { 0xD83DDE89U, },
 { 0xD83DDE81U, },
 { 0xD83DDEE9U, },
 { 0x2708U, 0xFE0FU, },
 { 0xD83DDEEBU, },
 { 0xD83DDEECU, },
 { 0xD83DDE80U, },
 { 0xD83DDEF0U, },
 { 0xD83DDCBAU, },
 { 0xD83DDEF6U, },
 { 0x26F5U, 0xFE0FU, },
 { 0xD83DDEE5U, },
 { 0xD83DDEA4U, },
 { 0xD83DDEF3U, },
 { 0x26F4U, },
 { 0xD83DDEA2U, },
 { 0x2693U, 0xFE0FU, },
 { 0xD83DDEA7U, },
 { 0x26FDU, 0xFE0FU, },
 { 0xD83DDE8FU, },
 { 0xD83DDEA6U, },
 { 0xD83DDEA5U, },
 { 0xD83DDDFAU, },
 { 0xD83DDDFFU, },
 { 0xD83DDDFDU, },
 { 0x26F2U, 0xFE0FU, },
 { 0xD83DDDFCU, },
 { 0xD83CDFF0U, },
 { 0xD83CDFEFU, },
 { 0xD83CDFDFU, },
 { 0xD83CDFA1U, },
 { 0xD83CDFA2U, },
 { 0xD83CDFA0U, },
 { 0x26F1U, },
 { 0xD83CDFD6U, },
 { 0xD83CDFDDU, },
 { 0x26F0U, },
 { 0xD83CDFD4U, },
 { 0xD83DDDFBU, },
 { 0xD83CDF0BU, },
 { 0xD83CDFDCU, },
 { 0xD83CDFD5U, },
 { 0x26FAU, 0xFE0FU, },
 { 0xD83DDEE4U, },
 { 0xD83DDEE3U, },
 { 0xD83CDFD7U, },
 { 0xD83CDFEDU, },
 { 0xD83CDFE0U, },
 { 0xD83CDFE1U, },
 { 0xD83CDFD8U, },
 { 0xD83CDFDAU, },
 { 0xD83CDFE2U, },
 { 0xD83CDFECU, },
 { 0xD83CDFE3U, },
 { 0xD83CDFE4U, },
 { 0xD83CDFE5U, },
 { 0xD83CDFE6U, },
 { 0xD83CDFE8U, },
 { 0xD83CDFEAU, },
 { 0xD83CDFEBU, },
 { 0xD83CDFE9U, },
 { 0xD83DDC92U, },
 { 0xD83CDFDBU, },
 { 0x26EAU, 0xFE0FU, },
 { 0xD83DDD4CU, },
 { 0xD83DDD4DU, },
 { 0xD83DDD4BU, },
 { 0x26E9U, },
 { 0xD83DDDFEU, },
 { 0xD83CDF91U, },
 { 0xD83CDFDEU, },
 { 0xD83CDF05U, },
 { 0xD83CDF04U, },
 { 0xD83CDF20U, },
 { 0xD83CDF87U, },
 { 0xD83CDF86U, },
 { 0xD83CDF07U, },
 { 0xD83CDF06U, },
 { 0xD83CDFD9U, },
 { 0xD83CDF03U, },
 { 0xD83CDF0CU, },
 { 0xD83CDF09U, },
 { 0xD83CDF01U, },
};

InputCategory Category6 = {
 { 0x231AU, 0xFE0FU, },
 { 0xD83DDCF1U, },
 { 0xD83DDCF2U, },
 { 0xD83DDCBBU, },
 { 0x2328U, 0xFE0FU, },
 { 0xD83DDDA5U, },
 { 0xD83DDDA8U, },
 { 0xD83DDDB1U, },
 { 0xD83DDDB2U, },
 { 0xD83DDD79U, },
 { 0xD83DDDDCU, },
 { 0xD83DDCBDU, },
 { 0xD83DDCBEU, },
 { 0xD83DDCBFU, },
 { 0xD83DDCC0U, },
 { 0xD83DDCFCU, },
 { 0xD83DDCF7U, },
 { 0xD83DDCF8U, },
 { 0xD83DDCF9U, },
 { 0xD83CDFA5U, },
 { 0xD83DDCFDU, },
 { 0xD83CDF9EU, },
 { 0xD83DDCDEU, },
 { 0x260EU, 0xFE0FU, },
 { 0xD83DDCDFU, },
 { 0xD83DDCE0U, },
 { 0xD83DDCFAU, },
 { 0xD83DDCFBU, },
 { 0xD83CDF99U, },
 { 0xD83CDF9AU, },
 { 0xD83CDF9BU, },
 { 0x23F1U, },
 { 0x23F2U, },
 { 0x23F0U, },
 { 0xD83DDD70U, },
 { 0x231BU, 0xFE0FU, },
 { 0x23F3U, },
 { 0xD83DDCE1U, },
 { 0xD83DDD0BU, },
 { 0xD83DDD0CU, },
 { 0xD83DDCA1U, },
 { 0xD83DDD26U, },
 { 0xD83DDD6FU, },
 { 0xD83DDDD1U, },
 { 0xD83DDEE2U, },
 { 0xD83DDCB8U, },
 { 0xD83DDCB5U, },
 { 0xD83DDCB4U, },
 { 0xD83DDCB6U, },
 { 0xD83DDCB7U, },
 { 0xD83DDCB0U, },
 { 0xD83DDCB3U, },
 { 0xD83DDC8EU, },
 { 0x2696U, 0xFE0FU, },
 { 0xD83DDD27U, },
 { 0xD83DDD28U, },
 { 0x2692U, },
 { 0xD83DDEE0U, },
 { 0x26CFU, },
 { 0xD83DDD29U, },
 { 0x2699U, 0xFE0FU, },
 { 0x26D3U, },
 { 0xD83DDD2BU, },
 { 0xD83DDCA3U, },
 { 0xD83DDD2AU, },
 { 0xD83DDDE1U, },
 { 0x2694U, 0xFE0FU, },
 { 0xD83DDEE1U, },
 { 0xD83DDEACU, },
 { 0x26B0U, 0xFE0FU, },
 { 0x26B1U, 0xFE0FU, },
 { 0xD83CDFFAU, },
 { 0xD83DDD2EU, },
 { 0xD83DDCFFU, },
 { 0xD83DDC88U, },
 { 0x2697U, 0xFE0FU, },
 { 0xD83DDD2DU, },
 { 0xD83DDD2CU, },
 { 0xD83DDD73U, },
 { 0xD83DDC8AU, },
 { 0xD83DDC89U, },
 { 0xD83CDF21U, },
 { 0xD83DDEBDU, },
 { 0xD83DDEB0U, },
 { 0xD83DDEBFU, },
 { 0xD83DDEC1U, },
 { 0xD83DDEC0U, },
 { 0xD83DDECEU, },
 { 0xD83DDD11U, },
 { 0xD83DDDDDU, },
 { 0xD83DDEAAU, },
 { 0xD83DDECBU, },
 { 0xD83DDECFU, },
 { 0xD83DDECCU, },
 { 0xD83DDDBCU, },
 { 0xD83DDECDU, },
 { 0xD83DDED2U, },
 { 0xD83CDF81U, },
 { 0xD83CDF88U, },
 { 0xD83CDF8FU, },
 { 0xD83CDF80U, },
 { 0xD83CDF8AU, },
 { 0xD83CDF89U, },
 { 0xD83CDF8EU, },
 { 0xD83CDFEEU, },
 { 0xD83CDF90U, },
 { 0x2709U, 0xFE0FU, },
 { 0xD83DDCE9U, },
 { 0xD83DDCE8U, },
 { 0xD83DDCE7U, },
 { 0xD83DDC8CU, },
 { 0xD83DDCE5U, },
 { 0xD83DDCE4U, },
 { 0xD83DDCE6U, },
 { 0xD83CDFF7U, },
 { 0xD83DDCEAU, },
 { 0xD83DDCEBU, },
 { 0xD83DDCECU, },
 { 0xD83DDCEDU, },
 { 0xD83DDCEEU, },
 { 0xD83DDCEFU, },
 { 0xD83DDCDCU, },
 { 0xD83DDCC3U, },
 { 0xD83DDCC4U, },
 { 0xD83DDCD1U, },
 { 0xD83DDCCAU, },
 { 0xD83DDCC8U, },
 { 0xD83DDCC9U, },
 { 0xD83DDDD2U, },
 { 0xD83DDDD3U, },
 { 0xD83DDCC6U, },
 { 0xD83DDCC5U, },
 { 0xD83DDCC7U, },
 { 0xD83DDDC3U, },
 { 0xD83DDDF3U, },
 { 0xD83DDDC4U, },
 { 0xD83DDCCBU, },
 { 0xD83DDCC1U, },
 { 0xD83DDCC2U, },
 { 0xD83DDDC2U, },
 { 0xD83DDDDEU, },
 { 0xD83DDCF0U, },
 { 0xD83DDCD3U, },
 { 0xD83DDCD4U, },
 { 0xD83DDCD2U, },
 { 0xD83DDCD5U, },
 { 0xD83DDCD7U, },
 { 0xD83DDCD8U, },
 { 0xD83DDCD9U, },
 { 0xD83DDCDAU, },
 { 0xD83DDCD6U, },
 { 0xD83DDD16U, },
 { 0xD83DDD17U, },
 { 0xD83DDCCEU, },
 { 0xD83DDD87U, },
 { 0xD83DDCD0U, },
 { 0xD83DDCCFU, },
 { 0xD83DDCCCU, },
 { 0xD83DDCCDU, },
 { 0x2702U, 0xFE0FU, },
 { 0xD83DDD8AU, },
 { 0xD83DDD8BU, },
 { 0x2712U, 0xFE0FU, },
 { 0xD83DDD8CU, },
 { 0xD83DDD8DU, },
 { 0xD83DDCDDU, },
 { 0x270FU, 0xFE0FU, },
 { 0xD83DDD0DU, },
 { 0xD83DDD0EU, },
 { 0xD83DDD0FU, },
 { 0xD83DDD10U, },
 { 0xD83DDD12U, },
 { 0xD83DDD13U, },
};

InputCategory Category7 = {
 { 0x2764U, 0xFE0FU, },
 { 0xD83DDC9BU, },
 { 0xD83DDC9AU, },
 { 0xD83DDC99U, },
 { 0xD83DDC9CU, },
 { 0xD83DDDA4U, },
 { 0xD83DDC94U, },
 { 0x2763U, 0xFE0FU, },
 { 0xD83DDC95U, },
 { 0xD83DDC9EU, },
 { 0xD83DDC93U, },
 { 0xD83DDC97U, },
 { 0xD83DDC96U, },
 { 0xD83DDC98U, },
 { 0xD83DDC9DU, },
 { 0xD83DDC9FU, },
 { 0x262EU, 0xFE0FU, },
 { 0x271DU, 0xFE0FU, },
 { 0x262AU, 0xFE0FU, },
 { 0xD83DDD49U, },
 { 0x2638U, 0xFE0FU, },
 { 0x2721U, 0xFE0FU, },
 { 0xD83DDD2FU, },
 { 0xD83DDD4EU, },
 { 0x262FU, 0xFE0FU, },
 { 0x2626U, 0xFE0FU, },
 { 0xD83DDED0U, },
 { 0x26CEU, },
 { 0x2648U, 0xFE0FU, },
 { 0x2649U, 0xFE0FU, },
 { 0x264AU, 0xFE0FU, },
 { 0x264BU, 0xFE0FU, },
 { 0x264CU, 0xFE0FU, },
 { 0x264DU, 0xFE0FU, },
 { 0x264EU, 0xFE0FU, },
 { 0x264FU, 0xFE0FU, },
 { 0x2650U, 0xFE0FU, },
 { 0x2651U, 0xFE0FU, },
 { 0x2652U, 0xFE0FU, },
 { 0x2653U, 0xFE0FU, },
 { 0xD83CDD94U, },
 { 0x269BU, 0xFE0FU, },
 { 0xD83CDE51U, },
 { 0x2622U, 0xFE0FU, },
 { 0x2623U, 0xFE0FU, },
 { 0xD83DDCF4U, },
 { 0xD83DDCF3U, },
 { 0xD83CDE36U, },
 { 0xD83CDE1AU, 0xFE0FU, },
 { 0xD83CDE38U, },
 { 0xD83CDE3AU, },
 { 0xD83CDE37U, },
 { 0x2734U, 0xFE0FU, },
 { 0xD83CDD9AU, },
 { 0xD83DDCAEU, },
 { 0xD83CDE50U, },
 { 0x3299U, 0xFE0FU, },
 { 0x3297U, 0xFE0FU, },
 { 0xD83CDE34U, },
 { 0xD83CDE35U, },
 { 0xD83CDE39U, },
 { 0xD83CDE32U, },
 { 0xD83CDD70U, 0xFE0FU, },
 { 0xD83CDD71U, 0xFE0FU, },
 { 0xD83CDD8EU, },
 { 0xD83CDD91U, },
 { 0xD83CDD7EU, 0xFE0FU, },
 { 0xD83CDD98U, },
 { 0x274CU, },
 { 0x2B55U, 0xFE0FU, },
 { 0xD83DDED1U, },
 { 0x26D4U, 0xFE0FU, },
 { 0xD83DDCDBU, },
 { 0xD83DDEABU, },
 { 0xD83DDCAFU, },
 { 0xD83DDCA2U, },
 { 0x2668U, 0xFE0FU, },
 { 0xD83DDEB7U, },
 { 0xD83DDEAFU, },
 { 0xD83DDEB3U, },
 { 0xD83DDEB1U, },
 { 0xD83DDD1EU, },
 { 0xD83DDCF5U, },
 { 0xD83DDEADU, },
 { 0x2757U, 0xFE0FU, },
 { 0x2755U, },
 { 0x2753U, },
 { 0x2754U, },
 { 0x203CU, 0xFE0FU, },
 { 0x2049U, 0xFE0FU, },
 { 0xD83DDD05U, },
 { 0xD83DDD06U, },
 { 0x303DU, 0xFE0FU, },
 { 0x26A0U, 0xFE0FU, },
 { 0xD83DDEB8U, },
 { 0xD83DDD31U, },
 { 0x269CU, 0xFE0FU, },
 { 0xD83DDD30U, },
 { 0x267BU, 0xFE0FU, },
 { 0x2705U, },
 { 0xD83CDE2FU, 0xFE0FU, },
 { 0xD83DDCB9U, },
 { 0x2747U, 0xFE0FU, },
 { 0x2733U, 0xFE0FU, },
 { 0x274EU, },
 { 0xD83CDF10U, },
 { 0xD83DDCA0U, },
 { 0x24C2U, 0xFE0FU, },
 { 0xD83CDF00U, },
 { 0xD83DDCA4U, },
 { 0xD83CDFE7U, },
 { 0xD83DDEBEU, },
 { 0x267FU, 0xFE0FU, },
 { 0xD83CDD7FU, 0xFE0FU, },
 { 0xD83CDE33U, },
 { 0xD83CDE02U, },
 { 0xD83DDEC2U, },
 { 0xD83DDEC3U, },
 { 0xD83DDEC4U, },
 { 0xD83DDEC5U, },
 { 0xD83DDEB9U, },
 { 0xD83DDEBAU, },
 { 0xD83DDEBCU, },
 { 0xD83DDEBBU, },
 { 0xD83DDEAEU, },
 { 0xD83CDFA6U, },
 { 0xD83DDCF6U, },
 { 0xD83CDE01U, },
 { 0xD83DDD23U, },
 { 0x2139U, 0xFE0FU, },
 { 0xD83DDD24U, },
 { 0xD83DDD21U, },
 { 0xD83DDD20U, },
 { 0xD83CDD96U, },
 { 0xD83CDD97U, },
 { 0xD83CDD99U, },
 { 0xD83CDD92U, },
 { 0xD83CDD95U, },
 { 0xD83CDD93U, },
 { 0x30U, 0xFE0FU, 0x20E3U, },
 { 0x31U, 0xFE0FU, 0x20E3U, },
 { 0x32U, 0xFE0FU, 0x20E3U, },
 { 0x33U, 0xFE0FU, 0x20E3U, },
 { 0x34U, 0xFE0FU, 0x20E3U, },
 { 0x35U, 0xFE0FU, 0x20E3U, },
 { 0x36U, 0xFE0FU, 0x20E3U, },
 { 0x37U, 0xFE0FU, 0x20E3U, },
 { 0x38U, 0xFE0FU, 0x20E3U, },
 { 0x39U, 0xFE0FU, 0x20E3U, },
 { 0xD83DDD1FU, },
 { 0xD83DDD22U, },
 { 0x23U, 0xFE0FU, 0x20E3U, },
 { 0x2AU, 0xFE0FU, 0x20E3U, },
 { 0x25B6U, 0xFE0FU, },
 { 0x23F8U, },
 { 0x23EFU, },
 { 0x23F9U, },
 { 0x23FAU, },
 { 0x23EDU, },
 { 0x23EEU, },
 { 0x23E9U, },
 { 0x23EAU, },
 { 0x23EBU, },
 { 0x23ECU, },
 { 0x25C0U, 0xFE0FU, },
 { 0xD83DDD3CU, },
 { 0xD83DDD3DU, },
 { 0x27A1U, 0xFE0FU, },
 { 0x2B05U, 0xFE0FU, },
 { 0x2B06U, 0xFE0FU, },
 { 0x2B07U, 0xFE0FU, },
 { 0x2197U, 0xFE0FU, },
 { 0x2198U, 0xFE0FU, },
 { 0x2199U, 0xFE0FU, },
 { 0x2196U, 0xFE0FU, },
 { 0x2195U, 0xFE0FU, },
 { 0x2194U, 0xFE0FU, },
 { 0x21AAU, 0xFE0FU, },
 { 0x21A9U, 0xFE0FU, },
 { 0x2934U, 0xFE0FU, },
 { 0x2935U, 0xFE0FU, },
 { 0xD83DDD00U, },
 { 0xD83DDD01U, },
 { 0xD83DDD02U, },
 { 0xD83DDD04U, },
 { 0xD83DDD03U, },
 { 0xD83CDFB5U, },
 { 0xD83CDFB6U, },
 { 0x2795U, },
 { 0x2796U, },
 { 0x2797U, },
 { 0x2716U, 0xFE0FU, },
 { 0xD83DDCB2U, },
 { 0xD83DDCB1U, },
 { 0x2122U, },
 { 0xA9U, },
 { 0xAEU, },
 { 0x3030U, },
 { 0x27B0U, },
 { 0x27BFU, },
 { 0xD83DDD1AU, },
 { 0xD83DDD19U, },
 { 0xD83DDD1BU, },
 { 0xD83DDD1DU, },
 { 0xD83DDD1CU, },
 { 0x2714U, 0xFE0FU, },
 { 0x2611U, 0xFE0FU, },
 { 0xD83DDD18U, },
 { 0x26AAU, 0xFE0FU, },
 { 0x26ABU, 0xFE0FU, },
 { 0xD83DDD34U, },
 { 0xD83DDD35U, },
 { 0xD83DDD3AU, },
 { 0xD83DDD3BU, },
 { 0xD83DDD38U, },
 { 0xD83DDD39U, },
 { 0xD83DDD36U, },
 { 0xD83DDD37U, },
 { 0xD83DDD33U, },
 { 0xD83DDD32U, },
 { 0x25AAU, 0xFE0FU, },
 { 0x25ABU, 0xFE0FU, },
 { 0x25FEU, 0xFE0FU, },
 { 0x25FDU, 0xFE0FU, },
 { 0x25FCU, 0xFE0FU, },
 { 0x25FBU, 0xFE0FU, },
 { 0x2B1BU, 0xFE0FU, },
 { 0x2B1CU, 0xFE0FU, },
 { 0xD83DDD08U, },
 { 0xD83DDD07U, },
 { 0xD83DDD09U, },
 { 0xD83DDD0AU, },
 { 0xD83DDD14U, },
 { 0xD83DDD15U, },
 { 0xD83DDCE3U, },
 { 0xD83DDCE2U, },
 { 0xD83DDC41U, 0x200DU, 0xD83DDDE8U, },
 { 0xD83DDCACU, },
 { 0xD83DDCADU, },
 { 0xD83DDDEFU, },
 { 0x2660U, 0xFE0FU, },
 { 0x2663U, 0xFE0FU, },
 { 0x2665U, 0xFE0FU, },
 { 0x2666U, 0xFE0FU, },
 { 0xD83CDCCFU, },
 { 0xD83CDFB4U, },
 { 0xD83CDC04U, 0xFE0FU, },
 { 0xD83DDD50U, },
 { 0xD83DDD51U, },
 { 0xD83DDD52U, },
 { 0xD83DDD53U, },
 { 0xD83DDD54U, },
 { 0xD83DDD55U, },
 { 0xD83DDD56U, },
 { 0xD83DDD57U, },
 { 0xD83DDD58U, },
 { 0xD83DDD59U, },
 { 0xD83DDD5AU, },
 { 0xD83DDD5BU, },
 { 0xD83DDD5CU, },
 { 0xD83DDD5DU, },
 { 0xD83DDD5EU, },
 { 0xD83DDD5FU, },
 { 0xD83DDD60U, },
 { 0xD83DDD61U, },
 { 0xD83DDD62U, },
 { 0xD83DDD63U, },
 { 0xD83DDD64U, },
 { 0xD83DDD65U, },
 { 0xD83DDD66U, },
 { 0xD83DDD67U, },

//};
//
//InputCategory Category8 = {

 { 0xD83CDFF3U, },
 { 0xD83CDFF4U, },
 { 0xD83CDFC1U, },
 { 0xD83DDEA9U, },
 { 0xD83CDFF3U, 0xFE0FU, 0x200DU, 0xD83CDF08U, },
 { 0xD83CDDE6U, 0xD83CDDEBU, },
 { 0xD83CDDE6U, 0xD83CDDFDU, },
 { 0xD83CDDE6U, 0xD83CDDF1U, },
 { 0xD83CDDE9U, 0xD83CDDFFU, },
 { 0xD83CDDE6U, 0xD83CDDF8U, },
 { 0xD83CDDE6U, 0xD83CDDE9U, },
 { 0xD83CDDE6U, 0xD83CDDF4U, },
 { 0xD83CDDE6U, 0xD83CDDEEU, },
 { 0xD83CDDE6U, 0xD83CDDF6U, },
 { 0xD83CDDE6U, 0xD83CDDECU, },
 { 0xD83CDDE6U, 0xD83CDDF7U, },
 { 0xD83CDDE6U, 0xD83CDDF2U, },
 { 0xD83CDDE6U, 0xD83CDDFCU, },
 { 0xD83CDDE6U, 0xD83CDDFAU, },
 { 0xD83CDDE6U, 0xD83CDDF9U, },
 { 0xD83CDDE6U, 0xD83CDDFFU, },
 { 0xD83CDDE7U, 0xD83CDDF8U, },
 { 0xD83CDDE7U, 0xD83CDDEDU, },
 { 0xD83CDDE7U, 0xD83CDDE9U, },
 { 0xD83CDDE7U, 0xD83CDDE7U, },
 { 0xD83CDDE7U, 0xD83CDDFEU, },
 { 0xD83CDDE7U, 0xD83CDDEAU, },
 { 0xD83CDDE7U, 0xD83CDDFFU, },
 { 0xD83CDDE7U, 0xD83CDDEFU, },
 { 0xD83CDDE7U, 0xD83CDDF2U, },
 { 0xD83CDDE7U, 0xD83CDDF9U, },
 { 0xD83CDDE7U, 0xD83CDDF4U, },
 { 0xD83CDDE7U, 0xD83CDDE6U, },
 { 0xD83CDDE7U, 0xD83CDDFCU, },
 { 0xD83CDDE7U, 0xD83CDDF7U, },
 { 0xD83CDDEEU, 0xD83CDDF4U, },
 { 0xD83CDDFBU, 0xD83CDDECU, },
 { 0xD83CDDE7U, 0xD83CDDF3U, },
 { 0xD83CDDE7U, 0xD83CDDECU, },
 { 0xD83CDDE7U, 0xD83CDDEBU, },
 { 0xD83CDDE7U, 0xD83CDDEEU, },
 { 0xD83CDDF0U, 0xD83CDDEDU, },
 { 0xD83CDDE8U, 0xD83CDDF2U, },
 { 0xD83CDDE8U, 0xD83CDDE6U, },
 { 0xD83CDDEEU, 0xD83CDDE8U, },
 { 0xD83CDDE8U, 0xD83CDDFBU, },
 { 0xD83CDDE7U, 0xD83CDDF6U, },
 { 0xD83CDDF0U, 0xD83CDDFEU, },
 { 0xD83CDDE8U, 0xD83CDDEBU, },
 { 0xD83CDDF9U, 0xD83CDDE9U, },
 { 0xD83CDDE8U, 0xD83CDDF1U, },
 { 0xD83CDDE8U, 0xD83CDDF3U, },
 { 0xD83CDDE8U, 0xD83CDDFDU, },
 { 0xD83CDDE8U, 0xD83CDDE8U, },
 { 0xD83CDDE8U, 0xD83CDDF4U, },
 { 0xD83CDDF0U, 0xD83CDDF2U, },
 { 0xD83CDDE8U, 0xD83CDDECU, },
 { 0xD83CDDE8U, 0xD83CDDE9U, },
 { 0xD83CDDE8U, 0xD83CDDF0U, },
 { 0xD83CDDE8U, 0xD83CDDF7U, },
 { 0xD83CDDE8U, 0xD83CDDEEU, },
 { 0xD83CDDEDU, 0xD83CDDF7U, },
 { 0xD83CDDE8U, 0xD83CDDFAU, },
 { 0xD83CDDE8U, 0xD83CDDFCU, },
 { 0xD83CDDE8U, 0xD83CDDFEU, },
 { 0xD83CDDE8U, 0xD83CDDFFU, },
 { 0xD83CDDE9U, 0xD83CDDF0U, },
 { 0xD83CDDE9U, 0xD83CDDEFU, },
 { 0xD83CDDE9U, 0xD83CDDF2U, },
 { 0xD83CDDE9U, 0xD83CDDF4U, },
 { 0xD83CDDEAU, 0xD83CDDE8U, },
 { 0xD83CDDEAU, 0xD83CDDECU, },
 { 0xD83CDDF8U, 0xD83CDDFBU, },
 { 0xD83CDDECU, 0xD83CDDF6U, },
 { 0xD83CDDEAU, 0xD83CDDF7U, },
 { 0xD83CDDEAU, 0xD83CDDEAU, },
 { 0xD83CDDEAU, 0xD83CDDF9U, },
 { 0xD83CDDEAU, 0xD83CDDFAU, },
 { 0xD83CDDEBU, 0xD83CDDF0U, },
 { 0xD83CDDEBU, 0xD83CDDF4U, },
 { 0xD83CDDEBU, 0xD83CDDEFU, },
 { 0xD83CDDEBU, 0xD83CDDEEU, },
 { 0xD83CDDEBU, 0xD83CDDF7U, },
 { 0xD83CDDECU, 0xD83CDDEBU, },
 { 0xD83CDDF5U, 0xD83CDDEBU, },
 { 0xD83CDDF9U, 0xD83CDDEBU, },
 { 0xD83CDDECU, 0xD83CDDE6U, },
 { 0xD83CDDECU, 0xD83CDDF2U, },
 { 0xD83CDDECU, 0xD83CDDEAU, },
 { 0xD83CDDE9U, 0xD83CDDEAU, },
 { 0xD83CDDECU, 0xD83CDDEDU, },
 { 0xD83CDDECU, 0xD83CDDEEU, },
 { 0xD83CDDECU, 0xD83CDDF7U, },
 { 0xD83CDDECU, 0xD83CDDF1U, },
 { 0xD83CDDECU, 0xD83CDDE9U, },
 { 0xD83CDDECU, 0xD83CDDF5U, },
 { 0xD83CDDECU, 0xD83CDDFAU, },
 { 0xD83CDDECU, 0xD83CDDF9U, },
 { 0xD83CDDECU, 0xD83CDDECU, },
 { 0xD83CDDECU, 0xD83CDDF3U, },
 { 0xD83CDDECU, 0xD83CDDFCU, },
 { 0xD83CDDECU, 0xD83CDDFEU, },
 { 0xD83CDDEDU, 0xD83CDDF9U, },
 { 0xD83CDDEDU, 0xD83CDDF3U, },
 { 0xD83CDDEDU, 0xD83CDDF0U, },
 { 0xD83CDDEDU, 0xD83CDDFAU, },
 { 0xD83CDDEEU, 0xD83CDDF8U, },
 { 0xD83CDDEEU, 0xD83CDDF3U, },
 { 0xD83CDDEEU, 0xD83CDDE9U, },
 { 0xD83CDDEEU, 0xD83CDDF7U, },
 { 0xD83CDDEEU, 0xD83CDDF6U, },
 { 0xD83CDDEEU, 0xD83CDDEAU, },
 { 0xD83CDDEEU, 0xD83CDDF2U, },
 { 0xD83CDDEEU, 0xD83CDDF1U, },
 { 0xD83CDDEEU, 0xD83CDDF9U, },
 { 0xD83CDDEFU, 0xD83CDDF2U, },
 { 0xD83CDDEFU, 0xD83CDDF5U, },
 { 0xD83CDF8CU, },
 { 0xD83CDDEFU, 0xD83CDDEAU, },
 { 0xD83CDDEFU, 0xD83CDDF4U, },
 { 0xD83CDDF0U, 0xD83CDDFFU, },
 { 0xD83CDDF0U, 0xD83CDDEAU, },
 { 0xD83CDDF0U, 0xD83CDDEEU, },
 { 0xD83CDDFDU, 0xD83CDDF0U, },
 { 0xD83CDDF0U, 0xD83CDDFCU, },
 { 0xD83CDDF0U, 0xD83CDDECU, },
 { 0xD83CDDF1U, 0xD83CDDE6U, },
 { 0xD83CDDF1U, 0xD83CDDFBU, },
 { 0xD83CDDF1U, 0xD83CDDE7U, },
 { 0xD83CDDF1U, 0xD83CDDF8U, },
 { 0xD83CDDF1U, 0xD83CDDF7U, },
 { 0xD83CDDF1U, 0xD83CDDFEU, },
 { 0xD83CDDF1U, 0xD83CDDEEU, },
 { 0xD83CDDF1U, 0xD83CDDF9U, },
 { 0xD83CDDF1U, 0xD83CDDFAU, },
 { 0xD83CDDF2U, 0xD83CDDF4U, },
 { 0xD83CDDF2U, 0xD83CDDF0U, },
 { 0xD83CDDF2U, 0xD83CDDECU, },
 { 0xD83CDDF2U, 0xD83CDDFCU, },
 { 0xD83CDDF2U, 0xD83CDDFEU, },
 { 0xD83CDDF2U, 0xD83CDDFBU, },
 { 0xD83CDDF2U, 0xD83CDDF1U, },
 { 0xD83CDDF2U, 0xD83CDDF9U, },
 { 0xD83CDDF2U, 0xD83CDDEDU, },
 { 0xD83CDDF2U, 0xD83CDDF6U, },
 { 0xD83CDDF2U, 0xD83CDDF7U, },
 { 0xD83CDDF2U, 0xD83CDDFAU, },
 { 0xD83CDDFEU, 0xD83CDDF9U, },
 { 0xD83CDDF2U, 0xD83CDDFDU, },
 { 0xD83CDDEBU, 0xD83CDDF2U, },
 { 0xD83CDDF2U, 0xD83CDDE9U, },
 { 0xD83CDDF2U, 0xD83CDDE8U, },
 { 0xD83CDDF2U, 0xD83CDDF3U, },
 { 0xD83CDDF2U, 0xD83CDDEAU, },
 { 0xD83CDDF2U, 0xD83CDDF8U, },
 { 0xD83CDDF2U, 0xD83CDDE6U, },
 { 0xD83CDDF2U, 0xD83CDDFFU, },
 { 0xD83CDDF2U, 0xD83CDDF2U, },
 { 0xD83CDDF3U, 0xD83CDDE6U, },
 { 0xD83CDDF3U, 0xD83CDDF7U, },
 { 0xD83CDDF3U, 0xD83CDDF5U, },
 { 0xD83CDDF3U, 0xD83CDDF1U, },
 { 0xD83CDDF3U, 0xD83CDDE8U, },
 { 0xD83CDDF3U, 0xD83CDDFFU, },
 { 0xD83CDDF3U, 0xD83CDDEEU, },
 { 0xD83CDDF3U, 0xD83CDDEAU, },
 { 0xD83CDDF3U, 0xD83CDDECU, },
 { 0xD83CDDF3U, 0xD83CDDFAU, },
 { 0xD83CDDF3U, 0xD83CDDEBU, },
 { 0xD83CDDF0U, 0xD83CDDF5U, },
 { 0xD83CDDF2U, 0xD83CDDF5U, },
 { 0xD83CDDF3U, 0xD83CDDF4U, },
 { 0xD83CDDF4U, 0xD83CDDF2U, },
 { 0xD83CDDF5U, 0xD83CDDF0U, },
 { 0xD83CDDF5U, 0xD83CDDFCU, },
 { 0xD83CDDF5U, 0xD83CDDF8U, },
 { 0xD83CDDF5U, 0xD83CDDE6U, },
 { 0xD83CDDF5U, 0xD83CDDECU, },
 { 0xD83CDDF5U, 0xD83CDDFEU, },
 { 0xD83CDDF5U, 0xD83CDDEAU, },
 { 0xD83CDDF5U, 0xD83CDDEDU, },
 { 0xD83CDDF5U, 0xD83CDDF3U, },
 { 0xD83CDDF5U, 0xD83CDDF1U, },
 { 0xD83CDDF5U, 0xD83CDDF9U, },
 { 0xD83CDDF5U, 0xD83CDDF7U, },
 { 0xD83CDDF6U, 0xD83CDDE6U, },
 { 0xD83CDDF7U, 0xD83CDDEAU, },
 { 0xD83CDDF7U, 0xD83CDDF4U, },
 { 0xD83CDDF7U, 0xD83CDDFAU, },
 { 0xD83CDDF7U, 0xD83CDDFCU, },
 { 0xD83CDDFCU, 0xD83CDDF8U, },
 { 0xD83CDDF8U, 0xD83CDDF2U, },
 { 0xD83CDDF8U, 0xD83CDDF9U, },
 { 0xD83CDDF8U, 0xD83CDDE6U, },
 { 0xD83CDDF8U, 0xD83CDDF3U, },
 { 0xD83CDDF7U, 0xD83CDDF8U, },
 { 0xD83CDDF8U, 0xD83CDDE8U, },
 { 0xD83CDDF8U, 0xD83CDDF1U, },
 { 0xD83CDDF8U, 0xD83CDDECU, },
 { 0xD83CDDF8U, 0xD83CDDFDU, },
 { 0xD83CDDF8U, 0xD83CDDF0U, },
 { 0xD83CDDF8U, 0xD83CDDEEU, },
 { 0xD83CDDECU, 0xD83CDDF8U, },
 { 0xD83CDDF8U, 0xD83CDDE7U, },
 { 0xD83CDDF8U, 0xD83CDDF4U, },
 { 0xD83CDDFFU, 0xD83CDDE6U, },
 { 0xD83CDDF0U, 0xD83CDDF7U, },
 { 0xD83CDDF8U, 0xD83CDDF8U, },
 { 0xD83CDDEAU, 0xD83CDDF8U, },
 { 0xD83CDDF1U, 0xD83CDDF0U, },
 { 0xD83CDDE7U, 0xD83CDDF1U, },
 { 0xD83CDDF8U, 0xD83CDDEDU, },
 { 0xD83CDDF0U, 0xD83CDDF3U, },
 { 0xD83CDDF1U, 0xD83CDDE8U, },
 { 0xD83CDDF5U, 0xD83CDDF2U, },
 { 0xD83CDDFBU, 0xD83CDDE8U, },
 { 0xD83CDDF8U, 0xD83CDDE9U, },
 { 0xD83CDDF8U, 0xD83CDDF7U, },
 { 0xD83CDDF8U, 0xD83CDDFFU, },
 { 0xD83CDDF8U, 0xD83CDDEAU, },
 { 0xD83CDDE8U, 0xD83CDDEDU, },
 { 0xD83CDDF8U, 0xD83CDDFEU, },
 { 0xD83CDDF9U, 0xD83CDDFCU, },
 { 0xD83CDDF9U, 0xD83CDDEFU, },
 { 0xD83CDDF9U, 0xD83CDDFFU, },
 { 0xD83CDDF9U, 0xD83CDDEDU, },
 { 0xD83CDDF9U, 0xD83CDDF1U, },
 { 0xD83CDDF9U, 0xD83CDDECU, },
 { 0xD83CDDF9U, 0xD83CDDF0U, },
 { 0xD83CDDF9U, 0xD83CDDF4U, },
 { 0xD83CDDF9U, 0xD83CDDF9U, },
 { 0xD83CDDF9U, 0xD83CDDF3U, },
 { 0xD83CDDF9U, 0xD83CDDF7U, },
 { 0xD83CDDF9U, 0xD83CDDF2U, },
 { 0xD83CDDF9U, 0xD83CDDE8U, },
 { 0xD83CDDF9U, 0xD83CDDFBU, },
 { 0xD83CDDFBU, 0xD83CDDEEU, },
 { 0xD83CDDFAU, 0xD83CDDECU, },
 { 0xD83CDDFAU, 0xD83CDDE6U, },
 { 0xD83CDDE6U, 0xD83CDDEAU, },
 { 0xD83CDDECU, 0xD83CDDE7U, },
 { 0xD83CDDFAU, 0xD83CDDF8U, },
 { 0xD83CDDFAU, 0xD83CDDFEU, },
 { 0xD83CDDFAU, 0xD83CDDFFU, },
 { 0xD83CDDFBU, 0xD83CDDFAU, },
 { 0xD83CDDFBU, 0xD83CDDE6U, },
 { 0xD83CDDFBU, 0xD83CDDEAU, },
 { 0xD83CDDFBU, 0xD83CDDF3U, },
 { 0xD83CDDFCU, 0xD83CDDEBU, },
 { 0xD83CDDEAU, 0xD83CDDEDU, },
 { 0xD83CDDFEU, 0xD83CDDEAU, },
 { 0xD83CDDFFU, 0xD83CDDF2U, },
 { 0xD83CDDFFU, 0xD83CDDFCU, },
};

} // namespace old
} // namespace
} // namespace emoji
} // namespace codegen
