/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import de.regnis.q.sequence.line.diff.QDiffGenerator;
import de.regnis.q.sequence.line.diff.QDiffManager;
import de.regnis.q.sequence.line.diff.QDiffUniGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNReturnValueCallback;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnDiffGenerator
implements ISvnDiffGenerator {
    protected static final String WC_REVISION_LABEL = "(working copy)";
    protected static final String PROPERTIES_SEPARATOR = "___________________________________________________________________";
    protected static final String HEADER_SEPARATOR = "===================================================================";
    protected static final String HEADER_ENCODING = "UTF-8";
    private SvnTarget originalTarget1 = null;
    private SvnTarget originalTarget2 = null;
    private SvnTarget baseTarget;
    private SvnTarget relativeToTarget;
    private SvnTarget repositoryRoot;
    private String encoding;
    private byte[] eol;
    private boolean useGitFormat;
    private boolean forcedBinaryDiff;
    private boolean diffDeleted = true;
    private boolean diffAdded = true;
    private List<String> rawDiffOptions;
    private boolean forceEmpty;
    private Set<String> visitedPaths = new HashSet<String>();
    private String externalDiffCommand;
    private SVNDiffOptions diffOptions;
    private boolean fallbackToAbsolutePath;
    private ISVNOptions options;
    private boolean propertiesOnly;
    private boolean ignoreProperties;

    private String getDisplayPath(SvnTarget target) {
        String relativePath;
        if (this.baseTarget == null) {
            relativePath = null;
        } else {
            String targetString = target.getPathOrUrlDecodedString();
            String baseTargetString = this.baseTarget.getPathOrUrlDecodedString();
            relativePath = this.getRelativePath(targetString, baseTargetString);
        }
        return relativePath != null ? relativePath : target.getPathOrUrlString();
    }

    private String getRelativeToRootPath(SvnTarget target, SvnTarget originalTarget) {
        String relativePath;
        if (this.repositoryRoot == null) {
            relativePath = null;
        } else if (this.repositoryRoot.isFile() == target.isFile()) {
            String targetString = target.getPathOrUrlDecodedString();
            String baseTargetString = this.repositoryRoot.getPathOrUrlDecodedString();
            relativePath = this.getRelativePath(targetString, baseTargetString);
        } else {
            String targetString = target.getPathOrUrlDecodedString();
            String baseTargetString = new File("").getAbsolutePath();
            relativePath = this.getRelativePath(targetString, baseTargetString);
        }
        return relativePath != null ? relativePath : target.getPathOrUrlString();
    }

    private String getRelativePath(String targetString, String baseTargetString) {
        String pathAsChild;
        if (targetString != null) {
            targetString = targetString.replace(File.separatorChar, '/');
        }
        if (baseTargetString != null) {
            baseTargetString = baseTargetString.replace(File.separatorChar, '/');
        }
        if ((pathAsChild = SVNPathUtil.getPathAsChild(baseTargetString, targetString)) != null) {
            return pathAsChild;
        }
        if (targetString.equals(baseTargetString)) {
            return "";
        }
        return null;
    }

    private String getChildPath(String path, String relativeToPath) {
        if (this.relativeToTarget == null) {
            return null;
        }
        String relativePath = this.getRelativePath(path, relativeToPath);
        if (relativePath == null) {
            return path;
        }
        if (relativePath.length() > 0) {
            return relativePath;
        }
        if (relativeToPath.equals(path)) {
            return ".";
        }
        return null;
    }

    @Override
    public void setBaseTarget(SvnTarget baseTarget) {
        this.baseTarget = baseTarget;
    }

    @Override
    public void setUseGitFormat(boolean useGitFormat) {
        this.useGitFormat = useGitFormat;
    }

    @Override
    public void setOriginalTargets(SvnTarget originalTarget1, SvnTarget originalTarget2) {
        this.originalTarget1 = originalTarget1;
        this.originalTarget2 = originalTarget2;
    }

    public void setRelativeToTarget(SvnTarget relativeToTarget) {
        this.relativeToTarget = relativeToTarget;
    }

    @Override
    public void setAnchors(SvnTarget originalTarget1, SvnTarget originalTarget2) {
    }

    @Override
    public void setRepositoryRoot(SvnTarget repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
    }

    @Override
    public void setForceEmpty(boolean forceEmpty) {
        this.forceEmpty = forceEmpty;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getGlobalEncoding() {
        ISVNOptions options = this.getOptions();
        if (options != null && options instanceof DefaultSVNOptions) {
            DefaultSVNOptions defaultOptions = (DefaultSVNOptions)options;
            return defaultOptions.getGlobalCharset();
        }
        return null;
    }

    @Override
    public void setEOL(byte[] eol) {
        this.eol = eol;
    }

    @Override
    public byte[] getEOL() {
        return this.eol;
    }

    @Override
    public boolean isForcedBinaryDiff() {
        return this.forcedBinaryDiff;
    }

    @Override
    public void setForcedBinaryDiff(boolean forcedBinaryDiff) {
        this.forcedBinaryDiff = forcedBinaryDiff;
    }

    public boolean isPropertiesOnly() {
        return this.propertiesOnly;
    }

    public void setPropertiesOnly(boolean propertiesOnly) {
        this.propertiesOnly = propertiesOnly;
    }

    public boolean isIgnoreProperties() {
        return this.ignoreProperties;
    }

    public void setIgnoreProperties(boolean ignoreProperties) {
        this.ignoreProperties = ignoreProperties;
    }

    @Override
    public void displayDeletedDirectory(SvnTarget target, String revision1, String revision2, OutputStream outputStream) throws SVNException {
    }

    @Override
    public void displayAddedDirectory(SvnTarget target, String revision1, String revision2, OutputStream outputStream) throws SVNException {
    }

    @Override
    public void displayPropsChanged(SvnTarget target, String revision1, String revision2, boolean dirWasAdded, SVNProperties originalProps, SVNProperties propChanges, OutputStream outputStream) throws SVNException {
        boolean showDiffHeader;
        if (this.isIgnoreProperties()) {
            return;
        }
        this.ensureEncodingAndEOLSet();
        String displayPath = this.getDisplayPath(target);
        String targetString1 = this.originalTarget1.getPathOrUrlDecodedString();
        String targetString2 = this.originalTarget2.getPathOrUrlDecodedString();
        if (displayPath == null || displayPath.length() == 0) {
            displayPath = ".";
        }
        boolean bl = showDiffHeader = !this.visitedPaths.contains(displayPath);
        if (showDiffHeader) {
            if (this.useGitFormat) {
                targetString1 = this.adjustRelativeToReposRoot(targetString1);
                targetString2 = this.adjustRelativeToReposRoot(targetString2);
            }
            String newTargetString = displayPath;
            String newTargetString1 = targetString1;
            String newTargetString2 = targetString2;
            String commonAncestor = SVNPathUtil.getCommonPathAncestor(newTargetString1, newTargetString2);
            int commonLength = commonAncestor == null ? 0 : commonAncestor.length();
            newTargetString1 = newTargetString1.substring(commonLength);
            newTargetString2 = newTargetString2.substring(commonLength);
            newTargetString1 = this.computeLabel(newTargetString, newTargetString1);
            newTargetString2 = this.computeLabel(newTargetString, newTargetString2);
            if (this.relativeToTarget != null) {
                String childPath2;
                String childPath1;
                String relativeToPath = this.relativeToTarget.getPathOrUrlDecodedString();
                String absolutePath = target.getPathOrUrlDecodedString();
                String childPath = this.getChildPath(absolutePath, relativeToPath);
                if (childPath == null) {
                    this.throwBadRelativePathException(absolutePath, relativeToPath);
                }
                if ((childPath1 = this.getChildPath(newTargetString1, relativeToPath)) == null) {
                    this.throwBadRelativePathException(newTargetString1, relativeToPath);
                }
                if ((childPath2 = this.getChildPath(newTargetString2, relativeToPath)) == null) {
                    this.throwBadRelativePathException(newTargetString2, relativeToPath);
                }
                displayPath = childPath;
                newTargetString1 = childPath1;
                newTargetString2 = childPath2;
            }
            String label1 = this.getLabel(newTargetString1, revision1);
            String label2 = this.getLabel(newTargetString2, revision2);
            boolean shouldStopDisplaying = this.displayHeader(outputStream, displayPath, false, this.fallbackToAbsolutePath, SvnDiffCallback.OperationKind.Modified);
            this.visitedPaths.add(displayPath);
            if (this.useGitFormat) {
                this.displayGitDiffHeader(outputStream, SvnDiffCallback.OperationKind.Modified, this.getRelativeToRootPath(target, this.originalTarget1), this.getRelativeToRootPath(target, this.originalTarget2), null);
            }
            if (shouldStopDisplaying) {
                return;
            }
            if (this.useGitFormat) {
                this.displayGitHeaderFields(outputStream, target, revision1, revision2, SvnDiffCallback.OperationKind.Modified, null);
            } else {
                this.displayHeaderFields(outputStream, label1, label2);
            }
        }
        this.displayPropertyChangesOn(this.useGitFormat ? this.getRelativeToRootPath(target, this.originalTarget1) : displayPath, outputStream);
        this.displayPropDiffValues(outputStream, propChanges, originalProps);
    }

    private void throwBadRelativePathException(String displayPath, String relativeToPath) throws SVNException {
        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_RELATIVE_PATH, "Path ''{0}'' must be an immediate child of the directory ''{0}''", displayPath, relativeToPath);
        SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
    }

    private void displayGitHeaderFields(OutputStream outputStream, SvnTarget target, String revision1, String revision2, SvnDiffCallback.OperationKind operation, String copyFromPath) throws SVNException {
        String path1 = copyFromPath != null ? copyFromPath : this.getRelativeToRootPath(target, this.originalTarget1);
        String path2 = this.getRelativeToRootPath(target, this.originalTarget2);
        try {
            this.displayString(outputStream, "--- ");
            this.displayFirstGitLabelPath(outputStream, path1, revision1, operation);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "+++ ");
            this.displaySecondGitLabelPath(outputStream, path2, revision2, operation);
            this.displayEOL(outputStream);
        }
        catch (IOException e) {
            this.wrapException(e);
        }
    }

    private String adjustRelativeToReposRoot(String targetString) {
        if (this.repositoryRoot != null) {
            String repositoryRootString = this.repositoryRoot.getPathOrUrlDecodedString();
            String relativePath = this.getRelativePath(targetString, repositoryRootString);
            return relativePath == null ? "" : relativePath;
        }
        return targetString;
    }

    private String computeLabel(String targetString, String originalTargetString) {
        if (originalTargetString.length() == 0) {
            return targetString;
        }
        if (originalTargetString.charAt(0) == '/') {
            return targetString + "\t(..." + originalTargetString + ")";
        }
        return targetString + "\t(.../" + originalTargetString + ")";
    }

    @Override
    public void displayContentChanged(SvnTarget target, File leftFile, File rightFile, String revision1, String revision2, String mimeType1, String mimeType2, SvnDiffCallback.OperationKind operation, File copyFromPath, OutputStream outputStream) throws SVNException {
        if (this.isPropertiesOnly()) {
            return;
        }
        this.ensureEncodingAndEOLSet();
        String displayPath = this.getDisplayPath(target);
        String targetString1 = this.originalTarget1.getPathOrUrlDecodedString();
        String targetString2 = this.originalTarget2.getPathOrUrlDecodedString();
        if (this.useGitFormat) {
            targetString1 = this.adjustRelativeToReposRoot(targetString1);
            targetString2 = this.adjustRelativeToReposRoot(targetString2);
        }
        String newTargetString = displayPath;
        String newTargetString1 = targetString1;
        String newTargetString2 = targetString2;
        String commonAncestor = SVNPathUtil.getCommonPathAncestor(newTargetString1, newTargetString2);
        int commonLength = commonAncestor == null ? 0 : commonAncestor.length();
        newTargetString1 = newTargetString1.substring(commonLength);
        newTargetString2 = newTargetString2.substring(commonLength);
        newTargetString1 = this.computeLabel(newTargetString, newTargetString1);
        newTargetString2 = this.computeLabel(newTargetString, newTargetString2);
        if (this.relativeToTarget != null) {
            String childPath2;
            String childPath1;
            String relativeToPath = this.relativeToTarget.getPathOrUrlDecodedString();
            String absolutePath = target.getPathOrUrlDecodedString();
            String childPath = this.getChildPath(absolutePath, relativeToPath);
            if (childPath == null) {
                this.throwBadRelativePathException(absolutePath, relativeToPath);
            }
            if ((childPath1 = this.getChildPath(newTargetString1, relativeToPath)) == null) {
                this.throwBadRelativePathException(newTargetString1, relativeToPath);
            }
            if ((childPath2 = this.getChildPath(newTargetString2, relativeToPath)) == null) {
                this.throwBadRelativePathException(newTargetString2, relativeToPath);
            }
            displayPath = childPath;
            newTargetString1 = childPath1;
            newTargetString2 = childPath2;
        }
        String label1 = this.getLabel(newTargetString1, revision1);
        String label2 = this.getLabel(newTargetString2, revision2);
        boolean leftIsBinary = false;
        boolean rightIsBinary = false;
        if (mimeType1 != null) {
            leftIsBinary = SVNProperty.isBinaryMimeType(mimeType1);
        }
        if (mimeType2 != null) {
            rightIsBinary = SVNProperty.isBinaryMimeType(mimeType2);
        }
        if (!this.forcedBinaryDiff && (leftIsBinary || rightIsBinary)) {
            boolean shouldStopDisplaying = this.displayHeader(outputStream, displayPath, rightFile == null, leftFile == null, operation);
            if (this.useGitFormat) {
                this.displayGitDiffHeader(outputStream, operation, this.getRelativeToRootPath(target, this.originalTarget1), this.getRelativeToRootPath(target, this.originalTarget2), null);
            }
            this.visitedPaths.add(displayPath);
            if (shouldStopDisplaying) {
                return;
            }
            this.displayBinary(mimeType1, mimeType2, outputStream, leftIsBinary, rightIsBinary);
            return;
        }
        String diffCommand = this.getExternalDiffCommand();
        if (diffCommand != null) {
            boolean shouldStopDisplaying = this.displayHeader(outputStream, displayPath, rightFile == null, leftFile == null, operation);
            if (this.useGitFormat) {
                this.displayGitDiffHeader(outputStream, operation, this.getRelativeToRootPath(target, this.originalTarget1), this.getRelativeToRootPath(target, this.originalTarget2), null);
            }
            this.visitedPaths.add(displayPath);
            if (shouldStopDisplaying) {
                return;
            }
            this.runExternalDiffCommand(outputStream, diffCommand, leftFile, rightFile, label1, label2);
        } else {
            this.internalDiff(target, outputStream, displayPath, leftFile, rightFile, label1, label2, operation, copyFromPath == null ? null : copyFromPath.getPath(), revision1, revision2);
        }
    }

    private void displayBinary(String mimeType1, String mimeType2, OutputStream outputStream, boolean leftIsBinary, boolean rightIsBinary) throws SVNException {
        this.displayCannotDisplayFileMarkedBinary(outputStream);
        if (leftIsBinary && !rightIsBinary) {
            this.displayMimeType(outputStream, mimeType1);
        } else if (!leftIsBinary && rightIsBinary) {
            this.displayMimeType(outputStream, mimeType2);
        } else if (leftIsBinary && rightIsBinary) {
            if (mimeType1.equals(mimeType2)) {
                this.displayMimeType(outputStream, mimeType1);
            } else {
                this.displayMimeTypes(outputStream, mimeType1, mimeType2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDiff(SvnTarget target, OutputStream outputStream, String displayPath, File file1, File file2, String label1, String label2, SvnDiffCallback.OperationKind operation, String copyFromPath, String revision1, String revision2) throws SVNException {
        String header = this.getHeaderString(target, displayPath, file2 == null, file1 == null, operation, copyFromPath);
        if (file2 == null && !this.isDiffDeleted()) {
            try {
                this.displayString(outputStream, header);
            }
            catch (IOException e) {
                this.wrapException(e);
            }
            return;
        }
        if (file1 == null && !this.isDiffAdded()) {
            try {
                this.displayString(outputStream, header);
            }
            catch (IOException e) {
                this.wrapException(e);
            }
            return;
        }
        String headerFields = this.getHeaderFieldsString(target, displayPath, label1, label2, revision1, revision2, operation, copyFromPath);
        RandomAccessFile is1 = null;
        RandomAccessFile is2 = null;
        try {
            String diffHeader;
            is1 = file1 == null ? null : SVNFileUtil.openRAFileForReading(file1);
            is2 = file2 == null ? null : SVNFileUtil.openRAFileForReading(file2);
            QDiffUniGenerator.setup();
            SVNHashMap properties = new SVNHashMap();
            properties.put("ignore-eol-style", this.getDiffOptions().isIgnoreEOLStyle());
            properties.put("eol", new String(this.getEOL()));
            if (this.getDiffOptions().isIgnoreAllWhitespace()) {
                properties.put("ignore-space", "all-space");
            } else if (this.getDiffOptions().isIgnoreAmountOfWhitespace()) {
                properties.put("ignore-space", "space-change");
            }
            if (this.forceEmpty || this.useGitFormat) {
                this.displayString(outputStream, header);
                diffHeader = headerFields;
                this.visitedPaths.add(displayPath);
            } else {
                diffHeader = header + headerFields;
            }
            QDiffUniGenerator generator = new QDiffUniGenerator((Map)properties, diffHeader);
            EmptyDetectionWriter writer = new EmptyDetectionWriter(new OutputStreamWriter(outputStream, HEADER_ENCODING));
            QDiffManager.generateTextDiff((RandomAccessFile)is1, (RandomAccessFile)is2, null, (Writer)writer, (QDiffGenerator)generator);
            if (writer.isSomethingWritten()) {
                this.visitedPaths.add(displayPath);
            }
            writer.flush();
        }
        catch (IOException e) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
                SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(is1);
                SVNFileUtil.closeFile(is2);
                throw throwable;
            }
            SVNFileUtil.closeFile(is1);
            SVNFileUtil.closeFile(is2);
        }
        SVNFileUtil.closeFile(is1);
        SVNFileUtil.closeFile(is2);
    }

    private String getHeaderFieldsString(SvnTarget target, String displayPath, String label1, String label2, String revision1, String revision2, SvnDiffCallback.OperationKind operation, String copyFromPath) throws SVNException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (this.useGitFormat) {
                this.displayGitHeaderFields(byteArrayOutputStream, target, revision1, revision2, operation, copyFromPath);
            } else {
                this.displayHeaderFields(byteArrayOutputStream, label1, label2);
            }
        }
        catch (SVNException e) {
            SVNFileUtil.closeFile(byteArrayOutputStream);
            try {
                byteArrayOutputStream.writeTo(byteArrayOutputStream);
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw e;
        }
        try {
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toString(HEADER_ENCODING);
        }
        catch (IOException e) {
            return "";
        }
    }

    private String getHeaderString(SvnTarget target, String displayPath, boolean deleted, boolean added, SvnDiffCallback.OperationKind operation, String copyFromPath) throws SVNException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            boolean stopDisplaying = this.displayHeader(byteArrayOutputStream, displayPath, deleted, added, operation);
            if (this.useGitFormat) {
                this.displayGitDiffHeader(byteArrayOutputStream, operation, this.getRelativeToRootPath(target, this.originalTarget1), this.getRelativeToRootPath(target, this.originalTarget2), copyFromPath);
            }
        }
        catch (SVNException e) {
            SVNFileUtil.closeFile(byteArrayOutputStream);
            try {
                byteArrayOutputStream.writeTo(byteArrayOutputStream);
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw e;
        }
        try {
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toString(HEADER_ENCODING);
        }
        catch (IOException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExternalDiffCommand(OutputStream outputStream, final String diffCommand, File file1, File file2, String label1, String label2) throws SVNException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(diffCommand);
        if (this.rawDiffOptions != null) {
            args.addAll(this.rawDiffOptions);
        } else {
            Collection svnDiffOptionsCollection = this.getDiffOptions().toOptionsCollection();
            args.addAll(svnDiffOptionsCollection);
            args.add("-u");
        }
        if (label1 != null) {
            args.add("-L");
            args.add(label1);
        }
        if (label2 != null) {
            args.add("-L");
            args.add(label2);
        }
        boolean tmpFile1 = false;
        boolean tmpFile2 = false;
        if (file1 == null) {
            file1 = SVNFileUtil.createTempFile("svn.", ".tmp");
            tmpFile1 = true;
        }
        if (file2 == null) {
            file2 = SVNFileUtil.createTempFile("svn.", ".tmp");
            tmpFile2 = true;
        }
        String file1Path = file1.getAbsolutePath().replace(File.separatorChar, '/');
        String file2Path = file2.getAbsolutePath().replace(File.separatorChar, '/');
        args.add(file1Path);
        args.add(file2Path);
        try {
            final OutputStreamWriter writer = new OutputStreamWriter(outputStream, this.getEncoding());
            SVNFileUtil.execCommand(args.toArray(new String[args.size()]), true, new ISVNReturnValueCallback(){

                @Override
                public void handleReturnValue(int returnValue) throws SVNException {
                    if (returnValue != 0 && returnValue != 1) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.EXTERNAL_PROGRAM, "''{0}'' returned {1}", diffCommand, String.valueOf(returnValue));
                        SVNErrorManager.error(err, SVNLogType.DEFAULT);
                    }
                }

                @Override
                public void handleChar(char ch) throws SVNException {
                    try {
                        writer.write(ch);
                    }
                    catch (IOException ioe) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getMessage());
                        SVNErrorManager.error(err, ioe, SVNLogType.DEFAULT);
                    }
                }

                @Override
                public boolean isHandleProgramOutput() {
                    return true;
                }
            });
            ((Writer)writer).flush();
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.DEFAULT);
        }
        finally {
            try {
                if (tmpFile1) {
                    SVNFileUtil.deleteFile(file1);
                }
                if (tmpFile2) {
                    SVNFileUtil.deleteFile(file2);
                }
            }
            catch (SVNException e) {}
        }
    }

    private String getExternalDiffCommand() {
        return this.externalDiffCommand;
    }

    private void displayMimeType(OutputStream outputStream, String mimeType) throws SVNException {
        try {
            this.displayString(outputStream, "svn:mime-type");
            this.displayString(outputStream, " = ");
            this.displayString(outputStream, mimeType);
            this.displayEOL(outputStream);
        }
        catch (IOException e) {
            this.wrapException(e);
        }
    }

    private void displayMimeTypes(OutputStream outputStream, String mimeType1, String mimeType2) throws SVNException {
        try {
            this.displayString(outputStream, "svn:mime-type");
            this.displayString(outputStream, " = (");
            this.displayString(outputStream, mimeType1);
            this.displayString(outputStream, ", ");
            this.displayString(outputStream, mimeType2);
            this.displayString(outputStream, ")");
            this.displayEOL(outputStream);
        }
        catch (IOException e) {
            this.wrapException(e);
        }
    }

    private void displayCannotDisplayFileMarkedBinary(OutputStream outputStream) throws SVNException {
        try {
            this.displayString(outputStream, "Cannot display: file marked as a binary type.");
            this.displayEOL(outputStream);
        }
        catch (IOException e) {
            this.wrapException(e);
        }
    }

    private void ensureEncodingAndEOLSet() {
        if (this.getEOL() == null) {
            this.setEOL(SVNProperty.EOL_LF_BYTES);
        }
        if (this.getEncoding() == null) {
            ISVNOptions options = this.getOptions();
            if (options != null && options.getNativeCharset() != null) {
                this.setEncoding(options.getNativeCharset());
            } else {
                this.setEncoding(HEADER_ENCODING);
            }
        }
    }

    private void displayPropDiffValues(OutputStream outputStream, SVNProperties diff, SVNProperties baseProps) throws SVNException {
        for (String name : diff.nameSet()) {
            SVNPropertyValue originalValue = baseProps != null ? baseProps.getSVNPropertyValue(name) : null;
            SVNPropertyValue newValue = diff.getSVNPropertyValue(name);
            String headerFormat = null;
            headerFormat = originalValue == null ? "Added: " : (newValue == null ? "Deleted: " : "Modified: ");
            try {
                this.displayString(outputStream, headerFormat + name);
                this.displayEOL(outputStream);
                if ("svn:mergeinfo".equals(name)) {
                    this.displayMergeInfoDiff(outputStream, originalValue == null ? null : originalValue.getString(), newValue == null ? null : newValue.getString());
                    continue;
                }
                byte[] originalValueBytes = this.getPropertyAsBytes(originalValue, this.getEncoding());
                byte[] newValueBytes = this.getPropertyAsBytes(newValue, this.getEncoding());
                originalValueBytes = originalValueBytes == null ? new byte[]{} : this.maybeAppendEOL(originalValueBytes);
                boolean newValueHadEol = newValueBytes != null && newValueBytes.length > 0 && (newValueBytes[newValueBytes.length - 1] == SVNProperty.EOL_CR_BYTES[0] || newValueBytes[newValueBytes.length - 1] == SVNProperty.EOL_LF_BYTES[0]);
                newValueBytes = newValueBytes == null ? new byte[]{} : this.maybeAppendEOL(newValueBytes);
                QDiffUniGenerator.setup();
                SVNHashMap properties = new SVNHashMap();
                properties.put("ignore-eol-style", this.getDiffOptions().isIgnoreEOLStyle());
                properties.put("eol", new String(this.getEOL()));
                properties.put("hunk-delimiter", "##");
                if (this.getDiffOptions().isIgnoreAllWhitespace()) {
                    properties.put("ignore-space", "all-space");
                } else if (this.getDiffOptions().isIgnoreAmountOfWhitespace()) {
                    properties.put("ignore-space", "space-change");
                }
                QDiffUniGenerator generator = new QDiffUniGenerator((Map)properties, "");
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, this.getEncoding());
                QDiffManager.generateTextDiff((InputStream)new ByteArrayInputStream(originalValueBytes), (InputStream)new ByteArrayInputStream(newValueBytes), null, (Writer)writer, (QDiffGenerator)generator);
                ((Writer)writer).flush();
                if (newValueHadEol) continue;
                this.displayString(outputStream, "\\ No newline at end of property");
                this.displayEOL(outputStream);
            }
            catch (IOException e) {
                this.wrapException(e);
            }
        }
    }

    private byte[] maybeAppendEOL(byte[] buffer) {
        if (buffer.length == 0) {
            return buffer;
        }
        byte lastByte = buffer[buffer.length - 1];
        if (lastByte == SVNProperty.EOL_CR_BYTES[0]) {
            return buffer;
        }
        if (lastByte != SVNProperty.EOL_LF_BYTES[0]) {
            byte[] newBuffer = new byte[buffer.length + this.getEOL().length];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            System.arraycopy(this.getEOL(), 0, newBuffer, buffer.length, this.getEOL().length);
            return newBuffer;
        }
        return buffer;
    }

    private String getGitDiffLabel1(SvnDiffCallback.OperationKind operationKind, String path1, String path2, String copyFromPath, String revision) {
        if (operationKind == SvnDiffCallback.OperationKind.Deleted) {
            return this.getLabel("a/" + path1, revision);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Copied) {
            return this.getLabel("a/" + copyFromPath, revision);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Added) {
            return this.getLabel("/dev/null", revision);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Modified) {
            return this.getLabel("a/" + path1, revision);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Moved) {
            return this.getLabel("a/" + copyFromPath, revision);
        }
        throw new IllegalArgumentException("Unsupported operation: " + (Object)((Object)operationKind));
    }

    private String getGitDiffLabel2(SvnDiffCallback.OperationKind operationKind, String path1, String path2, String copyFromPath, String revision) {
        if (operationKind == SvnDiffCallback.OperationKind.Deleted) {
            return this.getLabel("/dev/null", revision);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Copied) {
            return this.getLabel("b/" + path2, revision);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Added) {
            return this.getLabel("b/" + path2, revision);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Modified) {
            return this.getLabel("b/" + path2, revision);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Moved) {
            return this.getLabel("b/" + path2, revision);
        }
        throw new IllegalArgumentException("Unsupported operation: " + (Object)((Object)operationKind));
    }

    private void displayGitDiffHeader(OutputStream outputStream, SvnDiffCallback.OperationKind operationKind, String path1, String path2, String copyFromPath) throws SVNException {
        if (operationKind == SvnDiffCallback.OperationKind.Deleted) {
            this.displayGitDiffHeaderDeleted(outputStream, path1, path2, copyFromPath);
        } else if (operationKind == SvnDiffCallback.OperationKind.Copied) {
            this.displayGitDiffHeaderCopied(outputStream, path1, path2, copyFromPath);
        } else if (operationKind == SvnDiffCallback.OperationKind.Added) {
            this.displayGitDiffHeaderAdded(outputStream, path1, path2, copyFromPath);
        } else if (operationKind == SvnDiffCallback.OperationKind.Modified) {
            this.displayGitDiffHeaderModified(outputStream, path1, path2, copyFromPath);
        } else if (operationKind == SvnDiffCallback.OperationKind.Moved) {
            this.displayGitDiffHeaderRenamed(outputStream, path1, path2, copyFromPath);
        }
    }

    private void displayGitDiffHeaderAdded(OutputStream outputStream, String path1, String path2, String copyFromPath) throws SVNException {
        try {
            this.displayString(outputStream, "diff --git ");
            this.displayFirstGitPath(outputStream, path1);
            this.displayString(outputStream, " ");
            this.displaySecondGitPath(outputStream, path2);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "new file mode 10644");
            this.displayEOL(outputStream);
        }
        catch (IOException e) {
            this.wrapException(e);
        }
    }

    private void displayGitDiffHeaderDeleted(OutputStream outputStream, String path1, String path2, String copyFromPath) throws SVNException {
        try {
            this.displayString(outputStream, "diff --git ");
            this.displayFirstGitPath(outputStream, path1);
            this.displayString(outputStream, " ");
            this.displaySecondGitPath(outputStream, path2);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "deleted file mode 10644");
            this.displayEOL(outputStream);
        }
        catch (IOException e) {
            this.wrapException(e);
        }
    }

    private void displayGitDiffHeaderCopied(OutputStream outputStream, String path1, String path2, String copyFromPath) throws SVNException {
        try {
            this.displayString(outputStream, "diff --git ");
            this.displayFirstGitPath(outputStream, copyFromPath);
            this.displayString(outputStream, " ");
            this.displaySecondGitPath(outputStream, path2);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "copy from ");
            this.displayString(outputStream, copyFromPath);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "copy to ");
            this.displayString(outputStream, path2);
            this.displayEOL(outputStream);
        }
        catch (IOException e) {
            this.wrapException(e);
        }
    }

    private void displayGitDiffHeaderRenamed(OutputStream outputStream, String path1, String path2, String copyFromPath) throws SVNException {
        try {
            this.displayString(outputStream, "diff --git ");
            this.displayFirstGitPath(outputStream, copyFromPath);
            this.displayString(outputStream, " ");
            this.displaySecondGitPath(outputStream, path2);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "rename from ");
            this.displayString(outputStream, copyFromPath);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "rename to ");
            this.displayString(outputStream, path2);
            this.displayEOL(outputStream);
        }
        catch (IOException e) {
            this.wrapException(e);
        }
    }

    private void displayGitDiffHeaderModified(OutputStream outputStream, String path1, String path2, String copyFromPath) throws SVNException {
        try {
            this.displayString(outputStream, "diff --git ");
            this.displayFirstGitPath(outputStream, path1);
            this.displayString(outputStream, " ");
            this.displaySecondGitPath(outputStream, path2);
            this.displayEOL(outputStream);
        }
        catch (IOException e) {
            this.wrapException(e);
        }
    }

    private void displayFirstGitPath(OutputStream outputStream, String path1) throws IOException {
        this.displayGitPath(outputStream, path1, "a/", false);
    }

    private void displaySecondGitPath(OutputStream outputStream, String path2) throws IOException {
        this.displayGitPath(outputStream, path2, "b/", false);
    }

    private void displayFirstGitLabelPath(OutputStream outputStream, String path1, String revision1, SvnDiffCallback.OperationKind operation) throws IOException {
        String pathPrefix = "a/";
        if (operation == SvnDiffCallback.OperationKind.Added) {
            path1 = "/dev/null";
            pathPrefix = "";
        }
        this.displayGitPath(outputStream, this.getLabel(path1, revision1), pathPrefix, true);
    }

    private void displaySecondGitLabelPath(OutputStream outputStream, String path2, String revision2, SvnDiffCallback.OperationKind operation) throws IOException {
        String pathPrefix = "b/";
        if (operation == SvnDiffCallback.OperationKind.Deleted) {
            path2 = "/dev/null";
            pathPrefix = "";
        }
        this.displayGitPath(outputStream, this.getLabel(path2, revision2), pathPrefix, true);
    }

    private void displayGitPath(OutputStream outputStream, String path1, String pathPrefix, boolean label) throws IOException {
        this.displayString(outputStream, pathPrefix);
        this.displayString(outputStream, path1);
    }

    private String getAdjustedPathWithLabel(String displayPath, String path, String revision, String commonAncestor) {
        String adjustedPath = this.getAdjustedPath(displayPath, path, commonAncestor);
        return this.getLabel(adjustedPath, revision);
    }

    private String getAdjustedPath(String displayPath, String path1, String commonAncestor) {
        String adjustedPath = this.getRelativePath(path1, commonAncestor);
        adjustedPath = adjustedPath == null || adjustedPath.length() == 0 ? displayPath : (adjustedPath.charAt(0) == '/' ? displayPath + "\t(..." + adjustedPath + ")" : displayPath + "\t(.../" + adjustedPath + ")");
        return adjustedPath;
    }

    protected String getLabel(String path, String revToken) {
        revToken = revToken == null ? WC_REVISION_LABEL : revToken;
        return path + "\t" + revToken;
    }

    protected boolean displayHeader(OutputStream os, String path, boolean deleted, boolean added, SvnDiffCallback.OperationKind operation) throws SVNException {
        try {
            if (deleted && !this.isDiffDeleted()) {
                this.displayString(os, "Index: ");
                this.displayString(os, path);
                this.displayString(os, " (deleted)");
                this.displayEOL(os);
                this.displayString(os, HEADER_SEPARATOR);
                this.displayEOL(os);
                return true;
            }
            if (added && !this.isDiffAdded()) {
                this.displayString(os, "Index: ");
                this.displayString(os, path);
                this.displayString(os, " (added)");
                this.displayEOL(os);
                this.displayString(os, HEADER_SEPARATOR);
                this.displayEOL(os);
                return true;
            }
            this.displayString(os, "Index: ");
            this.displayString(os, path);
            this.displayEOL(os);
            this.displayString(os, HEADER_SEPARATOR);
            this.displayEOL(os);
            return false;
        }
        catch (IOException e) {
            this.wrapException(e);
            return false;
        }
    }

    protected void displayHeaderFields(OutputStream os, String label1, String label2) throws SVNException {
        try {
            this.displayString(os, "--- ");
            this.displayString(os, label1);
            this.displayEOL(os);
            this.displayString(os, "+++ ");
            this.displayString(os, label2);
            this.displayEOL(os);
        }
        catch (IOException e) {
            this.wrapException(e);
        }
    }

    private void displayPropertyChangesOn(String path, OutputStream outputStream) throws SVNException {
        try {
            this.displayEOL(outputStream);
            this.displayString(outputStream, "Property changes on: " + (this.useLocalFileSeparatorChar() ? path.replace('/', File.separatorChar) : path));
            this.displayEOL(outputStream);
            this.displayString(outputStream, PROPERTIES_SEPARATOR);
            this.displayEOL(outputStream);
        }
        catch (IOException e) {
            this.wrapException(e);
        }
    }

    private byte[] getPropertyAsBytes(SVNPropertyValue value, String encoding) {
        if (value == null) {
            return null;
        }
        if (value.isString()) {
            try {
                return value.getString().getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                return value.getString().getBytes();
            }
        }
        return value.getBytes();
    }

    private void displayMergeInfoDiff(OutputStream outputStream, String oldValue, String newValue) throws SVNException, IOException {
        SVNMergeRangeList rangeList;
        Map<String, SVNMergeRangeList> oldMergeInfo = null;
        Map<String, SVNMergeRangeList> newMergeInfo = null;
        if (oldValue != null) {
            oldMergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(oldValue), null);
        }
        if (newValue != null) {
            newMergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(newValue), null);
        }
        TreeMap deleted = new TreeMap();
        TreeMap added = new TreeMap();
        SVNMergeInfoUtil.diffMergeInfo(deleted, added, oldMergeInfo, newMergeInfo, true);
        for (String path : deleted.keySet()) {
            rangeList = (SVNMergeRangeList)deleted.get(path);
            this.displayString(outputStream, "   Reverse-merged " + path + ":r");
            this.displayString(outputStream, rangeList.toString());
            this.displayEOL(outputStream);
        }
        for (String path : added.keySet()) {
            rangeList = (SVNMergeRangeList)added.get(path);
            this.displayString(outputStream, "   Merged " + path + ":r");
            this.displayString(outputStream, rangeList.toString());
            this.displayEOL(outputStream);
        }
    }

    private boolean useLocalFileSeparatorChar() {
        return true;
    }

    public boolean isDiffDeleted() {
        return this.diffDeleted;
    }

    public boolean isDiffAdded() {
        return this.diffAdded;
    }

    private void wrapException(IOException e) throws SVNException {
        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, e);
        SVNErrorManager.error(errorMessage, e, SVNLogType.WC);
    }

    private void displayString(OutputStream outputStream, String s) throws IOException {
        outputStream.write(s.getBytes(HEADER_ENCODING));
    }

    private void displayEOL(OutputStream os) throws IOException {
        os.write(this.getEOL());
    }

    public SVNDiffOptions getDiffOptions() {
        if (this.diffOptions == null) {
            this.diffOptions = new SVNDiffOptions();
        }
        return this.diffOptions;
    }

    public void setExternalDiffCommand(String externalDiffCommand) {
        this.externalDiffCommand = externalDiffCommand;
    }

    public void setRawDiffOptions(List<String> rawDiffOptions) {
        this.rawDiffOptions = rawDiffOptions;
    }

    public void setDiffOptions(SVNDiffOptions diffOptions) {
        this.diffOptions = diffOptions;
    }

    public void setDiffDeleted(boolean diffDeleted) {
        this.diffDeleted = diffDeleted;
    }

    public void setDiffAdded(boolean diffAdded) {
        this.diffAdded = diffAdded;
    }

    public void setBasePath(File absoluteFile) {
        this.setBaseTarget(SvnTarget.fromFile(absoluteFile));
    }

    public void setFallbackToAbsolutePath(boolean fallbackToAbsolutePath) {
        this.fallbackToAbsolutePath = fallbackToAbsolutePath;
    }

    public void setOptions(ISVNOptions options) {
        this.options = options;
    }

    public ISVNOptions getOptions() {
        return this.options;
    }

    private class EmptyDetectionWriter
    extends Writer {
        private final Writer writer;
        private boolean somethingWritten;

        public EmptyDetectionWriter(Writer writer) {
            this.writer = writer;
            this.somethingWritten = false;
        }

        public boolean isSomethingWritten() {
            return this.somethingWritten;
        }

        @Override
        public void write(int c) throws IOException {
            this.somethingWritten = true;
            this.writer.write(c);
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.somethingWritten = cbuf.length > 0;
            this.writer.write(cbuf);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.somethingWritten = len > 0 && cbuf.length > 0;
            this.writer.write(cbuf, off, len);
        }

        @Override
        public void write(String str) throws IOException {
            this.somethingWritten = str.length() > 0;
            this.writer.write(str);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.somethingWritten = len > 0 && str.length() > 0;
            this.writer.write(str, off, len);
        }

        @Override
        public Writer append(CharSequence csq) throws IOException {
            this.somethingWritten = csq.length() > 0;
            return this.writer.append(csq);
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            this.somethingWritten = csq.length() > 0 && start >= end;
            return this.writer.append(csq, start, end);
        }

        @Override
        public Writer append(char c) throws IOException {
            this.somethingWritten = true;
            return this.writer.append(c);
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }
}

