/* Generated by make_unicode.py DO NOT MODIFY */
/* Unicode version: 11.0.0 */

/*
 * Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/licenses/publicdomain/
 */
#include "vm/Unicode.h"

using namespace js;
using namespace js::unicode;

/*
 * So how does indexing work?
 * First let's have a look at a char16_t, 16-bits:
 *              [................]
 * Step 1:
 *  Extracting the upper 11 bits from the char16_t.
 *   upper = char >>  5 ([***********.....])
 * Step 2:
 *  Using these bits to get an reduced index from index1.
 *   index = index1[upper]
 * Step 3:
 *  Combining the index and the bottom 5 bits of the original char16_t.
 *   real_index = index2[(index << 5) + (char & ((1 << 5) - 1))] ([...********+++++])
 *
 * The advantage here is that the biggest number in index1 doesn't need 10 bits,
 * but 7 and we save some memory.
 *
 * Step 4:
 *  Get the character informations by looking up real_index in js_charinfo.
 *
 * Pseudocode of generation:
 *
 * let table be the mapping of char16_t => js_charinfo_index
 * let index1 be an empty array
 * let index2 be an empty array
 * let cache be a hash map
 *
 * while shift is less then maximal amount you can shift 0xffff before it's 0
 *  let chunks be table split in chunks of size 2**shift
 *
 *  for every chunk in chunks
 *   if chunk is in cache
 *    let index be cache[chunk]
 *   else
 *    let index be the max key of index2 + 1
 *    for element in chunk
 *     push element to index2
 *    put index as chunk in cache
 *
 *   push index >> shift to index1
 *
 *  increase shift
 *  stop if you found the best shift
 */
const CharacterInfo unicode::js_charinfo[] = {
    {0, 0, 0},
    {0, 0, 1},
    {0, 0, 4},
    {0, 32, 2},
    {65504, 0, 2},
    {0, 0, 2},
    {743, 0, 2},
    {121, 0, 2},
    {0, 1, 2},
    {65535, 0, 2},
    {0, 65337, 2},
    {65304, 0, 2},
    {0, 65415, 2},
    {65236, 0, 2},
    {195, 0, 2},
    {0, 210, 2},
    {0, 206, 2},
    {0, 205, 2},
    {0, 79, 2},
    {0, 202, 2},
    {0, 203, 2},
    {0, 207, 2},
    {97, 0, 2},
    {0, 211, 2},
    {0, 209, 2},
    {163, 0, 2},
    {0, 213, 2},
    {130, 0, 2},
    {0, 214, 2},
    {0, 218, 2},
    {0, 217, 2},
    {0, 219, 2},
    {56, 0, 2},
    {0, 2, 2},
    {65535, 1, 2},
    {65534, 0, 2},
    {65457, 0, 2},
    {0, 65439, 2},
    {0, 65480, 2},
    {0, 65406, 2},
    {0, 10795, 2},
    {0, 65373, 2},
    {0, 10792, 2},
    {10815, 0, 2},
    {0, 65341, 2},
    {0, 69, 2},
    {0, 71, 2},
    {10783, 0, 2},
    {10780, 0, 2},
    {10782, 0, 2},
    {65326, 0, 2},
    {65330, 0, 2},
    {65331, 0, 2},
    {65334, 0, 2},
    {65333, 0, 2},
    {42319, 0, 2},
    {42315, 0, 2},
    {65329, 0, 2},
    {42280, 0, 2},
    {42308, 0, 2},
    {65327, 0, 2},
    {65325, 0, 2},
    {10743, 0, 2},
    {42305, 0, 2},
    {10749, 0, 2},
    {65323, 0, 2},
    {65322, 0, 2},
    {10727, 0, 2},
    {65318, 0, 2},
    {42282, 0, 2},
    {65467, 0, 2},
    {65319, 0, 2},
    {65465, 0, 2},
    {65317, 0, 2},
    {42261, 0, 2},
    {42258, 0, 2},
    {84, 0, 4},
    {0, 116, 2},
    {0, 38, 2},
    {0, 37, 2},
    {0, 64, 2},
    {0, 63, 2},
    {65498, 0, 2},
    {65499, 0, 2},
    {65505, 0, 2},
    {65472, 0, 2},
    {65473, 0, 2},
    {0, 8, 2},
    {65474, 0, 2},
    {65479, 0, 2},
    {65489, 0, 2},
    {65482, 0, 2},
    {65528, 0, 2},
    {65450, 0, 2},
    {65456, 0, 2},
    {7, 0, 2},
    {65420, 0, 2},
    {0, 65476, 2},
    {65440, 0, 2},
    {0, 65529, 2},
    {0, 80, 2},
    {0, 15, 2},
    {65521, 0, 2},
    {0, 48, 2},
    {65488, 0, 2},
    {0, 7264, 2},
    {3008, 0, 2},
    {0, 38864, 2},
    {59282, 0, 2},
    {59283, 0, 2},
    {59292, 0, 2},
    {59294, 0, 2},
    {59293, 0, 2},
    {59300, 0, 2},
    {59355, 0, 2},
    {35266, 0, 2},
    {0, 62528, 2},
    {35332, 0, 2},
    {3814, 0, 2},
    {65477, 0, 2},
    {0, 57921, 2},
    {8, 0, 2},
    {0, 65528, 2},
    {74, 0, 2},
    {86, 0, 2},
    {100, 0, 2},
    {128, 0, 2},
    {112, 0, 2},
    {126, 0, 2},
    {9, 0, 2},
    {0, 65462, 2},
    {0, 65527, 2},
    {58331, 0, 2},
    {0, 65450, 2},
    {0, 65436, 2},
    {0, 65424, 2},
    {0, 65408, 2},
    {0, 65410, 2},
    {0, 58019, 2},
    {0, 57153, 2},
    {0, 57274, 2},
    {0, 28, 2},
    {65508, 0, 2},
    {0, 16, 2},
    {65520, 0, 2},
    {0, 26, 0},
    {65510, 0, 0},
    {0, 54793, 2},
    {0, 61722, 2},
    {0, 54809, 2},
    {54741, 0, 2},
    {54744, 0, 2},
    {0, 54756, 2},
    {0, 54787, 2},
    {0, 54753, 2},
    {0, 54754, 2},
    {0, 54721, 2},
    {58272, 0, 2},
    {0, 30204, 2},
    {0, 23256, 2},
    {0, 23228, 2},
    {0, 23217, 2},
    {0, 23221, 2},
    {0, 23231, 2},
    {0, 23278, 2},
    {0, 23254, 2},
    {0, 23275, 2},
    {0, 928, 2},
    {64608, 0, 2},
    {26672, 0, 2},
};

const uint8_t unicode::index1[] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,  16,  17,
     18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,  32,  33,  34,  35,
     36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,
     54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66,  67,  26,  26,  26,  26,
     26,  68,  69,  70,  71,  72,  73,  74,  75,  26,  26,  26,  26,  26,  26,  26,  26,  76,
     77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,
     95,  96,  97,  98,  99, 100, 101, 102,  26, 103,  26, 104, 105, 105, 106, 105, 107, 108,
    109, 110, 111, 112, 113, 114, 115, 116, 117,  94,  94,  94,  94,  94,  94,  94,  94,  94,
     94,  94, 118, 119,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,
     94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94, 120, 121, 105, 122,
    123, 124, 125, 126,  94,  94,  94,  94,  94,  94,  94,  94, 127,  75, 128, 129, 130,  26,
    131, 132,  94,  94,  94,  94,  94,  94,  94,  94,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  86,  94,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26, 133,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 134, 135,  26,  26,  26,  26, 136, 137,
    138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155,
    156, 157, 158, 159,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 160, 161,
     94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,
     94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,
     94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,
     94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,
     94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,
     94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,
     94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,
     94,  94,  94,  94,  94,  94,  26,  26,  26,  26,  26, 162,  26, 163, 164, 165, 166, 167,
     26,  26,  26,  26, 168, 169, 170, 171, 172, 173,  26, 174, 175, 176, 177, 178,
};

const uint8_t unicode::index2[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   0,   0,   0,   0,   2,   0,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   6,   0,   2,   0,   0,   5,   0,   0,   0,   0,   0,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   0,
      3,   3,   3,   3,   3,   3,   3,   5,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   0,   4,   4,   4,   4,
      4,   4,   4,   7,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,  10,  11,
      8,   9,   8,   9,   8,   9,   5,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,
      9,   8,   9,   8,   9,   5,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,  12,   8,
      9,   8,   9,   8,   9,  13,  14,  15,   8,   9,   8,   9,  16,   8,   9,  17,  17,   8,
      9,   5,  18,  19,  20,   8,   9,  17,  21,  22,  23,  24,   8,   9,  25,   5,  23,  26,
     27,  28,   8,   9,   8,   9,   8,   9,  29,   8,   9,  29,   5,   5,   8,   9,  29,   8,
      9,  30,  30,   8,   9,   8,   9,  31,   8,   9,   5,   5,   8,   9,   5,  32,   5,   5,
      5,   5,  33,  34,  35,  33,  34,  35,  33,  34,  35,   8,   9,   8,   9,   8,   9,   8,
      9,   8,   9,   8,   9,   8,   9,   8,   9,  36,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   5,  33,  34,  35,   8,   9,  37,  38,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,  39,   5,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   5,   5,   5,   5,   5,   5,  40,   8,   9,  41,  42,  43,
     43,   8,   9,  44,  45,  46,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,  47,  48,
     49,  50,  51,   5,  52,  52,   5,  53,   5,  54,  55,   5,   5,   5,  52,  56,   5,  57,
      5,  58,  59,   5,  60,  61,  59,  62,  63,   5,   5,  61,   5,  64,  65,   5,   5,  66,
      5,   5,   5,   5,   5,   5,   5,  67,   5,   5,  68,   5,   5,  68,   5,   5,   5,  69,
     68,  70,  71,  71,  72,   5,   5,   5,   5,   5,  73,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,  74,  75,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,
      5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   5,   0,   5,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,  76,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   8,   9,
      8,   9,   5,   0,   8,   9,   0,   0,   5,  27,  27,  27,   0,  77,   0,   0,   0,   0,
      0,   0,  78,   2,  79,  79,  79,   0,  80,   0,  81,  81,   5,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   0,   3,   3,   3,   3,   3,
      3,   3,   3,   3,  82,  83,  83,  83,   5,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,  84,   4,   4,   4,   4,   4,   4,   4,   4,   4,
     85,  86,  86,  87,  88,  89,   5,   5,   5,  90,  91,  92,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
     93,  94,  95,  96,  97,  98,   0,   8,   9,  99,   8,   9,   5,  39,  39,  39, 100, 100,
    100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,
     94,  94,  94,  94,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   0,   2,   2,   2,   2,   2,   0,   0,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9, 101,   8,   9,   8,   9,   8,   9,   8,
      9,   8,   9,   8,   9,   8,   9, 102,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   0, 103, 103, 103,
    103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103,
    103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103,   0,
      0,   5,   0,   0,   0,   0,   0,   0,   5, 104, 104, 104, 104, 104, 104, 104, 104, 104,
    104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
    104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,   5,   5,   0,   0,   0,   0,   0,
      0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   2,   0,   2,   2,   0,
      2,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   0,   0,   0,   0,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,
      0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   0,   0,   0,   5,   5,   2,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   0,   5,   2,   2,   2,   2,   2,   2,   2,   0,   0,   2,   2,   2,   2,   2,
      2,   5,   5,   2,   2,   0,   2,   2,   2,   2,   5,   5,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   5,   5,   5,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   5,   2,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   5,   5,   0,   0,   0,   0,   5,   0,   0,   2,   0,   0,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      2,   2,   2,   2,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   2,   2,   2,
      5,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   0,   0,
      0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   2,   2,   2,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   5,   2,   2,   2,   2,   2,   2,   2,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   0,   0,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   2,   2,   2,   0,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   5,
      5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   0,   5,   0,
      0,   0,   5,   5,   5,   5,   0,   0,   2,   5,   2,   2,   2,   2,   2,   2,   2,   0,
      0,   2,   2,   0,   0,   2,   2,   2,   5,   0,   0,   0,   0,   0,   0,   0,   0,   2,
      0,   0,   0,   0,   5,   5,   0,   5,   5,   5,   2,   2,   0,   0,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      5,   0,   2,   0,   0,   2,   2,   2,   0,   5,   5,   5,   5,   5,   5,   0,   0,   0,
      0,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   0,
      5,   5,   0,   5,   5,   0,   5,   5,   0,   0,   2,   0,   2,   2,   2,   2,   2,   0,
      0,   0,   0,   2,   2,   0,   0,   2,   2,   2,   0,   0,   0,   2,   0,   0,   0,   0,
      0,   0,   0,   5,   5,   5,   5,   0,   5,   0,   0,   0,   0,   0,   0,   0,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   5,   5,   2,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   0,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   0,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,
      5,   0,   5,   5,   0,   5,   5,   5,   5,   5,   0,   0,   2,   5,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   2,   2,   2,   0,   2,   2,   2,   0,   0,   5,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   2,   2,   0,   0,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   5,   2,   2,   2,   2,   2,   2,   0,   2,   2,   2,   0,   5,   5,   5,   5,   5,
      5,   5,   5,   0,   0,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,
      5,   5,   5,   0,   5,   5,   0,   5,   5,   5,   5,   5,   0,   0,   2,   5,   2,   2,
      2,   2,   2,   2,   2,   0,   0,   2,   2,   0,   0,   2,   2,   2,   0,   0,   0,   0,
      0,   0,   0,   0,   2,   2,   0,   0,   0,   0,   5,   5,   0,   5,   5,   5,   2,   2,
      0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   5,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   5,   0,   5,   5,   5,
      5,   5,   5,   0,   0,   0,   5,   5,   5,   0,   5,   5,   5,   5,   0,   0,   0,   5,
      5,   0,   5,   0,   5,   5,   0,   0,   0,   5,   5,   0,   0,   0,   5,   5,   5,   0,
      0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,
      2,   2,   2,   2,   2,   0,   0,   0,   2,   2,   2,   0,   2,   2,   2,   2,   0,   0,
      5,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,
      0,   5,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,   2,   0,   2,   2,   2,   2,
      0,   0,   0,   0,   0,   0,   0,   2,   2,   0,   5,   5,   5,   0,   0,   0,   0,   0,
      5,   5,   2,   2,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   2,   2,   2,
      0,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   0,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,
      0,   0,   2,   5,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,   2,   0,   2,   2,
      2,   2,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,
      5,   0,   5,   5,   2,   2,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      0,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,
      2,   2,   0,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   2,   2,   5,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,   2,   0,
      2,   2,   2,   2,   5,   0,   0,   0,   0,   0,   5,   5,   5,   2,   0,   0,   0,   0,
      0,   0,   0,   5,   5,   5,   2,   2,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      0,   0,   2,   2,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   0,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   0,
      0,   0,   2,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   0,   2,   0,   2,   2,
      2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   5,   5,
      2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   2,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   5,   5,   0,   5,   0,   0,   5,   5,   0,   5,   0,   0,   5,
      0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,
      0,   5,   5,   5,   0,   5,   0,   5,   0,   0,   5,   5,   0,   5,   5,   5,   5,   2,
      5,   5,   2,   2,   2,   2,   2,   2,   0,   2,   2,   5,   0,   0,   5,   5,   5,   5,
      5,   0,   5,   0,   2,   2,   2,   2,   2,   2,   0,   0,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   0,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,   0,   0,   0,
      0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   2,   0,   2,   0,   2,   0,   0,   0,   0,   2,   2,   5,   5,
      5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,   5,   5,
      5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,
      5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   5,   5,   5,   5,   2,   2,   2,   5,
      2,   2,   2,   5,   5,   2,   2,   2,   2,   2,   2,   2,   5,   5,   5,   2,   2,   2,
      2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   0,   0, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105,
    105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105,
    105, 105, 105, 105, 105, 105, 105, 105, 105, 105,   0, 105,   0,   0,   0,   0,   0, 105,
      0,   0, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106,
    106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106,
    106, 106, 106, 106, 106, 106, 106, 106, 106,   0,   5, 106, 106, 106,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   0,   5,   0,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,
      5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   0,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   0,   5,   0,
      5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   2,   2,   2,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107,
    107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107,
    107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107,
    107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107,
    107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107,  87,  87,  87,  87,
     87,  87,   0,   0,  92,  92,  92,  92,  92,  92,   0,   0,   0,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   1,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   2,   2,
      2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,
      5,   5,   5,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   5,   0,   0,
      0,   0,   5,   2,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   0,   0,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,
      0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   5,   0,   0,   0,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,
      0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,
      2,   2,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,
      0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,
      2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   5,   5,   5,   5,   5,   5,
      0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,
      2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   0,   0,   0,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      0,   0, 108, 109, 110, 111, 111, 112, 113, 114, 115,   0,   0,   0,   0,   0,   0,   0,
    116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116,
    116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116,
    116, 116, 116, 116, 116, 116, 116,   0,   0, 116, 116, 116,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   0,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,
      5,   5,   5,   2,   5,   5,   5,   5,   2,   2,   2,   5,   5,   2,   2,   2,   0,   0,
      0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5, 117,   5,   5,   5, 118,   5,   5,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      0,   2,   2,   2,   2,   2,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   5,   5,   5,   5,   5, 119,   5,   5, 120,   5,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9, 121, 121, 121, 121, 121, 121, 121, 121, 122, 122,
    122, 122, 122, 122, 122, 122, 121, 121, 121, 121, 121, 121,   0,   0, 122, 122, 122, 122,
    122, 122,   0,   0, 121, 121, 121, 121, 121, 121, 121, 121, 122, 122, 122, 122, 122, 122,
    122, 122, 121, 121, 121, 121, 121, 121, 121, 121, 122, 122, 122, 122, 122, 122, 122, 122,
    121, 121, 121, 121, 121, 121,   0,   0, 122, 122, 122, 122, 122, 122,   0,   0,   5, 121,
      5, 121,   5, 121,   5, 121,   0, 122,   0, 122,   0, 122,   0, 122, 121, 121, 121, 121,
    121, 121, 121, 121, 122, 122, 122, 122, 122, 122, 122, 122, 123, 123, 124, 124, 124, 124,
    125, 125, 126, 126, 127, 127, 128, 128,   0,   0, 121, 121, 121, 121, 121, 121, 121, 121,
    122, 122, 122, 122, 122, 122, 122, 122, 121, 121, 121, 121, 121, 121, 121, 121, 122, 122,
    122, 122, 122, 122, 122, 122, 121, 121, 121, 121, 121, 121, 121, 121, 122, 122, 122, 122,
    122, 122, 122, 122, 121, 121,   5, 129,   5,   0,   5,   5, 122, 122, 130, 130, 131,   0,
    132,   0,   0,   0,   5, 129,   5,   0,   5,   5, 133, 133, 133, 133, 131,   0,   0,   0,
    121, 121,   5,   5,   0,   0,   5,   5, 122, 122, 134, 134,   0,   0,   0,   0, 121, 121,
      5,   5,   5,  95,   5,   5, 122, 122, 135, 135,  99,   0,   0,   0,   0,   0,   5, 129,
      5,   0,   5,   5, 136, 136, 137, 137, 131,   0,   0,   0,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,
      0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,
      0,   0,   0,   2,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      5,   0,   0,   0,   0,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      0,   5,   0,   0,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   5,   0,
    138,   0,   5,   0, 139, 140,   5,   5,   5,   5,   5,   5, 141,   5,   5,   5,   5,   5,
      5,   5,   0,   0,   5,   5,   5,   5,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,
      0,   0,   0,   0, 142,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
    143, 143, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144,
      5,   5,   5,   8,   9,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146,
    146, 146, 146, 146, 146, 146, 146, 146,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 103, 103, 103, 103, 103, 103,
    103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103,
    103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103,
    103, 103, 103, 103, 103,   0, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
    104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
    104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,   0,
      8,   9, 147, 148, 149, 150, 151,   8,   9,   8,   9,   8,   9, 152, 153, 154, 155,   5,
      8,   9,   5,   8,   9,   5,   5,   5,   5,   5,   5,   5, 156, 156,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   5,   0,   0,   0,
      0,   0,   0,   8,   9,   8,   9,   2,   2,   2,   8,   9,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 157, 157, 157, 157, 157, 157, 157, 157, 157, 157, 157, 157,
    157, 157, 157, 157, 157, 157, 157, 157, 157, 157, 157, 157, 157, 157, 157, 157, 157, 157,
    157, 157, 157, 157, 157, 157, 157, 157,   0, 157,   0,   0,   0,   0,   0, 157,   0,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,
      5,   0,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   0,
      5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,
      5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   0,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   1,   0,   0,   0,   0,   5,   5,   5,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,
      2,   2,   2,   2,   0,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   0,
      0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   0,   2,   2,   5,   5,   5,   5,   5,   0,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,
      5,   5,   5,   5,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   5,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   5,   2,   0,   0,   0,   0,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   5,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   5,   5,   2,   2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   5,   5,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   8,   9,   8,   9, 158,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   5,   0,   0,   8,   9, 159,   5,   5,   8,   9,   8,   9,
      5,   5,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9, 160, 161, 162, 163, 160,   5, 164, 165, 166, 167,   8,   9,   8,   9,
      8,   9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   2,   5,   5,   5,   2,   5,   5,   5,   5,   2,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,
      2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   2,   2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   5,   5,   5,   5,   5,   5,   0,   0,   0,   5,
      0,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   0,   0,   0,   2,   2,   2,   2,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   2,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      5,   5,   5,   2,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   0,   0,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   0,   0,   0,   5,   2,   2,   2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   2,   5,   2,   2,   2,   5,   5,   2,   2,   5,   5,   5,   5,   5,
      2,   2,   5,   2,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   0,   0,   5,   5,
      5,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,
      5,   0,   0,   5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,
      5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5, 168,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 169, 169,
    169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169,
    169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169,
    169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169,
    169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169,
    169, 169, 169, 169, 169, 169,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,   0,   0,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,
      0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   5,   2,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   0,   5,   5,   5,   5,   5,   0,   5,   0,   5,   5,   0,   5,   5,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,
      5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,
      0,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   0,   0,   0,   0,   2,   0,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,
      5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   0,   0,   5,   5,
      5,   5,   5,   5,   0,   0,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,
};

const CodepointsWithSameUpperCaseInfo unicode::js_codepoints_with_same_upper_info[] = {
    {0, 0, 0},
    {32, 0, 0},
    {32, 232, 0},
    {32, 300, 0},
    {0, 200, 0},
    {0, 268, 0},
    {0, 775, 0},
    {1, 0, 0},
    {65336, 0, 0},
    {65415, 0, 0},
    {65268, 0, 0},
    {210, 0, 0},
    {206, 0, 0},
    {205, 0, 0},
    {79, 0, 0},
    {202, 0, 0},
    {203, 0, 0},
    {207, 0, 0},
    {211, 0, 0},
    {209, 0, 0},
    {213, 0, 0},
    {214, 0, 0},
    {218, 0, 0},
    {217, 0, 0},
    {219, 0, 0},
    {1, 2, 0},
    {0, 1, 0},
    {65535, 0, 0},
    {65439, 0, 0},
    {65480, 0, 0},
    {65406, 0, 0},
    {10795, 0, 0},
    {65373, 0, 0},
    {10792, 0, 0},
    {65341, 0, 0},
    {69, 0, 0},
    {71, 0, 0},
    {0, 116, 7289},
    {116, 0, 0},
    {38, 0, 0},
    {37, 0, 0},
    {64, 0, 0},
    {63, 0, 0},
    {32, 62, 0},
    {32, 96, 0},
    {32, 57, 0},
    {65452, 32, 7205},
    {32, 86, 0},
    {64793, 32, 0},
    {32, 54, 0},
    {32, 80, 0},
    {31, 32, 0},
    {32, 47, 0},
    {0, 30, 0},
    {0, 64, 0},
    {0, 25, 0},
    {65420, 0, 7173},
    {0, 54, 0},
    {64761, 0, 0},
    {0, 22, 0},
    {0, 48, 0},
    {0, 15, 0},
    {8, 0, 0},
    {65506, 0, 0},
    {65511, 0, 0},
    {65521, 0, 0},
    {65514, 0, 0},
    {65482, 0, 0},
    {65488, 0, 0},
    {65472, 0, 0},
    {65529, 0, 0},
    {80, 0, 0},
    {32, 6254, 0},
    {32, 6253, 0},
    {32, 6244, 0},
    {32, 6242, 0},
    {32, 6242, 6243},
    {32, 6236, 0},
    {0, 6222, 0},
    {0, 6221, 0},
    {0, 6212, 0},
    {0, 6210, 0},
    {0, 6210, 6211},
    {0, 6204, 0},
    {1, 6181, 0},
    {0, 6180, 0},
    {15, 0, 0},
    {48, 0, 0},
    {7264, 0, 0},
    {38864, 0, 0},
    {59314, 0, 0},
    {59315, 0, 0},
    {59324, 0, 0},
    {59326, 0, 0},
    {59326, 0, 1},
    {59325, 65535, 0},
    {59332, 0, 0},
    {59356, 0, 0},
    {0, 35267, 0},
    {62528, 0, 0},
    {1, 59, 0},
    {0, 58, 0},
    {65478, 0, 0},
    {65528, 0, 0},
    {65462, 0, 0},
    {65527, 0, 0},
    {58247, 58363, 0},
    {65450, 0, 0},
    {65436, 0, 0},
    {65424, 0, 0},
    {65408, 0, 0},
    {65410, 0, 0},
    {28, 0, 0},
    {16, 0, 0},
    {26, 0, 0},
    {54793, 0, 0},
    {61722, 0, 0},
    {54809, 0, 0},
    {54756, 0, 0},
    {54787, 0, 0},
    {54753, 0, 0},
    {54754, 0, 0},
    {54721, 0, 0},
    {30270, 1, 0},
    {30269, 0, 0},
    {30204, 0, 0},
    {23256, 0, 0},
    {23228, 0, 0},
    {23217, 0, 0},
    {23221, 0, 0},
    {23231, 0, 0},
    {23278, 0, 0},
    {23254, 0, 0},
    {23275, 0, 0},
    {928, 0, 0},
};

const uint8_t unicode::codepoints_with_same_upper_index1[] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   0,   0,   0,  10,  11,  12,  13,  14,
     15,  16,  17,  18,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  19,  20,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  21,  22,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  23,   0,   0,   0,   0,   0,  24,  25,  26,  24,  27,  28,
     29,  30,   0,   0,   0,   0,  31,  32,  33,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,  34,  35,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  36,  37,  24,  38,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  39,
     40,   0,  41,  42,  43,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  44,   0,   0,   0,
};

const uint8_t unicode::codepoints_with_same_upper_index2[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,
      1,   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   3,   1,   1,   1,   1,   1,   1,
      1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,
      1,   1,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   0,   8,
      7,   0,   7,   0,   7,   0,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,
      0,   7,   0,   7,   0,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   9,   7,
      0,   7,   0,   7,   0,  10,   0,  11,   7,   0,   7,   0,  12,   7,   0,  13,  13,   7,
      0,   0,  14,  15,  16,   7,   0,  13,  17,   0,  18,  19,   7,   0,   0,   0,  18,  20,
      0,  21,   7,   0,   7,   0,   7,   0,  22,   7,   0,  22,   0,   0,   7,   0,  22,   7,
      0,  23,  23,   7,   0,   7,   0,  24,   7,   0,   0,   0,   7,   0,   0,   0,   0,   0,
      0,   0,  25,  26,  27,  25,  26,  27,  25,  26,  27,   7,   0,   7,   0,   7,   0,   7,
      0,   7,   0,   7,   0,   7,   0,   7,   0,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   0,  25,  26,  27,   7,   0,  28,  29,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,  30,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   0,   0,   0,   0,   0,   0,  31,   7,   0,  32,  33,   0,
      0,   7,   0,  34,  35,  36,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  37,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   7,   0,   7,   0,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0,
      0,  38,   0,   0,   0,   0,   0,   0,  39,   0,  40,  40,  40,   0,  41,   0,  42,  42,
      0,   1,  43,   1,   1,  44,   1,   1,  45,  46,  47,   1,  48,   1,   1,   1,  49,  50,
      0,  51,   1,   1,  52,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,  53,   0,
      0,  54,   0,   0,  55,  56,  57,   0,  58,   0,   0,   0,  59,  60,  26,  27,   0,   0,
     61,   0,   0,   0,   0,   0,   0,   0,   0,  62,  63,  64,   0,   0,   0,  65,  66,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,  67,  68,   0,   0,   0,  69,   0,   7,   0,  70,   7,   0,
      0,  30,  30,  30,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,
     71,  71,   1,   1,  72,   1,  73,   1,   1,   1,   1,   1,   1,   1,   1,   1,  74,   1,
      1,  75,  76,   1,   1,   1,   1,   1,   1,   1,  77,   1,   1,   1,   1,   1,   0,   0,
     78,   0,  79,   0,   0,   0,   0,   0,   0,   0,   0,   0,  80,   0,   0,  81,  82,   0,
      0,   0,   0,   0,   0,   0,  83,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   0,  84,  85,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,  86,   7,
      0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   0,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,
     87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,
     87,  87,  87,  87,  87,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,
     88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,
     88,  88,  88,  88,  88,  88,  88,  88,   0,  88,   0,   0,   0,   0,   0,  88,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,
     89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,
     89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,
     89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,
     89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  62,  62,
     62,  62,  62,  62,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  90,  91,  92,  93,
     94,  95,  96,  97,  98,   0,   0,   0,   0,   0,   0,   0,  99,  99,  99,  99,  99,  99,
     99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,
     99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,
     99,   0,   0,  99,  99,  99,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0, 100, 101,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   0,   0,   0,   0,   0, 102,
      0,   0,   0,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      0,   0,   0,   0,   0,   0,   0,   0, 103, 103, 103, 103, 103, 103, 103, 103,   0,   0,
      0,   0,   0,   0,   0,   0, 103, 103, 103, 103, 103, 103,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 103, 103, 103, 103, 103, 103, 103, 103,   0,   0,   0,   0,   0,   0,
      0,   0, 103, 103, 103, 103, 103, 103, 103, 103,   0,   0,   0,   0,   0,   0,   0,   0,
    103, 103, 103, 103, 103, 103,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 103,
      0, 103,   0, 103,   0, 103,   0,   0,   0,   0,   0,   0,   0,   0, 103, 103, 103, 103,
    103, 103, 103, 103,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 103, 103, 103, 103, 103, 103, 103, 103,
      0,   0,   0,   0,   0,   0,   0,   0, 103, 103, 103, 103, 103, 103, 103, 103,   0,   0,
      0,   0,   0,   0,   0,   0, 103, 103, 103, 103, 103, 103, 103, 103,   0,   0,   0,   0,
      0,   0,   0,   0, 103, 103, 104, 104, 105,   0, 106,   0,   0,   0,   0,   0,   0,   0,
      0,   0, 107, 107, 107, 107, 105,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    103, 103, 108, 108,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 103, 103,
    109, 109,  70,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 110, 110, 111, 111,
    105,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    112,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 113, 113, 113, 113, 113, 113, 113, 113,
    113, 113, 113, 113, 113, 113, 113, 113,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 114, 114,
    114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114,
    114, 114, 114, 114, 114, 114,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,
     87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,
     87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   7,   0, 115, 116, 117,   0,   0,   7,   0,   7,   0,   7,
      0, 118, 119, 120, 121,   0,   7,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0,   0,
    122, 122,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   0,   0,   0,   0,   0,   0,   0,   7,   0,   7,   0,   0,   0,   0,   7,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0, 123, 124,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   0,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   0,   7,   0, 125,   7,   0,   7,   0,
      7,   0,   7,   0,   7,   0,   0,   0,   0,   7,   0, 126,   0,   0,   7,   0,   7,   0,
      0,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   0,
      7,   0,   7,   0, 127, 128, 129, 130, 127,   0, 131, 132, 133, 134,   7,   0,   7,   0,
      7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,
};

const FoldingInfo unicode::js_foldinfo[] = {
    {0, 0, 0, 0},
    {32, 0, 0, 0},
    {32, 8415, 0, 0},
    {32, 300, 0, 0},
    {0, 65504, 0, 0},
    {0, 65504, 8383, 0},
    {0, 65504, 268, 0},
    {775, 743, 0, 0},
    {32, 8294, 0, 0},
    {0, 7615, 0, 0},
    {0, 65504, 8262, 0},
    {0, 121, 0, 0},
    {1, 0, 0, 0},
    {0, 65535, 0, 0},
    {65415, 0, 0, 0},
    {65268, 65236, 0, 0},
    {0, 195, 0, 0},
    {210, 0, 0, 0},
    {206, 0, 0, 0},
    {205, 0, 0, 0},
    {79, 0, 0, 0},
    {202, 0, 0, 0},
    {203, 0, 0, 0},
    {207, 0, 0, 0},
    {0, 97, 0, 0},
    {211, 0, 0, 0},
    {209, 0, 0, 0},
    {0, 163, 0, 0},
    {213, 0, 0, 0},
    {0, 130, 0, 0},
    {214, 0, 0, 0},
    {218, 0, 0, 0},
    {217, 0, 0, 0},
    {219, 0, 0, 0},
    {0, 56, 0, 0},
    {2, 1, 0, 0},
    {1, 65535, 0, 0},
    {0, 65534, 65535, 0},
    {0, 65457, 0, 0},
    {65439, 0, 0, 0},
    {65480, 0, 0, 0},
    {65406, 0, 0, 0},
    {10795, 0, 0, 0},
    {65373, 0, 0, 0},
    {10792, 0, 0, 0},
    {0, 10815, 0, 0},
    {65341, 0, 0, 0},
    {69, 0, 0, 0},
    {71, 0, 0, 0},
    {0, 10783, 0, 0},
    {0, 10780, 0, 0},
    {0, 10782, 0, 0},
    {0, 65326, 0, 0},
    {0, 65330, 0, 0},
    {0, 65331, 0, 0},
    {0, 65334, 0, 0},
    {0, 65333, 0, 0},
    {0, 42319, 0, 0},
    {0, 42315, 0, 0},
    {0, 65329, 0, 0},
    {0, 42280, 0, 0},
    {0, 42308, 0, 0},
    {0, 65327, 0, 0},
    {0, 65325, 0, 0},
    {0, 10743, 0, 0},
    {0, 42305, 0, 0},
    {0, 10749, 0, 0},
    {0, 65323, 0, 0},
    {0, 65322, 0, 0},
    {0, 10727, 0, 0},
    {0, 65318, 0, 0},
    {0, 42282, 0, 0},
    {0, 65467, 0, 0},
    {0, 65319, 0, 0},
    {0, 65465, 0, 0},
    {0, 65317, 0, 0},
    {0, 42261, 0, 0},
    {0, 42258, 0, 0},
    {116, 84, 7289, 0},
    {116, 0, 0, 0},
    {38, 0, 0, 0},
    {37, 0, 0, 0},
    {64, 0, 0, 0},
    {63, 0, 0, 0},
    {32, 62, 0, 0},
    {32, 96, 0, 0},
    {32, 57, 92, 0},
    {32, 65452, 7205, 0},
    {32, 86, 0, 0},
    {32, 64793, 0, 0},
    {32, 54, 0, 0},
    {32, 80, 0, 0},
    {32, 31, 0, 0},
    {32, 47, 0, 0},
    {32, 7549, 0, 0},
    {0, 65498, 0, 0},
    {0, 65499, 0, 0},
    {0, 65504, 30, 0},
    {0, 65504, 64, 0},
    {0, 65504, 25, 60},
    {0, 65420, 65504, 7173},
    {0, 65504, 54, 0},
    {0, 64761, 65504, 0},
    {0, 65504, 22, 0},
    {0, 65504, 48, 0},
    {1, 65505, 0, 0},
    {0, 65504, 65535, 0},
    {0, 65504, 15, 0},
    {0, 65504, 7517, 0},
    {0, 65472, 0, 0},
    {0, 65473, 0, 0},
    {8, 0, 0, 0},
    {65506, 65474, 0, 0},
    {65511, 65479, 35, 0},
    {65521, 65489, 0, 0},
    {65514, 65482, 0, 0},
    {0, 65528, 0, 0},
    {65482, 65450, 0, 0},
    {65488, 65456, 0, 0},
    {0, 7, 0, 0},
    {0, 65420, 0, 0},
    {65476, 65444, 65501, 0},
    {65472, 65440, 0, 0},
    {65529, 0, 0, 0},
    {80, 0, 0, 0},
    {32, 6254, 0, 0},
    {32, 6253, 0, 0},
    {32, 6244, 0, 0},
    {32, 6242, 0, 0},
    {32, 6242, 6243, 0},
    {32, 6236, 0, 0},
    {0, 65504, 6222, 0},
    {0, 65504, 6221, 0},
    {0, 65504, 6212, 0},
    {0, 65504, 6210, 0},
    {0, 65504, 6210, 6211},
    {0, 65504, 6204, 0},
    {0, 65456, 0, 0},
    {1, 6181, 0, 0},
    {0, 65535, 6180, 0},
    {15, 0, 0, 0},
    {0, 65521, 0, 0},
    {48, 0, 0, 0},
    {0, 65488, 0, 0},
    {7264, 0, 0, 0},
    {0, 3008, 0, 0},
    {0, 38864, 0, 0},
    {0, 8, 0, 0},
    {65528, 0, 0, 0},
    {59314, 59282, 0, 0},
    {59315, 59283, 0, 0},
    {59324, 59292, 0, 0},
    {59326, 59294, 0, 0},
    {59326, 59294, 1, 0},
    {59325, 59293, 65535, 0},
    {59332, 59300, 0, 0},
    {59356, 59355, 0, 0},
    {35267, 35266, 0, 0},
    {62528, 0, 0, 0},
    {0, 35332, 0, 0},
    {0, 3814, 0, 0},
    {1, 59, 0, 0},
    {0, 65535, 58, 0},
    {65478, 65477, 0, 0},
    {57921, 0, 0, 0},
    {0, 74, 0, 0},
    {0, 86, 0, 0},
    {0, 100, 0, 0},
    {0, 128, 0, 0},
    {0, 112, 0, 0},
    {0, 126, 0, 0},
    {0, 9, 0, 0},
    {65462, 0, 0, 0},
    {65527, 0, 0, 0},
    {58363, 58247, 58331, 0},
    {65450, 0, 0, 0},
    {65436, 0, 0, 0},
    {65424, 0, 0, 0},
    {65408, 0, 0, 0},
    {65410, 0, 0, 0},
    {58019, 57987, 0, 0},
    {57153, 57121, 0, 0},
    {57274, 57242, 0, 0},
    {28, 0, 0, 0},
    {0, 65508, 0, 0},
    {16, 0, 0, 0},
    {0, 65520, 0, 0},
    {26, 0, 0, 0},
    {0, 65510, 0, 0},
    {54793, 0, 0, 0},
    {61722, 0, 0, 0},
    {54809, 0, 0, 0},
    {0, 54741, 0, 0},
    {0, 54744, 0, 0},
    {54756, 0, 0, 0},
    {54787, 0, 0, 0},
    {54753, 0, 0, 0},
    {54754, 0, 0, 0},
    {54721, 0, 0, 0},
    {0, 58272, 0, 0},
    {1, 30270, 0, 0},
    {0, 30269, 65535, 0},
    {30204, 0, 0, 0},
    {23256, 0, 0, 0},
    {23228, 0, 0, 0},
    {23217, 0, 0, 0},
    {23221, 0, 0, 0},
    {23231, 0, 0, 0},
    {23278, 0, 0, 0},
    {23254, 0, 0, 0},
    {23275, 0, 0, 0},
    {928, 0, 0, 0},
    {0, 64608, 0, 0},
    {26672, 0, 0, 0},
};

const uint8_t unicode::folding_index1[] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,   0,   0,  11,  12,  13,  14,  15,
     16,  17,  18,  19,  20,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  21,  22,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  23,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  25,   0,   0,  26,   0,   0,  27,  28,  29,  27,  30,  31,
     32,  33,   0,   0,   0,   0,  34,  35,  36,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,  37,  38,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  39,  40,  27,  41,
     42,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  43,
     44,   0,  45,  46,  47,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,  48,  49,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  50,  51,   0,   0,
};

const uint8_t unicode::folding_index2[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   2,   1,   1,   1,   1,   1,   1,   1,   3,   1,   1,   1,   1,   1,   1,
      1,   0,   0,   0,   0,   0,   0,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   5,
      4,   4,   4,   4,   4,   4,   4,   6,   4,   4,   4,   4,   4,   4,   4,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   8,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,
      1,   1,   1,   1,   1,   1,   1,   9,   4,   4,   4,   4,   4,  10,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   0,   4,   4,   4,   4,
      4,   4,   4,  11,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,   0,   0,
     12,  13,  12,  13,  12,  13,   0,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,
     13,  12,  13,  12,  13,   0,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  14,  12,
     13,  12,  13,  12,  13,  15,  16,  17,  12,  13,  12,  13,  18,  12,  13,  19,  19,  12,
     13,   0,  20,  21,  22,  12,  13,  19,  23,  24,  25,  26,  12,  13,  27,   0,  25,  28,
     29,  30,  12,  13,  12,  13,  12,  13,  31,  12,  13,  31,   0,   0,  12,  13,  31,  12,
     13,  32,  32,  12,  13,  12,  13,  33,  12,  13,   0,   0,  12,  13,   0,  34,   0,   0,
      0,   0,  35,  36,  37,  35,  36,  37,  35,  36,  37,  12,  13,  12,  13,  12,  13,  12,
     13,  12,  13,  12,  13,  12,  13,  12,  13,  38,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,   0,  35,  36,  37,  12,  13,  39,  40,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  41,   0,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,   0,   0,   0,   0,   0,   0,  42,  12,  13,  43,  44,  45,
     45,  12,  13,  46,  47,  48,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  49,  50,
     51,  52,  53,   0,  54,  54,   0,  55,   0,  56,  57,   0,   0,   0,  54,  58,   0,  59,
      0,  60,  61,   0,  62,  63,  61,  64,  65,   0,   0,  63,   0,  66,  67,   0,   0,  68,
      0,   0,   0,   0,   0,   0,   0,  69,   0,   0,  70,   0,   0,  70,   0,   0,   0,  71,
     70,  72,  73,  73,  74,   0,   0,   0,   0,   0,  75,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  76,  77,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  78,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  12,  13,  12,  13,
      0,   0,  12,  13,   0,   0,   0,  29,  29,  29,   0,  79,   0,   0,   0,   0,   0,   0,
     80,   0,  81,  81,  81,   0,  82,   0,  83,  83,   0,   1,  84,   1,   1,  85,   1,   1,
     86,  87,  88,   1,  89,   1,   1,   1,  90,  91,   0,  92,   1,   1,  93,   1,   1,  94,
      1,   1,  95,  96,  96,  96,   0,   4,  97,   4,   4,  98,   4,   4,  99, 100, 101,   4,
    102,   4,   4,   4, 103, 104, 105, 106,   4,   4, 107,   4,   4, 108,   4,   4, 109, 110,
    110, 111, 112, 113,   0,   0,   0, 114, 115, 116,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13, 117, 118,
    119, 120, 121, 122,   0,  12,  13, 123,  12,  13,   0,  41,  41,  41, 124, 124, 124, 124,
    124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124,   1,   1, 125,   1, 126,   1,
      1,   1,   1,   1,   1,   1,   1,   1, 127,   1,   1, 128, 129,   1,   1,   1,   1,   1,
      1,   1, 130,   1,   1,   1,   1,   1,   4,   4, 131,   4, 132,   4,   4,   4,   4,   4,
      4,   4,   4,   4, 133,   4,   4, 134, 135,   4,   4,   4,   4,   4,   4,   4, 136,   4,
      4,   4,   4,   4, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137,
    137, 137,  12,  13, 138, 139,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
      0,   0,   0,   0,   0,   0,   0,   0,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13, 140,  12,  13,  12,  13,  12,  13,  12,  13,  12,
     13,  12,  13,  12,  13, 141,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,   0, 142, 142, 142, 142, 142,
    142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142,
    142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
    143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
    143, 143, 143, 143, 143, 143, 143, 143, 143,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144,
    144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144,
    144, 144, 144, 144, 144, 144, 144, 144, 144, 144,   0, 144,   0,   0,   0,   0,   0, 144,
      0,   0, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145, 145, 145, 145, 145,   0,   0, 145, 145, 145,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 146, 146, 146, 146, 146, 146, 146, 146,
    146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146,
    146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146,
    146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146,
    146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146,
    147, 147, 147, 147, 147, 147,   0,   0, 148, 148, 148, 148, 148, 148,   0,   0, 149, 150,
    151, 152, 153, 154, 155, 156, 157,   0,   0,   0,   0,   0,   0,   0, 158, 158, 158, 158,
    158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158,
    158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158, 158,
    158, 158, 158,   0,   0, 158, 158, 158,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0, 160,   0,   0,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13, 161, 162,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,   0,   0,   0,   0,   0, 163,   0,   0, 164,   0,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13, 147, 147, 147, 147, 147, 147,
    147, 147, 148, 148, 148, 148, 148, 148, 148, 148, 147, 147, 147, 147, 147, 147,   0,   0,
    148, 148, 148, 148, 148, 148,   0,   0, 147, 147, 147, 147, 147, 147, 147, 147, 148, 148,
    148, 148, 148, 148, 148, 148, 147, 147, 147, 147, 147, 147, 147, 147, 148, 148, 148, 148,
    148, 148, 148, 148, 147, 147, 147, 147, 147, 147,   0,   0, 148, 148, 148, 148, 148, 148,
      0,   0,   0, 147,   0, 147,   0, 147,   0, 147,   0, 148,   0, 148,   0, 148,   0, 148,
    147, 147, 147, 147, 147, 147, 147, 147, 148, 148, 148, 148, 148, 148, 148, 148, 165, 165,
    166, 166, 166, 166, 167, 167, 168, 168, 169, 169, 170, 170,   0,   0, 147, 147, 147, 147,
    147, 147, 147, 147, 148, 148, 148, 148, 148, 148, 148, 148, 147, 147, 147, 147, 147, 147,
    147, 147, 148, 148, 148, 148, 148, 148, 148, 148, 147, 147, 147, 147, 147, 147, 147, 147,
    148, 148, 148, 148, 148, 148, 148, 148, 147, 147,   0, 171,   0,   0,   0,   0, 148, 148,
    172, 172, 173,   0, 174,   0,   0,   0,   0, 171,   0,   0,   0,   0, 175, 175, 175, 175,
    173,   0,   0,   0, 147, 147,   0,   0,   0,   0,   0,   0, 148, 148, 176, 176,   0,   0,
      0,   0, 147, 147,   0,   0,   0, 119,   0,   0, 148, 148, 177, 177, 123,   0,   0,   0,
      0,   0,   0, 171,   0,   0,   0,   0, 178, 178, 179, 179, 173,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    180,   0,   0,   0, 181, 182,   0,   0,   0,   0,   0,   0, 183,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 184,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 185, 185, 185, 185, 185, 185, 185, 185, 185, 185, 185, 185, 185, 185,
    185, 185, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186,
      0,   0,   0,  12,  13,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 187, 187, 187, 187, 187, 187, 187, 187,
    187, 187, 187, 187, 187, 187, 187, 187, 187, 187, 187, 187, 187, 187, 187, 187, 187, 187,
    188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188,
    188, 188, 188, 188, 188, 188, 188, 188,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 142, 142, 142, 142, 142, 142,
    142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142,
    142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142,
    142, 142, 142, 142, 142,   0, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
    143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
    143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,   0,
     12,  13, 189, 190, 191, 192, 193,  12,  13,  12,  13,  12,  13, 194, 195, 196, 197,   0,
     12,  13,   0,  12,  13,   0,   0,   0,   0,   0,   0,   0, 198, 198,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,   0,   0,   0,   0,
      0,   0,   0,  12,  13,  12,  13,   0,   0,   0,  12,  13,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199,
    199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199,
    199, 199, 199, 199, 199, 199, 199, 199,   0, 199,   0,   0,   0,   0,   0, 199,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13, 200, 201,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,   0,   0,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,   0,   0,   0,   0,   0,   0,   0,   0,   0,  12,  13,  12,  13, 202,
     12,  13,  12,  13,  12,  13,  12,  13,  12,  13,   0,   0,   0,  12,  13, 203,   0,   0,
     12,  13,  12,  13,   0,   0,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,  12,  13,
     12,  13,  12,  13,  12,  13,  12,  13, 204, 205, 206, 207, 204,   0, 208, 209, 210, 211,
     12,  13,  12,  13,  12,  13,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 212,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,
    213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,
    213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,
    213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,
    213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   0,   0,   0,   0,   0,   0,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

bool
js::unicode::IsIdentifierStartNonBMP(uint32_t codePoint)
{
    if (codePoint >= 0x10000 && codePoint <= 0x1000b)
        return true;
    if (codePoint >= 0x1000d && codePoint <= 0x10026)
        return true;
    if (codePoint >= 0x10028 && codePoint <= 0x1003a)
        return true;
    if (codePoint >= 0x1003c && codePoint <= 0x1003d)
        return true;
    if (codePoint >= 0x1003f && codePoint <= 0x1004d)
        return true;
    if (codePoint >= 0x10050 && codePoint <= 0x1005d)
        return true;
    if (codePoint >= 0x10080 && codePoint <= 0x100fa)
        return true;
    if (codePoint >= 0x10140 && codePoint <= 0x10174)
        return true;
    if (codePoint >= 0x10280 && codePoint <= 0x1029c)
        return true;
    if (codePoint >= 0x102a0 && codePoint <= 0x102d0)
        return true;
    if (codePoint >= 0x10300 && codePoint <= 0x1031f)
        return true;
    if (codePoint >= 0x1032d && codePoint <= 0x1034a)
        return true;
    if (codePoint >= 0x10350 && codePoint <= 0x10375)
        return true;
    if (codePoint >= 0x10380 && codePoint <= 0x1039d)
        return true;
    if (codePoint >= 0x103a0 && codePoint <= 0x103c3)
        return true;
    if (codePoint >= 0x103c8 && codePoint <= 0x103cf)
        return true;
    if (codePoint >= 0x103d1 && codePoint <= 0x103d5)
        return true;
    if (codePoint >= 0x10400 && codePoint <= 0x1049d)
        return true;
    if (codePoint >= 0x104b0 && codePoint <= 0x104d3)
        return true;
    if (codePoint >= 0x104d8 && codePoint <= 0x104fb)
        return true;
    if (codePoint >= 0x10500 && codePoint <= 0x10527)
        return true;
    if (codePoint >= 0x10530 && codePoint <= 0x10563)
        return true;
    if (codePoint >= 0x10600 && codePoint <= 0x10736)
        return true;
    if (codePoint >= 0x10740 && codePoint <= 0x10755)
        return true;
    if (codePoint >= 0x10760 && codePoint <= 0x10767)
        return true;
    if (codePoint >= 0x10800 && codePoint <= 0x10805)
        return true;
    if (codePoint >= 0x10808 && codePoint <= 0x10808)
        return true;
    if (codePoint >= 0x1080a && codePoint <= 0x10835)
        return true;
    if (codePoint >= 0x10837 && codePoint <= 0x10838)
        return true;
    if (codePoint >= 0x1083c && codePoint <= 0x1083c)
        return true;
    if (codePoint >= 0x1083f && codePoint <= 0x10855)
        return true;
    if (codePoint >= 0x10860 && codePoint <= 0x10876)
        return true;
    if (codePoint >= 0x10880 && codePoint <= 0x1089e)
        return true;
    if (codePoint >= 0x108e0 && codePoint <= 0x108f2)
        return true;
    if (codePoint >= 0x108f4 && codePoint <= 0x108f5)
        return true;
    if (codePoint >= 0x10900 && codePoint <= 0x10915)
        return true;
    if (codePoint >= 0x10920 && codePoint <= 0x10939)
        return true;
    if (codePoint >= 0x10980 && codePoint <= 0x109b7)
        return true;
    if (codePoint >= 0x109be && codePoint <= 0x109bf)
        return true;
    if (codePoint >= 0x10a00 && codePoint <= 0x10a00)
        return true;
    if (codePoint >= 0x10a10 && codePoint <= 0x10a13)
        return true;
    if (codePoint >= 0x10a15 && codePoint <= 0x10a17)
        return true;
    if (codePoint >= 0x10a19 && codePoint <= 0x10a35)
        return true;
    if (codePoint >= 0x10a60 && codePoint <= 0x10a7c)
        return true;
    if (codePoint >= 0x10a80 && codePoint <= 0x10a9c)
        return true;
    if (codePoint >= 0x10ac0 && codePoint <= 0x10ac7)
        return true;
    if (codePoint >= 0x10ac9 && codePoint <= 0x10ae4)
        return true;
    if (codePoint >= 0x10b00 && codePoint <= 0x10b35)
        return true;
    if (codePoint >= 0x10b40 && codePoint <= 0x10b55)
        return true;
    if (codePoint >= 0x10b60 && codePoint <= 0x10b72)
        return true;
    if (codePoint >= 0x10b80 && codePoint <= 0x10b91)
        return true;
    if (codePoint >= 0x10c00 && codePoint <= 0x10c48)
        return true;
    if (codePoint >= 0x10c80 && codePoint <= 0x10cb2)
        return true;
    if (codePoint >= 0x10cc0 && codePoint <= 0x10cf2)
        return true;
    if (codePoint >= 0x10d00 && codePoint <= 0x10d23)
        return true;
    if (codePoint >= 0x10f00 && codePoint <= 0x10f1c)
        return true;
    if (codePoint >= 0x10f27 && codePoint <= 0x10f27)
        return true;
    if (codePoint >= 0x10f30 && codePoint <= 0x10f45)
        return true;
    if (codePoint >= 0x11003 && codePoint <= 0x11037)
        return true;
    if (codePoint >= 0x11083 && codePoint <= 0x110af)
        return true;
    if (codePoint >= 0x110d0 && codePoint <= 0x110e8)
        return true;
    if (codePoint >= 0x11103 && codePoint <= 0x11126)
        return true;
    if (codePoint >= 0x11144 && codePoint <= 0x11144)
        return true;
    if (codePoint >= 0x11150 && codePoint <= 0x11172)
        return true;
    if (codePoint >= 0x11176 && codePoint <= 0x11176)
        return true;
    if (codePoint >= 0x11183 && codePoint <= 0x111b2)
        return true;
    if (codePoint >= 0x111c1 && codePoint <= 0x111c4)
        return true;
    if (codePoint >= 0x111da && codePoint <= 0x111da)
        return true;
    if (codePoint >= 0x111dc && codePoint <= 0x111dc)
        return true;
    if (codePoint >= 0x11200 && codePoint <= 0x11211)
        return true;
    if (codePoint >= 0x11213 && codePoint <= 0x1122b)
        return true;
    if (codePoint >= 0x11280 && codePoint <= 0x11286)
        return true;
    if (codePoint >= 0x11288 && codePoint <= 0x11288)
        return true;
    if (codePoint >= 0x1128a && codePoint <= 0x1128d)
        return true;
    if (codePoint >= 0x1128f && codePoint <= 0x1129d)
        return true;
    if (codePoint >= 0x1129f && codePoint <= 0x112a8)
        return true;
    if (codePoint >= 0x112b0 && codePoint <= 0x112de)
        return true;
    if (codePoint >= 0x11305 && codePoint <= 0x1130c)
        return true;
    if (codePoint >= 0x1130f && codePoint <= 0x11310)
        return true;
    if (codePoint >= 0x11313 && codePoint <= 0x11328)
        return true;
    if (codePoint >= 0x1132a && codePoint <= 0x11330)
        return true;
    if (codePoint >= 0x11332 && codePoint <= 0x11333)
        return true;
    if (codePoint >= 0x11335 && codePoint <= 0x11339)
        return true;
    if (codePoint >= 0x1133d && codePoint <= 0x1133d)
        return true;
    if (codePoint >= 0x11350 && codePoint <= 0x11350)
        return true;
    if (codePoint >= 0x1135d && codePoint <= 0x11361)
        return true;
    if (codePoint >= 0x11400 && codePoint <= 0x11434)
        return true;
    if (codePoint >= 0x11447 && codePoint <= 0x1144a)
        return true;
    if (codePoint >= 0x11480 && codePoint <= 0x114af)
        return true;
    if (codePoint >= 0x114c4 && codePoint <= 0x114c5)
        return true;
    if (codePoint >= 0x114c7 && codePoint <= 0x114c7)
        return true;
    if (codePoint >= 0x11580 && codePoint <= 0x115ae)
        return true;
    if (codePoint >= 0x115d8 && codePoint <= 0x115db)
        return true;
    if (codePoint >= 0x11600 && codePoint <= 0x1162f)
        return true;
    if (codePoint >= 0x11644 && codePoint <= 0x11644)
        return true;
    if (codePoint >= 0x11680 && codePoint <= 0x116aa)
        return true;
    if (codePoint >= 0x11700 && codePoint <= 0x1171a)
        return true;
    if (codePoint >= 0x11800 && codePoint <= 0x1182b)
        return true;
    if (codePoint >= 0x118a0 && codePoint <= 0x118df)
        return true;
    if (codePoint >= 0x118ff && codePoint <= 0x118ff)
        return true;
    if (codePoint >= 0x11a00 && codePoint <= 0x11a00)
        return true;
    if (codePoint >= 0x11a0b && codePoint <= 0x11a32)
        return true;
    if (codePoint >= 0x11a3a && codePoint <= 0x11a3a)
        return true;
    if (codePoint >= 0x11a50 && codePoint <= 0x11a50)
        return true;
    if (codePoint >= 0x11a5c && codePoint <= 0x11a83)
        return true;
    if (codePoint >= 0x11a86 && codePoint <= 0x11a89)
        return true;
    if (codePoint >= 0x11a9d && codePoint <= 0x11a9d)
        return true;
    if (codePoint >= 0x11ac0 && codePoint <= 0x11af8)
        return true;
    if (codePoint >= 0x11c00 && codePoint <= 0x11c08)
        return true;
    if (codePoint >= 0x11c0a && codePoint <= 0x11c2e)
        return true;
    if (codePoint >= 0x11c40 && codePoint <= 0x11c40)
        return true;
    if (codePoint >= 0x11c72 && codePoint <= 0x11c8f)
        return true;
    if (codePoint >= 0x11d00 && codePoint <= 0x11d06)
        return true;
    if (codePoint >= 0x11d08 && codePoint <= 0x11d09)
        return true;
    if (codePoint >= 0x11d0b && codePoint <= 0x11d30)
        return true;
    if (codePoint >= 0x11d46 && codePoint <= 0x11d46)
        return true;
    if (codePoint >= 0x11d60 && codePoint <= 0x11d65)
        return true;
    if (codePoint >= 0x11d67 && codePoint <= 0x11d68)
        return true;
    if (codePoint >= 0x11d6a && codePoint <= 0x11d89)
        return true;
    if (codePoint >= 0x11d98 && codePoint <= 0x11d98)
        return true;
    if (codePoint >= 0x11ee0 && codePoint <= 0x11ef2)
        return true;
    if (codePoint >= 0x12000 && codePoint <= 0x12399)
        return true;
    if (codePoint >= 0x12400 && codePoint <= 0x1246e)
        return true;
    if (codePoint >= 0x12480 && codePoint <= 0x12543)
        return true;
    if (codePoint >= 0x13000 && codePoint <= 0x1342e)
        return true;
    if (codePoint >= 0x14400 && codePoint <= 0x14646)
        return true;
    if (codePoint >= 0x16800 && codePoint <= 0x16a38)
        return true;
    if (codePoint >= 0x16a40 && codePoint <= 0x16a5e)
        return true;
    if (codePoint >= 0x16ad0 && codePoint <= 0x16aed)
        return true;
    if (codePoint >= 0x16b00 && codePoint <= 0x16b2f)
        return true;
    if (codePoint >= 0x16b40 && codePoint <= 0x16b43)
        return true;
    if (codePoint >= 0x16b63 && codePoint <= 0x16b77)
        return true;
    if (codePoint >= 0x16b7d && codePoint <= 0x16b8f)
        return true;
    if (codePoint >= 0x16e40 && codePoint <= 0x16e7f)
        return true;
    if (codePoint >= 0x16f00 && codePoint <= 0x16f44)
        return true;
    if (codePoint >= 0x16f50 && codePoint <= 0x16f50)
        return true;
    if (codePoint >= 0x16f93 && codePoint <= 0x16f9f)
        return true;
    if (codePoint >= 0x16fe0 && codePoint <= 0x16fe1)
        return true;
    if (codePoint >= 0x17000 && codePoint <= 0x187f1)
        return true;
    if (codePoint >= 0x18800 && codePoint <= 0x18af2)
        return true;
    if (codePoint >= 0x1b000 && codePoint <= 0x1b11e)
        return true;
    if (codePoint >= 0x1b170 && codePoint <= 0x1b2fb)
        return true;
    if (codePoint >= 0x1bc00 && codePoint <= 0x1bc6a)
        return true;
    if (codePoint >= 0x1bc70 && codePoint <= 0x1bc7c)
        return true;
    if (codePoint >= 0x1bc80 && codePoint <= 0x1bc88)
        return true;
    if (codePoint >= 0x1bc90 && codePoint <= 0x1bc99)
        return true;
    if (codePoint >= 0x1d400 && codePoint <= 0x1d454)
        return true;
    if (codePoint >= 0x1d456 && codePoint <= 0x1d49c)
        return true;
    if (codePoint >= 0x1d49e && codePoint <= 0x1d49f)
        return true;
    if (codePoint >= 0x1d4a2 && codePoint <= 0x1d4a2)
        return true;
    if (codePoint >= 0x1d4a5 && codePoint <= 0x1d4a6)
        return true;
    if (codePoint >= 0x1d4a9 && codePoint <= 0x1d4ac)
        return true;
    if (codePoint >= 0x1d4ae && codePoint <= 0x1d4b9)
        return true;
    if (codePoint >= 0x1d4bb && codePoint <= 0x1d4bb)
        return true;
    if (codePoint >= 0x1d4bd && codePoint <= 0x1d4c3)
        return true;
    if (codePoint >= 0x1d4c5 && codePoint <= 0x1d505)
        return true;
    if (codePoint >= 0x1d507 && codePoint <= 0x1d50a)
        return true;
    if (codePoint >= 0x1d50d && codePoint <= 0x1d514)
        return true;
    if (codePoint >= 0x1d516 && codePoint <= 0x1d51c)
        return true;
    if (codePoint >= 0x1d51e && codePoint <= 0x1d539)
        return true;
    if (codePoint >= 0x1d53b && codePoint <= 0x1d53e)
        return true;
    if (codePoint >= 0x1d540 && codePoint <= 0x1d544)
        return true;
    if (codePoint >= 0x1d546 && codePoint <= 0x1d546)
        return true;
    if (codePoint >= 0x1d54a && codePoint <= 0x1d550)
        return true;
    if (codePoint >= 0x1d552 && codePoint <= 0x1d6a5)
        return true;
    if (codePoint >= 0x1d6a8 && codePoint <= 0x1d6c0)
        return true;
    if (codePoint >= 0x1d6c2 && codePoint <= 0x1d6da)
        return true;
    if (codePoint >= 0x1d6dc && codePoint <= 0x1d6fa)
        return true;
    if (codePoint >= 0x1d6fc && codePoint <= 0x1d714)
        return true;
    if (codePoint >= 0x1d716 && codePoint <= 0x1d734)
        return true;
    if (codePoint >= 0x1d736 && codePoint <= 0x1d74e)
        return true;
    if (codePoint >= 0x1d750 && codePoint <= 0x1d76e)
        return true;
    if (codePoint >= 0x1d770 && codePoint <= 0x1d788)
        return true;
    if (codePoint >= 0x1d78a && codePoint <= 0x1d7a8)
        return true;
    if (codePoint >= 0x1d7aa && codePoint <= 0x1d7c2)
        return true;
    if (codePoint >= 0x1d7c4 && codePoint <= 0x1d7cb)
        return true;
    if (codePoint >= 0x1e800 && codePoint <= 0x1e8c4)
        return true;
    if (codePoint >= 0x1e900 && codePoint <= 0x1e943)
        return true;
    if (codePoint >= 0x1ee00 && codePoint <= 0x1ee03)
        return true;
    if (codePoint >= 0x1ee05 && codePoint <= 0x1ee1f)
        return true;
    if (codePoint >= 0x1ee21 && codePoint <= 0x1ee22)
        return true;
    if (codePoint >= 0x1ee24 && codePoint <= 0x1ee24)
        return true;
    if (codePoint >= 0x1ee27 && codePoint <= 0x1ee27)
        return true;
    if (codePoint >= 0x1ee29 && codePoint <= 0x1ee32)
        return true;
    if (codePoint >= 0x1ee34 && codePoint <= 0x1ee37)
        return true;
    if (codePoint >= 0x1ee39 && codePoint <= 0x1ee39)
        return true;
    if (codePoint >= 0x1ee3b && codePoint <= 0x1ee3b)
        return true;
    if (codePoint >= 0x1ee42 && codePoint <= 0x1ee42)
        return true;
    if (codePoint >= 0x1ee47 && codePoint <= 0x1ee47)
        return true;
    if (codePoint >= 0x1ee49 && codePoint <= 0x1ee49)
        return true;
    if (codePoint >= 0x1ee4b && codePoint <= 0x1ee4b)
        return true;
    if (codePoint >= 0x1ee4d && codePoint <= 0x1ee4f)
        return true;
    if (codePoint >= 0x1ee51 && codePoint <= 0x1ee52)
        return true;
    if (codePoint >= 0x1ee54 && codePoint <= 0x1ee54)
        return true;
    if (codePoint >= 0x1ee57 && codePoint <= 0x1ee57)
        return true;
    if (codePoint >= 0x1ee59 && codePoint <= 0x1ee59)
        return true;
    if (codePoint >= 0x1ee5b && codePoint <= 0x1ee5b)
        return true;
    if (codePoint >= 0x1ee5d && codePoint <= 0x1ee5d)
        return true;
    if (codePoint >= 0x1ee5f && codePoint <= 0x1ee5f)
        return true;
    if (codePoint >= 0x1ee61 && codePoint <= 0x1ee62)
        return true;
    if (codePoint >= 0x1ee64 && codePoint <= 0x1ee64)
        return true;
    if (codePoint >= 0x1ee67 && codePoint <= 0x1ee6a)
        return true;
    if (codePoint >= 0x1ee6c && codePoint <= 0x1ee72)
        return true;
    if (codePoint >= 0x1ee74 && codePoint <= 0x1ee77)
        return true;
    if (codePoint >= 0x1ee79 && codePoint <= 0x1ee7c)
        return true;
    if (codePoint >= 0x1ee7e && codePoint <= 0x1ee7e)
        return true;
    if (codePoint >= 0x1ee80 && codePoint <= 0x1ee89)
        return true;
    if (codePoint >= 0x1ee8b && codePoint <= 0x1ee9b)
        return true;
    if (codePoint >= 0x1eea1 && codePoint <= 0x1eea3)
        return true;
    if (codePoint >= 0x1eea5 && codePoint <= 0x1eea9)
        return true;
    if (codePoint >= 0x1eeab && codePoint <= 0x1eebb)
        return true;
    if (codePoint >= 0x20000 && codePoint <= 0x2a6d6)
        return true;
    if (codePoint >= 0x2a700 && codePoint <= 0x2b734)
        return true;
    if (codePoint >= 0x2b740 && codePoint <= 0x2b81d)
        return true;
    if (codePoint >= 0x2b820 && codePoint <= 0x2cea1)
        return true;
    if (codePoint >= 0x2ceb0 && codePoint <= 0x2ebe0)
        return true;
    if (codePoint >= 0x2f800 && codePoint <= 0x2fa1d)
        return true;
    return false;
}

bool
js::unicode::IsIdentifierPartNonBMP(uint32_t codePoint)
{
    if (codePoint >= 0x10000 && codePoint <= 0x1000b)
        return true;
    if (codePoint >= 0x1000d && codePoint <= 0x10026)
        return true;
    if (codePoint >= 0x10028 && codePoint <= 0x1003a)
        return true;
    if (codePoint >= 0x1003c && codePoint <= 0x1003d)
        return true;
    if (codePoint >= 0x1003f && codePoint <= 0x1004d)
        return true;
    if (codePoint >= 0x10050 && codePoint <= 0x1005d)
        return true;
    if (codePoint >= 0x10080 && codePoint <= 0x100fa)
        return true;
    if (codePoint >= 0x10140 && codePoint <= 0x10174)
        return true;
    if (codePoint >= 0x101fd && codePoint <= 0x101fd)
        return true;
    if (codePoint >= 0x10280 && codePoint <= 0x1029c)
        return true;
    if (codePoint >= 0x102a0 && codePoint <= 0x102d0)
        return true;
    if (codePoint >= 0x102e0 && codePoint <= 0x102e0)
        return true;
    if (codePoint >= 0x10300 && codePoint <= 0x1031f)
        return true;
    if (codePoint >= 0x1032d && codePoint <= 0x1034a)
        return true;
    if (codePoint >= 0x10350 && codePoint <= 0x1037a)
        return true;
    if (codePoint >= 0x10380 && codePoint <= 0x1039d)
        return true;
    if (codePoint >= 0x103a0 && codePoint <= 0x103c3)
        return true;
    if (codePoint >= 0x103c8 && codePoint <= 0x103cf)
        return true;
    if (codePoint >= 0x103d1 && codePoint <= 0x103d5)
        return true;
    if (codePoint >= 0x10400 && codePoint <= 0x1049d)
        return true;
    if (codePoint >= 0x104a0 && codePoint <= 0x104a9)
        return true;
    if (codePoint >= 0x104b0 && codePoint <= 0x104d3)
        return true;
    if (codePoint >= 0x104d8 && codePoint <= 0x104fb)
        return true;
    if (codePoint >= 0x10500 && codePoint <= 0x10527)
        return true;
    if (codePoint >= 0x10530 && codePoint <= 0x10563)
        return true;
    if (codePoint >= 0x10600 && codePoint <= 0x10736)
        return true;
    if (codePoint >= 0x10740 && codePoint <= 0x10755)
        return true;
    if (codePoint >= 0x10760 && codePoint <= 0x10767)
        return true;
    if (codePoint >= 0x10800 && codePoint <= 0x10805)
        return true;
    if (codePoint >= 0x10808 && codePoint <= 0x10808)
        return true;
    if (codePoint >= 0x1080a && codePoint <= 0x10835)
        return true;
    if (codePoint >= 0x10837 && codePoint <= 0x10838)
        return true;
    if (codePoint >= 0x1083c && codePoint <= 0x1083c)
        return true;
    if (codePoint >= 0x1083f && codePoint <= 0x10855)
        return true;
    if (codePoint >= 0x10860 && codePoint <= 0x10876)
        return true;
    if (codePoint >= 0x10880 && codePoint <= 0x1089e)
        return true;
    if (codePoint >= 0x108e0 && codePoint <= 0x108f2)
        return true;
    if (codePoint >= 0x108f4 && codePoint <= 0x108f5)
        return true;
    if (codePoint >= 0x10900 && codePoint <= 0x10915)
        return true;
    if (codePoint >= 0x10920 && codePoint <= 0x10939)
        return true;
    if (codePoint >= 0x10980 && codePoint <= 0x109b7)
        return true;
    if (codePoint >= 0x109be && codePoint <= 0x109bf)
        return true;
    if (codePoint >= 0x10a00 && codePoint <= 0x10a03)
        return true;
    if (codePoint >= 0x10a05 && codePoint <= 0x10a06)
        return true;
    if (codePoint >= 0x10a0c && codePoint <= 0x10a13)
        return true;
    if (codePoint >= 0x10a15 && codePoint <= 0x10a17)
        return true;
    if (codePoint >= 0x10a19 && codePoint <= 0x10a35)
        return true;
    if (codePoint >= 0x10a38 && codePoint <= 0x10a3a)
        return true;
    if (codePoint >= 0x10a3f && codePoint <= 0x10a3f)
        return true;
    if (codePoint >= 0x10a60 && codePoint <= 0x10a7c)
        return true;
    if (codePoint >= 0x10a80 && codePoint <= 0x10a9c)
        return true;
    if (codePoint >= 0x10ac0 && codePoint <= 0x10ac7)
        return true;
    if (codePoint >= 0x10ac9 && codePoint <= 0x10ae6)
        return true;
    if (codePoint >= 0x10b00 && codePoint <= 0x10b35)
        return true;
    if (codePoint >= 0x10b40 && codePoint <= 0x10b55)
        return true;
    if (codePoint >= 0x10b60 && codePoint <= 0x10b72)
        return true;
    if (codePoint >= 0x10b80 && codePoint <= 0x10b91)
        return true;
    if (codePoint >= 0x10c00 && codePoint <= 0x10c48)
        return true;
    if (codePoint >= 0x10c80 && codePoint <= 0x10cb2)
        return true;
    if (codePoint >= 0x10cc0 && codePoint <= 0x10cf2)
        return true;
    if (codePoint >= 0x10d00 && codePoint <= 0x10d27)
        return true;
    if (codePoint >= 0x10d30 && codePoint <= 0x10d39)
        return true;
    if (codePoint >= 0x10f00 && codePoint <= 0x10f1c)
        return true;
    if (codePoint >= 0x10f27 && codePoint <= 0x10f27)
        return true;
    if (codePoint >= 0x10f30 && codePoint <= 0x10f50)
        return true;
    if (codePoint >= 0x11000 && codePoint <= 0x11046)
        return true;
    if (codePoint >= 0x11066 && codePoint <= 0x1106f)
        return true;
    if (codePoint >= 0x1107f && codePoint <= 0x110ba)
        return true;
    if (codePoint >= 0x110d0 && codePoint <= 0x110e8)
        return true;
    if (codePoint >= 0x110f0 && codePoint <= 0x110f9)
        return true;
    if (codePoint >= 0x11100 && codePoint <= 0x11134)
        return true;
    if (codePoint >= 0x11136 && codePoint <= 0x1113f)
        return true;
    if (codePoint >= 0x11144 && codePoint <= 0x11146)
        return true;
    if (codePoint >= 0x11150 && codePoint <= 0x11173)
        return true;
    if (codePoint >= 0x11176 && codePoint <= 0x11176)
        return true;
    if (codePoint >= 0x11180 && codePoint <= 0x111c4)
        return true;
    if (codePoint >= 0x111c9 && codePoint <= 0x111cc)
        return true;
    if (codePoint >= 0x111d0 && codePoint <= 0x111da)
        return true;
    if (codePoint >= 0x111dc && codePoint <= 0x111dc)
        return true;
    if (codePoint >= 0x11200 && codePoint <= 0x11211)
        return true;
    if (codePoint >= 0x11213 && codePoint <= 0x11237)
        return true;
    if (codePoint >= 0x1123e && codePoint <= 0x1123e)
        return true;
    if (codePoint >= 0x11280 && codePoint <= 0x11286)
        return true;
    if (codePoint >= 0x11288 && codePoint <= 0x11288)
        return true;
    if (codePoint >= 0x1128a && codePoint <= 0x1128d)
        return true;
    if (codePoint >= 0x1128f && codePoint <= 0x1129d)
        return true;
    if (codePoint >= 0x1129f && codePoint <= 0x112a8)
        return true;
    if (codePoint >= 0x112b0 && codePoint <= 0x112ea)
        return true;
    if (codePoint >= 0x112f0 && codePoint <= 0x112f9)
        return true;
    if (codePoint >= 0x11300 && codePoint <= 0x11303)
        return true;
    if (codePoint >= 0x11305 && codePoint <= 0x1130c)
        return true;
    if (codePoint >= 0x1130f && codePoint <= 0x11310)
        return true;
    if (codePoint >= 0x11313 && codePoint <= 0x11328)
        return true;
    if (codePoint >= 0x1132a && codePoint <= 0x11330)
        return true;
    if (codePoint >= 0x11332 && codePoint <= 0x11333)
        return true;
    if (codePoint >= 0x11335 && codePoint <= 0x11339)
        return true;
    if (codePoint >= 0x1133b && codePoint <= 0x11344)
        return true;
    if (codePoint >= 0x11347 && codePoint <= 0x11348)
        return true;
    if (codePoint >= 0x1134b && codePoint <= 0x1134d)
        return true;
    if (codePoint >= 0x11350 && codePoint <= 0x11350)
        return true;
    if (codePoint >= 0x11357 && codePoint <= 0x11357)
        return true;
    if (codePoint >= 0x1135d && codePoint <= 0x11363)
        return true;
    if (codePoint >= 0x11366 && codePoint <= 0x1136c)
        return true;
    if (codePoint >= 0x11370 && codePoint <= 0x11374)
        return true;
    if (codePoint >= 0x11400 && codePoint <= 0x1144a)
        return true;
    if (codePoint >= 0x11450 && codePoint <= 0x11459)
        return true;
    if (codePoint >= 0x1145e && codePoint <= 0x1145e)
        return true;
    if (codePoint >= 0x11480 && codePoint <= 0x114c5)
        return true;
    if (codePoint >= 0x114c7 && codePoint <= 0x114c7)
        return true;
    if (codePoint >= 0x114d0 && codePoint <= 0x114d9)
        return true;
    if (codePoint >= 0x11580 && codePoint <= 0x115b5)
        return true;
    if (codePoint >= 0x115b8 && codePoint <= 0x115c0)
        return true;
    if (codePoint >= 0x115d8 && codePoint <= 0x115dd)
        return true;
    if (codePoint >= 0x11600 && codePoint <= 0x11640)
        return true;
    if (codePoint >= 0x11644 && codePoint <= 0x11644)
        return true;
    if (codePoint >= 0x11650 && codePoint <= 0x11659)
        return true;
    if (codePoint >= 0x11680 && codePoint <= 0x116b7)
        return true;
    if (codePoint >= 0x116c0 && codePoint <= 0x116c9)
        return true;
    if (codePoint >= 0x11700 && codePoint <= 0x1171a)
        return true;
    if (codePoint >= 0x1171d && codePoint <= 0x1172b)
        return true;
    if (codePoint >= 0x11730 && codePoint <= 0x11739)
        return true;
    if (codePoint >= 0x11800 && codePoint <= 0x1183a)
        return true;
    if (codePoint >= 0x118a0 && codePoint <= 0x118e9)
        return true;
    if (codePoint >= 0x118ff && codePoint <= 0x118ff)
        return true;
    if (codePoint >= 0x11a00 && codePoint <= 0x11a3e)
        return true;
    if (codePoint >= 0x11a47 && codePoint <= 0x11a47)
        return true;
    if (codePoint >= 0x11a50 && codePoint <= 0x11a83)
        return true;
    if (codePoint >= 0x11a86 && codePoint <= 0x11a99)
        return true;
    if (codePoint >= 0x11a9d && codePoint <= 0x11a9d)
        return true;
    if (codePoint >= 0x11ac0 && codePoint <= 0x11af8)
        return true;
    if (codePoint >= 0x11c00 && codePoint <= 0x11c08)
        return true;
    if (codePoint >= 0x11c0a && codePoint <= 0x11c36)
        return true;
    if (codePoint >= 0x11c38 && codePoint <= 0x11c40)
        return true;
    if (codePoint >= 0x11c50 && codePoint <= 0x11c59)
        return true;
    if (codePoint >= 0x11c72 && codePoint <= 0x11c8f)
        return true;
    if (codePoint >= 0x11c92 && codePoint <= 0x11ca7)
        return true;
    if (codePoint >= 0x11ca9 && codePoint <= 0x11cb6)
        return true;
    if (codePoint >= 0x11d00 && codePoint <= 0x11d06)
        return true;
    if (codePoint >= 0x11d08 && codePoint <= 0x11d09)
        return true;
    if (codePoint >= 0x11d0b && codePoint <= 0x11d36)
        return true;
    if (codePoint >= 0x11d3a && codePoint <= 0x11d3a)
        return true;
    if (codePoint >= 0x11d3c && codePoint <= 0x11d3d)
        return true;
    if (codePoint >= 0x11d3f && codePoint <= 0x11d47)
        return true;
    if (codePoint >= 0x11d50 && codePoint <= 0x11d59)
        return true;
    if (codePoint >= 0x11d60 && codePoint <= 0x11d65)
        return true;
    if (codePoint >= 0x11d67 && codePoint <= 0x11d68)
        return true;
    if (codePoint >= 0x11d6a && codePoint <= 0x11d8e)
        return true;
    if (codePoint >= 0x11d90 && codePoint <= 0x11d91)
        return true;
    if (codePoint >= 0x11d93 && codePoint <= 0x11d98)
        return true;
    if (codePoint >= 0x11da0 && codePoint <= 0x11da9)
        return true;
    if (codePoint >= 0x11ee0 && codePoint <= 0x11ef6)
        return true;
    if (codePoint >= 0x12000 && codePoint <= 0x12399)
        return true;
    if (codePoint >= 0x12400 && codePoint <= 0x1246e)
        return true;
    if (codePoint >= 0x12480 && codePoint <= 0x12543)
        return true;
    if (codePoint >= 0x13000 && codePoint <= 0x1342e)
        return true;
    if (codePoint >= 0x14400 && codePoint <= 0x14646)
        return true;
    if (codePoint >= 0x16800 && codePoint <= 0x16a38)
        return true;
    if (codePoint >= 0x16a40 && codePoint <= 0x16a5e)
        return true;
    if (codePoint >= 0x16a60 && codePoint <= 0x16a69)
        return true;
    if (codePoint >= 0x16ad0 && codePoint <= 0x16aed)
        return true;
    if (codePoint >= 0x16af0 && codePoint <= 0x16af4)
        return true;
    if (codePoint >= 0x16b00 && codePoint <= 0x16b36)
        return true;
    if (codePoint >= 0x16b40 && codePoint <= 0x16b43)
        return true;
    if (codePoint >= 0x16b50 && codePoint <= 0x16b59)
        return true;
    if (codePoint >= 0x16b63 && codePoint <= 0x16b77)
        return true;
    if (codePoint >= 0x16b7d && codePoint <= 0x16b8f)
        return true;
    if (codePoint >= 0x16e40 && codePoint <= 0x16e7f)
        return true;
    if (codePoint >= 0x16f00 && codePoint <= 0x16f44)
        return true;
    if (codePoint >= 0x16f50 && codePoint <= 0x16f7e)
        return true;
    if (codePoint >= 0x16f8f && codePoint <= 0x16f9f)
        return true;
    if (codePoint >= 0x16fe0 && codePoint <= 0x16fe1)
        return true;
    if (codePoint >= 0x17000 && codePoint <= 0x187f1)
        return true;
    if (codePoint >= 0x18800 && codePoint <= 0x18af2)
        return true;
    if (codePoint >= 0x1b000 && codePoint <= 0x1b11e)
        return true;
    if (codePoint >= 0x1b170 && codePoint <= 0x1b2fb)
        return true;
    if (codePoint >= 0x1bc00 && codePoint <= 0x1bc6a)
        return true;
    if (codePoint >= 0x1bc70 && codePoint <= 0x1bc7c)
        return true;
    if (codePoint >= 0x1bc80 && codePoint <= 0x1bc88)
        return true;
    if (codePoint >= 0x1bc90 && codePoint <= 0x1bc99)
        return true;
    if (codePoint >= 0x1bc9d && codePoint <= 0x1bc9e)
        return true;
    if (codePoint >= 0x1d165 && codePoint <= 0x1d169)
        return true;
    if (codePoint >= 0x1d16d && codePoint <= 0x1d172)
        return true;
    if (codePoint >= 0x1d17b && codePoint <= 0x1d182)
        return true;
    if (codePoint >= 0x1d185 && codePoint <= 0x1d18b)
        return true;
    if (codePoint >= 0x1d1aa && codePoint <= 0x1d1ad)
        return true;
    if (codePoint >= 0x1d242 && codePoint <= 0x1d244)
        return true;
    if (codePoint >= 0x1d400 && codePoint <= 0x1d454)
        return true;
    if (codePoint >= 0x1d456 && codePoint <= 0x1d49c)
        return true;
    if (codePoint >= 0x1d49e && codePoint <= 0x1d49f)
        return true;
    if (codePoint >= 0x1d4a2 && codePoint <= 0x1d4a2)
        return true;
    if (codePoint >= 0x1d4a5 && codePoint <= 0x1d4a6)
        return true;
    if (codePoint >= 0x1d4a9 && codePoint <= 0x1d4ac)
        return true;
    if (codePoint >= 0x1d4ae && codePoint <= 0x1d4b9)
        return true;
    if (codePoint >= 0x1d4bb && codePoint <= 0x1d4bb)
        return true;
    if (codePoint >= 0x1d4bd && codePoint <= 0x1d4c3)
        return true;
    if (codePoint >= 0x1d4c5 && codePoint <= 0x1d505)
        return true;
    if (codePoint >= 0x1d507 && codePoint <= 0x1d50a)
        return true;
    if (codePoint >= 0x1d50d && codePoint <= 0x1d514)
        return true;
    if (codePoint >= 0x1d516 && codePoint <= 0x1d51c)
        return true;
    if (codePoint >= 0x1d51e && codePoint <= 0x1d539)
        return true;
    if (codePoint >= 0x1d53b && codePoint <= 0x1d53e)
        return true;
    if (codePoint >= 0x1d540 && codePoint <= 0x1d544)
        return true;
    if (codePoint >= 0x1d546 && codePoint <= 0x1d546)
        return true;
    if (codePoint >= 0x1d54a && codePoint <= 0x1d550)
        return true;
    if (codePoint >= 0x1d552 && codePoint <= 0x1d6a5)
        return true;
    if (codePoint >= 0x1d6a8 && codePoint <= 0x1d6c0)
        return true;
    if (codePoint >= 0x1d6c2 && codePoint <= 0x1d6da)
        return true;
    if (codePoint >= 0x1d6dc && codePoint <= 0x1d6fa)
        return true;
    if (codePoint >= 0x1d6fc && codePoint <= 0x1d714)
        return true;
    if (codePoint >= 0x1d716 && codePoint <= 0x1d734)
        return true;
    if (codePoint >= 0x1d736 && codePoint <= 0x1d74e)
        return true;
    if (codePoint >= 0x1d750 && codePoint <= 0x1d76e)
        return true;
    if (codePoint >= 0x1d770 && codePoint <= 0x1d788)
        return true;
    if (codePoint >= 0x1d78a && codePoint <= 0x1d7a8)
        return true;
    if (codePoint >= 0x1d7aa && codePoint <= 0x1d7c2)
        return true;
    if (codePoint >= 0x1d7c4 && codePoint <= 0x1d7cb)
        return true;
    if (codePoint >= 0x1d7ce && codePoint <= 0x1d7ff)
        return true;
    if (codePoint >= 0x1da00 && codePoint <= 0x1da36)
        return true;
    if (codePoint >= 0x1da3b && codePoint <= 0x1da6c)
        return true;
    if (codePoint >= 0x1da75 && codePoint <= 0x1da75)
        return true;
    if (codePoint >= 0x1da84 && codePoint <= 0x1da84)
        return true;
    if (codePoint >= 0x1da9b && codePoint <= 0x1da9f)
        return true;
    if (codePoint >= 0x1daa1 && codePoint <= 0x1daaf)
        return true;
    if (codePoint >= 0x1e000 && codePoint <= 0x1e006)
        return true;
    if (codePoint >= 0x1e008 && codePoint <= 0x1e018)
        return true;
    if (codePoint >= 0x1e01b && codePoint <= 0x1e021)
        return true;
    if (codePoint >= 0x1e023 && codePoint <= 0x1e024)
        return true;
    if (codePoint >= 0x1e026 && codePoint <= 0x1e02a)
        return true;
    if (codePoint >= 0x1e800 && codePoint <= 0x1e8c4)
        return true;
    if (codePoint >= 0x1e8d0 && codePoint <= 0x1e8d6)
        return true;
    if (codePoint >= 0x1e900 && codePoint <= 0x1e94a)
        return true;
    if (codePoint >= 0x1e950 && codePoint <= 0x1e959)
        return true;
    if (codePoint >= 0x1ee00 && codePoint <= 0x1ee03)
        return true;
    if (codePoint >= 0x1ee05 && codePoint <= 0x1ee1f)
        return true;
    if (codePoint >= 0x1ee21 && codePoint <= 0x1ee22)
        return true;
    if (codePoint >= 0x1ee24 && codePoint <= 0x1ee24)
        return true;
    if (codePoint >= 0x1ee27 && codePoint <= 0x1ee27)
        return true;
    if (codePoint >= 0x1ee29 && codePoint <= 0x1ee32)
        return true;
    if (codePoint >= 0x1ee34 && codePoint <= 0x1ee37)
        return true;
    if (codePoint >= 0x1ee39 && codePoint <= 0x1ee39)
        return true;
    if (codePoint >= 0x1ee3b && codePoint <= 0x1ee3b)
        return true;
    if (codePoint >= 0x1ee42 && codePoint <= 0x1ee42)
        return true;
    if (codePoint >= 0x1ee47 && codePoint <= 0x1ee47)
        return true;
    if (codePoint >= 0x1ee49 && codePoint <= 0x1ee49)
        return true;
    if (codePoint >= 0x1ee4b && codePoint <= 0x1ee4b)
        return true;
    if (codePoint >= 0x1ee4d && codePoint <= 0x1ee4f)
        return true;
    if (codePoint >= 0x1ee51 && codePoint <= 0x1ee52)
        return true;
    if (codePoint >= 0x1ee54 && codePoint <= 0x1ee54)
        return true;
    if (codePoint >= 0x1ee57 && codePoint <= 0x1ee57)
        return true;
    if (codePoint >= 0x1ee59 && codePoint <= 0x1ee59)
        return true;
    if (codePoint >= 0x1ee5b && codePoint <= 0x1ee5b)
        return true;
    if (codePoint >= 0x1ee5d && codePoint <= 0x1ee5d)
        return true;
    if (codePoint >= 0x1ee5f && codePoint <= 0x1ee5f)
        return true;
    if (codePoint >= 0x1ee61 && codePoint <= 0x1ee62)
        return true;
    if (codePoint >= 0x1ee64 && codePoint <= 0x1ee64)
        return true;
    if (codePoint >= 0x1ee67 && codePoint <= 0x1ee6a)
        return true;
    if (codePoint >= 0x1ee6c && codePoint <= 0x1ee72)
        return true;
    if (codePoint >= 0x1ee74 && codePoint <= 0x1ee77)
        return true;
    if (codePoint >= 0x1ee79 && codePoint <= 0x1ee7c)
        return true;
    if (codePoint >= 0x1ee7e && codePoint <= 0x1ee7e)
        return true;
    if (codePoint >= 0x1ee80 && codePoint <= 0x1ee89)
        return true;
    if (codePoint >= 0x1ee8b && codePoint <= 0x1ee9b)
        return true;
    if (codePoint >= 0x1eea1 && codePoint <= 0x1eea3)
        return true;
    if (codePoint >= 0x1eea5 && codePoint <= 0x1eea9)
        return true;
    if (codePoint >= 0x1eeab && codePoint <= 0x1eebb)
        return true;
    if (codePoint >= 0x20000 && codePoint <= 0x2a6d6)
        return true;
    if (codePoint >= 0x2a700 && codePoint <= 0x2b734)
        return true;
    if (codePoint >= 0x2b740 && codePoint <= 0x2b81d)
        return true;
    if (codePoint >= 0x2b820 && codePoint <= 0x2cea1)
        return true;
    if (codePoint >= 0x2ceb0 && codePoint <= 0x2ebe0)
        return true;
    if (codePoint >= 0x2f800 && codePoint <= 0x2fa1d)
        return true;
    if (codePoint >= 0xe0100 && codePoint <= 0xe01ef)
        return true;
    return false;
}
