/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*****************************************************************************/
/* This is an automatically generated file. If you're not                    */
/* nsSiteSecurityService.cpp, you shouldn't be #including it.     */
/*****************************************************************************/

#include <stdint.h>
const PRTime gPreloadListExpirationTime = INT64_C(1569913558186000);

class nsSTSPreload
{
  public:
    const char *mHost;
    const bool mIncludeSubdomains;
};

static const nsSTSPreload kSTSPreloadList[] = {
  { "000321365.com", true },
  { "00321365.com", true },
  { "003971.com", true },
  { "005555.xyz", true },
  { "008207.com", true },
  { "008251.com", true },
  { "008253.com", true },
  { "008271.com", true },
  { "009p.com", true },
  { "00dani.me", true },
  { "00f.net", true },
  { "0100dev.com", false },
  { "0100dev.nl", false },
  { "01011970.xyz", true },
  { "01110000011100110111001001100111.com", true },
  { "01918.net", true },
  { "021002.com", true },
  { "022367.com", true },
  { "022379.com", true },
  { "022391.com", true },
  { "022501.com", true },
  { "022503.com", true },
  { "022507.com", true },
  { "022561.com", true },
  { "022571.com", true },
  { "022601.com", true },
  { "022609.com", true },
  { "022610.com", true },
  { "02327.net", true },
  { "02375.net", true },
  { "025ks.com", true },
  { "026122.com", true },
  { "02638.net", true },
  { "02am8.com", true },
  { "03012.net", true },
  { "03018.net", true },
  { "03170317.com", true },
  { "0391315.com", true },
  { "046569.com", true },
  { "04911701.cn", true },
  { "04dco.tk", true },
  { "050.ca", true },
  { "050869.com", true },
  { "050media.nl", true },
  { "0511315.net", true },
  { "0513c.com", true },
  { "056657.com", true },
  { "056675.com", true },
  { "056679.com", true },
  { "056687.com", true },
  { "056690.com", true },
  { "056697.com", true },
  { "056867.com", true },
  { "056869.com", true },
  { "056875.com", true },
  { "056879.com", true },
  { "056950.com", true },
  { "056976.com", true },
  { "056985.com", true },
  { "0573wk.com", true },
  { "057587.com", true },
  { "057596.com", true },
  { "058509.com", true },
  { "058596.com", true },
  { "058679.com", true },
  { "059957.com", true },
  { "05am8.com", true },
  { "060258.com", true },
  { "060579.com", true },
  { "060757.com", true },
  { "060795.com", true },
  { "060796.com", true },
  { "060798.com", true },
  { "0607p.com", true },
  { "060870.com", true },
  { "060875.com", true },
  { "06091994.xyz", true },
  { "065679.com", true },
  { "065706.com", true },
  { "065790.com", true },
  { "065970.com", true },
  { "065976.com", true },
  { "066570.com", true },
  { "066579.com", true },
  { "066590.com", true },
  { "066705.com", true },
  { "066709.com", true },
  { "066790.com", true },
  { "066816.com", true },
  { "06804.com", true },
  { "068697.com", true },
  { "068756.com", true },
  { "068957.com", true },
  { "06918.net", true },
  { "069657.com", true },
  { "069676.com", true },
  { "06se.com", true },
  { "0708p.com", true },
  { "070968.com", true },
  { "070986.com", true },
  { "0720p.com", true },
  { "0736ks.com", true },
  { "077768.net", true },
  { "0792112.com", true },
  { "079606.com", true },
  { "079607.com", true },
  { "0798rcw.com", true },
  { "07stars.com", true },
  { "081115.com", true },
  { "081752.com", true },
  { "081763.com", true },
  { "081769.com", true },
  { "081783.com", true },
  { "081925.com", true },
  { "081927.com", true },
  { "081957.com", true },
  { "081967.com", true },
  { "082157.com", true },
  { "082159.com", true },
  { "082167.com", true },
  { "082173.com", true },
  { "082175.com", true },
  { "082179.com", true },
  { "082187.com", true },
  { "082192.com", true },
  { "082193.com", true },
  { "082195.com", true },
  { "082359.com", true },
  { "083903.com", true },
  { "083905.com", true },
  { "083907.com", true },
  { "083912.com", true },
  { "083957.com", true },
  { "083960.com", true },
  { "083962.com", true },
  { "083965.com", true },
  { "083967.com", true },
  { "085806.com", true },
  { "085905.com", true },
  { "085950.com", true },
  { "086807.com", true },
  { "086907.com", true },
  { "087010.com", true },
  { "087059.com", true },
  { "087065.com", true },
  { "087540.com", true },
  { "087569.com", true },
  { "087580.com", true },
  { "08845.cc", true },
  { "08918.net", true },
  { "089818.com", true },
  { "08am8.com", true },
  { "08detaxe.fr", true },
  { "0916app.com", true },
  { "095598.cc", true },
  { "09892.net", true },
  { "098955.com", true },
  { "09btt.com", true },
  { "09elektrik.com", true },
  { "0au.de", true },
  { "0c3.de", true },
  { "0chan.pl", true },
  { "0day.agency", true },
  { "0des.com", true },
  { "0ii0.cf", true },
  { "0ik.de", true },
  { "0knowledge.de", false },
  { "0paste.com", true },
  { "0wx.cat", true },
  { "0wx.es", true },
  { "0wx.eu", true },
  { "0wx.org", true },
  { "0x.cx", true },
  { "0x.sk", true },
  { "0x0.cloud", true },
  { "0x0.li", true },
  { "0x0000.ml", true },
  { "0x00c.de", true },
  { "0x00ff00ff.com", true },
  { "0x17.de", true },
  { "0x378.net", true },
  { "0x41.us", true },
  { "0x48.pw", true },
  { "0x52.net", true },
  { "0x7d.com", true },
  { "0x7fffffff.net", true },
  { "0x80.org", true },
  { "0x90.io", true },
  { "0xabe.io", true },
  { "0xacab.org", true },
  { "0xaf.tk", true },
  { "0xda.de", true },
  { "0xdc.io", false },
  { "0xdefaced.de", true },
  { "0xf00.ch", true },
  { "0xfc.de", true },
  { "0xff.se", true },
  { "0xn.de", true },
  { "1-2-3bounce.co.uk", true },
  { "100-downloads.com", true },
  { "10000v.ru", true },
  { "1000minds.com", true },
  { "1001kartini.com", true },
  { "1001kerstpakketten.com", false },
  { "10086.ru", true },
  { "100k.eu", true },
  { "100kredite.de", true },
  { "100lat.pl", true },
  { "100mani.it", true },
  { "100pounds.co.uk", true },
  { "101.qa", true },
  { "101010.pl", true },
  { "1011100.com", true },
  { "101sauna.kz", true },
  { "101sauna.ru", true },
  { "1041263497.rsc.cdn77.org", true },
  { "10430.net", true },
  { "10435.net", true },
  { "10436.net", true },
  { "10438.net", true },
  { "10439.net", true },
  { "10453.net", true },
  { "10495.net", true },
  { "10774.net", true },
  { "10840.net", true },
  { "10hz.de", true },
  { "10og.de", true },
  { "10ppm.com", true },
  { "110320.com", true },
  { "110692.com", true },
  { "111.one", true },
  { "1111k8.com", true },
  { "111321365.com", true },
  { "111zlong.com", true },
  { "1126p.com", true },
  { "112app.nl", true },
  { "112hz.com", true },
  { "112it.ro", true },
  { "1130p.com", true },
  { "11321365.com", true },
  { "114514ss.com", true },
  { "1177107.com", true },
  { "118btt.com", true },
  { "11loc.de", true },
  { "11thstreetcoffee.com", true },
  { "11urss.com", true },
  { "120323.com", true },
  { "1212873467.rsc.cdn77.org", true },
  { "1218641649.rsc.cdn77.org", true },
  { "123123qq.com", true },
  { "1236.be", true },
  { "123apps.net", true },
  { "123bearing.co.uk", true },
  { "123bearing.com", true },
  { "123bearing.eu", true },
  { "123birthdaygreetings.com", true },
  { "123comparer.fr", true },
  { "123derivatives.com", true },
  { "123djdrop.com", true },
  { "123midterm.com", true },
  { "123nutricion.es", true },
  { "123opstalverzekeringen.nl", true },
  { "123roulement.be", true },
  { "123roulement.com", true },
  { "123termpapers.com", true },
  { "123writings.com", true },
  { "124133.com", true },
  { "124633.com", true },
  { "125m125.de", true },
  { "126772.com", true },
  { "127661.com", true },
  { "127662.com", true },
  { "127663.com", true },
  { "127665.com", true },
  { "12autoankauf-berlin.de", true },
  { "12gotovo.com", true },
  { "12thmanrising.com", true },
  { "12train.com", true },
  { "12vpn.net", true },
  { "130.ua", true },
  { "130032.com", true },
  { "130212.com", true },
  { "130232.com", true },
  { "130497.xyz", true },
  { "131934.com", true },
  { "131954.com", true },
  { "13214.cc", true },
  { "132301.com", true },
  { "132302.com", true },
  { "132kv.ch", true },
  { "133294.com", true },
  { "133492.com", true },
  { "133846.xyz", true },
  { "136774.com", true },
  { "136814.com", true },
  { "136824.com", true },
  { "136924.com", true },
  { "137724.com", true },
  { "1391kj.com", true },
  { "1395kj.com", true },
  { "1406304513.com", true },
  { "141145.com", true },
  { "143533.com", true },
  { "143633.com", true },
  { "143733.com", true },
  { "143933.com", true },
  { "1453914078.rsc.cdn77.org", true },
  { "145433.com", true },
  { "145733.com", true },
  { "145ks.net", true },
  { "146233.com", true },
  { "146433.com", true },
  { "1464424382.rsc.cdn77.org", true },
  { "146533.com", true },
  { "146733.com", true },
  { "149433.com", true },
  { "149733.com", true },
  { "14it.de", true },
  { "14x3.de", true },
  { "15-10.com", true },
  { "1511774230.rsc.cdn77.org", true },
  { "152433.com", true },
  { "1527web.com", true },
  { "154233.com", true },
  { "154633.com", true },
  { "154933.com", true },
  { "155175.com", true },
  { "156433.com", true },
  { "158306.com", true },
  { "1590284872.rsc.cdn77.org", true },
  { "15918.net", true },
  { "159cp.com", true },
  { "1600esplanade.com", true },
  { "160887.com", true },
  { "161233.com", true },
  { "161263.com", true },
  { "162223.com", true },
  { "162231.com", true },
  { "162263.com", true },
  { "162361.com", true },
  { "162632.com", true },
  { "162jonesrd.ca", true },
  { "163132.com", true },
  { "1644091933.rsc.cdn77.org", true },
  { "1661237.com", true },
  { "168btt.com", true },
  { "168btt.net", true },
  { "170686.com", true },
  { "171083.com", true },
  { "1750studios.com", false },
  { "1768calc.com.au", true },
  { "176f88.com", true },
  { "177603.com", true },
  { "17kpw.cc", true },
  { "17kpw.com", true },
  { "17xile.com", true },
  { "180btt.com", true },
  { "1811559.com", true },
  { "182162.com", true },
  { "182wh.com", true },
  { "1844329061.rsc.cdn77.org", true },
  { "1876996.com", true },
  { "188198.net", true },
  { "188da.com", true },
  { "1895media.com", true },
  { "18f.gov", true },
  { "18f.gsa.gov", false },
  { "191090.com", true },
  { "1911trust.com", true },
  { "192433.com", true },
  { "1972969867.rsc.cdn77.org", true },
  { "1981612088.rsc.cdn77.org", true },
  { "1994.io", true },
  { "19btt.com", true },
  { "19hundert84.de", false },
  { "19qq.vip", true },
  { "1a-diamantscheiben.de", true },
  { "1a-werkstattgeraete.de", true },
  { "1ab-machinery.com", true },
  { "1android.de", true },
  { "1c-power.ru", true },
  { "1chan.pl", true },
  { "1cover.co.nz", true },
  { "1cover.com.au", true },
  { "1cswd.com", true },
  { "1e9.nl", true },
  { "1f123.net", true },
  { "1fach-digital.de", true },
  { "1gp.us", true },
  { "1hc.be", true },
  { "1hourproofreading.com", true },
  { "1in9.net", true },
  { "1it.click", true },
  { "1js.de", true },
  { "1kando.com", false },
  { "1ki174.com", true },
  { "1kmi.co", true },
  { "1ll.uk", true },
  { "1lord1faith.com", true },
  { "1m.duckdns.org", true },
  { "1montre.fr", true },
  { "1morebounce.co.uk", true },
  { "1nfr.com", false },
  { "1oaklasvegas.com", true },
  { "1of16.de", true },
  { "1on1on1.de", true },
  { "1on1on1.tv", true },
  { "1panorama.ru", true },
  { "1password.ca", true },
  { "1password.com", true },
  { "1password.eu", true },
  { "1pw.ca", true },
  { "1px.tv", true },
  { "1r.is", true },
  { "1rs.nl", true },
  { "1sand0s.nl", true },
  { "1se.co", true },
  { "1se2or3.com", true },
  { "1st-bounce.co.uk", true },
  { "1st-community.de", true },
  { "1stchoicefun.co.uk", true },
  { "1stchoicelandscapingwa.com", true },
  { "1stclassbouncycastles.co.uk", true },
  { "1stforfun.co.uk", true },
  { "1stpeninsulabouncers.co.uk", true },
  { "1v9.im", true },
  { "1way.faith", true },
  { "1whw.co.uk", true },
  { "1wirelog.de", true },
  { "1wl.uk", true },
  { "1zombie.team", true },
  { "2.wtf", true },
  { "200.network", true },
  { "2001y.me", true },
  { "2012.ovh", true },
  { "204504byse.info", true },
  { "2083236893.com", true },
  { "208garfield.com", true },
  { "20at.com", true },
  { "20denier.com", true },
  { "215dy.net", true },
  { "218btt.com", true },
  { "21sthammersmith.org.uk", true },
  { "21stnc.us", true },
  { "21x9.org", true },
  { "2206p.com", true },
  { "22321365.com", true },
  { "224918.com", true },
  { "22918.net", true },
  { "22delta.com", true },
  { "22txc.com", true },
  { "22vetter.st", true },
  { "230beats.com", true },
  { "233.be", true },
  { "2333666.xyz", true },
  { "2333blog.com", true },
  { "233blog.com", true },
  { "233boy.com", true },
  { "233bwg.com", true },
  { "233hub.com", true },
  { "233now.com", true },
  { "233v2.com", true },
  { "233vps.com", true },
  { "233yes.com", true },
  { "23436565.com", true },
  { "238212.com", true },
  { "24-7.jp", true },
  { "24.ie", true },
  { "245meadowvistaway.com", true },
  { "246060.ru", true },
  { "247exchange.com", true },
  { "247healthshop.com", true },
  { "247medplan.com", true },
  { "2495dentalimplants.com", true },
  { "249722.com", true },
  { "24dian30.com", true },
  { "24hour-locksmithsanantonio.com", true },
  { "24hourcyclist.co.uk", true },
  { "24hourlocksmithbaltimore.com", true },
  { "24hourlocksmithdallastx.com", true },
  { "24hourlocksmithdetroit.com", true },
  { "24hourlocksmithshouston.com", true },
  { "24hoursanantoniolocksmiths.com", true },
  { "24hourscienceprojects.com", true },
  { "24ip.com", true },
  { "24ip.de", true },
  { "24ip.fr", true },
  { "24seven.pk", true },
  { "24zpravy.cz", true },
  { "2502.net", true },
  { "2525admin.nl", true },
  { "256pages.com", false },
  { "2586p.com", true },
  { "258877.com", true },
  { "25reinyan25.net", true },
  { "26004.cc", true },
  { "2600edinburgh.org", true },
  { "2600hq.com", true },
  { "260887.com", true },
  { "263.info", true },
  { "267221.com", true },
  { "267661.com", true },
  { "27000.best", true },
  { "2718282.net", true },
  { "276112.com", true },
  { "276117.com", true },
  { "276771.com", true },
  { "28-industries.com", true },
  { "281116.com", true },
  { "281180.de", true },
  { "2858958.com", true },
  { "288game.net", true },
  { "28peaks.com", true },
  { "28spots.net", true },
  { "291167.xyz", true },
  { "2912.nl", true },
  { "2948.ca", true },
  { "2991236.com", true },
  { "2au.ru", true },
  { "2bas.nl", true },
  { "2bcompany.ch", true },
  { "2bis10.de", true },
  { "2bougie.com", true },
  { "2c-b.com", true },
  { "2c-d.com", true },
  { "2c-e.com", true },
  { "2c-t-2.com", true },
  { "2c-t-7.com", true },
  { "2c-t-8.com", true },
  { "2cash.ru", true },
  { "2chan.eu", true },
  { "2chan.jp", true },
  { "2cv-fahrer.de", true },
  { "2fm.ie", true },
  { "2fm.radio", true },
  { "2fraud.pro", true },
  { "2gen.com", true },
  { "2h-nagoya.org", true },
  { "2heartsbookings.co.uk", true },
  { "2hypeenterprises.com", true },
  { "2kgwf.fi", true },
  { "2krueger.de", true },
  { "2li.ch", true },
  { "2manydots.nl", true },
  { "2mb.solutions", true },
  { "2melo.fr", true },
  { "2nains.ch", true },
  { "2nerds1bit.com", true },
  { "2nics.net", true },
  { "2pay.fr", true },
  { "2programmers.net", true },
  { "2rsc.com", true },
  { "2rsc.net", true },
  { "2stv.net", true },
  { "2tuu.com", true },
  { "2ulcceria.nl", true },
  { "2wheel.com", true },
  { "2y.fi", true },
  { "3-dot-careapp1-146314.appspot.com", true },
  { "300m.com", false },
  { "301.technology", true },
  { "302422.com", true },
  { "303112.com", true },
  { "303312.com", true },
  { "303422.com", true },
  { "304122.com", true },
  { "304322.com", true },
  { "304622.com", true },
  { "3056999.com", true },
  { "309422.com", true },
  { "30hzcollective.com", true },
  { "310422.com", true },
  { "311186.com", true },
  { "311191.com", true },
  { "313422.com", true },
  { "314022.com", true },
  { "314122.com", true },
  { "314322.com", true },
  { "314522.com", true },
  { "314553.com", true },
  { "314622.com", true },
  { "314633.com", true },
  { "314922.com", true },
  { "315422.com", true },
  { "316433.com", true },
  { "319422.com", true },
  { "31klabs.com", true },
  { "320281.net", true },
  { "321132.com", true },
  { "321live.nl", true },
  { "324022.com", true },
  { "324122.com", true },
  { "324133.com", true },
  { "324522.com", true },
  { "324533.com", true },
  { "324922.com", true },
  { "325422.com", true },
  { "326422.com", true },
  { "326433.com", true },
  { "329422.com", true },
  { "32h.de", true },
  { "33-km.ru", true },
  { "33321365.com", true },
  { "333321365.com", true },
  { "33445111.com", true },
  { "33445222.com", true },
  { "33445333.com", true },
  { "33445444.com", true },
  { "3345.com", true },
  { "3351p.com", true },
  { "3361p.com", true },
  { "338393.com", true },
  { "338sa.com", true },
  { "33am8.com", true },
  { "33jiasu.com", true },
  { "340422.com", true },
  { "340622.com", true },
  { "340922.com", true },
  { "341422.com", true },
  { "341433.com", true },
  { "341533.com", true },
  { "341633.com", true },
  { "341733.com", true },
  { "341922.com", true },
  { "342022.com", true },
  { "342033.com", true },
  { "342133.com", true },
  { "342633.com", true },
  { "342733.com", true },
  { "342922.com", true },
  { "342933.com", true },
  { "343022.com", true },
  { "343622.com", true },
  { "343722.com", true },
  { "343922.com", true },
  { "34536565.com", true },
  { "346022.com", true },
  { "346033.com", true },
  { "346122.com", true },
  { "346233.com", true },
  { "346322.com", true },
  { "346422.com", true },
  { "346522.com", true },
  { "346533.com", true },
  { "346722.com", true },
  { "346922.com", true },
  { "3473-wiki.de", true },
  { "348233.com", true },
  { "348433.com", true },
  { "348533.com", true },
  { "349022.com", true },
  { "349033.com", true },
  { "349233.com", true },
  { "349433.com", true },
  { "349533.com", true },
  { "350422.com", true },
  { "351113.com", true },
  { "354022.com", true },
  { "354133.com", true },
  { "354233.com", true },
  { "354622.com", true },
  { "354633.com", true },
  { "354922.com", true },
  { "354933.com", true },
  { "356433.com", true },
  { "357maelai.co", true },
  { "360-staffing.com", true },
  { "360008888.com", true },
  { "360hosting.com.au", true },
  { "360live.fr", true },
  { "360rail.nl", true },
  { "360vrs.com", true },
  { "361116.com", true },
  { "361171.com", true },
  { "361173.com", true },
  { "361183.com", true },
  { "3615jacky.fr", true },
  { "36554ll.com", true },
  { "36554mm.com", true },
  { "365654321.com", true },
  { "36565b.com", true },
  { "36565f.com", true },
  { "3657654321.com", true },
  { "36587654321.com", true },
  { "365beautyworld.com", true },
  { "365daysreview.com", true },
  { "365electricalvn.com", true },
  { "365healthworld.com", true },
  { "365iosapp.com", true },
  { "365propertybuyer.co.uk", false },
  { "365skulls.com", true },
  { "367553.com", true },
  { "367556.com", true },
  { "370422.com", true },
  { "371422.com", true },
  { "371687.com", true },
  { "371cloud.com", true },
  { "373422.com", true },
  { "373816.com", true },
  { "374933.com", true },
  { "375422.com", true },
  { "376208.com", true },
  { "376557.com", true },
  { "377625.com", true },
  { "377632.com", true },
  { "377813.com", true },
  { "377817.com", true },
  { "378553.com", true },
  { "379700.com", true },
  { "380422.com", true },
  { "38138938.com", true },
  { "382225.com", true },
  { "3838onndo.tk", true },
  { "387763.com", true },
  { "3886aa.com", true },
  { "388da.com", true },
  { "38sihu.com", false },
  { "390422.com", true },
  { "392422.com", true },
  { "393422.com", true },
  { "394022.com", true },
  { "394122.com", true },
  { "394322.com", true },
  { "394522.com", true },
  { "394553.com", true },
  { "394622.com", true },
  { "394922.com", true },
  { "396422.com", true },
  { "398.info", true },
  { "3aandl.com", true },
  { "3ags.de", true },
  { "3amtoolbox.se", true },
  { "3ank.in", false },
  { "3b.pm", true },
  { "3bakayottu.com", true },
  { "3bigking.com", true },
  { "3c-d.de", true },
  { "3chat.org", true },
  { "3countiescastlehire.co.uk", true },
  { "3cs.ch", true },
  { "3d-animator.net", true },
  { "3d-fotoservice.de", true },
  { "3d1t0r4.com", true },
  { "3dcollective.es", true },
  { "3de5.nl", true },
  { "3deeplearner.com", true },
  { "3dgep.com", true },
  { "3djuegos.com", true },
  { "3dmedium.de", true },
  { "3dmusiclab.nl", true },
  { "3do3dont.com", true },
  { "3gdh.vip", true },
  { "3haeuserprojekt.org", true },
  { "3haueserprojekt.org", true },
  { "3hl0.net", true },
  { "3james.com", true },
  { "3logic.ru", true },
  { "3n5b.com", true },
  { "3niu168.com", true },
  { "3niu6.com", true },
  { "3niuurl.com", false },
  { "3oneseven.com", true },
  { "3plusdesign.gr", true },
  { "3prn.com", true },
  { "3queens.cz", true },
  { "3queens.io", true },
  { "3r.org.uk", true },
  { "3rsee.com", true },
  { "3s-datasolution.de", true },
  { "3s-datasolutions.de", true },
  { "3s-ddns.de", true },
  { "3s-dns.de", true },
  { "3s-hosting.de", true },
  { "3s-mail.de", true },
  { "3sdatasolution.de", true },
  { "3sdatasolutions.de", true },
  { "3sddns.de", true },
  { "3sdns.de", true },
  { "3shosting.de", true },
  { "3smail.de", true },
  { "3tribes.co.uk", true },
  { "3typen.tv", true },
  { "3v4l.org", true },
  { "3vlnaeet.cz", true },
  { "3xbit.com.br", true },
  { "3xm.at", true },
  { "4-1-where.com", true },
  { "4-it.de", true },
  { "4000milestare.com", false },
  { "403.ch", true },
  { "404notfound.com.br", true },
  { "4096b.com", true },
  { "4096bit.de", false },
  { "40acts.org.uk", true },
  { "41-where.com", true },
  { "41199.com", true },
  { "411film.com", true },
  { "411movie.com", true },
  { "411quest.com", true },
  { "414553.com", true },
  { "41studio.com", true },
  { "41where.com", true },
  { "42.tools", true },
  { "420.nerdpol.ovh", true },
  { "420java.com", true },
  { "42ch.com", true },
  { "42day.info", true },
  { "42l.fr", true },
  { "439050.com", true },
  { "43klive.com", true },
  { "440887.com", true },
  { "440hz.radio", true },
  { "441jj.com", false },
  { "441jz.com", false },
  { "442887.com", true },
  { "442jz.com", false },
  { "44321365.com", true },
  { "443887.com", true },
  { "443jz.com", false },
  { "444887.com", true },
  { "445887.com", true },
  { "44sec.com", true },
  { "451.ooo", true },
  { "4553.com", true },
  { "455327.com", true },
  { "4553s.com", true },
  { "46fa.com", true },
  { "47.rs", true },
  { "4706666.com", true },
  { "4716666.com", true },
  { "4726666.com", true },
  { "4756666.com", true },
  { "4786666.com", true },
  { "491mhz.net", true },
  { "49889.com", true },
  { "49dollaridahoregisteredagent.com", true },
  { "4c-haircare.com", true },
  { "4eyes.ch", true },
  { "4fit.ro", true },
  { "4g-server.eu", false },
  { "4garage.com.br", true },
  { "4gnews.pt", true },
  { "4hmediaproductions.com", true },
  { "4host.ch", true },
  { "4iners.com", true },
  { "4lock.com.br", true },
  { "4mm.org", true },
  { "4monar.com", true },
  { "4obgyne.com", true },
  { "4plebs.moe", true },
  { "4project.co.il", true },
  { "4th-ave-studio.com", true },
  { "4thdc.com", true },
  { "4u.services", true },
  { "4u2ore.net", true },
  { "4vector.com", true },
  { "4vf.de", true },
  { "4x.fi", true },
  { "4x4-27mc.nl", true },
  { "4x4.lk", true },
  { "4x4coatingen.nl", true },
  { "4x4tt.com", true },
  { "4xlabs.co", true },
  { "50.gd", true },
  { "50.pe", true },
  { "500k.nl", true },
  { "500p.xyz", true },
  { "502312.com", true },
  { "504122.com", true },
  { "504322.com", true },
  { "504622.com", true },
  { "504922.com", true },
  { "506422.com", true },
  { "50lakeshore.com", true },
  { "50north.de", true },
  { "513maximus.site", true },
  { "514122.com", true },
  { "514522.com", true },
  { "514922.com", true },
  { "515422.com", true },
  { "516422.com", true },
  { "516btt.com", true },
  { "516btt.net", true },
  { "518.com.tw", true },
  { "51877.net", true },
  { "519422.com", true },
  { "5197.co", false },
  { "5197.com", true },
  { "5197a.co", true },
  { "5197aa.co", true },
  { "5197b.co", true },
  { "5197bb.co", true },
  { "5197c.co", true },
  { "5197cc.co", true },
  { "5197d.co", true },
  { "5197dd.co", true },
  { "5197dh.co", true },
  { "5197dh.com", false },
  { "5197dns.com", false },
  { "5197dz.com", false },
  { "5197e.co", true },
  { "5197ee.co", true },
  { "5197f.co", true },
  { "5197ff.co", true },
  { "5197g.co", true },
  { "5197gg.co", true },
  { "5197h.co", true },
  { "5197hd.co", true },
  { "5197hh.co", true },
  { "5197i.co", true },
  { "5197ii.co", true },
  { "5197j.co", true },
  { "5197jj.co", true },
  { "5197k.co", true },
  { "5197kk.co", true },
  { "5197l.co", true },
  { "5197ll.co", true },
  { "5197m.co", true },
  { "5197mm.co", true },
  { "5197n.co", true },
  { "5197nn.co", true },
  { "5197o.co", true },
  { "5197oo.co", true },
  { "5197p.co", true },
  { "5197pp.co", true },
  { "5197q.co", true },
  { "5197qq.co", true },
  { "5197r.co", true },
  { "5197rr.co", true },
  { "5197s.co", true },
  { "5197ss.co", true },
  { "5197sx.com", false },
  { "5197t.co", true },
  { "5197tt.co", true },
  { "5197u.co", true },
  { "5197uu.co", true },
  { "5197v.co", true },
  { "5197vv.co", true },
  { "5197w.co", true },
  { "5197ww.co", true },
  { "5197x.co", true },
  { "5197xx.co", true },
  { "5197y.co", true },
  { "5197yy.co", true },
  { "5197z.co", true },
  { "5197zz.co", true },
  { "51acg.eu.org", true },
  { "51chiyu.com", true },
  { "51guaq.com", true },
  { "51tiaojiu.com", true },
  { "52051.com", true },
  { "52051a.com", true },
  { "52051b.com", true },
  { "52051c.com", true },
  { "52051d.com", true },
  { "52051e.com", true },
  { "52051f.com", true },
  { "52051g.com", true },
  { "52051h.com", true },
  { "52051i.com", true },
  { "52051j.com", true },
  { "52051k.com", true },
  { "52051l.com", true },
  { "52051m.com", true },
  { "52051n.com", true },
  { "52051o.com", true },
  { "52051p.com", true },
  { "52051q.com", true },
  { "52051r.com", true },
  { "52051s.com", true },
  { "52051t.com", true },
  { "52051u.com", true },
  { "52051v.com", true },
  { "52051w.com", true },
  { "52051x.com", true },
  { "52051y.com", true },
  { "52051z.com", true },
  { "52067.com", true },
  { "52067a.com", true },
  { "52067b.com", true },
  { "52067c.com", true },
  { "52067d.com", true },
  { "52067e.com", true },
  { "52067f.com", true },
  { "52067g.com", true },
  { "52067h.com", true },
  { "52067i.com", true },
  { "52067j.com", true },
  { "52067k.com", true },
  { "52067l.com", true },
  { "52067m.com", true },
  { "52067n.com", true },
  { "52067o.com", true },
  { "52067p.com", true },
  { "52067q.com", true },
  { "52067r.com", true },
  { "52067s.com", true },
  { "52067t.com", true },
  { "52067u.com", true },
  { "52067v.com", true },
  { "52067w.com", true },
  { "52067x.com", true },
  { "52067y.com", true },
  { "52067z.com", true },
  { "524022.com", true },
  { "524622.com", true },
  { "524922.com", true },
  { "525.info", true },
  { "5287.com", true },
  { "52hentai.ml", true },
  { "52kb365.com", true },
  { "52ncp.net", true },
  { "52sykb.com", true },
  { "531422.com", true },
  { "532445.com", true },
  { "534122.com", true },
  { "534622.com", true },
  { "534922.com", true },
  { "5364.com", true },
  { "536422.com", true },
  { "5364b.com", true },
  { "5364c.com", true },
  { "5364d.com", true },
  { "5364jc.com", true },
  { "53ningen.com", true },
  { "54.sb", true },
  { "540922.com", true },
  { "541022.com", true },
  { "541622.com", true },
  { "541722.com", true },
  { "541922.com", true },
  { "545922.com", true },
  { "546802.com", true },
  { "54below.com", true },
  { "54lsj.cc", true },
  { "55321365.com", true },
  { "5533445.com", true },
  { "555btt.com", true },
  { "555w.org", true },
  { "555wfcp.com", true },
  { "556021.com", true },
  { "556185.com", true },
  { "558btt.net", true },
  { "56736565.com", true },
  { "576422.com", true },
  { "578637.com", true },
  { "579422.com", true },
  { "57wilkie.net", true },
  { "581018.com", true },
  { "583422.com", true },
  { "585422.com", true },
  { "586422.com", true },
  { "588l.com", true },
  { "58nav.com", true },
  { "591422.com", true },
  { "592227.com", true },
  { "592422.com", true },
  { "5930593.com", true },
  { "594022.com", true },
  { "594622.com", true },
  { "595422.com", true },
  { "596422.com", true },
  { "5997891.com", true },
  { "599980.com", true },
  { "5apps.com", true },
  { "5c1fd0f31022cbc40af9f785847baaf9.space", true },
  { "5chat.it", true },
  { "5dm.tv", true },
  { "5dwin.com", true },
  { "5dwin.net", true },
  { "5francs.com", true },
  { "5gb.space", true },
  { "5in.win", true },
  { "5kraceforals.com", true },
  { "5percentperweek.com", true },
  { "5thchichesterscouts.org.uk", true },
  { "5y.fi", true },
  { "5yeb.com", true },
  { "602422.com", true },
  { "604122.com", true },
  { "604322.com", true },
  { "604522.com", true },
  { "604622.com", true },
  { "605422.com", true },
  { "606422.com", true },
  { "609422.com", true },
  { "609avenue.com", true },
  { "611135.com", true },
  { "614022.com", true },
  { "614322.com", true },
  { "614922.com", true },
  { "616f88.com", true },
  { "617020.com", true },
  { "61730123.com", true },
  { "618btt.com", true },
  { "618btt.net", true },
  { "620881.com", true },
  { "621422.com", true },
  { "622812.com", true },
  { "62314.cc", true },
  { "624022.com", true },
  { "624122.com", true },
  { "624322.com", true },
  { "624522.com", true },
  { "624922.com", true },
  { "626422.com", true },
  { "630422.com", true },
  { "631422.com", true },
  { "634022.com", true },
  { "634322.com", true },
  { "634622.com", true },
  { "634922.com", true },
  { "635422.com", true },
  { "636422.com", true },
  { "638566.com", true },
  { "639422.com", true },
  { "640622.com", true },
  { "640722.com", true },
  { "640922.com", true },
  { "641022.com", true },
  { "641322.com", true },
  { "641422.com", true },
  { "641522.com", true },
  { "641622.com", true },
  { "641722.com", true },
  { "641822.com", true },
  { "641922.com", true },
  { "642022.com", true },
  { "642322.com", true },
  { "642422.com", true },
  { "642722.com", true },
  { "642822.com", true },
  { "642922.com", true },
  { "643022.com", true },
  { "643122.com", true },
  { "643722.com", true },
  { "643922.com", true },
  { "645022.com", true },
  { "645122.com", true },
  { "645322.com", true },
  { "645722.com", true },
  { "645822.com", true },
  { "645922.com", true },
  { "646022.com", true },
  { "646322.com", true },
  { "646722.com", true },
  { "649022.com", true },
  { "649622.com", true },
  { "649722.com", true },
  { "649822.com", true },
  { "651422.com", true },
  { "652422.com", true },
  { "6541166.com", true },
  { "6542277.com", true },
  { "6543399.com", true },
  { "65477.com", true },
  { "6547700.com", true },
  { "6547711.com", true },
  { "6547722.com", true },
  { "6547733.com", true },
  { "6547744.com", true },
  { "6547755.com", true },
  { "6547766.com", true },
  { "6548855.com", true },
  { "6548877.com", true },
  { "659422.com", true },
  { "65d88.com", true },
  { "6602p.com", true },
  { "662607.xyz", true },
  { "66321365.com", true },
  { "6633445.com", true },
  { "6652566.com", true },
  { "6660111.ru", true },
  { "6664553.com", true },
  { "666618.cc", true },
  { "666668722.com", true },
  { "666am8.com", true },
  { "668825.vip", true },
  { "668am8.com", true },
  { "66b.com", true },
  { "670422.com", true },
  { "671422.com", true },
  { "672422.com", true },
  { "6729a.com", true },
  { "6729aa.co", true },
  { "6729aa.com", true },
  { "6729apk.com", true },
  { "6729app.com", true },
  { "6729b.co", true },
  { "6729b.com", true },
  { "6729bb.co", true },
  { "6729bb.com", true },
  { "6729c.co", true },
  { "6729c.com", true },
  { "6729cc.co", true },
  { "6729cc.com", true },
  { "6729d.co", true },
  { "6729d.com", true },
  { "6729dd.co", true },
  { "6729dd.com", true },
  { "6729e.co", true },
  { "6729e.com", true },
  { "6729ee.co", true },
  { "6729ee.com", true },
  { "6729f.co", true },
  { "6729f.com", true },
  { "6729ff.co", true },
  { "6729ff.com", true },
  { "6729g.co", true },
  { "6729g.com", true },
  { "6729gg.co", true },
  { "6729gg.com", true },
  { "6729h.co", true },
  { "6729h.com", true },
  { "6729hb.com", false },
  { "6729hd.com", false },
  { "6729hh.co", true },
  { "6729i.co", true },
  { "6729i.com", true },
  { "6729ii.co", true },
  { "6729ii.com", true },
  { "6729ipa.com", true },
  { "6729j.co", true },
  { "6729j.com", true },
  { "6729jj.co", true },
  { "6729jj.com", true },
  { "6729k.co", true },
  { "6729k.com", true },
  { "6729kk.co", true },
  { "6729l.co", true },
  { "6729l.com", true },
  { "6729ll.co", true },
  { "6729ll.com", true },
  { "6729m.co", true },
  { "6729m.com", true },
  { "6729nn.com", true },
  { "6729o.co", true },
  { "6729o.com", true },
  { "6729oo.co", true },
  { "6729oo.com", true },
  { "6729p.co", true },
  { "6729pp.co", true },
  { "6729pp.com", true },
  { "6729q.co", true },
  { "6729q.com", true },
  { "6729qq.co", true },
  { "6729qq.com", true },
  { "6729r.co", true },
  { "6729r.com", true },
  { "6729rr.co", true },
  { "6729rr.com", true },
  { "6729s.co", true },
  { "6729s.com", true },
  { "6729ss.co", true },
  { "6729ss.com", true },
  { "6729sx.com", false },
  { "6729t.co", true },
  { "6729t.com", true },
  { "6729tt.co", true },
  { "6729tt.com", true },
  { "6729u.com", true },
  { "6729uu.com", true },
  { "6729v.com", true },
  { "6729vv.co", true },
  { "6729vv.com", true },
  { "6729w.co", true },
  { "6729w.com", true },
  { "6729ww.co", true },
  { "6729ww.com", true },
  { "6729x.co", true },
  { "6729x.com", true },
  { "6729xx.co", true },
  { "6729xx.com", true },
  { "6729xy.com", false },
  { "6729y.co", true },
  { "6729y.com", true },
  { "6729yy.co", true },
  { "6729z.co", true },
  { "6729z.com", true },
  { "6729zz.co", true },
  { "6729zz.com", true },
  { "673422.com", true },
  { "676422.com", true },
  { "676812.com", true },
  { "679422.com", true },
  { "680422.com", true },
  { "68277.me", true },
  { "6848.com", true },
  { "686848.com", true },
  { "68hvip.com", true },
  { "690422.com", true },
  { "691422.com", true },
  { "692422.com", true },
  { "693422.com", true },
  { "694322.com", true },
  { "694622.com", true },
  { "694922.com", true },
  { "6957a.co", true },
  { "6957aa.co", true },
  { "6957b.co", true },
  { "6957bb.co", true },
  { "6957c.co", true },
  { "6957d.co", true },
  { "6957dd.co", true },
  { "6957dz.com", false },
  { "6957ee.co", true },
  { "6957f.co", true },
  { "6957g.co", true },
  { "6957gg.co", true },
  { "6957h.co", true },
  { "6957hd.com", false },
  { "6957hh.co", true },
  { "6957i.co", true },
  { "6957ii.co", true },
  { "6957j.co", true },
  { "6957jj.co", true },
  { "6957k.co", true },
  { "6957kk.co", true },
  { "6957l.co", true },
  { "6957ll.co", true },
  { "6957m.co", true },
  { "6957mm.co", true },
  { "6957n.co", true },
  { "6957nn.co", true },
  { "6957o.co", true },
  { "6957oo.co", true },
  { "6957p.co", true },
  { "6957qq.co", true },
  { "6957r.co", true },
  { "6957s.co", true },
  { "6957ss.co", true },
  { "6957t.co", true },
  { "6957tt.co", true },
  { "6957u.co", true },
  { "6957uu.co", true },
  { "6957v.co", true },
  { "6957vv.co", true },
  { "6957w.co", true },
  { "6957ww.co", true },
  { "6957x.co", true },
  { "6957xx.co", true },
  { "6957xy.com", false },
  { "6957y.co", true },
  { "6957yy.co", true },
  { "6957z.co", true },
  { "6957zz.co", true },
  { "6969.us", true },
  { "698da.com", true },
  { "6997896.com", true },
  { "69butterfly.com", true },
  { "69fps.gg", true },
  { "69games.xxx", true },
  { "69wasted.net", true },
  { "6bwcp.com", true },
  { "6dec.gc.ca", true },
  { "6hzx.com", true },
  { "6ird.com", true },
  { "6lo.zgora.pl", true },
  { "6z0.cn", true },
  { "700.az", true },
  { "701135.com", true },
  { "701605.com", true },
  { "704233.com", true },
  { "704533.com", true },
  { "7045h.com", true },
  { "704633.com", true },
  { "705994.com", true },
  { "7080997.com", true },
  { "709129.com", true },
  { "712433.com", true },
  { "713367.com", true },
  { "713387.com", true },
  { "713433.com", true },
  { "714133.com", true },
  { "714533.com", true },
  { "714633.com", true },
  { "715433.com", true },
  { "716176.com", true },
  { "716227.com", true },
  { "716331.com", true },
  { "718113.com", true },
  { "718227.com", true },
  { "718337.com", true },
  { "718433.com", true },
  { "718552.com", true },
  { "718772.com", true },
  { "719433.com", true },
  { "721167.com", true },
  { "721172.com", true },
  { "722201.com", true },
  { "724233.com", true },
  { "726127.com", true },
  { "726162.com", true },
  { "726176.com", true },
  { "726217.com", true },
  { "726221.com", true },
  { "726433.com", true },
  { "728433.com", true },
  { "729433.com", true },
  { "730433.com", true },
  { "731433.com", true },
  { "731716.com", true },
  { "731783.com", true },
  { "732433.com", true },
  { "735433.com", true },
  { "736371.com", true },
  { "736381.com", true },
  { "736433.com", true },
  { "738433.com", true },
  { "739433.com", true },
  { "740833.com", true },
  { "741833.com", true },
  { "742833.com", true },
  { "743833.com", true },
  { "74th.jp", true },
  { "756337.com", true },
  { "762.ch", true },
  { "762116.com", true },
  { "763137.com", true },
  { "77321365.com", true },
  { "7733445.com", true },
  { "7770b.com", true },
  { "7770t.com", true },
  { "7777k8.com", true },
  { "777coin.com", true },
  { "7787p.com", true },
  { "780aa.com", true },
  { "781371.com", true },
  { "781376.com", true },
  { "781671.com", true },
  { "781683.com", true },
  { "781713.com", true },
  { "783631.com", true },
  { "783lab.com", true },
  { "787637.com", true },
  { "7885765.com", true },
  { "7891553.com", true },
  { "7891997.com", true },
  { "7898666.com", true },
  { "790security.co.za", true },
  { "797715.com", true },
  { "79ch.com", true },
  { "7careconnect.com", true },
  { "7delights.com", true },
  { "7delights.in", true },
  { "7f.is", true },
  { "7geese.com", true },
  { "7graus.pt", true },
  { "7ka.co", true },
  { "7kicks.com", true },
  { "7kovrikov.ru", true },
  { "7milesglobal.com", true },
  { "7pb.ru", true },
  { "7plus.com.au", true },
  { "7proxies.com", true },
  { "7sons.de", true },
  { "7thcircledesigns.com", true },
  { "7x24servis.com", true },
  { "803001.com", true },
  { "804322.com", true },
  { "80780780.com", true },
  { "8080883.com", true },
  { "8080889.com", true },
  { "8086.cf", true },
  { "80883.cc", true },
  { "80887.cc", true },
  { "809088.cc", true },
  { "809422.com", true },
  { "80993.net", true },
  { "80bin.com", true },
  { "814022.com", true },
  { "815jz.com", true },
  { "816jz.com", true },
  { "81818app.com", true },
  { "8189196.com", true },
  { "818da.com", true },
  { "8203d88.com", true },
  { "8214p.com", true },
  { "8216p.com", true },
  { "8228d88.com", true },
  { "8230d88.com", true },
  { "833792.com", true },
  { "8349822.com", true },
  { "8363p.com", true },
  { "8367p.com", true },
  { "8368p.com", true },
  { "8369p.com", true },
  { "8371p.com", true },
  { "8373p.com", true },
  { "8376p.com", true },
  { "8378p.com", true },
  { "8379p.com", true },
  { "8387p.com", true },
  { "8391p.com", true },
  { "8396p.com", true },
  { "842844.com", true },
  { "848jz.com", true },
  { "8522.am", true },
  { "8522club.com", true },
  { "8522ph.com", true },
  { "8522tw.com", true },
  { "8522usa.com", true },
  { "86btt.com", true },
  { "8722.am", true },
  { "8722am.com", true },
  { "8722cn.com", true },
  { "8722hk.com", true },
  { "8722ph.com", true },
  { "8722tw.com", true },
  { "8722usa.com", true },
  { "877791.com", true },
  { "88-line.com", true },
  { "88-line.net", true },
  { "8809d88.com", true },
  { "881-line.com", true },
  { "881-line.net", true },
  { "8826ks.com", true },
  { "88321365.com", true },
  { "8833445.com", true },
  { "88522am.com", true },
  { "885287.com", true },
  { "8858ks.com", true },
  { "8868ks.com", true },
  { "886k8.net", true },
  { "887.ag", true },
  { "8876007.com", true },
  { "8876008.com", true },
  { "8876009.com", true },
  { "8876205.com", true },
  { "8876278.com", true },
  { "8876289.com", true },
  { "8876290.com", true },
  { "8876353.com", true },
  { "8876389.com", true },
  { "8876764.com", true },
  { "8876808.com", true },
  { "8876832.com", true },
  { "8876835.com", true },
  { "8876859.com", true },
  { "8876878.com", true },
  { "8876955.com", true },
  { "8876979.com", true },
  { "8876987.com", true },
  { "8876989.com", true },
  { "88851777.com", true },
  { "888666pj.com", true },
  { "88881.pw", true },
  { "888888722.com", true },
  { "88889822.com", true },
  { "888funcity.com", true },
  { "888funcity.net", true },
  { "88btt.net", true },
  { "88yule11.com", true },
  { "88yule112.com", true },
  { "88yule113.com", true },
  { "88yule12.com", true },
  { "88yule13.com", true },
  { "88yule15.com", true },
  { "88yule16.com", true },
  { "88yule6.com", true },
  { "88yule7.com", true },
  { "88yule9.com", true },
  { "890238.com", true },
  { "89btt.com", true },
  { "8balls.nl", true },
  { "8da188.com", true },
  { "8da222.com", true },
  { "8da999.com", true },
  { "8dabet.com", true },
  { "8maerz.at", true },
  { "8pc.ru", true },
  { "8t8.eu", true },
  { "8tech.com.hk", true },
  { "8thportsmouth.org.uk", true },
  { "8tuffbeers.com", true },
  { "8xx888.com", true },
  { "8xxxxxxx.com", true },
  { "8yun.cf", true },
  { "9-11commission.gov", true },
  { "901543.com", true },
  { "903422.com", true },
  { "905422.com", true },
  { "9090819.com", true },
  { "90r.jp", true },
  { "910kj.com", true },
  { "911.gov", true },
  { "911216.xyz", true },
  { "9118.com", true },
  { "9118.la", true },
  { "911commission.gov", true },
  { "912422.com", true },
  { "913422.com", true },
  { "914122.com", true },
  { "918.com", true },
  { "9180nn.com", true },
  { "9180tt.com", true },
  { "9180vv.com", true },
  { "9180xx.com", true },
  { "9180yy.com", true },
  { "9180zz.com", true },
  { "91816.net", true },
  { "9186119.com", true },
  { "91891849.com", true },
  { "91891854.com", true },
  { "91891856.com", true },
  { "91891878.com", true },
  { "918aak.com", true },
  { "918ajj.com", true },
  { "918akk.com", true },
  { "918amj.co", true },
  { "918att.com", true },
  { "918bbm.co", true },
  { "918bby.com", true },
  { "918bcf.co", true },
  { "918bcw.co", true },
  { "918btt.com", true },
  { "918btt.net", true },
  { "918btty.com", true },
  { "918bttz.com", true },
  { "918ca.com", true },
  { "918caa.com", true },
  { "918cch.com", true },
  { "918ch.com", true },
  { "918cr.com", true },
  { "918cx.com", true },
  { "918dc04.com", true },
  { "918dc16.com", true },
  { "918dc20.com", true },
  { "918dp.com", true },
  { "918ee.com", true },
  { "918ej.com", true },
  { "918ev.com", true },
  { "918fq.com", true },
  { "918fr.com", true },
  { "918fv.com", true },
  { "918gd.com", true },
  { "918hr.com", true },
  { "918hu.com", true },
  { "918iz.com", true },
  { "918kx.com", true },
  { "918mc.com", true },
  { "918md10.com", true },
  { "918md16.com", true },
  { "918md25.com", true },
  { "918mf.com", true },
  { "918nc.com", true },
  { "918nd.com", true },
  { "918nu.com", true },
  { "918ny.com", true },
  { "918qa.com", true },
  { "918rw.com", true },
  { "918sn.com", true },
  { "918ta.com", true },
  { "918tj.com", true },
  { "918tr.com", true },
  { "918tw.com", true },
  { "918uh.com", true },
  { "918um.com", true },
  { "918vb.com", true },
  { "918ve.com", true },
  { "918vi.com", true },
  { "918vz.com", true },
  { "918wa.com", true },
  { "918we.com", true },
  { "918wo.com", true },
  { "918wq.com", true },
  { "918ww.com", true },
  { "918xn.com", true },
  { "918zm.com", true },
  { "918zv.com", true },
  { "918zw.com", true },
  { "919422.com", true },
  { "91d27.com", true },
  { "91d52.com", true },
  { "91d58.com", true },
  { "91d89.com", true },
  { "91travel.info", true },
  { "924122.com", true },
  { "924322.com", true },
  { "924622.com", true },
  { "926422.com", true },
  { "929349.com", true },
  { "9297.co", false },
  { "9297.com", true },
  { "9297a.co", true },
  { "9297aa.co", true },
  { "9297b.co", true },
  { "9297bb.co", true },
  { "9297c.co", true },
  { "9297cc.co", true },
  { "9297d.co", true },
  { "9297dd.co", true },
  { "9297dns.com", false },
  { "9297e.co", true },
  { "9297ee.co", true },
  { "9297f.co", true },
  { "9297ff.co", true },
  { "9297g.co", true },
  { "9297gg.co", true },
  { "9297h.co", true },
  { "9297hb.com", false },
  { "9297hd.com", false },
  { "9297hh.co", true },
  { "9297i.co", true },
  { "9297ii.co", true },
  { "9297j.co", true },
  { "9297jj.co", true },
  { "9297k.co", true },
  { "9297kk.co", true },
  { "9297l.co", true },
  { "9297ll.co", true },
  { "9297m.co", true },
  { "9297mm.co", true },
  { "9297n.co", true },
  { "9297nn.co", true },
  { "9297o.co", true },
  { "9297oo.co", true },
  { "9297p.co", true },
  { "9297pp.co", true },
  { "9297q.co", true },
  { "9297qq.co", true },
  { "9297r.co", true },
  { "9297rr.co", true },
  { "9297s.co", true },
  { "9297ss.co", true },
  { "9297t.co", true },
  { "9297tt.co", true },
  { "9297u.co", true },
  { "9297uu.co", true },
  { "9297v.co", true },
  { "9297vv.co", true },
  { "9297w.co", true },
  { "9297ww.co", true },
  { "9297x.co", true },
  { "9297xx.co", true },
  { "9297y.co", true },
  { "9297yy.co", true },
  { "9297z.co", true },
  { "9297zz.co", true },
  { "92url.com", true },
  { "931422.com", true },
  { "932422.com", true },
  { "933325.com", true },
  { "934122.com", true },
  { "939394.org", true },
  { "9397.com", true },
  { "9397a.com", true },
  { "9397aa.com", true },
  { "9397b.com", true },
  { "9397bb.com", true },
  { "9397c.com", true },
  { "9397cc.com", true },
  { "9397dd.com", true },
  { "9397dh.com", true },
  { "9397e.com", true },
  { "9397ee.com", true },
  { "9397f.com", true },
  { "9397ff.com", true },
  { "9397g.com", true },
  { "9397gg.com", true },
  { "9397h.com", true },
  { "9397hb.com", true },
  { "9397hd.com", true },
  { "9397hh.com", true },
  { "9397i.com", true },
  { "9397ii.com", true },
  { "9397j.com", true },
  { "9397jj.com", true },
  { "9397kk.com", true },
  { "9397l.com", true },
  { "9397ll.com", true },
  { "9397m.com", true },
  { "9397mm.com", true },
  { "9397n.com", true },
  { "9397nn.com", true },
  { "9397o.com", true },
  { "9397oo.com", true },
  { "9397p.com", true },
  { "9397pp.com", true },
  { "9397q.com", true },
  { "9397qq.com", true },
  { "9397r.com", true },
  { "9397rr.com", true },
  { "9397s.com", true },
  { "9397ss.com", true },
  { "9397t.com", true },
  { "9397tt.com", true },
  { "9397u.com", true },
  { "9397uu.com", true },
  { "9397v.com", true },
  { "9397vv.com", true },
  { "9397w.com", true },
  { "9397ww.com", true },
  { "9397x.com", true },
  { "9397xx.com", true },
  { "9397y.com", true },
  { "9397yy.com", true },
  { "9397z.com", true },
  { "9397zz.com", true },
  { "943022.com", true },
  { "9449-27a1-22a1-e0d9-4237-dd99-e75e-ac85-2f47-9d34.de", true },
  { "946022.com", true },
  { "946422.com", true },
  { "949022.com", true },
  { "949122.com", true },
  { "949622.com", true },
  { "949722.com", true },
  { "961621.com", true },
  { "962312.com", true },
  { "963cq.com", true },
  { "967606.com", true },
  { "9679693.com", true },
  { "9681909.com", true },
  { "9721.com", true },
  { "9721a.com", true },
  { "9721aa.com", true },
  { "9721b.com", true },
  { "9721bb.com", true },
  { "9721c.com", true },
  { "9721cc.com", true },
  { "9721d.com", true },
  { "9721dd.com", true },
  { "9721dh.com", true },
  { "9721e.com", true },
  { "9721ee.com", true },
  { "9721f.com", true },
  { "9721ff.com", true },
  { "9721g.com", true },
  { "9721gg.com", true },
  { "9721h.com", true },
  { "9721hd.com", true },
  { "9721hh.com", true },
  { "9721i.com", true },
  { "9721j.com", true },
  { "9721jj.com", true },
  { "9721k.com", true },
  { "9721kk.com", true },
  { "9721l.com", true },
  { "9721ll.com", true },
  { "9721m.com", true },
  { "9721mm.com", true },
  { "9721n.com", true },
  { "9721nn.com", true },
  { "9721o.com", true },
  { "9721oo.com", true },
  { "9721p.com", true },
  { "9721pp.com", true },
  { "9721q.com", true },
  { "9721qq.com", true },
  { "9721r.com", true },
  { "9721rr.com", true },
  { "9721s.com", true },
  { "9721ss.com", true },
  { "9721t.com", true },
  { "9721tt.com", true },
  { "9721u.com", true },
  { "9721uu.com", true },
  { "9721v.com", true },
  { "9721vv.com", true },
  { "9721w.com", true },
  { "9721ww.com", true },
  { "9721x.com", true },
  { "9721xx.com", true },
  { "9721y.com", true },
  { "9721yy.com", true },
  { "9721z.com", true },
  { "9721zz.com", true },
  { "972422.com", true },
  { "9728.co", false },
  { "9728a.co", true },
  { "9728aa.co", true },
  { "9728b.co", true },
  { "9728bb.co", false },
  { "9728c.co", true },
  { "9728cc.co", true },
  { "9728d.co", true },
  { "9728dd.co", true },
  { "9728dh.com", false },
  { "9728dns.com", false },
  { "9728dz.com", false },
  { "9728e.co", true },
  { "9728ee.co", true },
  { "9728f.co", true },
  { "9728ff.co", true },
  { "9728g.co", true },
  { "9728gg.co", true },
  { "9728h.co", true },
  { "9728hb.com", false },
  { "9728hd.com", false },
  { "9728hh.co", true },
  { "9728i.co", true },
  { "9728ii.co", true },
  { "9728j.co", true },
  { "9728jj.co", true },
  { "9728k.co", true },
  { "9728kk.co", true },
  { "9728l.co", true },
  { "9728ll.co", true },
  { "9728m.co", true },
  { "9728mm.co", true },
  { "9728n.co", true },
  { "9728nn.co", true },
  { "9728o.co", true },
  { "9728oo.co", true },
  { "9728p.co", true },
  { "9728pp.co", true },
  { "9728q.co", true },
  { "9728qq.co", true },
  { "9728r.co", true },
  { "9728rr.co", true },
  { "9728s.co", true },
  { "9728ss.co", true },
  { "9728sx.com", false },
  { "9728t.co", true },
  { "9728tt.co", true },
  { "9728u.co", true },
  { "9728uu.co", true },
  { "9728v.co", true },
  { "9728vv.co", true },
  { "9728w.co", true },
  { "9728ww.co", true },
  { "9728x.co", true },
  { "9728xx.co", true },
  { "9728y.co", true },
  { "9728yy.co", true },
  { "9728z.co", true },
  { "9728zz.co", true },
  { "977hghg.com", true },
  { "9788876.com", true },
  { "9822.am", true },
  { "9822am.com", true },
  { "9822cn.com", true },
  { "9822hk.com", true },
  { "9822ph.com", true },
  { "9822tw.com", true },
  { "9822usa.com", true },
  { "984.ch", true },
  { "9867666.com", true },
  { "9918883.com", true },
  { "99321365.com", true },
  { "9933445.com", true },
  { "99599.fi", true },
  { "998081.com", true },
  { "9988ty.com", true },
  { "998sa.com", true },
  { "9994553.com", true },
  { "9998722.com", true },
  { "99998522.com", true },
  { "99999822.com", true },
  { "999998722.com", true },
  { "999salon.co", true },
  { "999salon.com", true },
  { "99lib.net", true },
  { "99rst.org", true },
  { "99spokes.com", true },
  { "9box.jp", true },
  { "9farm.com", true },
  { "9fvip.net", true },
  { "9iwan.net", true },
  { "9k886.com", true },
  { "9pkfz.com", true },
  { "9uelle.jp", true },
  { "9vx.org", true },
  { "9yw.me", true },
  { "a-1basements.com", true },
  { "a-1indianawaterproofing.com", true },
  { "a-allard.be", true },
  { "a-care.net", true },
  { "a-classinflatables.co.uk", true },
  { "a-invest.de", true },
  { "a-little-linux-box.at", true },
  { "a-msystems.com", true },
  { "a-oben.org", true },
  { "a-players.team", true },
  { "a-wife.net", true },
  { "a-ztransmission.com", true },
  { "a0print.nl", true },
  { "a122.cc", true },
  { "a1autotransport.com", true },
  { "a1bouncycastlehire.com", true },
  { "a1jumpandbounce.co.uk", true },
  { "a1moldsolutions.com", true },
  { "a1scuba.com", true },
  { "a22z.xyz", true },
  { "a291.cc", true },
  { "a2a.me", true },
  { "a2a.net", true },
  { "a2nutrition.com.au", true },
  { "a2os.club", true },
  { "a30.tokyo", true },
  { "a4sound.com", true },
  { "a5197.co", true },
  { "a632079.me", true },
  { "a6729.com", true },
  { "a6957.co", true },
  { "a7la-chat.com", true },
  { "a7m2.me", true },
  { "a88fc.com", true },
  { "a9297.co", true },
  { "a9397.com", true },
  { "a9721.com", true },
  { "a9728.co", true },
  { "aa-tour.ru", true },
  { "aa1718.net", true },
  { "aa5197.co", true },
  { "aa6729.co", true },
  { "aa6729.com", true },
  { "aa6957.co", true },
  { "aa9297.co", true },
  { "aa9397.com", true },
  { "aa9721.com", true },
  { "aa9728.co", true },
  { "aaa-racing.com", true },
  { "aaa-racing.net", true },
  { "aaa-racing.uk", true },
  { "aaapl.com", true },
  { "aabanet.com.br", true },
  { "aaben-bank.dk", true },
  { "aabenbank.dk", true },
  { "aacs-design.com", true },
  { "aadw.de", true },
  { "aalalbayt.com", true },
  { "aalalbayt.net", true },
  { "aalstmotors-usedcars.be", true },
  { "aaltocapital.com", true },
  { "aaminntourtravel.com", false },
  { "aamwa.com", true },
  { "aandkevents.co.uk", true },
  { "aanmpc.com", true },
  { "aaomidi.com", true },
  { "aapar.nl", true },
  { "aapas.org.ar", true },
  { "aarailfan.com", true },
  { "aarklendoia.com", true },
  { "aarkue.eu", true },
  { "aaron-russell.co.uk", true },
  { "aaronfurtado.com", true },
  { "aaronhorler.com", true },
  { "aaronhorler.com.au", true },
  { "aaronkimmig.de", true },
  { "aaronroyle.com", true },
  { "aatf.us", true },
  { "aati.be", true },
  { "aati.info", true },
  { "aattrans.com", true },
  { "aavienna.com", true },
  { "ab-photography.nl", true },
  { "ab288.com", true },
  { "ab2888.cn", true },
  { "ab28s.com", true },
  { "abaapplianceservice.com", true },
  { "abaaustin.com", true },
  { "ababyco.com.hr", true },
  { "abacusbouncycastle.co.uk", true },
  { "abaev.uk", true },
  { "abandonedmines.gov", true },
  { "abateroad66.it", true },
  { "abbadabbabouncycastles.co.uk", true },
  { "abbottscastles.co.uk", true },
  { "abbruch-star.de", true },
  { "abc-rz.de", true },
  { "abc.li", true },
  { "abc8081.net", true },
  { "abcbouncycastlessurrey.co.uk", true },
  { "abcbouncyfactory.co.uk", true },
  { "abcdef.be", true },
  { "abcheck.se", true },
  { "abckam.com", true },
  { "abcpartyhire.com", true },
  { "abcstudio.com.au", true },
  { "abdel.me", true },
  { "abdl.link", true },
  { "abdulrahman.eu", true },
  { "abdulwahaab.ca", true },
  { "abe-elektro.de", true },
  { "abe-medical.jp", true },
  { "abeilles-idapi.fr", true },
  { "abelsflooringandtile.com", true },
  { "abenteuer-ahnenforschung.de", true },
  { "aberdeencastles.co.uk", true },
  { "aberdeenjudo.co.uk", true },
  { "abeus.com", true },
  { "abg.ninja", true },
  { "abhisharma.me", true },
  { "abi-2017.tk", true },
  { "abiapp.net", true },
  { "abibruce.co.uk", true },
  { "abidinginhesed.com", true },
  { "abigisp.com", true },
  { "abilitycaresoftware.com", true },
  { "abilitymatters.co.uk", true },
  { "abilityone.gov", true },
  { "abilma.com", true },
  { "abilymp06.net", true },
  { "abimelec.com", true },
  { "abinyah.com", true },
  { "abitidalavoro.roma.it", true },
  { "abitidasposa.roma.it", true },
  { "abitur97ag.de", true },
  { "abiturma.de", true },
  { "abjay.com", true },
  { "ableprop.net", true },
  { "abmackenzie.com", true },
  { "abmc.gov", true },
  { "abmledger.ca", true },
  { "abmtax.ca", true },
  { "abn-consultants.ie", true },
  { "abnehmen.com", true },
  { "abobuch.de", true },
  { "aboces.org", true },
  { "aboderenovation.co.uk", true },
  { "abogadosescobarysanchez.es", true },
  { "abolicionistas.com", true },
  { "abolition.net", true },
  { "abolitionism.ca", true },
  { "abolitionism.co.uk", true },
  { "abolitionism.com", true },
  { "abolitionism.in", true },
  { "abolitionism.net", true },
  { "abolitionism.us", true },
  { "abolitionist-project.com", true },
  { "abolitionist-society.com", true },
  { "abolitionist.ca", true },
  { "abolitionist.co.uk", true },
  { "abolitionist.com", true },
  { "abolitionist.in", true },
  { "abolitionist.net", true },
  { "abolitionist.us", true },
  { "abolitionistparty.com", true },
  { "abolitionistproject.com", true },
  { "abolitionistsociety.com", true },
  { "abolitionniste.com", true },
  { "abolizionista.com", true },
  { "abonilla.com", true },
  { "aborla.net", true },
  { "abos.eu", false },
  { "abouncycastleman.co.uk", true },
  { "abouthrm.nl", true },
  { "aboutict.nl", true },
  { "aboutlegal.nl", true },
  { "aboutmedia.nl", true },
  { "aboutmyproperty.ca", true },
  { "aboutpublishers.nl", true },
  { "aboutspice.com", true },
  { "aboutyou.at", true },
  { "aboutyou.be", true },
  { "aboutyou.ch", true },
  { "aboutyou.de", true },
  { "aboutyou.nl", true },
  { "aboveaverageplumbing.com", true },
  { "abox-kb.com", true },
  { "abpis.hr", true },
  { "abracadabra.co.jp", false },
  { "abrakidabra.com.br", true },
  { "abrilect.com", true },
  { "abristolgeek.co.uk", true },
  { "abseits.org", true },
  { "absolem.cc", false },
  { "absolutcruceros.com", true },
  { "absoluteautobody.com", true },
  { "absolutedouble.co.uk", true },
  { "absolutehosting.co.za", true },
  { "absolutelyinflatables.co.uk", true },
  { "absoluterush.net", true },
  { "absolutewebdesigns.com", true },
  { "absolutviajes.com", true },
  { "abstractbarista.net", true },
  { "abstraction21.com", true },
  { "abstudio.de", true },
  { "absturztau.be", true },
  { "absturztaube.ch", true },
  { "absynthe-inquisition.fr", true },
  { "abthorpe.org", true },
  { "abublog.com", true },
  { "abulanov.com", true },
  { "abundanteconomy.com", true },
  { "abundent.com", true },
  { "abuse.ch", true },
  { "abuse.fi", true },
  { "abuse.io", true },
  { "abvent.net", true },
  { "abvlbasketviganello.ch", true },
  { "abyssproject.net", true },
  { "ac-admin.pl", true },
  { "ac-cosmetics.nl", true },
  { "ac-elektro.com.ua", true },
  { "ac-epmservices.com", true },
  { "ac.milan.it", true },
  { "ac0g.dyndns.org", true },
  { "aca-creative.co.uk", true },
  { "academiadebomberosonline.com", true },
  { "academica.nl", true },
  { "academicexperts.us", true },
  { "academichealthscience.net", true },
  { "academie-de-police.ch", true },
  { "academkin.com", true },
  { "academus.io", true },
  { "academytv.com.au", true },
  { "acaeum.com", true },
  { "acampar.com.br", true },
  { "acandroid.top", true },
  { "acaptureservices.com", true },
  { "acara-yoga.de", true },
  { "acareer.in", true },
  { "acarreosvillavicencio.com", true },
  { "acat.io", true },
  { "acbrussels-used.be", true },
  { "accelaway.com", true },
  { "acceleratenetworks.com", true },
  { "accelerateyourworld.org", true },
  { "accelerator.net", true },
  { "accelsnow.com", true },
  { "accentthailand.com", true },
  { "accesloges.com", true },
  { "accessacab.co.uk", true },
  { "accessauto-occasions.be", true },
  { "accessgaragedoors.com", true },
  { "accessibletravelclub.com", true },
  { "accesskeycloning.com", true },
  { "accessmy.net", true },
  { "accessoirescheveuxchic.com", true },
  { "accessoripersmartphone.it", true },
  { "acchicocchi.com", true },
  { "acclivity.pro", true },
  { "accme.co", true },
  { "accoladescreens.com.au", true },
  { "accord-application.com", true },
  { "accordiondoor.com", true },
  { "account.bbc.com", true },
  { "account4u.nl", true },
  { "accounts.firefox.com", true },
  { "accounts.google.com", true },
  { "accpl.co", true },
  { "accpodcast.com", true },
  { "accredit.ly", true },
  { "accreditamento.net", true },
  { "accrosoft.com", true },
  { "accudraftpaintbooths.com", true },
  { "accurateautobodywa.com", true },
  { "accutint.com", true },
  { "ace.one", true },
  { "acealters.com", true },
  { "aceanswering.com", true },
  { "acecolleges.edu.au", true },
  { "acefreightco.com", true },
  { "aceinflatables.com", true },
  { "aceinstituteonline.com", true },
  { "acelpb.com", true },
  { "acem.org.au", true },
  { "acemobileforce.com", true },
  { "acemypaper.com", true },
  { "acen.eu", true },
  { "acendealuz.com.br", true },
  { "acerentalandsales.com", true },
  { "acerislaw.com", true },
  { "acessoeducacao.com", true },
  { "acfun.eu.org", true },
  { "acg.social", true },
  { "acgmoon.com", true },
  { "acgmoon.org", true },
  { "acgtalktw.com", true },
  { "achalay.org", true },
  { "achat-volets-roulants.fr", true },
  { "acheconcursos.com.br", true },
  { "achenar.net", true },
  { "acheter-ethylotest.fr", true },
  { "achromatisch.de", true },
  { "achterblog.de", true },
  { "achterstieg.dedyn.io", true },
  { "achtzehn.de", true },
  { "achtzehn.eu", true },
  { "achtzehnterachter.de", true },
  { "achtzig20.de", true },
  { "achwo.de", true },
  { "acid.ninja", true },
  { "aciety.com", true },
  { "aciksite.com", true },
  { "acinq.co", true },
  { "ackermann.ch", true },
  { "ackis.duckdns.org", false },
  { "acklandstainless.com.au", true },
  { "acl.gov", true },
  { "aclu.org", false },
  { "acluva.org", false },
  { "acme.beer", true },
  { "acmexyz123.info", true },
  { "acnpacific.com", true },
  { "acodess.com", true },
  { "aconnor.xyz", true },
  { "acordes.online", true },
  { "acorncastles.co.uk", true },
  { "acorncredentialing.com", true },
  { "acoshift.com", true },
  { "acoshift.me", true },
  { "acourse.io", true },
  { "acousti-tech.com", true },
  { "acousticalsolutions.com", true },
  { "acoustics.network", true },
  { "acoustics.tech", true },
  { "acousticsoundrecords.com", true },
  { "acoustique-tardy.com", true },
  { "acp-integrative.fr", true },
  { "acpcoils.com", true },
  { "acperu.ch", true },
  { "acquisition.gov", true },
  { "acquistareviagragenericoitalia.net", false },
  { "acrepairgeorgetown.com", true },
  { "acrepairhutto.com", true },
  { "acrepairroundrocktx.com", true },
  { "acrevalue.com", true },
  { "acriticismlab.org", true },
  { "acrolife.cz", true },
  { "acrosstheblvd.com", true },
  { "acroyoga-nuernberg.de", true },
  { "acrylbilder-acrylmalerei.de", true },
  { "acrylicwifi.com", true },
  { "acsbbs.org", true },
  { "acsc.gov.au", true },
  { "acscbasket.com", true },
  { "acsemb.org", true },
  { "acsports.ca", true },
  { "act-safety.nl", true },
  { "actc.org.uk", true },
  { "actgruppe.de", true },
  { "actheater.com", true },
  { "acticu.com", true },
  { "actiefgeld.nl", true },
  { "actioncleaningnd.com", true },
  { "actioncoachignite.co.za", true },
  { "actionfinancialservices.net", true },
  { "actionlabs.net", true },
  { "actionmadagascar.ch", true },
  { "actionsack.com", true },
  { "actionselling.com", true },
  { "activatemyiphone.com", true },
  { "activateudid.com", true },
  { "active-tluszcz.pl", true },
  { "active.hu", false },
  { "activecare-monitor.com", false },
  { "activeexcavator.com", true },
  { "activehire.co.uk", true },
  { "activeleisure.ie", true },
  { "activiteithardenberg.nl", true },
  { "activityeventhire.co.uk", true },
  { "actom.cc", true },
  { "actonwoodworks.com", true },
  { "actors-cafe.net", true },
  { "actorshop.co.uk", true },
  { "actserv.co.ke", true },
  { "actualadmins.com", true },
  { "actualidadblog.com", true },
  { "actualidadecommerce.com", true },
  { "actualidadgadget.com", true },
  { "actualidadiphone.com", true },
  { "actualidadkd.com", true },
  { "actualidadliteratura.com", true },
  { "actualidadmotor.com", true },
  { "actualidadviajes.com", true },
  { "actualsolutions.am", true },
  { "acudire.es", true },
  { "acuica.co.uk", false },
  { "acul.me", true },
  { "aculocity.com", true },
  { "acupuntura.coach", true },
  { "acupuntura.doctor", true },
  { "acupuntura.institute", true },
  { "acupunturamadrid.xyz", true },
  { "acupunturavalencia.xyz", true },
  { "acus.gov", true },
  { "acutewealthadvisors.com", true },
  { "acwi.gov", true },
  { "acy.com", true },
  { "acyfxasia.com", true },
  { "acyume.com", true },
  { "ad-notam.asia", true },
  { "ad-notam.ch", true },
  { "ad-notam.co.uk", true },
  { "ad-notam.com", true },
  { "ad-notam.de", true },
  { "ad-notam.fr", true },
  { "ad-notam.it", true },
  { "ad-notam.pt", true },
  { "ad-notam.us", true },
  { "ad13.in", true },
  { "ada.eco", true },
  { "ada.gov", true },
  { "adaera.com", true },
  { "adalis.org", true },
  { "adam-ant.co.uk", true },
  { "adam-kostecki.de", true },
  { "adam.lgbt", true },
  { "adamas-magicus.ru", true },
  { "adambalogh.net", true },
  { "adambryant.ca", false },
  { "adamdixon.co.uk", true },
  { "adamfontenot.com", true },
  { "adamgibbins.com", true },
  { "adamh.us", true },
  { "adamkostecki.de", true },
  { "adamoutler.com", true },
  { "adamradocz.com", true },
  { "adams.dk", true },
  { "adamsasphaltpaving.com", true },
  { "adamstas.com", true },
  { "adamyuan.xyz", true },
  { "adappt.co.uk", true },
  { "adapptlabs.com", true },
  { "adapt-elektronik.com", true },
  { "adapt.de", true },
  { "adaptablesecurity.org", true },
  { "adaptergonomics.com", true },
  { "adapti.de", true },
  { "adaptivemechanics.edu.au", true },
  { "adarshcloud.in", true },
  { "adarshthapa.in", true },
  { "adativos.com.br", true },
  { "adawolfa.cz", true },
  { "adayinthelifeof.nl", true },
  { "adblockextreme.com", true },
  { "adblockextreme.net", true },
  { "adblockextreme.org", true },
  { "adc64.com", true },
  { "adcnvs.com", true },
  { "addcrazy.com", true },
  { "addeekt.com", true },
  { "adderall.space", true },
  { "addicional.com", true },
  { "addictic.fr", true },
  { "addictionresource.com", true },
  { "addictively.com", true },
  { "addisoncrump.info", true },
  { "addistribution.it", true },
  { "addnine.com", true },
  { "addon.watch", true },
  { "addones.net", true },
  { "addtoany.com", true },
  { "adduono.com", true },
  { "addvalue-renovations.co.uk", true },
  { "addydari.us", true },
  { "adelebeals.com", true },
  { "adelightfulglow.com", true },
  { "adeline.mobi", true },
  { "adentalsolution.com", true },
  { "adept-elearning.com", true },
  { "adept.org.pl", true },
  { "adesa.co.uk", true },
  { "adevel.eu", true },
  { "adex.network", true },
  { "adf-safetytools.com", true },
  { "adftrasporti.it", true },
  { "adhd-inattentive.com", true },
  { "adhesivelaundry.co.uk", true },
  { "adiehard.party", true },
  { "adimaja.com", true },
  { "adinariversloveschool.com", true },
  { "adingenierie.fr", true },
  { "adiprospero.it", true },
  { "aditibhatia.com", true },
  { "adjagu.org", true },
  { "adlerneves.com", true },
  { "adlerneves.com.br", true },
  { "adlerosn.com", true },
  { "adlerosn.com.br", true },
  { "adlershop.ch", true },
  { "adlignum.se", true },
  { "adme.co.il", true },
  { "admin-serv.net", true },
  { "admin.casa", true },
  { "admin.fedoraproject.org", true },
  { "admin.google.com", true },
  { "admin.stg.fedoraproject.org", true },
  { "admind.at", true },
  { "adminforge.de", true },
  { "administracionessaez.es", true },
  { "administratie-smits.nl", true },
  { "administratiekantoorblom.nl", true },
  { "administrator.de", true },
  { "administratorserwera.pl", true },
  { "adminless.ovh", true },
  { "adminlinux.pl", true },
  { "admino.cz", true },
  { "admins.tech", true },
  { "adminwerk.net", true },
  { "admirable.one", true },
  { "admirable.pro", true },
  { "admody.com", true },
  { "admongo.gov", true },
  { "adnanoktar.com", true },
  { "adnexa.it", true },
  { "adnolesh.com", true },
  { "adnseguros.es", true },
  { "adohanyzasjovoje.hu", true },
  { "adomani-italia.com", true },
  { "adoniscabaret.co.uk", true },
  { "adonizer.science", true },
  { "adonnante.com", true },
  { "adoptionlink.co.uk", true },
  { "adorecricket.com", true },
  { "adorewe.com", true },
  { "adorno-gymnasium.de", true },
  { "adoucisseur.shop", true },
  { "adquisitio.co.uk", true },
  { "adquisitio.es", true },
  { "adquisitio.fr", true },
  { "adquisitio.it", true },
  { "adr.gov", true },
  { "adra.com", true },
  { "adrafinil.wiki", true },
  { "adrenalin.od.ua", true },
  { "adrenalin.travel", true },
  { "adresults.com", true },
  { "adresults.nl", true },
  { "adrian.web.id", true },
  { "adrianbechtold.de", true },
  { "adriancitu.com", true },
  { "adriancostin.ro", true },
  { "adrianjensen.com", true },
  { "adrianmejias.com", true },
  { "adrianobarbosa.xyz", true },
  { "adrienjacquierbret.com", true },
  { "adrienkohlbecker.com", true },
  { "adriennesmiles.com", true },
  { "adrup.com", true },
  { "adsamcik.com", true },
  { "adsbouncycastles.co.uk", true },
  { "adsbtc.org", true },
  { "adsl2meg.fr", true },
  { "adswoo.com", true },
  { "adtelligent.com", true },
  { "adtgroup.com", true },
  { "adurra.com", true },
  { "aduvi.de", true },
  { "adv.cr", true },
  { "advaithbot.com", true },
  { "advance.hr", true },
  { "advanced-fleet-services.com", true },
  { "advanced-scribes.com", true },
  { "advanced.info", true },
  { "advanceddieselspokane.com", true },
  { "advanceddisposables.co.uk", false },
  { "advancedelectricalservicesqld.com.au", true },
  { "advancedendoscopycenter.net", true },
  { "advancedprotectionkey.com", true },
  { "advancedprotectionsecuritykey.com", true },
  { "advancedsurgicalconsultantsllc.com", true },
  { "advancedweb.hu", true },
  { "advancedwriters.com", true },
  { "advanceworx.com", true },
  { "advancis.net", true },
  { "advancyte.com", true },
  { "advantagehomeexteriors.com", true },
  { "advantagemechanicalinc.com", true },
  { "advara.com", true },
  { "advenacs.com", true },
  { "advenacs.com.au", true },
  { "advento.bg", true },
  { "adventure-inn.com", true },
  { "adventurecreators.com", true },
  { "adventuredrives.com", true },
  { "adventureforest.co.nz", true },
  { "adventureforest.de", false },
  { "adventureforest.nz", true },
  { "adventuregamers.com", true },
  { "adventurenow.nl", true },
  { "adventureswithlillie.ca", true },
  { "adventurousway.com", true },
  { "advertis.biz", true },
  { "adviserplus.com", true },
  { "advocate-europe.eu", true },
  { "advocator.ca", true },
  { "advocoeurdehaan.nl", true },
  { "advogatech.com.br", true },
  { "advokat-romanov.com", true },
  { "advtran.com", true },
  { "adware.pl", false },
  { "adwokatkosterka.pl", true },
  { "adwokatzdunek.pl", true },
  { "adws.io", true },
  { "adxperience.com", true },
  { "adzuna.at", true },
  { "adzuna.ca", true },
  { "adzuna.co.nz", true },
  { "adzuna.co.za", true },
  { "adzuna.com", true },
  { "adzuna.com.au", true },
  { "adzuna.com.br", true },
  { "adzuna.de", true },
  { "adzuna.fr", true },
  { "adzuna.in", true },
  { "adzuna.it", true },
  { "adzuna.nl", true },
  { "adzuna.pl", true },
  { "adzuna.ru", true },
  { "adzuna.sg", true },
  { "ae-construction.co.uk", true },
  { "ae-dir.com", true },
  { "ae-dir.org", true },
  { "ae86sb.com", true },
  { "ae86x.com", true },
  { "aebian.org", true },
  { "aecexpert.fr", true },
  { "aedollon.com", true },
  { "aefcleaning.com", true },
  { "aegee-utrecht.nl", true },
  { "aegis.moe", true },
  { "aegisalarm.co.uk", true },
  { "aegisalarm.com", true },
  { "aegisalarms.co.uk", true },
  { "aegisalarms.com", true },
  { "aegrel.ee", true },
  { "aehe.us", true },
  { "aei.co.uk", true },
  { "aelurus.com", true },
  { "aenterprise.info", true },
  { "aeon.co", true },
  { "aeonct.org", true },
  { "aeradesign.com", true },
  { "aerandir.fr", true },
  { "aereco.com", true },
  { "aergia.eu", true },
  { "aerisnetwork.com", true },
  { "aerlux.md", true },
  { "aero-pioneer.com", true },
  { "aero.parts", true },
  { "aerobasegroup.com", true },
  { "aerobotz.com", true },
  { "aeronautix.com", true },
  { "aeronote.net", true },
  { "aeropole.de", true },
  { "aeropole.eu", true },
  { "aerosimexperience.com", true },
  { "aerospace-schools.com", true },
  { "aerotechcoatings.com", true },
  { "aertel.ie", true },
  { "aessencia.com.br", true },
  { "aestheticsplus.xyz", true },
  { "aesthetx.com", true },
  { "aestore.by", true },
  { "aeternus.tech", true },
  { "aetherc0r3.eu", true },
  { "aetoscg.com", true },
  { "aetoscg.com.au", true },
  { "aextron.com", true },
  { "aextron.de", true },
  { "aextron.org", true },
  { "afavre.io", true },
  { "afb24.de", true },
  { "afcmrs.org", false },
  { "afcompany.it", true },
  { "aff.moe", true },
  { "affairefacile.net", true },
  { "affarsnatverk.nu", true },
  { "affichagepub3.com", true },
  { "affiliatefeatures.com", true },
  { "affiliatetest.azurewebsites.net", true },
  { "affilie.de", true },
  { "affinitysync.com", true },
  { "affissioni.roma.it", true },
  { "affittacamere.roma.it", true },
  { "affittialmare.it", true },
  { "affittisalento.it", true },
  { "affordableazdivorce.com", true },
  { "affordableenvironmental.net", true },
  { "affordablehealthquotesforyou.com", true },
  { "affordablemudjacking.com", true },
  { "affordablepapers.com", true },
  { "affordableracingparts.com.au", true },
  { "affpass.com", true },
  { "affping.com", true },
  { "affvps.net", true },
  { "afghan.dating", true },
  { "afgn.com.ua", true },
  { "afi-business-consulting.com", true },
  { "aficionados.com.br", true },
  { "afinadoronline.com.br", true },
  { "afinaudio.com", true },
  { "aflam4you.tv", true },
  { "aflfreebets.com", true },
  { "aflowershop.ca", true },
  { "afmtevents.com", true },
  { "afp548.com", true },
  { "afri.cc", true },
  { "africa.dating", true },
  { "african-bay.de", true },
  { "africanexponent.com", true },
  { "africanimpact.com", true },
  { "africankitchen.gallery", true },
  { "africantourer.com", true },
  { "afrikarl.de", true },
  { "afrodigital.uk", true },
  { "afs-asso.org", true },
  { "afscheidsportret.nl", true },
  { "aftab-alam.de", true },
  { "after.digital", true },
  { "afterdwi.info", true },
  { "afterhate.fr", true },
  { "afva.net", true },
  { "afwd.international", true },
  { "ag8-game.com", true },
  { "ag88.com", true },
  { "agalliasis.ch", true },
  { "agamsecurity.ch", true },
  { "agatajanik.de", true },
  { "agate.pw", true },
  { "agechecker.net", true },
  { "ageg.ca", true },
  { "agemfis.com", true },
  { "agenciadeempregosdourados.com.br", true },
  { "agenciafiscal.pe", true },
  { "agenciamseo.com.br", true },
  { "agencyinmotion.com", true },
  { "agenda-loto.net", false },
  { "agenda21senden.de", true },
  { "agendatelefonica.com.br", true },
  { "agent-grow.com", true },
  { "agentprocessing.com", true },
  { "agentur-pottkinder.de", true },
  { "agenziaimmobiliarezeta.it", true },
  { "agenziapubblicitaria.milano.it", true },
  { "agenziapubblicitaria.roma.it", true },
  { "ageragrosirdistro.com", true },
  { "agfmedia.com", true },
  { "agia.ad", true },
  { "agiapelagia.com", true },
  { "agibank.com.br", true },
  { "agic-geneve.ch", true },
  { "agilebits.com", true },
  { "agilecraft.com", true },
  { "agileecommerce.com.br", true },
  { "agileui.com", true },
  { "agiley.se", true },
  { "agilicus.ca", true },
  { "agilicus.com", true },
  { "agilizing.us", true },
  { "agilob.net", true },
  { "aging.gov", true },
  { "agingstats.gov", true },
  { "aginion.net", true },
  { "agliamici.it", true },
  { "agnesk.blog", true },
  { "agoodmind.com", true },
  { "agoravox.fr", true },
  { "agoravox.it", true },
  { "agoravox.tv", true },
  { "agotnes.com", true },
  { "agouraelectrical.com", true },
  { "agouraelectrician.com", true },
  { "agourahillselectric.com", true },
  { "agourahillselectrical.com", true },
  { "agourahillselectrician.com", true },
  { "agourahillsexteriorlighting.com", true },
  { "agourahillslandscapelighting.com", true },
  { "agourahillslighting.com", true },
  { "agourahillsoutdoorlighting.com", true },
  { "agouralandscapelighting.com", true },
  { "agouralighting.com", true },
  { "agouraoutdoorlighting.com", true },
  { "agpideas.com", true },
  { "agr.asia", true },
  { "agrajag.nl", true },
  { "agrarking.com", true },
  { "agrarking.de", true },
  { "agrarshop4u.de", true },
  { "agrekov.ru", true },
  { "agreor.com", true },
  { "agrichamber.com.ua", true },
  { "agriculture-schools.com", true },
  { "agridir.site", true },
  { "agrios.de", true },
  { "agro-forestry.net", true },
  { "agroline.by", true },
  { "agroxxi.ru", false },
  { "agroyard.com.ua", true },
  { "agsb.ch", true },
  { "agscinemas.com", true },
  { "agscinemasapp.com", true },
  { "aguarani.com.br", true },
  { "aguijara.com", true },
  { "agung-furniture.com", true },
  { "agwa.name", true },
  { "agy.cl", true },
  { "ahawkesrealtors.com", true },
  { "ahd.com", false },
  { "ahegao.ca", true },
  { "ahero4all.org", true },
  { "ahkubiak.ovh", false },
  { "ahlaejaba.com", true },
  { "ahlz.sk", true },
  { "ahmad.works", true },
  { "ahmd.io", true },
  { "ahmedabadflowermall.com", true },
  { "ahmedcharles.com", true },
  { "ahmedknowmadic.com", true },
  { "ahmerjamilkhan.org", true },
  { "ahmetozer.org", true },
  { "ahosi.com", true },
  { "ahoy.travel", true },
  { "ahoyconference.com", true },
  { "ahtuxpk.ru", true },
  { "ahughes03.com", true },
  { "ahxxm.com", false },
  { "ai-english.jp", true },
  { "ai-soft.co.jp", true },
  { "ai.gov", true },
  { "aia.de", true },
  { "aianipid.ee", true },
  { "aiasesoriainmobiliaria.com", true },
  { "aibenzi.com", true },
  { "aibiying.com", true },
  { "aicial.co.uk", true },
  { "aicv.club", true },
  { "aid-web.ch", true },
  { "aidanapple.com", true },
  { "aidanmitchell.co.uk", true },
  { "aidanmitchell.uk", true },
  { "aidanmontare.net", true },
  { "aidanpr.com", true },
  { "aidanpr.net", true },
  { "aiden.link", true },
  { "aidhan.net", true },
  { "aidi-ahmi.com", true },
  { "aids.gov", true },
  { "aie.de", true },
  { "aifriccampbell.com", true },
  { "aigcev.org", true },
  { "aigenpul.se", true },
  { "aignermunich.com", true },
  { "aignermunich.de", true },
  { "aignermunich.jp", true },
  { "aiho.stream", true },
  { "aiicy.org", true },
  { "aiida.se", true },
  { "aiinsurance.io", true },
  { "aiinsurance.xyz", true },
  { "aijsk.com", true },
  { "aikenpromotions.com", true },
  { "aiki.de", true },
  { "aiki.do", true },
  { "aikido-club-limburg.de", true },
  { "aikido-kiel.de", true },
  { "aikido-linz.at", true },
  { "aikido-wels.at", true },
  { "ailitonia.com", true },
  { "ailitonia.xyz", true },
  { "aimax.com", true },
  { "aimd.tech", true },
  { "aimeeandalec.com", true },
  { "aimgroup.co.tz", true },
  { "aimi-salon.com", true },
  { "aimonline.nl", true },
  { "aimotive.com", true },
  { "aimstoreglobal.com", true },
  { "ainfographie.com", true },
  { "aintevenmad.ch", true },
  { "ainvest.de", true },
  { "aiois.com", true },
  { "aipbarcelona.com", true },
  { "aipi.de", true },
  { "air-craftglass.com", true },
  { "air-shots.ch", true },
  { "air-techniques.fr", true },
  { "air-we-go.co.uk", true },
  { "airbnb.ae", true },
  { "airbnb.at", true },
  { "airbnb.be", true },
  { "airbnb.biz", true },
  { "airbnb.ca", true },
  { "airbnb.cat", true },
  { "airbnb.ch", true },
  { "airbnb.cl", true },
  { "airbnb.cn", true },
  { "airbnb.co.cr", true },
  { "airbnb.co.id", true },
  { "airbnb.co.il", true },
  { "airbnb.co.in", true },
  { "airbnb.co.kr", true },
  { "airbnb.co.nz", true },
  { "airbnb.co.uk", true },
  { "airbnb.co.ve", true },
  { "airbnb.com", true },
  { "airbnb.com.ar", true },
  { "airbnb.com.au", true },
  { "airbnb.com.bo", true },
  { "airbnb.com.br", true },
  { "airbnb.com.bz", true },
  { "airbnb.com.cn", true },
  { "airbnb.com.co", true },
  { "airbnb.com.ec", true },
  { "airbnb.com.gt", true },
  { "airbnb.com.hk", true },
  { "airbnb.com.hn", true },
  { "airbnb.com.hr", true },
  { "airbnb.com.kh", true },
  { "airbnb.com.mt", true },
  { "airbnb.com.my", true },
  { "airbnb.com.ni", true },
  { "airbnb.com.pa", true },
  { "airbnb.com.pe", true },
  { "airbnb.com.ph", true },
  { "airbnb.com.py", true },
  { "airbnb.com.sg", true },
  { "airbnb.com.sv", true },
  { "airbnb.com.tr", true },
  { "airbnb.com.tw", true },
  { "airbnb.com.ua", true },
  { "airbnb.com.vn", true },
  { "airbnb.cz", true },
  { "airbnb.de", true },
  { "airbnb.dk", true },
  { "airbnb.es", true },
  { "airbnb.fi", true },
  { "airbnb.fr", true },
  { "airbnb.gr", true },
  { "airbnb.gy", true },
  { "airbnb.hu", true },
  { "airbnb.ie", true },
  { "airbnb.is", true },
  { "airbnb.it", true },
  { "airbnb.jp", true },
  { "airbnb.la", true },
  { "airbnb.lu", true },
  { "airbnb.mx", true },
  { "airbnb.nl", true },
  { "airbnb.no", true },
  { "airbnb.pl", true },
  { "airbnb.pt", true },
  { "airbnb.ru", true },
  { "airbnb.se", true },
  { "airbnb.tools", true },
  { "airbnbchina.cn", true },
  { "airbnbopen.com", true },
  { "airborne-inflatables.co.uk", true },
  { "airbossofamerica.com", true },
  { "airclass.com", true },
  { "aircomms.com", true },
  { "airductclean.com", false },
  { "airductcleaning-fresno.com", true },
  { "airductcleaninggrandprairie.com", true },
  { "airductcleaningirving.com", true },
  { "airdur.eu", true },
  { "aireaseleaks.org", true },
  { "airetvie.com", true },
  { "airfax.io", true },
  { "airhart.me", true },
  { "airhelp.com", true },
  { "airhorn.de", true },
  { "airi-tabei.com", true },
  { "airicy.com", true },
  { "airikai.com", true },
  { "airlectrical-airconditioning.com.au", true },
  { "airlibre-parachutisme.com", true },
  { "airmail.cc", true },
  { "airmaxinflatables.com", true },
  { "airnow.gov", true },
  { "airpbx.com", true },
  { "airplay-inflatable-hire.co.uk", true },
  { "airplayradio.nl", true },
  { "airport-charlotte.com", true },
  { "airportal.cn", true },
  { "airrestoration.ch", true },
  { "airship.com", true },
  { "airslate.com", true },
  { "airsnore.com", true },
  { "airsoft.ch", true },
  { "airswap.io", true },
  { "airtec-france.fr", true },
  { "airtimerewards.co.uk", true },
  { "airtoolaccessoryo.com", true },
  { "airvpn.org", true },
  { "airvuz.com", true },
  { "airware.com", true },
  { "airwaystorage.net", true },
  { "airweb.top", true },
  { "airwegobouncycastles.co.uk", true },
  { "airwolfthemes.com", true },
  { "airwrenchei.com", true },
  { "ais.fashion", true },
  { "aisance-co.com", true },
  { "aisi316l.net", true },
  { "aisin.ae", true },
  { "aistockcharts.com", true },
  { "aistrope.com", true },
  { "ait.com.ar", true },
  { "aiticon.com", true },
  { "aitosoftware.com", true },
  { "aiutodomestico.ch", true },
  { "aivan.ai", true },
  { "aiwdirect.com", true },
  { "aiwosq.cn", true },
  { "aixvox.com", false },
  { "aizxxs.com", true },
  { "aizxxs.net", true },
  { "ajarope.com", true },
  { "ajaxed.net", true },
  { "ajbouncycastles.co.uk", true },
  { "ajdiaz.me", true },
  { "ajeventhire.co.uk", true },
  { "ajgroup-me.com", true },
  { "ajhstamps.co.uk", true },
  { "ajiaojr.info", true },
  { "ajiaojr.io", true },
  { "ajiaojr.me", true },
  { "ajiaojr.net", true },
  { "ajiboye.com", true },
  { "ajnasz.hu", true },
  { "ajsb85.com", true },
  { "ajwebsolutions.com", true },
  { "ak-varazdin.hr", true },
  { "ak-webit.de", true },
  { "aka.ms", true },
  { "akachanikuji.com", true },
  { "akademeia.moe", true },
  { "akademie-frankfurt.de", true },
  { "akalashnikov.ru", true },
  { "akamon.ac.jp", true },
  { "akaoma.com", true },
  { "akasha.world", true },
  { "akdusekbudil.cz", true },
  { "akelius.de", false },
  { "akfoundationindia.com", true },
  { "akhealthconnection.com", true },
  { "akhomesforyou.com", true },
  { "akihito.com", true },
  { "akijo.de", true },
  { "akiym.com", true },
  { "akj.io", true },
  { "akkbouncycastles.co.uk", true },
  { "akkeylab.com", true },
  { "akoofs.com", true },
  { "akostecki.de", true },
  { "akovana.com", true },
  { "akoya.fi", true },
  { "akplates.org", true },
  { "akpwebdesign.com", true },
  { "akr.io", true },
  { "akr.services", true },
  { "akrep.com", true },
  { "akronet.cz", false },
  { "akropol.cz", false },
  { "akropolis-ravensburg.de", true },
  { "aksehir.bel.tr", true },
  { "akselinurmio.fi", true },
  { "akshay.in.eu.org", true },
  { "akshi.in", true },
  { "aktin.cz", true },
  { "aktin.sk", true },
  { "aktion-vielfalt.ch", true },
  { "aktiv-naturheilmittel.at", false },
  { "aktiv-naturheilmittel.ch", true },
  { "aktiv-naturheilmittel.de", true },
  { "aktivace.eu", true },
  { "aktivierungscenter.de", true },
  { "aktuelle-uhrzeit.at", true },
  { "akuislam.com", true },
  { "akukas.com", true },
  { "akupunktur-akupunktoer.dk", true },
  { "akuseorangtraveler.com", true },
  { "akuston.eu", true },
  { "akutun.cl", true },
  { "akvorrat.at", true },
  { "al3366.tech", true },
  { "al3abmizo.com", true },
  { "al3xpro.com", true },
  { "alab.space", true },
  { "alabamadebtrelief.org", true },
  { "alaboard.com", true },
  { "alabordage.fr", true },
  { "alacriti.com", true },
  { "aladdin.ie", true },
  { "aladdinschools.appspot.com", true },
  { "alainbaechlerphotography.ch", true },
  { "alainfrancois.eu", true },
  { "alainfrancois.nl", true },
  { "alainmargot.ch", true },
  { "alainodea.com", true },
  { "alainwolf.ch", true },
  { "alainwolf.net", true },
  { "alair.cn", false },
  { "alamgir.works", true },
  { "alamowellnessalliance.com", true },
  { "alanberger.me.uk", true },
  { "alanhua.ng", true },
  { "alaninkenya.org", true },
  { "alaricfavier.eu", false },
  { "alarmat.pl", true },
  { "alarmcomplete.co.uk", true },
  { "alarna.de", true },
  { "alasdelalma.com.co", true },
  { "alaskafishinglodges.net", true },
  { "alaskajewelry.com", true },
  { "alastairs-place.net", true },
  { "albanboye.info", true },
  { "albanesi.it", true },
  { "albaniareiser.no", true },
  { "albareport.com", true },
  { "albbounce.co.uk", true },
  { "albersdruck.de", true },
  { "albertathome.org", true },
  { "albertcuyp-markt.amsterdam", true },
  { "albertinum-goettingen.de", true },
  { "albilaga.id", true },
  { "albion2.org", true },
  { "alboweb.nl", true },
  { "albrocar.com", true },
  { "alca31.com", true },
  { "alcatelonetouch.us", true },
  { "alchimic.ch", true },
  { "alcnutrition.com", true },
  { "alco-united.com", true },
  { "alcoholapi.com", true },
  { "alcolecapital.com", true },
  { "alcouponest.com", true },
  { "aldiabcs.com", true },
  { "aldien.com.br", true },
  { "aldomedia.com", true },
  { "aldorr.net", false },
  { "aldous-huxley.com", true },
  { "alecel.de", true },
  { "alecpap.com", true },
  { "alecpapierniak.com", true },
  { "alecrust.com", true },
  { "alek.in", true },
  { "aleksejjocic.tk", true },
  { "aleksib.fi", true },
  { "alela.fr", true },
  { "aleph.land", true },
  { "alerbon.net", true },
  { "alertboxx.com", true },
  { "alertonline.nl", true },
  { "alerts.sg", true },
  { "alertwire.com", true },
  { "alesia-formation.fr", true },
  { "alessandroonline.com.br", true },
  { "alessandrotravel.com", true },
  { "aletm.it", true },
  { "alex-ross.co.uk", true },
  { "alex4386.us", true },
  { "alex97000.de", true },
  { "alexander-beck.eu", true },
  { "alexanderb.info", true },
  { "alexandercanton.com", true },
  { "alexanderneng.de", true },
  { "alexanderschimpf.de", true },
  { "alexandra-schulze.de", true },
  { "alexandrastorm.com", true },
  { "alexandre-blond.fr", true },
  { "alexbaker.org", true },
  { "alexberts.ch", true },
  { "alexbogovich.com", true },
  { "alexcoman.com", true },
  { "alexdaniel.org", true },
  { "alexey-shamara.ru", true },
  { "alexeykopytko.com", true },
  { "alexfabian.myftp.org", true },
  { "alexgaynor.net", true },
  { "alexgebhard.com", true },
  { "alexglover.co.uk", true },
  { "alexhalderman.com", true },
  { "alexhd.de", true },
  { "alexisabarca.com", true },
  { "alexiskoustoulidis.com", true },
  { "alexjett.com", true },
  { "alexlambertz.de", true },
  { "alexlouden.com", true },
  { "alexmerkel.com", true },
  { "alexmerkel.me", true },
  { "alexmerkel.xyz", true },
  { "alexmroberts.net", true },
  { "alexn.org", true },
  { "alexpavel.com", true },
  { "alexpnixon.com", true },
  { "alexpotter.net", true },
  { "alexs.de", true },
  { "alexschroeder.ch", true },
  { "alexsergeyev.com", true },
  { "alexsexton.com", true },
  { "alextaffe.com", true },
  { "alexthayne.co.uk", true },
  { "alextjam.es", true },
  { "alextsang.net", true },
  { "alexvdveen.nl", true },
  { "alexvetter.de", true },
  { "alexwardweb.com", true },
  { "alexyang.me", true },
  { "alfa-tech.su", true },
  { "alfaproweb.fr", true },
  { "alfred-figge.de", true },
  { "alfredapp.com", true },
  { "alftrain.com", true },
  { "algawell.com", true },
  { "algeriepart.com", true },
  { "alghanimcatering.com", true },
  { "algoaware.eu", true },
  { "algoentremanos.com", true },
  { "algolia.com", true },
  { "algorithmic.ml", true },
  { "algoritmus-uspechu.cz", true },
  { "alhost.ml", true },
  { "aliacraft.net", true },
  { "aliantsoft.pl", true },
  { "aliaswp.com", true },
  { "alibangash.com", true },
  { "alibiloungelv.com", true },
  { "alice-noutore.com", true },
  { "alice.tw", true },
  { "alicemaywebdesign.com.au", true },
  { "alicestudio.it", true },
  { "alicetone.net", true },
  { "alieke.design", true },
  { "alien6.com", true },
  { "alienation.biz", true },
  { "alienflight.com", true },
  { "alienslab.net", true },
  { "alienstat.com", true },
  { "alienvision.com.br", true },
  { "alighierirescaldina.it", true },
  { "alignrs.com", true },
  { "alijammusic.com", false },
  { "alikulov.me", true },
  { "alinasmusicstudio.com", true },
  { "alinbu.net", true },
  { "aliorange.com", true },
  { "alisonisrealestate.com", true },
  { "alisonlitchfield.com", true },
  { "alistairstowing.com", true },
  { "aliv.biz", true },
  { "alix-board.de", true },
  { "alize-theatre.ch", true },
  { "aljaspod.com", true },
  { "aljaspod.hu", true },
  { "aljoschairmer.de", true },
  { "aljweb.com", true },
  { "alkacoin.net", true },
  { "all-connect.net", false },
  { "all-fashion-schools.com", true },
  { "all-markup-news.com", true },
  { "all4hardware4u.de", true },
  { "all878.com", true },
  { "allaboutfunuk.com", true },
  { "allaboutswing.co.uk", true },
  { "allaboutswing.com", true },
  { "allaboutthekink.org", true },
  { "allactioneventhire.co.uk", true },
  { "allamericanmuslim.com", true },
  { "allamericanpaintingplus.com", true },
  { "allamericanprotection.net", true },
  { "allamericatrans.com", true },
  { "allangirvan.net", true },
  { "allarmi.roma.it", true },
  { "allbenjoy.de", true },
  { "allbetgame.cn", true },
  { "allbetgaming.com", true },
  { "allbigdicks.com", true },
  { "allbounceandplay.co.uk", true },
  { "allbouncesurrey.co.uk", true },
  { "allbrandbrand.com", true },
  { "allbursaries.co.za", true },
  { "allbusiness.com", true },
  { "allcapa.org", true },
  { "allcarecorrectionalpharmacy.com", true },
  { "allcarepharmacy.com", true },
  { "allcinema.jp", true },
  { "allcleaningservice.org", true },
  { "allcleanservices.ca", true },
  { "allcloud.com", true },
  { "allcovered.nl", true },
  { "alldewall.de", true },
  { "alldolledupstore.com", true },
  { "alle-zonvakanties.nl", true },
  { "alle.bg", true },
  { "allemoz.com", true },
  { "allemoz.fr", true },
  { "allenscaravans.co.uk", true },
  { "allensun.org", true },
  { "allerstorfer.at", true },
  { "allesisonline.nl", true },
  { "alleskomtgoed.org", true },
  { "allesovertech.nl", true },
  { "allesrocknroll.de", true },
  { "allforyou.at", true },
  { "allfundsconnect.com", true },
  { "allgaragefloors.com", true },
  { "allgreenturf.com.au", true },
  { "allhard.org", true },
  { "alliance-psychiatry.com", true },
  { "alliances-globalsolutions.com", true },
  { "alliedfrozenstorage.com", true },
  { "allinagency.com", true },
  { "allincoin.shop", true },
  { "allis.studio", true },
  { "allius.de", true },
  { "alljamin.com", true },
  { "allladyboys.com", true },
  { "allmemy.com", true },
  { "allmend-ru.de", true },
  { "allmousepads.com", true },
  { "allns.fr", true },
  { "allo-credit.ch", true },
  { "allofthestops.com", true },
  { "allontanamentovolatili.it", true },
  { "allontanamentovolatili.milano.it", true },
  { "alloutofgum.com", true },
  { "alloutsec.com", true },
  { "alloverthehill.com", true },
  { "allphaseclean.com", true },
  { "allplayer.tk", true },
  { "allpointsblog.com", true },
  { "allpointsheating.com", true },
  { "allproptonline.com", true },
  { "allpussynow.com", true },
  { "allrad-buck.de", true },
  { "allroundpvp.net", true },
  { "allroundtechnology.com", true },
  { "allroundtechnology.nl", true },
  { "allsaints.church", true },
  { "allsearch.io", true },
  { "allseasonswaterproofing.com", true },
  { "allstakesupply.com.au", true },
  { "allstarautokiaparts.com", true },
  { "allstarcashforcars.com", true },
  { "allstarquilts.com", true },
  { "allsun.online", true },
  { "allsync.com", true },
  { "allsync.nl", true },
  { "allteach.co.uk", true },
  { "allterrainfence.com", true },
  { "allthecryptonews.com", true },
  { "alltherooms.com", true },
  { "alltherooms.es", true },
  { "allthethings.co.nz", true },
  { "allthings.me", true },
  { "allthingssquared.com", true },
  { "allthingswild.co.uk", true },
  { "alltubedownload.net", true },
  { "allurebikerental.com", true },
  { "allurescarves.com", true },
  { "alluvion.studio", true },
  { "allweatherlandscaping.net", true },
  { "almaatlantica.com", true },
  { "almamet.com", true },
  { "almatinki.com", true },
  { "almavios.com", false },
  { "almayadeen.education", true },
  { "almenrausch-pirkhof.de", true },
  { "almorafestival.com", true },
  { "almut-zielonka.de", true },
  { "aloesoluciones.com.ar", true },
  { "alohapartyevents.co.uk", true },
  { "alonas.ml", true },
  { "alonas.ovh", true },
  { "alonetone.com", true },
  { "alov.blog", true },
  { "alp.od.ua", true },
  { "alpca.org", true },
  { "alpencam.com", true },
  { "alpencams.com", true },
  { "alpencams.net", true },
  { "alpengreis.ch", true },
  { "alpertron.com.ar", true },
  { "alpes-deis-tools.com", true },
  { "alpha-force.net", false },
  { "alpha.ch", true },
  { "alpha88uat.com", true },
  { "alphaantileak.net", true },
  { "alphabetsigns.com", true },
  { "alphabouncycastles.co.uk", true },
  { "alphachat.net", true },
  { "alphadefense.co.za", true },
  { "alphaetomega3d.fr", true },
  { "alphafiduciaryservices.ch", true },
  { "alphahunks.com", true },
  { "alphainflatablehire.com", true },
  { "alphaman.ooo", true },
  { "alphanodes.com", true },
  { "alphapengu.in", true },
  { "alphapoker.ru", true },
  { "alpharotary.com", true },
  { "alphasall.com", true },
  { "alphassl.de", true },
  { "alphavote-avex.com", true },
  { "alphavote.com", true },
  { "alphera.nl", true },
  { "alphie.me", true },
  { "alphipneux.fr", true },
  { "alpinechaletrental.com", true },
  { "alpinehighlandrealty.com", true },
  { "alpinepubliclibrary.org", true },
  { "alpinestarmassage.com", true },
  { "alplogopedia.it", true },
  { "alpstarentaisetaxi.com", true },
  { "alpstarentaisetaxi.fr", true },
  { "alquds.edu", true },
  { "alquiaga.com", true },
  { "alrait.com", true },
  { "alre-outillage.fr", true },
  { "alroniks.com", true },
  { "als-japan.com", true },
  { "alstertouch.com", true },
  { "alstertouch.de", true },
  { "alstroemeria.org", true },
  { "alt-three.com", true },
  { "alt.org", true },
  { "altair.fi", true },
  { "altapina.com", false },
  { "altaplana.be", true },
  { "altaynews.kz", true },
  { "altbinaries.com", true },
  { "altco.group", true },
  { "altea-pep18.com", true },
  { "altedirect.com", true },
  { "alteiria.fr", true },
  { "alter-news.fr", true },
  { "alterbaum.net", true },
  { "alteria.xyz", true },
  { "alternador.com.br", true },
  { "alternative.bike", true },
  { "alternative.hosting", true },
  { "alternativebit.fr", true },
  { "alternativehosting.ca", true },
  { "alternativehosting.com", true },
  { "alternativeinternet.ca", true },
  { "alternativet.party", true },
  { "alternativetomeds.com", true },
  { "alterspalter.de", true },
  { "altes-sportamt.de", true },
  { "altesses.eu", true },
  { "altestore.com", true },
  { "altijdleroy.nl", true },
  { "altijdleroy.online", true },
  { "altisdev.com", true },
  { "altkremsmuensterer.at", true },
  { "altmaestrat.es", true },
  { "altmann-systems.de", true },
  { "altoa.cz", true },
  { "altonblom.com", true },
  { "altopartners.com", true },
  { "altopia.com", true },
  { "altphotos.com", true },
  { "altrui.st", true },
  { "altstipendiaten.de", true },
  { "alttrackr.com", true },
  { "altunbas.info", true },
  { "altweaver.com", true },
  { "aluminium-giesserei.de", true },
  { "alumni-kusa.jp", true },
  { "alupferd.de", true },
  { "aluroof.eu", true },
  { "alvcs.com", true },
  { "alvicom.hu", true },
  { "alvin.cool", true },
  { "alvosec.com", true },
  { "alwaysdry.com.au", true },
  { "alwayslookingyourbest.com", true },
  { "alwaysmine.fi", true },
  { "alxlegal.com", true },
  { "alxu.ca", true },
  { "alyoung.com", true },
  { "alza.at", true },
  { "alza.co.uk", true },
  { "alza.cz", true },
  { "alza.de", true },
  { "alza.hu", true },
  { "alza.sk", true },
  { "alzashop.com", true },
  { "alzonaprinting.com", true },
  { "am-39.com", true },
  { "am-dd.com", true },
  { "am-executive-consulting.com", true },
  { "am-liaotian.com", true },
  { "am156.com", true },
  { "am22i6xaf1m2a5m9k.xyz", true },
  { "am2s.fr", true },
  { "am5039.com", true },
  { "am5199.com", true },
  { "am5566m.com", true },
  { "am8213.com", true },
  { "am9588.com", true },
  { "am9d104.com", true },
  { "ama.ne.jp", true },
  { "amaderelectronics.com", true },
  { "amadoraslindas.com", true },
  { "amadvice.com", true },
  { "amagdic.com", true },
  { "amagical.net", false },
  { "amaiz.com", true },
  { "amal2019.com", true },
  { "amalfilapiazzetta.it", true },
  { "amalfipositanoboatrental.com", true },
  { "amalfirock.it", true },
  { "amalfitabula.it", true },
  { "amaliagamis.com", true },
  { "amanatrustbooks.org.uk", true },
  { "amandadamsphotography.com", true },
  { "amandasage.ca", true },
  { "amandaworldstudies.com", true },
  { "amanet.ro", true },
  { "amani-kinderdorf.de", true },
  { "amaranthinewanderlust.com", true },
  { "amardham.org", true },
  { "amaresq.com", true },
  { "amateri.com", true },
  { "amateurpornhours.com", true },
  { "amateurradionotes.com", true },
  { "amateurvoicetalent.com", true },
  { "amati.solutions", true },
  { "amato.tk", true },
  { "amatsuka.com", true },
  { "amauf.de", true },
  { "amautorepairwa.com", true },
  { "amazetimberfurniture.com.au", true },
  { "amazili-communication.com", true },
  { "amazing-castles.co.uk", true },
  { "amazingraymond.com", true },
  { "amazingraymond.com.au", true },
  { "amb.tf", true },
  { "amberalert.gov", true },
  { "amberglowleisure.co.uk", true },
  { "amberlightleisure.com", true },
  { "ambholding-usedcars.be", true },
  { "ambiente.one", true },
  { "ambiq.nl", true },
  { "ambulanza.roma.it", true },
  { "ambulari.cz", true },
  { "amcangroup.com", true },
  { "amcchemical.com", true },
  { "amcfirst.com", true },
  { "amchainitiative.org", true },
  { "amcs.website", true },
  { "amdouglas.com", true },
  { "amechancez.work", true },
  { "amedtest.org", true },
  { "ameego.com", true },
  { "ameego.it", true },
  { "ameego.net", true },
  { "ameego.nl", true },
  { "ameego.org", true },
  { "amees.me", false },
  { "ameliemarieintokyo.com", true },
  { "amello.de", true },
  { "amend-friseur-schwabing.de", true },
  { "amendine.fr", true },
  { "amendoeiraresort.com", true },
  { "america.gov", true },
  { "americafamilylawcenter.org", true },
  { "american-school-search.com", true },
  { "american.dating", true },
  { "americandetour.com", true },
  { "americanfoundationbr.com", true },
  { "americanindiannursing.com", true },
  { "americanmediainstitute.com", true },
  { "americanwater.lk", true },
  { "americasbasementcontractor.com", true },
  { "americasdirector.com", true },
  { "americkykongres.cz", true },
  { "ameriikanpoijat.org", true },
  { "amerika-forum.de", true },
  { "amerimarkdirect.com", true },
  { "amerimex.cc", true },
  { "amesgen.de", true },
  { "amesvacuumrepair.com", true },
  { "amethystdevelopment.co.uk", true },
  { "amf.to", true },
  { "amg-exterieur.fr", true },
  { "amg-microwave.com", true },
  { "amh-entertainments.co.uk", true },
  { "ami-de-bastanes.fr", true },
  { "amianto.roma.it", true },
  { "amica-travel.com", true },
  { "amica.it", true },
  { "amicalecanyon.ch", true },
  { "amiciidogrescue.org.uk", true },
  { "amiciperlatesta.it", true },
  { "amifoundation.net", true },
  { "amikootours.com", true },
  { "amineptine.com", true },
  { "aminorth.com", true },
  { "aminullrouted.com", true },
  { "amionvpn.com", true },
  { "amir-heinisch.de", true },
  { "amirautos.com", false },
  { "amirmahdy.com", true },
  { "amisderodin.fr", true },
  { "amiserver.de", true },
  { "amitabhsirkiclasses.org.in", true },
  { "amitpatra.com", true },
  { "amiu.org", true },
  { "amj74-informatique.fr", true },
  { "amleather.pl", true },
  { "amm6e.com", true },
  { "ammanagingdirectors.com", true },
  { "amministratore.biz", true },
  { "amministratore.roma.it", true },
  { "amministratorecondominio.roma.it", true },
  { "amnesty-bf.org", true },
  { "amnesty.org.au", true },
  { "amnesy.fr", true },
  { "amobileway.co.uk", true },
  { "amok8.am", true },
  { "amokinio.com", true },
  { "amoozesh98.com", true },
  { "amoozesh98.ir", true },
  { "amorgos-aegialis.com", true },
  { "amorim.ca", true },
  { "amosng.com", true },
  { "ampersandnbspsemicolon.com", true },
  { "amphetamines.org", true },
  { "amplead.com", true },
  { "ampleroads.com", true },
  { "ampproject.com", true },
  { "ampproject.org", true },
  { "amrcaustin.com", true },
  { "amrcla.com", true },
  { "amruta.org", true },
  { "ams-web-qa.azurewebsites.net", true },
  { "ams.co.rs", true },
  { "amsportuk.com", true },
  { "amstelland.com", true },
  { "amstelveentje.nl", true },
  { "amsterdamian.com", true },
  { "amuq.net", true },
  { "amuraimpianti.it", true },
  { "amvip9.com", true },
  { "amyfoundhermann.com", true },
  { "amyharrisonline.com", true },
  { "amyria.jp", true },
  { "amyyeung.com", true },
  { "amzn.rocks", true },
  { "an-alles-gedacht.de", true },
  { "an7hrax.se", true },
  { "anabolic.co", false },
  { "anacreon.de", true },
  { "anadiyogacentre.com", true },
  { "anaiscoachpersonal.es", true },
  { "anaisfae.art", true },
  { "anakin.ca", true },
  { "analangelsteen.com", true },
  { "analbleachingguide.com", true },
  { "analgesia.net", true },
  { "analisilaica.it", true },
  { "analogist.net", true },
  { "analteengirls.net", true },
  { "analytics-shop.com", true },
  { "analyticsinmotion.com", true },
  { "analyticum.at", true },
  { "analyticum.com", true },
  { "analyticum.de", true },
  { "analyticum.eu", true },
  { "analyticum.net", true },
  { "ananke.io", true },
  { "anankecosmetics.com", true },
  { "anantshri.info", true },
  { "ananyoo.com", true },
  { "anarajaoui.ma", true },
  { "anarchistischegroepnijmegen.nl", false },
  { "anastasia-shamara.ru", true },
  { "anatoray.com", true },
  { "ance.lv", true },
  { "ancel.io", true },
  { "ancestramil.fr", true },
  { "anchev.net", true },
  { "anchorit.gov", true },
  { "anchovy.nz", false },
  { "anciennes-automobiles.fr", true },
  { "anciens.org", true },
  { "ancientnorth.com", true },
  { "ancientnorth.nl", true },
  { "ancolies-andre.com", true },
  { "anconaswine.com", true },
  { "and-stuff.nl", true },
  { "and.com", true },
  { "andalusierondreizen.nl", true },
  { "andariegocusco.com", true },
  { "andarpersassi.it", true },
  { "andel.info", false },
  { "anders.hamburg", true },
  { "andersonshatch.com", true },
  { "andiplusben.com", true },
  { "andisadhdspot.com", true },
  { "anditi.com", true },
  { "andoms.fi", true },
  { "andre-lategan.com", true },
  { "andre-otto.com", true },
  { "andrea-kiaora.de", true },
  { "andrea-m.me", true },
  { "andrea-wirthensohn.at", true },
  { "andreaboero.it", true },
  { "andreadraghetti.it", true },
  { "andreagobetti.com", true },
  { "andreagourmet.it", true },
  { "andreahruby.it", true },
  { "andreamcnett.com", true },
  { "andreas-hecht.com", true },
  { "andreas-kluge.eu", true },
  { "andreaseracleous.com", true },
  { "andreasfeusi.ch", true },
  { "andreashecht-blog.de", true },
  { "andreasjanker.de", true },
  { "andreaskrasa.com", true },
  { "andreaslicht.nl", true },
  { "andreasolsson.se", true },
  { "andree.cloud", true },
  { "andrehansen.de", true },
  { "andrei-nakov.org", true },
  { "andrelauzier.com", true },
  { "andreoliveira.io", true },
  { "andrespaz.com", true },
  { "andreundnina.de", true },
  { "andrew.fi", true },
  { "andrew.london", true },
  { "andrewbdesign.com", true },
  { "andrewbennett.ltd", true },
  { "andrewdaws.io", true },
  { "andrewensley.com", true },
  { "andrewimeson.com", true },
  { "andrewin.ru", true },
  { "andrewlarson.org", true },
  { "andrewpeng.net", true },
  { "andrewprokos.com", true },
  { "andrewpucci.com", true },
  { "andrewrgoss.com", true },
  { "andrewryno.com", true },
  { "andrewsun.com", true },
  { "andrewtasso.com", true },
  { "andrewtchin.com", true },
  { "andrewx.net", true },
  { "andrisilberschmidt.ch", true },
  { "andro2id.com", true },
  { "andro4all.com", true },
  { "android-tv.3utilities.com", true },
  { "android.re", true },
  { "androide.com", true },
  { "androidhry.cz", true },
  { "androidkatalog.cz", true },
  { "androidnovinky.cz", true },
  { "androidsis.com", true },
  { "androidtamer.com", true },
  { "androidtelefony.cz", true },
  { "androidzone.me", true },
  { "andromeda.se", true },
  { "andromedacenter.com", true },
  { "androtech.xyz", true },
  { "androticsdirect.com", true },
  { "androzoom.com", true },
  { "andruvision.cz", true },
  { "andsat.org", true },
  { "andschwa.com", true },
  { "anduril.de", true },
  { "anduril.eu", true },
  { "andybrett.com", true },
  { "andyc.cc", true },
  { "andycraftz.eu", true },
  { "andycrockett.io", true },
  { "andys-place.co.uk", true },
  { "andyt.eu", true },
  { "andzia.art.pl", true },
  { "anedot-sandbox.com", true },
  { "anedot.com", true },
  { "anedot.space", true },
  { "anedot.xyz", true },
  { "aneebahmed.com", true },
  { "anegabawa.com", true },
  { "aneslix.com", false },
  { "anetaben.nl", true },
  { "anextraordinaryday.net", true },
  { "angehardy.com", true },
  { "angel-body.com", true },
  { "angelcloudworld.com", true },
  { "angelesydemonios.es", true },
  { "angeletakis.net", true },
  { "angelicare.co.uk", true },
  { "angelinahair.com", true },
  { "angeljmadrid.com", true },
  { "angeloryndon.com", true },
  { "angelremigene.com", true },
  { "angiejones.com", true },
  { "anginf.de", true },
  { "anglersconservation.net", true },
  { "anglesgirl.eu.org", true },
  { "anglesya.win", true },
  { "anglictina-sojcak.cz", true },
  { "anglictinasojcak.cz", true },
  { "anglingactive.co.uk", true },
  { "anglirl.eu.org", true },
  { "angrapa.ru", true },
  { "angrido.com", true },
  { "angristan.fr", true },
  { "angristan.xyz", true },
  { "angrut.com", true },
  { "angry.im", true },
  { "angrysnarl.com", true },
  { "angryteeth.net", true },
  { "angularjs.org", false },
  { "angusmak.com", true },
  { "anhaffen.lu", true },
  { "ani-man.de", true },
  { "anicam.fr", true },
  { "animaemundi.be", true },
  { "animal-liberation.com", true },
  { "animal-rights.com", true },
  { "animalistic.io", true },
  { "animaltesting.fr", true },
  { "animationsmusicales.ch", true },
  { "anime-culture.com", true },
  { "anime-rg.com", true },
  { "anime-tip.com", true },
  { "anime.my", false },
  { "anime1.me", true },
  { "anime1.moe", true },
  { "anime1.pw", true },
  { "animeai.com", true },
  { "animeclub.in.ua", true },
  { "animefever.tv", true },
  { "animefire.net", true },
  { "animefluxxx.com", true },
  { "animeinsights.net", true },
  { "animeone.me", true },
  { "animes-portal.info", true },
  { "animesharp.com", true },
  { "animetriad.com", true },
  { "animojis.es", true },
  { "animorphsfanforum.com", true },
  { "anipassion.com", false },
  { "anitaalbersen.nl", true },
  { "anitaxcph.dk", true },
  { "anitube.ch", true },
  { "aniwhen.com", true },
  { "anjocerdena.com", true },
  { "anjoola.com", true },
  { "ankane.org", true },
  { "ankaraevdenevenakliyat.name.tr", true },
  { "ankarakart.com.tr", true },
  { "ankaraprofesyonelwebtasarim.com", true },
  { "ankaraseo.name.tr", true },
  { "ankarauzmanlarnakliyat.com", true },
  { "ankitha.in", true },
  { "ankitpati.in", true },
  { "ankiuser.net", true },
  { "ankiweb.net", true },
  { "ankwanoma.com", true },
  { "anleitung-deutsch-lernen.de", true },
  { "anleitung-zum-flechten.de", true },
  { "anleitung-zum-haekeln.de", true },
  { "anleitung-zum-schreiben.de", true },
  { "anleitung-zum-schweissen.de", true },
  { "anleitung-zum-toepfern.de", true },
  { "anlovegeek.net", true },
  { "anna.info", true },
  { "annaenemma.nl", true },
  { "annalitvinova.pro", true },
  { "annangela.moe", true },
  { "annarokina.com", true },
  { "annawagner.pl", true },
  { "annedaniels.co.uk", true },
  { "anneeden.de", true },
  { "annejan.com", true },
  { "anneliesonline.nl", true },
  { "annema.biz", true },
  { "annemakeslovelycandles.co.uk", true },
  { "annetta.com", true },
  { "annetta.net", true },
  { "annettewindlin.ch", true },
  { "annevankesteren.nl", true },
  { "anniversary-cruise.com", true },
  { "annmariewaltsphotography.com", true },
  { "annonasoftware.com", true },
  { "annoyingasfuk.com", true },
  { "anns.eu", true },
  { "annuaire-jcb.com", true },
  { "annuaire-photographe.fr", false },
  { "annunciationbvmchurch.org", true },
  { "anodas.lt", true },
  { "anohana.org", true },
  { "anojan.com", true },
  { "anon-next.de", true },
  { "anoncom.net", true },
  { "anoncrypto.org", true },
  { "anoneko.com", true },
  { "anongoth.pl", true },
  { "anonoriviera.com", true },
  { "anons.fr", true },
  { "anonym-surfen.de", true },
  { "anonyme-spieler.at", true },
  { "anopan.tk", true },
  { "another.ch", true },
  { "anotherchef.com", true },
  { "anotherfatgeek.net", true },
  { "anothervps.com", true },
  { "anowicki.pl", true },
  { "ans-delft.nl", true },
  { "ans-ge.ch", true },
  { "ansas.eu", true },
  { "ansas.net", true },
  { "ansdell.net", true },
  { "ansermet.net", true },
  { "ansgar-sonntag.de", true },
  { "ansgarsonntag.de", true },
  { "anshar.eu", true },
  { "anshumanbiswas.com", true },
  { "ansibeast.net", true },
  { "ansichtssache.at", true },
  { "anstaskforce.gov", true },
  { "antama.eu", true },
  { "antama.nl", true },
  { "antani.cloud", true },
  { "antarcti.co", true },
  { "antarees.net", true },
  { "antaresmedia.com.py", true },
  { "antarespc.com", true },
  { "antcas.com", true },
  { "antennista.bari.it", true },
  { "antennista.catania.it", true },
  { "antennista.milano.it", true },
  { "antennista.pavia.it", true },
  { "antennista.roma.it", true },
  { "antennista.tv", true },
  { "antennistaroma.it", true },
  { "antennisti.milano.it", true },
  { "antennisti.roma.it", true },
  { "antfie.com", true },
  { "anthisis.tv", true },
  { "anthony-bardon.eu", true },
  { "anthony.codes", true },
  { "anthonyellis.com", true },
  { "anthonyfontanez.com", true },
  { "anthonygaidot.fr", true },
  { "anthonyvadala.me", true },
  { "anthropoid.ca", true },
  { "anti-bible.com", true },
  { "anti-radar.org", true },
  { "antiaz.com", true },
  { "anticopyright.com", true },
  { "antiekboerderijgraafland.nl", true },
  { "antifilter.network", true },
  { "antihype.space", true },
  { "antik-trodelmarkt.de", true },
  { "antikvariat.ru", false },
  { "antikvarius.ro", true },
  { "antilaserpriority.com", true },
  { "antimine.me", true },
  { "antincendio.roma.it", true },
  { "antipolygraph.org", true },
  { "antique-pedalcars.ch", true },
  { "antirepressionbayarea.com", true },
  { "antispeciesism.com", true },
  { "antispeciesist.com", true },
  { "antivirusprotection.reviews", true },
  { "antocom.com", true },
  { "antoga.eu", true },
  { "antoinedeschenes.com", true },
  { "antoineelizabe.com", true },
  { "antoinemary.com", true },
  { "antonchen.com", true },
  { "antonellabb.eu", true },
  { "antonin.one", true },
  { "antonio-gartenbau.de", true },
  { "antonjuulnaber.dk", true },
  { "antonok.com", true },
  { "antonuotila.fi", true },
  { "antota.lt", true },
  { "antragsgruen.de", true },
  { "antroposboutique.it", true },
  { "antroposofica.com.br", true },
  { "antvklik.com", true },
  { "antyblokada.pl", true },
  { "anulowano.pl", true },
  { "anvartay.com", false },
  { "anvorte.com", false },
  { "anwalt.us", true },
  { "anwaltsindex.com", true },
  { "anxietyspace.com", true },
  { "anxiolytics.com", true },
  { "anyad.at", true },
  { "anyi.in", true },
  { "anymetrix.io", true },
  { "anyon.com", true },
  { "anypeer.net", true },
  { "anyquestions.govt.nz", true },
  { "anystack.xyz", true },
  { "anzeiger.ag", true },
  { "ao-dev.com", true },
  { "ao2.it", true },
  { "aoa.gov", true },
  { "aoadatacommunity.us", true },
  { "aoaprograms.net", true },
  { "aobeauty.com.au", true },
  { "aod-tech.com", true },
  { "aoe9.com", true },
  { "aoeuaoeu.com", true },
  { "aofusa.net", true },
  { "aoil.gr", true },
  { "aokae.com", true },
  { "aopedeure.nl", true },
  { "aopsy.de", true },
  { "aori.com", true },
  { "aos-llc.com", true },
  { "aosc.io", false },
  { "aostacarnavals.it", true },
  { "aotearoa.maori.nz", true },
  { "aotearoaleaks.org", true },
  { "ap-swiss.ch", true },
  { "apac-tech.com", false },
  { "apache-portal.com", true },
  { "apachehaus.de", false },
  { "apachelounge.com", true },
  { "apachezone.com", true },
  { "apadvantage.com", true },
  { "apartamentosemindaiatuba.com.br", true },
  { "apartmanicg.me", true },
  { "apartment-in-rijeka.com", true },
  { "apartmentkroatien.at", true },
  { "apartmentregister.com.au", true },
  { "apbank.ch", true },
  { "apbox.de", true },
  { "apc.ec", true },
  { "apcemporium.co.uk", true },
  { "apcube.com", true },
  { "apdfawl.com", true },
  { "apdx.com", true },
  { "apef.ch", true },
  { "apercloud.es", true },
  { "apertis.org", true },
  { "aperturesciencelabs.de", true },
  { "apervita.net", true },
  { "apexitsolutions.ca", true },
  { "apgw.jp", true },
  { "aphelionentertainment.com", true },
  { "aphotrax.eu", true },
  { "api-connect.com", true },
  { "api.biz.tr", true },
  { "api.cloudflare.com", true },
  { "api.intercom.io", true },
  { "api.lookout.com", false },
  { "api.recurly.com", true },
  { "api.simple.com", false },
  { "api.xero.com", false },
  { "apiary.blog", true },
  { "apiary.clothing", true },
  { "apiary.store", true },
  { "apiary.supplies", true },
  { "apiary.supply", true },
  { "apicruz.com", true },
  { "apila.care", true },
  { "apimo.net", true },
  { "apimon.de", true },
  { "apination.com", true },
  { "apio.systems", true },
  { "apiplus.fr", true },
  { "apis.google.com", true },
  { "apis.moe", true },
  { "apisyouwonthate.com", true },
  { "apiu.me", true },
  { "apk.li", true },
  { "apk4fun.com", true },
  { "apkmod.id", true },
  { "aplikaceproandroid.cz", true },
  { "aplpackaging.co.uk", true },
  { "aplu.fr", true },
  { "aplus-usa.net", true },
  { "aplusdownload.com", true },
  { "apluswaterservices.com", true },
  { "apm.com.tw", true },
  { "apn-dz.org", true },
  { "apn-einstellungen.de", true },
  { "apobot.de", true },
  { "apocalypsemud.org", true },
  { "apogeephoto.com", true },
  { "apoly.de", true },
  { "aponkral.net", true },
  { "aporia.io", true },
  { "aposke.net", true },
  { "aposke.org", true },
  { "apothes.is", true },
  { "app-at.work", true },
  { "app.lookout.com", true },
  { "app.recurly.com", true },
  { "app.simpletax.ca", true },
  { "app.yinxiang.com", false },
  { "app2get.de", true },
  { "appagility.co.nz", true },
  { "appapi.link", true },
  { "apparelfashionwiki.com", true },
  { "appartement-andrea.at", true },
  { "appartement-evolene.net", true },
  { "appartementhaus-badria.de", true },
  { "appartementmarsum.nl", true },
  { "appassionata.ru", true },
  { "appchive.net", true },
  { "appearance-plm.de", true },
  { "appelaprojets.fr", true },
  { "appelboomdefilm.nl", true },
  { "appengine.google.com", true },
  { "apperio.com", true },
  { "appgeek.com.br", true },
  { "appharbor.com", true },
  { "appify.org", true },
  { "appinn.com", true },
  { "applelife.ru", true },
  { "applemon.com", true },
  { "appleoosa.com", true },
  { "applesencia.com", true },
  { "applian.jp", true },
  { "applicationmanager.gov", true },
  { "apply.eu", true },
  { "appmeas.co.uk", true },
  { "appmobile.io", true },
  { "appninjas.com", true },
  { "apponic.com", true },
  { "apponline.com", true },
  { "apprank.in", true },
  { "apprendre-le-russe-avec-ania.fr", true },
  { "apprenticeship.gov", true },
  { "apprenticeships.gov", true },
  { "approbo.com", true },
  { "approvedtreecare.com", true },
  { "apps.co", true },
  { "apps.facebook.com", false },
  { "apps.fedoraproject.org", true },
  { "apps.stg.fedoraproject.org", true },
  { "apps4inter.net", true },
  { "appscloudplus.com", true },
  { "appsdisosa.com", true },
  { "appseccalifornia.org", false },
  { "appsforlondon.com", true },
  { "appspace.com", true },
  { "appspacehosted.com", true },
  { "appspacestatic.com", true },
  { "appspaceusercontent.com", true },
  { "appt.ch", true },
  { "apptomics.com", true },
  { "appuals.com", true },
  { "appui-de-fenetre.fr", true },
  { "appveyor.com", true },
  { "appzoojoo.be", true },
  { "apratimsaha.com", true },
  { "aprefix.com", true },
  { "apretatuercas.es", true },
  { "aprikaner.de", true },
  { "aprogend.com.br", true },
  { "aproposcomputing.com", true },
  { "aprovpn.com", true },
  { "aprr.org", true },
  { "aprsdroid.org", true },
  { "aprz.de", true },
  { "apsa.paris", true },
  { "apstudynotes.org", true },
  { "aptitudetests.org", true },
  { "aptumseguros.mx", true },
  { "apu-board.de", true },
  { "apunkt.dk", true },
  { "apv-ollon.ch", true },
  { "apviz.io", true },
  { "aqarategypt.com", true },
  { "aqdun.com", true },
  { "aqsiq.net", true },
  { "aqua-bucht.de", true },
  { "aqua-fitness-nacht.de", true },
  { "aqua-fotowelt.de", true },
  { "aquabio.ch", true },
  { "aquadonis.ch", true },
  { "aquagarden.com.pl", true },
  { "aquahomo.com", true },
  { "aquainfo.net", true },
  { "aqualife.com.gr", true },
  { "aqualifeprojects.com", true },
  { "aqualysis.nl", true },
  { "aquamarin.icu", true },
  { "aquapoint.kiev.ua", true },
  { "aquarium-supplement.net", true },
  { "aquaselect.eu", true },
  { "aquatechnologygroup.com", true },
  { "aquaterm72.ru", true },
  { "aquaundine.net", true },
  { "aquavitaedayspa.com.au", true },
  { "aquelarreweb.com", true },
  { "aquila.co.uk", true },
  { "aquitainebrasserie.com.au", true },
  { "aquitroc.com", true },
  { "ar-informatique.ch", true },
  { "arab.dating", true },
  { "arabhardware.net", true },
  { "arabsexi.info", true },
  { "arachina.com", true },
  { "arackiralama.name.tr", true },
  { "arados.de", true },
  { "aragon.fun", true },
  { "arai21.net", true },
  { "araleeniken.com", true },
  { "aramido.de", true },
  { "aramloebmd.com", true },
  { "aranchhomes.com", true },
  { "aranycsillag.net", true },
  { "araraexpress.com.br", true },
  { "araratour.com", true },
  { "araro.ch", true },
  { "araseifudousan.com", true },
  { "arawaza.com", false },
  { "araxis.com", true },
  { "arbeitsch.eu", true },
  { "arbeitskreis-asyl-eningen.de", true },
  { "arbeitslosenverwaltung.de", true },
  { "arbejdsdag.dk", true },
  { "arbitrarion.com", true },
  { "arbitrary.ch", true },
  { "arcaik.net", true },
  { "arcbouncycastles.co.uk", true },
  { "arcenergy.co.uk", true },
  { "archaeoadventures.com", true },
  { "archeologicatoscana.it", true },
  { "archerygearonline.com", true },
  { "archimedicx.com", true },
  { "archined.nl", true },
  { "archit.in", true },
  { "architectryan.com", true },
  { "architecture-colleges.com", true },
  { "architectureandgovernance.com", true },
  { "archivero.es", true },
  { "archivesdelavieordinaire.ch", true },
  { "archivium.biz", true },
  { "archivosstl.com", true },
  { "archiweb.pl", false },
  { "archlinux.de", true },
  { "archlinux.org", true },
  { "arclandholdings.com.au", true },
  { "arcobalabs.ca", true },
  { "arcridge.ca", true },
  { "arctic.ca", true },
  { "arctic.gov", true },
  { "arctica.io", true },
  { "arctus-security.com", true },
  { "arcueil-cachan.fr", false },
  { "arcusnova.de", true },
  { "arda-audio.pt", true },
  { "ardadanal.com", true },
  { "ardia.ovh", true },
  { "ardor.noip.me", true },
  { "ardtrade.ru", true },
  { "area4pro.com", true },
  { "areaclienti.net", true },
  { "areafiftylan.nl", true },
  { "areatrend.com", true },
  { "arefidgetspinnersgay.com", true },
  { "arekatieandchrisgettingmarried.com", true },
  { "arekatieandchrisgettingmarried.today", true },
  { "arekatieandchrismarriedyet.com", true },
  { "arena-lemgo.de", true },
  { "arendburgers.nl", true },
  { "arenlor.com", true },
  { "arenlor.info", true },
  { "arenns.com", true },
  { "areqgaming.com", true },
  { "ares-trading.de", true },
  { "arethsu.se", true },
  { "arfad.ch", true },
  { "arganaderm.ch", true },
  { "argb.de", true },
  { "argecord.com", true },
  { "argekultur.at", true },
  { "argentinatrabaja.org", true },
  { "argonium.com.au", true },
  { "argot.com", true },
  { "argovpay.com", true },
  { "ariacreations.net", true },
  { "ariadermspa.com", true },
  { "arian.io", true },
  { "ariana.wtf", true },
  { "arias.re", true },
  { "ariba.info", true },
  { "ariege-pyrenees.net", true },
  { "arieswdd.com", true },
  { "arigato-java.download", true },
  { "arijitdg.net", true },
  { "arikar.eu", true },
  { "arilto.com", true },
  { "arima.co.ke", true },
  { "arinde.ee", true },
  { "arise19.com", true },
  { "arisechurch.com", true },
  { "ariseconference.org.nz", true },
  { "aristocrates.co", true },
  { "aritec-la.com", true },
  { "arivo.com.br", true },
  { "arizonabondedtitle.com", true },
  { "arjan.nl", true },
  { "arjandejong.eu", true },
  { "arjanenthijs.nl", true },
  { "arjansteevels.nl", true },
  { "arjanvaartjes.net", true },
  { "arjunasdaughter.pub", true },
  { "arjweb.co.uk", true },
  { "arkacrao.org", true },
  { "arkadiyt.com", true },
  { "arkhvoid.xyz", true },
  { "arkulagunak.com", false },
  { "arlartistadigital.com.mx", true },
  { "arlen.tv", true },
  { "arlenarmageddon.com", true },
  { "arletalibrary.com", true },
  { "arlingtonelectric.com", true },
  { "arlingtonwine.net", true },
  { "arm-host.com", true },
  { "arm.gov", true },
  { "armadale.wa.gov.au", true },
  { "armadaquadrat.com", true },
  { "armandsdiscount.com", true },
  { "armanozak.com", true },
  { "armansfinejewellery.com", true },
  { "armansfinejewellery.com.au", true },
  { "armarinhovirtual.com.br", true },
  { "armbrust.me", true },
  { "armedpoet.com", true },
  { "armil.it", true },
  { "armin-cme.de", true },
  { "armin-cpe.de", true },
  { "arminc.tk", true },
  { "arminpech.de", true },
  { "armleads.com", true },
  { "armor.ai", true },
  { "armstrongsengineering.com", true },
  { "army24.cz", true },
  { "armyprodej.cz", true },
  { "arnaudb.net", true },
  { "arnaudfeld.de", true },
  { "arnaudlanna.com", true },
  { "arnevankauter.com", true },
  { "arniescastles.co.uk", true },
  { "arno-klein.de", true },
  { "arno-klein.eu", true },
  { "arnoldkontz-occasions.lu", true },
  { "arnonerba.com", true },
  { "arnor.org", true },
  { "arnoudraeven.nl", true },
  { "arnoudvandalen.nl", true },
  { "arnove.net", true },
  { "arnsmedia.nl", true },
  { "arod.tk", true },
  { "arogov.com", true },
  { "arokha.com", true },
  { "aromachat.eu", true },
  { "aromacos.ch", true },
  { "aromatlas.com", true },
  { "aron.host", true },
  { "aroonchande.com", false },
  { "aros.pl", true },
  { "arose.io", true },
  { "around-cms.de", true },
  { "arox.eu", true },
  { "arpamip.org", true },
  { "arpnet.co.jp", true },
  { "arqueo-ecuatoriana.ec", true },
  { "arquitetura.pt", true },
  { "arrakis.se", true },
  { "arraudi.be", true },
  { "arrazane.com.br", true },
  { "arresttracker.com", true },
  { "arrive.by", true },
  { "arrmaforum.com", true },
  { "arroba.digital", true },
  { "arrow-analytics.nl", true },
  { "arrow-api.nl", true },
  { "arrowfastener.com", true },
  { "arrowheadaddict.com", true },
  { "arrowwebprojects.nl", true },
  { "ars-online.pl", true },
  { "arschkrebs.org", true },
  { "arshell.me", true },
  { "arslankaynakmetal.com", true },
  { "arsplus.ru", false },
  { "arswb.men", true },
  { "art-auction.jp", true },
  { "art-et-culture.ch", true },
  { "art-et-tonneaux.fr", true },
  { "art-pix.com", true },
  { "art-pix.de", true },
  { "art-pix.net", true },
  { "art-shinbi.com", true },
  { "artacadia.org", true },
  { "artboja.com", true },
  { "artdeco-photo.com", true },
  { "arte-soft.co", true },
  { "artea.ga", true },
  { "arteaga.co.uk", true },
  { "arteaga.eu", true },
  { "arteaga.me", true },
  { "arteaga.tech", true },
  { "arteaga.uk", true },
  { "arteaga.xyz", true },
  { "artebel.com.br", true },
  { "artecat.ch", true },
  { "artedellavetrina.it", true },
  { "artedona.com", true },
  { "arteequipamientos.com.uy", true },
  { "artefakt.es", true },
  { "artefeita.com.br", true },
  { "arteinstudio.it", true },
  { "artelt.com", true },
  { "arterienundvenen.ch", true },
  { "arterydb.ru", true },
  { "arteseideias.com.pt", true },
  { "arteshow.ch", true },
  { "artfabrics.com", true },
  { "artforum.sk", true },
  { "artfullyelegant.com", true },
  { "arthan.me", true },
  { "arthermitage.org", true },
  { "arthritisrheumaticdiseases.com", true },
  { "arthurlaw.ca", true },
  { "arthuryidi.com", true },
  { "articu.no", true },
  { "artificial.army", true },
  { "artificialgrassandlandscaping.com", true },
  { "artigianociao.jp", true },
  { "artik.cloud", true },
  { "artikelpendidikan.id", true },
  { "artimpact.ch", true },
  { "artioml.net", true },
  { "artionet.ch", true },
  { "artis-game.net", true },
  { "artisan-cheminees-poeles-design.fr", false },
  { "artisans-libres.com", true },
  { "artisansoftaste.com", true },
  { "artisavotins.com", true },
  { "artistagenda.com", true },
  { "artistedeparis.fr", true },
  { "artistrunwebsite.com", true },
  { "artiwear.com.tw", true },
  { "artlantis.nl", true },
  { "artleading.ru", true },
  { "artlifeisgood.com", true },
  { "artlogo.biz", true },
  { "artlogo.cz", true },
  { "artlogo.sk", true },
  { "artmanager.dk", true },
  { "artmarketingnews.com", true },
  { "artmoney.com", true },
  { "artofcode.co.uk", true },
  { "artofhomeorganizing.com", true },
  { "artofmonitoring.com", false },
  { "artofwhere.com", true },
  { "artozoul.fr", true },
  { "artplasticsurgeons.com", true },
  { "artratio.net", true },
  { "artroot.jp", true },
  { "artroscopiaperlosport.it", true },
  { "arts.gov", true },
  { "artschmidtoptical.com", true },
  { "artspac.es", true },
  { "arttel-media.ru", true },
  { "arturopinto.com.mx", true },
  { "arturrossa.de", true },
  { "arturszalak.com", true },
  { "artweby.cz", true },
  { "artworxbathrooms.com.au", true },
  { "arty.name", true },
  { "arubasunsetbeach.com", true },
  { "arunjoshua.com", true },
  { "arveron.ch", true },
  { "arvid.io", true },
  { "arvindhariharan.com", true },
  { "arvindhariharan.me", true },
  { "arvutiladu.ee", true },
  { "arweth.com", true },
  { "arx8x.net", true },
  { "arxell.com", true },
  { "aryabusines.com", true },
  { "aryalaroca.de", true },
  { "aryan-nation.com", true },
  { "aryasenna.net", true },
  { "arzid.com", true },
  { "arzinfo.pw", true },
  { "as200753.com", true },
  { "as200753.net", true },
  { "as44222.net", true },
  { "as8423.net", true },
  { "asadatec.de", true },
  { "asafaweb.com", true },
  { "asafilm.co", true },
  { "asandu.eu", true },
  { "asanger.biz", true },
  { "asato-jewelry.com", true },
  { "asbestosthedarkarts.com", true },
  { "asbito.de", true },
  { "ascamso.com", true },
  { "ascension.run", true },
  { "ascensori.biz", true },
  { "ascgathering.com", true },
  { "aschismatic.com", true },
  { "ascii.moe", true },
  { "asciitable.tips", true },
  { "asciiwwdc.com", true },
  { "ascpaphilatelie.eu", true },
  { "asd.gov.au", true },
  { "asec01.net", true },
  { "asegem.es", true },
  { "asemanhotel.com", true },
  { "asenno.com", true },
  { "aserver.co", true },
  { "asexualitat.cat", true },
  { "asfaleianet.gr", true },
  { "asgapps.co.za", true },
  { "ashd1.goip.de", true },
  { "ashd2.goip.de", true },
  { "ashd3.goip.de", true },
  { "ashenm.ml", true },
  { "ashessin.com", true },
  { "ashkan-rechtsanwalt-arbeitsrecht-paderborn.de", true },
  { "ashleyedisonuk.com", true },
  { "ashleykaryl.com", true },
  { "ashleymadison.com", true },
  { "ashleythouret.com", true },
  { "ashlocklawgroup.com", true },
  { "ashmportfolio.com", true },
  { "ashridgetrees.co.uk", true },
  { "ashtonc.ca", true },
  { "ashutoshmishra.org", true },
  { "asia-gazette.com", true },
  { "asia-global-risk.com", true },
  { "asia.dating", true },
  { "asiaheavens.com", true },
  { "asialeonding.at", true },
  { "asian-industry.eu", true },
  { "asianshops.net", true },
  { "asianspa.co.uk", true },
  { "asiba.com.au", true },
  { "asiesvenezuela.com", true },
  { "asiinc-tex.com", true },
  { "asile-colis.fr", true },
  { "asilo.roma.it", true },
  { "asinetasima.com", true },
  { "asirigbakaute.com", true },
  { "asisee.photography", true },
  { "ask.fi", true },
  { "ask.pe", true },
  { "ask1.org", true },
  { "askcascade.com", true },
  { "askeustache.com", true },
  { "askizzy.org.au", true },
  { "askkaren.gov", true },
  { "askv6.net", true },
  { "askvg.com", true },
  { "askwhy.cz", true },
  { "askwhy.eu", true },
  { "asmbsurvey.com", true },
  { "asmdz.com", true },
  { "asmeets.nl", true },
  { "asmood.net", true },
  { "aspargesgaarden.no", true },
  { "aspatrimoine.com", true },
  { "aspcl.ch", true },
  { "aspectuw.com.au", true },
  { "asperti.com", true },
  { "aspformacion.com", true },
  { "asphyxia.su", true },
  { "aspiescentral.com", true },
  { "aspiradorasbaratas.net", true },
  { "aspirateur-anti-pollution.fr", true },
  { "aspires.co.jp", true },
  { "asprion.org", true },
  { "asproni.it", true },
  { "asr.cloud", true },
  { "asr.li", true },
  { "asr.rocks", true },
  { "asr.solar", true },
  { "asra.gr", true },
  { "asseenfromthesidecar.org", true },
  { "assemble-together.org", true },
  { "assempsaibiza.com", true },
  { "assertion.de", true },
  { "assessoriati.com.br", true },
  { "assetbacked.capital", true },
  { "assetsec.io", true },
  { "assguidesporrentruy.ch", true },
  { "assign-it.co.uk", false },
  { "assistel.com", true },
  { "assistenzaferrodastiro.org", true },
  { "assistenzafrigorifero.org", true },
  { "assistenzalavatrice.org", true },
  { "assistenzamicroonde.org", true },
  { "associatedwomenshealthcare.com", true },
  { "assodigitale.it", true },
  { "asspinter.me", true },
  { "assumptionpj.org", true },
  { "astal.rs", true },
  { "astaninki.com", true },
  { "astarbouncycastles.co.uk", true },
  { "astarmathsandphysics.com", true },
  { "astaxanthin-sport.de", true },
  { "astaxanthin.de", true },
  { "astec-informatica.com", true },
  { "astengox.com", true },
  { "astenotarili.online", true },
  { "astral-imperium.com", true },
  { "astral.org.pl", true },
  { "astrath.net", true },
  { "astroalloys.com.au", true },
  { "astrology42.com", true },
  { "astropaykasa.org", true },
  { "astroscopy.ch", true },
  { "astural.org", true },
  { "astutikhonda.com", true },
  { "asu.moe", true },
  { "asuclassfinder.com", true },
  { "asun.co", true },
  { "asurbernardo.com", true },
  { "asurepay.cc", false },
  { "asustreiber.de", true },
  { "asvsa.ch", true },
  { "asws.nl", true },
  { "asylbarn.no", true },
  { "asystent-dzierzawy.pl", true },
  { "at.search.yahoo.com", false },
  { "at5.nl", true },
  { "at7s.me", true },
  { "ataber.pw", true },
  { "atac.no", true },
  { "atacadocervejeiro.com.br", true },
  { "atacadodesandalias.com.br", true },
  { "atahualpa.com", true },
  { "atallo.com", true },
  { "atallo.es", true },
  { "ataton.ch", true },
  { "atbwebservices.co.uk", true },
  { "atc.cuneo.it", true },
  { "atchleyjazz.com", true },
  { "atchleyjazz.org", true },
  { "atchleylab.org", true },
  { "atcom.cl", true },
  { "atds.ch", true },
  { "ateamsport.dk", true },
  { "atease-salon.jp", true },
  { "atedificacion.com", true },
  { "ateli.com", true },
  { "atelier-coiffure.ch", true },
  { "atelier-naruby.cz", true },
  { "atelieraphelion.com", true },
  { "atelierbw.com", true },
  { "atelierdefrancais.ch", true },
  { "atelierdeloulou.fr", true },
  { "atelierdesflammesnoires.fr", true },
  { "atelierfantazie.sk", true },
  { "atelierhsn.com", true },
  { "ateliernaruby.cz", true },
  { "ateliers-veronese-nantes.fr", true },
  { "atelierssud.ch", true },
  { "atencionbimbo.com", false },
  { "atendimentodelta.com.br", true },
  { "aterlectric.com", true },
  { "aterskapa-data.se", true },
  { "atf.gov", true },
  { "atgoetschel.ch", true },
  { "atgseed.co.uk", true },
  { "atgseed.uk", true },
  { "ath0.org", false },
  { "atheist-refugees.com", true },
  { "atheistfrontier.com", true },
  { "athekiu.com", true },
  { "athena-bartholdi.com", true },
  { "athenacle.xyz", true },
  { "athenadynamics.com", true },
  { "athenaneuro.com", true },
  { "athlin.de", true },
  { "atigerseye.com", true },
  { "atimbertownservices.com", true },
  { "atinylittle.space", true },
  { "atishchenko.com", true },
  { "atisoft.biz", true },
  { "atisoft.com.tr", true },
  { "atisoft.net", true },
  { "atisoft.net.tr", true },
  { "atisoft.web.tr", true },
  { "atisystem.com", true },
  { "atitude.com", true },
  { "ativapsicologia.com.br", true },
  { "atl-paas.net", true },
  { "atlantareroof.com", true },
  { "atlantaspringroll.com", true },
  { "atlantichomes.com.au", true },
  { "atlanticpediatricortho.com", true },
  { "atlantis-kh.noip.me", true },
  { "atlantischild.hu", true },
  { "atlantishq.de", true },
  { "atlantiswaterproofing.com", true },
  { "atlas-heritage.com", true },
  { "atlas-multimedia.de", true },
  { "atlasauthority.com", true },
  { "atlasbrown.com", true },
  { "atlascoffeeclub.com", true },
  { "atlascultural.com", true },
  { "atlasdev.nl", true },
  { "atlasone.us", true },
  { "atlassian.io", true },
  { "atlassignsandplaques.com", true },
  { "atletika.hu", true },
  { "atmalta.com", true },
  { "atmind.nl", true },
  { "atmschambly.com", true },
  { "atnis.com", true },
  { "ato4sound.com", true },
  { "atolm.net", true },
  { "atom.solutions", true },
  { "atom86.net", true },
  { "atombase.org", true },
  { "atomicbounce.co.uk", true },
  { "atomism.com", true },
  { "atorcidabrasileira.com.br", true },
  { "atplonline.co", true },
  { "atpnutrition.com", true },
  { "atraining.ru", true },
  { "atraverscugy.ch", true },
  { "atrevillot.com", true },
  { "atrinik.org", true },
  { "atsoftware.de", true },
  { "atspeeds.com", true },
  { "attac.us", true },
  { "atte.fi", true },
  { "attendanceondemand.com", true },
  { "attendantdesign.com", true },
  { "attendu.cz", true },
  { "attentigroup.com", true },
  { "attention.horse", true },
  { "attilagyorffy.com", true },
  { "attilavandervelde.nl", true },
  { "attinderdhillon.com", true },
  { "attitudes-bureaux.fr", true },
  { "attogtech.com", true },
  { "attorney.org.il", true },
  { "attuned.se", true },
  { "attwood.org", true },
  { "atuendomr.com", true },
  { "atviras.lt", false },
  { "atvirtual.at", true },
  { "atvsafety.gov", true },
  { "atwar-mod.com", true },
  { "atwonline.org", true },
  { "atxchirocoverage.com", true },
  { "atyourprice.net", true },
  { "atypicom.es", true },
  { "atypicom.fr", true },
  { "atypicom.it", true },
  { "atypicom.pt", true },
  { "atzenchefin.de", true },
  { "atzzz.com", true },
  { "au-be.net", true },
  { "au2pb.org", true },
  { "aubergegilly.ch", true },
  { "aubg.org", true },
  { "aubio.org", true },
  { "aubonmanger.fr", true },
  { "aubreysnider.com", true },
  { "auburnmedicalservices.com", true },
  { "aucarresainteloi.com", true },
  { "aucielrose.com", true },
  { "aucklandcastles.co.uk", true },
  { "aucubin.de", true },
  { "audiense.com", false },
  { "audio-detector.com", true },
  { "audiobookboo.com", true },
  { "audiobookstudio.com", true },
  { "audioboom.com", true },
  { "audiolibri.org", true },
  { "audiolot.com", true },
  { "audion.cc", true },
  { "audiophile.ch", true },
  { "audiophix.com", true },
  { "audiorecording.me", true },
  { "audiorental.net", true },
  { "audioschoolonline.com", true },
  { "audiotechniker.de", true },
  { "audirsq3.de", true },
  { "audisto.com", true },
  { "auditmatrix.com", true },
  { "auditos.com", true },
  { "audits.io", true },
  { "auditsquare.com", true },
  { "audreyhossepian.fr", true },
  { "audreyjudson.com", true },
  { "auenhof-agrar.de", true },
  { "auerbach-verlag.de", true },
  { "auf-feindgebiet.de", true },
  { "augen-seite.de", true },
  { "augenlaser-chemnitz.de", true },
  { "augenlaser-dresden.de", true },
  { "augenlasercenter-dresden.de", true },
  { "augenlaserzentrum-dresden.com", true },
  { "augenlaserzentrum-dresden.eu", true },
  { "augiero.it", true },
  { "augix.net", true },
  { "august-don.site", true },
  { "augustian-life.cz", true },
  { "augustiner-kantorei-erfurt.de", true },
  { "augustiner-kantorei.de", true },
  { "aukaraoke.su", true },
  { "aulasvirtualesperu.com", true },
  { "aulica-conseil.com", true },
  { "aulo.in", false },
  { "aumilieudumonde.gf", true },
  { "auntie-eileens.com.au", true },
  { "auntmia.com", true },
  { "auplidespages.fr", true },
  { "aura7chakr.com", true },
  { "aurelieburn.fr", true },
  { "aurelienaltarriba.fr", true },
  { "auri.ga", true },
  { "auricblue.com", true },
  { "auriko-games.de", true },
  { "aurnik.com", true },
  { "aurora-multimedia.co.uk", true },
  { "auroraassociationofrealtors.com", true },
  { "auroware.com", true },
  { "auroz.tech", true },
  { "auroz.video", true },
  { "aus-ryugaku.info", true },
  { "ausec.ch", true },
  { "auskunftsbegehren.at", true },
  { "ausmwoid.de", true },
  { "auspicacious.org", true },
  { "ausrecord.com", true },
  { "ausschreibungen-suedtirol.it", true },
  { "aussiefunadvisor.com", true },
  { "aussieservicedown.com", true },
  { "austenplumbing.com", true },
  { "austin-pearce.com", true },
  { "austin-security-cameras.com", true },
  { "austincardiac.com", true },
  { "austinheap.com", false },
  { "austinlockout.com", true },
  { "austintxacrepairtoday.com", true },
  { "austintxlocksmiths.com", true },
  { "austinuniversityhouse.com", true },
  { "australian.dating", true },
  { "australianairbrushedtattoos.com.au", true },
  { "australianattractions.com.au", true },
  { "australianimmigrationadvisors.com.au", true },
  { "australiantemporarytattoos.com", true },
  { "australiantemporarytattoos.com.au", true },
  { "australien-tipps.info", true },
  { "austromorph.space", true },
  { "auszeit-lanzarote.com", true },
  { "auszeit-walsrode.de", true },
  { "auszeit.bio", true },
  { "auth.adult", true },
  { "authcom.ca", true },
  { "authenticationhub.io", true },
  { "authenticwoodcraft.com", true },
  { "authinfo-bestellen.de", true },
  { "authinity.com", true },
  { "authland.com", false },
  { "author24.biz", true },
  { "author24.info", true },
  { "authoritysolutions.com", true },
  { "autimatisering.nl", true },
  { "autismewoerden.nl", true },
  { "auto-anleitung.de", true },
  { "auto-dealership-news.com", true },
  { "auto-i-dat.ch", true },
  { "auto-motor-i-sport.pl", true },
  { "auto-none.com", true },
  { "auto-plus.tn", true },
  { "auto-res.ru", true },
  { "auto-spurgo.com", true },
  { "auto.nl", true },
  { "auto1.fi", true },
  { "autoauctionsohio.com", true },
  { "autoauctionsvirginia.com", true },
  { "autobahnco.com", true },
  { "autobarn.co.nz", true },
  { "autobedrijfgarant.nl", true },
  { "autobella-hurtownia.pl", true },
  { "autobelle.it", true },
  { "autobourcier.com", true },
  { "autocartruck.com", true },
  { "autocobot.com", true },
  { "autocontrol.online", true },
  { "autocorner.com", true },
  { "autocrypt.org", true },
  { "autod.hu", true },
  { "autodalmacija.com", true },
  { "autodidactic.ai", true },
  { "autodidacticstudios.com", true },
  { "autodidacticstudios.net", true },
  { "autodidacticstudios.org", true },
  { "autoelettricaperbambini.com", true },
  { "autoentrepreneurinfo.com", true },
  { "autofficina.roma.it", true },
  { "autohomehub.com", true },
  { "autoi.ch", true },
  { "autoinsurancehavasu.com", true },
  { "autokeyreplacementsanantonio.com", true },
  { "autokovrik-diskont.ru", true },
  { "autolawetawroclaw.pl", true },
  { "autoledky.sk", true },
  { "automagischeberegening.nl", true },
  { "automatethis.com.au", true },
  { "automatic.com", true },
  { "automationpro.me", true },
  { "automationsmarthome.com", true },
  { "automotivegroup-usedcars.be", true },
  { "automotivemechanic.org", true },
  { "automoto-tom.net", true },
  { "automy.de", true },
  { "autonewssite.com", true },
  { "autonoleggio.milano.it", true },
  { "autoosijek.com", true },
  { "autopapo.com.br", true },
  { "autoparts.im", true },
  { "autoparts.sh", true },
  { "autoparts.wf", true },
  { "autoprice.info", false },
  { "autoprogconsortium.ga", true },
  { "autoproshouston.com", true },
  { "autorando.com", true },
  { "autoreinigung-noack.de", true },
  { "autorepairseattle.com", true },
  { "autorijschooljohanbos.nl", true },
  { "autorijschoolrichardschut.nl", true },
  { "autos-mertens.com", true },
  { "autosaan.ro", true },
  { "autoschadeschreuder.nl", true },
  { "autoscuola.roma.it", true },
  { "autosecurityfinance.com", true },
  { "autoshinka72.ru", true },
  { "autoshun.org", true },
  { "autoskola.hr", true },
  { "autoskolaplzen.cz", true },
  { "autoskole.hr", true },
  { "autospurghi.milano.it", true },
  { "autospurgo.it", true },
  { "autospurgo.milano.it", true },
  { "autostodulky.cz", true },
  { "autotechschool.com", true },
  { "autoteplo.org", true },
  { "autoterminus-used.be", true },
  { "autoto.hr", true },
  { "autotransportquoteservices.com", true },
  { "autouncle.at", true },
  { "autouncle.co.uk", true },
  { "autouncle.com", true },
  { "autouncle.de", true },
  { "autouncle.dk", true },
  { "autouncle.fi", true },
  { "autouncle.fr", true },
  { "autouncle.it", true },
  { "autouncle.pl", true },
  { "autouncle.pt", true },
  { "autouncle.ro", true },
  { "autouncle.se", true },
  { "autoverzekeringafsluiten.com", true },
  { "autowerkstatt-puchheim.de", true },
  { "autozane.com", true },
  { "autres-talents.fr", true },
  { "autshir.com", true },
  { "auvernet.org", true },
  { "auvidos.ru", true },
  { "aux-arts-de-la-table.com", true },
  { "auxiliame.com", true },
  { "auxille.com", true },
  { "auxquatrevents.ch", true },
  { "av-yummy.com", true },
  { "av01.tv", true },
  { "av0ndale.de", true },
  { "ava-creative.de", false },
  { "ava-software.at", true },
  { "avaaz.org", true },
  { "avabouncehire.co.uk", true },
  { "avacariu.me", true },
  { "avaemr-development-environment.ca", true },
  { "avaeon.com", true },
  { "available.direct", true },
  { "availablecastles.com", true },
  { "avalon-rpg.com", true },
  { "avanet.ch", true },
  { "avanet.com", true },
  { "avanovum.de", true },
  { "avantitualatin.com", true },
  { "avarty.com", true },
  { "avarty.net", true },
  { "avatardiffusion.com", true },
  { "avatarrecruit.co.uk", true },
  { "avcd.cz", true },
  { "avdagic.net", true },
  { "ave.zone", true },
  { "aveapps.com", false },
  { "aveclunettesoleil.fr", true },
  { "avedesk.org", false },
  { "avelinodiaz.gal", true },
  { "aventurische-allianz.de", true },
  { "avenuedesbebes.com", true },
  { "avenueeyecare.com", true },
  { "avepol.cz", true },
  { "avepol.eu", true },
  { "averageinspired.com", true },
  { "averam.net", true },
  { "averen.co.uk", true },
  { "avernis.de", true },
  { "avexon.com", true },
  { "avia-krasnoyarsk.ru", true },
  { "avia-ufa.ru", true },
  { "aviapoisk.kz", true },
  { "aviationstrategies.aero", true },
  { "aviationstrategy.aero", true },
  { "aviationweather.gov", true },
  { "avid.blue", true },
  { "avidmode-dev.com", true },
  { "avidmode-staging.com", true },
  { "avidmode.com", true },
  { "avietech.com", true },
  { "avinilo.com", true },
  { "avlhostel.com", true },
  { "avm-multimedia.com", true },
  { "avmoo.com", true },
  { "avmrc.nl", true },
  { "avmup.com", true },
  { "avnet.ws", true },
  { "avocode.com", true },
  { "avonture.be", true },
  { "avova.de", true },
  { "avpres.net", true },
  { "avptp.org", true },
  { "avqueen.cn", false },
  { "avs-building-services.co.uk", true },
  { "avselectrical.co.uk", true },
  { "avsox.com", true },
  { "avtek.pl", true },
  { "avticket.ru", false },
  { "avtobania.pro", true },
  { "avtoforex.ru", true },
  { "avtogara-isperih.com", true },
  { "avtomarket.ru", true },
  { "avtoveles.by", true },
  { "avtovokzaly.ru", true },
  { "avvaterra.ch", true },
  { "avvcorda.com", true },
  { "avvocato.bologna.it", true },
  { "aw.gov.pl", true },
  { "awakenedmind.com", true },
  { "awardplatform.com", true },
  { "awardsplatform.com", true },
  { "awaremi-tai.com", true },
  { "awaresec.com", true },
  { "awaresec.no", true },
  { "awarify.io", true },
  { "awarify.me", true },
  { "awaro.net", true },
  { "awbouncycastlehire.com", true },
  { "awen.me", true },
  { "awesome-coconut-software.fr", true },
  { "awesomebouncycastles.co.uk", true },
  { "awesomenamegenerator.com", true },
  { "awic.ca", true },
  { "awk.tw", true },
  { "awksolutions.com", true },
  { "awningcanopyus.com", true },
  { "awningsaboveus.com", true },
  { "awomansplacenj.com", true },
  { "awplasticsurgery.com", true },
  { "awscloudrecipes.com", true },
  { "awsmdev.de", true },
  { "awsome-books.co.uk", true },
  { "awsumchan.org", true },
  { "awxg.com", true },
  { "ax25.org", true },
  { "axel-fischer.net", true },
  { "axel-voss.eu", true },
  { "axelname.ru", true },
  { "axelteichmann.net", true },
  { "axelvoss.eu", true },
  { "axiatancell.com", true },
  { "axiomer.com", true },
  { "axishw.com", true },
  { "axispara-bg.com", true },
  { "axolotlfarm.org", false },
  { "axon-toumpa.gr", true },
  { "axonholdingse.eu", true },
  { "axre.de", true },
  { "axrec.de", true },
  { "ay-net.jp", true },
  { "ayahya.me", false },
  { "ayanomimi.com", true },
  { "aycomba.de", true },
  { "ayesh.me", true },
  { "aying.love", true },
  { "aykutcevik.com", true },
  { "aylak.com", true },
  { "aylavblog.com", true },
  { "aylesburycastlehire.co.uk", true },
  { "aymerick.fr", true },
  { "aymericlagier.com", true },
  { "ayothemes.com", true },
  { "ayrshirebouncycastlehire.co.uk", true },
  { "ayumi.network", true },
  { "ayumindev.net", true },
  { "ayumix3.xyz", true },
  { "ayurveda-mantry.com", true },
  { "az-moga.bg", true },
  { "az.net.au", true },
  { "az.search.yahoo.com", false },
  { "azabani.com", true },
  { "azadliq.info", true },
  { "azarus.ch", true },
  { "azazy.net", false },
  { "azgfd.com", true },
  { "azh-kunden.de", true },
  { "aziende.com.ar", true },
  { "azimut.fr", true },
  { "azizvicdan.com", false },
  { "azlk-team.ru", true },
  { "aznews.site", true },
  { "azort.com", true },
  { "azotobacter.nl", true },
  { "azrazalea.net", true },
  { "azsgeniedev.azurewebsites.net", true },
  { "azso.pro", true },
  { "azsupport.com", true },
  { "aztraslochi.it", true },
  { "aztrix.me", true },
  { "aztummytuck.com", true },
  { "azu-l.com", true },
  { "azu-l.jp", true },
  { "azuki.cloud", true },
  { "azukie.com", true },
  { "azurecrimson.com", true },
  { "azuriasky.com", true },
  { "azuriasky.net", true },
  { "azurlane.cool", true },
  { "azuxul.fr", true },
  { "azzorti.com", true },
  { "azzurrapelletterie.it", true },
  { "b-b-law.com", true },
  { "b-boom.nl", true },
  { "b-cyclesshop.ch", true },
  { "b-f-s.pl", true },
  { "b-freerobux.ga", true },
  { "b-performance.de", true },
  { "b-root-force.de", true },
  { "b-services.net", true },
  { "b00de.ga", true },
  { "b0k.org", true },
  { "b0rk.com", true },
  { "b1788.net", false },
  { "b1c1l1.com", true },
  { "b2and.com", false },
  { "b2bmuzikbank.com", true },
  { "b2families.com.au", true },
  { "b303.me", true },
  { "b4bouncycastles.co.uk", true },
  { "b4ckbone.de", true },
  { "b4z.eu", true },
  { "b5197.co", true },
  { "b6729.co", true },
  { "b6957.co", true },
  { "b72.com", true },
  { "b72.net", true },
  { "b767.net", true },
  { "b8a.me", true },
  { "b9297.co", true },
  { "b9728.co", true },
  { "b9999ff.com", true },
  { "b9999hh.com", true },
  { "b9999ii.com", true },
  { "b9999jj.com", true },
  { "b9999ll.com", true },
  { "b9999mm.com", true },
  { "b9999nn.com", true },
  { "b9999oo.com", true },
  { "b9999pp.com", true },
  { "b9999qq.com", true },
  { "b9999tt.com", true },
  { "b9999uu.com", true },
  { "b9999vv.com", true },
  { "b9999ww.com", true },
  { "b9999yy.com", true },
  { "b9999zz.com", true },
  { "b99iosapp.com", true },
  { "baalsworld.de", true },
  { "baas-becking.biology.utah.edu", true },
  { "baazee.de", true },
  { "babacasino.net", true },
  { "babai.ru", true },
  { "babeleo.com", true },
  { "babineaux.zone", true },
  { "babsbibs.com", true },
  { "baby-bath-tub.com", true },
  { "baby-digne.com", true },
  { "baby-fotografie-muenchen.de", true },
  { "babybauch-shooting-muenchen.de", true },
  { "babyboom.pl", true },
  { "babycamapp.com", true },
  { "babyfotograf-schweiz.ch", true },
  { "babymasaze.cz", true },
  { "babyphototime.com", true },
  { "babypibu.com", true },
  { "babyshoprimini.com", true },
  { "bachata.info", true },
  { "bachkhoa.net.vn", true },
  { "baciu.ch", true },
  { "backeby.eu", true },
  { "backgroundchecks.online", true },
  { "backmountaingas.com", true },
  { "backpacker.dating", true },
  { "backscattering.de", false },
  { "backschues.com", true },
  { "backschues.de", true },
  { "backschues.net", true },
  { "backseatbandits.com", true },
  { "backsideverbier.ch", true },
  { "backterris.com", true },
  { "backtest.org", true },
  { "backup-kurumsal.com", true },
  { "backupcloud.ru", true },
  { "backupsinop.com.br", true },
  { "bacon-monitoring.org", true },
  { "baconismagic.ca", true },
  { "bacontreeconsulting.com", true },
  { "bacoux.com", true },
  { "bacula.jp", true },
  { "bad.horse", true },
  { "bad.pet", true },
  { "badam.co", true },
  { "badanka.com", true },
  { "badanteinfamiglia.it", true },
  { "badaparda.com", true },
  { "badblock.fr", true },
  { "badedesign.no", true },
  { "badgersystems.de", true },
  { "badges.fedoraproject.org", true },
  { "badges.stg.fedoraproject.org", true },
  { "badgesenpatches.nl", true },
  { "badgirlsbible.com", true },
  { "badgr.io", true },
  { "badhusky.com", false },
  { "badkamermarkt.nl", true },
  { "badmania.fr", true },
  { "badmintonbible.com", true },
  { "badoo.com", true },
  { "badoo.de", true },
  { "badoo.eu", true },
  { "badoo.us", true },
  { "badrequest.me", true },
  { "baeder-luboss.de", true },
  { "baer.im", false },
  { "baer.one", false },
  { "baer.space", true },
  { "bag.bg", true },
  { "bageez.us", true },
  { "bagelcraft.net", true },
  { "bageluncle.com", true },
  { "baggy.me.uk", true },
  { "bagheera.me.uk", true },
  { "baglu.com", false },
  { "bagni-chimici.roma.it", true },
  { "bagnichimici.milano.it", true },
  { "bagnichimici.roma.it", true },
  { "bagsofbounce.co.uk", true },
  { "bagspecialist.nl", true },
  { "bagwrap.com", true },
  { "bah.im", false },
  { "bahadirh.ml", true },
  { "bahaiprayers.io", true },
  { "bahana.net", true },
  { "bahnbonus-praemienwelt.de", true },
  { "bahnenimbild.de", true },
  { "bahnenimbild.eu", true },
  { "bahnhelden.de", true },
  { "bahninrotweissrot.at", true },
  { "bahnmagazine.de", true },
  { "baiduo.com", true },
  { "baifubao.com", true },
  { "baiker.info", true },
  { "bailakomigo.com.br", true },
  { "baildonbouncycastles.co.uk", true },
  { "baileebee.com", true },
  { "baileybae.com", true },
  { "bailonga.com", true },
  { "baitcon.com", true },
  { "bajic.ch", true },
  { "baka-gamer.net", true },
  { "baka.org.cn", true },
  { "bakermen.com", true },
  { "bakersafari.co", true },
  { "bakerviewdentalcentre.com", true },
  { "bakeup.be", true },
  { "bakibal.com", true },
  { "bakim.li", true },
  { "bakingstone.com", true },
  { "bakkerinjebuurt.be", true },
  { "bakongcondo.com", true },
  { "balade-commune.ch", true },
  { "baladecommune.ch", true },
  { "balancascia.com.br", true },
  { "balance7.jp", true },
  { "balancedbrawl.net", true },
  { "balancenaturalhealthclinic.ca", true },
  { "balaskas.gr", true },
  { "balboa.io", true },
  { "balboa.org.uk", true },
  { "balcaonet.com.br", true },
  { "balcarek.pl", true },
  { "balconnr.com", true },
  { "balconsverdun.com", true },
  { "baldur.cc", true },
  { "baldy.blog", true },
  { "baleen.us", true },
  { "balia.de", true },
  { "balicekzdravi.cz", true },
  { "balikonos.cz", true },
  { "balinese.dating", true },
  { "balivillassanur.com", true },
  { "balkenbushmechanical.com", true },
  { "balkonien.org", true },
  { "ball-bizarr.de", true },
  { "ball3d.es", true },
  { "ballarin.cc", true },
  { "ballejaune.com", true },
  { "balletcenterofhouston.com", true },
  { "ballinarsl.com.au", true },
  { "ballmerpeak.org", true },
  { "ballonsportclub-erlangen.de", true },
  { "ballotapi.com", true },
  { "ballothero.com", true },
  { "ballparkbuns.com", false },
  { "ballroom.info", true },
  { "balmeo.co.uk", true },
  { "balmofgilead.org.uk", true },
  { "balslev.io", true },
  { "balter.com", true },
  { "balticer.de", true },
  { "balticmed.pl", true },
  { "balticnetworks.com", true },
  { "bamahammer.com", true },
  { "bamboorelay.com", true },
  { "bamily.rocks", true },
  { "ban.moe", true },
  { "bananabandy.com", true },
  { "bananice.moe", true },
  { "bancacrs.it", true },
  { "bancobai.ao", true },
  { "bancoctt.pt", true },
  { "bancomap.ch", true },
  { "bancor.network", true },
  { "bancosdominicanos.net", true },
  { "bandagastrica.es", true },
  { "bandeira1.com.br", true },
  { "banderasdelmundo.xyz", true },
  { "bandiga.it", true },
  { "bandito.re", true },
  { "banes.ch", true },
  { "bangdream.ga", true },
  { "bangkok-dark-night.com", true },
  { "bangkok.dating", true },
  { "bangkokcity.de", true },
  { "bangorfederal.com", false },
  { "bangridho.com", true },
  { "bangumi.co", true },
  { "bangyu.wang", true },
  { "banham.co.uk", false },
  { "banham.com", true },
  { "bani99.com", true },
  { "banjostringiz.com", true },
  { "bank.barclays.co.uk", true },
  { "bank.simple.com", false },
  { "banka.space", true },
  { "bankanswers.gov", true },
  { "bankbranchlocator.com", true },
  { "bankcardoffer.com", true },
  { "bankee.us", true },
  { "bankerscaddy.com", true },
  { "banketbesteld.nl", true },
  { "bankgradesecurity.com", true },
  { "bankin.com", true },
  { "bankinter.pt", true },
  { "bankio.se", true },
  { "banknet.gov", true },
  { "bankofdenton.com", true },
  { "bankpolicies.com", true },
  { "banksaround.com", true },
  { "banksiaparkcottages.com.au", true },
  { "bankstownapartments.com.au", true },
  { "bankvanbreda.be", true },
  { "banland.net", true },
  { "banned-bitches.tk", true },
  { "bannermarquees.ie", true },
  { "bannsecurity.com", true },
  { "banquevanbreda.be", true },
  { "bantaihost.com", true },
  { "banter.city", true },
  { "baofengtech.com", true },
  { "baopublishing.it", true },
  { "baptistedeleris.fr", true },
  { "bar-harcourt.com", true },
  { "bar.pl", true },
  { "barabrume.fr", true },
  { "baranhotel.ir", true },
  { "barankababra.hu", true },
  { "barans2239.com", true },
  { "baravalle.com", true },
  { "baraxolka.ru", true },
  { "barbara-fuchs-gruene-fuerth.de", true },
  { "barbarabowersrealty.com", true },
  { "barbarafabbri.com", true },
  { "barbarafeldman.com", true },
  { "barbarians.com", false },
  { "barbate.fr", true },
  { "barbershop-lasvillas.com", true },
  { "barbu.family", true },
  { "barburas.com", true },
  { "barcamp.koeln", true },
  { "barcel.com.mx", true },
  { "barcelonabagels.cat", true },
  { "barcelonapremium.es", true },
  { "barcelonapremiummini.es", true },
  { "barclays.net", true },
  { "bardes.org", true },
  { "bardiharborow.com", true },
  { "bardiharborow.tk", true },
  { "baresquare.com", true },
  { "bargainsettelement.com", true },
  { "bariatrica.es", true },
  { "baripedia.org", true },
  { "bariseau-mottrie.be", true },
  { "barisi.me", true },
  { "baristador.com", true },
  { "bariumoxide.com", true },
  { "barkerjr.xyz", true },
  { "barlex.pl", true },
  { "barlotta.net", true },
  { "barnabycolby.io", true },
  { "barnel.com", true },
  { "barneveldcentrum.nl", true },
  { "barneydavey.com", true },
  { "barnfotografistockholm.se", true },
  { "baron14.be", true },
  { "barracuda.com.tr", true },
  { "barrera.io", true },
  { "barriofut.com", true },
  { "barrydenicola.com", true },
  { "bars.kh.ua", true },
  { "barsashop.com.br", true },
  { "barsgroup.com", true },
  { "bart-f.com", true },
  { "bartbania.com", true },
  { "bartel.ws", true },
  { "bartelt.name", true },
  { "barter4crypto.com", true },
  { "barth.services", true },
  { "barthonia-showroom.de", true },
  { "bartkramer.nl", true },
  { "bartlamboo.nl", true },
  { "bartolomebellido.com", true },
  { "bartula.de", true },
  { "bartzutow.xyz", true },
  { "baruch.me", true },
  { "barwave.com", true },
  { "bas.co.jp", true },
  { "base-autonome-durable.com", true },
  { "baseballrampage.com", true },
  { "baseballsavings.com", true },
  { "baseballwarehouse.com", true },
  { "baseconvert.com", true },
  { "basedonline.nl", true },
  { "baselang.com", true },
  { "basement961.co.nz", true },
  { "basementdoctornorthwest.com", true },
  { "basementfinishingohio.com", true },
  { "basementwaterproofingdesmoines.com", true },
  { "baserverz.ga", true },
  { "baseweb.design", true },
  { "bashing-battlecats.com", true },
  { "bashstreetband.co.uk", true },
  { "basicapparel.de", true },
  { "basicattentiontoken.org", true },
  { "basics.net", true },
  { "basketball-brannenburg.de", true },
  { "basketforex.com", true },
  { "basnoslovno.ru", true },
  { "basonlinemarketing.nl", true },
  { "bass-pro.ru", true },
  { "bassblog.net", true },
  { "bassment.ph", true },
  { "bassresource.com", true },
  { "bassrider.eu", true },
  { "bastelzauberwelt.de", true },
  { "bastiv.com", true },
  { "bastolino.de", true },
  { "basw.eu", true },
  { "baswag.de", true },
  { "baswetter.photography", true },
  { "basyspro.net", true },
  { "batcave.tech", true },
  { "batch.com", true },
  { "batch.engineering", true },
  { "baterioverolety.cz", true },
  { "bati-alu.fr", true },
  { "batiburrillo.net", true },
  { "batipresta.ch", true },
  { "batiskaf.ua", true },
  { "batistareisfloresonline.com.br", true },
  { "batlab.ch", true },
  { "batolis.com", true },
  { "batook.org", true },
  { "batschu.de", true },
  { "batteryboys.ca", true },
  { "batteryboys.com", true },
  { "batterystaple.pw", true },
  { "battle-game.com", true },
  { "battleboxx.com", false },
  { "battleground.com.au", true },
  { "batuhanbensoy.com.tr", true },
  { "bauer.network", true },
  { "bauernmarkt-fernitz.at", true },
  { "baugeldspezi.de", true },
  { "baugelitt.eu", true },
  { "baugemeinschaftbernstein.de", true },
  { "baumannfabrice.com", true },
  { "baumkuchen-aus-dresden.de", true },
  { "baur.de", true },
  { "bausep.de", true },
  { "bauthier-occasions.be", true },
  { "bautied.de", true },
  { "bauunternehmen-herr.de", true },
  { "bavarianhiker.de", false },
  { "bavaroparadise.com", true },
  { "bavarovillage.com", true },
  { "bavartec.de", true },
  { "bawbby.com", true },
  { "bayareaenergyevents.com", true },
  { "baychimo.com", true },
  { "bayden.com", true },
  { "bayer-stefan.com", true },
  { "bayer-stefan.de", true },
  { "bayer-stefan.eu", true },
  { "bayerhazard.de", true },
  { "bayerstefan.com", true },
  { "bayerstefan.de", true },
  { "bayerstefan.eu", true },
  { "bayherbalist.com", true },
  { "bayilelakiku.com", true },
  { "bayly.eu", true },
  { "baymard.com", true },
  { "bayportbotswana.com", true },
  { "bayportfinance.com", true },
  { "bayportghana.com", true },
  { "bayporttanzania.com", true },
  { "bayportuganda.com", true },
  { "bayportzambia.com", true },
  { "baystreet.com.mt", true },
  { "baytalebaa.com", true },
  { "baytownent.com", true },
  { "baywatch.io", true },
  { "bayz.de", true },
  { "baza-gai.com.ua", true },
  { "bazaarbhaav.com", true },
  { "bazaarcompass.com", true },
  { "bazari.com.pl", true },
  { "bazdell.com", true },
  { "bazinga-events.nl", true },
  { "bazos.at", true },
  { "bazos.cz", true },
  { "bazos.pl", true },
  { "bazos.sk", true },
  { "bazziergraphik.com", true },
  { "bb1718.net", true },
  { "bb5197.co", true },
  { "bb6729.com", true },
  { "bb6957.co", true },
  { "bb9297.co", true },
  { "bb9721.com", true },
  { "bb9728.co", true },
  { "bbalposticino.it", true },
  { "bbcastles.com", true },
  { "bbgeschenke.ch", true },
  { "bbimarketing.com", true },
  { "bbinsure.com", true },
  { "bbka.org.uk", true },
  { "bbkaforum.co.uk", true },
  { "bbkworldwide.jp", true },
  { "bbld.de", true },
  { "bblsa.ch", true },
  { "bbnx.net", true },
  { "bbsec.xyz", true },
  { "bbuio.com", false },
  { "bbw.dating", true },
  { "bbwcs.co.uk", true },
  { "bbyouthco.com", true },
  { "bc-bd.org", false },
  { "bc-diffusion.com", true },
  { "bc-reloaded.net", true },
  { "bcansw.com.au", true },
  { "bcbulle.ch", true },
  { "bcdiesel.ca", true },
  { "bcdonadio.com", true },
  { "bcdonadio.com.br", true },
  { "bcdonadio.org", true },
  { "bceventhire.co.uk", true },
  { "bch7al.ma", true },
  { "bchep.com", true },
  { "bck-koethen.de", true },
  { "bck-lelystad.nl", true },
  { "bckaccompressoroz.com", true },
  { "bclogandtimberbuilders.com", true },
  { "bclrk.us", true },
  { "bcmainland.ca", true },
  { "bcmguide.com", true },
  { "bcmhire.co.uk", true },
  { "bcpc-ccgpfcheminots.com", true },
  { "bcrook.com", true },
  { "bcswampcabins.com", true },
  { "bcubic.net", true },
  { "bcvps.com", true },
  { "bd2positivo.com", true },
  { "bda-boulevarddesairs.com", true },
  { "bdbxml.net", true },
  { "bdd.fi", true },
  { "bdikaros-network.net", true },
  { "bdpachicago.tech", true },
  { "bdvg.org", true },
  { "be-a-password.ninja", true },
  { "be-ka-tec.de", true },
  { "be-real.life", false },
  { "be-up-developpement.com", true },
  { "be-webdesign.com", true },
  { "be.search.yahoo.com", false },
  { "be2cloud.de", true },
  { "beacham.online", true },
  { "beachcitycastles.com", true },
  { "beachmarketing.co.uk", true },
  { "beadare.com", true },
  { "beadare.nl", true },
  { "beaglesecurity.com", true },
  { "bealpha.pl", true },
  { "beanbagaa.com", true },
  { "beanilla.com", true },
  { "beanjuice.me", true },
  { "beans-one.com", false },
  { "beansgalore.com.au", true },
  { "bearcms.com", true },
  { "bearcosports.com.br", true },
  { "beardboys.co.za", true },
  { "bearded.sexy", true },
  { "beardic.cn", true },
  { "bearingworks.com", true },
  { "bearlakelife.com", true },
  { "beastiejob.com", true },
  { "beatfeld.de", true },
  { "beatnikbreaks.com", true },
  { "beatrizaebischer.ch", true },
  { "beau.pw", true },
  { "beaumelcosmetiques.fr", true },
  { "beaute-eternelle.ch", true },
  { "beauty-italy.ru", true },
  { "beauty24.de", true },
  { "beautybear.dk", true },
  { "beautybh.com", true },
  { "beautyby.tv", true },
  { "beautycarepack.com.ng", true },
  { "beautyevent.fr", true },
  { "beautykat.ru", true },
  { "beaverdamautos.com", true },
  { "beavertales.ca", true },
  { "bebef.de", true },
  { "bebefofuxo.com.br", true },
  { "bebes.uno", true },
  { "bebest.gov", false },
  { "bebetrotteur.com", true },
  { "beboldpr.com", true },
  { "bebout.pw", true },
  { "beckenhamcastles.co.uk", true },
  { "beckerantiques.com", true },
  { "beckyhirstconsulting.com.au", true },
  { "becs.ch", true },
  { "becydog.cz", true },
  { "bedamedia.com", true },
  { "bedandbreakfast.dk", true },
  { "bedandbreakfasteuropa.com", true },
  { "bedandbreakfasthoekvanholland.com", true },
  { "bedels.nl", true },
  { "bedfordnissanparts.com", true },
  { "bedrijfsfotoreportages.nl", true },
  { "bedrocklinux.org", true },
  { "bedste10.dk", true },
  { "bee-creative.nl", true },
  { "bee-line.org.uk", true },
  { "bee-removal-dublin.com", true },
  { "bee.clothing", true },
  { "bee.supply", true },
  { "bee.tools", true },
  { "beehive.govt.nz", true },
  { "beehive42.com", true },
  { "beehive42.eu", true },
  { "beehive42.net", true },
  { "beehive42.nl", true },
  { "beehive42.org", true },
  { "beehosting.pro", true },
  { "beekbier.nl", true },
  { "beekeeper.blog", true },
  { "beekeeper.clothing", true },
  { "beekeeper.supplies", true },
  { "beekeeper.supply", true },
  { "beekeeper.tools", true },
  { "beekeeping.clothing", true },
  { "beekeeping.tools", true },
  { "beeksnetwork.nl", true },
  { "beelit.com", true },
  { "beeming.net", true },
  { "beer9.com", true },
  { "beercandle.com", true },
  { "beergazetteer.com", true },
  { "beerians.com", true },
  { "beerjet.bg", true },
  { "beerjet.cz", true },
  { "beerjet.ro", true },
  { "beerjet.sk", true },
  { "beerjetcz.cz", true },
  { "beerly.eu", true },
  { "beerradar.no", true },
  { "beerradar.party", true },
  { "beersconf.com", true },
  { "beeswarmrehoming.com.au", true },
  { "beeswax-orgone.com", true },
  { "beethoveninlove.com", true },
  { "beeutifulparties.co.uk", true },
  { "beexfit.com", true },
  { "beezkneezcastles.co.uk", true },
  { "beeznest.com", true },
  { "befoodsafe.gov", true },
  { "beforesunrise.de", true },
  { "beforeyoueatoc.com", true },
  { "beframed.ch", true },
  { "befreewifi.info", true },
  { "befundonline.de", true },
  { "begabungsfoerderung.info", true },
  { "begbie.com", true },
  { "beginner.nl", true },
  { "behamepresrdce.sk", true },
  { "behamzdarma.cz", true },
  { "behead.de", true },
  { "beherit.pl", true },
  { "behindertenagentur.de", true },
  { "behna24hodin.cz", true },
  { "behoreal.cz", true },
  { "bei18.com", true },
  { "beichtgenerator.de", true },
  { "beijing.dating", true },
  { "beijinglug.club", true },
  { "beimchristoph.de", true },
  { "beinad.com", true },
  { "beinad.ru", true },
  { "beisance.com", true },
  { "bejarano.io", true },
  { "belacapa.com.br", true },
  { "belanglos.de", true },
  { "belani.eu", true },
  { "belanja.express", true },
  { "belarto.be", true },
  { "belarto.de", true },
  { "belarto.es", true },
  { "belarto.fr", true },
  { "belarto.it", true },
  { "belarto.nl", true },
  { "belarto.pl", true },
  { "belastingmiddeling.nl", true },
  { "belavis.com", true },
  { "beleggingspanden-financiering.nl", true },
  { "belegit.org", true },
  { "belezashopping.com.br", true },
  { "belfastbounce.co.uk", true },
  { "belfastlocks.com", true },
  { "belfasttechservices.co.uk", true },
  { "belfor-probleme.de", true },
  { "belfordroxo.net.br", true },
  { "belge.rs", true },
  { "belgers.com", true },
  { "belgicaservices.be", true },
  { "belhopro.be", true },
  { "belics.com", true },
  { "belien-tweedehandswagens.be", true },
  { "believablebook.com", false },
  { "believersweb.org", true },
  { "bell.id.au", true },
  { "bella.network", true },
  { "bellaklein.de", true },
  { "bellamodeling.com", true },
  { "bellezzasenzalimiti.it", true },
  { "bellinghamdetailandglass.com", true },
  { "belloy.ch", true },
  { "belloy.net", true },
  { "bellthrough.com", true },
  { "belly-button-piercings.com", true },
  { "bellyandbrain.amsterdam", true },
  { "belmarresort.com", true },
  { "belmontgoessolar.org", true },
  { "belos.at", true },
  { "belouga.org", true },
  { "belt.black", true },
  { "beltar.nl", true },
  { "belvoirbouncycastles.co.uk", true },
  { "belyoung.com.br", true },
  { "bemcorp.de", true },
  { "bemindly.com", true },
  { "bemsoft.pl", true },
  { "ben-energy.com", false },
  { "ben-jarvis.co.uk", true },
  { "ben-stock.de", true },
  { "ben.ninja", true },
  { "benabrams.it", true },
  { "benandsarah.life", true },
  { "benary.org", true },
  { "benbalter.com", true },
  { "benbozsa.ca", true },
  { "benc.io", true },
  { "benceskorka.com", true },
  { "benchling.com", true },
  { "benchmarkmonument.com", true },
  { "benchstoolo.com", true },
  { "bencorby.com", true },
  { "bendemaree.com", true },
  { "bendigoland.com.au", true },
  { "bendingtheending.com", true },
  { "bendix.co", true },
  { "bendyworks.com", true },
  { "beneathvt.com", true },
  { "benedict-balzer.de", true },
  { "benediktgeissler.de", true },
  { "benefits.gov", true },
  { "benefitsbookcase.com", true },
  { "benefitshub.io", true },
  { "benefitshub.xyz", true },
  { "benepiscinas.com.br", true },
  { "beneri.se", true },
  { "benevita.bio", true },
  { "benewpro.com", true },
  { "bengalurugifts.com", true },
  { "bengisureklam.com", true },
  { "benhaney.com", true },
  { "benhartmann.de", true },
  { "benhavenarchives.org", true },
  { "benjamin-hering.com", true },
  { "benjamin.pe", true },
  { "benjaminblack.net", true },
  { "benjamindietrich.com", true },
  { "benjamindietrich.de", true },
  { "benjaminjurke.com", true },
  { "benjaminkopelke.com", true },
  { "benjaminpiquet.fr", true },
  { "benjamins.com", true },
  { "benjaminvasel.de", true },
  { "benjii.me", true },
  { "benjijaldoner.nl", true },
  { "benmatthews.com.au", true },
  { "benmillett.us", false },
  { "bennettsbouncycastlehire.co.uk", true },
  { "bennettshire.co.uk", true },
  { "benni1.eu", true },
  { "bennierobinson.com", true },
  { "bennink.me", true },
  { "benno.frl", true },
  { "bennygommers.nl", true },
  { "benriya.shiga.jp", true },
  { "bensbouncycastles.co.uk", true },
  { "benschnarr.com", true },
  { "benscobie.com", true },
  { "benshoof.org", true },
  { "bensinflatables.co.uk", true },
  { "bensokol.com", true },
  { "benstevinson.com", true },
  { "bentertain.de", true },
  { "bentley.blog", true },
  { "bentley.link", true },
  { "bentongroup.co.uk", true },
  { "bentonweatherstone.co.uk", true },
  { "bentrask.com", true },
  { "benvds.com", true },
  { "benz-hikaku.com", true },
  { "benzi.io", true },
  { "benzina.cn", true },
  { "beoordelingen.be", true },
  { "bepenak.com", true },
  { "bephoenix.org.uk", true },
  { "beproduct.ru", true },
  { "bepsvpt.me", true },
  { "bequiia.com", true },
  { "beranovi.com", true },
  { "beraten-entwickeln-steuern.de", true },
  { "berati.tv", true },
  { "beratungswelt.dvag", true },
  { "berdu.id", true },
  { "bereaplumber.co.za", true },
  { "bereginy.com.ua", true },
  { "berend.tk", true },
  { "bergenhave.nl", true },
  { "berger-chiro.com", true },
  { "bergevoet-fa.nl", true },
  { "berglust-pur.de", true },
  { "bergmanbeachproperties.com", true },
  { "bergmann-fotografin-berlin.de", true },
  { "bergmann-fotografin-dortmund.de", true },
  { "bergmann-fotografin-duesseldorf.de", true },
  { "bergmann-fotografin-essen.de", true },
  { "bergmann-fotografin-frankfurt.de", true },
  { "bergmann-fotografin-hamburg.de", true },
  { "bergmann-fotografin-koeln.de", true },
  { "bergmann-fotografin-muenchen.de", true },
  { "bergmann-fotografin-stuttgart.de", true },
  { "bergstoneware.com", true },
  { "berichtsheft-vorlage.de", true },
  { "berikod.ru", true },
  { "beringsoegaard.dk", true },
  { "berkat-luqs.ddns.net", true },
  { "berlin.dating", true },
  { "bermeitinger.eu", true },
  { "bermytraq.bm", true },
  { "berna.fr", true },
  { "bernadetteanderes.ch", true },
  { "bernama.com.my", true },
  { "bernar.do", true },
  { "bernardcontainers.be", true },
  { "bernarddickens.com", true },
  { "bernardez-photo.com", true },
  { "bernardgo.com", true },
  { "bernardo.fm", true },
  { "bernat.ch", true },
  { "bernat.im", true },
  { "bernbrucher.com", true },
  { "bernbrucher.de", true },
  { "bernd-leitner-fotodesign.com", true },
  { "bernd-leitner-fotodesign.de", true },
  { "bernd-leitner.de", true },
  { "berndklaus.at", true },
  { "bernhard-seidenspinner.de", true },
  { "bernhardkau.de", true },
  { "bernhardluginbuehl.ch", true },
  { "bernhardluginbuehl.com", true },
  { "bernieware.de", true },
  { "bernyweb.net", true },
  { "berr.yt", true },
  { "berra.se", true },
  { "berruezoabogados.com", true },
  { "berrus.com", true },
  { "berry.cat", true },
  { "berrypay.com", true },
  { "bersierservices.ch", true },
  { "bersotavocats.fr", true },
  { "berst.cz", true },
  { "berthabailey.com", true },
  { "bertholdsson.com", true },
  { "bertold.org", true },
  { "bertoliniodontoiatria.it", true },
  { "bertrand.bio", true },
  { "bertrandkeller.info", true },
  { "bertsmithvwparts.com", true },
  { "beryl.net", true },
  { "bescover.com", true },
  { "beserberg.tk", true },
  { "besole.ch", true },
  { "bespaarenergie.click", true },
  { "bespokebathrooms.com.au", true },
  { "bespokestraps.com", true },
  { "besser-beissen.de", true },
  { "best-accounting-schools.com", true },
  { "best-art-colleges.com", true },
  { "best-baptist-colleges.com", true },
  { "best-beauty-schools.com", true },
  { "best-business-colleges.com", true },
  { "best-catholic-colleges.com", true },
  { "best-community-colleges.com", true },
  { "best-culinary-colleges.com", true },
  { "best-education-schools.com", true },
  { "best-engineering-colleges.com", true },
  { "best-essay-service.com", true },
  { "best-graduate-programs.com", true },
  { "best-hvac-schools.com", true },
  { "best-lutheran-colleges.com", true },
  { "best-management-schools.com", true },
  { "best-marketing-schools.com", true },
  { "best-music-colleges.com", true },
  { "best-nursing-colleges.com", true },
  { "best-pharmacy-schools.com", true },
  { "best-tickets.co.uk", true },
  { "best-trucking-schools.com", true },
  { "best-wallpaper.net", true },
  { "best10websitebuilders.com", true },
  { "best2pay.net", true },
  { "best66.me", true },
  { "bestattungen-kammerer.de", true },
  { "bestattungshaus-kammerer.de", true },
  { "bestautoinsurance.com", true },
  { "bestbatteriesonline.com", true },
  { "bestbefore.com", true },
  { "bestbrakes.com", true },
  { "bestbrokerindia.com", true },
  { "bestbyte.com.br", true },
  { "bestdating.today", true },
  { "bestdownloadscenter.com", true },
  { "bestelectricnd.com", true },
  { "bestessaycheap.com", true },
  { "bestessayhelp.com", true },
  { "bestfotostudio.com", true },
  { "bestfriendsequality.org", true },
  { "bestgiftever.ca", true },
  { "besti.it", true },
  { "bestinshowing.com", true },
  { "bestinver.es", false },
  { "bestjumptrampolines.be", true },
  { "bestkenmoredentists.com", true },
  { "bestladyshaver.co.uk", true },
  { "bestlooperpedalsguide.com", true },
  { "bestmotherfucking.website", true },
  { "bestoffert.club", true },
  { "bestoliveoils.com", true },
  { "bestpartyhire.com", true },
  { "bestpig.fr", true },
  { "bestplumbing.com", true },
  { "bestpractice.domains", true },
  { "bestschools.io", true },
  { "bestseries.tv", true },
  { "bestshoesmix.com", true },
  { "bestwarezone.com", true },
  { "bestwebsite.gallery", true },
  { "betaal.my", true },
  { "betacavi.com", true },
  { "betaclouds.net", true },
  { "betaprofiles.com", true },
  { "betaworx.de", true },
  { "betaworx.eu", true },
  { "betecnet.de", true },
  { "bethanyduke.com", true },
  { "bethanypeds.com", true },
  { "bethpage.net", true },
  { "betobaccofree.gov", true },
  { "betonbit.com", true },
  { "betonmarkets.info", true },
  { "betor.cz", true },
  { "betpamm.com", true },
  { "betrifft-mich-dsgvo.ch", true },
  { "bets.gg", true },
  { "betseybuckheit.com", true },
  { "betsharpangles.com", true },
  { "betshoot.com", true },
  { "bett1.de", true },
  { "bettaline.com.au", true },
  { "better-bounce.co.uk", true },
  { "better.com", true },
  { "better.fyi", true },
  { "bettercareclinic.co.uk", true },
  { "betterconsult.com", true },
  { "bettercrypto.org", true },
  { "betterna.me", true },
  { "betterscience.org", true },
  { "bettersecurity.co", true },
  { "bettertechinterviews.com", true },
  { "bettertest.it", true },
  { "bettertime.de", true },
  { "bettertime.jetzt", true },
  { "betterweb.fr", true },
  { "betterworldinternational.org", true },
  { "bettflaschen.ch", true },
  { "bettingbusiness.ru", true },
  { "bettingsider.dk", true },
  { "bettolinokitchen.com", true },
  { "bettrlifeapp.com", true },
  { "betulashop.ch", true },
  { "betwalker.com", true },
  { "beulen.email", true },
  { "beulen.link", true },
  { "beulen.pro", true },
  { "beuteugeu.com", true },
  { "bevedo.cz", true },
  { "bevedo.sk", true },
  { "beveiligingscamerawestland.nl", true },
  { "bevelpix.com", true },
  { "beverlyinternational.com", true },
  { "bevhills.com", true },
  { "bevinco2020.com", true },
  { "bevinsco.org", true },
  { "bevnut.com", true },
  { "bewegigsruum.ch", true },
  { "bewegungsfluss.com", false },
  { "bewerbungsfibel.de", true },
  { "bewertet.de", true },
  { "bewonderen.com", true },
  { "bexit-security.eu", true },
  { "bexit-security.nl", true },
  { "bexit.nl", true },
  { "bexleycastles.co.uk", true },
  { "beybiz.com", true },
  { "beyerautomation.com", true },
  { "beyerm.de", true },
  { "beyond-infinity.org", false },
  { "beyondalderaan.net", true },
  { "beyondbounce.co.uk", true },
  { "beyondordinarylife.com", true },
  { "beyondpricing.com", true },
  { "beyondtodaymediagroup.com", true },
  { "beyondweb.net", true },
  { "beyours.be", true },
  { "bez-energie.de", true },
  { "bezahlbare-praemien.ch", true },
  { "bezemkast.nl", true },
  { "bezlampowe.pl", true },
  { "bezlepkovamatka.cz", true },
  { "bezmlska.cz", false },
  { "bezpecnostsiti.cf", true },
  { "bezposrednio.net.pl", true },
  { "bezzia.com", true },
  { "bf5.ru", true },
  { "bf7088.com", true },
  { "bf7877.com", true },
  { "bfam.tv", true },
  { "bfcgermania88.de", true },
  { "bfem.gov", true },
  { "bfh.science", true },
  { "bfkcloud.ddns.net", true },
  { "bflix.tv", true },
  { "bfob.gg", true },
  { "bforb.sk", true },
  { "bfp-mail.de", true },
  { "bfpg.org", true },
  { "bft-media.com", true },
  { "bfw-online.de", true },
  { "bgbaby.net", true },
  { "bgfashion.net", true },
  { "bgfoto.info", true },
  { "bghost.xyz", true },
  { "bgkoleda.bg", true },
  { "bgmn.me", true },
  { "bgp.space", true },
  { "bgr34.cz", true },
  { "bgtgames.com", true },
  { "bgtoyou.com", true },
  { "bguidinger.com", true },
  { "bh-oberland.de", true },
  { "bh.sb", true },
  { "bharath-g.in", true },
  { "bhodisoft.com", true },
  { "bhserralheria.com.br", true },
  { "bhtelecom.ba", true },
  { "bhuntr.com", true },
  { "bhxch.moe", true },
  { "bi.search.yahoo.com", false },
  { "bi1gif.radio", true },
  { "bi8cku.club", true },
  { "bi8cku.tech", true },
  { "biaggeo.com", true },
  { "biancapulizie.it", true },
  { "biano-ai.com", true },
  { "biasmath.es", true },
  { "biathloncup.ru", true },
  { "bibica.net", true },
  { "bible-maroc.com", true },
  { "bibleversesfordailyliving.com", true },
  { "bibliaon.com", true },
  { "biblioblog.fr", true },
  { "bibliomarkt.ch", true },
  { "biblionaut.net", true },
  { "biblioporn.com", true },
  { "bibliotecadeseguranca.com.br", true },
  { "bibliotherapie-existentiale.com", true },
  { "biboumail.fr", true },
  { "bibuch.com", true },
  { "bicecontracting.com", true },
  { "bicha.net", true },
  { "bicifanaticos.com", true },
  { "bicranial.io", true },
  { "bicycle-events.com", true },
  { "bicycleframeiz.com", true },
  { "bicycleuniverse.com", true },
  { "biddl.com", true },
  { "biddle.co", true },
  { "bidman.cz", true },
  { "bidman.eu", true },
  { "bidu.com.br", true },
  { "bie.edu", false },
  { "bie08.com", true },
  { "bie79.com", true },
  { "biec.moe", true },
  { "biegal.ski", true },
  { "biegner-technik.de", true },
  { "biehlsoft.info", true },
  { "bielefailed.de", true },
  { "bien-etre-sante.info", true },
  { "bienestarinmobiliarioyaliadas.com", true },
  { "bienici.com", true },
  { "bienoubien.org", true },
  { "bienstar.tv", true },
  { "bierbaumer.net", true },
  { "biergaizi.info", true },
  { "bierwebshop.be", true },
  { "bieser.ch", true },
  { "biester.pro", true },
  { "bifrost.cz", true },
  { "big-andy.co.uk", true },
  { "big-bounce.co.uk", true },
  { "big-fluglaerm-hamburg.de", true },
  { "bigadcompany.com", true },
  { "bigbendguide.com", true },
  { "bigbluedoor.net", true },
  { "bigboris.tk", true },
  { "bigbouncebouncycastles.co.uk", true },
  { "bigbouncetheory.co.uk", true },
  { "bigbounceuk.com", true },
  { "bigbrotherawards.nl", true },
  { "bigcakes.dk", true },
  { "bigclassaction.com", true },
  { "bigdinosaur.org", true },
  { "bighouse-events.co.uk", true },
  { "bigideasnetwork.com", true },
  { "bigio.com.br", true },
  { "biglou.com", false },
  { "bigorbitgallery.org", true },
  { "bigpicture-learning.com", true },
  { "bigserp.com", true },
  { "bigshopper.com", true },
  { "bigshopper.nl", true },
  { "bigsisterchannel.com", true },
  { "bigskylifestylerealestate.com", true },
  { "bigskymontanalandforsale.com", true },
  { "bihub.io", true },
  { "biilo.com", true },
  { "bijancompany.com", true },
  { "bijouxcherie.com", true },
  { "biju-neko.jp", true },
  { "bijuteriicualint.ro", true },
  { "bike-kurse.ch", true },
  { "bike-shack.com", true },
  { "bikebay.it", true },
  { "bikehistory.org", true },
  { "biker.dating", true },
  { "bikhof.com", true },
  { "bikiniatoll.com", true },
  { "bikiniseli.com", true },
  { "bikkelbroeders.com", false },
  { "bikkelbroeders.nl", false },
  { "bilalkilic.de", true },
  { "bilbayt.com", true },
  { "bilder-designs.de", true },
  { "bildiri.ci", true },
  { "bildkomponist.de", true },
  { "bildschirmflackern.de", true },
  { "biletyplus.by", true },
  { "biletyplus.ua", true },
  { "bilgo.com", true },
  { "bilibili.link", true },
  { "bilibili.red", true },
  { "bilibili.sh", true },
  { "bilimoe.com", true },
  { "bilke.org", true },
  { "billaud.eu.org", true },
  { "billfazz.com", true },
  { "billgoldstein.name", true },
  { "billhartzer.com", true },
  { "billigastehemsidan.se", true },
  { "billiger-mietwagen.de", true },
  { "billigerfinder.de", true },
  { "billigpoker.dk", true },
  { "billin.net", true },
  { "billionaire365.com", true },
  { "billionairemailinglist.com", false },
  { "billkochman.com", true },
  { "billogr.am", true },
  { "billogram.be", true },
  { "billogram.ch", true },
  { "billogram.co", true },
  { "billogram.co.uk", true },
  { "billogram.com", true },
  { "billogram.de", true },
  { "billogram.es", true },
  { "billogram.eu", true },
  { "billogram.fi", true },
  { "billogram.fr", true },
  { "billogram.io", true },
  { "billogram.it", true },
  { "billogram.me", true },
  { "billogram.net", true },
  { "billogram.nl", true },
  { "billogram.nu", true },
  { "billogram.org", true },
  { "billogram.se", true },
  { "billogramcontent.com", true },
  { "billograminternal.com", true },
  { "billogramstatic.com", true },
  { "billogramtest.com", true },
  { "billopay.com", true },
  { "billopay.de", true },
  { "billopay.se", true },
  { "billpro.com", false },
  { "billy.pictures", true },
  { "billyoh.com", true },
  { "billysbouncycastlehire.co.uk", true },
  { "billywig.stream", true },
  { "biltullen.com", true },
  { "bim.physio", true },
  { "bimbo.com", false },
  { "bimbo.com.ar", false },
  { "bimbobakeriesusa.com", false },
  { "bimibroccoli.co.uk", true },
  { "bimibroccoli.com", true },
  { "bimibroccoli.dk", true },
  { "bimibroccoli.it", true },
  { "bimibroccoli.nl", true },
  { "bimibroccoli.se", true },
  { "bimibrocoli.es", true },
  { "bimibrocoli.fr", true },
  { "bimibrokkoli.de", true },
  { "bimmerlabs.com", true },
  { "bin95.com", true },
  { "bina.az", true },
  { "binans.com", true },
  { "binans.com.tr", true },
  { "binans.net", true },
  { "binary.house", true },
  { "binaryapparatus.com", true },
  { "binaryappdev.com", true },
  { "binarycreations.scot", true },
  { "binarydream.fi", true },
  { "binaryevolved.com", true },
  { "binaryrebel.net", true },
  { "binarystud.io", true },
  { "binding-problem.com", true },
  { "binfind.com", true },
  { "bing.com", true },
  { "bingobank.org", true },
  { "binhex.net", true },
  { "binhp.com", true },
  { "biniou.net", true },
  { "binkconsulting.be", true },
  { "binnenmeer.de", true },
  { "binsp.net", true },
  { "binti.com", true },
  { "bintooshoots.com", true },
  { "bio-disinfestazione.it", true },
  { "bio-feed.org", true },
  { "bio24.si", true },
  { "bioastin.de", true },
  { "bioatelier.it", true },
  { "biobuttons.ch", true },
  { "biocheminee.com", true },
  { "biocrafting.net", false },
  { "biodiagnostiki.clinic", true },
  { "biodieseldata.com", true },
  { "biodots.at", true },
  { "biodots.eu", true },
  { "biodots.info", true },
  { "biodots.it", true },
  { "bioedilizia.roma.it", true },
  { "bioemsan.cz", true },
  { "bioequivalence.design", true },
  { "bioetco.ch", true },
  { "bioexploratorium.pl", true },
  { "biofrequenze.it", true },
  { "biogecho.ch", true },
  { "biogecho.swiss", true },
  { "biogeist.de", true },
  { "biohappiness.com", true },
  { "bioharmony.ca", true },
  { "biointelligence-explosion.com", true },
  { "bioleev.sklep.pl", true },
  { "bioligo.ch", true },
  { "biologis.ch", true },
  { "biology-colleges.com", true },
  { "biomag.it", true },
  { "biomasscore.com", true },
  { "biomathalliance.org", true },
  { "biomed-hospital.ch", true },
  { "biomed.ch", true },
  { "biometrics.es", true },
  { "biomin.co.uk", false },
  { "biomodra.cz", true },
  { "bionima.com", true },
  { "biopsychiatry.com", true },
  { "bioresonanz-ibiza.com", true },
  { "biosafe.ch", true },
  { "biosbits.org", true },
  { "bioshine.com.sg", true },
  { "biosignalanalytics.com", true },
  { "biosphere.cc", true },
  { "biospw.com", true },
  { "biotechware.com", true },
  { "biotin.ch", true },
  { "bipyo.com", true },
  { "birbaumer.li", true },
  { "birchbarkfurniture.com", true },
  { "birchbarkfurniture.fr", true },
  { "birdbrowser.com", true },
  { "birdfeeder.online", true },
  { "birdiehosting.nl", true },
  { "birdslabel.com", true },
  { "birdymanbestreviews.com", true },
  { "birgerschwarz.de", false },
  { "birgit-rydlewski.de", true },
  { "birkenstab.de", true },
  { "birminghamsunset.com", true },
  { "birthdaytip.com", true },
  { "birthmatters.us", true },
  { "birthright.website", true },
  { "birzan.org", true },
  { "bisa-sis.net", true },
  { "bischoff-mathey.family", true },
  { "biscuitcute.com.br", true },
  { "biser-borisov.eu", true },
  { "biser.online", true },
  { "bishopscourt-hawarden.co.uk", true },
  { "bismarck-tb.de", true },
  { "biso.ga", true },
  { "bison.co", true },
  { "bisq.community", true },
  { "bissalama.org", true },
  { "bisschopssteeg.nl", true },
  { "bistrocean.com", true },
  { "bistroservice.de", true },
  { "bistrotdelagare.fr", true },
  { "biswas.me", true },
  { "bit-cloud.de", true },
  { "bit-rapid.com", true },
  { "bit-sentinel.com", true },
  { "bit-service-aalter.be", true },
  { "bit.biz.tr", true },
  { "bit8.com", true },
  { "bitaccelerate.com", true },
  { "bitbank.cc", true },
  { "bitbeans.de", true },
  { "bitbox.me", true },
  { "bitbucket.com", true },
  { "bitbucket.io", true },
  { "bitbucket.org", true },
  { "bitburner.de", true },
  { "bitchigo.com", true },
  { "bitcoin-india.net", true },
  { "bitcoin-india.org", true },
  { "bitcoin.asia", true },
  { "bitcoin.ch", true },
  { "bitcoin.co.nz", true },
  { "bitcoin.de", true },
  { "bitcoin.im", true },
  { "bitcoin.info", true },
  { "bitcoin.org", true },
  { "bitcoin.us", true },
  { "bitcoinbitcoin.com", true },
  { "bitcoincasinos.pro", true },
  { "bitcoincore.org", true },
  { "bitcoinfees.net", true },
  { "bitcoinindia.com", true },
  { "bitcoinkarlsruhe.de", true },
  { "bitcoinrealestate.com.au", true },
  { "bitcointhefts.com", true },
  { "bitcointrade.com.br", true },
  { "bitcoinx.ro", true },
  { "bitcork.io", true },
  { "bitcqr.io", true },
  { "bitenose.com", true },
  { "bitex.la", true },
  { "bitfasching.de", false },
  { "bitfehler.net", true },
  { "bitfinder.nl", true },
  { "bitfuse.net", true },
  { "bitgo.com", true },
  { "bitgrapes.com", true },
  { "bitguerrilla.com", true },
  { "bithir.co.uk", true },
  { "bititrain.com", true },
  { "bitlish.com", true },
  { "bitlo.com", true },
  { "bitlo.com.tr", true },
  { "bitlo.io", true },
  { "bitlo.org", true },
  { "bitmainwarranty.com", true },
  { "bitmarket.net", true },
  { "bitmarket.pl", true },
  { "bitmask.me", true },
  { "bitmessage.ch", true },
  { "bitmidi.com", true },
  { "bitminter.com", true },
  { "bitok.com", true },
  { "bitpoll.de", true },
  { "bitpoll.org", true },
  { "bitpumpe.net", true },
  { "bitref.com", true },
  { "bitrefill.com", true },
  { "bitrush.nl", true },
  { "bits-hr.de", true },
  { "bitsafe.com.my", true },
  { "bitski.com", true },
  { "bitskins.co", true },
  { "bitskrieg.net", true },
  { "bitso.com", true },
  { "bitsoffreedom.nl", true },
  { "bitstorm.nl", true },
  { "bitstorm.org", true },
  { "bitsy.com", true },
  { "bitsync.nl", true },
  { "bitten.pw", true },
  { "bittersweetcandybowl.com", true },
  { "bittylicious.com", true },
  { "bitvest.io", true },
  { "bitwarden.com", true },
  { "bitwolk.nl", true },
  { "bitxel.com.co", true },
  { "biupay.com.br", true },
  { "biurokarier.edu.pl", true },
  { "bixbydevelopers.com", true },
  { "bixservice.com", true },
  { "biyori.moe", true },
  { "biyou-homme.com", true },
  { "biz4x.com", true },
  { "bizbudding.com", true },
  { "bizcash.co.za", true },
  { "biznesonline.info", true },
  { "bizniskatalog.mk", true },
  { "biznpro.ru", true },
  { "bizpare.com", true },
  { "bizstarter.cz", true },
  { "biztera.com", true },
  { "biztok.eu", true },
  { "biztouch.work", true },
  { "bizzdesign.cloud", true },
  { "bizzdesign.com", true },
  { "bjarnerest.de", true },
  { "bjmgeek.science", true },
  { "bjmun.cn", true },
  { "bjoe2k4.de", true },
  { "bjoernengel.de", true },
  { "bjoernengel.eu", true },
  { "bjolanta.pl", true },
  { "bjornhelmersson.se", true },
  { "bjornjohansen.no", true },
  { "bjs.gov", true },
  { "bjsbouncycastles.com", true },
  { "bjut.photos", true },
  { "bk-wife.com", true },
  { "bkentertainments.co.uk", true },
  { "bkhayes.com", true },
  { "bkhpilates.co.uk", true },
  { "bkkposn.com", true },
  { "bklaindia.com", true },
  { "bkositspartytime.co.uk", true },
  { "bkt.to", true },
  { "bl00.se", true },
  { "bl4ckb0x.biz", true },
  { "bl4ckb0x.com", true },
  { "bl4ckb0x.de", true },
  { "bl4ckb0x.eu", true },
  { "bl4ckb0x.info", true },
  { "bl4ckb0x.net", true },
  { "bl4ckb0x.org", true },
  { "blaauwgeers.pro", true },
  { "blabber.im", true },
  { "blablacar.co.uk", true },
  { "blablacar.com", true },
  { "blablacar.com.tr", true },
  { "blablacar.com.ua", true },
  { "blablacar.de", true },
  { "blablacar.es", true },
  { "blablacar.fr", true },
  { "blablacar.hr", true },
  { "blablacar.hu", true },
  { "blablacar.in", true },
  { "blablacar.it", true },
  { "blablacar.mx", true },
  { "blablacar.nl", true },
  { "blablacar.pl", true },
  { "blablacar.pt", true },
  { "blablacar.ro", true },
  { "blablacar.rs", true },
  { "blablacar.ru", true },
  { "black-gay-porn.biz", true },
  { "black-holes.org", true },
  { "black-khat.com", true },
  { "black-mail.nl", true },
  { "black-raven.fr", true },
  { "black.dating", true },
  { "black.host", true },
  { "black1ce.com", true },
  { "blackandpony.de", true },
  { "blackbag.nl", true },
  { "blackbam.at", true },
  { "blackberryforums.be", true },
  { "blackbird-whitebird.com", true },
  { "blackboxconnections.com", true },
  { "blackcat.ca", true },
  { "blackcatinformatics.ca", true },
  { "blackcatinformatics.com", true },
  { "blackcountrymetalworks.co.uk", true },
  { "blackdown.de", true },
  { "blackdragoninc.org", true },
  { "blackedbyte.com", true },
  { "blackevent.be", true },
  { "blackfire.io", true },
  { "blackgamelp.de", true },
  { "blackgate.org", true },
  { "blackhat.dk", true },
  { "blackhelicopters.net", true },
  { "blackhillsinfosec.com", true },
  { "blackilli.de", true },
  { "blackislegroup.com", true },
  { "blackjackballroomcasino.info", true },
  { "blackl.net", true },
  { "blackmagicshaman.com", true },
  { "blackmonday.gr", true },
  { "blacknetwork.eu", true },
  { "blacknova.io", true },
  { "blackonion.com", true },
  { "blackpapermoon.de", true },
  { "blackpayment.ru", true },
  { "blackphoenix.de", true },
  { "blackroadphotography.de", true },
  { "blackroot.eu", true },
  { "blackscytheconsulting.com", true },
  { "blackseals.net", true },
  { "blacktown.eu", true },
  { "blackyau.cc", true },
  { "blackys-chamber.de", true },
  { "blaindalefarms.com", true },
  { "blaise.io", true },
  { "blakecoin.org", true },
  { "blakekhan.com", true },
  { "blakezone.com", true },
  { "blameomar.com", true },
  { "blancodent.com", true },
  { "blanket.technology", true },
  { "blasorchester-runkel.de", true },
  { "blastair.fr", true },
  { "blastentertainment.com.au", true },
  { "blastersklan.com", true },
  { "blastzoneentertainments.co.uk", true },
  { "blaudev.es", true },
  { "blayne.me", true },
  { "blayneallan.com", true },
  { "blazing.cz", true },
  { "blazor.nl", true },
  { "blblblblbl.fr", true },
  { "bleaching-tipps.de", true },
  { "blechbuexn.de", true },
  { "bleche-onlineshop.at", true },
  { "bleche-onlineshop.de", true },
  { "blechinger.io", true },
  { "blechschmidt.saarland", true },
  { "blenderinsider.com", true },
  { "blenderrecipereviews.com", true },
  { "blending.kr", true },
  { "blendle.com", true },
  { "blendle.nl", true },
  { "blendr.com", true },
  { "blendstudios.com", true },
  { "blenheimears.com", true },
  { "blenneros.net", false },
  { "blessedguy.com", true },
  { "blewebprojects.com", true },
  { "blichmann.eu", true },
  { "blideobames.com", true },
  { "blidz.com", true },
  { "blieque.co.uk", true },
  { "bliesekow.net", true },
  { "blikk.no", true },
  { "blikund.swedbank.se", true },
  { "blinder.com.co", true },
  { "blindpigandtheacorn.com", true },
  { "blingsparkleshine.com", true },
  { "blingwang.cn", true },
  { "blink-security.com", true },
  { "blinkdrivex.com", true },
  { "blinking.link", true },
  { "blio.tk", true },
  { "blip.website", true },
  { "blissjoe.com", true },
  { "blissplan.com", true },
  { "blivawesome.dk", true },
  { "blivvektor.dk", true },
  { "blizhost.com", true },
  { "blizhost.com.br", true },
  { "blizora.com", true },
  { "blkbx.eu", true },
  { "blm.gov", true },
  { "blo-melchiorshausen.de", true },
  { "blobemoji.com", true },
  { "blobfolio.com", true },
  { "blobs.gg", true },
  { "blocher.ch", true },
  { "blochoestergaard.com", true },
  { "block-this.com", true },
  { "block65.com", true },
  { "blockchain.com", true },
  { "blockchain.info", true },
  { "blockchainced.com", true },
  { "blockchaindaigakko.jp", true },
  { "blockchainwhiz.com", true },
  { "blockcheck.network", true },
  { "blockclique.io", true },
  { "blockedyourcar.com", true },
  { "blockedyourcar.net", true },
  { "blockedyourcar.org", true },
  { "blockified.io", true },
  { "blockmetry.com", true },
  { "blocknodes.live", true },
  { "blockstream.com", true },
  { "blockxit.de", true },
  { "bloemenbesteld.nl", true },
  { "bloemendal.me", true },
  { "blog-grupom2.es", true },
  { "blog.gov.uk", true },
  { "blog.linode.com", false },
  { "blog.lookout.com", false },
  { "blogaid.net", true },
  { "bloganchoi.com", true },
  { "blogarts.net", true },
  { "blogbooker.com", true },
  { "blogcast.com", true },
  { "blogconcours.net", true },
  { "blogdelosjuguetes.com", true },
  { "blogdieconomia.it", true },
  { "blogdimoda.com", true },
  { "blogdimotori.it", true },
  { "blogexpert.ca", true },
  { "bloggermumofthreeboys.com", true },
  { "blogging-life.com", true },
  { "bloginbeeld.nl", true },
  { "blogit.fi", true },
  { "bloglines.co.za", true },
  { "bloglogistics.com", true },
  { "bloglyric.com", true },
  { "blognr.com", true },
  { "blogom.at", true },
  { "blogpentrusuflet.ro", true },
  { "blogreen.org", true },
  { "blogsdna.com", true },
  { "blogthedayaway.com", true },
  { "blogtroterzy.pl", true },
  { "blok56.nl", true },
  { "blokmy.com", true },
  { "bloodhunt.pl", true },
  { "bloodsports.org", true },
  { "bloody.pw", true },
  { "bloom-avenue.com", true },
  { "bloom.sh", true },
  { "blopezabogado.es", true },
  { "bltc.co.uk", true },
  { "bltc.com", true },
  { "bltc.net", true },
  { "bltc.org", true },
  { "bltc.org.uk", true },
  { "bltdirect.com", true },
  { "blubberladen.de", true },
  { "blubop.fr", true },
  { "blue-gmbh-erfahrungen.de", true },
  { "blue-gmbh.de", true },
  { "blue-leaf81.net", true },
  { "blue42.net", true },
  { "blueangel.org.tw", true },
  { "bluebahari.gq", true },
  { "blueblou.com", true },
  { "bluecanvas.io", true },
  { "bluechilli.com", true },
  { "bluecrazii.nl", true },
  { "blued.moe", true },
  { "bluedeck.org", true },
  { "blueflare.org", true },
  { "bluefrag.com", true },
  { "bluefuzz.nl", true },
  { "bluehelixmusic.com", true },
  { "blueimp.net", true },
  { "bluekrypt.com", true },
  { "blueliquiddesigns.com.au", true },
  { "bluemarmalade.co.uk", true },
  { "bluemeda.web.id", true },
  { "bluemoonroleplaying.com", true },
  { "bluemosh.com", true },
  { "bluemtnrentalmanagement.ca", true },
  { "bluenote9.com", true },
  { "blueoakart.com", true },
  { "blueperil.de", true },
  { "blueplumbinggroup.com.au", true },
  { "bluepoint.one", true },
  { "bluepostbox.de", true },
  { "blueprintrealtytn.com", true },
  { "bluepromocode.com", true },
  { "bluerootsmarketing.com", true },
  { "blueskycoverage.com", true },
  { "blueskydigitalstrategy.com", true },
  { "bluestardiabetes.com", true },
  { "bluesuncamping.com", true },
  { "bluesunhotels.com", true },
  { "blueswandaily.com", true },
  { "bluetexservice.com", true },
  { "bluewavewebdesign.com", true },
  { "bluewizardart.net", true },
  { "bluex.im", true },
  { "bluex.info", true },
  { "bluex.net", true },
  { "bluex.org", true },
  { "blueyed.eu", true },
  { "bluffplumber.co.za", true },
  { "blui.cf", true },
  { "blui.xyz", true },
  { "bluiandaj.ml", true },
  { "bluicraft.tk", true },
  { "bluimedia.com", true },
  { "bluinet.com", true },
  { "blumenfeldart.com", true },
  { "blumiges-fischbachtal.de", false },
  { "bluntandsnakes.com", true },
  { "blupig.net", true },
  { "bluproducts.com.es", true },
  { "blurringexistence.net", true },
  { "blusens.com", true },
  { "blusmurf.net", true },
  { "blutopia.xyz", false },
  { "blyat.science", true },
  { "blyth.me.uk", true },
  { "blzrk.com", true },
  { "bm-immo.ch", true },
  { "bmhglobal.com.au", true },
  { "bminton.is-a-geek.net", true },
  { "bmk-kramsach.at", true },
  { "bmoattachments.org", true },
  { "bmone.net", true },
  { "bmros.com.ar", true },
  { "bmw-motorradclub-seefeld.de", true },
  { "bmwcolors.com", true },
  { "bn1digital.co.uk", true },
  { "bn4t.me", true },
  { "bnbsinflatablehire.co.uk", true },
  { "bnck.me", true },
  { "bngs.pl", true },
  { "bnin.org", true },
  { "bnjscastles.co.uk", true },
  { "bnstree.com", true },
  { "bnty.net", true },
  { "bnusd.cn", true },
  { "bnzblowermotors.com", true },
  { "bo4tracker.com", true },
  { "boardgamegeeks.de", true },
  { "boards.ie", true },
  { "boardspot.com", true },
  { "boat-engines.eu", true },
  { "boattrader.com", true },
  { "boattrader.com.au", true },
  { "bobaly.es", true },
  { "bobancoamigo.com", true },
  { "bobasy.pl", true },
  { "bobazar.com", true },
  { "bobbyhensley.com", true },
  { "bobcopeland.com", true },
  { "bobep.ru", true },
  { "bobkidbob.com", true },
  { "bobkoetsier.nl", true },
  { "bobnbouncedublin.ie", true },
  { "bobobox.net", true },
  { "bobstronomie.fr", true },
  { "bocamo.it", true },
  { "boccabell.com", true },
  { "bochantinobgyn.com", true },
  { "bochs.info", true },
  { "bockenauer.at", true },
  { "bocreation.fr", true },
  { "bodemplaten4x4.nl", true },
  { "bodhi.fedoraproject.org", true },
  { "bodis.nl", true },
  { "bodsch.com", true },
  { "bodybuildingworld.com", true },
  { "bodyconshop.com", true },
  { "bodygearguide.com", true },
  { "bodymusclejournal.com", true },
  { "bodypainter.pl", true },
  { "bodypainting.waw.pl", true },
  { "bodyshopnews.net", true },
  { "bodyworksautorebuild.com", true },
  { "boeddhashop.nl", true },
  { "boekenlegger.nl", true },
  { "boem.gov", true },
  { "boernecancerfonden.dk", true },
  { "bogdancornianu.com", true },
  { "bogdanepureanu.ro", true },
  { "bogner.sh", true },
  { "bogosity.se", true },
  { "bohan.co", true },
  { "bohramt.de", true },
  { "boimmobilier.ch", true },
  { "boincstats.com", true },
  { "boiseonlinemall.com", true },
  { "boisewaldorf.org", true },
  { "bokadoktorn-test.net", true },
  { "bokadoktorn.se", true },
  { "boke112.com", true },
  { "bokka.com", true },
  { "bokkeriders.com", true },
  { "bokutake.com", true },
  { "bol.io", true },
  { "boldmediagroup.com", true },
  { "boldt-metallbau.de", true },
  { "bolektro.de", true },
  { "boleyn.su", true },
  { "bolgarka.kz", true },
  { "bolgarnyelv.hu", true },
  { "bolivarfm.com.ve", true },
  { "bologna-disinfestazioni.it", true },
  { "bolovegna.it", true },
  { "bolt.cm", false },
  { "boltbeat.com", true },
  { "bolte.org", true },
  { "boltenergy.ca", true },
  { "boltmobile.ca", true },
  { "bomb.codes", true },
  { "bombe-lacrymogene.fr", true },
  { "bomboniere.roma.it", true },
  { "bomhard.de", true },
  { "bonaccorso.eu", true },
  { "bonami.cz", true },
  { "bonami.hu", true },
  { "bonami.pl", true },
  { "bonami.ro", true },
  { "bonami.sk", true },
  { "bonawehouse.co.uk", true },
  { "bonbonmania.com", true },
  { "bondagefetishstore.com", true },
  { "bondarenko.dn.ua", true },
  { "bondingwithbaby.ca", true },
  { "bondlink.com", true },
  { "bondskampeerder.nl", true },
  { "bonebunny.de", true },
  { "boneko.de", true },
  { "bonesserver.com", true },
  { "bonfi.net", true },
  { "bongbabyhouse.vn", true },
  { "bongloy.com", true },
  { "bongo.cat", true },
  { "bonifacius.be", true },
  { "bonito.pl", true },
  { "bonnant-associes.ch", true },
  { "bonnant-partners.ch", true },
  { "bonniecoloring.com", true },
  { "bonniedraw.com", true },
  { "bonniekitchen.com", true },
  { "bonnieradvocaten.nl", true },
  { "bonnsustainabilityportal.de", true },
  { "bonnyprints.at", true },
  { "bonnyprints.ch", true },
  { "bonnyprints.es", true },
  { "bonnyprints.fr", true },
  { "bonprix.co.uk", true },
  { "bonrecipe.com", true },
  { "bonsaimedia.nl", true },
  { "bonsi.net", true },
  { "bonus.ca", true },
  { "bonus.net.nz", true },
  { "bonus.pl", true },
  { "bonussource.com", true },
  { "bonux.co", true },
  { "boodmo.com", true },
  { "boogiebouncecastles.co.uk", true },
  { "book-in-hotel.com", true },
  { "booker.ly", true },
  { "bookingapp.be", true },
  { "bookingapp.nl", true },
  { "bookingslog.com", true },
  { "bookingworldspeakers.com", true },
  { "bookluk.com", true },
  { "bookmein.in", true },
  { "bookofdenim.com", true },
  { "booksearch.jp", true },
  { "bookshopofindia.com", true },
  { "booksinthefridge.at", true },
  { "booksouthafrica.travel", true },
  { "booktoan.com", true },
  { "booktracker-org.appspot.com", true },
  { "bookwave.art", true },
  { "bookzaga.com", true },
  { "bool.be", true },
  { "boombv.com", false },
  { "boomersurf.com", true },
  { "boomshelf.com", true },
  { "boomshelf.org", true },
  { "boonbox.com", true },
  { "booox.cc", true },
  { "booox.info", true },
  { "booox.net", true },
  { "booox.org", true },
  { "boop.gq", true },
  { "boop.pro", true },
  { "booplab.com", true },
  { "booquiz.com", true },
  { "boosinflatablegames.co.uk", true },
  { "boosman.nu", true },
  { "boosmanpoolservice.com", true },
  { "boost.fyi", true },
  { "boost.ink", true },
  { "boothlabs.me", true },
  { "bootjp.me", false },
  { "bootsschule-weiss.de", true },
  { "bopiweb.com", true },
  { "bopp.org", true },
  { "borahan.net", true },
  { "boran.cl", true },
  { "borchers.ninja", true },
  { "bordadoenpedreria.com", true },
  { "bordes.me", true },
  { "boredhackers.com", true },
  { "boreo.si", true },
  { "borg.cloud", true },
  { "borgodigatteraia.it", true },
  { "boringsmith.com", true },
  { "borisenko.by", true },
  { "borja.io", true },
  { "born2bounce.co.uk", true },
  { "bornandgrazed.com", true },
  { "borneodictionary.com", true },
  { "bornfiber.dk", true },
  { "bornhack.dk", true },
  { "borowski.pw", true },
  { "borrelpartybus.nl", true },
  { "borysek.net", true },
  { "borysenko.se", true },
  { "bosabosa.org", true },
  { "boscoyacht.ch", true },
  { "boskeopolis-stories.com", true },
  { "boss.az", true },
  { "bostadsportal.se", true },
  { "bostonadvisors.com", true },
  { "bostonaoii.com", true },
  { "bosufitness.cz", true },
  { "bosun.io", true },
  { "bot-manager.pl", true },
  { "botealis.ch", true },
  { "botezdepoveste.ro", true },
  { "botguard.net", true },
  { "bothellwaygarage.net", true },
  { "botmastery.com", true },
  { "botoes-primor.pt", true },
  { "botox.bz", true },
  { "botserver.de", true },
  { "bottaerisposta.net", true },
  { "bottineauneighborhood.org", true },
  { "bottinquebec.com", true },
  { "bottke.berlin", true },
  { "bottledstories.de", true },
  { "bou.cloud", true },
  { "bou.ke", true },
  { "bou.lt", true },
  { "bouah.net", true },
  { "bouchard-mathieux.com", true },
  { "bouchonville-knifemaker.com", true },
  { "bouckaert-usedcars.be", true },
  { "boudah.pl", true },
  { "boukoubengo.com", true },
  { "bouldercolorado.gov", true },
  { "boulderlibrary.org", true },
  { "boulderswap.com", true },
  { "boulzicourt.fr", true },
  { "bounce-a-mania.co.uk", true },
  { "bounce-a-roo.co.uk", true },
  { "bounce-abouts.com", true },
  { "bounce-n-go.co.uk", true },
  { "bounce-on.co.uk", true },
  { "bounce-r-us.co.uk", true },
  { "bounce-xtreme.co.uk", true },
  { "bounce4fun.co.uk", true },
  { "bounce4fun.ie", true },
  { "bounce4kidz.com", true },
  { "bounce4less.ie", true },
  { "bouncea-bout.com", true },
  { "bounceaboutandplay.co.uk", true },
  { "bounceaboutnewark.co.uk", true },
  { "bounceaboutsussex.co.uk", true },
  { "bouncealotcastlehire.co.uk", true },
  { "bouncealotnorthwest.co.uk", true },
  { "bounceandwobble.co.uk", true },
  { "bounceapp.com", true },
  { "bouncearoundevents.co.uk", true },
  { "bouncearoundsheffield.co.uk", true },
  { "bounceawaycastles.com", true },
  { "bouncebackcastles.co.uk", true },
  { "bouncebookings.com.au", true },
  { "bouncecrazy.ie", true },
  { "bouncejumpboston.co.uk", true },
  { "bouncekingdom.co.uk", true },
  { "bouncemaniaevents.co.uk", true },
  { "bouncemaniainflatables.co.uk", true },
  { "bouncemonkeys.co.uk", true },
  { "bouncenortheast.co.uk", true },
  { "bouncenpaint.co.uk", true },
  { "bouncepartycastles.com", true },
  { "bounceroosevents.co.uk", true },
  { "bouncers-bouncycastlehire.co.uk", true },
  { "bouncesouthwales.co.uk", true },
  { "bouncesquad.co.uk", true },
  { "bouncetasticuk.co.uk", true },
  { "bouncetheparty.co.uk", true },
  { "bounceunlimited.co.uk", true },
  { "bouncewrightcastles.co.uk", true },
  { "bouncincastles.co.uk", true },
  { "bouncing-bugs.co.uk", true },
  { "bouncingbairnsinflatables.co.uk", true },
  { "bouncingbeansinflatables.co.uk", true },
  { "bouncingbobsinflatables.co.uk", true },
  { "bouncingbuddiesleicester.co.uk", true },
  { "bouncinghigher.co.uk", true },
  { "bouncingscotland.com", true },
  { "bouncourseplanner.net", true },
  { "bouncy-castles-surrey.co.uk", true },
  { "bouncybaileys.co.uk", true },
  { "bouncyball.eu", true },
  { "bouncyballs.org", true },
  { "bouncyballscastles.co.uk", true },
  { "bouncybouncyboocastlehire.co.uk", true },
  { "bouncycastle.net.au", true },
  { "bouncycastlehire-norwich.com", true },
  { "bouncycastlehire-sheffield.co.uk", true },
  { "bouncycastlehire.co.uk", true },
  { "bouncycastlehireauckland.co.nz", true },
  { "bouncycastlehirebarnstaple.co.uk", true },
  { "bouncycastlehirebexley.co.uk", true },
  { "bouncycastlehirechelmsford.org.uk", true },
  { "bouncycastlehirehull.co.uk", true },
  { "bouncycastlehireinglasgow.co.uk", true },
  { "bouncycastlehirelouth.co.uk", true },
  { "bouncycastlehiremalvern.co.uk", true },
  { "bouncycastlehireoldham.co.uk", true },
  { "bouncycastlehirestroud.co.uk", true },
  { "bouncycastlehiresurrey.co.uk", true },
  { "bouncycastlehiretameside.co.uk", true },
  { "bouncycastlehirewinchester.co.uk", true },
  { "bouncycastleman.co.uk", true },
  { "bouncycastlemangloucestershire.co.uk", true },
  { "bouncycastleparade.com", true },
  { "bouncycastlesgalway.com", true },
  { "bouncycastleshire.co.uk", true },
  { "bouncycastleshireleeds.co.uk", true },
  { "bouncycastlesin.co.uk", true },
  { "bouncycastlesinderby.co.uk", true },
  { "bouncycastlesinleeds.co.uk", true },
  { "bouncycastlesisleofwight.co.uk", true },
  { "bouncycastlesmonaghan.com", true },
  { "bouncycastlessheerness.co.uk", true },
  { "bouncydays.co.uk", true },
  { "bouncyfeet.co.uk", true },
  { "bouncygiggles.com.au", true },
  { "bouncyhigher.co.uk", true },
  { "bouncyhousecastlehire.co.uk", true },
  { "bouncykingdom.co.uk", true },
  { "bouncykings.co.uk", true },
  { "bouncykingsnortheast.co.uk", true },
  { "bouncymacs.co.uk", true },
  { "bouncyrainbows.co.uk", true },
  { "bouncytime.co.uk", true },
  { "bouncywouncy.co.uk", true },
  { "bound2bounce.co.uk", true },
  { "boundarybrighton.com", true },
  { "bountyfactory.io", true },
  { "bourasse.fr", true },
  { "bourdon.fr.eu.org", true },
  { "bourgeoisdoorco.com", true },
  { "bournefun.co.uk", true },
  { "bourqu.in", true },
  { "bourseauxservices.com", true },
  { "boutiquedecanetas.com.br", true },
  { "boutiqueguenaelleverdin.com", true },
  { "boutoncoupdepoing.fr", true },
  { "bouw.live", true },
  { "bouzouada.com", true },
  { "bouzouks.net", true },
  { "bovenwebdesign.nl", true },
  { "bovworkplacepensions.com", true },
  { "bowdens.me", true },
  { "bowedwallcrackrepair.com", true },
  { "boweryandvine.com", true },
  { "bowlcake.fr", true },
  { "bowling.com", true },
  { "bownty.be", true },
  { "bownty.co.uk", true },
  { "bownty.de", true },
  { "bownty.dk", true },
  { "bownty.es", true },
  { "bownty.fr", true },
  { "bownty.it", true },
  { "bownty.nl", true },
  { "bowntycdn.net", true },
  { "bowtie.com.hk", true },
  { "boxcritters.wiki", true },
  { "boxcryptor.com", false },
  { "boxpeg.com", true },
  { "boxpirates.to", true },
  { "boxspringbett-160x200.de", true },
  { "boxvergelijker.nl", true },
  { "boyfriendcookbook.com", true },
  { "boyhost.cn", true },
  { "boyinglanguage.com", true },
  { "boypoint.de", true },
  { "boysontech.com", true },
  { "bozdoz.com", true },
  { "bozit.com.au", true },
  { "bozosbouncycastles.co.uk", true },
  { "bpa.gov", true },
  { "bpastudies.org", true },
  { "bphostels.com", true },
  { "bpo.ovh", true },
  { "bpol-forum.de", true },
  { "bpreguica.com.br", true },
  { "bps.vc", true },
  { "bpvboekje.nl", true },
  { "bqp.io", true },
  { "bqr.ch", true },
  { "bqtoolbox.com", true },
  { "br.search.yahoo.com", false },
  { "br3in.nl", false },
  { "br7.ru", true },
  { "braams.nl", true },
  { "braathe.no", true },
  { "bracho.xyz", true },
  { "brachotelborak.com", true },
  { "bradbrockmeyer.com", true },
  { "bradfordhottubhire.co.uk", true },
  { "bradfordmascots.co.uk", true },
  { "bradkovach.com", true },
  { "bradler.net", false },
  { "bradlinder.org", true },
  { "bradypatterson.com", true },
  { "braeunlich-gmbh.com", true },
  { "brage.info", true },
  { "brahmins.com", true },
  { "brahmstaedt.de", true },
  { "braiampeguero.xyz", true },
  { "brailsford.xyz", true },
  { "brain-force.ch", true },
  { "brainball.fr", true },
  { "brainfork.org", true },
  { "brainhub.nl", true },
  { "brainserve.ch", true },
  { "brainserve.com", true },
  { "brainserve.swiss", true },
  { "brainsik.net", true },
  { "brainster.co", true },
  { "braintreegateway.com", true },
  { "brainvoyagermusic.com", true },
  { "brainwav.es", true },
  { "brainwork.space", true },
  { "brainyapp.net", true },
  { "braithwaites.ltd", true },
  { "brakemanpro.com", true },
  { "brakpanplumber24-7.co.za", true },
  { "bralnik.com", true },
  { "brambogaerts.nl", true },
  { "bramhallsamusements.com", true },
  { "brammingfys.dk", true },
  { "bramstaps.nl", true },
  { "bramvanaken.be", true },
  { "bramygrozy.pl", true },
  { "bran.land", true },
  { "branch-bookkeeper.com", true },
  { "branchtrack.com", true },
  { "brandand.co.uk", true },
  { "brandbil.dk", true },
  { "brandcodestyle.com", true },
  { "brandingclic.com", true },
  { "brandingclick.com", true },
  { "brandondivorcelawyer.com", true },
  { "brandongomez.me", true },
  { "brandonhaynesmd.com", true },
  { "brandonhubbard.com", true },
  { "brandonlui.com", true },
  { "brandonwalker.me", true },
  { "brandrocket.dk", true },
  { "brandstead.com", true },
  { "brandtrapselfie.nl", true },
  { "brandweerbarboek.nl", true },
  { "brandweerfraneker.nl", true },
  { "brandweertrainingen.nl", true },
  { "brandweeruitgeest.nl", true },
  { "brank.as", true },
  { "branno.org", true },
  { "branw.xyz", false },
  { "brasal.ma", true },
  { "brasalcosmetics.com", true },
  { "brashear.me", true },
  { "brasilbombas.com.br", true },
  { "brasildxn.com.br", true },
  { "brasileiro.ca", true },
  { "brasserie-mino.fr", true },
  { "brasspipedreams.org", true },
  { "bratislava-airport-taxi.com", true },
  { "bratteng.me", true },
  { "bratteng.xyz", true },
  { "bratvanov.com", true },
  { "brau-ingenieur.de", true },
  { "braudoktor.de", true },
  { "brauingenieur.de", true },
  { "braunsteinpc.com", true },
  { "braunwarth.info", true },
  { "brava.bg", true },
  { "brave-foods.ch", true },
  { "brave-foods.com", true },
  { "brave.com", true },
  { "bravebaby.com.au", true },
  { "bravehearts.org.au", true },
  { "braviskindenjeugd.nl", true },
  { "bravisziekenhuis.nl", false },
  { "bravor.pe", true },
  { "brazilian.dating", true },
  { "braziliex.com", true },
  { "brazillens.com", true },
  { "brazoriabar.org", true },
  { "brb.city", true },
  { "brck.nl", true },
  { "brd.ro", true },
  { "breadandlife.org", true },
  { "breadofgod.org", true },
  { "breakingtech.it", true },
  { "breakingvap.fr", true },
  { "breaky.de", true },
  { "breard.tf", true },
  { "breathedreamgo.com", true },
  { "breathingblanket.com", true },
  { "brecht.ch", true },
  { "breckle.com.ua", true },
  { "brecknell.biz", true },
  { "brecknell.com", true },
  { "brecknell.info", true },
  { "brecknell.name", true },
  { "brecknell.net", true },
  { "brecknell.org", true },
  { "breda.computer", true },
  { "bredvid.no", true },
  { "breest.net", true },
  { "breeyn.com", true },
  { "brefy.com", true },
  { "brege.org", true },
  { "breitband.bz.it", true },
  { "breizh.me", true },
  { "brejoc.com", true },
  { "brelahotelberulia.com", true },
  { "bremen-restaurants.de", true },
  { "bremerfriedensforum.de", true },
  { "brenbarnes.com", true },
  { "brenbarnes.com.au", true },
  { "brendanbatliner.com", true },
  { "brentacampbell.com", true },
  { "brentnewbury.com", true },
  { "bressier.fr", true },
  { "bretcarmichael.com", true },
  { "brettabel.com", true },
  { "brettcornwall.com", true },
  { "brettlawyer.com", true },
  { "bretzner.fr", true },
  { "brevboxar.se", true },
  { "brewercollinsleadership.com", true },
  { "brewsouth.com", true },
  { "brewspark.co", true },
  { "brewvo.com", true },
  { "breznet.com", true },
  { "brgins.com", true },
  { "brian-gordon.name", true },
  { "brianalaway.com", true },
  { "brianalawayconsulting.com", true },
  { "briandwells.com", true },
  { "brianfoshee.com", true },
  { "brianjohnson.co.za", true },
  { "brianlanders.us", true },
  { "brianroadifer.com", true },
  { "briansemrau.com", true },
  { "briansmith.org", true },
  { "briantkatch.com", true },
  { "brianwalther.com", true },
  { "brianwesaala.com", true },
  { "briarproject.org", true },
  { "brickftp.com", true },
  { "brickheroes.com", true },
  { "brickstreettrio.com", true },
  { "brickvortex.com", true },
  { "bricolajeux.ch", true },
  { "brid.gy", false },
  { "bridalshoes.com", true },
  { "bridgedirectoutreach.com", true },
  { "bridgeglobalmarketing.com", true },
  { "bridgehomeloans.com", true },
  { "bridgement.com", true },
  { "bridgingdirectory.com", true },
  { "bridholm.se", true },
  { "bridltaceng.com", true },
  { "brie.tech", true },
  { "briefassistant.com", true },
  { "briefhansa.de", true },
  { "briefvorlagen-papierformat.de", true },
  { "brier.me", true },
  { "briffoud.fr", true },
  { "brighouse-leisure.co.uk", true },
  { "brightday.bz", true },
  { "brightendofleasecleaning.com.au", true },
  { "brightonbank.com", true },
  { "brightonbouncycastles.net", true },
  { "brightonchilli.org.uk", true },
  { "brightonzhang.com", true },
  { "brightside.com", true },
  { "brightworkcreative.com", true },
  { "brigidaarie.com", true },
  { "brigitte.nyc", true },
  { "brilliantbouncyfun.co.uk", true },
  { "brilliantproductions.co.nz", true },
  { "brimspark.systems", true },
  { "brio-shop.ch", true },
  { "briograce.com.mx", true },
  { "brioukraine.store", true },
  { "brisbanelogistics.com.au", true },
  { "brisignshop.com.au", true },
  { "bristebein.com", true },
  { "bristolandwestonsuperbounce.com", true },
  { "britanniapandi.com", true },
  { "britelocate.com", true },
  { "britishbeef.com", true },
  { "britishbookmakers.co.uk", true },
  { "britishgroupsg.com", true },
  { "britishmeat.com", true },
  { "britishpearl.com", true },
  { "britishsciencefestival.org", true },
  { "britishscienceweek.org", true },
  { "britishsfaward.org", true },
  { "britishsnoring.co.uk", true },
  { "britneyclause.com", true },
  { "brittanyferriesnewsroom.com", true },
  { "britton-photography.com", true },
  { "brizawen.com", true },
  { "brk.st", true },
  { "brmsalescommunity.com", true },
  { "brn.by", true },
  { "brnojebozi.cz", true },
  { "bro.hk", true },
  { "broadbandnd.com", true },
  { "broadleft.org", true },
  { "broadsheet.com.au", true },
  { "brockmeyer.net", true },
  { "brockmeyer.org", true },
  { "brodowski.cc", true },
  { "brody.digital", true },
  { "brody.ninja", true },
  { "broersma.com", true },
  { "broeselei.at", true },
  { "brokenhands.io", true },
  { "brokernet.ie", false },
  { "brokervalues.com", true },
  { "brompton-cocktail.com", true },
  { "bronetb2b.com.br", true },
  { "bronevichok.ru", true },
  { "bronwynlewis.com", true },
  { "broodbesteld.nl", true },
  { "brooklyncosmetics.net", true },
  { "brooklynentdoc.com", true },
  { "brooklynrealestateblog.com", true },
  { "brookworth.com", true },
  { "brossmanit.com", true },
  { "brouillard.ch", true },
  { "brouskat.be", true },
  { "brouwerijdeblauweijsbeer.nl", true },
  { "brovelton.com", true },
  { "brownfieldstsc.org", true },
  { "brownforces.desi", true },
  { "brownforces.org", true },
  { "brownihc.com", true },
  { "browntowncountryclub.com", true },
  { "browsemycity.com", true },
  { "browserleaks.com", true },
  { "brrd.io", true },
  { "brring.com", true },
  { "bru6.de", true },
  { "brubank.com", true },
  { "brubankv1-staging.azurewebsites.net", true },
  { "brucekovner.com", true },
  { "brucemartin.net", true },
  { "brucemobile.de", false },
  { "bruck.me", true },
  { "bruckmuehler-kanu-club.de", true },
  { "bruckner.li", true },
  { "brudkista.nu", true },
  { "brudkista.se", true },
  { "brudkistan.nu", true },
  { "brudkistan.se", true },
  { "brueser-gmbh.de", true },
  { "brunetderochebrune.com", true },
  { "brunick.de", false },
  { "brunn.email", true },
  { "brunner.ninja", true },
  { "brunohenc.from.hr", true },
  { "brunoproduit.ch", true },
  { "brunoramos.com", true },
  { "brunoramos.org", true },
  { "brunosouza.org", true },
  { "brush.ninja", true },
  { "brushcreekyachts.com", true },
  { "bruun.co", true },
  { "bry.do", true },
  { "bryankaplan.com", true },
  { "bryanquigley.com", true },
  { "bryansmith.net", true },
  { "bryansmith.tech", true },
  { "bryantzheng.com", true },
  { "brycecanyon.net", true },
  { "brycecanyonnationalpark.com", true },
  { "bryggebladet.dk", true },
  { "brzy-svoji.cz", true },
  { "bs-network.net", true },
  { "bs-security.com", true },
  { "bs.sb", true },
  { "bs.to", true },
  { "bs12v.ru", true },
  { "bsa157.org", true },
  { "bsaft.ml", true },
  { "bsapack564.org", true },
  { "bsatroop794.org", true },
  { "bsc-rietz.at", true },
  { "bscc.support", true },
  { "bsd-box.net", true },
  { "bsdes.net", true },
  { "bsdfreak.dk", true },
  { "bsdracing.ca", true },
  { "bsdunix.xyz", true },
  { "bsee.gov", true },
  { "bserved.de", true },
  { "bsg.ro", true },
  { "bsgamanet.ro", true },
  { "bsgcredit.ro", true },
  { "bsidesf.com", true },
  { "bsidesf.org", true },
  { "bsidessf.com", true },
  { "bsimerch.com", true },
  { "bslim-e-boutique.com", true },
  { "bsmn.ga", true },
  { "bsmomo-api.com", true },
  { "bso-buitengewoon.nl", true },
  { "bsociabl.com", true },
  { "bsp-southpool.com", true },
  { "bstoked.net", true },
  { "bsw-solution.de", true },
  { "bt123.xyz", true },
  { "bt780.com", true },
  { "bta.lv", false },
  { "bta00.com", true },
  { "bta55.com", true },
  { "btcarmory.com", true },
  { "btcbolsa.com", true },
  { "btcpop.co", true },
  { "btine.tk", true },
  { "btio.pw", false },
  { "btmstore.com.br", true },
  { "btnissanparts.com", true },
  { "btorrent.xyz", true },
  { "btsapem.com", true },
  { "btshe.net", true },
  { "btsoft.eu", true },
  { "btsow.com", false },
  { "btt-39.com", true },
  { "btt-59.com", true },
  { "btt0303.com", true },
  { "btt1212.com", true },
  { "btt138g.com", true },
  { "btt2020.com", true },
  { "btt2121.com", true },
  { "btt213.com", true },
  { "btt217.com", true },
  { "btt219.com", true },
  { "btt225.com", true },
  { "btt256.com", true },
  { "btt3535.com", true },
  { "btt381g.com", true },
  { "btt529g.com", true },
  { "btt686.com", true },
  { "btt776.com", true },
  { "btt8.me", true },
  { "btt88.net", true },
  { "btt88818.com", true },
  { "btt891.com", true },
  { "btt8989a.com", true },
  { "btt907.com", true },
  { "btt9090.com", true },
  { "btt918.cn", true },
  { "btt945g.com", true },
  { "btt9797.com", true },
  { "btt9898.com", true },
  { "btta13.com", true },
  { "btta15.com", true },
  { "btta27.com", true },
  { "btta30.com", true },
  { "bttc.co.uk", true },
  { "btth.pl", true },
  { "btth.tv", true },
  { "bttna.com", true },
  { "bttorj45.com", true },
  { "bttt222.com", true },
  { "bttt333.com", true },
  { "bttt999.com", true },
  { "bttyulecheng0.com", true },
  { "bttyulecheng7.com", true },
  { "buayacorp.com", true },
  { "bubblegumblog.com", true },
  { "bubblespetspa.com", true },
  { "bubblin.io", true },
  { "bubblinghottubs.co.uk", true },
  { "bubblybouncers.co.uk", true },
  { "bubulazi.com", false },
  { "bubulazy.com", false },
  { "bucek.cz", true },
  { "buch-angucken.de", true },
  { "buchhandlungkilgus.de", true },
  { "buchwegweiser.com", true },
  { "buck-hydro.de", true },
  { "buckelewrealtygroup.com", true },
  { "bucketlist.co.ke", true },
  { "buckscountyobgyn.com", true },
  { "buckypaper.com", true },
  { "buddhismus.net", true },
  { "buddie5.com", true },
  { "buddlycrafts.com", true },
  { "buddycompany.net", true },
  { "buddyworks.net", true },
  { "budeanu.com", true },
  { "budger.nl", true },
  { "budget.gov", true },
  { "budgetalk.com", true },
  { "budgetcastlehire.co.uk", true },
  { "budgetlob.gov", true },
  { "budgetlovers.nl", true },
  { "budgiesballoons.com", true },
  { "budntod.com", true },
  { "budolangnau.ch", true },
  { "budolfs.de", true },
  { "bueltge.de", true },
  { "buena-vista.cz", true },
  { "buena.me", true },
  { "bueny.com", true },
  { "bueny.net", true },
  { "buerger-lenke.de", true },
  { "bueroplus.de", true },
  { "bueroschwarz.design", true },
  { "bueroshop24.de", true },
  { "buettgens.net", true },
  { "buffaloautomation.com", true },
  { "buffaloturf.com.au", true },
  { "bug.blue", true },
  { "bug.ee", true },
  { "bugcrowd.com", true },
  { "bugginslab.co.uk", true },
  { "bugs.chromium.org", true },
  { "bugsmashed.com", true },
  { "bugwie.com", true },
  { "bugzil.la", true },
  { "bugzilla.mozilla.org", true },
  { "build.chromium.org", true },
  { "buildbox.io", true },
  { "buildbytes.com", true },
  { "buildhoscaletraingi.com", true },
  { "buildiffuse.com", true },
  { "building-cost-estimators.com", true },
  { "buildingcostestimators.co.uk", true },
  { "builditfl.com", false },
  { "builditsolutions.net", true },
  { "buildkite.com", true },
  { "buildmorebuslanes.com", true },
  { "buildplease.com", true },
  { "buileo.com", true },
  { "builtory.my", true },
  { "builtvisible.com", true },
  { "builtwith.com", true },
  { "buissonchardin.fr", true },
  { "bukiskola.hu", true },
  { "bukivallalkozasok.hu", true },
  { "bukkenfan.jp", true },
  { "bukpcszerviz.hu", true },
  { "bulario.com", true },
  { "bulario.net", true },
  { "bularmas.com", true },
  { "bulgarianwine.com", true },
  { "bulk-pagerank-checker.com", true },
  { "bulkcandystore.com", true },
  { "bulkowespacerkowo.nl", true },
  { "bulktrade.de", true },
  { "bulktshirtsjohannesburg.co.za", true },
  { "bulkwholesalesweets.co.uk", true },
  { "bulldog-hosting.de", false },
  { "bulldoghire.co.uk", true },
  { "bulledair-savons.ch", true },
  { "bullettags.com", true },
  { "bullpendaily.com", true },
  { "bullshitmail.nl", true },
  { "bullterrier.nu", true },
  { "bulwarkcrypto.com", true },
  { "bulwarkhost.com", true },
  { "bund-von-theramore.de", true },
  { "bundespolizei-forum.de", true },
  { "bungee.pw", true },
  { "bungee.systems", true },
  { "bungeetaco.com", true },
  { "bunix.de", true },
  { "bunkyo-life.com", true },
  { "bunny-rabbits.com", true },
  { "bunny.parts", true },
  { "bunnycarenotes.com", true },
  { "bunnydiamond.de", true },
  { "bunnyvishal.com", true },
  { "bunq.love", true },
  { "bunzy.ca", true },
  { "buonventosbt.eu", true },
  { "bupropion.com", true },
  { "burakogun.com", true },
  { "burakogun.com.tr", true },
  { "burakogun.net", true },
  { "burakogun.net.tr", true },
  { "burakogun.org", true },
  { "burcevo.info", true },
  { "burfordbedandbreakfast.co.uk", true },
  { "burg-hohnstein.com", true },
  { "burgernet.nl", true },
  { "burgers.io", true },
  { "burghardt.pl", true },
  { "buri.be", false },
  { "burialinsurancenetwork.com", true },
  { "burienergy.com", true },
  { "burke.services", true },
  { "burkhardt.at", true },
  { "burlapsac.ca", true },
  { "burncorp.org", true },
  { "burnerfitness.com", true },
  { "burnhamonseabouncycastles.co.uk", true },
  { "burningbird.net", true },
  { "burningflipside.com", false },
  { "burningmarket.de", true },
  { "burntfish.com", true },
  { "burnworks.com", true },
  { "buronwater.com", true },
  { "burotec-sarl.com", false },
  { "burr.is", true },
  { "bursaries-southafrica.co.za", true },
  { "burtplasticsurgery.com", true },
  { "burtrum.family", true },
  { "burtrum.me", true },
  { "burtrum.name", true },
  { "burtrum.org", true },
  { "burzcast.ro", true },
  { "burzmali.com", true },
  { "burzmedia.com", true },
  { "burzstudios.com", true },
  { "burzum.ch", true },
  { "buscandolosmejores.com", true },
  { "buscasimple.com", true },
  { "bushbaby.com", true },
  { "busindre.com", true },
  { "business-creators.ru", true },
  { "business-garden.com", true },
  { "business.facebook.com", false },
  { "business.gov", true },
  { "businesscentermarin.ch", true },
  { "businesscircle.com.my", true },
  { "businessesdirectory.eu", true },
  { "businessfactors.de", true },
  { "businessloanconnection.org", false },
  { "businessmadeeasypodcast.com", true },
  { "businessmarketingblog.org", true },
  { "businessplanexperts.ca", true },
  { "businesswebadmin.com", true },
  { "busit.be", true },
  { "busiteyiengelle.com", true },
  { "busold.ws", true },
  { "bustabit.com", true },
  { "bustadice.com", true },
  { "bustany.org", true },
  { "bustup-tips.com", true },
  { "busuttil.org.uk", true },
  { "butarque.es", true },
  { "buthowdoyoubuygroceries.com", true },
  { "butikvip.ru", true },
  { "butlercountyhistory.org", true },
  { "butlerfm.dk", true },
  { "butter.horse", true },
  { "butteramotors.com", true },
  { "buttonline.ch", true },
  { "buttonrun.com", true },
  { "butts-are.cool", true },
  { "butzies.ddnss.org", true },
  { "buurtgenotencollectief.nl", true },
  { "buurtpreventiefraneker.nl", true },
  { "buxum-communication.ch", true },
  { "buy-out.jp", true },
  { "buy2dollars.com", true },
  { "buyamerican.gov", true },
  { "buybike.shop", true },
  { "buycarpet.shop", true },
  { "buycbd.store", true },
  { "buycoins.top", true },
  { "buycook.shop", true },
  { "buydissertations.com", true },
  { "buyerdocs.com", true },
  { "buyessay.org", true },
  { "buyessays.net", true },
  { "buyhealth.shop", true },
  { "buyinginvestmentproperty.com", true },
  { "buyjewel.shop", true },
  { "buymindhack.com", true },
  { "buypapercheap.net", true },
  { "buyplussize.shop", true },
  { "buyprofessional.shop", true },
  { "buyritefairview.com", true },
  { "buyseo.store", true },
  { "buysuisse.shop", true },
  { "buytermpaper.com", true },
  { "buywine.shop", true },
  { "buziaczki.pl", true },
  { "buzz.tools", true },
  { "buzzconf.io", true },
  { "buzzcontent.com", true },
  { "buzzprint.it", true },
  { "bvbmedia.nl", true },
  { "bvionline.eu", true },
  { "bvisible.be", true },
  { "bvl.aero", true },
  { "bvv-europe.eu", true },
  { "bw.codes", true },
  { "bwanglab.com", true },
  { "bwcscorecard.org", true },
  { "bwe-seminare.de", true },
  { "bwfc.nl", true },
  { "bwgjms.com", true },
  { "bwgjms.net", true },
  { "bwgjms.org", true },
  { "bwh1.net", false },
  { "bwhbwh.com", true },
  { "bwhbwh.net", true },
  { "bwl-earth.club", true },
  { "bws16.de", true },
  { "bwserhoscaletrainaz.com", true },
  { "bx-n.de", true },
  { "bx49.cc", true },
  { "bxp40.at", true },
  { "by777.com", true },
  { "byange.pro", true },
  { "byatte.com", true },
  { "byeskille.no", true },
  { "bygningsregistrering.dk", true },
  { "byhe.me", true },
  { "byiu.info", false },
  { "byjuschennai.com", true },
  { "byken.cn", true },
  { "bymark.co", true },
  { "bymike.co", true },
  { "bynder.com", true },
  { "bynet.cz", true },
  { "bynumlaw.net", true },
  { "bypass.sh", true },
  { "bypetula.cz", true },
  { "byr.moe", true },
  { "byrko.cz", true },
  { "byronkg.us", true },
  { "byrtz.de", true },
  { "bytanchan.com", true },
  { "byte.nl", true },
  { "byte128.com", true },
  { "bytearts.net", false },
  { "bytebucket.org", true },
  { "bytecode.no", true },
  { "bytecrafter.com", true },
  { "bytecrafter.net", true },
  { "byteflies.com", true },
  { "bytegoing.com", true },
  { "bytejail.com", true },
  { "bytema.cz", true },
  { "bytema.eu", true },
  { "bytema.re", true },
  { "bytema.sk", true },
  { "bytemix.cloud", true },
  { "bytenoc.nl", true },
  { "bytepen.com", true },
  { "bytes.co", true },
  { "bytes.fyi", true },
  { "bytesatwork.de", true },
  { "byteshark.org", true },
  { "bytesign.de", true },
  { "bytesizedalex.com", true },
  { "bytesunlimited.com", true },
  { "bytesystems.com", true },
  { "byteterrace.com", true },
  { "bythen.cn", true },
  { "bythisverse.com", true },
  { "bytrain.net", true },
  { "bzh.tf", true },
  { "bziaks.xyz", true },
  { "bzsparks.com", false },
  { "bztech.com.br", true },
  { "bztraveler.com", true },
  { "bztraveler.net", true },
  { "bzv-fr.eu", true },
  { "c-aeroconsult.com", true },
  { "c-ma-copro.com", true },
  { "c-path.org", true },
  { "c-rom.fr", true },
  { "c-rtx.com", true },
  { "c-shock.org", true },
  { "c-webdesign.net", true },
  { "c-world.co.uk", true },
  { "c.cc", true },
  { "c00ke.com", true },
  { "c0rporation.com", true },
  { "c2design.it", true },
  { "c2lab.net", true },
  { "c2o-library.net", true },
  { "c3sign.de", false },
  { "c3vo.de", true },
  { "c3w.at", true },
  { "c3wien.at", true },
  { "c3woc.de", false },
  { "c4539.com", true },
  { "c4k3.net", true },
  { "c5197.co", true },
  { "c5h8no4na.net", true },
  { "c6729.co", true },
  { "c6729.com", true },
  { "c6957.co", true },
  { "c7dn.com", true },
  { "c8ms113.com", true },
  { "c9297.co", true },
  { "c9397.com", true },
  { "c9721.com", true },
  { "c9728.co", true },
  { "ca-key.de", true },
  { "ca.gparent.org", true },
  { "ca.search.yahoo.com", false },
  { "ca5.de", true },
  { "caarecord.org", true },
  { "caasd.org", true },
  { "cabaladada.org", true },
  { "cabarave.com", true },
  { "cabforum.org", true },
  { "cabineritten.nl", true },
  { "cabinet-bedin.com", true },
  { "cabinetfurnituree.com", true },
  { "cablemod.com", true },
  { "cablesandkits.com", true },
  { "cabotfinancial.co.uk", true },
  { "cabuna.hr", true },
  { "cacao-chocolate.com", true },
  { "cacao.supply", true },
  { "cacaolalina.com", true },
  { "cacaumidade.com.br", true },
  { "cacd.eu", true },
  { "caceis.bank", true },
  { "cachacacha.com", true },
  { "cachedview.nl", true },
  { "cachetur.no", true },
  { "cackette.com", true },
  { "cacr.pw", true },
  { "cad-noerdlingen.de", true },
  { "cadams.io", true },
  { "cadetsge.ch", true },
  { "cadmail.nl", true },
  { "cadman.pw", true },
  { "cadmanlaw.ca", true },
  { "cadmanlaw.com", true },
  { "cadooz.com", true },
  { "cadorama.fr", true },
  { "cadoth.net", true },
  { "cadra.nl", true },
  { "cadre.com", true },
  { "cadsys.net", true },
  { "cadusilva.com", true },
  { "caerus.ws", true },
  { "caesarkabalan.com", true },
  { "cafedupont.be", true },
  { "cafedupont.co.uk", true },
  { "cafedupont.de", true },
  { "cafedupont.nl", true },
  { "cafeimsueden.de", true },
  { "cafejulian.com", true },
  { "cafelandia.net", true },
  { "cafeobscura.nl", true },
  { "caferagazzi.de", true },
  { "cafericoy.com", true },
  { "cafermin.com", true },
  { "cafeterasbaratas.net", true },
  { "caffeinatedcode.com", true },
  { "caffeinefiend.org", true },
  { "cafled.org", true },
  { "cagalogluyayinevi.com", false },
  { "caglarcakici.com", true },
  { "caiben.org", true },
  { "caijunyi.net", false },
  { "cainhosting.com", false },
  { "caitcs.com", true },
  { "caizx.com", false },
  { "caja-pdf.es", true },
  { "cajio.ru", true },
  { "cajunuk.co.uk", true },
  { "cake-time.co.uk", true },
  { "cakearific.com", true },
  { "cakeoffencesact.uk", true },
  { "cakestart.net", true },
  { "caketoindia.com", true },
  { "cakingandbaking.com", true },
  { "cakirlarshipyard.com", true },
  { "cal9000.com", true },
  { "calaad.net", true },
  { "calabasaselectric.com", true },
  { "calabasaselectrical.com", true },
  { "calabasaselectrician.com", true },
  { "calabasasexteriorlighting.com", true },
  { "calabasaslandscapelighting.com", true },
  { "calabasaslighting.com", true },
  { "calabasasoutdoorlighting.com", true },
  { "calaborlawnews.com", true },
  { "calafont.cat", false },
  { "calc.pw", true },
  { "calcedge.com", true },
  { "calcinacci.com", true },
  { "calcoolator.pl", true },
  { "calculadoraconversor.com", true },
  { "calcularis.ch", true },
  { "calculateaspectratio.com", true },
  { "calculates.org", true },
  { "calculator-imt.com", true },
  { "calculator.tf", true },
  { "calcworkshop.com", true },
  { "caldoletto.com", true },
  { "caleb.cx", true },
  { "calebthompson.io", true },
  { "calehoo.com", true },
  { "calendar.cf", true },
  { "calendar.google.com", true },
  { "calendarr.com", true },
  { "calendarsnow.com", true },
  { "calendly.com", true },
  { "calenfil.com", true },
  { "caletka.cz", true },
  { "calgoty.com", true },
  { "calibreapp.com", true },
  { "calibso.net", true },
  { "caliderumba.com", true },
  { "californiawomensmedicalclinic.com", true },
  { "calixte-concept.fr", true },
  { "call-centervko.kz", true },
  { "call.me", true },
  { "callanan.nl", true },
  { "callantonia.com", true },
  { "callawayracing.se", false },
  { "callear.org", true },
  { "callerstrom.se", true },
  { "callfunc.com", true },
  { "callhub.io", true },
  { "callidus-vulpes.de", true },
  { "calltoar.ms", true },
  { "calltothepen.com", true },
  { "callumsilcock.com", true },
  { "callumsilcock.me", true },
  { "calluna.nl", true },
  { "calminteractive.fr", true },
  { "calmtech.com", true },
  { "calomel.org", true },
  { "calotte-academy.com", true },
  { "calrotaract.org", true },
  { "calvin.my", true },
  { "calvinallen.net", false },
  { "calyxengineers.com", true },
  { "calzadonline1-latam.com", true },
  { "calzadonline1.com", true },
  { "camara360grados.com", true },
  { "camaradivisas.com", true },
  { "camaras.uno", true },
  { "camarilloelectric.com", true },
  { "camarilloelectrical.com", true },
  { "camarilloexteriorlighting.com", true },
  { "camarillolandscapelighting.com", true },
  { "camarillolighting.com", true },
  { "camarillooutdoorlighting.com", true },
  { "camashop.de", true },
  { "camastowncar.com", true },
  { "cambier.org", true },
  { "cambiowatch.ch", true },
  { "cambodian.dating", true },
  { "cambreaconsulting.com", true },
  { "cambridge-examen.nl", true },
  { "cambridge-security.com", true },
  { "cambridgebouncers.co.uk", true },
  { "cambridgesecuritygroup.org", true },
  { "cambuslangharriers.org", true },
  { "camcapital.com", true },
  { "camconn.cc", true },
  { "camdenboneandjoint.com", true },
  { "camdesign.pl", true },
  { "camelforensics.com", true },
  { "camelservers.com", true },
  { "cameo-membership.uk", true },
  { "cameraviva.com.br", true },
  { "cameronthomson.racing", true },
  { "camerweb.es", true },
  { "camilomodzz.net", true },
  { "camisetasmalwee.com.br", true },
  { "camolist.com", true },
  { "camp-pleinsoleil.ch", true },
  { "camp.co.uk", true },
  { "campaign-ad.com", true },
  { "campaign.gov.uk", true },
  { "campaignagent.com.au", true },
  { "campaignhelpdesk.org", true },
  { "campaignwiki.org", true },
  { "campamentos.info", true },
  { "campbellapplianceheatingandair.com", true },
  { "campcambodia.org", true },
  { "campcanada.org", true },
  { "camperdays.de", true },
  { "camperlist.com", true },
  { "campermanaustralia.com", true },
  { "campertrailerfinance.com.au", true },
  { "camperverzekerd.nl", true },
  { "campfiretails.org", true },
  { "campgesher.com", true },
  { "camping-landes.com", true },
  { "camping-le-pasquier.com", true },
  { "camping-seilershof.de", true },
  { "campinghuntingshooting.com", true },
  { "campingshop.pl", true },
  { "campingskyhooks.com", true },
  { "campistry.net", true },
  { "campsoulfestival.com", true },
  { "campula.cz", true },
  { "campus-discounts.com", true },
  { "campus-finance.com", true },
  { "campusdrugprevention.gov", false },
  { "campusfit.co", true },
  { "campuswire.com", true },
  { "campvana.com", true },
  { "campwabashi.org", true },
  { "camshowdir.com", true },
  { "camshowdir.to", true },
  { "camshowhub.com", true },
  { "camshowhub.to", true },
  { "camshowstorage.com", true },
  { "camshowstorage.to", true },
  { "camshowverse.com", true },
  { "camshowverse.to", true },
  { "camsky.de", false },
  { "camzroofing.ca", true },
  { "canada-tourisme.ch", true },
  { "canadabread.com", false },
  { "canadalife.de", true },
  { "canadaradon.com", true },
  { "canadasmotorcycle.ca", true },
  { "canadian-nurse.com", true },
  { "canadian.dating", true },
  { "canadianatheists.ca", true },
  { "canadianatheists.com", true },
  { "canadianoutdoorequipment.com", true },
  { "canadiantouristboard.com", true },
  { "canal-onanismo.org", true },
  { "canalecontracting.com", true },
  { "canalsidehouse.be", true },
  { "canalsidehouse.com", true },
  { "canariculturacolor.com", true },
  { "canarymod.net", true },
  { "canavillage.net", true },
  { "canavillagepuntacana.com", true },
  { "canavillageresidences.com", true },
  { "canberraoutletcentre.com.au", true },
  { "cancerdata.nhs.uk", true },
  { "candaceplayforth.com", true },
  { "candelec.com", true },
  { "candeo-books.nl", true },
  { "candex.com", true },
  { "candguchocolat.com", true },
  { "candicecity.com", true },
  { "candidasa.com", true },
  { "candidateexperiencemarketing.nl", true },
  { "candidaturedunprix.com", true },
  { "candinya.com", true },
  { "candinya.me", true },
  { "cando.eu", true },
  { "cangku.in", true },
  { "cangku.moe", true },
  { "canglong.net", true },
  { "canhazip.com", true },
  { "canicaprice.com", true },
  { "canihavesome.coffee", true },
  { "caniuse.email", true },
  { "canker.org", true },
  { "canlidoviz.com", true },
  { "canmipai.com", true },
  { "cannabis-marijuana.com", true },
  { "cannabiscare.ca", true },
  { "cannabismd.com", true },
  { "cannacards.ca", true },
  { "cannaffiliate.com", true },
  { "cannahealth.com", true },
  { "cannoli.london", true },
  { "cannyfoxx.me", true },
  { "canoonic.se", true },
  { "canopycleaningmelbourne.com.au", true },
  { "canopytax.com", true },
  { "cant.at", true },
  { "cantatio.ch", true },
  { "canterbury.ws", true },
  { "canterburybouncycastlehire.co.uk", true },
  { "cantonroadjewelry.com", true },
  { "cantrack.com", true },
  { "canva-dev.com", true },
  { "canva.com", true },
  { "canx.org", true },
  { "canyonshoa.com", true },
  { "canyoupwn.me", true },
  { "cao.gov", true },
  { "cao.la", true },
  { "caoshan60.com", true },
  { "capachitos.cl", true },
  { "capacitacionyautoempleo.com", true },
  { "capacityproject.org", true },
  { "capbig.com", true },
  { "capeannpediatrics.com", true },
  { "capebretonpiper.com", true },
  { "capekeen.com", true },
  { "caph.info", true },
  { "caphane.com", true },
  { "capimlimaoflores.com.br", true },
  { "capitainebaggy.ch", true },
  { "capital-match.com", true },
  { "capitalcap.com", true },
  { "capitalcollections.org.uk", true },
  { "capitalfps.com", true },
  { "capitalibre.com", true },
  { "capitalism.party", true },
  { "capitalmediaventures.co.uk", true },
  { "capitalonecardservice.com", true },
  { "capitalp.jp", true },
  { "capitalquadatv.org.nz", true },
  { "capitolpathways.org", true },
  { "caplinbouncycastles.co.uk", true },
  { "capper.de", true },
  { "capriccio.to", true },
  { "caprichosdevicky.com", true },
  { "caps.is", true },
  { "capsogusto.com", true },
  { "capstansecurity.co.uk", true },
  { "capstansecurity.com", true },
  { "capstoneinsights.com", true },
  { "captain-dandelion.com", true },
  { "captainark.net", true },
  { "captainsfarm.in", true },
  { "captainsinn.com", true },
  { "captivationtheory.com", true },
  { "capturapp.com", false },
  { "capture-app.com", true },
  { "capuchinox.com", true },
  { "caputo.com", true },
  { "caputodesign.com", true },
  { "car-insurance-quotes.biz", true },
  { "car.info", true },
  { "car24.de", true },
  { "car24portal.de", true },
  { "caraccio.li", true },
  { "carassure.de", true },
  { "carauctionnetwork.com", true },
  { "carauctionsalabama.com", true },
  { "carauctionscarolina.com", true },
  { "carauctionsgeorgia.com", true },
  { "carauctionsillinois.com", true },
  { "caravanserail.info", true },
  { "carbon-designz.com", true },
  { "carbon-project.org", true },
  { "carbon.coop", true },
  { "carbon12.org", true },
  { "carbon12.software", true },
  { "carboneselectricosnettosl.info", false },
  { "carbonmade.com", false },
  { "carbono.uy", true },
  { "carbontv.com", true },
  { "carburetorcycleoi.com", true },
  { "carcloud.ch", true },
  { "card-cashing.com", true },
  { "cardano.eco", true },
  { "cardboard.cx", true },
  { "cardcaptorsakura.jp", true },
  { "carddreams.be", true },
  { "carddreams.de", true },
  { "carddreams.es", true },
  { "carddreams.nl", true },
  { "cardexchangesolutions.com", true },
  { "cardioc.ru", true },
  { "cardios.srv.br", true },
  { "cardranking.jp", true },
  { "cardrecovery.fr", true },
  { "cardsolutionsbh.com.br", true },
  { "cardxl.be", true },
  { "cardxl.de", true },
  { "cardxl.fr", true },
  { "cardxl.nl", true },
  { "care-spot.biz", true },
  { "care-spot.com", true },
  { "care-spot.info", true },
  { "care-spot.mobi", true },
  { "care-spot.net", true },
  { "care-spot.org", true },
  { "care-spot.us", true },
  { "care4all.com", true },
  { "careeapp.com", true },
  { "careeroptionscoach.com", true },
  { "careers.plus", true },
  { "carefour.nl", true },
  { "caremad.io", true },
  { "carepassport.com", true },
  { "carespot.biz", true },
  { "carespot.co", true },
  { "carespot.com", true },
  { "carespot.mobi", true },
  { "carespot.net", true },
  { "carespot.org", true },
  { "carespot.us", true },
  { "carespotexpress.com", true },
  { "carespotexpresshealthcare.com", true },
  { "carespottravelmedicine.com", true },
  { "carespottravelmedicine.mobi", true },
  { "carespoturgentcare.com", true },
  { "carespoturgentcare.info", true },
  { "carespoturgentcare.net", true },
  { "carespoturgentcare.org", true },
  { "carespoturgentcare.us", true },
  { "caretta.co.uk", true },
  { "careyshop.cn", true },
  { "carezone.com", false },
  { "carezzaperu.com", true },
  { "carfinancehelp.com", true },
  { "carfraemill.co.uk", true },
  { "cargobas.com", true },
  { "cargomaps.com", true },
  { "cargorestraintsystems.com.au", true },
  { "carhunters.cz", true },
  { "caribbean.dating", true },
  { "caribbeanexams.com", true },
  { "caribougrill.com", true },
  { "carigami.fr", true },
  { "caringladies.org", true },
  { "carinthia.eu", true },
  { "carisenda.com", true },
  { "carkeysanantonio.com", true },
  { "carlavitalesteticista.com", true },
  { "carlgo11.com", true },
  { "carlife-at.jp", true },
  { "carlili.fr", true },
  { "carlingfordapartments.com.au", true },
  { "carlinmack.com", true },
  { "carlislepassionplay.org", true },
  { "carlitoxxpro.com", true },
  { "carlmjohnson.net", false },
  { "carlo.mx", false },
  { "carlobiagi.de", true },
  { "carlocksmith--dallas.com", true },
  { "carlocksmithbaltimore.com", true },
  { "carlocksmithcarrollton.com", true },
  { "carlocksmithellicottcity.com", true },
  { "carlocksmithfallbrook.com", true },
  { "carlocksmithkey.com", true },
  { "carlocksmithlewisville.com", true },
  { "carlocksmithmesquite.com", true },
  { "carlocksmithtucson.com", true },
  { "carlosabarbamd.com", true },
  { "carlosfelic.io", true },
  { "carlosjeurissen.com", true },
  { "carlosjeurissen.nl", true },
  { "carlot-j.com", true },
  { "carls-fallout-4-guide.com", true },
  { "carmelglenane.com", true },
  { "carmelrise.co.uk", true },
  { "carnaticalifornia.com", true },
  { "carnet-du-voyageur.com", true },
  { "carnildo.com", true },
  { "caroes.be", true },
  { "caroffer.ch", true },
  { "carol-lambert.com", true },
  { "carolcappelletti.com", true },
  { "carolcestas.com", true },
  { "caroli.com", true },
  { "caroli.name", true },
  { "caroli.net", true },
  { "carolina.cz", true },
  { "carolinaclimatecontrolsc.com", true },
  { "carolinapainandspine.com", true },
  { "carolineeball.com", true },
  { "carolinehanania.com", true },
  { "carolynjoyce.com.au", true },
  { "carpetandhardwoodflooringpros.com", true },
  { "carpetcleaningtomball.com", true },
  { "carplus.net", true },
  { "carrando.com", true },
  { "carre-lutz.com", true },
  { "carriedin.com", true },
  { "carrierplatform.com", true },
  { "carringtonrealtygroup.com", true },
  { "carroattrezzimilanodaluiso.it", true },
  { "carroceriascarluis.com", true },
  { "cars4salecy.com", true },
  { "carshippingcarriers.com", true },
  { "carson-aviation-adventures.com", true },
  { "carson-matthews.co.uk", true },
  { "carsoug.com", true },
  { "carspneu.cz", true },
  { "carteirasedistintivos.com.br", true },
  { "cartelloni.roma.it", true },
  { "carterdan.net", true },
  { "carterstad.se", true },
  { "cartertonscouts.org.nz", true },
  { "cartesentreprises-unicef.fr", true },
  { "carthedral.com", true },
  { "cartierplan.ga", false },
  { "carto.la", true },
  { "cartongesso.roma.it", true },
  { "cartooncastles.ie", true },
  { "cartouche-deal.fr", true },
  { "cartouche24.eu", true },
  { "cartucce24.it", true },
  { "cartwrightrealestate.com", true },
  { "carusorealestate.com", true },
  { "carwellness-hinkelmann.de", true },
  { "casa-app.de", true },
  { "casa-due-pur.com", true },
  { "casa-due-pur.de", true },
  { "casa-due.com", true },
  { "casa-laguna.net", true },
  { "casa-lunch-break.de", true },
  { "casa-lunchbreak.de", true },
  { "casa-mea-inteligenta.ro", true },
  { "casaamor.ph", true },
  { "casaanastasia.ro", true },
  { "casabouquet.com", true },
  { "casacameo.com", false },
  { "casacazoleiro.com", true },
  { "casacochecurro.com", true },
  { "casacomcharme.com.br", true },
  { "casadasportasejanelas.com", true },
  { "casadoarbitro.com.br", true },
  { "casadopulpo.com", true },
  { "casadowifi.com.br", true },
  { "casaessencias.com.br", true },
  { "casalborgo.it", true },
  { "casalindamex.com", true },
  { "casalunchbreak.de", true },
  { "casamariposaspi.com", true },
  { "casapalla.com.br", true },
  { "casasuara.com", true },
  { "casbia.info", true },
  { "casbuijs.nl", true },
  { "casburggraaf.com", false },
  { "casc.cz", true },
  { "cascadesjobcorpscca.com", true },
  { "cascavelle.fr", true },
  { "cascavelle.nl", true },
  { "case-vacanza-salento.com", true },
  { "casecoverkeygi.com", true },
  { "casecurity.org", true },
  { "caseificio.roma.it", true },
  { "caseof.fr", true },
  { "caseplus-daem.de", true },
  { "cases.lu", true },
  { "caseycapitalpartners.com", true },
  { "cash-4x4.com", true },
  { "cashati.com", true },
  { "cashbackcow.us", true },
  { "cashbook.co.tz", true },
  { "cashbot.cz", true },
  { "cashfazz.com", true },
  { "cashlogic.ch", true },
  { "cashmaxtexas.com", true },
  { "cashplk.com", true },
  { "casian.ir", true },
  { "casino-cash-flow.su", true },
  { "casino-cashflow.ru", true },
  { "casino-online.info", true },
  { "casino-trio.com", true },
  { "casinobonuscodes.online", true },
  { "casinocashflow.ru", true },
  { "casinochecking.com", true },
  { "casinolegal.pt", true },
  { "casinolistings.com", true },
  { "casinomegaslotos.com", true },
  { "casinomucho.com", true },
  { "casinomucho.org", true },
  { "casinomucho.se", true },
  { "casinoonlinesicuri.com", true },
  { "casinoportugal.pt", true },
  { "casinorewards.info", true },
  { "casio-caisses-enregistreuses.fr", true },
  { "casirus.com", true },
  { "casjenprome.cz", true },
  { "caspar.ai", true },
  { "casperfirm.com", true },
  { "casperpanel.com", true },
  { "caspicards.com", true },
  { "cassimo.com", true },
  { "castbulletassoc.org", false },
  { "castelannenberg.com", true },
  { "casteloinformatica.com.br", true },
  { "castible.de", true },
  { "castle-engine.io", true },
  { "castlecapers.com.au", true },
  { "castlecms.io", true },
  { "castleking.net", true },
  { "castlekingdomstockport.co.uk", true },
  { "castlekingkent.co.uk", true },
  { "castlemail.io", true },
  { "castleparty.co.uk", true },
  { "castlepointanime.com", true },
  { "castles-in-the-sky.co.uk", true },
  { "castles4kidz.com", true },
  { "castles4rascalsiow.co.uk", true },
  { "castlesrus-kent.com", true },
  { "castleswa.com.au", true },
  { "casualgaming.no", true },
  { "casusgrillcaribbean.com", true },
  { "cat.net", true },
  { "cat73.org", true },
  { "catalog.beer", true },
  { "catalogobiblioteca.com", true },
  { "catalogoreina.com", true },
  { "catalogosvirtualesonline.com", true },
  { "catalyconv.com", true },
  { "catalystapp.co", true },
  { "catbold.space", true },
  { "catbox.moe", true },
  { "catbull.com", true },
  { "catburton.co.uk", true },
  { "catchers.cc", true },
  { "catchersgear.com", true },
  { "catchhimandkeephim.com", true },
  { "catchief.com", true },
  { "catchkol.com", true },
  { "catcoxx.de", true },
  { "catenacondos.com", true },
  { "catenariadiscos.com", true },
  { "catering-xanadu.cz", true },
  { "catfooddispensersreviews.com", true },
  { "catharinesomerville.com", true },
  { "catharisme.eu", true },
  { "catherinejf.com", true },
  { "cathiebrousse.com", true },
  { "catholic8964.org", true },
  { "catholics.dating", true },
  { "catholicteacherresources.com", true },
  { "cathosa.nl", true },
  { "cathouse.me", true },
  { "cathy.guru", true },
  { "cathy.website", true },
  { "cathyfitzpatrick.com", true },
  { "cathyjf.ca", true },
  { "cathyjf.com", true },
  { "cathyjf.net", true },
  { "cathyjf.org", true },
  { "cathyjfitzpatrick.com", true },
  { "cativa.net", true },
  { "catl.st", true },
  { "catlovingcare.com", true },
  { "catmoose.ca", true },
  { "catmoz.fr", true },
  { "cattivo.nl", false },
  { "catuniverse.org", true },
  { "catus.moe", true },
  { "catveteran.com", true },
  { "caughtredhanded.co.nz", true },
  { "caulfieldeastapartments.com.au", true },
  { "caulfieldracecourseapartments.com.au", true },
  { "causae-fincas.es", true },
  { "cav.ac", true },
  { "cavac.at", true },
  { "cavern.tv", true },
  { "cavzodiaco.com.br", true },
  { "caxalt.com", true },
  { "caylercapital.com", true },
  { "cazaviajes.es", true },
  { "cb-crochet.com", true },
  { "cb1388.com", true },
  { "cb1588.com", true },
  { "cbbank.com", true },
  { "cbc-hire.co.uk", true },
  { "cbcf.info", true },
  { "cbd.casa", true },
  { "cbd.supply", true },
  { "cbdcontact.eu", true },
  { "cbdev.de", true },
  { "cbdmarket.space", true },
  { "cbdoilcures.co", true },
  { "cbecrft.net", true },
  { "cbhq.net", true },
  { "cbin168.com", true },
  { "cbintermountainrealty.com", true },
  { "cbk-connect.com", true },
  { "cbr-xml-daily.ru", true },
  { "cbsdeheidevlinder.nl", true },
  { "cbw.sh", true },
  { "cc-customer.de", true },
  { "cc5197.co", true },
  { "cc6729.co", true },
  { "cc6729.com", true },
  { "cc6957.co", true },
  { "cc9297.co", true },
  { "cc9397.com", true },
  { "cc9721.com", true },
  { "cc9728.co", true },
  { "ccattestprep.com", true },
  { "ccavenue.com", true },
  { "ccc-ch.ch", true },
  { "ccc-cloud.de", true },
  { "cccwien.at", true },
  { "cceputnam360.com", true },
  { "ccgx.de", true },
  { "cclasabana.com.co", true },
  { "ccoooss.com", true },
  { "ccprwebsite.org", true },
  { "ccss-cces.com", true },
  { "cctvview.info", true },
  { "ccu.plus", true },
  { "cd-shopware.de", true },
  { "cd-sport.com", true },
  { "cd.search.yahoo.com", false },
  { "cd5k.net", true },
  { "cda-aigle.ch", true },
  { "cdasenegal.com", true },
  { "cdasiaonline.com", false },
  { "cdbf.ch", true },
  { "cdbtech.com", false },
  { "cdburnerxp.se", true },
  { "cdda.ch", true },
  { "cdepot.eu", true },
  { "cdkeykopen.com", true },
  { "cdkeyprices.com", true },
  { "cdkeyworld.de", true },
  { "cdn.ampproject.org", true },
  { "cdn6.de", true },
  { "cdncompanies.com", true },
  { "cdnjs.com", true },
  { "cdns.cloud", true },
  { "cdnsys.net", true },
  { "cdom.de", true },
  { "cdsdigital.de", true },
  { "cdshh.club", true },
  { "cdshining.com", true },
  { "cdu-gebhardshain.de", true },
  { "cdvl.org", true },
  { "ce-agentur.de", false },
  { "ce-pimkie.fr", true },
  { "ce-webdesign.de", true },
  { "ceanimalhealth.com", true },
  { "cebz.org", true },
  { "cecame.ch", true },
  { "ceciliacolombara.com", true },
  { "cecipu.gob.cl", true },
  { "cedarcitydining.com", true },
  { "cedarslodge.com", true },
  { "cedricbonhomme.org", true },
  { "cedriccassimo.ch", true },
  { "cedriccassimo.com", true },
  { "ceebee.com", true },
  { "cegss.org.gt", true },
  { "ceiphr.com", true },
  { "cejhon.cz", false },
  { "celcomhomefibre.com.my", true },
  { "cele.bi", true },
  { "celebmasta.com", true },
  { "celebrasianconference.com", true },
  { "celebrityhealthcritic.com", true },
  { "celebrityscope.net", true },
  { "celectro-pro.com", true },
  { "celestebonito.pt", true },
  { "celiendev.ch", true },
  { "celine-patisserie.fr", true },
  { "cell-lookup.com", true },
  { "cellartracker.com", true },
  { "cellebrite.com", true },
  { "celliberate.co.uk", true },
  { "cellsheet.me", true },
  { "celltek-server.de", false },
  { "celltesequ.com", true },
  { "celltick.com", true },
  { "celluliteorangeskin.com", true },
  { "celluliteremovaldiet.com", true },
  { "celti.ie.eu.org", true },
  { "celti.name", true },
  { "cementscience.com", true },
  { "cemeteriat.com", true },
  { "ceml.ch", true },
  { "cenatorium.pl", true },
  { "cendata.co.uk", true },
  { "cennelley.com", true },
  { "cennelly.com", true },
  { "censurfridns.dk", true },
  { "censurfridns.nu", true },
  { "censys.io", true },
  { "centa-am.com", true },
  { "centaur.de", true },
  { "centennialradon.com", true },
  { "centennialseptic.com", true },
  { "center-elite.ml", true },
  { "centermk.ru", true },
  { "centerpereezd.ru", false },
  { "centerperson.org", true },
  { "centerpoint.ovh", true },
  { "centio.bg", true },
  { "centos.cz", true },
  { "centos.tips", true },
  { "centralbank.ae", true },
  { "centralconvergence.com", true },
  { "centralebigmat.eu", true },
  { "centralegedimat.eu", true },
  { "centralfor.me", true },
  { "centralheating.hu", true },
  { "centralmarket.com", true },
  { "centralmissourifoundationrepair.com", true },
  { "centralpoint.be", false },
  { "centralpoint.nl", false },
  { "centralstatecu.org", true },
  { "centrationgame.com", true },
  { "centredaccueil.fr", true },
  { "centreoeil.ch", true },
  { "centrepointorguk-dev.azurewebsites.net", true },
  { "centrobill.com", true },
  { "centrodeesteticarecife.com", true },
  { "centroecuestrecastellar.com", true },
  { "centrojovencuenca.es", true },
  { "centrolavoro.org", true },
  { "centroperugia.gr", true },
  { "centrosocialferrel.pt", true },
  { "centrumhodinek.cz", true },
  { "centruvechisv.ro", true },
  { "centsi.io", true },
  { "centum.no", true },
  { "centura.de", true },
  { "centurialeonina.com", true },
  { "centurioninfosec.com", true },
  { "centurioninfosec.com.sg", true },
  { "centurioninfosec.hk", true },
  { "centurioninfosec.sg", true },
  { "centurionunderground.com", true },
  { "ceopedia.org", true },
  { "ceramica.roma.it", true },
  { "ceramixcoating.nl", true },
  { "ceramiya.com", true },
  { "cerastar.com", true },
  { "cerber.us", true },
  { "cerberis.com", true },
  { "cerberusinformatica.it", true },
  { "cerena-silver.ru", true },
  { "ceres-corp.org", true },
  { "cerivo.co.uk", true },
  { "cermak.photos", true },
  { "cernakova.eu", true },
  { "cerpus-course.com", true },
  { "cerrajeriaamericadelquindio.com", true },
  { "cerrajeriaenvillavicencio.com", true },
  { "cert.ee", true },
  { "cert.govt.nz", true },
  { "cert.or.id", true },
  { "certaintelligence.com", true },
  { "certbus.com", true },
  { "certcenter.com", true },
  { "certchannel.com", true },
  { "certevia.com", true },
  { "certfa.com", true },
  { "certible.com", true },
  { "certificatedetails.com", true },
  { "certificatespending.com", true },
  { "certificatetools.com", false },
  { "certificazioni-energetiche.it", true },
  { "certifiedfieldassociate.com", true },
  { "certifiednurses.org", true },
  { "certmonitor.com.au", true },
  { "certmonitor.net", true },
  { "certnazionale.it", true },
  { "certspotter.com", true },
  { "certspotter.org", true },
  { "cervejista.com", true },
  { "ces-ltd.co.uk", true },
  { "cesboard.com", true },
  { "cesdb.com", true },
  { "cesipagano.com", true },
  { "ceskepivnesety.sk", true },
  { "ceskepivnisety.cz", true },
  { "ceso-saco.com", true },
  { "cesobaly.cz", true },
  { "cestasedelicias.com.br", true },
  { "cetamol.com", true },
  { "ceu.edu", false },
  { "cevin.at", true },
  { "cevo.com.hr", true },
  { "cezdent.com", true },
  { "cf-ide.de", true },
  { "cfc-swc.gc.ca", true },
  { "cfda.gov", true },
  { "cfdcre5.org", true },
  { "cfh.com", true },
  { "cfigura.com", true },
  { "cflsystems.com", true },
  { "cfno.org", true },
  { "cfo.gov", true },
  { "cfpa-formation.fr", true },
  { "cfrq.ca", true },
  { "cfsh.tk", true },
  { "cftc.gov", true },
  { "cftcarouge.com", true },
  { "cfurl.cf", true },
  { "cfxdesign.com", true },
  { "cg-goerlitz.de", true },
  { "cg-systems.hu", true },
  { "cg.al", true },
  { "cg.search.yahoo.com", false },
  { "cgal.org", true },
  { "cgan.de", true },
  { "cgbassurances.ch", true },
  { "cgbilling.com", true },
  { "cgcookiemarkets.com", true },
  { "cgf-charcuterie.com", true },
  { "cgnparts.com", true },
  { "cgpe.com", true },
  { "cgsmart.com", true },
  { "cgurtner.ch", true },
  { "ch-laborit.fr", true },
  { "ch-sc.de", true },
  { "ch.bzh", true },
  { "ch.search.yahoo.com", false },
  { "ch47f.com", true },
  { "chabaudparfum.com", true },
  { "chabert-provence.fr", true },
  { "chabik.com", true },
  { "chad.ch", true },
  { "chadpugsley.com", true },
  { "chadstoneapartments.com.au", true },
  { "chaffeyconstruction.com", true },
  { "chaifeng.com", true },
  { "chainels.com", true },
  { "chaip.org", true },
  { "chairsgb.com", true },
  { "chaisystems.net", true },
  { "chaitanyapandit.com", true },
  { "chaletdemontagne.org", true },
  { "chaletmanager.com", true },
  { "chaletpierrot.ch", true },
  { "chaleur.com", true },
  { "chalker.io", true },
  { "challengeblog.org", true },
  { "challengeclothing.com.br", true },
  { "chambion.ch", true },
  { "chamicro.com", true },
  { "champdogs.co.uk", true },
  { "champdogs.com", true },
  { "champicreuse.fr", true },
  { "championcastles.ie", true },
  { "champions.co", true },
  { "championsofpowerfulliving.com", true },
  { "championweb.co.nz", true },
  { "championweb.com", true },
  { "championweb.com.au", true },
  { "championweb.com.sg", true },
  { "championweb.nz", true },
  { "championweb.sg", true },
  { "champonthis.de", true },
  { "chamsochoa.com", true },
  { "chancekorte.com", true },
  { "chanddriving.co.uk", true },
  { "chandr1000.ga", true },
  { "changecopyright.ru", true },
  { "changemywifipassword.com", true },
  { "changes.jp", true },
  { "changesfor.life", true },
  { "changethislater.com", true },
  { "channelsurf.tv", false },
  { "chantalguggenbuhl.ch", true },
  { "chanz.com", true },
  { "chaos-games.org", true },
  { "chaos-inc.de", true },
  { "chaos.run", true },
  { "chaoschemnitz.de", true },
  { "chaosdorf.de", true },
  { "chaosfield.at", true },
  { "chaoslab.org", true },
  { "chaospott.de", true },
  { "chaosriftgames.com", true },
  { "chaoswars.ddns.net", true },
  { "chaotichive.com", true },
  { "chaoticlaw.com", true },
  { "chapelfordbouncers.co.uk", true },
  { "chapiteauxduleman.fr", true },
  { "chaplain.co", true },
  { "charbonnel.eu", true },
  { "charcoal-se.org", true },
  { "charcoalvenice.com", true },
  { "charge.co", false },
  { "chargify.com", true },
  { "charisma.ai", true },
  { "charissadescande.com", true },
  { "charitylog.co.uk", true },
  { "charles-darwin.com", true },
  { "charlesbwise.com", true },
  { "charlespitonltd.com", true },
  { "charlesrogers.co.uk", true },
  { "charlesstover.com", true },
  { "charlestonfacialplastic.com", true },
  { "charlie4change.com", true },
  { "charliedillon.com", true },
  { "charliegarrod.com", true },
  { "charliehr.com", true },
  { "charlierogers.co.uk", true },
  { "charlierogers.com", true },
  { "charlotteomnes.com", true },
  { "charlottesvillegolfcommunities.com", true },
  { "charlottesvillehorsefarms.com", true },
  { "charlylou.de", true },
  { "charmander.me", true },
  { "charmanterelefant.at", true },
  { "charmingsaul.com", true },
  { "charmyadesara.com", true },
  { "charr.xyz", true },
  { "charset.org", true },
  { "charta-digitale-vernetzung.de", true },
  { "charteroak.org", true },
  { "chartkick.com", true },
  { "chartpen.com", true },
  { "chartsy.de", true },
  { "chartwellestate.com", true },
  { "charuru.moe", false },
  { "chascrazycreations.com", true },
  { "chasetrails.co.uk", true },
  { "chat-house-adell.com", true },
  { "chat-libera.org", true },
  { "chat-love.org", true },
  { "chat-porc.eu", true },
  { "chat-senza-registrazione.net", true },
  { "chat.cz", true },
  { "chat40.net", true },
  { "chatbelgie.eu", true },
  { "chatbots.systems", true },
  { "chatear.social", true },
  { "chateau-de-lisle.fr", true },
  { "chateaudestrainchamps.com", true },
  { "chateroids.com", true },
  { "chatfacile.org", true },
  { "chatforskning.no", true },
  { "chatgrape.com", true },
  { "chatitaly.org", true },
  { "chatnederland.eu", true },
  { "chatswoodprestige.com.au", true },
  { "chatsworthelectrical.com", true },
  { "chatt-gratis.net", true },
  { "chatt-gratis.org", true },
  { "chattanoogaface.com", true },
  { "chattergalerie.eu", true },
  { "chattergallery.com", true },
  { "chattersworld.nl", true },
  { "chatu.io", true },
  { "chatu.me", true },
  { "chatucomputers.com", true },
  { "chatxp.com", true },
  { "chatxsingle.net", true },
  { "chatxtutti.com", true },
  { "chatzimanolis.com", true },
  { "chatzimanolis.gr", true },
  { "chauffage-budget.fr", true },
  { "chaurocks.com", true },
  { "chaussenot.net", true },
  { "chavetaro.com", true },
  { "chaz6.com", true },
  { "chazalet.fr", true },
  { "chbk.co", true },
  { "chbs.me", true },
  { "chch.it", true },
  { "chcoc.gov", true },
  { "chcsct.com", true },
  { "chd-expert.fr", true },
  { "cheap-colleges.com", true },
  { "cheapcaribbean.com", true },
  { "cheapessay.net", true },
  { "cheapestgamecards.at", true },
  { "cheapestgamecards.be", true },
  { "cheapestgamecards.co.uk", true },
  { "cheapestgamecards.com", true },
  { "cheapestgamecards.de", true },
  { "cheapestgamecards.fi", true },
  { "cheapestgamecards.fr", true },
  { "cheapestgamecards.nl", true },
  { "cheapestgamecards.no", true },
  { "cheapestgamecards.se", true },
  { "cheapgeekts.com", false },
  { "cheapgoa.com", true },
  { "cheapiesystems.com", true },
  { "cheapticket.in", true },
  { "cheapwritinghelp.com", true },
  { "cheapwritingservice.com", true },
  { "cheatengine.pro", true },
  { "cheatsupreme.com", false },
  { "check.torproject.org", false },
  { "checkandreportlive.com", true },
  { "checkblau.de", true },
  { "checkecert.nl", true },
  { "checkjelinkje.nl", true },
  { "checkmyessay.com", true },
  { "checkmyessays.com", true },
  { "checkmyhttps.net", true },
  { "checkmyip.com", true },
  { "checkmypsoriasis.com", true },
  { "checkout.google.com", true },
  { "checkpoint-tshirt.com", true },
  { "checkpoint.com", true },
  { "checkras.tk", true },
  { "checkrente.nl", true },
  { "checkspf.net", true },
  { "checktype.com", true },
  { "checkui.com", true },
  { "checkyourmath.com", true },
  { "checkyourprivilege.org", true },
  { "checkyourreps.org", true },
  { "checos.co.uk", true },
  { "cheddarpayments.com", true },
  { "cheekycharliessoftplay.co.uk", true },
  { "cheekymonkeysinflatables.co.uk", true },
  { "cheela.org", true },
  { "cheem.co.uk", true },
  { "cheeseemergency.co.uk", true },
  { "cheetahwerx.com", true },
  { "cheez.systems", true },
  { "cheezflix.uk", true },
  { "chefcuisto.com", true },
  { "chefwear.com", true },
  { "chefz.co", true },
  { "chehalemgroup.com", true },
  { "cheladmin.ru", true },
  { "chelseafs.co.uk", true },
  { "cheltenhambouncycastles.co.uk", true },
  { "cheltik.ru", true },
  { "chemco.mu", true },
  { "chemicalcrux.org", true },
  { "chemiphys.com", true },
  { "chemistry-schools.com", true },
  { "chenapartment.com", true },
  { "chengfayun.com", true },
  { "chengxindong.com", true },
  { "chenkun.pro", true },
  { "chenky.com", true },
  { "chenna.me", true },
  { "chennien.com", true },
  { "chenpei.org", true },
  { "chenqinghua.com", true },
  { "chenzhekl.me", true },
  { "chenzhipeng.com.cn", true },
  { "cheque-transitionactive.fr", true },
  { "cherevoiture.com", true },
  { "cherie-belle.com", true },
  { "chernevclima.bg", true },
  { "cherrett.digital", true },
  { "cherry-green.ch", true },
  { "cherrybread.net", true },
  { "cherrywoodtech.com", true },
  { "chertseybouncycastles.co.uk", true },
  { "chesapeakebaychristmas.com", true },
  { "chess.com", true },
  { "chessboardao.com", true },
  { "chesskid.com", true },
  { "chesspoint.ch", true },
  { "chestercountypediatrics.com", true },
  { "chestercountyroboticsurgery.com", true },
  { "chesterfieldplaceapartmentsstl.com", true },
  { "chesterlestreetasc.co.uk", false },
  { "chetwood.se", true },
  { "chevy37.com", true },
  { "chevymotor-occasions.be", true },
  { "chewey.de", true },
  { "chewey.org", true },
  { "chewingucand.com", true },
  { "chez-janine.de", true },
  { "chez-oim.org", true },
  { "chez.moe", true },
  { "chfr.search.yahoo.com", false },
  { "chhory.com", true },
  { "chhy.at", true },
  { "chiangmaimontessori.com", true },
  { "chiaseeds24.com", true },
  { "chiboard.co", true },
  { "chibr.eu", true },
  { "chic-leather.com", true },
  { "chicagoemergencyclosings.com", true },
  { "chicagolug.org", true },
  { "chicagostudentactivists.org", true },
  { "chicback.com", true },
  { "chicisimo.com", true },
  { "chicolawfirm.com", true },
  { "chicurrichi.com", true },
  { "chif16.at", true },
  { "chikazawa.info", true },
  { "childcare.gov", true },
  { "childcounseling.org", true },
  { "childcustodylegalaid.org", true },
  { "childno.de", true },
  { "childrenandmedia.org.au", true },
  { "childrenfirstalways.org", true },
  { "childreninadversity.gov", true },
  { "childrens-room.com", true },
  { "childrensentertainmentleicester.co.uk", true },
  { "childrenspartiesrus.com", true },
  { "childstats.gov", true },
  { "childvisitationassistance.org", true },
  { "chiledogphoto.com", true },
  { "chilihosting.eu", true },
  { "chilimath.com", true },
  { "chilimathwords.com", true },
  { "chilio.net", true },
  { "chima.net", true },
  { "chima.us", true },
  { "chimeratool.com", true },
  { "chimerity.com", true },
  { "chimpanzee.net", true },
  { "chinahighlights.ru", true },
  { "chinaspaceflight.com", true },
  { "ching.tv", true },
  { "chinookwebdesign.ca", true },
  { "chinwag.im", true },
  { "chinwag.org", true },
  { "chip.pl", true },
  { "chipcore.com", false },
  { "chipglobe.com", true },
  { "chippy.ch", false },
  { "chips-scheduler.de", true },
  { "chipset.no", true },
  { "chiralsoftware.com", true },
  { "chireiden.net", true },
  { "chiro-neuchatel.ch", true },
  { "chiropractic.gr", true },
  { "chiropracticwpb.com", true },
  { "chiropraktik-riemann.de", true },
  { "chiropraticien-neuchatel.ch", true },
  { "chiropratique-neuchatel.ch", true },
  { "chirosphere.ch", true },
  { "chirpstory.com", true },
  { "chiru.no", true },
  { "chirurgoplastico.roma.it", true },
  { "chisago-isantidfl.com", true },
  { "chit.search.yahoo.com", false },
  { "chitoku.jp", false },
  { "chksite.com", true },
  { "chl.la", true },
  { "chliine.ch", true },
  { "chlo-products.biz", true },
  { "chlo-products.net", true },
  { "chloescastles.co.uk", true },
  { "chlth.com", true },
  { "chmielarz.it", true },
  { "chmsoft.com.ua", true },
  { "chmsoft.ru", true },
  { "choc-o-lush.co.uk", true },
  { "chocgu.com", true },
  { "chocodecor.com.br", true },
  { "chocolah.com.au", false },
  { "chocolat.work", true },
  { "chocolatesandhealth.com", true },
  { "chocolatier-tristan.ch", true },
  { "chocolytech.info", true },
  { "chokladfantasi.net", true },
  { "chomp.life", true },
  { "chonghe.org", true },
  { "chook.as", true },
  { "choootto.net", true },
  { "choosemypc.net", true },
  { "chopperdesign.com", true },
  { "chordify.net", true },
  { "chorpinkpoemps.de", true },
  { "chosenplaintext.org", true },
  { "chourishi-shigoto.com", true },
  { "chovancova.sk", true },
  { "choyri.com", true },
  { "chris-edwards.net", true },
  { "chrisahrweileryoga.com", true },
  { "chrisaitch.com", true },
  { "chrisb.me", true },
  { "chrisb.xyz", true },
  { "chrisbryant.me.uk", true },
  { "chrisburnell.com", true },
  { "chriscarey.com", true },
  { "chriscowley.me.uk", true },
  { "chriscutts.uk", true },
  { "chrisdecairos.ca", true },
  { "chrisgieger.com", true },
  { "chrisirwin.ca", true },
  { "chrisjean.com", true },
  { "chrislane.com", true },
  { "chrisluen.com", true },
  { "chrismathys.com", true },
  { "chrismcclendon.com", true },
  { "chrismckee.co.uk", true },
  { "chrismorgan.info", true },
  { "chrismurrayfilm.com", true },
  { "chrisnekarda.com", true },
  { "chrisplankhomes.com", true },
  { "chrispstreet.com", true },
  { "chrissmiley.co.uk", true },
  { "chrisspencercreative.com", true },
  { "chrisspencermusic.com", true },
  { "chrissx.ga", true },
  { "christadelphiananswers.org", true },
  { "christadelphians.eu", true },
  { "christec.net", true },
  { "christensenplace.us", true },
  { "christiaanconover.com", true },
  { "christian-fischer.pictures", true },
  { "christian-folini.ch", true },
  { "christian-gredig.de", true },
  { "christian-host.com", true },
  { "christian-liebel.com", true },
  { "christian-stadelmann.de", true },
  { "christianadventurecamps.org", true },
  { "christianbargon.de", false },
  { "christiancleva.com", true },
  { "christiancoleman.info", true },
  { "christianfaq.org", true },
  { "christianforums.com", true },
  { "christiangehring.org", true },
  { "christianillies.de", true },
  { "christianjens.com", true },
  { "christianliebel.com", true },
  { "christianlis.org.uk", true },
  { "christianlis.uk", true },
  { "christianoliff.com", true },
  { "christianpeltier.com", true },
  { "christianpilgrimage.com.au", true },
  { "christianrasch.de", true },
  { "christians.dating", true },
  { "christianscholz.de", false },
  { "christiehawkes.com", true },
  { "christielepage.com", true },
  { "christiesantiques.com", true },
  { "christineblachford.com", true },
  { "christmascard.be", true },
  { "christmaspartyhire.co.uk", true },
  { "christoph-conrads.name", true },
  { "christopher-simon.de", true },
  { "christopher.sh", true },
  { "christopherandcharlotte.uk", true },
  { "christopherburg.com", true },
  { "christopherkennelly.com", true },
  { "christopherstocks.online", true },
  { "christophertruncer.com", true },
  { "christophsackl.de", true },
  { "christthekingparish.net", true },
  { "christtheredeemer.us", true },
  { "christwaycounseling.com", true },
  { "chriswald.com", true },
  { "chriswarrick.com", true },
  { "chriswbarry.com", true },
  { "chriswells.io", true },
  { "chromaxa.com", true },
  { "chromcraft-revington.com", true },
  { "chrome-devtools-frontend.appspot.com", true },
  { "chrome.com", false },
  { "chrome.google.com", true },
  { "chromebookchart.com", true },
  { "chromebooksforwork.com", true },
  { "chromereporting-pa.googleapis.com", true },
  { "chromeworld.ru", true },
  { "chromiumbugs.appspot.com", true },
  { "chromiumcodereview.appspot.com", false },
  { "chromopho.be", true },
  { "chroniclesofgeorge.com", true },
  { "chronology.no", true },
  { "chronoshop.cz", true },
  { "chrpaul.de", true },
  { "chrstn.eu", true },
  { "chrysanthos.net", true },
  { "chrystajewelry.com", true },
  { "chs.us", false },
  { "chshealthcare.co.uk", true },
  { "chshouyu.com", true },
  { "chsterz.de", true },
  { "chtsi.uk", true },
  { "chuchote-moi.fr", true },
  { "chuill.com", true },
  { "chun.pro", true },
  { "chunche.net", true },
  { "chunk.science", true },
  { "chupadelfrasco.com", true },
  { "chuppa.com.au", true },
  { "churchofsaintrocco.org", true },
  { "churchofscb.org", true },
  { "churchthemes.com", true },
  { "churchwebcanada.ca", true },
  { "churchwebsupport.com", true },
  { "churningtracker.com", true },
  { "chwilrank.pl", true },
  { "chyen.cc", true },
  { "chytraauta.cz", true },
  { "chziyue.com", true },
  { "ci-fo.org", true },
  { "ci-suite.com", true },
  { "ciancode.com", true },
  { "ciania.pl", true },
  { "cianmawhinney.me", true },
  { "ciaracode.com", true },
  { "ciat.no", false },
  { "cibercactus.com", true },
  { "cica.es", true },
  { "cichol.com", true },
  { "ciclista.roma.it", true },
  { "cidbot.com", true },
  { "ciderclub.com", true },
  { "cidersus.com.ec", true },
  { "cie-theatre-montfaucon.ch", true },
  { "ciel.pro", true },
  { "cielbleu.org", true },
  { "cielly.com", true },
  { "cierreperimetral.com", true },
  { "cifop-numerique.fr", true },
  { "ciftlikesintisi.com", true },
  { "cig-dem.com", false },
  { "cigar-cartel.com", true },
  { "cigarterminal.com", false },
  { "cihar.com", true },
  { "ciicutini.ro", true },
  { "cikeblog.com", true },
  { "cilloc.be", true },
  { "cima-idf.fr", true },
  { "cimbalino.org", true },
  { "cimballa.com", true },
  { "cimfax.com", true },
  { "cinafilm.com", true },
  { "cine-music.de", true },
  { "cine.to", true },
  { "cinefilzonen.se", true },
  { "cinefun.net", true },
  { "cinema.paris", true },
  { "cinemarxism.com", true },
  { "cinemasetfree.com", true },
  { "cinemysticism.com", true },
  { "cinenote.link", true },
  { "cineplex.my", true },
  { "ciniticket.com", true },
  { "cinkciarz.pl", true },
  { "cinq-elements.com", true },
  { "cinsects.de", true },
  { "cinteo.com", true },
  { "cio-ciso-interchange.org", true },
  { "cio-cisointerchange.org", true },
  { "cio.go.jp", true },
  { "cio.gov", false },
  { "cio.guide", true },
  { "cioscloud.com", true },
  { "cip.md", true },
  { "cipartyhire.co.uk", true },
  { "cipher.team", true },
  { "cipherboy.com", true },
  { "ciphersuite.info", true },
  { "cipri.com", true },
  { "cipri.net", true },
  { "cipri.nl", true },
  { "cipri.org", true },
  { "cipria.no", true },
  { "cipriano.nl", true },
  { "cipy.com", true },
  { "cir.is", true },
  { "circady.com", true },
  { "circara.com", true },
  { "circle-people.com", true },
  { "circu.ml", true },
  { "circuitcityelectricaladelaide.com.au", true },
  { "circulatedigital.com", true },
  { "circule.cc", true },
  { "ciri.com.co", true },
  { "cirrus0.de", true },
  { "cirurgicagervasio.com.br", true },
  { "cirurgicalucena.com.br", true },
  { "cirurgicasalutar.com.br", true },
  { "cirurgicavirtual.com.br", true },
  { "cisa.gov", true },
  { "ciscodude.net", false },
  { "cisoaid.com", true },
  { "cisofy.com", true },
  { "cispeo.org", true },
  { "ciss.ltd", true },
  { "cisum-cycling.com", true },
  { "cisy.me", true },
  { "citas-adultas.com", true },
  { "citcuit.in", true },
  { "citfin.cz", true },
  { "cities.cl", true },
  { "citimarinestore.com", true },
  { "citizensbankal.com", true },
  { "citizenscience.gov", false },
  { "citizenscience.org", true },
  { "citizensgbr.org", true },
  { "citizensleague.org", true },
  { "citizing.org", true },
  { "citrusui.me", true },
  { "cittadesign.com", false },
  { "citton.com.br", true },
  { "city-adm.lviv.ua", true },
  { "city-walks.info", true },
  { "citya.com", true },
  { "citybeat.de", true },
  { "citycreek.studio", true },
  { "citydance.ee", true },
  { "cityextra.com.au", false },
  { "cityfloorsupply.com", true },
  { "citylights.eu", true },
  { "citymoobel.ee", true },
  { "cityoftitans.com", true },
  { "cityoftitansmmo.com", true },
  { "citysportapp.com", true },
  { "citywidealarms.com", true },
  { "cityworksonline.com", true },
  { "ciubotaru.tk", true },
  { "ciurcasdan.eu", true },
  { "civey.com", true },
  { "civicamente.cl", true },
  { "civicforum.pl", true },
  { "civics.us", true },
  { "civilbikes.com", true },
  { "civilg20.org", true },
  { "civillines.nl", true },
  { "civiltoday.com", true },
  { "cj-espace-vert.fr", true },
  { "cj-jackson.com", true },
  { "cjbeckert.com", false },
  { "cjdby.net", true },
  { "cjdpenterprises.com", true },
  { "cjdpenterprises.com.au", true },
  { "cjean.fr", true },
  { "cjey.me", true },
  { "cjhzp.net", true },
  { "cjr.host", true },
  { "ck.cx", true },
  { "ckenelley.com", true },
  { "ckenelly.com", true },
  { "ckenely.com", true },
  { "ckenneley.com", true },
  { "ckennelley.com", true },
  { "ckennelly.com", true },
  { "ckennely.com", true },
  { "ckleemann.de", true },
  { "cklie.de", true },
  { "ckliemann.com", true },
  { "ckliemann.net", true },
  { "ckna.ca", true },
  { "ckostecki.de", true },
  { "ckp.io", true },
  { "cktennis.com", true },
  { "ckventura.sk", true },
  { "cl.search.yahoo.com", false },
  { "claimconnect.com", true },
  { "claimconnect.us", true },
  { "claimjeidee.be", true },
  { "claimnote.com", true },
  { "clairegold.com", true },
  { "clairescastles.co.uk", true },
  { "claitec.com", true },
  { "clamofon.com", true },
  { "clan-ww.com", true },
  { "clanebouncycastles.com", true },
  { "clanrose.org.uk", true },
  { "clanwarz.com", true },
  { "clarkwinkelmann.com", true },
  { "clase3.tk", true },
  { "clash.lol", true },
  { "class.com.au", true },
  { "classdojo.com", true },
  { "classic-yacht-charters.com", true },
  { "classical-guitar-school.com", true },
  { "classicalpilates.ca", true },
  { "classiccutstupelo.com", true },
  { "classics.io", true },
  { "classictheatrecumbria.co.uk", true },
  { "classpoint.cz", true },
  { "classroom.google.com", true },
  { "classroomconductor.com", true },
  { "classroomcountdown.co.nz", true },
  { "classteaching.com.au", true },
  { "claster.it", true },
  { "claudia-urio.com", true },
  { "claudiney.id", true },
  { "claudiney.info", true },
  { "claudiolemos.com", true },
  { "claus-bahr.de", true },
  { "clauseriksen.net", true },
  { "clausewitz-gesellschaft.de", true },
  { "clav1d.com", true },
  { "clawe.de", true },
  { "clawhammer.dk", true },
  { "clayandcottonkirkwood.com", true },
  { "claygregory.com", true },
  { "clayprints.com", true },
  { "claytonstowing.com.au", true },
  { "clazzrooms.com", true },
  { "cldinc.com", true },
  { "cldly.com", true },
  { "cleanapproachnw.com", true },
  { "cleanbrowsing.org", true },
  { "cleandetroit.org", true },
  { "cleandogsnederland.nl", true },
  { "cleanhouse2000.us", true },
  { "cleaningbyrosie.com", true },
  { "cleaningservicejulai.com", true },
  { "cleanplanet.co.jp", true },
  { "clearance365.co.uk", true },
  { "clearblueday.co.uk", true },
  { "clearbookscdn.uk", true },
  { "clearbreezesecuritydoors.com.au", true },
  { "clearchaos.net", true },
  { "clearip.com", true },
  { "clearpay.co.uk", true },
  { "clearview-creative.com", true },
  { "clearvoice.com", true },
  { "clearwaterbidets.com", true },
  { "clemens-bartz.de", true },
  { "clemensbartz.de", true },
  { "clemenscompanies.com", true },
  { "clement-beaufils.fr", true },
  { "cles-asso.fr", true },
  { "cles.jp", true },
  { "clevertarget.ru", true },
  { "cleververmarkten.com", true },
  { "cleververmarkten.de", true },
  { "clevisto.com", true },
  { "clevvi.com.au", true },
  { "cleysense.com", true },
  { "clica.net", true },
  { "clicandfioul.com", true },
  { "clicheshishalounge.co.uk", true },
  { "click-licht.de", true },
  { "click2order.co.uk", true },
  { "click4web.com", true },
  { "clickbasin.co.uk", true },
  { "clickclickphish.com", true },
  { "clickenergy.com.au", true },
  { "clickingmad.com", true },
  { "clickphish.com", true },
  { "clien.net", true },
  { "client.coach", true },
  { "clientboss.com", true },
  { "clientportal.com", true },
  { "clientsecure.me", true },
  { "cliffbreak.de", true },
  { "clifflu.net", true },
  { "climaprecio.es", true },
  { "climateinteractive.org", true },
  { "climatestew.com", true },
  { "clindoeilmontagne.com", true },
  { "clinicalrehabilitation.info", true },
  { "clinicaltrials.gov", true },
  { "clinicasmedicas.com.br", true },
  { "clinicminds.com", true },
  { "cliniquevethuy.be", true },
  { "clintonlibrary.gov", true },
  { "clip.ovh", true },
  { "clipclip.com", true },
  { "clippings.com", true },
  { "clive.io", true },
  { "clmde.de", true },
  { "clnc.to", true },
  { "clnnet.ch", true },
  { "clo.me", true },
  { "clockcaster.com", true },
  { "clockworksms.com", true },
  { "clod-hacking.com", true },
  { "cloneuniverse.com", true },
  { "clorophilla.net", true },
  { "closeli.cn", true },
  { "closelinksecurity.co.uk", true },
  { "closelinksecurity.com", true },
  { "closetemail.com", true },
  { "cloud-surfer.net", false },
  { "cloud.bugatti", true },
  { "cloud.fail", true },
  { "cloud.google.com", true },
  { "cloud.gov", true },
  { "cloud10.io", true },
  { "cloud255.com", true },
  { "cloud42.ch", false },
  { "cloud9bouncycastlehire.com", true },
  { "cloud9vets.co.uk", true },
  { "cloudalice.com", true },
  { "cloudapps.digital", true },
  { "cloudbolin.es", true },
  { "cloudbrothers.info", true },
  { "cloudcactuar.com", false },
  { "cloudcaprice.net", true },
  { "cloudcert.org", true },
  { "cloudchart.site", true },
  { "cloudcite.net", true },
  { "cloudcloudcloud.cloud", true },
  { "cloudcrux.net", true },
  { "clouddog.com.br", true },
  { "cloudeezy.com", true },
  { "cloudey.net", true },
  { "cloudfiles.at", true },
  { "cloudflare-dns.com", true },
  { "cloudflare.com", true },
  { "cloudflareonazure.com", true },
  { "cloudhoreca.com", true },
  { "cloudia.org", true },
  { "cloudily.com", true },
  { "cloudimprovedtest.com", true },
  { "cloudkeep.nl", true },
  { "cloudlessdreams.com", true },
  { "cloudlight.biz", true },
  { "cloudns.net", true },
  { "cloudofertas.com.br", true },
  { "cloudoptimus.com", true },
  { "cloudpipes.com", true },
  { "cloudse.co.uk", true },
  { "cloudsec.tk", true },
  { "cloudsecurityalliance-europe.org", true },
  { "cloudsecurityalliance.com", true },
  { "cloudsecurityalliance.net", true },
  { "cloudsecurityalliance.org", true },
  { "cloudsecuritycongress.net", true },
  { "cloudsecuritycongress.org", true },
  { "cloudservice.io", true },
  { "cloudservices.nz", true },
  { "cloudsharp.io", true },
  { "cloudsign.jp", true },
  { "cloudspace-analytics.com", true },
  { "cloudspire.net", true },
  { "cloudteam.de", true },
  { "cloudtocloud.tk", true },
  { "cloudtropia.de", true },
  { "cloudup.com", true },
  { "cloudwallce.com", true },
  { "cloudwise.nl", true },
  { "clouz.de", true },
  { "cloveros.ga", true },
  { "clovertwo.com", true },
  { "clownindeklas.nl", true },
  { "cloxy.com", true },
  { "cloze.com", true },
  { "clr3.com", true },
  { "clsfoundationrepairandwaterproofing.com", true },
  { "clsimage.com", true },
  { "clsoft.ch", true },
  { "clu-in.org", true },
  { "club-adulti.ro", true },
  { "club-climate.com", true },
  { "club-creole.com", true },
  { "club-dieta.ru", true },
  { "club-duomo.com", true },
  { "club-jose.com", true },
  { "club-premiere.com", true },
  { "club-reduc.com", true },
  { "club-slow.jp", true },
  { "club-yy.com", true },
  { "club103.ch", true },
  { "clubcorsavenezuela.com", true },
  { "clubdelzapato.com", true },
  { "clubefiel.com.br", true },
  { "clubegolfpt.com", true },
  { "clubempleos.com", true },
  { "clubeohara.com", true },
  { "clubfamily.de", true },
  { "clubgalaxy.futbol", false },
  { "clubiconkenosha.com", true },
  { "clubmarina.store", true },
  { "clubmini.jp", true },
  { "clubnoetig-ink2g.de", true },
  { "clubon.space", true },
  { "clush.pw", true },
  { "cluster.biz.tr", true },
  { "clusteranalyse.net", true },
  { "clusterfuck.nz", true },
  { "clustermaze.net", true },
  { "cmacacias.ch", true },
  { "cmadeangelis.it", true },
  { "cmc.pt", true },
  { "cmcressy.ch", true },
  { "cmdline.org", true },
  { "cme-colleg.de", true },
  { "cmfaccounting.com", false },
  { "cmgacheatcontrol.com", true },
  { "cmillrehab.com", true },
  { "cmlachapelle.ch", true },
  { "cmlancy.ch", true },
  { "cmlignon.ch", true },
  { "cmn-group.com", true },
  { "cmn-groupe.com", true },
  { "cmngroup.com", true },
  { "cmngroupe.com", true },
  { "cmov-plongeurs.fr", true },
  { "cmoycontracts.com", true },
  { "cmplainpalais.ch", true },
  { "cms-weble.jp", true },
  { "cmserviscz.cz", true },
  { "cmskeyholding.co.uk", true },
  { "cmskeyholding.com", true },
  { "cmv.gr", true },
  { "cmylife.nl", true },
  { "cn.search.yahoo.com", false },
  { "cn8522.com", true },
  { "cna-aiic.ca", true },
  { "cna5.cc", true },
  { "cna5.net", true },
  { "cna5.org", true },
  { "cnam-idf.fr", true },
  { "cnbs.ch", true },
  { "cnc-lehrgang.de", true },
  { "cncado.net", true },
  { "cncbazar365.com", true },
  { "cncrans.ch", true },
  { "cncs.gov.pt", true },
  { "cnet-hosting.com", true },
  { "cni-certing.it", true },
  { "cnitdog.com", false },
  { "cnre.eu", true },
  { "cnvt.fr", true },
  { "co-founder-stuttgart.de", true },
  { "co.search.yahoo.com", false },
  { "co2eco.cn", false },
  { "co50.com", true },
  { "coa.one", true },
  { "coachezmoi.ch", true },
  { "coaching-harmonique.fr", true },
  { "coaching-impulse.ch", true },
  { "coaching-park.fr", true },
  { "coalitionministries.org", true },
  { "coalpointcottage.com", true },
  { "coastline.net.au", true },
  { "coathangastrangla.com", true },
  { "coathangastrangler.com", true },
  { "coathangerstrangla.com", true },
  { "coathangerstrangler.com", true },
  { "coatl-industries.com", false },
  { "coatsandcocktails.org", true },
  { "cobalt.io", true },
  { "cobaltgp.com", true },
  { "cobaltis.co.uk", true },
  { "cobaltlp.com", true },
  { "cobracastles.co.uk", true },
  { "cocaine.ninja", true },
  { "cocalc.com", true },
  { "cocareonline.com", true },
  { "coccolebenessere.it", true },
  { "cocinoyo.com", true },
  { "cock.li", true },
  { "cockedey.in", true },
  { "cockfile.com", true },
  { "cockybot.com", true },
  { "coco-line.ch", true },
  { "cocoaheads.at", false },
  { "cocoamexico.com", true },
  { "cocodroid.com", true },
  { "coconutoil24.com", true },
  { "cocoscastles.co.uk", true },
  { "cocquyt-usedcars.be", true },
  { "coda.io", true },
  { "coda.moe", true },
  { "coda.today", true },
  { "coda.world", true },
  { "codabix.com", true },
  { "codabix.de", true },
  { "code-golf.io", true },
  { "code-poets.co.uk", true },
  { "code-vikings.de", true },
  { "code-well.com", true },
  { "code.facebook.com", false },
  { "code.fm", true },
  { "code.google.com", true },
  { "code.taxi", true },
  { "code123.eu", true },
  { "code67.com", true },
  { "codeandpeace.com", true },
  { "codeandsupply.co", true },
  { "codebrahma.com", false },
  { "codecommunity.io", true },
  { "codedelarouteenligne.fr", true },
  { "codedo.info", true },
  { "codedump.net", true },
  { "codeeclipse.com", true },
  { "codeferm.com", true },
  { "codefordus.nrw", true },
  { "codehz.one", true },
  { "codein.ca", true },
  { "codeine.co.uk", true },
  { "codeit.guru", true },
  { "codeit.us", true },
  { "codejots.com", true },
  { "codemahrt.com", true },
  { "codemill.se", true },
  { "codemonster.eu", true },
  { "codenlife.kr", true },
  { "codenode.io", true },
  { "codeofthenorth.com", true },
  { "codepoints.net", true },
  { "codepref.com", true },
  { "codepult.com", true },
  { "codera.co.uk", true },
  { "codereview.appspot.com", false },
  { "codereview.chromium.org", false },
  { "codersatlas.co", true },
  { "codersatlas.xyz", true },
  { "coderware.co.uk", true },
  { "codes.pk", true },
  { "codesport.io", true },
  { "codespromo.be", true },
  { "codestudies.net", true },
  { "codesyncro.com", true },
  { "codetheworld.com", true },
  { "codetipi.com", true },
  { "codetripping.net", true },
  { "codeux.com", true },
  { "codeux.info", true },
  { "codeux.net", true },
  { "codevat.com", true },
  { "codeventure.de", true },
  { "codeversetech.com", true },
  { "codewild.de", true },
  { "codexpo.net", true },
  { "codeyellow.nl", true },
  { "codific.com", true },
  { "codigosddd.com.br", true },
  { "codimaker.com", true },
  { "coding-minds.com", true },
  { "coding.lv", true },
  { "codingforspeed.com", true },
  { "codingfromhell.net", true },
  { "codinginfinity.me", true },
  { "codingrobots.com", true },
  { "codxg.org", true },
  { "codyevanscomputer.com", true },
  { "codymoniz.com", true },
  { "codyqx4.com", true },
  { "coens.me.uk", true },
  { "coentropic.com", true },
  { "coeus.cloud", true },
  { "cofbev.com", true },
  { "coffee-machine.reviews", true },
  { "coffee-mamenoki.jp", true },
  { "coffee-up.it", true },
  { "coffeeandteabrothers.com", true },
  { "coffeetime.fun", true },
  { "cogala.eu", true },
  { "cogeneration-energy.com", true },
  { "cogent.cc", true },
  { "cogilog.com", true },
  { "cogitoltd.com", true },
  { "cognicom-gaming.com", true },
  { "cognitip.com", true },
  { "cognitivecomputingconsortium.com", true },
  { "cognitohq.com", true },
  { "cogsquad.house", true },
  { "coiffeurschnittstelle.ch", true },
  { "coigach-assynt.org", true },
  { "coimmvest.com", true },
  { "coin-quest.net", true },
  { "coin.dance", true },
  { "coinapult.com", true },
  { "coinbase.com", true },
  { "coincealed.com", true },
  { "coinchat.im", true },
  { "coincircle.com", true },
  { "coincoin.eu.org", true },
  { "coindeal.com", true },
  { "coinf.it", true },
  { "coinflux.com", true },
  { "coingate.com", true },
  { "coinlist.co", false },
  { "coinloan.io", true },
  { "coinmewallet.com", true },
  { "coinpit.io", true },
  { "coins2001.ru", true },
  { "coinsmat.com", true },
  { "coinsz.co", true },
  { "coinx.pro", true },
  { "coisabakana.com.br", true },
  { "coisasdemulher.org", true },
  { "cojam.ru", true },
  { "cojo.eu", true },
  { "cokebar.info", true },
  { "coker.com.au", true },
  { "col.la", true },
  { "colaborativa.tv", true },
  { "coladv.com", true },
  { "colantonio.homelinux.net", true },
  { "colapsys.net", true },
  { "colasjourdain.fr", true },
  { "colchonesmoon.com", true },
  { "colcomm.com", true },
  { "coldawn.com", false },
  { "coldcardwallet.com", true },
  { "coldfff.com", true },
  { "coldhak.ca", true },
  { "coldiario.com", true },
  { "coldlasers.org", true },
  { "coldstreamcreekfarm.com", true },
  { "colectivointerconductual.com", true },
  { "colemak.com", true },
  { "colengo.com", true },
  { "colf.online", true },
  { "colibris.xyz", true },
  { "colincogle.name", true },
  { "colinsnaith.co.uk", true },
  { "collabora-office.com", true },
  { "collabora.ca", true },
  { "collabora.co.kr", true },
  { "collabora.co.uk", true },
  { "collabora.com", true },
  { "collabora.kr", true },
  { "collabora.ninja", true },
  { "collabora.social", true },
  { "collabora.uk", true },
  { "collaboracloudsuite.com", true },
  { "collaboraoffice.co.uk", true },
  { "collaboraoffice.com", true },
  { "collaborativehealthpsychology.com", true },
  { "collabornation.net", true },
  { "collaction.hk", true },
  { "collada.org", true },
  { "collare.com.mx", true },
  { "collectdocs.com", true },
  { "collectfood.com", true },
  { "collectiblebeans.com", true },
  { "collectorknives.net", true },
  { "collectorsystems.com", true },
  { "collegeconnexxions.com.au", true },
  { "collegegirlhd.com", true },
  { "collegenavigator.gov", true },
  { "collegepaperworld.com", true },
  { "collegeprospectsofcentralindiana.com", true },
  { "collegereligionandphilosophy.com", true },
  { "collegesexvid.com", true },
  { "collegestationhomes.com", true },
  { "collinel-hossari.com", true },
  { "collinelhossari.com", true },
  { "collinklippel.com", true },
  { "collinmbarrett.com", true },
  { "colloquy.mobi", true },
  { "colo-tech.com", true },
  { "cololi.moe", true },
  { "colombian.dating", true },
  { "color01.net", true },
  { "coloraid.net", true },
  { "colorblindprogramming.com", true },
  { "colorbrush.ru", true },
  { "colorcodedlyrics.com", true },
  { "colorectalcompounding.com", true },
  { "colorfuldots.com", true },
  { "colorhexa.com", true },
  { "coloristcafe.com", true },
  { "colorpicker.fr", true },
  { "colors3d.com", true },
  { "colorsbycarin.com", true },
  { "colossal-events.co.uk", true },
  { "colourfulcastles.co.uk", true },
  { "colourmanagementpro.com", true },
  { "colpacpackaging.com", true },
  { "colpatriaws.azurewebsites.net", true },
  { "colson-occasions.be", true },
  { "coltellisurvival.com", true },
  { "columbuswines.com", true },
  { "colyakoomusic.com", true },
  { "colyakootees.com", true },
  { "com-in.de", true },
  { "comalia.com", true },
  { "comame.xyz", false },
  { "comarkinstruments.net", true },
  { "combatircelulitis.com", true },
  { "combattrecellulite.com", true },
  { "combron.be", true },
  { "combron.co.uk", true },
  { "combron.com", true },
  { "combron.nl", true },
  { "comcol.nl", true },
  { "comdotgame.com", true },
  { "comdurav.com", true },
  { "comeals.com", true },
  { "comedyhuis.nl", true },
  { "comefollowme2016.com", true },
  { "comeoishii.com", true },
  { "comercialbelzunces.com", true },
  { "comercialtpv.com", true },
  { "comercialtrading.eu", true },
  { "comerford.net", true },
  { "comestoarra.com", true },
  { "cometcache.com", true },
  { "cometonovascotia.ca", true },
  { "comff.net", true },
  { "comfintouch.com", true },
  { "comflores.com.br", true },
  { "comfortmastersinsulation.com", true },
  { "comfun.net", true },
  { "comhack.com", true },
  { "comicspornos.com", true },
  { "comicspornow.com", true },
  { "comicspornoxxx.com", true },
  { "comicwiki.dk", true },
  { "comidina.com", true },
  { "comiteaintriathlon.fr", true },
  { "comiteexpertes.gc.ca", true },
  { "comm.cx", true },
  { "commco.nl", true },
  { "commechezvous.ch", true },
  { "commerce.gov", true },
  { "commercezen.com", true },
  { "commercia.srl", true },
  { "commercial-academy.fr", true },
  { "commeunamour.com", true },
  { "commissaris-vraagbaak.nl", true },
  { "commissionagenda.com", true },
  { "commitsandrebases.com", true },
  { "commlabindia.com", true },
  { "common.io", true },
  { "commoncode.com.au", true },
  { "commoncode.io", true },
  { "commoncore4kids.com", true },
  { "commonspace.la", true },
  { "communalconsulting.org", true },
  { "communiques.info", true },
  { "communityblog.fedoraproject.org", true },
  { "communitychurchafrica.co.za", true },
  { "communitycodeofconduct.com", true },
  { "communitymanagertorrejon.com", true },
  { "communote.net", true },
  { "como-se-escribe.com", true },
  { "comoaliviareldolor.de", true },
  { "comoculosdesol.pt", true },
  { "comocurarlagastritis24.online", true },
  { "comocurarlagastritistratamientonatural.com", true },
  { "comodesinflamarlashemorroides.org", true },
  { "comodo.nl", true },
  { "comodormirmasrapido.com", true },
  { "comodosslstore.com", true },
  { "comogene.com", true },
  { "comohacerblog.net", true },
  { "comohacerpara.com", true },
  { "comoimportar.net", true },
  { "comopuededejardefumar.net", true },
  { "comoquitarlacaspa24.com", true },
  { "comoquitarlasestriasrapidamente.com", true },
  { "comosecarabarriga.net", true },
  { "comoseduzir.net", true },
  { "comosefazisto.com.br", true },
  { "comp2go.com.au", true },
  { "compactchess.cc", true },
  { "compagnia-buffo.de", false },
  { "compagniemartin.com", true },
  { "companion-web.net", true },
  { "comparatif-moto.fr", true },
  { "compareandrecycle.co.uk", true },
  { "compareinsurance.com.au", true },
  { "comparesoft.com", true },
  { "comparewatch.com", true },
  { "comparexcloudcenter.com", true },
  { "compartirtrenmesaave.com", true },
  { "compassbest.com", true },
  { "compassdirectportal.com", true },
  { "compassfinance.com", true },
  { "compassintladv.com", true },
  { "compasslos.com", true },
  { "compeat.com", true },
  { "competencyassessment.ca", true },
  { "comphare.nl", true },
  { "compibus.fr", true },
  { "compilenix.org", true },
  { "compleetondernemen.nl", true },
  { "completefloorcoverings.com", true },
  { "completesecurityessex.co.uk", true },
  { "completesecurityessex.com", true },
  { "completionist.me", true },
  { "complexart.ro", true },
  { "complexorganization.com", true },
  { "compliance-management.ch", true },
  { "compliance-systeme.de", true },
  { "compliancedictionary.com", true },
  { "compliancerisksoftware.co.uk", true },
  { "componentshop.co.uk", true },
  { "compostatebien.com.ar", true },
  { "compostelle-bouddha.fr", true },
  { "compoundingrxusa.com", true },
  { "compraneta.com", false },
  { "compraporinternet.online", true },
  { "comprarimpresoras-3d.com", true },
  { "compreair.com", true },
  { "compreautomacao.com.br", true },
  { "compree.com", true },
  { "compromised.com", true },
  { "compservice.in.ua", true },
  { "comptablevilledequebec.com", true },
  { "comptrollerofthecurrency.gov", true },
  { "comptu.com", true },
  { "compubench.com", true },
  { "compucorner.mx", true },
  { "compunetwor.com", true },
  { "compuplast.cz", true },
  { "computec.ch", true },
  { "computehealth.com", true },
  { "computer-acquisti.com", true },
  { "computer-menschen.de", true },
  { "computer-science-schools.com", true },
  { "computerassistance.co.uk", true },
  { "computerbas.nl", true },
  { "computerbase.de", true },
  { "computercamaccgi.com", true },
  { "computeremergency.com.au", false },
  { "computerhilfe-feucht.de", true },
  { "computerinfobits.com", true },
  { "computernetwerkwestland.nl", true },
  { "computerslotopschool.nl", true },
  { "computersystems.guru", false },
  { "computerwerk.org", true },
  { "computop.com", true },
  { "comunidadmontepinar.es", true },
  { "comvos.de", true },
  { "comw.cc", true },
  { "con-con.nl", true },
  { "conalcorp.com", true },
  { "conatus.ai", true },
  { "conaudisa.com", false },
  { "concept-web.ch", true },
  { "concertengine.com", true },
  { "concerto.amsterdam", true },
  { "concertsenboite.fr", true },
  { "concertsto.com", true },
  { "concilio.com", true },
  { "conciliumnotaire.ca", true },
  { "conclinica.com.br", true },
  { "concordsoftwareleasing.com", true },
  { "concretelevelingsystems.com", true },
  { "concreterepairatlanta.com", true },
  { "concreterepairconcreteraising.com", true },
  { "concursos.com.br", true },
  { "concursosabertos.com.br", true },
  { "concursuri.biz", true },
  { "condecom.com.br", true },
  { "condepenalba.com", false },
  { "condesaelectronics.com", true },
  { "condolencemessages.net", true },
  { "condominiosi.it", true },
  { "condominioweb.com", true },
  { "condosforcash.com", true },
  { "condroz-motors.be", true },
  { "conectadev.com", true },
  { "conectumfinanse.pl", true },
  { "conejovalleyelectrical.com", true },
  { "conejovalleyelectrician.com", true },
  { "conejovalleyexteriorlighting.com", true },
  { "conejovalleylandscapelighting.com", true },
  { "conejovalleylighting.com", true },
  { "conejovalleyoutdoorlighting.com", true },
  { "conexiontransporte.com", true },
  { "conference-expert.eu", true },
  { "confiancefoundation.org", true },
  { "config.schokokeks.org", false },
  { "confiwall.de", true },
  { "conformax.com.br", true },
  { "conftree.com", true },
  { "congafasdesol.com", true },
  { "congineer.com", true },
  { "congobunkering.com", true },
  { "conju.cat", true },
  { "conjugacao.com.br", true },
  { "conkret.de", true },
  { "conkret.mobi", true },
  { "conmedapps.com", true },
  { "conn.cx", true },
  { "connect-ed.network", true },
  { "connect.dating", true },
  { "connect.facebook.net", true },
  { "connecta.store", true },
  { "connectedcare.md", true },
  { "connectivia.it", true },
  { "connectmath.com", true },
  { "connectmy.car", true },
  { "connecto-data.com", true },
  { "connectum.eu", true },
  { "conner.work", true },
  { "connexas.eu", true },
  { "connext.de", true },
  { "connictro.de", true },
  { "connorhatch.com", true },
  { "connyduck.at", true },
  { "conocchialidasole.it", true },
  { "conociendosalama.com", true },
  { "conorboyd.info", true },
  { "conory.com", false },
  { "conotoxia.com", true },
  { "conpath.net", true },
  { "conpins.nl", true },
  { "conquer-addiction.org", true },
  { "conrad-kostecki.de", true },
  { "conradkostecki.de", true },
  { "conradsautotransmissionrepair.com", true },
  { "conraid.net", true },
  { "consagracionamariasantisima.org", true },
  { "consciente.ch", true },
  { "consciente.ngo", true },
  { "consciente.ong", true },
  { "consciouschoices.net", true },
  { "consegnafioridomicilio.net", true },
  { "consegne.it", true },
  { "consejosdenutricion.com", true },
  { "consensoprivacy.it", true },
  { "conservatoriesincornwall.com", true },
  { "consideredgifts.com", true },
  { "consilium-vitae.ch", true },
  { "consiliumvitae.ch", true },
  { "console.ninja", true },
  { "console.rest", true },
  { "consommateuraverti.com", true },
  { "consonare.de", true },
  { "constant-rough.de", true },
  { "constituenttracker.com", true },
  { "constitution.website", true },
  { "construct.net", true },
  { "constructexpres.ro", true },
  { "constructieve.nl", true },
  { "construction-colleges.com", true },
  { "construction-student.co.uk", true },
  { "constructionjobs.com", false },
  { "constructive.men", true },
  { "consul.io", true },
  { "consulenza.pro", true },
  { "consultasdigitales.com", true },
  { "consultation.biz.tr", true },
  { "consultimator.com", true },
  { "consultimedia.de", true },
  { "consulting-cloud.com", true },
  { "consultoriadeseguranca.com.br", true },
  { "consultoriosodontologicos.com.br", true },
  { "consultpetkov.com", true },
  { "consulvation.com", true },
  { "consumeractionlawgroup.com", true },
  { "consumerfiles.com", true },
  { "consumersentinel.gov", true },
  { "consuwijzer.nl", true },
  { "contactsingapore.sg", true },
  { "containerspace.com.au", true },
  { "contaquanto.com.br", true },
  { "contemplativeeducation.org", true },
  { "content-api-dev.azurewebsites.net", false },
  { "contentcoms.co.uk", true },
  { "contentpass.net", true },
  { "contentq.nl", true },
  { "contessa32experience.com", true },
  { "contextplatform.com", true },
  { "conti-profitlink.co.uk", true },
  { "continental-zermatt.ch", true },
  { "continuum.memorial", true },
  { "continuumrecoverycenter.com", true },
  { "contrabass.net", true },
  { "contractormountain.com", true },
  { "contractwriters.com", true },
  { "contrasentido.net", true },
  { "contraspin.co.nz", true },
  { "contratatupoliza.com", true },
  { "contributor.google.com", false },
  { "controlambientalbogota.com", true },
  { "controlarlaansiedad.com", true },
  { "controlautocom.com.br", true },
  { "controlbooth.com", true },
  { "controle.net", true },
  { "controleer-maar-een-ander.nl", true },
  { "controllertech.com", true },
  { "controltickets.com.br", true },
  { "controlvoltage.cc", true },
  { "contunda.de", true },
  { "conv2pdf.com", true },
  { "convergence.fi", true },
  { "convergencela.com", true },
  { "convergnce.com", true },
  { "conversiepartners.nl", true },
  { "conversiones.com", true },
  { "convert.im", true },
  { "converticacommerce.com", false },
  { "convertimg.com", true },
  { "convexset.org", true },
  { "cookeatup.com", true },
  { "cookescastles.co.uk", true },
  { "cookicons.co", true },
  { "cookie4.com", true },
  { "cookieandkate.com", true },
  { "cookiecrook.com", true },
  { "cookiesoft.de", true },
  { "cooking-sun.com", true },
  { "cookingcrusade.com", true },
  { "cookinglife.nl", false },
  { "cookingperfected.com", true },
  { "cookingreporter.com", true },
  { "cookmedical.com", false },
  { "cooksecuritygroup.com", true },
  { "cookwithmanali.com", true },
  { "cool-parties.co.uk", true },
  { "cool-wallpapers.jp", true },
  { "cool.haus", true },
  { "cool110.tk", true },
  { "cool110.xyz", true },
  { "coolattractions.co.uk", true },
  { "coolbitx.com", true },
  { "coolcamping.com", true },
  { "cooldan.com", true },
  { "coole-fete.de", true },
  { "coolerssr.space", true },
  { "coolgifs.de", true },
  { "coolprylar.se", true },
  { "cooltang.ooo", true },
  { "coolvibe.org", true },
  { "coon.fr", true },
  { "coonawarrawines.com.au", true },
  { "coonelnel.net", true },
  { "coop.se", true },
  { "cooperativa-je.net", true },
  { "coore.jp", true },
  { "coorpacademy.com", true },
  { "coorpintr.com", true },
  { "copdfoundation.org", true },
  { "copperandtileroofing.com", true },
  { "copperheados.com", true },
  { "copplaw.com", true },
  { "copta-imagefilme-und-drohnenvideos.de", true },
  { "coptkm.cz", true },
  { "copycaught.com", true },
  { "copycaught.net", true },
  { "copycaught.org", true },
  { "copycrafter.net", true },
  { "copydz.com", true },
  { "copypoison.com", true },
  { "copyright-watch.org", true },
  { "copyshrug.ca", true },
  { "corbi.net.au", true },
  { "cordejong.nl", true },
  { "corder.tech", true },
  { "cordeydesign.ch", true },
  { "cordis.io", true },
  { "cordis.tk", true },
  { "cordlessdog.com", true },
  { "cordobaaldia.com.mx", true },
  { "core-concepts.de", false },
  { "core-networks.de", true },
  { "core.mx", true },
  { "core.org.pt", true },
  { "coreapm.org", true },
  { "coreless-stretchfilm.com", true },
  { "corelia.net", true },
  { "corepartners.com.ua", true },
  { "coresolutions.ca", true },
  { "coreum.ca", true },
  { "corevetconnect.co.uk", true },
  { "coreyjmahler.com", true },
  { "corgi.party", true },
  { "coribi.com", true },
  { "corinastefan.ro", true },
  { "corintech.net", true },
  { "coriolis.ch", true },
  { "corisu.co", true },
  { "corkedwinebar.com", true },
  { "corkerscrisps.co.uk", true },
  { "corksoncolumbus.com", true },
  { "corl3ss.com", true },
  { "corlija.com", true },
  { "corlinde.nl", true },
  { "corlitocaffe.de", true },
  { "cornercircle.co.uk", true },
  { "cornergarage.coop", true },
  { "cornerstone.network", true },
  { "cornerstonecmc.org", true },
  { "corniche.com", true },
  { "corningcu.org", true },
  { "cornmachine.com", true },
  { "cornodo.com", true },
  { "corona-academy.com", true },
  { "corona-renderer.cloud", true },
  { "corona-renderer.com", true },
  { "coronersconnect.co.uk", true },
  { "coropiacere.org", true },
  { "corp.goog", true },
  { "corpfin.net", true },
  { "corpio.nl", true },
  { "corpkitnw.com", true },
  { "corpoflow.nl", true },
  { "corporateclash.net", true },
  { "corporatecomputingsolutions.com", true },
  { "corporateinfluencers.com", true },
  { "corpulant.coffee", true },
  { "corpulantcoffee.com", true },
  { "corpulent.coffee", true },
  { "corpulentcoffee.com", true },
  { "corpuschristisouthriver.org", true },
  { "corpusslayer.com", true },
  { "corrbee.com", true },
  { "correct.cf", true },
  { "correcthorse.cf", true },
  { "correctiv.org", true },
  { "correctpaardbatterijnietje.nl", true },
  { "corrick.io", true },
  { "corrupted.io", true },
  { "corsa-b.uk", true },
  { "corscanplus.com", true },
  { "corsectra.com", true },
  { "corsicalaw.com", true },
  { "corsihaccpsicurezzalavoro.it", true },
  { "corso-antincendio.org", true },
  { "cortealcastello.it", true },
  { "cortexitrecruitment.com", true },
  { "cortexx.nl", true },
  { "cortis-consulting.ch", true },
  { "corvax.kiev.ua", true },
  { "coryadum.com", true },
  { "cosasque.com", true },
  { "cosciamoos.com", true },
  { "cosirex.com", true },
  { "cosmechic.fr", true },
  { "cosmekaitori.jp", true },
  { "cosmeticappraisal.com", true },
  { "cosmeticasimple.com", true },
  { "cosmeticos-naturales.com", true },
  { "cosmetify.com", true },
  { "cosmicnavigator.com", true },
  { "cosmicworlds.com", true },
  { "cosmicworlds.mobi", true },
  { "cosmodacollection.com", true },
  { "cosmofunnel.com", true },
  { "cosmundi.de", true },
  { "cosplayer.com", true },
  { "cospol.ch", true },
  { "costablanca.villas", true },
  { "costablancavoorjou.com", true },
  { "costcoinsider.com", true },
  { "costinstefan.eu", true },
  { "costreportdata.com", false },
  { "costruzioni.milano.it", true },
  { "costulessdirect.com", true },
  { "coteries.com", true },
  { "cotoacc.com", true },
  { "cotonmusic.ch", true },
  { "cotwe-ge.ch", true },
  { "cougar.dating", true },
  { "counsellingtime.com", true },
  { "counstellor.com", true },
  { "counter-team.ch", true },
  { "counterenlol.com", true },
  { "counterglobal.com", true },
  { "countermail.com", false },
  { "countermats.net", true },
  { "countersolutions.co.uk", true },
  { "countetime.com", true },
  { "countingto.one", true },
  { "country-creativ.de", true },
  { "countrybrewer.com.au", true },
  { "countryfrog.uk", true },
  { "countryhouseresort.com", true },
  { "countryoutlaws.ca", true },
  { "countybankdel.com", true },
  { "countyjailinmatesearch.com", true },
  { "coupestanley.com", true },
  { "couplay.org", true },
  { "couponbates.com", true },
  { "couponcodesme.com", true },
  { "cour4g3.me", true },
  { "couragefound.org", true },
  { "coursables.com", true },
  { "courseconfidence.com", true },
  { "coursera.org", true },
  { "courseworkbank.info", true },
  { "courtlistener.com", true },
  { "couscous.recipes", true },
  { "couvreur-hinault.fr", true },
  { "covbounce.co.uk", true },
  { "covermytrip.com.au", true },
  { "covershousing.nl", true },
  { "covery.ai", true },
  { "covoiturage.fr", true },
  { "covve.com", false },
  { "covybrat.cz", true },
  { "cowbird.org", true },
  { "coweo.cz", true },
  { "coworking-luzern.ch", true },
  { "cowsay.blog", true },
  { "coxcapitalmanagement.com", true },
  { "coxxs.me", true },
  { "coya.tw", true },
  { "cozmoapp.com", true },
  { "cozo.me", true },
  { "cozyeggdesigns.com", true },
  { "cozywebsite.com", true },
  { "cp-st-martin.be", true },
  { "cpap.com", true },
  { "cpasperdu.com", true },
  { "cpcheats.co", true },
  { "cpd-education.co.uk", true },
  { "cpe-colleg.de", true },
  { "cpe-registry.com", true },
  { "cpe-registry.net", true },
  { "cpe-registry.org", true },
  { "cperegistry.com", true },
  { "cperegistry.net", true },
  { "cperegistry.org", true },
  { "cpgarmor.com", true },
  { "cphpvb.net", true },
  { "cplus.me", true },
  { "cplusplus.se", true },
  { "cppan.org", true },
  { "cppressinc.com", true },
  { "cpqcol.gov.co", true },
  { "cprheartcenter.com", true },
  { "cprnearme.com", true },
  { "cpsc.gov", true },
  { "cpsq.fr", true },
  { "cptoon.com", true },
  { "cpu.biz.tr", true },
  { "cpvmatch.eu", true },
  { "cpy.pt", true },
  { "cqn.ch", true },
  { "cr.search.yahoo.com", false },
  { "cr0nus.net", true },
  { "cr9499.com", true },
  { "cra-bank.com", true },
  { "cra-search.net", true },
  { "craazzyman21.at", true },
  { "crabfactory.com.my", true },
  { "crabrave.space", true },
  { "crackcat.de", true },
  { "cracker.in.th", true },
  { "crackle.io", true },
  { "crackorsquad.in", true },
  { "crackslut.eu", true },
  { "crackstation.net", true },
  { "cradle.ph", true },
  { "cradlepointecm.com", true },
  { "craft-me-in.com", true },
  { "craft-verlag.de", true },
  { "craftandbuild.de", true },
  { "craftinghand.com", true },
  { "craftinginredlipstick.com", true },
  { "craftist.de", true },
  { "craftsmandruggets.com", true },
  { "craftsmany.net", true },
  { "craftyguy.net", true },
  { "craftyphotons.net", true },
  { "crag.com.tw", true },
  { "craigary.net", true },
  { "craigbates.co.uk", true },
  { "craigfrancis.co.uk", true },
  { "craigleclaireteam.com", true },
  { "craigrouse.com", true },
  { "craigwfox.com", true },
  { "crain.com.au", true },
  { "cralarm.de", true },
  { "cramersoft.com", true },
  { "crandall.io", true },
  { "cranforddental.com", true },
  { "cranshafengin.com", true },
  { "crapouill.es", true },
  { "crashboy.ws", true },
  { "cratss.co.uk", true },
  { "crawford.cloud", true },
  { "crawfordcountytcc.org", true },
  { "crawl.report", true },
  { "crawler.ninja", true },
  { "crawleybouncycastles.co.uk", true },
  { "crazy-bulks.com", true },
  { "crazy-cat.net", true },
  { "crazy-coders.com", true },
  { "crazybulk.co.uk", true },
  { "crazybulk.com", true },
  { "crazybulk.de", true },
  { "crazybulk.fr", true },
  { "crazycastles.ie", true },
  { "crazycraftland.net", true },
  { "crazydomains.ae", true },
  { "crazydomains.co.nz", true },
  { "crazydomains.co.uk", true },
  { "crazydomains.com.au", true },
  { "crazydomains.in", true },
  { "crazymeeshu.com", true },
  { "crazynoisybizarre.town", true },
  { "crazypaul.com", true },
  { "crazypowered.com", true },
  { "crazyvisitors.com", true },
  { "crbug.com", true },
  { "crc-bank.com", true },
  { "crc-search.com", true },
  { "crdmendoza.net", true },
  { "crea-etc.net", true },
  { "crea-shops.ch", true },
  { "crea-th.at", true },
  { "crea-that.fr", true },
  { "crea.bg", true },
  { "crealogix-online.com", true },
  { "creamcastles.co.uk", true },
  { "creampiepornvids.com", true },
  { "creamsoft.com", true },
  { "creared.edu.co", true },
  { "createcos.com", true },
  { "createcpanama.com", true },
  { "createme.com.pl", true },
  { "createursdefilms.com", true },
  { "creatieven.com", true },
  { "creation-contemporaine.com", true },
  { "creativ-impuls-dekorateurin-muenchen.de", true },
  { "creative-wave.fr", true },
  { "creativeangles.in", true },
  { "creativebites.de", true },
  { "creativecaptiv.es", true },
  { "creativecommons.gr", true },
  { "creativecommons.org", true },
  { "creativeconceptsvernon.com", true },
  { "creativedigital.co.nz", true },
  { "creativefolks.co.uk", true },
  { "creativeglassgifts.com.au", true },
  { "creativeimagery.com.au", true },
  { "creativeink.de", true },
  { "creativekkids.com", true },
  { "creativelaw.eu", true },
  { "creativeliquid.com", true },
  { "creativesprite.com", true },
  { "creativesurvey.com", true },
  { "creativeweb.biz", true },
  { "creativewolf.net", true },
  { "creativosonline.org", true },
  { "creatixx-network.de", false },
  { "creators-design.com", true },
  { "creators.direct", true },
  { "creatorswave.com", true },
  { "creatujoya.com", true },
  { "crecman.fr", true },
  { "credential.eu", true },
  { "credex.bg", true },
  { "credigo.se", true },
  { "creditkarma.com", true },
  { "creditos-rapidos.com", true },
  { "creditozen.es", true },
  { "creditozen.mx", true },
  { "creditproautos.com", false },
  { "creditscoretalk.com", true },
  { "creeks-coworking.com", true },
  { "creep.im", true },
  { "creepypastas.com", true },
  { "creepypastas.net", true },
  { "creer-une-boutique-en-ligne.com", true },
  { "creerunsitepro.com", true },
  { "crefelder.com", true },
  { "crem.in", false },
  { "cremepassion.de", true },
  { "crena.ch", true },
  { "crepa.ch", true },
  { "crestasantos.com", true },
  { "cretdupuy.com", true },
  { "creteangle.com", true },
  { "cretica.no", true },
  { "creusalp.ch", true },
  { "crgalvin.com", true },
  { "crgm.net", true },
  { "cribcore.com", true },
  { "cricklewood.condos", true },
  { "criena.com", true },
  { "criena.net", true },
  { "crimbotrees.co.uk", true },
  { "crime-lawyers.com", true },
  { "crimefreeliving.com", true },
  { "crimesolutions.gov", true },
  { "crimevictims.gov", true },
  { "criminal-attorney.ru", true },
  { "criminal.enterprises", true },
  { "crimsonconnect.co.uk", true },
  { "crinesdanzantes.be", true },
  { "crip-usk.ba", true },
  { "criptocert.com", true },
  { "criptolog.com", true },
  { "criscitos.it", true },
  { "crisisactual.com", true },
  { "crisisnextdoor.gov", true },
  { "crismatthews.com", true },
  { "crisp.chat", true },
  { "crisp.email", true },
  { "crisp.help", true },
  { "crisp.im", true },
  { "crisp.watch", true },
  { "crispinusphotography.com", true },
  { "cristarta.com", true },
  { "cristau.org", true },
  { "cristianrasch.com", true },
  { "cristoraciones.com", true },
  { "critical.today", false },
  { "criticalsurveys.co.uk", true },
  { "critterguard.org", true },
  { "crizin.io", true },
  { "crizk.com", true },
  { "crm.onlime.ch", false },
  { "crm114d.com", true },
  { "croceverdevb.it", true },
  { "crochetnerd.com", true },
  { "crocuscoaching.co.uk", true },
  { "croisedanslemetro.com", true },
  { "croixblanche-haguenau.fr", true },
  { "cromosomax.com", true },
  { "cronberg.ch", true },
  { "cronenberg.cc", true },
  { "cronix.cc", true },
  { "cronologie.de", true },
  { "cronometer.com", true },
  { "cronoscentral.be", true },
  { "cropdiagnosis.com", true },
  { "crosbug.com", true },
  { "crose.co.uk", true },
  { "cross-led-sign.com", true },
  { "cross-link.ch", true },
  { "cross-view.com", true },
  { "cross-x.com", true },
  { "cross.lol", true },
  { "crossborderreturns.com", true },
  { "crossedwires.net", true },
  { "crossfitblackwater.com", true },
  { "crosslifenutrition.co.uk", true },
  { "crossoverit.com", true },
  { "crossway.nl", true },
  { "crowd.supply", true },
  { "crowdbox.net", true },
  { "crowdcloud.be", true },
  { "crowdliminal.com", true },
  { "crowdsim3d.com", true },
  { "crowdspire.org", true },
  { "crowdsupply.com", true },
  { "crowleymarine.com", true },
  { "crownaffairs.ch", true },
  { "crowncastles.co.uk", true },
  { "crownmarqueehire.co.uk", true },
  { "crownpoint.com", true },
  { "crows.io", true },
  { "croydonapartments.com.au", true },
  { "croydonbouncycastles.co.uk", true },
  { "crrev.com", true },
  { "crsmsodry.cz", true },
  { "crsoresina.it", true },
  { "crstat.ru", true },
  { "crt2014-2024review.gov", true },
  { "cruisemoab.com", true },
  { "crumbcontrol.com", true },
  { "crunchrapps.com", true },
  { "crunchy.rocks", true },
  { "crustytoothpaste.net", true },
  { "crute.me", true },
  { "crux.camp", true },
  { "crvv.me", true },
  { "cry.nu", false },
  { "cryobiz.com", true },
  { "cryothanasia.com", true },
  { "crypt.is-by.us", true },
  { "cryptagio.com", true },
  { "cryptearth.de", true },
  { "crypted.chat", true },
  { "crypteianetworks.com", true },
  { "cryptizy.com", true },
  { "crypto.cat", false },
  { "crypto.graphics", true },
  { "crypto.is", false },
  { "cryptobin.co", true },
  { "cryptocon.org", true },
  { "cryptoegg.ca", true },
  { "cryptofan.org", true },
  { "cryptofrog.co", true },
  { "cryptography.ch", true },
  { "cryptography.io", true },
  { "cryptoguidemap.com", true },
  { "cryptoholic.co", true },
  { "cryptoisnotacrime.org", true },
  { "cryptojacks.io", true },
  { "cryptojourney.com", true },
  { "cryptology.ch", true },
  { "cryptomail.nl", true },
  { "cryptomaniaks.com", true },
  { "cryptonom.org", true },
  { "cryptonym.com", true },
  { "cryptoparty.at", true },
  { "cryptoparty.tv", true },
  { "cryptopartyutah.org", true },
  { "cryptophobia.nl", true },
  { "cryptorival.com", true },
  { "cryptoseb.pw", true },
  { "cryptoshot.pw", true },
  { "cryptract.co", true },
  { "crys.cloud", true },
  { "crys.hu", true },
  { "crys.ovh", true },
  { "crystal-zone.com", true },
  { "crystalapp.ca", true },
  { "crystalchandelierservices.com", true },
  { "crystalgrid.net", true },
  { "crystaloscillat.com", true },
  { "crystalzoneshop.com", true },
  { "crystone.me", true },
  { "cryz.ru", true },
  { "cs.money", true },
  { "cs2016.ch", true },
  { "csa-library.org", true },
  { "csaapac.com", true },
  { "csaapac.org", true },
  { "csabg.org", true },
  { "csacongress.com", true },
  { "csacongress.org", true },
  { "csacongress.us", true },
  { "csadc.org", true },
  { "csasummit.net", true },
  { "csasummit.org", true },
  { "csca.me", true },
  { "cscau.com", true },
  { "cscdn.net", true },
  { "csd-slovenije.si", true },
  { "cselzer.com", true },
  { "csfcloud.com", true },
  { "csfd.cz", true },
  { "csfm.com", true },
  { "csgf.fun", true },
  { "csgf.ru", true },
  { "csgo.su", true },
  { "csgoswap.com", true },
  { "csharpmarc.net", true },
  { "cshub.nl", true },
  { "csi.lk", true },
  { "csinterstargeneve.ch", true },
  { "csirt.ee", true },
  { "csjministriesfoundation.org", true },
  { "cskentertainment.co.uk", true },
  { "cslaboralistas.pe", true },
  { "csmainframe.com", true },
  { "csokolade.hu", true },
  { "csosa.gov", true },
  { "csovek-idomok.hu", true },
  { "csp.ch", true },
  { "cspeti.hu", true },
  { "cspvalidator.org", true },
  { "csrichter.com", true },
  { "css.direct", false },
  { "css.net", true },
  { "cssai.eu", true },
  { "cssaunion.com", true },
  { "cstanley.net", true },
  { "cstb.ch", true },
  { "cstp-marketing.com", true },
  { "cstrong.nl", true },
  { "csu.st", true },
  { "csust.ac.cn", true },
  { "csvalpha.nl", true },
  { "cswarzone.com", true },
  { "cswgmbh.de", true },
  { "ct.search.yahoo.com", false },
  { "ctc-transportation.com", true },
  { "ctcom-peru.com", true },
  { "ctcue.com", true },
  { "ctf.link", true },
  { "ctj.im", true },
  { "ctkwwri.org", true },
  { "ctl.email", true },
  { "ctliu.com", true },
  { "ctnguyen.de", true },
  { "ctnguyen.net", true },
  { "ctns.de", false },
  { "ctoin.tw", true },
  { "ctomp.io", false },
  { "ctoresms.com", true },
  { "ctpe.net", true },
  { "ctrl.blog", true },
  { "ctrld.me", true },
  { "cttso.gov", true },
  { "cu247secure.ie", true },
  { "cub-bouncingcastles.co.uk", true },
  { "cubaal.com", true },
  { "cube-cloud.com", true },
  { "cube.builders", true },
  { "cubebot.io", true },
  { "cubebuilders.net", true },
  { "cubecart-demo.co.uk", true },
  { "cubecart-hosting.co.uk", true },
  { "cubecraft.net", true },
  { "cubecraftcdn.com", true },
  { "cubekrowd.net", true },
  { "cubeperformancecentre.com.au", true },
  { "cubetech.co.jp", true },
  { "cubia.de", true },
  { "cubia3.com", true },
  { "cubia4.com", true },
  { "cubiest.com", true },
  { "cubile.xyz", true },
  { "cubing.net", true },
  { "cublick.com", true },
  { "cubos.io", false },
  { "cubostecnologia.com", false },
  { "cubostecnologia.com.br", false },
  { "cubua.com", true },
  { "cuchichi.es", true },
  { "cuckoopalace.cn", true },
  { "cuddlecat.io", true },
  { "cuddlecomfort.com", true },
  { "cuddlingyaks.com", true },
  { "cudoo.de", true },
  { "cueca.com.br", true },
  { "cuecasonline.com.br", true },
  { "cuegee.com", true },
  { "cuentasmutualamr.org.ar", true },
  { "cuetoems.com", true },
  { "cuibonobo.com", true },
  { "cuio.net", true },
  { "culan.dk", true },
  { "cultiv.nl", true },
  { "cultofd50.org", true },
  { "cultofperf.org.uk", true },
  { "cultura10.com", true },
  { "culturedcode.com", true },
  { "culturesouthwest.org.uk", true },
  { "cumberlandrivertales.com", true },
  { "cuminas.com", true },
  { "cuminas.jp", true },
  { "cumplegenial.com", true },
  { "cumseface.eu", true },
  { "cumshots-video.ru", true },
  { "cumtd.com", true },
  { "cuntflaps.me", true },
  { "cuoc.org.uk", true },
  { "cup.al", true },
  { "cupcao.gov", true },
  { "cupidosshop.com", true },
  { "cupoane-reducere.net", true },
  { "cupom.net", true },
  { "cur.by", true },
  { "curacao-firma.com", true },
  { "curacaodiveguide.com", true },
  { "curamail.co.uk", true },
  { "curatedgeek.com", true },
  { "curatedtaste.com", true },
  { "curbside.com", true },
  { "cureatr.com", true },
  { "curieux.digital", true },
  { "curio-shiki.com", true },
  { "curiosity-driven.org", true },
  { "curlify.com", true },
  { "curlybracket.co.uk", true },
  { "currency-strength.com", true },
  { "current-usa.com", true },
  { "currentlystreaming.com", true },
  { "currentlyusa.com", true },
  { "currynissanmaparts.com", true },
  { "cursed.im", true },
  { "cursos-trabajadores.net", true },
  { "cursos.com", true },
  { "cursosdeinglesmexico.com", true },
  { "cursosforex.com", true },
  { "cursosingles.com", true },
  { "cursossena.co", true },
  { "cursosypostgrados.com", true },
  { "cursuri-de-actorie.ro", true },
  { "curtacircuitos.com.br", false },
  { "curtis-smith.me.uk", true },
  { "curtis-smith.uk", true },
  { "curtissmith.me.uk", true },
  { "curtissmith.uk", true },
  { "curva.co", true },
  { "curveprotect.com", true },
  { "curveprotect.cz", true },
  { "curveprotect.net", true },
  { "curveprotect.org", true },
  { "curvissa.co.uk", true },
  { "curvylove.de", true },
  { "custamped.com", true },
  { "custodiamobili.roma.it", true },
  { "custodian.nl", true },
  { "custodyxchange.com", true },
  { "customcontract.network", true },
  { "customdissertation.com", true },
  { "customfitbymj.net", true },
  { "customfitmarketing.com", true },
  { "customgear.com.au", true },
  { "customizeyoursink.com", true },
  { "custompapers.com", true },
  { "customwebsitesplus.com", true },
  { "customwritings.com", true },
  { "customwritingservice.com", true },
  { "customwritten.com", true },
  { "cutner.co", true },
  { "cuvva.co", true },
  { "cuvva.co.uk", true },
  { "cuvva.com", true },
  { "cuvva.eu", true },
  { "cuvva.io", true },
  { "cuvva.it", true },
  { "cuvva.me", true },
  { "cuvva.net", true },
  { "cuvva.org", true },
  { "cuvva.uk", true },
  { "cuvva.us", true },
  { "cuxpool.net", true },
  { "cvazquez.es", true },
  { "cvc.digital", true },
  { "cvchomes.com", true },
  { "cvcoders.com", true },
  { "cve-le-carrousel.ch", true },
  { "cviip.ca", true },
  { "cviip.com", true },
  { "cvjd.me", false },
  { "cvl.ch", true },
  { "cvlibrary.co.uk", true },
  { "cvmu.jp", true },
  { "cvps.top", true },
  { "cvr.dk", true },
  { "cvtemplatemaster.com", true },
  { "cvutdecin.cz", true },
  { "cvv.cn", true },
  { "cw.center", true },
  { "cwagner.me", true },
  { "cwarren.org", true },
  { "cwbrtrust.ca", true },
  { "cwc.gov", true },
  { "cwgaming.co.uk", true },
  { "cwinfo.fi", true },
  { "cwinfo.net", true },
  { "cwmart.in", true },
  { "cwrau.com", true },
  { "cwrau.de", true },
  { "cwrau.info", true },
  { "cwrau.io", true },
  { "cwrau.me", true },
  { "cwrau.name", true },
  { "cwrau.rocks", true },
  { "cwrau.tech", true },
  { "cwrcoding.com", true },
  { "cwwise.com", true },
  { "cxadd.com", true },
  { "cyanghost.com", true },
  { "cyber-wolfs.com", true },
  { "cyber.je", true },
  { "cyberatlantis.com", true },
  { "cybercareers.gov", true },
  { "cybercocoon.com", true },
  { "cybercrew.cc", true },
  { "cybercrime-forschung.de", true },
  { "cybercrime.gov", true },
  { "cybercymru.co.uk", false },
  { "cyberdean.fr", true },
  { "cyberdiscoverycommunity.uk", true },
  { "cyberduck.io", true },
  { "cyberexplained.info", true },
  { "cyberfamily.network", true },
  { "cybergrx.com", true },
  { "cyberguerrilla.info", true },
  { "cyberguerrilla.org", true },
  { "cyberhipsters.nl", true },
  { "cyberianhusky.com", false },
  { "cyberkov.com", true },
  { "cyberlegal.co", true },
  { "cyberlightapp.com", true },
  { "cybermeldpunt.nl", true },
  { "cybermotives.com", true },
  { "cyberogism.com", true },
  { "cyberonesol.com", true },
  { "cyberoptic.de", true },
  { "cyberphaze.com", true },
  { "cyberpioneer.net", false },
  { "cyberpubonline.com", true },
  { "cyberregister.nl", true },
  { "cyberregister.org", true },
  { "cybersafesolutions.com", true },
  { "cyberscan.io", true },
  { "cybersecurity.nz", true },
  { "cybersecurity.run", true },
  { "cybersecuritychallenge.be", false },
  { "cybersecurityketen.nl", true },
  { "cyberseguranca.com.br", true },
  { "cybersins.com", true },
  { "cybersmartdefence.com", true },
  { "cyberspect.com", true },
  { "cyberspect.io", true },
  { "cyberstatus.de", true },
  { "cybertu.be", true },
  { "cyberwars.dk", true },
  { "cyberwire.nl", true },
  { "cyberxpert.nl", true },
  { "cybozu.cn", true },
  { "cybozu.com", true },
  { "cyclebeads.com", true },
  { "cycledownunder.com", true },
  { "cycleluxembourg.lu", true },
  { "cyclinggoodso.com", true },
  { "cyclonebikes.com.ua", true },
  { "cyclop-editorial.fr", true },
  { "cydetec.com", true },
  { "cyfly.org", true },
  { "cygnaltech.com", true },
  { "cygnan.com", true },
  { "cygnatus.com", true },
  { "cygnius.net", true },
  { "cyhour.com", false },
  { "cykelbanor.se", true },
  { "cyl6.com", true },
  { "cylindehea.com", true },
  { "cylindricity.com", true },
  { "cynicaloptimist.me", true },
  { "cyon.ch", true },
  { "cyph.audio", true },
  { "cyph.com", true },
  { "cyph.healthcare", true },
  { "cyph.im", true },
  { "cyph.io", true },
  { "cyph.me", true },
  { "cyph.video", true },
  { "cyph.ws", true },
  { "cyphar.com", true },
  { "cypherpunk.at", true },
  { "cypherpunk.observer", true },
  { "cypressinheritancesaga.com", true },
  { "cypresslegacy.com", true },
  { "cyprus-company-service.com", true },
  { "cyrating.com", true },
  { "cysec.biz", true },
  { "cysmo.de", true },
  { "cytech.com.tr", true },
  { "cytegic-update-packages.com", true },
  { "cytotecforsale.com", true },
  { "cyumus.com", true },
  { "cyyzaid.cn", false },
  { "czakey.net", true },
  { "czbix.com", true },
  { "czbtm.com", true },
  { "czc.cz", true },
  { "czech.is", true },
  { "czechcrystals.co.uk", true },
  { "czechvirus.cz", true },
  { "czerno.com", true },
  { "czfa.pl", true },
  { "czk.mk", true },
  { "czwartybrat.pl", true },
  { "d-20.fr", true },
  { "d-designerin.de", true },
  { "d-eisenbahn.com", true },
  { "d-loop.de", true },
  { "d-macindustries.com", true },
  { "d-parts.de", true },
  { "d-parts24.de", true },
  { "d-toys.com.ua", true },
  { "d-training.de", true },
  { "d.nf", true },
  { "d.nr", true },
  { "d00d.de", true },
  { "d0g.cc", true },
  { "d0m41n.name", true },
  { "d0xq.com", true },
  { "d2.gg", true },
  { "d2ph.com", true },
  { "d2qa61rbluifiq.cloudfront.net", true },
  { "d3lab.net", true },
  { "d3xt3r01.tk", true },
  { "d3xx3r.de", true },
  { "d42.no", true },
  { "d4b.in.ua", true },
  { "d4done.com", true },
  { "d4fx.de", true },
  { "d4x.de", true },
  { "d5197.co", true },
  { "d66.nl", true },
  { "d6729.co", true },
  { "d6c5yfulmsbv6.cloudfront.net", true },
  { "d7211.com", true },
  { "d7215.com", true },
  { "d7216.com", true },
  { "d8.io", true },
  { "d8853.com", true },
  { "d88688.com", true },
  { "d8870.net", true },
  { "d8872.net", true },
  { "d88988.com", true },
  { "d88dc05.com", true },
  { "d88md23.com", true },
  { "d9297.co", true },
  { "d9397.com", true },
  { "d9721.com", true },
  { "d9728.co", true },
  { "d9c.eu", true },
  { "da-sh.cc", true },
  { "daallexx.eu", true },
  { "dabasstacija.lv", true },
  { "dabuttonfactory.com", true },
  { "dachb0den.net", true },
  { "dachdecker-ranzenberger.de", true },
  { "dachdeckermeister-egon-weiss.de", true },
  { "dachtechnik-windschuettl.de", true },
  { "daciaforum.nl", true },
  { "daciamodellen.nl", true },
  { "dadadani.xyz", true },
  { "dadafterforty.be", true },
  { "daddybio.com", true },
  { "daddyfinger.me", true },
  { "dado.fr", true },
  { "dado.me", true },
  { "dado.virtual.museum", true },
  { "dadons-laserdiscs.com", true },
  { "dadosch.de", true },
  { "dadrian.io", true },
  { "daduke.org", true },
  { "daemen.org", true },
  { "daemwool.ch", true },
  { "daevel.com", true },
  { "daevel.fr", true },
  { "daevel.net", true },
  { "dafont.com", true },
  { "dafricapress.com", true },
  { "dafyddcrosby.com", true },
  { "dag-hebergement.fr", true },
  { "dag-konsult.com", true },
  { "dagensannonser.se", true },
  { "dagmarhamalova.cz", true },
  { "dahlberg.cologne", true },
  { "dahliacake.com", true },
  { "daigakujuken-plus.com", true },
  { "daikoz.com", true },
  { "dailybits.be", true },
  { "dailyblogged.com", true },
  { "dailyemailinboxing.com", true },
  { "dailyenglishchallenge.com", true },
  { "dailyhealthguard.com", true },
  { "dailykos.com", true },
  { "dailyrover.com", true },
  { "dailyroverr.com", true },
  { "dailyxenang.com", true },
  { "daintymeal.com", true },
  { "dairyshrine.org", true },
  { "daisakuikeda.org", true },
  { "daisidaniels.co.uk", true },
  { "daisuki.pw", true },
  { "daisy-peanut.com", true },
  { "daisypeanut.com", true },
  { "daitouryu-jujutsu.com", true },
  { "daiyuu.jp", true },
  { "dajiadu.net", true },
  { "dak.org", true },
  { "dakin.nyc", true },
  { "dakindesign.com", true },
  { "dakinnyc.com", true },
  { "daknob.net", true },
  { "dakotasjoint.com", true },
  { "daktarisys.com", true },
  { "daladubbeln.se", true },
  { "dalaran.city", true },
  { "dale-electric.com", true },
  { "dale-west.com", true },
  { "dalek.co.nz", true },
  { "dalfsennet.nl", true },
  { "dalingk.com", true },
  { "dallaslu.com", true },
  { "dallasmenshealth.com", true },
  { "dallmeier.net", true },
  { "dalmatiersheusden.be", true },
  { "damaged.org", true },
  { "damasexpress.com", true },
  { "damedrogy.cz", true },
  { "damejidlo.cz", true },
  { "dameocio.com", true },
  { "damghaem.ir", true },
  { "damianus.hr", true },
  { "damianuv-blog.cz", true },
  { "damicris.ro", true },
  { "damienoreilly.org", true },
  { "daminiphysio.ca", true },
  { "damip.net", true },
  { "damirsystems.com", true },
  { "damjanovic.it", true },
  { "dammekens.be", true },
  { "damngoodpepper.com", false },
  { "damonline.dk", true },
  { "dampedia.com", true },
  { "damtosfoods.com", true },
  { "dan-informacijske-varnosti.si", true },
  { "dan-nixon.com", true },
  { "dan.me.uk", true },
  { "danads.com", true },
  { "danamica.dk", true },
  { "danandrum.com", true },
  { "danarozmarin.com", true },
  { "danbaldwinart.com", true },
  { "danburycampervans.co.uk", true },
  { "dance-colleges.com", true },
  { "danchen.org", true },
  { "dancingcubs.co.uk", true },
  { "dancingshiva.at", false },
  { "dandenongroadapartments.com.au", true },
  { "daneandthepain.com", true },
  { "danfromit.co.uk", true },
  { "danfromit.com", true },
  { "dangmai.tk", true },
  { "dangr.zone", true },
  { "danhalliday.com", true },
  { "danholloway.online", true },
  { "daniel-baumann.ch", true },
  { "daniel-cholewa.de", true },
  { "daniel-kulbe.de", true },
  { "daniel-milnes.co.uk", true },
  { "daniel-milnes.uk", true },
  { "daniel-ruf.de", true },
  { "daniel-wildhaber.ch", true },
  { "danielas.boutique", true },
  { "daniele.tech", true },
  { "danielehniss.de", true },
  { "danielepestilli.com", true },
  { "danielfeau.com", true },
  { "danielgorr.de", true },
  { "danielgray.email", true },
  { "danielgray.me", true },
  { "danielguttfreundphd.net", true },
  { "danielhinterlechner.eu", true },
  { "danielhochleitner.de", true },
  { "danieljamesscott.org", true },
  { "danieljball.co.uk", true },
  { "danieljstevens.com", true },
  { "danielkoster.nl", true },
  { "danielmartin.de", true },
  { "danielmiessler.com", true },
  { "danielmoch.com", true },
  { "danielmorell.com", true },
  { "danielmostertman.com", true },
  { "danielmostertman.nl", true },
  { "danieln.tech", true },
  { "danielnaaman.com", true },
  { "danielparker.com.au", true },
  { "danielpenno.com", true },
  { "danielpeukert.cz", true },
  { "danielran.com", true },
  { "danielrozenberg.com", true },
  { "danielsblog.org", true },
  { "danielschreurs.com", true },
  { "danielsfirm.com", true },
  { "danielstach.cz", true },
  { "danielsteiner.net", true },
  { "danielstiner.me", true },
  { "danielthompson.info", true },
  { "danieltollot.de", true },
  { "danielvoogsgerd.nl", true },
  { "danielwildhaber.ch", true },
  { "danilapisarev.com", true },
  { "danjesensky.com", true },
  { "dank.ninja", true },
  { "dankim.de", false },
  { "danla.nl", true },
  { "danmaby.com", true },
  { "danmarksbedstefredagsbar.dk", true },
  { "danmarksflyttemand.dk", true },
  { "danmassarano.com", true },
  { "danminkevitch.com", false },
  { "danna-salary.com", true },
  { "dannhanks.com", true },
  { "dannicholas.net", true },
  { "danny-tittel.de", true },
  { "danny.fm", true },
  { "dannycairns.com", true },
  { "dannyrohde.de", true },
  { "dannystevens.co.uk", true },
  { "danotage.tv", true },
  { "danpiel.net", true },
  { "dansage.co", true },
  { "dansaunders.me", true },
  { "danscomp.com", true },
  { "dansdiscounttools.com", true },
  { "dansedesalonsaintave.fr", true },
  { "danselibre.net", true },
  { "danselibre.org", true },
  { "danseressen.nl", true },
  { "dansk777.dk", true },
  { "danskoferie.dk", true },
  { "danskoya.com", true },
  { "danslan.org", true },
  { "danstillman.com", true },
  { "dantelistan.com", true },
  { "dantransports.fr", true },
  { "danw.io", true },
  { "danwin1210.me", true },
  { "danwolff.se", true },
  { "danyabanya.com", true },
  { "danzac.com", true },
  { "daop.co.uk", true },
  { "daoro.net", true },
  { "daphne.informatik.uni-freiburg.de", true },
  { "dapim.co.il", true },
  { "dara-berlin.de", true },
  { "daracokorilo.com", true },
  { "darani.ch", true },
  { "daravk.ch", true },
  { "darbi.org", true },
  { "darc-mak.de", true },
  { "darchoods.net", false },
  { "darcymarshall.com", true },
  { "dare.deals", true },
  { "dareyou.be", true },
  { "darf.nl", true },
  { "dariaburger.de", true },
  { "darinkotter.com", true },
  { "darioackermann.ch", true },
  { "darioclip.com", true },
  { "darioturchetti.me", true },
  { "darisni.me", true },
  { "dark-infection.de", true },
  { "dark-vision.cz", true },
  { "dark.ninja", true },
  { "darkag.ovh", true },
  { "darkcores.net", true },
  { "darkengine.io", true },
  { "darkengine.net", true },
  { "darkerlystormy.com", true },
  { "darkerstormy.com", true },
  { "darkeststar.org", true },
  { "darkfire.ch", true },
  { "darklaunch.com", true },
  { "darknessflickers.com", true },
  { "darknetlive.com", true },
  { "darknight.blog", true },
  { "darkrisks.com", true },
  { "darkserver.fedoraproject.org", true },
  { "darkserver.stg.fedoraproject.org", true },
  { "darkshop.nl", true },
  { "darkskymap.com", true },
  { "darkspacelab.com", true },
  { "darktime.ru", true },
  { "darkwater.info", true },
  { "darkx.me", true },
  { "darmgesundheit.ch", true },
  { "darom.jp", true },
  { "darshnam.com", false },
  { "dartcode.org", true },
  { "dartetdemetiers.fr", true },
  { "darth-sonic.de", true },
  { "dartshopmn.nl", true },
  { "darwinkel.net", true },
  { "darwinsearch.org", true },
  { "darylcrouse.com", true },
  { "darylcumbo.net", true },
  { "das-forum24.de", true },
  { "das-mediale-haus.de", true },
  { "das-sommercamp.de", true },
  { "dasgeestig.nl", true },
  { "dashdrive.net", true },
  { "dashlane.com", true },
  { "dashnearby.com", true },
  { "dasignsource.com", true },
  { "dasinternetluegt.at", true },
  { "dasteichwerk.at", true },
  { "dasug.de", true },
  { "dat4u.de", true },
  { "data-detox.de", true },
  { "data-wing.ga", false },
  { "data.bayern", true },
  { "data.gov", true },
  { "data.govt.nz", true },
  { "data.haus", true },
  { "data.qld.gov.au", false },
  { "data.world", true },
  { "data3w.nl", true },
  { "databionix.com", true },
  { "databutlr.com", true },
  { "databutlr.net", true },
  { "datacalle.com", true },
  { "datadit.hu", true },
  { "datafd.com", true },
  { "datafd.net", true },
  { "datagrail.io", true },
  { "dataguidance.com", true },
  { "dataharvest.at", true },
  { "datahive360.com", true },
  { "datahjalp.nu", true },
  { "datajobs.ai", true },
  { "datakick.org", true },
  { "datalife.gr", true },
  { "datalysis.ch", true },
  { "dataprivacysolution.com", true },
  { "dataprotectionadvisors.com", true },
  { "datapun.ch", true },
  { "datapure.net", true },
  { "dataregister.info", true },
  { "datascience.cafe", true },
  { "datascience.ch", true },
  { "dataskydd.net", true },
  { "dataspace.pl", true },
  { "datasupport-stockholm.se", true },
  { "datasupport.one", true },
  { "dataswamp.org", true },
  { "datatekniikka.com", false },
  { "datatekniikka.fi", false },
  { "datatekniker.nu", true },
  { "datateknologsektionen.se", false },
  { "datatree.nl", true },
  { "datatruckers.com", true },
  { "datatruckers.eu", true },
  { "datatruckers.net", true },
  { "datatruckers.org", true },
  { "datax-cloud.de", true },
  { "datecougarslocal.com", true },
  { "datelah.com", true },
  { "datelligent.com", true },
  { "datememe.com", true },
  { "datengrab.xyz", true },
  { "datenkeks.de", true },
  { "dateno1.com", true },
  { "datenreiter.org", true },
  { "datenschutz-consult.de", true },
  { "datenschutz-individuell.de", true },
  { "datenschutzgrundverordnung.de", true },
  { "datenschutztag.org", true },
  { "datenschutzzentrum.de", true },
  { "datenwerkstatt.net", true },
  { "datewon.net", false },
  { "datingsite-vergelijken.website", true },
  { "datingticino.ch", true },
  { "datisstom.nl", true },
  { "datmancrm.com", true },
  { "dator-test.se", true },
  { "datorhjalp-stockholm.se", true },
  { "datorhjalptaby.se", true },
  { "datorservice-stockholm.se", true },
  { "datumou-osusume.com", true },
  { "datumou-recipe.com", true },
  { "datumstudio.jp", true },
  { "datvexehue.com", true },
  { "daubecity.de", true },
  { "daubehosting.de", true },
  { "dave-pearce.com", true },
  { "daveaglick.com", true },
  { "davecardwell.com", true },
  { "davelynes.com", true },
  { "daveoc64.co.uk", true },
  { "daveops.net", true },
  { "davepage.me.uk", true },
  { "davepearce.com", true },
  { "davepermen.net", true },
  { "davescomputertips.com", true },
  { "davesharpe.com", true },
  { "davesinclair.com.au", true },
  { "davetempleton.com", true },
  { "davethom.net", true },
  { "davevelopment.net", true },
  { "davewardle.com", true },
  { "davewood.com.au", true },
  { "david-corry.com", true },
  { "david-hinschberger.me", true },
  { "david-jeffery.co.uk", true },
  { "david-pearce.com", true },
  { "david-reess.de", true },
  { "david-schiffmann.de", true },
  { "david.kitchen", true },
  { "davidadrian.org", true },
  { "davidandersson.se", true },
  { "davidandrewcoaching.com", true },
  { "davidbranco.me", true },
  { "davidbrookes.me", true },
  { "davidbuckell.com", true },
  { "daviddever.net", true },
  { "davidfetveit.com", true },
  { "davidforward.com", true },
  { "davidforward.net", true },
  { "davidfrancoeur.com", true },
  { "davidgouveia.net", true },
  { "davidgow.net", true },
  { "davidhanle.com", true },
  { "davidkeane.com", true },
  { "davidkennardphotography.com", true },
  { "davidking.xyz", true },
  { "davidlamprea.com", true },
  { "davidlane.io", true },
  { "davidlyness.com", true },
  { "davidmcevoy.org.uk", true },
  { "davidmn.org", true },
  { "davidnadaski.com", true },
  { "davidpearce.com", true },
  { "davidpearce.org", true },
  { "davidpescarolo.it", true },
  { "davidschadlich.com", true },
  { "davidschlachter.com", true },
  { "davidsimner.me.uk", true },
  { "davidsopas.com", true },
  { "davidtiffany.com", true },
  { "davidundetiwan.com", true },
  { "davidzack.net", true },
  { "davidzeegers.nl", true },
  { "davie3.com", true },
  { "davisdieselandautorepair.com", true },
  { "davisroi.com", true },
  { "davo-usedcars.be", true },
  { "davy-server.com", true },
  { "davypropper.com", true },
  { "daw.nz", true },
  { "dawgs.ga", true },
  { "dawnbringer.eu", true },
  { "dawnbringer.net", true },
  { "dawnofeden.net", true },
  { "dawoud.org", true },
  { "dawson-floridavilla.co.uk", true },
  { "dax.guide", true },
  { "daxpatterns.com", true },
  { "daycontactlens.com", true },
  { "daydream.team", true },
  { "daylightpirates.org", true },
  { "dayman.net", true },
  { "daymprove.life", true },
  { "dayofdays.be", true },
  { "dayofthegirl.gc.ca", true },
  { "daysoftheyear.com", true },
  { "daywalkers-photography.de", true },
  { "dazz.it", true },
  { "dazzit.ca", true },
  { "dazzit.com", true },
  { "dazzit.io", true },
  { "dazzit.net", true },
  { "dazzit.org", true },
  { "dazzit.xyz", true },
  { "db.ci", true },
  { "dbapress.org", true },
  { "dbaron.org", true },
  { "dbas.cz", true },
  { "dbentertainment.co.uk", true },
  { "dbgamestudio.com", true },
  { "dblcastles.co.uk", true },
  { "dbldub.net", true },
  { "dbmiller.org", true },
  { "dbmteam.com", true },
  { "dborcard.com", true },
  { "dbpkg.com", true },
  { "dbq.com", true },
  { "dbrand.com", true },
  { "dbrgn.ch", true },
  { "dbtsai.com", true },
  { "dc-elektro.com", true },
  { "dc-elektro.de", true },
  { "dc-elektro.eu", true },
  { "dc-occasies.be", true },
  { "dc-solution.de", false },
  { "dc1.com.br", true },
  { "dc562.org", true },
  { "dc585.info", true },
  { "dcain.me", true },
  { "dcards.in.th", true },
  { "dcbouncycastles.co.uk", true },
  { "dcc.cat", true },
  { "dcdestetica.it", true },
  { "dcepler.net", true },
  { "dchatelain.ch", true },
  { "dchest.org", true },
  { "dckd.nl", true },
  { "dclaisse.fr", true },
  { "dcmapping.net", true },
  { "dcmediahosting.com", true },
  { "dcmt.co", true },
  { "dcpower.eu", true },
  { "dcrdev.com", true },
  { "dcw.io", true },
  { "dd211d.com", true },
  { "dd5197.co", true },
  { "dd6729.co", true },
  { "dd6729.com", true },
  { "dd7211.com", true },
  { "dd9297.co", true },
  { "dd9397.com", true },
  { "dd9721.com", true },
  { "dd9728.co", true },
  { "ddatsh.com", true },
  { "ddays2008.org", true },
  { "ddel.de", true },
  { "dden.ca", true },
  { "ddepot.us", true },
  { "ddhosted.com", true },
  { "ddns-test.de", true },
  { "ddnsweb.com", true },
  { "ddoser.cn", true },
  { "ddosolitary.org", true },
  { "ddproxy.cf", true },
  { "ddracepro.net", true },
  { "dds.mil", true },
  { "ddsmatchsouthwest.com", true },
  { "ddy.tw", true },
  { "de-gucci.com", true },
  { "de-mail.info", true },
  { "de-medici.nl", true },
  { "de-rwa.de", true },
  { "de-spil.be", true },
  { "de.search.yahoo.com", false },
  { "dead-letter.email", true },
  { "deadbeef.ninja", true },
  { "deadc0de.re", true },
  { "deadmorose.ru", true },
  { "deaf.dating", true },
  { "deaf.eu.org", true },
  { "dealapp.nl", true },
  { "dealbanana.at", true },
  { "dealbanana.be", true },
  { "dealbanana.ch", true },
  { "dealbanana.co.uk", true },
  { "dealbanana.com", true },
  { "dealbanana.de", true },
  { "dealbanana.fi", true },
  { "dealbanana.fr", true },
  { "dealbanana.it", true },
  { "dealbanana.se", true },
  { "dealcruiser.nl", true },
  { "dealerselectric.com", true },
  { "dealinflatables.co.uk", true },
  { "dealpass.no", true },
  { "dealspotr.com", true },
  { "dealszone.net", true },
  { "deamuseum.org", true },
  { "deanbank.com", true },
  { "deanjerkovich.com", true },
  { "deanmorgan.org", true },
  { "deano-s.co.uk", true },
  { "deanosplace.net", true },
  { "deanpearce.net", true },
  { "dearfcc.com", true },
  { "dearfcc.net", true },
  { "dearfcc.org", true },
  { "dearktiel.nl", true },
  { "dearnevalleybouncycastles.co.uk", true },
  { "death.social", true },
  { "deathofspring.com", true },
  { "deathsdomain.com", true },
  { "deathy.ro", true },
  { "deautomaat.nl", true },
  { "deavel.com", true },
  { "deavel.fr", true },
  { "deavel.net", true },
  { "debarrasantony.com", true },
  { "debarrasasnieressurseine.com", true },
  { "debarrasboulognebillancourt.com", true },
  { "debarrasclichy.com", true },
  { "debarrascolombes.com", true },
  { "debarrasnanterre.com", true },
  { "debatereport.com", true },
  { "debbyefurd.com", true },
  { "debie-usedcars.be", true },
  { "debigare.com", true },
  { "debora-singkreis.de", true },
  { "debraydesign.com.au", true },
  { "debron-ot.nl", true },
  { "debrusoft.ch", true },
  { "debt.com", true },
  { "debtrecycling.com.au", true },
  { "debuemon.com", true },
  { "debuis.nl", true },
  { "dec6.gc.ca", true },
  { "decal-times.com", true },
  { "decalquai.ch", true },
  { "decay24.de", true },
  { "decayshop.com", true },
  { "decfun.com", true },
  { "dechat.nl", true },
  { "decher.de", true },
  { "decidetreatment.org", true },
  { "decidio.cc", true },
  { "decimatechnologies.eu", true },
  { "decis.fr", true },
  { "decisivetactics.com", true },
  { "deckbuilderamerica.com", true },
  { "declarationlocationmeublee.com", true },
  { "declivitas.com", true },
  { "deco-parisienne.fr", true },
  { "decock-usedcars.be", true },
  { "decodeanddestroy.com", true },
  { "decompiled.de", true },
  { "deconsolas.tk", true },
  { "decoora.com", true },
  { "decor-d.com", true },
  { "decor-live.ru", true },
  { "decor-prazdnik.ru", true },
  { "decoratingadvice.co.uk", true },
  { "decoratore.roma.it", true },
  { "decoratrix.com", true },
  { "decorestilo.com.br", true },
  { "decorumcomics.com", true },
  { "decosoftware.com", true },
  { "decrousaz-ceramique.ch", true },
  { "decrypto.net", true },
  { "decs.es", true },
  { "dede.ml", true },
  { "dedelta.net", true },
  { "dedg3.com", true },
  { "dedge.org", true },
  { "dedicatedtowomenobgyn.com", true },
  { "dedmorozrzn.ru", false },
  { "deduijventil.nl", true },
  { "dee.pe", true },
  { "dee.su", true },
  { "deechtebakkers.nl", true },
  { "deegeeinflatables.co.uk", true },
  { "deejayevents.ro", true },
  { "deelmijnreis.nl", true },
  { "deep-chess.com", true },
  { "deep-labs.com", true },
  { "deep.club", true },
  { "deeparamaraj.com", true },
  { "deepbluecrafting.co.uk", true },
  { "deepblueemail.com", true },
  { "deepcode.io", true },
  { "deephill.com", true },
  { "deepinnov.com", true },
  { "deepinsight.io", true },
  { "deeps.me", true },
  { "deepserve.info", true },
  { "deepsouthsounds.com", true },
  { "deepspace.dedyn.io", true },
  { "deepspace4.com", true },
  { "deepzz.com", true },
  { "deerfieldapartmentsstl.com", true },
  { "def-pos.ru", true },
  { "defantasia.cl", true },
  { "defcon.org", true },
  { "defcongroups.org", true },
  { "defeestboek.nl", true },
  { "defendas.com", true },
  { "defender-pro.com", true },
  { "defendersz.com", true },
  { "defendinnovation.org", true },
  { "defendtheweb.co.uk", true },
  { "defero.io", true },
  { "defiantrust.com", true },
  { "define-atheism.com", true },
  { "define-atheist.com", true },
  { "defineatheism.com", true },
  { "defineatheist.com", true },
  { "deflect.ca", true },
  { "deflumeri.com", true },
  { "deflumeriker.com", true },
  { "defman.me", true },
  { "defont.nl", true },
  { "defreitas.no", true },
  { "deftek.com", true },
  { "deftig-und-fein.de", true },
  { "deftnerd.com", true },
  { "defuse.ca", true },
  { "defxing.net", true },
  { "degata.com", true },
  { "degeberg.com", true },
  { "degeberg.dk", true },
  { "degen-elektrotechnik.de", true },
  { "degestamptepot.nl", true },
  { "degit.de", true },
  { "degoticapunk.xyz", true },
  { "degoulet.net", true },
  { "degracetechnologie.com", true },
  { "degrasboom.nl", true },
  { "degroupage.info", true },
  { "dehopre.com", true },
  { "deidee.nl", true },
  { "deimos.gq", true },
  { "dein-baumdienst.de", true },
  { "dein-trueffel.de", true },
  { "deinballon.de", true },
  { "deinewebsite.de", true },
  { "deinfoto.ch", true },
  { "deitti.net", true },
  { "dejan.media", true },
  { "dejandayoff.com", true },
  { "dejting-sidor.com", true },
  { "dejure.org", true },
  { "dejw.cz", true },
  { "dekasegi-kansai.com", true },
  { "dekasiba.com", true },
  { "dekeurslagers.nl", true },
  { "dekkercreativedesign.nl", true },
  { "dekko.io", true },
  { "dekoh-shouyu.com", true },
  { "dekonix.ru", true },
  { "dekulk.nl", true },
  { "delahrzolder.nl", true },
  { "delam.site", true },
  { "delbecqvo.be", true },
  { "deleenheir.be", true },
  { "deleidscheflesch.nl", true },
  { "delfic.org", true },
  { "delfino.cr", true },
  { "delhionlinegifts.com", true },
  { "deli-tochigi.jp", true },
  { "deliacreates.com", true },
  { "deliandiver.org", true },
  { "deliberatedigital.com", true },
  { "deliciisanatoase.ro", true },
  { "deliciousmedia.co.uk", true },
  { "deliciousmedia.net", true },
  { "delicioustable.com", true },
  { "delid.cz", true },
  { "deliver.moe", true },
  { "delkniga42.ru", true },
  { "dellipaoli.com", true },
  { "delogo.nl", true },
  { "delopt.co.in", true },
  { "delorenzi.dk", true },
  { "delphia.ai", true },
  { "delphia.com", true },
  { "delphine.dance", true },
  { "delta-data.ch", true },
  { "delta-smart.ch", true },
  { "delta.ru", true },
  { "delta23.de", false },
  { "deltaacademy.org", true },
  { "deltadata.ch", true },
  { "deltafinanceiro.com.br", true },
  { "deltanio.nl", true },
  { "deltaonlineguards.com", true },
  { "deltaservers.blog.br", true },
  { "deltaservers.com.br", true },
  { "deltasigmachi.org", true },
  { "deltava.org", true },
  { "deltawolf.tk", true },
  { "demarle.ch", true },
  { "dementiapraecox.de", true },
  { "demeyere-usedcars.be", true },
  { "demfloro.ru", true },
  { "demibaguette.com", true },
  { "demijn.nl", true },
  { "demilletech.net", true },
  { "demiranda.com", true },
  { "demmer.one", true },
  { "demo.swedbank.se", true },
  { "democracychronicles.com", true },
  { "democracyineurope.eu", true },
  { "democraziaineuropa.eu", true },
  { "demolandia.net", true },
  { "demomanca.com", true },
  { "demoniak.ch", true },
  { "demonwav.com", true },
  { "demonwolfdev.com", true },
  { "demotivatorbi.ru", true },
  { "dempsters.ca", false },
  { "demuzere.be", true },
  { "denabot.pw", true },
  { "denaehula.com", true },
  { "denali.net", true },
  { "denardbrewing.com", true },
  { "denariu.net", true },
  { "denbkh.ru", true },
  { "dengchangdong.com", true },
  { "dengode.eu", true },
  { "denied.gr", true },
  { "denimtoday.com", true },
  { "denis-martinez.photos", true },
  { "denisewakeman.com", true },
  { "denistruffaut.fr", false },
  { "deniszczuk.pl", true },
  { "denizdesign.co.uk", true },
  { "denkeandersblog.de", true },
  { "denkmalagentur.ch", true },
  { "denkubator.de", true },
  { "dennisang.com", true },
  { "dennisdoes.net", false },
  { "denniskoot.nl", true },
  { "dennismurphy.biz", true },
  { "dennogumi.org", true },
  { "denous.nl", true },
  { "dent.uy", true },
  { "dental-cloud.eu", true },
  { "dental-colleges.com", true },
  { "dentallaborgeraeteservice.de", true },
  { "dentanestplus.com", true },
  { "dentechnica.co.uk", true },
  { "dentistesdarveauetrioux.com", true },
  { "dentistglasgow.com", true },
  { "dentrassi.de", true },
  { "dentystabirmingham.co.uk", true },
  { "denuevestore.com", true },
  { "denvergospelhall.org", true },
  { "denwauranailab.com", true },
  { "deonlinespecialist.nl", true },
  { "deontology.com", true },
  { "depaco.com", true },
  { "depaddestoeltjes.be", true },
  { "depannage-traceur.fr", true },
  { "deparis.me", true },
  { "depeces.com", true },
  { "depechemode-live.com", true },
  { "deped.io", true },
  { "depedclub.net", true },
  { "depedncr.com", true },
  { "depedsurigaodelnorte.com", true },
  { "depedtalks.com", true },
  { "depedtambayan.net", true },
  { "depedtambayan.org.ph", true },
  { "depedtayo.com", true },
  { "depedtayo.ph", true },
  { "depicus.com", true },
  { "depilacioncon.com", true },
  { "deplorablesdaily.com", true },
  { "depone.net", true },
  { "depop.com", true },
  { "depositart.com", true },
  { "depositomobili.it", true },
  { "depotsquarekerrville.com", true },
  { "depotter-usedcars.be", true },
  { "deprecate.de", true },
  { "depth-co.jp", true },
  { "depthe.gr", true },
  { "depuratori.milano.it", true },
  { "der-bank-blog.de", true },
  { "der-fliesenzauberer.de", true },
  { "der-gardinenmann.de", true },
  { "der-lan.de", true },
  { "der-rudi.eu", true },
  { "der-stein-fluesterer.de", true },
  { "der-windows-papst.de", true },
  { "derattizzazione.name", true },
  { "derattizzazioni.biz", true },
  { "derattizzazioni.milano.it", true },
  { "derattizzazioni.org", true },
  { "derbuntering.de", true },
  { "derbybouncycastles.com", true },
  { "derbyware.com", true },
  { "derdewereldrommelmarkt.nl", true },
  { "dereferenced.net", true },
  { "derehamcastles.co.uk", true },
  { "derekbooth.co.uk", true },
  { "derekheld.com", true },
  { "derekkent.com", true },
  { "derekseaman.com", true },
  { "derekseaman.studio", true },
  { "derf.red", true },
  { "derf.us", true },
  { "dergeilstestammderwelt.de", true },
  { "derhil.de", true },
  { "derivedata.com", true },
  { "derma-expert.eu", true },
  { "dermapuur.nl", true },
  { "dermato.floripa.br", true },
  { "dermatologie-morges.ch", true },
  { "dermediq.nl", true },
  { "dermopigmentista.it", true },
  { "dermot.org.uk", true },
  { "dermscc.com", true },
  { "deroo.org", true },
  { "derp.army", true },
  { "derp.chat", true },
  { "derpy.pp.ua", true },
  { "derre.fr", true },
  { "derreichesack.com", true },
  { "dersoundhunter.de", true },
  { "derw.pw", true },
  { "des-hommes-et-des-clous.com", true },
  { "desafiomovilidadsustentable.com", true },
  { "desagaz.com", true },
  { "desarrollowp.com", true },
  { "descartes-finance.com", true },
  { "desec.io", true },
  { "desenfans.com", true },
  { "desentupidorapernambucana.com.br", true },
  { "desertmedaesthetics.com", true },
  { "desertsounds.org", true },
  { "desgenst.ch", true },
  { "design-in-bad.eu", true },
  { "design-tooning.de", true },
  { "designed-cybersecurity.com", true },
  { "designedbygeniuses.com", true },
  { "designedcybersecurity.com", true },
  { "designer-drug.com", true },
  { "designera.se", true },
  { "designerchad.com", true },
  { "designhotel-kronjuwel.de", true },
  { "designhuddle.com", true },
  { "designsbyjanith.com", true },
  { "designskin.ch", true },
  { "designville.cz", true },
  { "designville.sk", true },
  { "desila.jp", true },
  { "deskaservices.com", true },
  { "deskdesign.nl", true },
  { "deskeen.fr", true },
  { "deskguide.info", true },
  { "desktopd.eu.org", true },
  { "desktopfx.net", false },
  { "deskture.com", true },
  { "desmaakvanplanten.be", true },
  { "desormiers.com", true },
  { "despertadoronline.com.es", true },
  { "desplats.com.ar", true },
  { "dessinemoilademocratie.ch", true },
  { "destech.nl", true },
  { "destinattorneyjohngreene.com", true },
  { "destinoytarot.com", true },
  { "destinyofthephoenix.me", false },
  { "desu.ne.jp", true },
  { "desuchan.eu", true },
  { "desuchan.org", true },
  { "desynced.rocks", true },
  { "det-te.ch", true },
  { "detalika.ru", true },
  { "detalyedesigngroup.com", true },
  { "detao.org", true },
  { "detecmon.com", true },
  { "detecte-fuite.ch", true },
  { "detecte.ch", true },
  { "detectefuite.ch", true },
  { "detectify.com", false },
  { "detectivedesk.com.au", true },
  { "detekenmuze.nl", true },
  { "determapp.de", true },
  { "dethemium.com", true },
  { "dethikiemtra.com", true },
  { "detodojuegos.com", true },
  { "detoxetmoi.com", true },
  { "detoxic.vn", true },
  { "detroit-english.de", true },
  { "detroitzoo.org", true },
  { "detskysad.com", true },
  { "detuinmuze.nl", true },
  { "detusmascotas.com", true },
  { "detype.nl", true },
  { "deuchnord.fr", true },
  { "deude.de", true },
  { "deukie.nl", true },
  { "deumavan.ch", true },
  { "deurenfabriek.nl", true },
  { "deutsch-vietnamesisch-dolmetscher.com", true },
  { "deutsche-seniorenbetreuung.de", true },
  { "deutsche-tageszeitungen.de", true },
  { "deutschebusiness.com", true },
  { "deutscher-bericht.de", true },
  { "deutscher-rollenspielpreis.de", true },
  { "deutscheshoponline.com", true },
  { "deutschland-dsl.de", true },
  { "deuxmetrescubes.fr", true },
  { "dev-brandywineglobal.com", true },
  { "dev-greavesindia.pantheonsite.io", true },
  { "dev-gutools.co.uk", true },
  { "dev-pulse-mtn.pantheonsite.io", true },
  { "dev-sev-web.pantheonsite.io", true },
  { "dev-tek.de", true },
  { "devagency.fr", true },
  { "devalps.eu", true },
  { "devapi.pro", true },
  { "devb.nl", true },
  { "devcf.com", true },
  { "devcoins.org", true },
  { "devct.cz", false },
  { "devcu.com", true },
  { "devcu.net", true },
  { "devdeb.com", true },
  { "devel.cz", true },
  { "develop.cool", true },
  { "develope.cz", true },
  { "developer.android.com", true },
  { "developer.moe", true },
  { "developer.mydigipass.com", false },
  { "developerdan.com", true },
  { "developermail.io", false },
  { "developers.facebook.com", false },
  { "developfx.com", true },
  { "developmentaid.org", true },
  { "developmentsites.melbourne", true },
  { "develops.co.il", true },
  { "developyourelement.com", true },
  { "develux.com", true },
  { "develux.net", true },
  { "devh.net", true },
  { "deviajesturismo.com", true },
  { "deviant.email", true },
  { "devillers-occasions.be", true },
  { "devils-point.de", true },
  { "devilshakerz.com", true },
  { "deviltraxxx.de", true },
  { "devinfo.net", false },
  { "devinite.com", true },
  { "devirc.net", true },
  { "devisnow.fr", true },
  { "devklog.net", true },
  { "devlamvzw.org", false },
  { "devlatron.net", true },
  { "devlogr.com", true },
  { "devnull.zone", true },
  { "devonsawatzky.ca", true },
  { "devopers.com.br", true },
  { "devops-survey.com", true },
  { "devragu.com", true },
  { "devrandom.net", true },
  { "devries.one", true },
  { "devsjournal.com", true },
  { "devsrvr.ru", true },
  { "devstaff.gr", true },
  { "devstroke.io", true },
  { "devswag.io", true },
  { "devtoys.ru", true },
  { "devtty.org", true },
  { "devzero.io", true },
  { "dewaard.de", true },
  { "dewalch.net", true },
  { "dewapress.com", true },
  { "dewinter.com", true },
  { "dewolden.nl", true },
  { "dex.top", true },
  { "dexalo.de", true },
  { "dexigner.com", true },
  { "dexonrest.azurewebsites.net", true },
  { "dexonservicedeskws.azurewebsites.net", true },
  { "deyute.com", true },
  { "dez-online.de", true },
  { "dezeregio.nl", true },
  { "dezet-ev.de", true },
  { "dezmembrariromania.ro", true },
  { "dezshop24.de", true },
  { "dezzoroofing.co.za", true },
  { "df1paw.de", true },
  { "df3312.com", true },
  { "df3313.com", true },
  { "df3314.com", true },
  { "df3315.com", true },
  { "df3316.com", true },
  { "df3317.com", true },
  { "df3318.com", true },
  { "df3319.com", true },
  { "dfctaiwan.org", true },
  { "dfekt.no", true },
  { "dfektlan.no", true },
  { "dfl.mn", false },
  { "dflcares.com", true },
  { "dfmn.berlin", true },
  { "dfranke.com", true },
  { "dg7.in", true },
  { "dgblaw.com.au", false },
  { "dgbouncycastlehire.com", true },
  { "dgeex.eu", true },
  { "dggm.ru", true },
  { "dgitup.com", true },
  { "dgportals.co.uk", true },
  { "dgpot.com", true },
  { "dgt-portal.de", true },
  { "dgx.io", true },
  { "dh6729.com", true },
  { "dh9397.com", true },
  { "dh9721.com", true },
  { "dharveydev.com", true },
  { "dhautefeuille.eu", true },
  { "dhauwer.nl", true },
  { "dhaynes.xyz", true },
  { "dhconcept.ch", true },
  { "dheart.net", true },
  { "dhedegaard.dk", true },
  { "dhelixnet.de", true },
  { "dhemant.de", true },
  { "dhhs.gov", true },
  { "dhinflatables.co.uk", true },
  { "dhlinux.org", true },
  { "dhome.at", true },
  { "dhuy.net", false },
  { "di2pra.com", true },
  { "di2pra.fr", true },
  { "dia-de.com", true },
  { "dia.com.br", true },
  { "diabetessucks.net", true },
  { "diablovalleytech.com", true },
  { "diadorafitness.it", true },
  { "diagnoseo.com", true },
  { "diagnoseo.pl", true },
  { "diagnoseo.se", true },
  { "dialapicnic.co.za", true },
  { "dialect-agency.eu.org", true },
  { "dialoegue.com", true },
  { "diamante.ro", true },
  { "diamantovaburza.cz", true },
  { "diamond-hairstyle.dk", true },
  { "diamondgrid.ga", true },
  { "diamondsleepsolutions.com", true },
  { "diamondyze.nl", true },
  { "diamorphine.com", true },
  { "diamsmedia.ch", true },
  { "dianafaraj.de", true },
  { "dianefriedli.ch", true },
  { "dianurse.com", true },
  { "diare-na-miru.cz", true },
  { "diario-egipto.com", true },
  { "diaroma.it", true },
  { "diarynote.jp", true },
  { "diasdasemana.com", true },
  { "diasp.org", true },
  { "diatrofi-ygeia.gr", true },
  { "diavo.de", true },
  { "diba.org.cn", true },
  { "dibiphp.com", true },
  { "diccionarioabierto.com", true },
  { "diccionariodedudas.com", true },
  { "diccionarqui.com", true },
  { "dice.tokyo", true },
  { "dicelab-rhul.org", true },
  { "dicelab.co.uk", true },
  { "dicesites.com", true },
  { "dicio.com.br", true },
  { "dicionario.org", true },
  { "dicionariodegirias.com.br", true },
  { "dicionariodelatim.com.br", true },
  { "dicionariodenomesproprios.com.br", true },
  { "dicionariodesimbolos.com.br", true },
  { "dicionarioetimologico.com.br", true },
  { "dicionariofinanceiro.com", true },
  { "dicionariopopular.com", true },
  { "dicionarios.cc", true },
  { "dickord.cloud", true },
  { "dickord.club", true },
  { "dickpics.ru", true },
  { "dicksakowicz.com", true },
  { "dicoding.com", true },
  { "dictionaryofnumbers.com", true },
  { "dictionarypro.net", true },
  { "dictzone.com", true },
  { "didacte.com", true },
  { "didche.net", true },
  { "diddens.de", true },
  { "dideeducacion.com", true },
  { "didefamilia.com", true },
  { "didesalud.com", true },
  { "didierghez.com", true },
  { "didierlaumen.be", true },
  { "didigotoffer.com", true },
  { "didtrumpopengovernmentyet.com", true },
  { "die-bergfuehrer.de", true },
  { "die-besten-bewertungen.de", true },
  { "die-blahuts.de", true },
  { "die-borts.ch", true },
  { "die-gruenen-teufel.de", true },
  { "die-machons.de", true },
  { "die-partei-reutlingen.de", true },
  { "die-pizzabaeckerei.de", true },
  { "die-pleners.de", true },
  { "die-seide.de", true },
  { "die-seiler.de", true },
  { "die-sinlosen.de", true },
  { "die-speisekammer-reutlingen.de", true },
  { "diebestengutscheine.de", true },
  { "diebestenvpn.de", true },
  { "diedrich.co", true },
  { "dieecpd.org", true },
  { "diegelernten.de", true },
  { "diegerbers.de", true },
  { "diegogelin.com", true },
  { "diegorbaquero.com", true },
  { "diegotoledo.com.br", true },
  { "diehl.io", true },
  { "diekperaiwseis.gr", true },
  { "diem-project.org", true },
  { "diemattels.at", true },
  { "dienchaninstitute.com", true },
  { "diendorfer.space", true },
  { "dienstplan.cc", true },
  { "dienstplan.one", true },
  { "dierabenmutti.de", true },
  { "dieradvies.nl", true },
  { "dierenartsdeconinck.be", true },
  { "dieselanimals.lt", true },
  { "dieselgalleri.com", true },
  { "diesteppenreiter.de", true },
  { "dietaanticelulitica.com", true },
  { "dietaanticelulitis.com", true },
  { "dietacelulitis.com", true },
  { "dietafeliz.com", true },
  { "dieterglas.de", true },
  { "dietergreven.de", false },
  { "dieterstinglhamber.me", false },
  { "dietervandenbroeck.be", true },
  { "diethood.com", true },
  { "dieti.net", true },
  { "dietlin.com", true },
  { "dietrich.cx", true },
  { "dieumfrage.com", true },
  { "different.cz", false },
  { "differenta.ro", false },
  { "diffnow.com", true },
  { "difoosion.com", true },
  { "difusordeambientes.com.br", true },
  { "digaxtest.com", true },
  { "digcit.org", true },
  { "digdata.de", true },
  { "dighans.com", true },
  { "digiarc.net", true },
  { "digibild.ch", true },
  { "digibones.be", true },
  { "digibull.email", true },
  { "digibull.link", true },
  { "digicert-support.com", true },
  { "digicode.hu", true },
  { "digicy.cloud", true },
  { "digideli.ee", true },
  { "digidroom.be", true },
  { "digilicious.com", true },
  { "digimagical.com", true },
  { "digimedia.cd", false },
  { "digioccumss.ddns.net", true },
  { "digipost.no", true },
  { "digired.ro", true },
  { "digit.ec", true },
  { "digital-compounds.com", true },
  { "digital-eastside.de", true },
  { "digital-insurance-engine.com", true },
  { "digital-insurance-engine.de", true },
  { "digital-insurance-platform.com", true },
  { "digital-insurance-platform.de", true },
  { "digital-liberal.ch", true },
  { "digital-muscle.com.au", true },
  { "digital-sculpture.org", true },
  { "digital.gov", false },
  { "digital.govt.nz", true },
  { "digital1st.co.uk", true },
  { "digitalallies.co.uk", true },
  { "digitalarchitecture.com", true },
  { "digitalbitbox.com", true },
  { "digitalblood.eu", true },
  { "digitalcitizen.life", true },
  { "digitalcitizen.ro", true },
  { "digitalcraftmarketing.co.uk", true },
  { "digitalcreationclass.com", true },
  { "digitaldatacenter.net", true },
  { "digitaldeli.com", true },
  { "digitaldeli.org", true },
  { "digitaldeli.tv", true },
  { "digitaldeli.us", true },
  { "digitaldeliarchive.com", true },
  { "digitaldem.it", true },
  { "digitalehandtekeningen.nl", true },
  { "digitaleoverheid.nl", false },
  { "digitaleplus.fr", true },
  { "digitaletanker.com", true },
  { "digitalezukunft-hagen.de", true },
  { "digitalezukunft.nrw", true },
  { "digitalfishfun.com", true },
  { "digitalfoster.org", true },
  { "digitalfury.co.uk", true },
  { "digitalfuturenow.com", true },
  { "digitalgov.gov", true },
  { "digitalhabit.at", true },
  { "digitalhabitat.io", true },
  { "digitalid-sandbox.com", true },
  { "digitalid.com", true },
  { "digitalid.com.au", true },
  { "digitalliteracy.gov", true },
  { "digitalmarketingindallas.com", true },
  { "digitalposition.com", true },
  { "digitalprimate.my", true },
  { "digitalredshirts.com", true },
  { "digitalrights.center", true },
  { "digitalrights.fund", true },
  { "digitalskillswap.com", true },
  { "digitalspiders.pk", true },
  { "digitalsurge.io", true },
  { "digitaltcertifikat.dk", true },
  { "digitaltechnologies.ltd.uk", true },
  { "digitalunite.de", true },
  { "digitec.ch", true },
  { "digitecgalaxus.ch", true },
  { "digitise.io", true },
  { "digitkon.com", true },
  { "digitreads.com", true },
  { "digminecraft.com", true },
  { "digwp.com", true },
  { "dihesan.com", true },
  { "dijitaller.com", true },
  { "dijkmanmuziek.nl", false },
  { "dijkmanvandoorn.nl", false },
  { "diju.ch", true },
  { "dilberkebab.co.uk", true },
  { "dildoexperten.se", true },
  { "diletec.com.br", true },
  { "diligo.ch", true },
  { "dillewijnzwapak.nl", true },
  { "dillonkorman.com", true },
  { "dimagrimentoincorso.it", true },
  { "dimanet.fr", true },
  { "dimanss47.net", true },
  { "dimdom.com.br", true },
  { "dime-staging.com", true },
  { "dime.io", true },
  { "dimeponline.com.br", true },
  { "dimez.ru", true },
  { "dimiskovska.de", true },
  { "dimitrihomes.com", true },
  { "dimmersagourahills.com", true },
  { "dimmerscalabasas.com", true },
  { "dimmersdosvientos.com", true },
  { "dimmershiddenhills.com", true },
  { "dimmerslakesherwood.com", true },
  { "dimmersnewburypark.com", true },
  { "dimmersoakpark.com", true },
  { "dimmersthousandoaks.com", true },
  { "dimmerswestlakevillage.com", true },
  { "dimonb.com", true },
  { "din-hkd.jp", true },
  { "dineachook.com.au", true },
  { "dinepont.fr", true },
  { "dinerroboticurology.com", true },
  { "dingsbums.shop", true },
  { "dinheirolucrar.com", true },
  { "dinkommunikasjon.no", true },
  { "dinmtb.dk", true },
  { "dino.lol", true },
  { "dinocarrozzeria.com", true },
  { "dinstec.cl", true },
  { "dintrafic.net", true },
  { "diodeled.com", true },
  { "diodo.me", true },
  { "dionysos-ios.gr", true },
  { "diozoid.com", true },
  { "dipalma.me", true },
  { "dipdaq.com", true },
  { "dipling.de", true },
  { "diplomatiq.org", true },
  { "diplona.de", true },
  { "dipro.id", true },
  { "dipulse.it", true },
  { "dir2epub.com", true },
  { "dir2epub.org", true },
  { "dirba.io", true },
  { "direct-sel.com", true },
  { "direct.cz", true },
  { "direct365.es", true },
  { "directebanking.com", true },
  { "directelectricalltd.co.uk", true },
  { "directfinance.cz", true },
  { "directhomeremodelinginc.com", true },
  { "directlinkfunding.co.uk", true },
  { "directnews.be", true },
  { "directoriostelefonicos.com", true },
  { "directorioz.com", true },
  { "directoryhub.io", true },
  { "directreal.sk", true },
  { "directscripts.com", true },
  { "directspa.fr", true },
  { "direktvermarktung-schmitzberger.at", true },
  { "dirk-scheele.de", true },
  { "dirk-weise.de", true },
  { "dirkdoering.de", true },
  { "dirkjonker.nl", true },
  { "dirko.net", true },
  { "dirkwolf.de", true },
  { "dirtcraft.ca", true },
  { "dirtinmyshoes.com", true },
  { "dirtyincest.com", true },
  { "dirtyprettyartwear.com", true },
  { "dirtytiles.xyz", true },
  { "disability.gov", true },
  { "disabled.dating", true },
  { "disanteimpianti.com", true },
  { "disavow.tools", true },
  { "disc.uz", true },
  { "discarica.bari.it", true },
  { "discarica.bologna.it", true },
  { "discarica.firenze.it", true },
  { "discarica.it", true },
  { "discarica.milano.it", true },
  { "discarica.roma.it", true },
  { "disch.com.de", true },
  { "dischempharmacie.com", true },
  { "disciples.io", true },
  { "discofitta.com", true },
  { "disconformity.net", true },
  { "discord.gg", true },
  { "discord4j.com", true },
  { "discordapp.com", true },
  { "discordbee.com", true },
  { "discordghost.space", true },
  { "discordia.me", true },
  { "discordservers.com", true },
  { "discotek.club", true },
  { "discount24.de", true },
  { "discountlumberspokane.com", true },
  { "discountplush.com", true },
  { "discover-shaken.com", true },
  { "discoverthreejs.com", true },
  { "discoverucluelet.com", true },
  { "discoveryaima.com", true },
  { "discoveryballoon.org", true },
  { "discreet-condooms.nl", true },
  { "discrypt.ca", true },
  { "discus-communications.dk", true },
  { "dise-online.de", true },
  { "disinclined.org", true },
  { "disinfesta.it", true },
  { "disinfestando.info", true },
  { "disinfestatori.com", true },
  { "disinfestazione.brescia.it", true },
  { "disinfestazione.torino.it", true },
  { "disinfestazione.venezia.it", true },
  { "disinfestazione.verona.it", true },
  { "disinfestazione24.it", true },
  { "disinfestazioneblatte.it", true },
  { "disinfestazionecimici.roma.it", true },
  { "disinfestazioni-umbria.it", true },
  { "disinfestazioni.bari.it", true },
  { "disinfestazioni.bergamo.it", true },
  { "disinfestazioni.catania.it", true },
  { "disinfestazioni.co", true },
  { "disinfestazioni.firenze.it", true },
  { "disinfestazioni.genova.it", true },
  { "disinfestazioni.gorizia.it", true },
  { "disinfestazioni.info", true },
  { "disinfestazioni.milano.it", true },
  { "disinfestazioni.napoli.it", true },
  { "disinfestazioni.net", true },
  { "disinfestazioni.padova.it", true },
  { "disinfestazioni.rimini.it", true },
  { "disinfestazioni.torino.it", true },
  { "disinfestazioni.treviso.it", true },
  { "disinfestazioni.udine.it", true },
  { "disinfestazioni.venezia.it", true },
  { "disinfestazioni.verona.it", true },
  { "disinfestazionivespe.milano.it", true },
  { "disinfestazionizanzare.milano.it", true },
  { "disinfestazionizanzare.roma.it", true },
  { "disinisharing.com", true },
  { "disk.do", true },
  { "diskbit.com", true },
  { "diskbit.nl", true },
  { "disking.co.uk", true },
  { "dismail.de", true },
  { "displayenergycertificate.co.uk", true },
  { "disposable.link", true },
  { "disroot.org", true },
  { "disrupters.ch", true },
  { "dissertationhelp.com", true },
  { "dissidence.ovh", true },
  { "dissieux.com", true },
  { "dist-it.com", true },
  { "dist.torproject.org", false },
  { "disti.com", true },
  { "distiduffer.org", true },
  { "distillery.com", true },
  { "distinguishedprisoner.com", true },
  { "distracteddriving.gov", true },
  { "distraction.gov", true },
  { "distratus.com", true },
  { "distribuidoracristal.com.br", true },
  { "distribuidoraplus.com", true },
  { "distribuidorveterinario.es", true },
  { "distro.fr", true },
  { "ditelbat.com", true },
  { "diti.me", true },
  { "ditisabc.nl", true },
  { "div.im", true },
  { "diva.nl", true },
  { "divari.nl", true },
  { "divcoder.com", true },
  { "dive-japan.com", true },
  { "divedowntown.com", true },
  { "divegearexpress.com", true },
  { "divegearexpress.net", true },
  { "diveidc.com", true },
  { "diveplan.org", true },
  { "diversifiedproduct.com", true },
  { "diversityflags.com", true },
  { "diversityflags.com.au", true },
  { "diversityflags.nz", true },
  { "divertiagua.com.br", true },
  { "divewithfrank.com", true },
  { "divi-experte.de", true },
  { "dividendz.net", true },
  { "divinasaiamodas.com.br", true },
  { "divinegames.studio", true },
  { "divineglowinghealth.com", true },
  { "divinemercyparishvld.com", true },
  { "diving.photo", true },
  { "divingforlife.org", true },
  { "divisuite.com", true },
  { "divorcelawyersformen.com", true },
  { "divorciosmurcia.com", true },
  { "diwei.vip", true },
  { "dixi.fi", true },
  { "dixibox.com", true },
  { "diybook.at", true },
  { "diycc.org", true },
  { "diygeek.com", true },
  { "diymediahome.org", true },
  { "diyosun.com", true },
  { "diytechguides.com", true },
  { "diyvideoeditor.com", true },
  { "dizzie.org", true },
  { "dizzythewizard.co.uk", true },
  { "dj-leszwolle.nl", true },
  { "dj-x.info", true },
  { "dj3dub.com", true },
  { "djangobirthday.com", true },
  { "djangoproject.com", true },
  { "djangosnippets.org", true },
  { "djbbouncycastles.co.uk", true },
  { "djbobbytables.com", true },
  { "djboekingskantoor.nl", true },
  { "djc.me", true },
  { "djcursuszwolle.nl", true },
  { "djdavid98.hu", true },
  { "djfrenchy.com", true },
  { "djipanov.com", true },
  { "djleon.net", true },
  { "djlinux.cz", true },
  { "djlive.pl", true },
  { "djlnetworks.co.uk", true },
  { "djsbouncycastlehire.com", true },
  { "djt-vom-chausseehaus.de", true },
  { "djvintagevinyl.com", true },
  { "djvintagevinyl.nl", true },
  { "djwaynepryke.com", true },
  { "dk-kromeriz.cz", true },
  { "dk.com", true },
  { "dk.search.yahoo.com", false },
  { "dkcomputers.com.au", true },
  { "dkds.us", true },
  { "dko-steiermark.ml", true },
  { "dkstage.com", true },
  { "dkwedding.gr", true },
  { "dl.google.com", true },
  { "dlaspania.pl", true },
  { "dlbouncers.co.uk", true },
  { "dlde.ru", true },
  { "dldl.fr", true },
  { "dleger.space", true },
  { "dlfsymposium.nl", true },
  { "dlitz.net", true },
  { "dll4free.com", true },
  { "dlld.biz", true },
  { "dlld.com", true },
  { "dlld.info", true },
  { "dlld.org", true },
  { "dlld.us", true },
  { "dlrsp.org", true },
  { "dlscomputers.com.au", true },
  { "dlui.xyz", true },
  { "dlunch.net", true },
  { "dlz149.me", true },
  { "dlzz.net", true },
  { "dm.lookout.com", false },
  { "dm.mylookout.com", false },
  { "dm4productions.com", true },
  { "dm7ds.de", true },
  { "dmaglobal.com", true },
  { "dmailshop.ro", true },
  { "dmarc.dk", true },
  { "dmarc.tech", true },
  { "dmatrix.xyz", true },
  { "dmd.lv", true },
  { "dmdd.org.uk", true },
  { "dmess.ru", true },
  { "dmfj.io", true },
  { "dmhtwebordering.com", true },
  { "dmi.es", true },
  { "dmitry.sh", true },
  { "dmk-realestate.com", true },
  { "dmmkenya.co.ke", false },
  { "dmmultionderhoud.nl", true },
  { "dmn.sh", true },
  { "dmoj.ca", true },
  { "dmparish.com", true },
  { "dmschilderwerken.nl", true },
  { "dn3s.me", true },
  { "dn42.eu", false },
  { "dn42.us", true },
  { "dna.li", true },
  { "dnacloud.pl", true },
  { "dnakids.co.uk", true },
  { "dnalounge.com", true },
  { "dnapizza.com", true },
  { "dnc.org.nz", true },
  { "dndtools.net", true },
  { "dnlr.tech", true },
  { "dnmlab.it", true },
  { "dnplegal.com", true },
  { "dns-control.eu", true },
  { "dns-swiss.ch", true },
  { "dns.google.com", true },
  { "dns8.online", true },
  { "dnsaio.com", true },
  { "dnscrawler.com", true },
  { "dnscrypt-blacklist.tk", true },
  { "dnscrypt.info", true },
  { "dnscrypt.nl", true },
  { "dnscurve.io", true },
  { "dnshallinta.fi", true },
  { "dnskeep.com", true },
  { "dnskeeper.com", true },
  { "dnsman.se", true },
  { "dnspod.ml", true },
  { "dnsrate.com", true },
  { "dnstwister.report", true },
  { "do-prod.com", true },
  { "do.gd", true },
  { "do.search.yahoo.com", false },
  { "do13.net", true },
  { "do67.de", true },
  { "do67.net", true },
  { "dobraprace.cz", false },
  { "dobre-programy.xyz", true },
  { "dobreprogramy.pro", true },
  { "dobrisan.ro", true },
  { "doc.ai", true },
  { "doc.python.org", true },
  { "doc.to", false },
  { "doc8643.com", true },
  { "docabo.ch", true },
  { "docassure.de", true },
  { "docbox.ch", true },
  { "docdoc.ru", true },
  { "doceamoraviverbem.com", true },
  { "docemeldoces.com", true },
  { "dochimera.com", true },
  { "dochitaceahlau.ro", true },
  { "dockerbook.com", false },
  { "dockerup.net", true },
  { "docline.gov", true },
  { "docloudu.info", true },
  { "docplexus.com", true },
  { "docs.google.com", false },
  { "docs.python.org", true },
  { "docs.re", true },
  { "docs.tw", true },
  { "docsoc.org.uk", true },
  { "doctabaila.com", true },
  { "doctafit.com", true },
  { "doctor-locks.co.uk", true },
  { "doctor.dating", true },
  { "doctorbini.com", true },
  { "doctorfox.co.uk", true },
  { "doctorsonmaps.com", true },
  { "doctorwho.cz", true },
  { "doctorxdentist.com", true },
  { "docubox.info", true },
  { "docucopies.com", true },
  { "docudanang.com.vn", true },
  { "documaniatv.com", true },
  { "docusearch.com", true },
  { "doda.space", true },
  { "dodds.cc", true },
  { "dodopri.com", true },
  { "doenjoylife.com", true },
  { "doeren.com", true },
  { "does.one", true },
  { "doesburg-comp.nl", true },
  { "dofuspvp.com", true },
  { "dofux.org", true },
  { "dogadayiz.net", true },
  { "dogan.ch", false },
  { "dogcontrol.ca", true },
  { "dogear.ch", true },
  { "dogforum.de", true },
  { "dogft.com", true },
  { "doggedbyirs.com", true },
  { "doggo.cloud", true },
  { "doggo.dance", true },
  { "doggo.email", true },
  { "doggroomingcourse.com", true },
  { "doggybag-committee.com", true },
  { "dogmap.jp", true },
  { "dogodki.today", true },
  { "dogoo.com", true },
  { "dogpawstudio.com", true },
  { "dogrescuegreece.nl", true },
  { "dogworld.com.br", true },
  { "dohanews.co", true },
  { "doihavetoputonpants.com", true },
  { "doitauto.de", true },
  { "dojozendebourges.fr", true },
  { "dokelio-idf.fr", true },
  { "doki.space", true },
  { "dokipy.no", true },
  { "dokuboard.com", true },
  { "dolci-delizie.de", true },
  { "dolciterapie.com", true },
  { "doleta.gov", true },
  { "doli.se", true },
  { "dolice.net", true },
  { "dolinathome.com", true },
  { "dollarrp.pl", true },
  { "dollemore.com", true },
  { "dollhousetoyo.com", true },
  { "dolorism.com", true },
  { "dolph.de", true },
  { "dom-medicina.ru", true },
  { "doma.in", true },
  { "domadillo.com", true },
  { "domain-ermittlung.de", true },
  { "domain-swiss.ch", true },
  { "domain001.info", true },
  { "domainedemiolan.ch", true },
  { "domainexpress.de", false },
  { "domainkauf.de", true },
  { "domainoo.com", true },
  { "domains.autos", true },
  { "domains.boats", true },
  { "domains.google.com", true },
  { "domains.motorcycles", true },
  { "domains.yachts", true },
  { "domainsilk.com", true },
  { "domainspeicher.com", true },
  { "domainspeicher.one", true },
  { "domainstaff.com", true },
  { "domainvoider.cf", true },
  { "domakidis.com", true },
  { "domarkperu.com", true },
  { "domaxpoker.com", true },
  { "domeconseil.fr", true },
  { "domein-direct.nl", true },
  { "domenic.me", true },
  { "domenicam.com", true },
  { "domesticcleaners.co.uk", true },
  { "domfee.com", true },
  { "domhaase.me", true },
  { "domian.cz", true },
  { "dominationgame.co.uk", true },
  { "dominctheroofguy.com", true },
  { "dominicself.co.uk", true },
  { "dominik-bergmann.de", true },
  { "dominik-schlueter.de", true },
  { "dominik.st", true },
  { "dominikaner-vechta.de", true },
  { "dominikkulaga.pl", true },
  { "dominionregistries.domains", true },
  { "dominique-haas.fr", false },
  { "dominoknihy.cz", true },
  { "dominomatrix.com", true },
  { "dommascate.com.br", true },
  { "domob.eu", true },
  { "domodeco.fr", true },
  { "domodedovo.travel", true },
  { "domop.cc", true },
  { "domop.net", true },
  { "domop.org", true },
  { "domprojects.com", true },
  { "domscripting.com", true },
  { "domster.com", true },
  { "domus-global.com", true },
  { "domus-global.cz", true },
  { "domwkwiatach.pl", true },
  { "domyassignments.com", true },
  { "domycasestudy.com", true },
  { "domycoursework.com", true },
  { "domycreativewritings.com", true },
  { "domydissertations.com", true },
  { "domyessay.net", true },
  { "domyessays.com", true },
  { "domyhomeworks.net", true },
  { "domynetwork.com", true },
  { "domypapers.com", true },
  { "domyresearchpaper.com", true },
  { "domyreview.net", true },
  { "domyspeech.com", true },
  { "domytermpaper.com", true },
  { "domythesis.net", true },
  { "domyzitrka.cz", true },
  { "domznak.ru", true },
  { "donabeneko.jp", true },
  { "donaldm.co.uk", true },
  { "donateaday.net", true },
  { "donateway.com", true },
  { "donation.ph", true },
  { "donboscogroep.nl", true },
  { "donetsk24.su", true },
  { "donfelino.tk", false },
  { "dongcdn.com", true },
  { "dongxuwang.com", true },
  { "donjusto.nl", true },
  { "donkennedyandsons.com", true },
  { "donkeytrekkingkefalonia.com", true },
  { "donmaldeamores.com", true },
  { "donna-bellini-fotografie-berlin.de", true },
  { "donna-bellini-fotografie-erfurt.de", true },
  { "donna-bellini-fotografie-frankfurt.de", true },
  { "donna-bellini-fotografie-hamburg.de", true },
  { "donna-bellini-fotografie-koeln.de", true },
  { "donna-bellini-fotografie-muenchen.de", true },
  { "donna-bellini-fotografie-nuernberg.de", true },
  { "donna-bellini-fotografie-stuttgart.de", true },
  { "donna-bellini-fotografie-wien.de", true },
  { "donna-bellini-hochzeitsfotograf-frankfurt.de", true },
  { "donna-bellini-hochzeitsfotograf-muenchen.de", true },
  { "donnaandscottmcelweerealestate.com", true },
  { "donnacha.blog", true },
  { "donnachie.net", true },
  { "donnajeanbooks.com", true },
  { "donner-reuschel.de", true },
  { "donnons.org", false },
  { "donnoval.ru", false },
  { "donotcall.gov", true },
  { "donotlink.it", true },
  { "donovankraag.nl", true },
  { "dont.re", true },
  { "dont.watch", true },
  { "dontbeevil.com", true },
  { "dontbubble.me", true },
  { "dontcageus.org", true },
  { "donthedragonwilson.com", true },
  { "dontpayfull.com", true },
  { "donutcompany.co.jp", true },
  { "dooby.fr", true },
  { "dooleylabs.com", true },
  { "dooleytackaberry.com", true },
  { "doomoo.com", true },
  { "doomsworld.com", true },
  { "doomtech.net", true },
  { "doomus.me", true },
  { "doooooops.com", true },
  { "doop.im", true },
  { "doordecor.bg", true },
  { "doorflow.com", true },
  { "doorhandlese.com", true },
  { "doorshingekit.com", true },
  { "doorswest.net", true },
  { "doortim.nl", true },
  { "dopesoft.de", true },
  { "doppeleinhorn.de", true },
  { "dopravni-modely.cz", true },
  { "dopsi.ch", true },
  { "dora.moe", true },
  { "dorco.be", true },
  { "dorde.eu", true },
  { "dorfbaeck.at", true },
  { "dorfbrunnen.eu", true },
  { "doriangirod.ch", true },
  { "dorianharmans.nl", true },
  { "dorianmuthig.com", true },
  { "doridian.com", true },
  { "doridian.de", true },
  { "doridian.net", true },
  { "doridian.org", true },
  { "dormirmucho.com", true },
  { "dormitengernyikaland.hu", true },
  { "dormiu.com", true },
  { "dormiu.com.br", true },
  { "dornhecker.me", true },
  { "dorpshuis-dwarsgracht.nl", true },
  { "dorpshuiskesteren.nl", true },
  { "dorquelle.com", true },
  { "dorsetentertainments.co.uk", true },
  { "dorth.nl", true },
  { "dortmund.directory", true },
  { "dosdediez.com", true },
  { "dosenbierrepublik.com", true },
  { "dosenkiwi.at", true },
  { "doska.by", true },
  { "doska.ru", true },
  { "dosomeworks.biz", true },
  { "dossplumbing.co.za", true },
  { "dostalsecurity.com", true },
  { "dostlar.fr", true },
  { "dosvientoselectric.com", true },
  { "dosvientoselectrical.com", true },
  { "dosvientoselectrician.com", true },
  { "dosvientosexteriorlighting.com", true },
  { "dosvientoslandscapelighting.com", true },
  { "dosvientoslighting.com", true },
  { "dosvientosoutdoorlighting.com", true },
  { "doswap.com", true },
  { "dosyauzantisi.com", true },
  { "dot42.no", true },
  { "dotacni-parazit.cz", true },
  { "dotbigbang.com", true },
  { "dotbox.org", true },
  { "dotcircle.co", true },
  { "dotesports.com", true },
  { "dotgov.gov", true },
  { "dothebangthingsalon.com", true },
  { "dothydesign.com", true },
  { "dotjesper.com", true },
  { "dotjesper.dk", true },
  { "dotjesper.net", true },
  { "dotjs.party", true },
  { "dotkniseandroida.cz", true },
  { "dotkod.pl", true },
  { "dotneko.net", true },
  { "dotphoto.com", true },
  { "dotplex.com", true },
  { "dotplex.de", true },
  { "dotrel.com", true },
  { "dotrox.net", true },
  { "dotshule.ug", true },
  { "dotsiam.co.th", true },
  { "dotsiam.com", true },
  { "dotsiam.in.th", true },
  { "dotweb.cloud", true },
  { "douai.me", true },
  { "doubleaste.com", true },
  { "doubleavineyards.com", true },
  { "doubledash.org", true },
  { "doublefun.net", true },
  { "doublestat.me", true },
  { "doubleup.com.au", true },
  { "doucheba.gs", false },
  { "doughseeker.com", true },
  { "dougley.com", true },
  { "dougsautobody.com", true },
  { "doujinshi.info", true },
  { "doujinspot.com", true },
  { "dounats.com", true },
  { "douzer.de", true },
  { "douzer.industries", true },
  { "dovenzorgmalawi.nl", true },
  { "dowell.media", true },
  { "dowellconsulting.com", true },
  { "dowhatmakegood.de", true },
  { "dowling.nz", true },
  { "download.dk", true },
  { "downloadaja.com", true },
  { "downloadgamemods.com", true },
  { "downloadgram.com", true },
  { "downloadhindimovie.com", true },
  { "downloadhindimovie.net", true },
  { "downloadhindimovies.net", true },
  { "downloads.zdnet.com", true },
  { "downloadsoftwaregratisan.com", true },
  { "downrightcute.com", true },
  { "downthe.pub", true },
  { "downtimerobot.nl", true },
  { "downtownautospecialists.com", true },
  { "downtownstevenspoint.org", true },
  { "downtownvernon.com", true },
  { "dox-box.eu", true },
  { "doxal.ro", true },
  { "doyoucheck.com", false },
  { "doyouedc.com", true },
  { "doyoutax.com", true },
  { "doypacky.cz", false },
  { "doze-cloud.tech", true },
  { "dozecloud.com", true },
  { "dp.cx", true },
  { "dp2.com.br", true },
  { "dpd.com.pl", true },
  { "dpecuador.com", true },
  { "dperson.net", true },
  { "dpfsolutionsfl.com", true },
  { "dpg.no", true },
  { "dpi-design.de", true },
  { "dpisecuretests.com", true },
  { "dpm-ident.de", true },
  { "dponetwork.nl", true },
  { "dprb.biz", true },
  { "dprd-wonogirikab.go.id", false },
  { "dps.srl", true },
  { "dpsg-hohenlinden.de", true },
  { "dpsg-roden.de", true },
  { "dpwsweeps.co.uk", true },
  { "dr-becarelli-philippe.chirurgiens-dentistes.fr", true },
  { "dr-bodendorf.de", true },
  { "dr-it.co.uk", true },
  { "dr-jakob-zahnaerzte.de", true },
  { "dr-klotz.info", true },
  { "dr-knirr.de", true },
  { "dr-krebs.net", true },
  { "dr-marlen-nystroem.de", true },
  { "dr-moldovan.de", true },
  { "dr-nystroem.de", true },
  { "dr-peter-jahn.de", true },
  { "dr-schlamminger.de", true },
  { "dr-schmutzer.de", true },
  { "dr-schuessler.de", true },
  { "dr-stoetter.de", true },
  { "dr-www.de", true },
  { "dr2dr.ca", true },
  { "draadloos-besturen.nl", true },
  { "draadloze-noodstop.nl", true },
  { "drabadir.com", true },
  { "drabim.org", true },
  { "drach.xyz", true },
  { "drachenleder.de", true },
  { "dracisvet.cz", true },
  { "dracon.es", true },
  { "dracoon.cloud", true },
  { "dracoon.com", true },
  { "dracoon.de", true },
  { "dracoon.team", true },
  { "dracox.com", true },
  { "draftguru.com.au", true },
  { "drafton.com", true },
  { "dragcave.net", true },
  { "dragfiles.com", true },
  { "draghetti.it", true },
  { "draghive.com", true },
  { "dragon-chem.eu", true },
  { "dragon-hearts.co.uk", true },
  { "dragon.nu", true },
  { "dragoncave.me", true },
  { "dragonclean.gr", true },
  { "dragonfly.co.uk", true },
  { "dragonheartsrpg.com", true },
  { "dragonkin.net", true },
  { "dragonprogrammer.com", true },
  { "dragonschool.org", true },
  { "dragonsunited.at", true },
  { "dragonsunited.ch", true },
  { "dragonsunited.de", true },
  { "dragonsunited.eu", true },
  { "dragonsunited.info", true },
  { "dragonsunited.net", true },
  { "dragonsunited.org", true },
  { "dragonwolfpackaquaria.com", true },
  { "draintechnorthwest.net", true },
  { "drake.partners", true },
  { "drakecommercial.com", true },
  { "drakeluce.com", true },
  { "drakenson.de", true },
  { "draliabadi.com", true },
  { "dramaticpeople.com", true },
  { "dramyalderman.com", true },
  { "dranderle.com", true },
  { "dras.hu", true },
  { "draugr.de", true },
  { "draw.uy", true },
  { "drawchan.org", true },
  { "drawesome.uy", true },
  { "drawingcode.net", true },
  { "drawtwo.gg", true },
  { "drawvesly.ovh", true },
  { "drawxp.com", true },
  { "draycotthotel.com", true },
  { "drbresnick.com", true },
  { "drbriones.com", true },
  { "drcarolynquist.com", true },
  { "drchrislivingston.com", true },
  { "drchristophepanthier.com", true },
  { "drdegenhart.de", true },
  { "drdenisvincenzi.com.br", true },
  { "drdipilla.com", true },
  { "drdripplumbingsydney.com.au", true },
  { "dreamboxpro.com", true },
  { "dreamcraft.su", true },
  { "dreamcreator108.com", true },
  { "dreamday-with-dreamcar.de", true },
  { "dreamdestine.com", true },
  { "dreamdivers.com", true },
  { "dreamhack.com", true },
  { "dreamhostremixer.com", true },
  { "dreamlandmagic.com", true },
  { "dreamlordpress.it", true },
  { "dreamlux.cz", true },
  { "dreamlux.sk", true },
  { "dreammaker-nw.com", true },
  { "dreammakerutah.com", true },
  { "dreamof.net", false },
  { "dreamrae.net", true },
  { "dreamsforabetterworld.com.au", true },
  { "dreamstream.nl", true },
  { "dreamstream.tv", true },
  { "dreamstream.video", true },
  { "dreamz-staging.zone", true },
  { "dreamz.com", true },
  { "dreax.win", true },
  { "drei01.com", true },
  { "drei01.de", true },
  { "drei01.technology", true },
  { "dreid.org", true },
  { "dreiweiden.de", true },
  { "dresden-kaffee-24.de", true },
  { "dresden-kaffeeroesterei.de", true },
  { "dresdener-mandelstollen.de", true },
  { "dresdens-pfefferkuchenprinzessin.de", true },
  { "dresdner-kaffeeroesterei.de", true },
  { "dresdner-mandelstollen.de", true },
  { "dresdner-stollen.shop", true },
  { "dress-cons.com", true },
  { "dressify.in", true },
  { "drevanbeale.com", true },
  { "drevo-door.cz", false },
  { "drew.beer", true },
  { "drew.red", true },
  { "drewapianostudio.com", true },
  { "dreweryinc.com", true },
  { "drewsilcock.co.uk", true },
  { "drewzar.com", true },
  { "dreyfussplasticsurgery.com", true },
  { "drezzy.it", true },
  { "drfranciscofonseca.com.br", true },
  { "drfrey.ch", true },
  { "drfun1.com", true },
  { "drgerthplasticsurgery.com", true },
  { "drghomi.com", true },
  { "drglassgyn.com", true },
  { "drgn.no", true },
  { "drgrace.ca", true },
  { "drhathazi.hu", true },
  { "drheibel.com", true },
  { "drhildebrand.net", true },
  { "drhoseyni.com", true },
  { "drhyler.com", true },
  { "driesjtuver.nl", true },
  { "driessoftsec.tk", true },
  { "driftdude.nl", true },
  { "driftingruby.com", true },
  { "drighes.com", true },
  { "drillingsupply.info", true },
  { "drillingsupplystore.com", true },
  { "drillion.net", true },
  { "drillshackresort.com", true },
  { "drinkcontrolapp.com", true },
  { "drinkgas-jihlava.cz", true },
  { "drinkgo.vn", true },
  { "drinkplanet.eu", true },
  { "drive.google.com", false },
  { "driveexport.com", true },
  { "driven2shine.eu", true },
  { "drivenes.net", true },
  { "driver.ru", true },
  { "driver61.com", true },
  { "drivercopilot.com", true },
  { "driverless.id", true },
  { "driverprofiler.co.uk", true },
  { "driverscollection.com", true },
  { "drivinghorror.com", true },
  { "drivinhors.com", true },
  { "drivya.com", true },
  { "drixn.cn", true },
  { "drizz.com.br", false },
  { "drjacquesmalan.com", true },
  { "drjenafernandez.com", true },
  { "drjoe.ca", true },
  { "drjuanitacollier.com", false },
  { "drjulianneil.com", true },
  { "drkhsh.at", false },
  { "drkmtrx.xyz", true },
  { "drlandis.com", true },
  { "drlangsdon.com", true },
  { "drlinkcheck.com", true },
  { "drmayakato.com", true },
  { "drmcdaniel.com", true },
  { "drms.us", true },
  { "drmtransit.com", true },
  { "droidandy.com", true },
  { "droidapp.nl", true },
  { "droidgyan.com", true },
  { "droidhere.com", true },
  { "droidim.com", false },
  { "drone-it.net", true },
  { "dronebl.org", true },
  { "droneland.nl", true },
  { "dronepit.dk", true },
  { "dronesz.co", true },
  { "droni.cz", true },
  { "dronnet.com", false },
  { "dronografia.es", true },
  { "dronova-art.ru", true },
  { "drop.com", true },
  { "dropbox.com", true },
  { "dropboxer.net", true },
  { "dropistic.com", true },
  { "dropq.nl", true },
  { "dropscloud.spdns.de", true },
  { "dropshare.cloud", true },
  { "dropshell.net", true },
  { "droso.dk", true },
  { "drown.photography", true },
  { "drpetersenobgynal.com", true },
  { "drpetervoigt.ddns.net", true },
  { "drpetervoigt.de", true },
  { "drphillipsmwc.com", true },
  { "drpico.com.au", true },
  { "drpure.top", true },
  { "drrr.chat", true },
  { "drrr.wiki", true },
  { "drsajjadian.com", true },
  { "drsamuelkoo.com", true },
  { "drschlarb.eu", true },
  { "drsturgeonfreitas.com", true },
  { "drsubbio.com", true },
  { "drtimmarch.com", true },
  { "drtimothybradley.com", true },
  { "drtristanberry.com", true },
  { "druckerei-huesgen.de", true },
  { "drugs.com", true },
  { "drumbe.at", true },
  { "drumlines.org", true },
  { "drummondframing.com", true },
  { "drunkscifi.com", true },
  { "drupal-expert.it", true },
  { "drupal.org", true },
  { "drupalspb.org", true },
  { "drusantia.net", true },
  { "drusillas.co.uk", true },
  { "druwe.net", false },
  { "druznek.me", true },
  { "drwang.group", true },
  { "drweissbrot.net", true },
  { "drwxr.org", true },
  { "dryan.com", true },
  { "drybjed.net", true },
  { "drycleancoalition.org", true },
  { "drycreekphoto.com", true },
  { "drydrydry.com", true },
  { "dryerventcleaningarlington.com", true },
  { "dryerventcleaningcarrollton.com", true },
  { "dryjersey.com", true },
  { "drywallresponse.gov", true },
  { "ds67.de", true },
  { "dsancomics.com", true },
  { "dsayce.com", true },
  { "dsble.de", true },
  { "dsbrowser.com", true },
  { "dsbutler.de", true },
  { "dschwarzachtaler.de", true },
  { "dsebastien.net", true },
  { "dsektionen.se", false },
  { "dsgarms.com", true },
  { "dsgholsters.com", true },
  { "dsgnet.hu", true },
  { "dsgvo-addon.eu", true },
  { "dsgvo.name", true },
  { "dsh.io", true },
  { "dshield.org", true },
  { "dsm5.com", true },
  { "dsmjs.com", true },
  { "dsmnet.org", true },
  { "dso-imaging.co.uk", true },
  { "dso-izlake.si", true },
  { "dsol.hu", true },
  { "dspace.pl", true },
  { "dstamou.de", true },
  { "dstat.cc", true },
  { "dsteiner.at", true },
  { "dstvinstallalberton.co.za", true },
  { "dstvinstalledenvale.co.za", true },
  { "dstvinstallglenvista.co.za", true },
  { "dstvinstalljohannesburg.co.za", true },
  { "dstvinstallkemptonpark.co.za", true },
  { "dstvinstallrandburg.co.za", true },
  { "dstvrandburg.co.za", true },
  { "dstvsandton.co.za", true },
  { "dstvsouthafrica.com", true },
  { "dsuinnovation.com", true },
  { "dt27.org", true },
  { "dtbouncycastles.co.uk", true },
  { "dtdsh.com", true },
  { "dtg-fonds.com", true },
  { "dtg-fonds.de", true },
  { "dtg-fonds.net", true },
  { "dtk-vom-chausseehaus.de", true },
  { "dtnx.eu", true },
  { "dtnx.net", true },
  { "dtnx.org", true },
  { "dtoweb.be", true },
  { "dtp-mstdn.jp", false },
  { "dtuaarsfest.dk", true },
  { "dtx.sk", true },
  { "du-alex.ru", true },
  { "dualascent.com", true },
  { "dub.cz", true },
  { "dubai-company.ae", true },
  { "dubaieveningsafari.com", true },
  { "dubbingkursus.dk", true },
  { "dubious-website.com", true },
  { "dublin-traceroute.net", true },
  { "dubrovnik-dental.clinic", true },
  { "dubrovskiy.net", true },
  { "dubrovskiy.pro", true },
  { "dubstep.fr", true },
  { "dubtrack.fm", true },
  { "ducalendars.com", true },
  { "duch.cloud", true },
  { "duckbase.com", true },
  { "duckblade.com", true },
  { "duckcorp.org", true },
  { "duckduck.horse", true },
  { "duckduckstart.com", true },
  { "duckeight.win", true },
  { "duckfam.us", true },
  { "duckinc.net", true },
  { "duct.me", true },
  { "dudesunderwear.com.br", false },
  { "duernberg.at", true },
  { "duesee.org", true },
  { "duesterhus.eu", true },
  { "dufrei.com", true },
  { "dugnet.com", false },
  { "dugnet.io", false },
  { "dugnet.net", false },
  { "dugnet.org", false },
  { "dugunedavet.com", true },
  { "duh.se", true },
  { "duijf.info", true },
  { "duijfathome.nl", true },
  { "duitang.com", true },
  { "dukan-recepty.ru", true },
  { "dukatek.cz", true },
  { "dukegat.de", false },
  { "dukesatqueens.com", true },
  { "dukun.de", true },
  { "dulcinela.es", true },
  { "dulei.si", true },
  { "dullapp.com", true },
  { "dum.moe", true },
  { "dumax.xyz", true },
  { "dumbeartech.com", true },
  { "dumberger-bau.de", true },
  { "dumino.bg", true },
  { "duncancmt.com", true },
  { "duncanfamilytrust.org", true },
  { "duncanmoffat.com", true },
  { "duncanwinfrey.com", true },
  { "duncm.com", true },
  { "dundalkdonnie.com", true },
  { "dung-massage.fr", true },
  { "dungeon-bbs.de", true },
  { "dunklau.fr", true },
  { "dunkle-seite.org", true },
  { "dunloptrade.com", true },
  { "dunmanelectric.com", true },
  { "duobus.nl", true },
  { "duoluodeyu.com", true },
  { "duoquadragintien.fr", true },
  { "dupisces.com.tw", true },
  { "duplicazionechiavi.it", true },
  { "duploclique.pt", false },
  { "dupree.co", true },
  { "dupree.pe", true },
  { "durand.tf", true },
  { "duranthon.eu", true },
  { "durbanlocksmiths.co.za", true },
  { "durchblick-shop.de", true },
  { "durdle.com", true },
  { "dureuil.info", true },
  { "durfteparticiperen.nl", true },
  { "durgatopos.it", true },
  { "duria.de", true },
  { "duriaux-dentiste.ch", true },
  { "duroterm.ro", true },
  { "durys.be", true },
  { "dusmomente.com", true },
  { "dustplanet.de", true },
  { "dustri.org", true },
  { "dustygroove.com", true },
  { "dustyspokesbnb.ca", true },
  { "dustywilson.com", true },
  { "dutabisniz.com", true },
  { "dutch.desi", true },
  { "dutchdare.nl", true },
  { "dutchessuganda.com", true },
  { "dutchfoodie.nl", true },
  { "dutchforkrunners.com", true },
  { "dutchrank.nl", true },
  { "dutchsailors.com", true },
  { "dutchwanderers.nl", true },
  { "dutchweballiance.nl", true },
  { "dutrac.co.id", true },
  { "duval.paris", true },
  { "duvalo.eu", true },
  { "duvalo.info", true },
  { "duvalo.net", true },
  { "duvalo.org", true },
  { "duvalo.sk", true },
  { "dv189.com", true },
  { "dvbris.co.uk", true },
  { "dvbris.com", true },
  { "dvdinmotion.com", true },
  { "dvdland.com.au", true },
  { "dverisochi.ru", true },
  { "dvhosting.be", true },
  { "dvipadmin.com", true },
  { "dvlot.ru", true },
  { "dvnatura.ch", true },
  { "dvorupotocnych.sk", true },
  { "dvwc.org", true },
  { "dvx.cloud", true },
  { "dwgf.xyz", true },
  { "dwi-sued.de", true },
  { "dwienzek.de", true },
  { "dworekhetmanski.pl", true },
  { "dworzak.ch", true },
  { "dwscdv3.com", true },
  { "dwtm.ch", true },
  { "dwworld.co.uk", true },
  { "dx-revision.com", true },
  { "dxgl.info", true },
  { "dxgl.org", true },
  { "dxm.no-ip.biz", true },
  { "dybuster.at", true },
  { "dybuster.ch", true },
  { "dybuster.com", true },
  { "dybuster.de", true },
  { "dybuster.es", true },
  { "dybuster.it", true },
  { "dybuster.se", true },
  { "dycoa.com", true },
  { "dyeager.org", true },
  { "dyktig.as", true },
  { "dyktig.no", true },
  { "dylancl.cf", true },
  { "dylangattey.com", false },
  { "dylankatz.com", true },
  { "dylanknoll.ca", true },
  { "dylanspcrepairs.com", true },
  { "dylmye.me", false },
  { "dym.asia", true },
  { "dym.bz", true },
  { "dym2012.com", true },
  { "dym2013.com", true },
  { "dym2014.com", true },
  { "dym2017.com", true },
  { "dymersion.com", true },
  { "dymfbbs.com", true },
  { "dymmovie.com", true },
  { "dymowski.de", false },
  { "dyn-dnhensel.de", true },
  { "dyn.im", true },
  { "dynaloop.net", false },
  { "dynamicdesignuk.com", true },
  { "dynamicnet.net", false },
  { "dynamics-365.no", true },
  { "dynamics365.no", true },
  { "dynamicsnetwork.net", true },
  { "dynamicsretailnotes.com", true },
  { "dynamictostatic.com", true },
  { "dynapptic.com", true },
  { "dynastic.co", true },
  { "dynastyarena.com", true },
  { "dynastybullpen.com", true },
  { "dynastycalculator.com", true },
  { "dynastycentral.com", true },
  { "dynastychalkboard.com", true },
  { "dynastyclubhouse.com", true },
  { "dynastycrate.com", true },
  { "dynastyduel.com", true },
  { "dynastyfan.com", true },
  { "dynastygoal.com", true },
  { "dynastylocker.com", true },
  { "dynastyredline.com", true },
  { "dyncdn.me", true },
  { "dynn.be", true },
  { "dynocc.xyz", true },
  { "dynorphin.com", true },
  { "dynorphins.com", true },
  { "dynts.pro", true },
  { "dynx.pl", true },
  { "dyrenesverden.no", true },
  { "dyrkar.com", true },
  { "dyrstad.net", true },
  { "dyscalculia-blog.com", true },
  { "dysthymia.com", true },
  { "dyyn.de", true },
  { "dyz.pw", true },
  { "dz6729.com", true },
  { "dzar.nsupdate.info", true },
  { "dzeina.ch", true },
  { "dzet.de", true },
  { "dzi.wtf", true },
  { "dziary.com", true },
  { "dziekonski.com", true },
  { "dziura.me", true },
  { "dziurdzia.pl", true },
  { "dzivniekubriviba.lv", true },
  { "dzndk.com", true },
  { "dznn.nl", true },
  { "dzomo.org", true },
  { "dzsi.bi", true },
  { "dzsibi.com", true },
  { "dzsula.hu", true },
  { "dzworld.com", true },
  { "dzyszla.pl", true },
  { "e-beyond.de", true },
  { "e-bikesdirect.co.uk", true },
  { "e-biografias.net", true },
  { "e-borneoshop.com", true },
  { "e-briancon.com", true },
  { "e-colle.info", true },
  { "e-cottage.com.br", true },
  { "e-enterprise.gov", false },
  { "e-id.ee", true },
  { "e-labo.works", true },
  { "e-lambre.com", true },
  { "e-learningbs.com", true },
  { "e-lifetechnology.com", true },
  { "e-nanum.kr", true },
  { "e-ptn.com", true },
  { "e-referendum.cz", true },
  { "e-speak24.pl", true },
  { "e-standardstore.org", true },
  { "e-sushi.net", true },
  { "e-sw.co.jp", true },
  { "e-teacher.pl", true },
  { "e-teachers.me", true },
  { "e-tech-solution.com", true },
  { "e-tech-solution.net", true },
  { "e-techsolution.com", true },
  { "e-techsolutions.net", true },
  { "e-tonery.cz", true },
  { "e-traceur-france.fr", true },
  { "e-tresor.at", true },
  { "e-tune-mt.net", true },
  { "e-typ.eu", true },
  { "e-verify.gov", true },
  { "e-webos.com", true },
  { "e-worksmedia.com", false },
  { "e.mail.ru", true },
  { "e11even.nl", false },
  { "e15r.co", true },
  { "e2feed.com", true },
  { "e30.ee", true },
  { "e4metech.com", true },
  { "e5197.co", true },
  { "e5tv.hu", true },
  { "e64.com", true },
  { "e6729.co", true },
  { "e6729.com", true },
  { "e6957.co", true },
  { "e6e.io", true },
  { "e6ex.com", true },
  { "e7d.io", true },
  { "e7fun.net", true },
  { "e9297.co", true },
  { "e9397.com", true },
  { "e965.ru", true },
  { "e9721.com", true },
  { "e9728.co", true },
  { "ea2drocks.com", true },
  { "eac.gov", true },
  { "eacero.com", true },
  { "ead-italia.it", true },
  { "eagle.net", true },
  { "eagleindustriesltd.com", true },
  { "eaglemessaging.com", true },
  { "eagletechz.com.br", true },
  { "eaglewreck.info", true },
  { "eaglexiang.org", true },
  { "eagleyecs.com", true },
  { "eaimty.com", true },
  { "ealadel.com", true },
  { "ealev.de", true },
  { "eallion.com", true },
  { "eapestudioweb.com", true },
  { "earfolds.com", true },
  { "earl.org.uk", true },
  { "earlydocs.com", true },
  { "earlyyearshub.com", true },
  { "earmarks.gov", true },
  { "earn.com", true },
  { "earthspundesigns.com", true },
  { "earthsystemprediction.gov", true },
  { "earticleblog.com", true },
  { "earvinkayonga.com", false },
  { "easez.net", true },
  { "eashwar.com", true },
  { "eason-yang.com", true },
  { "eastarm.net", true },
  { "eastbaycontractor.com", true },
  { "eastblue.org", true },
  { "easterncapebirding.co.za", true },
  { "eastlothianbouncycastles.co.uk", true },
  { "eastmanbusinessinstitute.com", true },
  { "eastmidlandsstargazers.org.uk", false },
  { "eastnorschool.co.uk", true },
  { "eastplan.co.kr", true },
  { "eastsideroofingcontractor.com", true },
  { "eastwind.cloud", true },
  { "easy-rpg.org", false },
  { "easy2bathe.co.uk", true },
  { "easyadsnbanners.tk", false },
  { "easycoding.org", true },
  { "easyconstat.com", true },
  { "easycosmetic.ch", true },
  { "easydumpsterrental.com", true },
  { "easyeigo.com", true },
  { "easyenrollment.net", true },
  { "easyfiles.ch", true },
  { "easyhaul.com", true },
  { "easymun.com", true },
  { "easypay.bg", true },
  { "easypayments.pro", true },
  { "easyproperty.com", true },
  { "easypv.ch", true },
  { "easyqr.codes", true },
  { "easyroad.fr", true },
  { "easyslide.be", true },
  { "easystore.co", true },
  { "easytechguides.com", true },
  { "easytechsecurity.com", true },
  { "easyweenies.com", true },
  { "eat-sleep-code.com", true },
  { "eatery.co.il", true },
  { "eatmebudapest.hu", true },
  { "eaton-works.com", true },
  { "eatry.io", true },
  { "eatsleeprepeat.net", true },
  { "eatson.com", true },
  { "eatz-and-treatz.com", true },
  { "eatz.com", true },
  { "eaucube.com", true },
  { "eauxdespleiades.ch", true },
  { "eb-net.de", true },
  { "eb7.jp", true },
  { "ebanking.indovinabank.com.vn", true },
  { "ebanking.raiffeisen.ch", true },
  { "ebankingabersicher.ch", true },
  { "ebankingbutsecure.ch", true },
  { "ebankingentoutesecurite.ch", true },
  { "ebankingmasicuro.ch", true },
  { "ebas.ch", true },
  { "ebataw.com", true },
  { "ebaymotorssucks.com", true },
  { "ebene-bpo.com", true },
  { "ebenezersbarnandgrill.com", true },
  { "ebenvloedaanleggen.nl", true },
  { "ebermannstadt.de", false },
  { "eberwe.in", true },
  { "ebest.co.jp", true },
  { "ebiebievidence.com", false },
  { "ebiografia.com", true },
  { "ebisi.be", true },
  { "ebizarts.com", true },
  { "eblog.com.au", true },
  { "eblog.ink", true },
  { "eboek.info", true },
  { "ebonyriddle.com", true },
  { "ebooki.eu.org", true },
  { "eboutic.ch", true },
  { "eboyer.com", true },
  { "ebpglobal.com", false },
  { "ebrnd.de", true },
  { "ebuyclub.com", true },
  { "ec-current.com", true },
  { "ec.mine.nu", true },
  { "eca.edu.au", true },
  { "ecardoo.com", true },
  { "ecardoo.de", true },
  { "ecardoo.net", true },
  { "ecardoo.org", true },
  { "ecchidreams.com", true },
  { "ecclesia-koeln.de", true },
  { "ecco-verde.com", false },
  { "ecdn.cz", true },
  { "ecfnorte.com.br", true },
  { "echarity.ae", true },
  { "echatta.net", true },
  { "echatta.org", true },
  { "echi.pw", true },
  { "echidna-rocktools.eu", true },
  { "echo-security.co", true },
  { "echoanalytics.com", true },
  { "echobridgepartners.com", true },
  { "echodio.com", true },
  { "echofoxtrot.co", true },
  { "echoit.net", true },
  { "echoit.net.au", true },
  { "echoit.services", true },
  { "echopaper.com", true },
  { "echorecovery.org", true },
  { "echosim.io", true },
  { "echosixmonkey.com", true },
  { "echosystem.fr", true },
  { "echoworld.ch", true },
  { "echternach-immobilien.de", true },
  { "ecigfind.com", true },
  { "ecir.pro", true },
  { "ecir.ru", true },
  { "ecirtam.net", true },
  { "eckel.co", true },
  { "eclectiv.com", true },
  { "eclipse.ws", true },
  { "ecnetworker.com", true },
  { "eco-derattizzazione.it", true },
  { "eco-solu.co.jp", true },
  { "eco-work.it", true },
  { "eco2u.ru", true },
  { "ecobee.com", false },
  { "ecobergerie.fr", true },
  { "ecobin.nl", true },
  { "ecoccinelles.ch", true },
  { "ecoccinelles.com", true },
  { "ecococon.fr", true },
  { "ecocreativity.org", true },
  { "ecodedi.com", true },
  { "ecoder.co", true },
  { "ecodesigns.nl", true },
  { "ecodigital.social", true },
  { "ecofabrica.com.br", true },
  { "ecofac-bs.com", true },
  { "ecogen.com.au", true },
  { "ecogen.net.au", true },
  { "ecoheatcool.co.uk", true },
  { "ecohostingservices.uk", true },
  { "ecolala.my", true },
  { "ecole-attalens.ch", true },
  { "ecoledusabbat.org", true },
  { "ecolemathurincordier.com", true },
  { "ecologikashop.com", true },
  { "ecombustibil.ro", true },
  { "ecomia.dk", true },
  { "ecomycie.com", true },
  { "economiafinanzas.com", true },
  { "economias.pt", true },
  { "economic-sanctions.com", true },
  { "economicinclusion.gov", true },
  { "economics-colleges.com", true },
  { "economie2.alsace", true },
  { "economiefidu.ch", true },
  { "economies.ch", true },
  { "econsorzio.com", true },
  { "econsumer.gov", true },
  { "econverter.cloud", true },
  { "ecos-ev.de", true },
  { "ecos.srl", true },
  { "ecoshare.info", true },
  { "ecosm.com.au", true },
  { "ecosound.ch", true },
  { "ecostruxureit.com", true },
  { "ecosystem.atlassian.net", true },
  { "ecosystemmanager-uat1.azurewebsites.net", true },
  { "ecoterramedia.com", true },
  { "ecotur.org", true },
  { "ecovision.com.br", true },
  { "ecpannualmeeting.com", true },
  { "ecr-test-backoffice-app.azurewebsites.net", true },
  { "ecr-test-partnapp.azurewebsites.net", true },
  { "ecrandouble.ch", true },
  { "ecredits-dev-app-backoffice01.azurewebsites.net", true },
  { "ecredits-dev-app-partner01.azurewebsites.net", true },
  { "ecsupplyinc.com", true },
  { "ecuadorbienesraices.com", true },
  { "ecuatask.com", true },
  { "ecupcafe.com", false },
  { "ecuteam.com", true },
  { "ecxforum.com", true },
  { "ed.gs", true },
  { "ed4becky.net", true },
  { "edanni.io", true },
  { "edapt.org.uk", true },
  { "edas.info", false },
  { "edd-miles.com", true },
  { "eddesign.ch", true },
  { "eddmil.es", true },
  { "eddokloosterman.com", true },
  { "eddyn.net", true },
  { "edeals.co", true },
  { "edeals.co.com", true },
  { "edeals.com.co", true },
  { "edeca.net", true },
  { "edehsa.com", true },
  { "eden-eu.com", true },
  { "eden.co.uk", true },
  { "edenmal.net", true },
  { "edenming.info", true },
  { "edesseglabor.hu", true },
  { "edfinancial.com", true },
  { "edgedynasty.com", true },
  { "edgefantasy.com", true },
  { "edgeservices.co.uk", true },
  { "edgetalk.net", true },
  { "edgevelder.com", true },
  { "edh.email", true },
  { "edhesive.com", true },
  { "edholm.pub", true },
  { "edi-gate.com", true },
  { "edi-gate.de", true },
  { "edibarcode.com", true },
  { "edicct.com", true },
  { "edilane.com", true },
  { "edilane.de", true },
  { "edilservizi.it", true },
  { "edilservizivco.it", true },
  { "edinburghsportsandoutdoorlearning.com", true },
  { "edincmovie.com", true },
  { "ediscomp.sk", true },
  { "edisonlee55.com", true },
  { "edisonnissanparts.com", true },
  { "edit.co.uk", true },
  { "edit.yahoo.com", false },
  { "edited.de", true },
  { "edition-bambou.com", true },
  { "edition-sonblom.de", true },
  { "edlinger.at", true },
  { "edlinger.mobi", true },
  { "edlinus.cn", true },
  { "edmodo.com", true },
  { "edmoncu.com", true },
  { "edmundcelis.com", true },
  { "edoss.co.za", true },
  { "edp-collaborative.com", true },
  { "edplan.io", true },
  { "edragneainpuscarie.ro", true },
  { "edsby.com", true },
  { "edservicing.com", true },
  { "edshogg.co.uk", true },
  { "edsinet.com", true },
  { "edsm.net", true },
  { "edstep.com", true },
  { "edtech-hub.com", true },
  { "edtechwebb.com", true },
  { "edu-kingdom.com", true },
  { "edu6.cloud", true },
  { "edubase.net", true },
  { "edubras.com.br", true },
  { "educacionvirtual.com.ar", true },
  { "educatek.es", true },
  { "educateyourskin.com", true },
  { "educationevolving.org", true },
  { "educationfutures.com", true },
  { "educationmalaysia.co.uk", true },
  { "eductf.org", true },
  { "edugundavetiyesi.com", false },
  { "eduid.se", false },
  { "edumi.com", true },
  { "edumundo.nl", true },
  { "edunet.gq", true },
  { "edupool.in", true },
  { "eduroam.no", true },
  { "eduroam.uy", true },
  { "edusanjal.com", true },
  { "eduschedule.org", true },
  { "eduvpn.no", true },
  { "eduxpert.in", true },
  { "edv-kohls.de", true },
  { "edv-lehrgang.de", true },
  { "edv-ringhofer.de", true },
  { "edv-schmittner.de", true },
  { "edvgarbe.de", true },
  { "edvmesstec.de", true },
  { "edwards.me.uk", true },
  { "edwardsnowden.com", true },
  { "edwardspeyer.com", true },
  { "edwardwall.me", true },
  { "edwellbrook.com", true },
  { "edwinmattiacci.com", true },
  { "edwinyrkuniversity.de", true },
  { "edxg.de", false },
  { "edxn.de", true },
  { "edyou.eu", true },
  { "edzilla.info", true },
  { "ee5197.co", true },
  { "ee6729.co", true },
  { "ee9297.co", true },
  { "ee9397.com", true },
  { "ee9721.com", true },
  { "ee9728.co", true },
  { "eelcapone.nl", true },
  { "eellak.gr", true },
  { "eelsden.net", true },
  { "eelzak.nl", true },
  { "eemcevn.com", true },
  { "eentweevijf.be", true },
  { "eenvren.com", true },
  { "eenvxing.com", true },
  { "eer.io", true },
  { "eerstejaarsweekend.nl", true },
  { "eery.de", true },
  { "eesti.xyz", true },
  { "eewna.org", true },
  { "ef-georgia.org", true },
  { "ef.gy", true },
  { "efa-football.com", true },
  { "efaas.nl", true },
  { "efag.com", true },
  { "efcross.com", true },
  { "efeen.nl", true },
  { "eff.org", true },
  { "effdocs.com", true },
  { "effe.ch", true },
  { "effective-altruist.com", true },
  { "effectivecoffee.com", true },
  { "effectivepapers.com", true },
  { "effex.ru", true },
  { "effinfun.com", true },
  { "effortlesshr.com", true },
  { "efg-darmstadt.de", false },
  { "efipsactiva.com", true },
  { "eflorashop.be", true },
  { "eflorashop.ch", true },
  { "eflorashop.co.uk", true },
  { "eflorashop.com", true },
  { "eflorashop.de", true },
  { "eflorashop.es", true },
  { "eflorashop.fr", true },
  { "eflorashop.it", true },
  { "eflorashop.mx", true },
  { "eflorashop.net", true },
  { "eflorashop.us", true },
  { "efmcredentialing.org", true },
  { "efreet.xyz", true },
  { "eft.boutique", true },
  { "eftopia.org", true },
  { "egablo.black", true },
  { "egamespw.com", true },
  { "egami.ch", true },
  { "egarden.it", true },
  { "egb.at", false },
  { "egbc.ca", true },
  { "egbert.net", true },
  { "egeozcan.com", true },
  { "eges.eu", true },
  { "egg-ortho.ch", true },
  { "eggblast.com", true },
  { "eggert.org", false },
  { "eggqvq.com", true },
  { "egiftcards.be", true },
  { "egles.eu", true },
  { "eglisedenantes.fr", true },
  { "ego4u.com", true },
  { "ego4u.de", true },
  { "egoroof.ru", true },
  { "egov4.ch", true },
  { "egovernment-podcast.com", true },
  { "egres.xyz", true },
  { "egrojsoft.info", true },
  { "egrp365.ru", true },
  { "egw-ceramica.de", true },
  { "egweb.tv", true },
  { "ehaccp.it", true },
  { "ehandel.com", true },
  { "ehazi.hu", true },
  { "ehbssl.com", true },
  { "ehcommerce.com", true },
  { "ehcommerce.org", true },
  { "ehdud8451.gq", true },
  { "eheliche-disziplin.schule", true },
  { "ehertz.uk", true },
  { "ehipaa.com", true },
  { "ehlacademy.org", true },
  { "ehmsen.nu", true },
  { "ehmtheblueline.com", true },
  { "ehne.de", true },
  { "ehomusicgear.com", true },
  { "ehorizon.jp", true },
  { "ehrenburg.info", true },
  { "ehub.cz", true },
  { "ehub.hu", true },
  { "ehub.pl", true },
  { "ehub.sk", true },
  { "eichel.eu", true },
  { "eichler.work", true },
  { "eickemeyer.nl", true },
  { "eickhof.co", true },
  { "eickhof.us", true },
  { "eickhofcolumbaria.com", true },
  { "eidelpes.info", true },
  { "eigenpul.se", true },
  { "eigenpulse.com", true },
  { "eighty-aid.com", true },
  { "eightyfour.ca", true },
  { "eightysoft.de", true },
  { "eigpropertyauctions.co.uk", true },
  { "eihaikyo.com", true },
  { "eikounoayumi.jp", true },
  { "eilhan.com", true },
  { "eimacs.com", true },
  { "einfachbahn.de", true },
  { "einheft.info", true },
  { "einheizpreis.de", true },
  { "einkaufi.de", true },
  { "einrichtwerk.de", true },
  { "einrichtwerk.shop", true },
  { "einsatzstellenverwaltung.de", true },
  { "einser.com", true },
  { "einsteinathome.org", true },
  { "einsteincapital.ca", true },
  { "eintageinzug.de", true },
  { "eintragsservice24.de", true },
  { "eioperator.com", false },
  { "eipione.com", true },
  { "eirastudios.co.uk", false },
  { "eirb.fr", true },
  { "eirik.eu", true },
  { "eisaev.ru", true },
  { "eisenbahnfreunde-lengerich.de", true },
  { "eiskratzer-bedrucken.de", true },
  { "eit-web.de", false },
  { "eitler.cx", true },
  { "eiyoushi-shigoto.com", true },
  { "ej.uz", true },
  { "ejdv-anmeldung.de", true },
  { "ejeff.org", true },
  { "ejelectrical-qld.com.au", true },
  { "ejkhosting.nl", true },
  { "ejkmedia.nl", true },
  { "ejkmuseum.nl", true },
  { "ejknet.nl", true },
  { "ejkwebdesign.nl", true },
  { "ek-networks.de", false },
  { "ekaigotenshoku.com", true },
  { "ekaplast.com.pl", true },
  { "ekati.ru", true },
  { "ekb-avia.ru", true },
  { "ekd.de", true },
  { "ekedc.com", true },
  { "ekedp.com", true },
  { "eklepka.com", true },
  { "eklitzke.org", true },
  { "ekokontakt.cz", true },
  { "ekonbenefits.com", true },
  { "ekostecki.de", true },
  { "ekostrateg.com", true },
  { "ekouniejow.pl", true },
  { "ekpj.jp", true },
  { "ekpyroticfrood.net", true },
  { "ekranos.me", true },
  { "ekre.club", true },
  { "eksisozluk.com", true },
  { "ekuatorial.com", true },
  { "ekvastra.in", true },
  { "ekyu.moe", true },
  { "ekz-crosstour.ch", true },
  { "ekzarta.ru", true },
  { "ekzcrosstour.ch", true },
  { "el-cell.com", true },
  { "el-hossari.com", true },
  { "el-news.de", true },
  { "eladgames.com", true },
  { "eladlak-ingatlan.com", true },
  { "elagplus.com", true },
  { "elainerock.com", true },
  { "elaon.de", true },
  { "elars.de", true },
  { "elarvee.xyz", true },
  { "elb500ttl.nl", true },
  { "elbetech.net", true },
  { "elblogdegoyo.mx", true },
  { "elbohlyart.com", true },
  { "elburgozagalicos.com", true },
  { "elcambiador.es", true },
  { "elchamandelaprosperidad.org", true },
  { "eldapoint.co.uk", true },
  { "eldenelesat.com", true },
  { "eldercare.gov", true },
  { "elderjustice.gov", true },
  { "eldertons.co.uk", true },
  { "eldevo.com", true },
  { "eldinhadzic.com", true },
  { "eldrid.ge", true },
  { "eldritchfiction.net", true },
  { "electerious.com", true },
  { "electionsbycounty.com", true },
  { "electionsdatabase.com", true },
  { "electr0sheep.com", true },
  { "electragirl.com", true },
  { "electric-vault.co.uk", true },
  { "electricagoura.com", true },
  { "electricagourahills.com", true },
  { "electrical-schools.com", true },
  { "electricalagoura.com", true },
  { "electricalagourahills.com", true },
  { "electricalcalabasas.com", true },
  { "electricalcamarillo.com", true },
  { "electricalconejovalley.com", true },
  { "electricaldosvientos.com", true },
  { "electricalfencingbedfordview.co.za", true },
  { "electricalfencingedenvale.co.za", true },
  { "electricalhiddenhills.com", true },
  { "electricallakesherwood.com", true },
  { "electricalmalibu.com", true },
  { "electricalmoorpark.com", true },
  { "electricalnewburypark.com", true },
  { "electricaloakpark.com", true },
  { "electricalsimivalley.com", true },
  { "electricalthousandoaks.com", true },
  { "electricalwestlakevillage.com", true },
  { "electriccalabasas.com", true },
  { "electriccamarillo.com", true },
  { "electriccitysf.com", true },
  { "electricconejovalley.com", true },
  { "electricdosvientos.com", true },
  { "electricfencealberton.co.za", true },
  { "electricfencebenoni.co.za", true },
  { "electricfencingballito.co.za", true },
  { "electricfencinggillitts.co.za", true },
  { "electricfencinghillcrest.co.za", true },
  { "electricfencingkloof.co.za", true },
  { "electricfencingpinetown.co.za", true },
  { "electricgatemotorgermiston.co.za", true },
  { "electricgatemotorglenvista.co.za", true },
  { "electricgatemotorrandburg.co.za", true },
  { "electricgatemotorsballito.co.za", true },
  { "electricgatemotorsberea.co.za", true },
  { "electricgatemotorsbluff.co.za", true },
  { "electricgatemotorskemptonpark.co.za", true },
  { "electricgatemotorsqueensburgh.co.za", true },
  { "electricgatemotorsroodepoort.co.za", true },
  { "electricgatemotorsumhlanga.co.za", true },
  { "electrichiddenhills.com", true },
  { "electrician-umhlangaridge.co.za", true },
  { "electricianagoura.com", true },
  { "electricianagourahills.com", true },
  { "electriciancalabasas.com", true },
  { "electriciancamarillo.com", true },
  { "electricianconejovalley.com", true },
  { "electriciandosvientos.com", true },
  { "electricianhiddenhills.com", true },
  { "electriciankemptonpark24-7.co.za", true },
  { "electricianlakesherwood.com", true },
  { "electricianlalucia.co.za", true },
  { "electricianmalibu.com", true },
  { "electricianmoorpark.com", true },
  { "electriciannewburypark.com", true },
  { "electricianoakpark.com", true },
  { "electriciansimivalley.com", true },
  { "electricianthousandoaks.com", true },
  { "electricianwestlakevillage.com", true },
  { "electricienasnieres.fr", true },
  { "electricimagination.co.uk", true },
  { "electriclakesherwood.com", true },
  { "electricmalibu.com", true },
  { "electricmoorpark.com", true },
  { "electricnewburypark.com", true },
  { "electricoakpark.com", true },
  { "electricsimivalley.com", true },
  { "electricthousandoaks.com", true },
  { "electricwestlakevillage.com", true },
  { "electro-pak.com.pk", true },
  { "electronic-ignition-system.com", true },
  { "electronicafacil.net", true },
  { "electronicfasteners.com", false },
  { "electrostatics.com", true },
  { "electrotainment.com", true },
  { "elefandt.com", true },
  { "elefantevoador.com", true },
  { "elegance-sm.com", true },
  { "eleicoes2014.com.br", true },
  { "eleicoes2016.com.br", true },
  { "eleicoes2018.com", true },
  { "elejordemarketingconsultancy.com", true },
  { "elekharris.com", true },
  { "elektro-adam.de", true },
  { "elektro-diehm.de", true },
  { "elektro-doerr.com", true },
  { "elektro-hammes.net", true },
  { "elektro-hofmann-gmbh.de", true },
  { "elektro-hornetz.de", true },
  { "elektro-kahlen.de", true },
  { "elektro-koehl.de", true },
  { "elektro-liebeskind.de", true },
  { "elektro-metz.de", true },
  { "elektro-pfeiffer.de", true },
  { "elektro-praha10.cz", true },
  { "elektro-rossbach.de", true },
  { "elektro-roth.de", true },
  { "elektro-stock.de", true },
  { "elektro-woerdehoff.de", true },
  { "elektrobusch.com", true },
  { "elektrofinke.de", true },
  { "elektrokarges.de", true },
  { "elektrometz.de", true },
  { "elektronickakancelar.cz", true },
  { "elektronische-post.org", true },
  { "elektropartner.nu", true },
  { "elektropost.org", true },
  { "elektrotechnik-heisel.de", true },
  { "elektrotechnik-kaetzel.de", true },
  { "elemental.software", true },
  { "elementalsoftware.net", true },
  { "elementalsoftware.org", true },
  { "elementarty.com", true },
  { "elementarywave.com", true },
  { "elements.guide", true },
  { "elementshop.co.uk", true },
  { "elenatranslations.nl", true },
  { "elenta.lt", true },
  { "elephants.net", true },
  { "elephpant.cz", true },
  { "elepover.com", true },
  { "elerizoentintado.es", false },
  { "eletesstilus.hu", true },
  { "eletor.com", true },
  { "eletor.pl", true },
  { "eletrochape.com.br", true },
  { "elettricista-roma.it", true },
  { "elettricista-roma.org", true },
  { "elettricisti.roma.it", true },
  { "elettrodomestici.roma.it", true },
  { "eleusis-zur-verschwiegenheit.de", true },
  { "elevationcreative.net", true },
  { "elevationtech.co.za", true },
  { "elevatoraptitudetest.com", true },
  { "elexprimidor.com", true },
  { "elexwong.com", true },
  { "elfe.de", true },
  { "elfnon.com", true },
  { "elforno.gr", true },
  { "elfring.eu", true },
  { "elfussports.com", true },
  { "elgalponazo.com.ar", true },
  { "elglobo.com.mx", false },
  { "elgosblanc.com", true },
  { "elgrecohotel.gr", true },
  { "elguillatun.cl", true },
  { "elhamadimi.com", true },
  { "elhorizontal.com", true },
  { "elhossari.com", true },
  { "elia.cloud", true },
  { "elian-art.de", true },
  { "elias-nicolas.com", true },
  { "eliaskordelakos.com", true },
  { "eliasojala.me", true },
  { "eliaswendt.com", true },
  { "eliaswendt.de", true },
  { "elibom.com", true },
  { "elie.net", true },
  { "elifesciences.org", true },
  { "eligibilis.com", true },
  { "eligible.com", true },
  { "eligibleapi.com", true },
  { "eligrey.com", true },
  { "elijahgrey.com", true },
  { "eliminercellulite.com", true },
  { "elinevanhaaften.nl", true },
  { "elinvention.ovh", true },
  { "elipsyum.com", true },
  { "elisa.ee", false },
  { "elisabeth-kostecki.de", true },
  { "elisabeth-strunz.de", true },
  { "elisabethkostecki.de", true },
  { "elisabethrene.com", true },
  { "elite-porno.ru", true },
  { "elite12.de", true },
  { "elitebike.com.co", true },
  { "elitebouncingfun.com", true },
  { "elitegameservers.net", true },
  { "elitel.nl", true },
  { "elitenutritionoficial.com", true },
  { "elitsa.gr", true },
  { "elixi.re", true },
  { "elixir.bzh", true },
  { "eliyah.co.il", true },
  { "elizabethbuitrago.com", true },
  { "elizabethrominski.com", true },
  { "elizeugomes.com.br", true },
  { "eljef.me", true },
  { "elkoy.org", true },
  { "ell-net.tokyo", true },
  { "ell888.com", true },
  { "ella-kwikmed.com", false },
  { "ellak.gr", true },
  { "ellegaard.dk", true },
  { "ellemental.me", true },
  { "ellencorddry.com", true },
  { "ellevit.ch", true },
  { "elliesbouncers.co.uk", true },
  { "elliot.cat", true },
  { "elliquiy.com", true },
  { "elliriehl.at", true },
  { "ellisamusements.co.uk", true },
  { "ellisleisure.co.uk", true },
  { "ellsinger.me", true },
  { "elmermx.ch", true },
  { "elnoorandelmohanad.com", true },
  { "elo-forum.org", true },
  { "elodrias.de", true },
  { "elon-musk.ml", true },
  { "elonaspitze.de", true },
  { "elosrah.com", true },
  { "elpaseadordeperros.com", true },
  { "elpo.net", true },
  { "elpoderdelespiritu.org", true },
  { "elradix.be", true },
  { "elrinconderovica.com", true },
  { "elsagradocoran.org", true },
  { "elshou.com", true },
  { "elsignificadodesonar.com", true },
  { "elstopstelten.nl", true },
  { "elsvanderlugt.nl", true },
  { "eltair.com", true },
  { "eltern-verein.ch", true },
  { "elternbeiratswahl.online", true },
  { "elternforum-birmensdorf.ch", true },
  { "elternverein-utzenstorf.ch", true },
  { "eltlaw.com", true },
  { "eluhome.de", true },
  { "eluvio.com", true },
  { "elvidence.com.au", true },
  { "elviraszabo.com", true },
  { "elvispresley.net", true },
  { "elvn.tokyo", false },
  { "elwave.org", true },
  { "elwix.com", true },
  { "elyasweb.com", true },
  { "elysiandigital.co", true },
  { "elysiria.fr", true },
  { "elysium.coop", true },
  { "elysiumware.com", true },
  { "em-biotek.cz", true },
  { "emaging-productions.fr", true },
  { "emaging.fr", true },
  { "email-pipeline.xyz", true },
  { "emailconfiguration.com", true },
  { "emailfuermich.de", true },
  { "emailhunter.co", true },
  { "emailmeform.com", true },
  { "emailprivacytester.com", true },
  { "emailtools.io", true },
  { "emaily.eu", true },
  { "emanol.co.uk", true },
  { "emanuel.photography", true },
  { "emanuela-gabriela.co.uk", true },
  { "emanuelduss.ch", true },
  { "emanueleanastasio.com", true },
  { "emanuelemazzotta.com", true },
  { "emarketingmatters.com", true },
  { "emasex.com", true },
  { "emasex.es", true },
  { "embassycargo.eu", true },
  { "emberlife.com", true },
  { "embodiaacademy.com", true },
  { "embodiaapp.com", true },
  { "embox.net", true },
  { "embracecontext.com", true },
  { "embraceni.org", true },
  { "embroideryexpress.co.uk", true },
  { "embsaypreschool.co.uk", true },
  { "emdrupholm.dk", true },
  { "emecew.com", true },
  { "emeliefalk.se", true },
  { "ememsei.com", true },
  { "emeraldcbdshop.com", false },
  { "emeraldcityswagger.com", true },
  { "emeraldcoastrideshare.com", true },
  { "emergencyshutoff.com", true },
  { "emergenzalavoro.com", true },
  { "emero.de", true },
  { "emex.ro", true },
  { "emi-air-comprime.com", true },
  { "emi.im", true },
  { "emielraaijmakers.nl", true },
  { "emigratieplanner.com", true },
  { "emil-dein-baecker.de", true },
  { "emil-reimann.com", true },
  { "emil.click", true },
  { "emil.one", true },
  { "emiliemunsch.com", true },
  { "emiliendevos.be", true },
  { "emilio.media", true },
  { "emiliobonelli.de", true },
  { "emiliops.com", true },
  { "emilong.com", true },
  { "emils-1910.de", true },
  { "emilstahl.com", true },
  { "emilstahl.dk", true },
  { "emilvarga.com", true },
  { "emily.moe", true },
  { "emilybellydance.com.au", true },
  { "emilyjohnson.ga", true },
  { "emilypennock.com", true },
  { "emirabiz.com", false },
  { "emirichardson.com", true },
  { "emisia.com", true },
  { "emissary.coffee", true },
  { "emivauthey.com", true },
  { "emkrivoy.com", true },
  { "emma.ly", true },
  { "emmagarland.com", true },
  { "emmagraystore.com", true },
  { "emo-poris.com", true },
  { "emobilityforum.org", true },
  { "emoji.bzh", false },
  { "emolafarm.com", true },
  { "emond-usedcars.net", true },
  { "empathogen.com", true },
  { "empathogens.com", true },
  { "empathy.ca", true },
  { "empatico.org", true },
  { "empatico.xyz", true },
  { "emperola.com", true },
  { "emperor-penguin.com", true },
  { "emperor-penguins.com", true },
  { "empese.com", true },
  { "empherino.net", true },
  { "empire-univ.com", true },
  { "emploi-collectivites.fr", true },
  { "employeeexpress.gov", true },
  { "employeemanual.com.au", true },
  { "employer.gov", true },
  { "employer.guru", true },
  { "employer411.com", false },
  { "emporikonathenshotel.com", true },
  { "emporiodascalcinhas.com.br", true },
  { "emporiodosperfumes.com.br", true },
  { "emporioonline.com.br", true },
  { "emporiopatanegra.com.br", true },
  { "emporioviverbem.com.br", false },
  { "empower.net", true },
  { "empowerdb.com", true },
  { "emprechtinger.com", true },
  { "emprego.pt", true },
  { "empregosrj.com", true },
  { "emprendeperuano.com", true },
  { "emprunterlivre.ci", true },
  { "empyrean-advisors.com", true },
  { "emrah.io", true },
  { "emresaglam.com", true },
  { "ems.gov", true },
  { "emsa-casm.ca", true },
  { "emulovers.com", true },
  { "emultiagent.pl", true },
  { "emvoice.net", true },
  { "emvoiceapp.com", true },
  { "emw3.com", true },
  { "emyr.net", true },
  { "emyself.org", true },
  { "emzi0767.com", true },
  { "en-booster.jp", true },
  { "en-crypt.me", true },
  { "en-maktoob.search.yahoo.com", false },
  { "en4rab.co.uk", true },
  { "enaah.de", true },
  { "enalean.com", true },
  { "enamae.net", true },
  { "enbecom.net", true },
  { "enbulleiugnen.com", true },
  { "encfs.win", true },
  { "encircleapp.com", true },
  { "encnet.de", true },
  { "encode.host", true },
  { "encodecloud.net", true },
  { "encoderx.uk", true },
  { "encountercss.com", true },
  { "encouragemarketing.com", true },
  { "encredible.de", false },
  { "encredible.org", false },
  { "encretplomb.ch", true },
  { "encrypted.google.com", true },
  { "encryptmy.site", true },
  { "encryptmysite.net", true },
  { "encuentraprecios.es", true },
  { "encycarpedia.com", true },
  { "encyclopedia-titanica.org", true },
  { "ende-x.com", true },
  { "endeal.nl", true },
  { "enderbycamping.com", true },
  { "enderle.cloud", true },
  { "enderszone.com", true },
  { "endingthedocumentgame.gov", true },
  { "endlessdiy.ca", true },
  { "endlessvideo.com", true },
  { "endoftenancycleaninglondon.co.uk", true },
  { "endoftennancycleaning.co.uk", true },
  { "endpointsystems.com", true },
  { "enduranceday.be", true },
  { "endustriyelfirinlar.com", true },
  { "endviolence.gc.ca", true },
  { "endzeit-architekten.com", false },
  { "eneamarcantoni.com", true },
  { "eneko.com", true },
  { "enemiesoflight.de", true },
  { "energie-sante.ch", true },
  { "energiekeurplus.nl", true },
  { "energija-visiems.lt", true },
  { "energy-healings.com", true },
  { "energy-in-balance.eu", true },
  { "energy-infra.nl", true },
  { "energy-initiative.com", true },
  { "energyatlas.com", true },
  { "energyaupair.se", true },
  { "energycodes.gov", true },
  { "energydrinkblog.de", true },
  { "energyefficientservices.com", true },
  { "energyelephant.com", true },
  { "energygenie.com.au", true },
  { "energyled.com.br", true },
  { "energysolutionstech.com", true },
  { "energystar.gov", true },
  { "enersaveapp.org", true },
  { "enersolelectrical.com.au", true },
  { "enet-navigator.de", true },
  { "enfantsdelarue.ch", true },
  { "enflow.nl", true },
  { "enforcement-trends-dev.azurewebsites.net", true },
  { "enforcement-trends-test.azurewebsites.net", true },
  { "enforcement-trends.azurewebsites.net", true },
  { "enganches.es", true },
  { "engarde.net", true },
  { "engaugetools.com", true },
  { "engelke-optik.de", true },
  { "engelundlicht.ch", true },
  { "engelwerbung.com", true },
  { "engg.ca", true },
  { "engie-laadpalen.nl", true },
  { "enginepit.com", true },
  { "enginsight.com", true },
  { "enginx.net", true },
  { "engl-server.de", true },
  { "engl-systems.de", true },
  { "englishbulgaria.net", true },
  { "englishcast.com.br", true },
  { "englishforums.com", true },
  { "englishlol.com", true },
  { "englishphonopass.com", true },
  { "englishstudio.com", true },
  { "englishtofrench.eu", true },
  { "englishtype.com", true },
  { "engrish.ml", true },
  { "engvid.com", true },
  { "engweld.co.uk", true },
  { "enigma.swiss", true },
  { "enijew.com", true },
  { "enitso.de", true },
  { "enixgaming.com", true },
  { "enjin.io", true },
  { "enjincoin.io", true },
  { "enjinwallet.io", true },
  { "enjinx.cn", true },
  { "enjinx.io", true },
  { "enjoy-drive.com", true },
  { "enlight.no", true },
  { "enlightenedhr.com", true },
  { "enlightenment.org", true },
  { "enlnf.link", true },
  { "enloestatebank.com", true },
  { "ennea-mediation.fr", true },
  { "enness.co.uk", true },
  { "ennori.jp", true },
  { "enorekcah.com", true },
  { "enot32.ru", true },
  { "enotecastore.it", true },
  { "enotefile.com", true },
  { "enpasenerji.com.tr", true },
  { "enquos.com", true },
  { "enrich.email", true },
  { "enrique.wtf", true },
  { "enriquepiraces.com", true },
  { "enrollapp.com", true },
  { "ensage.io", true },
  { "enscosupply.com", true },
  { "ensemble-rubato.de", true },
  { "ensembling.com", true },
  { "ensley.tech", true },
  { "ensons.de", true },
  { "ensured.com", true },
  { "ensured.nl", true },
  { "ensurtec.com", true },
  { "ent-london.com", true },
  { "entabe.jp", true },
  { "entactogen.com", true },
  { "entactogens.com", true },
  { "entercenter.ru", true },
  { "enterclaim.com", true },
  { "entersoftsecurity.com", true },
  { "entertainmentformitzvahs.com", true },
  { "entheogens.com", true },
  { "enthusiaformazione.com", true },
  { "entradaweb.cl", true },
  { "entrainr.com", true },
  { "entravex.com", true },
  { "entrecieletpierres.com", true },
  { "entrezdansladanse.fr", true },
  { "entropia.de", false },
  { "entropy.su", true },
  { "entrusted.io", true },
  { "entryboss.cc", true },
  { "entrypoint.sh", true },
  { "entwickler.land", true },
  { "enuchi.jp", true },
  { "enuygun.com", true },
  { "envant.co.uk", true },
  { "enveloppenopmaat.nl", true },
  { "envescent.com", true },
  { "enviatufoto.com", true },
  { "enviaya.com.mx", true },
  { "enviro-umweltservice.de", true },
  { "environmental-colleges.com", true },
  { "enviroprobasements.com", true },
  { "envirotech.com.au", true },
  { "envoie.moi", true },
  { "envoyez.moi", true },
  { "enxadahost.com", true },
  { "eocservices.co.uk", true },
  { "eoitek.com", true },
  { "eola.co", true },
  { "eonhive.com", true },
  { "eooe.me", true },
  { "eoonglobalresources.jp", true },
  { "eopugetsound.org", false },
  { "eosol.de", true },
  { "eosol.net", true },
  { "eosolutions.co", true },
  { "epa.com.es", true },
  { "epagos.com.ar", true },
  { "epaslaugos.lt", true },
  { "epassafe.com", true },
  { "epay.bg", true },
  { "epcreport.net", true },
  { "epdeveloperchallenge.com", true },
  { "ephesusbreeze.com", true },
  { "epi-lichtblick.de", true },
  { "epi.one", true },
  { "epic-vistas.com", true },
  { "epic-vistas.de", true },
  { "epicbouncycastles.co.uk", true },
  { "epicdowney.com", true },
  { "epicenter.work", true },
  { "epicenter.works", true },
  { "epicentre.works", true },
  { "epicfail.be", true },
  { "epicinflatables.co.uk", true },
  { "epickitty.co.uk", true },
  { "epiclub.com.au", true },
  { "epicpages.com", true },
  { "epicsecure.de", true },
  { "epicserver.ru", true },
  { "epicvistas.com", true },
  { "epicvistas.de", true },
  { "epicwalnutcreek.com", true },
  { "epidauros.be", true },
  { "epigrafes-led-farmakeia.gr", true },
  { "epilis.gr", true },
  { "epinesdeparadis.com", true },
  { "epiphanyofourlordchurch.com", true },
  { "epiphyte.network", true },
  { "episkevh-plaketas.gr", true },
  { "epistas.com", true },
  { "epistas.de", true },
  { "epitesz.co", true },
  { "epiteugma.com", true },
  { "epitome.cc", true },
  { "epitome.games", true },
  { "epizentrum.work", true },
  { "epizentrum.works", true },
  { "epmcentroitalia.it", true },
  { "epolitiker.com", true },
  { "epos-distributor.co.uk", true },
  { "epos.az", true },
  { "eposbirmingham.co.uk", true },
  { "eposbrighton.co.uk", true },
  { "eposbristol.co.uk", true },
  { "eposcardiff.co.uk", true },
  { "eposig.net", true },
  { "eposkent.co.uk", true },
  { "eposleeds.co.uk", true },
  { "eposleicester.co.uk", true },
  { "eposliverpool.co.uk", true },
  { "eposlondon.co.uk", true },
  { "epossheffield.co.uk", true },
  { "eposswansea.co.uk", true },
  { "epostplus.li", true },
  { "eposyork.co.uk", true },
  { "eppelblei.lu", true },
  { "eppelduerferjugend.lu", true },
  { "eppelpress.lu", true },
  { "eppione.com", true },
  { "epreskripce.cz", true },
  { "epsilon.dk", true },
  { "epsmil.it", true },
  { "epspolymer.com", true },
  { "epublibre.org", true },
  { "epvin.com", true },
  { "epyonsuniverse.net", true },
  { "eq-serve.com", true },
  { "eqibank.com", true },
  { "equalcloud.com", true },
  { "equi.ac", true },
  { "equiac.com", true },
  { "equidam.com", true },
  { "equinecoaching.ca", true },
  { "equinetherapy.ca", true },
  { "equinox.io", true },
  { "equipandoloja.net.br", true },
  { "equipedefrance.tv", true },
  { "equk.co.uk", true },
  { "er-mgmt.com", true },
  { "er.tl", true },
  { "er1s.xyz", true },
  { "erasmo.info", true },
  { "erasmusplusrooms.com", true },
  { "erate.fi", true },
  { "erath.fr", true },
  { "erdethamburgeronsdag.no", true },
  { "ereader.uno", true },
  { "erethon.com", true },
  { "erf-neuilly.com", true },
  { "ergo-open.de", true },
  { "ergobyte.eu", true },
  { "ergobyte.gr", true },
  { "ergodark.com", true },
  { "ergoterapeutas.lt", true },
  { "ergovita.com.br", true },
  { "ergovitanet.com.br", true },
  { "eriador.io", true },
  { "ericabrahamsen.net", true },
  { "ericairwin.com", true },
  { "ericdiao.com", true },
  { "erichogue.ca", true },
  { "erichorstmanshof.nl", true },
  { "ericjohnltd.com", true },
  { "erick.blog", true },
  { "ericksonvasquez.com", true },
  { "ericleuthardt.com", true },
  { "erico.jp", true },
  { "ericoc.com", true },
  { "erics.site", true },
  { "ericspeidel.de", true },
  { "ericvaughn-flam.com", true },
  { "ericyl.com", true },
  { "eridanus.uk", true },
  { "erigrid.eu", true },
  { "erik-stomp.de", true },
  { "erikapsicologia.com", true },
  { "erikatanithphotography.co.uk", true },
  { "erikheemskerk.nl", true },
  { "erikhubers.nl", true },
  { "erikkruithof.nl", true },
  { "erikserver2.tk", true },
  { "erikw.me", true },
  { "erikwalther.eu", true },
  { "erinaceinae.com", true },
  { "eriner.me", true },
  { "eringmaguire.com", true },
  { "erinn.io", true },
  { "erisrenee.com", true },
  { "erkaelderbarenaaben.dk", true },
  { "erlebnisarchaeologie-bayern.de", true },
  { "ernal.net", true },
  { "ernest.ly", true },
  { "ernsteisprung.ch", true },
  { "eromon.net", true },
  { "eron.info", true },
  { "eropics.org", true },
  { "erp-band.ru", true },
  { "erp.band", true },
  { "erpax.com", true },
  { "erpband.ru", true },
  { "erpcargo.com", false },
  { "erpelstolz.at", true },
  { "erperium.com", true },
  { "erpiv.com", true },
  { "errietta.me", true },
  { "error.fail", true },
  { "error418.nl", true },
  { "ers35.com", true },
  { "ersa-shop.com", true },
  { "ershiwo.com", true },
  { "ersindemirtas.com", true },
  { "ersinerce.com", true },
  { "erstehilfeprodukte.at", true },
  { "ert.ovh", true },
  { "eru.im", false },
  { "eru.me", true },
  { "eru.moe", true },
  { "erudikum.cz", true },
  { "ervaarjapan.nl", true },
  { "erverydown.ml", true },
  { "erwin.saarland", true },
  { "erwinpaal.nl", true },
  { "erwinschmaeh.ch", true },
  { "erwinwensveen.nl", true },
  { "erythroxylum-coca.com", true },
  { "es-geenen.de", true },
  { "es.search.yahoo.com", false },
  { "esafar.cz", false },
  { "esagente.com", true },
  { "esailinggear.com", true },
  { "esalesdata.com", true },
  { "esamievalori.com", true },
  { "esample.info", true },
  { "esb9588.info", false },
  { "esc.chat", true },
  { "esc.gov", true },
  { "escael.org", true },
  { "escapeforyou.com", true },
  { "escapeplaza.de", true },
  { "escaperoomdoctor.com", true },
  { "escaperoomsolutions.com", true },
  { "escapetalk.nl", true },
  { "escargotbistro.com", true },
  { "escavador.com", true },
  { "esclear.de", true },
  { "escolibri.com", true },
  { "escontact.ch", true },
  { "escortlistings.ca", true },
  { "escortlistings.eu", true },
  { "escortlistings.fr", true },
  { "escortlistings.mx", true },
  { "escortlistings.ph", true },
  { "escortlistings.us", true },
  { "escortlistingsuk.co.uk", true },
  { "escortmantra.com", true },
  { "escritoriodearte.com", false },
  { "escuelabiblica.com", true },
  { "escyr.top", true },
  { "esd.cc", true },
  { "esdenera.com", true },
  { "esdiscuss.org", true },
  { "esdvfootloose.nl", true },
  { "eservices-greece.com", true },
  { "esg-abi2001.de", true },
  { "esgen.org", true },
  { "esgr.in", true },
  { "esh.ink", true },
  { "esher.ac.uk", true },
  { "eshigami.com", true },
  { "eshop-prices.com", true },
  { "eshspotatoes.com", true },
  { "esigmbh.de", true },
  { "esigtorg.ru", true },
  { "esim.cz", true },
  { "esite.ch", true },
  { "eskdale.net", true },
  { "eskriett.com", true },
  { "eslint.org", true },
  { "esoa.net", true },
  { "esoko.eu", true },
  { "esolcourses.com", true },
  { "esolitos.com", true },
  { "esono.de", true },
  { "esote.net", true },
  { "esoterikerforum.de", true },
  { "esovita.de", true },
  { "espace-caen.fr", true },
  { "espace-gestion.fr", true },
  { "espace.network", true },
  { "espacelanguetokyo.fr", true },
  { "espacetemps.ch", true },
  { "espacetheosophie.fr", true },
  { "espacio-cultural.com", true },
  { "espanol.search.yahoo.com", false },
  { "espanova.com", true },
  { "espci.fr", true },
  { "especificosba.com.ar", true },
  { "espehus.dk", true },
  { "espgg.org", true },
  { "espigol.org", true },
  { "espiritugay.com", true },
  { "esport-agency.fr", true },
  { "esport-battlefield.com", true },
  { "esports-network.de", true },
  { "espower.com.sg", true },
  { "espritrait.com", true },
  { "esquirou-trieves.fr", true },
  { "esrhd.com", true },
  { "esrinfo.com", true },
  { "essayace.co.uk", true },
  { "essayads.com", true },
  { "essaybrand.com", true },
  { "essaychecker.com", true },
  { "essaydirectory.com", true },
  { "essayforsale.net", true },
  { "essayforum.com", false },
  { "essayhave.com", true },
  { "essayjob.com", true },
  { "essaylib.com", true },
  { "essaynews.com", true },
  { "essaypro.net", true },
  { "essayscam.org", true },
  { "essaytalk.com", true },
  { "essaywriting.biz", true },
  { "essenalablog.de", true },
  { "essencespresso.es", true },
  { "essenciasparis.com.br", true },
  { "essex.cc", true },
  { "essite.net", true },
  { "esslm.sk", true },
  { "essoduke.org", true },
  { "essteebee.ch", true },
  { "est-it.de", true },
  { "establo.pro", true },
  { "estada.ch", true },
  { "estafallando.es", true },
  { "estafallando.mx", true },
  { "estaleiro.org", true },
  { "estate360.co.tz", true },
  { "estcequejailaflemme.fr", false },
  { "estcequonmetenprodaujourdhui.info", true },
  { "esteam.se", true },
  { "estedafah.com", true },
  { "estefan.dyndns.org", true },
  { "esteladigital.com", true },
  { "esterilizacion-perros.es", true },
  { "esteticanorte.com.br", true },
  { "estetista.net", true },
  { "estherlew.is", true },
  { "esthernariyoshi.com", true },
  { "esthesoleil.jp", true },
  { "estilopack-loja.com.br", true },
  { "estimulantesbrasil.com", true },
  { "estintori.roma.it", true },
  { "estoic.net", true },
  { "estonia.net", true },
  { "estonoentraenelexamen.com", true },
  { "estoppels.com", true },
  { "estraks.com", true },
  { "estudiarparaser.com", true },
  { "estudiaryaprenderingles.com", true },
  { "estufitas.com", true },
  { "esu.moe", true },
  { "esu.wiki", true },
  { "esu.zone", true },
  { "esurety.net", true },
  { "esuretynew.azurewebsites.net", true },
  { "esyume.com", true },
  { "et-inf.de", true },
  { "eta.cz", true },
  { "etaes.eu", true },
  { "etajerka.spb.ru", true },
  { "etaoinwu.win", true },
  { "etasigmaphi.org", true },
  { "etath.com", true },
  { "etax.com.au", true },
  { "etccooperative.org", true },
  { "etch.co", true },
  { "etd-glasfaser.de", true },
  { "etda.or.th", true },
  { "etduvindemoselle.fr", true },
  { "etech-solution.com", true },
  { "etech-solution.net", true },
  { "etech-solutions.com", true },
  { "etechsolution.net", true },
  { "eteesheet.com", true },
  { "eternal-warriors.de", true },
  { "eternalabyss.int.eu.org", true },
  { "eternalflame.info", true },
  { "eternalsymbols.com", true },
  { "eternit.roma.it", true },
  { "etfacta.com", true },
  { "eth-faucet.net", true },
  { "eth0.nl", true },
  { "etha.nz", true },
  { "ethack.org", true },
  { "ethan.pm", true },
  { "ethanchin.com", true },
  { "ethanjones.me", true },
  { "ethanlew.is", true },
  { "ethelbrooks.com", true },
  { "ethelbrooks.es", true },
  { "ethercalc.com", true },
  { "ethercalc.org", true },
  { "ethergeist.de", true },
  { "etherium.org", true },
  { "etherpad.nl", true },
  { "ethers.news", true },
  { "ethicalconsumer.org", true },
  { "ethicaldata.co.uk", true },
  { "ethicalpolitics.org", true },
  { "ethicsburg.gov", true },
  { "ethika.com", true },
  { "ethil-faer.fr", true },
  { "ethiobaba.com", true },
  { "ethiopian.dating", true },
  { "ethiopiannews247.com", true },
  { "ethitter.com", true },
  { "etienne.cc", true },
  { "etiennes.work", true },
  { "etiquetaunica.com.br", true },
  { "etni-cidade.net", true },
  { "etnis.id", true },
  { "etnoria.com", true },
  { "etoile-usedcars.com", true },
  { "etre-soi.ch", true },
  { "etre-vivant.fr", true },
  { "etrecosmeticderm.com", true },
  { "etresmant.es", true },
  { "etrker.com", true },
  { "etskinner.com", true },
  { "etskinner.net", true },
  { "etssquare.com", true },
  { "etudesbibliques.fr", true },
  { "etudesbibliques.net", true },
  { "etudesbibliques.org", true },
  { "eturist.si", true },
  { "etv.cx", true },
  { "etwalldentalpractice.co.uk", true },
  { "etyd.org", true },
  { "eu-darlehen-finanzierung.de", true },
  { "eu-datenbank.de", true },
  { "eu-stellenangebot.de", true },
  { "euaggelion.blog.br", true },
  { "euanbarrett.com", true },
  { "euchre.us", true },
  { "eugenechae.com", true },
  { "eugenekay.com", true },
  { "eugenetech.org", true },
  { "eujuicers.bg", true },
  { "eujuicers.com", true },
  { "eujuicers.com.hr", true },
  { "eujuicers.com.ua", true },
  { "eujuicers.cz", true },
  { "eujuicers.de", true },
  { "eujuicers.es", true },
  { "eujuicers.fr", true },
  { "eujuicers.hu", true },
  { "eujuicers.it", true },
  { "eujuicers.pl", true },
  { "eujuicers.pt", true },
  { "eujuicers.ro", true },
  { "eujuicers.rs", true },
  { "eujuicers.ru", true },
  { "eujuicers.si", true },
  { "eujuicers.sk", true },
  { "eulenschmiede.de", true },
  { "eupay.de", true },
  { "euporos.ch", true },
  { "eureka.archi", true },
  { "eurekaarchi.com", true },
  { "eurekaarchitecture.com", true },
  { "eurekz.com", true },
  { "euro-construction.co.uk", true },
  { "euroalter.com", true },
  { "eurocars2000.es", true },
  { "eurocenterobuda.hu", true },
  { "eurocertificazione.it", true },
  { "eurocomcompany.cz", true },
  { "euroconthr.ro", true },
  { "eurodentaire.com", true },
  { "euroflora.com", true },
  { "euroflora.mobi", true },
  { "eurofrank.eu", true },
  { "eurolocarno.es", true },
  { "europalettenkaufen.de", true },
  { "europapier.at", false },
  { "europapier.net", true },
  { "europareise2010.de", true },
  { "europarts-sd.com", true },
  { "europastudien.de", true },
  { "european-agency.org", true },
  { "europeancupinline.eu", true },
  { "europeantimberconnectors.ca", true },
  { "europeantransportmanagement.com", true },
  { "europeanwineresource.com", true },
  { "europeos.es", true },
  { "europetravelservice.co.uk", true },
  { "europop.com", true },
  { "eurora.de", true },
  { "eurorecambios24.com", true },
  { "euroroad17.dk", true },
  { "euroscot.de", true },
  { "euroshop.or.at", true },
  { "euroskano.nl", true },
  { "eurotime.ua", true },
  { "eurotramp.com", true },
  { "eurotravelstar.eu", true },
  { "eurousa.us", true },
  { "eurovision.ie", true },
  { "euterpiaradio.ch", true },
  { "eutotal.com", true },
  { "euwid-energie.de", true },
  { "euwid.de", true },
  { "ev-zertifikate.de", true },
  { "eva-select.com", true },
  { "eva.cz", true },
  { "evafojtova.cz", true },
  { "evailoil.ee", true },
  { "evailoil.eu", true },
  { "evalesc.com", true },
  { "evaluate.jp", true },
  { "evamachkova.cz", true },
  { "evamathil.de", true },
  { "evamira.com", true },
  { "evanfiddes.com", true },
  { "evangelicalmagazine.com", true },
  { "evangelosm.com", true },
  { "evansdesignstudio.com", true },
  { "evantageglobal.com", true },
  { "evanwang0.com", true },
  { "evasioncreole.com", true },
  { "evasovova.cz", true },
  { "evavolfova.cz", true },
  { "evdenevenakliyatankara.name.tr", true },
  { "eve.ac", true },
  { "eve0s.com", true },
  { "eveadmin.azurewebsites.net", false },
  { "evelienzorgt.nl", true },
  { "evelyndayman.com", true },
  { "evemodx.com", true },
  { "evenementenhoekvanholland.nl", true },
  { "event-blick.de", true },
  { "event-fullyyours.com", true },
  { "event4fun.no", true },
  { "eventaro.com", true },
  { "eventerlebnis.ch", true },
  { "eventide.space", true },
  { "eventive.org", true },
  { "eventnexus.co.uk", true },
  { "eventosbgp.com", true },
  { "eventosenmendoza.com.ar", true },
  { "events-hire.co.uk", true },
  { "eventservicestockholm.se", true },
  { "eventsframe.com", true },
  { "eventtech.com", false },
  { "evenwallet.com", true },
  { "eveonline.com", true },
  { "ever.sale", true },
  { "everain.me", true },
  { "everettsautorepair.com", true },
  { "everfine.com.tw", true },
  { "evergladesrestoration.gov", true },
  { "evergreenmichigan.com", true },
  { "everhome.de", true },
  { "everify.gov", true },
  { "everitoken.io", true },
  { "everlastingoak.de", true },
  { "everling.lu", true },
  { "everlong.org", true },
  { "evermarkstudios.com", true },
  { "everpcpc.com", true },
  { "evertonarentwe.com", true },
  { "everwaking.com", false },
  { "every-day-life.com", true },
  { "everybodyhertz.co.uk", true },
  { "everyday.eu.org", true },
  { "everydayhealthandbeauty.com", true },
  { "everydaywot.com", true },
  { "everydaywp.com", true },
  { "everyfad.com", true },
  { "everything-everywhere.com", true },
  { "everythingaccess.com", true },
  { "everythingstech.com", false },
  { "everythinq.com", true },
  { "everytrycounts.gov", false },
  { "everywhere.cloud", true },
  { "eveshamglass.co.uk", true },
  { "eveswell.com", true },
  { "evexia.xyz", true },
  { "evidence-based.review", true },
  { "evidencebased.net", true },
  { "evidenceusa.com.br", true },
  { "evidencija.ba", true },
  { "evidentiasoftware.com", true },
  { "evilbunnyfufu.com", true },
  { "evileden.com", true },
  { "evilized.de", true },
  { "evilmartians.com", true },
  { "evion.nl", true },
  { "evlann.com", false },
  { "evlear.com", true },
  { "evoco.vc", true },
  { "evodation.com", true },
  { "evodation.org", true },
  { "evodia-spirits.de", true },
  { "evok.com.co", false },
  { "evolutioninflatables.co.uk", true },
  { "evolutionlending.co.uk", true },
  { "evolutionpets.com", true },
  { "evolvetechnologies.co.uk", true },
  { "evolvingthoughts.net", true },
  { "evony.eu", true },
  { "evosyn.com", true },
  { "evote-ch.ch", true },
  { "evotec.pl", true },
  { "evotec.xyz", true },
  { "evoting-test.ch", true },
  { "evoting.ch", true },
  { "evrial.com", true },
  { "evrica.me", true },
  { "evromandie.ch", true },
  { "evrotrust.com", true },
  { "evstatus.com", true },
  { "evtasima.name.tr", true },
  { "evtripping.com", true },
  { "evtscan.io", true },
  { "evyn.eu", true },
  { "ewa-hayward.co.uk", true },
  { "ewaipiotr.pl", true },
  { "ewanm89.co.uk", true },
  { "ewanm89.com", true },
  { "ewanm89.uk", true },
  { "ewhitehat.com", true },
  { "ewie.name", true },
  { "ewinstore.com", true },
  { "ewout.io", true },
  { "ewsfeed.com", true },
  { "ewtl.es", true },
  { "ewus.de", true },
  { "ewycena.pl", true },
  { "ex-deli.jp", true },
  { "exablue.de", true },
  { "exactlyinfinite.com", true },
  { "exactphilosophy.net", true },
  { "exadime.net", true },
  { "exagoni.com.au", true },
  { "exagoni.com.my", true },
  { "exaktus.pt", true },
  { "examedge.com", true },
  { "example.wf", true },
  { "example4d.com", true },
  { "exampleessays.com", true },
  { "examsmate.in", true },
  { "exaplac.com", true },
  { "exarpy.com", true },
  { "exatmiseis.net", false },
  { "excaliburtitle.com", false },
  { "exceedagency.com", true },
  { "excel-mechanical.com", true },
  { "excelhot.com", true },
  { "excelkurs.one", true },
  { "excella.me", true },
  { "exceltechdubai.com", true },
  { "exceltechoman.com", true },
  { "excentos.com", true },
  { "exceptionalservers.com", true },
  { "excess-baggage.com", true },
  { "excessamerica.com", true },
  { "excesssecurity.com", true },
  { "exchangers.top", true },
  { "exchaser.com", true },
  { "exclusivebeautystudio.com.au", true },
  { "exclusivebouncycastles.co.uk", true },
  { "exclusivecarcare.co.uk", true },
  { "excursionescaribe.com", true },
  { "exdamo.de", false },
  { "exe-boss.tech", true },
  { "execution.biz.tr", true },
  { "executiveresolutions.co.uk", true },
  { "exeintel.com", true },
  { "exekutori.com", true },
  { "exemples-de-stands.com", true },
  { "exerforge.com", true },
  { "exerforge.net", true },
  { "exeria.de", true },
  { "exexcarriers.com", true },
  { "exgaywatch.com", true },
  { "exgen.io", true },
  { "exhalespa.com", false },
  { "exhibityour.com", true },
  { "exiahost.com", true },
  { "exit9wineandliquor.com", true },
  { "exitooutdoor.com", true },
  { "exmart.ng", true },
  { "exmoe.com", true },
  { "exocen.com", true },
  { "exon.io", true },
  { "exordiumconcepts.com", true },
  { "exoscale.ch", true },
  { "exoscale.com", true },
  { "exoten-spezialist.de", true },
  { "exoticads.com", true },
  { "exozwiki.com", true },
  { "exp.de", true },
  { "expancio.com", false },
  { "expanddigital.media", true },
  { "expandeco.com", true },
  { "expatmortgage.uk", true },
  { "expe.voyage", true },
  { "expeditiegrensland.nl", true },
  { "experienceoutdoors.org.uk", true },
  { "experienceoz.com.au", true },
  { "experimentator.cz", true },
  { "experise.fr", true },
  { "expert-korovin.ru", true },
  { "expert.cz", true },
  { "experteasy.com.au", true },
  { "expertofficefitouts.com.au", true },
  { "expertpanel.gc.ca", true },
  { "expertplumbingandsolarservicesbathurst.com.au", true },
  { "expertsverts.com", true },
  { "expertvagabond.com", true },
  { "expertviolinteacher.com", true },
  { "expii.com", true },
  { "expiscor.solutions", true },
  { "explicate.org", true },
  { "explodie.org", true },
  { "explodingcamera.com", true },
  { "exploit-db.com", true },
  { "exploit.cz", false },
  { "exploit.party", true },
  { "exploit.ph", true },
  { "exploited.cz", true },
  { "exploitit.com.au", true },
  { "exploodo.rocks", true },
  { "explorebigideas.com", true },
  { "exploremonero.com", true },
  { "exploretsp.gov", true },
  { "exploringenderby.com", true },
  { "expmind.co.in", true },
  { "expo-america.ru", true },
  { "expo-asia.ru", true },
  { "expo-europe.ru", true },
  { "expo-larionov.org", true },
  { "exponentialnews.net", true },
  { "expoort.com", true },
  { "expoort.es", true },
  { "expoort.fr", true },
  { "expoort.it", true },
  { "expopodium.com", true },
  { "exporta.cz", true },
  { "exposurecompensation.co.uk", true },
  { "express-shina.ru", true },
  { "express-vpn.com", true },
  { "express1040.com", true },
  { "expressemotion.net", true },
  { "expresshosting.org", true },
  { "expressmarket.ru", true },
  { "expresstinte.de", true },
  { "expressvpn.com", true },
  { "expresswins.co.uk", true },
  { "expromo.eu", true },
  { "expxkcd.com", true },
  { "exs.lv", true },
  { "exside.com", true },
  { "exsora.com", true },
  { "extasic.com", true },
  { "extendwings.com", true },
  { "extensia.it", true },
  { "extensibility.biz.tr", true },
  { "extensiblewebmanifesto.org", true },
  { "extensiblewebreportcard.org", true },
  { "extensiblewebsummit.org", true },
  { "extensionciglia.roma.it", true },
  { "extensionschallenge.com", true },
  { "extensiontree.com", true },
  { "exteriorlightingagoura.com", true },
  { "exteriorlightingagourahills.com", true },
  { "exteriorlightingcalabasas.com", true },
  { "exteriorlightingcamarillo.com", true },
  { "exteriorlightingconejovalley.com", true },
  { "exteriorlightingdosvientos.com", true },
  { "exteriorlightinghiddenhills.com", true },
  { "exteriorlightinglakesherwood.com", true },
  { "exteriorlightingmalibu.com", true },
  { "exteriorlightingmoorpark.com", true },
  { "exteriorlightingnewburypark.com", true },
  { "exteriorlightingoakpark.com", true },
  { "exteriorlightingsimivalley.com", true },
  { "exteriorlightingthousandoaks.com", true },
  { "exteriorlightingwestlakevillage.com", true },
  { "extintormadrid.com", true },
  { "extradesktops.com", false },
  { "extradiely.sk", true },
  { "extradivers-worldwide.com", true },
  { "extranetpuc.com.br", true },
  { "extratorrent.cool", true },
  { "extreemhost.nl", true },
  { "extreme-gaming.de", true },
  { "extreme-gaming.us", true },
  { "extreme-players.com", true },
  { "extreme-players.de", true },
  { "extreme.co.th", true },
  { "exvs.org", true },
  { "exyplis.com", true },
  { "eydesignguidelines.com", true },
  { "eye-encounters.com", true },
  { "eyeandfire.com", true },
  { "eyebrowsmicroblading.co.uk", true },
  { "eyecandy.gr", true },
  { "eyeglasses.com", false },
  { "eyelashconcept.com", true },
  { "eyeonid.com", true },
  { "eyep.me", true },
  { "eyes-berg.ch", true },
  { "eyes-berg.com", true },
  { "eyesandearsrescue.org", true },
  { "eynio.com", true },
  { "eyona.com", true },
  { "eyps.net", true },
  { "eyrelles-tissus.com", true },
  { "eythorsson.com", true },
  { "ez3d.eu", true },
  { "ezakazivanje.rs", true },
  { "ezdog.press", true },
  { "ezequiel-garzon.net", true },
  { "ezesec.com", true },
  { "ezgif.com", true },
  { "ezhik-din.ru", true },
  { "eztvtorrent.com", true },
  { "ezwritingservice.com", true },
  { "f-droid.org", true },
  { "f-hd.net", true },
  { "f-thie.de", true },
  { "f-u-c-k.wien", true },
  { "f00.fr", true },
  { "f0x.es", true },
  { "f13cybertech.cz", true },
  { "f1classement.com", true },
  { "f1fever.co.uk", true },
  { "f1fever.net", true },
  { "f1minute.com", true },
  { "f1nal-lap.be", true },
  { "f2h.io", true },
  { "f3nws.com", true },
  { "f43.me", true },
  { "f5197.co", true },
  { "f5nu.com", true },
  { "f6729.co", true },
  { "f6729.com", true },
  { "f6957.co", true },
  { "f88-line.com", true },
  { "f88-line.net", true },
  { "f88288.com", true },
  { "f88da.com", true },
  { "f88fine.com", true },
  { "f88good.com", true },
  { "f88line.com", true },
  { "f88line.net", true },
  { "f88ll.com", true },
  { "f88yule1.com", true },
  { "f88yule111.com", true },
  { "f88yule122.com", true },
  { "f88yule5.com", true },
  { "f88yule6.com", true },
  { "f88yule7.com", true },
  { "f88yule8.com", true },
  { "f8s.co", true },
  { "f9297.co", true },
  { "f9397.com", true },
  { "f9721.com", true },
  { "f9728.co", true },
  { "fa-works.com", true },
  { "fabbro-roma.org", true },
  { "fabbro.roma.it", true },
  { "faber.org.ru", true },
  { "fabian-fingerle.de", true },
  { "fabian-klose.com", true },
  { "fabian-klose.de", true },
  { "fabian-klose.net", true },
  { "fabianackle.ch", true },
  { "fabianbeiner.com", true },
  { "fabianbeiner.de", false },
  { "fabianegli.ch", true },
  { "fabianfranke.de", true },
  { "fabiankoeppen.com", true },
  { "fabien-hebuterne.fr", true },
  { "fabienne-roux.org", true },
  { "fabiobier.com", true },
  { "fabjansisters.eu", true },
  { "fabled.com", true },
  { "fableforge.nl", true },
  { "fabrica360.com", true },
  { "fabriceleroux.com", true },
  { "fabriziocavaliere.it", true },
  { "fabriziorocca.it", true },
  { "fabrykowski.com", true },
  { "fabrysociety.org", true },
  { "fabse.net", true },
  { "fabservicos.com.br", true },
  { "facai666.cc", true },
  { "facai888.cc", true },
  { "facanabota.com", true },
  { "facanabota.com.br", true },
  { "facarospauls.com", true },
  { "facchinaggio.milano.it", true },
  { "facciadastile.it", true },
  { "face-fashion.de", true },
  { "face-mania.com", true },
  { "facealacrise.fr", true },
  { "facebattle.com", true },
  { "facebook-atom.appspot.com", true },
  { "facebook.com", false },
  { "facebydrh.com", true },
  { "facebylouise.co.uk", true },
  { "facekungfu.com", true },
  { "facepainting.gr", true },
  { "facerepo.com", true },
  { "faceresources.org", true },
  { "facesdr.com", true },
  { "facfox.com", true },
  { "fach-journalist.de", true },
  { "fachmann-umzuege.de", true },
  { "fachschaftslisten.at", true },
  { "fachschaftslisten.org", true },
  { "facialexercising.com", true },
  { "facil.services", false },
  { "faciledireto.com.br", true },
  { "facilities.fr", true },
  { "facilitiessurvey.org", true },
  { "facility-service-muenchen.de", true },
  { "fackovcova.cz", true },
  { "fackovcova.eu", true },
  { "fackovcova.sk", true },
  { "fackovec.cz", true },
  { "fackovec.eu", true },
  { "fackovec.sk", true },
  { "factbytefactbox.com", true },
  { "factor.cc", false },
  { "factorio.tools", true },
  { "factoriotools.com", true },
  { "factorit.fr", true },
  { "factory-f.net", true },
  { "factuur.pro", true },
  { "factuursturen.be", true },
  { "factuursturen.nl", true },
  { "factys.do", true },
  { "factys.es", true },
  { "facua.org", true },
  { "facucosta.com.ar", true },
  { "faderweb.de", true },
  { "fadilus.com", false },
  { "faehler.de", true },
  { "faelix.net", true },
  { "faeservice.eu", true },
  { "fafa106.com", true },
  { "faggut.gg", true },
  { "fahmed.de", true },
  { "fahnamporn.com", true },
  { "fahrenwal.de", true },
  { "fahrenwalde.de", true },
  { "fahrschule-laux.de", true },
  { "fahrwerk.io", true },
  { "fai.gov", true },
  { "faidanoi.it", true },
  { "faidatefacile.it", true },
  { "fail.coach", true },
  { "fail4free.de", true },
  { "failover.de", true },
  { "failover.eu", true },
  { "fairbill.com", true },
  { "fairedeseconomies.info", true },
  { "fairgolfteams.com", true },
  { "fairmarketing.com", true },
  { "fairplay.im", true },
  { "fairr.de", true },
  { "fairr.online", true },
  { "fairssl.dk", true },
  { "fairssl.se", true },
  { "fairviewmotel-simcoe.com", true },
  { "fairydust.space", true },
  { "faithcentercogop.net", true },
  { "faithgrowth.com", true },
  { "faithindemocracy.eu", false },
  { "faithleaks.org", true },
  { "faithwatch.org", true },
  { "faixaazul.com", true },
  { "fakeduckpond.com", true },
  { "fakeemergency.com", true },
  { "fakerli.com", true },
  { "fakti.bg", true },
  { "faktotum.tech", true },
  { "fakturi.com", true },
  { "fakturoid.cz", true },
  { "falaeapp.org", true },
  { "falaowang.com", true },
  { "falbros.com", true },
  { "falcema.com", true },
  { "falconfrag.com", true },
  { "falconvintners.com", true },
  { "falcoz.co", true },
  { "faldoria.de", true },
  { "falegname-roma.it", true },
  { "falegname.roma.it", true },
  { "falegnameria.milano.it", true },
  { "falkhusemann.de", true },
  { "fallenangeldrinks.co.uk", true },
  { "fallenangeldrinks.com", true },
  { "fallenangelspirits.co.uk", true },
  { "fallenangelspirits.com", true },
  { "fallenmoons.nl", true },
  { "fallenmystic.com", true },
  { "fallenspirits.co.uk", true },
  { "fallin.space", true },
  { "falling.se", true },
  { "fallofthecitadel.com", true },
  { "falsum.net", true },
  { "fam-kreibich.de", true },
  { "fam-stemmer.de", false },
  { "fam-weyer.de", true },
  { "famcloud.de", true },
  { "fameng.nl", true },
  { "fameus.fr", true },
  { "famfi.co", true },
  { "familiaperez.net", true },
  { "familie-keil.de", true },
  { "familie-kruithof.nl", true },
  { "familie-kupschke.de", true },
  { "familie-leu.ch", true },
  { "familie-monka.de", true },
  { "familie-poeppinghaus.de", true },
  { "familie-remke.de", true },
  { "familieholme.de", true },
  { "familiekiekjes.nl", true },
  { "familienportal.de", true },
  { "familiereimann.com", true },
  { "familjenfrodlund.se", true },
  { "familjenm.se", true },
  { "familleseux.net", true },
  { "familylawhotline.org", true },
  { "familyparties.co.uk", true },
  { "familyreal.ru", true },
  { "familytreehq.com", true },
  { "familyworld.gr", true },
  { "famion.eu", false },
  { "famososnaweb.com", true },
  { "famousbirthdays.com", true },
  { "famoushostels.com", true },
  { "famvangelder.nl", true },
  { "famvsomeren.nl", true },
  { "fan.gov", true },
  { "fanactu.com", true },
  { "fanatical.com", true },
  { "fanatik.io", true },
  { "fanboi.ch", true },
  { "fancy-bridge.com", true },
  { "fancy.org.uk", true },
  { "fancygaming.dk", true },
  { "fandler.cz", true },
  { "fandomservices.com", true },
  { "fanfareunion.ch", true },
  { "fangs.ink", true },
  { "fanhouwan.com", true },
  { "fanjingbo.com", true },
  { "fanjingbo.me", true },
  { "fanjoe.be", true },
  { "fansale.de", true },
  { "fansided.com", true },
  { "fantasiapainter.com", true },
  { "fantasiatravel.hr", true },
  { "fantasmesexuel.info", true },
  { "fantasticcleaners.com.au", true },
  { "fantastichandymanmelbourne.com.au", true },
  { "fantastici.de", true },
  { "fantasticservices.com", true },
  { "fantasticservicesgroup.com.au", true },
  { "fantasycastles.co.uk", true },
  { "fantasycdn.com", true },
  { "fantasydrop.com", true },
  { "fantasyescortsbirmingham.co.uk", true },
  { "fantasymina.de", true },
  { "fantasypartyhire.com.au", true },
  { "fantasyspectrum.com", true },
  { "fantgames.com", true },
  { "fantopia.club", true },
  { "fantraxhq.com", true },
  { "fanyina.cn", true },
  { "fanyina.com", true },
  { "fanyue123.tk", true },
  { "fanz.pro", true },
  { "fanzlive.com", true },
  { "fapplepie.com", true },
  { "faq.ie", true },
  { "fara.gov", true },
  { "faradji.nu", true },
  { "faradome.ws", true },
  { "faradrive.ir", true },
  { "faraslot8.com", true },
  { "farcecrew.de", true },
  { "farces.com", false },
  { "farfallapets.com.br", true },
  { "farfetchos.com", true },
  { "fargtorget.se", true },
  { "farhadexchange.com", true },
  { "farhood.org", true },
  { "farid.is", true },
  { "farizizhan.com", true },
  { "farleybrass.com.au", true },
  { "farleymetals.com.au", true },
  { "farmacia-discreto.com", true },
  { "farmaciacorvi.it", true },
  { "farmaciadejaime.es", true },
  { "farmer.dating", true },
  { "farmers.gov", false },
  { "farmkazuto.com", true },
  { "faroebusinessreport.com", true },
  { "faroes.net", true },
  { "faroes.org", true },
  { "farsil.eu", true },
  { "fart.wtf", true },
  { "farthing.xyz", true },
  { "farwat.ru", true },
  { "farzli.com", true },
  { "faschingmd.com", true },
  { "fashion-hunters.pl", true },
  { "fashion-stoff.de", true },
  { "fashion.bg", true },
  { "fashion24.de", true },
  { "fashiondays.bg", true },
  { "fashiondays.hu", true },
  { "fashiondays.ro", true },
  { "fashioneditor.gr", true },
  { "fashionhijabers.com", true },
  { "fashiontrendsetter.com", true },
  { "fashionunited.be", true },
  { "fashionunited.cl", true },
  { "fashionunited.com", true },
  { "fashionunited.com.ar", true },
  { "fashionunited.de", true },
  { "fashionunited.fi", true },
  { "fashionunited.hk", true },
  { "fashionunited.hu", true },
  { "fashionunited.ie", true },
  { "fashionunited.lu", true },
  { "fashionunited.mx", true },
  { "fashionunited.nl", true },
  { "fashionunited.no", true },
  { "fashionunited.nz", true },
  { "fashionunited.pl", true },
  { "fashionunited.se", true },
  { "fashionweekweb.com", true },
  { "fashtic.nl", true },
  { "faspirits.co.uk", true },
  { "faspirits.com", true },
  { "fassaden-selleng.de", true },
  { "fassadenverkleidung24.de", true },
  { "fassi-sport.it", true },
  { "fast-host.net", true },
  { "fast-pro.co.jp", true },
  { "fastblit.com", true },
  { "fastcash.com.br", true },
  { "fastcomcorp.com", true },
  { "fastcommerce.org", true },
  { "fastconv.com", true },
  { "fastest-hosting.co.uk", true },
  { "fastforwardsociety.nl", true },
  { "fastforwardthemes.com", true },
  { "fastinviter.com", true },
  { "fastmail.com", false },
  { "fastonline.ro", true },
  { "fastpresence.com", true },
  { "fastserv.pl", true },
  { "fastvistorias.com.br", true },
  { "fastworx.com", true },
  { "faszienrollen-info.de", false },
  { "fatalerrorcoded.eu", true },
  { "fateandirony.com", true },
  { "fatecdevday.com.br", true },
  { "fatedata.com", true },
  { "fateitalia.it", true },
  { "fatfueled.com", true },
  { "fatherhood.gov", true },
  { "fathers4equalrights.org", true },
  { "fatidique.com", true },
  { "fatimamoldes.com.br", true },
  { "fatmixx.com", true },
  { "fatowltees.com", true },
  { "fattailcall.com", true },
  { "fattorino.it", true },
  { "fatturegeko.eu", true },
  { "faucetbox.com", false },
  { "faultlines.org", true },
  { "faulty.equipment", true },
  { "favalart.com", true },
  { "favirei.com", true },
  { "favorai.com", true },
  { "fawong.com", true },
  { "faxvorlagen-druckvorlagen.de", true },
  { "fazzfinancial.com", true },
  { "fb-feed.net", true },
  { "fb.me", true },
  { "fbcdn.net", true },
  { "fbhackpass.com", true },
  { "fbi.gov", true },
  { "fbigame.com", true },
  { "fbiic.gov", true },
  { "fbijobs.gov", true },
  { "fbo.gov", true },
  { "fbrief.org", true },
  { "fbsbx.com", true },
  { "fbtholdings.com", true },
  { "fburl.com", true },
  { "fbwgynplus.com", true },
  { "fbwgynplus.com.au", true },
  { "fc.media", true },
  { "fca-tools.com", true },
  { "fcbarcelona.cz", true },
  { "fcburk.de", true },
  { "fcdn.nl", true },
  { "fcforum.net", true },
  { "fcingolstadt.de", true },
  { "fckd.net", true },
  { "fcosinus.com", true },
  { "fcprovadia.com", true },
  { "fcsic.gov", true },
  { "fdalawboston.com", true },
  { "fdaregs.com", true },
  { "fdevs.ch", true },
  { "fdfz.edu.cn", true },
  { "fdicig.gov", true },
  { "fdicoig.gov", true },
  { "fdis.net.cn", true },
  { "fdlibre.eu", true },
  { "fdms.gov", true },
  { "fdp-brig-glis.ch", true },
  { "fdpbrig.ch", true },
  { "fdresearch.ca", true },
  { "fdworlds.com", true },
  { "fe-data.nl", true },
  { "feac.us", true },
  { "feaden.me", true },
  { "feandc.com", true },
  { "fearby.com", true },
  { "feastr-dev.de", true },
  { "feastr.de", true },
  { "feastr.io", true },
  { "feat.agency", true },
  { "featherweightlabs.com", true },
  { "featuredmen.com", true },
  { "feb.gov", true },
  { "fedcenter.gov", true },
  { "federaljobs.gov", true },
  { "federalreserve.gov", true },
  { "federalreserveconsumerhelp.gov", true },
  { "federatedbank.com", true },
  { "fedjobs.gov", true },
  { "fedorahosted.org", true },
  { "fedoramagazine.org", true },
  { "fedorapeople.org", true },
  { "fedoraproject.org", true },
  { "fedpartnership.gov", true },
  { "fedramp.gov", false },
  { "fedshirevets.gov", true },
  { "fedux.com.ar", true },
  { "fedvan.com", true },
  { "feedbin.com", false },
  { "feedermarket.net", true },
  { "feedfall.com", true },
  { "feedhq.org", true },
  { "feedkovacs.hu", true },
  { "feedough.com", true },
  { "feedthefuture.gov", true },
  { "feeeei.com", true },
  { "feek.fit", true },
  { "feel-events.com", true },
  { "feel.aero", true },
  { "feelgood-workouts.de", true },
  { "feelmom.com", true },
  { "feeltennis.net", true },
  { "feen.us", true },
  { "feepod.com", true },
  { "feetpa.ws", true },
  { "feezmodo.com", false },
  { "fefelovalex.ru", true },
  { "fegame.eu", true },
  { "fegame.mobi", true },
  { "fegame.net", true },
  { "fegame.nl", true },
  { "fegc-wgec.gc.ca", true },
  { "fegli.gov", true },
  { "fehngarten.de", true },
  { "feigling.net", false },
  { "feildel.fr", true },
  { "feilen.de", true },
  { "feisbed.com", true },
  { "feisim.com", true },
  { "feisim.org", true },
  { "feistyduck.com", true },
  { "feixiang.eu.org", true },
  { "feiya.ng", true },
  { "fejes.house", true },
  { "feld.design", true },
  { "feld.saarland", true },
  { "feldbogenclub-hamburg.de", true },
  { "feldhousen.com", true },
  { "felett.es", true },
  { "feli.games", true },
  { "felicifia.org", true },
  { "felinepc.com", true },
  { "felistirnavia.sk", true },
  { "felix-hirner.de", true },
  { "felixaufreisen.de", true },
  { "felixbarta.de", true },
  { "felixcrux.com", true },
  { "felixgenicio.com", true },
  { "felixkaaman.com", true },
  { "felixkauer.de", true },
  { "felixqu.com", true },
  { "felixsanz.com", true },
  { "felixseele.de", true },
  { "felsing.net", true },
  { "felsmalerei.net", true },
  { "femaex.com.br", true },
  { "femanca.com", true },
  { "femastudios.com", true },
  { "feminina.pt", true },
  { "feministspectrum.org", true },
  { "feministwiki.org", true },
  { "femmes-women.gc.ca", true },
  { "femmes.gc.ca", true },
  { "femmesaupluriel.com", true },
  { "femtomind.com", true },
  { "feng-hhcm.com", true },
  { "feng.si", true },
  { "fengyi.tel", true },
  { "fenhl.net", true },
  { "fenichelar.com", true },
  { "fenster-bank.at", true },
  { "fenster-bank.de", true },
  { "feragon.net", true },
  { "ferdies.co.za", true },
  { "fergtm.com", true },
  { "ferien-netzwerk.de", true },
  { "ferienchalet-wallis.ch", true },
  { "ferienhaeuser-krummin.de", true },
  { "ferienhaus-polchow-ruegen.de", false },
  { "ferienhausprovence.ch", true },
  { "ferienstpeter.de", true },
  { "ferienwohnung-hafeninsel-stralsund.de", true },
  { "ferienwohnung-wiesengrund.eu", true },
  { "feriespotter.dk", true },
  { "ferm-rotterdam.nl", true },
  { "fermabel.com.br", true },
  { "fernandes.org", true },
  { "fernandob.com", true },
  { "fernandobarata.pt", true },
  { "fernandobarillas.com", true },
  { "fernandomiguel.net", true },
  { "feross.net", true },
  { "feross.org", true },
  { "ferrada.org", true },
  { "ferrariadvisor.it", true },
  { "ferret.zone", true },
  { "ferreteriaxerez.com", true },
  { "ferriswheelofficial.us", true },
  { "ferrolatino.ch", true },
  { "ferrone.ru", true },
  { "ferrousmoon.com", true },
  { "ferry.tw", true },
  { "ferticare.pt", true },
  { "fertila.de", true },
  { "festaprylar.se", true },
  { "festival-tipps.com", true },
  { "festivaljapon.com", true },
  { "fetch.co.uk", true },
  { "fetchease.com", true },
  { "fetlife.com", true },
  { "fettlaus.de", true },
  { "feudalisten.de", true },
  { "feuerhuhn.de", true },
  { "feuerloescher-arten.de", true },
  { "feuerloescher-test.de", true },
  { "feuerwehr-coesfeld.de", true },
  { "feuerwehr-gebirge.de", true },
  { "feuerwehr-heiligenberg.de", true },
  { "feuerwehr-illmensee.de", true },
  { "feuerwehr-mehring.de", true },
  { "feuerwehr-oberkotzau.de", true },
  { "feuerwehr-offenbach-bieber.de", false },
  { "feuerwehr-vechta.de", true },
  { "feuerwerksmanufaktur.de", true },
  { "feuetgloire.com", true },
  { "fewo-hafeninsel-stralsund.de", true },
  { "fewo-thueringer-wald.de", true },
  { "fexco.com", true },
  { "feybiblia.com", true },
  { "feyermedia.de", true },
  { "ff-bad-hoehenstadt.de", true },
  { "ff-obersunzing-niedersunzing.de", true },
  { "ff14-mstdn.xyz", false },
  { "ff44.net", true },
  { "ff5197.co", true },
  { "ff6729.com", true },
  { "ff6957.co", true },
  { "ff9297.co", true },
  { "ff9397.com", true },
  { "ff9721.com", true },
  { "ff9728.co", true },
  { "ffbsee.net", true },
  { "ffiec.gov", true },
  { "ffis.me", true },
  { "ffkoenigsberg.de", true },
  { "fflone.com", true },
  { "ffmradio.de", true },
  { "ffprofile.com", true },
  { "ffrev.de", true },
  { "ffsociety.nl", true },
  { "ffta.eu", true },
  { "ffw-zeven.de", true },
  { "ffzeven.de", true },
  { "fhar.be", true },
  { "fhba.com.au", true },
  { "fhcdn.xyz", true },
  { "fhconseil.fr", true },
  { "fhdhelp.de", false },
  { "fhdhilft.de", false },
  { "fhfaoig.gov", true },
  { "fi.google.com", true },
  { "fi.search.yahoo.com", false },
  { "fiam.me", true },
  { "fiareapp.red", false },
  { "fiasgo.com", true },
  { "fiasgo.dk", true },
  { "fiasgo.i.ng", true },
  { "fibo-forex.org", true },
  { "fibra.click", true },
  { "fibrasynormasdecolombia.com", false },
  { "fibretv.co.nz", true },
  { "fibretv.tv", true },
  { "fibromuebles.com", true },
  { "fichier-pdf.fr", true },
  { "fickweiler.nl", true },
  { "ficlab.com", true },
  { "ficus.io", true },
  { "fidanza.eu", true },
  { "fidelapp.com", true },
  { "fidelis-it.ch", true },
  { "fidelis-it.net", true },
  { "fidhouriet.ch", true },
  { "fiduciaire-ratio.ch", true },
  { "fieldwork-paysage.com", false },
  { "fierlafijn.net", true },
  { "fierscleaning.nl", true },
  { "fiery.me", true },
  { "fiestagenial.com", true },
  { "fifautstore.com", true },
  { "fifei.de", true },
  { "fifichachnil.paris", true },
  { "fifr.nl", true },
  { "fiftynorth.eu", true },
  { "fiftyonetielt.be", true },
  { "figan.cz", true },
  { "fight215.com", true },
  { "fight215.org", true },
  { "figinstitute.org", true },
  { "figliasons.com", true },
  { "figshare.com", true },
  { "figurasdelinguagem.com.br", true },
  { "figure.nz", true },
  { "fiilr.com", true },
  { "fiix.io", true },
  { "fijnefeestdageneneengelukkignieuwjaar.nl", true },
  { "fijnewoensdag.nl", true },
  { "fiken.no", true },
  { "fikst.com", true },
  { "fil-tec-rixen.com", true },
  { "fil.fi", true },
  { "filamentia.nl", true },
  { "filanthropystar.org", true },
  { "filaretihairlove.gr", true },
  { "file-cloud.eu", true },
  { "file-pdf.it", true },
  { "filebox.one", true },
  { "filecloud.fun", true },
  { "filecopa.com", true },
  { "filedropbox.nl", true },
  { "filehash.de", true },
  { "files.com", true },
  { "files.from-me.org", true },
  { "fileservicios.com.ar", true },
  { "filestar.io", true },
  { "filestartest.io", true },
  { "filetransfer.one", true },
  { "filezilla-project.org", true },
  { "filhodohomem.com", true },
  { "fili.com", true },
  { "filidorwiese.nl", true },
  { "filiio.com", true },
  { "filingsmadeeasy.com", true },
  { "filip-prochazka.com", false },
  { "filippo.io", true },
  { "filipsebesta.com", true },
  { "fillo.sk", true },
  { "film-colleges.com", true },
  { "film-op-tv.nl", true },
  { "film-storyboards.fr", true },
  { "film-tutorial.com", true },
  { "filmatiporno.xxx", true },
  { "filme-onlines.com", true },
  { "filmers.net", true },
  { "filmitis.com", true },
  { "filmreviewonline.com", true },
  { "filmsite-studio.com", true },
  { "filmsphoto.com", true },
  { "filoo.de", true },
  { "filstop.com", true },
  { "filterlists.com", true },
  { "filtr.me", true },
  { "fimsquad.com", true },
  { "finagosolo.com", true },
  { "final-expense-quotes.com", true },
  { "finalrewind.org", true },
  { "finalworkdriesstef.tk", true },
  { "finalx.nl", true },
  { "finance-colleges.com", true },
  { "financejobs.ch", true },
  { "financepark.ch", true },
  { "financialfreedomaus.com", true },
  { "financniexperti.sk", true },
  { "finansa.no", true },
  { "finanstilsynet.dk", true },
  { "finanziero.de", true },
  { "finch.am", true },
  { "finchi.de", true },
  { "find-job-in.com", true },
  { "find-mba.com", true },
  { "findaffordablehousing.ca", true },
  { "findapinball.com", true },
  { "findelahistoria.com", true },
  { "findingkorea.com", true },
  { "findingtheuniverse.com", true },
  { "finditez.com", true },
  { "findoon.de", true },
  { "findrejsepartner.dk", true },
  { "findstorenearme.ca", true },
  { "findstorenearme.co.uk", true },
  { "findstorenearme.us", true },
  { "findthatnude.com", true },
  { "findyourtrainer.com", true },
  { "findyourvoice.ca", true },
  { "finecraft.cc", true },
  { "finefriends.nl", true },
  { "finefriends.social", true },
  { "finefriendsapp.com", true },
  { "finelovedolls.com", true },
  { "finenet.com.tw", true },
  { "finesoon.net", true },
  { "finevegashomes.com", true },
  { "finewineonline.com", true },
  { "finflix.net", true },
  { "finform.ch", true },
  { "fini-de-jouer.ch", true },
  { "finilaviolence.gc.ca", true },
  { "finisron.in", true },
  { "finkelstein.fr", true },
  { "finkmartin.com", true },
  { "finlandcook.online", true },
  { "finlandcook.top", true },
  { "finn.io", true },
  { "finnclass.cz", true },
  { "finnwea.com", true },
  { "finpt.com", false },
  { "finsprings.org", true },
  { "fintandunleavy.com", false },
  { "fintry.ca", true },
  { "finvantage.com", true },
  { "finwe.info", true },
  { "finzy.com", true },
  { "fionafuchs.de", true },
  { "fionamcbride.com", true },
  { "fioristionline.it", true },
  { "fioristionline.net", true },
  { "fioulmarket.fr", true },
  { "fir3net.com", true },
  { "fire-schools.com", true },
  { "firebaseio.com", true },
  { "firebirdrangecookers.com", true },
  { "firebounty.com", true },
  { "fireboxfood.com", true },
  { "firebugmusic.com", true },
  { "firecore.com", true },
  { "firecry.org", true },
  { "firefart.at", true },
  { "firefense.com", true },
  { "firefighters.dating", true },
  { "firegoby.jp", true },
  { "firegore.com", true },
  { "fireleadership.gov", true },
  { "firemist.com", true },
  { "firemudfm.com", true },
  { "firenza.org", true },
  { "fireorbit.de", true },
  { "fireportal.cz", true },
  { "fireportal.sk", true },
  { "fireshellsecurity.team", true },
  { "firesofheaven.org", true },
  { "firestuff.org", true },
  { "firesuite.net", true },
  { "firetotheprisons.org", true },
  { "firevap.org", true },
  { "fireworksshowvr.com", true },
  { "firexfly.com", true },
  { "firma-cerny.cz", true },
  { "firma-offshore.com", true },
  { "firmament.space", true },
  { "firmapi.com", true },
  { "firmen-assekuranz.de", true },
  { "firmenwerbung-vermarktung.de", true },
  { "firmware.science", true },
  { "first-house.no", true },
  { "first.org", true },
  { "first4it.com", true },
  { "firstchoicebouncycastlehire.co.uk", true },
  { "firstchoicecandy.com", true },
  { "firstclasscastles.com", true },
  { "firstclassleisure.co.uk", true },
  { "firstderm.com", true },
  { "firstdry.com.br", true },
  { "firstfinca.de", true },
  { "firstinnovation.co.jp", true },
  { "firstmall.de", true },
  { "firstnetworksouth.com", true },
  { "firstq.xyz", true },
  { "firstsecurity.cl", true },
  { "fischer-kundendienst.de", true },
  { "fischers.cc", true },
  { "fischers.srv.br", true },
  { "fiscoeconti.it", true },
  { "fise.cz", true },
  { "fish-hook.ru", true },
  { "fishermailbox.net", true },
  { "fishermansbend.apartments", true },
  { "fishermansbendcorporation.com.au", true },
  { "fishermansbendtownhouses.com.au", true },
  { "fishexport.eu", true },
  { "fishgen.no", true },
  { "fishlanestudios.com", true },
  { "fishoilsafety.com", true },
  { "fishserver.net", true },
  { "fishtacos.blog", true },
  { "fisinfomanagerdr.com", true },
  { "fisiobox.eu", true },
  { "fiskalnepretor.pl", true },
  { "fiskelures.se", true },
  { "fit-4u.ch", true },
  { "fit-mit-nina.com", true },
  { "fit-mit-system.eu", true },
  { "fit365.jp", false },
  { "fitchconnect.com", true },
  { "fitinclass.com", true },
  { "fitkram.cz", true },
  { "fitness-challenge.co.uk", true },
  { "fitness.gov", true },
  { "fitnessunder50.com", true },
  { "fitseven.ru", true },
  { "fittelo.cz", true },
  { "fitzsim.org", true },
  { "fiuxy.bz", true },
  { "fiuxy.org", true },
  { "fiveslice.pizza", true },
  { "fivethirtyeight.com", true },
  { "fiveyearsahead.com", true },
  { "fixatom.com", true },
  { "fixed.supply", true },
  { "fixedtodayplumbing.com.au", true },
  { "fixel.express", true },
  { "fixforce.nl", true },
  { "fixhotsauce.com", true },
  { "fixingscrews.co.uk", true },
  { "fixlasvegas.com", true },
  { "fixmyalarmpanel.co.uk", true },
  { "fixmycomputerdude.com", true },
  { "fiziktedavi.name.tr", true },
  { "fizjoterapia.uk", true },
  { "fizyoterapi.name.tr", true },
  { "fizz.buzz", false },
  { "fizzgi.gs", true },
  { "fj.je", true },
  { "fj.search.yahoo.com", false },
  { "fj.simple.com", false },
  { "fjdekermadec.com", true },
  { "fjordboge.dk", true },
  { "fjzone.org", true },
  { "fkfev.de", true },
  { "fkosquad.moe", true },
  { "fktpm.ru", true },
  { "flaemig42.de", false },
  { "flagburningworld.com", true },
  { "flagfox.net", true },
  { "flagshop.jp", true },
  { "flagspot.net", false },
  { "flam3d.be", true },
  { "flam3d.nl", true },
  { "flam3d.org", true },
  { "flamer-scene.com", false },
  { "flamero.fi", true },
  { "flamet.eu", true },
  { "flameworked.com", true },
  { "flamingkeys.com", true },
  { "flamingowomenspavilion.com", true },
  { "flamme-von-anor.de", true },
  { "flana.com", true },
  { "flanga.io", true },
  { "flanga.org", true },
  { "flangaapis.com", true },
  { "flapoverspeed.com", true },
  { "flare.cloud", true },
  { "flashback.org", true },
  { "flashbeing.com", true },
  { "flashcomp.cz", true },
  { "flashgot.net", true },
  { "flat.io", true },
  { "flatbellyreview.com", true },
  { "flatbook.one", true },
  { "flatmail.pl", true },
  { "flatmatehub.com.au", true },
  { "flatpackmates.co.uk", true },
  { "flauschig.net", true },
  { "flavinus.fr", true },
  { "flaviu.co.uk", true },
  { "flavo.io", true },
  { "flavr.be", true },
  { "flawlesscowboy.xyz", true },
  { "flcatering.com", true },
  { "flealab.it", true },
  { "fleep.io", true },
  { "fleesty.dynv6.net", true },
  { "fleet-group.com", true },
  { "fleet-search.com", true },
  { "fleetcor.at", true },
  { "fleetcor.ch", true },
  { "fleetcor.cz", true },
  { "fleetcor.de", true },
  { "fleetcor.fr", true },
  { "fleetcor.hu", true },
  { "fleetcor.lu", true },
  { "fleetcor.nl", true },
  { "fleetcor.pl", true },
  { "fleetcor.sk", true },
  { "fleetcorcards.be", true },
  { "fleetsmith.com", true },
  { "fleetssl.com", true },
  { "fleetyards.net", true },
  { "flehm.de", true },
  { "fleisch.club", true },
  { "fleischmann.com.br", true },
  { "flers-agglo.fr", true },
  { "flerstourisme.fr", true },
  { "fletcherdigital.com", true },
  { "fletchto99.com", true },
  { "fletemaritimo.online", true },
  { "flets-ms.com", true },
  { "fleurenplume.fr", true },
  { "fleursdujour.ph", true },
  { "fleuryfleury.com", true },
  { "flexapplications.se", true },
  { "flexbuildingsystems.com", true },
  { "flexfunding.com", true },
  { "fleximaal.com", true },
  { "fleximal.com", true },
  { "fleximus.org", false },
  { "flexport.com", true },
  { "flexstart.me", true },
  { "flextrack.dk", true },
  { "fliacuello.com.ar", true },
  { "flibusta.appspot.com", true },
  { "flickcritter.com", true },
  { "flieger-funk-runde.de", true },
  { "fliesen-waldschmidt.de", true },
  { "flight.school", true },
  { "flightdeckfriend.com", true },
  { "flightmedx.com", true },
  { "flightschoolbooking.com", true },
  { "flightschoolcandidates.gov", true },
  { "flightzero.cf", true },
  { "fliino.com", true },
  { "fliino.eu", true },
  { "fliino.info", true },
  { "fliino.net", true },
  { "fliino.org", true },
  { "flinch.io", true },
  { "flip.kim", true },
  { "flipneus.net", true },
  { "fliptable.org", true },
  { "flirtee.net", true },
  { "flirtos.de", true },
  { "flmortgagebank.com", true },
  { "floatationlocations.com", true },
  { "floaternet.com", true },
  { "flockbox.club", true },
  { "flocktofedora.org", true },
  { "floersheimer-openair.de", true },
  { "floffi.media", true },
  { "floify.com", true },
  { "flokinet.is", true },
  { "floobits.com", true },
  { "floodsmart.gov", true },
  { "floogulinc.com", true },
  { "floorballpoint.cz", true },
  { "flooringnightmares.com", true },
  { "flooringsourcetx.com", true },
  { "floors4lessbay.com", true },
  { "floort.net", false },
  { "floraclick.net", true },
  { "floraexpress.it", true },
  { "florafiora.com.br", true },
  { "floravan.com", true },
  { "floravino.de", true },
  { "florence.uk.net", true },
  { "florenceapp.co.uk", true },
  { "florentynadawn.co.uk", true },
  { "floresvilleedc.org", true },
  { "florian-bachelet.fr", true },
  { "florian-thie.de", true },
  { "floriankarmen.com", true },
  { "floriankeller.de", true },
  { "florianmitrea.uk", true },
  { "florianschmitt.ca", true },
  { "floriantanner.ch", true },
  { "floridafabrication.net", true },
  { "floridafieros.org", true },
  { "floridagulfbeachrealty.com", true },
  { "floridahomesinvest.com", true },
  { "floridasexhealth.com", true },
  { "floridaweightlossdoctors.com", true },
  { "florinlungu.it", true },
  { "florismoo.nl", true },
  { "florismouwen.com", false },
  { "floristmou.com", true },
  { "florisvdk.net", true },
  { "floriswesterman.nl", true },
  { "florlola.com", true },
  { "floskelwolke.de", true },
  { "flossexanten.de", true },
  { "flourishtogether.com", true },
  { "flow.su", true },
  { "flowcom.de", true },
  { "flowersbylegacy.com", true },
  { "flowersquito.com", true },
  { "flowinvoice.com", true },
  { "flowreader.com", true },
  { "flra.gov", true },
  { "fluffycloud.de", true },
  { "fluggesellschaft.de", true },
  { "fluhrers.de", true },
  { "fluidmeterusa.com", true },
  { "fluids.ac.uk", true },
  { "fluitbeurt.nl", true },
  { "flumble.nl", true },
  { "flunschi.goip.de", true },
  { "fluoxetine.net", true },
  { "flushlife.com", true },
  { "fluteandpianoteaching.co.uk", true },
  { "flux.healthcare", true },
  { "fluxfingers.net", true },
  { "fluxforge.com", true },
  { "fluxi.fi", true },
  { "fluxoid.com", true },
  { "flw365365.com", true },
  { "fly-en-drive.nl", true },
  { "fly.moe", true },
  { "flyavantar.com", true },
  { "flyboyfpv.com", true },
  { "flydrivesicilie.nl", true },
  { "flyer.tools", true },
  { "flygon.pink", true },
  { "flyinghigh.co.jp", true },
  { "flyinglocksmiths.com", true },
  { "flyingpackets.net", true },
  { "flyingrub.me", true },
  { "flymns.fr", true },
  { "flynn.io", true },
  { "flyp.me", true },
  { "flypenge.dk", true },
  { "flyserver.co.il", false },
  { "flyswoop.com", true },
  { "flyt.online", true },
  { "flytoadventures.com", true },
  { "fm-cdn.de", true },
  { "fm.ie", true },
  { "fmarchal.fr", true },
  { "fmbilder.se", true },
  { "fmc.gov", true },
  { "fmdance.cl", true },
  { "fminsight.net", true },
  { "fmodoux.biz", true },
  { "fmussatmd.com", true },
  { "fnanen.net", true },
  { "fnbnokomis.com", true },
  { "fnh-expert.net", true },
  { "fnkr.net", true },
  { "fnof.ch", true },
  { "fnordserver.eu", true },
  { "fnpro.eu", true },
  { "fnzc.co.nz", true },
  { "foairbus.fr", true },
  { "foairbussas.fr", true },
  { "focanamoda.com.br", true },
  { "focusmark.jp", false },
  { "focusministries1.org", true },
  { "focuspointtechnologies.com", true },
  { "foej-aktiv.de", true },
  { "foej.net", true },
  { "foerster.gmbh", true },
  { "fogpublishingph.com", true },
  { "fogway.net", true },
  { "foia.gov", true },
  { "foiaonline.gov", true },
  { "foixet.com", true },
  { "fojing.com", true },
  { "fojt.cz", true },
  { "fojtova.cz", true },
  { "fojtovi.cz", true },
  { "fokan.be", true },
  { "fokan.ch", true },
  { "fokep.no", true },
  { "fokkusu.fi", true },
  { "folio.no", true },
  { "foliumbiosciences.com", true },
  { "foliumfinance.com", true },
  { "foljeton.dk", true },
  { "folk.as", true },
  { "follandviolins.com", true },
  { "followback.net", true },
  { "follower98.ir", true },
  { "followerrocket.com", true },
  { "followings-live.com", true },
  { "followmystaff.com", true },
  { "followthatpage.com", true },
  { "followthedog.co.uk", true },
  { "foluomeng.net", true },
  { "folv.es", true },
  { "folwark.krakow.pl", true },
  { "fomopop.com", true },
  { "fondationwiggli.ch", true },
  { "fondy.eu", true },
  { "fondy.ua", true },
  { "fonga.ch", true },
  { "fono.jp", true },
  { "fonolo.com", true },
  { "fonseguin.ca", true },
  { "font-converter.net", true },
  { "fonte-trading.com", true },
  { "fontedoprazer.com", true },
  { "fontein.de", true },
  { "fontlibrary.org", true },
  { "fonts4free.net", true },
  { "fonzone.it", true },
  { "foo.fo", true },
  { "foo.hamburg", true },
  { "foodattitude.ch", true },
  { "foodblogger.club", true },
  { "foodboy.com", true },
  { "foodcare.ml", true },
  { "foodlist.net", true },
  { "foodloader.net", true },
  { "foodsafety.gov", true },
  { "foodsafetyjobs.gov", true },
  { "foodsouvenirs.it", true },
  { "foodtable.at", true },
  { "foodwise.marketing", true },
  { "foolip.org", true },
  { "foolwealth.com", true },
  { "foorack.com", true },
  { "fooster.io", true },
  { "foot.fr", true },
  { "footagecrate.com", true },
  { "footballforum.de", true },
  { "for.care", true },
  { "foray-jero.me", true },
  { "forbidden-mods.de", true },
  { "forbusiness.ca", true },
  { "forcelink.eu", true },
  { "forcelinkamerica.com", true },
  { "forcelinkamerica.nl", true },
  { "forcewave.com", true },
  { "ford-shop.by", true },
  { "ford.com.au", true },
  { "ford.com.br", true },
  { "ford.com.cn", true },
  { "ford.mx", true },
  { "fordlibrarymuseum.gov", true },
  { "fordsync.com", true },
  { "foreachcode.com", true },
  { "forecastcity.com", true },
  { "foreclosureattorneyhouston.com", true },
  { "forefrontcloud.com", true },
  { "foregroundweb.com", true },
  { "foreign-language-colleges.com", true },
  { "forellenpark.com", true },
  { "forento.be", true },
  { "foresthillhomes.ca", true },
  { "forestraven.net", true },
  { "foreverclean.com", true },
  { "foreverssl.com", true },
  { "foreversummertime.com", true },
  { "forewordreviews.com", true },
  { "forex.ee", true },
  { "forexchef.de", true },
  { "forexee.com", true },
  { "forextickler.com", true },
  { "forextimes.ru", true },
  { "forfunssake.co.uk", true },
  { "forge-goerger.eu", true },
  { "forgotten-legends.org", true },
  { "form3w.nl", true },
  { "formacionyestudios.com", true },
  { "forman.store", true },
  { "formapi.io", true },
  { "format-paysage.ch", true },
  { "formation-assureur.com", true },
  { "formation-mac.ch", true },
  { "formationseeker.com", true },
  { "formersessalaries.com", true },
  { "formini.dz", true },
  { "formio.nl", true },
  { "formsbyair.com", true },
  { "formsmarts.com", true },
  { "formula-ot.ru", true },
  { "formulacionquimica.com", true },
  { "formulastudent.de", true },
  { "fornoreason.net.au", true },
  { "fornwall.net", true },
  { "forodeespanol.com", true },
  { "forodieta.com", true },
  { "forokd.com", true },
  { "forologikidilosi.com.gr", true },
  { "forourselves.com", true },
  { "forrestheller.com", true },
  { "forro.berlin", true },
  { "forro.info", true },
  { "forsec.nl", true },
  { "forself.me", true },
  { "forstbetrieb-hennecke.de", true },
  { "forstprodukte.de", true },
  { "forteggz.nl", true },
  { "forthetoys.com", true },
  { "fortnine.ca", true },
  { "fortran.io", true },
  { "fortress.no", true },
  { "fortress.sk", true },
  { "fortuna-apotheke-lahnstein.de", true },
  { "fortuna.co.ua", true },
  { "forty-two.nl", true },
  { "forty8creates.com", true },
  { "fortytwo.cloud", true },
  { "forum-bonn.de", true },
  { "forum-heg.ch", true },
  { "forum-kinozal-tv.appspot.com", true },
  { "forum-kinozal.appspot.com", true },
  { "forum.quantifiedself.com", false },
  { "forumotomobil.com", true },
  { "forumvoordemocratie.nl", true },
  { "forvisualdesign.com", true },
  { "forward-fly-fishing.ch", true },
  { "foryourhealthybody.com", true },
  { "fosaudit.com", true },
  { "foscamcanada.com", true },
  { "fosdem.org", true },
  { "fosgreece.com", true },
  { "fossforward.com", true },
  { "fossilfreeyale.org", true },
  { "fosterpark.ca", true },
  { "fotella.com", true },
  { "fotikpro.ru", true },
  { "foto-janvanaefst.nl", true },
  { "foto-leistenschneider.de", true },
  { "foto-leitner.com", true },
  { "foto-leitner.de", true },
  { "foto-robitsch.at", true },
  { "foto-roma.ru", true },
  { "foto.by", true },
  { "fotoallerlei.com", true },
  { "fotoboxvysocina.cz", true },
  { "fotocopiatrici.roma.it", true },
  { "fotofaerie.net", true },
  { "fotoflits.net", true },
  { "fotografechristha.nl", true },
  { "fotografiadellalucerossa.com", true },
  { "fotografiamakro.pl", true },
  { "fotohome.dk", true },
  { "fotokomorkomania.pl", true },
  { "fotoleitner.com", true },
  { "fotoleitner.de", true },
  { "fotonjan.com", true },
  { "fotostravestisbr.com", true },
  { "fotostudio-leitner.com", true },
  { "fotostudio-leitner.de", true },
  { "fotostudio-schweiz.ch", true },
  { "fotowettbewerb.co", true },
  { "fotowolfy.com", true },
  { "fougner.co", true },
  { "found.website", true },
  { "foundationrepairnebraska.com", true },
  { "foundationspecialistmi.com", true },
  { "foundationswellness.net", true },
  { "foundchurch.co.uk", true },
  { "founderio.net", true },
  { "foundsounds.me", true },
  { "fourashesgolfcentre.co.uk", true },
  { "fourashesgolfcentre.com", true },
  { "fourashesgolfcentre.uk", true },
  { "fournarisopenday.com", true },
  { "fowlervwparts.com", true },
  { "fowlsmurf.net", true },
  { "fox.my", false },
  { "foxesare.sexy", true },
  { "foxo.blue", true },
  { "foxontheinter.net", true },
  { "foxphotography.ch", true },
  { "foxquill.com", true },
  { "foxroy.com", true },
  { "foxstreetcomms.co.za", false },
  { "foxvisor.com", true },
  { "fozzie.space", true },
  { "fpaci.org", true },
  { "fpasca.com", true },
  { "fpc.gov", false },
  { "fpersona.com", true },
  { "fpgradosuperior.com", true },
  { "fpsclasico.de", true },
  { "fpt-technojapan.com", true },
  { "fpy.cz", true },
  { "fr.search.yahoo.com", false },
  { "frack.nl", false },
  { "fracreazioni.it", true },
  { "fraesentest.de", true },
  { "fragmentspuren.de", true },
  { "fragstore.net", true },
  { "fraho.eu", true },
  { "framapiaf.org", false },
  { "framboise314.fr", true },
  { "framedpaws.com", true },
  { "framezdakkapellen.nl", true },
  { "fran.cr", true },
  { "francescopalazzo.com", true },
  { "francescopandolfibalbi.it", true },
  { "francescoyatesfansite.com", true },
  { "francetraceur.fr", true },
  { "franchini.email", true },
  { "franchini.engineer", true },
  { "francinebelanger.network", true },
  { "francis.ph", true },
  { "francis.tokyo", true },
  { "francisli.net", false },
  { "franckgirard.net", true },
  { "franckyz.com", true },
  { "francois-occasions.be", true },
  { "francoisbelangerboisclair.com", true },
  { "francoiscarrier.com", true },
  { "francoise-paviot.com", true },
  { "francoisharvey.ca", true },
  { "francoislepage.com", true },
  { "francoz.me", true },
  { "frandor.co.uk", true },
  { "frankbellamy.co.uk", true },
  { "frankellawfirm.com", true },
  { "franken-lehrmittel.de", true },
  { "frankenhost.de", true },
  { "frankenlehrmittel.de", true },
  { "frankierfachmann.de", true },
  { "frankierprofi.de", true },
  { "frankierstar.de", true },
  { "frankinteriordesign.co.uk", true },
  { "frankl.in", true },
  { "frankmorrow.com", true },
  { "frankopol-sklep.pl", true },
  { "frankpalomeque.com", true },
  { "franksiler.com", true },
  { "frankslaughterinsurance.com", true },
  { "frankyan.com", true },
  { "frantic1048.com", true },
  { "frantorregrosa.me", true },
  { "franz-vatter.de", true },
  { "franz.beer", true },
  { "franziska-pascal.de", true },
  { "franziskaherbert.de", true },
  { "franzknoll.de", true },
  { "frappant.cc", true },
  { "frappant.net", true },
  { "fraselab.ru", true },
  { "frasesconemocion.com", true },
  { "frasesdodia.com", true },
  { "frasesparaface.com.br", true },
  { "frasesytarjetas.com", true },
  { "frasys.net", true },
  { "frattaroli.org", true },
  { "frau-pusteblu.me", true },
  { "frau-sucht-bauer.de", true },
  { "fraudmarc.com", true },
  { "frauenarzt-niendorf.de", true },
  { "frauenarzt-zinke.de", true },
  { "frauenlob.rocks", true },
  { "fraye.net", true },
  { "frazell.net", true },
  { "frbracch.it", true },
  { "frc.gov", true },
  { "frccsgo.tk", true },
  { "frdl.ch", true },
  { "freaksites.dk", true },
  { "freaksports.com.au", true },
  { "frebib.co.uk", true },
  { "frebib.com", true },
  { "frebib.net", true },
  { "freddieonfire.tk", false },
  { "freddysfuncastles.co.uk", true },
  { "fredericcote.com", true },
  { "frederik-braun.com", false },
  { "frederikshavn.net", true },
  { "frederikvig.com", true },
  { "fredloya.com", true },
  { "fredriksslaktforskning.se", true },
  { "freds4buildings.com", true },
  { "fredsmith.net", true },
  { "fredsmith.org", true },
  { "fredsmith.us", true },
  { "fredvoyage.fr", true },
  { "free-ss.site", true },
  { "free.ac.cn", true },
  { "free.com.tw", true },
  { "freeaf.gq", true },
  { "freeasyshop.com", true },
  { "freebarrettbrown.org", true },
  { "freebcard.com", true },
  { "freebetoffers.co.uk", true },
  { "freebookmakersbetsandbonuses.com.au", true },
  { "freeboson.org", true },
  { "freebsdbrasil.com.br", true },
  { "freebus.org", true },
  { "freecam2cam.site", true },
  { "freecloud.at", true },
  { "freecookies.nl", true },
  { "freedev.cz", true },
  { "freedgb.com", true },
  { "freedom.nl", true },
  { "freedom.press", true },
  { "freedom35.org", true },
  { "freedomfinance.se", true },
  { "freedomflotilla.org", true },
  { "freedomfrontier.tk", true },
  { "freedomkiaparts.com", true },
  { "freedomonline.bg", true },
  { "freedomrahoitus.fi", true },
  { "freeenglishhelp.com", true },
  { "freeexampapers.com", true },
  { "freeform4u.de", true },
  { "freegame-mugen.jp", true },
  { "freegutters.com", true },
  { "freeiconspng.com", true },
  { "freeinoutboard.com", true },
  { "freejasongoudlock.org", true },
  { "freejeremy.net", true },
  { "freekdevries.nl", true },
  { "freeks.com.br", true },
  { "freela.ch", true },
  { "freelance.boutique", true },
  { "freelance.nl", true },
  { "freelanceessaywriters.com", true },
  { "freelancehunt.com", true },
  { "freelancejobs.org.uk", true },
  { "freelanceunited.co.uk", true },
  { "freelauri.com", true },
  { "freelifer.jp", true },
  { "freelo.cz", true },
  { "freemania.eu", true },
  { "freemania.nl", true },
  { "freemanlogistics.com", true },
  { "freemans.com", true },
  { "freeministryresources.org", true },
  { "freemomhugs.org", true },
  { "freemyipod.org", true },
  { "freend.me", false },
  { "freenetproject.org", true },
  { "freeonplate.com", true },
  { "freepnglogos.com", true },
  { "freepublicprofile.com", true },
  { "freertomorrow.com", true },
  { "freeshell.de", true },
  { "freeshkre.li", true },
  { "freesitemapgenerator.com", true },
  { "freesms-online.de", true },
  { "freesnowden.is", true },
  { "freesoft-board.to", true },
  { "freesoftlab.com", true },
  { "freesolitaire.win", true },
  { "freesourcestl.org", true },
  { "freespot.mobi", true },
  { "freessl.tech", true },
  { "freesslcertificate.me", true },
  { "freetaxusa.com", true },
  { "freethetv.ie", true },
  { "freetsa.org", true },
  { "freeweibo.com", true },
  { "freewoodfactory.com", true },
  { "freexmovie.com", true },
  { "freeyourmusic.com", true },
  { "freezion.com", true },
  { "freie-software.net", true },
  { "freiewaehler-verden.de", true },
  { "freifahrt.de", true },
  { "freifamily.ch", true },
  { "freifunk-burgaltendorf.de", true },
  { "freifunk-essen.de", true },
  { "freifunk-in-solingen.de", true },
  { "freifunk-lindlar.net", true },
  { "freifunk-luenen.de", true },
  { "freifunk-nrw.de", true },
  { "freifunk-remscheid.de", true },
  { "freimeldungen.de", true },
  { "freims.cc", true },
  { "freitasul.com.br", true },
  { "freitasul.io", true },
  { "freiwurst.net", true },
  { "freizeitbad-riff.de", true },
  { "freizeitplaza.de", true },
  { "frejasdal.dk", true },
  { "frenchcreekcog.org", true },
  { "frenchguy.ch", true },
  { "frenchmusic.fr", true },
  { "frequencebanane.ch", true },
  { "frequentflyerapp.com", true },
  { "fresh-hotel.org", true },
  { "fresh-networks.net", true },
  { "fresh.co.il", true },
  { "freshdesigns.de", true },
  { "freshdns.nl", true },
  { "freshempire.gov", true },
  { "freshlymind.com", true },
  { "freshmaza.com", true },
  { "freshmaza.net", true },
  { "fretscha.com", true },
  { "frettirnar.is", true },
  { "fretworksec.com", true },
  { "freundinnen-ausflug.de", true },
  { "freundinnen-kurzurlaub.de", true },
  { "freundinnen-urlaub.de", true },
  { "frforms.com", true },
  { "friarsonbase.com", true },
  { "frickelboxx.de", true },
  { "frickelmeister.de", true },
  { "fridolinka.cz", true },
  { "friederes.lu", true },
  { "friederloch.de", true },
  { "friedrich-foto-art.de", true },
  { "friedsamphotography.com", true },
  { "friedstechnology.com", true },
  { "friedstechnology.nl", true },
  { "friedstechnology.online", true },
  { "friedzombie.com", true },
  { "friedzombie.nl", true },
  { "friedzombie.online", true },
  { "friendlysiberia.com", true },
  { "friendowment.us", true },
  { "friends-of-naz.com", true },
  { "friends-socialgroup.org", true },
  { "friends.tn", true },
  { "friends24.cz", true },
  { "friendship-quotes.co.uk", true },
  { "friendshipismagicsquad.com", true },
  { "friendsofgfwpc.org", true },
  { "frieslandrail.nl", true },
  { "friet.org", true },
  { "frietbesteld.nl", true },
  { "frietzombie.nl", true },
  { "friezy.ru", true },
  { "frigi.ch", true },
  { "frigolit.net", true },
  { "friller.com.au", true },
  { "frillip.com", true },
  { "fringeintravel.com", true },
  { "frinkiac.com", true },
  { "frino.de", true },
  { "friplay.host", true },
  { "frippz.se", true },
  { "friss.com", true },
  { "fritz-koehne-schule.de", true },
  { "fritzrepair.com", true },
  { "frizo.com", true },
  { "frizzless.com", true },
  { "frnco.uk", true },
  { "frob.nl", true },
  { "froehliche-hessen.de", true },
  { "frogatto.com", true },
  { "frogeye.fr", true },
  { "froggitt.com", true },
  { "froh.co.jp", true },
  { "frolova.org", true },
  { "fromager.net", true },
  { "fromanolderwoman.com", true },
  { "fromscratch.rocks", true },
  { "fronteers.nl", false },
  { "frontier-ad.co.jp", true },
  { "frontier.bet", true },
  { "frontiers.nl", true },
  { "frontletter.io", true },
  { "frontline.cloud", true },
  { "frontlinemessenger.com", true },
  { "fropky.com", true },
  { "frostprotection.co.uk", true },
  { "frostwarning.com", true },
  { "frostysummers.com", true },
  { "frothy.coffee", true },
  { "froufe.com", true },
  { "frownonline.co.uk", true },
  { "frozen-geek.net", true },
  { "frozen-solid.net", true },
  { "frozenjam.com", true },
  { "frpg.gov", true },
  { "frprn.com", true },
  { "frprn.es", true },
  { "frprn.xxx", true },
  { "frsnpwr.net", true },
  { "frtib.gov", true },
  { "frtn.com", true },
  { "frtr.gov", true },
  { "frtrains.com", true },
  { "fruchthof24.de", true },
  { "fruchtikus.net", true },
  { "fruend-hausgeraeteshop.de", true },
  { "frugalfamilyhome.com", true },
  { "frugalmechanic.com", true },
  { "frugro.be", true },
  { "fruition.co.jp", true },
  { "fruitscale.com", true },
  { "fruityfitness.com", true },
  { "fruityten.co.uk", true },
  { "frusky.de", true },
  { "fruttini.de", true },
  { "frydrychit.cz", true },
  { "fs-g.org", true },
  { "fs-maistadt.de", true },
  { "fs257.com", true },
  { "fsapubs.gov", false },
  { "fsbn.eu", true },
  { "fsbnh.bank", true },
  { "fsbpaintrock.com", true },
  { "fsbturton.com", true },
  { "fsch2009.com", true },
  { "fsck.cz", true },
  { "fsck.jp", false },
  { "fsckd.com", true },
  { "fscott.de", true },
  { "fsfxpackages.com", true },
  { "fsg.one", true },
  { "fsgeek.ca", true },
  { "fsk.fo", true },
  { "fskounoike.com", true },
  { "fsky.info", true },
  { "fsm2016.org", true },
  { "fsps.ch", true },
  { "fsty.uk", true },
  { "fsvoboda.cz", true },
  { "fsvt.ch", true },
  { "ft.com", false },
  { "ftang.de", true },
  { "ftc.gov", false },
  { "ftccomplaintassistant.gov", true },
  { "ftcefile.gov", true },
  { "ftdev.in", true },
  { "ftexchange.com", true },
  { "fthat.link", true },
  { "ftng.se", true },
  { "ftptest.net", true },
  { "ftrsecure.com", true },
  { "ftv.re", true },
  { "fuantaishenhaimuli.net", true },
  { "fuciam.com.co", true },
  { "fuckcie.com", true },
  { "fucklife.ch", true },
  { "fucknazis.cf", true },
  { "fucknazis.tk", true },
  { "fuckonthefirst.date", false },
  { "fuckyoupaypal.me", true },
  { "fuckz.net", true },
  { "fuechschen.org", true },
  { "fuego.tech", true },
  { "fuelingyourdreams.com", true },
  { "fuerstenfelder-immobilien.de", true },
  { "fuglede.dk", true },
  { "fuite.ch", true },
  { "fuitedeau.ch", true },
  { "fuites.ch", true },
  { "fujianshipbuilding.com", true },
  { "fujiwaraqol.com", true },
  { "fujiwarashinzo.com", true },
  { "fukakukeiba.com", true },
  { "fukata.org", true },
  { "fukikaeru.com", true },
  { "fukuiedu.com", true },
  { "fukushima-fun.com", true },
  { "fukushimacoffee.com", true },
  { "fulfilmentcrowd.com", true },
  { "fulgenzis.com", true },
  { "fulijiejie.com", true },
  { "fuliwang.info", true },
  { "fuliwang.us", true },
  { "full-race.com", true },
  { "full-stack.ninja", true },
  { "fullautomotivo.com.br", true },
  { "fullbundle.com", true },
  { "fullereno.com", true },
  { "fullerlife.org.uk", true },
  { "fullfilez.com", true },
  { "fullhub.ru", true },
  { "fullmatch.net", true },
  { "fullstack.love", true },
  { "fullstacknotes.com", false },
  { "fumblers.ca", true },
  { "fumerolles.ch", true },
  { "fumo.se", false },
  { "fun-bounce.co.uk", true },
  { "fun-fan.biz", true },
  { "fun-tasia.co.uk", true },
  { "fun4kidzbouncycastles.co.uk", true },
  { "fun4ubouncycastles.co.uk", true },
  { "fun888city.com", true },
  { "fun888city.net", true },
  { "fun88city.com", true },
  { "funadvisor.ca", true },
  { "funadvisorfrance.com", true },
  { "funandbounce.com", true },
  { "funatic.nl", true },
  { "funbouncelincs.co.uk", true },
  { "funbuynet.com.br", true },
  { "funchestra.at", false },
  { "functional.cc", true },
  { "functions-online.com", true },
  { "fundacionfranciscofiasco.org", true },
  { "fundavi.jp", true },
  { "fundayltd.com", true },
  { "fundays.nl", true },
  { "fundchan.com", true },
  { "fundeego.com", true },
  { "fundingempire.com", true },
  { "fundmylegalclaim.co.uk", true },
  { "fundort.ch", true },
  { "funds.ddns.net", true },
  { "funfactorleeds.co.uk", true },
  { "funfair.io", true },
  { "funfoodco.co.uk", true },
  { "funfunmstdn.tokyo", true },
  { "funhouse-inflatables.co.uk", true },
  { "funinbeds.org.uk", true },
  { "funkazoid-radio.com", true },
  { "funken-networks.de", true },
  { "funkfernbedienung-industrie.de", true },
  { "funknotaus.de", true },
  { "funktionel.co", true },
  { "funktionsverket.se", true },
  { "funkygamer1.de", true },
  { "funniestclip.com", true },
  { "funnybikini.com", true },
  { "funoverip.net", true },
  { "funsochi.ru", true },
  { "funspins.com", true },
  { "funtasticinflatablesdurham.co.uk", true },
  { "funtime-inflatables.co.uk", true },
  { "funtime.com.ua", true },
  { "funtime.kiev.ua", true },
  { "funtimeentertainment.co.uk", true },
  { "funtimesbouncycastles.co.uk", true },
  { "fur.red", true },
  { "furcdn.net", true },
  { "furgo.love", true },
  { "furigana.info", true },
  { "furikake.xyz", true },
  { "furkancaliskan.com", true },
  { "furkot.com", true },
  { "furkot.de", true },
  { "furkot.es", true },
  { "furkot.fr", true },
  { "furkot.it", true },
  { "furkot.pl", true },
  { "furlan.co", true },
  { "furlog.it", false },
  { "furnfurs.com", true },
  { "furnishedproperty.com.au", true },
  { "furniturezoneboone.com", true },
  { "furries-united.de", true },
  { "furry.bot", true },
  { "furry.cat", true },
  { "furry.cool", true },
  { "furry.dk", true },
  { "furrytech.network", true },
  { "fursuitbutts.com", true },
  { "fusa-miyamoto.jp", true },
  { "fuselight.nl", true },
  { "fuseos.net", true },
  { "fusiongaming.de", true },
  { "fussball-xxl.de", true },
  { "fussell.io", true },
  { "fuszara.pl", true },
  { "futa.moe", false },
  { "futaba-works.com", true },
  { "futbolvivo.tv", true },
  { "futbomb.com", true },
  { "futcre.com", true },
  { "futos.de", true },
  { "futrou.com", true },
  { "future-moves.com", true },
  { "futureaudiographics.com", true },
  { "futurefund.com", true },
  { "futuregrowthva.com", true },
  { "futurenda.com", true },
  { "futureoceans.org", true },
  { "futuressm.com", true },
  { "futuretimes.io", true },
  { "futurezone.at", true },
  { "fuvelis.fr", true },
  { "fuwafuwa.moe", true },
  { "fuyu.moe", true },
  { "fuzenet.net", true },
  { "fuzoku.jp", true },
  { "fuzzing-project.org", true },
  { "fveevaete.com", true },
  { "fwdx.net", true },
  { "fwest.ovh", true },
  { "fwest98.nl", true },
  { "fwest98.ovh", true },
  { "fwz.me", true },
  { "fx-rk.com", true },
  { "fx5.de", true },
  { "fxislamic.com", true },
  { "fxmarketing.com.au", true },
  { "fxmarketing.net.au", true },
  { "fxopen.co.uk", true },
  { "fxopen.com", true },
  { "fxopen.com.au", true },
  { "fxopen.com.br", true },
  { "fxopen.com.mx", true },
  { "fxopen.my", true },
  { "fxopen.ru", true },
  { "fxp.co.il", true },
  { "fxseo.com.au", true },
  { "fxtalk.cn", true },
  { "fxthai.com", true },
  { "fxtrade-lab.com", true },
  { "fxweb.co", true },
  { "fxwebsites.com.au", true },
  { "fxwebsites.net.au", true },
  { "fxwebstudio.net.au", true },
  { "fydjbsd.cn", true },
  { "fyfywka.com", true },
  { "fyksen.me", true },
  { "fyn.nl", true },
  { "fyner.lt", true },
  { "fyol.xyz", false },
  { "fyreek.me", true },
  { "fyretrine.com", true },
  { "fysesbjerg.dk", true },
  { "fysiomassageoosterhout.nl", true },
  { "fysiotherapieapeldoornzuid.nl", true },
  { "fysiotherapieholtenbroek.nl", true },
  { "fysiovdberg.nl", true },
  { "fysuite.com", true },
  { "fytcart.com", true },
  { "fytorio-pasxalis.gr", true },
  { "fzbrweb.cz", true },
  { "fzdm.com", true },
  { "fzhyzamt.com", true },
  { "fztopsec.com", true },
  { "fzx750.ru", true },
  { "g-ds.de", true },
  { "g-fruit.gr", true },
  { "g-m-w.eu", true },
  { "g-p-design.com", true },
  { "g-rom.net", true },
  { "g.co", true },
  { "g01.in.ua", true },
  { "g0881.com", true },
  { "g0man.com", true },
  { "g1.ie", true },
  { "g10e.ch", true },
  { "g116688.com", true },
  { "g2links.com", true },
  { "g2pla.net", true },
  { "g2ship.com", true },
  { "g2soft.net", true },
  { "g3circuit.com", true },
  { "g3d.ro", true },
  { "g3dev.ch", true },
  { "g3rv4.com", true },
  { "g4w.co", true },
  { "g5197.co", true },
  { "g6729.co", true },
  { "g6957.co", true },
  { "g8energysolutions.co.uk", true },
  { "g9297.co", true },
  { "g9397.com", true },
  { "g9721.com", true },
  { "g9728.co", true },
  { "ga-2.it", true },
  { "ga-part.ru", true },
  { "gaaz.fr", true },
  { "gabe565.com", true },
  { "gabeb1920.com", true },
  { "gabecook.com", true },
  { "gabinetejuridicotecnologicojuandemeseguer.es", true },
  { "gabinetpsychoterapii.krakow.pl", true },
  { "gabiocs.com", true },
  { "gabriel.to", true },
  { "gabriele-kluge.de", true },
  { "gabriele.tips", true },
  { "gabrielgn.com.br", true },
  { "gabrielsteens.nl", true },
  { "gabz.pw", true },
  { "gachimuchi.ru", true },
  { "gachiyase.com", true },
  { "gachter.name", true },
  { "gadabit.pl", true },
  { "gaddini.it", true },
  { "gadget-tips.com", true },
  { "gadgetadvisor.com", true },
  { "gadgethacks.com", true },
  { "gae123.com", true },
  { "gaengler.com", true },
  { "gaest.com", true },
  { "gaestehaus-monika.com", true },
  { "gaetanosonline.com", true },
  { "gaff-rig.co.uk", true },
  { "gaflooring.com", true },
  { "gafunds.com", true },
  { "gagliarducci.it", true },
  { "gagne.tk", true },
  { "gagnerplusdargent.info", true },
  { "gagniard.org", true },
  { "gagor.pl", true },
  { "gagygnole.ch", true },
  { "gaiavanderzeyp.com", true },
  { "gailbartist.com", true },
  { "gailfellowsphotography.com", true },
  { "gaines-sodiamex.fr", true },
  { "gaio-automobiles.fr", true },
  { "gaireg.de", true },
  { "gaiserik.com", false },
  { "gaitandmobility.com", true },
  { "gaitrehabilitation.com", true },
  { "gaitresearch.com", true },
  { "gajas18.com", true },
  { "gajowniczek.eu", true },
  { "gakdigital.com", true },
  { "gakki.photos", true },
  { "gaku-architect.com", true },
  { "gala.kiev.ua", false },
  { "galabau-maurmann.de", true },
  { "galacg.me", true },
  { "galactic-crew.org", true },
  { "galak.ch", true },
  { "galaltosalento.it", true },
  { "galanight.cz", true },
  { "galax.us", true },
  { "galaxieblog.com.my", true },
  { "galaxus.at", true },
  { "galaxus.ch", true },
  { "galaxus.com", true },
  { "galaxus.de", true },
  { "galaxus.eu", true },
  { "galaxus.fr", true },
  { "galaxy.edu.pe", true },
  { "galaxymimi.com", true },
  { "galaxymusicpromo.com", true },
  { "galeria42.com", true },
  { "galeriajardim.com.br", true },
  { "galeriarr.pl", true },
  { "galeries.photo", true },
  { "galighticus.com", true },
  { "galileanhome.org", true },
  { "galilel.cloud", true },
  { "galinas-blog.de", true },
  { "galinos.gr", true },
  { "galle.cz", true },
  { "gallerify.eu", true },
  { "galletasgabi.com.mx", false },
  { "galleyfoods.com", true },
  { "gallicrooster.com", true },
  { "gallifreyapp.co.uk", true },
  { "gallifreypermaculture.com.au", true },
  { "gallmeyer-consulting.com", true },
  { "gallun-shop.com", true },
  { "galoserver.org", true },
  { "galpaoap.com.br", true },
  { "galvingao.com", true },
  { "gamberorosso.menu", true },
  { "gambetti.fr", true },
  { "gambit.pro", true },
  { "gambitnash.co.uk", true },
  { "gambitnash.com", true },
  { "gambitprint.com", true },
  { "gambler.ru", true },
  { "gamblerhealing.com", true },
  { "gamcore.com", true },
  { "game-club.me", true },
  { "game-files.net", false },
  { "game-topic.ru", true },
  { "game4less.com", true },
  { "game7.de", true },
  { "game88city.com", true },
  { "game88city.net", true },
  { "gameanalytics.com", true },
  { "gameblabla.nl", true },
  { "gamebrott.com", true },
  { "gamecard-shop.nl", true },
  { "gamechefpummarola.eu", true },
  { "gamechurch.de", true },
  { "gameclue.jp", true },
  { "gamecollector.be", true },
  { "gameconservation.org.uk", true },
  { "gamedevelopers.pl", true },
  { "gamegix.com", true },
  { "gameharbor.duckdns.org", true },
  { "gameindustry.de", true },
  { "gameisbest.jp", true },
  { "gamejobs.co", true },
  { "gamekaitori.jp", true },
  { "gamekeepers.cz", true },
  { "gamemodding.com", true },
  { "gamenauta.com.br", true },
  { "gamenerd.net", true },
  { "gameofbooks.de", true },
  { "gamepad.com.br", true },
  { "gameplaysforkids.com", true },
  { "gamepreorders.com", true },
  { "gamequest.info", true },
  { "gamer-portal.com", true },
  { "gamercredo.com", true },
  { "gamereader.de", true },
  { "gamerepublic.hu", true },
  { "gameres.com", true },
  { "gamerezo.com", true },
  { "gamerwares.com", true },
  { "gamerzdot.com", true },
  { "games4theworld.org", true },
  { "gamesaviour.com", true },
  { "gamesdepartment.co.uk", true },
  { "gameserver-sponsor.me", true },
  { "gameshogun.xyz", true },
  { "gameshowchallenge.ie", true },
  { "gamesided.com", true },
  { "gamesme.cn", true },
  { "gamesplanet.com", true },
  { "gamesputnik.ru", true },
  { "gamestats.gg", true },
  { "gametilt.com", true },
  { "gametube.website", true },
  { "gamilab.com", true },
  { "gamilab.no", true },
  { "gamingexodus.com", true },
  { "gamingmedley.com", true },
  { "gamingrealms.net", true },
  { "gamingzoneservers.com", true },
  { "gamisalya.com", true },
  { "gamishou.fr", true },
  { "gamismodernshop.com", true },
  { "gamismu.com", true },
  { "gamismurahonline.com", true },
  { "gamivo.com", true },
  { "gamoloco.com", true },
  { "gamster.tv", true },
  { "ganado.org", true },
  { "ganaenergia.com", true },
  { "ganaenergia.es", true },
  { "ganasoku.net", true },
  { "gancedo.com.es", true },
  { "gandalfservice.com", true },
  { "gandalfthefeline.com", true },
  { "gandgliquors.com", true },
  { "ganggalbichler.at", true },
  { "gangnamavenue.com", true },
  { "gangnamcool.com", true },
  { "gansleit.com", false },
  { "ganyouxuan.com", true },
  { "ganztagplus.de", true },
  { "gao.ci", true },
  { "gao.rocks", true },
  { "gaodebo.com", true },
  { "gaojianli.me", true },
  { "gaos.org", true },
  { "gapdirect.com", true },
  { "gapfa.org", true },
  { "gaphag.ddns.net", true },
  { "garage-leone.com", true },
  { "garagedejan.ch", true },
  { "garagedoorrepairingsanjose.com", true },
  { "garageenginuity.com", true },
  { "garagefox.ch", true },
  { "garagegoossens.be", true },
  { "garagemhermetica.org", true },
  { "garagesmart.com.au", true },
  { "garagevanhulle-used.be", true },
  { "garanteasy.com", true },
  { "garazskapuszereles.hu", true },
  { "garbagedisposalguides.com", true },
  { "garbomuffin.com", true },
  { "garcia-franco.com", true },
  { "garciagerman.com", true },
  { "garda-see.mobi", true },
  { "gardedenfantspourtous.fr", true },
  { "gardengameshireuk.com", true },
  { "gardeningdirect.co.uk", true },
  { "gardenstate.tech", true },
  { "garderobche.eu", true },
  { "gardikagigih.com", true },
  { "gardis.ua", true },
  { "garedtech.com", false },
  { "garethbowker.com", true },
  { "garethkirk.com", true },
  { "garethrhugh.es", true },
  { "gargazon.net", true },
  { "garnuchbau.de", true },
  { "garriganenterprises.com", true },
  { "garriganenterprisesinc.com", true },
  { "garron.net", true },
  { "garrowmediallc.com", true },
  { "gartenbaur.de", true },
  { "gartenplanung-brendes.de", true },
  { "garycarmell.com", true },
  { "garycwaite.com", true },
  { "garyjones.co.uk", true },
  { "garyrh.com", true },
  { "garystallman.com", true },
  { "garyswine.com", true },
  { "garywhittington.com", true },
  { "gashalot.com", true },
  { "gaspapp.com", true },
  { "gastauftritt.net", true },
  { "gastoudererenda.nl", true },
  { "gastromedicalcenter.com.br", true },
  { "gastrotiger.at", true },
  { "gastrotiger.de", true },
  { "gate2home.com", true },
  { "gateaucreation.fr", true },
  { "gatekiller.co.uk", true },
  { "gatewaybridal.com", true },
  { "gathermycrew.org.au", true },
  { "gathu.co.ke", true },
  { "gauche.com", true },
  { "gaudeamus-folklor.cz", true },
  { "gaudere.co.jp", true },
  { "gaurl.ga", true },
  { "gaussianwaves.com", true },
  { "gauthier.dk", true },
  { "gautvedt.no", true },
  { "gavin.sh", true },
  { "gavins.stream", true },
  { "gaw.sh", true },
  { "gawrimanecuta.com", true },
  { "gay-sissies.com", true },
  { "gay.systems", true },
  { "gayauthors.org", true },
  { "gaycc.cc", true },
  { "gayhotti.es", true },
  { "gaymerconnect.net", true },
  { "gaymerx.com", true },
  { "gaymerx.net", true },
  { "gaymerx.org", true },
  { "gaysexpositions.guide", true },
  { "gaysfisting.com", true },
  { "gaytorrent.ru", true },
  { "gayukai.net", true },
  { "gayxsite.com", true },
  { "gazellegames.net", true },
  { "gazete.org", true },
  { "gazette.govt.nz", true },
  { "gbc-radio.nl", true },
  { "gbcsummercamps.com", true },
  { "gbl.selfip.net", true },
  { "gboys.net", true },
  { "gbs-uk.com", true },
  { "gc-mc.de", true },
  { "gc.de", true },
  { "gc.gy", true },
  { "gc.ru.net", true },
  { "gcbit.dk", true },
  { "gcfadvisors.com", true },
  { "gcgeeks.com.au", true },
  { "gcoded.de", true },
  { "gcs-ventures.com", true },
  { "gcsepod.com", true },
  { "gd88.cc", true },
  { "gdax.com", true },
  { "gdb-tutorial.net", true },
  { "gdgrzeszow.pl", true },
  { "gdiary.net", true },
  { "gdngs.de", true },
  { "gdoce.es", false },
  { "gdpr-pohotovost.cz", true },
  { "gdraco.com", true },
  { "gdsqua.re", true },
  { "gdv.me", true },
  { "gdz-spishy.com", true },
  { "ge3k.net", false },
  { "gear4you.shop", true },
  { "gearallnews.com", true },
  { "gearbot.rocks", true },
  { "gearboxhero.com", true },
  { "gearev.net", true },
  { "gearfinder.nl", true },
  { "gearset.com", true },
  { "geba-online.de", true },
  { "gebn.co.uk", true },
  { "gebn.uk", true },
  { "geboortestoeltje.com", true },
  { "geborgen-wachsen.de", true },
  { "gebruikershandleiding.com", true },
  { "gecem.org", true },
  { "gechr.io", true },
  { "geckler-ee.de", false },
  { "gedachtekaarsje.nl", true },
  { "geder.at", true },
  { "gedlingcastlehire.co.uk", true },
  { "gedlingtherapy.co.uk", true },
  { "gee.is", true },
  { "geecrat.com", true },
  { "geek-hub.de", true },
  { "geek.ch", true },
  { "geekabit.nl", true },
  { "geekandi.com", true },
  { "geekariom.com", true },
  { "geekbundle.org", true },
  { "geekclubbooks.com", true },
  { "geekeffect.co.uk", true },
  { "geeklair.net", true },
  { "geeklan.co.uk", true },
  { "geekles.net", true },
  { "geekpad.com", true },
  { "geeks.berlin", true },
  { "geeks.lgbt", true },
  { "geeks.one", false },
  { "geekshirts.cz", true },
  { "geekstreet.fr", true },
  { "geekthis.de", true },
  { "geektier.com", true },
  { "geektopia.es", true },
  { "geekwhack.org", true },
  { "geekwithabudget.com", true },
  { "geekwu.org", true },
  { "geekz.sk", true },
  { "geekzone.co.nz", true },
  { "geekzone.fr", true },
  { "geeq.ch", true },
  { "geerdsen.net", true },
  { "geertdegraaf.nl", true },
  { "geertswei.nl", true },
  { "gefolge.org", true },
  { "gegeco.ch", true },
  { "geh.li", true },
  { "gehas-wein-shop.de", true },
  { "gehirn.co.jp", true },
  { "gehirn.jp", true },
  { "gehopft.de", true },
  { "gehreslaw.com", true },
  { "gehrke.cloud", true },
  { "gehrke.in", true },
  { "gehsicht.de", true },
  { "geigenbauer.in", false },
  { "geiser-family.ch", true },
  { "geisser-elektronikdata.de", true },
  { "geitenijs.com", true },
  { "gelb-computer.de", true },
  { "geld-im-blick.de", true },
  { "geld24.nl", true },
  { "geldimblick.de", true },
  { "geleenbeekdal.nl", true },
  { "geleia-real.com", true },
  { "geli-graphics.com", true },
  { "gelis.ch", true },
  { "gellis12.com", true },
  { "gelog-software.de", false },
  { "gelonghui.com", true },
  { "geloofindemocratie.nl", false },
  { "gelpinhos.pt", true },
  { "gelsey.com", true },
  { "geluidsstudio.com", true },
  { "geluk.io", true },
  { "gelukkigehonden.nl", true },
  { "gem-info.fr", true },
  { "gemails.eu", true },
  { "gemeinsam-ideen-verwirklichen.de", true },
  { "gemgroups.in", true },
  { "gemini.com", true },
  { "gemquery.com", true },
  { "genbright.com", true },
  { "genchev.io", true },
  { "gencmedya.com", true },
  { "genderidentiteit.nl", true },
  { "gendrin.com", true },
  { "gendundrupa.ch", true },
  { "gene-drive.com", true },
  { "gene-drives.com", true },
  { "genealorand.com", true },
  { "geneau.net", true },
  { "genehightower.com", true },
  { "genehome.com.au", true },
  { "genemon.at", true },
  { "generace-id.org", true },
  { "generador-electrico.com", true },
  { "general-anaesthesia.com", true },
  { "general-anaesthetics.com", true },
  { "general-anesthesia.com", true },
  { "general-plast.com", true },
  { "generali-worldwide.com", true },
  { "generalinsuranceservices.com", true },
  { "generationgoat.com", true },
  { "generationr.nl", true },
  { "generator.creditcard", true },
  { "generic.cx", true },
  { "generujdata.cz", true },
  { "genesiseureka.com", true },
  { "genesismachina.ca", true },
  { "genesistrading.com", true },
  { "genesysmi.com", true },
  { "genetargetsolutions.com.au", true },
  { "genetidyne.com", true },
  { "genevachauffeur.com", true },
  { "geneve-naturisme.ch", true },
  { "genevoise-entretien.ch", true },
  { "genfaerd.dk", true },
  { "geniofinanciero.org", true },
  { "geniush.ovh", true },
  { "geniusteacher.in", true },
  { "geniuszone.biz", true },
  { "genocidediary.org", true },
  { "genodeftest.de", true },
  { "genomequestlive.com", true },
  { "genosse-einhorn.de", true },
  { "genossenwiese.ch", true },
  { "genoveve.de", true },
  { "gensend.com", true },
  { "gensenwedding.jp", true },
  { "genshiken-itb.org", true },
  { "gensicke.de", true },
  { "genslerapps.com", true },
  { "genslerwisp.com", true },
  { "gensokyo.re", true },
  { "gensonline.eu", true },
  { "gentcdn.com", true },
  { "gentianes.ch", true },
  { "gentlent.net", true },
  { "gentoo-blog.de", true },
  { "gentz.rocks", true },
  { "genusshotel-riegersburg.at", true },
  { "genxnotes.com", true },
  { "geocar.com", true },
  { "geocompass.at", true },
  { "geoffsec.org", true },
  { "geography-schools.com", true },
  { "geoinstinct.com", true },
  { "geoip.fedoraproject.org", true },
  { "geoip.stg.fedoraproject.org", true },
  { "geojs.io", true },
  { "geology-schools.com", true },
  { "geomac.gov", true },
  { "geometra.roma.it", true },
  { "geometra24.it", true },
  { "geomex.be", true },
  { "geomonkeys.com", true },
  { "geoponika.gr", true },
  { "geoport.al", true },
  { "georadar-algerie.com", true },
  { "george-brighton.co.uk", true },
  { "george-orwell.com", true },
  { "georgeblack.me", true },
  { "georgebrighton.co.uk", true },
  { "georgecolgrove.com", true },
  { "georgedesign.ch", true },
  { "georgemaschke.net", true },
  { "georgepancescu.ro", true },
  { "georgescarryout.com", false },
  { "georgewatson.me", true },
  { "georgewbushlibrary.gov", true },
  { "georgiaautoglass.net", true },
  { "georgiaglassrepair.com", true },
  { "georgiastuartyoga.co.uk", true },
  { "georgiaurologist.com", true },
  { "georgioskontaxis.com", true },
  { "georgioskontaxis.net", true },
  { "georgioskontaxis.org", true },
  { "georgmayer.eu", true },
  { "geoscan.aero", true },
  { "geoscope.ch", true },
  { "geotab.com", true },
  { "gepgroup.gr", true },
  { "gepps.de", true },
  { "geraintwhite.co.uk", true },
  { "gerald-zojer.com", true },
  { "geraldsonrealty.com", true },
  { "gerardinden.nl", true },
  { "gerardobsd.com", true },
  { "gerardozamudio.mx", true },
  { "gerbyte.co.uk", true },
  { "gerbyte.com", true },
  { "gerbyte.uk", true },
  { "germandarknes.net", true },
  { "germanmasterpainters.nz", true },
  { "germanssky.de", true },
  { "gernert-server.de", true },
  { "gero.io", true },
  { "gerritcodereview.com", true },
  { "gervais-avocat.fr", true },
  { "gerwinvanderkamp.nl", true },
  { "ges-bo.de", true },
  { "geschichtscheck.de", true },
  { "geschmacksache.online", true },
  { "geschwinder.net", true },
  { "gesica.cloud", true },
  { "gesnex.com", true },
  { "gessettirotti.it", true },
  { "gestionrocamar.es", true },
  { "gestorehotel.com", true },
  { "gestormensajeria.com", true },
  { "gestsal.com", true },
  { "gesundheitmassage.com", true },
  { "gesundheitswelt24.de", true },
  { "get-erp.ru", true },
  { "get-it-live.com", true },
  { "get-it-live.de", true },
  { "get-on.bid", true },
  { "get-refer.com", true },
  { "get.how", true },
  { "get2getha.org", true },
  { "getbonfire.com", true },
  { "getbooks.co.il", true },
  { "getbox.me", true },
  { "getbreadcrumbs.com", true },
  { "getbrowink.com", true },
  { "getbutterfly.com", true },
  { "getcard.cc", true },
  { "getcloak.com", false },
  { "getdash.io", true },
  { "getdeveloper.de", true },
  { "geteckeld.nl", true },
  { "geteduroam.no", true },
  { "geterp.ru", true },
  { "geteventbox.com", true },
  { "getfedora.org", true },
  { "getfilterlive.org", true },
  { "getfirstalert.com", true },
  { "getflorence.co.uk", true },
  { "getgeek.es", true },
  { "getgeek.se", true },
  { "gethow.org", true },
  { "gethttpsforfree.com", true },
  { "getidmcc.com", true },
  { "getimgs.com", true },
  { "getinphase.com", true },
  { "getintopc.com", true },
  { "getitlive.de", true },
  { "getlawyered.com.au", true },
  { "getmango.com", true },
  { "getmdl.io", true },
  { "getmerch.eu", true },
  { "getmovil.com", false },
  { "getnib.com", true },
  { "getnikola.com", true },
  { "getpagespeed.com", true },
  { "getpanelapp.com", true },
  { "getpei.com", true },
  { "getpublii.com", true },
  { "getpuck.com", true },
  { "getrambling.com", true },
  { "getresilience.org", true },
  { "getsecure.nl", true },
  { "getsensibill.com", true },
  { "getsetbounce.co.uk", true },
  { "getsmartaboutdrugs.gov", false },
  { "getsport.mobi", true },
  { "getteamninja.com", true },
  { "getthefriendsyouwant.com", true },
  { "getticker.com", true },
  { "gettok.com", true },
  { "gettopquality.com", true },
  { "getupandbounce.co.uk", true },
  { "getvdownloader.com", true },
  { "getwemap.com", true },
  { "getwisdom.io", true },
  { "getyeflask.com", true },
  { "getyourlifestraight.com", true },
  { "gevelreinigingtiel.nl", true },
  { "geyduschek.be", true },
  { "gf-franken.de", true },
  { "gf5fcalc.com", true },
  { "gfahnen.de", true },
  { "gfast.ru", true },
  { "gfcleisure.co.uk", true },
  { "gfe.li", true },
  { "gfedating.com", true },
  { "gfelite.de", true },
  { "gfestival.fo", true },
  { "gfk-kunststoff-luebben.de", true },
  { "gflame.de", true },
  { "gfms.ru", true },
  { "gfnetfun.cf", true },
  { "gforce.ninja", true },
  { "gfoss.eu", true },
  { "gfourmis.co", true },
  { "gfxbench.com", true },
  { "gg5197.co", true },
  { "gg6729.co", true },
  { "gg6729.com", true },
  { "gg6957.co", true },
  { "gg9297.co", true },
  { "gg9397.com", true },
  { "gg9721.com", true },
  { "gg9728.co", true },
  { "ggbet.me", true },
  { "ggdcpt.com", true },
  { "gginin.today", true },
  { "ggl-luzern.ch", true },
  { "ggma.co.uk", true },
  { "ggmmontascale.it", true },
  { "ggp2.com", true },
  { "ggs-marschallstrasse.de", true },
  { "ggs.jp", true },
  { "ggservers.com", true },
  { "ggx.us", true },
  { "gh-sandanski.com", true },
  { "gha.st", true },
  { "ghettonetflix.de", true },
  { "ghfip.com.au", true },
  { "ghini.com", true },
  { "ghislainphu.fr", true },
  { "ghostcir.com", true },
  { "ghowell.io", true },
  { "ghuntley.com", false },
  { "giac.org", true },
  { "giacomopelagatti.it", true },
  { "giakki.eu", false },
  { "giannademartini.com", true },
  { "gianproperties.com", true },
  { "giant-panda.com", true },
  { "giant-tortoise.com", true },
  { "gianttree.de", true },
  { "giardinaggio.milano.it", true },
  { "giardinaggio.napoli.it", true },
  { "giardiniblog.it", true },
  { "giardiniere.bologna.it", true },
  { "giardiniere.milano.it", true },
  { "giardiniere.roma.it", true },
  { "gichigamigames.com", true },
  { "gidari.shop", true },
  { "giebel.it", true },
  { "giemall.com", true },
  { "gierds.de", true },
  { "giethoorn.com", true },
  { "gietvloergarant.nl", false },
  { "gifino.fr", true },
  { "giftcard.net", true },
  { "giftcardgranny.com", true },
  { "giftedconsortium.com", true },
  { "giftking.nl", false },
  { "giftlist.guru", true },
  { "giftmaniabrilhos.com.br", true },
  { "gifts365.co.uk", true },
  { "giftya.com", true },
  { "gifudodo.com", true },
  { "gig-raiffeisen.de", true },
  { "giga.nl", true },
  { "gigabitz.pw", false },
  { "gigacog.com", true },
  { "gigantism.com", true },
  { "giggletotz.co.uk", true },
  { "gigin.eu", true },
  { "gigin.me", true },
  { "gigis-pizzeria.de", true },
  { "gigis.cloud", true },
  { "giglink.club", true },
  { "gigolodavid.be", true },
  { "gigseekr.com", true },
  { "gigtroll.eu", true },
  { "gijsbertus.com", true },
  { "gijswesterman.nl", true },
  { "gikovatelojavirtual.com.br", true },
  { "gilangcp.com", true },
  { "gileadpac.com", true },
  { "giliamor.com", true },
  { "gillesmorelle.com", true },
  { "gillfamily.de", true },
  { "gillmanandsoame.co.uk", true },
  { "gillyscastles.co.uk", true },
  { "gilme.net", true },
  { "gilmoreid.com.au", true },
  { "gilnet.be", true },
  { "gimme.money", true },
  { "gina-architektur.design", true },
  { "ginabaum.com", true },
  { "ginen.xyz", true },
  { "gingersutton.com", true },
  { "ginionusedcars.be", true },
  { "ginja.co.th", true },
  { "ginnegappen.nl", true },
  { "ginniemae.gov", true },
  { "gino-gelati.de", true },
  { "ginza-luce.net", true },
  { "ginza-viola.com", true },
  { "ginzadelunch.jp", true },
  { "ginzaj.com", true },
  { "giochiecodici.it", true },
  { "gioielleriamolena.com", true },
  { "gippert-klein.de", true },
  { "giraffeduck.com", true },
  { "giraffenland.de", true },
  { "giraffes.org", true },
  { "giri.co", true },
  { "girlan.net", true },
  { "girlsforum.com", true },
  { "girlsnet.work", true },
  { "girlz.jp", true },
  { "girsa.org", true },
  { "girvas.ru", true },
  { "gisac.org", true },
  { "gisch.tk", true },
  { "gisher.news", true },
  { "gisher.org", true },
  { "gisher.video", true },
  { "gishiko.net", true },
  { "gistr.io", true },
  { "git.market", false },
  { "git.org.il", true },
  { "git.sb", true },
  { "git.tt", true },
  { "gitecolombedesbois.com", true },
  { "gitep.org.uk", true },
  { "gites-alizea.com", true },
  { "gitesdeshautescourennes.com", true },
  { "github.com", true },
  { "githubapp.com", true },
  { "githubber.com", true },
  { "githubber.tv", true },
  { "gitla.in", true },
  { "gitstuff.tk", true },
  { "gittigidiyor.com", true },
  { "gittr.ch", true },
  { "giuem.com", true },
  { "giunchi.net", true },
  { "giuseppemacario.men", true },
  { "give.net", true },
  { "give2charity.co", true },
  { "give2charityapp.com", true },
  { "giveattheoffice.org", false },
  { "giveaways.ph", true },
  { "given2.com", true },
  { "giveoneup.org", true },
  { "givesunlight.com", true },
  { "givingnexus.org", false },
  { "givingtools.com", true },
  { "gixtools.com", true },
  { "gixtools.net", true },
  { "gizmo.ovh", true },
  { "gj-bochum.de", true },
  { "gjcampbell.co.uk", true },
  { "gjengset.com", true },
  { "gjspunk.de", false },
  { "gkoenig-innenausbau.de", true },
  { "gkralik.eu", true },
  { "gl.search.yahoo.com", false },
  { "gla-hyperloop.com", true },
  { "glaciernursery.com", true },
  { "gladdy.co.uk", true },
  { "gladdy.uk", true },
  { "gladdymedia.co.uk", true },
  { "gladdymedia.com", true },
  { "gladdymedia.uk", true },
  { "gladiac.duckdns.org", true },
  { "gladwellentertainments.co.uk", true },
  { "gladysstrickland.com", true },
  { "glahcks.com", true },
  { "glamguru.co.il", true },
  { "glamguru.world", true },
  { "glamour4you.de", true },
  { "glamourdaze.com", true },
  { "glamouria.com.br", true },
  { "glasdon.com", true },
  { "glasen-hardt.de", true },
  { "glasfaser-im-hanseviertel.de", true },
  { "glasgestaltung.biz", true },
  { "glaspe.com", true },
  { "glass.google.com", true },
  { "glasschmuck-millefiori.de", true },
  { "glassemployees.com", true },
  { "glassexpertswa.com", true },
  { "glassrainbowtrust.org.je", true },
  { "glassrom.pw", true },
  { "glasweld.com", true },
  { "glavsudexpertiza.ru", true },
  { "glcastlekings.co.uk", true },
  { "gleanview.com", true },
  { "gleich-aluminium-shop.de", true },
  { "glenberviegolfclub.com", true },
  { "glencarbide.com", true },
  { "glendarraghbouncycastles.co.uk", true },
  { "glenhuntlyapartments.com.au", true },
  { "glenshere.com", true },
  { "glidingshop.cz", true },
  { "glidingshop.de", true },
  { "glidingshop.eu", true },
  { "glitzerstuecke.de", true },
  { "glixee.com", true },
  { "glloq.org", true },
  { "global-adult-webcams.com", true },
  { "global-office.com", true },
  { "global-village.koeln", true },
  { "globalbano.com", true },
  { "globalbridge-japan.com", true },
  { "globalcanineregistry.com", true },
  { "globalchokepoints.org", true },
  { "globalcomix.com", true },
  { "globalgovernancewatch.org", true },
  { "globalhealth.gov", true },
  { "globalhealthstrategiesnetwork.com", true },
  { "globalhealthstrategiesnetwork.info", true },
  { "globalhealthstrategiesnetwork.net", true },
  { "globalhealthstrategiesnetwork.org", true },
  { "globalhorses.de", true },
  { "globalinvestigations.co.uk", true },
  { "globalipaction.ch", true },
  { "globalisierung-fakten.de", true },
  { "globalitac.com", true },
  { "globalityinvestment.com", true },
  { "globalno.me", true },
  { "globalonetechnology.com", true },
  { "globalprojetores.com.br", true },
  { "globalresearchcouncil.org", true },
  { "globalresistancecorporation.com", true },
  { "globalventil.com", true },
  { "globalwitness.org", true },
  { "globe-flight.de", true },
  { "globecollege.nl", true },
  { "globelink-group.com", true },
  { "globologic.com", true },
  { "glocalworks.jp", true },
  { "gloeckle-gruppe.de", true },
  { "glofox.com", true },
  { "glolighting.co.za", true },
  { "gloneta.com", false },
  { "gloning.name", true },
  { "glont.net", true },
  { "gloria.tv", true },
  { "gloryholefucking.com", true },
  { "glosiko.com", true },
  { "glotech.co.uk", true },
  { "glotechkitchens.co.uk", true },
  { "glotechrepairs.co.uk", true },
  { "gloucestershiregospelpartnership.org.uk", true },
  { "gluecksgriff-taschen.de", true },
  { "glueckskindter.de", true },
  { "gluedtomusic.com", true },
  { "gluit.de", true },
  { "glutenfreelife.co.nz", true },
  { "glutenfreevr.com", true },
  { "glykofridis.nl", true },
  { "glyph.ws", true },
  { "glyptodon.com", true },
  { "glyxins.com", true },
  { "gm-net.jp", true },
  { "gm.search.yahoo.com", false },
  { "gmacedo.com", true },
  { "gmail.com", false },
  { "gmbh-kiekin.de", true },
  { "gmc.uy", true },
  { "gmccar.it", true },
  { "gmcd.co", true },
  { "gmdu.net", true },
  { "gme.one", true },
  { "gmod.de", true },
  { "gmpark.dk", true },
  { "gmpartsdb.com", true },
  { "gmslparking.co.uk", true },
  { "gmta.nl", true },
  { "gmtplus.co.za", true },
  { "gmuh.fr", true },
  { "gmw-hannover.de", true },
  { "gmw-ingenieurbuero.de", true },
  { "gmx.at", true },
  { "gmx.ch", true },
  { "gmx.co.uk", true },
  { "gmx.com", true },
  { "gmx.de", true },
  { "gmx.es", true },
  { "gmx.fr", true },
  { "gmx.net", true },
  { "gn00.com", true },
  { "gnax.jp", false },
  { "gndh.net", true },
  { "gnetion.com", true },
  { "gnetwork.eu", true },
  { "gnfrazier.me", true },
  { "gnk.io", true },
  { "gnucashtoqif.us", true },
  { "gnwp.eu", true },
  { "go-dutch.eu", true },
  { "go-embedded.de", true },
  { "go-propiedades.cl", true },
  { "go-wild.co.uk", true },
  { "go-zh.org", true },
  { "go.microsoft.com", true },
  { "go.xero.com", false },
  { "go2archive.nl", true },
  { "go2ubl.nl", true },
  { "goa8.xyz", true },
  { "goalbookapp.com", true },
  { "goalongtravels.com", true },
  { "goanalyse.co.uk", true },
  { "goand.run", true },
  { "goarmy.eu", true },
  { "goatcloud.com", true },
  { "gobarrelroll.com", true },
  { "gobouncy.co.uk", true },
  { "gobouncy.com", true },
  { "gobytedesign.co.uk", true },
  { "gocardless.com", true },
  { "gocher.me", true },
  { "gochu.se", true },
  { "gocleanerslondon.co.uk", true },
  { "gocphongthuy.net", true },
  { "god-clan.hu", true },
  { "godattributes.com", true },
  { "godaxen.tv", true },
  { "godclan.hu", true },
  { "godesigner.ru", true },
  { "godsofhell.com", true },
  { "godsofhell.de", true },
  { "goeb.eu", true },
  { "goeb.org", true },
  { "goededoelkerstkaarten.nl", true },
  { "goedkoopstecartridges.nl", true },
  { "goedkopecartridgeskopen.nl", true },
  { "goedkopeonesies.nl", true },
  { "goedkopetonerkopen.nl", true },
  { "goedverzekerd.net", true },
  { "goehler-baumpflege.de", true },
  { "goemail.me", true },
  { "goerlitz-zgorzelec.org", true },
  { "goerres2014.de", true },
  { "goetemp.de", true },
  { "goetic.space", true },
  { "goettinger-biergarten.de", true },
  { "goffrie.com", true },
  { "gofigure.fr", false },
  { "goflipr.com", true },
  { "goflo.net", true },
  { "gofoiayourself.org", true },
  { "gogle-analytics.com", true },
  { "gogleapis.com", true },
  { "gogoodyear.eu", true },
  { "gogroopie.com", true },
  { "gogroopie.ie", true },
  { "gogrow.com", true },
  { "gogsat.com", true },
  { "gohon.org", true },
  { "gohongi-katakori.com", true },
  { "goingreen.com.au", true },
  { "gokhankesici.com", true },
  { "gokmenguresci.com", true },
  { "golang.org", true },
  { "golang.zone", true },
  { "golangnews.com", true },
  { "goldclubcasino.com", true },
  { "goldcoast-plumbing.com.au", true },
  { "goldcoastasian.com", true },
  { "goldcoasthypnotherapyhypnosis.com.au", true },
  { "goldcoastphotographycourses.com", true },
  { "goldcoaststumpbusters.com", true },
  { "goldenbadger.de", true },
  { "goldendawnapersonalaffair.com", true },
  { "goldenhillsoftware.com", true },
  { "goldenhost.ca", false },
  { "goldenmonrepos.com", true },
  { "goldenplate.com.sg", true },
  { "goldenruleemail.com", true },
  { "goldfmromania.ro", true },
  { "goldmark.com.au", true },
  { "goldpreisfinder.at", true },
  { "goldsecurity.com", true },
  { "goldsilver.org.ua", true },
  { "goldstein.tel", true },
  { "goldsteinlawgroup.com", true },
  { "goldytechspecialists.com", true },
  { "golf18network.com", true },
  { "golf18staging.com", true },
  { "golfhausmallorca.com", true },
  { "golfmeile.de", true },
  { "golfpark-bostalsee.de", true },
  { "golfscape.com", true },
  { "golighthouse.com", true },
  { "golik.net.pl", false },
  { "golser-schuh.at", true },
  { "golser.info", true },
  { "gomasy.jp", true },
  { "gomedium.com", true },
  { "gomel.chat", true },
  { "gomel.city", true },
  { "gomelchat.com", true },
  { "gomelphoto.com", true },
  { "gommista.roma.it", true },
  { "gondawa.com", true },
  { "gondelvaartdwarsgracht.nl", true },
  { "gondola-parkinson.com", true },
  { "gongjianwei.com", true },
  { "gongjuhao.com", true },
  { "gonx.dk", false },
  { "goo.gl", true },
  { "gooby.co", false },
  { "good-tips.pro", true },
  { "good588.com", true },
  { "gooday.life", true },
  { "gooddayatwork.co.uk", true },
  { "goodhealthtv.com", true },
  { "goodiesoft.hu", false },
  { "goodiesoftware.xyz", true },
  { "goodquote.gq", true },
  { "goodryb.top", true },
  { "goodshepherdmv.com", true },
  { "goodth.ink", true },
  { "goodvibesblog.com", true },
  { "google", true },
  { "google-analytics.com", true },
  { "googleandroid.cz", true },
  { "googlemail.com", false },
  { "googleplex.com", true },
  { "googleshortcuts.org", true },
  { "googlesource.com", true },
  { "goombi.fr", true },
  { "goonersworld.co.uk", true },
  { "goonfleet.com", true },
  { "goooo.info", true },
  { "goover.de", true },
  { "goow.in", true },
  { "goozp.com", true },
  { "gopher.tk", true },
  { "gophoto.it", true },
  { "goprimal.eu", true },
  { "goproallaccess.com", true },
  { "goproinspectiongroup.com", true },
  { "goquiq.com", true },
  { "gordeijnsbouw.nl", true },
  { "gordonchevy.com", true },
  { "gordonobrecht.com", true },
  { "gordonscouts.com.au", true },
  { "gorealya.com", true },
  { "gorf.chat", true },
  { "gorf.club", true },
  { "gorgias.me", true },
  { "gorky.media", true },
  { "gorn.ch", true },
  { "gornergrat-kulm.ch", true },
  { "gosccs.com", true },
  { "gosforthdentalsurgery.co.uk", true },
  { "goshawkdb.io", true },
  { "goshin-group.co.jp", true },
  { "goshow.tv", true },
  { "gosnipe.com", true },
  { "gosolockpicks.com", true },
  { "gospelfollower.com", true },
  { "gospelvestcination.de", true },
  { "gosportweather.co.uk", true },
  { "gostaffer.com", true },
  { "gostargazing.co.uk", true },
  { "gosu.pro", true },
  { "gosuland.org", true },
  { "got-tty.de", true },
  { "goteborgsklassikern.se", true },
  { "gotech.com.eg", false },
  { "gothamlimo.com", true },
  { "gothic.dating", true },
  { "gotirupati.com", false },
  { "gotmalk.org", false },
  { "goto.google.com", true },
  { "goto.msk.ru", true },
  { "goto10.se", true },
  { "gotomi.info", false },
  { "gotowned.org", false },
  { "gotoxy.at", true },
  { "gotrail.fr", true },
  { "gotrek.com.au", true },
  { "gottcode.org", false },
  { "goudenharynck.be", true },
  { "gouforit.com", true },
  { "gouldcooksey.com", true },
  { "goup.co", true },
  { "goup.com.tr", true },
  { "gouptime.ml", true },
  { "gourmetfestival.de", true },
  { "gourmetspalencia.com", true },
  { "gov.uk", false },
  { "governmentjobs.gov", true },
  { "governorhub.com", true },
  { "govisitcostarica.co.cr", true },
  { "govisitcostarica.com", true },
  { "govloans.gov", true },
  { "govsurvey.us", true },
  { "govtjobs.blog", true },
  { "govype.com", true },
  { "gow220.ru", true },
  { "gowancommunications.com", true },
  { "goweraesthetics.co.uk", true },
  { "gowildrodeo.co.uk", true },
  { "gowithflo.de", true },
  { "gozenhost.com", true },
  { "gpalabs.com", true },
  { "gpccp.cc", true },
  { "gpcsolutions.fr", true },
  { "gpdimaranathasiantar.org", false },
  { "gpgscoins.com", true },
  { "gplans.us", true },
  { "gpm.ltd", true },
  { "gprs.uk.com", true },
  { "gpsolarpanels.com", true },
  { "gpsvideocanada.com", true },
  { "gpu.nu", true },
  { "gpureport.cz", true },
  { "gpws.ovh", true },
  { "gpyy.net", true },
  { "gqmstore.com.br", true },
  { "gr.search.yahoo.com", false },
  { "gr8engineer2b.com", true },
  { "graandco.com", false },
  { "graasp.net", false },
  { "grabacabpa.com", true },
  { "grabadolasermonterrey.com", true },
  { "grabatt.de", true },
  { "grace-wan.com", true },
  { "gracebaking.com", false },
  { "gracedays.org", true },
  { "gracethrufaith.com", true },
  { "gracetini.com", true },
  { "gradecam.com", false },
  { "gradienthosting.co.uk", true },
  { "gradients.com", true },
  { "gradualgram.com", true },
  { "graeber.com", true },
  { "graecum.org", true },
  { "graetnew.com", true },
  { "graf-igor.ch", true },
  { "graf.re", true },
  { "grafcaps.com", true },
  { "graffen.dk", true },
  { "grafmag.pl", true },
  { "grafoteka.pl", true },
  { "graft.community", true },
  { "graft.observer", true },
  { "grahambaker.ca", true },
  { "grahamcarruthers.co.za", true },
  { "grahamcluley.com", true },
  { "grailians.com", true },
  { "grailify.com", true },
  { "graingert.co.uk", true },
  { "graliv.net", false },
  { "gramati.com.br", true },
  { "grammysgrid.com", true },
  { "granary-demo.appspot.com", false },
  { "grandcafecineac.nl", true },
  { "grandcafetwist.nl", true },
  { "grandcapital.cn", true },
  { "grandcapital.id", true },
  { "grandcapital.net", true },
  { "grandcapital.ru", true },
  { "grandcastles.co.uk", true },
  { "grandchene.ch", true },
  { "grande.coffee", true },
  { "grandeto.com", true },
  { "grandjunctionbrewing.com", true },
  { "grandmusiccentral.com.au", true },
  { "grandpadusercontent.com", true },
  { "grandwailea.com", true },
  { "grandworldnghiduong.com", true },
  { "granfort.es", false },
  { "granishe.com", true },
  { "graniteind.com", true },
  { "grannys-stats.com", true },
  { "grannyshouse.de", true },
  { "grantcooper.com", true },
  { "grantmorrison.net", true },
  { "grantplatform.com", true },
  { "grantsplatform.com", true },
  { "graonatural.com.br", true },
  { "grapee.jp", true },
  { "grapeintentions.com", true },
  { "grapevine.is", true },
  { "graph.org", true },
  { "graphcommons.com", true },
  { "graphene.software", true },
  { "grapheneos.org", true },
  { "graphic-schools.com", true },
  { "graphic-shot.com", true },
  { "graphobyte.com", true },
  { "grapholio.net", true },
  { "grasboomamersfoort.nl", true },
  { "grasboombinnendoor.nl", true },
  { "grasboomclophaemer.nl", true },
  { "grasboomderoos.nl", true },
  { "grasboomleusden.nl", true },
  { "grasboommax.nl", true },
  { "grasboommeerbalans.nl", true },
  { "grasboomveenendaal.nl", true },
  { "grasboomvondellaan.nl", true },
  { "grasmark.com", true },
  { "grassenberg.de", true },
  { "grasshoppervape.com", true },
  { "grasso.io", true },
  { "grassreinforcement.com.au", true },
  { "gratis.market", true },
  { "gratisgamecards.nl", true },
  { "gratisrollenspieltag.de", true },
  { "gratiswifivoorjegasten.nl", true },
  { "gratitudeabundancepassion.com", true },
  { "grattan.co.uk", true },
  { "graumeier.de", true },
  { "gravilink.com", true },
  { "gravitascreative.net", true },
  { "gravity-inc.net", true },
  { "gravityformspdfextended.com", true },
  { "gravitypdf.com", true },
  { "grawe-blog.at", true },
  { "grayclub.co.il", true },
  { "grayhatter.com", true },
  { "grayiron.io", true },
  { "graymalk.in", true },
  { "grayowlworks.com", true },
  { "grayscale.co", true },
  { "grayson.sh", true },
  { "graz2020.com", true },
  { "grazieitalian.com", true },
  { "grazitti.com", true },
  { "grc.com", false },
  { "greatagain.gov", true },
  { "greaterlowellpediatrics.com", true },
  { "greatestwebsiteonearth.com", true },
  { "greatfire.org", true },
  { "greathairtransplants.com", true },
  { "greatislandarts.ca", true },
  { "greatlakeside.de", true },
  { "greatlifeinsurancegroup.com", true },
  { "greatskillchecks.com", true },
  { "greatwebdesign.uk", true },
  { "greboid.co.uk", true },
  { "greboid.com", true },
  { "greek.dating", true },
  { "greeklish.gr", true },
  { "greekmusic.academy", true },
  { "green-attitude.be", true },
  { "green-care.nl", true },
  { "green-light.cf", true },
  { "green-light.co.nz", true },
  { "green-light.ga", true },
  { "green-light.gq", true },
  { "green-light.ml", true },
  { "green-techno.ru", true },
  { "greenaddress.it", true },
  { "greenapproach.ca", true },
  { "greencircleplantnursery.com.au", true },
  { "greencircleplantnursery.net.au", true },
  { "greener.pl", true },
  { "greengorych.ru", true },
  { "greenhats.de", true },
  { "greenliquidsystem.com", true },
  { "greenliv.pl", true },
  { "greenlungs.net", true },
  { "greenmachines.com", true },
  { "greenoutdoor.dk", false },
  { "greenpanda.de", true },
  { "greenpartyofnewmilford.org", true },
  { "greenpeace-magazin.de", true },
  { "greenpeace.berlin", true },
  { "greenponik.com", true },
  { "greenroach.ru", true },
  { "greenrushdaily.com", true },
  { "greensborosecuritycameras.com", true },
  { "greensdictofslang.com", true },
  { "greensquare.tk", true },
  { "greenteamtwente.nl", true },
  { "greenwithdecor.com", true },
  { "greg.red", true },
  { "gregbrimble.com", true },
  { "greger.me", true },
  { "gregmilton.com", true },
  { "gregmote.com", true },
  { "gregoirow.be", true },
  { "gregorians.org", true },
  { "gregorkofler.com", true },
  { "gregory-kramer.fr", true },
  { "gregory-thibault.com", true },
  { "gregorykelleher.com", true },
  { "gregoryrealestategroup.com", true },
  { "gregorywiest.com", true },
  { "greice.de", true },
  { "grenadiercorps-kaarst.de", true },
  { "grenadiere-kaarst.de", true },
  { "grenadierkorps-kaarst.de", true },
  { "grenadierkorps.de", true },
  { "grendel.no", true },
  { "grenlandkiropraktor.no", true },
  { "grepmaste.rs", true },
  { "grepular.com", true },
  { "gresak.io", true },
  { "greta-birkner.de", true },
  { "grexx.co.uk", true },
  { "grexx.de", true },
  { "grexx.nl", true },
  { "grey.house", true },
  { "greyhash.se", true },
  { "greymattertechs.com", true },
  { "greysky.me", true },
  { "greyskymedia.com", true },
  { "greysolutions.it", true },
  { "greywizard.com", true },
  { "greywolf.cz", true },
  { "grh.am", true },
  { "griassdi-reseller.de", true },
  { "gricargo.com", true },
  { "grid.studio", true },
  { "gridle.io", true },
  { "gridpack.org", true },
  { "gridsmartercities.com", true },
  { "griechische-pfoetchen.de", true },
  { "griefheart.com", true },
  { "grieg-gaarden.no", true },
  { "grieg.no", false },
  { "griegfoundation.no", true },
  { "grieglogistics.no", true },
  { "griegshipbrokers.com", true },
  { "griegshipbrokers.no", true },
  { "grienenberger.eu", true },
  { "griesser2.de", true },
  { "grifomarchetti.com", true },
  { "grillen-darf-nicht-gesund-sein.de", true },
  { "grillhutsunderland.com", true },
  { "grillteller42.de", true },
  { "grimcalc.com", true },
  { "grimm-gastrobedarf.de", true },
  { "grimneko.de", true },
  { "grimstveit.no", true },
  { "grinnellplanes.com", true },
  { "grinnellplans.com", true },
  { "gritte.ch", true },
  { "grizzlys.com", true },
  { "grocerybuild.com", true },
  { "grocock.me.uk", true },
  { "groenaquasolutions.nl", true },
  { "groentebesteld.nl", true },
  { "groenteclub.nl", true },
  { "groepjam-usedcars.be", true },
  { "grog.pw", true },
  { "grokker.com", true },
  { "groklearning.com", true },
  { "grolimur.ch", true },
  { "gronau-it-cloud-computing.de", true },
  { "grondius.com", true },
  { "groomershop.ru", false },
  { "groomscroft.co.uk", true },
  { "groomscroft.com", true },
  { "grootinadvies.nl", true },
  { "groovydisk.com", true },
  { "groovygoldfish.org", true },
  { "gropp.org", true },
  { "grosdebit.com", true },
  { "gross-gerau-hausarzt.de", true },
  { "gross.business", true },
  { "grossberger-ge.org", false },
  { "grossiste-en-ligne.com", true },
  { "groszek.pl", true },
  { "groth.im", true },
  { "groth.xyz", true },
  { "grothoff.org", true },
  { "grottenthaler.eu", true },
  { "groundmc.net", true },
  { "groundthumpingmotors.com", true },
  { "groundthumpingmotors.net", true },
  { "groundthumpinmotors.com", true },
  { "groundthumpinmotors.net", true },
  { "group4layers.net", true },
  { "groupe-neurologique-nord.lu", true },
  { "groupebaillargeon.com", true },
  { "groupghistelinck-cars.be", true },
  { "grouphomes.com.au", false },
  { "groupme.com", true },
  { "groups.google.com", true },
  { "groupseslogistic.com", true },
  { "grove-archiv.de", true },
  { "growingallthings.co.uk", true },
  { "growit.events", true },
  { "growy.ch", true },
  { "grozter.se", true },
  { "grrmmll.com", true },
  { "grsecurity.net", true },
  { "gruble.de", true },
  { "gruebebraeu.ch", true },
  { "gruenderlehrstuhl.de", true },
  { "gruenderwoche-dresden.de", true },
  { "gruene-im-rvr.de", true },
  { "gruene-wattenscheid.de", true },
  { "gruenes-wp.de", true },
  { "gruenprint.de", true },
  { "gruenstreifen-ev.de", true },
  { "grumpy.fr", true },
  { "grumpygamers.com", true },
  { "grundlage.com.ua", true },
  { "grunwaldzki.center", true },
  { "grunwasser.fr", true },
  { "gruper.mk", true },
  { "grupodatco.com", true },
  { "grupomakben.com", true },
  { "grupomedlegal.com", true },
  { "grupoparco.com", true },
  { "grupoproabienesraices.com.mx", true },
  { "grusenmeyer.be", true },
  { "grusig-geil.ch", true },
  { "gruver.de", true },
  { "gruwa.net", true },
  { "gs1pt.org", true },
  { "gs93.de", true },
  { "gsaj114.net", true },
  { "gscloud.xyz", true },
  { "gsi-network.com", true },
  { "gsimagebank.co.uk", true },
  { "gslink.me", true },
  { "gsmsecurity.net", true },
  { "gsoc.se", true },
  { "gsrc.io", true },
  { "gst.name", true },
  { "gst.priv.at", true },
  { "gt-mp.net", true },
  { "gt-network.de", true },
  { "gta-arabs.com", true },
  { "gtaforum.nl", true },
  { "gtdgo.com", false },
  { "gtlaun.ch", true },
  { "gtlfsonlinepay.com", true },
  { "gtmetrix.com", true },
  { "gtn-pravda.ru", true },
  { "gtoepfer.de", true },
  { "gtopala.com", true },
  { "gtopala.net", true },
  { "gtour.info", false },
  { "gtravers-basketmaker.co.uk", true },
  { "gtxbbs.com", true },
  { "gtxmail.de", true },
  { "guadagnare.info", true },
  { "guadalgrass.com", true },
  { "guanyembadalona.org", true },
  { "guanzhong.ca", true },
  { "guardian360.nl", true },
  { "guardianportal.us", true },
  { "guardianproject.info", true },
  { "gubagoo.com", true },
  { "gubagoo.io", true },
  { "gudini.net", true },
  { "gudrunfit.dk", true },
  { "guegan.de", true },
  { "guenthereder.at", true },
  { "guenthernoack.de", true },
  { "guerard.info", true },
  { "guerrilla.technology", true },
  { "guesthouse-namaste.com", true },
  { "guevener.de", true },
  { "gueze-ardeche.fr", true },
  { "gueze-sas.fr", true },
  { "guffr.it", true },
  { "guge.ch", true },
  { "guhenry3.tk", true },
  { "guiacidade.com.br", true },
  { "guiadamassagem.site", true },
  { "guiaextra.com", true },
  { "guiaswow.com", true },
  { "guichet-entreprises.fr", true },
  { "guichet-qualifications.fr", true },
  { "guid2steamid.com", true },
  { "guid2steamid.pw", true },
  { "guida.org", true },
  { "guide-peche-cantal.com", true },
  { "guidebook.co.tz", true },
  { "guidedsteps.com", true },
  { "guideline.gov", false },
  { "guidelines.gov", false },
  { "guideo.ch", true },
  { "guidepointsecurity.com", true },
  { "guidesacademe.com", true },
  { "guidetoiceland.is", false },
  { "guildbase.de", true },
  { "guildofmusicsupervisors.co.uk", true },
  { "guillaume-briand.fr", true },
  { "guillaumeperrin.io", true },
  { "guillemaud.me", false },
  { "guim.co.uk", true },
  { "guineapigmustach.es", true },
  { "guitarvolume.com", true },
  { "gulchuk.com", true },
  { "gulfstream.ru", true },
  { "gulshankumar.net", true },
  { "gume4you.com", true },
  { "gumeyamall.jp", true },
  { "gumi.ca", true },
  { "gummientchen.net", true },
  { "gunauc.net", true },
  { "gunbrig.com", true },
  { "gunn.ee", true },
  { "gunwatch.co.uk", true },
  { "gunworld.com.au", true },
  { "gunz.net", true },
  { "guochang.xyz", true },
  { "guodong.net", true },
  { "guohuageng.com", true },
  { "guoke.com", true },
  { "guolaw.ca", true },
  { "guoliang.me", true },
  { "guozeyu.com", true },
  { "gupfen.ch", true },
  { "guphi.net", false },
  { "gurkan.in", true },
  { "gurmel.ru", true },
  { "gurpusmaximus.com", true },
  { "guru-naradi.cz", true },
  { "gurucomi.com", true },
  { "gurueffect.com", true },
  { "gurunpa.com", true },
  { "gururi.com", true },
  { "gus.host", true },
  { "gustaff.de", true },
  { "gut8er.com.de", true },
  { "gutools.co.uk", true },
  { "guts.me", true },
  { "guts.moe", true },
  { "gutschein-spezialist.de", true },
  { "gutscheingeiz.de", true },
  { "guus-thijssen.nl", true },
  { "guusvandewal.nl", true },
  { "guyeskens.be", true },
  { "guysauto.com", true },
  { "guytarrant.co.uk", true },
  { "gv-neumann.de", true },
  { "gv-salto.nl", true },
  { "gvatas.in", true },
  { "gvc-it.tk", true },
  { "gveh.de", true },
  { "gvi-timing.ch", true },
  { "gvitiming.ch", true },
  { "gvobgyn.ca", true },
  { "gvoetbaldagenalcides.nl", true },
  { "gvt2.com", true },
  { "gvt3.com", true },
  { "gvwgroup.cloud", true },
  { "gvwgroup.com", true },
  { "gw2efficiency.com", true },
  { "gw2treasures.com", true },
  { "gw2zone.net", true },
  { "gwerder.net", true },
  { "gwhois.org", true },
  { "gwilken.com", true },
  { "gwo24.pl", true },
  { "gwrtech.com", true },
  { "gwsec.co.uk", true },
  { "gwynfryncottages.com", true },
  { "gxmyqy.net", true },
  { "gyas.nl", true },
  { "gymagine.ch", true },
  { "gymbunny.de", true },
  { "gymhero.me", true },
  { "gymjp.com", true },
  { "gymkirchenfeld.ch", true },
  { "gymnaserenens.ch", true },
  { "gymnasium-hittfeld.de", true },
  { "gympap.de", true },
  { "gynaecology.co", true },
  { "gynoguide.com", true },
  { "gyoza.beer", true },
  { "gypsyreel.com", true },
  { "gyre.ch", true },
  { "gyrenens.ch", true },
  { "gyu-raku.jp", true },
  { "gyulakerezsi.ro", true },
  { "gz-architekten.de", true },
  { "gz-benz.com", true },
  { "gz-bmw.com", true },
  { "gza.jp", true },
  { "gzom.ru", true },
  { "gzriedstadt.de", true },
  { "h-ealthy.net", true },
  { "h-jo.net", true },
  { "h001.ru", true },
  { "h09.eu", true },
  { "h10l.com", true },
  { "h11.io", false },
  { "h1ctf.com", true },
  { "h1z1swap.com", true },
  { "h24.org", true },
  { "h2b.me", true },
  { "h2rul.eu", true },
  { "h2s-design.de", true },
  { "h2u.tv", true },
  { "h3artbl33d.nl", true },
  { "h3b.nl", true },
  { "h3x.net", true },
  { "h3z.jp", true },
  { "h404bi.com", true },
  { "h5197.co", true },
  { "h6729.co", true },
  { "h6729.com", true },
  { "h6957.co", true },
  { "h9297.co", true },
  { "h9397.com", true },
  { "h9728.co", true },
  { "ha-kunamatata.de", true },
  { "ha.com", true },
  { "ha3.eu", true },
  { "ha6.ru", true },
  { "haaksmadehaanuitvaart.nl", true },
  { "haarigerrattenarsch.com", true },
  { "haarlemsesaxofoonschool.nl", true },
  { "haarstudiok99.nl", true },
  { "haavard.me", true },
  { "haazen.xyz", true },
  { "habarisoft.com", true },
  { "haberer.me", true },
  { "habitat-domotique.fr", true },
  { "habr.com", true },
  { "habtium.es", true },
  { "hacc.top", true },
  { "haccp.bergamo.it", true },
  { "haccp.milano.it", true },
  { "haccp.roma.it", true },
  { "hacertest.com", true },
  { "hacettepeteknokent.com.tr", true },
  { "hachre.de", false },
  { "hack.club", true },
  { "hackademix.net", true },
  { "hackadena.com", true },
  { "hackanders.com", true },
  { "hackattack.com", true },
  { "hackbarth.guru", true },
  { "hackbeil.name", true },
  { "hackcraft.net", true },
  { "hackdown.org", true },
  { "hackendoz.com", true },
  { "hackenkunjeleren.nl", true },
  { "hackenturet.dk", true },
  { "hacker.club", true },
  { "hacker.holiday", true },
  { "hacker.im", true },
  { "hacker.one", true },
  { "hacker.parts", true },
  { "hacker1.com", true },
  { "hacker101.com", true },
  { "hacker8.cn", false },
  { "hackerchai.com", true },
  { "hackereyes.com", true },
  { "hackergateway.com", true },
  { "hackernet.se", true },
  { "hackerone-ext-content.com", true },
  { "hackerone-user-content.com", true },
  { "hackerone.at", true },
  { "hackerone.blog", true },
  { "hackerone.com", true },
  { "hackerone.events", true },
  { "hackerone.net", true },
  { "hackerone.org", true },
  { "hackerschat.net", true },
  { "hackgins.com", true },
  { "hackhouse.sh", true },
  { "hackingand.coffee", false },
  { "hackingdh.com", true },
  { "hackingondemand.com", true },
  { "hackmd.io", true },
  { "hackmeimfamo.us", true },
  { "hackreone.com", true },
  { "hacksoc.co.uk", true },
  { "hackthissite.org", true },
  { "hacktivis.me", true },
  { "hacktober.dk", true },
  { "hackworx.com", false },
  { "hadaly.fr", true },
  { "hadleighswimmingclub.co.uk", true },
  { "hadouk.in", true },
  { "hadrons.org", true },
  { "hady.fr", true },
  { "haeckdesign.com", true },
  { "haefligermedia.ch", true },
  { "haemka.de", true },
  { "haens.li", true },
  { "haerwu.biz", true },
  { "haferman.net", true },
  { "haferman.org", true },
  { "hafniatimes.com", true },
  { "hag27.com", true },
  { "haggeluring.su", true },
  { "hagiati.gr", true },
  { "hagier.pl", true },
  { "hagskold.se", true },
  { "hagueaustralia.com.au", true },
  { "haha-raku.com", true },
  { "haha.nl", true },
  { "hahay.es", true },
  { "haibara.top", true },
  { "haiboxu.com", true },
  { "hailer.com", true },
  { "hailstorm.nl", true },
  { "haim.bio", true },
  { "haimablog.ooo", true },
  { "haircrazy.com", true },
  { "hairplaybychenellekay.com", false },
  { "hairraisingphotobooths.co.uk", true },
  { "hairtonic-lab.com", true },
  { "haixihui.cn", true },
  { "hajekdavid.cz", true },
  { "hajekj.com", true },
  { "hajekj.cz", true },
  { "hajekj.net", true },
  { "haju.fi", true },
  { "haka.se", true },
  { "hakaru.org", true },
  { "hakase.pw", true },
  { "hakatabijin-mind.com", true },
  { "hake.me", true },
  { "hakkasannightclub.com", true },
  { "hakurei.moe", true },
  { "halacs.hu", true },
  { "halbich.design", true },
  { "haleo.net", true },
  { "half.host", true },
  { "halfhosting.de", true },
  { "halihali.cc", true },
  { "halihali.tv", true },
  { "halitopuroprodutos.com.br", true },
  { "halkirkbouncycastles.co.uk", true },
  { "hallelujahsoftware.com", true },
  { "halletienne.fr", true },
  { "hallhuber.com", true },
  { "halliday.work", true },
  { "halligladen.de", true },
  { "hallmarkestates.ca", true },
  { "hallucinogen.com", true },
  { "hallucinogens.org", true },
  { "halo.fr", true },
  { "halocredit.pl", true },
  { "haloobaloo.com", true },
  { "haloria.com", true },
  { "haltegame.com", true },
  { "halyul.com", true },
  { "hamacho-kyudo.com", true },
  { "hamali.bg", true },
  { "hambassadors.org", true },
  { "hamburg40grad.de", true },
  { "hamburgerbesteld.nl", true },
  { "hamburgobgyn.com", true },
  { "hamcocc.com", true },
  { "hamcram.io", true },
  { "hamiltonlinen.com", true },
  { "hamiltonmedical.nl", true },
  { "hamiltonweather.ca", true },
  { "hammer-schnaps.com", true },
  { "hammer-sms.com", true },
  { "hampl.tv", true },
  { "hampshiretechservices.co.uk", true },
  { "hana.ondemand.com", true },
  { "hanakaraku.com", true },
  { "hanakatova.com", true },
  { "hanazono.tokyo", true },
  { "hanbing.it", true },
  { "handbrake.fr", true },
  { "handcraft.eu.org", true },
  { "handgelenkbandage-test.de", true },
  { "handknit.com.np", true },
  { "handlecoin.com", true },
  { "handleidingkwijt.com", true },
  { "handmade-workshop.de", true },
  { "handmadehechoamano.com", true },
  { "handy-center.net", true },
  { "handy-reparatur-berlin.com", true },
  { "handymanlondonplease.co.uk", true },
  { "handynummer-info.ch", true },
  { "handynummer.online", true },
  { "handysex.live", true },
  { "handyticket.de", true },
  { "hanfox.co.uk", false },
  { "hanfverband-erfurt.de", true },
  { "hang333.moe", true },
  { "hangar.hosting", true },
  { "hangcapnach.com", true },
  { "hangerphant.com", true },
  { "hangout", true },
  { "hangouts.google.com", true },
  { "hangtenseo.com", true },
  { "hangw.xyz", true },
  { "hanjuapp.com", true },
  { "hankr.com", true },
  { "hanksacservice.com", true },
  { "hannah.link", true },
  { "hannahi.com", true },
  { "hannasecret.de", true },
  { "hannoluteijn.nl", true },
  { "hannover.de", true },
  { "hannywbarek.com", true },
  { "hanpenblog.com", true },
  { "hansahome.ddns.net", true },
  { "hansashop.eu", true },
  { "hansashop.fi", true },
  { "hansbijster.nl", true },
  { "hanschventures.com", true },
  { "hansen-kronshagen.de", true },
  { "hansen.hn", true },
  { "hansgoes.it", true },
  { "hansgoes.nl", true },
  { "hansgoesit.nl", true },
  { "hansminten.com", true },
  { "hansmund.com", true },
  { "hansolrella.com", true },
  { "hansonian.com", true },
  { "hansvaneijsden.com", true },
  { "hansvaneijsden.nl", true },
  { "hantse.com", true },
  { "hanu.la", true },
  { "hanyibo.com", true },
  { "hanzubon.jp", true },
  { "hao-zhang.com", true },
  { "haogoodair.ca", true },
  { "haoqi.men", true },
  { "haorenka.org", true },
  { "haozhang.org", true },
  { "hapheemraadssingel.nl", true },
  { "hapimiennam.com", true },
  { "haplogroup.org", true },
  { "happist.com", true },
  { "happy-baby.info", true },
  { "happy-life-food.de", true },
  { "happyagain.de", true },
  { "happyagain.se", true },
  { "happyandrelaxeddogs.eu", true },
  { "happybirthdaywisher.com", true },
  { "happybounce.co.uk", true },
  { "happycarb.de", true },
  { "happychat.io", true },
  { "happychungus.tk", true },
  { "happycoder.net", true },
  { "happydietplan.com", true },
  { "happydoq.ch", true },
  { "happygadget.me", true },
  { "happykidscastles.co.uk", true },
  { "happylifestyle.com", true },
  { "happyschnapper.com", true },
  { "happyteamlabs.com", true },
  { "happyukgo.com", true },
  { "hapsana.nl", true },
  { "haptemic.com", true },
  { "haraj.com.sa", true },
  { "harald-d.dyndns.org", true },
  { "harald-pfeiffer.de", true },
  { "harapecorita.com", true },
  { "harbor-light.net", true },
  { "hardeman.nu", true },
  { "hardenize.com", true },
  { "hardergayporn.com", true },
  { "hardertimes.com", true },
  { "hardesec.com", true },
  { "hardez.de", false },
  { "hardfalcon.net", true },
  { "hardforum.com", true },
  { "hardh.at", true },
  { "hardhat.io", true },
  { "hardrain980.com", true },
  { "hardtfrieden.de", true },
  { "hardwareschotte.de", true },
  { "harelmallac.com", true },
  { "harelmallacglobal.com", true },
  { "haribilalic.com", true },
  { "harilova.fr", true },
  { "harion.fr", true },
  { "harisht.me", false },
  { "harititan.com", true },
  { "harjitbhogal.com", true },
  { "harlor.de", true },
  { "harmfarm.nl", true },
  { "harmoney.co.nz", true },
  { "harmoney.com", true },
  { "harmoney.com.au", true },
  { "harmonyplace.com", true },
  { "harms.io", true },
  { "harmsboone.org", true },
  { "harnov.dk", true },
  { "haroldsharpe.com", true },
  { "harp.gov", true },
  { "harpoo.jp", true },
  { "harrcostl.com", true },
  { "harringtonca.com", true },
  { "harrisconsulting.ie", true },
  { "harrisonswebsites.com", true },
  { "harrygerritstransport.nl", true },
  { "harrymclaren.co.uk", true },
  { "harrysgardengamehire.co.uk", true },
  { "harrysmallbones.co.uk", true },
  { "harrysqnc.co.uk", true },
  { "harschnitz.nl", false },
  { "hartie95.de", true },
  { "hartkampforkids.nl", true },
  { "hartlep.email", true },
  { "hartlieb.me", true },
  { "hartzer.com", true },
  { "haruhi.org.ua", true },
  { "harukakikuchi.com", true },
  { "harukawa.moe", true },
  { "haruue.moe", true },
  { "harvarddharma.org", true },
  { "harvestapp.com", true },
  { "harvester.fr", true },
  { "harveyauzorst.com", true },
  { "harveyplum.com", true },
  { "harveysautoservice.net", true },
  { "has-no-email-set.de", false },
  { "has.work", true },
  { "haschrebellen.de", true },
  { "hasdf.de", true },
  { "hasecuritysolutions.com", true },
  { "haselsteiner.me", true },
  { "hash-archive.org", true },
  { "hash.army", true },
  { "hash.works", true },
  { "hashcashconsultants.com", true },
  { "hashcat.net", true },
  { "hashemian.com", true },
  { "hashes.org", true },
  { "hashi.dk", true },
  { "hashicorp.com", true },
  { "hashimah.ca", true },
  { "hashimoto-jimusho.com", true },
  { "hashinteractive.com", true },
  { "hashish.net", true },
  { "hashiura.jp", true },
  { "hashnode.com", true },
  { "hashru.nl", true },
  { "hashtagpatriot.com", true },
  { "hashworks.net", true },
  { "hashxp.org", true },
  { "hasilocke.de", true },
  { "haskett.ca", true },
  { "haskovec.com", true },
  { "hasselbach-dellwig.de", true },
  { "hatarisecurity.co.ke", true },
  { "hatcher.cloud", true },
  { "hatpakha.com", true },
  { "hatter.ink", true },
  { "hatul.info", true },
  { "haucke.xyz", true },
  { "hauller.ch", true },
  { "hauntedfieldsofglory.com", true },
  { "hauntedhouserecords.co.uk", true },
  { "hauora.fyi", true },
  { "haus-garten-test.de", true },
  { "haus-henne.de", true },
  { "haus-zeitlos.de", true },
  { "hausarztpraxis-linn.de", true },
  { "haushaltsaufloesunghannover.de", true },
  { "haushenne.de", true },
  { "hausjugo.de", true },
  { "haustechnik-breu.de", true },
  { "haustechnik-schulte-sanitaer-heizung-klima.de", true },
  { "hausundhof.com", true },
  { "hausverbrauch.de", true },
  { "hautaka.com", true },
  { "hautarztzentrum.ch", true },
  { "hauteslatitudes.com", true },
  { "havarijna-sluzba-bratislava.sk", true },
  { "havasigabor.hu", true },
  { "havasuinsurance.com", true },
  { "have.jp", true },
  { "haveabounce.co.uk", true },
  { "haveacry.com", true },
  { "haveforeningen-enghaven.dk", true },
  { "havefunbiking.com", true },
  { "haveibeenpwned.com", true },
  { "havellab.de", true },
  { "havelland-obstler.de", true },
  { "havencyber.com", true },
  { "havenstrategies.com", true },
  { "havernbenefits.com", true },
  { "haverstack.com", true },
  { "havetherelationshipyouwant.com", true },
  { "hawaar.com", true },
  { "hawaiianchoice.com", true },
  { "hawaiioceanproject.com", true },
  { "hawkeyeinsight.com", true },
  { "hawkinsonkiaparts.com", true },
  { "hawkofgeorgia.com", true },
  { "hawkon.dk", true },
  { "hawksguild.com", true },
  { "hawksracing.de", true },
  { "hax.to", true },
  { "haxdroid.com", true },
  { "haxo.nl", false },
  { "hayai.space", true },
  { "hayashi-rin.net", true },
  { "haydenjames.io", true },
  { "hayfordoleary.com", true },
  { "haynes-davis.com", true },
  { "haystack-staging.com", true },
  { "hayvid.com", true },
  { "haz.cat", true },
  { "haze.productions", true },
  { "hazeltime.com", true },
  { "hazeover.com", true },
  { "hazloconlapix.com", true },
  { "hazukilab.com", true },
  { "hb5197.com", false },
  { "hb6729.com", true },
  { "hb8522.com", true },
  { "hb9397.com", true },
  { "hbcu-colleges.com", true },
  { "hbkonsult.com", true },
  { "hboeck.de", true },
  { "hbpowell.com", true },
  { "hcbj.io", true },
  { "hcie.pl", false },
  { "hcscrusaders.com", true },
  { "hd-gaming.com", true },
  { "hd-offensive.at", false },
  { "hd-only.org", true },
  { "hd-outillage.com", true },
  { "hd5197.com", false },
  { "hd6729.com", true },
  { "hd9397.com", true },
  { "hd9721.com", true },
  { "hdc.cz", true },
  { "hdcamvids.com", true },
  { "hdcenter.cc", true },
  { "hddrecovery.net.au", true },
  { "hdeaves.uk", true },
  { "hdf.world", true },
  { "hdfgroup.org", true },
  { "hdguru.com", true },
  { "hdhoang.space", true },
  { "hdkandsons.com", true },
  { "hdnastudio.com", true },
  { "hdritalyphotos.com", true },
  { "hdrsource.com", true },
  { "hdrtranscon.com", true },
  { "hds-lan.de", true },
  { "hdtwinks.com", true },
  { "hdv.paris", true },
  { "hdwallpapers.net", true },
  { "heaaart.com", true },
  { "head.org", true },
  { "head.ru", true },
  { "headforcloud.com", true },
  { "headjapan.com", true },
  { "headlinepublishing.be", true },
  { "headlinesclub.com", true },
  { "headshotharp.de", true },
  { "healike.hk", true },
  { "healingourskin.com", true },
  { "health-booster.com", false },
  { "health-iq.com.au", true },
  { "health-plan-news.com", true },
  { "health.gov", true },
  { "health.graphics", true },
  { "healthand-beautynews.net", true },
  { "healthandskinbeauty.com", true },
  { "healthcare.gov", false },
  { "healthcultureexpo.com", true },
  { "healthdata.gov", true },
  { "healtheffectsofasbestos.com", true },
  { "healthery.com", true },
  { "healthfinder.gov", true },
  { "healthfoam.com", true },
  { "healthgames.co.uk", true },
  { "healthiercompany.com", true },
  { "healthiergenerations.co.uk", true },
  { "healthit.gov", true },
  { "healthplansamerica.org", true },
  { "healthstar-dev.io", true },
  { "healthstar.io", true },
  { "healththoroughfare.com", true },
  { "healthy-map.com", true },
  { "healthybeterlife.click", true },
  { "healthyfitfood.com", true },
  { "healthypeople.gov", true },
  { "healthyrecharge.com", true },
  { "healthyspirituality.org", true },
  { "healthysuperhuman.com", true },
  { "healthyteame.com", true },
  { "heap.zone", true },
  { "heapkeeper.org", true },
  { "hearmeraw.uk", true },
  { "heartcomms.com.au", true },
  { "heartlandbiomed.com", true },
  { "heartmdinstitute.com", true },
  { "heartsintrueharmony.com", true },
  { "hearttruth.gov", true },
  { "heartview.com.br", true },
  { "heartwoodart.com", true },
  { "hearty.ga", true },
  { "hearty.gq", true },
  { "hearty.me", true },
  { "hearty.ml", true },
  { "hearty.ooo", true },
  { "hearty.tw", true },
  { "heartyapp.tw", true },
  { "heartycraft.com", true },
  { "heatershop.co.uk", true },
  { "heatingandairconditioningdallastx.com", true },
  { "heatingpartswarehouse.co.uk", true },
  { "heaven.moe", true },
  { "heavensattic.co.uk", true },
  { "heavensinferno.net", true },
  { "heavyequipments.org", true },
  { "heayao.com", true },
  { "hebamme-cranio.ch", true },
  { "hebikhiv.nl", true },
  { "hebingying.cn", true },
  { "hebocon.nl", true },
  { "hec-espace-entreprise.ch", true },
  { "hec.global", true },
  { "heckelektro.de", true },
  { "heckerundknopp.de", true },
  { "heddoun.com", true },
  { "hedge.fi", true },
  { "hedgeschool.ie", true },
  { "hedonism.org", true },
  { "hedonistic-imperative.com", true },
  { "hedonistic.org", true },
  { "hedonium.com", true },
  { "hedweb.co.uk", true },
  { "hedweb.com", true },
  { "hedweb.net", true },
  { "hedweb.org", true },
  { "heello.es", true },
  { "hefengautoparts.com", true },
  { "heftkaufen.de", true },
  { "hegen.com.pl", false },
  { "hegen.cz", false },
  { "hegen.sk", false },
  { "hegenshop.de", true },
  { "heh.ee", true },
  { "heha.co", false },
  { "heiaheia.com", true },
  { "heid.ws", true },
  { "heidisheroes.org", true },
  { "heighton.com.au", true },
  { "heijblok.com", true },
  { "heijdel.nl", true },
  { "heikegastmann.com", true },
  { "heikohessenkemper.de", true },
  { "heikorichter.name", true },
  { "heiland.io", true },
  { "heiliger-gral.info", true },
  { "heilpraxis-bgl.de", true },
  { "heimatverein-eitensheim.de", true },
  { "heimdallr.nl", true },
  { "heimonen.eu", true },
  { "heinemeier.dk", true },
  { "heino-peters.de", true },
  { "heinpost.nl", false },
  { "heinzelmann.co", true },
  { "heiraten-gardasee.de", true },
  { "heiraten-venedig.de", true },
  { "heissluft-fritteuse.com", true },
  { "heistheguy.com", true },
  { "heitepriem.info", true },
  { "heitland-it.de", true },
  { "heiwa-valve.co.jp", false },
  { "hejianpeng.cn", true },
  { "heka.ai", true },
  { "hektenkairez.com", true },
  { "helber-it-services.de", true },
  { "helden-spielen.de", true },
  { "heldenhalde.de", true },
  { "heldundsexgott.de", true },
  { "heleendebruyne.be", true },
  { "helenaknowledge.com", true },
  { "helenekurtz.com", true },
  { "helenkellersimulator.org", true },
  { "helensmithpr.co.uk", true },
  { "helfordriversc.co.uk", true },
  { "helichat.de", true },
  { "helifreak.club", true },
  { "helijobs.net", true },
  { "helikon.ro", true },
  { "helioanodyne.eu", true },
  { "helios4.com", true },
  { "heliosnet.com", true },
  { "heliosvoting.org", true },
  { "helix.am", true },
  { "hell.sh", true },
  { "hellenicagora.co.uk", true },
  { "hellenicmusicacademy.com", true },
  { "hellerarko.de", true },
  { "hellersgas.com", true },
  { "helles-koepfchen.de", true },
  { "helloacm.com", true },
  { "hellobrian.me", true },
  { "hellomedian.com", true },
  { "hellomookie.com", true },
  { "hellomouse.cf", true },
  { "hellomouse.net", true },
  { "hellovillam.com", true },
  { "helloworldhost.com", false },
  { "helloyemek.com", true },
  { "hellsgamers.pw", true },
  { "hellsh.com", true },
  { "helm-pokale.de", true },
  { "help.simpletax.ca", true },
  { "help207.xyz", true },
  { "helpconnect.com.au", true },
  { "helpmij.cf", true },
  { "helpscoutdocs.com", true },
  { "helpstarloja.com.br", true },
  { "helptasker.com", true },
  { "helptasker.net", true },
  { "helptasker.ru", true },
  { "helpwithadoption.com", true },
  { "helpwithinsomnia.org", true },
  { "helpwithmybank.gov", true },
  { "helsenorge.no", true },
  { "helserbrothers.com", true },
  { "helsinki.dating", true },
  { "helvella.de", true },
  { "hematoonkologia.pl", true },
  { "hemdal.se", true },
  { "hemkoll.nu", true },
  { "hemnet.se", true },
  { "hems.si", true },
  { "hemtest.com", true },
  { "hen.ne.ke", true },
  { "henchman.io", true },
  { "hendersonrealestatepros.com", true },
  { "hendersonvalleyautomotive.co.nz", true },
  { "hendric.us", false },
  { "hendrickx.be", true },
  { "hendrinortier.nl", true },
  { "hengroenet.de", true },
  { "hengstumone.com", true },
  { "henkboelman.com", true },
  { "henke-home.eu", true },
  { "henker.net", true },
  { "henkverlinde.com", false },
  { "henley-computer-repairs.co.uk", true },
  { "henleybouncycastles.co.uk", true },
  { "hennecke-forstbetrieb.de", true },
  { "henneke.me", true },
  { "hennes-haan.de", true },
  { "hennes-shop.de", true },
  { "hennies.org", true },
  { "henningkerstan.de", true },
  { "hennymerkel.com", true },
  { "henok.eu", true },
  { "henrik-bondtofte.dk", true },
  { "henriksen.is", true },
  { "henrikwelk.de", true },
  { "henrilammers.nl", true },
  { "henry.gg", true },
  { "henryocallaghan.com", true },
  { "henryphan.com", false },
  { "henrysautodetail.com", true },
  { "hentaipornography.com", true },
  { "hentaiz.net", true },
  { "hentschke-bau.de", true },
  { "hentschke-betonfertigteilwerk.de", true },
  { "hentschke-invest.de", true },
  { "henzenhoning.nl", true },
  { "heppler.net", true },
  { "heptafrogs.de", true },
  { "her25.com", false },
  { "heraldik-wiki.de", true },
  { "herba-belgie.be", true },
  { "herberichfamily.com", true },
  { "herbert.io", true },
  { "herbertjanvandinther.nl", true },
  { "herbhuang.com", true },
  { "herbolarigranvida.com", true },
  { "herbweb.net", true },
  { "herbweb.org", true },
  { "herds.eu", true },
  { "herdserv.de", true },
  { "herecsrymy.cz", true },
  { "heren.fashion", true },
  { "heretic-guild.com", true },
  { "heritagebaptistchurch.com.ph", true },
  { "heritagecoffee.co.uk", true },
  { "herkam.pl", true },
  { "hermanbrouwer.nl", true },
  { "hermes-net.de", true },
  { "herminghaus24.de", true },
  { "herni-kupony.cz", true },
  { "herocentral.de", true },
  { "heroco.xyz", true },
  { "herofil.es", true },
  { "herohirehq.co.uk", true },
  { "heroiclove.com", true },
  { "heroicpixel.com", true },
  { "heroku.com", true },
  { "heroku.ga", true },
  { "heroliker.com", true },
  { "heromuster.com", true },
  { "herpes-no.com", true },
  { "herranzramia.com", false },
  { "herrderzeit.de", true },
  { "herrenmuehle-wein.de", true },
  { "herrfirm.com", true },
  { "herringboneeats.com", true },
  { "herringsresidence.be", true },
  { "herrkaschke.com", true },
  { "herrsmith.com", true },
  { "herrtxbias.net", false },
  { "hersdorf-eifel.de", true },
  { "hertsbouncycastles.com", true },
  { "hertz.bj", true },
  { "herzbotschaft.de", true },
  { "herzfuersoziales.at", true },
  { "herzig.cc", true },
  { "herzogglass.com", true },
  { "herzwacht.de", true },
  { "hesaplama.net", true },
  { "hesslag.com", true },
  { "hestervanderheijden.nl", true },
  { "hestia-systeme.be", true },
  { "hestia-systeme.com", true },
  { "hestia-systeme.eu", true },
  { "hestia-systeme.fr", true },
  { "hesyifei.com", true },
  { "hetene.nl", true },
  { "hethely.ch", true },
  { "hetluisterbos.be", true },
  { "hetmer.cz", true },
  { "hetushu.com", true },
  { "heute-kaufen.de", true },
  { "heute.training", true },
  { "heutger.net", true },
  { "hevertonfreitas.com.br", true },
  { "hexagon-e.com", true },
  { "hexapt.com", true },
  { "hexcode.in", true },
  { "hexed.it", true },
  { "hexiaohu.cn", true },
  { "hexicurity.com", true },
  { "hexo.io", false },
  { "hexony.com", true },
  { "hexr.org", true },
  { "hexstream.net", true },
  { "hexstream.xyz", true },
  { "hexstreamsoft.com", true },
  { "hexxagon.com", true },
  { "heywood.cloud", true },
  { "hf51.nl", true },
  { "hfox.org", true },
  { "hg.gg", true },
  { "hg.python.org", true },
  { "hg0086.la", true },
  { "hg170.cc", true },
  { "hgbet.com", true },
  { "hghanbarimd.com", true },
  { "hgpowerglue.nl", true },
  { "hguandl.com", true },
  { "hgvnet.de", true },
  { "hgw168.com", true },
  { "hgw777.cc", true },
  { "hh-medic.com", true },
  { "hh-wolke.dedyn.io", true },
  { "hh5197.co", true },
  { "hh6729.co", true },
  { "hh6729.com", true },
  { "hh6957.co", true },
  { "hh9297.co", true },
  { "hh9397.com", true },
  { "hh9721.com", true },
  { "hh9728.co", true },
  { "hhgdo.de", true },
  { "hhh1080.com", true },
  { "hhhdb.com", true },
  { "hhidr.org", true },
  { "hhmmmm.de", true },
  { "hhs.gov", true },
  { "hhtoners.com.br", true },
  { "hhuitvaart.nl", true },
  { "hibari.moe", true },
  { "hiccupsandjuice.co.uk", true },
  { "hickorywinecellar.com", true },
  { "hicl.org", true },
  { "hicoria.com", true },
  { "hicts.nl", true },
  { "hiczp.com", true },
  { "hidbo.de", true },
  { "hiddendepth.ie", true },
  { "hiddenhillselectric.com", true },
  { "hiddenhillselectrical.com", true },
  { "hiddenhillselectrician.com", true },
  { "hiddenhillsexteriorlighting.com", true },
  { "hiddenhillslandscapelighting.com", true },
  { "hiddenhillslighting.com", true },
  { "hiddenhillsoutdoorlighting.com", true },
  { "hiddenmalta.net", true },
  { "hideallip.com", true },
  { "hideo54.com", true },
  { "hideouswebsite.com", true },
  { "hidroshop.com.br", true },
  { "hidroshoping.com.br", true },
  { "hidupnomad.com", true },
  { "hielscher.com", true },
  { "hieu.com.au", true },
  { "hiffo.de", true },
  { "higgstools.org", true },
  { "highair.net", true },
  { "highdesertroboticsurgery.com", true },
  { "higherpress.org", true },
  { "highkick.jp", true },
  { "highlatitudestravel.com", true },
  { "highlegshop.com", true },
  { "highlevelwoodlands.com", true },
  { "highlightsfootball.com", true },
  { "highlnk.com", true },
  { "highspeed-arnsberg.de", true },
  { "highspeedinternet.my", true },
  { "hightimes.com", true },
  { "highwaytohoell.de", true },
  { "higilopocht.li", true },
  { "hiimodel.com", true },
  { "hik-cloud.com", true },
  { "hikawa.top", true },
  { "hike.pics", true },
  { "hikerone.com", true },
  { "hikinggearlab.com", true },
  { "hikingguy.com", true },
  { "hilahdih.cz", true },
  { "hilaryhutler.com", true },
  { "hilchenba.ch", true },
  { "hilde.link", true },
  { "hildebrand.group", true },
  { "hildegardis-schule.de", true },
  { "hilden.ws", true },
  { "hilfe-bei-krebs-vechta.de", true },
  { "hilfreiche-server.tips", true },
  { "hilhorst-uitvaartverzorging.nl", true },
  { "hillcrestswimclub.com", true },
  { "hillebrand.io", true },
  { "hillier-swift.co.uk", true },
  { "hillsandsaunders.co.uk", true },
  { "hillsandsaunders.com", true },
  { "hillsboroccpa.org", true },
  { "hillstrak.com.au", true },
  { "hillstrakwpg.com.au", true },
  { "hilltopcellar.com", true },
  { "hilnu.com", true },
  { "hiltonarubabeachservices.com", true },
  { "himecorazon.com", true },
  { "himekomi.com", true },
  { "himiku.com", true },
  { "hin10.com", true },
  { "hinaryazan.com", true },
  { "hinata-hidetoshi.com", true },
  { "hindimoviedownload.net", true },
  { "hindimovieonline.net", true },
  { "hingston.org", true },
  { "hinkel-sohn.de", true },
  { "hintergrundbewegung.de", true },
  { "hinterhofbu.de", true },
  { "hinterposemuckel.de", true },
  { "hiparish.org", true },
  { "hiphop.ren", true },
  { "hipnos.net", true },
  { "hippies.com.br", true },
  { "hippomovers.com", true },
  { "hippopotamuses.org", true },
  { "hips.com", true },
  { "hipstercat.fr", false },
  { "hiqfranchise.co.uk", true },
  { "hiqhub.co.uk", false },
  { "hiqonline.co.uk", true },
  { "hirakatakoyou.org", true },
  { "hirake55.com", true },
  { "hiratake.xyz", true },
  { "hire-a-coder.de", true },
  { "hireabouncycastle.net", true },
  { "hiresteve.ca", true },
  { "hirevets.gov", true },
  { "hirevo.eu", true },
  { "hirevue.com", true },
  { "hirezzportal.com", true },
  { "hiromuogawa.com", true },
  { "hirotaka.org", true },
  { "hirtzfr.eu", true },
  { "hirzaconsult.ro", true },
  { "hisbrucker.net", true },
  { "hisgifts.com.au", true },
  { "hisingensck.se", true },
  { "hisnet.de", true },
  { "hispanic.dating", true },
  { "hisregistries.com", true },
  { "hisregistries.net", true },
  { "hisregistries.org", true },
  { "histoire-cite.ch", true },
  { "historia-arte.com", true },
  { "historiasdepueblo.es", true },
  { "history-schools.com", true },
  { "history.google.com", false },
  { "history.gov", true },
  { "hitandhealth.nl", true },
  { "hitchpin.com", true },
  { "hitechgr.eu", true },
  { "hiteco.com", true },
  { "hiteshbrahmbhatt.com", true },
  { "hiteshchandwani.com", true },
  { "hitflow.fr", true },
  { "hititgunesi-tr.com", true },
  { "hitmanstat.us", true },
  { "hitn.at", true },
  { "hitoapi.cc", true },
  { "hitocom.net.br", true },
  { "hitokoto-mania.com", true },
  { "hitokoto.cn", false },
  { "hitomecha.com", true },
  { "hitrost.com", true },
  { "hitter-lauzon.com", true },
  { "hitter.family", true },
  { "hitterfamily.com", true },
  { "hiv-symptome.de", true },
  { "hiv.com.tw", true },
  { "hiv.gov", true },
  { "hivatalinfo.hu", true },
  { "hiverlune.net", true },
  { "hiwiki.tk", true },
  { "hiyacar.co.uk", true },
  { "hiyobi.me", true },
  { "hiyuki2578.net", false },
  { "hizzacked.xxx", true },
  { "hj-mosaiques.be", true },
  { "hj.rs", true },
  { "hjartasmarta.se", true },
  { "hjertingfysioterapi.dk", true },
  { "hjort.land", true },
  { "hjortland.org", true },
  { "hjphoto.co.uk", true },
  { "hjtky.cn", true },
  { "hk.search.yahoo.com", false },
  { "hkas.org.hk", true },
  { "hkbsurgery.com", true },
  { "hkdobrev.com", true },
  { "hkr.at", true },
  { "hks-projekt.at", true },
  { "hks.pw", true },
  { "hktech.com", true },
  { "hktkl.com", true },
  { "hkustmbajp.com", true },
  { "hlavacek.us", true },
  { "hlavi.hu", true },
  { "hledejlevne.cz", true },
  { "hlfh.space", true },
  { "hlidacnajemneho.cz", true },
  { "hlin.cloud", true },
  { "hlinformatics.nl", true },
  { "hloe0xff.ru", true },
  { "hlsmandarincentre.com", true },
  { "hlucas.de", true },
  { "hm773.net", true },
  { "hm773.org", true },
  { "hmcdj.cn", true },
  { "hmhotelec.com", false },
  { "hmnd.io", true },
  { "hmoegirl.com", true },
  { "hms-waldmann.de", true },
  { "hmsseahawk.com", true },
  { "hn.search.yahoo.com", false },
  { "hnfertilizermachine.com", true },
  { "hnn.net.br", true },
  { "hnonline.sk", true },
  { "hnrk.io", true },
  { "hnyp.hu", true },
  { "hoaas.no", true },
  { "hoahau.org", true },
  { "hoarding.me", true },
  { "hoathienthao.com", true },
  { "hoathienthao.vn", true },
  { "hobby-drechselei.de", true },
  { "hobbyspeed.com", true },
  { "hocassian.cn", true },
  { "hochdorf-tennis.de", true },
  { "hochhaus.us", true },
  { "hochoukikikiraku.com", true },
  { "hochyi.com", true },
  { "hochzeit-dana-laurens.de", true },
  { "hochzeitsfotograf-deinfoto.ch", true },
  { "hochzeitsgezwitscher.de", true },
  { "hochzeitsplanerin-hamburg.de", true },
  { "hockeyapp.ch", true },
  { "hockeymotion.ch", true },
  { "hodgephotography.com", true },
  { "hodnos.com", true },
  { "hoe.re", true },
  { "hoeft-autolackierung.de", true },
  { "hoekvanholland.eu", true },
  { "hoeren.club", true },
  { "hoesnelwasik.nl", true },
  { "hoevenstein.nl", false },
  { "hoewler.ch", true },
  { "hoezzi.nl", true },
  { "hof-mulin.ch", true },
  { "hofapp.de", true },
  { "hofauer.de", true },
  { "hoflerlawfirm.com", true },
  { "hogarthdavieslloyd.com", true },
  { "hoge.se", true },
  { "hogepad.com", true },
  { "hogl.dk", true },
  { "hogrebe.de", true },
  { "hogwarts.io", true },
  { "hohenleimbach.de", true },
  { "hohm.in", true },
  { "hoiquanadida.com", true },
  { "hoish.in", false },
  { "hoken-wakaru.jp", true },
  { "hokioisecurity.com", true },
  { "hokung.xyz", true },
  { "hokusya.com", true },
  { "holadinero.es", true },
  { "holadinero.mx", true },
  { "holboxwhalesharktours.com", false },
  { "holebedeljek.hu", true },
  { "holidayacademy.co.uk", true },
  { "holidaysportugal.eu", true },
  { "holisticacupuncture.com.au", true },
  { "holistichealer.in", true },
  { "holisticon.de", true },
  { "holland-sailing.de", true },
  { "hollandsdiep.nl", true },
  { "hollermann.eu", true },
  { "hollo.me", true },
  { "hollowpoint.xyz", true },
  { "hollowrap.com", true },
  { "hollowwinds.xyz", true },
  { "hollyforrest.ca", true },
  { "hollyforrestphotography.ca", true },
  { "holmesian.org", true },
  { "holo.ovh", true },
  { "holofono.com", true },
  { "holofox.ru", true },
  { "holoxplor.space", true },
  { "holvonix.com", true },
  { "holycrossphl.org", true },
  { "holycrossverobeach.org", true },
  { "holydragoon.jp", true },
  { "holyfamilyphilly.org", true },
  { "holyfamilyrussell.org", true },
  { "holyghost-church.org", true },
  { "holygrail.games", true },
  { "holyhiphopdatabase.com", true },
  { "holymartyrschurch.org", true },
  { "holyspiritpalmyra.com", true },
  { "holyspiritweb.org", true },
  { "holytransaction.com", true },
  { "holywhite.com", true },
  { "holz.nu", true },
  { "holzed.com", true },
  { "holzheizer-forum.de", true },
  { "holzheizerforum.de", true },
  { "holzschutz-holzbearbeitung.de", true },
  { "holzspielzeug-shop.ch", true },
  { "holzstueckwerk.de", true },
  { "holzundgarten.de", true },
  { "holzvergaser-forum.de", true },
  { "homatism.com", true },
  { "hombresconestilo.com", true },
  { "homebasedsalons.com.au", true },
  { "homebodyalberta.com", true },
  { "homecareassociatespa.com", true },
  { "homecheck.gr", true },
  { "homecompost.in", true },
  { "homeeducator.com", true },
  { "homefacialpro.com", false },
  { "homegardeningforum.com", true },
  { "homegardenresort.nl", true },
  { "homegreenmark.com", true },
  { "homehunting.pt", true },
  { "homeimagician.com.au", true },
  { "homelab.farm", true },
  { "homelabquotes.com", true },
  { "homeland.ie", true },
  { "homem-viril.com", true },
  { "homeodynamics.com", true },
  { "homeofjones.net", true },
  { "homeogenium.com", true },
  { "homeownersinsurancenevada.com", true },
  { "homeownersinsurancenv.com", true },
  { "homepage.shiga.jp", true },
  { "homeporn.stream", true },
  { "homeprivate.de", true },
  { "homeseller.com", true },
  { "homeserver-kp.de", true },
  { "homesteadandprepper.com", true },
  { "homesteadfarm.org", true },
  { "homewatt.co.uk", true },
  { "homeyou.com", true },
  { "hommeatoutfaire.be", true },
  { "homoo.social", true },
  { "homophoni.com", true },
  { "hompus.nl", false },
  { "homunyan.com", true },
  { "hon-matsuba.co.jp", true },
  { "honda-centrum.cz", true },
  { "hondart.cz", true },
  { "hondenoppasfraneker.nl", true },
  { "honey.beer", true },
  { "honey.is", true },
  { "honeybadger.io", false },
  { "honeycome.net", true },
  { "honeycreeper.com", true },
  { "honeyhaw.com", true },
  { "honeypot.net", true },
  { "hong.io", true },
  { "honglitrading.co.uk", true },
  { "hongoi.com", true },
  { "honigdealer.de", true },
  { "honkion.net", true },
  { "honoka-seitai.jp", true },
  { "honovere.de", true },
  { "hontoir.eu", true },
  { "hoodtrader.com", true },
  { "hoofddorp-centraal.nl", true },
  { "hoofdredacteuren.nl", true },
  { "hoogeveen.nl", true },
  { "hookany.com", true },
  { "hookbin.com", true },
  { "hookupndate.com", true },
  { "hookxlab.org", true },
  { "hoooc.com", true },
  { "hooowl.com", true },
  { "hoop.la", true },
  { "hoopertechnicalsolutions.com", true },
  { "hooplessinseattle.com", true },
  { "hooray.beer", true },
  { "hoorr.com", true },
  { "hoosa.de", true },
  { "hoovism.com", true },
  { "hoowhen.cn", true },
  { "hopconseils.ch", true },
  { "hopconseils.com", true },
  { "hope-line-earth.jp", true },
  { "hopecbd.com", true },
  { "hopemeet.me", true },
  { "hopesanddreams.org.uk", true },
  { "hopla.sg", true },
  { "hoplongtech.com", true },
  { "hopps.me", true },
  { "hoppyx.com", true },
  { "hopzone.net", true },
  { "horaceli.com", true },
  { "horackova.info", true },
  { "horairetrain.fr", true },
  { "hord.ca", true },
  { "horecaapparatuurkobezuijen.nl", true },
  { "horecatiger.eu", true },
  { "horeco.com", true },
  { "horeizai.net", true },
  { "horgenberg.com", true },
  { "horizonhomes-samui.com", true },
  { "horizonlawncare.tk", true },
  { "horizzon.cloud", true },
  { "horn.co", true },
  { "hornertranslations.com", true },
  { "horoca.net", true },
  { "horochx.org", true },
  { "horodance.dk", true },
  { "horrell.ca", true },
  { "horrendous-servers.com", true },
  { "horror-forum.de", true },
  { "horrormovies.gr", true },
  { "horsegateway.com", true },
  { "horsehunter.co.uk", true },
  { "horstmanshof.eu", true },
  { "horton-brasses.com", true },
  { "hory.me", true },
  { "horza.org", true },
  { "hoshimaq.com.br", true },
  { "hoshimaquinas.com.br", true },
  { "hoshinplan.com", true },
  { "hoshisato.com", true },
  { "hosiet.me", true },
  { "hosmussynergie.nl", false },
  { "hospitalhomelottery.org", true },
  { "hospitality-colleges.com", true },
  { "hostadvice.com", true },
  { "hostarea51.com", true },
  { "hostco.nl", true },
  { "hosteasy.nl", false },
  { "hostedcomments.com", true },
  { "hostedtalkgadget.google.com", true },
  { "hostfission.com", true },
  { "hostiberi.com", true },
  { "hostinecpodlipou.cz", true },
  { "hosting-swiss.ch", true },
  { "hostingactive.it", true },
  { "hostingalternative.com", false },
  { "hostinghelp.guru", true },
  { "hostinginnederland.nl", true },
  { "hostinglogin.net", true },
  { "hostingphp.ch", true },
  { "hostingpunt.be", true },
  { "hostingsams.com", true },
  { "hostingsolutions.cz", true },
  { "hostix.de", true },
  { "hostmark.pl", true },
  { "hostmijnpagina.nl", true },
  { "hostmodern.com.au", true },
  { "hostmywebsite.online", true },
  { "hosts.cf", true },
  { "hot-spa.ch", true },
  { "hotcandlestick.com", true },
  { "hotchillibox.com", true },
  { "hotcoin.io", true },
  { "hotel-alan.hr", true },
  { "hotel-kontorhaus-stralsund.de", true },
  { "hotel-kontorhaus.de", true },
  { "hotel-kronjuwel.de", true },
  { "hotel-le-vaisseau.ch", true },
  { "hotel-pension-sonnalp.eu", true },
  { "hotel-rosner.at", true },
  { "hotel-schiller.de", true },
  { "hotel1926.com.mt", true },
  { "hotelamgarnmarkt.at", false },
  { "hotelbonacabol.com", true },
  { "hotelbretagne.dk", true },
  { "hotelcoliber.pl", true },
  { "hotelelaphusabrac.com", true },
  { "hoteles4you.com", true },
  { "hotelflow.com.br", true },
  { "hotelident.de", true },
  { "hotelkaj.hr", true },
  { "hotelmap.com", true },
  { "hotelmarinaadria.com", true },
  { "hotelneptundalmatien.com", true },
  { "hotelpostaorvieto.it", true },
  { "hotels-insolites.com", true },
  { "hotels3d.com", true },
  { "hotels4teams.com", true },
  { "hotelsinbuxton.com", true },
  { "hotelsinformer.com", true },
  { "hotelsinncoventry.com", true },
  { "hotelsolinebrela.com", true },
  { "hotelvalena.com", true },
  { "hotelvillaluisa.de", true },
  { "hothbricks.com", true },
  { "hothiphopmusic.com", true },
  { "hotjuice.com", true },
  { "hotnewhiphop.com", true },
  { "hoton.in", true },
  { "hotornot.com", true },
  { "hotplate.co.nz", true },
  { "hottaro.com", true },
  { "hottheme.net", true },
  { "hotting.nl", true },
  { "hottubhirenewcastle.co.uk", true },
  { "hottubspasnewcastle.co.uk", true },
  { "hotwifer.com", true },
  { "houdremont-la-courneuve.info", true },
  { "houraiteahouse.net", true },
  { "house-sparrow.com", true },
  { "houseandgarden.co.uk", true },
  { "houseboydesigns.com", true },
  { "housekeeperlondon.co.uk", true },
  { "houselocal.co.uk", true },
  { "houseofherbs.gr", true },
  { "houseofhouston.com", true },
  { "houseofyee.com", true },
  { "houser.lu", true },
  { "housese.at", true },
  { "houstonapartmentinsiders.com", true },
  { "houstonauthorizedrepair.com", true },
  { "houstoncreditlaw.com", true },
  { "houstontxlocksmiths.com", true },
  { "houtinee.com", true },
  { "hoverboardbarato.com", true },
  { "how-old.info", true },
  { "how2dev.tools", true },
  { "howa-n.net", true },
  { "howardtyson.com", true },
  { "howbehealthy.com", true },
  { "howbigismybuilding.com", true },
  { "howellaccounts.co.uk", true },
  { "howesky.com", true },
  { "howgoodwasmysex.com", true },
  { "howieisawesome.com", true },
  { "howlongtobeatsteam.com", true },
  { "howmanymilesfrom.com", true },
  { "howsecureismypassword.net", true },
  { "howsmyssl.com", true },
  { "howsmytls.com", true },
  { "howson.me", true },
  { "howsyourhealth.org", true },
  { "howtogeek.com", true },
  { "howtogosolar.org", true },
  { "howtolaser.com", true },
  { "howtomovetheneedle.com", true },
  { "howtoteachviolin.com", true },
  { "howtotech.de", true },
  { "hoxo.fr", true },
  { "hozana.si", false },
  { "hp-work.net", true },
  { "hp42.de", true },
  { "hpac-portal.com", true },
  { "hpage.com", true },
  { "hpbn.co", true },
  { "hpisavageforum.com", true },
  { "hpkp-faq.de", true },
  { "hps.digital", true },
  { "hps.hu", true },
  { "hpsdigital.hu", true },
  { "hpvtimmerwerken.nl", true },
  { "hq77.ru", true },
  { "hqq.tv", true },
  { "hquest.pro.br", true },
  { "hqwebhosting.tk", false },
  { "hr-tech.shop", true },
  { "hr28.co.uk", true },
  { "hraesvelg.net", true },
  { "hrafnkellbaldurs.com", true },
  { "hranicka.cz", true },
  { "hrbanen.nl", true },
  { "hrbatypes.cz", true },
  { "hrbrt.nl", true },
  { "hrdns.de", false },
  { "hrebecek.cz", true },
  { "href.one", true },
  { "hreflang.info", true },
  { "hrjfeedstock.org", true },
  { "hrltech.com.br", true },
  { "hroling.nl", true },
  { "hroschyk.cz", true },
  { "hrsa.gov", true },
  { "hrtech.shop", true },
  { "hryniewski.net", true },
  { "hryx.net", true },
  { "hs-arbeitsschutz.de", true },
  { "hs-group.net", true },
  { "hs-umformtechnik.de", true },
  { "hsappstatic.net", true },
  { "hschen.top", false },
  { "hscorp.de", true },
  { "hsg-kreuzberg.de", true },
  { "hsivonen.com", true },
  { "hsivonen.fi", true },
  { "hsivonen.iki.fi", true },
  { "hsiwen.com", true },
  { "hsmr.cc", true },
  { "hsn-tsn.com", true },
  { "hsn.com", true },
  { "hspinc.ca", true },
  { "hsr.gov", false },
  { "hsts.eu", true },
  { "hsts.me", true },
  { "hsts.ovh", true },
  { "hstsfail.appspot.com", true },
  { "hstspreload.appspot.com", true },
  { "hstspreload.com", true },
  { "hstspreload.de", true },
  { "hstspreload.org", true },
  { "hsturan.com", true },
  { "hsuan.pw", false },
  { "hszemi.de", true },
  { "ht.mk", true },
  { "htaccessbook.com", true },
  { "htaps.com", true },
  { "htb.click", true },
  { "htdcomputer.vn", true },
  { "hte.ovh", true },
  { "hti.digital", true },
  { "htmanager.fr", true },
  { "htmdom.com", true },
  { "html.moe", true },
  { "html2gutenberg.com", true },
  { "html5.org", true },
  { "html5media.info", true },
  { "htmlacademy.ru", true },
  { "htmlvalidator.com", true },
  { "htmlyse.com", true },
  { "htmue.net", true },
  { "htmue.org", true },
  { "htsure.ma", true },
  { "http2.eu", true },
  { "http2.pro", true },
  { "https-rulesets.org", true },
  { "https.dk", true },
  { "https.jetzt", true },
  { "https4all.org", true },
  { "httpsalarm.com", true },
  { "httpsecured.net", true },
  { "httpsiseasy.com", true },
  { "httpsispisseasy.com", true },
  { "httpsnow.com", true },
  { "httpsnow.org", true },
  { "httpswatch.ca", true },
  { "httpswatch.com", true },
  { "hu.search.yahoo.com", false },
  { "huagati.com", true },
  { "huahinpropertylisting.com", true },
  { "hualao.co", true },
  { "huang-haitao.com", true },
  { "huang.nu", true },
  { "huangh.com", true },
  { "huangjiaint.com", true },
  { "huangjingjing.com", true },
  { "huangqifu.com", true },
  { "huangzenghao.cn", false },
  { "huaqian.art", true },
  { "huashan.co.uk", true },
  { "hub.org.ua", true },
  { "hub385.com", true },
  { "hubapi.com", true },
  { "hubbroker.com", true },
  { "hubchain.com", true },
  { "hubchain.com.br", true },
  { "hubchain.fr", true },
  { "hubchain.io", true },
  { "hubchain.org", true },
  { "huber-informatik.de", true },
  { "hubok.net", true },
  { "hubspot.com", true },
  { "huchet.me", true },
  { "hudebnibazarmixer.cz", true },
  { "hudobniny.net", true },
  { "hudrydum.cz", true },
  { "hudsonfaceandeye.com", true },
  { "huduser.gov", true },
  { "huendeleskopfhuette.de", true },
  { "huersch.com", true },
  { "hues-in-lee.de", true },
  { "huffduffer.com", true },
  { "hugh-dancy.com", true },
  { "hugi.is", true },
  { "huglen.info", true },
  { "hugo.pro", true },
  { "hugofs.com", true },
  { "hugolegrand.fr", true },
  { "hugolynx.fr", true },
  { "hugonote.ml", true },
  { "hugonote.ovh", true },
  { "hugovr.nl", true },
  { "huguesblanchard.paris", true },
  { "huguesditciles.com", true },
  { "huh.gdn", true },
  { "huh.today", false },
  { "huihui.moe", true },
  { "huininga.com", true },
  { "huininga.nl", true },
  { "huininga.org", true },
  { "huipc.com", true },
  { "huisartsenpraktijkheemraadssingel.nl", true },
  { "huisartsenpraktijksonmezer.nl", true },
  { "huisartsenpraktijkzonnehoed.nl", true },
  { "huisjeboompje-baby.nl", true },
  { "huislaw.com", true },
  { "huislijn.nl", true },
  { "huissier-vosges.com", true },
  { "huitaodang.com", true },
  { "huizenvlees.nl", true },
  { "hulaginswoodworking.com", true },
  { "hulet.tech", true },
  { "hulldevs.net", true },
  { "hulpbijmarketing.nl", true },
  { "hulpmiddelenshop.nl", true },
  { "human-clone.com", true },
  { "humanenrich.com", true },
  { "humanesources.com", true },
  { "humanity.com", true },
  { "humans.io", true },
  { "humanzee.com", true },
  { "humass.nl", true },
  { "humblebee.at", true },
  { "humblebee.be", true },
  { "humblebee.bg", true },
  { "humblebee.ch", true },
  { "humblebee.co.in", true },
  { "humblebee.co.uk", true },
  { "humblebee.com.mx", true },
  { "humblebee.com.ph", true },
  { "humblebee.cz", true },
  { "humblebee.dk", true },
  { "humblebee.eu", true },
  { "humblebee.foundation", true },
  { "humblebee.fr", true },
  { "humblebee.gr", true },
  { "humblebee.hu", true },
  { "humblebee.ie", true },
  { "humblebee.it", true },
  { "humblebee.me.uk", true },
  { "humblebee.nz", true },
  { "humblebee.pl", true },
  { "humblebee.uk", true },
  { "humblebee.us", true },
  { "humblebeeshop.ca", true },
  { "humblebeeshop.com.au", true },
  { "humbledot.com", true },
  { "humboldthomeguide.com", true },
  { "humboldtmfg.com", true },
  { "humeur.de", true },
  { "humexe.com", true },
  { "humio.com", true },
  { "hummingbird.services", true },
  { "hummy.tv", true },
  { "humpen.se", true },
  { "humppakone.com", true },
  { "hund.io", true },
  { "hundesport-psvhalle.de", true },
  { "hundeverwaltung.de", true },
  { "hundhausen.de", true },
  { "hundter.com", true },
  { "hunger.im", true },
  { "huniverse.co", true },
  { "hunqz.com", true },
  { "hunstoncanoeclub.co.uk", true },
  { "hunter-read.com", true },
  { "hunter.io", true },
  { "hunterkehoe.com", true },
  { "huntexpired.com", true },
  { "huntingdonbouncers.co.uk", true },
  { "huntingdonlifesciences.com", true },
  { "huntshomeinspections.com", false },
  { "huntsmansecurity.com", true },
  { "huntsvillecottage.ca", true },
  { "huoduan.com", true },
  { "huonit.com.au", true },
  { "huoqibaike.club", true },
  { "huoyankan.com", true },
  { "hup.hu", true },
  { "hurd.is", true },
  { "huren.nl", true },
  { "hurleyhomestead.com", true },
  { "huroji.com", true },
  { "hurtigtinternet.dk", true },
  { "husakbau.at", true },
  { "hushfile.it", true },
  { "husic.net", false },
  { "huskyeye.de", true },
  { "huskyinc.us", false },
  { "hussam.eu.org", true },
  { "hustlehope.com", true },
  { "huurwoordenaar.nl", true },
  { "huutonauru.net", true },
  { "huwcbjones.co.uk", true },
  { "huxcoconstruction.com", true },
  { "huxley.net", true },
  { "huynhviet.com", true },
  { "huyvu.nl", true },
  { "hvdbox.de", true },
  { "hvh.no", true },
  { "hvmk.nl", true },
  { "hvrint.de", true },
  { "hvtuananh.com", true },
  { "hwag-pb.de", true },
  { "hwlibre.com", true },
  { "hx53.de", true },
  { "hxp.io", true },
  { "hxsf.me", true },
  { "hxying.com", true },
  { "hy1.com", true },
  { "hybridworx.com", true },
  { "hybridworx.de", true },
  { "hybridworx.eu", true },
  { "hybridworx.net", true },
  { "hybridworx.org", true },
  { "hybrydowe-samochody.pl", true },
  { "hybula.com", true },
  { "hycken.com", true },
  { "hyckenberg.com", true },
  { "hyderabadonlinegifts.com", true },
  { "hydra.zone", true },
  { "hydracommunity.net", true },
  { "hydrante.ch", true },
  { "hydrazin.pw", true },
  { "hydro17.com", true },
  { "hydroagro.pl", true },
  { "hydrographicsocietybenelux.eu", true },
  { "hydronicheatingaustralia.com.au", true },
  { "hydrosnow.fr", true },
  { "hydroturbine.info", true },
  { "hydrozone.fr", true },
  { "hyec.jp", true },
  { "hygo.com", true },
  { "hyk.me", true },
  { "hylemorphica.org", true },
  { "hynek.me", true },
  { "hyparia.fr", true },
  { "hyparia.org", true },
  { "hype.ru", true },
  { "hypehost.net", false },
  { "hypemgmt.com", true },
  { "hyper-text.org", true },
  { "hyper.ai", true },
  { "hyper.lol", true },
  { "hyperactive.am", true },
  { "hyperalgesia.com", true },
  { "hyperautomotive.com.au", true },
  { "hyperbolic-mayonnaise-interceptor.ovh", true },
  { "hyperd.sh", true },
  { "hyperion.io", true },
  { "hyperreal.biz", true },
  { "hypersomnia.com", true },
  { "hyperstack.org", true },
  { "hyperthymia.com", true },
  { "hyphen.co.za", true },
  { "hyphenpda.co.za", true },
  { "hypnovir.us", true },
  { "hypotecnicentrum.cz", true },
  { "hypothecairelening.net", true },
  { "hypotheekbond.nl", true },
  { "hypothes.is", true },
  { "hypothesis.link", true },
  { "hypothyroidmom.com", true },
  { "hytale.com", true },
  { "hytzongxuan.com", true },
  { "hytzongxuan.top", true },
  { "hyundai.no", true },
  { "hyvanilmankampaamo.fi", true },
  { "hyvanolonterapia.fi", true },
  { "hyvinvointineuvoja.fi", true },
  { "hywlovexyc.info", true },
  { "hztgzz.com", true },
  { "i--b.com", true },
  { "i-aloks.ru", true },
  { "i-geld.de", true },
  { "i-hakul.net", true },
  { "i-hoz.ru", true },
  { "i-logic.co.jp", false },
  { "i-meto.com", true },
  { "i-office.com.vn", true },
  { "i-proswiss.com", true },
  { "i-red.info", true },
  { "i-sports.cz", true },
  { "i-stuff.site", true },
  { "i-telligence.de", true },
  { "i-verbi.it", true },
  { "i-voting.pl", true },
  { "i00.eu", true },
  { "i1314.gdn", true },
  { "i2b.ro", true },
  { "i2gether.org.uk", true },
  { "i2verify.com", true },
  { "i5197.co", true },
  { "i5y.co.uk", true },
  { "i5y.org", true },
  { "i6729.co", true },
  { "i6729.com", true },
  { "i6957.co", true },
  { "i879.com", true },
  { "i8cp.com", true },
  { "i9297.co", true },
  { "i9397.com", true },
  { "i95.me", false },
  { "i9721.com", true },
  { "i9728.co", true },
  { "i9s.in", true },
  { "ia.cafe", true },
  { "ia.net", true },
  { "iaco.li", true },
  { "iactu.info", true },
  { "iaeste.no", true },
  { "iaeste.or.jp", true },
  { "iaf.gov", true },
  { "iahemobile.net", true },
  { "iainsimms.co.uk", true },
  { "iainsimms.com", true },
  { "iainsimms.me", true },
  { "iaitouzi.com", true },
  { "ialis.me", true },
  { "iam.lc", true },
  { "iam.soy", true },
  { "iamanewme.com", true },
  { "iambozboz.co.uk", true },
  { "iamcryptoki.com", true },
  { "iamhansen.xyz", true },
  { "iamjoshellis.com", true },
  { "iamlife.com", true },
  { "iamtheib.me", true },
  { "iamtonyarthur.com", true },
  { "iamusingtheinter.net", false },
  { "iamwoodbeard.com", true },
  { "ianbrault.com", true },
  { "iandouglasscott.com", true },
  { "iane-ccs.com", true },
  { "ianix.com", true },
  { "ianjmoriarty.com", true },
  { "ianklug.com", true },
  { "iankmusic.com", true },
  { "ianmooreis.me", true },
  { "ianmoriarty.com.au", true },
  { "iansyst.co.uk", true },
  { "ianwalsh.org", false },
  { "iap.network", true },
  { "ias-gruppe.net", true },
  { "iassess.eu", true },
  { "iatfei.com", true },
  { "iautodily.cz", true },
  { "iavian.com", true },
  { "iba.community", true },
  { "ibacktraced.it", true },
  { "ibaq.nl", true },
  { "ibauruapan.com.mx", true },
  { "ibavaro.com", true },
  { "ibb.co", true },
  { "ibcl.us", true },
  { "ibcmed.org", true },
  { "ibe.de", true },
  { "ibeep.com", true },
  { "iberiaversicherungen.com", true },
  { "ibericaderedes.es", true },
  { "ibericarbenet.es", true },
  { "ibericarcuzco.es", true },
  { "ibericarcuzcomini.es", true },
  { "ibericarformula.es", true },
  { "ibericargestoso.es", true },
  { "ibericarmotors.es", true },
  { "ibericarmotorsmalaga.es", true },
  { "ibericarmovilcentro.es", true },
  { "ibericarmovilsur.es", true },
  { "ibericarreicomsa.es", true },
  { "ibericartechnik.es", true },
  { "iberiserver.es", true },
  { "ibestreview.com", true },
  { "ibexcore.com", true },
  { "ibi.mt", true },
  { "ibigawamizueco.com", true },
  { "ibin.co", true },
  { "ibiz.mk", true },
  { "iblackfriday.ro", true },
  { "ibodyiq.com", true },
  { "ibps-recruitment.in", true },
  { "ibrainmedicine.org", true },
  { "ibrom.eu", true },
  { "ibsociety.com", true },
  { "ibstyle.tk", true },
  { "ibuki.run", true },
  { "ibwc.gov", true },
  { "ibykos.com", true },
  { "ic-lighting.com.au", true },
  { "ic-spares.com", true },
  { "ic3.gov", true },
  { "icafecash.com", true },
  { "icanhasht.ml", true },
  { "icanhazpass.com", true },
  { "icarlos.net", true },
  { "icasture.top", true },
  { "iccpublisher.com", true },
  { "icdp.org.ua", true },
  { "ice.xyz", true },
  { "iceberg.academy", true },
  { "icecars.net", true },
  { "icecontrol.ro", true },
  { "icedream.tech", true },
  { "icelandicasian.com", true },
  { "icetiger.eu", true },
  { "icetravellers.com", true },
  { "ich-hab-die-schnauze-voll-von-der-suche-nach-ner-kurzen-domain.de", true },
  { "ich-tanke.de", true },
  { "ichasco.com", true },
  { "ichbinein.org", true },
  { "ichbinkeinreh.de", true },
  { "iclart.com", true },
  { "iclinic.ua", true },
  { "icloud.st", true },
  { "icloudlogin.com", true },
  { "icmhd.ch", true },
  { "icmp2018.org", true },
  { "icmshoptrend.com", true },
  { "icobench.com", true },
  { "icodeconnect.com", true },
  { "icoh.it", true },
  { "iconomi.net", true },
  { "icowhitepapers.co", true },
  { "icpc.pp.ua", true },
  { "icq-project.net", true },
  { "icsfinomornasco.gov.it", true },
  { "icsfinomornasco.it", true },
  { "ict-concept.nl", true },
  { "ict-crew.nl", true },
  { "ict-helpteam.nl", true },
  { "ict-radar.com", true },
  { "ict-radar.nl", true },
  { "ictbaneninnederland.nl", true },
  { "ictbiz.com.au", true },
  { "ictcareer.ch", true },
  { "ictl.eu", true },
  { "ictoniolopisa.it", true },
  { "ictradar.com", true },
  { "ictussistemas.com.br", true },
  { "icy.aq", true },
  { "icyapril.com", true },
  { "icymint.me", true },
  { "icynet.eu", true },
  { "iczc.cz", true },
  { "id-blog.ch", true },
  { "id.atlassian.com", true },
  { "id.mayfirst.org", false },
  { "id.search.yahoo.com", false },
  { "id0-rsa.pub", true },
  { "idaeus.eu", true },
  { "idahoansforliberty.net", true },
  { "idar-oberstein.de", true },
  { "idarv.com", true },
  { "idaspis.com", true },
  { "idatha.de", true },
  { "idc-business.be", true },
  { "idconsult.nl", true },
  { "ideageek.net", true },
  { "ideal-envelopes.co.uk", false },
  { "idealimplant.com", true },
  { "idealninajemce.cz", false },
  { "idealsegurancaeletronica.com.br", true },
  { "idealtruss.com", true },
  { "idealtruss.com.tw", true },
  { "idealwhite.space", true },
  { "ideasenfoto.com", true },
  { "ideashop.com", true },
  { "ideatarmac.com", true },
  { "ideaweb.de", true },
  { "idenamaislami.com", true },
  { "idensys.nl", true },
  { "ident-clinic.be", true },
  { "identassist.com", true },
  { "identifyme.net", true },
  { "identigraf.center", true },
  { "identity.plus", true },
  { "identitytheft.gov", true },
  { "idered.net", true },
  { "idesignstudio.de", true },
  { "idesoft.cloud", true },
  { "idesoftinnovacion.com", true },
  { "idesoftinnovacion.es", true },
  { "idexxpublicationportal.com", true },
  { "idfy.io", true },
  { "idgard.de", false },
  { "idgateway.co.uk", true },
  { "idhosts.co.id", true },
  { "idiotentruppe.de", true },
  { "idleleo.com", true },
  { "idlethoughtsandramblings.com", true },
  { "idmanagement.gov", true },
  { "idmobile.co.uk", true },
  { "idndx.com", true },
  { "idoc24.com", true },
  { "idodiandina.com", true },
  { "idolf.dk", true },
  { "idolish7.fun", false },
  { "idolknow.com", true },
  { "idontplaydarts.com", true },
  { "idoparadoxon.hu", true },
  { "idratherbequilting.com", true },
  { "idraulico-roma.it", true },
  { "idraulico-roma.org", true },
  { "idraulico.roma.it", true },
  { "idrissi.eu", true },
  { "idroserviceweb.com", true },
  { "idrottsnaprapaten.se", true },
  { "idrycleaningi.com", true },
  { "idtheft.gov", true },
  { "idubaj.cz", true },
  { "idunno.org", true },
  { "idvl.de", true },
  { "idxforza.com", true },
  { "idysse.com", true },
  { "ie.search.yahoo.com", false },
  { "iea-annex61.org", true },
  { "iec.pe", true },
  { "ieeedeis.org", true },
  { "ieeesb.nl", true },
  { "ieeesbe.nl", true },
  { "ieeespmb.org", true },
  { "iegat.com", true },
  { "ieji.de", true },
  { "iemb.tk", true },
  { "ienakanote.com", false },
  { "ies-italia.it", true },
  { "iesonline.co.in", true },
  { "ieval.ro", true },
  { "ifan.ws", true },
  { "ifangpei.cn", true },
  { "ifangpei.com.cn", true },
  { "ifelse.io", true },
  { "ifengge.cn", true },
  { "ifengge.me", true },
  { "ifgcdn.com", true },
  { "ifibe.com", true },
  { "ifightsurveillance.com", true },
  { "ifightsurveillance.net", true },
  { "ifightsurveillance.org", true },
  { "iflare.de", true },
  { "ifma.edu.br", true },
  { "ifort.fr", true },
  { "ifosep.fr", true },
  { "ifoss.me", true },
  { "ifsac.org", true },
  { "ifsclist.com", true },
  { "ifsr.de", true },
  { "ift.cx", true },
  { "iftrue.de", true },
  { "ifttl.com", true },
  { "ifxd.bid", true },
  { "ig.com", true },
  { "iga-semi.jp", true },
  { "igarage.nl", true },
  { "igcc.jp", true },
  { "igdn.de", true },
  { "igeh-immo.at", true },
  { "igglabs.com", true },
  { "iggprivate.com", true },
  { "iggsoft.com", true },
  { "iggsoftware.com", true },
  { "igiftcards.de", true },
  { "igiftcards.nl", true },
  { "igimusic.com", true },
  { "igk.nz", true },
  { "iglosujemy.pl", true },
  { "igmus.org", true },
  { "ignace72.eu", true },
  { "ignacjanskiednimlodziezy.pl", true },
  { "ignat-mag.com", true },
  { "ignat.by", true },
  { "ignatovich.by", true },
  { "ignatovich.me", true },
  { "ignet.gov", true },
  { "ignitedlocal.com", true },
  { "ignitelocal.com", true },
  { "ignition.gg", true },
  { "igorandandre.com", true },
  { "igorrealestate.com", true },
  { "igorw.org", true },
  { "igotoffer.com", false },
  { "igrarium.com.ua", true },
  { "igrivi.com", true },
  { "iguana.com.ec", false },
  { "ih8sn0w.com", true },
  { "iha6.com", true },
  { "ihacklabs.com", false },
  { "ihcprofile.com", true },
  { "ihearmedical.com", true },
  { "ihempz.cz", true },
  { "ihkk.net", true },
  { "ihmphila.org", true },
  { "ihoey.com", true },
  { "ihollaback.org", true },
  { "ihopeit.works", true },
  { "ihorizon.jp", true },
  { "ihostup.net", true },
  { "ihotel.io", true },
  { "ihrhost.com", true },
  { "ihtdenisjaccard.com", true },
  { "ihuan.me", true },
  { "ii5197.co", true },
  { "ii6729.com", true },
  { "ii6957.co", true },
  { "ii74.com", true },
  { "ii918.com", true },
  { "ii9297.co", true },
  { "ii9397.com", true },
  { "ii9721.com", true },
  { "ii9728.co", true },
  { "iiax.net", true },
  { "iiax.org", true },
  { "iiit.pl", true },
  { "iinf.in", true },
  { "iinix.com", true },
  { "iiong.com", true },
  { "iisjy.cn", true },
  { "iix.se", true },
  { "iiyama-bg.com", true },
  { "ijinus.com", true },
  { "ijm.io", true },
  { "ijohan.nl", true },
  { "ijsbaanwitten.nl", true },
  { "ijsblokjesvormen.nl", true },
  { "ijsclubdwarsgracht.nl", true },
  { "ijsclubtilburg.nl", true },
  { "ijsclubwanneperveen.nl", true },
  { "ijunohana.jp", true },
  { "ikachalife.com", true },
  { "ikarate.ru", true },
  { "ikarr.com", true },
  { "ikeacareers.co.uk", true },
  { "ikebukuro-shame.com", true },
  { "ikedaquotes.org", true },
  { "ikespta.com", true },
  { "ikeyless.com", true },
  { "ikigaiweb.com", true },
  { "ikiler.com", true },
  { "ikinokori-marketing.com", true },
  { "ikk.me", true },
  { "ikkakujuku.work", false },
  { "ikkatsu-satei.jp", true },
  { "ikkbb.de", true },
  { "ikke-coach.nl", true },
  { "ikkev.de", true },
  { "ikkoku.de", true },
  { "iklive.org", false },
  { "ikmx.net", true },
  { "iknet.top", true },
  { "ikparis.com", true },
  { "ikraenglish.com", false },
  { "ikulist.me", true },
  { "ikvts.de", true },
  { "ikwilthepiratebay.org", true },
  { "ikxkx.com", true },
  { "ikymbo.com", true },
  { "ila.fi", true },
  { "ilamparas.at", true },
  { "ilamparas.co.uk", true },
  { "ilamparas.com", true },
  { "ilamparas.com.co", true },
  { "ilamparas.com.ve", true },
  { "ilamparas.mx", true },
  { "ilard.fr", true },
  { "ilazycat.com", true },
  { "ildomani.it", true },
  { "ile-kalorii.pl", true },
  { "ile-sapporo.jp", true },
  { "ileci.de", true },
  { "ilektronika-farmakeia-online.gr", true },
  { "ilemonrain.com", false },
  { "ilformichiere.com", true },
  { "ilhan.name", true },
  { "iliastsi.net", true },
  { "iligang.cn", true },
  { "iligang.com", true },
  { "iligang.link", true },
  { "iligang.xin", true },
  { "iliz-kafe.fr", true },
  { "ilkeakyildiz.com", false },
  { "illambias.ch", true },
  { "illative.net", true },
  { "illegalpornography.com", true },
  { "illegalpornography.me", true },
  { "illerzell.de", true },
  { "illich.cz", true },
  { "illicitart.ca", true },
  { "illicitdigital.com", true },
  { "illjinx.info", true },
  { "illorenese.fr", true },
  { "illsley.org", true },
  { "illumed.net", true },
  { "illuminationis.com", true },
  { "illuminatisofficial.org", true },
  { "illusionephemere.com", true },
  { "illusionunlimited.com", true },
  { "illustrate.biz", true },
  { "illuxat.com", true },
  { "ilmainensanakirja.fi", true },
  { "ilmataat.ee", true },
  { "ilmiobusinessonline.it", true },
  { "ilmiogiardiniere.it", true },
  { "ilmuk.org", false },
  { "ilonewolfs.com", true },
  { "ilookz.nl", true },
  { "ilove.fish", true },
  { "ilovequiz.ru", true },
  { "ilovethiscampsite.com", true },
  { "ilrg.com", true },
  { "iltec-prom.ru", true },
  { "iltec.ru", true },
  { "iltuogiardino.org", true },
  { "ilweb.es", true },
  { "ilya.pp.ua", true },
  { "im-c-shop.com", true },
  { "im-haus-sonnenschein.de", true },
  { "im-in.space", true },
  { "im2net.com", true },
  { "im4h.de", true },
  { "im4h.eu", true },
  { "im4h.info", true },
  { "im66.net", true },
  { "ima-tourcoing.fr", true },
  { "ima.re", true },
  { "imacs.org", true },
  { "image-drive.de", true },
  { "imagebin.ca", true },
  { "imagecurl.com", true },
  { "imagecurl.org", true },
  { "imagefu.com", true },
  { "imageination.co", true },
  { "imagerive.ch", true },
  { "imagescostumes.com", true },
  { "imaginair.es", true },
  { "imaginary.ca", true },
  { "imaginary.stream", true },
  { "imaginationpathway.com", true },
  { "imagine-programming.com", true },
  { "imaginetricks.com", true },
  { "imagr.io", true },
  { "imanageproducts.co.uk", true },
  { "imanageproducts.uk", true },
  { "imanesdeviaje.com", true },
  { "imanolbarba.net", true },
  { "imap2imap.de", true },
  { "imarkethost.co.uk", true },
  { "imawhale.com", true },
  { "imbiancatura.milano.it", true },
  { "imbianchino.roma.it", true },
  { "imbushuo.net", true },
  { "imcsi.cn", true },
  { "imcsx.co", true },
  { "imdemos.com", true },
  { "ime.moe", true },
  { "imed.com.pt", true },
  { "imed.pt", true },
  { "imediafly.com", true },
  { "imedikament.de", true },
  { "imeds.pl", true },
  { "imeid.de", false },
  { "imex-dtp.com", true },
  { "imforza.com", true },
  { "img.com.ru", true },
  { "img.mg", true },
  { "img.ovh", true },
  { "imga.ch", true },
  { "imgaa.com", true },
  { "imgal.vin", true },
  { "imgbb.com", true },
  { "imgg.es", true },
  { "imgup.co", true },
  { "imguploaden.nl", true },
  { "imhua.com", true },
  { "imi-rhapsody.eu", true },
  { "iminshell.com", false },
  { "imirhil.fr", true },
  { "imisa.com.mx", true },
  { "imitza.com", true },
  { "imjad.cn", true },
  { "imjo.in", true },
  { "imjustcreative.co.uk", true },
  { "imjustcreative.com", true },
  { "imkerei-freilinger.de", false },
  { "imkerverein-moenchswald.de", true },
  { "imlonghao.com", true },
  { "immarypoppinsyall.tk", true },
  { "immaterium.de", true },
  { "immatix.xyz", true },
  { "immersion-pictures.com", true },
  { "immo-agentur.com", false },
  { "immo-passion.net", true },
  { "immobilien-badlippspringe.de", true },
  { "immobilien-in-istanbul.de", true },
  { "immobilien-zirm.de", true },
  { "immobiliengutachter-holland.de", true },
  { "immobilier-nice.fr", true },
  { "immobilier92.net", true },
  { "immobiza.com", false },
  { "immortal.run", true },
  { "imobile3.com", true },
  { "imoe.xyz", true },
  { "imokuri123.com", true },
  { "imoney.tw", true },
  { "imouto.my", false },
  { "imouyang.com", true },
  { "imovel5.com.br", true },
  { "impact.health.nz", true },
  { "impacter.eu", true },
  { "impactfestival.be", true },
  { "impactingsports.com", true },
  { "impactplumbingdrainage.com.au", true },
  { "impactpub.ch", true },
  { "impakho.com", true },
  { "impas.se", true },
  { "impelup.com", true },
  { "impendulo.org", true },
  { "impera.at", true },
  { "imperial-legrand.com", true },
  { "imperialinfosys.com", true },
  { "imperialmiami.com", true },
  { "imperiodigital.online", true },
  { "imperiumglass.com.au", true },
  { "impiantistica.org", true },
  { "implantologie-dr-loeck.de", true },
  { "impns.org", true },
  { "imponet.com.ar", true },
  { "import-shopping.de", true },
  { "importsagt.com", true },
  { "impossible.co", true },
  { "impossible.org", true },
  { "impossiblefitness.com", true },
  { "impossiblehq.com", true },
  { "impossiblenutrition.com", true },
  { "impossiblex.com", true },
  { "impotsimple.ca", true },
  { "imppac-schmuck.de", true },
  { "imppac.de", true },
  { "imprendo.co", true },
  { "imprendo.pro", true },
  { "impresa-di-pulizie.milano.it", true },
  { "impresa-di-pulizie.org", true },
  { "impresa-pulizie.it", true },
  { "impresadipulizia.roma.it", true },
  { "impresadipulizie.roma.it", true },
  { "impresaedile.roma.it", true },
  { "impresapulizia.milano.it", true },
  { "impresapulizie.firenze.it", true },
  { "impresapuliziebergamo.it", true },
  { "imprezzor.com", true },
  { "imprimante-3d-store.fr", true },
  { "improfestival.ee", true },
  { "improklinikken.dk", true },
  { "improved-madness.de", true },
  { "improvision.eu", true },
  { "impyus.com", true },
  { "imququ.com", true },
  { "imreh.net", true },
  { "imrunner.com", true },
  { "imrunner.ru", true },
  { "ims-sargans.ch", true },
  { "imscompany.com", true },
  { "imtikai.ml", true },
  { "imtikaib.ml", true },
  { "imwalking.de", true },
  { "imwnk.cn", true },
  { "imy.rs", true },
  { "imydl.tech", true },
  { "imyjy.cn", true },
  { "imyrs.cn", true },
  { "imyunya.com", true },
  { "imyvm.com", true },
  { "imyz.tw", true },
  { "in-depthoutdoors.com", true },
  { "in-flames.com", true },
  { "in.search.yahoo.com", false },
  { "in.xero.com", false },
  { "in10tion.com", false },
  { "inabox.ro", true },
  { "inait.ai", true },
  { "inanyevent.london", true },
  { "inares.org", true },
  { "inbitcoin.it", true },
  { "inbounder.io", false },
  { "inbox.google.com", true },
  { "inbulgaria.info", true },
  { "inc.wf", true },
  { "incarceratedwombats.com", true },
  { "incarna.co", true },
  { "incco.ir", true },
  { "incert.cn", true },
  { "incertint.com", true },
  { "incestporn.tv", true },
  { "inchcape-fleet-autobid.co.uk", true },
  { "inche-ali.com", true },
  { "inchenaim.com", true },
  { "inchidi.id", true },
  { "incigma.com", true },
  { "includesubdomains.preloaded.test", true },
  { "includesubdomains2.preloaded.test", true },
  { "incoherent.ch", true },
  { "incommon.io", true },
  { "incompliance.de", true },
  { "inconcerts.de", true },
  { "incontrixsingle.net", true },
  { "incore.nl", true },
  { "incowrimo.org", true },
  { "incparadise.net", true },
  { "incubos.org", true },
  { "incy.io", true },
  { "ind.ie", true },
  { "indecipherable.info", true },
  { "independencerecovery.com", true },
  { "independenttravelcats.com", true },
  { "index-mp3.com", true },
  { "indiaflowermall.com", true },
  { "indian-elephant.com", true },
  { "indianaantlersupply.com", true },
  { "indianaberry.com", true },
  { "indianafoundationpros.com", true },
  { "indianamoldrepairpros.com", true },
  { "indianareflux.com", true },
  { "indianawaterdamagerepairpros.com", true },
  { "indiansmartpanel.com", true },
  { "indiapur.com", true },
  { "indiatrademarkwatch.com", true },
  { "indiayogastudio.net", true },
  { "indicateurs-flash.fr", true },
  { "indie.dog", true },
  { "indiecongdr.it", true },
  { "indiegame.space", true },
  { "indievelopment.nl", true },
  { "indigitalagency.com", true },
  { "indigoblack.com.au", true },
  { "indigoinflatables.com", true },
  { "indigolawnscape.net", true },
  { "indigosakura.com", true },
  { "indigotreeservice.com", true },
  { "indika.pe", true },
  { "indio.co.jp", true },
  { "inditip.com", true },
  { "indogermanstartup.com", true },
  { "indoorcomfortteam.com", true },
  { "indota.hu", true },
  { "indovinabank.com.vn", true },
  { "indusap.com", true },
  { "indusfastremit-us.com", true },
  { "indust.me", true },
  { "industriafranchini.com", true },
  { "industrial-remote-control.com", true },
  { "industrialstarter.com", true },
  { "industriemeister.io", true },
  { "indybay.org", true },
  { "ineardisplay.com", true },
  { "inebula.it", true },
  { "ineed.coffee", false },
  { "inertianetworks.com", true },
  { "inessoftsec.be", true },
  { "inesta.nl", true },
  { "inet.se", true },
  { "inethost.eu", true },
  { "inetserver.eu", true },
  { "inetsoftware.de", true },
  { "inf-fusion.ca", true },
  { "inference.biz.tr", true },
  { "infermiere.roma.it", true },
  { "inff.info", true },
  { "inffin-portal.de", true },
  { "inficom.org", true },
  { "infinipharm.com", true },
  { "infinitescript.com", true },
  { "infinitiofallentownparts.com", true },
  { "infinitioflynnwoodparts.com", true },
  { "infinitomaisum.com", true },
  { "infinitybas.com", true },
  { "infinitybc.se", true },
  { "infinityepos.co.uk", true },
  { "infirmiere-canadienne.com", true },
  { "infirmieredevie.ch", true },
  { "inflatablehire-scotland.co.uk", true },
  { "inflatablesny.com", true },
  { "inflatamania.com", true },
  { "inflationstation.net", true },
  { "inflexsys.com", true },
  { "influo.com", true },
  { "infmed.com", true },
  { "info-beamer.com", true },
  { "info-o-zbozi.cz", true },
  { "info-screen-usercontent.me", true },
  { "info-screen.me", true },
  { "info-screw.com", true },
  { "infobae.com", true },
  { "infobrain.net", true },
  { "infocity-tech.fr", true },
  { "infocoin.es", true },
  { "infocommsociety.com", true },
  { "infocon.org", true },
  { "infocusvr.net", true },
  { "infodesigners.eu", true },
  { "infodesk.at", true },
  { "infodiscus.com", true },
  { "infoduv.fr", true },
  { "infogram.com", true },
  { "infogrfx.com", true },
  { "infogym.com", true },
  { "infohub.com.ua", true },
  { "infomasx.com", true },
  { "infomegastore.com", true },
  { "infomir.eu", true },
  { "infomisto.com", true },
  { "infonote.ca", true },
  { "infopuntzorg.nl", true },
  { "infor-allaitement.be", true },
  { "informace-zbozi.cz", true },
  { "informatiebeveiliging.nl", true },
  { "informatik-handwerk.de", true },
  { "informationrx.org", true },
  { "informations-echafaudages.com", true },
  { "informhealth.com", true },
  { "informnapalm.org", true },
  { "infosec-handbook.eu", true },
  { "infosec.exchange", false },
  { "infosec.pizza", true },
  { "infosec.wiki", true },
  { "infosecchicago.com", true },
  { "infosectalks.com", true },
  { "infosectekniques.com", true },
  { "infosective.org", true },
  { "infosenior.ch", true },
  { "infotainworld.com", true },
  { "infotolium.com", false },
  { "infotrac.net", true },
  { "infotune.nl", true },
  { "infovision-france.com", true },
  { "infra.land", true },
  { "infraball.com", true },
  { "infrabeep.com", true },
  { "infrabeta.com", true },
  { "infrabind.com", true },
  { "infrabold.com", true },
  { "infrabond.com", true },
  { "infraboom.com", true },
  { "infraclass.com", true },
  { "infraclip.com", true },
  { "infracron.com", true },
  { "infradart.com", true },
  { "infradisk.com", true },
  { "infradrop.com", true },
  { "infrafile.com", true },
  { "infrafind.com", true },
  { "infrafire.com", true },
  { "infraflip.com", true },
  { "infraflux.com", true },
  { "infrafuse.com", true },
  { "infrafusion.com", true },
  { "infralira.com", true },
  { "infralist.com", true },
  { "infraloon.com", true },
  { "inframake.com", true },
  { "inframeet.com", true },
  { "inframenu.com", true },
  { "inframetro.com", true },
  { "inframint.com", true },
  { "infraname.com", true },
  { "infranest.com", true },
  { "infranium.com", true },
  { "infranium.eu", true },
  { "infranium.info", true },
  { "infranium.net", true },
  { "infranium.org", true },
  { "infranotes.com", true },
  { "infranoto.com", true },
  { "infranox.com", true },
  { "infrapass.com", true },
  { "infrapeer.com", true },
  { "infrapilot.com", true },
  { "infraping.com", true },
  { "infrapirtis.lt", true },
  { "infraplot.com", true },
  { "infrarank.com", true },
  { "infrarank.net", true },
  { "infraredradiant.com", true },
  { "infraspin.com", true },
  { "infratank.com", true },
  { "infratask.com", true },
  { "infrathink.com", true },
  { "infratrip.com", true },
  { "infravibe.com", true },
  { "infravideo.com", true },
  { "infravoce.com", true },
  { "infrazine.com", true },
  { "infruction.com", true },
  { "infstudios.nl", true },
  { "infuzeit.com.au", true },
  { "ing-buero-junk.de", true },
  { "ingalls.run", true },
  { "ingatlanjogaszok.hu", true },
  { "ingatlanrobot.hu", true },
  { "ingber.com", true },
  { "inge-r.nl", true },
  { "ingeeibach.de", true },
  { "ingenius.ws", true },
  { "ingi.ga", true },
  { "ingjobs.ch", true },
  { "inglebycakes.co.uk", true },
  { "inglesnarede.com.br", true },
  { "ingo-schlueter.de", true },
  { "ingolonde.pw", true },
  { "ingoschlueter.de", true },
  { "ingressfs.pl", true },
  { "ingridbai.me", true },
  { "inhaltsangabe.de", true },
  { "inheritestate.com", true },
  { "inhouseents.co.uk", true },
  { "iniiter.com", true },
  { "inima.org", true },
  { "iningrui.com", true },
  { "inishbofin.ie", true },
  { "initq.net", true },
  { "initramfs.io", true },
  { "initrd.net", true },
  { "inixal.com", true },
  { "injigo.com", false },
  { "injurylawyer.com", true },
  { "ink.horse", true },
  { "inkable.com.au", true },
  { "inkhor.se", true },
  { "inkontriamoci.com", true },
  { "inkopers.org", true },
  { "inksay.com", true },
  { "inkspire.co.uk", true },
  { "inkurz.de", true },
  { "inlabo.de", true },
  { "inline-sport.cz", true },
  { "inlinea.ch", true },
  { "inlink.ee", true },
  { "inmaps.xyz", true },
  { "inmatefinancial.com", true },
  { "inmateintake.com", true },
  { "inmobillium.fr", true },
  { "inmueblescartagena.com.co", true },
  { "inmusrv.de", true },
  { "innatocol.com", true },
  { "innerfence.com", true },
  { "innerlightcrystals.co.uk", true },
  { "innermostparts.org", true },
  { "innersafe.com", true },
  { "inno.ch", true },
  { "innocenceseekers.net", true },
  { "innogen.fr", true },
  { "innohb.com", true },
  { "innolabfribourg.ch", true },
  { "innoloop.com", true },
  { "innophate-security.com", true },
  { "innot.net", true },
  { "innotas.com", true },
  { "innoteil.com", true },
  { "innotel.com.au", true },
  { "innovamag.com", true },
  { "innovaptor.at", true },
  { "innovaptor.com", true },
  { "innovate-indonesia.com", true },
  { "innovation-workshop.ro", true },
  { "innovation.gov", false },
  { "innover.se", true },
  { "innovere.co.uk", true },
  { "innovum.cz", false },
  { "innwan.com", true },
  { "inoa8.com", true },
  { "inobun.jp", true },
  { "inondation.ch", true },
  { "inovatecsystems.com", true },
  { "inovitec.eu", true },
  { "inoxandco.com", true },
  { "inoxdesign.fr", true },
  { "inoxdesign.pro", true },
  { "inoxmavang.net", true },
  { "inpas.co.uk", true },
  { "inphi.com", true },
  { "input.sh", true },
  { "inputmag.com", true },
  { "inputmodes.com", true },
  { "inqorp.ca", true },
  { "inquant.de", true },
  { "ins-kreativ.de", true },
  { "ins.to", true },
  { "ins1gn1a.com", true },
  { "insblauehinein.nl", true },
  { "inscomers.net", true },
  { "inscribe.ai", true },
  { "inscripcionessena.com", true },
  { "insecret.co.ua", true },
  { "insecret.com.ua", true },
  { "insecret.trade", true },
  { "insecure.org.je", true },
  { "insegne.roma.it", true },
  { "insertcoins.net", true },
  { "inserzioniticino.ch", true },
  { "insgesamt.net", true },
  { "inshapenutrition.com.br", true },
  { "insho.fashion", true },
  { "inshop.hu", true },
  { "inside19.com", true },
  { "insideaudit.com", true },
  { "insidebedroom.com", true },
  { "insideevs.com", true },
  { "insideevs.fr", true },
  { "insidesolutions.nl", true },
  { "insidethefirewall.tk", true },
  { "insighti.org", true },
  { "insighti.sk", true },
  { "insignificant.space", true },
  { "insinuator.net", true },
  { "insistel.com", true },
  { "insolved.com", true },
  { "insomniasec.com", true },
  { "inspiratienodig.nl", true },
  { "inspired-lua.org", true },
  { "inspiredlife.fun", true },
  { "inspiredrealtyinc.com", true },
  { "insrt.uk", true },
  { "insside.net", true },
  { "instachina.ru", true },
  { "instafind.nl", true },
  { "instafuckfriend.com", true },
  { "instagib.info", true },
  { "instagram-atom.appspot.com", true },
  { "instagram.com", true },
  { "instagrammernews.com", true },
  { "instagramtweet.com", true },
  { "instahub.net", true },
  { "installatietechniekgresnigt.nl", true },
  { "installgentoo.net", true },
  { "instamojo.com", true },
  { "instant-clearance-sale.co.uk", true },
  { "instant-thinking.de", true },
  { "instant.io", true },
  { "instantkhabar.com", true },
  { "instantphotocamera.com", true },
  { "instantphotoprinter.com", true },
  { "instava.cz", true },
  { "instead.com.au", true },
  { "insteagle.com", true },
  { "instela.com", true },
  { "instelikes.com.br", true },
  { "instics.com", true },
  { "instinctiveads.com", true },
  { "institut-confucius-montpellier.org", true },
  { "institutmaupertuis.hopto.org", true },
  { "institutogiuseppe.com", true },
  { "institutogiuseppe.com.ar", true },
  { "institutolancaster.com", true },
  { "institutomaritimocolombiano.com", true },
  { "instrumart.ru", false },
  { "insult.es", true },
  { "insurance321.com", true },
  { "insurancesloans.com", true },
  { "insureon.com", true },
  { "int64software.com", true },
  { "intafe.co.jp", true },
  { "intal.info", true },
  { "intarweb.ca", true },
  { "intasky.cz", true },
  { "intasky.sk", true },
  { "integralblue.com", true },
  { "integralkk.com", true },
  { "integrata.de", true },
  { "integratedintegrations.xyz", true },
  { "integratedmedicalonline.com", true },
  { "integrateur-web-paris.com", true },
  { "integrity.gov", true },
  { "integrityfortcollins.com", true },
  { "integrityglobal.com", true },
  { "integrityokc.com", true },
  { "integrityoklahoma.com", true },
  { "integrogroup.com", true },
  { "integromat.com", true },
  { "integroof.com", true },
  { "intelhost.cl", true },
  { "intelhost.com", true },
  { "intelhost.com.ar", true },
  { "intelhost.com.br", true },
  { "intelhost.com.co", true },
  { "intelhost.com.mx", true },
  { "intelhost.com.pe", true },
  { "inteli.com.pl", true },
  { "intellar.com", true },
  { "intellectdynamics.com", true },
  { "intelligence-explosion.com", true },
  { "intelligenetics.com", true },
  { "intellihr.io", true },
  { "intellimax.ir", true },
  { "intellinetixvibration.com", true },
  { "intellitonic.com", true },
  { "intelly.nl", true },
  { "intelly365.nl", true },
  { "intencje.pl", true },
  { "inter-corporate.com", true },
  { "inter-culinarium.com", true },
  { "interaffairs.com", true },
  { "interaktiva.fi", true },
  { "interasistmen.se", true },
  { "interchangedesign.com", true },
  { "interchanges.io", true },
  { "intercom.com", true },
  { "intercom.io", true },
  { "interessengemeinschaft-pregelstrasse.tk", true },
  { "interessiert-uns.net", true },
  { "interflores.com.br", true },
  { "interfug.de", true },
  { "intergozd.si", true },
  { "interguard.net", true },
  { "interiery-waters.cz", true },
  { "interimages.fr", true },
  { "interior-design-colleges.com", true },
  { "interiordesignsconcept.com", true },
  { "interiorprofesional.com.ar", true },
  { "interisaudit.com", true },
  { "interlijn.nl", true },
  { "interlingvo.biz", true },
  { "intermax.nl", true },
  { "intermedinet.nl", true },
  { "intern.tax", true },
  { "internalkmc.com", true },
  { "internaluse.net", true },
  { "international-arbitration-attorney.com", true },
  { "international-books.org", true },
  { "international-nash-day.com", true },
  { "internationalfashionjobs.com", true },
  { "internationalschool.it", true },
  { "internationalschoolnewyork.com", true },
  { "internationalstudentassociation.com", true },
  { "internationaltalento.it", true },
  { "internect.co.za", true },
  { "internet-aukcion.info", true },
  { "internet-pornografie.de", false },
  { "internet-software.eu", true },
  { "internetaanbieders.eu", true },
  { "internetanbieter-experte.de", true },
  { "internetbank.swedbank.se", true },
  { "internetbugbounty.com", true },
  { "internetbusiness-howto.com", true },
  { "internetcom.jp", true },
  { "internetfonden.se", true },
  { "internetgardener.co.uk", true },
  { "internethealthreport.org", true },
  { "internethering.de", true },
  { "internetinhetbuitengebied.nl", true },
  { "internetmedia.si", true },
  { "internetmuseum.se", true },
  { "internetnz.nz", true },
  { "internetofdon.gs", true },
  { "internetoffensive.fail", true },
  { "internetofinsecurethings.com", true },
  { "internetovehazardnihry.cz", true },
  { "internetpro.me", true },
  { "internetstaff.com", true },
  { "internetzentrale.net", true },
  { "interparcel.com", true },
  { "interpol.gov", true },
  { "interracial.dating", true },
  { "interseller.io", true },
  { "interssl.com", true },
  { "interstateautomotiveinc.com", true },
  { "intertime.services", true },
  { "interviewme.pl", true },
  { "interways.de", true },
  { "intheater.de", true },
  { "inthepicture.com", true },
  { "inthouse.cloud", true },
  { "intita.com", true },
  { "intmissioncenter.org", true },
  { "into.technology", true },
  { "inton.biz", true },
  { "intoparking.com", true },
  { "intoparking.fi", true },
  { "intpforum.com", true },
  { "intr0.cf", true },
  { "intr0.com", true },
  { "intr0.tk", true },
  { "intrack.net.au", true },
  { "intradayseasonals.com", true },
  { "intramanager.dk", true },
  { "intranet.dvag", true },
  { "intranetsec-regionra.fr", true },
  { "intraobes.com", true },
  { "intrasoft.com.au", true },
  { "intraxia.com", true },
  { "intrepy.com", true },
  { "intrigue3d.com", true },
  { "intropickup.ru", true },
  { "intrp.net", true },
  { "intvonline.com", true },
  { "intxt.net", true },
  { "inumcoeli.com.br", true },
  { "inup.jp", true },
  { "inusasha.de", true },
  { "inuyasha-petition.tk", true },
  { "invadelabs.com", true },
  { "invalida.ru", true },
  { "invasion.com", true },
  { "invasivespeciesinfo.gov", true },
  { "invasmani.com", true },
  { "inventaire.ch", true },
  { "inventionsteps.com.au", true },
  { "inventix.nl", true },
  { "inventoryimages.co.uk", true },
  { "inventoryimages.com", true },
  { "inventtatte.com", true },
  { "inventtheworld.com.au", true },
  { "inventum.cloud", true },
  { "inverselink-user-content.com", true },
  { "investarholding.nl", true },
  { "investigatore.roma.it", true },
  { "investigazione.milano.it", true },
  { "investigazione.roma.it", true },
  { "investigazionimoretti.it", true },
  { "investinghacker.com.au", true },
  { "investinturkey.com.tr", true },
  { "investir.ch", true },
  { "investor-academy.jp", true },
  { "investor.gov", true },
  { "investoren-beteiligung.de", true },
  { "investorforms.com", true },
  { "investosure.com", true },
  { "investpay.ru", true },
  { "invidio.us", true },
  { "invinoaustria.com", true },
  { "invinoaustria.cz", true },
  { "invioinc.com", true },
  { "inviosolutions.com", true },
  { "invisible-college.com", true },
  { "invisiverse.com", true },
  { "invitacionesytarjetas.gratis", true },
  { "invitemember.com", true },
  { "invitescene.com", true },
  { "invitethemhome.com", true },
  { "invkao.com", true },
  { "invoiced.com", true },
  { "invoicehippo.nl", true },
  { "invuite.com", true },
  { "invuite.com.au", true },
  { "inwao.com", true },
  { "inwestcorp.se", true },
  { "inyourowntime.info", true },
  { "inyourowntime.zone", true },
  { "inzdr.com", true },
  { "inzelabs.com", true },
  { "inzernettechnologies.com", true },
  { "inzestfreunde.de", true },
  { "ioactive.com", true },
  { "iobint.com", true },
  { "iocheck.com", false },
  { "iochen.com", true },
  { "iocurrents.com", true },
  { "iofort.com", true },
  { "iojo.net", true },
  { "ioliver.co.uk", true },
  { "iomedia.ch", true },
  { "iompost.com", true },
  { "iomstamps.com", true },
  { "iondrey.cf", true },
  { "iondrey.fr", true },
  { "iondrey.ga", true },
  { "iondrey.gq", true },
  { "iondrey.ml", true },
  { "iondrey.tk", true },
  { "ione.net.nz", true },
  { "ionlabs.kr", true },
  { "ionspin.com", true },
  { "ionx.co.uk", true },
  { "ioover.net", true },
  { "iop.intuit.com", false },
  { "iosartstudios.gr", true },
  { "ioslo.net", true },
  { "iosmods.com", true },
  { "iosnoops.com", true },
  { "iossifovlab.com", true },
  { "iostream.by", true },
  { "iotac.xyz", true },
  { "iowaent.com", true },
  { "iowaschoolofbeauty.com", true },
  { "iowen.cn", true },
  { "ip-address.me", true },
  { "ip-blacklist.net", true },
  { "ip-hahn.de", true },
  { "ip-ra.com", true },
  { "ip-tanz.com", true },
  { "ip.sb", true },
  { "ip3office.com", true },
  { "ip6.li", true },
  { "ipad.li", true },
  { "ipadkaitori.jp", true },
  { "ipal.im", true },
  { "ipal.name", true },
  { "ipal.pl", true },
  { "ipal.tel", true },
  { "iparkki.com", true },
  { "ipcareers.net", true },
  { "ipdsols.co.za", true },
  { "ipemcomodoro.com.ar", true },
  { "ipfire.org", true },
  { "ipfirebox.de", true },
  { "ipfs.ink", true },
  { "ipfs.io", true },
  { "iphonekaitori.tokyo", true },
  { "iphoneunlock.nu", true },
  { "iphonote.com", true },
  { "ipintel.io", true },
  { "iplantom.com", true },
  { "iplayradio.net", false },
  { "ipleak.net", true },
  { "ipledgeonline.org", false },
  { "iplog.info", false },
  { "ipmonitoring.hu", true },
  { "ipo-times.jp", true },
  { "ipokabu.net", true },
  { "ipomue.com", false },
  { "ipop.gr", true },
  { "iposm.net", true },
  { "ipplans.com", true },
  { "iprcenter.gov", true },
  { "ipresent.com", true },
  { "iprim.ru", true },
  { "ipripojeni.cz", true },
  { "iproducemusic.com", true },
  { "ips-consult.nl", true },
  { "ipsec.pl", true },
  { "ipslsig.org", true },
  { "ipso.paris", true },
  { "ipstream.it", true },
  { "ipswitch.com.tw", true },
  { "iptvzoom.xyz", true },
  { "ipty.de", true },
  { "ipura.ch", true },
  { "ipv4.cf", true },
  { "ipv4.co.il", true },
  { "ipv4.gr", true },
  { "ipv6-adresse.dk", true },
  { "ipv6-handbuch.de", true },
  { "ipv6.gr", true },
  { "ipv6.jetzt", true },
  { "ipv6vpn.net", true },
  { "ipv6wallofshame.com", true },
  { "iqboxy.com", true },
  { "iqsmn.org", true },
  { "ir1s.com", true },
  { "iramellor.com", true },
  { "iranian.lgbt", true },
  { "iranianholiday.com", true },
  { "iranjeunesse.com", true },
  { "irasandi.com", true },
  { "irayo.net", true },
  { "irc-results.com", true },
  { "irdvb.com", true },
  { "ireef.tv", true },
  { "iren.ch", true },
  { "irenekauer.com", true },
  { "ireviewi.com", true },
  { "irf2.pl", true },
  { "irfan.id", true },
  { "irgendeine.cloud", true },
  { "irgit.pl", true },
  { "irgwebsites.com", true },
  { "iridiumbrowser.de", true },
  { "iridiumflare.de", true },
  { "iriomote.com", true },
  { "iris-design.info", true },
  { "iris-insa.com", true },
  { "irish.dating", true },
  { "irish.radio", true },
  { "irishradioplayer.radio", true },
  { "irisjieun.com", true },
  { "irismq.fr", true },
  { "irkfap.com", true },
  { "irland-firma.com", true },
  { "irlfp.com", true },
  { "irmag.ru", true },
  { "irmgard-woelfle.de", true },
  { "irmgardkoch.com", true },
  { "irodorinet.com", true },
  { "iroise.ch", true },
  { "ironcarnival.com", true },
  { "ironfistdesign.com", true },
  { "ironhide.de", true },
  { "ironpeak.be", true },
  { "ironpony.com", true },
  { "irrewilse.se", true },
  { "irritant.net", true },
  { "iruarts.ch", true },
  { "iruca.co", true },
  { "irvingramo.com", true },
  { "iryogakkai.jp", true },
  { "is-going-to-rickroll.me", true },
  { "is-rocket.science", true },
  { "is-socket.tk", true },
  { "isa357.com", true },
  { "isa5417.com", true },
  { "isaaccomputerscience.org", true },
  { "isaacdgoodman.com", false },
  { "isaackabel.cf", true },
  { "isaackabel.ga", true },
  { "isaackabel.gq", true },
  { "isaackabel.ml", true },
  { "isaackabel.tk", true },
  { "isaackhor.com", true },
  { "isaacman.tech", true },
  { "isaacmorneau.com", true },
  { "isaacpartnership.co.uk", true },
  { "isaacpartnership.com", true },
  { "isaacphysics.org", true },
  { "isaaczais.com", true },
  { "isabelaflores.com", true },
  { "isabellavandijk.nl", true },
  { "isabelle-delpech.com", true },
  { "isabellehogarth.co.uk", true },
  { "isabelmurillo-ordonez.com", true },
  { "isakssons.com", true },
  { "isamay.es", true },
  { "isamiok.com", true },
  { "isara.com", true },
  { "isaropiping.fr", true },
  { "isavings.com", true },
  { "isayoga.de", true },
  { "isbaseballstillon.com", true },
  { "isbc-telecom.ru", true },
  { "isbengrumpy.com", true },
  { "iscert.org", true },
  { "isdn.jp", true },
  { "isecrets.se", true },
  { "iservicio.mx", true },
  { "isg-tech.com", true },
  { "isgp-studies.com", false },
  { "ishamf.com", true },
  { "ishangirdhar.com", true },
  { "ishiharaken.com", true },
  { "ishland.com", true },
  { "ishtarfreya.com", true },
  { "isif-ostewg.org", true },
  { "isil.fi", true },
  { "isimonbrown.co.uk", true },
  { "isincheck.com", true },
  { "isiso.com.tr", true },
  { "isistomie.com", true },
  { "isitchristmas.com", true },
  { "isitcoffeetime.com", true },
  { "isitdoneyet.gov", true },
  { "isitef.com", true },
  { "isitpatchtuesday.com", true },
  { "isitrest.info", true },
  { "isitup.org", true },
  { "iskanderbroere.nl", true },
  { "iskaron.de", true },
  { "iskaz.rs", true },
  { "iskogen.nu", true },
  { "islam.si", true },
  { "islamicmarkets.com", true },
  { "islamonline.net", true },
  { "islandhosting.com", true },
  { "islavolcan.cl", true },
  { "isletech.net", true },
  { "isliada.org", true },
  { "islief.com", true },
  { "islightdown.today", true },
  { "islykaithecutest.cf", true },
  { "islykaithecutest.ml", true },
  { "ismailkarsli.com", true },
  { "ismat.com", true },
  { "ismena.bg", true },
  { "ismywebsitepenalized.com", true },
  { "isn.cz", true },
  { "iso27032.com", true },
  { "isocom.eu", true },
  { "isognattori.com", true },
  { "isolta.com", true },
  { "isolta.de", true },
  { "isolta.ee", true },
  { "isolta.fi", true },
  { "isolta.lv", true },
  { "isolta.se", true },
  { "isonet.fr", true },
  { "isopres.de", true },
  { "isotope.gov", true },
  { "isotopes.gov", true },
  { "isovideo.com", true },
  { "isowosi.com", true },
  { "ispfontela.es", true },
  { "ispitrade.com", true },
  { "ispo.com.tw", true },
  { "isqrl.de", true },
  { "israel-in-color.com", true },
  { "israelbiblicalstudies.com", true },
  { "israelbizreg.com", true },
  { "isreedyinthe.uk", true },
  { "isreedyinthe.us", true },
  { "isreedyintheuk.com", true },
  { "issa.org.pl", false },
  { "issasfrissa.se", true },
  { "issforum.org", true },
  { "issio.net", true },
  { "issue.watch", true },
  { "issues.email", true },
  { "ist-intim.de", true },
  { "ist.cm", true },
  { "istanbul.systems", true },
  { "istdieweltschonuntergegangen.de", true },
  { "isteinbaby.de", true },
  { "isterfaslur.com", true },
  { "istheapplestoredown.com", true },
  { "istheapplestoredown.de", true },
  { "isthedoorlocked.com", true },
  { "istheinternetdown.com", true },
  { "istheinternetonfire.com", true },
  { "isthephone.com", true },
  { "istheservicedown.co.uk", true },
  { "istheservicedown.com", true },
  { "istheservicedowncanada.com", true },
  { "isthnew.com", true },
  { "istitutoricci.it", true },
  { "istitutovivaldi.it", true },
  { "istogether.com", true },
  { "istore.lt", true },
  { "istorrent.is", true },
  { "istrazivac-istine.com", true },
  { "istschonsolangeinrente.de", true },
  { "istsi.org", true },
  { "isusemasa.com", true },
  { "isuzupartscenter.com", true },
  { "isv.online", true },
  { "isvbscriptdead.com", true },
  { "isvsecwatch.org", true },
  { "isz.no", true },
  { "iszy.cc", true },
  { "it-academy.sk", true },
  { "it-boss.ro", true },
  { "it-faul.de", true },
  { "it-fernau.com", true },
  { "it-inside.ch", true },
  { "it-jobbank.dk", true },
  { "it-kron.de", true },
  { "it-maker.eu", true },
  { "it-meneer.nl", true },
  { "it-rotter.de", true },
  { "it-schamans.de", true },
  { "it-service24.at", true },
  { "it-service24.ch", true },
  { "it-service24.com", true },
  { "it-shamans.de", true },
  { "it-shamans.eu", true },
  { "it-stack.de", true },
  { "it-support-nu.se", true },
  { "it-support-stockholm.se", true },
  { "it-support.one", true },
  { "it-supportistockholm.se", true },
  { "it-supportnu.se", true },
  { "it-swarm.net", true },
  { "it-sysoft.com", true },
  { "it-tekniker.nu", true },
  { "it-ti.me", true },
  { "it-uws.com", true },
  { "it.search.yahoo.com", false },
  { "it1b.com", true },
  { "itactiq.com", true },
  { "itactiq.info", true },
  { "itaiferber.net", true },
  { "ital-gamma.be", true },
  { "italbavaro.com", true },
  { "italia-store.com", true },
  { "italiachegioca.com", true },
  { "italian.dating", true },
  { "italianjourneys.com.au", true },
  { "italianshoemanufacturers.com", true },
  { "italieflydrive.nl", true },
  { "italserrande.it", true },
  { "italserver.com", true },
  { "itamservices.nl", true },
  { "itap.gov", true },
  { "itb-online.co.uk", true },
  { "itbox.cl", true },
  { "itcbuerobedarf.de", true },
  { "itchy.nl", true },
  { "itchybrainscentral.com", true },
  { "itconsulting-wolfinger.de", true },
  { "itcs.services", true },
  { "itdashboard.gov", true },
  { "itdo.com", true },
  { "itecor.net", true },
  { "iteecafe.hu", true },
  { "iteha.de", true },
  { "iteke.ml", true },
  { "iteke.tk", true },
  { "iteli.eu", true },
  { "iterader.com", true },
  { "iterror.co", true },
  { "itesign.de", true },
  { "itfh.eu", true },
  { "itfix.cz", true },
  { "itgoesup.com", true },
  { "itgoesupent.com", true },
  { "itgoesupentertainment.com", true },
  { "ithakama.cz", true },
  { "ithelfer.ch", true },
  { "ithenrik.com", true },
  { "ithinc.net", true },
  { "ithink.cf", true },
  { "ithjalpforetag.se", true },
  { "itikon.com", true },
  { "itilo.de", true },
  { "itis.gov", true },
  { "itis4u.ch", true },
  { "itkaufmann.at", true },
  { "itkonsultstockholm.se", true },
  { "itludens.com", true },
  { "itm-c.de", true },
  { "itmanie.cz", true },
  { "itmindscape.com", true },
  { "itn.co.uk", true },
  { "itneeds.tech", true },
  { "itnota.com", true },
  { "itochan.jp", true },
  { "itooky.com", true },
  { "itpanda.pl", true },
  { "itpro.ua", true },
  { "itraveille.fr", true },
  { "itreallyaddsup.com", true },
  { "itring.pl", false },
  { "itruss.com.tw", true },
  { "itruth.tk", true },
  { "its-future.com", true },
  { "its-gutachten.de", true },
  { "its420somewhere.com", true },
  { "itsabouncything.com", true },
  { "itsasaja.com", true },
  { "itsaw.de", true },
  { "itsayardlife.com", true },
  { "itsblue.de", true },
  { "itsburning.nl", true },
  { "itsdcdn.com", true },
  { "itsecblog.de", true },
  { "itsecguy.com", true },
  { "itseeze.com", true },
  { "itsense.fr", true },
  { "itsevident.com", true },
  { "itsfitlab.com", true },
  { "itsgoingdown.org", true },
  { "itshka.rv.ua", true },
  { "itsmyparty.ie", true },
  { "itsnotquitethehilton.com", true },
  { "itsok.de", true },
  { "itsok.link", true },
  { "itspartytimeonline.co.uk", true },
  { "itspecialista.eu", true },
  { "itspersonaltraining.nl", true },
  { "itsquiet.org", true },
  { "itsryan.com", true },
  { "itsstefan.eu", true },
  { "itstatic.tech", true },
  { "itsuitsyou.co.za", true },
  { "itsundef.in", true },
  { "itsupportnacka.se", true },
  { "itsv.at", true },
  { "itswincer.com", true },
  { "itsynergy.co.uk", true },
  { "itzap.com.au", true },
  { "iurisnow.com", true },
  { "iusedtosmoke.com", true },
  { "iuyos.com", true },
  { "ivact.co.jp", true },
  { "ivanaleksandrov.net", true },
  { "ivanbenito.com", true },
  { "ivanboi.com", true },
  { "ivancacic.com", false },
  { "ivanmeade.com", true },
  { "ivanovolive.ru", true },
  { "ivaoru.org", true },
  { "ivfausland.de", true },
  { "ivfmeds.com", true },
  { "ivig.com.br", true },
  { "ivisitorinsurance.com", true },
  { "ivo.co.za", true },
  { "ivocopro.de", true },
  { "ivocotec.de", true },
  { "ivoid.cf", true },
  { "ivopetkov.com", true },
  { "ivor.io", true },
  { "ivor.is", true },
  { "ivorvanhese.com", true },
  { "ivorvanhese.nl", true },
  { "ivotemahdi.com", true },
  { "ivpn.net", true },
  { "ivre.rocks", true },
  { "ivsign.net", true },
  { "ivusn.cz", true },
  { "ivvl.ru", true },
  { "ivy-league-colleges.com", true },
  { "iwader.co.uk", true },
  { "iwalton.com", true },
  { "iwantexchange.com", true },
  { "iwantpayments.com", true },
  { "iwanttoliveinabunker.com", true },
  { "iwanttrack.com", true },
  { "iwascoding.com", true },
  { "iwascoding.de", true },
  { "iwatchcops.com", true },
  { "iwatchcops.org", true },
  { "iwch.tk", true },
  { "iwd.gc.ca", true },
  { "iwell.de", true },
  { "iwizerunek.pl", true },
  { "iworos.com", true },
  { "iww.me", true },
  { "ixanis.net", true },
  { "ixds.org", true },
  { "ixnext.de", true },
  { "ixquick-proxy.com", true },
  { "ixquick.co.uk", true },
  { "ixquick.com", true },
  { "ixquick.de", true },
  { "ixquick.eu", true },
  { "ixquick.fr", true },
  { "ixquick.info", true },
  { "ixquick.nl", true },
  { "iyassu.com", true },
  { "iyc.web.tr", true },
  { "iyinolaashafa.com", true },
  { "iyn.me", true },
  { "iyouewo.com", true },
  { "iyuanbao.net", true },
  { "iz8mbw.net", true },
  { "izevg.ru", true },
  { "izodiacsigns.com", true },
  { "izolpoznan.pl", true },
  { "izt.tech", true },
  { "izttech.com", true },
  { "izuba.info", true },
  { "izumi.tv", true },
  { "izxxs.com", true },
  { "izxxs.net", true },
  { "izxzw.net", true },
  { "izzys.casa", true },
  { "j-elliott.co.uk", true },
  { "j-navi.com", true },
  { "j-ph.ovh", true },
  { "j-softlab.com", true },
  { "j0bs.org", true },
  { "j0e.com", true },
  { "j0hndball.com", true },
  { "j0m.de", true },
  { "j0s.at", true },
  { "j0s.eu", true },
  { "j15h.nu", true },
  { "j1visahealthinsurance.com", true },
  { "j2h.de", true },
  { "j3e.de", true },
  { "j5197.co", true },
  { "j5lx.de", true },
  { "j5lx.eu", true },
  { "j5lx.io", true },
  { "j605.tk", true },
  { "j6729.co", true },
  { "j6957.co", true },
  { "j9297.co", true },
  { "j9504.com", true },
  { "j9507.com", true },
  { "j9508.com", true },
  { "j9512.com", true },
  { "j9514.com", true },
  { "j9515.com", true },
  { "j9516.com", true },
  { "j9517.com", true },
  { "j95aa.com", true },
  { "j95app.com", true },
  { "j95bb.com", true },
  { "j95cc.com", true },
  { "j95dd.com", true },
  { "j95ee.com", true },
  { "j95ios.com", true },
  { "j95ss.com", true },
  { "j95xx.com", true },
  { "j95zz.com", true },
  { "j9721.com", true },
  { "j9728.co", true },
  { "ja-gps.com.au", true },
  { "ja-zur-gs.de", true },
  { "jaakkohannikainen.fi", true },
  { "jaalits.com", true },
  { "jaamaa.com", true },
  { "jaarvistech.com", true },
  { "jaba.hosting", true },
  { "jababu.cz", true },
  { "jabbari.io", true },
  { "jabbas.eu", true },
  { "jabber.at", true },
  { "jabberfr.org", true },
  { "jabbers.one", true },
  { "jabberzac.org", true },
  { "jaberg-rutschi.ch", true },
  { "jabergrutschi.ch", true },
  { "jability.ovh", true },
  { "jabjab.de", true },
  { "jaccblog.com", true },
  { "jacekowski.org", true },
  { "jacik.cz", true },
  { "jack2celebrities.com", true },
  { "jackassofalltrades.org", true },
  { "jackdawphoto.co.uk", true },
  { "jackdelik.de", true },
  { "jackf.me", true },
  { "jackflet.ch", true },
  { "jackgreenrealty.com", true },
  { "jackhoodtransportation.com", true },
  { "jackjack.ga", true },
  { "jackpothappy.com", true },
  { "jacksanalytics.com", true },
  { "jacksball.com", true },
  { "jackson-quon.com", true },
  { "jackson.jp", true },
  { "jacksonhu.com", true },
  { "jacksonvillestation.com", true },
  { "jacksorrell.com", true },
  { "jackwozny.com", true },
  { "jackyliao.me", true },
  { "jackyliao123.tk", true },
  { "jackyyf.com", false },
  { "jacobamunch.com", true },
  { "jacobhaug.com", false },
  { "jacobi-server.de", true },
  { "jacobian.org", true },
  { "jacobjangles.com", true },
  { "jacobs-implantate.at", true },
  { "jacuzziprozone.com", true },
  { "jadchaar.me", true },
  { "jadehotel.nl", true },
  { "jadopado.com", true },
  { "jaegerlacke.de", true },
  { "jaepinformatica.com", true },
  { "jaetech.org", true },
  { "jagbouncycastles.co.uk", true },
  { "jagerman.com", true },
  { "jaguarlandrover-asse.be", true },
  { "jaguarlandrover-occasions.be", true },
  { "jaguarwong.xyz", true },
  { "jahanaisamu.com", true },
  { "jahmusic.net", true },
  { "jahner.xyz", true },
  { "jahofmann.de", false },
  { "jaiestate.com", true },
  { "jailbreakingisnotacrime.org", true },
  { "jaingynecology.com", true },
  { "jaispirit.com", true },
  { "jaitnetworking.com", false },
  { "jajsemjachym.cz", true },
  { "jak-na-les.cz", true },
  { "jakarta.dating", true },
  { "jakdelatseo.cz", true },
  { "jake.eu.org", true },
  { "jake.ml", true },
  { "jake.nom.za", true },
  { "jake.wales", true },
  { "jake1.eu", true },
  { "jakecurtis.de", true },
  { "jakereynolds.co", true },
  { "jakerullman.com", true },
  { "jaketremper.com", true },
  { "jakewales.com", true },
  { "jakewalker.xyz", true },
  { "jakewestrip.com", true },
  { "jakob-server.tk", true },
  { "jakobejitblokaci.cz", true },
  { "jakobkrigovsky.com", true },
  { "jakobssystems.net", true },
  { "jakpremyslet.cz", true },
  { "jaksch.biz", true },
  { "jakub-boucek.cz", true },
  { "jakubboucek.cz", true },
  { "jakubklimek.com", true },
  { "jakubsindelar.cz", true },
  { "jakubtopic.cz", true },
  { "jakubvrba.cz", true },
  { "jala.co.jp", true },
  { "jaleo.cn", true },
  { "jalogisch.de", true },
  { "jamaat.hk", true },
  { "jamacha.org", true },
  { "jamalfi.bio", true },
  { "jamberrynails.co.uk", true },
  { "james-bell.co.uk", true },
  { "james-loewen.com", true },
  { "jamesachambers.com", false },
  { "jamesaimonetti.com", true },
  { "jamesbillingham.com", true },
  { "jameschorlton.co.uk", true },
  { "jamesdorf.com", true },
  { "jamesedition.com", true },
  { "jamesgreenfield.com", true },
  { "jamesheald.com", true },
  { "jameshemmings.co.uk", true },
  { "jameshost.net", true },
  { "jameshunt.us", false },
  { "jamesj.me", false },
  { "jamesjboyer.com", true },
  { "jamesmarsh.net", true },
  { "jamesmilazzo.com", true },
  { "jamesmorrison.me", true },
  { "jamesmurphy.com.au", false },
  { "jamesrobertson.net", true },
  { "jamesross.name", true },
  { "jamessmith.me.uk", true },
  { "jamestmartin.me", true },
  { "jamesturnerstickley.com", true },
  { "jameswarp.com", true },
  { "jamhost.org", true },
  { "jamie-read-photography.com", true },
  { "jamie.ie", true },
  { "jamielarter.ca", true },
  { "jamielinux.com", true },
  { "jamiemagee.co.uk", true },
  { "jamiemagee.dk", true },
  { "jamieweb.net", true },
  { "jamieweb.org", true },
  { "jamiewebb.net", true },
  { "jammucake.com", true },
  { "jammysplodgers.co.uk", true },
  { "jamon.ca", true },
  { "jamonsilva.com", true },
  { "jamstatic.fr", true },
  { "jan-and-maaret.de", true },
  { "jan-bucher.ch", true },
  { "jan-hill.com", true },
  { "jan-reiss.de", true },
  { "jan-rieger.de", true },
  { "jan-roenspies.de", true },
  { "jan-von.de", true },
  { "janaundgeorgsagenja.eu", true },
  { "janbrodda.de", true },
  { "jandev.de", true },
  { "jane.com", true },
  { "janehamelgardendesign.co.uk", true },
  { "janelauhomes.com", true },
  { "janhermann.cz", true },
  { "janhuelsmann.com", true },
  { "jani.media", true },
  { "janiat.com", true },
  { "janik.xyz", false },
  { "janikrabe.com", true },
  { "janjoris.nl", true },
  { "jankamp.com", true },
  { "janker.me", true },
  { "jankoepsel.com", true },
  { "jann.is", true },
  { "jannekekaasjager.nl", true },
  { "jannisfink.de", true },
  { "jannyrijneveld.nl", true },
  { "janokacer.sk", true },
  { "janschaumann.de", true },
  { "janterpstra.eu", true },
  { "jantinaboelens.nl", true },
  { "janvari.com", true },
  { "janvaribalint.com", true },
  { "janz.online", true },
  { "japanesemotorsports.net", true },
  { "japangids.nl", true },
  { "japaniac.de", false },
  { "japanphilosophy.com", false },
  { "japansm.com", true },
  { "japanwatches.xyz", true },
  { "jardineriaon.com", true },
  { "jardiniersduminotaure.fr", true },
  { "jaredfraser.com", true },
  { "jarmatys.pl", true },
  { "jarniashop.se", true },
  { "jaroku.com", true },
  { "jarondl.net", true },
  { "jarrah-alsilawi.com", true },
  { "jarrettgraham.com", true },
  { "jarroba.com", true },
  { "jas-team.net", true },
  { "jashvaidya.com", true },
  { "jasmijnwagenaar.nl", true },
  { "jasminefields.net", true },
  { "jasonamorrow.com", true },
  { "jasongerber.ch", true },
  { "jasonmili.online", true },
  { "jasonsplecoscichlids.com", true },
  { "jasper.link", true },
  { "jasperhammink.com", true },
  { "jasperhuttenmedia.com", true },
  { "jasperpatterson.me", true },
  { "jastrow.me", true },
  { "jaszbereny-vechta.eu", true },
  { "javalestari.com", true },
  { "javamilk.com", true },
  { "javelin.cc", true },
  { "javfree.me", true },
  { "javhdmovies.com", true },
  { "javi.pro", false },
  { "javierburgos.net", true },
  { "javierlorente.es", true },
  { "javik.net", true },
  { "jaxfstk.com", true },
  { "jaxxnet.co.uk", true },
  { "jaxxnet.org", true },
  { "jaybrokers.com", true },
  { "jayf.de", true },
  { "jayfreestone.com", false },
  { "jayharkess.uk", true },
  { "jaymecd.rocks", true },
  { "jaypandit.me", true },
  { "jayrl.com", true },
  { "jaysaw.me", true },
  { "jaytx.com", true },
  { "jayxon.com", true },
  { "jayxu.com", true },
  { "jazminguaramato.com", true },
  { "jazz-alliance.com", true },
  { "jazz-alliance.org", true },
  { "jazzanet.com", true },
  { "jazzncheese.com", true },
  { "jazzy-feet.com", true },
  { "jazzy.id.au", true },
  { "jazzy.pro", true },
  { "jazzysumi.com", true },
  { "jbbd.fr", true },
  { "jbeta.is", true },
  { "jblackweb.com", true },
  { "jbridal.com.au", true },
  { "jbs-jardins.ch", true },
  { "jbsinternational.com", true },
  { "jbt-stl.com", true },
  { "jcadg.com", true },
  { "jcai.dk", true },
  { "jcaicedo.com", true },
  { "jcb.com", true },
  { "jcbgolfandcountryclub.com", true },
  { "jci.cc", true },
  { "jclynne.com", true },
  { "jcontspoord.nl", true },
  { "jcsesecuneta.com", true },
  { "jctf.team", true },
  { "jcus.co", true },
  { "jcvidroseespelhos.com.br", true },
  { "jcwodan.nl", true },
  { "jcyz.cf", true },
  { "jd1.de", true },
  { "jd777.vip", true },
  { "jdassets.com", true },
  { "jdc.io", true },
  { "jdcdirectsales.com", true },
  { "jdcgroup.com.ph", true },
  { "jdegbau.com", true },
  { "jdheysupplies.co.uk", true },
  { "jdjohnsonmedia.com", true },
  { "jdjohnsonwaterproofing.com", true },
  { "jdm.elk.pl", true },
  { "jdm.pl", true },
  { "jdmgarage.com.au", true },
  { "jdncr.com", true },
  { "jdoi.pw", true },
  { "jdpleisure.co.uk", true },
  { "jdscastlehire.co.uk", true },
  { "jdtic.com", true },
  { "jdubya.info", true },
  { "je-vends.fr", true },
  { "je2050.de", true },
  { "jeancardeno.com", true },
  { "jeandanielfaessler.ch", true },
  { "jeankygourmet.com", true },
  { "jeanmarieayer.ch", true },
  { "jeannecalment.com", true },
  { "jeannelucienne.fr", true },
  { "jeanneret-combustibles.ch", true },
  { "jec-dekrone.be", true },
  { "jecho.cn", true },
  { "jecjacshop.com", true },
  { "jeda.ch", true },
  { "jedepannetonordi.fr", true },
  { "jedidiah.eu", false },
  { "jedipedia.net", true },
  { "jediweb.com.au", true },
  { "jedmud.com", true },
  { "jedwarddurrett.com", true },
  { "jeec.ist", true },
  { "jeemain.org", true },
  { "jeepeg.com", true },
  { "jeeran.com", true },
  { "jeeranservices.com", true },
  { "jeerbl.com", true },
  { "jeff.forsale", true },
  { "jeffcloninger.net", true },
  { "jeffersonregan.co.uk", true },
  { "jeffersonregan.com", true },
  { "jeffersonregan.net", true },
  { "jeffhaferman.com", true },
  { "jeffmcneill.com", true },
  { "jeffpenchoff.com", true },
  { "jeffreyhaferman.com", true },
  { "jeffrhinelander.com", true },
  { "jeffri.me", true },
  { "jeffsanders.com", true },
  { "jefftickle.com", true },
  { "jeffwebb.com", true },
  { "jefrydco.id", true },
  { "jefsweden.eu", true },
  { "jej.cz", true },
  { "jej.sk", true },
  { "jekhar.com", true },
  { "jekkt.com", false },
  { "jelena-adeli.com", true },
  { "jelenkovic.rs", true },
  { "jell.ie", true },
  { "jelle.pro", true },
  { "jelleluteijn.com", true },
  { "jelleluteijn.eu", true },
  { "jelleluteijn.net", true },
  { "jelleluteijn.nl", true },
  { "jelleluteijn.pro", true },
  { "jelleraaijmakers.nl", true },
  { "jelleschneiders.com", true },
  { "jelly.cz", true },
  { "jellybeanbooks.com.au", true },
  { "jelmer.uk", true },
  { "jelmoli-shop.ch", true },
  { "jem.gov", true },
  { "jemangeducheval.com", true },
  { "jembatankarir.com", true },
  { "jemefaisdesamis.com", true },
  { "jemigjordy.nl", true },
  { "jennethaarfotografie.nl", true },
  { "jennierobinson.com", true },
  { "jenniferengerwingaantrouwen.nl", true },
  { "jennifersauer.nl", true },
  { "jennythebaker.com", true },
  { "jenolson.net", true },
  { "jenprace.cz", true },
  { "jensrex.dk", true },
  { "jepertinger-itconsulting.de", true },
  { "jeproteste.info", true },
  { "jeremiahbenes.com", true },
  { "jeremy-chen.org", true },
  { "jeremy.codes", false },
  { "jeremy.hu", true },
  { "jeremybentham.com", true },
  { "jeremybloomfield.co.uk", true },
  { "jeremyc.ca", false },
  { "jeremycantu.com", true },
  { "jeremycrews.com", true },
  { "jeremynally.com", true },
  { "jeremyness.com", true },
  { "jeremypaul.me", true },
  { "jeremytcd.com", true },
  { "jericamacmillan.com", true },
  { "jering.tech", true },
  { "jermann.biz", true },
  { "jeroendeneef.com", true },
  { "jerret.de", true },
  { "jerrysretailstores.com", true },
  { "jerryweb.org", true },
  { "jerryyu.ca", true },
  { "jerseybikehire.co.uk", true },
  { "jerseyjumpingbeans.co.uk", true },
  { "jerseylvi2013.org", true },
  { "jerseyplantsdirect.com", true },
  { "jes.events", true },
  { "jesec.io", true },
  { "jesiensredniowiecza.pl", true },
  { "jesse3.com", true },
  { "jesseerbach.com", true },
  { "jessekaufman.com", true },
  { "jessesjumpingcastles.co.uk", true },
  { "jessevictors.com", true },
  { "jessgranger.com", false },
  { "jessicabenedictus.nl", false },
  { "jessicahrehor.com", true },
  { "jesters-court.net", true },
  { "jesuisadmin.fr", true },
  { "jesuisunpapageek.fr", true },
  { "jesusvazquez.online", true },
  { "jet-stream.fr", true },
  { "jetbbs.com", true },
  { "jetflex.de", true },
  { "jetkittens.co.uk", true },
  { "jetsetboyz.net", true },
  { "jetsieswerda.nl", true },
  { "jetwhiz.com", true },
  { "jeurissen.co", true },
  { "jeuxetcodes.fr", true },
  { "jeweet.net", true },
  { "jewishboyscouts.com", true },
  { "jewishquotations.com", true },
  { "jf-fotos.de", true },
  { "jfbst.net", true },
  { "jfr.im", true },
  { "jfreitag.de", true },
  { "jgid.de", true },
  { "jgke.fi", true },
  { "jglover.com", true },
  { "jgoguen.ca", true },
  { "jgoldgroup.com", true },
  { "jgregory.co.uk", true },
  { "jgwb.de", true },
  { "jgwb.eu", true },
  { "jhalderm.com", true },
  { "jhaveri.net", true },
  { "jhe.li", true },
  { "jhill.de", true },
  { "jhollandtranslations.com", true },
  { "jhservicos.net.br", true },
  { "jhwestover.com", true },
  { "ji0vwl.net", true },
  { "jiahao.codes", true },
  { "jiangxu.site", true },
  { "jianji.de", true },
  { "jianny.me", true },
  { "jianshu.com", true },
  { "jianwei.wang", true },
  { "jianyuan.art", true },
  { "jicaivvip.com", true },
  { "jichi.io", true },
  { "jichi000.win", true },
  { "jie.dance", true },
  { "jif.gc.ca", true },
  { "jiji.co.tz", true },
  { "jiji.com.gh", true },
  { "jiji.ke", true },
  { "jiji.ug", true },
  { "jimbiproducts.com", true },
  { "jimbraaten.com", true },
  { "jimbutlerkiaparts.com", true },
  { "jimdorf.com", true },
  { "jime-hlavou.cz", true },
  { "jimeaton.com", true },
  { "jimfranke.com", true },
  { "jimfranke.nl", true },
  { "jimmycai.com", false },
  { "jimmyroura.ch", true },
  { "jimshaver.net", true },
  { "jimslop.nl", true },
  { "jinanshen.com", true },
  { "jinbo123.com", false },
  { "jinbowiki.org", true },
  { "jing.su", true },
  { "jingbo.fan", true },
  { "jingjo.com.au", true },
  { "jingyunbank.com", true },
  { "jinja.ai", true },
  { "jinkuru.net", true },
  { "jino-jossy.appspot.com", true },
  { "jinshuju.net", true },
  { "jintaiyang123.org", true },
  { "jiogo.com", true },
  { "jirav.com", true },
  { "jiripudil.cz", true },
  { "jisai.net.cn", true },
  { "jisha.site", true },
  { "jix.im", true },
  { "jixun.moe", true },
  { "jiyue.com", true },
  { "jiyue.moe", true },
  { "jiyuu-ni.net", true },
  { "jj5197.co", true },
  { "jj6729.co", true },
  { "jj6729.com", true },
  { "jj6957.co", true },
  { "jj9297.co", true },
  { "jj9397.com", true },
  { "jj9721.com", true },
  { "jj9728.co", true },
  { "jjhampton.com", true },
  { "jjj.blog", true },
  { "jjmarketing.co.uk", true },
  { "jjspartyhire.co.uk", true },
  { "jjvanoorschot.nl", true },
  { "jk-entertainment.biz", true },
  { "jkchocolate.com", true },
  { "jkg.tw", true },
  { "jki.io", true },
  { "jkinteriorspa.com", true },
  { "jkrippen.com", true },
  { "jldp.org", true },
  { "jlink.nl", true },
  { "jlkhosting.com", true },
  { "jloh.codes", true },
  { "jlponsetto.com", true },
  { "jlr-luxembourg.com", true },
  { "jltcsecuritygroup.com", true },
  { "jltctech.com", true },
  { "jm-bea.net", true },
  { "jmalarcon.es", true },
  { "jmarciniak.it", true },
  { "jmatt.org", true },
  { "jmbeautystudio.se", true },
  { "jmbelloteau.com", true },
  { "jmcashngold.com.au", true },
  { "jmcataffo.com", true },
  { "jmce.eu", true },
  { "jmcleaning.services", true },
  { "jmdiesel.com", true },
  { "jmedved.com", true },
  { "jmentertainment.co.uk", true },
  { "jmfjltd.com", true },
  { "jmorahan.net", true },
  { "jmpb.hu", true },
  { "jms8.net", true },
  { "jmsjms.cc", true },
  { "jmsjms.me", true },
  { "jmsjms.top", true },
  { "jmsjms.xyz", true },
  { "jmsolodesigns.com", true },
  { "jmssg.jp", true },
  { "jmwap.com", true },
  { "jnjdj.com", true },
  { "jnm-art.com", true },
  { "jnordell.com", true },
  { "joa-ebert.com", true },
  { "joanofarcmtcarmel.org", true },
  { "joaoaugusto.net", true },
  { "joaopenteado.com", true },
  { "joaosampaio.com.br", true },
  { "job-ofertas.info", true },
  { "job.biz.tr", true },
  { "jobalicious.nl", true },
  { "jobatus.com.br", true },
  { "jobatus.es", true },
  { "jobatus.it", true },
  { "jobatus.mx", true },
  { "jobatus.pt", true },
  { "jobbidag.se", true },
  { "jobbkk.com", true },
  { "jobbsafari.no", true },
  { "jobbsafari.se", true },
  { "jobcorpsy2y.com", true },
  { "jobify.in", true },
  { "jobindex.dk", true },
  { "joblab.com.ua", true },
  { "joblife.co.za", true },
  { "jobmi.com", true },
  { "jobmiplayground.com", true },
  { "jobs.at", true },
  { "jobs.ch", true },
  { "jobs4sales.ch", true },
  { "jobsarkari.com", true },
  { "jobseekeritalia.it", true },
  { "jobsindemedia.nl", true },
  { "jobsisbrown.com", true },
  { "jobsnet.eu", true },
  { "jobsuchmaschine.ch", true },
  { "jobwinner.ch", true },
  { "jobzninja.com", true },
  { "jockbusuttil.co.uk", true },
  { "jockbusuttil.com", true },
  { "jockbusuttil.uk", true },
  { "jodaniels.photography", true },
  { "jodbush.com", true },
  { "jodlajodla.si", true },
  { "joduska.me", true },
  { "jodyboucher.com", false },
  { "jodyshop.com", true },
  { "joe262.com", true },
  { "joebiden.com", true },
  { "joebobbriggs.net", true },
  { "joedavison.me", true },
  { "joedoyle.us", true },
  { "joefixit.co", true },
  { "joel.coffee", true },
  { "joelcoustrain.com", true },
  { "joeldrapper.com", true },
  { "joelfries.com", true },
  { "joelj.org", true },
  { "joelle.me", true },
  { "joelleandpeter.co.uk", true },
  { "joellimberg.com", true },
  { "joellombardo.com", false },
  { "joelmarkhamphotography.com.au", true },
  { "joelmunch.com", true },
  { "joelnichols.uk", true },
  { "joelotu.com", true },
  { "joelving.dk", true },
  { "joepitt.co.uk", false },
  { "joergschneider.com", true },
  { "joerosca.com", true },
  { "joerss.at", true },
  { "joeseago.com", true },
  { "joeskup.com", true },
  { "joespaintingpgh.com", true },
  { "joestead.codes", false },
  { "joetsutj.com", true },
  { "joetyson.me", true },
  { "joeyfelix.com", true },
  { "joeygitalian.com", true },
  { "joeyhoer.com", true },
  { "joeysmith.com", true },
  { "joeyvanvenrooij.nl", true },
  { "jogjacar.com", true },
  { "jogwitz.de", true },
  { "johanli.com", true },
  { "johannes-bauer.com", true },
  { "johannes-zinke.de", true },
  { "johannes.io", true },
  { "johannes.wtf", true },
  { "johannesburg-escorts.co.za", true },
  { "johannesen.tv", true },
  { "johannespichler.com", false },
  { "johanpeeters.com", true },
  { "johansf.tech", true },
  { "johego.org", true },
  { "johnaltamura.com", true },
  { "johnball.co", true },
  { "johnbeil.com", true },
  { "johnberan.com", true },
  { "johnblackbourn.com", true },
  { "johnbpodcast.com", true },
  { "johncook.ltd.uk", true },
  { "johndball.co", true },
  { "johndball.com", true },
  { "johndball.info", true },
  { "johndball.net", true },
  { "johndball.org", true },
  { "johnfulgenzi.com", true },
  { "johngadenne.com.au", true },
  { "johngallias.com", true },
  { "johngmchenrymd.com", true },
  { "johnguant.com", true },
  { "johnhancocknypensions.com", true },
  { "johnhancockpensions.com", true },
  { "johnhgaunt.com", true },
  { "johnkastler.net", true },
  { "johnkraal.com", true },
  { "johnmcintosh.pro", true },
  { "johnmh.me", true },
  { "johnmichel.org", true },
  { "johnnybegood.tk", true },
  { "johnnybet.com", true },
  { "johnnybsecure.com", true },
  { "johnroach.io", true },
  { "johnroberts.me", true },
  { "johnrockefeller.net", true },
  { "johnrosewicz.com", true },
  { "johnsanchez.io", true },
  { "johnsegovia.com", true },
  { "johnvanhese.nl", true },
  { "johnyytb.be", true },
  { "joi-dhl.ch", true },
  { "joinhahobby.com.br", true },
  { "joinhonor.com", true },
  { "jointotem.com", true },
  { "joinus-outfits.nl", true },
  { "jojosplaycentreandcafeteria.co.uk", true },
  { "jokedalderup.nl", true },
  { "jokequebec.com", true },
  { "jokerice.co.uk", true },
  { "jokesbykids.com", true },
  { "jokewignand.nl", true },
  { "joliettech.com", true },
  { "jolinebrussel.nl", true },
  { "jollausers.de", true },
  { "jolle.io", true },
  { "jollygoodspudz.ca", true },
  { "jollykidswobbleworld.co.uk", true },
  { "jolo.software", true },
  { "jolokia.ch", true },
  { "jomagus.de", true },
  { "jomibe.de", true },
  { "jomo.tv", true },
  { "jonahperez.com", true },
  { "jonale.net", true },
  { "jonandnoraswedding.com", true },
  { "jonas-thelemann.de", true },
  { "jonas-wenk.de", false },
  { "jonas.me", true },
  { "jonasberger.com", true },
  { "jonaskjodt.com", true },
  { "jonasled.de", true },
  { "jonaswitmer.ch", true },
  { "jonathancarter.org", true },
  { "jonathandupree.com", true },
  { "jonathanlara.com", true },
  { "jonathanreyes.com", false },
  { "jonathanscott.me", true },
  { "jonblankenship.com", true },
  { "jondarby.com", true },
  { "jondevin.com", true },
  { "jondowdle.com", true },
  { "jonespayne.com", false },
  { "jong030.nl", true },
  { "jongbloed.nl", true },
  { "jongcs.com", true },
  { "jongpay.com", true },
  { "jonilar.com", true },
  { "jonincharacter.com", true },
  { "jonirrings.com", true },
  { "jonkermedia.nl", false },
  { "jonlabelle.com", true },
  { "jonlu.ca", true },
  { "jonnasbeauty.com", true },
  { "jonny5.ru", true },
  { "jonnybarnes.uk", true },
  { "jonnystoten.com", true },
  { "jonoalderson.com", true },
  { "jonola.com", true },
  { "jonpads.com", true },
  { "jonpavelich.com", true },
  { "jons.org", true },
  { "jonscaife.com", true },
  { "jonssheds.direct", true },
  { "joodari.fi", true },
  { "jooksms.com", true },
  { "jooksuratas.ee", true },
  { "joompress.biz", true },
  { "joona.pw", true },
  { "joonatoona.me", true },
  { "joostrijneveld.nl", true },
  { "joostvanderlaan.nl", true },
  { "jopsens.de", true },
  { "joran.org", true },
  { "jorcus.com", true },
  { "jordandevelopment.com", true },
  { "jordanhamilton.me", false },
  { "jordankmportal.com", true },
  { "jordans.co.uk", true },
  { "jordanscorporatelaw.com", true },
  { "jordanstrustcompany.com", true },
  { "jordhy.com", true },
  { "jorisdalderup.nl", true },
  { "jornalalerta.com.br", true },
  { "jorsev.com", true },
  { "josc.com.au", true },
  { "joscares.com", true },
  { "jose-alexand.re", true },
  { "jose-lesson.com", true },
  { "joseetesser.nl", true },
  { "josef-lotz.de", true },
  { "josefjanosec.com", true },
  { "josefottosson.se", true },
  { "joseitoda.org", true },
  { "josemikkola.fi", true },
  { "josepbel.com", true },
  { "josephbarela.com", true },
  { "josephbleroy.com", true },
  { "josephgeorge.com.au", true },
  { "josephre.es", false },
  { "josephsniderman.com", true },
  { "josephsniderman.org", true },
  { "josephv.website", true },
  { "joshgilson.com", true },
  { "joshgrancell.com", true },
  { "joshharkema.com", true },
  { "joshharmon.me", true },
  { "joshics.in", true },
  { "joshjanzen.com", true },
  { "joshlovephotography.co.uk", true },
  { "joshpanter.com", false },
  { "joshrickert.com", true },
  { "joshruppe.com", true },
  { "joshschmelzle.com", true },
  { "joshtriplett.org", true },
  { "joshua-kuepper.de", true },
  { "joshua.bio", true },
  { "joshuadmiller.info", true },
  { "joshuamessick.com", true },
  { "joshuameunier.com", true },
  { "joshuarogers.net", true },
  { "josoansi.de", true },
  { "journalism-schools.com", true },
  { "journeedesfilles.gc.ca", true },
  { "journeyfriday.rocks", true },
  { "journeyof1000hops.com", true },
  { "journeytomastery.net", true },
  { "jouwpaardenbak.nl", true },
  { "jovani.com", false },
  { "jovic.hamburg", true },
  { "joyful.house", true },
  { "joyfulexpressions.gallery", true },
  { "joyfulhealthyeats.com", true },
  { "joynadvisors.com", true },
  { "joyofcookingandbaking.com", true },
  { "joyqi.com", true },
  { "joysinventingblog.com", true },
  { "jpbe-network.de", true },
  { "jpbe.de", true },
  { "jpbike.cz", false },
  { "jpdeharenne.be", true },
  { "jpeg.io", true },
  { "jpgangbang.com", true },
  { "jphandjob.com", true },
  { "jplesbian.com", true },
  { "jpmelos.com", true },
  { "jpmelos.com.br", true },
  { "jpmguitarshop.com.br", true },
  { "jpod.cc", true },
  { "jpoirierlavoie.ca", true },
  { "jpph.org", true },
  { "jpralves.net", true },
  { "jproxx.com", true },
  { "jps-selection.co.uk", true },
  { "jps-selection.com", true },
  { "jps-selection.eu", true },
  { "jpshop.ru", true },
  { "jpsinflatables.co.uk", true },
  { "jpslconsulting.ca", true },
  { "jquery.wtf", true },
  { "jrabasco.me", true },
  { "jrc9.ca", true },
  { "jrchaseify.xyz", true },
  { "jreb.nl", true },
  { "jreiff.de", true },
  { "jrflorian.com", true },
  { "jross.me", true },
  { "jrtapsell.co.uk", true },
  { "jrxpress.com", true },
  { "js-web.eu", true },
  { "js8855.com", true },
  { "jschoi.org", true },
  { "jschumacher.info", true },
  { "jsd-cog.org", true },
  { "jsdelivr.com", true },
  { "jselby.net", true },
  { "jsent.co.uk", true },
  { "jsevilleja.org", false },
  { "jsk26.ru", true },
  { "jskoelliken.ch", true },
  { "jsme.cz", true },
  { "jsmetallerie.fr", true },
  { "jsnfwlr.com", true },
  { "jsnfwlr.io", true },
  { "json.download", true },
  { "jsonsinc.com", true },
  { "jsteward.moe", true },
  { "jstore.ch", true },
  { "jsxc.ch", true },
  { "jtcat.com", true },
  { "jtcjewelry.com", true },
  { "jtconsultancy.sg", true },
  { "jtl-software.com", true },
  { "jtmar.me", true },
  { "jtp.id", true },
  { "jts3servermod.com", true },
  { "jtslay.com", true },
  { "jttech.se", true },
  { "ju.io", true },
  { "juan23.edu.uy", true },
  { "juanfrancisco.tech", true },
  { "juanjovega.com", true },
  { "juanmaguitar.com", true },
  { "juanmazzetti.com", true },
  { "juanxt.ddns.net", true },
  { "jubilerkarat.pl", true },
  { "jubileum.online", true },
  { "jubileumfotograaf.nl", true },
  { "jubobs.com", true },
  { "jucca-nautica.si", true },
  { "juch.cc", true },
  { "juchit.at", true },
  { "jucktehkeinen.de", true },
  { "judge2020.com", true },
  { "judoprodeti.cz", true },
  { "judosaintdenis.fr", true },
  { "judytka.cz", true },
  { "juef.space", true },
  { "juegosycodigos.es", true },
  { "juegosycodigos.mx", true },
  { "juegosyolimpicos.com", true },
  { "juergen-roehrig.de", true },
  { "juergenhecht.de", true },
  { "juergenklieber.de", true },
  { "juergenspecht.com", true },
  { "juergenspecht.de", true },
  { "juergmeier.ch", true },
  { "jugendfeuerwehr-vechta.de", true },
  { "jugendhackt.org", true },
  { "jugendsuenden.info", true },
  { "jugh.de", true },
  { "juhakoho.com", true },
  { "juice.codes", true },
  { "juk.life", false },
  { "juku-wing.jp", true },
  { "jule-spil.dk", true },
  { "julenlanda.com", false },
  { "julestern.com", true },
  { "julian-post.de", true },
  { "julian-uphoff.de", true },
  { "julian-weigle.de", true },
  { "julianbroadway.com", true },
  { "juliangonggrijp.com", true },
  { "julianickel.de", true },
  { "julianmeyer.de", true },
  { "julianmp.info", true },
  { "juliansimioni.com", true },
  { "julianskitchen.ch", true },
  { "julianvmodesto.com", true },
  { "julianweigle.de", true },
  { "julianxhokaxhiu.com", true },
  { "juliazeengardendesign.co.uk", true },
  { "julibear.com", true },
  { "julibon.com", true },
  { "julico.nl", true },
  { "julie-and-stevens-wedding.com", true },
  { "juliedecubber.com", true },
  { "juliekoubova.net", true },
  { "juliekproperties.com", true },
  { "juliemaurel.fr", true },
  { "julienc.io", true },
  { "juliendoco.com", true },
  { "julienpaterne.com", true },
  { "julienschmidt.com", true },
  { "julientartarin.com", true },
  { "julius-zoellner.de", true },
  { "jullensgroningen.com", true },
  { "julm.de", true },
  { "juls.cloud", true },
  { "jultube.de", true },
  { "jumbopan.net", true },
  { "jumboquid.co.uk", true },
  { "jump-zone.co.uk", true },
  { "jump.wtf", true },
  { "jump4funinflatables.co.uk", true },
  { "jumpandbounce.co.uk", true },
  { "jumpandjivechildrensparties.co.uk", true },
  { "jumparoundbouncycastles.co.uk", true },
  { "jumparty.co.uk", true },
  { "jumpeasy.com.au", true },
  { "jumpin-jax.co.uk", true },
  { "jumpinchat.com", true },
  { "jumpingbee.co.uk", true },
  { "jumpingcastlesonline.com.au", true },
  { "jumpingjacksbouncycastles.co.uk", true },
  { "jumpinjaes.co.uk", true },
  { "jumpinmonkeys.co.uk", true },
  { "jumpintogreenerpastures.com", true },
  { "jumpnplay.co.uk", true },
  { "jundongwu.com", true },
  { "junespina.com", true },
  { "junethack.net", true },
  { "jungesforumkonstanz.de", true },
  { "junggesellmuc.de", true },
  { "jungidee.at", true },
  { "jungleducks.ca", true },
  { "junglejackscastles.co.uk", true },
  { "junglememories.co.uk", true },
  { "junglist.org", true },
  { "juni.io", true },
  { "junias-fenske.de", true },
  { "juniorhandball.com", true },
  { "juniperroots.ca", true },
  { "junjun-web.net", true },
  { "junkdrome.org", true },
  { "juno.co.uk", true },
  { "junoaroma.com", true },
  { "junodownload.com", true },
  { "junta.pl", true },
  { "juozasveza.lt", true },
  { "jura-reiseschutz.de", true },
  { "jurassicbarkharrogate.co.uk", true },
  { "jurassicgolf.nl", true },
  { "juridoc.com.br", true },
  { "jurijbuga.de", true },
  { "juristique.fr", true },
  { "juristique.info", true },
  { "juristique.org", true },
  { "juristique.us", true },
  { "jurriaan.ninja", true },
  { "jusos-goettingen.de", true },
  { "just-vet-and-drive.fr", true },
  { "just-webdesign-berlin.de", true },
  { "justanothercompany.name", true },
  { "justbelieverecoverypa.com", true },
  { "justbookexcursions.com", true },
  { "justbookhotels.com", true },
  { "justbooktransfers.com", true },
  { "justboom.co", true },
  { "justbouncecastles.co.uk", true },
  { "justchunks.net", true },
  { "justgalak.com", true },
  { "justgalak.org", true },
  { "justice.gov", true },
  { "justice4assange.com", true },
  { "justin-tech.com", true },
  { "justinfreid.com", true },
  { "justinho.com", true },
  { "justinmuturifoundation.org", true },
  { "justinribeiro.com", true },
  { "justinstandring.com", true },
  { "justmensgloves.com", true },
  { "justonce.net", true },
  { "justpaste.it", true },
  { "justsmart.io", true },
  { "justsome.info", true },
  { "justthinktwice.gov", false },
  { "justupdate.me", true },
  { "justyy.com", true },
  { "juszkiewicz.com.pl", true },
  { "jutella.de", false },
  { "jutlander-netbank.dk", true },
  { "jutlander.dk", true },
  { "juttaheitland.com", true },
  { "juusujanar.eu", true },
  { "juwelierstoopman.nl", true },
  { "juyunce.com", true },
  { "jvandenbroeck.com", true },
  { "jvanerp.nl", true },
  { "jvbouncycastlehire.co.uk", true },
  { "jvdham.nl", true },
  { "jvega.me", true },
  { "jvlandscapingservices.com", true },
  { "jvphotoboothhire.co.uk", true },
  { "jvsticker.com", true },
  { "jw1.ca", true },
  { "jwatt.org", true },
  { "jwe.nl", true },
  { "jwhite.network", true },
  { "jwilsson.com", true },
  { "jwjwjw.com", true },
  { "jwmmarketing.com", true },
  { "jwnotifier.org", true },
  { "jwod.gov", true },
  { "jwplay.ml", true },
  { "jwpoore.com", true },
  { "jwschuepfheim.ch", true },
  { "jwz.org", true },
  { "jxir.de", true },
  { "jxkangyifu.com", true },
  { "jxltom.com", true },
  { "jxm.in", true },
  { "jydemarked.dk", true },
  { "jyoti-fairworks.org", true },
  { "jz585.com", true },
  { "jzbk.org", true },
  { "jzcapital.co", true },
  { "jzgj088.com", true },
  { "k-bone.com", true },
  { "k-homes.net", true },
  { "k-netz.de", true },
  { "k-plant.com", true },
  { "k-pture.com", true },
  { "k-scr.me", true },
  { "k-system.de", true },
  { "k-tube.com", true },
  { "k0.gg", true },
  { "k1024.org", true },
  { "k258059.net", true },
  { "k2mts.org", true },
  { "k3nny.fr", true },
  { "k4law.com", true },
  { "k4r.ru", true },
  { "k5197.co", true },
  { "k6729.com", true },
  { "k6957.co", true },
  { "k7azx.com", true },
  { "k8.com", true },
  { "k8013.com", true },
  { "k807.com", true },
  { "k8084.com", true },
  { "k819.com", true },
  { "k8668.com", true },
  { "k86990.com", true },
  { "k8n.de", true },
  { "k9297.co", true },
  { "k9728.co", true },
  { "k9swx.com", true },
  { "kaamoscreations.com", true },
  { "kaas.wtf", true },
  { "kaasbesteld.nl", true },
  { "kaatha-kamrater.se", true },
  { "kab-s.de", true },
  { "kabaca.design", true },
  { "kabarlinux.id", true },
  { "kabashop.com.br", true },
  { "kabat-fans.cz", true },
  { "kabellegger.nl", true },
  { "kabeltv.co.nz", true },
  { "kabeuchi.com", true },
  { "kabos.art", true },
  { "kabouterbankje.nl", true },
  { "kabulpress.org", true },
  { "kabus.org", true },
  { "kacgal.com", true },
  { "kachelfm.nl", true },
  { "kachlikova2.cz", true },
  { "kack.website", true },
  { "kadhambam.in", true },
  { "kado-ya.jp", true },
  { "kafeh-jazan.com", true },
  { "kaffau.com", true },
  { "kaffeekrone.de", true },
  { "kafoom.de", true },
  { "kagicomb.org", true },
  { "kaginalycloud.com", true },
  { "kagitreklam.com", true },
  { "kagucho.net", true },
  { "kaheim.de", true },
  { "kai-ratzeburg.de", true },
  { "kaidoblogi.eu", true },
  { "kaigojj.com", true },
  { "kaikei7.com", true },
  { "kaileymslusser.com", true },
  { "kaioken.bar", true },
  { "kaisab.com", true },
  { "kaisakura.net", true },
  { "kaisev.net", false },
  { "kaiusaltd.com", true },
  { "kaivac-emea.com", true },
  { "kaizencraft.ga", true },
  { "kaizenreporting.com", true },
  { "kaizeronion.com", true },
  { "kajak.land", true },
  { "kaka.farm", true },
  { "kakacon.nz", true },
  { "kakao-karten.de", true },
  { "kakaravaara.fi", true },
  { "kakie-gobocha.jp", true },
  { "kakie-kolesa.ru", true },
  { "kakolightingmuseum.or.jp", true },
  { "kaktuskola.se", true },
  { "kalakarclub.com", true },
  { "kalamos-psychiatrie.be", true },
  { "kalashcards.com", true },
  { "kalastus.com", true },
  { "kaleidlink.com", true },
  { "kaleidoscope.co.uk", true },
  { "kalender.com", true },
  { "kalevlamps.co.uk", true },
  { "kaliaa.fi", true },
  { "kalian.cz", true },
  { "kalifornien-tourismus.de", true },
  { "kalkulacka-havarijni.cz", true },
  { "kall.is", true },
  { "kallies-net.de", true },
  { "kalmar.com", true },
  { "kalolina.com", true },
  { "kalombo.ru", true },
  { "kaloni.info", true },
  { "kaltenbrunner.it", true },
  { "kalterersee.ch", true },
  { "kalugadeti.ru", true },
  { "kalwestelectric.com", true },
  { "kalyanmatka.guru", false },
  { "kam-serwis.pl", true },
  { "kamata-shinkyu-seikotsu.jp", true },
  { "kameari-za.space", true },
  { "kamen-master.ru", true },
  { "kamikaichimaru.com", false },
  { "kamilki.me", true },
  { "kamilmagdziak.pl", true },
  { "kaminbau-laub.de", true },
  { "kamisato-ent.com", true },
  { "kamixa.se", true },
  { "kamppailusali.fi", true },
  { "kamranmirhazar.com", true },
  { "kamui.co.uk", true },
  { "kamuniang.org", true },
  { "kan3.de", true },
  { "kana-mono.biz", true },
  { "kanaete-uranai.com", true },
  { "kanag.pl", true },
  { "kanal-tv-haensch.de", true },
  { "kandalife.com", true },
  { "kandianshang.com", true },
  { "kanecastles.com", true },
  { "kanehusky.com", false },
  { "kanetix.ca", true },
  { "kangaroo-bouncycastle.co.uk", true },
  { "kangarooislandholidayaccommodation.com.au", true },
  { "kangaroojacks.co.uk", true },
  { "kangaroos.org", true },
  { "kangaroovalleykayaks.com.au", true },
  { "kangaroovalleymuseum.com", true },
  { "kangaroovalleyolives.com.au", true },
  { "kangaroovalleyshow.org.au", true },
  { "kangaroovalleywoodcrafts.com.au", true },
  { "kangkai.me", true },
  { "kanis.ag", true },
  { "kankimaru.com", true },
  { "kanna.cf", true },
  { "kannchen.de", true },
  { "kansaiyamamoto.jp", true },
  { "kantankye.nl", true },
  { "kantanmt.com", true },
  { "kantorkita.net", true },
  { "kantorosobisty.pl", true },
  { "kanuvu.de", true },
  { "kany.me", false },
  { "kanzashi.com", true },
  { "kanzlei-gaengler.de", true },
  { "kanzlei-oehler.com", true },
  { "kanzlei-sixt.de", true },
  { "kap-genial.de", true },
  { "kap.pe", true },
  { "kappenstein.org", false },
  { "kappharn.com", true },
  { "kappie.xyz", true },
  { "kapsalonlinds.nl", true },
  { "kapseli.net", true },
  { "kaptadata.com", true },
  { "karabas.com", true },
  { "karabijnhaken.nl", false },
  { "karachi.dating", true },
  { "karalane.com", true },
  { "karamomo.net", true },
  { "karanjthakkar.com", true },
  { "karasik.by", true },
  { "karateka.org", true },
  { "karateka.ru", true },
  { "karatekit.co.uk", true },
  { "kardize24.pl", true },
  { "kardolocksmith.com", true },
  { "karenwillisholmes.com", true },
  { "karewan.ovh", true },
  { "kargl.net", true },
  { "karguine.in", true },
  { "karina.gd", true },
  { "karit.nz", true },
  { "karlbowden.com", true },
  { "karlic.net", true },
  { "karlin.run", true },
  { "karlloch.de", true },
  { "karlsmithmn.org", true },
  { "karlzotter.com", true },
  { "karmaassurance.ca", true },
  { "karmabaker.com", true },
  { "karmaflux.com", true },
  { "karmainsurance.ca", true },
  { "karmaplatform.com", true },
  { "karmaspa.se", true },
  { "karn.nu", true },
  { "karneid.info", true },
  { "karoverwaltung.de", true },
  { "karrot.world", true },
  { "karsofsystems.com", true },
  { "karsten-voigt.de", true },
  { "karta-paliwowa.pl", true },
  { "kartacha.com", true },
  { "kartar.net", false },
  { "kartatopia.com", true },
  { "kartbird.com", true },
  { "kartec.com", true },
  { "kartonmodellbau.org", true },
  { "karula.org", true },
  { "karuna.community", true },
  { "karupp-did.net", true },
  { "kasadara.com", true },
  { "kasei.im", true },
  { "kashinavi.com", true },
  { "kashmirobserver.net", true },
  { "kasinobonus.com", true },
  { "kasko.io", true },
  { "kasnoffskinclinic.com", true },
  { "kassa.at", true },
  { "kassa.expert", true },
  { "kastankaoffice.cz", true },
  { "kastelruth.biz", true },
  { "kastgroup.com", true },
  { "kastorsky.ru", true },
  { "kat.marketing", true },
  { "katagena.com", true },
  { "kataiszilveszter.hu", true },
  { "katalogbajugamismu.com", true },
  { "katalogkapsli.pl", true },
  { "katarsisuib.no", true },
  { "katcleaning.com.au", true },
  { "kateduggan.net", true },
  { "katekligys.com", true },
  { "katemihalikova.cz", true },
  { "katericke.com", true },
  { "katex.org", true },
  { "kathardt.de", true },
  { "kathegiraldo.com", true },
  { "kati-raumplaner.de", true },
  { "katiechai.xyz", true },
  { "katieriker.com", true },
  { "katieskandy.co.uk", true },
  { "katieskastles.co.uk", true },
  { "katja-und-ronny.de", true },
  { "katjavoneysmondt.de", true },
  { "katka.info", true },
  { "katnunn.co.uk", true },
  { "kato-yane.com", true },
  { "katscastles.co.uk", true },
  { "katsunet.com", true },
  { "kattelans.eu", true },
  { "katyl.info", false },
  { "katyusha.net", true },
  { "katzensklave.me", true },
  { "katzrkool.xyz", true },
  { "kau-boys.com", true },
  { "kau-boys.de", true },
  { "kaufberatung.community", true },
  { "kavorka.me", true },
  { "kavovary-kava.cz", true },
  { "kawaii.io", true },
  { "kaweus.de", true },
  { "kay.la", true },
  { "kayo.digital", true },
  { "kaypasocks.com", true },
  { "kaysis.gov.tr", false },
  { "kazakov.lt", true },
  { "kazancci.com", true },
  { "kazand.lt", true },
  { "kazandaemon.ru", true },
  { "kazek.com.pl", true },
  { "kazekprzewozy.pl", true },
  { "kazu.click", true },
  { "kazuhirohigashi.com", true },
  { "kazumi.ro", true },
  { "kazy111.info", true },
  { "kb09.net", true },
  { "kb88.com", true },
  { "kb883.cc", true },
  { "kb8882.com", true },
  { "kb88dc23.com", true },
  { "kba-online.de", true },
  { "kbb-ev.de", true },
  { "kbbouncycastlehire.co.uk", true },
  { "kbc.be", true },
  { "kbcequitas.hu", true },
  { "kbit.dk", true },
  { "kbjorklu.com", true },
  { "kbleventhire.co.uk", true },
  { "kbterapicenter.se", true },
  { "kc-holzfaeller.de", true },
  { "kc1hbk.com", true },
  { "kc3.moe", true },
  { "kc5mpk.com", true },
  { "kcliner.com", true },
  { "kcmicapital.com", true },
  { "kcolford.com", false },
  { "kcshipping.co.uk", true },
  { "kcsordparticipation.org", true },
  { "kd.net.nz", true },
  { "kdcp.pw", true },
  { "kdex.de", true },
  { "kdw.cloud", true },
  { "kdyby.org", true },
  { "ke.fo", true },
  { "ke7tlf.us", true },
  { "keakon.net", true },
  { "keane.space", true },
  { "keaysmillwork.com", true },
  { "keb.com.au", true },
  { "keb.net.au", true },
  { "kebabbesteld.nl", true },
  { "kebabbruce.com", false },
  { "kecht.at", true },
  { "kedarastudios.com", true },
  { "kedv.es", true },
  { "kee.pm", true },
  { "keeckee.ga", true },
  { "keeleysam.com", true },
  { "keelove.net", true },
  { "keengamer.com", true },
  { "keepa.com", true },
  { "keeperapp.com", true },
  { "keeperklan.com", false },
  { "keepersecurity.com", true },
  { "keepingtheplot.co.uk", true },
  { "keepiteasy.eu", true },
  { "keepitsecure24.com", true },
  { "keepleft.gr", true },
  { "keepsight.org.au", true },
  { "keevault.pm", true },
  { "keevitaja.com", true },
  { "keeweb.info", true },
  { "keez.cf", true },
  { "keganthorrez.com", true },
  { "kehlenbach.net", true },
  { "keian.tk", true },
  { "keifel.de", true },
  { "kein-design.de", true },
  { "keinanung.nl", true },
  { "keinefilterblase.de", true },
  { "keisaku.org", true },
  { "keishiando.com", true },
  { "keithlomax.com", true },
  { "keithws.net", true },
  { "keke-shop.ch", true },
  { "kekku.li", true },
  { "keksi.io", true },
  { "kela.jp", true },
  { "keldan.fo", true },
  { "kelderwijnen.nl", true },
  { "kelgtermans-usedcars.be", true },
  { "kelheor.space", true },
  { "kelleymcchesney.us", true },
  { "kellimacconnell.com", true },
  { "kellygrenard.com", true },
  { "kellyskastles.co.uk", true },
  { "kelsa.io", true },
  { "kelsall39.com", true },
  { "kelvinfichter.com", false },
  { "kemmerer-net.de", true },
  { "kempkens.io", true },
  { "kempo-sissach.ch", true },
  { "kemptown.co.uk", true },
  { "kemptown.com", true },
  { "kemptown.net", true },
  { "ken.fm", true },
  { "kenalsworld.com", true },
  { "kenbonny.net", true },
  { "kendermore.it", true },
  { "kendernet.com", true },
  { "kengilmour.com", false },
  { "kenguntokku.jp", true },
  { "kenia-vakantie.nl", true },
  { "kennedy.ie", true },
  { "kennedyinsurancesolutions.com", true },
  { "kenners.org", true },
  { "kennethaasan.no", true },
  { "kennethlim.me", true },
  { "kenneths.org", true },
  { "kenny-peck.com", true },
  { "kennynet.co.uk", true },
  { "keno.im", true },
  { "kenokallinger.at", true },
  { "kenoschwalb.com", false },
  { "kenrogers.co", false },
  { "kens.pics", true },
  { "kensbouncycastles.co.uk", true },
  { "kenscustomfloors.com", true },
  { "kenshobox.net", true },
  { "kensparkesphotography.com", true },
  { "kentec.net", false },
  { "kenterlis.gr", true },
  { "kenvix.com", true },
  { "kenyons.info", true },
  { "keops-spine.fr", true },
  { "keops-spine.us", true },
  { "kep-sbt.hu", true },
  { "kepkonyvtar.hu", true },
  { "keponews.com", true },
  { "kepsbt.hu", true },
  { "keralit.nl", true },
  { "kerebro.com", true },
  { "kerforhome.com", false },
  { "kerijacoby.com", true },
  { "kermadec.com", true },
  { "kermadec.fr", true },
  { "kermadec.net", true },
  { "kernel-error.de", true },
  { "kernelpanics.nl", true },
  { "kernelprogrammer.com", true },
  { "kerrfrequencycombs.org", true },
  { "kerrnel.com", true },
  { "kersmexico.com", true },
  { "kerstkaart.nl", true },
  { "kersvers.agency", true },
  { "kerus.net", true },
  { "kerzyte.net", true },
  { "kessawear.com", true },
  { "kesslerwine.com", true },
  { "ketamine.co.uk", true },
  { "ketaminecareclinic.com", true },
  { "ketosecology.co.uk", true },
  { "ketotadka.com", true },
  { "kettlebellkrusher.com", true },
  { "kettner.com", true },
  { "ketty-voyance.com", true },
  { "keutel.net", true },
  { "kevchia.com", true },
  { "kevertje.net", true },
  { "kevin-darmor.eu", true },
  { "kevin-ta.com", true },
  { "kevinapease.com", true },
  { "kevinbusse.de", true },
  { "kevincox.ca", false },
  { "kevincramer.net", true },
  { "kevindavid.org", true },
  { "kevindienst.blog", true },
  { "kevinfoley.cc", true },
  { "kevinfoley.org", true },
  { "kevinhill.nl", true },
  { "kevinhq.com", true },
  { "kevinkla.es", true },
  { "kevinlocke.name", true },
  { "kevinmeijer.nl", true },
  { "kevinmoreland.com", true },
  { "kevinmorssink.nl", true },
  { "kevinpirnie.com", false },
  { "kevinrandles.com", false },
  { "kevinratcliff.com", true },
  { "kevinschreuder.com", true },
  { "kevyn.lu", true },
  { "kexino.com", true },
  { "kexueboy.com", true },
  { "keybase.io", true },
  { "keybored.co", true },
  { "keybored.me", true },
  { "keycdn.com", true },
  { "keycenter.com.br", true },
  { "keycontainers.co.za", true },
  { "keyerror.com", true },
  { "keygen.sh", true },
  { "keyholdingservices.co.uk", true },
  { "keyhomechecker.com", true },
  { "keyihao.cn", true },
  { "keyinfo.io", true },
  { "keylaserinstitute.com", true },
  { "keylength.com", true },
  { "keymach.com", true },
  { "keymicrosystems.com", true },
  { "keynes.id.au", true },
  { "keys247.co.uk", true },
  { "keysofart.com", true },
  { "keystoneok.com", false },
  { "keysupport.org", true },
  { "keywalker.co.jp", true },
  { "keywebdesign.nl", true },
  { "keyyek.com", false },
  { "kf5252.com", true },
  { "kf7joz.com", true },
  { "kfassessment.com", true },
  { "kffs.ru", true },
  { "kfirba.me", true },
  { "kfm.ink", true },
  { "kforesund.se", true },
  { "kfv-kiel.de", false },
  { "kfz-hantschel.de", true },
  { "kfz-service-wachtmann.de", true },
  { "kg7.pl", true },
  { "kgm-irm.be", true },
  { "kgnk.ru", true },
  { "kgv-schlauroth.de", true },
  { "khaganat.net", true },
  { "khairul-zamri.com", true },
  { "khaledgarbaya.net", false },
  { "khanovaskola.cz", true },
  { "khas.co.uk", true },
  { "khasiatmanfaat.com", true },
  { "kheshtar.pl", true },
  { "khetmaal.com", true },
  { "khetzal.info", true },
  { "khg-orchester.de", true },
  { "khipu.com", true },
  { "khmb.ru", false },
  { "khojirdesign.ir", true },
  { "khorne.me", true },
  { "khoury-dulla.ch", true },
  { "khs1994.com", true },
  { "khslaw.com", true },
  { "khudothiswanpark.vn", true },
  { "khushiandjoel.com", true },
  { "kiadoapartman.hu", true },
  { "kiahoriane.com", true },
  { "kiano.net", true },
  { "kiapartscenter.net", true },
  { "kiarayoga.com", true },
  { "kibea.net", true },
  { "kibibit.net", true },
  { "kibriscicek.net", true },
  { "kick-in.nl", true },
  { "kickasscanadians.ca", true },
  { "kickedmycat.com", true },
  { "kickstart.com.pk", false },
  { "kicou.info", false },
  { "kiczela.eu", true },
  { "kidaptive.com", true },
  { "kiddieschristian.academy", true },
  { "kiddyboom.ua", true },
  { "kids-at-home.ch", true },
  { "kids-castles.com", true },
  { "kids-world.dk", true },
  { "kids2day.in", true },
  { "kidsareatrip.com", true },
  { "kidsclub.photos", true },
  { "kidsdaysout.co.uk", true },
  { "kidsdinefree.com", true },
  { "kidsforsavingearth.org", true },
  { "kidsinwoods-interfacesouth.org", true },
  { "kidsmark.net", true },
  { "kidsneversleep.com", true },
  { "kidspaper.nl", true },
  { "kidsplay-plymouth.co.uk", true },
  { "kidsplaybouncycastles.co.uk", true },
  { "kidswallstickers.com.au", true },
  { "kidtoyshop.ru", true },
  { "kidzpartiesllp.co.uk", true },
  { "kidzsmile.co.uk", true },
  { "kiebel.de", true },
  { "kiehls.pt", true },
  { "kiekin.org", true },
  { "kiekko.pro", true },
  { "kieran.de", true },
  { "kieran.ie", true },
  { "kieranjones.uk", true },
  { "kiesuwkerstkaart.nl", true },
  { "kievkiralikotel.com", true },
  { "kigmbh.com", true },
  { "kiisu.club", true },
  { "kikbb.com", true },
  { "kiki-voice.jp", true },
  { "kiknudes.co", true },
  { "kiku.pw", true },
  { "kileahh.fr", true },
  { "kilianvalkhof.com", true },
  { "killaraapartments.com.au", true },
  { "killdeer.com", true },
  { "killerkink.net", true },
  { "killerrobots.com", true },
  { "killymoonbouncycastles.com", true },
  { "kilobyte22.de", true },
  { "kilogram.nl", true },
  { "kilometertje.nl", true },
  { "kimbal.co.uk", true },
  { "kimdumaine.com", true },
  { "kimiris.com", true },
  { "kimis.gr", true },
  { "kimisia.net", true },
  { "kimitang.com", true },
  { "kimkuhlmanphoto.com", true },
  { "kimmel.com", true },
  { "kimmel.in", true },
  { "kimochi.info", true },
  { "kimono-rental-one.com", true },
  { "kimotodental.com", true },
  { "kimsufi-jordi.tk", true },
  { "kimtran.kim", true },
  { "kimtstore.com", true },
  { "kin.life", true },
  { "kin.pet", true },
  { "kinautas.com", true },
  { "kindconcentrates.com", true },
  { "kinderarzt-berlin-zia.de", true },
  { "kinderbasar-luhe.de", true },
  { "kinderchor-bayreuth.de", true },
  { "kinderkleding.news", true },
  { "kinderpneumologie.ch", true },
  { "kindertagespflege-rasselbande-halle.de", true },
  { "kinderzahn-bogenhausen.de", true },
  { "kindesfreude.ch", true },
  { "kindfotografie.nl", true },
  { "kindlezs.com", true },
  { "kine-duthil.fr", true },
  { "kinepolis-studio.be", true },
  { "kinerd.me", true },
  { "kinesiomed-cryosauna.gr", true },
  { "kinetic.ventures", true },
  { "kinetiq.com", true },
  { "king-of-the-castles.com", true },
  { "kingant.net", true },
  { "kinganywhere.eu", true },
  { "kingbird.me", true },
  { "kingdoms.gg", true },
  { "kingiescastles.co.uk", true },
  { "kingjamesbibleonline.org", true },
  { "kingofshooting.com", true },
  { "kingofthecastlecoventry.co.uk", true },
  { "kingofthecastlesentertainments.co.uk", true },
  { "kingofthecastlesouthwales.co.uk", true },
  { "kingofthecastlesrhyl.co.uk", true },
  { "kingsfoot.com", true },
  { "kingsgateseptic.com", true },
  { "kingstclinic.com", true },
  { "kingtreeexperts.com", true },
  { "kingwoodtxlocksmith.com", true },
  { "kini24.ru", true },
  { "kinkcafe.net", true },
  { "kinkenonline.com", true },
  { "kinkyhookup.com", true },
  { "kinmunity.com", true },
  { "kinnikinnick.com", true },
  { "kinniyaonlus.com", true },
  { "kinocheck.de", true },
  { "kinohled.cz", true },
  { "kinomoto.ovh", false },
  { "kinos.nl", true },
  { "kinozal-tv.appspot.com", true },
  { "kinsights.com", false },
  { "kintawifi.com", false },
  { "kintone.com", true },
  { "kintore.tv", true },
  { "kiocloud.com", true },
  { "kiot.eu", true },
  { "kipa.at", true },
  { "kipiradio.com", true },
  { "kippenbart.gq", true },
  { "kipsu.com", true },
  { "kipwells32.com", true },
  { "kiragameforum.net", true },
  { "kirainmoe.com", true },
  { "kiraku.co", true },
  { "kirbear.com", true },
  { "kirchen-im-web.de", false },
  { "kirchengemeinde-markt-erlbach.de", true },
  { "kirchhoff-getraenke.de", true },
  { "kircp.com", true },
  { "kirei.se", true },
  { "kirig.ph", true },
  { "kirikira.moe", true },
  { "kirill.ws", true },
  { "kirillaristov.com", true },
  { "kirillpokrovsky.de", false },
  { "kirinas.com", true },
  { "kirinuki.jp", true },
  { "kirkforcongress.com", true },
  { "kirkforillinois.com", true },
  { "kirkovsky.com", true },
  { "kirkwoodfence.com", true },
  { "kiro-ku.com", true },
  { "kiropraktorvard.se", true },
  { "kirrie.pe.kr", true },
  { "kirsch-gestaltung.de", true },
  { "kirschbaum.me", true },
  { "kirstenbos.ca", true },
  { "kirstin-peters.de", true },
  { "kirwandigital.com", true },
  { "kisallatorvos.hu", true },
  { "kisel.org", true },
  { "kisiselveri.com", true },
  { "kiskeedeesailing.com", true },
  { "kisma.de", true },
  { "kissflow.com", true },
  { "kissgyms.com", true },
  { "kisskiss.ch", true },
  { "kissmycreative.com", true },
  { "kissoft.ro", true },
  { "kisun.co.jp", false },
  { "kita-sun.com", true },
  { "kitabmimpi.com", true },
  { "kitabnamabayi.com", true },
  { "kitacoffee.com", true },
  { "kitbag.com.au", true },
  { "kitchen-profi.by", true },
  { "kitchen-profi.com.ua", true },
  { "kitchen-profi.kz", true },
  { "kitchenpunx.com", false },
  { "kiteadventure.nl", true },
  { "kiteschooledam.nl", true },
  { "kiteschoolijmuiden.nl", true },
  { "kiteschoolkatwijk.nl", true },
  { "kiteschoolnoordwijk.nl", true },
  { "kiteschoolschellinkhout.nl", true },
  { "kiteschoolwijkaanzee.nl", true },
  { "kiteschoolzandvoort.nl", true },
  { "kitpartners.com", true },
  { "kitsapsolutions.com", true },
  { "kittmedia.com", true },
  { "kittpress.com", true },
  { "kivitelezesbiztositas.hu", true },
  { "kiwi-bird.xyz", true },
  { "kiwi.com", true },
  { "kiwi.digital", true },
  { "kiwi.wiki", true },
  { "kix.moe", true },
  { "kiyotatsu.com", true },
  { "kizomba.info", true },
  { "kizzedbykelz.com", true },
  { "kizzycode.de", true },
  { "kj-prince.com", true },
  { "kj1396.net", true },
  { "kj1397.com", true },
  { "kjaer.io", true },
  { "kjarrval.is", true },
  { "kjchernov.info", true },
  { "kjellner.com", true },
  { "kjelltitulaer.com", true },
  { "kjellvn.net", true },
  { "kjfaudio.com", true },
  { "kjmedia.dk", true },
  { "kjnotes.com", true },
  { "kk-neudorf-duissern.de", false },
  { "kk.in.th", true },
  { "kk5197.co", true },
  { "kk6729.co", true },
  { "kk6729.com", true },
  { "kk6957.co", true },
  { "kk9297.co", true },
  { "kk9397.com", true },
  { "kk9721.com", true },
  { "kk9728.co", true },
  { "kki.org", true },
  { "kkovacs.eu", true },
  { "kkr-bridal.net", true },
  { "kks-karlstadt.de", true },
  { "kksg.com", true },
  { "kkyy.me", true },
  { "kkzxak47.com", true },
  { "kl-diaetist.dk", true },
  { "kl008888.com", true },
  { "klaasmeijerbodems.nl", true },
  { "klaim.us", true },
  { "klanggut.at", true },
  { "klares-licht.de", true },
  { "klarika.com", true },
  { "klarmobil-empfehlen.de", true },
  { "klauke-enterprises.com", true },
  { "klausbrinch.dk", false },
  { "klausen.dk", true },
  { "klaver.it", true },
  { "klaw.xyz", true },
  { "klaxon.me", true },
  { "klcreations.co.uk", true },
  { "kle.cz", true },
  { "kleaning.by", true },
  { "klebeband.eu", true },
  { "klebetape.de", true },
  { "kledingrekken.nl", false },
  { "kleim.fr", true },
  { "kleinblogje.nl", false },
  { "kleine-dingen.nl", true },
  { "kleine-strandburg-heringsdorf.de", true },
  { "kleine-strandburg.com", true },
  { "kleine-strolche-lich.de", true },
  { "kleine-viecherei.de", true },
  { "kleineanfragen.de", true },
  { "kleinestrandburg-heringsdorf.de", true },
  { "kleinestrandburg-usedom.de", true },
  { "kleineviecherei.de", true },
  { "kleinfein.co", true },
  { "kleinsys.com", true },
  { "kleintransporte.net", true },
  { "klemkow.net", true },
  { "klemkow.org", true },
  { "klempin.se", true },
  { "kleppe.co", true },
  { "kleteckova.cz", true },
  { "klev.su", true },
  { "kli.is", true },
  { "klickstdu.com", true },
  { "kliemann.me", true },
  { "klimaloven.no", true },
  { "klimapartner.de", true },
  { "klimapartner.net", true },
  { "klimchuk.com", true },
  { "klingenundmesser.com", true },
  { "klinik-fuer-aesthetische-zahnheilkunde.de", true },
  { "klinikac.co.id", false },
  { "klinkenberg.ws", true },
  { "klishyn.com", true },
  { "klm-huisjes.nl", true },
  { "klmhouses.com", true },
  { "klocker-ausserlechner.com", true },
  { "klocksnack.se", false },
  { "kloia.com", true },
  { "klop.info", true },
  { "klose.family", true },
  { "klosko.net", true },
  { "kloudboy.com", true },
  { "kls-agency.com.ua", false },
  { "klseet.com", true },
  { "klssn.com", true },
  { "klu.io", true },
  { "klubxanadu.cz", true },
  { "kluck.me", true },
  { "klugemedia.de", true },
  { "klustermedia.com", true },
  { "klusweb-merenwijk.nl", true },
  { "klva.cz", true },
  { "kmashworth.co.uk", true },
  { "kmkz.jp", true },
  { "kmsci.com.ph", true },
  { "kn007.net", true },
  { "kn40la.com", true },
  { "kn4ivj.com", true },
  { "kn4ola.com", true },
  { "knaake.net", true },
  { "knab-networks.com", true },
  { "knapp.noip.me", true },
  { "knapp.servehttp.com", true },
  { "knarcraft.net", true },
  { "kncg.pw", true },
  { "kndkv.com", true },
  { "kndrd.io", true },
  { "kneblinghausen.de", true },
  { "knechtology.com", true },
  { "knegten-agilis.com", true },
  { "knep.me", true },
  { "knetterbak.nl", true },
  { "kngk-azs.ru", true },
  { "kngk-group.ru", true },
  { "kngk-transavto.ru", true },
  { "kngk.org", true },
  { "kngkng.com", true },
  { "knight-industries.org", true },
  { "knightsbridge.net", true },
  { "knightsbridgewine.com", true },
  { "knihovnajablonne.cz", true },
  { "knip.ch", true },
  { "knispel-online.de", true },
  { "knitfarious.com", true },
  { "knmv.nl", true },
  { "knnet.ch", true },
  { "knoji.com", true },
  { "knop.info", true },
  { "knot-store.com", true },
  { "knowarth.com", true },
  { "knowledgeforce.com", true },
  { "knowledgehook.com", true },
  { "knowyourday.ai", true },
  { "knthost.com", true },
  { "knurps.de", true },
  { "knuthildebrandt.de", true },
  { "knygos.lt", true },
  { "ko-sys.com", true },
  { "ko.si", true },
  { "koalas.org", true },
  { "kobejet.com", true },
  { "kobezda.net", true },
  { "kobofarm.com", true },
  { "koboldmalade.fr", true },
  { "kobolya.hu", true },
  { "kocherev.org", true },
  { "kochereva.com", true },
  { "kochhar.net", true },
  { "kochinke.com", true },
  { "kochinke.us", true },
  { "kockanakocko.si", true },
  { "kodak-ism.com", true },
  { "kodamail.com", true },
  { "kodden.com.br", true },
  { "kode-it.de", true },
  { "kode.ch", true },
  { "kodify.net", true },
  { "koe.hn", true },
  { "koebbes.de", true },
  { "koecollege.com", true },
  { "koeeusa.org", true },
  { "koehlhoff.de", true },
  { "koeldezomerdoor.nl", true },
  { "koelnmafia.de", true },
  { "koenigsbrunner-tafel.de", true },
  { "koenleemans.nl", true },
  { "koenrh.com", true },
  { "koenrh.net", true },
  { "koenrh.nl", true },
  { "koenrouwhorst.com", true },
  { "koenrouwhorst.nl", true },
  { "koenzk.nl", true },
  { "koerperkult.ch", true },
  { "koertner-muth.com", true },
  { "koertner-muth.de", true },
  { "koethen-markt.de", true },
  { "koetjesenkanker.nl", true },
  { "kofler.info", true },
  { "kogak.ninja", true },
  { "kogax.com", true },
  { "kogcoder.com", true },
  { "kogi.fr", true },
  { "kogro.de", true },
  { "kogudesi.com", true },
  { "koha.be", true },
  { "kohlchan.net", true },
  { "kohlistkool.tk", true },
  { "koho.fi", true },
  { "kohoutsautomotive.com", true },
  { "kohsandra.com", true },
  { "kohu.nz", true },
  { "koi-lexikon.de", true },
  { "koicenter-thuine.de", true },
  { "koifish.org", true },
  { "kojip.com", true },
  { "koka-shop.de", true },
  { "kokensupport.com", true },
  { "kokobaba.com", true },
  { "kokona.ch", true },
  { "kokoushuvila.fi", true },
  { "kokumoto.com", true },
  { "kolania.de", true },
  { "kolania.net", true },
  { "kolaprestaurant.com", true },
  { "kolas.in", true },
  { "kolbeinsson.se", true },
  { "kolcsey.eu", true },
  { "kolibrisolutions.nl", true },
  { "kolin.org", true },
  { "kolitel.com", true },
  { "kolizaskrap.bg", true },
  { "kolja-engelmann.de", true },
  { "koljakrekow.de", true },
  { "kolkataflowermall.com", true },
  { "kollect.ie", true },
  { "kollega.it", true },
  { "kollegamenti.it", true },
  { "kolmann.at", true },
  { "kolmann.eu", true },
  { "kolpingsfamilie-vechta-maria-frieden.de", true },
  { "koluke.co", true },
  { "koluke.com", true },
  { "komall.net", true },
  { "komelin.com", true },
  { "komenamanda.de", true },
  { "kometia.com", true },
  { "komicloud.com", true },
  { "komidoc.com", true },
  { "komiksbaza.pl", true },
  { "kominfo.go.id", true },
  { "kominfo.net", false },
  { "kominki-sauny.pl", true },
  { "komintek.ru", true },
  { "komischkeszeug.de", true },
  { "kommaer.dk", true },
  { "kommune42.org", true },
  { "komodolabs.com", true },
  { "komoju.com", true },
  { "komok.co.uk", true },
  { "komp247.pl", true },
  { "kompetenzkurs.de", true },
  { "kompjoeter.net", true },
  { "komplet.sk", true },
  { "kon-sil.de", true },
  { "kondi.net", true },
  { "kondou-butsudan.com", true },
  { "kongar.org", true },
  { "kongress-hostessen.de", true },
  { "koniecfica.sk", false },
  { "konijntjes.nl", true },
  { "konings.it", false },
  { "koningskwartiertje.nl", true },
  { "konklone.com", true },
  { "konosuke.jp", true },
  { "konplott.shop", true },
  { "konpyuta.nl", true },
  { "konsertoversikt.no", true },
  { "konst.se", true },
  { "kontaxis.org", true },
  { "kontorhaus-stralsund.de", true },
  { "konventa.net", true },
  { "konyalian.com", true },
  { "konzertheld.de", true },
  { "koodaklife.com", true },
  { "koodimasin.ee", true },
  { "koodimasin.eu", true },
  { "kooer.org", true },
  { "koof.win", true },
  { "koolauwomenshealthcare.com", true },
  { "kooli.ee", true },
  { "koolikatsed.ee", true },
  { "koolitee.ee", true },
  { "kooliveeb.ee", true },
  { "koop-bremen.de", true },
  { "kooponline.eu", true },
  { "koot.nl", true },
  { "kooxdiving.com", true },
  { "koozal.de", true },
  { "kopfkrieg.org", false },
  { "kopfundseele.de", true },
  { "kopjethee.nl", true },
  { "koplancpa.com", true },
  { "kopplin.family", true },
  { "koptev.ru", true },
  { "kopteva.ru", true },
  { "korbel-loziska.cz", true },
  { "korben.info", true },
  { "kordamed.ee", true },
  { "korea-dpr.org", true },
  { "korea.dating", true },
  { "koreaboo.com", true },
  { "koreaninhd.com", true },
  { "korem011-tniad.mil.id", true },
  { "koretech.nl", true },
  { "korinar.com", true },
  { "kornrunner.net", true },
  { "korobkovsky.ru", false },
  { "koroknaimedical.hu", true },
  { "korosiprogram.hu", true },
  { "korp.fr", true },
  { "korrelzout.nl", true },
  { "kortgebyr.dk", true },
  { "korup.com", true },
  { "koryfi.com", true },
  { "kos4all.com", true },
  { "kosaki.moe", true },
  { "kosherjava.com", true },
  { "kosho.org", true },
  { "kosinc.org", true },
  { "kosmos.org.tw", true },
  { "kost-magazin.de", true },
  { "kostal.com", true },
  { "kostecki.com", true },
  { "kostecki.org", true },
  { "kostecki.tel", true },
  { "kostya.ws", true },
  { "kosuzu.moe", true },
  { "kother.org", true },
  { "kotilinkki.fi", true },
  { "kotitesti.fi", true },
  { "kotke.ru", true },
  { "kotly-marten.com.ua", true },
  { "kotobox.net", true },
  { "kotois.com", true },
  { "kotonoha.cafe", true },
  { "kotori.love", true },
  { "kouki-food.com", true },
  { "koumakan.cc", true },
  { "koumuwin.com", true },
  { "koushinjo.org", true },
  { "kouten-jp.com", true },
  { "kov.space", true },
  { "koval.io", true },
  { "kovals.sk", true },
  { "kovehitus.ee", true },
  { "kovspace.com", true },
  { "kovuthehusky.com", true },
  { "kowalmik.tk", true },
  { "kowalstwo.com.pl", true },
  { "kowarschick.de", true },
  { "koyo.kr", true },
  { "kozawa.tokyo", true },
  { "kozossegireklamozas.hu", true },
  { "kozuch.biz", true },
  { "kpfanworld.com", true },
  { "kpforme.org", true },
  { "kpinvest.eu", true },
  { "kplasticsurgery.com", true },
  { "kplnet.net", true },
  { "kpmgclientcollab.co.nz", true },
  { "kpop.re", true },
  { "kpumuk.info", true },
  { "kpx1.de", true },
  { "kr.search.yahoo.com", false },
  { "kr0n.dk", true },
  { "krachtinverbinding.nl", true },
  { "kradalby.no", true },
  { "kraft.blog", true },
  { "kraft.im", true },
  { "kraftfleisch.de", true },
  { "kraftzeiten.de", true },
  { "krag.be", true },
  { "kraga.sk", true },
  { "kraiwan.com", true },
  { "kraiwon.com", true },
  { "kraken.io", true },
  { "kraken.site", true },
  { "kralik.io", true },
  { "kralovskapradelna.cz", true },
  { "kralovstvimap.cz", true },
  { "kram.nz", true },
  { "krambeutel.de", true },
  { "kramer-edelstahl.de", true },
  { "krampus-fischamend.at", true },
  { "kramsj.uk", true },
  { "krang.org.uk", true },
  { "krankenpflege-haushaltshilfe.de", true },
  { "kranz.space", false },
  { "krasnodar-avia.ru", true },
  { "krasnodar-pravoved.ru", true },
  { "krasovsky.me", true },
  { "krautomat.com", true },
  { "kraynik.com", true },
  { "krayx.com", true },
  { "krazykastles.co.uk", true },
  { "krazykoolkastles.com", true },
  { "krazyphotobooths.co.uk", true },
  { "kreationnext.com", false },
  { "kreativbande.com", true },
  { "kreativelabs.ch", true },
  { "kreativstrecke.de", true },
  { "kredigram.com", true },
  { "kredit-abzocke.com", true },
  { "kredita.dk", true },
  { "kreditkacs.cz", true },
  { "kredytzen.pl", true },
  { "kreen.org", true },
  { "krehl.io", true },
  { "kremalicious.com", true },
  { "kretschmann.consulting", true },
  { "kreuzpfadfinder.de", true },
  { "kriechel.de", true },
  { "krikorianconstruction.com", true },
  { "krinetzki.de", true },
  { "kringloopwinkelsteenwijk.nl", true },
  { "krinnovations.ie", true },
  { "kriptokereso.com", true },
  { "kriptosec.com", true },
  { "kris.click", true },
  { "krise-chance.ch", true },
  { "krisftp.fr", true },
  { "krishnenduayur.org", true },
  { "krishofer.com", true },
  { "krismurray.co.uk", true },
  { "krisstarkey.co.uk", true },
  { "kristall-energie.at", true },
  { "kristenpaigejohnson.com", true },
  { "kristiehill.com", true },
  { "kristikala.nl", true },
  { "kristinbailey.com", false },
  { "kristofba.ch", true },
  { "kristofdv.be", true },
  { "kritikawebu.cz", true },
  { "kritikos.io", true },
  { "krizevci.info", true },
  { "krmeni.cz", false },
  { "kroell.net", true },
  { "krokedil.se", true },
  { "kromamoveis.com.br", true },
  { "kromax.it", true },
  { "kromonos.net", false },
  { "kroon.email", true },
  { "kropkait.pl", true },
  { "krrn.de", true },
  { "krsaustralia.com.au", true },
  { "krsn.de", true },
  { "krsvrs.nl", true },
  { "kruin.net", true },
  { "kruisselbrink.com", true },
  { "kruk.co", true },
  { "krukhmer.com", true },
  { "krumberconsulting.com", true },
  { "krupa.net.pl", false },
  { "kruselegal.com.au", true },
  { "krutka.cz", true },
  { "kruzhki-s-kartinkami.ru", true },
  { "kry.no", true },
  { "kry.se", true },
  { "kryglik.com", true },
  { "krypmonet.com", false },
  { "krypsys.com", true },
  { "krypt.com", true },
  { "kryptera.se", true },
  { "kryptomech.com", true },
  { "kryptux.xyz", true },
  { "krytykawszystkiego.com", true },
  { "krytykawszystkiego.pl", true },
  { "kryx.de", true },
  { "krzyzowki123.pl", true },
  { "ks-watch.de", true },
  { "ks0618.com", true },
  { "ks0718.com", true },
  { "ks0768.com", true },
  { "ks0776.com", true },
  { "ks080.com", true },
  { "ks0877.com", true },
  { "ks0996.com", true },
  { "ks191.com", true },
  { "ks381.com", true },
  { "ks5000.com", true },
  { "ks5660.com", true },
  { "ks628.com", true },
  { "ks681.com", true },
  { "ks88.com", true },
  { "ks88.org", true },
  { "kscarlett.com", true },
  { "kschv-rdeck.de", true },
  { "kselenia.ee", true },
  { "ksero.center", true },
  { "ksero.wroclaw.pl", true },
  { "kshlm.in", true },
  { "ksmmmo.org.tr", true },
  { "ksoc.com", true },
  { "ksopp.si", true },
  { "kspg.tv", true },
  { "kssk.de", true },
  { "ksukelife.com", true },
  { "kt-events.de", true },
  { "kt-zoe.com", true },
  { "kt3i.com", true },
  { "kthnxbai.xyz", true },
  { "ktm-troxler.de", true },
  { "ktmclubitalia.it", true },
  { "kts-thueringen.de", true },
  { "ktsee.eu.org", true },
  { "ktsofas.gr", true },
  { "ktw.lv", true },
  { "ku-7.club", true },
  { "ku.io", false },
  { "kuaimen.bid", true },
  { "kuaiyaojing.com", true },
  { "kualiti.net", true },
  { "kualo.co.uk", true },
  { "kualo.com", true },
  { "kualo.in", true },
  { "kuaza.com", false },
  { "kub.hr", true },
  { "kubik-rubik.de", false },
  { "kubkprf.ru", true },
  { "kublis.ch", true },
  { "kuchen-am-stiel.de", true },
  { "kucloud.win", true },
  { "kucnibudzet.com", true },
  { "kucukayvaz.com", true },
  { "kudo.co.id", true },
  { "kuechenprofi-group.de", false },
  { "kuechenserver.de", true },
  { "kuechenserver.org", true },
  { "kuehndel.org", true },
  { "kuehnel-bs.de", true },
  { "kuehnel-online.eu", true },
  { "kuehnel.org", false },
  { "kuemmerlin.eu", true },
  { "kuemmling.eu", true },
  { "kuhn-elektrotechnik.de", true },
  { "kuhne-electronic.de", true },
  { "kuhnelautorepair.com", true },
  { "kujadin.de", true },
  { "kukal.cz", true },
  { "kuketz-blog.de", true },
  { "kuketz-security.de", true },
  { "kulde.net", true },
  { "kulinaristi.fi", true },
  { "kulivps.com", true },
  { "kulopo.com", true },
  { "kultsar.com", true },
  { "kulturmel.ch", true },
  { "kum.com", true },
  { "kuma.es", true },
  { "kumachan.biz", true },
  { "kumalog.com", true },
  { "kumasanda.jp", true },
  { "kumbayops.com", true },
  { "kumpulannamabayi.com", true },
  { "kunaldesai.blog", true },
  { "kundenerreichen.com", true },
  { "kundenerreichen.de", true },
  { "kungerkueken.de", true },
  { "kunra.de", true },
  { "kunstdrucke-textildruck.de", true },
  { "kunsthandel-augustus-rex.de", true },
  { "kunstundunrat.de", true },
  { "kunvn.com", true },
  { "kuoruan.com", true },
  { "kupaa.ink", true },
  { "kupferschmids.ch", true },
  { "kupferstichshop.com", true },
  { "kupiclub.com", true },
  { "kupid.com", true },
  { "kupiec.eu.org", true },
  { "kupiewszystkieauta.pl", true },
  { "kupimlot.ru", true },
  { "kupinska.pl", true },
  { "kupleno.com", true },
  { "kuponrazzi.com", true },
  { "kuponydoher.cz", true },
  { "kupschke.net", true },
  { "kurniadwin.to", true },
  { "kurofuku.me", true },
  { "kuroha.co.uk", true },
  { "kuroinu.jp", true },
  { "kuroisalva.xyz", false },
  { "kurona.ga", true },
  { "kuronekogaro.com", true },
  { "kurschies.de", true },
  { "kurserne.dk", true },
  { "kurswahl-online.de", true },
  { "kursypolska.pl", true },
  { "kurtschlatzer.com", true },
  { "kuruppa.xyz", true },
  { "kuschku.de", true },
  { "kusdaryanto.web.id", true },
  { "kushtikidsparties.co.uk", true },
  { "kusochi.eu", true },
  { "kutinsoft.com", true },
  { "kutip.id", true },
  { "kutsankaplan.com", true },
  { "kuttler.eu", true },
  { "kutukupret.com", true },
  { "kutus.ee", true },
  { "kuunlamaailm.ee", true },
  { "kuwichitagastro.com", true },
  { "kuwichitaim.com", true },
  { "kvadratnimeter.si", true },
  { "kvalita-1a.cz", true },
  { "kvalitetsaktiepodden.se", true },
  { "kvalitnitesneni.cz", true },
  { "kvantel.no", true },
  { "kvcc.com.au", true },
  { "kvestmaster.ru", true },
  { "kvetinymilt.cz", true },
  { "kvhile.com", true },
  { "kvilt.dk", true },
  { "kvnsport.ru", true },
  { "kvpc.com.au", true },
  { "kwat.chat", true },
  { "kwbresidential.com", true },
  { "kwcolville.com", true },
  { "kwedo.com", true },
  { "kwench.com", true },
  { "kwok.cc", true },
  { "kwoll.de", true },
  { "kwyxz.org", true },
  { "kx197.com", true },
  { "kxah35.com", true },
  { "kxline.com", true },
  { "kxway.com", true },
  { "kybi.sk", true },
  { "kydara.com", true },
  { "kyledrake.net", true },
  { "kylegutschow.com", true },
  { "kylejohnson.io", true },
  { "kylelaker.com", true },
  { "kylianvermeulen.com", true },
  { "kylianvermeulen.nl", true },
  { "kylinj.com", false },
  { "kynaston.org.uk", true },
  { "kynastonwedding.co.uk", true },
  { "kyochon.fr", true },
  { "kyosaku.org", true },
  { "kyoto-k9.com", false },
  { "kyoto-mic.com", true },
  { "kyoto-tomoshibi.jp", true },
  { "kyprexxo.com", true },
  { "kyras-castles.co.uk", true },
  { "kys.host", true },
  { "kysil.org", true },
  { "kyunyuki.com", true },
  { "kyusyu.org", true },
  { "kyy.me", true },
  { "kz.search.yahoo.com", false },
  { "kzar.co.uk", true },
  { "kzsdabas.hu", true },
  { "l-atelier-c.com", true },
  { "l0re.com", true },
  { "l0v0l.com", true },
  { "l17r.eu", true },
  { "l214.com", true },
  { "l2guru.ru", true },
  { "l33te.net", true },
  { "l4n-clan.de", true },
  { "l5197.co", true },
  { "l66.io", true },
  { "l6729.co", true },
  { "l6729.com", true },
  { "l6957.co", true },
  { "l7plumbing.com.au", true },
  { "l7world.com", true },
  { "l9297.co", true },
  { "l9397.com", true },
  { "l9721.com", true },
  { "l9728.co", true },
  { "la-baldosa.fr", true },
  { "la-compagnie-des-elfes.fr", true },
  { "la-fenice-neheim.de", true },
  { "la-ganiere.com", true },
  { "la-kaz-a-velo.fr", true },
  { "la-laitonnerie.com", true },
  { "la-maison.ch", true },
  { "la-maison.eu", true },
  { "la-petite-entreprise.com", true },
  { "la-tourmaline.ch", true },
  { "laac.io", true },
  { "laan247.dk", true },
  { "laatikko.io", true },
  { "laatjeniethackmaken.nl", true },
  { "labande-annonce.fr", true },
  { "labanochjonas.se", true },
  { "labanote.com", true },
  { "labanskoller.se", true },
  { "labanskollermark.se", true },
  { "labavn.org", true },
  { "labcenter.com", true },
  { "labcoat.jp", true },
  { "labeled.vn", true },
  { "labiblioafronebrulepas.com", true },
  { "labobooks.com", true },
  { "laboratoriodemarketingb3.com", true },
  { "labortogether.com", true },
  { "labouncycastlehire.co.uk", true },
  { "labourreedevergheas.fr", true },
  { "laboutiquedejuliette.com", true },
  { "laboxfaitsoncinema.com", true },
  { "labradorpuppiesforsalebyregisteredlabradorbreeders.com", false },
  { "labrat.mobi", false },
  { "labspack.com", true },
  { "labsys.xyz", true },
  { "labtest.ltd", true },
  { "lacaey.se", true },
  { "lacantine.xyz", true },
  { "lacaveducinquantenaire.com", true },
  { "lacetsfun.com", true },
  { "lacetsroses.ch", true },
  { "laceysfarm.ie", true },
  { "lachainedesentrepreneurs.fr", true },
  { "lachawoj.de", true },
  { "lachlan-harris.com", true },
  { "lachlan.com", true },
  { "lachlanallison.com", true },
  { "lachosetypo.com", true },
  { "lachyoga-schwieberdingen.de", true },
  { "laclaque.ch", true },
  { "lacledeslan.com", false },
  { "lacledor.ch", true },
  { "laclefdor.ch", true },
  { "lacliniquefinanciere.com", true },
  { "lacoast.gov", true },
  { "lacocinadelila.com", true },
  { "lacoquette.gr", true },
  { "lacyc3.eu", true },
  { "ladadate.com", true },
  { "ladbroke.net", false },
  { "ladenzeile.at", true },
  { "ladenzeile.de", true },
  { "ladislavbrezovnik.com", true },
  { "lado.ltd", true },
  { "ladotech.cn", true },
  { "ladotech.com", true },
  { "ladraiglaan.com", true },
  { "lady-2.jp", true },
  { "ladyanna.de", true },
  { "ladyofhopeparish.org", true },
  { "laegernevedlillebaelt.dk", true },
  { "laermschmiede.de", true },
  { "laeryn.com", true },
  { "laextra.mx", true },
  { "lafantasticatravel.com", true },
  { "lafayette-rushford.com", true },
  { "lafcheta.info", false },
  { "lafema.de", true },
  { "lafermegourmande.fr", true },
  { "lafillepolyvalente.ca", true },
  { "lafillepolyvalente.com", true },
  { "lafka.org", true },
  { "lafkor.de", true },
  { "laflash.com", true },
  { "lagarderob.ru", false },
  { "lagazzettadigitale.it", true },
  { "lagerauftrag.info", true },
  { "lagier.xyz", true },
  { "lagit.in", true },
  { "laglab.org", false },
  { "lagout.org", true },
  { "lagriffeduservice.fr", true },
  { "lagsoftware.com", true },
  { "laguinguette.fr", true },
  { "lagunakitchenandbath.com", true },
  { "lahipotesisgaia.com", true },
  { "lahnau-akustik.de", true },
  { "lahora.com.ec", true },
  { "lai.is", true },
  { "laibcoms.com", true },
  { "lain.at", true },
  { "lain.li", true },
  { "laindonleisure.co.uk", true },
  { "lak-berlin.de", true },
  { "lakedavid.com.au", true },
  { "lakehavasuwebsites.com", true },
  { "lakelandbank.com", true },
  { "lakeoswegotowncar.com", true },
  { "lakersview.com", true },
  { "lakesherwoodelectric.com", true },
  { "lakesherwoodelectrical.com", true },
  { "lakesherwoodelectrician.com", true },
  { "lakesherwoodexteriorlighting.com", true },
  { "lakesherwoodlandscapelighting.com", true },
  { "lakesherwoodlighting.com", true },
  { "lakesherwoodoutdoorlighting.com", true },
  { "lakeshowlife.com", true },
  { "lakewoodcityglass.com", true },
  { "lakkt.de", true },
  { "lakonia.com.br", true },
  { "lalalab.com", true },
  { "lalaya.fr", true },
  { "laled.ch", true },
  { "lalucepulsata.it", true },
  { "lalucioledigitale.com", true },
  { "lalunaonlinebr.com", true },
  { "lalyre-corcelles.ch", true },
  { "lamakat.de", true },
  { "lamaletarural.es", true },
  { "lamapoll.de", true },
  { "lamargheritalruoto.it", true },
  { "lamarieealhonneur.com", false },
  { "lambangcapgiare.com", true },
  { "lambauer.com", true },
  { "lambdaof.xyz", true },
  { "lambertshealthcare.co.uk", true },
  { "lambertz.xyz", true },
  { "lamboo.be", true },
  { "lamclam.site", true },
  { "lamconnect.com", true },
  { "lamed.se", true },
  { "lamikvah.org", true },
  { "laminine.info", true },
  { "lammersmarketing.com", true },
  { "lamontre.ru", true },
  { "lamp.re", false },
  { "lamp24.se", true },
  { "lampade.it", true },
  { "lampara.es", true },
  { "lampegiganten.dk", true },
  { "lampegiganten.no", true },
  { "lampen24.be", true },
  { "lampen24.nl", true },
  { "lampenwelt.at", true },
  { "lampenwelt.ch", true },
  { "lampenwelt.de", true },
  { "lampl.info", false },
  { "lampposthomeschool.com", true },
  { "lampy.pl", true },
  { "lamunyon.com", true },
  { "lan.biz.tr", true },
  { "lana.swedbank.se", true },
  { "lanahallen.com", true },
  { "lanbroa.eu", true },
  { "lancashirecca.org.uk", true },
  { "lancejames.com", true },
  { "lancelafontaine.com", true },
  { "lancelhoff.com", true },
  { "lancemanion.com", true },
  { "lanceyip.com", true },
  { "lancyvbc.ch", true },
  { "land.nrw", false },
  { "landbetweenthelakes.us", true },
  { "landchecker.com.au", true },
  { "landegge.nl", true },
  { "landflair-magazin.de", true },
  { "landhaus-christmann.de", true },
  { "landhaus-havelse.de", true },
  { "landinfo.no", true },
  { "landingear.com", true },
  { "landlordy.com", true },
  { "landofelves.net", false },
  { "landoncreekapartments.com", true },
  { "landrovermerriamparts.com", true },
  { "landscape-photography.org", true },
  { "landscapelightingagoura.com", true },
  { "landscapelightingagourahills.com", true },
  { "landscapelightingcalabasas.com", true },
  { "landscapelightingcamarillo.com", true },
  { "landscapelightingconejovalley.com", true },
  { "landscapelightingdosvientos.com", true },
  { "landscapelightinghiddenhills.com", true },
  { "landscapelightinglakesherwood.com", true },
  { "landscapelightingmalibu.com", true },
  { "landscapelightingmoorpark.com", true },
  { "landscapelightingnewburypark.com", true },
  { "landscapelightingoakpark.com", true },
  { "landscapelightingsimivalley.com", true },
  { "landscapelightingthousandoaks.com", true },
  { "landscapelightingwestlakevillage.com", true },
  { "landscapephotography.org.au", true },
  { "landyparts.nl", true },
  { "lanetix.com", true },
  { "lanforalla.se", true },
  { "lang-php.com", true },
  { "langatang.com", true },
  { "langbein.org", true },
  { "langduytinh.com", true },
  { "langkahteduh.com", true },
  { "langkawitrip.com", true },
  { "langotie.com.br", true },
  { "langsam-dator.se", true },
  { "langstreckensaufen.de", true },
  { "languagecourse.net", true },
  { "languageterminal.com", true },
  { "langworth.com", true },
  { "langzijn.nl", true },
  { "lanna.io", true },
  { "lannainnovation.com", true },
  { "lannamontessori.com", true },
  { "lannatefl.com", true },
  { "lanodan.eu", true },
  { "lanonfire.com", true },
  { "lanostrasalute.it", true },
  { "lanre.org", true },
  { "lanroamer.de", true },
  { "lansechensilu.com", true },
  { "lansewu.com", true },
  { "lansoftware.eu", true },
  { "lanternalauth.com", true },
  { "lanternhealth.org", true },
  { "lantian.pub", true },
  { "lanturtle.com", true },
  { "lanuovariviera.it", true },
  { "lanzamientovirtual.es", true },
  { "lanzarote-online.info", true },
  { "laos.dating", true },
  { "laospage.com", true },
  { "laozhu.me", true },
  { "lapageamelkor.org", true },
  { "lapassiondutrading.com", true },
  { "lapatio.dk", true },
  { "lapicena.eu", true },
  { "lapidge.net", true },
  { "lapix.com.co", true },
  { "laplacesicherheit.de", true },
  { "laplanetebleue.com", true },
  { "lapolla.com", true },
  { "laportedufutur.org", true },
  { "lapotagere.ch", true },
  { "lapparente-aise.ch", true },
  { "lappari.com", false },
  { "lapshore.com", true },
  { "lara.photography", true },
  { "larabergmann.de", true },
  { "laracode.eu", true },
  { "laraeph.com", true },
  { "laraigneedusoir.com", true },
  { "laranara.se", true },
  { "laranjada.org", true },
  { "laraveldirectory.com", true },
  { "laravelsaas.com", true },
  { "larbertbaptist.org", true },
  { "lareclame.fr", true },
  { "larepublicacultural.es", true },
  { "lares.com", true },
  { "largescaleforums.com", true },
  { "largeviewer.com", true },
  { "lariposte.org", true },
  { "lariscus.eu", true },
  { "larondinedisinfestazione.com", true },
  { "larptreff.de", true },
  { "larraz.es", true },
  { "larryli.cn", true },
  { "larrysalibra.com", true },
  { "lars-ewald.com", true },
  { "lars-mense.de", true },
  { "lars.cloud", true },
  { "lars.moi", true },
  { "larsklene.nl", true },
  { "larsklint.com", true },
  { "lartduportrait.fr", true },
  { "laruga.co.uk", true },
  { "lasabubillas.es", true },
  { "lasalle.wa.edu.au", true },
  { "lasarmas.com", true },
  { "lasavonnerieducroisic.fr", true },
  { "lascana.co.uk", true },
  { "lasereyess.net", true },
  { "laserhealthsolutions.com", true },
  { "laserplaza.de", true },
  { "laserplaza.net", true },
  { "lask.in", true },
  { "laskas.pl", true },
  { "lasowy.com", true },
  { "laspequenassemillas.com", true },
  { "lasranas.es", true },
  { "lasrecetascocina.com", true },
  { "lasrecetasdeguada.com", true },
  { "lasse-it.dk", true },
  { "lasseleegaard.com", true },
  { "lasseleegaard.dk", true },
  { "lasseleegaard.net", true },
  { "lasseleegaard.org", true },
  { "lassesworld.com", true },
  { "lassesworld.se", true },
  { "lastbutnotyeast.com", true },
  { "lastharo.com", true },
  { "lastpass.com", false },
  { "lastrada-minden.de", true },
  { "lasuzefc.fr", true },
  { "lat.sk", true },
  { "latabaccheria.net", true },
  { "late.am", true },
  { "latecnosfera.com", true },
  { "latedeals.co.uk", true },
  { "latenitefilms.com", false },
  { "lateralsecurity.com", true },
  { "latestdeals.co.uk", true },
  { "latiendauno.com", true },
  { "latiendawapa.com", true },
  { "latinmusicrecords.com", true },
  { "latino.dating", true },
  { "latinphone.com", true },
  { "latintoy.com", true },
  { "latitudesign.com", true },
  { "latremebunda.com", true },
  { "latrine.cz", true },
  { "lattyware.co.uk", true },
  { "lattyware.com", true },
  { "laubacher.io", true },
  { "lauchundei.at", true },
  { "laudableapps.com", true },
  { "laudablesites.com", true },
  { "laudwein.fr", true },
  { "lauensteiner.de", false },
  { "laufpix.de", true },
  { "lauftreff-himmelgeist.de", true },
  { "laughinggrapepublishing.com", true },
  { "laukstein.com", true },
  { "launayflorian.net", true },
  { "launch-subtitle.com", true },
  { "launcher-minecraft.com", true },
  { "launchkey.com", false },
  { "launchmylifend.com", true },
  { "launchpad-app2.com", true },
  { "launchpadder2.com", true },
  { "laupv.online", true },
  { "lauraandwill.wedding", false },
  { "lauraenvoyage.fr", true },
  { "laurakashiwase.com", true },
  { "lauralinde.de", true },
  { "lauraofrank.com", true },
  { "lauraohagan.com", true },
  { "laurasplacefamilysupport.org.au", true },
  { "laurelblack.com", true },
  { "laurencball.com", true },
  { "laurenceplouffe.com", true },
  { "laurenlobue.com", true },
  { "laurensvanderblom.nl", true },
  { "lauriemilne.com", true },
  { "laurineprice.com", true },
  { "lauritzt.cf", true },
  { "lauriuc.sk", true },
  { "lausannedentiste.ch", true },
  { "lausannelovers.ch", true },
  { "laussat.de", true },
  { "laut.digital", true },
  { "lauxzahnheilkunde.de", true },
  { "lauzon-hitter.com", true },
  { "lavabit.no", true },
  { "lavalite.de", true },
  { "lavamob.com", true },
  { "lavanderia.roma.it", true },
  { "lavaux.lv", true },
  { "lavenderx.org", true },
  { "laviedalex.ovh", true },
  { "lavinaec.com", true },
  { "lavinya.net", true },
  { "lavita.de", true },
  { "lavitaura.com", true },
  { "lavitrine-une-collection.be", true },
  { "lavka-konditera.com", true },
  { "lavoieducoeur.be", true },
  { "lavoiepharmd.com", true },
  { "lavolte.net", true },
  { "lavril.fr", true },
  { "law-colleges.com", true },
  { "law-peters.de", true },
  { "law-profile.com", true },
  { "law.co.il", true },
  { "law22.com", true },
  { "lawabidingcactus.com", true },
  { "lawbirduk.com", true },
  { "lawlessenglish.com", true },
  { "lawlessfrench.com", true },
  { "lawlessspanish.com", true },
  { "lawn-seeds.com", true },
  { "lawnuk.com", true },
  { "lawrenceberg.nl", true },
  { "lawrencemurgatroyd.com", true },
  { "lawrencewhiteside.com", true },
  { "lawyerkf.com", true },
  { "layazc.com", true },
  { "laylo.io", true },
  { "laylo.nl", true },
  { "layordesign.co.uk", true },
  { "layoutsatzunddruck.de", true },
  { "lazau.com", true },
  { "lazisbaiturrahman.org", true },
  { "lazistance.com", true },
  { "lazowik.pl", true },
  { "lazurit.com", true },
  { "lazyboston.com", true },
  { "lazyclock.com", true },
  { "lazyframe.com", true },
  { "lazyhelp.com", true },
  { "lazytux.org", true },
  { "lb-toner.de", true },
  { "lbayer.com", true },
  { "lbc.gr", true },
  { "lbgconsultores.com", true },
  { "lbihrhelpdesk.com", true },
  { "lbls.me", true },
  { "lbmblaasmuziek.nl", true },
  { "lbphacker.pw", true },
  { "lbs-logics.com", true },
  { "lbsistemas.com.mx", true },
  { "lbux.org", true },
  { "lc-cs.com", false },
  { "lca-pv.de", true },
  { "lca.gov", true },
  { "lcacommons.gov", true },
  { "lcars-sv.info", true },
  { "lcdn.ro", true },
  { "lce-events.com", true },
  { "lcgabogados.com", true },
  { "lcgaj.com", true },
  { "lcrmscp.gov", true },
  { "lcx.cc", true },
  { "lcy.im", false },
  { "lcy.moe", true },
  { "ld-begunjscica.si", true },
  { "ldc.com.br", false },
  { "ldesignweb.com", true },
  { "ldjb.jp", true },
  { "ldm2468.com", true },
  { "ldsun.com", true },
  { "le-bar.org", true },
  { "le-controle-parental.fr", true },
  { "le-creux-du-van.ch", true },
  { "le-dev.de", false },
  { "le-drive-de-just-vet.fr", true },
  { "le-h.de", true },
  { "le-hosting.de", true },
  { "le-page.info", true },
  { "le-palantir.com", true },
  { "le-traiteur-parisien.fr", true },
  { "le130rb.com", true },
  { "le23.fr", true },
  { "leadbook.ru", true },
  { "leadbox.cz", true },
  { "leaderoftheresistance.com", false },
  { "leaderoftheresistance.net", false },
  { "leadinfo.com", true },
  { "leadpagebuilders.com", true },
  { "leadquest.nl", true },
  { "leafandseed.co.uk", true },
  { "leafans.tk", false },
  { "leafinote.com", true },
  { "leafland.co.nz", true },
  { "leakforums.net", true },
  { "leamsigc.com", false },
  { "leankit.com", true },
  { "leanplando.com", true },
  { "leap-it.be", true },
  { "leapandjump.co.uk", true },
  { "leapworks.io", true },
  { "learnflakes.net", true },
  { "learning-id.com", true },
  { "learningaboutcarinsurance.com", true },
  { "learningis1.st", true },
  { "learninglaw.com", true },
  { "learningman.top", true },
  { "learningselfreliance.com", true },
  { "learnlux.com", true },
  { "learnpianogreece.com", true },
  { "learnplayground.com", true },
  { "learnthetruth.tk", true },
  { "leaseit24.com", true },
  { "leaseit24.de", true },
  { "leaseourthings.com", true },
  { "leaseplan.com", true },
  { "leasit.at", true },
  { "leasit.de", true },
  { "leastsignificantbit.de", true },
  { "leatam.fr", true },
  { "leatherfurnitureexpo.com", true },
  { "leatherwood.nl", true },
  { "leavesofchangeweekly.org", true },
  { "lebanesearmy.gov.lb", true },
  { "lebarmy.gov.lb", true },
  { "lebedata.com", true },
  { "lebendige-heilkunst.de", true },
  { "lebens-fluss.at", true },
  { "lebensraum-fitness-toenisvorst.de", true },
  { "lebensraum-im-garten.de", true },
  { "lebensraum-kurse.ch", true },
  { "lebihan.pl", true },
  { "leblanc.io", true },
  { "lebourgeo.is", true },
  { "lecannabis.com", false },
  { "lecannabiste.com", true },
  { "lecn2.com", true },
  { "lecoinchocolat.com", true },
  { "lectricecorrectrice.com", true },
  { "led-jihlava.cz", true },
  { "ledecologie.com.br", true },
  { "ledeguisement.com", true },
  { "lederer-it.com", true },
  { "ledlight.com", true },
  { "ledlights.ca", true },
  { "ledscontato.com.br", true },
  { "ledwereld.nl", true },
  { "lee-fuller.co.uk", true },
  { "leeaaronsrealestate.com", true },
  { "leebiblestudycentre.co.uk", true },
  { "leeclemens.net", false },
  { "leedev.org", true },
  { "leekspin.ml", true },
  { "leelaylay.com", true },
  { "leere.me", true },
  { "leerliga.de", true },
  { "leertipp.de", true },
  { "leesilvey.com", true },
  { "leet2.com", true },
  { "leetcode.com", true },
  { "leetcode.net", true },
  { "leetgamers.asia", true },
  { "leevealdc.com", true },
  { "lefcoaching.nl", false },
  { "lefebvristes.com", true },
  { "lefebvristes.fr", true },
  { "leflibustier.ru", true },
  { "lefonddeloeil.com", true },
  { "left-baggage.co.uk", true },
  { "leftbrainsolutions.com.au", true },
  { "leftclick.cloud", true },
  { "leftclick.eu", true },
  { "legabot.fr", true },
  { "legacyiohs.org", true },
  { "legacylawofwashington.com", true },
  { "legadental.com", true },
  { "legaillart.fr", true },
  { "legal-tender.com", true },
  { "legalatlanta.com", true },
  { "legalcontrol.info", true },
  { "legaldesk.com", true },
  { "legalforms.ng", true },
  { "legalinmotion.es", true },
  { "legalplace.fr", true },
  { "legalrobot.com", true },
  { "legalsearch.nl", true },
  { "legalsoftware.net", true },
  { "legendary.camera", true },
  { "legendarycamera.com", true },
  { "legendcatz.com", true },
  { "legendesdechine.ch", true },
  { "legendofkrystal.com", true },
  { "legends-game.ru", false },
  { "legible.es", true },
  { "legilimens.de", true },
  { "legioniv.org", true },
  { "legionminecraft.com", true },
  { "legiscontabilidade.com.br", true },
  { "legissa.ovh", true },
  { "legit.nz", true },
  { "legjobblogo.hu", true },
  { "legland.fr", true },
  { "legnami24.it", true },
  { "legoutdesplantes.be", true },
  { "legrandvtc.fr", true },
  { "legumeinfo.org", true },
  { "legyenkianegykereked.hu", true },
  { "lehighmathcircle.org", true },
  { "lehighvalleypeds.com", true },
  { "lehmitz-weinstuben.de", true },
  { "lehti-tarjous.net", true },
  { "leibniz-gymnasium-altdorf.de", true },
  { "leibniz-remscheid.de", false },
  { "leideninternationalreview.com", true },
  { "leighneithardt.com", true },
  { "leignier.org", true },
  { "leilonorte.com", true },
  { "leinfelder.in", true },
  { "leipzig.photo", true },
  { "leipziger-triathlon.de", true },
  { "leisure-blog.com", true },
  { "leisure-supplies-show.co.uk", true },
  { "leiyinan.com", true },
  { "lejardindesmesanges.fr", true },
  { "lektier.cf", true },
  { "lel.ovh", true },
  { "lelambiental.com.br", true },
  { "lemarcheelagrandeguerra.it", true },
  { "lemazol.fr", true },
  { "lemilane.it", true },
  { "lemni.top", true },
  { "lemoine.at", true },
  { "lemondenumerique.com", true },
  { "lemondrops.xyz", true },
  { "lemonlawnow.com", true },
  { "lemonop.com", true },
  { "lemonparty.co", true },
  { "lemonrockbiketours.com", true },
  { "lemonthy.com", true },
  { "lemouillour.fr", true },
  { "lemuslimpost.com", true },
  { "lenagroben.de", true },
  { "lenalio.fr", true },
  { "lenaneva.ru", true },
  { "lence.net", true },
  { "lencia.ga", true },
  { "lendingclub.com", true },
  { "lenidh.de", true },
  { "leninalbertop.com.ve", true },
  { "lenit.nl", true },
  { "lennyobez.be", true },
  { "lenostech.gr", true },
  { "lenou.nl", true },
  { "lenr-forum.com", true },
  { "lensdoctor.com", true },
  { "lenspirations.com", true },
  { "lensual.space", true },
  { "lenuagebauche.org", true },
  { "lenyip.com", true },
  { "lenyip.me", true },
  { "lenyip.works", true },
  { "leoandpeto.com", true },
  { "leodraxler.at", true },
  { "leola.cz", true },
  { "leola.sk", true },
  { "leolemos.com.br", true },
  { "leominstercu.com", false },
  { "leon-tech.com", true },
  { "leonbuitendam.nl", true },
  { "leondenard.com", true },
  { "leonklingele.de", true },
  { "leonmahler.consulting", true },
  { "leontiekoetter.de", true },
  { "leopoldina.net", true },
  { "leovanna.co.uk", true },
  { "leowkahman.com", true },
  { "lep.gov", true },
  { "lepartiecomemoracoes.com.br", true },
  { "lepenetapeti.com", true },
  { "lepidum.jp", true },
  { "leponton-lorient.fr", true },
  { "lepsos.com", true },
  { "lequerceagriturismo.com", true },
  { "lequest.dk", true },
  { "lereporter.ma", true },
  { "leretour.ch", true },
  { "lernenamsee.ch", true },
  { "lernerspersonalinjury.ca", true },
  { "lernorteuropa.com", true },
  { "lernorteuropa.de", true },
  { "lernorteuropa.eu", true },
  { "lernplattform-akademie.de", true },
  { "les-ateliers-de-melineo.be", true },
  { "les-explos.com", true },
  { "les-inoxydables.com", true },
  { "lesancheslibres.fr", true },
  { "lesarts.com", true },
  { "lesberger.ch", true },
  { "lesbofight.com", true },
  { "lesbrillantsdaristide.com", true },
  { "lesconteursavis.org", true },
  { "lescrapdesfilles.fr", true },
  { "leseditionsbraquage.com", true },
  { "lesfilmsavivre.com", true },
  { "lesgoodnews.fr", true },
  { "leshervelines.com", true },
  { "lesjardinsdubanchet.fr", true },
  { "lesmamy.ch", true },
  { "lesmontagne.net", true },
  { "lesnet.co.uk", true },
  { "lespagesweb.ch", true },
  { "lespecialiste-pradelexcellence.com", true },
  { "lesplatanes.ch", true },
  { "lespret.nl", true },
  { "lesquerda.cat", false },
  { "lessis.moe", true },
  { "lesterchan.net", true },
  { "lesterrassesdusoleil.ch", true },
  { "lesummeira.is", true },
  { "lesyndicat.info", true },
  { "leszonderstress.nl", true },
  { "letemps.ch", true },
  { "letempsdujasmin.fr", true },
  { "letertrefleuri.com", true },
  { "letni-kurzy.cz", true },
  { "leto12.xyz", true },
  { "letranif.net", true },
  { "lets-bounce.com", true },
  { "lets-go-acoustic.de", true },
  { "lets-ktai.jp", true },
  { "lets.ninja", true },
  { "lets.nu", true },
  { "letsbounceuk.com", true },
  { "letsdebug.net", true },
  { "letsdocode.com", true },
  { "letsencrypt-for-cpanel.com", true },
  { "letsflyinto.space", true },
  { "letsgame.nl", true },
  { "letsgetchecked.com", true },
  { "letsgowhilewereyoung.com", true },
  { "letson.me", true },
  { "letsorganise.uk", true },
  { "letspartyrugby.co.uk", true },
  { "letsprint3d.net", true },
  { "letssackcancer.org", true },
  { "letstalkcounseling.com", true },
  { "letterbox-online.de", true },
  { "letterdance.de", true },
  { "letteringinstitute.com", true },
  { "lettersblogatory.com", true },
  { "lettori.club", true },
  { "lettres-motivation.net", true },
  { "leuchtmann.ch", true },
  { "leuenhagen.com", true },
  { "leulu.com", true },
  { "leumi-how-to.co.il", true },
  { "leutgeb.xyz", true },
  { "leuthardtfamily.com", true },
  { "lev103.com", true },
  { "levans.fr", true },
  { "levanscatering.com", false },
  { "level-10.de", true },
  { "level6.me", true },
  { "level9hvac.com", true },
  { "levelonetrainingandfitness.com", true },
  { "leveluplv.com", true },
  { "leveluprails.com", true },
  { "levendwater.org", true },
  { "levensbron.nl", true },
  { "leventismotors.com.ng", true },
  { "leveragedtokens.com", true },
  { "leverj.io", true },
  { "levermann.eu", true },
  { "leviaan.nl", true },
  { "leviathan-studio.com", true },
  { "levineteamestates.com", true },
  { "levinus.de", true },
  { "leviscop.com", true },
  { "leviscop.de", true },
  { "lew.im", true },
  { "lewdawson.com", true },
  { "lewdgamer.com", true },
  { "lewis.li", true },
  { "lewiscollard.com", true },
  { "lewisdatasecurity.com", true },
  { "lewislaw.com", true },
  { "lewisllewellyn.me", true },
  { "lexdigital.pl", true },
  { "lexic.co", true },
  { "lexico.pt", true },
  { "lexicography.online", true },
  { "lexpierce.social", true },
  { "lexway.pk", true },
  { "leymaritima.com", true },
  { "leyun.cloud", true },
  { "lezard-com.fr", true },
  { "lfashion.eu", true },
  { "lfgss.com", true },
  { "lfrconseil.com", true },
  { "lg-waps.go.jp", true },
  { "lg-waps.jp", true },
  { "lgbt-colleges.com", true },
  { "lgbt.io", true },
  { "lgbt.ventures", true },
  { "lgbtq.cool", true },
  { "lgbtventures.com", true },
  { "lghfinancialstrategy.ch", true },
  { "lgnsh.fr", true },
  { "lgpecasoriginais.com.br", true },
  { "lhajn.cz", true },
  { "lhakustik.se", true },
  { "lhamaths.online", true },
  { "lhconsult.tk", false },
  { "lhgavarain.com", true },
  { "lhost.su", true },
  { "lhr.wiki", true },
  { "li-ke.co.jp", true },
  { "li.search.yahoo.com", false },
  { "lialion.de", true },
  { "liam-w.io", true },
  { "liamelliott.me", true },
  { "liamlin.me", true },
  { "liandongyoupin.com", true },
  { "liangxingai.com", true },
  { "lianhongrui.com", true },
  { "lianye1.cc", true },
  { "lianye2.cc", true },
  { "lianye3.cc", true },
  { "lianye4.cc", true },
  { "lianye5.cc", true },
  { "lianye6.cc", true },
  { "liaronce.com", true },
  { "liautard.fr", true },
  { "lib64.net", true },
  { "libbitcoin.org", true },
  { "libble.eu", true },
  { "libbywinberginteriors.com.au", true },
  { "liberapay.com", true },
  { "liberation2020.com", true },
  { "liberationist.org", true },
  { "liberationschool.org", true },
  { "liberdademg.com.br", true },
  { "libgame.com", true },
  { "libmpq.org", true },
  { "libnull.com", true },
  { "libra.com", true },
  { "library-quest.com", true },
  { "libraryextension.com", true },
  { "libraryfreedomproject.org", false },
  { "libraryofcode.us", true },
  { "librarytools.com", false },
  { "libravatar.org", true },
  { "librazy.org", true },
  { "libre-innovation.org", true },
  { "libre-service.de", true },
  { "libre.cr", true },
  { "libre.university", true },
  { "libreboot.org", true },
  { "librebox.de", true },
  { "librelamp.com", true },
  { "libremail.nl", true },
  { "librends.org", true },
  { "libreoffice-from-collabora.com", true },
  { "libreofficefromcollabora.com", true },
  { "librervac.org", true },
  { "librisulibri.it", true },
  { "librofilia.com", true },
  { "libscode.com", false },
  { "libskia.so", true },
  { "libsodium.org", true },
  { "libstock.si", true },
  { "lichess.org", true },
  { "lichtmetzger.de", false },
  { "lichtspot.de", true },
  { "lichttechnik-tumler.com", true },
  { "lichttraeumer.de", true },
  { "lickthesalt.com", true },
  { "licloud.homeip.net", true },
  { "lidavidm.me", true },
  { "lidel.org", true },
  { "liderwalut.pl", false },
  { "lidl-gewinnspiel.de", true },
  { "lidl-holidays.com", true },
  { "lidl-menubox.ch", true },
  { "lidl-shop.be", true },
  { "lidl-shop.cz", true },
  { "lidl-shop.nl", true },
  { "lidl-tour.ro", true },
  { "lidogr.com", true },
  { "lidong.me", true },
  { "lidow.eu", true },
  { "lidtkemotors.com", true },
  { "liduan.net", false },
  { "lie.as", true },
  { "liebel.org", true },
  { "lieberwirth.biz", true },
  { "liemen.net", true },
  { "lieren4x4.nl", true },
  { "lieuu.com", true },
  { "lifanov.com", true },
  { "life-emotions.pt", true },
  { "life29.com", true },
  { "lifeartstudios.net", true },
  { "lifebetweenlives.com.au", true },
  { "lifeboxhealthcare.co.uk", true },
  { "lifecism.com", true },
  { "lifeenrichmentnc.com", true },
  { "lifefoto.de", true },
  { "lifegrip.com.au", true },
  { "lifeinhex.com", true },
  { "lifeinsurancepro.org", true },
  { "lifekiss.ru", true },
  { "lifelenz.com", true },
  { "lifematenutrition.com", true },
  { "lifemcserver.com", true },
  { "lifemstyle.com", true },
  { "lifeqa.net", true },
  { "lifereset.it", true },
  { "lifesafety.com.br", true },
  { "lifeset.pp.ua", true },
  { "lifeslonglist.com", true },
  { "lifestylecent.com", true },
  { "lifestylefinancial.ca", true },
  { "lifestylefoto.cz", true },
  { "lifestyletravel.co.za", true },
  { "lifetree.network", true },
  { "lifeupgame.fr", true },
  { "lifewithdyna.com", true },
  { "lifi.digital", true },
  { "lifi.is", true },
  { "lift-wise.com", true },
  { "liftie.info", true },
  { "liftoff.rocks", true },
  { "ligadosgames.com", true },
  { "light-up.xyz", true },
  { "light.mail.ru", true },
  { "lightbox.co", true },
  { "lighting-centres.co.uk", true },
  { "lightingagoura.com", true },
  { "lightingagourahills.com", true },
  { "lightingcalabasas.com", true },
  { "lightingconejovalley.com", true },
  { "lightingdosvientos.com", true },
  { "lightinghiddenhills.com", true },
  { "lightinglakesherwood.com", true },
  { "lightingmalibu.com", true },
  { "lightingmoorpark.com", true },
  { "lightingnewburypark.com", true },
  { "lightingoakpark.com", true },
  { "lightingsimivalley.com", true },
  { "lightingthousandoaks.com", true },
  { "lightingwestlakevillage.com", true },
  { "lightning.community", true },
  { "lightning.engineering", true },
  { "lightpics.net", true },
  { "lights.co.uk", true },
  { "lights.ie", true },
  { "lightscale.com", true },
  { "lightsheep.no", false },
  { "lightspeed.com", false },
  { "lightspeedta.co", true },
  { "lightweighthr.com", true },
  { "ligmadrive.com", true },
  { "lignite.com", true },
  { "lignoma.com", true },
  { "ligonier.com", true },
  { "lihaul.dnsalias.net", true },
  { "lijncoaching.nl", true },
  { "lijstje.be", true },
  { "lijstje.nl", true },
  { "likc.me", true },
  { "likeablehub.com", true },
  { "likeabox.de", true },
  { "likebee.gr", true },
  { "likegeeks.com", true },
  { "likehifi.de", true },
  { "likemovies.de", true },
  { "likenewhearing.com.au", true },
  { "likeometer.co", true },
  { "likere.com", true },
  { "likesforinsta.com", true },
  { "likui.me", true },
  { "lilaccakeboutique.com", true },
  { "liljohnsanitary.net", true },
  { "lillepuu.com", true },
  { "lilliputpreschool.co.nz", true },
  { "lily-bearing.com", true },
  { "lily-inn.com", true },
  { "lilyfarmfreshskincare.com", true },
  { "lilylasvegas.com", true },
  { "lilysbouncycastles.com", true },
  { "lilyvet.com", true },
  { "lim-light.com", true },
  { "limap.ch", true },
  { "limawi.io", true },
  { "limberg.me", true },
  { "limbo.services", true },
  { "limelabs.de", true },
  { "limelabs.io", true },
  { "limeres.com", true },
  { "limereslaw.com", true },
  { "limitededitioncomputers.com", true },
  { "limitededitionsolutions.com", true },
  { "limitxyz.com", true },
  { "limo.pl", true },
  { "limoshka.ru", true },
  { "limousineservicezurich.com", true },
  { "limpid.nl", true },
  { "limsia.co", true },
  { "limsia.com", true },
  { "limules.ch", true },
  { "limx.win", true },
  { "lin.fi", true },
  { "linaklein.de", true },
  { "linan.blog", true },
  { "linan.info", true },
  { "linan.me", true },
  { "linan.site", true },
  { "linasjourney.com", true },
  { "lincdavis.com", true },
  { "linchpin-it.com", true },
  { "lincnaarzorg.nl", true },
  { "lincoln.com.cn", true },
  { "lincoln.mx", true },
  { "lincolnboolefoundation.org", true },
  { "lincolnfinewines.com", true },
  { "lincolnpedsgroup.com", true },
  { "lincolnsfh.com", true },
  { "lincolnwayflorist.com", true },
  { "lindalap.fi", true },
  { "lindaolsson.com", true },
  { "linden.me", true },
  { "lindeskar.se", true },
  { "lindnerhof-taktik.de", true },
  { "lindnerhof.info", true },
  { "lindo.ru", true },
  { "lindon.pw", true },
  { "lindsayanderson.com", true },
  { "lindsaygorski.com", true },
  { "lindskogen.se", true },
  { "lindy.co", false },
  { "line-wise.com", true },
  { "line.biz", true },
  { "line.co.nz", true },
  { "lineageos.org", true },
  { "linearaudio.net", true },
  { "linearaudio.nl", true },
  { "linearmap.com", true },
  { "linge-ma.ro", true },
  { "lingerie.com.br", true },
  { "lingeriesilhouette.com", true },
  { "lingotaxi.com", true },
  { "linguatrip.com", false },
  { "lingvo-svoboda.ru", true },
  { "linherest.tk", true },
  { "linhua.org", true },
  { "link-sanitizer.com", true },
  { "link2serve.com", true },
  { "link9.net", true },
  { "linkdr.uk", true },
  { "linkedinbackground.com", true },
  { "linkedpipes.com", true },
  { "linkenheil.org", true },
  { "linkk9.com", true },
  { "linklocker.co", true },
  { "linkmaker.co.uk", true },
  { "linkmauve.fr", true },
  { "linkopia.com", true },
  { "linkst.co", true },
  { "linkthis.me", true },
  { "linktio.com", true },
  { "linky.tk", true },
  { "linkycat.com", true },
  { "linkyou.top", true },
  { "linode.com", false },
  { "linost.com", true },
  { "linpx.com", true },
  { "linqhost.nl", true },
  { "linss.com", true },
  { "lintmx.com", true },
  { "linux-audit.com", true },
  { "linux-florida.com", true },
  { "linux-mint-czech.cz", true },
  { "linux-vme.org", true },
  { "linux.cn", true },
  { "linux.conf.au", true },
  { "linux.fi", true },
  { "linux3.org", true },
  { "linuxadictos.com", true },
  { "linuxbabe.com", true },
  { "linuxbg.eu", true },
  { "linuxbierwanderung.com", true },
  { "linuxchick.se", true },
  { "linuxcommand.ru", true },
  { "linuxdays.cz", true },
  { "linuxforum.ch", true },
  { "linuxgiggle.com", true },
  { "linuxhostsupport.com", true },
  { "linuxiuvat.de", true },
  { "linuxlounge.net", true },
  { "linuxos.org", true },
  { "linuxproperties.com", true },
  { "linuxsecurity.expert", true },
  { "linx.net", true },
  { "linzgau.de", true },
  { "linzyjx.com", true },
  { "lion-tech.ch", true },
  { "lionlyrics.com", true },
  { "lionsdeal.com", true },
  { "lipartydepot.com", true },
  { "lipex.com", true },
  { "lipighor.com", true },
  { "lipighor.xyz", true },
  { "lipoabaltimore.org", true },
  { "lippu1.fi", true },
  { "lipthink.com", true },
  { "liqd.net", true },
  { "liqueur.wiki", true },
  { "liquid.cz", true },
  { "liquidhost.co", true },
  { "liquidinternet.co", true },
  { "liquipedia.net", true },
  { "lirion.de", true },
  { "lirlandais.ch", true },
  { "lirnberger.com", true },
  { "lisahh-jayne.com", true },
  { "lisamccorrie.com", true },
  { "lisanzauomo.com", true },
  { "lisburnhottubnbounce.co.uk", true },
  { "lisinphotography.com", true },
  { "liskgdt.net", true },
  { "lislan.org.uk", true },
  { "lisowski-development.com", false },
  { "lissauer.com", true },
  { "list-gymnasium.de", true },
  { "listahu.org", true },
  { "listekdo.fr", true },
  { "listen.dk", true },
  { "lister-kirchweg.de", true },
  { "listminut.be", true },
  { "lists.fedoraproject.org", true },
  { "lists.stg.fedoraproject.org", true },
  { "litchidova.nl", true },
  { "litebit.de", true },
  { "litebit.eu", true },
  { "litebit.nl", true },
  { "litebitanalytics.eu", true },
  { "litebitcdn.eu", true },
  { "litebits.com", true },
  { "litemind.com", false },
  { "literaki123.pl", true },
  { "literarymachin.es", true },
  { "literature-schools.com", true },
  { "litfin.name", true },
  { "lithan.com", true },
  { "lithesalar.se", true },
  { "lithianissaneugeneparts.com", true },
  { "litsovet.com", true },
  { "little-cake.com", true },
  { "littlebestfriend.de", true },
  { "littleblackfish.se", true },
  { "littleboutiqueshop.co.uk", true },
  { "littleduck.xyz", true },
  { "littlefairy.no", true },
  { "littlefamilyadventure.com", true },
  { "littlegreece.ae", true },
  { "littlejumpers.co.uk", true },
  { "littlelife.co.uk", true },
  { "littlenina.nz", false },
  { "littlenlargeevents.co.uk", true },
  { "littlepigcreek.com.au", true },
  { "littlepincha.fr", true },
  { "littleprincessandmascotparties.co.uk", true },
  { "littleredpenguin.com", true },
  { "littleredsbakeshop.com", true },
  { "littlericket.me", true },
  { "littlescallywagsplay.co.uk", true },
  { "littleskin.cn", true },
  { "littleswitch.co.jp", true },
  { "littlewatcher.com", true },
  { "liturgical.net", true },
  { "litvideoserver.de", true },
  { "litz.ca", true },
  { "litzenberger.ca", true },
  { "liu0hy.cn", true },
  { "liubliu.co.uk", true },
  { "liudon.org", true },
  { "liujr.tk", true },
  { "liul.in", true },
  { "liupeicheng.top", true },
  { "liuxiangling.com", true },
  { "liv3d.stream", true },
  { "liv3ly.com", true },
  { "livada.fr", true },
  { "livaniaccesorios.com", true },
  { "live8811.com", true },
  { "live8899.cn", true },
  { "live8899.co", true },
  { "live8899.net", true },
  { "live9922.com", true },
  { "livebandphotos.com", true },
  { "livebetterwith.com", true },
  { "livebythesun.de", true },
  { "livecards.co.uk", true },
  { "livecards.es", true },
  { "livecards.eu", true },
  { "livecards.it", true },
  { "livecchi.cloud", true },
  { "livedesign.at", true },
  { "livedesign24.de", true },
  { "liveflightapp.com", true },
  { "livehomecams.co.uk", true },
  { "livejasmin.dk", true },
  { "livekaarten.be", true },
  { "livekaarten.nl", true },
  { "livekarten.at", true },
  { "livekarten.de", true },
  { "livekort.com", true },
  { "livekort.dk", true },
  { "livekort.no", true },
  { "livekort.se", true },
  { "livekortti.com", true },
  { "livekortti.fi", true },
  { "livela.jp", true },
  { "livelexi.com", true },
  { "livelifewithintent.com", true },
  { "livepaperhelp.com", true },
  { "liveregistratie.nl", true },
  { "liverider.co.jp", true },
  { "livesheep.com", true },
  { "liveslides.com", true },
  { "livesure.com", true },
  { "livetoride.co.za", true },
  { "livi.co", true },
  { "livi.co.uk", true },
  { "livi.fr", true },
  { "living-space.co.nz", true },
  { "living-with-outlook-2010.com", true },
  { "living.digital", true },
  { "living.video", true },
  { "living24.de", true },
  { "livingafrugallife.com", true },
  { "livingforreal.com", true },
  { "livinginhimalone.com", true },
  { "livingkingsinc.net", true },
  { "livinglocalnashville.com", true },
  { "livingworduk.org", true },
  { "livive.com", true },
  { "livnev.xyz", true },
  { "livogeva.dk", true },
  { "lixiaoyu.live", true },
  { "lixtick.com", true },
  { "liyang.pro", false },
  { "liyin.date", true },
  { "liz.ee", true },
  { "lizardsystems.com", true },
  { "lizheng.de", true },
  { "lizhi.io", true },
  { "lizmooredestinationweddings.com", true },
  { "liztattoo.se", true },
  { "lizzaran.io", true },
  { "lizzwood.com", true },
  { "ljason.cn", true },
  { "ljoonal.xyz", true },
  { "ljs.io", true },
  { "ljusdalsnaprapatklinik.se", true },
  { "lk-hardware.cz", true },
  { "lk1.bid", true },
  { "lkellar.org", true },
  { "lknw.de", true },
  { "ll.gr", true },
  { "ll5197.co", true },
  { "ll6729.co", true },
  { "ll6729.com", true },
  { "ll6957.co", true },
  { "ll9297.co", true },
  { "ll9397.com", true },
  { "ll9721.com", true },
  { "ll9728.co", true },
  { "llamacuba.com", true },
  { "llandudnochristmasfayre.co.uk", true },
  { "llbcpa.com", true },
  { "llemoz.com", true },
  { "llm-guide.com", true },
  { "llnl.gov", true },
  { "lloyd-day.me", true },
  { "llslb.com", false },
  { "lm-landscapes.co.uk", true },
  { "lm-pumpen.de", false },
  { "lm1628.com", true },
  { "lm228.cn", true },
  { "lm228.com", true },
  { "lm338.cn", true },
  { "lm338.com", true },
  { "lmbyrne.co.uk", true },
  { "lmbyrne.com", true },
  { "lmcm.io", true },
  { "lmddgtfy.net", true },
  { "lmdexpresstransport.com", true },
  { "lmintlcx.com", true },
  { "lmmi.nl", true },
  { "lmmtfy.io", true },
  { "lmsptfy.com", true },
  { "lmsuitespagna.it", true },
  { "lmtls.me", true },
  { "lmtm.eu", true },
  { "lndrive.space", true },
  { "lng-17.org", true },
  { "lnhequipmentltd.com", true },
  { "lnyltx.cn", true },
  { "load-ev.de", true },
  { "loadlow.me", true },
  { "loanaway.ca", true },
  { "loancompare.co.za", true },
  { "loandolphin.com.au", true },
  { "loansharkpro.com", true },
  { "loanstreet.nl", true },
  { "lob-assets-staging.com", true },
  { "lob-assets.com", true },
  { "lob-staging.com", true },
  { "lob.com", true },
  { "lobivia.de", true },
  { "lobosdomain.hopto.org", true },
  { "lobsangstudio.com", true },
  { "lobstr.co", true },
  { "loca-voiture.fr", true },
  { "local360.net", true },
  { "localbandz.com", true },
  { "localbitcoins.com", true },
  { "localblitz.com", true },
  { "localblock.co.za", true },
  { "localbouncycastle.com", true },
  { "localcryptopremium.com", true },
  { "locald.at", true },
  { "localdecor.com.br", true },
  { "localethereum.com", true },
  { "localhorst.duckdns.org", true },
  { "localhorst.xyz", true },
  { "localhost.ee", true },
  { "localprideart.com", true },
  { "localsearch.homes", true },
  { "localsource.eu", true },
  { "localspot.pl", true },
  { "locapos.com", true },
  { "location-appartement-dakar.com", true },
  { "locatorplus.gov", true },
  { "locauxrama.fr", true },
  { "lock.me", true },
  { "lock23.ca", true },
  { "lockaby.org", true },
  { "locker.email", true },
  { "locker.plus", true },
  { "locklock.com.br", true },
  { "locklockbrasil.com.br", true },
  { "lockme.at", true },
  { "lockme.ch", true },
  { "lockme.de", true },
  { "lockme.pl", true },
  { "locknlock.com.br", true },
  { "locknlockbrasil.com.br", true },
  { "lockpick.nl", true },
  { "lockpicks.se", true },
  { "locksmith--sanantoniotx.com", true },
  { "locksmith-sanantonio-tx.com", true },
  { "locksmithbalchsprings.com", true },
  { "locksmithballito.com", true },
  { "locksmithbluff.co.za", true },
  { "locksmithdearborn.com", true },
  { "locksmithdrippingspringstx.com", true },
  { "locksmithedmonds.com", true },
  { "locksmithfriendswoodtexas.com", true },
  { "locksmithgarland-tx.com", true },
  { "locksmithgrapevinetx.com", true },
  { "locksmithhumbletx.com", true },
  { "locksmithindurban.co.za", true },
  { "locksmithlakewaytx.com", true },
  { "locksmithlivoniami.com", true },
  { "locksmithmadisonheights.com", true },
  { "locksmithmesquitetexas.com", true },
  { "locksmithmesquitetx.com", true },
  { "locksmithmissouricity.com", true },
  { "locksmithopen.com", true },
  { "locksmithsammamishwa.com", true },
  { "locksmithsanantoniotexas.com", true },
  { "locksmithsbuda.com", true },
  { "locksmithscottsdaleaz.com", true },
  { "locksmithseattleco.com", true },
  { "locksmithservice-houston.com", true },
  { "locksmithspring.com", true },
  { "locksmithspringtx.com", true },
  { "locksmithswestville.com", true },
  { "locksmiththewoodlands.com", true },
  { "lockwoodchristmastreefarm.com", true },
  { "locomocosec.com", true },
  { "locomore.com", true },
  { "locomotionds.com", true },
  { "locomotive.net.br", true },
  { "locoserver.net", true },
  { "locurimunca.co", true },
  { "locus-dashboard.com", true },
  { "locusmap.eu", true },
  { "lodash.com", false },
  { "loddeke.eu", true },
  { "loenshotel.de", true },
  { "loew.de", true },
  { "loforo.com", true },
  { "lofttravel.com", true },
  { "loganmarchione.com", true },
  { "loganparkneighborhood.org", true },
  { "logbook.ch", true },
  { "logbot.info", true },
  { "logement-saisonnier.com", true },
  { "logement.com", true },
  { "logentries.com", false },
  { "logexplorer.net", true },
  { "logfile.at", true },
  { "logfile.ch", true },
  { "logicaccountingsolutions.com", true },
  { "logical-invest.com", true },
  { "logiciel-entreprise-seurann.fr", true },
  { "logicio.ch", false },
  { "logicio.de", false },
  { "logicio.net", false },
  { "logicne-hise.si", true },
  { "logicoma.com", true },
  { "login.corp.google.com", true },
  { "login.gov", false },
  { "login.launchpad.net", true },
  { "login.raiffeisen.ch", true },
  { "login.sapo.pt", true },
  { "login.ubuntu.com", true },
  { "login.xero.com", false },
  { "login.yahoo.com", false },
  { "logitel.de", true },
  { "logitrack.tk", true },
  { "logo-vogtland.de", true },
  { "logoesun.com", true },
  { "logoglo.com", true },
  { "logojoes.net", true },
  { "logopaediereinhard.de", true },
  { "logopedistalanni.it", true },
  { "logophiliapress.com", true },
  { "logopoeia.com", true },
  { "logostock.jp", true },
  { "logtalk.org", true },
  { "logtalk.pt", true },
  { "logtywardrobe.com", true },
  { "logue.be", true },
  { "logze.nl", true },
  { "lohanaflores.com.br", true },
  { "lohmeier.it", true },
  { "lohmeyer-it.de", true },
  { "lohmeyer.cc", true },
  { "loic.gr", true },
  { "loichot.ch", true },
  { "loisircreatif.net", true },
  { "lojadamimo.com.br", true },
  { "lojadanidrea.com.br", true },
  { "lojadarenda.com.br", true },
  { "lojadewhisky.com.br", true },
  { "lojadoarcomprimido.com.br", true },
  { "lojadoprazer.com.br", true },
  { "lojadosomautomotivo.com.br", true },
  { "lojafazendoarte.com.br", true },
  { "lojafilipaper.com.br", true },
  { "lojamagicalx.com", true },
  { "lojamascate.com.br", true },
  { "lojamoleco.com.br", true },
  { "lojaprimemed.com.br", true },
  { "lojaprojetoagua.com.br", true },
  { "lojaterrazul.com.br", true },
  { "lojavisamed.com.br", true },
  { "lojix.com", true },
  { "lojj.pt", true },
  { "lok.space", true },
  { "lokaal.org", true },
  { "lokal-speisen.de", true },
  { "lokalna.net", true },
  { "loker.id", true },
  { "loket.nl", true },
  { "lolas-vip.com", true },
  { "lolaseuropeancafe.com", true },
  { "lolcow.farm", true },
  { "loli.com", true },
  { "loli.net", true },
  { "loli.pet", true },
  { "loli.ski", true },
  { "loli.tube", true },
  { "loli.world", true },
  { "lolibrary.org", true },
  { "lolic.xyz", true },
  { "lolicon.eu", true },
  { "lolitalechat.com", true },
  { "lolkot.ru", true },
  { "lolly.cc", true },
  { "lolnames.gg", true },
  { "lolpatrol.de", true },
  { "lolpatrol.wtf", true },
  { "loma.ml", true },
  { "lommeregneren.dk", true },
  { "lommyfleet.com", true },
  { "lon-so.com", true },
  { "lona.io", true },
  { "lonasdigital.com", true },
  { "london-transfers.com", true },
  { "london.dating", true },
  { "londongallery.net", true },
  { "londongynaecologist.co", true },
  { "londonindustry.it", true },
  { "londonkan.jp", true },
  { "londonkeyholdingcompany.co.uk", true },
  { "londonpropertymatch.com", true },
  { "londonseedcentre.co.uk", true },
  { "lonelytweets.com", true },
  { "lonesomecosmonaut.com", true },
  { "lonestarlandandcommercial.com", true },
  { "long116.com", true },
  { "long139.com", true },
  { "long18.cc", true },
  { "long228.com", true },
  { "long688.com", true },
  { "longboat.io", true },
  { "longhaircareforum.com", true },
  { "longhorn-imports.com", true },
  { "longhorn.id.au", true },
  { "longma168.cn", true },
  { "longma168.com", true },
  { "longstride.net", true },
  { "longtermcare.gov", true },
  { "lonniec.com", true },
  { "lonniemason.net", true },
  { "lonwan.ru", true },
  { "look.co.il", true },
  { "lookagain.co.uk", true },
  { "lookasik.eu", true },
  { "lookastic.co.uk", true },
  { "lookastic.com", true },
  { "lookastic.de", true },
  { "lookastic.es", true },
  { "lookastic.fr", true },
  { "lookastic.mx", true },
  { "lookastic.ru", true },
  { "lookatmysco.re", true },
  { "lookbetweenthelines.com", true },
  { "looker.wang", true },
  { "lookgadgets.com", true },
  { "lookup-dns.net", true },
  { "lookzook.com", true },
  { "loom.no", true },
  { "loonylatke.com", true },
  { "loopstart.org", true },
  { "looseleafsecurity.com", true },
  { "loothole.com", true },
  { "loposchokk.com", true },
  { "loqu8.com", true },
  { "loquo.com", true },
  { "loqyu.com", true },
  { "lordjevington.co.uk", true },
  { "lore.azurewebsites.net", true },
  { "loremipsum.info", true },
  { "lorenadumitrascu.ro", true },
  { "lorenz-hundler.co", true },
  { "lorenzocompeticion.com", true },
  { "loreofthenorth.com", true },
  { "loreofthenorth.nl", true },
  { "loricozengeller.com", true },
  { "loritaboegl.de", true },
  { "lormansas.com", true },
  { "losangelestown.com", true },
  { "loshogares.com.mx", true },
  { "losmedicamentos.net", true },
  { "losreyesdeldescanso.com.ar", true },
  { "lost.host", true },
  { "lost.report", true },
  { "lostkeys.co.uk", true },
  { "lostsandal.com", true },
  { "lostsandal.io", true },
  { "lostserver.com", true },
  { "lostwithdan.com", true },
  { "loteamentoabertoamparo.com.br", true },
  { "loteamentomontereiitu.com.br", true },
  { "lotl.ru", true },
  { "lotn.mobi", true },
  { "lotn.nl", true },
  { "lotnonline.com", true },
  { "lotnonline.nl", true },
  { "loto-tele.com", true },
  { "lotro-wiki.com", true },
  { "lotsofbargains.com", true },
  { "lottoland.pt", true },
  { "lottospielen24.org", false },
  { "lotw.de", true },
  { "lotz.li", true },
  { "lou.ist", true },
  { "lou.lt", true },
  { "louange-reconvilier.ch", true },
  { "loucanfixit.com", true },
  { "louerunhacker.fr", true },
  { "louisapolicefoundation.com", true },
  { "louisapolicefoundation.org", true },
  { "louisemisellinteriors.co.uk", true },
  { "louisvillecarguys.com", true },
  { "louisvillefibroids.com", true },
  { "loune.net", true },
  { "loungecafe.net", true },
  { "loungecafe.org", true },
  { "loungepapillon.com", true },
  { "love4taylor.me", true },
  { "loveai.org", true },
  { "loveandadoreboutique.com", true },
  { "lovebeingsexy.co.uk", true },
  { "lovebigisland.com", true },
  { "loveislandgames.com", true },
  { "loveisourweapon.com", true },
  { "lovelivewiki.com", true },
  { "lovelovenavi.jp", true },
  { "lovemanagementaccounts.co.uk", true },
  { "lovemiku.info", true },
  { "lovemomiji.com", true },
  { "lovemybubbles.com", true },
  { "lovenwishes.com", true },
  { "loveph.one", true },
  { "lover-bg.com", true },
  { "loverepair.co.uk", true },
  { "loverepublic.ru", true },
  { "lovesmagical.com", true },
  { "lovesupremefestival.com", true },
  { "lovevape.co", true },
  { "loveysa.ch", true },
  { "lovg.ren", true },
  { "lovingearth.co", true },
  { "lovingthermo.com", true },
  { "lovizaim.ru", true },
  { "low-diets.com", true },
  { "lowbidders.com", true },
  { "lowcost.to", true },
  { "lowcostwire.com.au", true },
  { "lowerpricefinder.com", true },
  { "lowmagnitude.com", true },
  { "lowsec.space", true },
  { "lowsidetna.com", true },
  { "lowson.ca", true },
  { "loxal.net", true },
  { "loxal.org", true },
  { "loyaleco.it", true },
  { "loyaltyondemand.club", true },
  { "loyaltyondemand.eu", true },
  { "loyisa.cn", true },
  { "lp-support.nl", true },
  { "lpt-nebreziny.eu", true },
  { "lq.hr", true },
  { "lra-cloud.de", true },
  { "lrdo.net", true },
  { "lriese.ch", true },
  { "lrssystems.com", true },
  { "lrumeq.com", true },
  { "ls-alarm.de", true },
  { "ls-modcompany.com", true },
  { "lsal.me", true },
  { "lsc-dillingen.de", true },
  { "lsc.gov", true },
  { "lsh1688.com", true },
  { "lsiq.io", true },
  { "lsmentor.com", true },
  { "lsmpx.com", true },
  { "lsquo.com", true },
  { "lsscreens.de", true },
  { "lsy.cn", true },
  { "lsys.ac", true },
  { "lt.search.yahoo.com", false },
  { "ltaake.com", true },
  { "ltecode.com", true },
  { "ltib.com.au", true },
  { "ltls.org", true },
  { "ltn-tom-morel.fr", true },
  { "ltservers.net", true },
  { "lu.search.yahoo.com", false },
  { "luan.ma", true },
  { "luav.org", true },
  { "lubar.me", true },
  { "lubbockyounglawyers.org", true },
  { "lublin.toys", true },
  { "luc-oberson.ch", true },
  { "luca-steeb.com", true },
  { "lucacastelnuovo.nl", false },
  { "lucafontana.net", true },
  { "lucafrancesca.me", true },
  { "lucasantarella.com", true },
  { "lucasbergen.ca", true },
  { "lucasem.com", true },
  { "lucasgymnastics.com", true },
  { "lucasit.com", true },
  { "lucaslarson.net", true },
  { "lucassoler.com.ar", false },
  { "luce.life", true },
  { "luchscheider.de", false },
  { "luchthavenmaastricht.nl", true },
  { "lucian.blog", true },
  { "lucianoalbanes.com", true },
  { "lucid-light.de", true },
  { "lucid-reality.ch", true },
  { "lucidframeworks.com", true },
  { "lucidlight.de", true },
  { "lucie-parizkova.cz", true },
  { "lucie.jp", true },
  { "lucielavickova.com", true },
  { "luckycastles.co.uk", true },
  { "luckyfrog.hk", true },
  { "luckystorevn.com", true },
  { "luclu7.fr", true },
  { "lucy.science", true },
  { "lucyparsonslabs.com", true },
  { "lucysan.net", true },
  { "lucz.co", true },
  { "luda.me", true },
  { "ludek.biz", true },
  { "ludikovsky.name", true },
  { "ludogue.net", true },
  { "ludovic-muller.fr", true },
  { "ludwiggrill.de", true },
  { "ludwigjohnson.se", true },
  { "ludwigpro.net", true },
  { "luedeke-bremen.eu", true },
  { "luehne.de", true },
  { "luelistan.net", true },
  { "luenwarneke.com", true },
  { "luera1959.de", true },
  { "luffyhair.com", true },
  { "luftbild-siegerland.de", true },
  { "luftreiniger.biz", true },
  { "lugbb.org", true },
  { "luginbuehl.be", true },
  { "luginbuehl.eu", true },
  { "lugui.in", true },
  { "luisa-birkner.de", true },
  { "luiscapelo.info", true },
  { "luismaier.de", true },
  { "luisyr.com", true },
  { "luizkowalski.net", true },
  { "luk.earth", true },
  { "lukas-gorr.de", true },
  { "lukas-meixner.com", true },
  { "lukasberan.com", true },
  { "lukasberan.cz", true },
  { "lukasfunk.com", true },
  { "lukasschick.de", false },
  { "lukaszorn.de", true },
  { "lukaszwojcik.net", true },
  { "luke.ch", true },
  { "luke6887.me", true },
  { "lukeistschuld.de", true },
  { "lukem.net", true },
  { "lukeng.net", true },
  { "lukesbouncycastlehire.com", true },
  { "lukestebbing.com", false },
  { "lukull-pizza.de", true },
  { "lumbercartel.ca", true },
  { "lumen.sh", true },
  { "lumenbrowser.com", true },
  { "lumi.pw", true },
  { "lumiere.com", true },
  { "luminaire.fr", true },
  { "luminaires-online.fr", true },
  { "luminary.pl", true },
  { "lumitop.com", true },
  { "lumminary.com", true },
  { "lumomongoose.com", true },
  { "lunakit.org", true },
  { "lunalove.de", true },
  { "lunanova.moe", true },
  { "lunapps.com", true },
  { "lunar6.ch", true },
  { "lunarichter.de", true },
  { "lunarlog.com", true },
  { "lunarshark.com", true },
  { "lunarsoft.net", true },
  { "lunartail.nl", true },
  { "lunasqu.ee", true },
  { "lunazacharias.com", true },
  { "lunchbunch.me", true },
  { "lundberghealthadvocates.com", true },
  { "lune-indigo.ch", true },
  { "lunidea.ch", true },
  { "lunidea.com", true },
  { "lunis.net", false },
  { "lunite.net", true },
  { "luodaoyi.com", true },
  { "luoe.me", true },
  { "luoh.cc", true },
  { "luoh.me", true },
  { "luohua.im", true },
  { "luongvu.com", true },
  { "luowu.cc", true },
  { "lupa.cz", true },
  { "lupecode.com", true },
  { "lupinencyclopedia.com", true },
  { "lupinenorthamerica.com", true },
  { "luqsus.pl", true },
  { "lushan.me", true },
  { "lusitom.com", true },
  { "luso-livros.net", true },
  { "lusoft.cz", true },
  { "lust.works", true },
  { "lusteniny.cz", true },
  { "lustin.fr", true },
  { "lustrum.ch", true },
  { "luteijn.biz", true },
  { "luteijn.cloud", true },
  { "luteijn.email", true },
  { "luteijn.pro", true },
  { "luthierunatespalermo.com", true },
  { "lutizi.com", false },
  { "lutoma.org", true },
  { "luukdebruincv.nl", true },
  { "luukklene.nl", true },
  { "luukuton.fi", true },
  { "luuppi.fi", true },
  { "luv.asn.au", true },
  { "luvare.com", true },
  { "luvbridal.com.au", true },
  { "luvplay.co.uk", true },
  { "luxcraft.eng.br", true },
  { "luxecalendar.com", true },
  { "luxsci.com", true },
  { "luxurydistribution.cz", true },
  { "luxurynsight.net", false },
  { "luxuryweddingsindonesia.com", true },
  { "luxusnivoucher.cz", true },
  { "luxusnyvoucher.sk", true },
  { "luxvacuos.net", true },
  { "luxwatch.com", true },
  { "luyckx.net", true },
  { "luzat.com", true },
  { "luzfaltex.com", true },
  { "lv.search.yahoo.com", false },
  { "lv0.it", true },
  { "lvcshu.com", true },
  { "lvftw.com", true },
  { "lvguitars.com", true },
  { "lvmoo.com", true },
  { "lvrsystems.com", true },
  { "lw-addons.net", true },
  { "lwl.moe", true },
  { "lwl12.com", true },
  { "lwsl.ink", true },
  { "lxai.net", true },
  { "lxd.cc", true },
  { "lyam.fr", true },
  { "lycee-saintjoseph-mesnieres.fr", true },
  { "lycetre.com", true },
  { "lycly.me", true },
  { "lydudlejning.net", true },
  { "lyftrideestimate.com", true },
  { "lykai.ca", true },
  { "lymia.moe", true },
  { "lynero.dk", true },
  { "lyness.io", true },
  { "lyngvaer.no", true },
  { "lynnellneri.com", true },
  { "lynnlaytonnissanparts.com", true },
  { "lynnmosher.com", true },
  { "lynsec.com", true },
  { "lynthium.com", true },
  { "lynx.nl", true },
  { "lynxbroker.de", true },
  { "lynxpro.nl", true },
  { "lyon-interactive.com", true },
  { "lyon-synergie.com", true },
  { "lyrical-nonsense.com", true },
  { "lyricfm.ie", true },
  { "lys.ch", true },
  { "lyst.co.uk", true },
  { "lyuly.com", true },
  { "lyx.dk", true },
  { "lzcreation.com", true },
  { "lzh.one", true },
  { "lzwc.nl", true },
  { "m-22.com", true },
  { "m-chemical.com.hk", true },
  { "m-gaming.tk", true },
  { "m-gh.info", true },
  { "m-idea.jp", true },
  { "m-kleinert.de", true },
  { "m-kugpn.ru", true },
  { "m-mail.fr", true },
  { "m-monitor.pl", true },
  { "m-net.de", true },
  { "m-orthodontic.com", true },
  { "m-ses.fr", true },
  { "m.facebook.com", true },
  { "m.mail.ru", true },
  { "m.me", true },
  { "m0t0k1ch1.com", true },
  { "m0v0.com", true },
  { "m134.eu", true },
  { "m2epro.com", true },
  { "m2il.co", true },
  { "m2os.com", true },
  { "m2tm.fr", true },
  { "m4g.ru", true },
  { "m4rcus.de", true },
  { "m5197.co", true },
  { "m6729.co", true },
  { "m6729.com", true },
  { "m6957.co", true },
  { "m9297.co", true },
  { "m9397.com", true },
  { "m9721.com", true },
  { "m9728.co", true },
  { "ma-eir.nl", true },
  { "ma2t.com", true },
  { "maartenderaedemaeker.be", true },
  { "maartenvandekamp.nl", true },
  { "maatwerkopruimcoaching.nl", true },
  { "maatwerkzorgcoaching.nl", true },
  { "maaya.jp", true },
  { "maayogashram.com", true },
  { "mabankonline.com", true },
  { "mabulledu.net", true },
  { "mac-i-tea.ch", true },
  { "mac-service-stockholm.se", true },
  { "mac-servicen.se", true },
  { "mac-support.nu", true },
  { "mac-support.se", true },
  { "mac-world.pl", true },
  { "mac.biz.tr", true },
  { "mac1.net", true },
  { "mac101hq.com", true },
  { "macaw.nl", true },
  { "macaws.org", true },
  { "macbook.es", true },
  { "macedonian-hotels.com", true },
  { "macedonian-hotels.com.mk", true },
  { "macedonian-hotels.mk", true },
  { "maceinturecuir.com", true },
  { "maces-net.de", true },
  { "macgeneral.de", true },
  { "macgenius.com", true },
  { "mach-politik.ch", true },
  { "macha.cloud", true },
  { "machbach.com", true },
  { "machetewp.com", true },
  { "machidaclip.com", true },
  { "machikka.com", false },
  { "machinetransport.com", true },
  { "machon.biz", true },
  { "macht-elektro.de", true },
  { "machtweb.de", true },
  { "machu-picchu.nl", true },
  { "macil.tech", true },
  { "macinyasha.net", true },
  { "mackeysack.com", true },
  { "mackiehouse.ca", true },
  { "macksproductions.in", true },
  { "maclemon.at", true },
  { "macleod.io", true },
  { "macnemo.de", true },
  { "macnetwork.eu", true },
  { "macnetwork.fr", true },
  { "macnetwork.net", true },
  { "maco.org.uk", true },
  { "maconnerie-dcs.ch", true },
  { "macosxfilerecovery.com", true },
  { "macros.co.jp", true },
  { "macrostudent.com", true },
  { "macsupportnacka.se", true },
  { "macsupportstockholm.se", true },
  { "mactools.com.co", true },
  { "mad.ninja", true },
  { "madamegarage.nl", true },
  { "madars.org", false },
  { "madbicicletas.com", true },
  { "madbin.com", true },
  { "madbouncycastles.co.uk", true },
  { "maddi.biz", true },
  { "maddistonevangelical.co.uk", true },
  { "maddreefer.com", true },
  { "made-in-earth.co.jp", true },
  { "made-to-usb.com", true },
  { "madebydusk.com", true },
  { "madebyshore.com", true },
  { "madeinrussia.com", true },
  { "madeinstudio3.com", true },
  { "madeitwor.se", true },
  { "madeloc.com", true },
  { "mademoiselledemargaux.com", true },
  { "mader.jp", true },
  { "madewithopendata.org", true },
  { "madin.ru", true },
  { "madirc.net", true },
  { "madisonent-facialplasticsurgery.com", true },
  { "madisonsquarerealestate.com", true },
  { "madmar.ee", true },
  { "madmax-store.gr", true },
  { "madoka.nu", true },
  { "madpsy.uk", true },
  { "madreacqua.org", true },
  { "madrecha.com", true },
  { "madreshoy.com", true },
  { "madridagency.com", true },
  { "madridartcollection.com", true },
  { "madscientistwebdesign.com", true },
  { "madsstorm.dk", true },
  { "madtec.de", true },
  { "maduradas.info", true },
  { "maduradas.net", true },
  { "madwarlock.com", true },
  { "maedchenflohmarkt.at", true },
  { "maedchenflohmarkt.de", true },
  { "maeln.com", true },
  { "maelstrom-fury.eu", true },
  { "maelstrom.ninja", true },
  { "maeplasticsurgery.com", true },
  { "maesinox.be", true },
  { "maff.co.uk", true },
  { "mafia.network", true },
  { "mafiaforum.de", true },
  { "mafiapenguin.club", true },
  { "mafiasi.de", true },
  { "magasindejouets.com", true },
  { "magasinsalledebain.be", true },
  { "magasinsalledebain.fr", true },
  { "magasinsalledebains.be", true },
  { "magasinsalledebains.fr", true },
  { "magasinsenfrance.com", true },
  { "magazin3513.com", true },
  { "magazinedotreino.com.br", true },
  { "magbt.net", true },
  { "magdeburg.directory", true },
  { "magdic.eu", true },
  { "magebit.com", true },
  { "magenda.sk", true },
  { "magentaize.net", true },
  { "magentapinkinteriors.co.uk", true },
  { "magentoeesti.eu", true },
  { "magepro.fr", true },
  { "magewell.nl", true },
  { "maggie.com", true },
  { "magi-cake.com", true },
  { "magic-cards.info", true },
  { "magical-secrets.com", true },
  { "magical.rocks", true },
  { "magicalcircuslv.com", true },
  { "magicamulet.me", true },
  { "magicball.co", true },
  { "magicbeanschool.com", true },
  { "magicbroccoli.de", true },
  { "magiccards.info", true },
  { "magicdaysomagh.co.uk", true },
  { "magicdlp.com", true },
  { "magicjudges.org", true },
  { "magiclen.org", true },
  { "magicroom.it", true },
  { "magicsms.pl", true },
  { "magicspaceninjapirates.de", true },
  { "magictable.com", true },
  { "magicvodi.at", true },
  { "magilio.com", true },
  { "magnacarebroker.com", true },
  { "magnate.co", true },
  { "magnatronic.com.br", true },
  { "magneticanvil.com", true },
  { "magneticattraction.com.au", true },
  { "magnetpass.uk", true },
  { "magnets.jp", true },
  { "magnificatwellnesscenter.com", true },
  { "magnificentdata.com", true },
  { "magnoliastrong.com", true },
  { "magnunbaterias.com.br", true },
  { "magodaoferta.com.br", true },
  { "magonote-nk.com", true },
  { "magravsitalia.com", true },
  { "magu.kz", true },
  { "maguire.email", true },
  { "magwin.co.uk", true },
  { "mah-nig.ga", true },
  { "mahadulmuneer.org", true },
  { "mahatmayoga.org", true },
  { "mahawi.sk", true },
  { "mahefa.co.uk", true },
  { "mahjong-navi.com", true },
  { "mahjong.org", true },
  { "mahjongrush.com", true },
  { "mahler.io", true },
  { "mahrer.net", true },
  { "maiaimobiliare.ro", true },
  { "maidoty.net", true },
  { "maiebanatulfruncea.com", true },
  { "maijia800.com", true },
  { "maikolfish.it", true },
  { "maikoloc.com", true },
  { "mail-de.jp", true },
  { "mail-rotter.de", true },
  { "mail-settings.google.com", true },
  { "mail.com", true },
  { "mail.de", true },
  { "mail.google.com", true },
  { "mail.storage", true },
  { "mail.yahoo.com", false },
  { "mail180.com", true },
  { "mail4you.in", true },
  { "mailbox.mg", true },
  { "mailbox.org", true },
  { "mailfence.com", true },
  { "mailflank.com", true },
  { "mailhardener.com", true },
  { "mailinabox.email", true },
  { "mailjet.tech", true },
  { "mailjunky.de", true },
  { "maillady-susume.com", true },
  { "mailmag.net", false },
  { "mailman.ml", true },
  { "mailnara.co.kr", true },
  { "mailtelligent.com", true },
  { "mailto.space", true },
  { "mailum.org", false },
  { "mainechiro.com", true },
  { "mainframeserver.space", true },
  { "mainhattan-handwerker.de", true },
  { "mainlined.org", true },
  { "mainone.net", true },
  { "mainquest.org", true },
  { "maintenance-traceur-hp.fr", true },
  { "mainzelmaennchen.net", true },
  { "maioresemelhores.com", true },
  { "maisgasolina.com", true },
  { "maison-haimard.fr", true },
  { "maisondoree.be", true },
  { "maisonpaulmier.fr", true },
  { "maispa.com", true },
  { "maisretorno.com", true },
  { "maisvitaminas.com.br", true },
  { "maitemerino.net", true },
  { "maitheme.com", true },
  { "maiti.info", true },
  { "maitrise-orthopedique.com", true },
  { "majaweb.cz", true },
  { "majemedia.com", false },
  { "majesnix.org", true },
  { "majid.info", true },
  { "majkassab.com", true },
  { "majkassab.net", true },
  { "majkassab.org", true },
  { "majkl.me", true },
  { "majkl.xyz", true },
  { "majkl578.cz", true },
  { "majkyto.cz", true },
  { "majlovesreg.one", true },
  { "majolka.com", true },
  { "majorpaintingco.com", true },
  { "majorpussycum.com", true },
  { "makaleci.com", true },
  { "makalu.me", true },
  { "makariza.com.co", true },
  { "make-your-own-song.com", true },
  { "makeaboldmove.com", true },
  { "makechanges.com.au", true },
  { "makedin.net", true },
  { "makefoodrecipes.com", true },
  { "makem-bounce.co.uk", true },
  { "makenaiyo-fx.com", true },
  { "makerdao.com", true },
  { "makersatwork.com", true },
  { "maketheneighborsjealous.com", true },
  { "makeurbiz.com", true },
  { "maki-chan.de", true },
  { "makinen.ru", true },
  { "makita-online.kz", true },
  { "makkusu.photo", true },
  { "makkyon.com", true },
  { "makos.jp", true },
  { "makowitz.cz", true },
  { "maktoob.search.yahoo.com", false },
  { "maku.edu.tr", true },
  { "malacat.com", true },
  { "malachiteauth.com", true },
  { "malash.me", true },
  { "malaysia.search.yahoo.com", false },
  { "malaysian.dating", true },
  { "maldives.cx", true },
  { "malenaamatomd.com", true },
  { "malenyflorist.com.au", true },
  { "maler-marschalleck.de", true },
  { "malermeister-haussmann.de", true },
  { "malesoowki.blog", true },
  { "malezan.com", true },
  { "maliar.fr", true },
  { "malibu-electric.com", true },
  { "malibuelectrical.com", true },
  { "malibuexteriorlighting.com", true },
  { "malibumodas.com.br", true },
  { "malik.holdings", true },
  { "malik.id", true },
  { "malikussa.id", true },
  { "malikussaid.com", true },
  { "malikzinad.com", true },
  { "malinator.net", false },
  { "malinheadview.ie", true },
  { "malkoun.com", true },
  { "mall.cz", true },
  { "mall.hr", true },
  { "mall.hu", true },
  { "mall.pl", true },
  { "mall.sk", true },
  { "mallach.net", true },
  { "mallhonda.com", true },
  { "mallonline.com.br", true },
  { "malnex.de", true },
  { "malta-firma.com", true },
  { "maltarea.com", true },
  { "malte-kiefer.de", true },
  { "malufs.com.br", true },
  { "malvertise.xyz", true },
  { "malware.watch", true },
  { "malwareinvestigator.gov", true },
  { "malwarekillers.com", true },
  { "malwaretips.com", false },
  { "maly.cz", true },
  { "malyshata.com", true },
  { "malysvet.net", true },
  { "mamabepo.com", true },
  { "mamamoet.ru", true },
  { "mamanecesitaungintonic.com", true },
  { "mamatting.com", true },
  { "mamaxi.org", true },
  { "mambas.cn", true },
  { "mamiecouscous.com", true },
  { "mammals.net", true },
  { "mammaw.com", true },
  { "mammothlakesmls.net", true },
  { "mamoris-net.jp", true },
  { "mamospienas.lt", true },
  { "mamot.fr", false },
  { "mamuko.nl", true },
  { "man3s.jp", false },
  { "mana.ee", true },
  { "manach.net", true },
  { "manage.cm", true },
  { "manage4all.de", true },
  { "manageathome.co.uk", true },
  { "managedhosting.de", true },
  { "managedservicesraleighnc.com", true },
  { "management-companie.ro", true },
  { "managementboek.nl", true },
  { "managementfeedback.com", true },
  { "managementforstartups.com", true },
  { "manageprojects.com", false },
  { "manager-efficacement.com", true },
  { "manager.linode.com", false },
  { "managewp.org", true },
  { "manantialdevida1450.com", true },
  { "manatees.com.au", true },
  { "manatees.net", true },
  { "manavgabhawala.com", true },
  { "manawill.jp", true },
  { "mandcbouncycastlehire.co.uk", true },
  { "mandiblackburnphoto.com", true },
  { "mandynamic.gr", true },
  { "maneggio.milano.it", true },
  { "manesht.ir", true },
  { "manfredgruber.net", true },
  { "manfredi.io", true },
  { "manfredimatteo.com", true },
  { "manfredschafer.ch", true },
  { "mangahigh.com", true },
  { "mangaristica.com", false },
  { "mangel.io", true },
  { "mangnhuapvc.com.vn", true },
  { "mangotwoke.co.uk", true },
  { "manhattanchoralensemble.org", true },
  { "manhole.club", true },
  { "manhuagui.com", true },
  { "maniaiti.nz", true },
  { "manicbouncycastles.co.uk", true },
  { "manicode.com", true },
  { "manicuradegel.com", true },
  { "manicuradegel.es", true },
  { "manilaprinciples.org", true },
  { "maniorpedi.com", true },
  { "maniosglass.gr", true },
  { "manipil.ch", true },
  { "manipurmatka.net", false },
  { "manja-und-martin.de", true },
  { "manjaro.ru", true },
  { "mankans.com", true },
  { "mankomarketing.com", true },
  { "manmeetgill.com", true },
  { "manneguiden.no", true },
  { "mannheimbloggt.tk", true },
  { "mannschafft.ch", true },
  { "manoirdecontres.com", true },
  { "manonandre-avocat.fr", true },
  { "manoro.de", true },
  { "manowarus.com", true },
  { "mansdell.net", true },
  { "mansfeld.pl", true },
  { "manski.net", true },
  { "mantabiofuel.com", true },
  { "mantachiepharmacy.com", true },
  { "manti.by", true },
  { "mantor.org", false },
  { "manualidadeson.com", true },
  { "manuall.co.uk", true },
  { "manuall.cz", true },
  { "manuall.de", true },
  { "manuall.dk", true },
  { "manuall.es", true },
  { "manuall.fi", true },
  { "manuall.fr", true },
  { "manuall.info.tr", true },
  { "manuall.it", true },
  { "manuall.jp", true },
  { "manuall.kr", true },
  { "manuall.no", true },
  { "manuall.pl", true },
  { "manuall.pt", true },
  { "manuall.ro", true },
  { "manuall.se", true },
  { "manualscollection.com", true },
  { "manuel-herrmann.de", true },
  { "manuel-schefczyk.de", true },
  { "manueli.de", true },
  { "manuelpinto.in", false },
  { "manufacturing.gov", true },
  { "manufacturinginmexico.org", true },
  { "manufacturingusa.com", true },
  { "manuscripteditorial.com", true },
  { "manuscriptlink.com", true },
  { "manutd.org.np", true },
  { "manuth.life", true },
  { "manwish.cn", true },
  { "manwithavan.co.uk", true },
  { "manyetikboya.com", true },
  { "manyiu.com", true },
  { "manylots.ru", true },
  { "manyue.org", true },
  { "maoi.re", true },
  { "maomihz.com", true },
  { "maone.net", true },
  { "maorx.cn", true },
  { "maosensanguentadasdejesus.net", true },
  { "maowtm.org", true },
  { "maozedong.red", true },
  { "map-patho.com", true },
  { "map4erfurt.de", true },
  { "map4jena.de", true },
  { "mapasmundi.com.br", true },
  { "mapblender.com", true },
  { "mapchange.org", true },
  { "mapeo.io", true },
  { "maplegate.info", true },
  { "mapletime.com", true },
  { "mapresidentielle.fr", true },
  { "mapstack.org", true },
  { "maquinariaspesadas.org", true },
  { "maquinasdecoserplus.com", true },
  { "maquininhamercadopoint.com.br", true },
  { "mar-eco.no", true },
  { "marabumadrid.com", false },
  { "marabunta.io", true },
  { "marakovits.net", true },
  { "marandu.com.ar", true },
  { "marble.com", true },
  { "marbogardenlidkoping.se", true },
  { "marbree.eu", true },
  { "marc-hammer.de", true },
  { "marc-hoffrichter.de", true },
  { "marc-schlagenhauf.de", true },
  { "marcaixala.me", true },
  { "marcanhoury.com", true },
  { "marcbeije.com", true },
  { "marcceleiro.com", true },
  { "marceau.ovh", true },
  { "marcel-preuss.de", true },
  { "marcel-veronetzki.de", true },
  { "marcel-waldvogel.ch", true },
  { "marcelinofranchini.com", true },
  { "marcelinofranchini.eu", true },
  { "marcelinofranchini.info", true },
  { "marcelinofranchini.net", true },
  { "marcelinofranchini.org", true },
  { "marceljeannin.com", true },
  { "marcelkooiman.com", true },
  { "marcelpreuss.de", true },
  { "marcelsiegert.com", true },
  { "marcelwaldvogel.ch", true },
  { "marcelwiedemeier.com", true },
  { "marcelwolf.coach", true },
  { "marcgoertz.de", true },
  { "marche-contre-monsanto.ch", true },
  { "marcheslep.org.uk", true },
  { "marchhappy.tech", false },
  { "marchukov.com", true },
  { "marciaimportados.com.br", true },
  { "marcianoandtopazio.com", true },
  { "marclay.co.uk", true },
  { "marco-goltz.de", true },
  { "marco-hegenberg.net", true },
  { "marco-polo-reisen.com", true },
  { "marcobicca.com", true },
  { "marcocasoni.com", true },
  { "marcoherten.com", true },
  { "marcoklomp.nl", true },
  { "marcoslater.com", true },
  { "marcotics.nl", true },
  { "marcusds.ca", true },
  { "marcuskoh.com", true },
  { "marcusstafford.com", true },
  { "mareamoda.com", true },
  { "marechal-company.com", true },
  { "marek.pro", true },
  { "marek.su", true },
  { "marelijah.org", true },
  { "margagriesser.de", true },
  { "margatroid.com", true },
  { "margaux-perrin.com", true },
  { "margays.de", true },
  { "margecommunication.com", true },
  { "margo-co.ch", true },
  { "margotlondon.co.uk", true },
  { "marguerite-maison.fr", true },
  { "mariafernanda.com.br", true },
  { "mariaheidemann.nl", true },
  { "marianatherapy.com", true },
  { "marianelaisashi.com", true },
  { "marianhoenscheid.de", true },
  { "mariannenan.nl", true },
  { "mariannethijssen.nl", true },
  { "mariapietropola.com", true },
  { "mariasbonitas.com", true },
  { "mariatash.com", true },
  { "maridonlaw.com", true },
  { "marie-elisabeth.dk", false },
  { "marie-pettenbeck-schule.de", true },
  { "mariehane.com", true },
  { "mariemiramont.fr", true },
  { "mariereichl.cz", true },
  { "marietrap.ch", true },
  { "marijnfidder.nl", true },
  { "marikafranke.de", true },
  { "marilsnijders.nl", true },
  { "marilynmartin.com.au", true },
  { "marilynstreats.com", true },
  { "marin-business-center.ch", true },
  { "marin-dom.ru", false },
  { "marin-tullet.com", true },
  { "marinat2012.de", true },
  { "marinazarza.es", true },
  { "marinbusinesscenter.ch", true },
  { "marine.gov", true },
  { "marinekaplama.com", true },
  { "marinela.com.mx", false },
  { "marinelausa.com", false },
  { "marinershousecalstock.com", true },
  { "marines-shop.com", true },
  { "marioabela.com", true },
  { "mariogeckler.de", false },
  { "mariposah.ch", true },
  { "marisamorby.com", false },
  { "mariskavankasbergen.nl", true },
  { "maritim.go.id", false },
  { "mariushubatschek.de", true },
  { "mariviolin.com", true },
  { "marjeta-gurtner.ch", true },
  { "marjoleindens.be", true },
  { "marjorie-wiki.de", true },
  { "marjoriecarvalho.com.br", true },
  { "mark-dietzer.de", true },
  { "mark-semmler.de", true },
  { "mark1998.com", true },
  { "markaconnor.com", true },
  { "markandrosalind.co.uk", true },
  { "markantoffice.com", true },
  { "markbiesheuvel.nl", true },
  { "markdain.net", true },
  { "markdescande.com", true },
  { "markel.com.es", true },
  { "market-vanna.ru", true },
  { "market.android.com", true },
  { "marketespace.fr", false },
  { "marketindex.com.au", true },
  { "marketing-2.de", true },
  { "marketing.limited", true },
  { "marketing91.com", true },
  { "marketingbrandingnews.com", true },
  { "marketingbrandingnews.net", true },
  { "marketingco.nl", true },
  { "marketingconverts.com", true },
  { "marketingforfood.com", true },
  { "marketinggenerators.nl", false },
  { "marketingtrendnews.com", true },
  { "marketingvirtuales.com", true },
  { "marketnsight.com", true },
  { "markfordelegate.com", true },
  { "markhaehnel.de", true },
  { "markhoodphoto.com", false },
  { "markhoodwrites.com", true },
  { "markido.com", true },
  { "markiewicz.online", true },
  { "markitzeroday.com", true },
  { "markkirkforillinois.com", true },
  { "markkirkforsenate.com", true },
  { "marklauman.ca", true },
  { "markoh.co.uk", true },
  { "markom.rs", true },
  { "markprof.ru", true },
  { "markri.nl", true },
  { "markridgwell.co.uk", true },
  { "markridgwell.com", true },
  { "markridgwellcom.appspot.com", true },
  { "markscastles.co.uk", true },
  { "markshroyer.com", true },
  { "marksm.it", true },
  { "marksmit.co", true },
  { "markspres.org", true },
  { "markstickley.co.uk", true },
  { "markt-heiligenstadt.de", false },
  { "marktcontact.com", true },
  { "marktguru.at", true },
  { "marktguru.de", true },
  { "marktissink.nl", true },
  { "markup-ua.com", true },
  { "markus-blog.de", true },
  { "markus-dev.com", true },
  { "markus-keppeler.de", true },
  { "markus-musiker.de", true },
  { "markus-ullmann.de", true },
  { "markusehrlicher.de", true },
  { "markuskeppeler.de", true },
  { "markuskeppeler.no-ip.biz", true },
  { "markvanacker.be", true },
  { "marl.fr", true },
  { "marloncommunications.com", true },
  { "marlonlosurdopictures.com", true },
  { "marlosoft.net", true },
  { "marmista.roma.it", true },
  { "marmolesromero.com", true },
  { "marmotte.love", true },
  { "marocemploi.co", true },
  { "maroismasso.com", true },
  { "marolu.one", true },
  { "marpa-wohnen.de", true },
  { "marqueswines.co.uk", true },
  { "marrai.de", true },
  { "marriage-shrine.jp", true },
  { "marrickvilleapartments.com.au", true },
  { "marron-dietrecipe.com", true },
  { "marsanvet.com", true },
  { "marsble.com", true },
  { "marseillekiteclub.com", true },
  { "marshallscastles.com", true },
  { "marshallwilson.com", true },
  { "marshmallow.co", true },
  { "marshmallow.com", true },
  { "marsikelektro.cz", true },
  { "martasibaja.com", true },
  { "martel-innovate.com", true },
  { "martelange.ovh", true },
  { "marten-buer.de", true },
  { "martensmxservice.nl", true },
  { "martensson.io", true },
  { "marti201.ga", true },
  { "martialarts-wels.at", true },
  { "martian.tk", true },
  { "martide.com", true },
  { "martijn.site", true },
  { "martijnvanderzande.nl", true },
  { "martin-loewer.de", true },
  { "martin-weil.de", true },
  { "martin.vet", true },
  { "martinbaileyphotography.com", true },
  { "martindimitrov.cz", true },
  { "martine.nu", true },
  { "martineweitweg.de", true },
  { "martinfranc.eu", true },
  { "martinhaunschmid.com", true },
  { "martinkus.eu", true },
  { "martinmuc.de", true },
  { "martinreed.net", true },
  { "martinvillalba.com", true },
  { "martinvillalba.com.ar", true },
  { "martinvillalba.info", true },
  { "martinvillalba.net", true },
  { "martinvillalba.org", true },
  { "martonmihaly.hu", true },
  { "maruhoi.com", true },
  { "marvell.cat", true },
  { "marvelmoviemarathon.com", true },
  { "marvelousdesigners.com", true },
  { "marxists.org", true },
  { "marxmyths.org", true },
  { "marycliffpress.com", true },
  { "maryeclark.com", true },
  { "maryeileen90.party", true },
  { "maryhaze.net", true },
  { "maryjaneroach.com", true },
  { "maryjruggles.com", true },
  { "marykatrinaphotography.com", true },
  { "marylandbasementandcrawlspacewaterproofing.com", true },
  { "masarik.sh", true },
  { "masatotaniguchi.jp", true },
  { "masautonomo.com", true },
  { "masaze-hanka.cz", true },
  { "mascosolutions.com", true },
  { "masdillah.com", true },
  { "maservant.net", true },
  { "mashandco.it", true },
  { "mashandco.tv", true },
  { "mashcape.com", true },
  { "masiniunelte.store.ro", true },
  { "maskim.fr", true },
  { "maslin.io", true },
  { "masrur.org", true },
  { "massaboutique.com", true },
  { "massage-colleges.com", true },
  { "massage-vitalite.fr", true },
  { "massage-well.ch", true },
  { "massage4u.net", true },
  { "massagecoolangatta.com.au", true },
  { "massagecupping.com", true },
  { "massagetainha-hanoi.com", true },
  { "massconsultores.com", true },
  { "massdrop.com", true },
  { "masse.org", true },
  { "massflix.com", true },
  { "massfone.com", true },
  { "masshiro.blog", true },
  { "massoni.pl", true },
  { "massotherapeutique.com", true },
  { "masta.ch", true },
  { "mastah.fr", true },
  { "mastellone.us", true },
  { "mastepinnelaand.nl", true },
  { "master-net.org", true },
  { "mastercardpac.com", true },
  { "masterdemolitioninc.com", true },
  { "masterdigitale.com", true },
  { "masterhelenaroma.com", true },
  { "masterofallscience.com", true },
  { "masterofbytes.ch", true },
  { "masterpassword.org", true },
  { "masterpc.co.uk", true },
  { "masterplc.com", true },
  { "masters.black", true },
  { "mastersadistancia.com", true },
  { "mastersthesiswriting.com", true },
  { "masterstuff.de", true },
  { "mastodon.at", true },
  { "mastodon.host", true },
  { "mastodon.top", true },
  { "mat.tt", true },
  { "matanz.de", true },
  { "matatabimix.com", true },
  { "matatall.com", true },
  { "match.audio", true },
  { "matcha-iga.jp", true },
  { "matchatea24.com", true },
  { "matchboxdesigngroup.com", true },
  { "matchmadeinstubton.com", true },
  { "matdogs.com", true },
  { "mateiko.by", true },
  { "matejgroma.com", true },
  { "matel.org", true },
  { "matematyka.wiki", true },
  { "materassi.roma.it", true },
  { "materiaischiquinho.com.br", true },
  { "material-ui.com", true },
  { "material-world-fuyouhin.com", true },
  { "materialism.com", true },
  { "materialyinzynierskie.pl", true },
  { "maternalsafety.org", true },
  { "matex-tokyo.co.jp", true },
  { "math-coaching.com", true },
  { "math-colleges.com", true },
  { "math.hamburg", true },
  { "mathalexservice.info", true },
  { "mathematik.rocks", false },
  { "matheo-schefczyk.de", true },
  { "mathes.berlin", true },
  { "mathfinder.org", true },
  { "mathhire.org", true },
  { "mathiasbynens.be", true },
  { "mathiasgarbe.de", true },
  { "mathiaswagner.org", true },
  { "mathieuguimond.com", true },
  { "mathieui.net", true },
  { "mathis.com.tr", true },
  { "maths.network", true },
  { "mathspace.co", true },
  { "matijakolaric.com", true },
  { "matildajaneclothing.com", true },
  { "matipl.pl", true },
  { "matjaz.it", true },
  { "matlss.com", true },
  { "matocmedia.com", true },
  { "matok.me.uk", true },
  { "matome-surume.com", true },
  { "matomeathena.com", true },
  { "matoutepetiteboutique.com", true },
  { "matratzentester.com", true },
  { "matridiana.com", true },
  { "matrieux.dk", true },
  { "matrimoni.uk", true },
  { "matriterie-sdv.ro", true },
  { "matrixim.cc", true },
  { "matrixmedia.ro", true },
  { "matrixreq.com", true },
  { "matsu-semi.com", true },
  { "matt-brooks.com", true },
  { "matt-royal.com.cy", true },
  { "matt-royal.gr", true },
  { "matt.gd", true },
  { "matt.re", true },
  { "mattandyana.com", true },
  { "mattari-app.com", true },
  { "mattatoio.eu", true },
  { "mattbsg.xyz", true },
  { "mattcarr.net", false },
  { "mattcoles.io", true },
  { "mattconstruction.com", true },
  { "mattcorp.com", true },
  { "matteobrenci.com", true },
  { "matteomarescotti.it", true },
  { "mattersource.com", true },
  { "mattessons.co.uk", true },
  { "mattferderer.com", true },
  { "mattfin.ch", true },
  { "mattforster.ca", true },
  { "matthecat.com", true },
  { "matthew-cash.com", true },
  { "matthewfells.com", true },
  { "matthewgallagher.co.uk", true },
  { "matthewgrow.com", true },
  { "matthewj.ca", true },
  { "matthewkenny.co.uk", true },
  { "matthewljiang.com", true },
  { "matthewohare.com", true },
  { "matthewsaeger.com", true },
  { "matthewsetter.com", true },
  { "matthey.nl", true },
  { "matthi.coffee", true },
  { "matthi3u.xyz", true },
  { "matthias-muenzner.de", true },
  { "matthiasbeck.com", true },
  { "matthiasheil.de", true },
  { "matthiasott.com", true },
  { "matthiasschwab.de", true },
  { "matthieuschlosser.fr", true },
  { "matthijssen.info", true },
  { "mattiascibien.net", true },
  { "mattlaks.com", true },
  { "mattli.us", true },
  { "mattmccutchen.net", true },
  { "mattmcshane.com", true },
  { "mattonline.me", true },
  { "mattprojects.com", true },
  { "mattwservices.co.uk", true },
  { "matviet.vn", true },
  { "matway.com", true },
  { "matway.net", true },
  { "matze.co", true },
  { "mauerwerk.online", true },
  { "mauerwerkstag.info", true },
  { "mauiticketsforless.com", true },
  { "mauldincookfence.com", true },
  { "mauracher.cc", true },
  { "mauran.me", true },
  { "maureencsmith.ca", true },
  { "mauricedb.nl", true },
  { "mauricioquadradoconsultor.com.br", true },
  { "mauricioquadradocontador.com.br", true },
  { "mauricioquadradofotografia.com.br", true },
  { "maurovacca.com", true },
  { "maury-moteurs.com", true },
  { "mavenclinic.com", true },
  { "mavensecurity.com", true },
  { "maveris.com", true },
  { "mavobiz.at", true },
  { "mavobiz.de", true },
  { "mavoprax.at", true },
  { "mavoprax.de", true },
  { "mavora.at", true },
  { "mavora.de", true },
  { "mavotax.at", true },
  { "mavotax.de", true },
  { "mawo.olkusz.pl", true },
  { "max-moeglich.de", true },
  { "max-went.pl", true },
  { "max.gov", true },
  { "maxb.fm", true },
  { "maxbeenen.de", true },
  { "maxbruckner.de", true },
  { "maxbruckner.org", true },
  { "maxchan.info", true },
  { "maxedgymequipment.com", true },
  { "maxh.me.uk", true },
  { "maximdeboiserie.be", true },
  { "maximdens.be", true },
  { "maximeferon.fr", true },
  { "maximilian-graf.de", true },
  { "maximilian-greger.com", true },
  { "maximilian-staedtler.de", true },
  { "maximiliankaul.de", true },
  { "maximiliankrieg.de", true },
  { "maxims-travel.com", true },
  { "maxinesbydennees.com", true },
  { "maxipcalls.com", true },
  { "maxisito.it", true },
  { "maxkaul.de", true },
  { "maxlaumeister.com", true },
  { "maxmatthe.ws", true },
  { "maxmilton.com", true },
  { "maxmind.com", true },
  { "maxmobiles.ru", true },
  { "maxmoda.eu", true },
  { "maxp.info", true },
  { "maxpl0it.com", true },
  { "maxr1998.de", true },
  { "maxrandolph.com", true },
  { "maxtruxa.com", true },
  { "maxundlara.at", true },
  { "maxwaellenergie.de", true },
  { "maxwell-english.co.jp", false },
  { "maxwellmoore.co.uk", true },
  { "mayaimplant.com", true },
  { "mayavi.co.in", true },
  { "mayhutmuibep.com", true },
  { "mayomarquees.com", true },
  { "mayopartyhire.com", true },
  { "mayorcahill.com", true },
  { "maypolevilla.co.uk", true },
  { "mayrhofer.eu.org", false },
  { "mazda-mps.de", true },
  { "mazda-thermote.com", true },
  { "mazda626.net", true },
  { "mazdaofgermantown.com", true },
  { "maze.design", false },
  { "maze.fr", true },
  { "mazenjobs.com", true },
  { "mazepa.ml", true },
  { "mazi.io", true },
  { "mazurlabs.tk", true },
  { "mazzotta.me", true },
  { "mb-is.info", true },
  { "mb-server.de", true },
  { "mb300sd.com", true },
  { "mb300sd.net", true },
  { "mbaasy.com", true },
  { "mbaestlein.de", true },
  { "mbainflatables.co.uk", true },
  { "mbanq.com", true },
  { "mbardot.com", true },
  { "mbasic.facebook.com", false },
  { "mbcars.be", true },
  { "mbda.gov", false },
  { "mbeo.ch", true },
  { "mbinf.de", false },
  { "mbk.net.pl", true },
  { "mblankhorst.nl", true },
  { "mble.mg", true },
  { "mbr-net.de", true },
  { "mbrooks.info", true },
  { "mbs-journey.com", true },
  { "mbsec.net", true },
  { "mbsr-barmstedt.de", true },
  { "mburaks.com", true },
  { "mbwis.net", true },
  { "mc-jobs.net", true },
  { "mc-ruempel-firmen-und-haushaltsaufloesungen.de", true },
  { "mc-venture.net", false },
  { "mc-web.se", true },
  { "mc81.com", true },
  { "mcatnnlo.org", true },
  { "mcblain.ca", true },
  { "mcblain.com", true },
  { "mcconciergerie.com", true },
  { "mccoolesredlioninn.com", true },
  { "mccordsvillelocksmith.com", true },
  { "mccrackon.com", true },
  { "mcculloughjchris.com", true },
  { "mcdermottautomotive.com", true },
  { "mcdona1d.me", true },
  { "mcdonalds.be", true },
  { "mcdonalds.design", true },
  { "mcdsg.net", true },
  { "mce.eu", true },
  { "mce.nyc", true },
  { "mce55.eu", true },
  { "mcea-hld.jp", true },
  { "mceconferencecentre.eu", true },
  { "mcfedries.com", true },
  { "mcfi.mu", true },
  { "mcfipvt.com", true },
  { "mcfx.us", true },
  { "mcgaccountancy.co.uk", true },
  { "mcgovernance.com", true },
  { "mchel.net", true },
  { "mchopkins.net", true },
  { "mchost.no", true },
  { "mchristopher.com", true },
  { "mcinterface.de", true },
  { "mcivor.me", true },
  { "mcjackk77.me", true },
  { "mckendry.com", true },
  { "mckendry.consulting", true },
  { "mckernan.in", false },
  { "mckinley.school", true },
  { "mcl.de", false },
  { "mcl.gg", true },
  { "mclinflatables.co.uk", true },
  { "mclmotors.co.uk", true },
  { "mclyr.com", true },
  { "mcmillansedationdentistry.com", false },
  { "mcmillanskiclub.com.au", true },
  { "mcneill.io", true },
  { "mcnext.net", true },
  { "mcon.se", true },
  { "mcpaoffice.com", true },
  { "mcpebox.com", true },
  { "mcplayman.de", true },
  { "mcrn.jp", true },
  { "mcsinflatables.co.uk", true },
  { "mcsports.es", true },
  { "mcsrvstat.us", true },
  { "mctitan.net", true },
  { "mctools.org", true },
  { "mcuexchange.com", true },
  { "mcuuid.net", true },
  { "mcversions.net", true },
  { "mcynews.com", true },
  { "mcyukon.com", true },
  { "mczo.net", true },
  { "md-clinica.com.ua", true },
  { "md5file.com", true },
  { "md5hashing.net", true },
  { "mdek.at", true },
  { "mdewendt.de", true },
  { "mdf-bis.com", true },
  { "mdi-wolfsburg.de", true },
  { "mdiv.pl", true },
  { "mdkr.nl", true },
  { "mdlayher.com", true },
  { "mdma.net", true },
  { "mdmed.clinic", true },
  { "mdosch.de", true },
  { "mdpraha.cz", true },
  { "mdrsp.de", true },
  { "mdrthmcs.io", true },
  { "mds-paris.com", true },
  { "mdsave.com", true },
  { "mdtorelli.it", true },
  { "mdx.no", true },
  { "mdxdave.de", true },
  { "mdxn.org", true },
  { "mdzservers.com", true },
  { "me-center.com", true },
  { "me-groups.com", true },
  { "me-soft.nl", true },
  { "me.net.nz", true },
  { "meadowfen.farm", true },
  { "meadowfenfarm.com", true },
  { "mealgoo.com", true },
  { "meamod.com", false },
  { "meangirl.club", true },
  { "meany.xyz", true },
  { "meap.xyz", true },
  { "measureyourpenis.today", true },
  { "meat.org.uk", true },
  { "mebaneattorney.com", true },
  { "mec010.com", true },
  { "mec020.com", true },
  { "mec021.com", true },
  { "mec022.com", true },
  { "mec023.com", true },
  { "mec024.com", true },
  { "mec025.com", true },
  { "mec027.com", true },
  { "mec028.com", true },
  { "mec029.com", true },
  { "mec0310.com", true },
  { "mec0311.com", true },
  { "mec0312.com", true },
  { "mec0313.com", true },
  { "mec0314.com", true },
  { "mec0315.com", true },
  { "mec0316.com", true },
  { "mec0317.com", true },
  { "mec0318.com", true },
  { "mec0319.com", true },
  { "mec0335.com", true },
  { "mec0350.com", true },
  { "mec0351.com", true },
  { "mec0352.com", true },
  { "mec0353.com", true },
  { "mec0354.com", true },
  { "mec0355.com", true },
  { "mec0356.com", true },
  { "mec0357.com", true },
  { "mec0358.com", true },
  { "mec0359.com", true },
  { "mec0370.com", true },
  { "mec0371.com", true },
  { "mec0372.com", true },
  { "mec0373.com", true },
  { "mec0374.com", true },
  { "mec0375.com", true },
  { "mec0376.com", true },
  { "mec0377.com", true },
  { "mec0378.com", true },
  { "mec0379.com", true },
  { "mec0391.com", true },
  { "mec0392.com", true },
  { "mec0393.com", true },
  { "mec0394.com", true },
  { "mec0395.com", true },
  { "mec0396.com", true },
  { "mec0398.com", true },
  { "mec0410.com", true },
  { "mec0411.com", true },
  { "mec0412.com", true },
  { "mec0413.com", true },
  { "mec0414.com", true },
  { "mec0415.com", true },
  { "mec0416.com", true },
  { "mec0419.com", true },
  { "mec0421.com", true },
  { "mec0429.com", true },
  { "mec0431.com", true },
  { "mec0432.com", true },
  { "mec0433.com", true },
  { "mec0434.com", true },
  { "mec0435.com", true },
  { "mec0436.com", true },
  { "mec0437.com", true },
  { "mec0438.com", true },
  { "mec0439.com", true },
  { "mec0440.com", true },
  { "mec0450.com", true },
  { "mec0451.com", true },
  { "mec0452.com", true },
  { "mec0453.com", true },
  { "mec0454.com", true },
  { "mec0455.com", true },
  { "mec0456.com", true },
  { "mec0457.com", true },
  { "mec0458.com", true },
  { "mec0459.com", true },
  { "mec0470.com", true },
  { "mec0471.com", true },
  { "mec0472.com", true },
  { "mec0473.com", true },
  { "mec0474.com", true },
  { "mec0475.com", true },
  { "mec0476.com", true },
  { "mec0477.com", true },
  { "mec0478.com", true },
  { "mec0479.com", true },
  { "mec0482.com", true },
  { "mec0483.com", true },
  { "mec0510.com", true },
  { "mec0511.com", true },
  { "mec0512.com", true },
  { "mec0513.com", true },
  { "mec0514.com", true },
  { "mec0515.com", true },
  { "mec0516.com", true },
  { "mec0517.com", true },
  { "mec0518.com", true },
  { "mec0519.com", true },
  { "mec0523.com", true },
  { "mec0530.com", true },
  { "mec0531.com", true },
  { "mec0532.com", true },
  { "mec0533.com", true },
  { "mec0534.com", true },
  { "mec0535.com", true },
  { "mec0536.com", true },
  { "mec0537.com", true },
  { "mec0538.com", true },
  { "mec0539.com", true },
  { "mec0550.com", true },
  { "mec0551.com", true },
  { "mec0552.com", true },
  { "mec0553.com", true },
  { "mec0554.com", true },
  { "mec0555.com", true },
  { "mec0556.com", true },
  { "mec0557.com", true },
  { "mec0558.com", true },
  { "mec0559.com", true },
  { "mec0561.com", true },
  { "mec0562.com", true },
  { "mec0563.com", true },
  { "mec0564.com", true },
  { "mec0565.com", true },
  { "mec0566.com", true },
  { "mec0570.com", true },
  { "mec0571.com", true },
  { "mec0572.com", true },
  { "mec0573.com", true },
  { "mec0574.com", true },
  { "mec0575.com", true },
  { "mec0576.com", true },
  { "mec0577.com", true },
  { "mec0578.com", true },
  { "mec0579.com", true },
  { "mec0580.com", true },
  { "mec0591.com", true },
  { "mec0592.com", true },
  { "mec0593.com", true },
  { "mec0594.com", true },
  { "mec0595.com", true },
  { "mec0596.com", true },
  { "mec0597.com", true },
  { "mec0598.com", true },
  { "mec0599.com", true },
  { "mec0660.com", true },
  { "mec0661.com", true },
  { "mec0662.com", true },
  { "mec0663.com", true },
  { "mec0691.com", true },
  { "mec0692.com", true },
  { "mec0701.com", true },
  { "mec0710.com", true },
  { "mec0711.com", true },
  { "mec0712.com", true },
  { "mec0713.com", true },
  { "mec0714.com", true },
  { "mec0715.com", true },
  { "mec0716.com", true },
  { "mec0717.com", true },
  { "mec0718.com", true },
  { "mec0719.com", true },
  { "mec0722.com", true },
  { "mec0724.com", true },
  { "mec0728.com", true },
  { "mec0730.com", true },
  { "mec0731.com", true },
  { "mec0732.com", true },
  { "mec0733.com", true },
  { "mec0734.com", true },
  { "mec0735.com", true },
  { "mec0736.com", true },
  { "mec0737.com", true },
  { "mec0738.com", true },
  { "mec0739.com", true },
  { "mec0743.com", true },
  { "mec0744.com", true },
  { "mec0745.com", true },
  { "mec0746.com", true },
  { "mec0751.com", true },
  { "mec0752.com", true },
  { "mec0753.com", true },
  { "mec0754.com", true },
  { "mec0755.com", true },
  { "mec0756.com", true },
  { "mec0757.com", true },
  { "mec0758.com", true },
  { "mec0759.com", true },
  { "mec0760.com", true },
  { "mec0762.com", true },
  { "mec0763.com", true },
  { "mec0765.com", true },
  { "mec0766.com", true },
  { "mec0768.com", true },
  { "mec0769.com", true },
  { "mec0770.com", true },
  { "mec0771.com", true },
  { "mec0772.com", true },
  { "mec0773.com", true },
  { "mec0774.com", true },
  { "mec0775.com", true },
  { "mec0776.com", true },
  { "mec0777.com", true },
  { "mec0778.com", true },
  { "mec0779.com", true },
  { "mec0790.com", true },
  { "mec0791.com", true },
  { "mec0792.com", true },
  { "mec0793.com", true },
  { "mec0794.com", true },
  { "mec0795.com", true },
  { "mec0796.com", true },
  { "mec0797.com", true },
  { "mec0798.com", true },
  { "mec0799.com", true },
  { "mec0810.com", true },
  { "mec0811.com", true },
  { "mec0812.com", true },
  { "mec0813.com", true },
  { "mec0814.com", true },
  { "mec0816.com", true },
  { "mec0817.com", true },
  { "mec0818.com", true },
  { "mec0819.com", true },
  { "mec0826.com", true },
  { "mec0827.com", true },
  { "mec0830.com", true },
  { "mec0831.com", true },
  { "mec0832.com", true },
  { "mec0833.com", true },
  { "mec0834.com", true },
  { "mec0835.com", true },
  { "mec0836.com", true },
  { "mec0837.com", true },
  { "mec0838.com", true },
  { "mec0839.com", true },
  { "mec0840.com", true },
  { "mec0851.com", true },
  { "mec0852.com", true },
  { "mec0853.com", true },
  { "mec0854.com", true },
  { "mec0855.com", true },
  { "mec0856.com", true },
  { "mec0857.com", true },
  { "mec0858.com", true },
  { "mec0859.com", true },
  { "mec0870.com", true },
  { "mec0871.com", true },
  { "mec0872.com", true },
  { "mec0873.com", true },
  { "mec0874.com", true },
  { "mec0875.com", true },
  { "mec0876.com", true },
  { "mec0877.com", true },
  { "mec0878.com", true },
  { "mec0879.com", true },
  { "mec0881.com", true },
  { "mec0883.com", true },
  { "mec0886.com", true },
  { "mec0887.com", true },
  { "mec0888.com", true },
  { "mec0890.com", true },
  { "mec0891.com", true },
  { "mec0898.com", true },
  { "mec0899.com", true },
  { "mec0910.com", true },
  { "mec0911.com", true },
  { "mec0912.com", true },
  { "mec0913.com", true },
  { "mec0914.com", true },
  { "mec0915.com", true },
  { "mec0916.com", true },
  { "mec0917.com", true },
  { "mec0919.com", true },
  { "mec0930.com", true },
  { "mec0931.com", true },
  { "mec0932.com", true },
  { "mec0933.com", true },
  { "mec0934.com", true },
  { "mec0935.com", true },
  { "mec0936.com", true },
  { "mec0937.com", true },
  { "mec0938.com", true },
  { "mec0941.com", true },
  { "mec0943.com", true },
  { "mec0951.com", true },
  { "mec0952.com", true },
  { "mec0953.com", true },
  { "mec0954.com", true },
  { "mec0971.com", true },
  { "mec0972.com", true },
  { "mec0973.com", true },
  { "mec0974.com", true },
  { "mec0975.com", true },
  { "mec0976.com", true },
  { "mec0977.com", true },
  { "mec0991.com", true },
  { "mec111.com", true },
  { "mec222.com", true },
  { "mec333.com", true },
  { "mec444.com", true },
  { "mec555.com", true },
  { "mec825.com", true },
  { "mec888.com", true },
  { "mec999.com", true },
  { "mecanicoautomotriz.org", true },
  { "mecaniquemondor.com", true },
  { "meccano.srl", true },
  { "mechanics-schools.com", true },
  { "mechanus.io", true },
  { "mechaspartans6648.com", true },
  { "mechmk1.me", true },
  { "mechok.ru", true },
  { "med-colleges.com", true },
  { "med-otzyv.ru", true },
  { "med-post.biz", true },
  { "med-post.co", true },
  { "med-post.com", true },
  { "med-post.net", true },
  { "med-post.org", true },
  { "med-postclinic.com", true },
  { "med-postdoctor.com", true },
  { "med-postdoctors.com", true },
  { "med-postemergency.com", true },
  { "med-posthealth.com", true },
  { "med-postmedical.com", true },
  { "med-postphysicians.com", true },
  { "med-postwellness.com", true },
  { "med.tips", true },
  { "med360.at", true },
  { "medba.se", true },
  { "medbreaker-friends.at", true },
  { "medcir.com.br", true },
  { "medcorfu.gr", true },
  { "medcrowd.com", true },
  { "meddelare.com", true },
  { "meddigital.com", false },
  { "medecine-esthetique-du-calaisis.fr", true },
  { "medeinos.lt", true },
  { "medellinapartamentos.com", true },
  { "medexpress.co.uk", true },
  { "medguide-bg.com", true },
  { "medhy.fr", true },
  { "medi.com.br", true },
  { "media-credit.eu", true },
  { "media-instance.ru", true },
  { "media-library.co.uk", true },
  { "media-pi.com", true },
  { "media-serwis.com", true },
  { "mediaarea.net", true },
  { "mediabackoffice.co.jp", true },
  { "mediablaster.com", true },
  { "mediabogen.net", true },
  { "mediaburst.co.uk", true },
  { "mediacloud.me", true },
  { "mediadex.be", true },
  { "mediaexpert.fr", true },
  { "mediafart.fr", true },
  { "mediafly.com", true },
  { "mediafocus.biz", true },
  { "mediagenic.ch", true },
  { "mediagold.it", true },
  { "mediagrand.net", true },
  { "mediahaus.de", true },
  { "mediajurnal.com", true },
  { "medialab.nrw", true },
  { "medialys.ca", true },
  { "mediamarkt.pl", true },
  { "mediapart.fr", true },
  { "mediapath.gr", true },
  { "mediarithmics.com", true },
  { "mediarithmics.io", true },
  { "mediaselection.eu", true },
  { "mediathekview.de", true },
  { "mediationculturelleclp.ch", true },
  { "mediatorzy.waw.pl", true },
  { "mediaukkies.nl", true },
  { "mediawijsheid.nl", true },
  { "mediawijzer.net", true },
  { "mediawiki.org", true },
  { "mediawin.pl", true },
  { "medic-world.com", true },
  { "medical-assistant-colleges.com", true },
  { "medicalabroad.org", true },
  { "medicalcountermeasures.gov", true },
  { "medicare-providers.net", true },
  { "medicarecoveragefinder.com", true },
  { "medicareinfo.org", true },
  { "medicinasaludvida.com", true },
  { "medicine.com", true },
  { "medicinesfast.com", false },
  { "medicinia.com.br", true },
  { "mediciventures.com", true },
  { "medicm.jp", true },
  { "medicocompetente.it", true },
  { "medicoresponde.com.br", true },
  { "medicsz.co", true },
  { "medienweite.de", true },
  { "medifi.com", true },
  { "medigap-quote.net", true },
  { "medikalakademi.com.tr", true },
  { "medikuma.com", true },
  { "medino.com", true },
  { "medinside.ch", true },
  { "medinside.li", true },
  { "medinsider.ch", true },
  { "medinsider.li", true },
  { "meditadvisors.com", true },
  { "meditation-rennes.org", true },
  { "meditel.nl", true },
  { "medium.com", true },
  { "medja.net", true },
  { "medlabmediagroup.com", true },
  { "medlineplus.gov", true },
  { "medo64.com", true },
  { "medovea.ru", true },
  { "medpeer.co.jp", true },
  { "medpeer.jp", true },
  { "medpics.com", true },
  { "medpost.biz", true },
  { "medpost.co", true },
  { "medpost.com", true },
  { "medpost.info", true },
  { "medpost.me", true },
  { "medpost.mobi", true },
  { "medpost.tv", true },
  { "medpost.us", true },
  { "medpostcare.com", true },
  { "medpostclinic.com", true },
  { "medpostdoctor.com", true },
  { "medpostdoctors.com", true },
  { "medpostemergency.com", true },
  { "medpostexpresscare.com", true },
  { "medposthealth.com", true },
  { "medposthealthcare.com", true },
  { "medpostimmediatecare.com", true },
  { "medpostmedical.com", true },
  { "medpostphysicians.com", true },
  { "medposturgentcare.biz", true },
  { "medposturgentcare.co", true },
  { "medposturgentcare.com", true },
  { "medposturgentcare.info", true },
  { "medposturgentcare.net", true },
  { "medposturgentcare.org", true },
  { "medpostwalkincare.com", true },
  { "medpostwellness.com", true },
  { "medsblalabs.com", true },
  { "medschat.com", true },
  { "medtalents.ch", true },
  { "medtehnika.ua", true },
  { "medtip.de", true },
  { "medusa.wtf", true },
  { "meduza.io", true },
  { "medvedikorenka.cz", true },
  { "medvedkovo-hovrino.ru", true },
  { "medvet.com.es", true },
  { "medvezhii-ozera.ru", true },
  { "medwaybouncycastlehire.co.uk", true },
  { "medyotan.ga", true },
  { "medzinenews.com", false },
  { "meeco.kr", true },
  { "meedoenhartvanwestbrabant.nl", true },
  { "meehle.com", true },
  { "meeplegamers.com", true },
  { "meereskunst.de", true },
  { "meerman.nl", true },
  { "meermantechnischburo.nl", true },
  { "meerutcake.com", true },
  { "meesteresmisty.nl", true },
  { "meet.google.com", true },
  { "meetawesomepeople.net", true },
  { "meetbot.fedoraproject.org", true },
  { "meetingapplication.com", true },
  { "meetingfriends.ch", true },
  { "meetingmanage.nl", true },
  { "meetingmanager.ovh", true },
  { "meetings2.com", true },
  { "meetmygoods.com", true },
  { "meetscompany.jp", true },
  { "meeusen-usedcars.be", true },
  { "meeztertom.nl", true },
  { "meg-a-bounce.co.uk", true },
  { "mega-byte.nl", true },
  { "mega.co.nz", true },
  { "mega.nz", true },
  { "megabounce.co.uk", true },
  { "megabounceni.co.uk", true },
  { "megabouncingcastles.com", true },
  { "megaflowers.ru", true },
  { "megagifs.de", true },
  { "megainflatables.co.uk", true },
  { "megakoncert90.cz", true },
  { "megamisja.pl", true },
  { "megamp3.eu", true },
  { "meganandmarc.us", true },
  { "meganreel.com", false },
  { "megapixel.cz", true },
  { "megaplan.cz", true },
  { "megaplan.ru", true },
  { "megarex.jp", true },
  { "megauction.tk", true },
  { "megawarez.org", true },
  { "megaxchange.com", true },
  { "megaxchange.org", true },
  { "meggidesign.com", true },
  { "mego.cloud", true },
  { "megumico.net", true },
  { "megztosidejos.lt", true },
  { "meh.is", true },
  { "mehalick.com", true },
  { "mehhh.xyz", true },
  { "mehmetdursun.av.tr", true },
  { "mehmetince.net", true },
  { "mehostdd.com", false },
  { "mehr-schulferien.de", true },
  { "mehrleben.at", true },
  { "mehrnevesht.com", true },
  { "mehrwert.de", true },
  { "meia.ir", true },
  { "meidev.co", true },
  { "meierhofer.net", true },
  { "meikan.moe", true },
  { "meillard-auto-ecole.ch", true },
  { "meilleur.info", true },
  { "meilleurstrucs.com", true },
  { "mein-gehalt.at", true },
  { "mein-kuechenhelfer.de", true },
  { "mein-muehlhausen.bayern", true },
  { "mein-webportal.de", true },
  { "meinbetriebsrat24.de", true },
  { "meincenter-meinemeinung.de", true },
  { "meincoach.at", true },
  { "meine-cloud-online.de", true },
  { "meine-email-im.net", true },
  { "meine-finanzanalyse.de", true },
  { "meine-immofinanzierung.de", true },
  { "meineit.dvag", true },
  { "meinewolke.pw", true },
  { "meinezwangsversteigerung.de", true },
  { "meinheizstrom.de", true },
  { "meintragebaby.de", true },
  { "meinv.asia", true },
  { "meiodomato.com.br", true },
  { "meiqia.cn", true },
  { "meiqia.com", true },
  { "meisterlabs.com", true },
  { "meistertask.com", true },
  { "meitan.gz.cn", true },
  { "meizitang.es", true },
  { "mekesh.com", true },
  { "mekesh.net", true },
  { "mekesh.ru", true },
  { "meklon.net", true },
  { "mekongeye.com", true },
  { "melanfengshui.com", true },
  { "melaniebernhardt.com", true },
  { "melaniegruber.de", true },
  { "melbourne.dating", true },
  { "melcher.it", true },
  { "melchizedek-forum.de", true },
  { "meldcode-assistent.nl", true },
  { "melearning.university", false },
  { "melerpaine.com", true },
  { "melhoresdominios.com", true },
  { "melhoresmarcasdenotebook.com.br", true },
  { "melikoff.es", true },
  { "melillaorienta.es", true },
  { "melina-schefczyk.de", true },
  { "melissaadkins.com", true },
  { "melissameuwszen.nl", true },
  { "melnessgroup.com", true },
  { "melnikov.ch", true },
  { "melodict.com", true },
  { "melodiouscode.co.uk", true },
  { "melodiouscode.com", true },
  { "melodiouscode.net", true },
  { "melodiouscode.uk", true },
  { "melodrom.de", true },
  { "melopie.com", true },
  { "melosyne.com", true },
  { "melosyne.de", true },
  { "melosyne.net", true },
  { "melosyne.org", true },
  { "meltzow.net", true },
  { "members-arbourlake.com", true },
  { "members-only-shopping.com", true },
  { "members.nearlyfreespeech.net", false },
  { "membershipservices.org.uk", true },
  { "meme-photostudio.com.tw", true },
  { "meme.fi", true },
  { "meme.institute", true },
  { "memememememememe.me", true },
  { "memes.nz", true },
  { "memesbee.com", true },
  { "memfrob.org", true },
  { "memiux.com", true },
  { "memmertusa.com", true },
  { "memo-linux.com", true },
  { "memo.ee", true },
  { "memo2ch.com", true },
  { "memoire-resistance-ariege.fr", true },
  { "memorycards.ie", true },
  { "memoryex.net", true },
  { "memrise.com", true },
  { "menanwc.org", true },
  { "menden.com", true },
  { "mendipbouncycastles.co.uk", true },
  { "mendozagenevieve.com", true },
  { "mendy.jp", true },
  { "mengxin.life", true },
  { "menielias.com", true },
  { "menkyo-blog.com", true },
  { "mennace.com", true },
  { "menno.me", true },
  { "menole.com", true },
  { "menole.de", true },
  { "menole.net", true },
  { "mensagemaniversario.com.br", true },
  { "mensagemdaluz.com", true },
  { "mensagensaniversario.com.br", true },
  { "mensagensdeconforto.com.br", true },
  { "mensarena.gr", true },
  { "mensch-peter.me", true },
  { "menshealthinsurance.com", true },
  { "mentalhealthmn.org", true },
  { "mentaltraining-fuer-musiker.ch", true },
  { "mentecuriosa.net", true },
  { "mentiq.az", true },
  { "menudieta.com", true },
  { "menuonlineordering.com", true },
  { "menzietti.it", true },
  { "meo.de", true },
  { "mephedrone.org", true },
  { "meps.net", true },
  { "mer.gd", true },
  { "merakilp.com", true },
  { "meransuedtirol.com", true },
  { "meraseo.com", true },
  { "mercadeolocal.com.ar", true },
  { "mercadoleal.com.br", true },
  { "mercadopago.com", true },
  { "mercamaris.es", true },
  { "mercari.com", true },
  { "mercedes-benz.io", true },
  { "mercedes-ig.de", true },
  { "mercedespartscenter.com", true },
  { "merchant-automotive.com", true },
  { "merchcity.com", true },
  { "mercier-auto.com", true },
  { "mercier-cars.co.uk", true },
  { "mercredifiction.io", true },
  { "mercury.photo", true },
  { "mercuryamericas.com", false },
  { "meremeti-online.gr", true },
  { "meremobil.dk", true },
  { "merenbach.com", true },
  { "merenita.com", true },
  { "merenita.eu", true },
  { "merenita.net", true },
  { "merenita.nl", true },
  { "meric-graphisme.info", true },
  { "meridianenvironmental.com", true },
  { "meridianfresno.com", true },
  { "meridianmetals.com", true },
  { "meridianoshop.com.br", true },
  { "merkel.me", true },
  { "merlet.eu", true },
  { "merlinsoap.com", true },
  { "merloaded.rocks", true },
  { "merojob.com", true },
  { "meronberry.jp", true },
  { "merpay.com", true },
  { "mers.one", true },
  { "merson.org", true },
  { "merson.tv", true },
  { "mertarauh.com", true },
  { "mertcangokgoz.com", true },
  { "meruri.com", true },
  { "merzai.co.uk", true },
  { "mes-bouquins.fr", true },
  { "mes-finances.be", true },
  { "mes10doigts.ovh", true },
  { "mesami-art.de", true },
  { "mesappros.com", true },
  { "mescaline.com", true },
  { "mescaline.org", true },
  { "mesec.cz", true },
  { "mesh.gov", true },
  { "meshok.info", true },
  { "mesicka.com", true },
  { "mesomeds.com", true },
  { "messagescelestes-archives.ca", true },
  { "messagevortex.com", true },
  { "messagevortex.net", true },
  { "messdorferfeld.de", true },
  { "messenger.com", false },
  { "messengerwebbrands.com", true },
  { "messer24.ch", true },
  { "messymom.com", true },
  { "mestazitrka.cz", true },
  { "mesvt.com", true },
  { "meta-db.com", true },
  { "meta-word.com", true },
  { "meta4.be", true },
  { "metachris.com", true },
  { "metacoda.com", true },
  { "metacode.biz", true },
  { "metadata.be", true },
  { "metaether.net", true },
  { "metafurquest.net", true },
  { "metaglyphics.com", true },
  { "metainnovative.net", true },
  { "metallomania.it", true },
  { "metallosajding.ru", true },
  { "metalu.ch", true },
  { "metanic.services", true },
  { "metanodo.com", true },
  { "metapeen.nl", true },
  { "metasquare.com.au", true },
  { "metasquare.nyc", true },
  { "metasyntactic.xyz", true },
  { "metasysteminfo.com", true },
  { "metaurl.io", true },
  { "metaword.com", true },
  { "metaword.net", true },
  { "metaword.org", true },
  { "metebalci.com", false },
  { "meteenonline.nl", true },
  { "meteo-parc.com", true },
  { "meteo-r.ovh", true },
  { "meteobox.co", true },
  { "meteobox.cz", true },
  { "meteobox.de", true },
  { "meteobox.es", true },
  { "meteobox.fr", true },
  { "meteobox.mx", true },
  { "meteobox.pl", true },
  { "meteobox.sk", true },
  { "meteocat.net", true },
  { "meteorapp.space", true },
  { "meteorites-for-sale.com", true },
  { "meteorologiaenred.com", true },
  { "meteosmit.it", true },
  { "meter.md", true },
  { "meterhost.com", true },
  { "methamphetamine.co.uk", true },
  { "methylone.com", true },
  { "metric.ai", true },
  { "metricmutt.com", true },
  { "metro-lawn-care.com", true },
  { "metro-web.net", true },
  { "metroairvirtual.com", true },
  { "metrobriefs.com", true },
  { "metrodetroitmommy.com", true },
  { "metrolush.com", true },
  { "metron-eging.com", true },
  { "metron-networks.com", true },
  { "metron-online.com", true },
  { "metronaut.de", true },
  { "metronews.co.nz", true },
  { "metropolisil.gov", true },
  { "metropop.ch", true },
  { "metsasta.com", true },
  { "mettekopp.dk", true },
  { "meubanco7.com.br", true },
  { "meujeitodigital.com.br", false },
  { "meupainel.me", true },
  { "meurisse.org", true },
  { "mevanshop.com", false },
  { "mevo.xyz", true },
  { "mevs.cz", true },
  { "mexican.dating", true },
  { "mexicanjokes.net", true },
  { "mexico.sh", true },
  { "mexicom.org", true },
  { "meyash.co", true },
  { "mezzehuis.be", true },
  { "mf-fischer.de", true },
  { "mfen.de", true },
  { "mfits.co.uk", true },
  { "mflodin.se", true },
  { "mfxbe.de", true },
  { "mgdigitalmarketing.com.au", true },
  { "mghw.ch", true },
  { "mgi.gov", true },
  { "mgiljum.com", true },
  { "mglink.be", true },
  { "mgrossklaus.de", true },
  { "mgrt.net", true },
  { "mgsisk.com", true },
  { "mgtbaas.eu", true },
  { "mgvideo.com.au", true },
  { "mhadot.com", true },
  { "mhalfter.de", true },
  { "mhand.org", true },
  { "mhatero.com", true },
  { "mhatlaw.com", true },
  { "mheistermann.de", true },
  { "mhermans.nl", true },
  { "mhf.gc.ca", true },
  { "mhi.web.id", true },
  { "mhjuma.com", true },
  { "mhtdesign.net", true },
  { "mhurologytriad.org", true },
  { "mi-beratung.de", true },
  { "mi-so-ji.com", true },
  { "mi80.com", true },
  { "mi92.ru", true },
  { "mia.ac", true },
  { "miadennees.com", true },
  { "miagexport.com", true },
  { "miah.top", true },
  { "mialquilerdecoches.com", true },
  { "miamaibaum.com", true },
  { "miaololi.com", true },
  { "miaomiao.eu.org", true },
  { "miaomiaomiao.live", true },
  { "miaonagemi.com", true },
  { "miaowo.org", true },
  { "miavierra.org", true },
  { "mibh.de", true },
  { "mibuiin.com", true },
  { "micado-software.com", true },
  { "micalodeal.ch", true },
  { "micbase.com", true },
  { "michadenheijer.com", true },
  { "michael-schefczyk.de", true },
  { "michael-steinhauer.eu", true },
  { "michael.band", true },
  { "michaelasawyer.com", true },
  { "michaelband.co", true },
  { "michaelband.com", true },
  { "michaelcullen.name", true },
  { "michaelhrehor.com", true },
  { "michaelismold.com", true },
  { "michaelizquierdo.com", true },
  { "michaeljdennis.com", true },
  { "michaelklos.nl", true },
  { "michaelkuchta.me", true },
  { "michaell.io", true },
  { "michaell.xyz", true },
  { "michaelleibundgut.com", true },
  { "michaelloveys.com", true },
  { "michaelpelletterie.it", true },
  { "michaelpfrommer.de", true },
  { "michaelpfrommer.pub", true },
  { "michaelschmidt.ch", true },
  { "michaelschubert.com", true },
  { "michaelschule-rheine.de", true },
  { "michaelsweater.com", true },
  { "michaeltaboada.me", true },
  { "michaeltroger.com", true },
  { "michaeltruskowski.com", true },
  { "michaelwermeester.com", true },
  { "michal-s.net", true },
  { "michal-spacek.com", true },
  { "michal-spacek.cz", true },
  { "michaldudek.it", true },
  { "michalklabnik.cz", true },
  { "michalspacek.com", true },
  { "michalspacek.cz", true },
  { "michalwiglasz.cz", true },
  { "michaonline.de", true },
  { "michel-wein.de", true },
  { "michele.ml", true },
  { "michellavat.com", true },
  { "michelletmc.com", true },
  { "michelskovbo.dk", true },
  { "michiganstateuniversityonline.com", true },
  { "michiganunionoptout.com", true },
  { "michilaw.com", true },
  { "michmexguides.com.mx", true },
  { "michu.pl", true },
  { "mickelvaessen.com", true },
  { "miconcinemas.com", true },
  { "micopal.com", true },
  { "micr.io", true },
  { "micr0lab.org", true },
  { "micra.org.uk", true },
  { "microbiote-insectes-vecteurs.group", true },
  { "microco.sm", true },
  { "microcomploja.com.br", true },
  { "microdots.de", true },
  { "microfonejts.com.br", true },
  { "microlog.org", true },
  { "micromata.de", true },
  { "micromegas.com.ua", true },
  { "micromind.io", true },
  { "micromookie.com", true },
  { "microneedlingstudio.se", true },
  { "microsoftaffiliates.azurewebsites.net", true },
  { "microvb.com", true },
  { "microwesen.de", true },
  { "microzubr.com", true },
  { "micsell.com", true },
  { "midair.io", true },
  { "midamericapiering.com", true },
  { "midart.ro", true },
  { "midasjewellery.com.au", true },
  { "midcarolinaregionalairport.com", true },
  { "midcarolinaregionalairport.org", true },
  { "midgawash.com", true },
  { "midi-ctes.fr", true },
  { "midiaid.de", true },
  { "midislandrealty.com", true },
  { "midistop.org", true },
  { "midkam.ca", true },
  { "midlandgate.de", true },
  { "midlandleisuresales.co.uk", true },
  { "midlandroofingri.com", true },
  { "midlandsfundays.co.uk", true },
  { "midlandsphotobooths.co.uk", true },
  { "midnight-visions.de", true },
  { "midnightmango.co.uk", true },
  { "midnightmango.de", true },
  { "midnightmechanism.com", true },
  { "midrandplumber24-7.co.za", true },
  { "midress.club", true },
  { "midstatebasement.com", true },
  { "midt.io", true },
  { "midterm.us", true },
  { "midtowndentistry.com", true },
  { "midweb.ro", false },
  { "midwestbloggers.org", true },
  { "midwestplus.com", true },
  { "miegl.com", true },
  { "miegl.cz", true },
  { "miele-katerini.gr", true },
  { "miemus.eu", true },
  { "mierloiu.ro", true },
  { "mietwohnungen-vermietung.com", true },
  { "mieuxgrandir.ch", true },
  { "miffy.me", true },
  { "mig5.net", true },
  { "miggy.org", true },
  { "mightysighty.com", true },
  { "miguel.pw", true },
  { "migueldemoura.com", true },
  { "miguelgaton.es", true },
  { "miguelmenendez.pro", true },
  { "miguelmoura.com", true },
  { "miguia.tv", true },
  { "mihgroup.net", true },
  { "mihnea.net", true },
  { "mijailovic.net", true },
  { "mijcorijneveld.nl", true },
  { "mijn-financien.be", true },
  { "mijn.computer", true },
  { "mijnetz.nl", true },
  { "mijnkerstkaarten.be", true },
  { "mijnkinderkleding.com", true },
  { "mijnpartijhandel.nl", true },
  { "mijnreisoverzicht.nl", true },
  { "mijnstembureau.nl", true },
  { "mijntelefoonboek.com", true },
  { "mijntransacties.nl", true },
  { "mika.moe", true },
  { "mikadoe.nl", true },
  { "mikakalathil.ca", true },
  { "mikakalevi.com", true },
  { "mikalikes.men", true },
  { "mike-bland.com", true },
  { "mike-burns.com", true },
  { "mike-et-pascale-sanger.com", true },
  { "mike2k.de", true },
  { "mikeandersondj.com", true },
  { "mikebelanger.ca", true },
  { "mikeblog.site", true },
  { "mikebutcher.ca", true },
  { "mikecapson.com", true },
  { "mikecb.org", true },
  { "mikegao.net", false },
  { "mikegao.org", true },
  { "mikegarnett.co.uk", true },
  { "mikegerwitz.com", true },
  { "mikehamburg.com", true },
  { "mikehilldesign.co.uk", true },
  { "mikeklidjian.com", true },
  { "mikekreuzer.com", true },
  { "mikemooresales.com", true },
  { "mikerichards.photography", true },
  { "miketabor.com", true },
  { "miketheuer.com", true },
  { "mikevesch.com", true },
  { "mikewest.org", true },
  { "mikewillia.ms", true },
  { "mikewrites.online", true },
  { "mikeybailey.org", true },
  { "mikhirev.ru", true },
  { "miki.it", true },
  { "mikkelladegaard.dk", true },
  { "mikkelscheike.com", true },
  { "mikkelvej.dk", true },
  { "mikkonen.bio", true },
  { "miklcct.com", true },
  { "miknight.com", true },
  { "mikonmaa.fi", true },
  { "mikropixel.de", true },
  { "mikroskeem.eu", true },
  { "miku.ro", true },
  { "mikumaycry.com", true },
  { "mil-spec.ch", true },
  { "milahendri.com", true },
  { "milania.de", true },
  { "milanpala.cz", false },
  { "milanstephan.de", true },
  { "milcahsmusings.com", true },
  { "milchbuchstabe.de", true },
  { "mileme.com", true },
  { "milenaria.es", true },
  { "milesapart.dating", true },
  { "milfpornograph.com", true },
  { "milhoazul.com.br", true },
  { "militaryonesource.mil", true },
  { "milkameglepetes.hu", true },
  { "milkingit.co.uk", true },
  { "milkingit.net", true },
  { "milktea.info", true },
  { "milkypond.org", true },
  { "millanova.wedding", false },
  { "milldyke.com", true },
  { "milldyke.nl", true },
  { "millefleurs.eu", true },
  { "millennium-thisiswhoweare.net", true },
  { "millenniumstem.org", true },
  { "millenniumweb.com", false },
  { "millersminibarns.com", true },
  { "millettable.com", true },
  { "millhousenchurch.com", true },
  { "millionairegames.com", true },
  { "millionen-von-sonnen.de", true },
  { "millistream.com", true },
  { "milsonhypnotherapyservices.com", true },
  { "mim.am", true },
  { "mimavision.ddns.net", true },
  { "mimemo.io", true },
  { "mimemoriadepez.com", true },
  { "mimeo.digital", true },
  { "mimithedog.com", true },
  { "mimmog.it", true },
  { "mimocad.io", true },
  { "mimovrste.com", true },
  { "mimusic.cf", true },
  { "min-datorsupport.se", true },
  { "min-sky.no", true },
  { "minakov.pro", true },
  { "minami.xyz", true },
  { "minamo.io", true },
  { "minandolacorrupcion.mx", true },
  { "minapin.com", true },
  { "minaprine.com", true },
  { "mind-box.ch", true },
  { "mind-hochschul-netzwerk.de", true },
  { "mindatasupport.nu", true },
  { "mindatasupport.se", true },
  { "mindatorsupport.se", true },
  { "mindcoding.ro", true },
  { "mindfactory.de", true },
  { "mindhunter.info", true },
  { "mindleaking.org", true },
  { "mindmax.fi", true },
  { "mindmeister.com", true },
  { "mindofmedia.dk", true },
  { "mindoktor.se", false },
  { "mindorbs.com", true },
  { "mindox.com.br", true },
  { "mindstretchers.co.uk", true },
  { "mine-craftlife.com", true },
  { "mine-pixl.de", true },
  { "mine260309.me", false },
  { "minebier.dk", true },
  { "minecraft-forum.eu", true },
  { "minecraft-ok.ru", true },
  { "minecraft-server.eu", true },
  { "minecraftforum.de", true },
  { "minecraftforum.ovh", true },
  { "minecraftjson.com", false },
  { "minecraftstal.com", true },
  { "minehattan.de", true },
  { "minehub.de", true },
  { "minei.me", true },
  { "minenash.com", true },
  { "minepack.net", true },
  { "minepay.net", true },
  { "minepic.org", true },
  { "minepod.fr", true },
  { "minerstat.com", true },
  { "minerva2015.it", true },
  { "minesouls.fr", true },
  { "minetracker.dk", true },
  { "minez-nightswatch.com", false },
  { "minfin.gov.ua", true },
  { "mingky.net", true },
  { "mingkyaa.com", true },
  { "mingming.info", true },
  { "mingram.net", true },
  { "mingtreerealty.com", true },
  { "mingwah.ch", true },
  { "minh.at", false },
  { "minhyukpark.com", true },
  { "mini2.fi", true },
  { "miniaturepets.net", true },
  { "minican.net", true },
  { "minigames.com", true },
  { "miniglueck.net", true },
  { "minigolf-reisinger.com", true },
  { "minigolfandgames.co.uk", true },
  { "minikidz.es", true },
  { "minikneet.com", true },
  { "minilions.fr", true },
  { "minimal-apps.de", true },
  { "minimalistbaker.com", true },
  { "minimaltimer.com", true },
  { "minimayhemsoftplay.co.uk", true },
  { "minimbah.com.au", true },
  { "minimvc.com", true },
  { "mining.diamonds", true },
  { "miningtronics.com", false },
  { "minisoft4u.ir", true },
  { "ministeriumfuerinternet.de", true },
  { "minitruckin.net", true },
  { "minitrucktalk.com", true },
  { "miniverse.social", true },
  { "minkymoon.jp", true },
  { "minmaxgame.com", true },
  { "minnesotareadingcorps.org", true },
  { "minnit.chat", true },
  { "minorshadows.net", true },
  { "minpingvin.dk", true },
  { "minschuns.ch", true },
  { "mintclass.com", true },
  { "mintrak2.com", true },
  { "mintse.com", true },
  { "minu.link", true },
  { "minube.co.cr", true },
  { "minutashop.ru", true },
  { "minux.info", true },
  { "mio-ip.ch", true },
  { "mionerve.com", true },
  { "mionerve.org", true },
  { "mipapo.de", true },
  { "miproximopaso.org", true },
  { "mipueblohoy.com", true },
  { "mipymesenlinea.com", true },
  { "mir.pe", true },
  { "mirabalphoto.es", true },
  { "miraheze.org", true },
  { "miraidenshi.com", true },
  { "miraiex.com", false },
  { "miramar-obgyn.com", true },
  { "miramar.ca", true },
  { "mirazperu.com", true },
  { "mircarfinder.ru", true },
  { "mirch.com", true },
  { "mirco-grams.de", true },
  { "mireiaseuba.com", true },
  { "mirepublic.co.nz", true },
  { "mireservaonline.es", true },
  { "mirfire.com", true },
  { "mirjamderijk.nl", true },
  { "mirkofranz.de", true },
  { "miroctum.com", true },
  { "mironet.cz", true },
  { "mirrordream.net", true },
  { "mirrorsedgearchive.de", true },
  { "mirshak.com", true },
  { "mirtes.cz", true },
  { "mirtouf.fr", true },
  { "misakacloud.net", true },
  { "misakastudio.com", true },
  { "misakatang.cn", true },
  { "misakiya.co.jp", true },
  { "misanci.cz", true },
  { "mischak.net", true },
  { "misclick.nl", true },
  { "mishkan-israel.net", true },
  { "mishkovskyi.net", true },
  { "misini.fr", true },
  { "misinstrumentos.com", true },
  { "miskatonic.org", true },
  { "misoji-resist.com", true },
  { "misol.kr", true },
  { "misp-project.org", true },
  { "miss-inventory.co.uk", true },
  { "miss-platinum.net", true },
  { "miss.com.tw", true },
  { "missblisshair.com.au", true },
  { "missdream.org", true },
  { "misseguf.dk", true },
  { "missevent.pl", true },
  { "missguidedus.com", true },
  { "mission-orange.de", true },
  { "missionsgemeinde.de", true },
  { "missip.nl", true },
  { "missjoias.com.br", true },
  { "misskey.jp", true },
  { "misskey.xyz", true },
  { "missoy.me", true },
  { "misssex.de", true },
  { "missualready.com", true },
  { "missyou.link", true },
  { "mistacms.com", true },
  { "mistaken.pl", true },
  { "mister-matthew.de", true },
  { "misterseguros.com.br", true },
  { "mistinecn.com", true },
  { "mistreaded.com", true },
  { "mistybox.com", true },
  { "misupport.dk", true },
  { "misura.re", true },
  { "misuzu.moe", true },
  { "misxvenelantro.com", true },
  { "mit-dem-rad-zur-arbeit.de", true },
  { "mit-dem-rad-zur-uni.de", true },
  { "mit-uns.org", true },
  { "mitaines.ch", true },
  { "mitarbeitermotivation-anleitungen.de", true },
  { "mitchellhandymanservices.co.uk", true },
  { "mitchelmore.ca", true },
  { "mitdip-mit-group-ch.azurewebsites.net", true },
  { "miticobikes.com", true },
  { "mitigationcommission.gov", true },
  { "mitnetz-gas.de", true },
  { "mitnetz-strom.de", true },
  { "mitrax.com.br", true },
  { "mitre10.com.au", true },
  { "mitrecaasd.org", true },
  { "mitremai.org", true },
  { "mitrostudios.com", true },
  { "mitsonnenbrillen.de", true },
  { "mitsukabose.com", true },
  { "mittagonggardencentre.com.au", true },
  { "mittagonghomestead.com.au", true },
  { "mittbolan.se", true },
  { "mittelalter-lexikon.de", true },
  { "mittelunsachlich.de", true },
  { "mitylite.com", true },
  { "mitzpettel.com", true },
  { "miui-germany.de", true },
  { "mivestuariolaboral.com", true },
  { "mivzak.im", true },
  { "mivzakim.biz", true },
  { "mivzakim.cf", true },
  { "mivzakim.ga", true },
  { "mivzakim.gq", true },
  { "mivzakim.info", true },
  { "mivzakim.ml", true },
  { "mivzakim.mobi", true },
  { "mivzakim.net", true },
  { "mivzakim.org", true },
  { "mivzakim.tk", true },
  { "mivzakim.tv", true },
  { "miweb.cr", false },
  { "mixedrecipe.com", true },
  { "mixinglight.com", true },
  { "mixmister.com", true },
  { "mixposure.com", true },
  { "mixrepairs.co.uk", true },
  { "mixtafrica.com", true },
  { "mixx.com.hk", true },
  { "miyatore.com", true },
  { "miyoshi-kikaku.com", false },
  { "miyugirls.com", true },
  { "mizar.im", true },
  { "mizipack.com", true },
  { "mizque.ch", true },
  { "mizternational.com", true },
  { "mizu.coffee", true },
  { "mizucoffee.net", true },
  { "mizuho-trade.net", true },
  { "mizuhobank.co.id", true },
  { "mj420.com", true },
  { "mjacobson.net", true },
  { "mjanja.ch", true },
  { "mjasm.org", true },
  { "mjec.net", true },
  { "mjmedia.co.za", true },
  { "mjmnagy.info", true },
  { "mjpak.com.au", true },
  { "mjsacco-dwi.com", true },
  { "mjsacco.com", true },
  { "mjscustomcreations.com.au", true },
  { "mjt.me.uk", true },
  { "mk89.de", true },
  { "mkaciuba.com", false },
  { "mkakh.com", true },
  { "mkbouncycastles.co.uk", true },
  { "mkbouncyhire.co.uk", true },
  { "mkcert.org", true },
  { "mkchandler.com", true },
  { "mkd.mk", true },
  { "mkes.com", true },
  { "mkg-chirurgie-bruchsal.de", true },
  { "mkg-scherer.de", true },
  { "mkg-wiebelskirchen.de", true },
  { "mkhsoft.eu", true },
  { "mkimage.com", true },
  { "mkinteriores.com.br", true },
  { "mkjl.ml", true },
  { "mkk.de", true },
  { "mklpedia.de", true },
  { "mkoppmann.at", true },
  { "mkpef.org", true },
  { "mksac.co.uk", true },
  { "mksdarchitects.com", true },
  { "mkse.com", true },
  { "mkset.ru", true },
  { "mktdigital.info", true },
  { "mktemp.org", true },
  { "mktenlared.com", true },
  { "mkuznets.com", true },
  { "mkw.st", true },
  { "mlan-server.de", true },
  { "mlcnfriends.com", true },
  { "mlemay.com", true },
  { "mlmjam.com", true },
  { "mlp.ee", true },
  { "mlpvector.club", true },
  { "mlsha.cn", true },
  { "mlundberg.se", true },
  { "mlvbphotography.com", true },
  { "mlytics.com", true },
  { "mm-wife.com", true },
  { "mm13.at", true },
  { "mm5197.co", true },
  { "mm6729.co", true },
  { "mm6729.com", true },
  { "mm6957.co", true },
  { "mm9297.co", true },
  { "mm9397.com", true },
  { "mm9721.com", true },
  { "mm9728.co", true },
  { "mmalisz.com", true },
  { "mmaps.org", true },
  { "mmbb.org", true },
  { "mmgal.com", true },
  { "mmin.us", false },
  { "mmmarco.com", true },
  { "mmmm.mn", true },
  { "mmogah.com", true },
  { "mmonit.com", true },
  { "mmprojects.nl", true },
  { "mms.is", true },
  { "mmsmotor.com.hk", true },
  { "mmt.my", true },
  { "mmucha.de", true },
  { "mnciitbhu.me", true },
  { "mncloud.de", true },
  { "mnconsulting.xyz", true },
  { "mnd.sc", true },
  { "mne.moe", true },
  { "mneerup.dk", true },
  { "mnemonic.ninja", true },
  { "mneti.ru", true },
  { "mnguyen.io", true },
  { "mnienamel.com", true },
  { "mnium.de", true },
  { "mnml.art", true },
  { "mnml.jp", true },
  { "mnnknz.de", true },
  { "mns.co.jp", true },
  { "mns.jp", true },
  { "mnsure.org", true },
  { "mnt-tech.fr", true },
  { "mo-journal.com", true },
  { "mo.nl", true },
  { "mo2021.de", true },
  { "moa.moe", true },
  { "moabpapier.de", true },
  { "moabygg.se", true },
  { "moahmo.com", true },
  { "moarcookies.com", true },
  { "mobag.ru", true },
  { "mobal.com", true },
  { "mobasuite.com", true },
  { "mobi2go.com", true },
  { "mobifinans.ru", true },
  { "mobila-chisinau.md", true },
  { "mobilcom-debitel-empfehlen.de", true },
  { "mobilcom-debitel.de", true },
  { "mobile-holzofenpizza.de", true },
  { "mobile.united.com", false },
  { "mobile.usaa.com", false },
  { "mobile360.ph", true },
  { "mobilebingoclub.co.uk", true },
  { "mobilecasinoclub.co.uk", true },
  { "mobilecontractcomparison.com", true },
  { "mobilelooper.com", true },
  { "mobilemedics.com", true },
  { "mobileread.com", true },
  { "mobilesector.de", true },
  { "mobiletraff.co", true },
  { "mobiletry.com", true },
  { "mobilewikiserver.com", true },
  { "mobilinnov.it", true },
  { "mobilisation-generale.org", true },
  { "mobility-events.ch", true },
  { "mobilux.lv", true },
  { "mobio.net", true },
  { "mobiproj.com", true },
  { "mobisaar-cloud.de", true },
  { "mobius.network", true },
  { "mobizma.com", true },
  { "mobl.io", true },
  { "mobobe.com", true },
  { "mobsender.com", true },
  { "mobycoders.com", true },
  { "mobydog.net", true },
  { "moc.ac", true },
  { "mochanstore.com", false },
  { "mochizuki.moe", true },
  { "mockerel.com", true },
  { "mocking-bird.org", true },
  { "mococo.co.uk", true },
  { "modaexecutiva.com.br", true },
  { "modafinil.net", true },
  { "modafo.com", true },
  { "modalogi.com", true },
  { "modcasts.video", true },
  { "modcover.com", true },
  { "modding-forum.com", true },
  { "modding-welt.com", true },
  { "moddiy.com", true },
  { "mode-hautnah.de", true },
  { "mode-individuell.de", true },
  { "modelclub-draveil.eu", true },
  { "modelcube.com", true },
  { "modelemax.pl", true },
  { "modelisme-rc.net", true },
  { "modelisme-voiture-rc.fr", true },
  { "modellismo.roma.it", true },
  { "modelservis.cz", true },
  { "modemaille.com", true },
  { "modemchild.net", true },
  { "modeportaal.nl", true },
  { "moderatoren.org", true },
  { "modern-family.tv", true },
  { "moderncoinmart.com", true },
  { "moderncommercialrealestate.com", true },
  { "modifiedmind.com", true },
  { "modistry.com", true },
  { "modmountain.com", true },
  { "modonor.dk", true },
  { "modosaude.com.br", true },
  { "modscrew.com", true },
  { "modul21.com", true },
  { "modul21.eu", true },
  { "module.market", true },
  { "modulex-gmbh.de", true },
  { "moduloseltaladro.com", true },
  { "modusawperandi.com", true },
  { "moe-max.jp", true },
  { "moe.best", true },
  { "moebel-vergleichen.com", true },
  { "moechel.com", true },
  { "moecraft.net", true },
  { "moefactory.com", true },
  { "moegi.ml", true },
  { "moego.me", true },
  { "moehrke.cc", true },
  { "moekes.amsterdam", true },
  { "moeking.me", true },
  { "moeloli.cc", true },
  { "moeqing.net", true },
  { "moesif.com", true },
  { "moetrack.com", true },
  { "moeyun.net", true },
  { "mofidmed.com", true },
  { "mofohome.dyndns.org", true },
  { "moha-swiss.com", true },
  { "mohanmekap.com", true },
  { "mohela.com", true },
  { "mohitchahal.com", true },
  { "mohr-maschinenservice.de", true },
  { "moin.jp", true },
  { "moipourtoit.ch", true },
  { "moipourtoit.com", true },
  { "moipourtoit.org", true },
  { "moisesbarrio.es", true },
  { "mojaknjiznica.com", false },
  { "mojarada.nl", true },
  { "mojavenissanofbarstowparts.com", true },
  { "mojeco2.cz", true },
  { "mojefedora.cz", true },
  { "mojilitygroup.com", true },
  { "mojizuri.com", true },
  { "mojkragujevac.net", true },
  { "mojoco.co.za", true },
  { "mojomusic.org", true },
  { "mojt.net", true },
  { "mojzis.com", true },
  { "mojzis.cz", true },
  { "mojzisova.com", true },
  { "mok.pw", true },
  { "mokhtarmial.com", false },
  { "moki.org.pl", true },
  { "molb.org", true },
  { "mold.world", true },
  { "molecularbiosystems.org", true },
  { "moleskinestudio.com", true },
  { "molinero.xyz", true },
  { "mollaretsmeningitis.org", true },
  { "mollie.com", true },
  { "molokai.org", true },
  { "molpek.com", true },
  { "molti.hu", true },
  { "molun.net", true },
  { "molunerfinn.com", true },
  { "molwick.com", true },
  { "momentsofimpact.info", true },
  { "momentum.photos", true },
  { "momentumdash.com", true },
  { "momirfarooq.com", true },
  { "momjoyas.com", true },
  { "momo0v0.club", true },
  { "momove.nl", true },
  { "momozeit.de", true },
  { "momstableonline.com", true },
  { "momut.org", true },
  { "momy-genealogie.info", true },
  { "mon-partage.fr", true },
  { "mon-trafic.com", false },
  { "mon22.ch", true },
  { "mona-antenna.com", true },
  { "mona-dress.com", true },
  { "monachatdeco.com", true },
  { "monaco-automaten.de", true },
  { "monad.io", true },
  { "monakasatmasr.com", true },
  { "monalyse.com", true },
  { "monarchcleanersnc.com", true },
  { "monarcjuexpo.ch", true },
  { "monbudget.org", true },
  { "moncoach.ch", true },
  { "mondedie.fr", true },
  { "mondial-movers.nl", true },
  { "mondo-it.ch", true },
  { "monelephantapois.com", true },
  { "moneni.com", true },
  { "monerogamez.com", true },
  { "monetki.net", true },
  { "moneybird.com", true },
  { "moneybird.nl", true },
  { "moneychangersoftware.com", true },
  { "moneycredit.eu", true },
  { "moneygo.se", true },
  { "moneyhouse.de", true },
  { "moneypark.ch", true },
  { "moneytoday.se", true },
  { "mongolie.net", true },
  { "mongolieenfrance.fr", true },
  { "monicajean.photography", true },
  { "moniquedekermadec.com", true },
  { "moniquemunhoz.com.br", true },
  { "monitman.com", true },
  { "monitoring.kalisz.pl", true },
  { "monitzer.com", true },
  { "monix.io", true },
  { "monkay.de", true },
  { "monkeybusiness.agency", true },
  { "monkeyfaqs.com", true },
  { "monkeytek.ca", true },
  { "monlabs.com", true },
  { "monloyer.quebec", true },
  { "monnyonle.hu", true },
  { "mono.cafe", true },
  { "mono0x.net", true },
  { "monobank.no", true },
  { "monobunt.at", true },
  { "monodukuri.com", true },
  { "monolithapps.com", true },
  { "monolithindustries.com", true },
  { "monolithinteractive.com", true },
  { "mononom.com", true },
  { "monopoly-one.com", true },
  { "monospazzole.roma.it", true },
  { "monothesis.com", true },
  { "monoworks.co.jp", true },
  { "monpc-pro.fr", true },
  { "monpermismoto.com", true },
  { "monpermisvoiture.com", true },
  { "monpetitforfait.com", true },
  { "monpetitmobile.com", true },
  { "monplay.host", true },
  { "monsieurbureau.com", true },
  { "monsieursavon.ch", true },
  { "monsterandfox.co.uk", true },
  { "monstermashentertainments.co.uk", true },
  { "monsterx.cn", true },
  { "montack.de", true },
  { "montage-kaika.de", false },
  { "montagne-tendance.ch", true },
  { "montanasky.tv", true },
  { "montanteaesthetics.com", true },
  { "montanwerk.de", true },
  { "montarfotoaki.com", true },
  { "montas.io", true },
  { "montazer.net", true },
  { "montemanik.com", true },
  { "montessori.edu.vn", true },
  { "montgomeryfirm.com", true },
  { "montgomerysoccer.net", true },
  { "montopolis.com", true },
  { "montpreveyres.ch", true },
  { "montredeal.fr", true },
  { "montsaintaignan.fr", true },
  { "montychristie.com", true },
  { "monwarez.ovh", true },
  { "monzo.com", true },
  { "monzo.me", true },
  { "moo.la", true },
  { "moodfoods.com", true },
  { "moolah.rocks", true },
  { "moon.fish", true },
  { "moonagic.com", true },
  { "moonbench.xyz", true },
  { "moonbot.io", true },
  { "moonboys.de", true },
  { "moonchart.co.uk", true },
  { "moondrop.org", true },
  { "moonkin.eu", true },
  { "moonlabs.nl", true },
  { "moonmelo.com", true },
  { "moonraptor.co.uk", false },
  { "moonraptor.com", false },
  { "moonshyne.org", true },
  { "moontaj.com", true },
  { "moonue.com", true },
  { "moonvpn.org", true },
  { "moorewelliver.com", true },
  { "moorfunevents.co.uk", true },
  { "moorparkelectrical.com", true },
  { "moorparkelectrician.com", true },
  { "moorparkexteriorlighting.com", true },
  { "moorparklandscapelighting.com", true },
  { "moorparklighting.com", true },
  { "moorparkoutdoorlighting.com", true },
  { "mooselook.de", true },
  { "moosmann-moehrle.de", true },
  { "moot-info.co.za", true },
  { "moovablestorage.com", true },
  { "moparcraft.net", true },
  { "moparisthebest.com", true },
  { "moparisthebest.net", true },
  { "moparisthebest.org", true },
  { "moparscape.net", true },
  { "mopedpress.com", true },
  { "mopedreifen.de", false },
  { "mopie.de", true },
  { "mople71.cz", true },
  { "mopliangxing.com", true },
  { "moplx.com", true },
  { "moppeleinhorn.de", true },
  { "mopxing.com", true },
  { "mora.pl", true },
  { "morbatex.com", true },
  { "morbiceramicindustry.com", true },
  { "morbitzer.de", true },
  { "morbius.cz", true },
  { "morbotron.com", true },
  { "morchino.ch", true },
  { "morchstore.com", true },
  { "mordrum.com", true },
  { "more-hikkoshi.com", true },
  { "more-terrain.de", true },
  { "moreal.co", true },
  { "moreniche.com", true },
  { "morepablo.com", true },
  { "morepay.cn", true },
  { "moreserviceleads.com", true },
  { "moresw.com", true },
  { "morethanautodealers.com", true },
  { "morethancode.be", true },
  { "morethandigital.info", true },
  { "moretti.camp", true },
  { "morgan-insurance.com", true },
  { "morgansleisure.co.uk", true },
  { "moritz-baestlein.de", true },
  { "moritztremmel.de", true },
  { "moriz.de", true },
  { "moriz.net", true },
  { "mormon-colleges.com", true },
  { "mormonleaks.io", true },
  { "morningcurve.com", true },
  { "morningstar.moe", true },
  { "morris.computer", true },
  { "morrisby.com", true },
  { "morteruelo.net", true },
  { "mortgagecalculator.biz", true },
  { "mortis.eu", true },
  { "morvo.mx", true },
  { "mosaic-design.ru", true },
  { "mosaicadvisors.com", true },
  { "mosaicmarble.com", true },
  { "mosboutique.it", true },
  { "moscatalogue.net", true },
  { "moscow.dating", true },
  { "moseleyelectronics.com", true },
  { "moseracctg.com", true },
  { "mosfet.cz", true },
  { "mosin.org", true },
  { "moskeedieren.nl", true },
  { "mosquitojoe.com", true },
  { "mosscade.com", true },
  { "mostcomfortableworkboots.net", true },
  { "motd.ch", true },
  { "motd.today", true },
  { "motekforce.link", true },
  { "motekforcelink.com", true },
  { "motekforcelink.eu", true },
  { "motekforcelink.nl", true },
  { "motekmedical.com", true },
  { "motekmedical.eu", true },
  { "motekmedical.nl", true },
  { "moteksystems.com", true },
  { "motezazer.fr", true },
  { "mothereff.in", false },
  { "motifstudio.com.ua", true },
  { "motionless.nl", true },
  { "motionvideos.uk", true },
  { "motiweb.fr", true },
  { "motlife.net", true },
  { "motmplus.com", true },
  { "motoactionimola.it", true },
  { "motocollection.pl", true },
  { "motodb.co.uk", true },
  { "motodb.eu", true },
  { "motodb.net", true },
  { "motodb.uk", true },
  { "motogb.net", true },
  { "motohell.com", true },
  { "motojato.com.br", true },
  { "motonauticaibiza.com", true },
  { "motor-forum.nl", true },
  { "motor1.com", true },
  { "motoreflex.com", true },
  { "motorpointarenacardiff.co.uk", true },
  { "motorring.ru", true },
  { "motorsplus.com", false },
  { "motorsportdiesel.com", true },
  { "motoryachtclub-radolfzell.de", true },
  { "motosikletevi.com", true },
  { "motospaya.com", true },
  { "motostorie.blog", true },
  { "mototax.ch", true },
  { "motovio.de", true },
  { "motowilliams.com", true },
  { "motransportinfo.com", true },
  { "motstats.co.uk", true },
  { "mouche.fr", true },
  { "moucloud.cn", true },
  { "moulinaparoles.ca", true },
  { "mountain-rock.ru", true },
  { "mountainactivitysection.org.uk", true },
  { "mountainbatchers.de", true },
  { "mountainchalet.blue", true },
  { "mountainspringsrentals.ca", true },
  { "mousepotato.uk", true },
  { "moutiezhaller.com", true },
  { "movacare.de", true },
  { "move.mil", true },
  { "moveltix.net", true },
  { "movember.com", false },
  { "movewellapp.com", true },
  { "movewellnesslab.com", true },
  { "movfun.ga", true },
  { "movie-infos.net", true },
  { "movie1000.com", true },
  { "movie4kto.site", true },
  { "movie4kto.stream", true },
  { "moviefreeze.com", true },
  { "movieguys.org", true },
  { "moviesetc.net", true },
  { "moviko.nz", true },
  { "movil.uno", true },
  { "moviltronix.com", true },
  { "movimento-terra.it", true },
  { "movinglogistics.nl", false },
  { "movingtohttps.com", true },
  { "movingtojapan.life", true },
  { "movlib.org", true },
  { "moy.cat", true },
  { "moylen.eu", true },
  { "mozartgroup.hu", true },
  { "mozektevidi.net", true },
  { "mozilla-hispano.org", true },
  { "mozilla.cz", true },
  { "mozzez.de", true },
  { "mp3gratuiti.com", true },
  { "mpa-pro.fr", true },
  { "mpac.ca", false },
  { "mpc-hc.org", true },
  { "mpcompliance.com", true },
  { "mpetroff.net", true },
  { "mpg-universal.com", true },
  { "mpgaming.pro", true },
  { "mphwinkel.nl", true },
  { "mpkrachtig.nl", true },
  { "mplanetphl.fr", true },
  { "mplant.io", true },
  { "mplicka.cz", true },
  { "mplusm.eu", true },
  { "mprsco.eu", true },
  { "mpsgarage.com.au", true },
  { "mpsoundcraft.com", true },
  { "mpu-beratungsstellen.com", true },
  { "mpu-ibbi.de", true },
  { "mpu-vorbereitung.com", true },
  { "mpublicidad.com", true },
  { "mr-anderson.org", true },
  { "mr-wolf.nl", false },
  { "mralonas.ml", true },
  { "mrandmrsparrot.gr", true },
  { "mrbounce.com", true },
  { "mrbouncescrazycastles.co.uk", true },
  { "mrbouncycastle.com", true },
  { "mrbuckykat.com", true },
  { "mrca-sharp.com", true },
  { "mrcoolevents.com", true },
  { "mrcrowley217.com", true },
  { "mrd.ninja", true },
  { "mrdatenschutz.de", true },
  { "mrdayman.com", true },
  { "mremallin.ca", true },
  { "mrevolution.eu", true },
  { "mrhc.ru", true },
  { "mrhee.com", true },
  { "mrhookupsd.com", true },
  { "mrichard333.com", true },
  { "mrinalpurohit.in", true },
  { "mrjbanksy.com", true },
  { "mrjhnsn.com", true },
  { "mrjo.sh", true },
  { "mrjooz.com", true },
  { "mrkapowski.com", true },
  { "mrketolocksmith.com", true },
  { "mrknee.gr", true },
  { "mrkrabat.de", true },
  { "mrmad.com.tw", true },
  { "mrmanner.eu", true },
  { "mrnh.de", true },
  { "mrning.com", true },
  { "mrnordic.com", true },
  { "mrprintables.com", true },
  { "mrs-labo.jp", true },
  { "mrs-shop.com", true },
  { "mrsbairds.com", false },
  { "mrschristine.com", true },
  { "mrserge.lv", true },
  { "mrsk.me", true },
  { "mrstat.co.uk", true },
  { "mrstuudio.ee", true },
  { "mrtunnel.club", true },
  { "mruczek.ga", true },
  { "mrv.li", true },
  { "mrx.one", false },
  { "mrxn.net", true },
  { "ms-a.at", true },
  { "ms-ch.ch", true },
  { "ms-host.fr", true },
  { "msa-aesch.ch", true },
  { "mscc.mu", true },
  { "mscc.org", true },
  { "msch.pw", true },
  { "mschuessler.org", true },
  { "msebera.cz", true },
  { "msh100.uk", true },
  { "msi-zlin.cz", true },
  { "msiegmund.com", true },
  { "msize48.ch", true },
  { "msmails.de", true },
  { "msnr.net", true },
  { "mspsocial.net", true },
  { "msquadrat.de", true },
  { "msroot.de", true },
  { "mssora.com", true },
  { "mssys.de", true },
  { "mstdn.blue", true },
  { "mstdn.club", true },
  { "mstdn.io", true },
  { "mstdn.onl", false },
  { "mstdn.vodka", false },
  { "msuna.net", true },
  { "msx.org", true },
  { "mszavodumiru.cz", true },
  { "mt-bank.jp", true },
  { "mt.search.yahoo.com", false },
  { "mt1016.com", true },
  { "mt2414.com", true },
  { "mt4programming.com", true },
  { "mta.fail", true },
  { "mta.org.ua", true },
  { "mtane0412.com", true },
  { "mtasa.com", true },
  { "mtasa.hu", true },
  { "mtauburnassociates.com", true },
  { "mtb.wtf", true },
  { "mtd.org", true },
  { "mte.sk", true },
  { "mtechprecisioninc.com", true },
  { "mteleport.net", true },
  { "mtgeni.us", true },
  { "mtgenius.com", true },
  { "mtgsuomi.fi", true },
  { "mthode.org", true },
  { "mthrbrd.com", true },
  { "mthrbrd.net", true },
  { "mths.be", false },
  { "mticareportal.com", true },
  { "mtiryaki.com", true },
  { "mtjholding.ee", true },
  { "mtlconcerts.com", true },
  { "mtltransport.com", true },
  { "mtludlow.co.uk", true },
  { "mtouch.facebook.com", false },
  { "mtravelers.net", true },
  { "mtrip.com", true },
  { "mtrock.ru", true },
  { "mts-energia.eu", true },
  { "mts-server.com", true },
  { "mtsolar.es", true },
  { "mu.search.yahoo.com", false },
  { "muabannhanh.com", false },
  { "mubase.dk", true },
  { "mubiflex.nl", true },
  { "muchohentai.com", true },
  { "muckingabout.eu", true },
  { "muckrack.com", true },
  { "mucmail.de", true },
  { "muctool.de", true },
  { "mudanzasacuna.com.co", true },
  { "mudbenesov.cz", true },
  { "mudcrab.us", false },
  { "mudit.xyz", true },
  { "muehlemann.net", true },
  { "muelhau.pt", true },
  { "muell-weg.de", true },
  { "muellapp.com", true },
  { "mueller-gaestehaus.de", true },
  { "muenchberger.com", true },
  { "muffs.ru", true },
  { "mufibot.net", true },
  { "mugen.technology", true },
  { "muguayuan.com", true },
  { "muh.io", true },
  { "muhcow.dk", true },
  { "mui.jp", true },
  { "muilties.com", true },
  { "muitadica.com", true },
  { "muitoalemdobolo.com.br", true },
  { "mujerfutura.com", true },
  { "muk-kobetsu.com", true },
  { "mukilteodentalarts.com", true },
  { "mukilteoeuropeanautorepair.com", true },
  { "mulaccosmetics.com", true },
  { "mulaisehat.com", true },
  { "mulej.net", true },
  { "mulheres18.com", true },
  { "muling.lu", true },
  { "mulk.hopto.org", true },
  { "mullens-usedcars.be", true },
  { "mullerimoveisrj.com.br", true },
  { "multi-vpn.biz", true },
  { "multibit.org", true },
  { "multibomasm.com.br", true },
  { "multiclinicacardio.com.br", true },
  { "multicomhost.com", true },
  { "multigamecard.com", true },
  { "multigeist.de", true },
  { "multikalender.de", false },
  { "multimail.work", true },
  { "multimatte.com", false },
  { "multimed-solutions.com", true },
  { "multimed.krakow.pl", true },
  { "multimedia-pool.com", true },
  { "multimediapc.de", true },
  { "multiplayernow.com", true },
  { "multipleservers.com", true },
  { "multirep.ch", true },
  { "multiroom-streaming.de", true },
  { "multisite.ovh", true },
  { "multitec.nl", true },
  { "multitek.no", true },
  { "multitenantlaravel.com", true },
  { "multiterm.org", true },
  { "multitheftauto.com", true },
  { "multixa.net", true },
  { "multrier.fr", true },
  { "mum.ceo", true },
  { "muma.ml", true },
  { "mumakil.fi", false },
  { "mumbaionlinegifts.com", true },
  { "muminkoykiran.com", true },
  { "mumolabs.com", true },
  { "munch.me", true },
  { "munchcorp.com", true },
  { "mundismart.com", true },
  { "mundoarabe.com.br", true },
  { "mundoconejos.com", true },
  { "mundodapoesia.com", true },
  { "mundodasmensagens.com", true },
  { "mundokinderland.com.br", true },
  { "mundolarraz.es", true },
  { "mundomagicotv.com", true },
  { "mundoperros.es", true },
  { "mundotortugas.com", true },
  { "mundschenk.at", true },
  { "mundtec.com.br", true },
  { "munduch.cz", true },
  { "munduch.eu", true },
  { "munki.org", true },
  { "munkibuilds.org", true },
  { "munwr.com", true },
  { "muqu.co", true },
  { "mur-vegetal-interieur.fr", true },
  { "murakami-sah.com", true },
  { "murashun.jp", true },
  { "muratore-roma.it", true },
  { "murfy.nz", true },
  { "murmel.it", false },
  { "murof.com.br", true },
  { "murray.xyz", true },
  { "murraya.cn", true },
  { "musa.gallery", true },
  { "muscle-tg.com", true },
  { "muscleangels.com", true },
  { "musclecarresearch.com", true },
  { "muscolinomusic.com", true },
  { "museclef.com", true },
  { "musehelix.com", true },
  { "muserver.io", true },
  { "muses-success.info", true },
  { "musettishop.com", true },
  { "mush-room.co.jp", true },
  { "mushfiqweb.com", true },
  { "mushikabu.net", true },
  { "music-is-my-life.de", true },
  { "music-project.eu", true },
  { "music-world.pl", true },
  { "music.amazon.com", true },
  { "musica.com", true },
  { "musicalive.nl", true },
  { "musicall.com", true },
  { "musicalschwarzenburg.ch", true },
  { "musicalsoulfood.com", true },
  { "musicapara.net", true },
  { "musicasbr.com.br", true },
  { "musicchris.de", true },
  { "musicdemons.com", true },
  { "musicfromgod.com", true },
  { "musicgamegalaxy.de", true },
  { "musician.dating", true },
  { "musicindustrydb.org", true },
  { "musickhouseleveling.com", true },
  { "musicompare.com", true },
  { "musicschoolonline.com", true },
  { "musicstudio.pro", true },
  { "musicwear.cz", true },
  { "musicworkout.de", true },
  { "musiikkiohjelmapalvelu.fi", true },
  { "musik-mentaltraining.ch", true },
  { "musikholics.com", true },
  { "musiktag2020.ch", true },
  { "musikverein-elten.de", true },
  { "musikzentrale.net", true },
  { "musketonhaken.nl", false },
  { "muslim.singles", true },
  { "musmann.io", true },
  { "muspla.com", true },
  { "muspla.com.br", true },
  { "mussalains.com", true },
  { "musta.ch", true },
  { "mustafaturhan.com", false },
  { "mustard.co.uk", true },
  { "mustardking.me", true },
  { "mustasj.no", true },
  { "mustat.com", true },
  { "muster-folien.de", true },
  { "muster-schablonen.de", true },
  { "mustertexte-musterbewerbung.de", true },
  { "musthavesforreal.com", true },
  { "muszic.co", true },
  { "muthai.in.th", true },
  { "mutuelle.fr", true },
  { "muunnin.net", true },
  { "muurlingoogzorg.nl", true },
  { "muwatenraqamy.org", true },
  { "muy.ooo", true },
  { "muz2u.ru", true },
  { "muzeumkomiksu.eu", true },
  { "muzhijy.com", true },
  { "muzikantine.nl", true },
  { "muzykanawesele.info", true },
  { "mv-schnuppertage.de", true },
  { "mvandek.nl", true },
  { "mvbits.com", true },
  { "mvisioncorp.com", true },
  { "mvistatic.com", true },
  { "mvno.io", true },
  { "mvp-stars.com", true },
  { "mvwoensei.com", true },
  { "mvwoensel.com", true },
  { "mw.search.yahoo.com", false },
  { "mwainc.org", true },
  { "mwamitours.com", true },
  { "mware-staging.azurewebsites.net", true },
  { "mwavuli.co.ke", true },
  { "mwba.org", true },
  { "mwe.st", true },
  { "mwezi-foundation.org", true },
  { "mwezi.org", true },
  { "mwlcouriers.com", true },
  { "mwtdev.se", true },
  { "mww.moe", true },
  { "mx-quad.fr", true },
  { "mx.org.ua", true },
  { "mx.search.yahoo.com", false },
  { "mx5international.com", true },
  { "mxdvl.com", true },
  { "mxihan.xyz", true },
  { "my-aftershave-store.co.uk", true },
  { "my-best-wishes.com", true },
  { "my-contract.ch", true },
  { "my-contract.info", true },
  { "my-contract.net", true },
  { "my-ebook.es", true },
  { "my-floor.com", true },
  { "my-gode.fr", true },
  { "my-host.ovh", true },
  { "my-hps.de", false },
  { "my-ip.work", true },
  { "my-new-bikini.de", true },
  { "my-nextcloud.at", true },
  { "my-stuff-online.com", true },
  { "my-webcloud.at", true },
  { "my.onlime.ch", false },
  { "my.usa.gov", false },
  { "my.xero.com", false },
  { "my4g.net", true },
  { "my4thtelco.com.sg", true },
  { "my4thtelco.sg", true },
  { "myabcm.com", true },
  { "myaccount.google.com", false },
  { "myactivity.google.com", false },
  { "myadpost.com", true },
  { "myadself.com", true },
  { "myaggic.com", true },
  { "myalliancechurch.com", true },
  { "myamend.com", true },
  { "myamihealth.com", true },
  { "myamity.info", true },
  { "myammo.ru", true },
  { "myanimelist.net", true },
  { "myapexcard.com", true },
  { "mybagofcoffee.com", true },
  { "mybakkupakku.com", true },
  { "mybasementdoctor.com", true },
  { "mybb.com", true },
  { "mybb.de", true },
  { "mybicc.org", true },
  { "mybloggedlife.com", true },
  { "mybodylife.com", true },
  { "mybon.at", false },
  { "mybonfire.com", true },
  { "myboothang.com", true },
  { "mybus.ro", true },
  { "mybusiness.wien", true },
  { "mycaelis.fr", true },
  { "mycamshowhub.com", true },
  { "mycamshowhub.to", true },
  { "mycard.moe", true },
  { "mycareersfuture.sg", true },
  { "mycc.be", true },
  { "mycieokien.info", false },
  { "mycinema.pro", true },
  { "mycircleworks.com", true },
  { "myclasscam.com", true },
  { "myclasscam.org", true },
  { "myclgnotes.com", true },
  { "myclinicalstudybuddy.com", true },
  { "mycloud-system.com", true },
  { "mycofairtrade.com", true },
  { "myconan.net", true },
  { "myconan.tk", true },
  { "myconf.com", true },
  { "myconf.uk", true },
  { "myconnect.cn", true },
  { "myconsulting.ch", true },
  { "mycookrecetas.com", true },
  { "mycoupons.com", true },
  { "mycp668.com", true },
  { "mycr.eu", true },
  { "mycreativenook.com", true },
  { "mycreditcardcenter.com", true },
  { "mycreditunion.gov", true },
  { "mycrypnet.io", true },
  { "mycrypto.com", false },
  { "mycrystalgrove.com", true },
  { "mycustomwriting.com", true },
  { "mydais.org", true },
  { "mydarkstar.net", true },
  { "mydatadoneright.eu", true },
  { "mydaywebapp.com", true },
  { "mydebian.in.ua", true },
  { "mydentalplan.gr", true },
  { "mydevolo.com", true },
  { "mydevolo.de", true },
  { "mydigitalweek.com", true },
  { "mydna.bio", true },
  { "mydnshost.co.uk", true },
  { "mydoc.fr", true },
  { "mydocserve.com", true },
  { "mydomaindesk.com", true },
  { "mydroneservices.ca", true },
  { "mydroneservices.com", true },
  { "mydsacontabilidad.com", true },
  { "myduffyfamily.com", true },
  { "myeasybooking.de", true },
  { "myeberspaecher.com", true },
  { "myedumundo.com", true },
  { "myeisenbahn.de", true },
  { "myessaygeek.com", true },
  { "myetherwallet.com", true },
  { "myf.cloud", true },
  { "myfae.eu", true },
  { "myfantasysportstalk.com", true },
  { "myfedloan.org", true },
  { "myfirenet.com", true },
  { "myfloridadeferredcomp.com", true },
  { "myforfaitmobile.com", true },
  { "myfreemp3.click", true },
  { "myfrenchtattoo.fr", true },
  { "myg21.com", true },
  { "mygadgetguardian.lookout.com", false },
  { "mygallery.homelinux.net", true },
  { "mygate.at", false },
  { "mygedit.com", true },
  { "mygeneral.org", true },
  { "mygeotrip.com", true },
  { "mygest.me", true },
  { "mygigabitnation.com", true },
  { "mygignation.com", true },
  { "mygirlfriendshouse.com", true },
  { "mygnmr.com", true },
  { "mygoldennetwork.com", true },
  { "mygreatlakes.org", true },
  { "mygretchen.de", true },
  { "mygrotto.org", true },
  { "mygymer.ch", true },
  { "myhatsuden.jp", true },
  { "myhealthreviews.com", true },
  { "myhmz.bid", true },
  { "myhollywoodnews.com", true },
  { "myhome-24.pl", true },
  { "myhuthwaite.com", true },
  { "myibidder.com", true },
  { "myimds.com", true },
  { "myimmitracker.com", true },
  { "myinvite.nl", true },
  { "myipaddr.de", true },
  { "myipv4.de", true },
  { "myjudo.net", true },
  { "myjumparoo.co.uk", true },
  { "myjumpsuit.de", true },
  { "myjuvelirika.ru", true },
  { "myki.co", true },
  { "mykontool.de", true },
  { "mykumedir.com", true },
  { "mylatestnews.org", true },
  { "mylawyer.be", true },
  { "myleanfactory.de", true },
  { "mylife360mag.com", true },
  { "mylifeabundant.com", true },
  { "mylittlechat.ru", true },
  { "myliveupdates.com", true },
  { "myloan.hk", true },
  { "myloneworkers.com", true },
  { "mylookout.com", false },
  { "mylotto.co.nz", true },
  { "mylstrom.com", true },
  { "mylucknursinghome.com", true },
  { "mymadina.com", true },
  { "mymall.co.jp", true },
  { "mymarketingcourses.com", true },
  { "mymb.pm", true },
  { "mymedz.nl", true },
  { "mymixtapez.com", true },
  { "mymommyworld.com", true },
  { "mymonture.com", true },
  { "mymotor.nl", true },
  { "mymun.com", true },
  { "mymun.net", true },
  { "mymx.lu", true },
  { "myna.go.jp", true },
  { "mynameistavis.com", true },
  { "myndcoin.com", true },
  { "myndcoins.com", true },
  { "mynext.events", true },
  { "mynextmove.org", true },
  { "mynn.io", true },
  { "mynook.info", false },
  { "myonline.hu", true },
  { "myonline.store", true },
  { "myopd.in", true },
  { "myoptumhealthcomplexmedical.com", true },
  { "myoptumhealthparentsteps.com", true },
  { "myotopie.de", true },
  { "myoueb.fr", true },
  { "myoukochou.com", true },
  { "myownconference.cloud", true },
  { "myownconference.com", true },
  { "myownconference.com.ua", true },
  { "myownconference.net", true },
  { "myownconference.pl", true },
  { "myownconference.ru", true },
  { "myowndisk.com", true },
  { "myowndisk.net", true },
  { "mypaperdone.com", true },
  { "mypaperwriter.com", true },
  { "myparisiankitchen.com", true },
  { "mypartnernews.com", true },
  { "mypartybynoelia.es", true },
  { "mypay.fr", true },
  { "mypayoffloan.com", true },
  { "myperfecthome.ca", true },
  { "myperks.in", true },
  { "myphamaplus.org", true },
  { "myphotoshopbrushes.com", true },
  { "mypillcard.com", true },
  { "mypizza-bremen.de", true },
  { "myplaceonline.com", true },
  { "mypnu.net", true },
  { "mypress.mx", true },
  { "myprintcard.de", true },
  { "myproblog.com", true },
  { "myprotime.eu", true },
  { "myrandomtips.com", true },
  { "myraytech.net", false },
  { "myrealestatemate.com.au", true },
  { "myrealestateschool.com", true },
  { "myred.net", true },
  { "myref.net", true },
  { "myrekber.co.id", true },
  { "myrent.quebec", true },
  { "myrepubic.net", true },
  { "myrepubiic.net", true },
  { "myrepublc.net", true },
  { "myrepublic.asia", true },
  { "myrepublic.cf", true },
  { "myrepublic.cloud", true },
  { "myrepublic.co.id", true },
  { "myrepublic.com.cn", true },
  { "myrepublic.com.hk", true },
  { "myrepublic.com.kh", true },
  { "myrepublic.com.lk", true },
  { "myrepublic.com.my", true },
  { "myrepublic.com.ph", true },
  { "myrepublic.com.tw", true },
  { "myrepublic.eu.com", true },
  { "myrepublic.ga", true },
  { "myrepublic.gq", true },
  { "myrepublic.icu", true },
  { "myrepublic.id", true },
  { "myrepublic.in", true },
  { "myrepublic.limited", true },
  { "myrepublic.lk", true },
  { "myrepublic.ml", true },
  { "myrepublic.mobi", true },
  { "myrepublic.my", true },
  { "myrepublic.net", true },
  { "myrepublic.net.au", true },
  { "myrepublic.nz", true },
  { "myrepublic.ph", true },
  { "myrepublic.rocks", true },
  { "myrepublic.run", true },
  { "myrepublic.tk", true },
  { "myrepublic.tv", true },
  { "myrepublic.tw", true },
  { "myrepublic.us.com", true },
  { "myrepublic.xyz", true },
  { "myrepublicau.com", true },
  { "myrepublicaus.com", true },
  { "myrepublicbroadband.com.au", true },
  { "myrepublicfibre.com.au", true },
  { "myrepublicgroup.com", true },
  { "myrepublicinternet.com.au", true },
  { "myrepublicltd.com", true },
  { "myrepublicmy.com", true },
  { "myrepublicnz.com", true },
  { "myrepublicsg.com", true },
  { "myrepublictelecom.com", true },
  { "myrepubllc.net", true },
  { "myresearchapp.com", true },
  { "myrevery.com", true },
  { "myrewardspoints.com", true },
  { "myriadof.com", true },
  { "myrig.com", true },
  { "myrnabiondo.com.br", true },
  { "myrotvorets.center", true },
  { "myrotvorets.news", true },
  { "myrp.co", true },
  { "mysad.de", true },
  { "mysber.ru", true },
  { "myschoolphoto.org", true },
  { "myseatime.com", true },
  { "mysecretcase.com", true },
  { "myself5.de", true },
  { "myservicearl.com", true },
  { "mysexydate24.com", true },
  { "mysignal.com", true },
  { "mysmelly.com", true },
  { "mysockfactory.ch", true },
  { "mysockfactory.com", true },
  { "mysocrat.com", true },
  { "mysoundtalks.com", false },
  { "myspicer.com", true },
  { "mysqldump-secure.org", true },
  { "myssl.com", true },
  { "mystaffonline.com", true },
  { "mystagic.cloud", true },
  { "mysteriouscode.io", true },
  { "mysterydata.com", true },
  { "mysterymind.ch", true },
  { "mysteryshow.site", true },
  { "mystia.org", true },
  { "mystic-welten.de", true },
  { "mysticconsult.com", true },
  { "mystickphysick.com", true },
  { "mysticrs.tk", true },
  { "mystorymonster.com", true },
  { "mystudy.me", true },
  { "mystudycart.com", true },
  { "myswissmailaddress.com", true },
  { "myte.ch", true },
  { "mytfg.de", true },
  { "mythemeshop.com", false },
  { "mythicdelirium.com", true },
  { "mytime.fr", true },
  { "mytime.gl", true },
  { "myting.net", true },
  { "mytntware.com", true },
  { "mytraiteurs.com", true },
  { "mytripcar.co.uk", true },
  { "mytripcar.com", true },
  { "mytripcar.de", true },
  { "mytripcar.es", true },
  { "mytripcar.fr", true },
  { "mytruecare.org", true },
  { "mytrustadviser.com", true },
  { "mytty.net", true },
  { "mytuleap.com", false },
  { "mytun.com", true },
  { "myulog.net", true },
  { "myunox.com", true },
  { "myupdatestar.com", true },
  { "myupdatestudio.com", true },
  { "myupdatesystems.com", true },
  { "myusagepayments.com", true },
  { "myvacompany.com", true },
  { "myvalleymarketing.com", true },
  { "myvegan.menu", true },
  { "myvirtualserver.com", true },
  { "myvitalhealthsolutions.com.au", true },
  { "mywari.com", true },
  { "mywebpanel.eu", true },
  { "mywebpanel.nl", true },
  { "myweddingaway.co.uk", true },
  { "myweddingreceptionideas.com", true },
  { "mywetpussycams.com", true },
  { "mywiwe.com.au", true },
  { "mywomenshealthgroup.com", true },
  { "myworkinfo.com", false },
  { "myworth.com.au", true },
  { "myxnr.com", true },
  { "myyubikey.net", true },
  { "myyubikey.org", true },
  { "myzhili.com", true },
  { "myzina.cz", false },
  { "mz-mz.net", true },
  { "mza.com", true },
  { "mzcsgo.top", true },
  { "mzh.io", true },
  { "mziulu.me", false },
  { "mzlive.eu", true },
  { "mzmtech.com", true },
  { "mznet.de", true },
  { "mzorn.photography", true },
  { "mzstatic.cc", true },
  { "mzzj.de", true },
  { "n-a.date", true },
  { "n-design.de", true },
  { "n-linear.org", true },
  { "n-m.lu", true },
  { "n-man.info", true },
  { "n-pix.com", false },
  { "n-soft.info", true },
  { "n-un.de", false },
  { "n0paste.tk", false },
  { "n0psled.nl", true },
  { "n26.com", true },
  { "n2diving.net", true },
  { "n2servers.com", true },
  { "n4v.eu", true },
  { "n5197.co", true },
  { "n6729.co", true },
  { "n6729.com", true },
  { "n6957.co", true },
  { "n6a.net", true },
  { "n7.education", true },
  { "n8ch.net", true },
  { "n8mgt.com", true },
  { "n8nvi.com", true },
  { "n8solutions.net", true },
  { "n8solutions.us", true },
  { "n8ta.com", true },
  { "n9297.co", true },
  { "n9397.com", true },
  { "n9721.com", true },
  { "n9728.co", true },
  { "na-school.nl", true },
  { "naahgluck.de", true },
  { "nabaleka.com", true },
  { "nabankco.com", true },
  { "nabbar.com", true },
  { "nabidkamajetku.cz", true },
  { "nabidkydnes.cz", true },
  { "nabytek-valmo.cz", true },
  { "nac-6.fr", true },
  { "nacfit.com", true },
  { "nachsendeauftrag.net", true },
  { "nachsenden.info", true },
  { "nachtmuziek.info", true },
  { "nacin.com", true },
  { "nacktetatsachen.at", false },
  { "nacyklo.cz", true },
  { "nadaquenosepas.com", true },
  { "nadejeproninu.cz", true },
  { "nadelholzkulturen.de", true },
  { "naders.com", true },
  { "nadiafourcade-photographie.fr", true },
  { "nadine-birkner.de", true },
  { "nadine-chaudier.net", true },
  { "nadji.ga", true },
  { "nadsandgams.com", true },
  { "nadyaolcer.fr", true },
  { "nafod.net", true },
  { "naga-semi.com", true },
  { "naga.im", true },
  { "naganithin.me", true },
  { "nagashi.ma", false },
  { "nagaya.biz", true },
  { "nagel-dentaltechnik.de", true },
  { "nagelfam.com", true },
  { "nah.nz", true },
  { "nah.re", true },
  { "nai-job.jp", true },
  { "naijaxnet.com.ng", true },
  { "nailattitude.ch", true },
  { "nailchiodo.com", true },
  { "nailsalon-aztplus.com", true },
  { "nailsart.roma.it", true },
  { "nailtodayminneapolis.com", true },
  { "nairobibusinessreview.com", true },
  { "naivetube.com", false },
  { "najany.de", true },
  { "najany.dk", true },
  { "najany.fr", true },
  { "najany.nl", true },
  { "najany.se", true },
  { "najedlo.sk", true },
  { "naji-astier.com", true },
  { "naka.io", true },
  { "nakalabo.jp", true },
  { "nakama.tv", true },
  { "nakandya.com", true },
  { "nakayama.industries", true },
  { "nakayama.systems", true },
  { "nakayamaresearch.com", true },
  { "nakedalarmclock.me", true },
  { "nakedtruthbeauty.com", true },
  { "nakene.com", true },
  { "nakladki.su", true },
  { "nakliyat.name.tr", true },
  { "nakliyatsirketi.biz.tr", true },
  { "nakluky.cz", true },
  { "nako.no", true },
  { "nalenders.com", true },
  { "nalepky-na-zed.cz", true },
  { "nalepte.cz", true },
  { "nalexandru.xyz", true },
  { "nalsai.de", true },
  { "namaanakperempuan.net", true },
  { "namaleaks.com", false },
  { "namalelaki.com", true },
  { "namaperempuan.com", true },
  { "namazvakitleri.com.tr", true },
  { "namegrep.com", true },
  { "nameid.org", true },
  { "namepros.com", true },
  { "nameproscdn.com", true },
  { "namereel.com", true },
  { "namethatporn.com", true },
  { "nametiles.co", true },
  { "nami.trade", true },
  { "naminam.de", true },
  { "namrs.net", true },
  { "namskra.is", true },
  { "namu.games", true },
  { "namu.la", true },
  { "namu.live", true },
  { "namu.moe", true },
  { "namu.news", true },
  { "namu.wiki", true },
  { "namus.gov", true },
  { "nan.ci", true },
  { "nan.ge", true },
  { "nan0.cloud", true },
  { "nanarose.ch", true },
  { "nanch.com", true },
  { "nancytelford.com", true },
  { "nandex.org", true },
  { "nange.cn", true },
  { "nanisiyou.com", true },
  { "nankiseamansclub.com", true },
  { "nannytax.ca", true },
  { "nano.voting", true },
  { "nanogi.ga", true },
  { "nanogramme.fr", false },
  { "nanopixel.ch", true },
  { "nanotechnologist.com", true },
  { "nanotechnologysolutions.com.au", true },
  { "nanotechtorsion.com", true },
  { "nanowallet.io", true },
  { "nanpuyue.com", true },
  { "nansa.ch", true },
  { "nanubo.com", true },
  { "nanubo.de", true },
  { "naomi.es", false },
  { "naomiheji.com", true },
  { "napcae.de", true },
  { "napisdata.us", true },
  { "napkins-wholesale.co.za", true },
  { "napkins-wholesale.com", true },
  { "napkins-wholesale.in", true },
  { "napkins-wholesale.nz", true },
  { "napkins-wholesale.uk", true },
  { "napkins-wholesale.us", true },
  { "naplata.mk", true },
  { "nappynko.com", true },
  { "naradiebosch.sk", true },
  { "naradiehusqvarna.sk", true },
  { "naradiemakita.sk", true },
  { "narakenkoland.net", true },
  { "naralogics.com", true },
  { "narardetval.se", true },
  { "narazaka.net", true },
  { "narfation.org", true },
  { "nargele.eu", true },
  { "nargileh.nl", true },
  { "naric.com", true },
  { "narindal.ch", true },
  { "naro.se", true },
  { "narodniki.com", true },
  { "naroska.name", true },
  { "narrativasdigitais.pt", true },
  { "narrative.network", true },
  { "narrative.org", true },
  { "narrenverein-wolkenschieber.de", true },
  { "narthollis.net", false },
  { "nasbi.pl", true },
  { "nasbnation.com", false },
  { "naseehah.ga", true },
  { "nashdistribution.com", true },
  { "nashikmatka.com", false },
  { "nashira.cz", true },
  { "nashuaradiology.com", true },
  { "nashvillebasements.com", true },
  { "nashvillelidsurgery.com", true },
  { "nashzhou.me", true },
  { "nasr.mobi", true },
  { "nasrsolar.com", true },
  { "nasserver-test.de", true },
  { "nastoletni.pl", true },
  { "nataldigital.com", true },
  { "nataliedawnhanson.com", true },
  { "natation-nsh.com", false },
  { "natchmatch.com", true },
  { "nateandxtina.wedding", true },
  { "natecraun.net", false },
  { "natehobi.com", true },
  { "natenom.com", true },
  { "natenom.de", true },
  { "natenom.name", true },
  { "natevolker.com", true },
  { "natgeofreshwater.com", true },
  { "nathaliebaron.ch", true },
  { "nathaliebaroncoaching.ch", true },
  { "nathaliedijkxhoorn.com", true },
  { "nathaliedijkxhoorn.nl", true },
  { "nathanaeldawe.com", true },
  { "nathancheek.com", false },
  { "nathanmfarrugia.com", true },
  { "nathansmetana.com", true },
  { "nation-contracting.com.hk", true },
  { "nationalbank.gov", true },
  { "nationalbanknet.gov", true },
  { "nationalcentereg.org", true },
  { "nationalcprfoundation.com", true },
  { "nationalcrimecheck.com.au", true },
  { "nationalhomequotes.com", true },
  { "nationalmap.gov", true },
  { "nationalpassportservice.info", true },
  { "nationalpriorities.org", true },
  { "nationalresourcedirectory.gov", true },
  { "nationalservice.gov", true },
  { "nationaltrails.ru", true },
  { "natives-team.ch", true },
  { "nativitynj.org", true },
  { "nativs.ch", true },
  { "natlec.com", true },
  { "natropie.pl", true },
  { "natsumihoshino.com", true },
  { "nattiam.com", true },
  { "natuerlichabnehmen.ch", true },
  { "natur.com", true },
  { "natura-sense.com", true },
  { "naturalezafengshui.com", true },
  { "naturalfit.co.uk", true },
  { "naturalhealthcures.net", true },
  { "naturalkitchen.co.uk", true },
  { "naturalspacesdomes.com", true },
  { "naturaum.de", true },
  { "nature-et-bio.fr", true },
  { "natureclaim.com", true },
  { "natureflo.net", true },
  { "naturesbest.co.uk", true },
  { "naturesorganichaven.com", true },
  { "natureword.com", true },
  { "naturheilpraxis-oida.de", true },
  { "naturheilpraxis-p-grote.de", true },
  { "naturline.com", true },
  { "naturtint.co.uk", true },
  { "natusvita.com.br", true },
  { "natverkstekniker.se", true },
  { "naude.co", true },
  { "naughty.audio", true },
  { "nauris.fi", true },
  { "nausicaahotel.it", true },
  { "naut.ca", true },
  { "nautiljon.com", true },
  { "nautsch.de", true },
  { "navarralanparty.org", true },
  { "navdeep.ca", true },
  { "navienna.com", true },
  { "navient.com", true },
  { "navigator.ca", true },
  { "navitime.me", true },
  { "navstevnik.sk", true },
  { "navycs.com", true },
  { "nawir.de", true },
  { "nayahe.ru", true },
  { "nayami64.xyz", true },
  { "nayanaas.com", true },
  { "nayr.us", true },
  { "nazevfirmy.cz", true },
  { "nazimogluinsaat.com", true },
  { "nazukebanashi.com", true },
  { "nazuna.blue", true },
  { "nb.zone", true },
  { "nb01.com", true },
  { "nb6.de", true },
  { "nba-2k.com", true },
  { "nba-croatia.com", true },
  { "nba.christmas", true },
  { "nba.com.de", true },
  { "nba.de.com", true },
  { "nba.download", true },
  { "nba.gd", true },
  { "nba.gs", true },
  { "nba.gy", true },
  { "nba.hosting", true },
  { "nba.im", true },
  { "nba.live", true },
  { "nba.lu", true },
  { "nba.moe", true },
  { "nba.trade", true },
  { "nba.vc", true },
  { "nba.vg", true },
  { "nba2.com", true },
  { "nba2k.blog", true },
  { "nba2k.cc", true },
  { "nba2k.cn", true },
  { "nba2k.co", true },
  { "nba2k.com.cn", true },
  { "nba2k.download", true },
  { "nba2k.live", true },
  { "nba2k.net", true },
  { "nba2k.online", true },
  { "nba2k.tw", true },
  { "nba2kcn.com", true },
  { "nba2kmods.com", true },
  { "nba2kmt.com", true },
  { "nba2kmy.team", true },
  { "nba2kol.com", true },
  { "nba2konline.com", true },
  { "nba2konlinex.com", true },
  { "nba2kx.com", true },
  { "nbad.al", true },
  { "nbadancers.com", true },
  { "nbade.com", true },
  { "nbafile.com", true },
  { "nbagirls.com", true },
  { "nbaim.com", true },
  { "nbaimg.com", true },
  { "nbalive.cn", true },
  { "nbalivecn.com", true },
  { "nbalivex.com", true },
  { "nbari.com", true },
  { "nbask.com", true },
  { "nbasky.com", true },
  { "nbaspot.com", true },
  { "nbavc.com", true },
  { "nbavg.com", true },
  { "nbayouxi.com", true },
  { "nbhorsetraining.com", true },
  { "nbib.gov", true },
  { "nbnnetwork.com", true },
  { "nbrii.com", true },
  { "nbriresearch.com", true },
  { "nbur.co.uk", true },
  { "nc-beautypro.fr", true },
  { "nc-formation.fr", true },
  { "nca.ink", true },
  { "ncamarquee.co.uk", true },
  { "ncands.net", true },
  { "ncarmine.com", true },
  { "ncc-efm.com", true },
  { "ncc-efm.org", true },
  { "ncc-qualityandsafety.org", true },
  { "nccemail.net", true },
  { "ncdc.pt", true },
  { "ncea.net.au", true },
  { "nch.link", true },
  { "nchangfong.com", true },
  { "nchponline.org", true },
  { "ncjrs.gov", true },
  { "ncloud.freeddns.org", true },
  { "ncpimd001.spdns.de", true },
  { "ncsc.gov.uk", true },
  { "ncstep.org", true },
  { "nctx.co.uk", true },
  { "ncua.gov", true },
  { "ndarville.com", true },
  { "ndbt.com", true },
  { "ndcpolipak.com", true },
  { "ndeoffshore.com", true },
  { "nder.be", true },
  { "ndfa.net", true },
  { "ndfirefighter.com", true },
  { "ndhlink.com", true },
  { "ndime.com", true },
  { "ndpbrn-research.org", true },
  { "ndphp.org", true },
  { "ndpigskin.com", true },
  { "nds-helicopter.de", true },
  { "ndum.ch", true },
  { "ndvr.com", true },
  { "ndx.ee", true },
  { "ndy.sex", true },
  { "ne-on.org", true },
  { "nea.gov", true },
  { "nearby.in.th", true },
  { "neartothesky.com", true },
  { "neasahourigan.com", true },
  { "neatous.cz", true },
  { "neatous.net", true },
  { "neatzy.co.uk", true },
  { "neave.tv", true },
  { "neba.io", true },
  { "nebelhauch.de", true },
  { "nebelheim.de", true },
  { "nebenbeiblog.ch", true },
  { "nebl.cash", true },
  { "nebra.io", true },
  { "nebul.at", true },
  { "nebula.exchange", true },
  { "nebulae.co", true },
  { "nebuso.com", true },
  { "necessaryandproportionate.net", true },
  { "necessaryandproportionate.org", true },
  { "neckbeard.xyz", true },
  { "necormansir.com", true },
  { "nectarleaf.com", true },
  { "nectir-staging.com", true },
  { "nectir.co", true },
  { "nedcdata.org", true },
  { "nederdraad.org", true },
  { "nederland.media", true },
  { "nederlands-vastgoedfonds.nl", true },
  { "nedim-accueil.fr", true },
  { "nedlinin.com", true },
  { "nedraconsult.ru", true },
  { "nedzadalibegovic.com", true },
  { "neecist.org", true },
  { "needemand.com", true },
  { "needstyle.ru", true },
  { "neeerd.org", true },
  { "neel.ch", true },
  { "neemzy.org", true },
  { "neev.tech", true },
  { "nefertitis.cz", true },
  { "neffat.si", true },
  { "neflabs.com", true },
  { "nefro-cme.de", true },
  { "neftis.es", true },
  { "neg9.org", false },
  { "negai.moe", true },
  { "negativecurvature.net", true },
  { "neglecteddiseases.gov", true },
  { "negril.com", true },
  { "neheim-huesten.de", true },
  { "nehoupat.cz", true },
  { "nehrp.gov", true },
  { "neighborhoodelectricwa.com", true },
  { "neil-barrett.com", true },
  { "neil-barrett.uk", true },
  { "neildaniels.com", true },
  { "neilfarrington.com", true },
  { "neillans.co.uk", true },
  { "neillans.com", true },
  { "neilwynne.com", true },
  { "nejenpneu.cz", true },
  { "nejlevnejsi-parapety.cz", true },
  { "neko-nyan-nuko.com", true },
  { "nekodex.net", true },
  { "nekomimi.pl", true },
  { "nekomimirouter.com", true },
  { "nekorektni.cz", true },
  { "nekosc.com", true },
  { "nekowa.moe", true },
  { "nekox.ml", true },
  { "nekusoul.de", true },
  { "nelflex.com.br", true },
  { "nelhage.com", true },
  { "nemcd.com", false },
  { "nemiroth.net", true },
  { "nemo.run", true },
  { "nemopan.com", true },
  { "nemopret.dk", true },
  { "nemplex.com", true },
  { "nemplex.win", false },
  { "nems.no", true },
  { "nemumu.com", true },
  { "nemunai.re", true },
  { "nengzhen.com.cn", true },
  { "nenkin-kikin.jp", true },
  { "neno.io", true },
  { "neo2k.dk", true },
  { "neo2shyalien.eu", false },
  { "neobits.nl", true },
  { "neocities.org", true },
  { "neoclick.io", true },
  { "neodigital.bg", true },
  { "neodrive.ch", true },
  { "neoedresources.org", true },
  { "neojo.org", true },
  { "neolaudia.es", true },
  { "neonataleducationalresources.org", true },
  { "neonatalgoldenhours.org", true },
  { "neonknight.ch", true },
  { "neons.org", true },
  { "neophilus.net", true },
  { "neos.co.jp", true },
  { "neosdesignstudio.co.uk", true },
  { "neosey.com", true },
  { "neostralis.com", true },
  { "neotiv.com", true },
  { "neowin.net", true },
  { "neowlan.net", true },
  { "neoxcrf.com", true },
  { "neoz.com.br", true },
  { "nepageeks.com", true },
  { "nepal-evolution.org", true },
  { "nepezzano13.com", true },
  { "nephelion.org", true },
  { "nephology.net.au", true },
  { "nephy.jp", true },
  { "nepovolenainternetovahazardnihra.cz", true },
  { "nepremicninar.com", true },
  { "nepremicnine.click", true },
  { "nepremicnine.net", true },
  { "nepustil.net", false },
  { "nerdca.st", true },
  { "nerdherd.fun", true },
  { "nerdhouse.io", true },
  { "nerdmind.de", true },
  { "nerdpol.ch", true },
  { "nerdpol.org", true },
  { "nerdrockshop.co.uk", true },
  { "nerds-gegen-stephan.de", true },
  { "nerdswithknives.com", true },
  { "nerdtime.de", true },
  { "nerdwallet.com", true },
  { "nerdydev.net", true },
  { "nereustech.com", true },
  { "nerot.eu", true },
  { "nerpa-club.ru", true },
  { "nerv.com.au", true },
  { "nerven.se", true },
  { "nesolabs.com", true },
  { "nesolabs.de", true },
  { "nestedquotes.ca", false },
  { "nestor.nu", true },
  { "neswec.org.uk", true },
  { "net-combo-ja.com", true },
  { "net-safe.info", true },
  { "net-share.de", true },
  { "net4visions.at", true },
  { "net4visions.de", true },
  { "netamia.com", true },
  { "netapps.de", true },
  { "netbank.com.au", true },
  { "netbears.com", true },
  { "netbears.ro", true },
  { "netbows.com", true },
  { "netbows.es", true },
  { "netbox.org", true },
  { "netbrewventures.com", true },
  { "netbulls.io", true },
  { "netbuzz.ru", true },
  { "netchameleon.com", true },
  { "netconnect.at", true },
  { "netcoolusers.org", true },
  { "netd.at", true },
  { "netdex.co", true },
  { "netera.se", true },
  { "neteraser.de", true },
  { "netexpat.com", true },
  { "netfabb.com", true },
  { "netfeeds.eu", true },
  { "netflixlife.com", true },
  { "netfog.de", true },
  { "netframe.net", true },
  { "netfuture.ch", true },
  { "nethack.ninja", true },
  { "nethackwiki.com", true },
  { "nethask.ru", true },
  { "nethostingtalk.com", true },
  { "nethunter.top", true },
  { "netid.de", true },
  { "netki.com", true },
  { "netlentes.com.br", true },
  { "netlocal.ru", true },
  { "netmagicas.com.br", true },
  { "netmeister.org", true },
  { "netnea.com", true },
  { "netnik.de", true },
  { "netnodes.net", true },
  { "netraising.com", false },
  { "netrelay.email", true },
  { "netrewrite.com", true },
  { "netrider.net.au", false },
  { "netrogue.ninja", true },
  { "netronix.be", true },
  { "netsigna.de", true },
  { "netsite.dk", true },
  { "netsoins.org", true },
  { "netsparker.com", true },
  { "netsparker.com.tr", true },
  { "netspeedia.net", true },
  { "netsphere.cz", true },
  { "nettacompany.com.tr", true },
  { "nettamente.com", true },
  { "nette.org", true },
  { "nettegeschenke.de", true },
  { "nettgiro.no", true },
  { "nettia.fi", true },
  { "nettilamppu.fi", true },
  { "netto-service.ch", true },
  { "nettools.link", true },
  { "nettx.co.uk", true },
  { "netube.org", true },
  { "netvizura.co.uk", true },
  { "netvpn.ml", true },
  { "netwaf.com", true },
  { "netwarc.eu", true },
  { "netwarc.nl", true },
  { "netweaver.uk", true },
  { "networg.com", true },
  { "networg.cz", true },
  { "networg.pl", true },
  { "network-midlands.co.uk", true },
  { "network-midlands.uk", true },
  { "network-notes.com", true },
  { "network23.nl", true },
  { "networkersdiary.com", true },
  { "networkhane.com", true },
  { "networking4all.com", true },
  { "networkingnexus.net", true },
  { "networkingphoenix.com", true },
  { "networkmas.com", false },
  { "networkmidlands.co.uk", true },
  { "networkmidlands.uk", true },
  { "networkmon.net", true },
  { "networkofarts.com", true },
  { "networkposting.com", true },
  { "netz-yokohama.co.jp", true },
  { "netzfabrik.com", true },
  { "netzfrauen.org", true },
  { "netzklad.de", true },
  { "netzona.org", true },
  { "netzwerkwerk.de", true },
  { "neuber.uno", true },
  { "neuflizeobc.net", true },
  { "neurabyte.com", true },
  { "neurexcellence.com", true },
  { "neurobiology.com", true },
  { "neurochip.com", true },
  { "neurocny.cloud", true },
  { "neurolab.no", true },
  { "neuronus.com.br", true },
  { "neuropatia-periferica.com", true },
  { "neuropharmacology.com", true },
  { "neurostimtms.com", true },
  { "neurotransmitter.net", true },
  { "neurozentrum-zentralschweiz.ch", true },
  { "neutein.com", true },
  { "neutralox.com", true },
  { "neuwal.com", true },
  { "neva.li", true },
  { "never.pet", true },
  { "nevergreen.io", true },
  { "nevermore.fi", true },
  { "neverwetturkey.com", true },
  { "nevivur.net", true },
  { "nevntech.com", true },
  { "nevolution.me", true },
  { "nevoxo.com", true },
  { "new-black-order.com", true },
  { "new-boiler-prices.co.uk", true },
  { "new-ms.com", true },
  { "new-process.ch", true },
  { "new-process.com", true },
  { "new-process.de", true },
  { "new-process.eu", true },
  { "new-vip.com", true },
  { "new-web-studio.com", true },
  { "new.travel.pl", true },
  { "newaccess.ch", true },
  { "newbernpost539.com", true },
  { "newbietech.cn", false },
  { "newborncryptocoin.com", true },
  { "newbrunswick.today", true },
  { "newbrunswicktoday.com", true },
  { "newburybouncycastles.co.uk", true },
  { "newburyparkelectric.com", true },
  { "newburyparkelectrical.com", true },
  { "newburyparkelectrician.com", true },
  { "newburyparkexteriorlighting.com", true },
  { "newburyparklandscapelighting.com", true },
  { "newburyparkoutdoorlighting.com", true },
  { "newcab.de", true },
  { "newcityinfo.ch", true },
  { "newcitystudio.ch", true },
  { "newcloudwhodis.com", true },
  { "newday.host", true },
  { "newdimensioninterlock.com", true },
  { "newearth.press", true },
  { "newenglandworkinjury.com", true },
  { "newfangledscoop.com", true },
  { "newfiepedia.ca", true },
  { "newflavor.design", true },
  { "newflora.ru", true },
  { "newfoundland-labradorflora.ca", true },
  { "newgrowbook.com", true },
  { "newguidance.ch", true },
  { "newind.info", true },
  { "newinf.at", true },
  { "newinternet.media", true },
  { "newizv.ru", true },
  { "newkaliningrad.ru", true },
  { "newknd.com", true },
  { "newlifeband.de", true },
  { "newline.online", true },
  { "newmarketbouncycastlehire.co.uk", true },
  { "newmed.com.br", true },
  { "newmediaone.net", true },
  { "newmelalife.com", true },
  { "newmusicjackson.org", true },
  { "newodesign.com", true },
  { "newposts.ru", true },
  { "newreleases.io", true },
  { "news47ell.com", true },
  { "newsgroups.io", true },
  { "newsletteralerts.com", true },
  { "newsmotor.info", true },
  { "newspiritfilms.com", true },
  { "newspsychology.com", true },
  { "newstone-tech.com", true },
  { "newsyslog.org", true },
  { "newtonproject.org", true },
  { "newtrackon.com", true },
  { "newvehicle.com", true },
  { "newyorkcoffeejobs.com", true },
  { "nex.li", true },
  { "nex.sx", true },
  { "nexd.com", true },
  { "nexgeneration-solutions.com", true },
  { "nexicafiles.com", true },
  { "next-idea.co", true },
  { "next-taxi.ru", false },
  { "next-web.ad.jp", true },
  { "next176.sk", true },
  { "next24.io", true },
  { "nextbranders.com", true },
  { "nextcairn.com", true },
  { "nextcasino.com", true },
  { "nextcloud-miyamoto.spdns.org", true },
  { "nextcloud.at", true },
  { "nextcloud.com", true },
  { "nextcloud.de", true },
  { "nextcloud.li", false },
  { "nextcloud.nerdpol.ovh", true },
  { "nextcloud.org", true },
  { "nextclouddarwinkel.nl", true },
  { "nextcom.digital", true },
  { "nexter.cloud", true },
  { "nextevolution.co.uk", true },
  { "nextgen.sk", true },
  { "nextgenthemes.com", true },
  { "nextgreatmess.com", true },
  { "nextiot.de", true },
  { "nextiva.com", true },
  { "nextlevel-it.co.uk", true },
  { "nextmbta.com", true },
  { "nextme.se", true },
  { "nextnely.com", true },
  { "nextnowagency.com", true },
  { "nextos.com", true },
  { "nextrec.site", true },
  { "nextrobotics.de", true },
  { "nextstep-labs.gr", true },
  { "nextwab.com", true },
  { "nexus-exit.de", true },
  { "nexusconnectinternational.eu", true },
  { "nexwebsites.com", true },
  { "nexxus-sistemas.net.br", true },
  { "neyer-lorenz.de", true },
  { "nezrouge-est-vaudois.ch", true },
  { "nezrouge-geneve.ch", true },
  { "nf9q.com", true },
  { "nfam.de", true },
  { "nfe-elektro.de", true },
  { "nfir.nl", true },
  { "nflchan.org", true },
  { "nflmocks.com", true },
  { "nfpors.gov", true },
  { "nframe.io", true },
  { "nfsec.pl", true },
  { "nfz.moe", true },
  { "ng-musique.com", true },
  { "ngasembaru.com", true },
  { "ngc.gov", false },
  { "nghe.net", true },
  { "ngi.eu", true },
  { "nginxconfig.com", true },
  { "nginxconfig.io", true },
  { "ngojclee.com", true },
  { "ngospelmedia.net", true },
  { "ngt.gr", true },
  { "nguyencucthanh.com", true },
  { "nguyenhongson.me", true },
  { "nguyenminhhung.com", false },
  { "ngvf.de", true },
  { "ngx.hk", true },
  { "ngxpkg.com", true },
  { "nhakhoangocanh.net", true },
  { "nhchalton.com", true },
  { "nhdsilentheroes.org", true },
  { "nhgteam.hu", true },
  { "nhhoteljobs.nl", true },
  { "nhimf.org", true },
  { "nhnieuws.nl", true },
  { "nhome.ba", true },
  { "nhsolutions.be", true },
  { "nhw.ovh", true },
  { "ni-mate.com", true },
  { "ni.search.yahoo.com", false },
  { "niadd.com", true },
  { "niagara.ru", false },
  { "niagarafalls.ca", true },
  { "niagarafallsmuseums.ca", true },
  { "niagaraschoice.org", true },
  { "nibb13.tech", true },
  { "nibo.blog", true },
  { "nibouw.nl", true },
  { "nic.goog", true },
  { "nic.gov", true },
  { "nic.how", true },
  { "nic.soy", true },
  { "nic.xn--q9jyb4c", true },
  { "nice.ch", true },
  { "niceb5y.net", true },
  { "niceguyit.biz", true },
  { "nicesco.re", true },
  { "nicesleepo.com", true },
  { "nicestudio.co.il", false },
  { "nichi.co", true },
  { "nichijou.com", true },
  { "nicholasperkins.io", true },
  { "nicholaspruss.com", true },
  { "nicholasquigley.com", true },
  { "nicholasruddick.com", true },
  { "nicholaswilliams.net", true },
  { "nichteinschalten.de", false },
  { "nichthelfer.de", true },
  { "nicic.gov", true },
  { "nickcraver.com", true },
  { "nickfrost.rocks", true },
  { "nickguyver.com", true },
  { "nickhitch.co.uk", true },
  { "nickloose.de", true },
  { "nickmchardy.com", true },
  { "nickmorri.com", true },
  { "nickmorris.name", true },
  { "nickplotnek.co.uk", true },
  { "nickrickard.co.uk", true },
  { "nicks-autos.com", true },
  { "nickserve.com", true },
  { "nickstories.de", true },
  { "nicktheitguy.com", true },
  { "niclasreich.de", true },
  { "nicn.me", true },
  { "nico.st", true },
  { "nicochinese.com", true },
  { "nicocourts.com", true },
  { "nicogrosser.de", true },
  { "nicoknibbe.nl", true },
  { "nicoladixonrealestate.com", true },
  { "nicolaiteglskov.dk", true },
  { "nicolajanedesigns.co.uk", true },
  { "nicolaottomano.it", true },
  { "nicolas-dumermuth.com", true },
  { "nicolas-hoffmann.net", true },
  { "nicolas-hoizey.com", true },
  { "nicolas-simond.ch", true },
  { "nicolas-simond.com", true },
  { "nicolasfriedli.ch", true },
  { "nicolasiung.me", true },
  { "nicolaszambetti.ch", true },
  { "nicolaw.uk", true },
  { "nicolemathew.com", true },
  { "niconico.ooo", true },
  { "niconode.com", false },
  { "nicoobook.com", true },
  { "nicsezcheckfbi.gov", true },
  { "nicul.in", true },
  { "nidro.de", true },
  { "nidsuber.ch", true },
  { "niederohmig.de", true },
  { "niehage.name", true },
  { "nien.cf", true },
  { "nien.co", true },
  { "nien.com", true },
  { "nien.eu.org", true },
  { "nien.gq", true },
  { "nien.org", true },
  { "nien.tk", true },
  { "nienkeslop.nl", true },
  { "nierenpraxis-dr-merkel.de", true },
  { "nierenpraxis-merkel.de", true },
  { "niers.land", true },
  { "nieselregen.com", true },
  { "niess.space", true },
  { "niesstar.com", true },
  { "nietmvwoensel.com", true },
  { "nietzsche.com", true },
  { "nieuwsberichten.eu", true },
  { "nieuwslagmaat.nl", true },
  { "nifc.gov", true },
  { "niftiestsoftware.com", true },
  { "nigelwakefield.com", true },
  { "nigensha.co.jp", true },
  { "niggemeier.cc", true },
  { "niggo.eu", true },
  { "night2stay.cn", true },
  { "night2stay.com", true },
  { "night2stay.de", true },
  { "night2stay.fr", true },
  { "night2stay.ru", true },
  { "nightfirec.at", true },
  { "nightsi.de", true },
  { "nightstand.io", true },
  { "nihon-no-sake.net", true },
  { "nihtek.in", true },
  { "nij.gov", true },
  { "nijiero-ch.com", false },
  { "nijikata.com", true },
  { "nijm.nl", true },
  { "nikandcara.com", true },
  { "nikao-tech.com", true },
  { "nikimix.com", true },
  { "nikitashevchenko.com", true },
  { "nikkasystems.com", true },
  { "nikkila.me", true },
  { "nikklassen.ca", true },
  { "niklas.pw", true },
  { "niklasbabel.com", true },
  { "nikolainevalainen.fi", true },
  { "nikomo.fi", false },
  { "nikoninframe.co.uk", true },
  { "nikonlibrary.co.uk", true },
  { "nikonnps.co.uk", true },
  { "nikonpromotions.co.uk", true },
  { "nikonschool.co.uk", true },
  { "nikpool.com", true },
  { "niktok.com", true },
  { "nikunjcementarticles.com", true },
  { "nil.gs", true },
  { "nil.mx", true },
  { "niles.xyz", true },
  { "nilgirispice.co.uk", true },
  { "niloxy.com", true },
  { "nim-news.com", true },
  { "nimbo.com.au", true },
  { "nimeshjm.com", true },
  { "nimidam.com", true },
  { "nina-laaf.de", true },
  { "ninaforever.com", true },
  { "ninarinaldi.com.br", true },
  { "ninaundandre.de", true },
  { "ninchat.com", true },
  { "ninebennink.com", true },
  { "ninepints.co", true },
  { "ninesix.cc", true },
  { "ninespec.com", true },
  { "ninetaillabs.com", true },
  { "ninetaillabs.xyz", true },
  { "ninfora.com", true },
  { "ningbo.co.uk", true },
  { "ninja-galerie.de", true },
  { "ninja-skillz.com", true },
  { "ninjan.co", true },
  { "ninjasquad.fr", true },
  { "ninjaworld.co.uk", true },
  { "ninjio.com", true },
  { "ninov.de", true },
  { "ninreiei.jp", true },
  { "nintendoforum.no", true },
  { "ninth.cat", true },
  { "ninthfloor.org", true },
  { "ninverse.com", true },
  { "niourk.com", true },
  { "nipax.cz", true },
  { "nipe-systems.de", true },
  { "nipit.biz", true },
  { "nippangift.com", true },
  { "nipplefucking.com", true },
  { "nippon-oku.com", true },
  { "niqex.com", true },
  { "nirhub.ru", true },
  { "nirjonmela.com", true },
  { "nirjonmela.net", true },
  { "nirudo.me", true },
  { "nirvanashop.com", true },
  { "niscats.com", true },
  { "nishimebistro.cz", true },
  { "nissanofbismarckparts.com", true },
  { "nitifilter.com", true },
  { "nitrix.me", true },
  { "nitrohorse.com", false },
  { "nitrokey.com", true },
  { "nitropanel.com", true },
  { "nitropur.com", true },
  { "nitropur.de", true },
  { "nitrous-networks.com", true },
  { "nitschinger.at", true },
  { "niu.moe", true },
  { "niumactive.it", true },
  { "nivelul2.ro", true },
  { "nixnet.xyz", true },
  { "nixonlibrary.gov", true },
  { "nixx-gel.cz", true },
  { "niyawe.de", true },
  { "niyazpoyilan.com", false },
  { "nizhaoheng.com", true },
  { "nja.id.au", true },
  { "njast.net", true },
  { "njguardtraining.com", true },
  { "njilc.com", true },
  { "njpjanssen.nl", true },
  { "nkapliev.org", true },
  { "nkforum.pl", true },
  { "nkinka.de", true },
  { "nl-ix.net", true },
  { "nl.search.yahoo.com", false },
  { "nl3ehv.nl", true },
  { "nlap.ca", false },
  { "nlbewustgezond.nl", true },
  { "nlegall.fr", true },
  { "nllboard.co.uk", true },
  { "nlleisure.co.uk", true },
  { "nlm.gov", true },
  { "nlt.by", false },
  { "nmd.so", true },
  { "nmmlp.org", true },
  { "nmnd.de", true },
  { "nmontag.com", true },
  { "nn.cz", true },
  { "nn5197.co", true },
  { "nn6729.co", true },
  { "nn6729.com", true },
  { "nn6957.co", true },
  { "nn9297.co", true },
  { "nn9397.com", true },
  { "nn9721.com", true },
  { "nn9728.co", true },
  { "nna774.net", true },
  { "no-ip.cz", true },
  { "no-xice.com", true },
  { "no.search.yahoo.com", false },
  { "noagendahr.org", true },
  { "noah-witt.com", true },
  { "noahjacobson.com", true },
  { "noahmodas.com.br", true },
  { "noahsaso.com", true },
  { "noahwitt.me", true },
  { "nob.ro", true },
  { "nobilefoods.com", true },
  { "nobitakun.com", true },
  { "nobledust.com", true },
  { "nobleparkapartments.com.au", true },
  { "nobly.de", true },
  { "noc.org", true },
  { "nocit.dk", true },
  { "nocks.com", true },
  { "noclegiwchecinach.pl", true },
  { "nocmd.com", true },
  { "nodecdn.net", true },
  { "nodecraft.com", true },
  { "nodeedge.com", true },
  { "nodeflame.com", true },
  { "nodejs.de", true },
  { "nodelab-it.de", true },
  { "nodesec.cc", true },
  { "nodespin.com", true },
  { "nodevops.com", true },
  { "noeatnosleep.me", true },
  { "noedidacticos.com", true },
  { "noelclaremont.com", true },
  { "noellabo.jp", true },
  { "noellimpag.me", true },
  { "noematic.space", true },
  { "noemax.com", true },
  { "noexec.org", true },
  { "nofrillsdns.com", true },
  { "nogerondier.eu", true },
  { "nogetime.com", true },
  { "noglobalwarrants.org", true },
  { "nohats.ca", true },
  { "nohkan.fr", true },
  { "nohm.eu", true },
  { "nohttps.org", true },
  { "nohup.se", true },
  { "nohup.xyz", true },
  { "noiglosujemy.com.pl", true },
  { "noiglosujemy.pl", true },
  { "noima.com", true },
  { "noincludesubdomains.preloaded.test", false },
  { "noise.agency", true },
  { "noisetrap.cz", true },
  { "noisky.cn", true },
  { "noisyfox.cn", true },
  { "nokono.com", true },
  { "nolaviz.org", true },
  { "noleggio-bagni-chimici.it", true },
  { "noleggiobagnichimici.perugia.it", true },
  { "noleggioimbarcazioni.it", true },
  { "noleggiolimousine.roma.it", true },
  { "noma-film.com", true },
  { "nomadproject.io", true },
  { "nomagic.software", true },
  { "nomaster.cc", true },
  { "nomenclator.org", true },
  { "nomesbiblicos.com", true },
  { "nomial.co.uk", true },
  { "nomifensine.com", true },
  { "nomik.xyz", true },
  { "nomsy.net", true },
  { "noname-ev.de", true },
  { "nonametheme.com", true },
  { "noncombatant.org", true },
  { "nonx.pro", true },
  { "noob-box.net", true },
  { "noobow.me", true },
  { "noobsunited.de", true },
  { "noobunbox.net", true },
  { "noodles.net.nz", false },
  { "noodplan.co.za", true },
  { "noodweer.be", true },
  { "noofficewalls.com", true },
  { "nook.my", true },
  { "noomist.com", true },
  { "noon-entertainments.com", true },
  { "noonan.family", true },
  { "noop.ch", true },
  { "nooranevalainen.fi", true },
  { "noordsee.de", true },
  { "noordwesthoekrit.nl", true },
  { "noorsolidarity.com", true },
  { "noortronic.com", true },
  { "nootronerd.com", true },
  { "nootropic.com", true },
  { "noovell.com", true },
  { "nopaste.xyz", true },
  { "nopaynocure.com", true },
  { "nophelet.com", true },
  { "norad.sytes.net", true },
  { "noradevot.com", true },
  { "norbertschneider-music.com", true },
  { "nord-restaurant-bar.de", true },
  { "nord-sud.be", true },
  { "nordfinck.de", true },
  { "nordicirc.com", true },
  { "nordinfo.fi", true },
  { "nordlichter-brv.de", true },
  { "nordmoregatebilklubb.com", true },
  { "nordnetz-hamburg.de", true },
  { "nordseeblicke.de", true },
  { "nordstromheating.com", true },
  { "nordwal.de", true },
  { "nordwaldzendo.de", true },
  { "noreply.mx", true },
  { "norestfortheweekend.com", true },
  { "noret.com", true },
  { "norfolkgardencare.co.uk", true },
  { "norichanmama.com", true },
  { "noriel.ro", true },
  { "normaculta.com.br", true },
  { "norman-preusser-gmbh.de", true },
  { "normanbauer.com", true },
  { "normandgascon.com", true },
  { "normankranich.de", true },
  { "normantobar.com", true },
  { "norml.fr", true },
  { "noroshi-burger.com", true },
  { "norrlandsbilverkstad.se", true },
  { "norrliden.de", true },
  { "norsewars.com", true },
  { "norskpensjon.no", true },
  { "northatlantalaw.net", true },
  { "northbridgecre.com", true },
  { "northbrisbaneapartments.com.au", true },
  { "northcoastlabs.com", true },
  { "northconsulting.fr", true },
  { "northcountykiaparts.com", true },
  { "northcreekresort.com", true },
  { "northcreekresortblue.ca", true },
  { "northdakotahealthnetwork.com", true },
  { "northdevonbouncycastles.co.uk", true },
  { "northeastcdc.org", true },
  { "northeastrodeo.co.uk", true },
  { "northebridge.com", true },
  { "northern-lakes.com", true },
  { "northerngate.net", true },
  { "northernhamsterclub.com", true },
  { "northernpowertrain.com", true },
  { "northernselfstorage.co.za", true },
  { "northfieldyarn.com", true },
  { "northokanaganbookkeeping.com", true },
  { "northpointoutdoors.com", true },
  { "northpole.dance", true },
  { "northpost.is", true },
  { "northridgeelectrical.com", true },
  { "northtexasvasectomy.com", true },
  { "northumbriagames.co.uk", true },
  { "nos-medias.fr", true },
  { "nos-oignons.net", true },
  { "noscript.net", true },
  { "noscura.nl", true },
  { "noseastumismo.com", true },
  { "nosecrets.ch", true },
  { "noslite.nl", true },
  { "nosqlzoo.net", true },
  { "nossasenhora.net", true },
  { "nossasenhoradodesterro.com.br", true },
  { "nostalgimidi.se", true },
  { "nostraforma.com", false },
  { "nosuch.site", true },
  { "nosuch.website", true },
  { "noswap.com", true },
  { "nosyu.pe.kr", true },
  { "nota.moe", true },
  { "notabug.org", true },
  { "notacooldomain.com", true },
  { "notadd.com", true },
  { "notallmine.net", true },
  { "notar-glagowski.com", true },
  { "notar-glagowski.de", true },
  { "notar-peikert.com", true },
  { "notare-marktplatz24.info", true },
  { "notariusz-bialystok.com", true },
  { "notarkrauss.de", true },
  { "notcompletelycorrect.com", true },
  { "noteboat.net", true },
  { "notepad.nz", true },
  { "noteshare.net", true },
  { "noteshare.online", true },
  { "noteskeeper.ru", true },
  { "nothing.net.nz", true },
  { "nothingprivate.ml", true },
  { "noticaballos.com", true },
  { "noticiasdehumor.com", true },
  { "noticiasdetv.com", true },
  { "notify.moe", true },
  { "notigatos.es", true },
  { "notilus.fr", true },
  { "notjustvacs.com", true },
  { "notmybox.com", true },
  { "notnize.net", true },
  { "notnl.com", true },
  { "notofilia.com", true },
  { "notora.tech", true },
  { "nototema.com", true },
  { "notsafefor.work", true },
  { "nottres.com", true },
  { "noudjalink.nl", true },
  { "nourishandnestle.com", true },
  { "noustique.com", true },
  { "nousyukum.com", true },
  { "nova-dess.ch", true },
  { "nova-it.pl", true },
  { "nova-kultura.org", true },
  { "nova-wd.org.uk", true },
  { "nova.com.hk", true },
  { "nova.live", true },
  { "novabench.com", true },
  { "novacal.ga", true },
  { "novacoast.com", false },
  { "novadermis.es", true },
  { "novafreixo.pt", true },
  { "novaiguacu.net.br", true },
  { "novascan.net", true },
  { "novawave.ca", true },
  { "nove.city", true },
  { "noveciti.com", true },
  { "novecity.cloud", true },
  { "novecity.com", true },
  { "novecity.info", true },
  { "novecity.it", true },
  { "novecity.org", true },
  { "novecitymail.com", true },
  { "novelfeed.com", true },
  { "novelinglife.net", true },
  { "novelvyretraite.fr", true },
  { "novema.jp", true },
  { "novengi.mu", true },
  { "novfishing.ru", true },
  { "novgorod-avia.ru", true },
  { "novilaw.com", true },
  { "novilidery.com", true },
  { "novinhabucetuda.com", true },
  { "novinivo.com", true },
  { "novojet.cl", true },
  { "novoresume.com", false },
  { "novosibavia.ru", true },
  { "novurania.com", true },
  { "nowarning.cc", true },
  { "nowhere.dk", true },
  { "nowitzki.network", true },
  { "nowlas.org", true },
  { "nowloading.co", true },
  { "nowzuwan.org", false },
  { "noxlogic.nl", true },
  { "noxx.global", true },
  { "noxx.solutions", true },
  { "noyocenter.org", true },
  { "np-edv.at", true },
  { "np.search.yahoo.com", false },
  { "np39.de", true },
  { "npath.de", true },
  { "npbeta.com", true },
  { "npcrcss.org", true },
  { "nphrm.com", true },
  { "npmcdn.com", true },
  { "npregion.org", true },
  { "npsas.org", true },
  { "npw.net", true },
  { "nqeshreviewer.com", true },
  { "nrd.gov", true },
  { "nrd.li", true },
  { "nrev.ch", true },
  { "nriol.net", true },
  { "nrkn.fr", true },
  { "nrsmart.com", true },
  { "nrsweb.org", true },
  { "nrvn.cc", false },
  { "ns-frontier.com", true },
  { "ns2servers.pw", true },
  { "nsa.ovh", true },
  { "nsadns.uk", true },
  { "nsapwn.com", true },
  { "nsboston.org", true },
  { "nscnet.jp", true },
  { "nsfw-story.com", true },
  { "nshipster.cn", true },
  { "nshipster.co.kr", true },
  { "nshipster.com", true },
  { "nshipster.es", true },
  { "nsm.ee", true },
  { "nsm.stat.no", true },
  { "nsnsp.org", true },
  { "nso.ie", true },
  { "nsofficeinteriors.com", true },
  { "nsoft.nu", true },
  { "nsp.ua", true },
  { "nspawn.org", true },
  { "nsradiology.net", true },
  { "nst-maroc.com", true },
  { "nstd.net", true },
  { "nstinvoiceqa.com", true },
  { "nstnet.org", true },
  { "nstremsdoerfer.ovh", true },
  { "nstrust.co.uk", true },
  { "nsworks.com", true },
  { "nszipline.com", true },
  { "nt-catala.com", true },
  { "ntags.org", true },
  { "ntcp.ph", true },
  { "nte.email", true },
  { "nti.de", true },
  { "ntia.gov", true },
  { "ntlabs.org", true },
  { "ntotten.com", true },
  { "ntppool.org", false },
  { "ntsb.gov", true },
  { "ntwt.us", true },
  { "ntx360grad-fallakte.de", true },
  { "ntzwrk.org", true },
  { "nu3tion.com", true },
  { "nu3tion.cz", true },
  { "nuacht.ie", true },
  { "nualgiponds.com", true },
  { "nuamooreaindonesia.com", true },
  { "nuclea.id", true },
  { "nuclearcat.com", true },
  { "nucleosynth.space", true },
  { "nudes.ovh", true },
  { "nudevotion.com", true },
  { "nudge.ai", true },
  { "nuel.cl", true },
  { "nuffield.nl", true },
  { "nuipogoda.ru", true },
  { "nukleosome.com", true },
  { "null-life.com", true },
  { "nullday.de", true },
  { "nulle-part.org", true },
  { "nullonerror.org", true },
  { "nullpointer.io", true },
  { "nullroute.com", true },
  { "nullwebscripts.com", true },
  { "nullxsec.net", true },
  { "numarasorgulama.tel", true },
  { "numatic.co.uk", true },
  { "numbercult.net", true },
  { "numbermunchers.net", true },
  { "numberoneshoes.co.nz", true },
  { "numberzero.org", true },
  { "numerik-games.ch", true },
  { "numero-aleatorio.com", true },
  { "numero1.ch", true },
  { "numerologist.com", true },
  { "numerossanos.com.ar", true },
  { "numismed-seniorcare.de", true },
  { "numo.co", true },
  { "numwave.nl", true },
  { "nunesgh.com", true },
  { "nunnenmacher.net", true },
  { "nunnun.jp", true },
  { "nunomoura.com", true },
  { "nuovaelle.it", true },
  { "nuquery.com", true },
  { "nur.berlin", true },
  { "nureg.club", true },
  { "nureg.net", true },
  { "nureg.xyz", true },
  { "nuriacamaras.com", true },
  { "nursejj.com", true },
  { "nursemom.ca", true },
  { "nurseone.ca", true },
  { "nurseregistry.com", true },
  { "nurses.dating", true },
  { "nuryahan.com.br", true },
  { "nusatrip-api.com", true },
  { "nussadoclub.org", true },
  { "nut.services", true },
  { "nutikell.com", true },
  { "nutleyeducationalfoundation.org", true },
  { "nutleyef.org", true },
  { "nutpanda.com", true },
  { "nutra-creations.com", true },
  { "nutrafitsuplementos.com.br", true },
  { "nutri-spec.me", true },
  { "nutricaovegana.com", true },
  { "nutriciametabolics-shop.de", true },
  { "nutridieta.com", true },
  { "nutripedia.gr", true },
  { "nutrishop.com", true },
  { "nutrition.gov", true },
  { "nuttyveg.com", true },
  { "nuvechtdal.nl", true },
  { "nuvini.com", true },
  { "nuvospineandsports.com", true },
  { "nuxer.fr", true },
  { "nv.gw", true },
  { "nvl-game.tokyo", true },
  { "nvq.nl", true },
  { "nvr.bz", true },
  { "nvtc.gov", true },
  { "nwapproval.com", false },
  { "nwautorebuild.com", true },
  { "nwbc.gov", true },
  { "nwea.nl", true },
  { "nwerc.party", true },
  { "nwgh.org", false },
  { "nwimports.com", true },
  { "nwitt.us", true },
  { "nwk1.com", true },
  { "nwmd.nl", true },
  { "nwperformanceandoffroad.com", true },
  { "nwra.com", true },
  { "nwtrb.gov", true },
  { "nwwc.dk", true },
  { "nwwnetwork.net", true },
  { "nxcd.com.br", true },
  { "nxgn.io", true },
  { "nxinfo.ch", true },
  { "nxit.ca", true },
  { "nxth.io", true },
  { "nya.as", true },
  { "nyadora.com", true },
  { "nyadora.moe", true },
  { "nyan.it", true },
  { "nyan.stream", true },
  { "nyantec.com", true },
  { "nybiz.nyc", true },
  { "nyconcretelifting.com", true },
  { "nycoyote.org", true },
  { "nydig.com", true },
  { "nydnxs.com", true },
  { "nyerjachioval.hu", true },
  { "nyerjenaheraval.hu", true },
  { "nyhaoyuan.net", true },
  { "nyiad.edu", true },
  { "nyip.co.uk", true },
  { "nyip.edu", true },
  { "nylevemusic.com", true },
  { "nyloc.de", true },
  { "nylonfeetporn.com", true },
  { "nymphetomania.net", true },
  { "nyoliveoil.com", true },
  { "nyoronfansubs.org", true },
  { "nyphox.ovh", true },
  { "nysis.fr", true },
  { "nysis.net", true },
  { "nysteak5.com", true },
  { "nytrafficticket.com", true },
  { "nyxi.eu", true },
  { "nyyu.tk", true },
  { "nyzed.com", true },
  { "nzb.cat", false },
  { "nzbs.com", true },
  { "nzstudy.ac.nz", true },
  { "nzws.me", true },
  { "o-results.ch", true },
  { "o-s.no", true },
  { "o-sp.com", true },
  { "o2careers.co.uk", true },
  { "o3.wf", true },
  { "o3wallet.com", true },
  { "o5.cx", true },
  { "o5197.co", true },
  { "o6729.co", true },
  { "o6729.com", true },
  { "o6957.co", true },
  { "o6asan.com", true },
  { "o9297.co", true },
  { "o9397.com", true },
  { "o9721.com", true },
  { "o9728.co", true },
  { "oahpmdata.net", true },
  { "oaic.gov.au", true },
  { "oakandresin.co", true },
  { "oakesfam.net", true },
  { "oakface.club", true },
  { "oakface.com.au", true },
  { "oakington.info", false },
  { "oakparkelectrical.com", true },
  { "oakparkexteriorlighting.com", true },
  { "oakparklandscapelighting.com", true },
  { "oakparklighting.com", true },
  { "oakparkoutdoorlighting.com", true },
  { "oakslighting.co.uk", true },
  { "oaktonhouseandgardens.com", true },
  { "oaktree-realtors.com", true },
  { "oasiristorantebagno.it", true },
  { "oasisdabeleza.com.br", true },
  { "oasisim.net", false },
  { "oatmealdome.me", true },
  { "oatycloud.spdns.de", true },
  { "oauth-dropins.appspot.com", false },
  { "obamalibrary.gov", true },
  { "obamawhitehouse.gov", true },
  { "obec-krakovany.cz", true },
  { "oberhofdrinks.com", true },
  { "obermeiers.eu", true },
  { "oberoi.de", true },
  { "obesidadlavega.com", true },
  { "obfuscate.xyz", true },
  { "obg-global.com", true },
  { "obgalslancaster.com", true },
  { "obgynmiamifl.com", true },
  { "obitech.de", true },
  { "object.earth", true },
  { "objectif-terre.ch", true },
  { "objectorientedsolutions.com", true },
  { "objekt-textil.ch", true },
  { "oblast45.ru", false },
  { "obligacjekk.pl", true },
  { "oboeta.com", true },
  { "obono.at", true },
  { "obrienswine.ie", true },
  { "obs.group", true },
  { "obscur.us", true },
  { "obsproject.com", true },
  { "obtima.org", true },
  { "obud.cz", true },
  { "obxlistings.com", true },
  { "obyvateleceska.cz", true },
  { "obzoroff.info", true },
  { "oc-sa.ch", true },
  { "ocalaflwomenshealth.com", true },
  { "ocarupo.com", true },
  { "occ.gov", true },
  { "occenterprises.org", true },
  { "occentus.net", true },
  { "occmon.net", true },
  { "occonnections.org", true },
  { "occupational-therapy-colleges.com", true },
  { "ocd2016.com", true },
  { "ocdadmin.com", true },
  { "oceanbreezehomes.com", true },
  { "oceancity4sales.com", true },
  { "oceandns.eu", true },
  { "oceandns.net", true },
  { "oceandns.nl", true },
  { "oceanlord.me", true },
  { "oceanofapk.com", true },
  { "oceanvisuals.com", true },
  { "ocenovani-inspekce.cz", true },
  { "ocf.io", true },
  { "ocg-card.com", true },
  { "ochrepoint.com.au", true },
  { "ochsenfeld.co", true },
  { "ochsundjunior.ch", true },
  { "ochsundjunior.swiss", true },
  { "ocim.ch", true },
  { "ockendenhemming.co.uk", true },
  { "oclausen.com", true },
  { "ocni-ambulance-most.cz", true },
  { "ocolere.ch", true },
  { "ocotg.com", true },
  { "ocrn.nl", true },
  { "ocsigroup.fr", true },
  { "ocsr.nl", true },
  { "octa.store", true },
  { "octagongroup.co", true },
  { "octarineparrot.com", true },
  { "octav.name", false },
  { "octava.ua", true },
  { "octaviosimon.com", true },
  { "octavus.it", true },
  { "octobered.com", true },
  { "octocaptcha.com", true },
  { "octocat.ninja", true },
  { "octofox.de", true },
  { "octohedralpvp.tk", true },
  { "octolopagon.games", true },
  { "octopus-agents.com", true },
  { "octosniff.net", true },
  { "octosys.net", true },
  { "octosys.org", true },
  { "octosys.ru", true },
  { "octothorpe.club", true },
  { "octothorpe.ninja", true },
  { "oculus.com", true },
  { "odden.io", true },
  { "oddmuse.org", true },
  { "oddnumber.ca", true },
  { "oddsandevens.ca", true },
  { "oddsandevensbookkeeping.ca", true },
  { "ode.red", true },
  { "odensc.me", true },
  { "odense3dprint.dk", true },
  { "odhosc.ca", true },
  { "odinseye.net", true },
  { "odonti.com", true },
  { "odoo.co.th", true },
  { "odpikedoslike.com", true },
  { "odtu.lu", true },
  { "oducs.org", true },
  { "odvps.com", true },
  { "odysseyofthemind.eu", true },
  { "odzyskaniedomeny.pl", true },
  { "oe-boston.com", true },
  { "oe0fcdncxjpdd05b.myfritz.net", true },
  { "oec-music.com", false },
  { "oeh.ac.at", true },
  { "oeko-bundesfreiwilligendienst-sh.de", true },
  { "oeko-bundesfreiwilligendienst.de", true },
  { "oeko-jahr-jubilaeum.de", true },
  { "oeko-jahr.de", true },
  { "oelbilder-oelmalerei.de", true },
  { "oelsner.net", true },
  { "oemspace.net", true },
  { "oemspace.nl", true },
  { "oemwolf.com", true },
  { "oenings.eu", true },
  { "oepsbanaan.nl", true },
  { "oes.org.gt", true },
  { "oessi.eu", true },
  { "ofcampuslausanne.ch", true },
  { "ofda.gov", true },
  { "ofertasadsl.com", true },
  { "ofertino.es", true },
  { "ofertolino.fr", true },
  { "offandonagain.org", true },
  { "offbyinfinity.com", true },
  { "offenekommune.de", true },
  { "offenes-deutschland.de", true },
  { "offensity.com", true },
  { "offertegiuste.com", true },
  { "offgames.io", true },
  { "offgridauto.com", true },
  { "offgridhub.com", true },
  { "office-discount.at", true },
  { "office-discount.de", true },
  { "office-furniture-direct.co.uk", true },
  { "office-morimoto.com", true },
  { "officefundays.co.uk", true },
  { "officeinteriors.co.nz", true },
  { "officemovepro.com", true },
  { "officiants.wedding", false },
  { "officium.tech", true },
  { "offroadeq.com", true },
  { "offroadhoverboard.net", true },
  { "offshoot.ie", true },
  { "offshoot.rentals", true },
  { "offshore.digital", true },
  { "offshoremarineparts.com", false },
  { "offtopica.uk", true },
  { "ofggolf.com", true },
  { "oflow.me", true },
  { "ofsetas.lt", true },
  { "oftamedic.com", true },
  { "oftn.org", true },
  { "oge.ch", true },
  { "ogocare.com", true },
  { "oguya.ch", true },
  { "ogyaa.jp", true },
  { "oh14.de", true },
  { "ohadsoft.com", true },
  { "ohai.su", true },
  { "ohchouette.com", true },
  { "ohd.dk", true },
  { "oheila.com", true },
  { "ohentpay.com", true },
  { "ohhere.xyz", true },
  { "ohiohealthfortune100.com", true },
  { "ohm.sg", true },
  { "ohm2013.org", true },
  { "ohmayonnaise.com", true },
  { "ohne-name.de", true },
  { "ohol.se", true },
  { "ohsocool.org", true },
  { "ohsohairy.co.uk", true },
  { "oi-wiki.org", true },
  { "oil-ecn.ru", true },
  { "oisd.nl", true },
  { "oita-homes.com", true },
  { "ojaioliveoil.com", true },
  { "ojdip.net", true },
  { "ojp.gov", true },
  { "ok3on.cz", true },
  { "okad-center.de", true },
  { "okad.de", true },
  { "okad.eu", true },
  { "okada-touki.jp", true },
  { "okaidi.es", true },
  { "okaidi.fr", true },
  { "okakuro.org", true },
  { "okashi.me", true },
  { "okay.cf", true },
  { "okay.coffee", true },
  { "okaz.de", true },
  { "okazoo.eu", true },
  { "okburrito.com", true },
  { "okchousebuyer.com", true },
  { "okeeferanch.ca", true },
  { "okhrana.agency", true },
  { "okib.ca", true },
  { "okin-jp.net", true },
  { "okinawa-mag.net", true },
  { "oklahomafibroids.com", true },
  { "okna-tm.kz", true },
  { "okonetwork.org.uk", true },
  { "okoris.net", true },
  { "okotoksbeach.ca", true },
  { "okqubit.net", true },
  { "oksafe-t.org", true },
  { "oktime.cz", true },
  { "oktoberfeststore.nl", true },
  { "oktomus.com", true },
  { "oku-nara.com", true },
  { "okukan.com.au", true },
  { "okurapictures.com", true },
  { "okusiassociates.com", true },
  { "okviz.com", true },
  { "okwu.cz", true },
  { "olafnorge.de", true },
  { "olanderflorist.com", true },
  { "olasouris.com", true },
  { "olastrafford.org", true },
  { "olback.net", true },
  { "olbat.net", true },
  { "olcayanar.com", true },
  { "olcbrookhaven.org", true },
  { "oldbrookinflatables.co.uk", true },
  { "oldbrookmarqueehire.co.uk", true },
  { "oldchaphome.nl", true },
  { "older-racer.com", true },
  { "oldita.ru", true },
  { "oldking.net", true },
  { "oldnews.news", true },
  { "oldno07.com", true },
  { "oldoakflorist.com", true },
  { "oldonyosafaris.com", true },
  { "oldprop.com", true },
  { "oldroutetwo.com", true },
  { "oldschool-criminal.com", true },
  { "oldsticker.com", true },
  { "oldstmary.com", true },
  { "oldtimerreifen-moeller.de", true },
  { "oleam.org", true },
  { "olecoin.io", true },
  { "olegon.ru", true },
  { "olegs.be", true },
  { "oleksii.name", true },
  { "olenergies.com", true },
  { "oleodecopayba.com.br", true },
  { "oles-hundehaus.de", true },
  { "olfnewcastle.com", true },
  { "olfsecane.org", true },
  { "olgcc.net", true },
  { "olgiati.org", true },
  { "olgun.eu", true },
  { "olhcparish.net", true },
  { "olightstore.ro", true },
  { "olitham.com", true },
  { "olivemultispecialist.com", true },
  { "oliveoil.bot", true },
  { "oliveoilschool.org", true },
  { "oliveoiltest.com", true },
  { "oliveoiltimes.com", true },
  { "oliveraiedelabastideblanche.fr", true },
  { "oliverclausen.com", true },
  { "oliverdunk.com", false },
  { "oliverfaircliff.com", true },
  { "olivernaraki.com", true },
  { "oliverniebuhr.de", true },
  { "oliverschmid.space", true },
  { "oliverspringer.eu", true },
  { "oliverst.com", true },
  { "olivier-rochet.com", true },
  { "olivierberardphotographe.com", true },
  { "olivierlemoal.fr", true },
  { "olivierpieters.be", true },
  { "oliviervaillancourt.com", true },
  { "olizeite.ch", true },
  { "ollie.io", true },
  { "ollies.cz", true },
  { "olliespage.com", true },
  { "olliespage.net", true },
  { "olliespage.uk", true },
  { "ollning.com", true },
  { "olltechjob.com", true },
  { "olmari.fi", true },
  { "olmc-nutley.org", true },
  { "olmcjc.com", true },
  { "olmcnewark.com", true },
  { "olmik.net", true },
  { "olmmcc.tk", true },
  { "olmsted.io", true },
  { "olofsson.cc", true },
  { "olomercy.com", true },
  { "olphseaside.org", true },
  { "olqoa.org", true },
  { "olschurch.com", true },
  { "olsh-hilltown.com", true },
  { "olsonproperties.com", true },
  { "olymp-arts.world", true },
  { "olympeakgaming.tv", true },
  { "olympiads.ca", true },
  { "olympic-research.com", true },
  { "om.yoga", true },
  { "om1.com", true },
  { "omanko.porn", true },
  { "omegahosting.net", true },
  { "omegarazer.ca", true },
  { "omegathermoproducts.nl", true },
  { "omenprinting.com.au", true },
  { "omeopatiadinamica.it", true },
  { "omerefe.av.tr", true },
  { "omertabeyond.com", true },
  { "omertabeyond.net", true },
  { "ometepeislandinfo.com", true },
  { "omf.link", true },
  { "omfg.exposed", true },
  { "omgbouncycastlehire.co.uk", true },
  { "omi-news.fr", true },
  { "omicron3069.com", true },
  { "omitech.co.uk", true },
  { "omniaclubs.com", true },
  { "omniasig.ro", true },
  { "omniasl.com", true },
  { "omniatv.com", true },
  { "omnibot.tv", true },
  { "omnifurgone.it", true },
  { "omnigon.network", true },
  { "omnimoto.it", true },
  { "omnisiens.se", true },
  { "omnitrack.org", true },
  { "omniverse.ru", true },
  { "omny.info", true },
  { "omoide-hitokoto.com", true },
  { "omorashi.org", true },
  { "omori.ch", true },
  { "omoteura.com", true },
  { "omronwellness.com", true },
  { "omsdieppe.fr", true },
  { "omskrock.com", true },
  { "on-tech.co.uk", true },
  { "on.tax", true },
  { "on2it.net", true },
  { "ona.io", true },
  { "onaboat.se", true },
  { "onahonavi.com", true },
  { "onair.ovh", true },
  { "onarto.com", true },
  { "onbuzzer.com", false },
  { "oncalltech.net", true },
  { "onceuponarainbow.co.uk", true },
  { "oncf.asso.fr", true },
  { "oncodedesign.com", true },
  { "ond-inc.com", true },
  { "ond-inc.jp", true },
  { "ondcp.gov", true },
  { "onderwijstransparant.nl", true },
  { "ondevamosjantar.com", true },
  { "ondrej.org", true },
  { "ondrejbudin.cz", true },
  { "one---line.com", true },
  { "one-resource.com", true },
  { "one-s.co.jp", true },
  { "one-tab.com", true },
  { "one2edit.com", true },
  { "oneazcu.com", false },
  { "onebigcow.com", true },
  { "oneclic.ch", true },
  { "onedegreehealth.com", true },
  { "onedottwelve.co.jp", false },
  { "onedottwelve.com", false },
  { "onedrive.com", true },
  { "onedrive.live.com", false },
  { "onee3.org", true },
  { "oneearthapp.com", true },
  { "oneheartbali.church", true },
  { "oneindex.tk", true },
  { "onelinkmmp.net", true },
  { "onemeter.com", true },
  { "onemid.net", true },
  { "onemoonmedia.de", true },
  { "oneononeonone.de", true },
  { "oneononeonone.tv", true },
  { "onepercentrentals.com", true },
  { "onepersona.io", true },
  { "onepointsafeband.ca", true },
  { "onepointsafeband.com", true },
  { "onepointzero.com", true },
  { "oneprediction.com", true },
  { "onesnzeroes.com", true },
  { "onesports.cz", true },
  { "onestasolar.com", true },
  { "onestepfootcare.com", true },
  { "onestop-study.com", true },
  { "onestopcastles.co.uk", true },
  { "onetcenter.org", true },
  { "onetcodeconnector.org", true },
  { "onetime.info", true },
  { "onetonline.org", true },
  { "onetouchrevealplus.com", true },
  { "onetwentyseven001.com", true },
  { "onevpn.com", true },
  { "oneway.ga", true },
  { "onewaymail.com", true },
  { "oneweb.hu", true },
  { "onfarma.it", true },
  { "ongea.io", true },
  { "ongiaenegogoa.com", true },
  { "onhistory.co.uk", true },
  { "onhub1.com", true },
  { "oni.nl", true },
  { "onice.ch", true },
  { "onionbot.me", true },
  { "onionplay.eu", true },
  { "onionplay.net", true },
  { "onionscan.org", true },
  { "onionyst.com", true },
  { "oniria.ch", true },
  { "onix.eu.com", true },
  { "onixcco.com.br", true },
  { "onkentessegertdij.hu", true },
  { "onlfait.ch", true },
  { "online-backup.se", true },
  { "online-biblio.tk", true },
  { "online-calculator.com", true },
  { "online-consulting-corp.fr", true },
  { "online-eikaiwa-guide.com", true },
  { "online-health-insurance.com", true },
  { "online-lernprogramme.de", true },
  { "online-pr.at", true },
  { "online-stopwatch.com", true },
  { "online-textil.com", true },
  { "online-textil.cz", true },
  { "online-textil.sk", true },
  { "online.marketing", true },
  { "online.swedbank.se", true },
  { "online24.pt", true },
  { "onlinecasino.vlaanderen", true },
  { "onlinecasinobluebook.com", true },
  { "onlinecensorship.org", true },
  { "onlinecollegeessay.com", true },
  { "onlinedemo.hu", true },
  { "onlinefashion.it", true },
  { "onlinehaircuts.com", true },
  { "onlinehashfollow.com", true },
  { "onlinekmc.com", true },
  { "onlinelegalmarketing.com", true },
  { "onlinelegalmedia.com", true },
  { "onlinemarketingmuscle.com", true },
  { "onlinemarketingtraining.co.uk", true },
  { "onlinepokerspelen.be", true },
  { "onlineporno.tv", true },
  { "onlineporno.xyz", true },
  { "onlineprofecional.com", true },
  { "onlinerollout.de", true },
  { "onlinesystem.jp", true },
  { "onlinetextil.cz", true },
  { "onlineth.com", false },
  { "onlinevisa.ru", true },
  { "onlineweblearning.com", true },
  { "onlinexl.nl", true },
  { "onlylibya.com", true },
  { "onmaps.de", true },
  { "onmarketbookbuilds.com", true },
  { "onnaguse.com", true },
  { "onoranzefunebri.roma.it", true },
  { "onore.org", true },
  { "onpay.io", true },
  { "onqproductions.com", true },
  { "onrr.gov", true },
  { "ons.ca", true },
  { "onsgenoegen-waz.nl", true },
  { "onsinscrit.com", true },
  { "onspring.com", true },
  { "ontdekhetzelf.nu", true },
  { "onthebriteside.com", true },
  { "ontras.com", false },
  { "ontservice.com", true },
  { "ontsnappingskamer.nl", true },
  { "onurer.net", true },
  { "onvey.io", true },
  { "onviga.de", true },
  { "onvisible.website", true },
  { "onvori.com", true },
  { "onvori.de", true },
  { "onvousment.fr", true },
  { "onysix.net", true },
  { "onyxcts.com", true },
  { "onyxfireinc.com", true },
  { "onyxgen.duckdns.org", true },
  { "onyxmoon.me", true },
  { "oo5197.co", true },
  { "oo6729.co", true },
  { "oo6729.com", true },
  { "oo6957.co", true },
  { "oo918.com", true },
  { "oo9297.co", true },
  { "oo9397.com", true },
  { "oo9721.com", true },
  { "oo9728.co", true },
  { "oodlessoftplay.co.uk", true },
  { "oogami.name", true },
  { "ooharttemplates.com", true },
  { "oolsa.net", true },
  { "ooonja.de", true },
  { "oosolutions.nl", true },
  { "ooyo.be", true },
  { "op3racional.eu", true },
  { "opalesurfcasting.net", true },
  { "oparl.org", true },
  { "opcare.co.uk", true },
  { "opcenter.de", true },
  { "opcionpublicitaria.com", true },
  { "opcionpublicitaria.pe", true },
  { "ope.ee", true },
  { "open-banking-access.uk", true },
  { "open-bs.com", true },
  { "open-bs.ru", true },
  { "open-ctp.com", true },
  { "open-ctp.net", true },
  { "open-ctp.org", true },
  { "open-desk.org", true },
  { "open-freax.fr", false },
  { "open-future.be", true },
  { "open-gaming.net", true },
  { "open-infrastructure.net", true },
  { "open-letters.de", true },
  { "open-mesh.org", true },
  { "open-sauce-recipes.co.uk", true },
  { "open-source.gr", true },
  { "open.gl", true },
  { "openacte.ch", true },
  { "openbayes.com", true },
  { "openbeecloud.com", true },
  { "openblox.org", true },
  { "opencad.io", true },
  { "opencaves.io", true },
  { "opencircuit.nl", true },
  { "openclima.com", true },
  { "openconf.uk", true },
  { "opencpes.net", true },
  { "opencrm.co.uk", true },
  { "openctp.com", true },
  { "openctp.net", true },
  { "openctp.org", true },
  { "opendata.cz", true },
  { "opendataincubator.eu", true },
  { "opendecide.com", true },
  { "openfir.st", true },
  { "openfitapi-falke.azurewebsites.net", true },
  { "opengg.me", true },
  { "opengovpartnership.de", true },
  { "openings.ninja", true },
  { "openitforum.pl", true },
  { "openjur.de", true },
  { "openkim.org", true },
  { "openkvk.nl", true },
  { "openmirrors.ml", true },
  { "openmtbmap.org", true },
  { "openpictures.ch", true },
  { "openquery.com.au", true },
  { "openrainbow.com", true },
  { "openrainbow.net", true },
  { "openre.site", true },
  { "openrealestate.co", true },
  { "openresearch.amsterdam", true },
  { "openresty.com", true },
  { "openreview.net", true },
  { "openroademail.com", true },
  { "openrtm.org", true },
  { "openruhr.de", true },
  { "openscreen.lu", true },
  { "openshippers.com", true },
  { "opensource-cms.nl", true },
  { "opensource-training.de", true },
  { "opensourcesurvey.org", true },
  { "openspa.webhop.info", true },
  { "openssl.org", true },
  { "openstandia.jp", true },
  { "openstem.com.au", true },
  { "openstreetmap.is", true },
  { "openstreetmap.lu", true },
  { "openstreetmap.org", true },
  { "opentrack.info", true },
  { "opentuition.com", true },
  { "openverse.com", true },
  { "openvz.org", true },
  { "openwaveguide.de", true },
  { "openwifi.gr", true },
  { "openwireless.org", true },
  { "opexterminating.com", true },
  { "opfin.com", true },
  { "ophis-phosphoros.com", true },
  { "opiates.ca", true },
  { "opic.gov", true },
  { "opin.me", true },
  { "opinio.fr", true },
  { "opinionitech.com", true },
  { "opioids.co.uk", true },
  { "opioids.com", true },
  { "opioids.gov", true },
  { "opium.io", true },
  { "oplop.appspot.com", true },
  { "oposiciones.com.es", true },
  { "oposicionesapolicialocal.es", true },
  { "oposicionescorreos.com.es", true },
  { "oposicionescorreos.es", true },
  { "oposicionescorreos.info", true },
  { "oposicionesdejusticia.org", true },
  { "oposicionesertzaintza.com.es", true },
  { "oposicionesycursos.com", true },
  { "oppada.com", true },
  { "oppaiti.me", true },
  { "oppejoud.ee", true },
  { "opportunis.me", true },
  { "opportunity.de", true },
  { "opportunityliu.top", true },
  { "oppositionsecurity.com", true },
  { "oppress.life", true },
  { "oppwa.com", true },
  { "opq.pw", true },
  { "oprechtgezegd.nl", true },
  { "oprueba.com", true },
  { "opryshok.com", true },
  { "ops-com.com", true },
  { "opsmate.com", false },
  { "opti-net.at", true },
  { "opticaltest.com", true },
  { "optik-trosdorff.de", true },
  { "optimalsetup.com", true },
  { "optimaner.pl", true },
  { "optimist.bg", true },
  { "optimumwebdesigns.com", true },
  { "optimus.io", true },
  { "optimuscrime.net", true },
  { "optm.us", true },
  { "optmos.at", true },
  { "optoutday.de", true },
  { "opture.ch", true },
  { "opus-codium.fr", true },
  { "opus-consulting.no", true },
  { "opvakantie-noorwegen.nl", true },
  { "opvakantie-zweden.nl", true },
  { "oqwebdesign.com", true },
  { "orang-utans.com", true },
  { "orangecomputers.com", true },
  { "orangefab.asia", true },
  { "orangejetpack.com", true },
  { "orangenbaum.at", true },
  { "orangesquash.org.uk", true },
  { "orangewombat.com", true },
  { "orangutan-appeal.org.uk", true },
  { "orangutan.org", true },
  { "oranjee.net", false },
  { "orbital3.com", true },
  { "orbu.net", true },
  { "orca.pet", true },
  { "orcada.co", true },
  { "orcahq.com", true },
  { "orcamoney.com", true },
  { "orcawiki.nl", true },
  { "orchideenettoyage.com", true },
  { "orchidlive.com", true },
  { "orchids.co.jp", true },
  { "orchidsforum.com", true },
  { "orchidspaper.com", true },
  { "orcsnet.com", true },
  { "ordbokpro.se", true },
  { "orde.red", true },
  { "ordermore.cloud", true },
  { "ordernow.at", true },
  { "orderswift.com", true },
  { "ordoh.com", true },
  { "ordoro.com", true },
  { "oreshinya.xyz", true },
  { "oreskylaw.com", true },
  { "oreto.de", false },
  { "orf-digitalsatkarte.at", false },
  { "orf-kartentausch.at", false },
  { "orfelios.com", true },
  { "organica.co.za", true },
  { "organisatieteam.nl", true },
  { "organisationsberatung-jacobi.de", true },
  { "orgasmium.com", true },
  { "orgsyn.in", true },
  { "orgyporngroup.com", true },
  { "orhideous.name", true },
  { "orians.eu", true },
  { "oribia.net", true },
  { "orientalart.nl", true },
  { "orientravelmacas.com", true },
  { "oriflameszepsegkozpont.hu", true },
  { "origami.to", true },
  { "origamika.com", true },
  { "origin8delicafes.com", true },
  { "original-christstollen.com", true },
  { "original-christstollen.de", true },
  { "originalniknihy.cz", true },
  { "originpc.com", false },
  { "orikadabra.nl", true },
  { "orikum.org", true },
  { "orimex-mebel.ru", true },
  { "orion-universe.com", true },
  { "orioncokolada.cz", true },
  { "orionfinancialservices.com", true },
  { "orkestar-krizevci.hr", true },
  { "orkiv.com", true },
  { "orlandobalbas.com", true },
  { "orlandoprojects.com", true },
  { "orleika.io", true },
  { "ormer.nl", true },
  { "oro.roma.it", true },
  { "orocojuco.com", true },
  { "orologeria.roma.it", true },
  { "oroscopodelmese.it", true },
  { "orrs.de", true },
  { "ortho-europe.com", true },
  { "orthocop.cz", true },
  { "orthodocspro.com", true },
  { "orthodontiste-geneve-docteur-rioux.com", true },
  { "orthograph.ch", true },
  { "orthotictransfers.com", true },
  { "ortlepp.eu", true },
  { "oruggt.is", true },
  { "orwell1984.today", true },
  { "oryva.com", true },
  { "os-s.net", true },
  { "os-t.de", true },
  { "os24.cz", true },
  { "osacrypt.studio", true },
  { "osakeannit.fi", true },
  { "osao.org", true },
  { "osbi.pl", true },
  { "osborn.io", true },
  { "osborneinn.com", true },
  { "osburn.com", true },
  { "oscarvk.ch", true },
  { "osepideasthatwork.org", true },
  { "oses.mobi", true },
  { "osez-l-odyssee.fr", true },
  { "oshayr.com", true },
  { "oshell.me", true },
  { "oshrc.gov", true },
  { "osielnava.com", true },
  { "osimmo.fr", true },
  { "osirisrp.online", true },
  { "osirium.com", true },
  { "oskrba.net", true },
  { "oskrba.online", true },
  { "oskuro.net", true },
  { "osla.org", true },
  { "oslinux.net", true },
  { "osm.is", true },
  { "osm.ovh", true },
  { "osmani-gebaeudereinigung.de", true },
  { "osmanlitorunu.com", true },
  { "osmosis.org", true },
  { "osmre.gov", true },
  { "osnova.cz", true },
  { "osobliwydom.pl", true },
  { "osolutionscorp.com", true },
  { "osom.finance", true },
  { "osomjournal.org", true },
  { "ospf.sk", true },
  { "ospree.me", true },
  { "ostachstore.com", true },
  { "ostan-collections.net", true },
  { "osteendiner.com", true },
  { "osterkraenzchen.de", true },
  { "ostgotamusiken.se", true },
  { "osti.gov", true },
  { "ostimwebyazilim.com", true },
  { "ostr.io", true },
  { "ostrov8.com", true },
  { "osuszanie-krakow.pl", true },
  { "osuszanie-radom.pl", true },
  { "osuszanie-warszawa.pl", true },
  { "oswaldlabs.com", true },
  { "oswalds.co.uk", true },
  { "oswaldsmillaudio.com", true },
  { "oswbouncycastles.co.uk", true },
  { "osworx.net", true },
  { "osx86spain.com", true },
  { "oszri.hu", true },
  { "ota365.com", true },
  { "otakubox.de", true },
  { "otakurepublic.com", true },
  { "otakurumi.de", true },
  { "otellio.com", true },
  { "otellio.de", true },
  { "otellio.it", true },
  { "other98.com", true },
  { "oticasaopaulo.com.br", true },
  { "oticasvisao.net.br", true },
  { "otisko.com", true },
  { "otokiralama.name.tr", true },
  { "otomobilforumu.com", true },
  { "otorrino.pt", true },
  { "otoy.com", true },
  { "otoya.space", false },
  { "otprema.hr", true },
  { "otpsmart.com.ua", true },
  { "otr.ie", true },
  { "otrm.de", true },
  { "ots.gov", true },
  { "otsfreestyle.jp", true },
  { "ottoproject.io", false },
  { "ottoversand.at", true },
  { "otvaracie-hodiny.sk", true },
  { "otvertka.kz", true },
  { "otya.me", true },
  { "ouaibe.qc.ca", true },
  { "ouattara.ch", true },
  { "ouestsolutions.com", true },
  { "ouglor.com", true },
  { "ouin.land", true },
  { "oulunjujutsu.com", true },
  { "ouowo.gq", true },
  { "our-box.de", true },
  { "our-box.net", true },
  { "ourai.ws", true },
  { "ourcloud.at", true },
  { "ourdocuments.gov", true },
  { "ourevents.net", true },
  { "ourfavorite-kakamigahara.jp", true },
  { "ourladymountcarmel.net", true },
  { "ourladyofcalvary.org", true },
  { "ourladyoftheassumptionchurch.org", true },
  { "ourladyqueenofmartyrs.org", true },
  { "ourmaster.org", true },
  { "ourocg.cn", true },
  { "ourwedding.xyz", true },
  { "ourworldindata.org", true },
  { "out-of-scope.de", true },
  { "outdoorchoose.com", true },
  { "outdoorfurniture.ie", true },
  { "outdoorimagingportal.com", true },
  { "outdoorlightingagoura.com", true },
  { "outdoorlightingagourahills.com", true },
  { "outdoorlightingcalabasas.com", true },
  { "outdoorlightingconejovalley.com", true },
  { "outdoorlightingdosvientos.com", true },
  { "outdoorlightinghiddenhills.com", true },
  { "outdoorlightinglakesherwood.com", true },
  { "outdoorlightingmalibu.com", true },
  { "outdoorlightingmoorpark.com", true },
  { "outdoorlightingnewburypark.com", true },
  { "outdoorlightingoakpark.com", true },
  { "outdoorlightingsimivalley.com", true },
  { "outdoorlightingthousandoaks.com", true },
  { "outdoorlightingwestlakevillage.com", true },
  { "outerlimitsdigital.com", true },
  { "outetc.com", true },
  { "outfunnel.com", true },
  { "outgress.com", true },
  { "outincanberra.com.au", true },
  { "outinjersey.net", true },
  { "outka.xyz", true },
  { "outline.ski", true },
  { "outlookonthedesktop.com", true },
  { "outplnr.fr", true },
  { "outpostinfo.com", true },
  { "output.clothing", true },
  { "outsideconnections.com", true },
  { "outsiders.paris", true },
  { "outstack.vote", true },
  { "ouxiang.me", true },
  { "ovabastecedoraindustrial.com", true },
  { "ovelhaostra.com", false },
  { "overalglas.nl", true },
  { "overamsteluitgevers.nl", true },
  { "overclockers.ge", true },
  { "overdrive-usedcars.be", true },
  { "overkillshop.com", true },
  { "overlandireland.ie", true },
  { "overnightglasses.com", true },
  { "overs.jp", true },
  { "overs.top", true },
  { "overseamusic.de", true },
  { "oversight.garden", true },
  { "oversight.gov", true },
  { "overstap.deals", true },
  { "overstemmen.nl", true },
  { "overstockpromote.com", true },
  { "overthinkingit.com", true },
  { "overtrolls.de", true },
  { "overzicht.pro", true },
  { "overzicht.ws", true },
  { "oveweddings.com", true },
  { "ovirt.org", true },
  { "ovisy.com", true },
  { "ovix.co", true },
  { "ovnrain.com", true },
  { "ovpn.to", true },
  { "ovvy.net", false },
  { "owapi.net", true },
  { "owddm.com", true },
  { "owennelson.co.uk", true },
  { "owensordinarymd.com", true },
  { "owid.cloud", true },
  { "owl-square.com", true },
  { "owl-stat.ch", true },
  { "owl.net", true },
  { "owlishmedia.com", true },
  { "own3d.ch", true },
  { "ownagepranks.com", true },
  { "ownc.at", true },
  { "ownmay.com", false },
  { "owntournament.org", true },
  { "oxanababy.com", true },
  { "oxborrow.ca", true },
  { "oxdl.cn", true },
  { "oxelie.com", true },
  { "oxia.me", true },
  { "oxiame.eu", true },
  { "oximo.lviv.ua", true },
  { "oxo.cloud", true },
  { "oxygin.net", true },
  { "oxytocin.org", true },
  { "oxyx.tk", true },
  { "oxz.me", true },
  { "oxzeth3sboard.com", true },
  { "oyashirosama.tokyo", true },
  { "oyosoft.fr", true },
  { "oyosoft.net", true },
  { "oysterworldwide.com", true },
  { "oyunpat.com", true },
  { "ozalp.dk", true },
  { "ozark.be", true },
  { "ozarktrailcooler.com", true },
  { "oznamovacipovinnost.cz", true },
  { "ozvolvo.org", true },
  { "p-p.site", true },
  { "p-s-b.com", true },
  { "p0l.de", true },
  { "p1979.com", true },
  { "p1group.com", true },
  { "p1ratrulezzz.me", true },
  { "p22.co", true },
  { "p4chivtac.com", true },
  { "p5197.co", true },
  { "p5on.net", true },
  { "p5r.uk", true },
  { "p6957.co", true },
  { "p9297.co", true },
  { "p9721.com", true },
  { "p9728.co", true },
  { "pa-w.de", true },
  { "pa.search.yahoo.com", false },
  { "paarberatung-hn.de", true },
  { "paardenhulp.nl", true },
  { "paardensportbak.nl", true },
  { "paas-inf.net", true },
  { "paass.net", true },
  { "paazmaya.fi", true },
  { "pablo.im", true },
  { "pablo.scot", true },
  { "pablo.sh", true },
  { "pabloarteaga.co.uk", true },
  { "pabloarteaga.com", true },
  { "pabloarteaga.com.es", true },
  { "pabloarteaga.es", true },
  { "pabloarteaga.eu", true },
  { "pabloarteaga.info", true },
  { "pabloarteaga.me", true },
  { "pabloarteaga.name", true },
  { "pabloarteaga.net", true },
  { "pabloarteaga.nom.es", true },
  { "pabloarteaga.org", true },
  { "pabloarteaga.science", true },
  { "pabloarteaga.tech", true },
  { "pabloarteaga.uk", true },
  { "pabloarteaga.xyz", true },
  { "pablofain.com", true },
  { "pabuzo.vn", true },
  { "pacaom.com", true },
  { "pacatlantic.com", true },
  { "pacch.io", true },
  { "pacchioni.me", true },
  { "paccolat.name", true },
  { "pace.car", true },
  { "paced.me", true },
  { "pacelink.de", true },
  { "pacifco.com", true },
  { "pacificcashforcars.com.au", true },
  { "pacificgynsurgicalgroup.com", true },
  { "pacificpuke.com", true },
  { "pacifictilkin-occasions.be", true },
  { "pack-haus.de", true },
  { "packagingproject.management", true },
  { "packagist.jp", true },
  { "packagist.org", false },
  { "packaware.com", true },
  { "packetdigital.com", true },
  { "packetlinux.com", true },
  { "pact2017.nl", true },
  { "pactf.com", true },
  { "padam-group.com", true },
  { "padberx-marketing-consultants.de", true },
  { "paddy.rocks", true },
  { "padelbox.de", true },
  { "padeoe.com", true },
  { "padianda.com", true },
  { "padkit.org", true },
  { "padpilot.co", true },
  { "padrepio.in", true },
  { "padron.com.es", true },
  { "padzilla.com", true },
  { "paedlink.ca", true },
  { "paf-events.ch", true },
  { "pagalworld.co", true },
  { "pagalworld.com", true },
  { "pagalworld.info", true },
  { "pagalworld.io", true },
  { "pagalworld.la", true },
  { "pagalworld.live", true },
  { "pagalworld.me", true },
  { "pagalworld.org", true },
  { "page-builders.com", true },
  { "pageantsnews.com", false },
  { "pageboard.fr", true },
  { "pagedesignhub.com", true },
  { "pagedesignpro.com", true },
  { "pagedesignweb.com", true },
  { "pagefulloflies.io", true },
  { "pagerduty.com", true },
  { "pagewizz.com", true },
  { "pagiamtzis.com", true },
  { "pagina394.com.br", true },
  { "paginaweb4u.com", true },
  { "pagure.io", true },
  { "pahae.de", false },
  { "pahealthbilling.com", true },
  { "pahlawanpulsa.com", true },
  { "paichai.space", false },
  { "paincareehr.com", true },
  { "paindata.dk", true },
  { "painefamily.co.uk", true },
  { "paintball-ljubljana.si", true },
  { "paintball-shop.sk", true },
  { "paintcolorsbysue.com", true },
  { "paintingindurban.co.za", true },
  { "paipuman.jp", true },
  { "pajadam.me", true },
  { "pajuvuo.fi", true },
  { "paketo.cz", true },
  { "paketo.sk", true },
  { "paketwatch.de", false },
  { "pakho.xyz", true },
  { "pakingas.lt", true },
  { "pakistani.dating", true },
  { "pakitow.fr", true },
  { "pakke.de", true },
  { "paktolos.net", true },
  { "palabr.as", true },
  { "palapadev.com", true },
  { "palariviera.com", true },
  { "palary.work", true },
  { "palatin.at", true },
  { "palava.tv", true },
  { "palavalbasket.it", true },
  { "palavatv.com", true },
  { "palazzo.link", true },
  { "palebluedot.de", true },
  { "paleo.io", true },
  { "paleodietfoodlist.com", true },
  { "paleodietrecipes.com", true },
  { "paleorecipepro.com", true },
  { "paleoso.com", true },
  { "palermopride.it", true },
  { "palestra.roma.it", true },
  { "palladium46.com", true },
  { "palletflow.com", true },
  { "palli.ch", true },
  { "palmaprop.com", true },
  { "palmavile.us", true },
  { "palmaville.com", true },
  { "palmen-apotheke.de", true },
  { "palomardisplays.com", true },
  { "pama.fun", true },
  { "pamaniqu.nl", true },
  { "pamatv.hk", true },
  { "pamsorel.co.za", true },
  { "pan.digital", true },
  { "panamatrippin.com", true },
  { "panasca.is", true },
  { "panascais.at", true },
  { "panascais.ch", true },
  { "panascais.co", true },
  { "panascais.com", true },
  { "panascais.cz", true },
  { "panascais.de", true },
  { "panascais.es", true },
  { "panascais.eu", true },
  { "panascais.fi", true },
  { "panascais.fr", true },
  { "panascais.host", true },
  { "panascais.info", true },
  { "panascais.io", true },
  { "panascais.me", true },
  { "panascais.net", true },
  { "panascais.network", true },
  { "panascais.nl", true },
  { "panascais.org", true },
  { "panascais.pl", true },
  { "panascais.pt", true },
  { "panascais.pw", true },
  { "panascais.ru", true },
  { "panascais.site", true },
  { "panascais.tech", true },
  { "panascais.us", true },
  { "panascais.zone", true },
  { "panaxis.biz", true },
  { "panaxis.ch", true },
  { "panaxis.li", true },
  { "panda-community.com", true },
  { "panda.tf", true },
  { "pandaltd.nl", true },
  { "pandemicflu.gov", true },
  { "pandkonijn.nl", true },
  { "pandoraflora.com", true },
  { "pandymic.com", true },
  { "paneldewelopera.pl", true },
  { "paneldoorsolutions.com", true },
  { "paneu.de", true },
  { "panevo.com", true },
  { "panhandlemenshealth.com", true },
  { "panic.tk", true },
  { "panier-legumes.bio", true },
  { "panino.gr", true },
  { "paninohome.com", true },
  { "paniodpolskiego.eu", true },
  { "paniyanovska.ua", true },
  { "panj.ws", true },
  { "panjiva.com", true },
  { "panmetro.com", true },
  { "panopy.co", true },
  { "panopy.me", true },
  { "panpa.ca", true },
  { "panpsychism.com", true },
  { "panpsychist.com", true },
  { "pantallasled.com.mx", true },
  { "pantallasled.mx", true },
  { "pantallasyescenarios.com", true },
  { "pantheoncrafters.com", true },
  { "panthur.com.au", false },
  { "pantographe.info", true },
  { "pantou.org", false },
  { "pants-off.xyz", true },
  { "panzer72.ru", true },
  { "panzerscreen.dk", true },
  { "paolotagliaferri.com", true },
  { "pap.la", false },
  { "papa-webzeit.de", true },
  { "papabearsautocenter.com", true },
  { "papadopoulos.me", true },
  { "papakatsu-life.com", true },
  { "papaya.me.uk", true },
  { "papayame.com", true },
  { "papayapythons.com", true },
  { "papelcraft.co.uk", true },
  { "paper-republic.org", true },
  { "paper.sc", true },
  { "paperhoney.by", true },
  { "paperlesssolutionsltd.com.ng", true },
  { "papermuseum.jp", true },
  { "papersmart.net", true },
  { "papertracker.net", true },
  { "paperturn.com", true },
  { "paperwritinghelp.net", true },
  { "papiermakerijdehoop.nl", true },
  { "papiermeteenverhaal.nl", true },
  { "papierniczy.eu", true },
  { "papillon-events.be", true },
  { "papion.it", true },
  { "papiweb.ca", true },
  { "paprikas.fr", true },
  { "paraborsa.net", true },
  { "parachute70.com", true },
  { "paracomer.es", true },
  { "paradais-sphynx.com", true },
  { "paradependentesquimicos.com.br", true },
  { "paradise-engineer.com", true },
  { "paradise-engineering.com", true },
  { "paradise-travel.net", true },
  { "paradiselost.com", true },
  { "paradoxdesigns.org", true },
  { "paragonie.com", false },
  { "paragonremodeling.com", true },
  { "paragreen.net", true },
  { "paranoidmode.com", true },
  { "paranoidpenguin.net", true },
  { "parasitologyclub.org", true },
  { "parasosto.fi", true },
  { "paratlan.hu", true },
  { "paratlantalalkozas.hu", true },
  { "paratxt.org", true },
  { "parcelbroker.co.uk", false },
  { "parchcraftaustralia.com", true },
  { "parckwart.de", true },
  { "parcon.it", true },
  { "parcoursup.fr", true },
  { "pareachat.com", true },
  { "parentelement.com", true },
  { "parentheseardenne.be", true },
  { "parentinterview.com", true },
  { "parentsandzebrasunited.com", true },
  { "parentsintouch.co.uk", true },
  { "paris-store.com", true },
  { "parisackerman.com", true },
  { "parisbloom.com", true },
  { "parisderriere.fr", true },
  { "parisescortgirls.com", true },
  { "parisfranceparking.com", true },
  { "parisfranceparking.de", true },
  { "parisfranceparking.fr", true },
  { "parisfranceparking.nl", true },
  { "parkeren.in", true },
  { "parkerplumbingcompany.com.au", true },
  { "parkhost.eu", true },
  { "parkinginparis.fr", true },
  { "parkingparisnord.fr", true },
  { "parkingpoint.co.uk", true },
  { "parkinsplasticsurgery.com", true },
  { "parkrunstats.servehttp.com", true },
  { "parkviewmotorcompany.com", true },
  { "parkwayminyan.org", true },
  { "parlamento.gub.uy", true },
  { "parleamonluc.fr", true },
  { "parleu2016.nl", true },
  { "parmels.com.br", true },
  { "parnassys.net", true },
  { "parnizaziteksasko.cz", true },
  { "parodesigns.com", true },
  { "parolu.io", true },
  { "parquettista.milano.it", true },
  { "parquettista.roma.it", true },
  { "parrocchiamontevecchia.it", true },
  { "parry.org", true },
  { "parsdev.ir", true },
  { "parsemail.org", true },
  { "parser.nu", true },
  { "parsonsfamilyhomes.com", true },
  { "partage-noir.fr", true },
  { "parteaga.com", true },
  { "parteaga.net", true },
  { "partecipa.tn.it", true },
  { "parthkolekar.me", true },
  { "partin.nl", true },
  { "partiono.com", true },
  { "partnercardservices.com", true },
  { "partnermobil.de", true },
  { "partnertaxhub.com", true },
  { "partou.de", true },
  { "partridge.tech", true },
  { "parts4phone.com", true },
  { "partsestore.com", true },
  { "parturi-manner.fi", true },
  { "partusedtyres.net", true },
  { "party-and-play.co.uk", true },
  { "party-calendar.net", true },
  { "party-kneipe-bar.com", true },
  { "party-time-inflatables-durham.co.uk", true },
  { "partybounceplay.co.uk", true },
  { "partycentrumopenhuis.nl", true },
  { "partyhelfer.ch", true },
  { "partyhireisleofwight.co.uk", true },
  { "partyhireliverpool.co.uk", true },
  { "partypearl.de", true },
  { "partyrocksbounce.co.uk", true },
  { "partyschnaps.com", true },
  { "partyspaces.co.uk", true },
  { "partytime-uk.co.uk", true },
  { "partytimeltd.ie", true },
  { "partytownireland.co.uk", true },
  { "partytownmarquees.co.uk", true },
  { "partyvan.io", true },
  { "partyyy.io", true },
  { "partyzone.ie", true },
  { "parvaneh.fr", true },
  { "parys.org", true },
  { "pasadenapooch.org", true },
  { "pasadenasandwichcompany.com", true },
  { "pasalt.com", true },
  { "pasarella.eu", true },
  { "pascal-bourhis.com", true },
  { "pascal-bourhis.net", true },
  { "pascal-wittmann.de", true },
  { "pascalchristen.ch", true },
  { "pascaline-jouis.fr", true },
  { "pascalleguern.com", true },
  { "pascalmathis.com", true },
  { "pascalmathis.me", true },
  { "pascalmathis.net", true },
  { "pascalspoerri.ch", false },
  { "pascualinmuebles.com", true },
  { "pasearch.nl", true },
  { "pashminacachemire.com", true },
  { "pass.org.my", true },
  { "passabook.com", true },
  { "passcod.name", true },
  { "passengertravelportal.com", true },
  { "passfilesafe.com", true },
  { "passieposse.nl", true },
  { "passionandbalance.com", true },
  { "passionate.org.nz", true },
  { "passionatefoodie.co.uk", true },
  { "passionatehorsemanship.com", true },
  { "passionatelife.com.au", true },
  { "passionebenessere.com", true },
  { "passionpictures.eu", true },
  { "passions-art.com", true },
  { "passover-fun.com", true },
  { "passport.yandex.by", true },
  { "passport.yandex.com", true },
  { "passport.yandex.com.tr", true },
  { "passport.yandex.kz", true },
  { "passport.yandex.ru", true },
  { "passport.yandex.ua", true },
  { "passports.govt.nz", true },
  { "passporttrails.com", true },
  { "passthepopcorn.me", true },
  { "passumpsicbank.com", true },
  { "passvanille-reservation.fr", true },
  { "passvau.lt", true },
  { "passwd.one", true },
  { "passwd.org", true },
  { "password-checker.de", true },
  { "password.consulting", true },
  { "password.work", true },
  { "passwordhashing.com", true },
  { "passwordkeeperbooks.com", true },
  { "passwords.google.com", false },
  { "passwordscon.org", true },
  { "passwordsecurity.info", true },
  { "passworks.io", true },
  { "passy.pw", true },
  { "pasta-factory.co.il", true },
  { "pastaenprosecco.nl", true },
  { "paste.fedoraproject.org", true },
  { "paste.gg", true },
  { "paste.to", true },
  { "pastebin.co.za", true },
  { "pastebin.run", true },
  { "pastebin.tw", true },
  { "pasternok.org", true },
  { "pasticcerialorenzetti.com", true },
  { "pasztor.at", true },
  { "patapwn.com", true },
  { "patatbesteld.nl", true },
  { "pataterosviajeros.com", true },
  { "patbatesremodeling.com", false },
  { "patdorf.com", true },
  { "patechmasters.com", true },
  { "patentados.com", true },
  { "patentfamily.de", true },
  { "paterno-gaming.com", true },
  { "pathagoras.com", true },
  { "pathwaystoresilience.org", true },
  { "patika-biztositas.hu", true },
  { "patikabiztositas.hu", true },
  { "patineteselectricosbaratos.net", true },
  { "patric-lenhart.de", true },
  { "patrick-omland.de", true },
  { "patrick-omland.eu", true },
  { "patrick-othmer.de", true },
  { "patrick-robrecht.de", true },
  { "patrick.my-gateway.de", true },
  { "patrickaudley.ca", true },
  { "patrickaudley.com", true },
  { "patrickbrosi.de", true },
  { "patrickhoefler.net", true },
  { "patricklynch.xyz", true },
  { "patrickschneider.me", true },
  { "patrikgarten.de", true },
  { "patriksima.cz", true },
  { "patriksimek.cz", true },
  { "patriotstationatchalfont.com", true },
  { "patrocinio.com.br", true },
  { "patrykwegrzynek.pl", true },
  { "patrz.eu", true },
  { "patsch-photography.de", true },
  { "patsyforyou.ch", true },
  { "patsytoforyou.ch", true },
  { "pattonfanatic.com", true },
  { "pattuka.com", true },
  { "pattyliao.com", true },
  { "paudley.ca", true },
  { "paudley.com", true },
  { "paudley.org", true },
  { "paul-barton.co.uk", true },
  { "paul.reviews", true },
  { "pauladamsmith.com", true },
  { "paulbakaus.com", true },
  { "paulbdelaat.nl", true },
  { "paulbramhall.uk", true },
  { "paulchen.at", true },
  { "paulcooper.me.uk", true },
  { "paulerhof.com", true },
  { "paulgerberrealtors.com", true },
  { "paulinewesterman.nl", true },
  { "paullockaby.com", true },
  { "paulmeier.com", false },
  { "paulorochago.com.br", true },
  { "paulov.com", true },
  { "paulov.info", true },
  { "paulov.ru", true },
  { "paulrobertlloyd.com", true },
  { "paulrotter.de", true },
  { "paulschreiber.com", true },
  { "paulscustomauto.com", true },
  { "paulsnar.lv", true },
  { "paulswartz.net", true },
  { "paulus-foto.pl", true },
  { "paulw.io", true },
  { "paulward.net", true },
  { "paulwatabe.com", true },
  { "paulwendelboe.com", true },
  { "pauly-stahlhandel.com", true },
  { "pauly-stahlhandel.de", true },
  { "pautadiaria.com", true },
  { "pavamtio.cz", true },
  { "pavando.com", true },
  { "pavelfojt.cz", true },
  { "pavelrebrov.com", true },
  { "pavelstriz.cz", true },
  { "paw.cloud", true },
  { "paw.pt", true },
  { "pawel-international.com", true },
  { "pawelnazaruk.com", true },
  { "pawelurbanek.com", true },
  { "pawspuppy.com", true },
  { "pawsr.us", true },
  { "pawsru.org", true },
  { "paxchecker.com", true },
  { "paxerahealth.com", true },
  { "pay-online.in", true },
  { "pay.gov", true },
  { "paya.cat", true },
  { "payboy.biz", true },
  { "payboy.rocks", true },
  { "paybro.eu", true },
  { "payexpresse.c