/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.util.AndStringPattern;
import classycle.util.NotStringPattern;
import classycle.util.StringPattern;
import classycle.util.StringPatternSequence;
import classycle.util.TrueStringPattern;
import classycle.util.WildCardPattern;

public abstract class CommandLine {
    private static final String MERGE_INNER_CLASSES = "-mergeInnerClasses";
    private static final String INCLUDING_CLASSES = "-includingClasses=";
    private static final String EXCLUDING_CLASSES = "-excludingClasses=";
    private static final String REFLECTION_PATTERN = "-reflectionPattern=";
    private boolean _mergeInnerClasses;
    protected boolean _valid = true;
    protected StringPatternSequence _pattern = new AndStringPattern(new StringPattern[0]);
    protected StringPattern _reflectionPattern;
    protected String[] _classFiles;

    public CommandLine(String[] args) {
        int index;
        for (index = 0; index < args.length && args[index].charAt(0) == '-'; ++index) {
            this.handleOption(args[index]);
        }
        this._classFiles = new String[args.length - index];
        System.arraycopy(args, index, this._classFiles, 0, this._classFiles.length);
        if (this._classFiles.length == 0) {
            this._valid = false;
        }
    }

    protected void handleOption(String argument) {
        if (argument.startsWith(MERGE_INNER_CLASSES)) {
            this._mergeInnerClasses = true;
        } else if (argument.startsWith(INCLUDING_CLASSES)) {
            String patterns = argument.substring(INCLUDING_CLASSES.length());
            this._pattern.appendPattern(WildCardPattern.createFromsPatterns(patterns, ","));
        } else if (argument.startsWith(EXCLUDING_CLASSES)) {
            String patterns = argument.substring(EXCLUDING_CLASSES.length());
            StringPattern p = WildCardPattern.createFromsPatterns(patterns, ",");
            this._pattern.appendPattern(new NotStringPattern(p));
        } else if (argument.startsWith(REFLECTION_PATTERN)) {
            String patterns = argument.substring(REFLECTION_PATTERN.length());
            this._reflectionPattern = patterns.length() == 0 ? new TrueStringPattern() : WildCardPattern.createFromsPatterns(patterns, ",");
        } else {
            this._valid = false;
        }
    }

    public String[] getClassFiles() {
        return this._classFiles;
    }

    public StringPattern getPattern() {
        return this._pattern;
    }

    public StringPattern getReflectionPattern() {
        return this._reflectionPattern;
    }

    public boolean isValid() {
        return this._valid;
    }

    public boolean isMergeInnerClasses() {
        return this._mergeInnerClasses;
    }

    public String getUsage() {
        return "[-mergeInnerClasses] [-includingClasses=<pattern1>,<pattern2>,...] [-excludingClasses=<pattern1>,<pattern2>,...] [-reflectionPattern=<pattern1>,<pattern2>,...] <class files, zip/jar/war/ear files, or folders>";
    }
}

