#!/bin/bash

#
# debian-8.x86_64.sh
# Creates a Docker image used to build Moon Phase on Debian 8.
#


# Assume success.
ExitCode=0

# Include docker functions (also includes print functions).
which awisewhere.sh >/dev/null && . "$(awisewhere.sh)/docker.sh" && \
    which dib.sh >/dev/null
if [ $? -ne 0 ]; then
  echo "$0: error: unable to locate files needed by this script."
  echo "$0: error: verify awiseshell is installed and is in the path."
  ExitCode=1
fi

if [ $ExitCode -eq 0 ]; then

  # If called from shell with no parameters, start 'dib.sh'.
  if [ $# -eq 0 ]; then
    Parent=$(ps -o comm= $PPID)
    if [ "$Parent" == "bash" ]; then
      dib.sh "$0"
      exit
    fi
  fi

  PBUILDER_OPT='--mirror ftp://ftp.us.debian.org/debian/ --debootstrapopts \
      --keyring=/usr/share/keyrings/debian-archive-keyring.gpg \
      --distribution $DIST --architecture $ARCH --basetgz $DIST-${ARCH}.tgz'

  case $1 in

    -b)
      if [ $# -lt 1 ]; then
        Print_MissingArgumentsError 1 "to '$1' option"
      elif [ $# -gt 1 ]; then
        Print_ExtraArgumentsError 1 "to '$1' option"
      fi
      echo "registry.gitlab.com/alanwise/awisetoolbox:debian-8.x86_64-20170706"
      ExitCode=0
      ;;

    -c)
      if [ $# -lt 1 ]; then
        Print_MissingArgumentsError 1 "to '$1' option"
      elif [ $# -gt 1 ]; then
        Print_ExtraArgumentsError 1 "to '$1' option"
      fi
      echo "3"
      ExitCode=0
      ;;

    -r)
      if [ $# -lt 1 ]; then
        Print_MissingArgumentsError 1 "to '$1' option"
      elif [ $# -gt 1 ]; then
        Print_ExtraArgumentsError 1 "to '$1' option"
      fi
      echo "registry.gitlab.com/moonphase/moonphase"
      ExitCode=0
      ;;

    -0)
      if [ $# -lt 2 ]; then
        Print_MissingArgumentsError 1 "to '$1' option"
      elif [ $# -gt 2 ]; then
        Print_ExtraArgumentsError 1 "to '$1' option"
      fi
      PBUILDERRCTEMP=$(tempfile)
      echo 'EXTRAPACKAGES="fakeroot git cmake debhelper git libqt4-dev"' \
          >>$PBUILDERRCTEMP
          # fakeroot needed by pbuilder, git needed by .gitlab-ci.yml.
          # All others by moonphase.
      Docker_CopyFile $PBUILDERRCTEMP "$2:/root/.pbuilderrc"
      ExitCode=$?
      rm "$PBUILDERRCTEMP"
      ;;

    -1)
      if [ $# -lt 2 ]; then
        Print_MissingArgumentsError 1 "to '$1' option"
      elif [ $# -gt 2 ]; then
        Print_ExtraArgumentsError 1 "to '$1' option"
      fi
      DIST="jessie"
      ARCH="i386"
      Docker_ExecuteShellCommandInContainer \
          "$2" "pbuilder create $(eval echo $PBUILDER_OPT); pbuilder clean"
      ExitCode=$?
      ;;

    -2)
      if [ $# -lt 2 ]; then
        Print_MissingArgumentsError 1 "to '$1' option"
      elif [ $# -gt 2 ]; then
        Print_ExtraArgumentsError 1 "to '$1' option"
      fi
      DIST="jessie"
      ARCH="amd64"
      Docker_ExecuteShellCommandInContainer \
          "$2" "pbuilder create $(eval echo $PBUILDER_OPT); pbuilder clean"
      ExitCode=$?
      ;;

    *)
      echo "Usage: $0 [OPTION]"
      echo "Creates a Docker image used to build Moon Phase on Debian 8."
      echo ""
      echo "  -b              Print base image name."
      echo "  -c              Print stage count."
      echo "  -r              Print image registry name."
      echo "  -0 containerid  Run stage 0 of the build."
      echo "  -1 containerid  Run stage 1 of the build."
      echo "  -2 containerid  Run stage 2 of the build."
      echo ""
      echo "Only one option may be specified per invocation."
      echo ""
      echo "The resulting image will be tagged with name of this script (minus any "
      echo "extension) plus the date (in \"YYYYMMDD\" format)."
      ;;

  esac
fi

exit $ExitCode


#
# debian-8.x86_64.sh
#
