/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2018 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * max sin - cos

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "TransfSinAndCosMaxIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfSinAndCosMaxIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	// Q_UNUSED(aux);

	REAL4 sinZ = z * fractal->transformCommon.constantMultiplierA111;
	REAL4 cosZ = z * fractal->transformCommon.constantMultiplierB111;
	sinZ.x = native_sin(sinZ.x);
	sinZ.y = native_sin(sinZ.y);
	sinZ.z = native_sin(sinZ.z);
	cosZ.x = native_cos(cosZ.x);
	cosZ.y = native_cos(cosZ.y);
	cosZ.z = native_cos(cosZ.z);
	REAL4 sinCosZ = sinZ * cosZ;
	REAL4 maxZ = z;
	maxZ.x = max(max(sinZ.x, cosZ.x), sinCosZ.x);
	maxZ.y = max(max(sinZ.y, cosZ.y), sinCosZ.y);
	maxZ.z = max(max(sinZ.z, cosZ.z), sinCosZ.z);

	if (!fractal->transformCommon.functionEnabledFalse)
	{
		z = maxZ * fractal->transformCommon.scale;
	}
	else
	{
		if (fractal->transformCommon.functionEnabled)
		{
			z += maxZ * fractal->transformCommon.scale;
		}
		else
		{
			// z = maxZ * native_divide(fractal->transformCommon.scale, (fabs(z) + 1.0f));
			z.x = maxZ.x * native_divide(fractal->transformCommon.scale, (fabs(z.x) + 1.0f));
			z.y = maxZ.y * native_divide(fractal->transformCommon.scale, (fabs(z.y) + 1.0f));
			z.z = maxZ.z * native_divide(fractal->transformCommon.scale, (fabs(z.z) + 1.0f));
		}
	}

	if (fractal->analyticDE.enabled) // temp
	{
		if (!fractal->analyticDE.enabledFalse)
			aux->DE = mad(aux->DE, fabs(fractal->transformCommon.scale), 1.0f);
		else
			aux->DE = mad(aux->DE * fabs(fractal->transformCommon.scale), fractal->analyticDE.scale1,
				fractal->analyticDE.offset1);
	}
	return z;
}