/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2018 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * MsltoeToroidal
 * @reference http://www.fractalforums.com/theory/toroidal-coordinates/msg9428/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "MsltoeToroidalIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MsltoeToroidalIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (fractal->transformCommon.functionEnabledFalse) // pre-scale
	{
		z *= fractal->transformCommon.scale3D111;
		aux->DE *= native_divide(length(z), aux->r) + 1.0f;
	}

	// Toroidal bulb
	REAL r1 = fractal->transformCommon.minR05; // default 0.5f
	REAL theta = atan2(z.y, z.x);
	REAL x1 = r1 * native_cos(theta);
	REAL y1 = r1 * native_sin(theta);
	aux->r = mad((z.x - x1), (z.x - x1), (z.y - y1) * (z.y - y1)) + z.z * z.z; //+ 1e-030f
	REAL phi = asin(native_divide(z.z, native_sqrt(aux->r)));
	REAL rp = native_powr(aux->r, fractal->transformCommon.pwr4); // default 4.0f

	phi *= fractal->transformCommon.pwr8; // default 8
	theta *= fractal->bulb.power;					// default 9 gives 8 symmetry
	// convert back to cartesian coordinates
	z.x = (mad(rp, native_cos(phi), r1)) * native_cos(theta);
	z.y = (mad(rp, native_cos(phi), r1)) * native_sin(theta);
	z.z = -rp * native_sin(phi);

	if (!fractal->analyticDE.enabledFalse)
	{ // analytic DE adjustment,default is,  scale1 & offset1 & offset2 = 1.0f
		aux->DE = mad(native_powr(aux->r, fractal->transformCommon.pwr4 - 1.0f) * aux->DE * aux->DE,
			fractal->transformCommon.pwr4, 1.0f);
	}
	else
	{
		aux->DE = mad(native_powr(aux->r, fractal->transformCommon.pwr4 - fractal->analyticDE.offset1)
										* fractal->transformCommon.pwr4 * fractal->analyticDE.scale1 * aux->DE,
			aux->DE, fractal->analyticDE.offset2);
	}

	if (fractal->transformCommon.functionEnabledAxFalse) // spherical offset
	{
		REAL lengthTempZ = -length(z);
		// if (lengthTempZ > -1e-21f) lengthTempZ = -1e-21f;   //  z is neg.)
		z *= 1.0f + native_divide(fractal->transformCommon.offset, lengthTempZ);
		z *= fractal->transformCommon.scale;
		aux->DE = mad(aux->DE, fabs(fractal->transformCommon.scale), 1.0f);
	}
	// then add Cpixel constant vector
	return z;
}