/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import org.jvnet.lafwidget.utils.FadeStateListener;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceRadioButtonUI;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceCheckBoxUI
extends SubstanceRadioButtonUI {
    private static final String propertyPrefix = "CheckBox.";
    protected FadeStateListener substanceFadeStateListener;
    protected PropertyChangeListener substancePropertyListener;
    private static Map<String, Icon> icons = new HashMap<String, Icon>();

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceCheckBoxUI((JToggleButton)b);
    }

    private SubstanceCheckBoxUI(JToggleButton button) {
        super(button);
        button.setRolloverEnabled(true);
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    protected void installListeners(final AbstractButton b) {
        super.installListeners(b);
        this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), null);
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceCheckBoxUI.this.substanceFadeStateListener != null) {
                        SubstanceCheckBoxUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceCheckBoxUI.this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), null);
                    SubstanceCheckBoxUI.this.substanceFadeStateListener.registerListeners();
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void uninstallListeners(AbstractButton b) {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners(b);
    }

    public static synchronized void reset() {
        icons.clear();
    }

    private static synchronized Icon getIcon(JToggleButton button, ComponentState state) {
        SubstanceTheme theme;
        float visibility;
        FadeTracker fadeTracker = FadeTracker.getInstance();
        float f = visibility = state.isSelected() ? 10.0f : 0.0f;
        if (fadeTracker.isTracked(button, FadeTracker.FadeKind.SELECTION)) {
            visibility = fadeTracker.getFade10(button, FadeTracker.FadeKind.SELECTION);
        }
        if (fadeTracker.isTracked(button, FadeTracker.FadeKind.ROLLOVER)) {
            SubstanceTheme defaultTheme = SubstanceCoreUtilities.getDefaultTheme(button, true);
            SubstanceTheme theme2 = theme = SubstanceCoreUtilities.getActiveTheme(button, true);
            float cyclePos = 0.0f;
            if (!state.isSelected() && state.isEnabled()) {
                if (state == ComponentState.DEFAULT) {
                    theme2 = defaultTheme;
                    cyclePos = 10.0f - fadeTracker.getFade10(button, FadeTracker.FadeKind.ROLLOVER);
                } else {
                    theme2 = theme;
                    theme = defaultTheme;
                    cyclePos = fadeTracker.getFade10(button, FadeTracker.FadeKind.ROLLOVER);
                }
                String key = state.name() + ":" + theme.getDisplayName() + ":" + theme2.getDisplayName() + ":" + cyclePos + ":" + visibility;
                Icon result = icons.get(key);
                if (result != null) {
                    return result;
                }
                result = new ImageIcon(SubstanceImageCreator.getCheckBox(button, SubstanceSizeUtils.getCheckBoxMarkSize(), state, theme, theme2, cyclePos, visibility / 10.0f));
                icons.put(key, result);
                return result;
            }
        }
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        theme = SubstanceCoreUtilities.getComponentTheme(button, kind);
        int cyclePos = state.getCycleCount();
        String key = state.name() + ":" + theme.getDisplayName() + ":" + theme.getDisplayName() + ":" + cyclePos + ":" + visibility;
        Icon result = icons.get(key);
        if (result != null) {
            return result;
        }
        result = new ImageIcon(SubstanceImageCreator.getCheckBox(button, SubstanceSizeUtils.getCheckBoxMarkSize(), state, theme, theme, cyclePos, visibility / 10.0f));
        icons.put(key, result);
        return result;
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    public Icon getDefaultIcon() {
        ButtonModel model = this.button.getModel();
        return SubstanceCheckBoxUI.getIcon(this.button, ComponentState.getState(model, this.button));
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceCheckBox: \n");
        sb.append("\t" + icons.size() + " icons");
        return sb.toString();
    }
}

