/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image.codec;

import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGHuffmanTable;
import com.sun.image.codec.jpeg.JPEGQTable;
import java.util.Arrays;

public class JPEGParam
implements JPEGEncodeParam {
    private float quality = 0.75f;
    private int colorID = -1;
    private int width;
    private int height;
    private int numBands;
    private boolean imageInfoValid = false;
    private boolean tableInfoValid = false;
    private JPEGQTable[] qTable = new JPEGQTable[4];
    private JPEGHuffmanTable[] acHuffmanTable = new JPEGHuffmanTable[4];
    private JPEGHuffmanTable[] dcHuffmanTable = new JPEGHuffmanTable[4];
    private int restartInterval = 0;
    private int[] horizontalSubsampleComponents;
    private int[] verticalSubsampleComponents;
    private byte[][][] markers = new byte[16][][];
    private byte[][] commentMarker = null;
    private static int[] components = new int[]{0, 1, 3, 3, 4, 3, 4, 4, 4, 4, 4, 4};
    private int[] qTableComponentMapping;
    private int[] acHuffmanComponentMapping;
    private int[] dcHuffmanComponentMapping;
    private byte APP0_MARKER_NUM_BYTES = (byte)14;

    public JPEGParam(JPEGEncodeParam param) {
        this((JPEGDecodeParam)param);
    }

    public JPEGParam(JPEGDecodeParam param) {
        this(param.getEncodedColorID(), param.getNumComponents());
        int i;
        this.setTableInfoValid(param.isTableInfoValid());
        this.setImageInfoValid(param.isImageInfoValid());
        this.setRestartInterval(param.getRestartInterval());
        for (i = 0; i < 4; ++i) {
            this.qTable[i] = param.getQTable(i);
            this.acHuffmanTable[i] = param.getACHuffmanTable(i);
            this.dcHuffmanTable[i] = param.getDCHuffmanTable(i);
        }
        for (i = 0; i < this.getNumComponents(); ++i) {
            this.setQTableComponentMapping(i, param.getQTableComponentMapping(i));
            this.setACHuffmanComponentMapping(i, param.getACHuffmanComponentMapping(i));
            this.setDCHuffmanComponentMapping(i, param.getDCHuffmanComponentMapping(i));
        }
        for (i = 224; i < 239; ++i) {
            byte[][] markerData = param.getMarkerData(i);
            Object copyMarkerData = null;
            if (markerData != null) {
                copyMarkerData = new byte[markerData.length][];
                for (int j = 0; j < markerData.length; ++j) {
                    copyMarkerData[j] = Arrays.copyOf(markerData[j], markerData[j].length);
                }
            }
            this.setMarkerData(i, (byte[][])copyMarkerData);
        }
        byte[][] commentData = param.getMarkerData(254);
        Object copyCommentData = null;
        if (commentData != null) {
            copyCommentData = new byte[commentData.length][];
            for (int i2 = 0; i2 < commentData.length; ++i2) {
                copyCommentData[i2] = Arrays.copyOf(commentData[i2], commentData[i2].length);
            }
            this.setMarkerData(254, (byte[][])copyCommentData);
        }
    }

    public JPEGParam(int colorID) {
        this(colorID, components[colorID]);
    }

    public JPEGParam(int colorID, int numBands) {
        if (colorID < 0 || colorID >= 12 || colorID != 0 && numBands != components[colorID]) {
            throw new IllegalArgumentException();
        }
        this.colorID = colorID;
        this.numBands = numBands;
        this.initialize();
    }

    private void initialize() {
        this.qTable[0] = JPEGQTable.StdLuminance;
        this.qTable[1] = JPEGQTable.StdChrominance;
        this.acHuffmanTable[0] = JPEGHuffmanTable.StdACLuminance;
        this.acHuffmanTable[1] = JPEGHuffmanTable.StdACChrominance;
        this.dcHuffmanTable[0] = JPEGHuffmanTable.StdDCLuminance;
        this.dcHuffmanTable[1] = JPEGHuffmanTable.StdDCChrominance;
        this.qTableComponentMapping = new int[this.getNumComponents()];
        this.acHuffmanComponentMapping = new int[this.getNumComponents()];
        this.dcHuffmanComponentMapping = new int[this.getNumComponents()];
        this.horizontalSubsampleComponents = new int[this.getNumComponents()];
        this.verticalSubsampleComponents = new int[this.getNumComponents()];
        this.setTableInfoValid(true);
        this.setImageInfoValid(true);
        this.setMarkerData(224, this.arrayAdd(this.getMarkerData(224), this.createAPP0MarkerData()));
    }

    private byte[] createAPP0MarkerData() {
        byte[] data = null;
        switch (this.colorID) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                data = new byte[this.APP0_MARKER_NUM_BYTES];
                data[0] = 74;
                data[1] = 70;
                data[2] = 73;
                data[3] = 70;
                data[4] = 0;
                data[5] = 1;
                data[6] = 2;
                data[7] = 0;
                data[8] = 0;
                data[9] = 1;
                data[10] = 0;
                data[11] = 1;
                data[12] = 0;
                data[13] = 0;
            }
        }
        return data;
    }

    @Override
    public void setQuality(float quality, boolean forceBaseline) {
        if ((double)quality < 0.0) {
            quality = 0.0f;
        } else if ((double)quality > 1.0) {
            quality = 1.0f;
        }
        this.quality = quality;
        quality = 1.0f - quality;
        for (int i = 0; i < 4; ++i) {
            if (this.qTable[i] == null) continue;
            this.qTable[i] = this.qTable[i].getScaledInstance(quality, forceBaseline);
        }
    }

    @Override
    public Object clone() {
        JPEGParam c = new JPEGParam(this);
        return c;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getHorizontalSubsampling(int component) {
        if (component < 0 || component > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.horizontalSubsampleComponents[component];
    }

    @Override
    public int getVerticalSubsampling(int component) {
        if (component < 0 || component > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.verticalSubsampleComponents[component];
    }

    @Override
    public JPEGQTable getQTable(int tableNum) {
        if (tableNum < 0 || tableNum > 4) {
            throw new IllegalArgumentException("tableNum must be [0-3]");
        }
        return this.qTable[tableNum];
    }

    @Override
    public JPEGQTable getQTableForComponent(int component) {
        if (component < 0 || component > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.qTable[this.qTableComponentMapping[component]];
    }

    @Override
    public JPEGHuffmanTable getDCHuffmanTable(int tableNum) {
        if (tableNum < 0 || tableNum > 4) {
            throw new IllegalArgumentException("tableNum must be [0-3]");
        }
        return this.dcHuffmanTable[tableNum];
    }

    @Override
    public JPEGHuffmanTable getDCHuffmanTableForComponent(int component) {
        if (component < 0 || component > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.dcHuffmanTable[this.dcHuffmanComponentMapping[component]];
    }

    @Override
    public JPEGHuffmanTable getACHuffmanTable(int tableNum) {
        if (tableNum < 0 || tableNum > 4) {
            throw new IllegalArgumentException("tableNum must be [0-3]");
        }
        return this.acHuffmanTable[tableNum];
    }

    @Override
    public JPEGHuffmanTable getACHuffmanTableForComponent(int component) {
        if (component < 0 || component > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.acHuffmanTable[this.acHuffmanComponentMapping[component]];
    }

    @Override
    public int getDCHuffmanComponentMapping(int component) {
        if (component < 0 || component > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.dcHuffmanComponentMapping[component];
    }

    @Override
    public int getACHuffmanComponentMapping(int component) {
        if (component < 0 || component > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.acHuffmanComponentMapping[component];
    }

    @Override
    public int getQTableComponentMapping(int component) {
        if (component < 0 || component > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.qTableComponentMapping[component];
    }

    @Override
    public boolean isImageInfoValid() {
        return this.imageInfoValid;
    }

    @Override
    public boolean isTableInfoValid() {
        return this.tableInfoValid;
    }

    @Override
    public boolean getMarker(int marker) {
        byte[][] data = null;
        switch (marker) {
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                data = this.markers[marker - 224];
                break;
            }
            case 254: {
                data = this.commentMarker;
                break;
            }
            default: {
                throw new IllegalArgumentException("Marker provided is invalid");
            }
        }
        return data != null && data.length > 0;
    }

    @Override
    public byte[][] getMarkerData(int marker) {
        byte[][] data = null;
        switch (marker) {
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                data = this.markers[marker - 224];
                break;
            }
            case 254: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Marker provided is invalid");
            }
        }
        return data;
    }

    @Override
    public int getEncodedColorID() {
        return this.colorID;
    }

    @Override
    public int getNumComponents() {
        return this.numBands;
    }

    @Override
    public int getRestartInterval() {
        return this.restartInterval;
    }

    @Override
    public int getDensityUnit() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("APP0 Marker not found.");
        }
        byte[] data = this.getValidAPP0Marker();
        if (data == null) {
            throw new IllegalArgumentException("No valid APP0 Marker found");
        }
        return data[7];
    }

    @Override
    public int getXDensity() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("APP0 Marker not found.");
        }
        byte[] data = this.getValidAPP0Marker();
        if (data == null) {
            throw new IllegalArgumentException("No valid APP0 Marker found");
        }
        int upper = data[8] << 8;
        int lower = data[9] & 0xFF;
        return upper | lower;
    }

    @Override
    public int getYDensity() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("APP0 Marker not found.");
        }
        byte[] data = this.getValidAPP0Marker();
        if (data == null) {
            throw new IllegalArgumentException("No valid APP0 Marker found");
        }
        int upper = data[10] << 8;
        int lower = data[11] & 0xFF;
        return upper | lower;
    }

    @Override
    public void setHorizontalSubsampling(int component, int subsample) {
        if (component < 0 || component > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        this.horizontalSubsampleComponents[component] = subsample;
    }

    @Override
    public void setVerticalSubsampling(int component, int subsample) {
        if (component < 0 || component > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        this.verticalSubsampleComponents[component] = subsample;
    }

    @Override
    public void setQTable(int tableNum, JPEGQTable qTable) {
        if (tableNum < 0 || tableNum > 4) {
            throw new IllegalArgumentException("tableNum must be [0-3]");
        }
        this.qTable[tableNum] = qTable;
    }

    @Override
    public void setDCHuffmanTable(int tableNum, JPEGHuffmanTable huffTable) {
        if (tableNum < 0 || tableNum > 4) {
            throw new IllegalArgumentException("tableNum must be [0-3]");
        }
        this.dcHuffmanTable[tableNum] = huffTable;
    }

    @Override
    public void setACHuffmanTable(int tableNum, JPEGHuffmanTable huffTable) {
        if (tableNum < 0 || tableNum > 4) {
            throw new IllegalArgumentException("tableNum must be [0-3]");
        }
        this.acHuffmanTable[tableNum] = huffTable;
    }

    @Override
    public void setACHuffmanComponentMapping(int component, int table) {
        if (component < 0 || component > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component specified.");
        }
        if (table < 0 || table > 4) {
            throw new IllegalArgumentException("Invalid table specified");
        }
        this.acHuffmanComponentMapping[component] = table;
    }

    @Override
    public void setDCHuffmanComponentMapping(int component, int table) {
        if (component < 0 || component > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component specified.");
        }
        if (table < 0 || table > 4) {
            throw new IllegalArgumentException("Invalid table specified");
        }
        this.dcHuffmanComponentMapping[component] = table;
    }

    @Override
    public void setQTableComponentMapping(int component, int table) {
        if (component < 0 || component > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component specified.");
        }
        if (table < 0 || table > 4) {
            throw new IllegalArgumentException("Invalid table specified");
        }
        this.qTableComponentMapping[component] = table;
    }

    @Override
    public void setImageInfoValid(boolean flag) {
        this.imageInfoValid = flag;
    }

    @Override
    public void setTableInfoValid(boolean flag) {
        this.tableInfoValid = flag;
    }

    @Override
    public void setMarkerData(int marker, byte[][] data) {
        if (data == null) {
            return;
        }
        switch (marker) {
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                this.markers[marker - 224] = data;
                break;
            }
            case 254: {
                this.commentMarker = data;
                break;
            }
            default: {
                throw new IllegalArgumentException("Marker provided is invalid");
            }
        }
    }

    @Override
    public void addMarkerData(int marker, byte[] data) {
        if (data == null) {
            return;
        }
        switch (marker) {
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                this.markers[marker - 224] = this.arrayAdd(this.markers[marker - 224], data);
                break;
            }
            case 254: {
                this.commentMarker = this.arrayAdd(this.commentMarker, data);
                break;
            }
            default: {
                throw new IllegalArgumentException("Marker provided is invalid");
            }
        }
    }

    @Override
    public void setRestartInterval(int restartInterval) {
        this.restartInterval = restartInterval;
    }

    @Override
    public void setDensityUnit(int unit) {
        if (unit < 0 || unit > 3) {
            throw new IllegalArgumentException("Invalid density unit.");
        }
        byte[] data = this.getValidAPP0Marker();
        if (data == null) {
            data = this.createAPP0MarkerData();
            this.markers[0] = this.arrayAdd(this.markers[0], data);
        }
        data[7] = (byte)unit;
    }

    @Override
    public void setXDensity(int density) {
        byte[] data = this.getValidAPP0Marker();
        if (data == null) {
            data = this.createAPP0MarkerData();
            this.markers[0] = this.arrayAdd(this.markers[0], data);
        }
        byte upper = (byte)(density >>> 8 & 0xFF);
        byte lower = (byte)(density & 0xFF);
        data[8] = upper;
        data[9] = lower;
    }

    @Override
    public void setYDensity(int density) {
        byte[] data = this.getValidAPP0Marker();
        if (data == null) {
            data = this.createAPP0MarkerData();
            this.markers[0] = this.arrayAdd(this.markers[0], data);
        }
        byte upper = (byte)(density >>> 8 & 0xFF);
        byte lower = (byte)(density & 0xFF);
        data[10] = upper;
        data[11] = lower;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public float getQuality() {
        return this.quality;
    }

    private byte[][] arrayAdd(byte[][] origArr, byte[] newArr) {
        Object newData;
        if (origArr != null) {
            newData = (byte[][])Arrays.copyOf(origArr, origArr.length + 1);
            newData[origArr.length] = Arrays.copyOf(newArr, newArr.length);
        } else {
            newData = new byte[][]{Arrays.copyOf(newArr, newArr.length)};
        }
        return newData;
    }

    private byte[] getValidAPP0Marker() {
        byte[][] app0Markers = this.getMarkerData(224);
        for (int i = 0; i < app0Markers.length; ++i) {
            byte[] data = app0Markers[i];
            if (data[0] != 74 || data[1] != 70 || data[2] != 73 || data[3] != 70 || data[4] != 0 || data[5] > 1) continue;
            return data;
        }
        return null;
    }
}

