/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.FadeStateListener;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceButtonBorder;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.utils.ButtonBackgroundDelegate;
import org.jvnet.substance.utils.ButtonColorDelegate;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceToggleButtonUI
extends BasicToggleButtonUI {
    private ButtonBackgroundDelegate delegate = new ButtonBackgroundDelegate();
    private RolloverButtonListener substanceButtonListener;
    protected PropertyChangeListener substancePropertyListener;
    protected FadeStateListener substanceFadeStateListener;

    public static ComponentUI createUI(JComponent b) {
        ((AbstractButton)b).setRolloverEnabled(true);
        return new SubstanceToggleButtonUI();
    }

    public void installDefaults(AbstractButton b) {
        Color fg;
        super.installDefaults(b);
        if (b.getClientProperty("substancelaf.buttonborderoriginal") == null) {
            b.putClientProperty("substancelaf.buttonborderoriginal", b.getBorder());
        }
        if (b.getClientProperty("substancelaf.buttonborderoriginal") == null) {
            b.putClientProperty("substancelaf.buttonborderoriginal", b.getBorder());
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(b);
        if (b.getClientProperty("substancelaf.buttonbordercomputed") == null) {
            b.setBorder(shaper.getButtonBorder(b));
        } else {
            Border currBorder = b.getBorder();
            if (!(currBorder instanceof SubstanceButtonBorder)) {
                b.setBorder(shaper.getButtonBorder(b));
            } else {
                SubstanceButtonBorder sbCurrBorder = (SubstanceButtonBorder)currBorder;
                if (shaper.getClass() != sbCurrBorder.getButtonShaperClass()) {
                    b.setBorder(shaper.getButtonBorder(b));
                }
            }
        }
        b.putClientProperty("substancelaf.buttonopacityoriginal", b.isOpaque());
        b.setOpaque(false);
        Color bg = b.getBackground();
        if (bg instanceof UIResource) {
            b.setBackground(new ButtonColorDelegate(b, false));
        }
        if ((fg = b.getForeground()) instanceof UIResource) {
            b.setForeground(new ButtonColorDelegate(b, true));
        }
    }

    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setBorder((Border)b.getClientProperty("substancelaf.buttonborderoriginal"));
        b.setOpaque((Boolean)b.getClientProperty("substancelaf.buttonopacityoriginal"));
        b.putClientProperty("substancelaf.buttonopacityoriginal", null);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return null;
    }

    protected void installListeners(final AbstractButton b) {
        super.installListeners(b);
        this.substanceButtonListener = new RolloverButtonListener(b);
        b.addMouseListener(this.substanceButtonListener);
        b.addMouseMotionListener(this.substanceButtonListener);
        b.addFocusListener(this.substanceButtonListener);
        b.addPropertyChangeListener(this.substanceButtonListener);
        b.addChangeListener(this.substanceButtonListener);
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.buttonShaper".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SwingUtilities.updateComponentTreeUI(b);
                        }
                    });
                }
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceToggleButtonUI.this.substanceFadeStateListener != null) {
                        SubstanceToggleButtonUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceToggleButtonUI.this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), null);
                    SubstanceToggleButtonUI.this.substanceFadeStateListener.registerListeners();
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), null);
        this.substanceFadeStateListener.registerListeners();
    }

    protected void uninstallListeners(AbstractButton b) {
        b.removeMouseListener(this.substanceButtonListener);
        b.removeMouseMotionListener(this.substanceButtonListener);
        b.removeFocusListener(this.substanceButtonListener);
        b.removePropertyChangeListener(this.substanceButtonListener);
        b.removeChangeListener(this.substanceButtonListener);
        this.substanceButtonListener = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        super.uninstallListeners(b);
    }

    public void update(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        this.delegate.updateBackground(g, button);
        this.paint(g, c);
        AbstractButton b = (AbstractButton)c;
        FontMetrics fm = c.getFontMetrics(c.getFont());
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (!(b.hasFocus() && b.isFocusPainted() || !FadeTracker.getInstance().isTracked(c, FadeTracker.FadeKind.FOCUS))) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }

    public Dimension getPreferredSize(JComponent c) {
        AbstractButton button = (AbstractButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        return shaper.getPreferredSize(button, super.getPreferredSize(button));
    }

    public boolean contains(JComponent c, int x, int y) {
        return ButtonBackgroundDelegate.contains((JToggleButton)c, x, y);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!b.isFocusPainted()) {
            return;
        }
        SubstanceCoreUtilities.paintFocus(g, b, b, textRect, 1.0f, 2 + SubstanceSizeUtils.getExtraPadding());
    }

    protected void paintIcon(Graphics g, AbstractButton b, Rectangle iconRect) {
        Graphics2D graphics = (Graphics2D)g.create();
        FadeTracker fadeTracker = FadeTracker.getInstance();
        Icon icon = SubstanceCoreUtilities.getIcon(b, false);
        graphics.setComposite(TransitionLayout.getAlphaComposite(b));
        if (fadeTracker.isTracked(b, FadeTracker.FadeKind.ROLLOVER)) {
            ComponentState state = ComponentState.getState(b.getModel(), b);
            if (state.isRollover()) {
                SubstanceCoreUtilities.getIcon(b, true).paintIcon(b, graphics, iconRect.x, iconRect.y);
                graphics.setComposite(TransitionLayout.getAlphaComposite((Component)b, fadeTracker.getFade10(b, FadeTracker.FadeKind.ROLLOVER) / 10.0f));
                icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
            } else {
                icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
                graphics.setComposite(TransitionLayout.getAlphaComposite((Component)b, fadeTracker.getFade10(b, FadeTracker.FadeKind.ROLLOVER) / 10.0f));
                b.getIcon().paintIcon(b, graphics, iconRect.x, iconRect.y);
            }
        } else {
            icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
        }
        graphics.dispose();
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        SubstanceCoreUtilities.paintText(g, (AbstractButton)c, textRect, text, this.getTextShiftOffset(), this.getPropertyPrefix());
    }
}

