#include <config.h>

// This file contains pixmap versions of icons from the Tango base icon
// theme:  http://tango.freedesktop.org/Tango_Desktop_Project
//
// Licensed under the Creative Commons Attribution Share-Alike license:
// http://creativecommons.org/licenses/by-sa/2.5/

// ---------------------------------------------------------------------
// Tango icons
// ---------------------------------------------------------------------

/* XPM */
const char *address_book_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 124 2",
"   c #727E0A",
".  c #785977",
"X  c #CC0000",
"o  c #EF2929",
"O  c #698373",
"+  c #67837F",
"@  c #9DB029",
"#  c #EDD400",
"$  c #A2AB7B",
"%  c #FCE94F",
"&  c #6F6384",
"*  c #617296",
"=  c #5A7AA4",
"-  c #6C7CA0",
";  c #7A88A7",
":  c #7B8AA8",
">  c #7E8CA8",
",  c #7E8CAB",
"<  c #8F9E86",
"1  c #99A580",
"2  c #808DA9",
"3  c #808DAA",
"4  c #818FAB",
"5  c #828EAA",
"6  c #8290AC",
"7  c #8390AC",
"8  c #8B96AE",
"9  c #8F9FB8",
"0  c #9E9DBF",
"q  c #AB82AA",
"w  c #AA83AB",
"e  c #AC80A8",
"r  c #AC80A9",
"t  c #AC82AA",
"y  c #AA84AC",
"u  c #AA85AC",
"i  c #A986AD",
"p  c #A887AE",
"a  c #A987AE",
"s  c #A889AF",
"d  c #A789B0",
"f  c #A78AB1",
"g  c #A78BB1",
"h  c #A58DB3",
"j  c #A889B0",
"k  c #AC8BB1",
"l  c #A491B6",
"z  c #AB92B6",
"x  c #A7ADBD",
"c  c #A9ACB8",
"v  c #A8AEBC",
"b  c #ABB0BE",
"n  c #ABB1BE",
"m  c #ACB1BE",
"M  c #B5B5B6",
"N  c #B7B7B7",
"B  c #B9B9B9",
"V  c #9E9DC0",
"C  c #9D9EC0",
"Z  c #9D9FC1",
"A  c #9BA2C3",
"S  c #9CA1C3",
"D  c #9CA2C3",
"F  c #9BA3C4",
"G  c #9AA4C5",
"H  c #9AA5C5",
"J  c #99A7C7",
"K  c #9AA6C6",
"L  c #9FABC3",
"P  c #95AFCD",
"I  c #96AECC",
"U  c #95AFCE",
"Y  c #95B0CE",
"T  c #95B1CF",
"R  c #9DB7D2",
"E  c #AAACC9",
"W  c #AFB5C2",
"Q  c #A9B3CF",
"!  c #AFBAC9",
"~  c #B4B9C4",
"^  c #A5BDD7",
"/  c #A8B8D0",
"(  c #A9B8D0",
")  c #A9B9D0",
"_  c #A9B9D1",
"`  c #A7BFD8",
"'  c #A8BFD8",
"]  c #A9C1D9",
"[  c #ACC3DA",
"{  c #B1C0D6",
"}  c #B4C9DE",
"|  c #BCC8D9",
" . c #B7CAE0",
".. c #B7CBE0",
"X. c #B8CBE0",
"o. c #B9CBE0",
"O. c #BACDE2",
"+. c #BFCCE0",
"@. c #C1C1C3",
"#. c #DDDDDD",
"$. c #DEDEDE",
"%. c #C3CFE0",
"&. c #C3D0E2",
"*. c #C0D2E4",
"=. c #C6D6E7",
"-. c #CBD7E5",
";. c #CBD8E7",
":. c #C7D7E8",
">. c #CEDAE8",
",. c #CEDBE8",
"<. c #CEDBE9",
"1. c #CFDBE9",
"2. c #CCDAEA",
"3. c #CFDCE9",
"4. c #CFDCEA",
"5. c #CFDCEC",
"6. c #D0DCEA",
"7. c #D1DEEB",
"8. c #D2DEEB",
"9. c #D3DFEC",
"0. c #D7E3F0",
"q. c #D7E4F0",
"w. c #D8E4F1",
"e. c None",
/* pixels */
"e.= = = = = = = = = = = = = e.e.",
"= - 8.=.O.} ^ ^ ` ` ' ' R < # e.",
"= | 6.&.5.] G d r u V T [ < % # ",
"= %.4.{ 2.Q y F U J p A [ 1 % # ",
"= -.3./ 2.z Z 0 q w J f [ $ % # ",
"= 7.1./ 2.t I y C i P r [ O @   ",
"= 0.<.( 2.r P r S a D s [ O @   ",
"= w.,.) 2.k G l j h y K [ + @   ",
"= w.,._ 2.E p J Y T T T [ & o X ",
"= q.>.+.2.] H g e i T T [ & o X ",
"= 0.9.5.:.*. .....X.X.X.o.& o X ",
"= ;., 5 2 > ; : 4 6 7 3 * . X e.",
"= L M N N N N N N N B ! = = e.e.",
"= 9 @.#.#.#.#.#.$.$.$.~ = = e.e.",
"= = 8 x W b b n n m m v c = e.e.",
"e.= = = = = = = = = = = = = e.e."
};

/* XPM */
const char *edit_undo_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 61 1",
"  c #BB9F15",
". c #BEA113",
"X c #BCA114",
"o c #BCA015",
"O c #BDA116",
"+ c #BBA11B",
"@ c #BFA31B",
"# c #C4A000",
"$ c #C4A901",
"% c #C8AC02",
"& c #CBAA0E",
"* c #C2A211",
"= c #C1A313",
"- c #C2A611",
"; c #C1A314",
": c #C1A319",
"> c #C0A41A",
", c #C5AB1B",
"< c #C0A623",
"1 c #D6C004",
"2 c #DAC304",
"3 c #D8C207",
"4 c #DFC80A",
"5 c #DFC80B",
"6 c #DFC90F",
"7 c #F7DD05",
"8 c #E3CD16",
"9 c #E8D21D",
"0 c #F1DB29",
"q c #F4DF2C",
"w c #ECD936",
"e c #FAE320",
"r c #FBE425",
"t c #F5E02F",
"y c #F6E02F",
"u c #F6E131",
"i c #F7E232",
"p c #F8E232",
"a c #D8C543",
"s c #DBC443",
"d c #E1CD40",
"f c #E3CE41",
"g c #E9DA5D",
"h c #EADB66",
"j c #EBDC6F",
"k c #EEE16E",
"l c #F2E469",
"z c #F3E56A",
"x c #F6E769",
"c c #F5E66D",
"v c #F7E86C",
"b c #F7E86E",
"n c #F9EA69",
"m c #FAEB6F",
"M c #EFE276",
"N c #FAEC73",
"B c #FBED76",
"V c #FBED79",
"C c #F2E788",
"Z c #FBF3AD",
"A c None",
/* pixels */
"AAAAAA#AAAAAAAAA",
"AAAAA##AAAAAAAAA",
"AAAA#Z#AAAAAAAAA",
"AAA#Zr##. +AAAAA",
"AA#ZueNmbvX;AAAA",
"A#Zyi0t08wxf=AAA",
"#Zypiit0999wdOAA",
"A#Vpq1119995z,oA",
"AA#B2Bnnnn743j@A",
"AAA#BB####$k6l>A",
"AAAA#B#AAAA#cM:A",
"AAAAA##AAAAA%C*A",
"AAAAAA#AAAAA&g<A",
"AAAAAAAAAAAAsaAA",
"AAAAAAAAAAAAh-AA",
"AAAAAAAAAAAAAAAA"
};

/* XPM */
const char *edit_select_all_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 37 1",
"  c #000000",
". c #888A85",
"X c #8B8D88",
"o c #8B8D89",
"O c #8C8E89",
"+ c #8D8F8A",
"@ c #8197AF",
"# c #8298B0",
"$ c #A8BED6",
"% c #A9BFD7",
"& c #AAC0D8",
"* c #ABC1D9",
"= c #ACC2DA",
"- c #ADC3DB",
"; c #AEC4DC",
": c #AFC5DD",
"> c #B0C6DE",
", c #B1C7DF",
"< c #B2C8E0",
"1 c #B3C9E1",
"2 c #EBEBEB",
"3 c #ECECEC",
"4 c #EEEEEE",
"5 c #F0F0F0",
"6 c #F2F2F2",
"7 c #F4F4F4",
"8 c #F5F5F5",
"9 c #F6F6F6",
"0 c #F7F7F7",
"q c #F8F8F8",
"w c #F9F9F9",
"e c #FAFAFA",
"r c #FBFBFB",
"t c #FCFCFC",
"y c #FDFDFD",
"u c #FEFEFE",
"i c None",
/* pixels */
"io............Oi",
"i.yuuyyttrreewXi",
"i.y$%%&&*****qXi",
"i.u%@@@@=@@@=qXi",
"i.y&@@@@-----qXi",
"i.y&@@@@-;;;2qXi",
"i.t*@@@@;@@:3qXi",
"i.t==-;::>>>4qXi",
"i.t=-;::>>,,5qXi",
"i.r=@@@@@@@<60Xi",
"i.r-;:>> < 170Xi",
"i.e-;:>,< 8990Xi",
"i.w-####< 0q00Xi",
"i.w-;:>,< 0wq0Xi",
"i.qqqqqq q qqqXi",
"iO............+i"
};

/* XPM */
const char *edit_clear_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 108 2",
"   c #7B4A00",
".  c #7C4B00",
"X  c #AB1B0D",
"o  c #A12400",
"O  c #A03600",
"+  c #B8381D",
"@  c #804E01",
"#  c #845201",
"$  c #865203",
"%  c #AD4213",
"&  c #876400",
"*  c #A6690A",
"=  c #A96B0A",
"-  c #AB6D0B",
";  c #B2760B",
":  c #B2720C",
">  c #BC7A0F",
",  c #B06917",
"<  c #BB4A28",
"1  c #C17D10",
"2  c #C86D33",
"3  c #9A8500",
"4  c #9C8800",
"5  c #9C8B00",
"6  c #9D8C00",
"7  c #9E8D00",
"8  c #9F8D00",
"9  c #9E8D01",
"0  c #9F8D01",
"q  c #9F8E00",
"w  c #9F8E01",
"e  c #9F8E04",
"r  c #9F8F05",
"t  c #A18801",
"y  c #A08E01",
"u  c #A08F01",
"i  c #A08F05",
"p  c #A19008",
"a  c #A29009",
"s  c #A59411",
"d  c #AB9B1A",
"f  c #AE9E1B",
"g  c #B1A01D",
"h  c #BBA529",
"j  c #BEAE32",
"k  c #C0B02F",
"l  c #C6B530",
"z  c #C5B432",
"x  c #C6B633",
"c  c #C5B536",
"v  c #DAC203",
"b  c #DBC304",
"n  c #DCC407",
"m  c #DCC510",
"M  c #DCC610",
"N  c #DCC615",
"B  c #E3CB11",
"V  c #E5CD14",
"C  c #E7D018",
"Z  c #DFCA26",
"A  c #EED723",
"S  c #F3DB2A",
"D  c #F6DE2F",
"F  c #FBE437",
"G  c #FCE53C",
"H  c #FDE63C",
"J  c #CDBD41",
"K  c #CCBD43",
"L  c #CDBE45",
"P  c #D7B162",
"I  c #CFC149",
"U  c #D2C34F",
"Y  c #D8C84F",
"T  c #D6C856",
"R  c #DCCD58",
"E  c #DDCF5E",
"W  c #EDDA46",
"Q  c #E4D249",
"!  c #E4D34C",
"~  c #E5D44E",
"^  c #E6D656",
"/  c #E1D35B",
"(  c #E7D75B",
")  c #E7D85F",
"_  c #FBE544",
"`  c #FDE952",
"'  c #FDEA5F",
"]  c #E2D467",
"[  c #E7D96D",
"{  c #ECDC68",
"}  c #E8DA6C",
"|  c #F6D861",
" . c #EADC72",
".. c #EBDD77",
"X. c #EBDE77",
"o. c #F3E365",
"O. c #FDEB61",
"+. c #FDEA63",
"@. c #FDEC6B",
"#. c #FDEB6C",
"$. c #FDEC6D",
"%. c #FDEE7D",
"&. c #FBEA84",
"*. c #FDEF84",
"=. c #F8EA88",
"-. c #FBED8B",
";. c #FDEF8A",
":. c None",
/* pixels */
":..   :.:.:.:.:.:.:.:.:.:.:.:.:.",
"  * -   :.:.:.:.:.:.:.:.:.:.:.:.",
"  : 1 =   :.5 :.:.:.:.:.:.:.:.:.",
":.$ > 1 # 3 5 :.:.:.:.:.:.:.:.:.",
":.  @ ; t j g :.:.:.:.:.:.:.:.:.",
":.:.& 4 J X., O u :.:.:.:.:.:.:.",
":.:.9 Y { 2 X P  .K a w :.:.:.:.",
":.:.7 h < + | +.#.%.=.L r q :.:.",
":.:.:.o % &.@.*.$.` _ o...I f 6 ",
":.:.:.:.k ;.' O.` H S C M Q ] 0 ",
":.:.:.:.s -.G F D A V b v ^ x q ",
":.:.:.:.y E W C B n v v ! R e :.",
":.:.:.:.:.d } m v v N ( T i :.:.",
":.:.:.:.:.q c ) Z ~ [ z 7 :.:.:.",
":.:.:.:.:.:.7 U / l p 8 :.:.:.:.",
":.:.:.:.:.:.:.6 7 7 :.:.:.:.:.:."
};

/* XPM */
const char *edit_copy_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 27 1",
"  c #888A85",
". c #898B86",
"X c #8A8C87",
"o c #8C8E89",
"O c #8D8F8A",
"+ c #989A95",
"@ c #989A96",
"# c #9A9B97",
"$ c #C3C4C3",
"% c #C7C7C6",
"& c #D4D4D4",
"* c #E3E3E2",
"= c #E3E4E2",
"- c #EEEEEE",
"; c #F0F0EF",
": c #F3F3F3",
"> c #F4F4F4",
", c #F6F6F5",
"< c #F7F7F6",
"1 c #F8F8F7",
"2 c #FAFAF9",
"3 c #FAFAFA",
"4 c #FBFBFB",
"5 c #FCFCFB",
"6 c #FEFEFD",
"7 c #FFFFFF",
"8 c None",
/* pixels */
"8888888888888888",
"8888888888888888",
"8888888888888888",
"8888#          O",
"8888X7777777777 ",
"8888.7;;;;;;;;7 ",
"8888X7;%%%%%%;7 ",
"8888.7;;;;;;;;7 ",
"8888X7;%%%%%;;7 ",
"8888.7;;;;;;;3: ",
"8888X7;%%%%%-<$ ",
"8888X7;;;;;oooo ",
"8888.6;;;;3+31= ",
"8888.2;;;33+3*  ",
"8888.><,54&@= 88",
"8888o.       888"
};

/* XPM */
const char *edit_cut_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 88 1",
"  c #A60101",
". c #A60202",
"X c #A40502",
"o c #A60606",
"O c #A70606",
"+ c #A80303",
"@ c #A80403",
"# c #A80606",
"$ c #A80707",
"% c #A90707",
"& c #AA0808",
"* c #AA0909",
"= c #A90A0A",
"- c #A90B0B",
"; c #AA0B0B",
": c #AA0C0C",
"> c #AA0D0D",
", c #AB0D0D",
"< c #AA0E0E",
"1 c #B50B0B",
"2 c #B70F0E",
"3 c #B80D0D",
"4 c #AB1010",
"5 c #AB1111",
"6 c #AB1313",
"7 c #AB1414",
"8 c #AB1616",
"9 c #AD1717",
"0 c #AE1818",
"q c #9C2F2C",
"w c #C01513",
"e c #C01514",
"r c #C71A19",
"t c #C91A1A",
"y c #CA1B1A",
"u c #CB1F1F",
"i c #CD1D1C",
"p c #CD1D1D",
"a c #CE1D1D",
"s c #CF1D1D",
"d c #CE1E1E",
"f c #D01F1F",
"g c #D11F1F",
"h c #D12020",
"j c #D22020",
"k c #D32121",
"l c #D42222",
"z c #D52323",
"x c #D62323",
"c c #DB2727",
"v c #A34A45",
"b c #898984",
"n c #8A8C87",
"m c #8B8D88",
"M c #8C8E89",
"N c #8D8F8A",
"B c #8E908B",
"V c #8F918C",
"C c #90918D",
"Z c #91938E",
"A c #92948F",
"S c #939590",
"D c #9A9C97",
"F c #9FA09C",
"G c #A8A9A5",
"H c #AAACA7",
"J c #AEAFAB",
"K c #B3B2AF",
"L c #B3B5B0",
"P c #B5B6B2",
"I c #B5B6B3",
"U c #B6B8B3",
"Y c #B8BAB5",
"T c #BABBB7",
"R c #C5C6C3",
"E c #C6C8C3",
"W c #CCCEC9",
"Q c #CDCECB",
"! c #D2D3D0",
"~ c #D2D4D0",
"^ c #DBDCD9",
"/ c #E1E1DF",
"( c #E7E8E6",
") c #EFF0EF",
"_ c #F5F6F5",
"` c #F7F7F6",
"' c #F7F7F7",
"] c None",
/* pixels */
"]]]]mS]]]]mV]]]]",
"]]]B'm]]]]C!V]]]",
"]]]m~)A]]]HEN]]]",
"]]]NL`m]]BWJm]]]",
"]]]]m^)ZMUQm]]]]",
"]]]]NP'mFIYm]]]]",
"]]]]]m/_DGm]]]]]",
"]]]]]NT(HBn]]]]]",
"]]]]]]bRKq]]]]]]",
"]]]]08ov.r90]]]]",
"]]]%jd2X@thu=]]]",
"]]#f+e ]]iw+pO]]",
"]7z]]a=]]+y]]h7]",
"],s]1k:]]*x3]g5]",
"]6cfa$]]]]&lsa6]",
"]]<48]]]]]]>;-]]"
};

/* XPM */
const char *edit_paste_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 77 1",
"  c #6A4200",
". c #6B4301",
"X c #6C4301",
"o c #6B4403",
"O c #6C4401",
"+ c #6D4401",
"@ c #6E4502",
"# c #6E4602",
"$ c #6F4602",
"% c #5C5C5B",
"& c #5C5C5C",
"* c #5E5E5E",
"= c #5F5F5E",
"- c #666864",
"; c #676964",
": c #6E6C64",
"> c #6E6D64",
", c #6A6C68",
"< c #706D63",
"1 c #706D64",
"2 c #716F64",
"3 c #736F64",
"4 c #7E7E7B",
"5 c #7F7F7C",
"6 c #B37B22",
"7 c #B97F23",
"8 c #BA7F23",
"9 c #A77D3B",
"0 c #A37C3D",
"q c #A47E3E",
"w c #A17C40",
"e c #C08424",
"r c #C58726",
"t c #C58727",
"y c #C68827",
"u c #C28628",
"i c #80807D",
"p c #959589",
"a c #97978A",
"s c #B1B2B2",
"d c #B2B4B4",
"f c #B3B5B5",
"g c #B7B7B4",
"h c #B8B9B5",
"j c #B9B9B6",
"k c #B9BAB6",
"l c #BBBBBB",
"z c #C1C2BE",
"x c #CCCDCA",
"c c #CDCECB",
"v c #D8D8D5",
"b c #D9D9D6",
"n c #DADAD8",
"m c #DBDBD9",
"M c #E0E0E0",
"N c #E7E7E4",
"B c #E7E7E5",
"V c #E8E8E6",
"C c #E9E9E7",
"Z c #EAEAE8",
"A c #EBEBE9",
"S c #EBEBEA",
"D c #ECECEA",
"F c #ECECEB",
"G c #EDEDEB",
"H c #EDEDEC",
"J c #EDEEED",
"K c #EEEEED",
"L c #EFEFED",
"P c #EFEFEE",
"I c #F0F0EF",
"U c #F1F1F1",
"Y c #F2F2F2",
"T c #FEFEFD",
"R c #FEFEFE",
"E c #FFFFFF",
"W c None",
/* pixels */
"WWWWW=&&&&=WWWWW",
"WW+Oo%paap%oOOWW",
"W+eq1*5ii4*:w7XW",
"W$y2UMllllMY>t W",
"W$y-EIIIIIIE;u W",
"W$r-EIffffPE;u W",
"W$r-EIIIILGE;u W",
"W#r-EIffdsZE;u W",
"W#r-EIPHSZmE;u W",
"W#r-EKFACnxE;u W",
"W#r-EDZVckhE;u W",
"W@r-ECBbjEEE;u W",
"W@r-ENvzgEE;tu W",
"W@r<JRRRPT;ttt W",
"WX893,,,,,0006.W",
"WWXOOOOOOOOOO.WW"
};

/* XPM */
const char *file_open_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 69 1",
"  c #555753",
". c #595B57",
"X c #5D5F5B",
"o c #61635F",
"O c #455D79",
"+ c #636561",
"@ c #676965",
"# c #6A6C68",
"$ c #6D6F6B",
"% c #3F6086",
"& c #3E6089",
"* c #3465A4",
"= c #436B9D",
"- c #537196",
"; c #58769B",
": c #617A9A",
"> c #6395CC",
", c #6496CC",
"< c #6597CC",
"1 c #6598CD",
"2 c #6698CC",
"3 c #6898CD",
"4 c #6899CD",
"5 c #6999CD",
"6 c #6A9ACD",
"7 c #6B9ACD",
"8 c #6B9BCD",
"9 c #6A9ACE",
"0 c #6C9BCE",
"q c #6D9CCE",
"w c #6E9CCE",
"e c #6E9DCE",
"r c #709DCF",
"t c #709ECE",
"y c #729FCF",
"u c #76A2D0",
"i c #7CA6D2",
"p c #969795",
"a c #969992",
"s c #9A9C98",
"d c #A6A6A6",
"f c #A7A9A4",
"g c #A9ABA9",
"h c #C0C0BF",
"j c #81A9D4",
"k c #85ACD5",
"l c #88AED6",
"z c #89AED6",
"x c #89AFD7",
"c c #8AAFD7",
"v c #8BB0D7",
"b c #8CB1D8",
"n c #94B6DB",
"m c #9BBBDD",
"M c #9ABADE",
"N c #9CBBDD",
"B c #A6C2E0",
"V c #ADC7E3",
"C c #AEC7E3",
"Z c #BED2E8",
"A c #C6C6C5",
"S c #C9C9C9",
"D c #CCCCCA",
"F c #CECECE",
"G c #D8D8D7",
"H c #C6D8EB",
"J c #F5F5F4",
"K c #FFFFFF",
"L c None",
/* pixels */
"L$$$$$@@LLLLLLLL",
"$FFFFFFA+LLLLLLL",
"#hppsfffffffffaL",
"@SddfKKKKKKKKKfL",
"ohppfKJJJJJJJKfL",
"XSddfKJDDDDDJKfL",
"XhppfKJJJJJJJKfL",
".SddfKJDDDGJJKfL",
" h:************=",
" S*HZZZZZZZZZZH*",
" h*CbbbbbbbbbzB*",
" S*VvbvclkjiuyN*",
" h;mtrewq08954n*",
" gx8765321<,>M-O",
"&*************%L",
"LLLLLLLLLLLLLLLL"
};

/* XPM */
const char *format_indent_more_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 68 1",
"  c #555753",
". c #61635F",
"X c #797B78",
"o c #7A7B78",
"O c #7A7C78",
"+ c #888A85",
"@ c #8B8D88",
"# c #8C8E8A",
"$ c #8D8F8A",
"% c #929391",
"& c #929491",
"* c #939491",
"= c #939492",
"- c #939592",
"; c #ABACAA",
": c #ACADAA",
"> c #ACADAB",
", c #ADAEAB",
"< c #C5C5C3",
"1 c #C5C6C4",
"2 c #C5C7C4",
"3 c #C7C7C5",
"4 c #C7C7C6",
"5 c #D2D2D0",
"6 c #D2D3D0",
"7 c #D2D2D1",
"8 c #D2D3D1",
"9 c #D3D4D2",
"0 c #D4D5D3",
"q c #D6D6D4",
"w c #D6D7D5",
"e c #DBDBD9",
"r c #E0E1E0",
"t c #E7E7E7",
"y c #EDEDEC",
"u c #EEEDEC",
"i c #EEEEED",
"p c #EFEEED",
"a c #EEEEEE",
"s c #EFEEEE",
"d c #EFEFEE",
"f c #F0F0EF",
"g c #F1F1F1",
"h c #F2F1F0",
"j c #F2F1F1",
"k c #F2F2F0",
"l c #F2F2F1",
"z c #F3F2F1",
"x c #F3F2F2",
"c c #F3F3F2",
"v c #F4F3F2",
"b c #F4F3F3",
"n c #F4F4F3",
"m c #F4F4F4",
"M c #F5F4F4",
"N c #F4F5F4",
"B c #F5F5F4",
"V c #F5F6F4",
"C c #F5F6F5",
"Z c #F6F6F5",
"A c #F7F6F5",
"S c #F7F6F6",
"D c #F7F7F6",
"F c #F7F8F6",
"G c #F8F8F7",
"H c #FEFEFE",
"J c #FFFFFF",
"K c None",
/* pixels */
"K$++++++++++++$K",
"K+JJJJJJJJJJJJ@K",
"K+JGGGGGFAZCBH@K",
"K+JGGGG@@@@@MH@K",
"K+JGGGDeZVmnnH@K",
"K+JGGDZ.wNnbxH@K",
"K+JGDSC. qvzjH@K",
"K+t4,-O.  0ghH@K",
"K+t3,=o.   9fH@K",
"K+t2>*o.    8H@K",
"K+t1:&o.   5dH@K",
"K+t<;%X.  7sdH@K",
"K+Jcchl. 6piuH@K",
"K+Jckgf.6aiuyH@K",
"K+JHHHHrHHHHHJ@K",
"K$@@@@@@@@@@@@#K"
};

/* XPM */
const char *left_arrow_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 98 2",
"   c #3A7304",
".  c #3A7404",
"X  c #3B7404",
"o  c #3B7504",
"O  c #3A7405",
"+  c #3B7604",
"@  c #3C7604",
"#  c #3D7904",
"$  c #3F790A",
"%  c #41790E",
"&  c #437A10",
"*  c #457C13",
"=  c #4E9A06",
"-  c #519E07",
";  c #4D8419",
":  c #52891E",
">  c #55A409",
",  c #56A609",
"<  c #58A90A",
"1  c #59AC0B",
"2  c #5AAD0B",
"3  c #5CAD0E",
"4  c #5EB30D",
"5  c #5EA31D",
"6  c #60B50D",
"7  c #61B60E",
"8  c #61B70E",
"9  c #62AF17",
"0  c #65B519",
"q  c #578927",
"w  c #598B29",
"e  c #5A8C2C",
"r  c #5D8D2E",
"t  c #60A420",
"y  c #66AF20",
"u  c #66AC22",
"i  c #65A827",
"p  c #68A92B",
"a  c #6BA236",
"s  c #6EA23D",
"d  c #70AD35",
"f  c #71B035",
"g  c #75B23C",
"h  c #67C111",
"j  c #69C211",
"k  c #6EC915",
"l  c #7CC833",
"z  c #7BB642",
"x  c #7AB742",
"c  c #7FB947",
"v  c #7DB549",
"b  c #7DA855",
"n  c #7FA956",
"m  c #80B64D",
"M  c #82B74F",
"N  c #85B954",
"B  c #87BB54",
"V  c #87BA57",
"C  c #87B65B",
"Z  c #88BB58",
"A  c #89BC59",
"S  c #8ABC5A",
"D  c #8BBD5C",
"F  c #90BF63",
"G  c #97BD72",
"H  c #8DC459",
"J  c #97DA54",
"K  c #91C064",
"L  c #96CA65",
"P  c #94C26A",
"I  c #9DC477",
"U  c #A5DC6E",
"Y  c #A0C37E",
"T  c #A3CA7E",
"R  c #A6CF7F",
"E  c #A3D572",
"W  c #A5D576",
"Q  c #A9D77D",
"!  c #A5C982",
"~  c #A7CD84",
"^  c #AACF88",
"/  c #A9D480",
"(  c #ACD881",
")  c #AEDB82",
"_  c #B0DE83",
"`  c #B3D296",
"'  c #B5D497",
"]  c #B8D69B",
"[  c #BDD9A3",
"{  c #BFDAA6",
"}  c #C2DCAA",
"|  c #C4DDAC",
" . c #C5DEAE",
".. c #C6DEAE",
"X. c #C7DFB1",
"o. c #C8DFB1",
"O. c #CAE0B5",
"+. c None",
/* pixels */
"+.+.+.+.+.+.+.+.+.+.o +.+.+.+.+.",
"+.+.+.+.+.+.+.+.X w   +.+.+.+.+.",
"+.+.+.+.+.+.+.. n o.  +.+.+.+.+.",
"+.+.+.+.+.+.& Y [ O.  +.+.+.+.+.",
"+.+.+.+.X r ` ^ K X.+         . ",
"+.+.+.O b ' P V D |  ... .| }   ",
"+.+.* G ~ m v M N Z A S A Z {   ",
"o e ! F d g z c x f i 5 t p ]   ",
"o q I B u y 9 3 1 < > - = = T   ",
"+.+.% C L 0 6 8 7 4 2 , - = T   ",
"+.+.+.o s W l j h ) ( / R T T   ",
"+.+.+.+.+ : E J k _ #         . ",
"+.+.+.+.+.+.$ H U _   +.+.+.+.+.",
"+.+.+.+.+.+.+.@ a Q   +.+.+.+.+.",
"+.+.+.+.+.+.+.+.+ ;   +.+.+.+.+.",
"+.+.+.+.+.+.+.+.+.+.o +.+.+.+.+."
};

/* XPM */
const char *log_out_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 184 2",
"   c #555753",
".  c #565854",
"X  c #575955",
"o  c #585A56",
"O  c #595B57",
"+  c #595959",
"@  c #5B5D59",
"#  c #5C5E5A",
"$  c #5D5D5D",
"%  c #645F5E",
"&  c #5F615D",
"*  c #61635F",
"=  c #606060",
"-  c #646562",
";  c #656763",
":  c #646464",
">  c #656565",
",  c #686966",
"<  c #686A67",
"1  c #686868",
"2  c #696B68",
"3  c #6D6E6B",
"4  c #6C6C6C",
"5  c #6E6E6E",
"6  c #6F6F6F",
"7  c #7E6A6A",
"8  c #707070",
"9  c #737571",
"0  c #757575",
"q  c #767676",
"w  c #797979",
"e  c #7E7E7E",
"r  c #7F7F7F",
"t  c #A50000",
"y  c #A50101",
"u  c #A60303",
"i  c #A60404",
"p  c #A20E0E",
"a  c #AA0B0B",
"s  c #A90C0C",
"d  c #A61111",
"f  c #A51413",
"g  c #A11616",
"h  c #AC1111",
"j  c #AC1515",
"k  c #B51B1B",
"l  c #B01E1E",
"z  c #AC2524",
"x  c #B02121",
"c  c #B12221",
"v  c #BC2424",
"b  c #B72828",
"n  c #BC3030",
"m  c #B93C3C",
"M  c #BC3E3E",
"N  c #CE0808",
"B  c #CE0C0C",
"V  c #CF0E0E",
"C  c #CF1010",
"Z  c #D11A1A",
"A  c #D21B1B",
"S  c #C42D2D",
"D  c #D32525",
"F  c #D52D2D",
"G  c #C53636",
"H  c #D33535",
"J  c #D73636",
"K  c #D63838",
"L  c #D43A3A",
"P  c #D23C3C",
"I  c #D23D3D",
"U  c #B64543",
"Y  c #BB4948",
"T  c #8A6464",
"R  c #8B7373",
"E  c #867979",
"W  c #D94141",
"Q  c #DB4848",
"!  c #DB4A4A",
"~  c #DB4C4C",
"^  c #DB4D4D",
"/  c #C45151",
"(  c #DC5151",
")  c #DD5656",
"_  c #D55E5E",
"`  c #C76565",
"'  c #CD6161",
"]  c #C46C6B",
"[  c #D26565",
"{  c #E16969",
"}  c #E26E6E",
"|  c #7F817D",
" . c #808080",
".. c #828282",
"X. c #858585",
"o. c #858685",
"O. c #868686",
"+. c #878886",
"@. c #888888",
"#. c #898989",
"$. c #898A88",
"%. c #8B8B8B",
"&. c #8D8F8B",
"*. c #8C8C8C",
"=. c #8D8D8D",
"-. c #8F8F8F",
";. c #919191",
":. c #929390",
">. c #929292",
",. c #939393",
"<. c #949494",
"1. c #959595",
"2. c #969696",
"3. c #979797",
"4. c #989897",
"5. c #989898",
"6. c #999999",
"7. c #9A9B98",
"8. c #9A9A9A",
"9. c #9C9C9C",
"0. c #9D9D9D",
"q. c #9E9E9E",
"w. c #A28988",
"e. c #A0A0A0",
"r. c #A1A1A1",
"t. c #A2A3A1",
"y. c #A2A2A2",
"u. c #A3A3A3",
"i. c #A4A4A4",
"p. c #A5A5A5",
"a. c #A6A6A6",
"s. c #A7A7A7",
"d. c #A9A9A9",
"f. c #AAAAAA",
"g. c #ABABAB",
"h. c #ADADAD",
"j. c #AFAFAF",
"k. c #BABABA",
"l. c #BBBBBB",
"z. c #BDBDBD",
"x. c #A9A9A9",
"c. c #C58886",
"v. c #D79292",
"b. c #E78888",
"n. c #E88D8D",
"m. c #E88E8E",
"M. c #EA9595",
"N. c #EA9696",
"B. c #EB9A9A",
"V. c #ECA7A7",
"C. c #BEC1BB",
"Z. c #C3C3C3",
"A. c #C3C6C1",
"S. c #C5C7C1",
"D. c #C6C8C3",
"F. c #C6C9C3",
"G. c #C6C9C4",
"H. c #C7C9C5",
"J. c #D0D2D0",
"K. c #D4D6D2",
"L. c #D6D8D4",
"P. c #D7D9D5",
"I. c #D8DAD6",
"U. c #D9DBD7",
"Y. c #EDD4D3",
"T. c #E4E5E3",
"R. c #E5E6E4",
"E. c #ECE3E1",
"W. c #EDEEEC",
"Q. c #EFEFED",
"!. c #EFEFEE",
"~. c #F0F0EE",
"^. c #F1F1EF",
"/. c #F3F1EF",
"(. c #F3F3F2",
"). c #F4F4F2",
"_. c #F4F4F3",
"`. c #F6F6F5",
"'. c #F8F8F7",
"]. c #F9F9F9",
"[. c #FAFAFA",
"{. c #FBFBFA",
"}. c #FBFBFB",
"|. c None",
/* pixels */
"@               . # - , < ; 3 |.",
"  a.X.w 5 > $ + Q.^._.`.`.W.| |.",
"  h.*.r 0 4 : = Q.(.'.{.}.].7.|.",
"  k.1.#.e 0 5 1 !.).].v.M [.t.|.",
"  l.0.<.#.r q 8 ~./.` / j Y.w.|.",
"  z.e.3.-.O.e q E.m ' V.n b c y ",
"  x.y.8.;.@. .7 x [ b.m.M.N.B.y ",
"  x.i.9.,.%.T d _ { Q ! ~ ^ n.u ",
"  x.s.q.2.=.g G ) F D Z C A } i ",
"  x.d.r.5.-.R p S J N B B V ( y ",
"  x.f.u.8.>.#.E z v K W L P I t ",
"  x.f.p.0.1.-...% Y k H i l f a ",
"  x.f.d.r.6.6 $.J.T.] h s R.+.|.",
"  x.g.j.o.&.H.K.P.I.U.c.U L.9 |.",
"  Z.4.:.C.A.D.F.G.G.G.G.G.S.* |.",
"@ 2 . X o o o o O O O O O o & |."
};

/* XPM */
const char *minus_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 19 1",
"  c #3465A4",
". c #7DA6D7",
"X c #7FA8D7",
"o c #83AAD8",
"O c #86ADD9",
"+ c #90B3DA",
"@ c #92B4DA",
"# c #94B6DB",
"$ c #95B7DB",
"% c #9FBEE0",
"& c #B4CCE5",
"* c #B5CCE6",
"= c #B6CCE6",
"- c #B6CDE6",
"; c #B7CEE6",
": c #BBD1E7",
"> c #BCD1E7",
", c #C0D3E8",
"< c None",
/* pixels */
"<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<",
"<<            <<",
"<< ,:>;;;;-*= <<",
"<< &$#@+OoX.% <<",
"<<            <<",
"<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<"
};

/* XPM */
const char *net_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 160 2",
"   c #576F95",
".  c #58749D",
"X  c #5A769F",
"o  c #5876A0",
"O  c #5977A0",
"+  c #5877A2",
"@  c #5978A2",
"#  c #5979A3",
"$  c #5A79A3",
"%  c #5E7AA3",
"&  c #5A79A4",
"*  c #5A7AA4",
"=  c #5B7AA4",
"-  c #5D7DA6",
";  c #5E7DA6",
":  c #627BA3",
">  c #627CA5",
",  c #617FA6",
"<  c #617FA8",
"1  c #637FA8",
"2  c #4F80B6",
"3  c #5685B7",
"4  c #5686BA",
"5  c #5988BC",
"6  c #5C8ABD",
"7  c #6983A6",
"8  c #6380A8",
"9  c #6984A9",
"0  c #708AAD",
"q  c #6D90B7",
"w  c #7591B4",
"e  c #7591B5",
"r  c #7792B6",
"t  c #7994B6",
"y  c #7A95B7",
"u  c #7E97B9",
"i  c #628FC1",
"p  c #6B96C6",
"a  c #6C96C5",
"s  c #719BC9",
"d  c #759FCB",
"f  c #819ABA",
"g  c #839BBB",
"h  c #9DA6AE",
"j  c #AEB5BC",
"k  c #8BA7C7",
"l  c #84A6CA",
"z  c #83A7CE",
"x  c #93ABC7",
"c  c #94ACC8",
"v  c #9AB0CB",
"b  c #9CB2CB",
"n  c #9BB2CC",
"m  c #9DB3CD",
"M  c #9FB4CE",
"N  c #80A7D1",
"B  c #93B6DC",
"V  c #A4B5C9",
"C  c #A5B7C9",
"Z  c #A0B4CD",
"A  c #A3B6CE",
"S  c #BABFC4",
"D  c #B8BFC6",
"F  c #B5BEC8",
"G  c #A3B8D0",
"H  c #A9BCD1",
"J  c #ABBDD3",
"K  c #AABED3",
"L  c #AFBFD4",
"P  c #A2BDDA",
"I  c #9CBDE0",
"U  c #B7C2CD",
"Y  c #BCC4CC",
"T  c #B3C1D0",
"R  c #B1C0D5",
"E  c #B1C2D6",
"W  c #BEC7D0",
"Q  c #BCC8D4",
"!  c #BECAD6",
"~  c #B5C5D8",
"^  c #B4C7DC",
"/  c #B7C8DC",
"(  c #BBC9DA",
")  c #BECBDA",
"_  c #B8C9DD",
"`  c #BCCDDF",
"'  c #ACCAE9",
"]  c #BECFE1",
"[  c #B3CCE8",
"{  c #B1CEEC",
"}  c #B5D1EE",
"|  c #BED4EB",
" . c #BCD7F2",
".. c #C0C6CE",
"X. c #C7CDD2",
"o. c #C8CED4",
"O. c #C8CFD5",
"+. c #C6CFD8",
"@. c #CED0D1",
"#. c #CED1D3",
"$. c #CAD5DF",
"%. c #D1D1D1",
"&. c #D3D3D3",
"*. c #D7D9DB",
"=. c #DCDDDF",
"-. c #C3D2E3",
";. c #CCD7E2",
":. c #CFD9E2",
">. c #CCD9E7",
",. c #CEDBEA",
"<. c #CCDDEF",
"1. c #DBDEE0",
"2. c #D4DDE9",
"3. c #D5DFE9",
"4. c #D6DFE9",
"5. c #D5DFEB",
"6. c #DFE1E3",
"7. c #DCE1E5",
"8. c #DEE2E7",
"9. c #D9E1E9",
"0. c #DCE3E9",
"q. c #DBE4EF",
"w. c #DCE4ED",
"e. c #C9E1F9",
"r. c #CCE3FA",
"t. c #D4E5F6",
"y. c #D2E5F9",
"u. c #D5E8FC",
"i. c #DAEAFA",
"p. c #DEEDFB",
"a. c #DAEBFC",
"s. c #DEEEFF",
"d. c #DFEFFF",
"f. c #E0E0E0",
"g. c #E2E2E2",
"h. c #E0E3E4",
"j. c #E3E4E5",
"k. c #E2E4E6",
"l. c #E0E5EB",
"z. c #E4E6E8",
"x. c #EDEEEF",
"c. c #EFEFEF",
"v. c #E6EBF0",
"b. c #E6EBF4",
"n. c #E0EFFF",
"m. c #E2EFFE",
"M. c #E1F0FF",
"N. c #E2F1FF",
"B. c #E3F1FF",
"V. c #F1F2F3",
"C. c #F4F4F5",
"Z. c #F5F5F5",
"A. c #F6F6F6",
"S. c #F0F4F8",
"D. c #F8F9F9",
"F. c #F9F9F9",
"G. c #FBFBFB",
"H. c #FDFDFD",
"J. c #FEFEFE",
"K. c None",
/* pixels */
"K.K.K.K.K.o = * @ + K.K.K.K.K.K.",
"K.K.K.% g ( w.b.5.E u # K.K.K.K.",
"K.K., R l.:.S ) | ! 9.A $ K.K.K.",
"K.9 L 8.#.m.p.t.Q ..1.v.Z * K.K.",
": f S.j.$.N.B.i.+.*.C.G.3.t K.K.",
"0 ~ h.<.n.M.M.a.X.W V F z.G * K.",
"8 2.K r.s.d.d.,.H.J.H.k.=.` * K.",
"= q.'  .e.u.y.O.J.J.J.F.j -.* K.",
"; >.U o.[ } { H D.V.J.c.@._ * K.",
"1 J 7.J.6.P I B l k Z.g.h m * K.",
"> y 4.J.J.x.z N d a f.&.C e K.K.",
"K.< b 0.A.D s p i 5 %.Y c * K.K.",
"K.K.- v ;.q 6 4 2 3 T x # K.K.K.",
"K.K.K.7 r M / ] ^ n w O K.K.K.K.",
"K.K.K.K.  X $ & @ . K.K.K.K.K.K.",
"K.K.K.K.K.K.K.K.K.K.K.K.K.K.K.K."
};

/* XPM */
const char *plus_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 19 1",
"  c #3465A4",
". c #7DA6D7",
"X c #7FA8D7",
"o c #83AAD8",
"O c #86ADD9",
"+ c #90B3DA",
"@ c #92B4DA",
"# c #94B6DB",
"$ c #95B7DB",
"% c #9FBEE0",
"& c #B4CCE5",
"* c #B5CCE6",
"= c #B6CCE6",
"- c #B6CDE6",
"; c #B7CEE6",
": c #BBD1E7",
"> c #BCD1E7",
", c #C0D3E8",
"< c None",
/* pixels */
"<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<",
"<<<<<<    <<<<<<",
"<<<<<< ;; <<<<<<",
"<<<<<< ;; <<<<<<",
"<<<<<< ;; <<<<<<",
"<<     ;;     <<",
"<< ,:>;;;;-*= <<",
"<< &$#@+OoX.% <<",
"<<     OO     <<",
"<<<<<< ;O <<<<<<",
"<<<<<< ;O <<<<<<",
"<<<<<< ;; <<<<<<",
"<<<<<<    <<<<<<",
"<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<"
};

/* XPM */
const char *process_stop_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 133 2",
"   c #860000",
".  c #870000",
"X  c #880000",
"o  c #890000",
"O  c #880202",
"+  c #890202",
"@  c #890303",
"#  c #BD0000",
"$  c #BF0000",
"%  c #BD0202",
"&  c #BD0303",
"*  c #BE0404",
"=  c #BE0505",
"-  c #BF0505",
";  c #B01818",
":  c #B11A1A",
">  c #B11B1B",
",  c #B41D1D",
"<  c #B41F1F",
"1  c #BC1818",
"2  c #BF1919",
"3  c #AF2222",
"4  c #B12222",
"5  c #B72121",
"6  c #B22424",
"7  c #B32626",
"8  c #B82323",
"9  c #B82424",
"0  c #C10000",
"q  c #C10101",
"w  c #C30000",
"e  c #C50000",
"r  c #C70000",
"t  c #C70303",
"y  c #CB0101",
"u  c #CC0F0F",
"i  c #C51A1A",
"p  c #C41B1B",
"a  c #C71D1D",
"s  c #D01010",
"d  c #D31111",
"f  c #D21F1F",
"g  c #C92929",
"h  c #CE2828",
"j  c #CC2F2F",
"k  c #CE2F2F",
"l  c #CF2F2F",
"z  c #D52323",
"x  c #D02F2F",
"c  c #D22F2F",
"v  c #D52F2F",
"b  c #DF2B2B",
"n  c #DF2C2C",
"m  c #DF2D2D",
"M  c #D13131",
"N  c #D23131",
"B  c #D53030",
"V  c #D53737",
"C  c #D63B3B",
"Z  c #D93B3B",
"A  c #DA3B3B",
"S  c #DB3C3C",
"D  c #E63434",
"F  c #E73737",
"G  c #E83737",
"H  c #E83B3B",
"J  c #EA3F3F",
"K  c #DB4040",
"L  c #DB4141",
"P  c #DC4242",
"I  c #D75757",
"U  c #D65858",
"Y  c #D75B5B",
"T  c #D65F5F",
"R  c #D75F5F",
"E  c #D85A5A",
"W  c #D85B5B",
"Q  c #D85C5C",
"!  c #DB5F5F",
"~  c #EB4343",
"^  c #E94545",
"/  c #ED4747",
"(  c #EC4A4A",
")  c #EB4C4C",
"_  c #ED5252",
"`  c #EF5A5A",
"'  c #D76060",
"]  c #DA6464",
"[  c #DA6767",
"{  c #EC6161",
"}  c #ED6565",
"|  c #EE6868",
" . c #EF6A6A",
".. c #F26969",
"X. c #F06F6F",
"o. c #F17575",
"O. c #D89292",
"+. c #DE9292",
"@. c #D89999",
"#. c #F38383",
"$. c #F58383",
"%. c #F58585",
"&. c #F68787",
"*. c #F68888",
"=. c #F68989",
"-. c #F68A8A",
";. c #F78B8B",
":. c #E39696",
">. c #DEACAC",
",. c #E5A5A5",
"<. c #E6A5A5",
"1. c #E9A5A5",
"2. c #E4AAAA",
"3. c #E6ABAB",
"4. c #E8BCBC",
"5. c #DACDCD",
"6. c #DAD6D6",
"7. c #DBDBDB",
"8. c #DFDFDF",
"9. c #E6D9D9",
"0. c #E2DEDE",
"q. c #E5DFDF",
"w. c #E6DFDF",
"e. c #E6E0E0",
"r. c #E8E8E8",
"t. c #ECECEC",
"y. c #EDEDED",
"u. c #F3EDED",
"i. c #F1F1F1",
"p. c #FCF7F7",
"a. c #F9F9F9",
"s. c #FEFEFE",
"d. c None",
/* pixels */
"d.d.d.d.o             o d.d.d.d.",
"d.d.d.o 3 *.;.;.-.&.$.8 o d.d.d.",
"d.d.o 4 #.P v v v v S o.< o d.d.",
"d.o 6 #.P V v v v v V A X.> o d.",
"o 7 #.L I 5.R v v Q 9.! Z  .; o ",
"O =.K v O.7.6.' E e.y.,.c C | O ",
"@ *.v v B @.8.0.w.t.3.N x k } + ",
"@ *.v v v B >.r.t.4.M l k j { + ",
"@ *.v v v W w.t.i.u.] k j g ^ + ",
"@ %.v v Y q.t.2.<.a.p.[ i % G + ",
"O ..z f +.t.2.x h 1.s.:.# & D + ",
"o 9 ` d y U t e w q T % * b a . ",
"d.o 5 _ s r e w 0 $ # = n p X d.",
"d.d.o , ) u w 0 $ # - m 2 X d.d.",
"d.d.d.o : ( / ~ J H F 1 X d.d.d.",
"d.d.d.d.o             X d.d.d.d."
};

/* XPM */
const char *right_arrow_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 100 2",
"   c #3A7304",
".  c #3A7404",
"X  c #3B7404",
"o  c #3B7504",
"O  c #3A7405",
"+  c #3B7604",
"@  c #3C7604",
"#  c #3C7804",
"$  c #40790A",
"%  c #427A0E",
"&  c #437A10",
"*  c #467C14",
"=  c #4E9A06",
"-  c #4F9C06",
";  c #4D8418",
":  c #538B1E",
">  c #52A007",
",  c #54A408",
"<  c #57A709",
"1  c #5AAC0B",
"2  c #5BAE0B",
"3  c #5EB30D",
"4  c #5FB20E",
"5  c #61B70E",
"6  c #62B90E",
"7  c #64BC0F",
"8  c #64BA11",
"9  c #66BF10",
"0  c #66B817",
"q  c #6CBA1F",
"w  c #6CBF1C",
"e  c #568926",
"r  c #598C2A",
"t  c #5E8F30",
"y  c #5F8F31",
"u  c #68A92B",
"i  c #6BAC2F",
"p  c #6FBA26",
"a  c #6AA136",
"s  c #6EAC33",
"d  c #71A63E",
"f  c #74AF3B",
"g  c #78B63D",
"h  c #7FCB34",
"j  c #80BE44",
"k  c #82BE49",
"l  c #81AB5A",
"z  c #82AB5A",
"x  c #85B954",
"c  c #88BB58",
"v  c #8BBC5B",
"b  c #8BBB5D",
"n  c #8BBD5C",
"m  c #8CBE5C",
"M  c #84C249",
"N  c #88C44D",
"B  c #89C350",
"V  c #8AC255",
"C  c #8DC655",
"Z  c #8BC158",
"A  c #8CC358",
"S  c #8DC25A",
"D  c #8DC15C",
"F  c #92D352",
"G  c #8FC161",
"H  c #91C164",
"J  c #99C46F",
"K  c #9BCA6D",
"L  c #9CD267",
"P  c #9DC873",
"I  c #9EC976",
"U  c #9CC37A",
"Y  c #A0D56C",
"T  c #A3CA7E",
"R  c #A4CC7E",
"E  c #A5D773",
"W  c #A6D37B",
"Q  c #A7D17F",
"!  c #A8DA78",
"~  c #A4C684",
"^  c #AACE89",
"/  c #AAD581",
"(  c #ABD681",
")  c #ABD781",
"_  c #AFD48C",
"`  c #B1D291",
"'  c #B7D49C",
"]  c #B9D79C",
"[  c #BBD99F",
"{  c #BDD9A3",
"}  c #C0DBA7",
"|  c #C2DCAA",
" . c #C3DCAB",
".. c #C5DDAD",
"X. c #C6DEAF",
"o. c #C7DEB0",
"O. c #CBE0B6",
"+. c #CBE1B7",
"@. c #CEE3BB",
"#. c None",
/* pixels */
"#.#.#.#.#.o #.#.#.#.#.#.#.#.#.#.",
"#.#.#.#.#.  r . #.#.#.#.#.#.#.#.",
"#.#.#.#.#.  +.z . #.#.#.#.#.#.#.",
"#.#.#.#.#.  @. .~ & #.#.#.#.#.#.",
".         + O.J ` ' y X #.#.#.#.",
"  } | ..X.o.o.H G P [ l O #.#.#.",
"  { x c v n m D S V A _ U * #.#.",
"  ] f s u i g k B N M j K ^ t o ",
"  T = = = > < 2 4 0 q p C I e o ",
"  T = = - , 1 3 6 7 w L b % #.#.",
"  T T T R Q / 5 9 h ! d + #.#.#.",
".         # ( 8 F E : @ #.#.#.#.",
"#.#.#.#.#.  ) Y Z $ #.#.#.#.#.#.",
"#.#.#.#.#.  W a @ #.#.#.#.#.#.#.",
"#.#.#.#.#.  ; + #.#.#.#.#.#.#.#.",
"#.#.#.#.#.o #.#.#.#.#.#.#.#.#.#."
};

/* XPM */
const char *save_as_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 95 2",
"   c #000000",
".  c #4E6A7D",
"X  c #58787A",
"o  c #6E706B",
"O  c #6B716E",
"+  c #72756B",
"@  c #667173",
"#  c #627075",
"$  c #38678B",
"%  c #3D698A",
"&  c #3B6B8F",
"*  c #3D6B8E",
"=  c #3F6C8E",
"-  c #4A6D85",
";  c #436E88",
":  c #4A7180",
">  c #41749A",
",  c #44789F",
"<  c #547D9B",
"1  c #6B7F88",
"2  c #5186AF",
"3  c #5892BD",
"4  c #688BA0",
"5  c #6E99B6",
"6  c #7798B0",
"7  c #719FBF",
"8  c #739FC0",
"9  c #79A7CA",
"0  c #92A6AC",
"q  c #95A9AF",
"w  c #9AAEB4",
"e  c #A2A4A1",
"r  c #A3A4A1",
"t  c #AEB0AD",
"y  c #AFB0AD",
"u  c #AEB0AE",
"i  c #AFB0AE",
"p  c #B7B8B6",
"a  c #C5CBBF",
"s  c #8FB3CE",
"d  c #92B7D3",
"f  c #96BBD8",
"g  c #9EBFD9",
"h  c #98BFDC",
"j  c #ACBCC3",
"k  c #9BC2DF",
"l  c #ABC8DF",
"z  c #ABCBE2",
"x  c #ACCBE3",
"c  c #B1CEE6",
"v  c #CACFC4",
"b  c #CED4C8",
"n  c #C9D6DD",
"m  c #DCDBDB",
"M  c #DBDCDB",
"N  c #DCDCDB",
"B  c #DCDBDC",
"V  c #DBDCDC",
"C  c #DCDCDC",
"Z  c #DDE1D6",
"A  c #DFE2DE",
"S  c #E2E6DD",
"D  c #C1D9EB",
"F  c #C5DBEC",
"G  c #D5DFE5",
"H  c #D0DFEF",
"J  c #E3E3E3",
"K  c #E4E4E4",
"L  c #E9E9EA",
"P  c #EAE9EA",
"I  c #EBECEC",
"U  c #ECECEC",
"Y  c #EDEDED",
"T  c #EDEEED",
"R  c #EDEDEE",
"E  c #EDEEEE",
"W  c #EEEEEE",
"Q  c #EEEFEE",
"!  c #EEEEEF",
"~  c #EFEEEF",
"^  c #EFEFEF",
"/  c #F0F0F0",
"(  c #F1F1F1",
")  c #F2F2F2",
"_  c #F3F3F3",
"`  c #F3F4F3",
"'  c #F4F4F4",
"]  c #F7F7F7",
"[  c #F9F9F9",
"{  c #FAFAFA",
"}  c #FCFBFC",
"|  c #FCFCFC",
" . c #FDFDFD",
".. c #FFFFFF",
"X. c None",
/* pixels */
"X.X.X.$ $ $ % : X X.X.X.X.X.X.X.",
"X.X.X.c H F k 4 ; X.X.X.X.X.X.X.",
"1 @ # - > , g D 2 . o o o o o o ",
"O S ..Z n 5 $ z d < G ......' o ",
"+  .W Y A 6 $ 9 s * j R E T ` o ",
"o } I $ $ $ $ 9 3 $ $ $ $ U _ o ",
"o { L v $ h 7 7 7 8 f $ q P ) o ",
"o [ { K a $ h 8 8 l $ 0 K ' ( o ",
"o [ W { K a $ x h & 0 K { W ( o ",
"o ] J W { { b = $ w { | W J / o ",
"o r e r r r r r r r r r r r r o ",
"o C m N C B N B C M V   N V C o ",
"o ^ y u i t y y y y ~   Q ! ~ o ",
"o ..p p p p p p p p ..  ......o ",
"o ....................  ......o ",
"o o o o o o o o o o o o o o o o "
};

/* XPM */
const char *save_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 107 2",
"   c #4E6A7D",
".  c #58787A",
"X  c #6E706B",
"o  c #6B716E",
"O  c #72756B",
"+  c #667173",
"@  c #627075",
"#  c #38678B",
"$  c #3D698A",
"%  c #3B6B8F",
"&  c #3D6B8E",
"*  c #3F6C8E",
"=  c #4A6D85",
"-  c #436E88",
";  c #4A7180",
":  c #41749A",
">  c #44789F",
",  c #547D9B",
"<  c #6B7F88",
"1  c #5186AF",
"2  c #5892BD",
"3  c #688BA0",
"4  c #6E99B6",
"5  c #7798B0",
"6  c #719FBF",
"7  c #739FC0",
"8  c #79A7CA",
"9  c #9F9F9F",
"0  c #92A6AC",
"q  c #95A9AF",
"w  c #9AAEB4",
"e  c #A8A7A7",
"r  c #A8A7A8",
"t  c #A9A9A9",
"y  c #AAAAA9",
"u  c #AFAFAF",
"i  c #B4B4B4",
"p  c #B7B6B6",
"a  c #B9B9B9",
"s  c #BCBCBC",
"d  c #C5CBBF",
"f  c #8FB3CE",
"g  c #92B7D3",
"h  c #96BBD8",
"j  c #9EBFD9",
"k  c #98BFDC",
"l  c #ACBCC3",
"z  c #9BC2DF",
"x  c #ABC8DF",
"c  c #ABCBE2",
"v  c #ACCBE3",
"b  c #B1CEE6",
"n  c #C2C2C2",
"m  c #C3C3C3",
"M  c #C4C4C4",
"N  c #C5C5C5",
"B  c #CACFC4",
"V  c #C8C8C8",
"C  c #C9C9C9",
"Z  c #CACACA",
"A  c #CBCBCB",
"S  c #CDCDCD",
"D  c #CECECE",
"F  c #CFCFCF",
"G  c #CED4C8",
"H  c #C9D6DD",
"J  c #D0D0D0",
"K  c #D1D1D1",
"L  c #D2D2D2",
"P  c #D5D5D5",
"I  c #D6D6D6",
"U  c #DCDCDC",
"Y  c #DDDDDD",
"T  c #DDE1D6",
"R  c #DFE2DE",
"E  c #E2E6DD",
"W  c #C1D9EB",
"Q  c #C5DBEC",
"!  c #D5DFE5",
"~  c #D0DFEF",
"^  c #E3E3E3",
"/  c #E4E4E4",
"(  c #E9E9EA",
")  c #EAE9EA",
"_  c #EBEBEB",
"`  c #EBECEC",
"'  c #ECECEC",
"]  c #EDEDED",
"[  c #EDEEED",
"{  c #EDEDEE",
"}  c #EDEEEE",
"|  c #EEEEEE",
" . c #F0F0F0",
".. c #F1F1F1",
"X. c #F2F2F2",
"o. c #F3F3F3",
"O. c #F3F4F3",
"+. c #F4F4F4",
"@. c #F7F7F7",
"#. c #F9F9F9",
"$. c #FAFAFA",
"%. c #FCFBFC",
"&. c #FCFCFC",
"*. c #FDFDFD",
"=. c #FEFEFE",
"-. c #FFFFFF",
";. c None",
/* pixels */
";.;.;.# # # $ ; . ;.;.;.;.;.;.;.",
";.;.;.b ~ Q z 3 - ;.;.;.;.;.;.;.",
"< + @ = : > j W 1   X X X X X X ",
"o E -.T H 4 # c g , ! -.-.-.+.X ",
"O *.| ] R 5 # 8 f & l { } [ O.X ",
"X %.` # # # # 8 2 # # # # ' o.X ",
"X $.( B # k 6 6 6 7 h # q ) X.X ",
"X #.$./ d # k 7 7 x # 0 / +...X ",
"X #.| $./ d # v k % 0 / $.| ..X ",
"X @.^ | $.$.G * # w $.&.| ^  .X ",
"X =.-.-.-.-.-.-.-.+.+._ _ ^  .X ",
"X D C C C C N C C N N N N N I X ",
"X D N 9 u s M V J t L t L a Z X ",
"X S m y i n M V A r K e K p Z X ",
"X Y U U U P P F F F F F F F Z X ",
"X X X X X X X X X X X X X X X X "
};

/* XPM */
const char *time_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 59 1",
"  c #2E3436",
". c #32383A",
"X c #383E40",
"o c #393E40",
"O c #3B4042",
"+ c #404648",
"@ c #414748",
"# c #4A5052",
"$ c #4C5153",
"% c #4D5254",
"& c #555753",
"* c #61635F",
"= c #636561",
"- c #646662",
"; c #686A66",
": c #6E706C",
"> c #7C7E79",
", c #818485",
"< c #888A85",
"1 c #939591",
"2 c #959798",
"3 c #9B9C9A",
"4 c #A0A2A3",
"5 c #AAABA8",
"6 c #B0B1AE",
"7 c #B0B2B3",
"8 c #B8B9B7",
"9 c #C2C3C1",
"0 c #C3C4C2",
"q c #C2C4C4",
"w c #C5C6C6",
"e c #C8C8C8",
"r c #CACAC9",
"t c #C8C9CA",
"y c #C9C9CA",
"u c #CACBCA",
"i c #CDCECD",
"p c #CECFCE",
"a c #D2D2D2",
"s c #D6D6D6",
"d c #D9D9D9",
"f c #DFDFDF",
"g c #E0E0E0",
"h c #E1E1E1",
"j c #E2E2E2",
"k c #E3E3E2",
"l c #E3E3E3",
"z c #E4E4E4",
"x c #E6E6E6",
"c c #E7E7E7",
"v c #E9E9E9",
"b c #ECECEC",
"n c #EEEEEE",
"m c #F1F1F1",
"M c #F3F3F3",
"N c #FBFBFA",
"B c #FDFDFD",
"V c #FFFFFF",
"C c None",
/* pixels */
"CC<<CCC<CCC<CCCC",
"C<<<<<<<<<<<<<CC",
"<V<0VV<sBB<sBV<C",
"<V<1xx<<kx<<xV<C",
"<VsdxxsszxsssV<C",
">Vxzt,j$+7ccxV>C",
">Vnx% f2e#xxpV>C",
">Vnxf fq@4xxrV>C",
";Vxxf f.ywxi9V;C",
";Vxxf fOoXxi9V;C",
"=VxllglhhhaMBN=C",
"-Vxvbnmxpu8M63-C",
"-VVVVVVVVVVV5:-C",
"=*************-C",
"C <&&&&&&&&&& CC",
"C             CC"
};

/* XPM */
const char *trash_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 130 2",
"   c #535A22",
".  c #545B23",
"X  c #575E26",
"o  c #5B6129",
"O  c #5D6329",
"+  c #61682A",
"@  c #666D2D",
"#  c #6C732F",
"$  c #6F7731",
"%  c #737B32",
"&  c #767F33",
"*  c #494D4C",
"=  c #5C5E59",
"-  c #5E605C",
";  c #61635E",
":  c #62645F",
">  c #636561",
",  c #646663",
"<  c #666863",
"1  c #686A65",
"2  c #686A66",
"3  c #6A6C68",
"4  c #6B6D68",
"5  c #6D6F6B",
"6  c #70726D",
"7  c #70726E",
"8  c #727470",
"9  c #737571",
"0  c #757773",
"q  c #767B77",
"w  c #787A75",
"e  c #797B77",
"r  c #788134",
"t  c #7A8235",
"y  c #798237",
"u  c #7F865E",
"i  c #81893A",
"p  c #8B943E",
"a  c #879042",
"s  c #899245",
"d  c #8B9348",
"f  c #8C9548",
"g  c #909946",
"h  c #929C4A",
"j  c #959E49",
"k  c #969F4A",
"l  c #919A4C",
"z  c #949D4F",
"x  c #8A9259",
"c  c #8A915C",
"v  c #939A59",
"b  c #98A247",
"n  c #96A04F",
"m  c #9CA64D",
"M  c #98A150",
"N  c #9AA252",
"B  c #9FA956",
"V  c #A5AE49",
"C  c #A0A956",
"Z  c #A6AF55",
"A  c #A8B154",
"S  c #ADB757",
"D  c #A9B259",
"F  c #ADB75C",
"G  c #AEB75D",
"H  c #B2BD50",
"J  c #B3BE50",
"K  c #B3BD5A",
"L  c #888E69",
"P  c #8C9162",
"I  c #9FA46B",
"U  c #A7AF67",
"Y  c #A1A76E",
"T  c #A9B260",
"R  c #AAB263",
"E  c #AAB264",
"W  c #B2BB64",
"Q  c #A3AB72",
"!  c #A5AC72",
"~  c #A8AD75",
"^  c #ADB17E",
"/  c #ACB27E",
"(  c #B5C051",
")  c #B8C257",
"_  c #B9C35D",
"`  c #BBC55F",
"'  c #BBC561",
"]  c #BCC661",
"[  c #BCC662",
"{  c #BDC763",
"}  c #B8C065",
"|  c #BDC765",
" . c #BBC469",
".. c #BAC36D",
"X. c #BDC675",
"o. c #C7D07E",
"O. c #989A94",
"+. c #B2B881",
"@. c #B5BB82",
"#. c #B7BE81",
"$. c #B8BE84",
"%. c #A9AD94",
"&. c #B6BBA6",
"*. c #B1B4AD",
"=. c #BCC286",
"-. c #BFC687",
";. c #C3CA89",
":. c #C7CC8B",
">. c #C9D181",
",. c #CAD184",
"<. c #C9D18D",
"1. c #CCD28E",
"2. c #C3CA99",
"3. c #C4CB9E",
"4. c #CDD590",
"5. c #CBD09E",
"6. c #CCD29D",
"7. c #CCD19F",
"8. c #D0D691",
"9. c #D1D793",
"0. c #C8CEA5",
"q. c #CDD2A1",
"w. c #D2D7B9",
"e. c #D3D8BB",
"r. c #D3D9BB",
"t. c #D4D9BB",
"y. c #D4D9BC",
"u. c #D6DBC8",
"i. c #DBE0D7",
"p. c None",
/* pixels */
"p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.",
"p.p.. . . . . . . . . . . . p.p.",
"p.u i.i.i.i.i.i.i.i.i.i.i.i.L p.",
". i.q = - ; > < 2 4 5 6 8 *.i.. ",
". i.* : , 1 3 5 7 9 0 w e O.i.. ",
". &.i.i.i.i.i.i.i.i.i.i.i.i.%.. ",
". . v t r & % $ # @ + O o X .   ",
"p.. o.( ( J V Z E b p i y x . p.",
"p.. o.( ( H } u.u.5.C j f c . p.",
"p.. >.( ( 6...W 7.q.B N z I . p.",
"p.. ,.) ] t.u.F D T #.M l ! . p.",
"p.. 8.| { r.X.G 0.R w.n d ~ . p.",
"p.. 9.[ '  .q.2.y.e.U h s Q . p.",
"p.. 4.` _ K S A 3.m k g a Y . p.",
"p.. ^ 1.<.:.;.-.=.$.@.+./ P . p.",
"p.p.. . . . . . . . . . . . p.p."
};

/* XPM */
const char *image_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 86 1",
"  c #233659",
". c #384151",
"X c #2F4262",
"o c #374762",
"O c #33476A",
"+ c #34486A",
"@ c #3B4C6B",
"# c #384C6E",
"$ c #3D4E6D",
"% c #3D4F6D",
"& c #3F516F",
"* c #3D5071",
"= c #515151",
"- c #45546E",
"; c #435470",
": c #455672",
"> c #475773",
", c #405374",
"< c #415474",
"1 c #485773",
"2 c #495973",
"3 c #67758F",
"4 c #5072A3",
"5 c #5475A4",
"6 c #5778A6",
"7 c #5B7BA8",
"8 c #5F7EAA",
"9 c #617FAB",
"0 c #7A8698",
"q c #7D899D",
"w c #6180AD",
"e c #6381AD",
"r c #6583AF",
"t c #6884AA",
"y c #718DA7",
"u c #6986B1",
"i c #6D89B3",
"p c #728DB6",
"a c #738EB6",
"s c #7590B7",
"d c #7892B9",
"f c #888A85",
"g c #818A9A",
"h c #818DA2",
"j c #8691A3",
"k c #819AB8",
"l c #8099BD",
"z c #839ABE",
"x c #869CBF",
"c c #8FA6AF",
"v c #9CA7B9",
"b c #9EA8BA",
"n c #9EA9BA",
"m c #9FA9BB",
"M c #A4B8A9",
"N c #B6C5B2",
"B c #B3C2B7",
"V c #C4D1AF",
"C c #C5D1B1",
"Z c #D1DCB1",
"A c #DCE5B9",
"S c #E2EBBE",
"D c #889EC1",
"F c #8CA1C1",
"G c #8EA3C4",
"H c #93A6C6",
"J c #95A8C7",
"K c #9DAFC7",
"L c #96A9C8",
"P c #98ABC9",
"I c #9AACCA",
"U c #A1B3C3",
"Y c #A2B3CE",
"T c #A5B5D0",
"R c #A6B6D1",
"E c #A7B7D1",
"W c #A8B7D1",
"Q c #A8B8D2",
"! c #EEF3CB",
"~ c #F7FADF",
"^ c #FCFDEE",
"/ c #F6F6F6",
"( c #FEFEF9",
") c #FDFDFD",
"_ c #FEFEFE",
"` c #FFFFFE",
/* pixels */
"ffffffffffffffff",
"f______________f",
"f)0oooooooooo0/f",
"f_&9ety876554o/f",
"f);acA!Miurrwo/f",
"f):lV(`Skdsspo/f",
"f)>GN~^ZFDxxzo/f",
"f)1IKBCUPLqJHo/f",
"f)2WQQWERT=jYo/f",
"f)-mmmmnbv==go/f",
"f)o$%%$@X ==.o/f",
"f)o<,*#+O====o/f",
"f)oh333333333o/f",
"f)0oooooooooo0/f",
"f_////////////)f",
"ffffffffffffffff"
};

/* XPM */
const char *weather_clear_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 76 1",
"  c #FCAF3E",
". c #FBB13E",
"X c #FBB13F",
"o c #FCB03E",
"O c #FCB13E",
"+ c #FCB23E",
"@ c #FCB33E",
"# c #FCB23F",
"$ c #FCB33F",
"% c #FAB43F",
"& c #FBB43F",
"* c #FCB43F",
"= c #FAB545",
"- c #FBB94A",
"; c #FCB953",
": c #FBBA57",
"> c #FCBC57",
", c #FBBD5B",
"< c #FBD349",
"1 c #FCD549",
"2 c #FCE34E",
"3 c #FCE956",
"4 c #FCEA57",
"5 c #FCE459",
"6 c #FCE55D",
"7 c #FCE959",
"8 c #FCEA5A",
"9 c #FCC66D",
"0 c #FCD964",
"q c #FBDB6C",
"w c #FCC470",
"e c #FCC570",
"r c #FCEB65",
"t c #FCE768",
"y c #FCEC68",
"u c #FCE86E",
"i c #FCED71",
"p c #FCCC82",
"a c #FDCD83",
"s c #FCCD84",
"d c #FCEF81",
"f c #FCEF82",
"g c #FCEF84",
"h c #FCEF87",
"j c #FDF089",
"k c #FDF08B",
"l c #FDF08C",
"z c #FDEAAD",
"x c #FDF3A1",
"c c #FDF0A2",
"v c #FDF3A2",
"b c #FDF1AA",
"n c #FCF4AB",
"m c #FDF4AC",
"M c #FCF4AD",
"N c #FDF4AE",
"B c #FDECB4",
"V c #FDE6BF",
"C c #FDF4B0",
"Z c #FDF5B1",
"A c #FDF6BE",
"S c #FDE6C1",
"D c #FEF8CE",
"F c #FEF9CF",
"G c #FEF8D0",
"H c #FEF9D0",
"J c #FEF9DF",
"K c #FEFAE3",
"L c #FEF8E7",
"P c #FEF9E7",
"I c #FEFCEF",
"U c #FEFCF0",
"Y c #FEFDF0",
"T c #FEFCF1",
"R c #FEFEFB",
"E c None",
/* pixels */
"EEEEEEEEEEEEEEEE",
"EEEEEEEoOEEEEEEE",
"EEEEEEEOOEEEEEEE",
"EEE #Eapw;E+ EEE",
"EEE+9VPUJz:$#EEE",
"EEEESRIDCMc=EEEE",
"EEEaLYYFmjh0@EEE",
"EOOsTGHAxdyt.OoE",
"EoOeKZNvli75XOOE",
"EEE>Bnkfi84<#EEE",
"EEEE,bgr342%EEEE",
"EEE#*-qu61&@+EEE",
"EEE +E#X.@E# EEE",
"EEEEEEEOOEEEEEEE",
"EEEEEEEOoEEEEEEE",
"EEEEEEEEEEEEEEEE"
};

/* XPM */
const char *start_here_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 52 1",
"  c #204A87",
". c #204A88",
"X c #204B88",
"o c #214B88",
"O c #214B89",
"+ c #214C89",
"@ c #234E8B",
"# c #234F8C",
"$ c #244F8C",
"% c #24508D",
"& c #25508E",
"* c #25518F",
"= c #285593",
"- c #295694",
"; c #2A5896",
": c #2C5B99",
"> c #2D5C9A",
", c #2F5F9D",
"< c #2F5F9E",
"1 c #30609F",
"2 c #31619F",
"3 c #3162A0",
"4 c #3465A4",
"5 c #3566A4",
"6 c #3566A5",
"7 c #3667A5",
"8 c #3667A6",
"9 c #3768A6",
"0 c #3868A6",
"q c #3869A7",
"w c #3A6AA8",
"e c #3D6EAA",
"r c #4070AC",
"t c #4272AD",
"y c #4474AF",
"u c #4575B0",
"i c #4E7DB6",
"p c #507FB7",
"a c #5080B8",
"s c #5180B8",
"d c #5483BA",
"f c #5B8ABF",
"g c #5D8BC0",
"h c #5E8CC1",
"j c #6492C5",
"k c #6593C6",
"l c #6795C7",
"z c #6895C8",
"x c #6996C8",
"c c #6B98CA",
"v c #729FCF",
"b c None",
/* pixels */
"bbbbbbbbbb. obbb",
"bb750bbbbb@2;Xbb",
"bbexd8bbbX144#bb",
"b7lvvrbbbX444- b",
"b7vvva5bb%444>Ob",
"btvvvhqb -4443 b",
"4svvvc6bb-4441Xb",
"bpvvvz7bb&444:Ob",
"byvvvfqbb+444=bb",
"bwvvvibbb     bb",
"b44444bbbbbbbbbb",
"bbbbbbbbb     bb",
"b64444bbbo>4,obb",
"b0gvj9bbbb$<*Xbb",
"bbrku7bbbb  Xbbb",
"bb668bbbbbbbbbbb"
};

/* XPM */
const char *help_browser_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 153 2",
"   c #204A87",
".  c #214B88",
"X  c #224B88",
"o  c #224C88",
"O  c #234C89",
"+  c #234D89",
"@  c #244E8A",
"#  c #254F8A",
"$  c #254F8B",
"%  c #264F8B",
"&  c #27508B",
"*  c #2A538E",
"=  c #2C548D",
"-  c #2D558D",
";  c #2D558E",
":  c #2E558F",
">  c #2F578F",
",  c #2D5690",
"<  c #2F5891",
"1  c #315891",
"2  c #365C93",
"3  c #325B94",
"4  c #335B94",
"5  c #335C94",
"6  c #345C95",
"7  c #345D95",
"8  c #385E94",
"9  c #386097",
"0  c #3B6096",
"q  c #386098",
"w  c #3A6299",
"e  c #3B639A",
"r  c #3C649A",
"t  c #40679D",
"y  c #42699F",
"u  c #436A9F",
"i  c #47699C",
"p  c #4B6E9F",
"a  c #456CA1",
"s  c #466DA1",
"d  c #496FA3",
"f  c #4D6FA0",
"g  c #4B72A5",
"h  c #4C72A5",
"j  c #4D73A6",
"k  c #5176A7",
"l  c #5878A5",
"z  c #5978A6",
"x  c #5B7AA7",
"c  c #5C7BA7",
"v  c #5278A9",
"b  c #547AAC",
"n  c #567CAD",
"m  c #597AA8",
"M  c #5D7CA8",
"N  c #5A7FB0",
"B  c #617EAA",
"V  c #5E83B2",
"C  c #6381AB",
"Z  c #6482AC",
"A  c #6582AC",
"S  c #6482AD",
"D  c #6A86AF",
"F  c #6284B2",
"G  c #6587B3",
"H  c #6085B4",
"J  c #6286B4",
"K  c #6387B6",
"L  c #6987B1",
"P  c #6589B7",
"I  c #6B88B2",
"U  c #6B89B3",
"Y  c #6C88B0",
"T  c #6D8BB5",
"R  c #6C8DB7",
"E  c #678BB9",
"W  c #6A8EBA",
"Q  c #6B8FBB",
"!  c #718DB5",
"~  c #728FB7",
"^  c #6F92BD",
"/  c #7191BB",
"(  c #7093BF",
")  c #7594BD",
"_  c #7296C1",
"`  c #7396C1",
"'  c #7497C1",
"]  c #7999C1",
"[  c #789BC5",
"{  c #829DC1",
"}  c #86A1C3",
"|  c #89A1C2",
" . c #8CA1C1",
".. c #8CA2C1",
"X. c #8BA5C7",
"o. c #8FA8C8",
"O. c #90A5C3",
"+. c #94A9C6",
"@. c #94ADCC",
"#. c #9BAFCB",
"$. c #9BB2D1",
"%. c #9FB7D5",
"&. c #9DB7D6",
"*. c #A0B4CF",
"=. c #A0B5D0",
"-. c #A7B8D0",
";. c #A6B9D3",
":. c #A0B9D7",
">. c #A9B9D0",
",. c #AABAD1",
"<. c #ADBCD3",
"1. c #B7C6DA",
"2. c #BDC9DB",
"3. c #BAC9DD",
"4. c #BDCADC",
"5. c #C0CCDD",
"6. c #C2CEDE",
"7. c #C6D2E1",
"8. c #C8D4E4",
"9. c #CAD6E5",
"0. c #CBD6E5",
"q. c #C9D7E7",
"w. c #CCD7E6",
"e. c #CDDAE9",
"r. c #D1DBE8",
"t. c #D6DEE9",
"y. c #E3E8F0",
"u. c #E4E9F0",
"i. c #E5EAF1",
"p. c #E6EAF1",
"a. c #E6EBF2",
"s. c #E7EBF2",
"d. c #E8ECF3",
"f. c #E8EDF3",
"g. c #E9EDF3",
"h. c #E9EEF3",
"j. c #EBEFF4",
"k. c #EDF0F5",
"l. c #EDF1F7",
"z. c #EFF2F6",
"x. c #EFF3F7",
"c. c #EFF3F8",
"v. c #F0F3F7",
"b. c #F0F3F8",
"n. c #F1F4F8",
"m. c #F1F5F9",
"M. c #F2F5F9",
"N. c #F9FBFC",
"B. c #FBFCFD",
"V. c #FDFDFE",
"C. c #FEFEFE",
"Z. c #FFFFFF",
"A. c None",
/* pixels */
"A.A.A.A.A.            A.A.A.A.A.",
"A.A.A.A.=  .2.j.j.2...= A.A.A.A.",
"A.A.  x y.>.A 0 0 A ,.u.c   A.A.",
"A.A.B s.z i 6.v.p.-.f S f.M A.A.",
"A.; i.l   Y V.t.z.Z.4.q U a.- A.",
"  O.>.    p f 3 m Z.B.s u 1.+.  ",
"  5.A   & , 6 w | Z.d.g j } 7.O ",
"  k.2 # , 7 e T N.C.{ b n R x.. ",
"  k.8 * 4 w y f.Z.=.N V H ) b.X ",
"  5.D < 9 t k 8.9.J K E W $.w.@ ",
"  O.<.5 r a v o.@.P Q ( ` q.*.. ",
"A.; a.L t d F Z.Z.^ _ [ &.l.> A.",
"A.A.C h.~ h G Z.Z.' [ :.m.I A.A.",
"A.A.  Z g.3.X./ ] %.e.c.! % A.A.",
"A.A.A.A.: #.0.n.M.r.;.1 A.A.A.A.",
"A.A.A.A.A.  + o o $ . A.A.A.A.A."
};

/* XPM */
const char *system_software_update_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 165 2",
"   c #364878",
".  c #774861",
"X  c #6E5471",
"o  c #6F5674",
"O  c #705472",
"+  c #9E080B",
"@  c #991116",
"#  c #A40000",
"$  c #931821",
"%  c #843345",
"&  c #405583",
"*  c #4E648F",
"=  c #516790",
"-  c #506A96",
";  c #576F95",
":  c #5A6B93",
">  c #5B6D94",
",  c #546E98",
"<  c #597199",
"1  c #58749D",
"2  c #5A769F",
"3  c #686284",
"4  c #656588",
"5  c #6B7B9F",
"6  c #5877A2",
"7  c #5C77A1",
"8  c #5978A2",
"9  c #5979A3",
"0  c #5A79A3",
"q  c #5A79A4",
"w  c #5A7AA4",
"e  c #5D7DA6",
"r  c #607AA3",
"t  c #617FA8",
"y  c #4F80B6",
"u  c #5685B7",
"i  c #5686BA",
"p  c #5988BC",
"a  c #5C8ABD",
"s  c #6983A6",
"d  c #768BAD",
"f  c #6D90B7",
"g  c #7591B4",
"h  c #7792B6",
"j  c #7994B6",
"k  c #7A95B7",
"l  c #7E97B9",
"z  c #628FC1",
"x  c #6B96C6",
"c  c #6C96C5",
"v  c #719BC9",
"b  c #759FCB",
"n  c #8593B1",
"m  c #9DA6AE",
"M  c #AEB5BC",
"N  c #8BA7C7",
"B  c #84A6CA",
"V  c #83A7CE",
"C  c #95A7C2",
"Z  c #93ABC7",
"A  c #9EADC5",
"S  c #94ACC8",
"D  c #9AB0CB",
"F  c #9CB2CB",
"G  c #9BB2CC",
"H  c #9DB3CD",
"J  c #9FB4CE",
"K  c #80A7D1",
"L  c #93B6DC",
"P  c #A4B5C9",
"I  c #A5B7C9",
"U  c #A0B4CD",
"Y  c #A3B6CE",
"T  c #AFB8CB",
"R  c #ADB9CE",
"E  c #BABFC4",
"W  c #B8BFC6",
"Q  c #B5BEC8",
"!  c #B4BCCD",
"~  c #A3B8D0",
"^  c #A9BCD1",
"/  c #AABED3",
"(  c #A2BDDA",
")  c #9CBDE0",
"_  c #B7C2CD",
"`  c #BCC4CC",
"'  c #B3C1D0",
"]  c #B1C2D6",
"[  c #BEC7D0",
"{  c #BCC8D4",
"}  c #BECAD6",
"|  c #B4C7DC",
" . c #B7C8DC",
".. c #BECBDA",
"X. c #B8C9DD",
"o. c #BCCDDF",
"O. c #ACCAE9",
"+. c #BECFE1",
"@. c #B3CCE8",
"#. c #B1CEEC",
"$. c #B5D1EE",
"%. c #BED4EB",
"&. c #BCD7F2",
"*. c #C0C6CE",
"=. c #C7CDD2",
"-. c #C4CAD6",
";. c #C8CED4",
":. c #C8CFD5",
">. c #C6CFD8",
",. c #CED0D1",
"<. c #CED1D3",
"1. c #CAD5DF",
"2. c #D1D1D1",
"3. c #D3D3D3",
"4. c #D7D9DB",
"5. c #D9DCDF",
"6. c #DCDDDF",
"7. c #C3D2E3",
"8. c #CCD7E2",
"9. c #CFD9E2",
"0. c #CEDBEA",
"q. c #CCDDEF",
"w. c #DBDEE0",
"e. c #D5DFE9",
"r. c #D6DFE9",
"t. c #D5DFEB",
"y. c #DFE1E3",
"u. c #DCE1E5",
"i. c #D9E1E9",
"p. c #DCE3E9",
"a. c #DCE4ED",
"s. c #C9E1F9",
"d. c #CCE3FA",
"f. c #D4E5F6",
"g. c #D2E5F9",
"h. c #D5E8FC",
"j. c #DAEAFA",
"k. c #DEEDFB",
"l. c #DAEBFC",
"z. c #DEEEFF",
"x. c #DFEFFF",
"c. c #E0E0E0",
"v. c #E2E2E2",
"b. c #E3E4E5",
"n. c #E2E4E6",
"m. c #E4E6E8",
"M. c #EDEEEF",
"N. c #EFEFEF",
"B. c #E6EBF0",
"V. c #E6EBF4",
"C. c #E0EFFF",
"Z. c #E2EFFE",
"A. c #E1F0FF",
"S. c #E2F1FF",
"D. c #E3F1FF",
"F. c #F1F2F3",
"G. c #F4F4F5",
"H. c #F5F5F5",
"J. c #F6F6F6",
"K. c #F8F9F9",
"L. c #F9F9F9",
"P. c #FBFBFB",
"I. c #FDFDFD",
"U. c #FEFEFE",
"Y. c None",
/* pixels */
"Y.              8 6 Y.Y.Y.Y.Y.Y.",
"Y.Y.      5 a.V.t.] l 9 Y.Y.Y.Y.",
"Y.Y., : ! 9.E ..%.} i.Y 0 Y.Y.Y.",
"Y.< : -.<.Z.k.f.{ *.w.B.U w Y.Y.",
"*   T b.1.S.D.j.>.4.G.P.e.j Y.Y.",
"= > 5.q.C.A.A.l.=.[ P Q m.~ w Y.",
"& n / d.z.x.x.0.I.U.I.n.6.o.3 Y.",
"  R O.&.s.h.g.:.U.U.U.L.M 7.O Y.",
"- A _ ;.@.$.#.^ K.F.U.N.,.X.o Y.",
"7 C u.U.y.( ) L B N H.v.m H % # ",
"r k r.U.U.M.V K b c c.3.I d @ # ",
"Y.t F p.J.W v x z p 2.` S . # Y.",
"Y.Y.e D 8.f a i y u ' Z 4 + Y.Y.",
"Y.Y.Y.s h J  .+.| G g X + Y.Y.Y.",
"Y.Y.Y.Y.; 2 0 q 8 1 $ # # # Y.Y.",
"Y.Y.Y.Y.Y.Y.Y.Y.# # # # # # # Y."
};

/* XPM */
const char *utilities_terminal_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 163 2",
"   c #000000",
".  c #010201",
"X  c #020302",
"o  c #060606",
"O  c #060706",
"+  c #070706",
"@  c #070806",
"#  c #080807",
"$  c #090908",
"%  c #0A0B09",
"&  c #0B0C0A",
"*  c #0D0E0C",
"=  c #0F100D",
"-  c #131412",
";  c #181F11",
":  c #182011",
">  c #192011",
",  c #273019",
"<  c #273119",
"1  c #26311A",
"2  c #27311A",
"3  c #27321A",
"4  c #27321B",
"5  c #28321A",
"6  c #28331B",
"7  c #28341B",
"8  c #29331D",
"9  c #29341C",
"0  c #29351C",
"q  c #232423",
"w  c #2F312D",
"e  c #343633",
"r  c #364323",
"t  c #364423",
"y  c #364523",
"u  c #374523",
"i  c #374525",
"p  c #3B4A26",
"a  c #3B4A27",
"s  c #3C4B27",
"d  c #3C4C27",
"f  c #46562B",
"g  c #46572C",
"h  c #4E5E36",
"j  c #4C563D",
"k  c #4C5A3A",
"l  c #4E6132",
"z  c #4F6232",
"x  c #4F6332",
"c  c #536537",
"v  c #545851",
"b  c #555952",
"n  c #5A5E57",
"m  c #5F625B",
"M  c #616E4D",
"N  c #657C41",
"B  c #616A55",
"V  c #62655E",
"C  c #647151",
"Z  c #657152",
"A  c #697850",
"S  c #6A7559",
"D  c #636660",
"F  c #646860",
"G  c #656961",
"H  c #6A6E66",
"J  c #6F736B",
"K  c #737D64",
"L  c #747772",
"P  c #747870",
"I  c #767972",
"U  c #777A73",
"Y  c #787C74",
"T  c #797D75",
"R  c #7D7F79",
"E  c #758954",
"W  c #73825F",
"Q  c #768560",
"!  c #798764",
"~  c #7B8865",
"^  c #7C8967",
"/  c #7A846C",
"(  c #7E8B69",
")  c #7F8C6B",
"_  c #7D8079",
"`  c #7E807A",
"'  c #7E817A",
"]  c #808D6D",
"[  c #859869",
"{  c #828E70",
"}  c #81837D",
"|  c #81837E",
" . c #82857E",
".. c #83867E",
"X. c #849071",
"o. c #849074",
"O. c #8C9D72",
"+. c #8E9F74",
"@. c #90A076",
"#. c #92A279",
"$. c #94A27D",
"%. c #95A47F",
"&. c #848681",
"*. c #868782",
"=. c #878983",
"-. c #878A82",
";. c #888B83",
":. c #8A8C87",
">. c #8B8C87",
",. c #8C8F87",
"<. c #8D8F8A",
"1. c #8D9088",
"2. c #8F918C",
"3. c #91928D",
"4. c #92958D",
"5. c #939590",
"6. c #969893",
"7. c #979A92",
"8. c #989995",
"9. c #989996",
"0. c #9A9B97",
"q. c #999C94",
"w. c #97A681",
"e. c #99A38A",
"r. c #9DA098",
"t. c #A2B387",
"y. c #A4B58A",
"u. c #A5B68D",
"i. c #A8B88E",
"p. c #A0A19D",
"a. c #A2A59C",
"s. c #A3A69D",
"d. c #A3A69E",
"f. c #A9B990",
"g. c #AABA92",
"h. c #ACBC94",
"j. c #AEBD97",
"k. c #AFBE98",
"l. c #B1BF9B",
"z. c #B0B1AE",
"x. c #B2B4B1",
"c. c #B4B6B1",
"v. c #B7B9B4",
"b. c #C0C1BE",
"n. c #CCCDCB",
"m. c #CDCECC",
"M. c #CDD2C6",
"N. c #CED1C8",
"B. c #CFD3CB",
"V. c #D3D6CD",
"C. c #D6D7D5",
"Z. c #D7D7D5",
"A. c #D7D8D6",
"S. c #D7D8D7",
"D. c #D9DED4",
"F. c #DBDBD9",
"G. c #DDDDDC",
"H. c #DDDEDC",
"J. c #DDDEDD",
"K. c #E0E3DB",
"L. c #ECEDEA",
"P. c #F2F3F1",
"I. c None",
/* pixels */
"I.r.q.4.1.;...' T P J H G V n I.",
"s.c.Z.J.H.G.G.G.G.G.G.F.n.x.L b ",
"s.C.e # # # # # # # # + + w 9.b ",
"a.S.= l.k.j.h.g.f.i.u.y.t.  0.v ",
"a.S.* o.X.{ ] ) ( ^ ~ ! Q   6.v ",
"a.S.& w.%.$.#.@.+.O.[ E N   5.v ",
"a.S.% S D./ Z C M h f f g   3.v ",
"a.S.$ W e.K.M.A c l z z x   <.v ",
"a.S.@ j B B.V.i r t t y u   :.v ",
"a.S.+ k N.K a p p p s s d   =.v ",
"a.S.+ 8 2 , < P.P.P.L.5 5   &.v ",
"a.S.O 1 3 4 4 6 6 7 9 9 0   } v ",
"a.S.o ; ; ; ; ; ; ; : > >   ` v ",
"s.A.q X . . . . . . . . . - I b ",
"d.v.m.b.z.p.8.5.2.>.*.| R U D b ",
"I.r.7.4.,.-. ._ Y P J H F m n I."
};

/* XPM */
const char *emblem_symbolic_link_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 70 1",
"  c #888A85",
". c #AAABA8",
"X c #B6B7B4",
"o c #BFC0BE",
"O c #C0C1BF",
"+ c #C1C2C0",
"@ c #C7C8C6",
"# c #E3E3E3",
"$ c #E4E3E4",
"% c #E4E4E4",
"& c #E4E5E4",
"* c #E4E4E5",
"= c #E5E5E5",
"- c #E5E6E5",
"; c #E6E6E6",
": c #E6E7E6",
"> c #E7E7E6",
", c #E8E8E8",
"< c #E9E8E8",
"1 c #E8E8E9",
"2 c #E8E9E9",
"3 c #E9E9E9",
"4 c #EAE9E9",
"5 c #E9E9EA",
"6 c #EAEAEA",
"7 c #EBEAEA",
"8 c #EAEBEA",
"9 c #EAEBEB",
"0 c #EBEBEB",
"q c #ECECEB",
"w c #ECEBEC",
"e c #ECECEC",
"r c #EDEDED",
"t c #EDEEED",
"y c #EDEDEE",
"u c #EEEEEE",
"i c #EFEFEE",
"p c #EFEEEF",
"a c #EFEFEF",
"s c #EFF0EF",
"d c #F0F0F0",
"f c #F1F1F1",
"g c #F2F1F1",
"h c #F1F2F1",
"j c #F2F2F1",
"k c #F2F1F2",
"l c #F2F2F2",
"z c #F3F3F3",
"x c #F3F3F4",
"c c #F4F4F4",
"v c #F5F5F4",
"b c #F4F5F5",
"n c #F5F5F5",
"m c #F6F5F6",
"M c #F5F6F6",
"N c #F6F6F6",
"B c #F7F6F6",
"V c #F8F8F8",
"C c #F9F9F9",
"Z c #F9FAF9",
"A c #FAFAFA",
"S c #FBFAFB",
"D c #FBFBFB",
"F c #FCFBFB",
"G c #FCFCFC",
"H c #FDFDFC",
"J c #FDFDFD",
"K c #FEFEFE",
"L c #FFFFFF",
"P c None",
/* pixels */
"P              P",
" LLLLLLLLLLLLLL ",
" L############J ",
" L############J ",
" L###%=;:;-*$#J ",
" L#%oX..O42.;&D ",
" L%@<6...+..3>D ",
" L;10ri.....q5V ",
" L,9rahz....uwN ",
" L4eajc.....dra ",
" L8yfx......gpa ",
" L0ukvVDHFCmzsa ",
" L9uknVDKGCMzaa ",
" L7tfcBCSZVblaa ",
" LGGGGGGAAANNNa ",
"P              P"
};

/* XPM */
const char *emblems_system_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 17 1",
"  c #676965",
". c #71736F",
"X c #777975",
"o c #888A84",
"O c #888A85",
"+ c #898B87",
"@ c #8D8F8A",
"# c #8F918C",
"$ c #979993",
"% c #A2A3A0",
"& c #B8BAB4",
"* c #BDBFB9",
"= c #C0C0BE",
"- c #C7CAC3",
"; c #D3D7CF",
": c #EEEEEC",
"> c None",
/* pixels */
">>>>>>>>>>>>>>>>",
">>>>>>OOO>>>>>>>",
">>>OO>O:O>OO>>>>",
">>O:=O%;%O=:O>>>",
">>O=;;;;;;;=O>>>",
">>>O;&o$o*;O>>>>",
">OO%;o.> +;%OO>>",
">O:;;$>>>$;;:O>>",
">OO%;@#>Xo;%OO>>",
">>>O:&@$o-;O>>>>",
">>O=;;;;;;;=O>>>",
">>O:=O%;%O=:O>>>",
">>>OO>O:O>OO>>>>",
">>>>>>OOO>>>>>>>",
">>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>"
};

/* XPM */
const char *dialog_information_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 116 2",
"   c #303030",
".  c #393936",
"X  c #5E5E3E",
"o  c #3A4A77",
"O  c #3A4B77",
"+  c #3B4B77",
"@  c #3D4C76",
"#  c #3D4D76",
"$  c #384978",
"%  c #384A79",
"&  c #394A79",
"*  c #394B7A",
"=  c #3A4B7A",
"-  c #3B4C78",
";  c #3C4D78",
":  c #3E4E79",
">  c #464646",
",  c #435177",
"<  c #40507A",
"1  c #41517B",
"2  c #45547E",
"3  c #46557F",
"4  c #4A577A",
"5  c #80805C",
"6  c #8A8B66",
"7  c #475780",
"8  c #485883",
"9  c #4B5B83",
"0  c #495985",
"q  c #4A5A86",
"w  c #546083",
"e  c #586383",
"r  c #5E6880",
"t  c #4B7EB2",
"y  c #5E8DBA",
"u  c #608EBC",
"i  c #7E91B1",
"p  c #7E90B2",
"a  c #779DC5",
"s  c #789DC4",
"d  c #A8AA84",
"f  c #A6AC98",
"g  c #A7AD98",
"h  c #ABB198",
"j  c #8C9BB8",
"k  c #8D9CB8",
"l  c #98A4BD",
"z  c #9AA5BE",
"x  c #DDDFAB",
"c  c #D3D5B0",
"v  c #E3E6BA",
"b  c #87A8CC",
"n  c #91AECD",
"m  c #9BAEC8",
"M  c #9DB9D6",
"N  c #A4ADC3",
"B  c #A5BED8",
"V  c #A6BED8",
"C  c #A9C0D9",
"Z  c #AAC1D9",
"A  c #B7C2D5",
"S  c #B9C4D6",
"D  c #B5C6DA",
"F  c #B5C7DB",
"G  c #B5CAE0",
"H  c #C1CCD7",
"J  c #EBEDC1",
"K  c #F3F6C9",
"L  c #F5F8CA",
"P  c #C2D0E0",
"I  c #C0D0E3",
"U  c #C5D2E1",
"Y  c #C1D2E4",
"T  c #C2D3E4",
"R  c #C3D3E4",
"E  c #C5D5E5",
"W  c #C7D6E5",
"Q  c #C9D6E7",
"!  c #C8D7E8",
"~  c #CBD9E8",
"^  c #CCD9E8",
"/  c #CEDBE9",
"(  c #D0D5E0",
")  c #D2DAE2",
"_  c #D0DDEB",
"`  c #D3DFEB",
"'  c #D4E0EC",
"]  c #D4E0ED",
"[  c #D6E1ED",
"{  c #D8E2ED",
"}  c #D9E3EE",
"|  c #DEE7F1",
" . c #DFE7F2",
".. c #DFE8F2",
"X. c #E0E5ED",
"o. c #E0E6EC",
"O. c #E2E7EF",
"+. c #E0E9F2",
"@. c #E2EAF3",
"#. c #E8EFF4",
"$. c #E8EFF5",
"%. c #EDEFF4",
"&. c #EBF0F5",
"*. c #EBF0F6",
"=. c #ECF1F7",
"-. c #EFF3F7",
";. c #EEF3F8",
":. c #F3F7FA",
">. c #F4F7FA",
",. c #F5F8FA",
"<. c #F7F9FB",
"1. c #FAFBFD",
"2. c #FAFCFD",
"3. c #FCFCFD",
"4. c #FFFFFF",
"5. c None",
/* pixels */
"5.5.5.5.5.+ o $ % O @ 5.5.5.5.5.",
"5.5.5.5.- N %.3.<.O.z : 5.5.5.5.",
"5.5.5.; ( ,.#.@.} ` { S 1 5.5.5.",
"5.5.# N ,.-.>.*...] T E k , 5.5.",
"5.5.< %.$.:.2.=. ._ Y s U 3 5.5.",
"5.5.& 1.+.;.4.4.4.4.H 5./ * 5.5.",
"5.5.= >.[ | 4.&.o.) n 5.Q * 5.5.",
"5.5.2 X.~ ! 4.I G M 5.u F 8 5.5.",
"5.5.4 l ' V 4.B b 5.t Z i w 5.5.",
"5.5.5.7 A R a 4.5.y C m 0 5.5.5.",
"5.5.5.5.7 j P ^ W D p q 5.5.5.5.",
"5.5.5.5.5.e 9 f g h r 5.5.5.5.5.",
"5.5.5.5.5.5.X J L x X 5.5.5.5.5.",
"5.5.5.5.5.5.X 5 d 6 X 5.5.5.5.5.",
"5.5.5.5.5.5.X v K c X 5.5.5.5.5.",
"5.5.5.5.5.5.5.. >   5.5.5.5.5.5."
};

/* XPM */
const char *executable_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 67 1",
"  c #364878",
". c #486490",
"X c #516A96",
"o c #566F99",
"O c #5F7A9F",
"+ c #7182AA",
"@ c #7382AB",
"# c #7483AB",
"$ c #7584AC",
"% c #7786AD",
"& c #7A87AF",
"* c #7A88AE",
"= c #7B88AF",
"- c #7C89B0",
"; c #7D89B1",
": c #7C8CB0",
"> c #7C8EB0",
", c #7F90B1",
"< c #858EB5",
"1 c #858FB5",
"2 c #8790B6",
"3 c #8394B4",
"4 c #8991B7",
"5 c #8895B7",
"6 c #8F9BBB",
"7 c #8E9CBB",
"8 c #8D9EBA",
"9 c #8D9FBA",
"0 c #9197BC",
"q c #9099BC",
"w c #949ABE",
"e c #95A2BF",
"r c #9D9FC3",
"t c #98A2C1",
"y c #99A3C2",
"u c #9BABC3",
"i c #9FAEC6",
"p c #A1AAC6",
"a c #A0AFC6",
"s c #A2AEC7",
"d c #A3B1C8",
"f c #A5B0C8",
"g c #A7B1C9",
"h c #A4B2C8",
"j c #A5B2C9",
"k c #A7B2CA",
"l c #A7B4CA",
"z c #A9B3CB",
"x c #A8B4CB",
"c c #A9B5CB",
"v c #ACB0CC",
"b c #ABB5CD",
"n c #AAB6CC",
"m c #ABB6CC",
"M c #ACB7CD",
"N c #ADB8CE",
"B c #AEB9CE",
"V c #AFB9CF",
"C c #B0BACF",
"Z c #B1BBD0",
"A c #B2BBD1",
"S c #B3BCD1",
"D c #BFC4D8",
"F c #C1C5D9",
"G c #C3C7DA",
"H c #C8CADD",
"J c None",
/* pixels */
"JJJJJJJ JJJJJJJJ",
"JJJJJJ G JJJJJJJ",
"JJJJJ GuO JJJJJJ",
"JJJJ Gia9. JJJJJ",
"JJJ Gdhj8Xo JJJJ",
"JJ Glxcn>3,o JJJ",
"J GmMNBs:ez+o JJ",
" GVCZAk7bS%@$o J",
"J Ggf65#py=;o JJ",
"JJ G*&-tDq1o JJJ",
"JJJ G<24Fwo JJJJ",
"JJJJ G0vHo JJJJJ",
"JJJJJ Gro JJJJJJ",
"JJJJJJ o JJJJJJJ",
"JJJJJJJ JJJJJJJJ",
"JJJJJJJJJJJJJJJJ"
};

/* XPM */
const char *other_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 82 1",
"  c #CE5C00",
". c #DF8D14",
"X c #DF8E17",
"o c #DE901E",
"O c #E18F16",
"+ c #E29018",
"@ c #E29119",
"# c #E39119",
"$ c #E4931B",
"% c #E5941D",
"& c #E69721",
"* c #E69825",
"= c #E59828",
"- c #EFA231",
"; c #EAA238",
": c #EAA33A",
"> c #F1A332",
", c #E5A444",
"< c #EBA847",
"1 c #EFAA45",
"2 c #EBAB4C",
"3 c #E9AA4F",
"4 c #EFAE4D",
"5 c #F5AD43",
"6 c #F2AF4F",
"7 c #EFB35C",
"8 c #F1B55C",
"9 c #E8B365",
"0 c #EAB566",
"q c #EDB665",
"w c #EEBA6D",
"e c #EEBB6F",
"r c #F1BA69",
"t c #EFC17E",
"y c #F6C47B",
"u c #FAC579",
"i c #F3C889",
"p c #F2CA8E",
"a c #F4CA8D",
"s c #F4CB8F",
"d c #F4CC8F",
"f c #F8CC8B",
"g c #FACD8B",
"h c #EFCB96",
"j c #F3CB90",
"k c #F3CC91",
"l c #F4CC91",
"z c #F4CD92",
"x c #F5CE93",
"c c #F1CC97",
"v c #F1CD97",
"b c #F6CE94",
"n c #F6CE95",
"m c #F2CE9B",
"M c #F1CE9C",
"N c #F1CE9D",
"B c #F1CF9E",
"V c #F7D095",
"C c #F7D096",
"Z c #F8D197",
"A c #F8D198",
"S c #F9D299",
"D c #F9D399",
"F c #FBD49C",
"G c #FBD59C",
"H c #FDD79F",
"J c #F8D1A0",
"K c #F8D1A1",
"L c #F7D7AF",
"P c #F4D8AE",
"I c #F3D9B4",
"U c #F5DBB8",
"Y c #F9DCB9",
"T c #F8DDBD",
"R c #F8DEBD",
"E c #FAE0BF",
"W c #F5DFC2",
"Q c #F8DFC0",
"! c #FAE1C1",
"~ c #FBEAD3",
"^ c #F9EAD5",
"/ c None",
/* pixels */
"////////////////",
"///////  ///////",
"////// WI //////",
"///// U9oh /////",
"//// N,0X.c ////",
"/// MO3t=#+v ///",
"// m@$e<&2wqP //",
"/ B#%;i7rsljp^ /",
"/ R*:a48bbxzkQ /",
"// Ld16yZCVnQ //",
"/// Y->fDSA! ///",
"//// K5gGF! ////",
"///// JuH~ /////",
"////// TE //////",
"///////  ///////",
"////////////////"
};

/* XPM */
const char *folder_open_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 69 1",
"  c #555753",
". c #595B57",
"X c #5D5F5B",
"o c #61635F",
"O c #455D79",
"+ c #636561",
"@ c #676965",
"# c #6A6C68",
"$ c #6D6F6B",
"% c #3F6086",
"& c #3E6089",
"* c #3465A4",
"= c #436B9D",
"- c #537196",
"; c #58769B",
": c #4E7AB1",
"> c #5C84B7",
", c #6D85A4",
"< c #7C8EA4",
"1 c #6395CC",
"2 c #6496CC",
"3 c #6597CC",
"4 c #6598CD",
"5 c #6698CC",
"6 c #6898CD",
"7 c #6899CD",
"8 c #6999CD",
"9 c #6A9ACD",
"0 c #6B9ACD",
"q c #6B9BCD",
"w c #6A9ACE",
"e c #6C9BCE",
"r c #6D9CCE",
"t c #6E9CCE",
"y c #6E9DCE",
"u c #7D9DC6",
"i c #709DCF",
"p c #709ECE",
"a c #729FCF",
"s c #76A2D0",
"d c #7CA6D2",
"f c #969795",
"g c #A6A6A6",
"h c #A7A7A7",
"j c #A8A8A8",
"k c #A9ABA9",
"l c #C0C0BF",
"z c #81A9D4",
"x c #85ACD5",
"c c #88AED6",
"v c #89AED6",
"b c #89AFD7",
"n c #8AAFD7",
"m c #8BB0D7",
"M c #8CB1D8",
"N c #94B6DB",
"B c #9ABADE",
"V c #9CBBDD",
"C c #9EBDDE",
"Z c #A6C2E0",
"A c #A7C3E0",
"S c #AEC7E3",
"D c #AFC8E3",
"F c #B1CAE4",
"G c #B9CFE7",
"H c #C6C6C5",
"J c #C9C9C9",
"K c #CECECE",
"L c None",
/* pixels */
"L$$$$$@@LLLLLLLL",
"$KKKKKKH+LLLLLLL",
"#lfffffff     LL",
"@Jggggggggghj LL",
"olfffffffffff LL",
"XJggggggggghj LL",
"Xlf************=",
".Jg*SDDDDDDDDDG*",
" lf:AMMMMMMMMMS*",
" J<>AMMMMMMMMMS*",
" l,uAMMMMMMMMvZ*",
" J*FmMmncxzdsaV*",
" l;Cpiytreqw87N*",
" kbq098654321B-O",
"&*************%L",
"LLLLLLLLLLLLLLLL"
};

/* XPM */
const char *waterfall_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 5 1",
" 	c None",
".	c #124188",
"+	c #788D9B",
"@	c #ABCBE2",
"#	c #204A87",
"                ",
" ..+..@@@@..+.. ",
" ..+..@@@@..+.. ",
" ..+..@@@@..+.. ",
" ..+..@##@..+.. ",
" ..+..@@@@..+.. ",
" ..+..@@@@..+.. ",
" ..+..@@@@..+.. ",
" ..+..@@@@..+.. ",
" ..+..@##@..+.. ",
" ..+..@@@@..+.. ",
" ..+..@@@@..+.. ",
" ..+..@##@..+.. ",
" ..+..@@@@..+.. ",
" ..+..@##@..+.. ",
"                "};

/* XPM */
const char *dice_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 5 1",
" 	c None",
".	c #888A85",
"+	c #FDF2D2",
"@	c #740404",
"#	c #A50101",
"................",
".++++++++++++++.",
".++@@#++++@@#++.",
".++@##++++@##++.",
".++###++++###++.",
".++++++++++++++.",
".++@@#++++@@#++.",
".++@##++++@##++.",
".++###++++###++.",
".++++++++++++++.",
".++@@#++++@@#++.",
".++@##++++@##++.",
".++###++++###++.",
".++++++++++++++.",
"................",
"                "}
;


/* XPM */
const char *preferences_system_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 44 1",
"  c #204A87",
". c #7D8385",
"X c #748AA2",
"o c #788DA4",
"O c #728BAE",
"+ c #7D91A7",
"@ c #7C93B3",
"# c #7A95B4",
"$ c #7A95B5",
"% c #888A85",
"& c #8A8C87",
"* c #A0A19E",
"= c #869CB8",
"- c #92A5BE",
"; c #A4A4A3",
": c #ABACA9",
"> c #ADADAA",
", c #B8B7B5",
"< c #B9B8B7",
"1 c #BAB9B6",
"2 c #BFBEBD",
"3 c #ADBBCC",
"4 c #BDC8D4",
"5 c #C4C3C2",
"6 c #C6C4C2",
"7 c #CAC9C8",
"8 c #D2D1D0",
"9 c #D4D3D2",
"0 c #D4D3D3",
"q c #E4E3E2",
"w c #E5E3E2",
"e c #ECEBE9",
"r c #ECECEA",
"t c #EEEEEC",
"y c #EEEEED",
"u c #EFEFEE",
"i c #F0F0EE",
"p c #F0F0EF",
"a c #F0F0F0",
"s c #F3F3F3",
"d c #F6F6F5",
"f c #F7F7F7",
"g c #FAFAFA",
"h c None",
/* pixels */
"hhhhhhhhhhhhhhhh",
"hhhh%hhhhhhhh%hh",
"hhh%e%hhhhhh%u%h",
"hhhh%i%hhhh%a%hh",
"h%hh%g%hhhh%&hhh",
"%d:%fw>thh%hhhhh",
"h%spyr1%h%hhhhhh",
"hh%%%%8;%%hhhhhh",
"hhhhhh,%<%hhhhhh",
"hhh   .>72%hhhhh",
"hh 33@ %%02%hhhh",
"h 4oo- hh%q6%%hh",
" 3oX#@ hhh%95%hh",
" 3+$O hhhhh%*%hh",
" -== hhhhhh%%%hh",
"h   hhhhhhhhhhhh"
};

/* XPM */
const char *preferences_desktop_font_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 78 1",
"  c #000000",
". c #010101",
"X c #040404",
"o c #050505",
"O c #060606",
"+ c #202020",
"@ c #222222",
"# c #2C2C2C",
"$ c #2E2E2E",
"% c #2F2F2F",
"& c #343434",
"* c #474747",
"= c #484848",
"- c #494949",
"; c #4A4A4A",
": c #4B4B4B",
"> c #4D4D4D",
", c #565656",
"< c #5F5F5F",
"1 c #626262",
"2 c #666666",
"3 c #747474",
"4 c #767676",
"5 c #797979",
"6 c #7C7C7C",
"7 c #828282",
"8 c #888A85",
"9 c #A7A7A7",
"0 c #ADADAD",
"q c #B1B1B1",
"w c #B8B9B8",
"e c #BFBFBF",
"r c #CECECE",
"t c #D3D3D3",
"y c #DBDBDB",
"u c #E2E2E2",
"i c #E3E3E3",
"p c #E4E3E4",
"a c #E4E4E4",
"s c #E4E5E4",
"d c #E4E4E5",
"f c #E5E6E5",
"g c #E6E6E6",
"h c #E6E7E6",
"j c #E7E7E6",
"k c #E8E7E7",
"l c #E8E8E8",
"z c #E8E9E9",
"x c #E9E9E9",
"c c #EAE9E9",
"v c #E9E9EA",
"b c #EBEAEA",
"n c #EAEBEA",
"m c #EAEBEB",
"M c #EBEBEB",
"N c #ECECEB",
"B c #ECEBEC",
"V c #ECECEC",
"C c #ECEDEC",
"Z c #EDEDED",
"A c #EEEEEE",
"S c #EFEFEF",
"D c #F0F0F0",
"F c #F1F1F1",
"G c #F2F2F2",
"H c #F3F3F3",
"J c #F4F4F4",
"K c #F5F5F5",
"L c #F6F6F6",
"P c #F7F7F7",
"I c #F8F8F8",
"U c #F9F9F9",
"Y c #FAFAFA",
"T c #FBFBFB",
"R c #FCFCFC",
"E c #FDFDFD",
"W c #FFFFFF",
"Q c None",
/* pixels */
"Q88888888888888Q",
"8WWWWWWWWWWWWWW8",
"8Wi97%%iggggiiE8",
"8Wiuyr%ilxlliiE8",
"8Wiq%3%ghgfdpiE8",
"8Wi%te%xxczkgsT8",
"8Wa%%%w:%CBmxjT8",
"8WgVZAS*#DSANvI8",
"8WlZSDF=+& .1GL8",
"8WcSDGH= 4G2 qS8",
"8WnDGHK-oHUy 6S8",
"8WMFHJL-OFTt 4S8",
"8WmGJLP; 5P< 0S8",
"8WbGJLI,$@X >PS8",
"8WRRRRRRYYYLLLS8",
"Q88888888888888Q"
};

/* XPM */
const char *system_search_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 127 2",
"   c #646662",
".  c #666864",
"X  c #676965",
"o  c #686966",
"O  c #696B66",
"+  c #6A6B68",
"@  c #6B6B6B",
"#  c #6A6C68",
"$  c #6B6D69",
"%  c #6C6E69",
"&  c #6C6D6A",
"*  c #6C6E6A",
"=  c #6D6F6A",
"-  c #6C6E6B",
";  c #6D6E6B",
":  c #6D6F6C",
">  c #6E706B",
",  c #6F706C",
"<  c #6F716C",
"1  c #70716D",
"2  c #747672",
"3  c #767875",
"4  c #7A7C78",
"5  c #7F807D",
"6  c #5980AD",
"7  c #5C85B3",
"8  c #618AB9",
"9  c #6690BF",
"0  c #6893C2",
"q  c #6994C5",
"w  c #6D97C5",
"e  c #6E9AC9",
"r  c #6F9BCA",
"t  c #6F9CCD",
"y  c #729DCF",
"u  c #719ECE",
"i  c #729ECE",
"p  c #729FCE",
"a  c #739FCE",
"s  c #729ECF",
"d  c #729FCF",
"f  c #739FCF",
"g  c #76A0CD",
"h  c #75A1CF",
"j  c #78A1CD",
"k  c #838580",
"l  c #828481",
"z  c #848682",
"x  c #858784",
"c  c #868785",
"v  c #888A85",
"b  c #898B88",
"n  c #898A89",
"m  c #8F908F",
"M  c #919291",
"N  c #939592",
"B  c #A3A4A1",
"V  c #A7A8A6",
"C  c #A8A9A8",
"Z  c #B7B7B5",
"A  c #B8B8B7",
"S  c #8AA6C5",
"D  c #8EA8C5",
"F  c #81A3CA",
"G  c #85A6CA",
"H  c #89A9CB",
"J  c #96A9C1",
"K  c #9BADC2",
"L  c #9EAFC4",
"P  c #80A7D4",
"I  c #8FB1D9",
"U  c #96B3D2",
"Y  c #97B4D3",
"T  c #97B8DB",
"R  c #ADBACA",
"E  c #A2BEDF",
"W  c #B9CADC",
"Q  c #ACC6E2",
"!  c #AEC8E3",
"~  c #B4CCE6",
"^  c #B6CDE6",
"/  c #C2C2C2",
"(  c #C4C4C4",
")  c #C7C7C7",
"_  c #C9C9C8",
"`  c #CACAC9",
"'  c #CBCBCA",
"]  c #CBCCCA",
"[  c #C5CCD2",
"{  c #D6D6D6",
"}  c #D1D5D9",
"|  c #D4D6D9",
" . c #D7D8DA",
".. c #D9D9D8",
"X. c #DADAD9",
"o. c #D8DADB",
"O. c #DADADA",
"+. c #DADBDB",
"@. c #DBDBDB",
"#. c #DADBDC",
"$. c #DEDEDE",
"%. c #DFDFDF",
"&. c #C0D3E9",
"*. c #C7D8EB",
"=. c #C7D9EC",
"-. c #CBDBEC",
";. c #CEDDED",
":. c #D1D9E1",
">. c #D2D9E0",
",. c #D5DCE4",
"<. c #DBE2E9",
"1. c #D1E0F0",
"2. c #D3E1F0",
"3. c #D5E2F0",
"4. c #D6E2F1",
"5. c #D7E4F1",
"6. c #D9E4F1",
"7. c #DFE9F3",
"8. c #E2E2E2",
"9. c #E0E9F3",
"0. c #E0E9F4",
"q. c #E3EBF4",
"w. c #E2EBF5",
"e. c #E3EBF5",
"r. c #E7EEF7",
"t. c #ECF2F8",
"y. c None",
/* pixels */
"y.y.y.y.3 , 1 > = 4 y.y.y.y.y.y.",
"y.y.y.: ] #.| }  .` - y.y.y.y.y.",
"y.y.< +.J w h p 0 K $.> y.y.y.y.",
"y.* O.S d *.w.7.! p D @.$ y.y.y.",
"y.V L p 4.r.t.e.1.T u R B y.y.y.",
"O X.9 Q 6.0.q.9.;.P s F ..O y.y.",
"> o.u ~ -.2.5.3.y.y.y u 8.> y.y.",
"% %.g I ^ =.&.E y.y.f e @.% y.y.",
"k ( G q y y.y.y.y.y.8 H _ z y.y.",
"y.l :.p t y.y.i y.y.p >.X y.y.y.",
"y.# C W p 7 y.r 6 a [ N c o y.y.",
"y.y.% M <.U j p Y ,.+ A x 2 . y.",
"y.y.y.# 5 m / %.n   y.; Z b ) & ",
"y.y.y.y.y.v % % v y.y.@ & ' { & ",
"y.y.y.y.y.y.y.y.y.y.y.y.y.& & y.",
"y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y."
};

/* XPM */
const char *utilities_system_monitor_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 115 2",
"   c #7D7D7A",
".  c #7E7E7B",
"X  c #829B7A",
"o  c #829C7C",
"O  c #849E7C",
"+  c #BBC774",
"@  c #204A87",
"#  c #265987",
"$  c #2C5D8E",
"%  c #2C6090",
"&  c #2C6292",
"*  c #2C6294",
"=  c #2F6697",
"-  c #316696",
";  c #316697",
":  c #316A99",
">  c #316A9A",
",  c #346A9A",
"<  c #316C9B",
"1  c #346E9D",
"2  c #346E9E",
"3  c #34709E",
"4  c #3772A1",
"5  c #3772A2",
"6  c #3A74A3",
"7  c #3D77A6",
"8  c #3D77A7",
"9  c #3D79A7",
"0  c #3D7BA8",
"q  c #3D7CAA",
"w  c #407EAB",
"e  c #4280AC",
"r  c #4280AD",
"t  c #4283AE",
"y  c #4284AF",
"u  c #4584B1",
"i  c #4587B1",
"p  c #4887B3",
"a  c #488AB5",
"s  c #4A8DB7",
"d  c #4D8DB7",
"f  c #4D8EB9",
"g  c #4D8FBA",
"h  c #5294BE",
"j  c #5495BF",
"k  c #7792B5",
"l  c #85A180",
"z  c #85A280",
"x  c #87A481",
"c  c #89A483",
"v  c #89A584",
"b  c #8BA785",
"n  c #8BAA86",
"m  c #8CAA86",
"M  c #8EAC89",
"N  c #90AE8B",
"B  c #90AF8B",
"V  c #91B08C",
"C  c #93B28E",
"Z  c #94B48F",
"A  c #96B590",
"S  c #96B691",
"D  c #97B893",
"F  c #8199BA",
"G  c #B4B6B1",
"H  c #B4B7B1",
"J  c #B6C496",
"K  c #B7C699",
"L  c #BACA9C",
"P  c #BECE9F",
"I  c #BFCFA0",
"U  c #EEE788",
"Y  c #D3D9A5",
"T  c #D5DBA7",
"R  c #E7E8B0",
"E  c #EDEAB0",
"W  c #98C0D9",
"Q  c #BAD1E1",
"!  c #C9CCC6",
"~  c #CBCEC9",
"^  c #CCCFCA",
"/  c #D0D2CE",
"(  c #D3D6D1",
")  c #D5D7D3",
"_  c #D7D9D5",
"`  c #DADCD8",
"'  c #DBDCD9",
"]  c #DCDDDB",
"[  c #DEE0DD",
"{  c #DFE1DD",
"}  c #D6E3ED",
"|  c #D6E4ED",
" . c #D7E5EF",
".. c #D8E6EF",
"X. c #E2E3E0",
"o. c #E4E5E2",
"O. c #E5E7E4",
"+. c #E9EAE8",
"@. c #EEEEED",
"#. c #E9F1F6",
"$. c #EFF4F8",
"%. c #F4F5F3",
"&. c #F6F7F6",
"*. c #F0F5F8",
"=. c #F0F5F9",
"-. c #F1F6F9",
";. c #F5F8FA",
":. c #F6F8FB",
">. c #F8F9F8",
",. c #F9F9F8",
"<. c #F9FAF9",
"1. c #FAFBFA",
"2. c #FEFEFE",
"3. c #FFFFFF",
"4. c None",
/* pixels */
". . . . . . . . . . . . . . .   ",
". ,.>.3.3.3.3.3.3.3.3.2.1.1.1.. ",
". ,.k @ @ @ @ @ @ @ @ @ @ k ] . ",
". 2.@ # $ * X o < > : - & @ O.. ",
". 2.@ % ; O E z 6 6 5 3 , @ X.. ",
". 2.@ = 2 J $.K b q 0 7 4 @ [ . ",
". 2.@ 1 x Y Q | M u t w 9 @ ' . ",
". 2.@ l v } L  .V + B M n @ _ . ",
". 2.@ ;.:.T V ..P U -.=.*.@ ( . ",
". 2.@ c m N C I #.W Z V M @ / . ",
". 2.@ 8 r p f S R D A d u @ ^ . ",
". 2.@ 7 e i s Z j h g a y @ ! . ",
". ,.F @ @ @ @ @ @ @ @ @ @ k G . ",
". ,.&.<.%.@.+.o.{ ` ) / ~ H H . ",
". . . . . . . . . . . . . . .   ",
"4.4.4.4.4.4.4.4.4.4.4.4.4.4.4.4."
};












/* XPM */
const char *system_users_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 146 2",
"   c #6C3F3B",
".  c #624F0D",
"X  c #6D4A0A",
"o  c #685D14",
"O  c #616B09",
"+  c #616519",
"@  c #687214",
"#  c #6E771D",
"$  c #596921",
"%  c #6A692B",
"&  c #6A6A2B",
"*  c #6D712F",
"=  c #6F7131",
"-  c #767B35",
";  c #797F37",
":  c #55315F",
">  c #5C3B59",
",  c #723C51",
"<  c #5A3464",
"1  c #5C3566",
"2  c #465440",
"3  c #7E6040",
"4  c #614D7E",
"5  c #645370",
"6  c #864F06",
"7  c #815107",
"8  c #885106",
"9  c #8E5105",
"0  c #955104",
"q  c #9F5203",
"w  c #9E5807",
"e  c #A35403",
"r  c #B85410",
"t  c #BA5C11",
"y  c #BF6C10",
"u  c #815330",
"i  c #965435",
"p  c #90563F",
"a  c #AA7722",
"s  c #AF7D2E",
"d  c #BC7625",
"f  c #CD5C00",
"g  c #CC5E01",
"h  c #CC5E04",
"j  c #C16404",
"k  c #C4680A",
"l  c #D56402",
"z  c #D16604",
"x  c #C16710",
"c  c #C77D28",
"v  c #844240",
"b  c #895443",
"n  c #905841",
"m  c #8B6B58",
"M  c #AF8033",
"N  c #B68134",
"B  c #B88530",
"V  c #B98633",
"C  c #C2893C",
"Z  c #DF8E3A",
"A  c #E0992A",
"S  c #E09B2D",
"D  c #E3A23C",
"F  c #E1A23E",
"G  c #868F41",
"H  c #B78940",
"J  c #BC8E43",
"K  c #B99355",
"L  c #C38F44",
"P  c #D08F4A",
"I  c #C29142",
"U  c #C0934B",
"Y  c #D8994A",
"T  c #C49A52",
"R  c #CB9A51",
"E  c #CF9D51",
"W  c #DDA053",
"Q  c #DCA552",
"!  c #D1A55F",
"~  c #DDAB5E",
"^  c #E3A340",
"/  c #E5A746",
"(  c #E6AA4D",
")  c #E6A251",
"_  c #E3A256",
"`  c #E5A255",
"'  c #E6AD54",
"]  c #E5AE5C",
"[  c #EBAA5B",
"{  c #E8AA5C",
"}  c #C99C66",
"|  c #D9AC64",
" . c #DAAE6D",
".. c #E2B369",
"X. c #ECB868",
"o. c #F1BD6F",
"O. c #EBBC74",
"+. c #ECBD74",
"@. c #F3BE71",
"#. c #EFC075",
"$. c #3D538B",
"%. c #3E558E",
"&. c #30609D",
"*. c #32629E",
"=. c #32629F",
"-. c #3263A1",
";. c #3264A1",
":. c #3364A2",
">. c #3364A3",
",. c #3466A4",
"<. c #3466A5",
"1. c #3467A7",
"2. c #3568A8",
"3. c #3568A9",
"4. c #366AAC",
"5. c #366BAD",
"6. c #3B6EAE",
"7. c #386DB1",
"8. c #485F99",
"9. c #4F649A",
"0. c #4071AF",
"q. c #4172AF",
"w. c #4576B2",
"e. c #4A78B2",
"r. c #547FB5",
"t. c #5680B5",
"y. c #5E83B2",
"u. c #5981B4",
"i. c #5F86B7",
"p. c #5A85B9",
"a. c #6B8BB4",
"s. c #6087B9",
"d. c #A9A3B9",
"f. c #F3C680",
"g. c #F9C780",
"h. c #F6CB8A",
"j. c #F0CE99",
"k. c #829FC5",
"l. c #8BA6C9",
"z. c #8DA7C8",
"x. c #A6ACC4",
"c. c #B0B6CB",
"v. c #A0B6D1",
"b. c #B4C1D3",
"n. c #D6DBE3",
"m. c None",
/* pixels */
"m.m.m.m.6 0 9 e m.m.m.m.m.m.m.m.",
"m.m.m.z Y ! E L q m.m.m.m.m.m.m.",
"m.m.w W T U V d x f g f m.m.m.m.",
"m.m.8 R J K c k ) h.@.{ f m.m.m.",
"m.m.7 I B H y [ f.O.( #.Z f m.m.",
"m.m.. C M a l g.+.j.' D ] f m.m.",
"m.m.  u N s j o./ ..S F Q f m.m.",
"m.2 * + 3 X o ` X.A ^ | P r m.m.",
"2 - # G G % , n _ ~  .} p v m.m.",
"2 - @ G & 1 l.5 m h t i b s.1 1 ",
"2 - @ @ 1 z.4.7.c.4 d.x.2.;.s.1 ",
"2 - $ O > s.1.5.v.n.p.k.<.&.6.1 ",
"2 - ; = 1 i.>.1.3.b.u.,.-.-.6.1 ",
"m.2 2 2 1 y.>.%.:.a.-.*.$.=.6.1 ",
"m.m.m.m.1 t.r.9.e.0.0.0.8.q.w.1 ",
"m.m.m.m.: 1 1 1 1 1 1 1 1 1 1 < "
};

/* XPM */
const char *multimedia_player_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 78 1",
"  c #535551",
". c #555753",
"X c #5B5B58",
"o c #626460",
"O c #666864",
"+ c #676964",
"@ c #686A65",
"# c #696B66",
"$ c #6A6C67",
"% c #696968",
"& c #6C6E69",
"* c #6E6F6C",
"= c #6E706B",
"- c #70726D",
"; c #747671",
": c #747672",
"> c #767874",
", c #787A75",
"< c #787A76",
"1 c #7A7B77",
"2 c #7A7C77",
"3 c #7B7D78",
"4 c #7C7D79",
"5 c #7C7E79",
"6 c #7C7D7A",
"7 c #7D7F7A",
"8 c #7E7F7B",
"9 c #7E807B",
"0 c #80817D",
"q c #80827D",
"w c #B3BC78",
"e c #838581",
"r c #858782",
"t c #888A85",
"y c #898A87",
"u c #8A8C89",
"i c #91928E",
"p c #92948F",
"a c #939592",
"s c #969893",
"d c #989996",
"f c #9B9D9A",
"g c #9FA09D",
"h c #A2A49F",
"j c #B2B796",
"k c #A4A6A2",
"l c #A4A6A3",
"z c #A5A6A3",
"x c #A5A7A3",
"c c #A6A7A3",
"v c #A8AAA5",
"b c #ADAEAB",
"n c #AEAEAB",
"m c #B6BAA6",
"M c #B4B5A8",
"N c #B8BCA8",
"B c #B8BCAA",
"V c #B6B6B4",
"C c #B8B9B6",
"Z c #B9B9B6",
"A c #BBC286",
"S c #BDC58D",
"D c #BBC291",
"F c #BBC096",
"G c #BEC496",
"H c #BFC59B",
"J c #C3C996",
"K c #C3CA96",
"L c #C3C79F",
"P c #C5CB9A",
"I c #C4CAA3",
"U c #C5C9A4",
"Y c #C9CEAB",
"T c #CBCFAC",
"R c #C9D0A3",
"E c #CBD0A5",
"W c #D1D6AE",
"Q c #CFD4B0",
/* pixels */
" ...............",
".>cccxxxxxxzlk>.",
".di1114444480td.",
".dajLUYTIHGDQud.",
".dhFKPREJSAwWsd.",
".dpMBNNNNNNmmrd.",
".d=&&$&=&$$&$$d.",
".d#+@++#@++#+@d.",
".d,nfvb:;:-XoOd.",
".dyCkVZ777<%6*d.",
".d777777777eq9d.",
".d555555555555d.",
".d3g3g33333333d.",
".d222222222222d.",
".>dddddddddddd>.",
"................"
};

/* XPM */
const char *chat_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 15 1",
"  c #888A85",
". c #9D9D9D",
"X c #C6C6C4",
"o c #E9E9E9",
"O c #EAEAEA",
"+ c #EBEBEB",
"@ c #ECECEC",
"# c #EDEDED",
"$ c #EEEEEE",
"% c #EFEFEF",
"& c #F0F0F0",
"* c #F1F1F1",
"= c #F2F2F2",
"- c #FFFFFF",
"; c None",
/* pixels */
";;;;           ;",
";;; ----------- ",
";;; -ooooooooo- ",
";           Xo- ",
" ----------- o- ",
" -ooooooooo- o- ",
" -ooooooo@@- o- ",
" -ooooo@@@@- -- ",
" -ooo@@@&&&- - ;",
" -o@@@&@@&&- - ;",
" -o@@&@&&&&-   ;",
" --&@------- ; ;",
"; -@-       .;;;",
"; -- ;;;;;;;;;;;",
";   ;;;;;;;;;;;;",
"; ;;;;;;;;;;;;;;"
};

/* XPM */
const char * dialog_information_48_icon[] = {
"48 48 606 2",
"  	c None",
". 	c #616673",
"+ 	c #626779",
"@ 	c #616777",
"# 	c #626473",
"$ 	c #626472",
"% 	c #616776",
"& 	c #626778",
"* 	c #626574",
"= 	c #6B7287",
"- 	c #8798B9",
"; 	c #9FB3D8",
"> 	c #ABC0E2",
", 	c #B8C9EB",
"' 	c #BBCBEB",
") 	c #B3C5E3",
"! 	c #AABCDA",
"~ 	c #90A0BC",
"{ 	c #6D758A",
"] 	c #626576",
"^ 	c #626675",
"/ 	c #727B94",
"( 	c #9DB1DB",
"_ 	c #ACC1EB",
": 	c #98B4E2",
"< 	c #85A7DA",
"[ 	c #7CA1D5",
"} 	c #759CD0",
"| 	c #749CCE",
"1 	c #7EA4D2",
"2 	c #89ABD6",
"3 	c #A5BFE1",
"4 	c #C5D5EE",
"5 	c #B6C5E1",
"6 	c #7A8399",
"7 	c #626777",
"8 	c #90A4CD",
"9 	c #A7BEEB",
"0 	c #87A8DE",
"a 	c #7197D3",
"b 	c #84A7D6",
"c 	c #9AB7DB",
"d 	c #AAC3DF",
"e 	c #B3C9E2",
"f 	c #B4CBE2",
"g 	c #B1C8E2",
"h 	c #A3BEDC",
"i 	c #8CAED3",
"j 	c #749DC9",
"k 	c #94B3D8",
"l 	c #CAD8EF",
"m 	c #ADBCD6",
"n 	c #656978",
"o 	c #676D81",
"p 	c #9BB0DC",
"q 	c #94B0E5",
"r 	c #7198D6",
"s 	c #93B2DD",
"t 	c #BACEE6",
"u 	c #C5D6E9",
"v 	c #C7D8EA",
"w 	c #C7D8E9",
"x 	c #C7D7EA",
"y 	c #C8D8E9",
"z 	c #C6D6E8",
"A 	c #C5D6E8",
"B 	c #C3D4E7",
"C 	c #C0D2E6",
"D 	c #91B2D5",
"E 	c #769ECA",
"F 	c #B3C8E4",
"G 	c #C4D2E8",
"H 	c #6C7283",
"I 	c #63687A",
"J 	c #99B0DE",
"K 	c #88A8E2",
"L 	c #7BA0D9",
"M 	c #B3C9E6",
"N 	c #C5D6EA",
"O 	c #C6D7E9",
"P 	c #C8D8EB",
"Q 	c #C9D8E9",
"R 	c #C9D9EA",
"S 	c #C8D8EA",
"T 	c #C7D7E9",
"U 	c #C6D6E9",
"V 	c #C3D4E8",
"W 	c #C0D2E7",
"X 	c #85A9CF",
"Y 	c #779FCA",
"Z 	c #A3BDDD",
"` 	c #C6D4E9",
" .	c #666B7A",
"..	c #62687A",
"+.	c #8EA4D1",
"@.	c #8DACE4",
"#.	c #7EA2DA",
"$.	c #BDD0EA",
"%.	c #CADAEA",
"&.	c #C8D9EB",
"*.	c #C6D8EA",
"=.	c #C3D5E8",
"-.	c #AEC5E0",
";.	c #7CA3CC",
">.	c #79A0CB",
",.	c #B8C6DD",
"'.	c #7382A2",
").	c #96B2E7",
"!.	c #749BD8",
"~.	c #BBCFE9",
"{.	c #C3D5E9",
"].	c #C9D8EA",
"^.	c #CADAEB",
"/.	c #CBDAEB",
"(.	c #CCDAEB",
"_.	c #CCDBEB",
":.	c #CBDBEA",
"<.	c #CBDAEA",
"[.	c #C9D9E9",
"}.	c #C4D6E9",
"|.	c #C2D4E7",
"1.	c #8AACD1",
"2.	c #80A4CE",
"3.	c #7CA1CC",
"4.	c #CADAEE",
"5.	c #8391A7",
"6.	c #626877",
"7.	c #95AFE0",
"8.	c #789CDC",
"9.	c #A1BCE2",
"0.	c #C2D4E9",
"a.	c #CCDBEC",
"b.	c #CDDCEB",
"c.	c #CEDCEB",
"d.	c #CDDBEB",
"e.	c #CDDBEC",
"f.	c #C8D9EA",
"g.	c #C4D5E7",
"h.	c #9AB8D8",
"i.	c #84A8CF",
"j.	c #8EAFD5",
"k.	c #D0DAEE",
"l.	c #626876",
"m.	c #717B94",
"n.	c #94B1E6",
"o.	c #749AD6",
"p.	c #BDD0E8",
"q.	c #C1D3E7",
"r.	c #CCDCEB",
"s.	c #CFDCEC",
"t.	c #D0DDED",
"u.	c #D0DEED",
"v.	c #CFDDEC",
"w.	c #CEDCEC",
"x.	c #CEDBEB",
"y.	c #CCDAEA",
"z.	c #C9D9EB",
"A.	c #A3BDDC",
"B.	c #8AACD2",
"C.	c #85A9D0",
"D.	c #80A5CE",
"E.	c #CFDAF0",
"F.	c #838D9F",
"G.	c #616878",
"H.	c #869AC3",
"I.	c #83A5DE",
"J.	c #8AABD9",
"K.	c #BED1E6",
"L.	c #C1D3E8",
"M.	c #C4D6E8",
"N.	c #CAD9EB",
"O.	c #D1DEEE",
"P.	c #D2E0EE",
"Q.	c #D1DFED",
"R.	c #D0DEEC",
"S.	c #A4BEDB",
"T.	c #8FB1D4",
"U.	c #ACC4E1",
"V.	c #B5C1D5",
"W.	c #626979",
"X.	c #98ADDA",
"Y.	c #92B2D8",
"Z.	c #BDD1E6",
"`.	c #CEDDEC",
" +	c #D4E1EE",
".+	c #D3E1EE",
"++	c #D4E0EF",
"@+	c #D3E0EE",
"#+	c #9EBBD9",
"$+	c #95B4D6",
"%+	c #90B0D4",
"&+	c #91B3D5",
"*+	c #DBE2F2",
"=+	c #626878",
"-+	c #9EB6E1",
";+	c #6F98D0",
">+	c #93B2D6",
",+	c #BDD2E6",
"'+	c #C1D4E7",
")+	c #C4D5E9",
"!+	c #D0DEEE",
"~+	c #D5E2EF",
"{+	c #D7E2F0",
"]+	c #D6E1EF",
"^+	c #D6E1ED",
"/+	c #D5E1EF",
"(+	c #D3E0EF",
"_+	c #D0DFEE",
":+	c #9FBBDA",
"<+	c #9AB7D8",
"[+	c #8FB0D4",
"}+	c #8AABD1",
"|+	c #E7ECFA",
"1+	c #626775",
"2+	c #646775",
"3+	c #9EB8E4",
"4+	c #6F99CC",
"5+	c #8BACD2",
"6+	c #BFD0E6",
"7+	c #C5D7E9",
"8+	c #D2DFED",
"9+	c #D7E2EF",
"0+	c #D8E3F0",
"a+	c #DAE5F1",
"b+	c #D9E4EF",
"c+	c #D8E4EF",
"d+	c #D1E0EE",
"e+	c #AFC6DF",
"f+	c #A4C0DC",
"g+	c #99B8D7",
"h+	c #92B3D5",
"i+	c #8DAED3",
"j+	c #E7EBFA",
"k+	c #666976",
"l+	c #A1B9E1",
"m+	c #6F99C8",
"n+	c #7AA1CB",
"o+	c #BDD0E6",
"p+	c #C7D6E9",
"q+	c #DBE6F2",
"r+	c #DCE5F2",
"s+	c #DCE5F1",
"t+	c #D8E4F0",
"u+	c #C3D4E9",
"v+	c #AEC7E0",
"w+	c #ABC3DE",
"x+	c #9EBADA",
"y+	c #98B6D6",
"z+	c #92B1D3",
"A+	c #E8EDFB",
"B+	c #656876",
"C+	c #A0B7DA",
"D+	c #739BC8",
"E+	c #7AA1CC",
"F+	c #A2BEDB",
"G+	c #C4D5E8",
"H+	c #CFDEED",
"I+	c #DAE4F0",
"J+	c #DDE8F3",
"K+	c #DFE9F2",
"L+	c #DFEAF4",
"M+	c #E0E8F2",
"N+	c #DDE7F2",
"O+	c #B8CDE3",
"P+	c #B4CAE1",
"Q+	c #AFC6E0",
"R+	c #AAC2DE",
"S+	c #A2BDDB",
"T+	c #9DB9D9",
"U+	c #E8ECFA",
"V+	c #636777",
"W+	c #96ACCA",
"X+	c #7EA3CD",
"Y+	c #7DA3CD",
"Z+	c #86AAD0",
"`+	c #BACDE5",
" @	c #CCDCEC",
".@	c #D4E1EF",
"+@	c #D8E2EF",
"@@	c #DEE7F3",
"#@	c #E0EAF4",
"$@	c #E1E9F2",
"%@	c #E3EAF3",
"&@	c #DDE8F2",
"*@	c #CAD8EB",
"=@	c #C1D4E6",
"-@	c #B9CEE5",
";@	c #A8C1DD",
">@	c #A0BCD9",
",@	c #A5C1DE",
"'@	c #DEE3F3",
")@	c #636877",
"!@	c #8291A8",
"~@	c #92B3D7",
"{@	c #88ABD1",
"]@	c #95B3D6",
"^@	c #B0C7E0",
"/@	c #FAFCFD",
"(@	c #EEF3F7",
"_@	c #DFE7F2",
":@	c #DCE6F1",
"<@	c #DEEAF2",
"[@	c #DFE8F1",
"}@	c #DCE6F2",
"|@	c #D5E0EE",
"1@	c #D4D8DD",
"2@	c #DFDFDF",
"3@	c #BFD1E5",
"4@	c #BACDE3",
"5@	c #B3C8E2",
"6@	c #ABC3DD",
"7@	c #C5D3EB",
"8@	c #B8C0D1",
"9@	c #676D7D",
"0@	c #A8BFDD",
"a@	c #85AAD0",
"b@	c #9BB8D8",
"c@	c #F0F4FA",
"d@	c #F5F9FC",
"e@	c #FCFDFD",
"f@	c #F0F4F7",
"g@	c #E3E9EF",
"h@	c #D9E1EA",
"i@	c #D5DEE5",
"j@	c #D6DDE3",
"k@	c #DFE3E7",
"l@	c #E9ECEC",
"m@	c #F1F2F2",
"n@	c #E4E6E9",
"o@	c #B6CCE4",
"p@	c #AEC6DF",
"q@	c #E0E6F6",
"r@	c #818493",
"s@	c #8794A9",
"t@	c #A6C0DE",
"u@	c #8DAED2",
"v@	c #9EBAD9",
"w@	c #A6C0DC",
"x@	c #D1DFEE",
"y@	c #EEF2F8",
"z@	c #C6D6E7",
"A@	c #E2E9F0",
"B@	c #EFF2F5",
"C@	c #F3F4F5",
"D@	c #F3F4F4",
"E@	c #F2F2F3",
"F@	c #EAECEE",
"G@	c #DFE3E6",
"H@	c #EFEFF3",
"I@	c #E5EBF3",
"J@	c #BACEE5",
"K@	c #B4C9E2",
"L@	c #CAD8ED",
"M@	c #CCD4E3",
"N@	c #656977",
"O@	c #646978",
"P@	c #A6B3C7",
"Q@	c #A8C2E0",
"R@	c #A9C2DD",
"S@	c #B5CBE3",
"T@	c #F0F3F9",
"U@	c #C9DBEA",
"V@	c #F9FAFC",
"W@	c #C6D5E7",
"X@	c #C8D9EC",
"Y@	c #E7EBF8",
"Z@	c #717481",
"`@	c #666C7A",
" #	c #B1BBCF",
".#	c #B2C9E3",
"+#	c #A2BDDA",
"@#	c #ACC2DE",
"##	c #B3C9E1",
"$#	c #E0E9F3",
"%#	c #F1F5F9",
"&#	c #F2F5FA",
"*#	c #CFDEEE",
"=#	c #EAEDFA",
"-#	c #7F8490",
";#	c #686C7B",
">#	c #BBC5D7",
",#	c #ACC4DF",
"'#	c #B5CBE2",
")#	c #E0E7F0",
"!#	c #F1F3F4",
"~#	c #D0E0EF",
"{#	c #EAEEFA",
"]#	c #818592",
"^#	c #707683",
"/#	c #CAD7EA",
"(#	c #C1D1E6",
"_#	c #D0D6DD",
":#	c #D8D9DB",
"<#	c #E5EAF8",
"[#	c #ACB0BC",
"}#	c #646976",
"|#	c #C7CFDE",
"1#	c #AFC7E0",
"2#	c #B9CCE4",
"3#	c #BFD4E7",
"4#	c #BDC5CF",
"5#	c #BDC4CD",
"6#	c #E8ECF9",
"7#	c #868895",
"8#	c #B5BCCB",
"9#	c #B9C4CF",
"0#	c #9DA3A9",
"a#	c #939595",
"b#	c #EAEDF8",
"c#	c #767B88",
"d#	c #8A8F9D",
"e#	c #D0DDEF",
"f#	c #B2C5D8",
"g#	c #B0C0CA",
"h#	c #B0BBBB",
"i#	c #80837C",
"j#	c #A5AB94",
"k#	c #B1B494",
"l#	c #ADB08A",
"m#	c #9C9D7A",
"n#	c #757567",
"o#	c #E3E6F3",
"p#	c #666977",
"q#	c #656A78",
"r#	c #C6CEDC",
"s#	c #B4BEC5",
"t#	c #A3AF9F",
"u#	c #A8B19D",
"v#	c #888B7B",
"w#	c #929683",
"x#	c #BBBEA1",
"y#	c #C1C2A0",
"z#	c #999A7D",
"A#	c #949477",
"B#	c #B3B48C",
"C#	c #A3A584",
"D#	c #A1A591",
"E#	c #E2E7EF",
"F#	c #9B9FAC",
"G#	c #6E717D",
"H#	c #CACFD7",
"I#	c #C0C8C8",
"J#	c #AEB7AD",
"K#	c #9CA296",
"L#	c #7E8174",
"M#	c #BFC2AC",
"N#	c #C5C8AC",
"O#	c #92937E",
"P#	c #B9BB9E",
"Q#	c #D5D8B7",
"R#	c #D1D5B9",
"S#	c #DBDEDD",
"T#	c #C3C6CE",
"U#	c #656776",
"V#	c #555744",
"W#	c #6E737A",
"X#	c #BFC4CC",
"Y#	c #D8DDE2",
"Z#	c #C9CFCA",
"`#	c #C2C7B9",
" $	c #C3C7B4",
".$	c #C7CBB2",
"+$	c #CED2BB",
"@$	c #DADBC8",
"#$	c #E4E6DE",
"$$	c #EEF0F5",
"%$	c #B9BDBF",
"&$	c #62666E",
"*$	c #666635",
"=$	c #A1A262",
"-$	c #6E7276",
";$	c #82868E",
">$	c #B9BDC0",
",$	c #D5D8DB",
"'$	c #E1E4E7",
")$	c #E6E9ED",
"!$	c #E3E5E8",
"~$	c #D9DBDC",
"{$	c #BABCBC",
"]$	c #757780",
"^$	c #686A68",
"/$	c #4E4E2F",
"($	c #595A30",
"_$	c #A3A456",
":$	c #D3D58E",
"<$	c #BEC19D",
"[$	c #92968B",
"}$	c #73767C",
"|$	c #686B75",
"1$	c #626571",
"2$	c #6B6E77",
"3$	c #76797A",
"4$	c #8C8D7B",
"5$	c #999772",
"6$	c #8E8C5C",
"7$	c #4D4D28",
"8$	c #4C4C28",
"9$	c #83834C",
"0$	c #D8D9A1",
"a$	c #F2F4D6",
"b$	c #ECEEC0",
"c$	c #EBEFBE",
"d$	c #E9ECBB",
"e$	c #E8EAB7",
"f$	c #DCDEAB",
"g$	c #CDCE99",
"h$	c #BCBB87",
"i$	c #9D9B6C",
"j$	c #696740",
"k$	c #4B4B28",
"l$	c #636334",
"m$	c #B3B35F",
"n$	c #EFF0D4",
"o$	c #FFFFFF",
"p$	c #F8FADD",
"q$	c #F4F7C6",
"r$	c #F1F3C1",
"s$	c #E9EBB8",
"t$	c #DDDFAC",
"u$	c #C8C997",
"v$	c #A3A376",
"w$	c #8F8D61",
"x$	c #67663D",
"y$	c #4C4C29",
"z$	c #5B5C32",
"A$	c #A9A959",
"B$	c #DBDDA0",
"C$	c #F4F6DA",
"D$	c #F3F6C7",
"E$	c #F4F7C5",
"F$	c #EDF0BF",
"G$	c #DADCAD",
"H$	c #C6C89A",
"I$	c #B8B989",
"J$	c #B8B683",
"K$	c #A6A471",
"L$	c #8E8B5E",
"M$	c #7E7E49",
"N$	c #DADBA2",
"O$	c #F2F3D7",
"P$	c #EDEFC2",
"Q$	c #ECF0BE",
"R$	c #E9EBBA",
"S$	c #E6E8B5",
"T$	c #CDCD99",
"U$	c #BCBB86",
"V$	c #A09E6E",
"W$	c #707048",
"X$	c #616132",
"Y$	c #B2B260",
"Z$	c #CACB97",
"`$	c #A8A778",
" %	c #9B996C",
".%	c #949161",
"+%	c #54542F",
"@%	c #5D5D31",
"#%	c #ACAC5A",
"$%	c #DBDCA1",
"%%	c #F0F3C1",
"&%	c #DDDFB0",
"*%	c #C8C89C",
"=%	c #B9BA8C",
"-%	c #BDBE8A",
";%	c #ACAA76",
">%	c #898658",
",%	c #52522E",
"'%	c #474726",
")%	c #5C5C32",
"!%	c #969660",
"~%	c #C4C790",
"{%	c #D8D9A5",
"]%	c #D8DBAB",
"^%	c #D2D4A5",
"/%	c #C8C899",
"(%	c #B4B586",
"_%	c #9C9D6F",
":%	c #86865A",
"<%	c #66653F",
"[%	c #4E4E29",
"}%	c #444424",
"|%	c #404022",
"1%	c #4C4C2F",
"2%	c #505031",
"3%	c #535331",
"4%	c #4F4F2C",
"5%	c #525232",
"6%	c #4F4F31",
"7%	c #4B4B31",
"8%	c #3A3A1F",
"9%	c #3D3D3D",
"0%	c #636363",
"a%	c #B9B9B9",
"b%	c #C0C0C0",
"c%	c #AFAFAF",
"d%	c #8D8D8D",
"e%	c #565656",
"f%	c #383838",
"g%	c #555555",
"h%	c #848484",
"i%	c #B8B8B8",
"j%	c #A8A8A8",
"k%	c #707070",
"l%	c #525252",
"m%	c #5A5A5A",
"n%	c #595959",
"o%	c #4F4F4F",
"                                                                                                ",
"                                                                                                ",
"                                        . + @ # $ % & *                                         ",
"                                    % = - ; > , ' ) ! ~ { ]                                     ",
"                                ^ / ( _ : < [ } | 1 2 3 4 5 6 7                                 ",
"                              7 8 9 0 a b c d e f g h i j k l m n                               ",
"                            o p q r s t u v w x y z A B C D E F G H                             ",
"                          I J K L M N O w P Q R S S T U V W X Y Z `  .                          ",
"                        ..+.@.#.$.N U x Q %.R R R R &.*.u =.-.;.>.F ,.+                         ",
"                        '.).!.~.{.A T y ].^./.(._.:.<.[.T }.|.1.2.3.4.5.                        ",
"                      6.7.8.9.0.V U w R /.a.b.c.c.d.e.(.f.O g.h.i.2.j.k.l.                      ",
"                      m.n.o.p.q.=.A S /.:.r.s.t.u.v.w.x.y.z.A A.B.C.D.E.F.                      ",
"                    G.H.I.J.K.L.M.O N.<.b.t.O.P.Q.Q.u.R.s._.w S.T.B.C.U.V.7                     ",
"                    W.X.o.Y.Z.|.=.x ^.d.`.Q.Q. + +.+++@+t.r.z.#+$+%+B.&+*+=+                    ",
"                    7 -+;+>+,+'+)+R _.`.!+@+~+~+{+]+^+/+(+_+L.:+<+$+[+}+|+1+                    ",
"                    2+3+4+5+6+|.7+N.r.v.8+++9+0+a+b+c+c+ +d+e+f+:+g+h+i+j+k+                    ",
"                    1+l+m+n+o+B p+/.w.8+++9+a+a+q+r+s+a+t+u+v+w+f+x+y+z+A+B+                    ",
"                    & C+D+E+F+G+y %.H+@+^+c+I+J+K+L+M+N+%.O+P+Q+R+S+T+$+U+V+                    ",
"                    + W+X+Y+Z+`+v  @H+.@+@q+@@#@$@%@&@*@=@Z.-@P+-.;@>@,@'@)@                    ",
"                      !@~@2.{@]@^@u /@(@_@:@<@[@}@|@    1@2@3@4@5@6@f+7@8@                      ",
"                      9@0@a@B.>+b@S+c@d@e@f@g@h@i@j@k@l@m@n@V o+o@p@;@q@r@                      ",
"                        s@t@u@]@v@w@x@y@z@A@B@C@D@E@F@G@H@I@  =@J@K@L@M@N@                      ",
"                        O@P@Q@y+>@R@S@T@U@              V@    W@o+X@Y@Z@                        ",
"                          `@ #.#+#@###$#:@            %#&#      *#=#-#                          ",
"                            ;#>#S@,#'#v.)#            !#      ~#{#]#                            ",
"                              ^#/#v+o@(#_#            :#      <#[#                              ",
"                              }#|#1#2#3#4#5#                  6#7#                              ",
"                                8#t O+=@9#0#        a#        b#c#                              ",
"                                d#e#f#g#h#i#j#k#l#m#n#        o#p#                              ",
"                                q#r#s#t#u#v#w#x#y#z#A#B#C#D#E#F#                                ",
"                                  G#H#I#J#K#L#M#N#O#P#Q#R#S#T#U#                                ",
"                                  V#W#X#Y#Z#`# $.$+$@$#$$$%$&$                                  ",
"                                  *$=$-$;$>$,$'$)$!$~${$]$^$/$                                  ",
"                                  ($_$:$<$[$}$|$1$2$3$4$5$6$7$                                  ",
"                                  8$9$0$a$b$c$d$e$f$g$h$i$j$k$                                  ",
"                                  l$m$n$o$p$q$r$s$t$u$v$w$x$y$                                  ",
"                                  z$A$B$C$D$E$F$G$H$I$J$K$L$7$                                  ",
"                                  8$M$N$O$P$Q$R$S$f$T$U$V$W$8$                                  ",
"                                  X$Y$n$o$p$q$r$s$t$Z$`$ %.%+%                                  ",
"                                  @%#%$%C$D$q$%%&%*%=%-%;%>%,%                                  ",
"                                  '%)%!%~%{%]%^%/%(%_%:%<%[%}%                                  ",
"                                      |%1%2%3%4%4%5%6%7%8%                                      ",
"                                        9%0%a%b%c%d%e%f%                                        ",
"                                          g%h%i%j%k%l%                                          ",
"                                            l%m%n%o%                                            ",
"                                                                                                ",
"                                                                                                ",
"                                                                                                "
};

/* XPM */
const char * dialog_warning_48_icon[] = {
"48 48 305 2",
"  	c None",
". 	c #A10000",
"+ 	c #A00000",
"@ 	c #A20000",
"# 	c #B72323",
"$ 	c #DE6868",
"% 	c #DF6969",
"& 	c #BC2828",
"* 	c #A70B0B",
"= 	c #E16F6F",
"- 	c #D22020",
"; 	c #D11A1A",
"> 	c #E16C6C",
", 	c #A90E0E",
"' 	c #CE4C4C",
") 	c #D94040",
"! 	c #CC0000",
"~ 	c #D73939",
"{ 	c #CF4A4A",
"] 	c #AA1414",
"^ 	c #E26F6F",
"/ 	c #CD0707",
"( 	c #CD0505",
"_ 	c #E06666",
": 	c #AF1717",
"< 	c #A30000",
"[ 	c #D25252",
"} 	c #D73636",
"| 	c #D52F2F",
"1 	c #D44F4F",
"2 	c #B01A1A",
"3 	c #CD0404",
"4 	c #D03A3A",
"5 	c #D14040",
"6 	c #CC0202",
"7 	c #DF5E5E",
"8 	c #B31C1C",
"9 	c #D55858",
"0 	c #D63030",
"a 	c #D8B6B6",
"b 	c #DAC1C1",
"c 	c #CC0606",
"d 	c #D42626",
"e 	c #D75353",
"f 	c #B32020",
"g 	c #E16767",
"h 	c #D25050",
"i 	c #DCDCDC",
"j 	c #D36060",
"k 	c #CC0101",
"l 	c #DD5555",
"m 	c #B92222",
"n 	c #D85E5E",
"o 	c #D42828",
"p 	c #CC0404",
"q 	c #DABFBF",
"r 	c #DBC9C9",
"s 	c #CD0A0A",
"t 	c #D21D1D",
"u 	c #D85555",
"v 	c #A20202",
"w 	c #B72828",
"x 	c #DF6060",
"y 	c #D35B5B",
"z 	c #DDDDDD",
"A 	c #D56B6B",
"B 	c #DB4C4C",
"C 	c #BC2727",
"D 	c #A10101",
"E 	c #DB6363",
"F 	c #D32121",
"G 	c #CD0808",
"H 	c #DBC5C5",
"I 	c #DEDEDE",
"J 	c #DDD1D1",
"K 	c #CE1010",
"L 	c #D01616",
"M 	c #DA5656",
"N 	c #A20303",
"O 	c #BC2D2D",
"P 	c #DE5959",
"Q 	c #D36565",
"R 	c #DFDFDF",
"S 	c #D67676",
"T 	c #D94242",
"U 	c #C02C2C",
"V 	c #DC6767",
"W 	c #CD0C0C",
"X 	c #DCCCCC",
"Y 	c #DED6D6",
"Z 	c #CE1616",
"` 	c #CF1010",
" .	c #DB5656",
"..	c #A30505",
"+.	c #BF3333",
"@.	c #DC5252",
"#.	c #D56F6F",
"$.	c #E0E0E0",
"%.	c #D88484",
"&.	c #C43030",
"*.	c #DE6A6A",
"=.	c #D01515",
"-.	c #CD1111",
";.	c #DCD1D1",
">.	c #949494",
",.	c #777777",
"'.	c #959595",
").	c #E1DCDC",
"!.	c #CF1D1D",
"~.	c #CE0A0A",
"{.	c #DB5252",
"].	c #A50909",
"^.	c #C53A3A",
"/.	c #DB4B4B",
"(.	c #D57878",
"_.	c #454545",
":.	c #000000",
"<.	c #E1E1E1",
"[.	c #D98F8F",
"}.	c #D63131",
"|.	c #C83333",
"1.	c #A50808",
"2.	c #E06B6B",
"3.	c #CD1717",
"4.	c #DCD5D5",
"5.	c #505050",
"6.	c #515151",
"7.	c #E2E0E0",
"8.	c #D02727",
"9.	c #CD0606",
"0.	c #DB4E4E",
"a.	c #A90C0C",
"b.	c #C84040",
"c.	c #DA4444",
"d.	c #D68383",
"e.	c #5C5C5C",
"f.	c #5D5D5D",
"g.	c #E2E2E2",
"h.	c #DC9C9C",
"i.	c #D42929",
"j.	c #CA3636",
"k.	c #A70C0C",
"l.	c #E06A6A",
"m.	c #CE0B0B",
"n.	c #CE1E1E",
"o.	c #DEDADA",
"p.	c #696969",
"q.	c #6A6A6A",
"r.	c #E3E3E3",
"s.	c #E4E3E3",
"t.	c #D13131",
"u.	c #DB4949",
"v.	c #AB1010",
"w.	c #CC4646",
"x.	c #D83C3C",
"y.	c #D78D8D",
"z.	c #757575",
"A.	c #E4E4E4",
"B.	c #DFAAAA",
"C.	c #CD3838",
"D.	c #A81111",
"E.	c #E06969",
"F.	c #CE0808",
"G.	c #CF2626",
"H.	c #DEDCDC",
"I.	c #818181",
"J.	c #E5E5E5",
"K.	c #D23C3C",
"L.	c #B01414",
"M.	c #D04A4A",
"N.	c #D73535",
"O.	c #D89797",
"P.	c #8C8C8C",
"Q.	c #8E8E8E",
"R.	c #E6E6E6",
"S.	c #E0B4B4",
"T.	c #AC1616",
"U.	c #E06767",
"V.	c #D02F2F",
"W.	c #DFDEDE",
"X.	c #989898",
"Y.	c #999999",
"Z.	c #E7E7E7",
"`.	c #D44949",
" +	c #D83B3B",
".+	c #B31818",
"++	c #DAA3A3",
"@+	c #A4A4A4",
"#+	c #A5A5A5",
"$+	c #E3C1C1",
"%+	c #D01414",
"&+	c #D23B3B",
"*+	c #A00101",
"=+	c #B11C1C",
"-+	c #E06262",
";+	c #CD0303",
">+	c #D13838",
",+	c #C7C7C7",
"'+	c #E8E8E8",
")+	c #E9E9E9",
"!+	c #D75555",
"~+	c #D63333",
"{+	c #B81B1B",
"]+	c #D55656",
"^+	c #DBADAD",
"/+	c #B0B0B0",
"(+	c #B1B1B1",
"_+	c #E6CCCC",
":+	c #CF0E0E",
"<+	c #D43939",
"[+	c #B52222",
"}+	c #DF5D5D",
"|+	c #D14242",
"1+	c #595959",
"2+	c #636363",
"3+	c #EAEAEA",
"4+	c #D96262",
"5+	c #D52C2C",
"6+	c #BB1D1D",
"7+	c #D85B5B",
"8+	c #D32222",
"9+	c #DDB7B7",
"0+	c #0B0B0B",
"a+	c #0D0D0D",
"b+	c #EBEBEB",
"c+	c #E8D4D4",
"d+	c #CD0909",
"e+	c #D53838",
"f+	c #A40404",
"g+	c #BB2828",
"h+	c #DD5656",
"i+	c #D24C4C",
"j+	c #323232",
"k+	c #313131",
"l+	c #ECECEC",
"m+	c #DB6F6F",
"n+	c #D32525",
"o+	c #BF1E1E",
"p+	c #A10202",
"q+	c #DB5F5F",
"r+	c #D11B1B",
"s+	c #DDBFBF",
"t+	c #CCCCCC",
"u+	c #626262",
"v+	c #616161",
"w+	c #CACACA",
"x+	c #EBDDDD",
"y+	c #CE0E0E",
"z+	c #D53535",
"A+	c #A40505",
"B+	c #BD2E2E",
"C+	c #DC4F4F",
"D+	c #D45757",
"E+	c #EDEDED",
"F+	c #EEEEEE",
"G+	c #DD7B7B",
"H+	c #D21F1F",
"I+	c #C32020",
"J+	c #A20404",
"K+	c #DD6262",
"L+	c #DEC7C7",
"M+	c #EEE5E5",
"N+	c #D53131",
"O+	c #A60707",
"P+	c #960000",
"Q+	c #C02D2D",
"R+	c #D03636",
"S+	c #E1DFDF",
"T+	c #EFEFEF",
"U+	c #D95858",
"V+	c #C41E1E",
"W+	c #9E0000",
"X+	c #9F0000",
"Y+	c #D21C1C",
"Z+	c #D42E2E",
"`+	c #9F0101",
" @	c #9D0000",
".@	c #D85757",
"+@	c #D12C2C",
"@@	c #830000",
"#@	c #B01B1B",
"$@	c #DA5757",
"%@	c #E06464",
"&@	c #E06363",
"*@	c #DF6161",
"=@	c #DF5F5F",
"-@	c #DE5C5C",
";@	c #DE5A5A",
">@	c #DD5757",
",@	c #DD5454",
"'@	c #DC5050",
")@	c #DB4D4D",
"!@	c #DB4A4A",
"~@	c #DA4848",
"{@	c #DA4747",
"]@	c #DA4545",
"^@	c #D94343",
"/@	c #D83E3E",
"(@	c #D83D3D",
"_@	c #D73838",
":@	c #D02A2A",
"<@	c #B00F0F",
"[@	c #920000",
"}@	c #860000",
"|@	c #900000",
"                                                                                                ",
"                                                                                                ",
"                                                                                                ",
"                                                                                                ",
"                                                                                                ",
"                                            . + + @                                             ",
"                                          @ # $ % & @                                           ",
"                                          * = - ; > ,                                           ",
"                                        . ' ) ! ! ~ { @                                         ",
"                                        ] ^ / ! ! ( _ :                                         ",
"                                      < [ } ! ! ! ! | 1 .                                       ",
"                                      2 > 3 ! 4 5 ! 6 7 8                                       ",
"                                    @ 9 0 ! 6 a b c ! d e .                                     ",
"                                    f g 6 ! h i i j ! k l m                                     ",
"                                  . n o ! p q i i r s ! t u v                                   ",
"                                  w x ! ! y i z z z A ! ! B C .                                 ",
"                                D E F ! G H z z z I J K ! L M N                                 ",
"                                O P ! ! Q z z z I I R S ! ! T U +                               ",
"                              N V ; ! W X z z I I R R Y Z ! `  ...                              ",
"                            . +.@.! ! #.z z I I R R R $.%.! ! ~ &.@                             ",
"                            ..*.=.! -.;.z I >.,.,.'.$.$.).!.! ~.{.].                            ",
"                          < ^./.! ! (.z I I _.:.:._.$.<.<.[.! ! }.|..                           ",
"                          1.2.` ! 3.4.I I R 5.:.:.6.<.<.<.7.8.! 9.0.a.                          ",
"                        @ b.c.! ! d.I I R R e.:.:.f.<.<.g.g.h.! ! i.j.@                         ",
"                        k.l.m.! n.o.I R R R p.:.:.q.<.g.g.r.s.t.! 3 u.v.                        ",
"                      . w.x.! ! y.I R R R $.z.:.:.z.g.g.r.A.A.B.! ! F C..                       ",
"                      D.E.F.! G.H.R R R $.$.I.:.:.I.r.r.A.A.J.J.K.! 6 T L.                      ",
"                    < M.N.! ! O.R R R $.$.<.P.:.:.Q.r.A.A.J.J.R.S.k ! ; 4 .                     ",
"                    T.U.( ! V.W.R R $.$.<.<.X.:.:.Y.A.A.J.J.R.R.Z.`.! !  +.+                    ",
"                  . h | ! ! ++R R $.$.<.<.<.@+:.:.#+A.J.J.R.R.Z.Z.$+6 ! %+&+*+                  ",
"                  =+-+;+! >+R R $.$.<.<.g.g.,+q.q.,+J.J.R.R.Z.'+'+)+!+! ! ~+{+.                 ",
"                . ]+o ! ! ^+R $.$.<.<.g.g.r.g./+(+A.J.R.R.Z.'+'+)+)+_+9.! :+<+v                 ",
"                [+}+k ! |+$.$.$.<.<.g.g.r.r.1+:.:.2+R.R.Z.'+'+)+)+3+3+4+! ! 5+6+<               ",
"              D 7+8+! 6 9+$.$.<.<.g.g.r.r.A.0+:.:.a+R.Z.'+'+)+)+3+3+b+c+d+! ~.e+f+              ",
"              g+h+! ! i+$.$.<.<.g.g.r.r.A.A.j+:.:.k+Z.'+'+)+)+3+3+b+b+l+m+! ! n+o+@             ",
"            p+q+r+! 3 s+$.<.<.g.g.r.r.A.A.J.t+u+v+w+'+'+)+)+3+3+b+b+l+l+x+y+! / z+A+            ",
"          + B+C+! ! D+$.<.<.g.g.r.r.A.A.J.J.R.R.Z.'+'+)+)+3+3+b+b+l+l+E+F+G+! ! H+I+@           ",
"          J+K+L ! c L+<.<.g.g.r.r.A.A.J.J.R.R.Z.'+'+)+)+3+3+b+b+l+l+E+F+F+M+L ! 3 N+O+          ",
"        P+Q+B ! ! R+S+<.g.g.r.r.A.A.J.J.R.R.Z.'+'+)+)+3+3+b+b+l+l+E+F+F+T+T+U+! ! ; V+W+        ",
"        X+U+Y+! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! 3 Z+`+        ",
"         @.@n+( ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! 6 m.+@*+        ",
"        @@#@$@-+_ %@&@*@=@7 -@;@P >@l ,@@.'@C+)@B !@~@{@]@^@T ) /@(@ +~ _@} N.~+| :@<@[@        ",
"          }@X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+|@          ",
"                                                                                                ",
"                                                                                                ",
"                                                                                                ",
"                                                                                                ",
"                                                                                                "
};

/* XPM */
const char *refresh_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 94 2",
"   c #3465A4",
".  c #3565A4",
"X  c #3566A4",
"o  c #3566A5",
"O  c #3667A5",
"+  c #3767A5",
"@  c #3767A6",
"#  c #3768A5",
"$  c #3768A6",
"%  c #3868A6",
"&  c #3869A6",
"*  c #3969A6",
"=  c #3969A7",
"-  c #3A69A7",
";  c #3A6AA6",
":  c #3A6AA7",
">  c #3B6BA7",
",  c #3C6BA8",
"<  c #3C6BA9",
"1  c #3C6CA9",
"2  c #3D6DA9",
"3  c #4170AB",
"4  c #4371AB",
"5  c #4774AD",
"6  c #4B77AF",
"7  c #4C77AF",
"8  c #4C78AF",
"9  c #4C78B0",
"0  c #4D79B0",
"q  c #4E7AB1",
"w  c #4F7CB6",
"e  c #537FB7",
"r  c #5580B5",
"t  c #5B84B7",
"y  c #5D85B7",
"u  c #5F87B9",
"i  c #6188B9",
"p  c #6890C0",
"a  c #6990C0",
"s  c #6D94C2",
"d  c #6891C7",
"f  c #6C95C9",
"g  c #7298C5",
"h  c #82A5CE",
"j  c #84A6CE",
"k  c #88A7CE",
"l  c #88ABD2",
"z  c #8AACD3",
"x  c #8FACD0",
"c  c #8CADD3",
"v  c #8FADD2",
"b  c #8EAED3",
"n  c #8FB0D3",
"m  c #93B1D4",
"M  c #95B2D4",
"N  c #9CB7D7",
"B  c #97B6D8",
"V  c #99B9DB",
"C  c #9DBDDC",
"Z  c #A1BBD9",
"A  c #A1BEDD",
"S  c #A0BEDE",
"D  c #A8C1DE",
"F  c #A8C2DF",
"G  c #B0C9E3",
"H  c #B4CAE3",
"J  c #B4CBE5",
"K  c #BCD1E7",
"L  c #BFD2E7",
"P  c #BFD3E9",
"I  c #C1D2E6",
"U  c #C7D7E9",
"Y  c #C4D7EB",
"T  c #C6D8EB",
"R  c #C8D8EA",
"E  c #C9D9EA",
"W  c #CDDBEB",
"Q  c #C9DAEC",
"!  c #CCDCED",
"~  c #CCDDEE",
"^  c #D5E2F0",
"/  c #D8E4F1",
"(  c #DBE6F2",
")  c #DDE8F3",
"_  c #E0E9F4",
"`  c #E2EBF5",
"'  c #E3ECF5",
"]  c #E4ECF5",
"[  c #E4EDF5",
"{  c #E5EDF5",
"}  c #E5EDF6",
"|  c #E6EEF6",
" . c #E7EEF6",
".. c None",
/* pixels */
"........% % % % , ..............",
"......% a n F F m u % ......O ..",
"....% c C A J P ~ ^ L 0 # 4   ..",
"..% a g 1 # % y Z / / ) k E % ..",
"..% 4 1 % ......% i W ` | | % ..",
"..O % d % ..........  U T ' % ..",
"..O ..............% x | / | , ..",
"................  O 6 8 8 8 O ..",
"..        O   O ................",
"..  | ' ` N O ..............O ..",
"..O | U E   ..........O f r   ..",
"..O | ` | I 0 % ......< w % # ..",
"..% / M ` ) ! c 9 O % % 1 0 : ..",
"..O y O 0 J Q K G A z h b % ....",
"..  O ....% r h B V z s % ......",
"..O ..........: # O : : ........"
};

/* XPM */
const char *text_editor_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 52 1",
"  c #000000",
". c #4C4226",
"X c #6B5736",
"o c #705B39",
"O c #636363",
"+ c #717171",
"@ c #757575",
"# c #8F5902",
"$ c #C4A000",
"% c #EBB13D",
"& c #A18355",
"* c #A08356",
"= c #A38555",
"- c #A08457",
"; c #A48757",
": c #C89F64",
"> c #CEA668",
", c #CFAA69",
"< c #D2AC6A",
"1 c #CFAD71",
"2 c #868686",
"3 c #888A85",
"4 c #8C8C8C",
"5 c #8F8F8F",
"6 c #9D9D9D",
"7 c #AEAEAE",
"8 c #B1B1B1",
"9 c #B2B2B2",
"0 c #B7B7B7",
"q c #B8B8B8",
"w c #BCBCBC",
"e c #C2AB8A",
"r c #C4C4C4",
"t c #CACACA",
"y c #CBCBCB",
"u c #CCCCCC",
"i c #D3D3D3",
"p c #D6D6D6",
"a c #DADADA",
"s c #DBDBDB",
"d c #EDE5C4",
"f c #EDE6C5",
"g c #EEEAC6",
"h c #EFEBC7",
"j c #F9E8C6",
"k c #E9E9E9",
"l c #EAEAEA",
"z c #EBEBEB",
"x c #ECECEC",
"c c #EEEEEE",
"v c #FFFFFF",
"b c None",
/* pixels */
"bbbbbbbbbbbbbbbb",
"bbb$b$b$b$b$bbbb",
"bb$j$j$j$j$j$bbb",
"b3$%$%$%$%$%$##b",
"b3z$w$q$q$0$#h1#",
"b3vxxxxxxxi#h<&#",
"b3vsuuuuu0#h<;#b",
"b3vxxxxxi#h,&#bb",
"b3vsuuu0#f>-#3bb",
"b3vxxxz#f:=#+3bb",
"b3vsut+oe=#523bb",
"b3vxzz#.X#6p73bb",
"b3vstr #O4ts93bb",
"b3vxzzzzzzzx93bb",
"b3x99999999993bb",
"b3333333333333bb"
};

/* XPM */
const char *text_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 21 1",
"  c #818181",
". c #959595",
"X c #999999",
"o c #C4C4C4",
"O c #C5C5C5",
"+ c #C6C6C6",
"@ c #C7C7C7",
"# c #C8C8C8",
"$ c #EDEDE5",
"% c #EDEDE6",
"& c #EAEAEA",
"* c #EBEBEB",
"= c #ECECEC",
"- c #EDEDED",
"; c #EEEEEE",
": c #EFEFEF",
"> c #F0F0F0",
", c #F1F1F1",
"< c #F2F2F2",
"1 c #FFFFFF",
"2 c None",
/* pixels */
"X            222",
" 111111111111 22",
" 1=&==&====>1 22",
" 1&oooo#oo#>1 22",
" 1&=&=====>>1 22",
" 1=o#oo##o#>1 22",
" 1&=====%==>1 22",
" 1=oo#o>:%=>1 22",
" 1====>=>:>>1 22",
" 1=##o#####>1 22",
" 1===>=>>>><1 22",
" 1=o#####>><1 22",
" 1===>>>>>>>1 22",
" 111111111111 22",
".            .22",
"2222222222222222"
};

/* XPM */
const char *shutdown_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 66 1",
"  c #272727",
". c #282828",
"X c #2B2B2B",
"o c #2D2D2D",
"O c #515151",
"+ c #555555",
"@ c #5F5F5F",
"# c #606060",
"$ c #616161",
"% c #656565",
"& c #6C6C6C",
"* c #6D6D6D",
"= c #6F6F6F",
"- c #7A7A7A",
"; c #7D7D7D",
": c #808080",
"> c #848484",
", c #858585",
"< c #888A85",
"1 c #8E8E8E",
"2 c #8F8F8F",
"3 c #A0A0A0",
"4 c #A2A2A2",
"5 c #A6A6A6",
"6 c #A9A9A9",
"7 c #ABABAB",
"8 c #B3B3B3",
"9 c #B9B9B9",
"0 c #BBBBBB",
"q c #BCBCBC",
"w c #C1C1C1",
"e c #C2C2C2",
"r c #C3C3C3",
"t c #C5C5C5",
"y c #C7C7C7",
"u c #C9C9C9",
"i c #CCCCCC",
"p c #D2D2D2",
"a c #D4D4D4",
"s c #D8D8D8",
"d c #DEDEDE",
"f c #DFDFDF",
"g c #E0E0E0",
"h c #E1E1E1",
"j c #E2E2E2",
"k c #E3E3E3",
"l c #E4E4E4",
"z c #E5E5E5",
"x c #E6E6E6",
"c c #E7E7E7",
"v c #E8E8E8",
"b c #E9E9E9",
"n c #EAEAEA",
"m c #EBEBEB",
"M c #ECECEC",
"N c #EDEDED",
"B c #EEEEEE",
"V c #EFEFEF",
"C c #F0F0F0",
"Z c #F1F1F1",
"A c #F3F3F3",
"S c #F4F4F4",
"D c #F5F5F5",
"F c #F6F6F6",
"G c #F7F7F7",
"H c None",
/* pixels */
"H<<<<<<<<<<<<<<H",
"<kkkkkkkkkkkkkk<",
"<kkVFFGFFFFFFlk<",
"<kVFFFFFFFFFFAl<",
"<lAAAi>>>>1AAAl<",
"<lAAAOOOOO kAAn<",
"<nAVV+;::1 dVVn<",
"<nVVn@538qXdVnn<",
"<nVnn%59rioknnV<",
"<Vnkl-yVnk#llkV<",
"<Vnkk;dFFF=dkkV<",
"<Vldk>3rr9;addV<",
"<Vnddi&=#&7pddA<",
"<VAndkd9rripdAV<",
"<VVAAVVAAVAVVAA<",
"H<<<<<<<<<<<<<<H"
};

/* XPM */
const char *applications_system_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 17 1",
"  c #3F638F",
". c #426B9C",
"X c #436FA5",
"o c #467ABA",
"O c #457ABE",
"+ c #497CBA",
"@ c #4C7FBD",
"# c #5682B7",
"$ c #5686C3",
"% c #6490C7",
"& c #7CA1CF",
"* c #82A5D1",
"= c #86A7D2",
"- c #8FAED5",
"; c #9DB8DA",
": c #BCCDE3",
"> c None",
/* pixels */
">>>>>>>>>>>>>>>>",
">>>>>>OOO>>>>>>>",
">>>OO>O:O>OO>>>>",
">>O:=O%;%O=:O>>>",
">>O=;;;;;;;=O>>>",
">>>O;&o$o*;O>>>>",
">OO%;o.> +;%OO>>",
">O:;;$>>>$;;:O>>",
">OO%;@#>Xo;%OO>>",
">>>O:&@$o-;O>>>>",
">>O=;;;;;;;=O>>>",
">>O:=O%;%O=:O>>>",
">>>OO>O:O>OO>>>>",
">>>>>>OOO>>>>>>>",
">>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>"
};

// ---------------------------------------------------------------------
// End Tango icons
// ---------------------------------------------------------------------

// audio-card from gnome icon theme

/* XPM */
const char *audio_card_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 102 2",
"   c #3A3E00",
".  c #3A3F00",
"X  c #3B3F00",
"o  c #2F3536",
"O  c #303634",
"+  c #303735",
"@  c #303637",
"#  c #363D32",
"$  c #323835",
"%  c #313836",
"&  c #333936",
"*  c #323937",
"=  c #343936",
"-  c #383E31",
";  c #3B4000",
":  c #3D4104",
">  c #3E4206",
",  c #657000",
"<  c #677300",
"1  c #687400",
"2  c #687502",
"3  c #687505",
"4  c #6B7704",
"5  c #6B7901",
"6  c #6C7900",
"7  c #6C7801",
"8  c #6D7A00",
"9  c #6C7A02",
"0  c #6F7D01",
"q  c #707E02",
"w  c #707E07",
"e  c #404630",
"r  c #3D5B50",
"t  c #38595E",
"y  c #38595F",
"u  c #395A5F",
"i  c #365761",
"p  c #405C4F",
"a  c #545650",
"s  c #545652",
"d  c #555753",
"f  c #565852",
"g  c #565853",
"h  c #565854",
"j  c #575955",
"k  c #585A56",
"l  c #5A5C58",
"z  c #5D5E5B",
"x  c #5E5F5C",
"c  c #426050",
"v  c #426251",
"b  c #646662",
"n  c #656663",
"m  c #666864",
"M  c #676965",
"N  c #696A67",
"B  c #696B67",
"V  c #6E6F6D",
"C  c #6E706C",
"Z  c #6F716D",
"A  c #758201",
"S  c #748202",
"D  c #798708",
"F  c #7F8839",
"G  c #A3B31A",
"H  c #A4B31A",
"J  c #A4B419",
"K  c #AABA1A",
"L  c #858E39",
"P  c #848D3B",
"I  c #878F3D",
"U  c #87903B",
"Y  c #8A9539",
"T  c #8C9638",
"R  c #919C38",
"E  c #949E39",
"W  c #959F3A",
"Q  c #959F3B",
"!  c #929D3C",
"~  c #939E3C",
"^  c #959F3D",
"/  c #95A03C",
"(  c #96A03C",
")  c #97A03C",
"_  c #97A13C",
"`  c #97A23D",
"'  c #D8EB31",
"]  c #DBEF33",
"[  c #DFF234",
"{  c #E0F338",
"}  c #E4F839",
"|  c #E8FB38",
" . c #EBFF39",
".. c #EFFF65",
"X. c #B7B9B5",
"o. c #C4C6C2",
"O. c #C6C8C4",
"+. c #C7C9C5",
"@. c #C8CAC6",
"#. c #D0D2CE",
"$. c #D4D6D2",
"%. c None",
/* pixels */
"%.%.%.%.%.%.%.%.%.%.%.%.j k j %.",
"%.%.%.%.%.%.%.%.%.%.%.d O.#.X.d ",
"X                     a $.d d %.",
"  E W W W Q Q ( ( ( ^ f $.d %.%.",
"  ` e * * % % + # c v f $.d l x ",
"  ` + V Z Z Z C & y u f $.d o.d ",
"  ` + Z d d d N = 3 8 f $.d h g ",
"  _ + B M m n b $ p t f $.d %.%.",
"  ) - @ o o o o O r i f $.d k z ",
"  / A q 0 9 5 2 1 < , f $.d @.d ",
"  ~ K S J 6 H 7 G U I f $.d d h ",
"  ! { D ' 4 ] w [ P : a $.d %.%.",
"  T ..R } L | Y  .F > s $.d %.%.",
"; X X X X X X . . . . s +.d %.%.",
"%.%.%.%.%.%.%.%.%.%.%.d d d %.%.",
"%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%."
};

// help-about from gnome

/* XPM */
const char *help_about_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 76 1",
"  c #C4A001",
". c #C5A101",
"X c #C5A102",
"o c #C6A202",
"O c #C6A203",
"+ c #C7A403",
"@ c #C7A404",
"# c #C7A405",
"$ c #C7A406",
"% c #C7A407",
"& c #C7A507",
"* c #C8A508",
"= c #C9A70B",
"- c #C9A80D",
"; c #CAA80C",
": c #C9A810",
"> c #CCAC12",
", c #CCAC14",
"< c #CDAE1B",
"1 c #CFB11C",
"2 c #D0B11F",
"3 c #CFB021",
"4 c #D2B522",
"5 c #D3B62C",
"6 c #D2B62F",
"7 c #F6E132",
"8 c #F6E235",
"9 c #F5E038",
"0 c #F7E23A",
"q c #F8E33C",
"w c #F8E43E",
"e c #D9C04A",
"r c #E4CE4C",
"t c #E4CE4F",
"y c #E7D041",
"u c #E7D247",
"i c #EBD755",
"p c #EBD756",
"a c #ECD85A",
"s c #F8E441",
"d c #F9E644",
"f c #F6E349",
"g c #FBE74A",
"h c #F9E74D",
"j c #F7E75F",
"k c #F8E75A",
"l c #FBE95C",
"z c #E9D668",
"x c #EAD86C",
"c c #F6E664",
"v c #F6E667",
"b c #F8E864",
"n c #F8E865",
"m c #F9E96B",
"M c #FAEB71",
"N c #F9EB73",
"B c #F8EA7B",
"V c #FAEC7C",
"C c #F9EC7F",
"Z c #EEDF83",
"A c #EEDF85",
"S c #F7E981",
"D c #F8EC88",
"F c #F9ED89",
"G c #FAED8B",
"H c #F8EB8F",
"J c #F9EE9B",
"K c #FBF097",
"L c #FCF2A6",
"P c #FCF3AA",
"I c #FDF6BC",
"U c #FCF7CF",
"Y c #FDF8D1",
"T c #FDF9DF",
"R c #FEFCEE",
"E c None",
/* pixels */
"EEEEEEE.EEEEEEEE",
"EEEEEE@e@EEEEEEE",
"EEEEEE3T<EEEEEEE",
"EEEEE+ARZ+EEEEEE",
"EEEEE%UVYOEEEEEE",
"EEE+OxLdIzo+EEEE",
"E$:rHKhglPJt-@EE",
"X6DCf8wddwkGS5XE",
"E&2aBn0qsNFi1#EE",
"EEE#;pj7mp=+EEEE",
"EEEEE*c9v@EEEEEE",
"EEEEE#uby@EEEEEE",
"EEEEEE,M>EEEEEEE",
"EEEEEE&4&EEEEEEE",
"EEEEEEE EEEEEEEE",
"EEEEEEEEEEEEEEEE"
};

// insert link icon from gnome

/* XPM */
const char *insert_link_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 97 2",
"   c #2E3436",
".  c #2F3536",
"X  c #363C3D",
"o  c #373D3E",
"O  c #464A48",
"+  c #464B4C",
"@  c #4F524F",
"#  c #545652",
"$  c #555753",
"%  c #575955",
"&  c #585A56",
"*  c #595B57",
"=  c #5A5B57",
"-  c #5A5C58",
";  c #5B5D58",
":  c #5C5D59",
">  c #62645F",
",  c #656763",
"<  c #6B6D69",
"1  c #6E6F6B",
"2  c #6F716D",
"3  c #71726F",
"4  c #767773",
"5  c #777875",
"6  c #7C7E79",
"7  c #7C7F79",
"8  c #CF5F04",
"9  c #D06106",
"0  c #D86605",
"q  c #D86706",
"w  c #F47A03",
"e  c #F47A04",
"r  c #F47D0B",
"t  c #E97910",
"y  c #E97911",
"u  c #7E807D",
"i  c #EA9D4C",
"p  c #F4B15E",
"a  c #F5B364",
"s  c #FDC97D",
"d  c #838580",
"f  c #8A8C87",
"g  c #979B96",
"h  c #989B95",
"j  c #9FA19D",
"k  c #B3B4B0",
"l  c #B4B7B0",
"z  c #B7B7B1",
"x  c #B5B7B2",
"c  c #B5B8B2",
"v  c #BABDB6",
"b  c #BBBEB7",
"n  c #BBBEB8",
"m  c #BDBEBB",
"M  c #C0C0BC",
"N  c #C2C3BF",
"B  c #FBD7AA",
"V  c #FBD9AE",
"C  c #C4C6C0",
"Z  c #C5C7C1",
"A  c #CBCEC8",
"S  c #CCCEC9",
"D  c #D0D1CE",
"F  c #D1D3CE",
"G  c #D4D4D0",
"H  c #D6D7D6",
"J  c #D9DAD8",
"K  c #DBDCDB",
"L  c #DEDEDA",
"P  c #DFDFDD",
"I  c #FDE6C4",
"U  c #FEE9CA",
"Y  c #FEEACC",
"T  c #E0E0DC",
"R  c #E0E0DD",
"E  c #E2E3E2",
"W  c #E4E4E1",
"Q  c #E6E6E4",
"!  c #E7E8E6",
"~  c #E9E9E6",
"^  c #E8E9E8",
"/  c #EDEDEB",
"(  c #EDEDEC",
")  c #EDEEED",
"_  c #EEEEEC",
"`  c #EFF0EE",
"'  c #F1F1F0",
"]  c #F3F3F1",
"[  c #F3F3F2",
"{  c #F4F5F4",
"}  c #F5F5F4",
"|  c #F6F6F5",
" . c #F6F6F6",
".. c #F8F8F7",
"X. c #F9F9F9",
"o. c #FDFDFD",
"O. c None",
/* pixels */
"O.# # # # ; O.O.O.O.O.O.O.O.; # ",
"O. .{ [ ` J u - O.O.O.O.- H ) o.",
"O.v v v b C F < # $ $ # 5 / A n ",
"O.# * $ * 7 b h 1 m m 1 x Z 6 % ",
"O.O.& R Q 2 $ $ $ $ $ $ $ $ 3 K ",
"O.O.: z L ] }  ...X.| ' ( ^ ! E ",
"O.O @ 4 M G T W ~ _ P D N k j f ",
"O.S c d , = $ $ $ $ $ $ $ $ & > ",
"O.v v v l g + X O.O.O.O.X + g l ",
"O.      . o O.O.O.O.O.O.O.O.o . ",
"O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.",
"O.O.O.O.O.w e r r r r r e w O.O.",
"O.O.O.O.O.O.y V Y I U B t O.O.O.",
"O.O.O.O.O.O.O.q a s p 0 O.O.O.O.",
"O.O.O.O.O.O.O.O.9 i 9 O.O.O.O.O.",
"O.O.O.O.O.O.O.O.O.8 O.O.O.O.O.O."
};
 
 // close icon from default gtk theme

/* XPM */
const char *close_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 74 1",
"  c #5A5C58",
". c #5C5E5B",
"X c #5C5F5B",
"o c #5D5F5B",
"O c #5E5F5B",
"+ c #5E5F5C",
"@ c #5D605A",
"# c #5D605B",
"$ c #5C615B",
"% c #5F605A",
"& c #5E615B",
"* c #5E605C",
"= c #5F605C",
"- c #5E615C",
"; c #5F615C",
": c #5E605D",
"> c #5E615D",
", c #5F625C",
"< c #5F625D",
"1 c #5F615E",
"2 c #5F625E",
"3 c #60615B",
"4 c #60625D",
"5 c #60615E",
"6 c #60625E",
"7 c #61625E",
"8 c #61645F",
"9 c #7D807A",
"0 c #7E817B",
"q c #80827B",
"w c #80837E",
"e c #82847D",
"r c #82857E",
"t c #838680",
"y c #848681",
"u c #848781",
"i c #868983",
"p c #878983",
"a c #868984",
"s c #888A85",
"d c #898C86",
"f c #898D86",
"g c #8A8C86",
"h c #8A8D88",
"j c #8D9089",
"k c #8E908A",
"l c #8E918B",
"z c #8F928C",
"x c #8F928D",
"c c #91938E",
"v c #92948F",
"b c #949590",
"n c #949691",
"m c #959892",
"M c #959992",
"N c #969994",
"B c #979B95",
"V c #B1B4AC",
"C c #B4B7AF",
"Z c #B8BBB3",
"A c #B9BCB4",
"S c #BABDB5",
"D c #BDC0B8",
"F c #BDC1B9",
"G c #BFC3BB",
"H c #C1C4BC",
"J c #C3C6BE",
"K c #C3C7BF",
"L c #C4C8C0",
"P c #C5C9C1",
"I c #CACEC6",
"U c #CBCEC6",
"Y c #CDD1C9",
"T c None",
/* pixels */
"TTTTTTTTTTTTTTTT",
"TTTTTTTTTTTTTTTT",
"TT681TTTTTT ,5TT",
"TT5Ll2TTTT=wZ:TT",
"TT4fUx7TT4aDu;TT",
"TTT3jYz<;dHs+TTT",
"TTTT>kINmJh=TTTT",
"TTTTT>BPKM*TTTTT",
"TTTTT-vHGc+TTTTT",
"TTTT-uFnbSr.TTTT",
"TTT=eAg%#iCq$TTT",
"TT:9Cp@TTXyV0;TT",
"TT;Vp@TTTTOtVoTT",
"TT44&TTTTTT&O4TT",
"TTTTTTTTTTTTTTTT",
"TTTTTTTTTTTTTTTT"
};

// enter key icon from KDE's crystal theme

/* XPM */
const char *enter_key_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 91 1",
"  c #5C5C5C",
". c #626262",
"X c #666666",
"o c #696969",
"O c #6B6B6B",
"+ c #6C6C6C",
"@ c #6E6E6E",
"# c #6F6F6F",
"$ c #717171",
"% c #737373",
"& c #747474",
"* c #838383",
"= c #8D8D8D",
"- c #92928F",
"; c #939393",
": c #A3A3A2",
"> c #A7A7A5",
", c #A7A7A6",
"< c #A7A7A7",
"1 c #A9A9A8",
"2 c #A9A9A9",
"3 c #AEAEAD",
"4 c #B0B0AE",
"5 c #B1B1AF",
"6 c #B2B2B0",
"7 c #B4B4B2",
"8 c #B5B5B3",
"9 c #B7B7B6",
"0 c #B7B7B7",
"q c #B9B9B7",
"w c #BABAB9",
"e c #BBBBBB",
"r c #BCBCBB",
"t c #BEBEBC",
"y c #C2C2C1",
"u c #C4C4C0",
"i c #C4C4C4",
"p c #C5C5C5",
"a c #C6C6C4",
"s c #C7C7C7",
"d c #C9C9C6",
"f c #CBCBC8",
"g c #CACACA",
"h c #CFCFCD",
"j c #D0D0CE",
"k c #D1D1CF",
"l c #D0D0D0",
"z c #D1D1D1",
"x c #D2D2D0",
"c c #D3D3D1",
"v c #D2D2D2",
"b c #D3D3D2",
"n c #D3D3D3",
"m c #D4D4D3",
"M c #D4D4D4",
"N c #D5D5D5",
"B c #D7D7D6",
"V c #D7D7D7",
"C c #D8D8D8",
"Z c #D9D9D8",
"A c #D9D9D9",
"S c #DADAD9",
"D c #DADADA",
"F c #DCDCDC",
"G c #DDDDDD",
"H c #DEDEDE",
"J c #DFDFDF",
"K c #E0E0E0",
"L c #E2E2E2",
"P c #E3E3E3",
"I c #E4E4E4",
"U c #E5E5E5",
"Y c #E7E7E7",
"T c #E8E8E8",
"R c #E9E9E9",
"E c #EBEBEB",
"W c #ECECEC",
"Q c #EDEDED",
"! c #EFEFEF",
"~ c #F0F0F0",
"^ c #F3F3F3",
"/ c #F4F4F4",
"( c #F5F5F5",
") c #F6F6F6",
"_ c #F7F7F7",
"` c #F8F8F8",
"' c #F9F9F9",
"] c #FAFAFA",
"[ c #FCFCFC",
"{ c #FDFDFD",
"} c None",
/* pixels */
"}}}}}}}}}}}}}}}}",
"}}}}}}fSFFFFFSd}",
"}}}}}}c{[[[[['a}",
"}}}}}}x]_`'`_`t}",
"}}}}}}x)^(p`^/r}",
"}}}}}}k^!!%'!!w}",
"}}}}}}j~WQ#`EWq}",
"}}}}}}yWTR@(TR9}",
"}Z)))_/YIU+~PI8}",
"}BLHKH<zLPOWJK7}",
"}mHGD= 2siXTFG6}",
"}bDApo$&**;HCC4}",
"}bVMA0.eDDCNMN3}",
"}hvlzngzllllll1}",
"}u5>,,,,,,,,,:-}",
"}}}}}}}}}}}}}}}}"
};

// question icon from default gtk theme

/* XPM */
const char *dialog_question_48_icon[] = {
"48 48 215 2",
"  	c None",
". 	c #3768A6",
"+ 	c #3968A7",
"@ 	c #3A6AA7",
"# 	c #386BA6",
"$ 	c #3968A5",
"% 	c #A7BEDA",
"& 	c #F4F7FB",
"* 	c #F4F8FB",
"= 	c #A5BDD9",
"- 	c #3769A6",
"; 	c #3869A6",
"> 	c #BBCEE4",
", 	c #FFFFFF",
"' 	c #FEFEFF",
") 	c #BBCDE3",
"! 	c #F9FBFD",
"~ 	c #98B9DC",
"{ 	c #99B9DC",
"] 	c #729FCF",
"^ 	c #97B8DB",
"/ 	c #BACDE3",
"( 	c #719ECE",
"_ 	c #709DCD",
": 	c #709DCE",
"< 	c #6F9CCD",
"[ 	c #6F9CCC",
"} 	c #95B6DA",
"| 	c #B9CDE3",
"1 	c #6E9CCC",
"2 	c #6E9BCC",
"3 	c #6D9BCC",
"4 	c #6D9ACB",
"5 	c #94B5D9",
"6 	c #B9CCE3",
"7 	c #78A2D0",
"8 	c #709CCC",
"9 	c #6C9ACB",
"0 	c #6C99CA",
"a 	c #6B99CA",
"b 	c #93B4D8",
"c 	c #B9CCE2",
"d 	c #739FCE",
"e 	c #A1BEDE",
"f 	c #C9DAEC",
"g 	c #EBF1F8",
"h 	c #FAFCFD",
"i 	c #E7EEF6",
"j 	c #B7CDE6",
"k 	c #759FCE",
"l 	c #6B98CA",
"m 	c #6A98C9",
"n 	c #6A97C9",
"o 	c #92B3D8",
"p 	c #B9CBE2",
"q 	c #80A8D3",
"r 	c #E8EFF7",
"s 	c #6997C9",
"t 	c #6996C8",
"u 	c #6896C8",
"v 	c #91B2D7",
"w 	c #B8CBE2",
"x 	c #7FA7D2",
"y 	c #FDFDFE",
"z 	c #E9F0F7",
"A 	c #EFF4F9",
"B 	c #BBD0E7",
"C 	c #6895C8",
"D 	c #6795C7",
"E 	c #6794C7",
"F 	c #8FB1D6",
"G 	c #B8CBE1",
"H 	c #7EA6D1",
"I 	c #F2F6FA",
"J 	c #ADC6E1",
"K 	c #749FCD",
"L 	c #6A98CA",
"M 	c #AFC7E2",
"N 	c #E1EAF4",
"O 	c #6694C7",
"P 	c #6694C6",
"Q 	c #6593C6",
"R 	c #8EAFD5",
"S 	c #B7CBE1",
"T 	c #96B7DA",
"U 	c #6C99CB",
"V 	c #709CCB",
"W 	c #719DCC",
"X 	c #7FA5D0",
"Y 	c #6693C6",
"Z 	c #6592C6",
"` 	c #6492C5",
" .	c #6391C5",
"..	c #8DAFD4",
"+.	c #B0C7E2",
"@.	c #CBDBEC",
"#.	c #6391C4",
"$.	c #6290C4",
"%.	c #8CADD3",
"&.	c #B7CAE1",
"*.	c #3768A5",
"=.	c #396AA7",
"-.	c #A4BCD8",
";.	c #96B6D8",
">.	c #FDFEFE",
",.	c #85A9D2",
"'.	c #6290C3",
").	c #618FC3",
"!.	c #608EC3",
"~.	c #8BADD3",
"{.	c #A0B8D6",
"].	c #3768A7",
"^.	c #FEFFFF",
"/.	c #99B8DA",
"(.	c #A4BFDD",
"_.	c #608EC2",
":.	c #5F8DC2",
"<.	c #5F8DC1",
"[.	c #8AABD2",
"}.	c #3868A6",
"|.	c #396AA6",
"1.	c #87AAD2",
"2.	c #FBFCFE",
"3.	c #A1BDDC",
"4.	c #5F8EC2",
"5.	c #5E8DC1",
"6.	c #5E8CC1",
"7.	c #89AAD1",
"8.	c #3767A6",
"9.	c #3969A6",
"0.	c #92B4D8",
"a.	c #D0DEEE",
"b.	c #B1C8E2",
"c.	c #5D8CC1",
"d.	c #5D8BC0",
"e.	c #87AAD1",
"f.	c #F9FAFD",
"g.	c #79A0CC",
"h.	c #5C8BC0",
"i.	c #87A9D0",
"j.	c #F9FAFC",
"k.	c #B6C9E0",
"l.	c #3767A5",
"m.	c #90B2D6",
"n.	c #6B97C7",
"o.	c #6C97C8",
"p.	c #6C97C7",
"q.	c #6C96C7",
"r.	c #5C8AC0",
"s.	c #5B8ABF",
"t.	c #87A8D0",
"u.	c #3668A4",
"v.	c #8FB0D6",
"w.	c #5C8ABF",
"x.	c #5B89BF",
"y.	c #86A8D0",
"z.	c #B6CAE1",
"A.	c #8DAFD5",
"B.	c #ECF1F8",
"C.	c #5A89BF",
"D.	c #5A89BE",
"E.	c #85A7CF",
"F.	c #F8FAFC",
"G.	c #B6CAE0",
"H.	c #BACDE2",
"I.	c #8BADD4",
"J.	c #F6F8FB",
"K.	c #5A88BE",
"L.	c #5988BE",
"M.	c #5987BD",
"N.	c #84A7CE",
"O.	c #89ABD3",
"P.	c #EBF1F7",
"Q.	c #5887BD",
"R.	c #84A6CE",
"S.	c #88ABD1",
"T.	c #5886BD",
"U.	c #5786BC",
"V.	c #83A6CE",
"W.	c #82A5CE",
"X.	c #3667A4",
"Y.	c #85A8D0",
"Z.	c #5785BC",
"`.	c #5685BC",
" +	c #82A4CD",
".+	c #B6C8E0",
"++	c #3767A3",
"@+	c #85A8CF",
"#+	c #5685BB",
"$+	c #5584BB",
"%+	c #3667A3",
"&+	c #B8CAE1",
"*+	c #5684BB",
"=+	c #81A4CC",
"-+	c #B5C8E0",
";+	c #3566A2",
">+	c #82A5CD",
",+	c #5483BA",
"'+	c #B7C9E0",
")+	c #81A4CD",
"!+	c #5382BA",
"~+	c #80A3CB",
"{+	c #B5C8DF",
"]+	c #80A3CC",
"^+	c #5382B9",
"/+	c #7FA2CB",
"(+	c #B4C8DF",
"_+	c #9DB5D3",
":+	c #F1F5F9",
"<+	c #F0F4F9",
"[+	c #9CB4D3",
"}+	c #3565A1",
"|+	c #305D95",
"1+	c #3666A3",
"2+	c #305D96",
"                                                                                                ",
"                                                                                                ",
"                                            . + @ #                                             ",
"                                          $ % & * = -                                           ",
"                                        ; > , ' ' , ) ;                                         ",
"                                      ; > , ! ~ { ! , ) ;                                       ",
"                                    ; > , ! ~ ] ] ~ ! , ) ;                                     ",
"                                  ; > , ! ~ ] ] ] ] ~ ! , ) ;                                   ",
"                                ; > , ! ~ ] ] ] ] ] ] ~ ! , ) ;                                 ",
"                              ; > , ! ~ ] ] ] ] ] ] ] ] ~ ! , ) -                               ",
"                            ; > , ! ~ ] ] ] ] ] ] ] ] ] ] ^ ! , / -                             ",
"                          ; > , ! ~ ] ] ] ] ] ] ] ] ] ( ( _ ^ ! , / -                           ",
"                        ; > , ! ~ ] ] ] ] ] ] ] ( ( : _ < < [ } ! , | -                         ",
"                      ; > , ! ~ ] ] ] ] ] ] ( ( _ _ < < 1 2 3 4 5 ! , 6 -                       ",
"                    ; > , ! ~ ] ] ] ] ( ( : _ < 7 8 2 2 4 4 9 0 a b ! , c -                     ",
"                  ; > , ! ~ ] ] ] ( ( d e f g h , ' i j k a a l m n o ! , p -                   ",
"                ; > , ! ~ ] ( ( : _ < q , , , , , , , , r k n n s t u v ! , w -                 ",
"              ; > , ! ~ ( ( _ _ < < 1 x , , y z A , , , , B t u u C D E F ! , G -               ",
"            ; > , ! ^ : _ < < [ 2 2 4 H I J K l L M , , , N C D D O P Q Q R ! , S -             ",
"          ; > , ! T _ < < 1 2 3 4 9 U V W l m n s X , , , i E O Y Q Z ` `  ...! , S -           ",
"        $ > , ! } < [ 2 2 4 4 9 0 a l L n n s t u +., , , @.Q Q Z ` `  .#.$.$.%.! , &.*.        ",
"      =.-., ! } 1 2 3 4 9 U 0 a l m n s t u u C ;.>., , >.,.` `  .#.$.$.'.).).!.~.! , {.].      ",
"      . & ^.} 2 4 4 9 0 a l L n n s t u C D D /.y , , ^.(.`  .#.$.$.).).)._._.:.<.[.' I }.      ",
"      |.& ^.5 9 U 0 a l m n s t u u C D E O 1.2., , ^.3.#.$.$.'.).).!._.4.:.5.6.6.7.' I 8.      ",
"      9.-., ! 0.l L n n s t u C D D O P Q Q a., , , b.$.$.).).)._._.:.<.6.6.c.d.e.f., {.8.      ",
"        *./ , ! v s t u u C D E O Y Q Q ` ` r , , , g.).).!._.4.:.5.6.6.d.d.h.i.j., k.l.        ",
"          - ) , ! m.C D D O P Q Q Z ` `  .#.n.o.p.q.'._._.:.<.6.6.c.d.h.r.s.t.j., k.u.          ",
"            - ) , ! v.O Y Q Q ` `  .#.$.$.'.).).!._.4.:.5.6.6.d.d.h.w.s.x.y.j., z.u.            ",
"              - / , ! A.Z ` `  .#.$.$.'.).).B.& & & 6.6.c.d.h.r.s.x.C.D.E.F., G.u.              ",
"                - H., ! I.#.$.$.'.).).!._.4.J., , , d.d.h.w.s.x.C.D.K.E.F., k.u.                ",
"                  - c , ! ~.'.).)._._.:.<.6.J., , , r.s.x.x.D.K.L.M.N.F., k.u.                  ",
"                    - c , ! O._.4.:.5.6.6.d.P.& & & x.C.D.K.L.M.Q.R.F., k.u.                    ",
"                      - p , ! S.5.6.c.d.h.r.s.x.x.D.K.L.M.Q.T.U.V.F., k.u.                      ",
"                        l.w , f.i.d.h.w.s.x.C.D.K.L.M.Q.T.U.U.W.F., k.X.                        ",
"                          l.G , f.Y.x.x.D.K.L.M.Q.T.U.U.Z.`. +F., .+X.                          ",
"                            ++G , j.@+K.L.M.Q.T.U.U.`.#+$+ +F., .+%+                            ",
"                              %+&+, F.V.T.U.U.Z.`.*+$+$+=+F., -+%+                              ",
"                                ;+&., F.>+`.#+$+$+,+,+=+F., -+;+                                ",
"                                  ;+'+, F.)+$+,+,+!+~+F., {+;+                                  ",
"                                    ;+k., F.]+!+^+/+F., {+;+                                    ",
"                                      ;+k., F./+~+F., (+;+                                      ",
"                                        %+k., ^.^., (+%+                                        ",
"                                          ;+_+:+<+[+}+                                          ",
"                                            |+}+1+2+                                            ",
"                                                                                                ",
"                                                                                                ",
"                                                                                                ",
"                                                                                                "
};

/* XPM */
const char *clear_sq_icon[] = {
"16 16 1 1",
"     c None",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                "
};

const char *clear_row_icon[] = {
"16 1 1 1",
"     c None",
"                "
};


