#ifndef JSRUNNER_H
#define JSRUNNER_H

#include <QObject>
#include <QWebEngineProfile>
#include <QWebEnginePage>
#include <QTimer>
#include <QEventLoop>

class JSRunner : public QObject
{
    Q_OBJECT

public:
    JSRunner();
    ~JSRunner();
    bool setHtml(QString);
    QVariant runJavaScript(QString);

private:
    bool htmlReady;
    QVariant result;

signals:
    void resultAvailable();

private:
    QWebEngineProfile* profile;
    QWebEnginePage* page;
    QTimer timer;
    QEventLoop loop;

private slots:
    void handleHtmlReady(bool);
    void handleResultReady(const QVariant&);
};

#endif // JSRUNNER_H
