Name:           clementine
Version:        1.3.1
Release:        1%{?dist}
Summary:        A music player and library organiser

Group:          Applications/Multimedia
License:        GPLv3
URL:            http://www.clementine-player.org/
Source0:        %{name}-1.3.1.tar.xz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  desktop-file-utils liblastfm-devel taglib-devel gettext
BuildRequires:  qt4-devel boost-devel gcc-c++ glew-devel libgpod-devel
BuildRequires:  cmake gstreamer1-devel gstreamer1-plugins-base-devel
BuildRequires:  libmtp-devel protobuf-devel protobuf-compiler libcdio-devel
BuildRequires:  qjson-devel cryptopp-devel fftw-devel sparsehash-devel
BuildRequires:  sqlite-devel pulseaudio-libs-devel libechonest-devel
BuildRequires:  libchromaprint-devel

Requires:       libgpod protobuf-lite libcdio qjson sqlite

# GStreamer codec dependencies
Requires:       gstreamer1-plugins-ugly

%ifarch x86_64
Requires:       gstreamer1(decoder-audio/x-vorbis)()(64bit)
Requires:       gstreamer1(decoder-audio/x-flac)()(64bit)
Requires:       gstreamer1(decoder-audio/x-speex)()(64bit)
Requires:       gstreamer1(decoder-audio/x-wav)()(64bit)
%else
Requires:       gstreamer1(decoder-audio/x-vorbis)
Requires:       gstreamer1(decoder-audio/x-flac)
Requires:       gstreamer1(decoder-audio/x-speex)
Requires:       gstreamer1(decoder-audio/x-wav)
%endif

%description
Clementine is a modern music player and library organiser.
It is inspired by Amarok 1.4, focusing on a fast and easy-to-use interface for
searching and playing your music.

Features include:
  * Search and play your local music library
  * Listen to internet radio from Last.fm, SomaFM, Magnatune, Jamendo and Icecast
  * Create smart playlists and dynamic playlists
  * Tabbed playlists, import and export M3U, XSPF, PLS and ASX
  * Visualisations from projectM
  * Lyrics and artist biographies and photos
  * Transcode music into MP3, Ogg Vorbis, Ogg Speex, FLAC or AAC
  * Edit tags on MP3 and OGG files, organise your music
  * Download missing album cover art from Last.fm
  * Cross-platform - works on Windows, Mac OS X and Linux
  * Native desktop notifications on Linux (libnotify) and Mac OS X (Growl)
  * Remote control using a Wii Remote, MPRIS or the command-line
  * Copy music to your iPod, iPhone, MTP or mass-storage USB player
  * Queue manager

%prep
%setup -q -n %{name}-1.3.1


%build
cd bin
%{cmake} .. -DUSE_INSTALL_PREFIX=OFF -DBUNDLE_PROJECTM_PRESETS=ON -DCMAKE_POSITION_INDEPENDENT_CODE=ON
make %{?_smp_mflags}

%install
cd bin
make install DESTDIR=$RPM_BUILD_ROOT
rm -f $RPM_BUILD_ROOT/usr/share/icons/ubuntu-mono-{dark,light}/apps/24/clementine-panel*.png

%clean
cd bin
make clean


%files
%defattr(-,root,root,-)
%doc
%{_bindir}/clementine
%{_bindir}/clementine-tagreader
%{_datadir}/appdata/clementine.appdata.xml
%{_datadir}/applications/clementine.desktop
%{_datadir}/clementine/projectm-presets
%{_datadir}/kde4/services/clementine-itms.protocol
%{_datadir}/kde4/services/clementine-itpc.protocol
%{_datadir}/kde4/services/clementine-feed.protocol
%{_datadir}/kde4/services/clementine-zune.protocol
%{_datadir}/icons/hicolor/64x64/apps/clementine.png
%{_datadir}/icons/hicolor/128x128/apps/clementine.png
%{_datadir}/icons/hicolor/scalable/apps/clementine.svg

%changelog
* Tue Apr 19 2016 David Sansome <me@davidsansome.com> - 1.3.1
- Version 1.3.1
