// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package org.chromium.chrome.browser.video_tutorials.test;

import android.graphics.Bitmap;

import androidx.annotation.Nullable;

import org.chromium.base.Callback;
import org.chromium.chrome.browser.image_fetcher.ImageFetcher;
import org.chromium.chrome.browser.image_fetcher.ImageFetcherConfig;

import jp.tomorrowkey.android.gifplayer.BaseGifImage;

/** A {@link ImageFetcher} for tests that can fetch a test bitmap. */
public class TestImageFetcher extends ImageFetcher.ImageFetcherForTesting {
    private final Bitmap mBitmapToFetch;

    public TestImageFetcher(@Nullable Bitmap bitmapToFetch) {
        mBitmapToFetch = bitmapToFetch;
    }

    @Override
    public void fetchGif(final Params params, Callback<BaseGifImage> callback) {}

    @Override
    public void fetchImage(Params params, Callback<Bitmap> callback) {
        callback.onResult(mBitmapToFetch);
    }

    @Override
    public void clear() {}

    @Override
    public @ImageFetcherConfig int getConfig() {
        return ImageFetcherConfig.IN_MEMORY_ONLY;
    }

    @Override
    public void destroy() {}
}
