// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_APP_LIST_ICON_STANDARDIZER_H_
#define CHROME_BROWSER_UI_APP_LIST_ICON_STANDARDIZER_H_

namespace gfx {
class ImageSkia;
}  // namespace gfx

// TODO(mmourgos): Look into possibly moving this code to ui/gfx/image.
namespace app_list {

// Takes an icon image and returns a standardized version of that icon. This
// function consists of the following steps:
// 1. Check if the original icon is already circle shaped. If it is, then
//    return the original input icon.
// 2. Find the scale required to resize and fit the original icon inside of
//    a new circle background.
// 3. Scale down the icon and draw it over a background circle. Return the newly
//    generated icon as the standard icon.
gfx::ImageSkia CreateStandardIconImage(const gfx::ImageSkia& image);

}  // namespace app_list

#endif  // CHROME_BROWSER_UI_APP_LIST_ICON_STANDARDIZER_H_
