// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// #import {Route} from '../router.m.js';

/**
 * Specifies all possible os routes in settings.
 *
 * @typedef {{
 *   ABOUT: !settings.Route,
 *   ABOUT_ABOUT: !settings.Route,
 *   ACCOUNTS: !settings.Route,
 *   ACCOUNT_MANAGER: !settings.Route,
 *   ADVANCED: !settings.Route,
 *   AMBIENT_MODE: !settings.Route,
 *   AMBIENT_MODE_PHOTOS: !settings.Route,
 *   APP_MANAGEMENT: !settings.Route,
 *   APP_MANAGEMENT_DETAIL: !settings.Route,
 *   APP_MANAGEMENT_PLUGIN_VM_SHARED_PATHS: !settings.Route,
 *   APP_MANAGEMENT_PLUGIN_VM_SHARED_USB_DEVICES: !settings.Route,
 *   APPS: !settings.Route,
 *   ANDROID_APPS_DETAILS: !settings.Route,
 *   CROSTINI: !settings.Route,
 *   CROSTINI_ANDROID_ADB: !settings.Route,
 *   CROSTINI_DETAILS: !settings.Route,
 *   CROSTINI_DISK_RESIZE: !settings.Route,
 *   CROSTINI_EXPORT_IMPORT: !settings.Route,
 *   CROSTINI_SHARED_PATHS: !settings.Route,
 *   CROSTINI_SHARED_USB_DEVICES: !settings.Route,
 *   BASIC: !settings.Route,
 *   BLUETOOTH: !settings.Route,
 *   BLUETOOTH_DEVICES: !settings.Route,
 *   CHANGE_PICTURE: !settings.Route,
 *   CUPS_PRINTERS: !settings.Route,
 *   DATETIME: !settings.Route,
 *   DATETIME_TIMEZONE_SUBPAGE: !settings.Route,
 *   DETAILED_BUILD_INFO: !settings.Route,
 *   DEVICE: !settings.Route,
 *   DISPLAY: !settings.Route,
 *   EXTERNAL_STORAGE_PREFERENCES: !settings.Route,
 *   FINGERPRINT: !settings.Route,
 *   FILES: !settings.Route,
 *   GOOGLE_ASSISTANT: !settings.Route,
 *   INTERNET: !settings.Route,
 *   INTERNET_NETWORKS: !settings.Route,
 *   KERBEROS_ACCOUNTS: !settings.Route,
 *   KEYBOARD: !settings.Route,
 *   KNOWN_NETWORKS: !settings.Route,
 *   LOCK_SCREEN: !settings.Route,
 *   MANAGE_ACCESSIBILITY: !settings.Route,
 *   MANAGE_CAPTION_SETTINGS: !settings.Route,
 *   MANAGE_SWITCH_ACCESS_SETTINGS: !settings.Route,
 *   MANAGE_TTS_SETTINGS: !settings.Route,
 *   MULTIDEVICE: !settings.Route,
 *   MULTIDEVICE_FEATURES: !settings.Route,
 *   NEARBY_SHARE: !settings.Route,
 *   NETWORK_DETAIL: !settings.Route,
 *   OS_ACCESSIBILITY: !settings.Route,
 *   OS_LANGUAGES: !settings.Route,
 *   OS_LANGUAGES_DETAILS: !settings.Route,
 *   OS_LANGUAGES_EDIT_DICTIONARY: !settings.Route,
 *   OS_LANGUAGES_INPUT: !settings.Route,
 *   OS_LANGUAGES_INPUT_METHODS: !settings.Route,
 *   OS_LANGUAGES_INPUT_METHOD_OPTIONS: !settings.Route,
 *   OS_LANGUAGES_LANGUAGES: !settings.Route,
 *   OS_LANGUAGES_SMART_INPUTS: !settings.Route,
 *   OS_PRINTING: !settings.Route,
 *   OS_PRIVACY: !settings.Route,
 *   OS_RESET: !settings.Route,
 *   OS_SEARCH: !settings.Route,
 *   OS_SIGN_OUT: !settings.Route,
 *   OS_SYNC: !settings.Route,
 *   OS_PEOPLE: !settings.Route,
 *   PERSONALIZATION: !settings.Route,
 *   POINTERS: !settings.Route,
 *   POWER: !settings.Route,
 *   PRIVACY: !settings.Route,
 *   SEARCH: !settings.Route,
 *   SMART_LOCK: !settings.Route,
 *   SMB_SHARES: !settings.Route,
 *   STORAGE: !settings.Route,
 *   STYLUS: !settings.Route,
 *   SYNC: !settings.Route,
 *   SYNC_ADVANCED: !settings.Route,
 * }}
 */
/* #export */ let OsSettingsRoutes;
