// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * Available switch assignment values.
 * @enum {number}
 */
const SwitchAccessAssignmentValue = {
  NONE: 0,
  ONE: 1,
  TWO: 2,
  THREE: 3,
  FOUR: 4,
  FIVE: 5,
  SPACE: 6,
  ENTER: 7,
};

/**
 * Available commands.
 * @enum {string}
 */
const SwitchAccessCommand = {
  NEXT: 'next',
  PREVIOUS: 'previous',
  SELECT: 'select'
};
