// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_NEARBY_SHARING_MOCK_NEARBY_SHARING_SERVICE_H_
#define CHROME_BROWSER_NEARBY_SHARING_MOCK_NEARBY_SHARING_SERVICE_H_

#include "chrome/browser/nearby_sharing/nearby_sharing_service.h"
#include "testing/gmock/include/gmock/gmock.h"

class MockNearbySharingService : public NearbySharingService {
 public:
  MockNearbySharingService();
  ~MockNearbySharingService() override;

  // NearbySharingService:
  MOCK_METHOD(void, AddObserver, (NearbySharingService::Observer*), (override));
  MOCK_METHOD(void,
              RemoveObserver,
              (NearbySharingService::Observer*),
              (override));
  MOCK_METHOD(bool, HasObserver, (NearbySharingService::Observer*), (override));
  MOCK_METHOD(StatusCodes,
              RegisterSendSurface,
              (TransferUpdateCallback*,
               ShareTargetDiscoveredCallback*,
               SendSurfaceState),
              (override));
  MOCK_METHOD(StatusCodes,
              UnregisterSendSurface,
              (TransferUpdateCallback*, ShareTargetDiscoveredCallback*),
              (override));
  MOCK_METHOD(StatusCodes,
              RegisterReceiveSurface,
              (TransferUpdateCallback*, ReceiveSurfaceState),
              (override));
  MOCK_METHOD(StatusCodes,
              UnregisterReceiveSurface,
              (TransferUpdateCallback*),
              (override));
  MOCK_METHOD(StatusCodes, ClearForegroundReceiveSurfaces, (), (override));
  MOCK_METHOD(bool, IsInHighVisibility, (), (override));
  MOCK_METHOD(StatusCodes,
              SendAttachments,
              (const ShareTarget&, std::vector<std::unique_ptr<Attachment>>),
              (override));
  MOCK_METHOD(void,
              Accept,
              (const ShareTarget&, StatusCodesCallback),
              (override));
  MOCK_METHOD(void,
              Reject,
              (const ShareTarget&, StatusCodesCallback),
              (override));
  MOCK_METHOD(void,
              Cancel,
              (const ShareTarget&, StatusCodesCallback),
              (override));
  MOCK_METHOD(void,
              Open,
              (const ShareTarget&, StatusCodesCallback),
              (override));
  MOCK_METHOD(NearbyNotificationDelegate*,
              GetNotificationDelegate,
              (const std::string&),
              (override));
  MOCK_METHOD(NearbyShareSettings*, GetSettings, (), (override));
  MOCK_METHOD(NearbyShareHttpNotifier*, GetHttpNotifier, (), (override));
  MOCK_METHOD(NearbyShareLocalDeviceDataManager*,
              GetLocalDeviceDataManager,
              (),
              (override));
  MOCK_METHOD(NearbyShareContactManager*, GetContactManager, (), (override));
  MOCK_METHOD(NearbyShareCertificateManager*,
              GetCertificateManager,
              (),
              (override));
};

#endif  // CHROME_BROWSER_NEARBY_SHARING_MOCK_NEARBY_SHARING_SERVICE_H_
