// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_EXTENSIONS_API_TAB_GROUPS_TAB_GROUPS_CONSTANTS_H_
#define CHROME_BROWSER_EXTENSIONS_API_TAB_GROUPS_TAB_GROUPS_CONSTANTS_H_

namespace extensions {

// Constants used for the Tab Groups API.
namespace tab_groups_constants {

// Keys used in serializing group data & events.
extern const char kCollapsedKey[];
extern const char kColorKey[];
extern const char kTitleKey[];

// Error messages.
extern const char kCannotMoveGroupIntoMiddleOfOtherGroupError[];
extern const char kCannotMoveGroupIntoMiddleOfPinnedTabsError[];
extern const char kGroupNotFoundError[];

}  // namespace tab_groups_constants
}  // namespace extensions

#endif  // CHROME_BROWSER_EXTENSIONS_API_TAB_GROUPS_TAB_GROUPS_CONSTANTS_H_
