// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_VR_ELEMENTS_UI_ELEMENT_NAME_H_
#define CHROME_BROWSER_VR_ELEMENTS_UI_ELEMENT_NAME_H_

#include <string>

#include "chrome/browser/vr/vr_ui_export.h"

namespace vr {

// These identifiers serve as stable, semantic identifiers for UI elements.
enum UiElementName {
  kNone = 0,
  kRoot,
  k2dBrowsingRepositioner,
  k2dBrowsingRoot,
  k2dBrowsingBackground,
  k2dBrowsingDefaultBackground,
  k2dBrowsingTexturedBackground,
  k2dBrowsingForeground,
  k2dBrowsingContentGroup,
  k2dBrowsingViewportAwareRoot,
  kWebVrRoot,
  kWebVrViewportAwareRoot,
  kContentResizer,
  kContentFrame,
  kContentFrameHitPlane,
  kContentQuad,
  kControllerRoot,
  kControllerGroup,
  kLaser,
  kController,
  kRepositionCursor,
  kReticle,
  kReticleLaserGroup,
  kKeyboardDmmRoot,
  kKeyboard,
  kBackplane,
  kCeiling,
  kFloor,
  kStars,
  kUrlBarPositioner,
  kUrlBarDmmRoot,
  kUrlBar,
  kUrlBarLayout,
  kUrlBarBackButton,
  kUrlBarLeftSeparator,
  kUrlBarSecurityButtonRegion,
  kUrlBarSecurityButton,
  kUrlBarOriginLayout,
  kUrlBarOriginRegion,
  kUrlBarUrlText,
  kUrlBarHintLayout,
  kUrlBarHintText,
  kUrlBarRightSeparator,
  kUrlBarOverflowButton,
  kOverflowMenuBackplane,
  kOverflowMenu,
  kOverflowMenuLayout,
  kOverflowMenuForwardButton,
  kOverflowMenuReloadButton,
  kOverflowMenuNewTabItem,
  kOverflowMenuNewIncognitoTabItem,
  kOverflowMenuBookmarksItem,
  kOverflowMenuRecentTabsItem,
  kOverflowMenuHistoryItem,
  kOverflowMenuDownloadsItem,
  kOverflowMenuShareItem,
  kOverflowMenuPreferencesItem,
  kOverflowMenuCloseAllTabsItem,
  kOverflowMenuCloseAllIncognitoTabsItem,
  kOverflowMenuSendFeedbackItem,
  kOmniboxDmmRoot,
  kOmniboxRoot,
  kOmniboxBackground,
  kOmniboxTextField,
  kOmniboxTextFieldLayout,
  kOmniboxVoiceSearchButton,
  kOmniboxCloseButton,
  kOmniboxSuggestions,
  kOmniboxSuggestionsOuterLayout,
  kOmniboxOuterLayout,
  k2dBrowsingHostedUi,
  k2dBrowsingHostedUiContent,
  k2dBrowsingVisibiltyHider,
  k2dBrowsingVisibiltyFader,
  kIndicatorBackplane,
  kIndicatorLayout,
  kAudioCaptureIndicator,
  kVideoCaptureIndicator,
  kScreenCaptureIndicator,
  kLocationAccessIndicator,
  kBluetoothConnectedIndicator,
  kWebVrIndicatorTransience,
  kWebVrIndicatorLayout,
  kWebVrAudioCaptureIndicator,
  kWebVrVideoCaptureIndicator,
  kWebVrScreenCaptureIndicator,
  kWebVrLocationAccessIndicator,
  kWebVrBluetoothConnectedIndicator,
  kLoadingIndicator,
  kLoadingIndicatorForeground,
  kCloseButton,
  kScreenDimmer,
  kExitWarningText,
  kExitWarningBackground,
  kExitPrompt,
  kWebVrExclusiveScreenToast,
  kPlatformToastTransientParent,
  kPlatformToast,
  kSolidBackground,
  kWebVrFloor,
  kWebVrHostedUi,
  kWebVrHostedUiContent,
  kWebVrTimeoutRoot,
  kWebVrTimeoutSpinner,
  kWebVrBackground,
  kWebVrTimeoutMessage,
  kWebVrTimeoutMessageLayout,
  kWebVrTimeoutMessageIcon,
  kWebVrTimeoutMessageText,
  kWebVrTimeoutMessageButton,
  kWebVrTimeoutMessageButtonText,
  kSpeechRecognitionRoot,
  kSpeechRecognitionCircle,
  kSpeechRecognitionMicrophoneIcon,
  kSpeechRecognitionResult,
  kSpeechRecognitionResultText,
  kSpeechRecognitionResultBackplane,
  kSpeechRecognitionListening,
  kSpeechRecognitionListeningGrowingCircle,
  kSpeechRecognitionListeningCloseButton,
  kControllerTrackpadLabel,
  kControllerTrackpadRepositionLabel,
  kControllerExitButtonLabel,
  kControllerBackButtonLabel,
  kControllerRepositionFinishLabel,
  kControllerTouchpadButton,
  kControllerAppButton,
  kControllerHomeButton,
  kControllerBatteryDot0,
  kControllerBatteryDot1,
  kControllerBatteryDot2,
  kControllerBatteryDot3,
  kControllerBatteryDot4,
  kContentRepositionHitPlane,
  kContentRepositionVisibilityToggle,
  kWebXrExternalPromptNotification,
  kUsbConnectedIndicator,
  kWebXrUsbConnectedIndicator,
  kMidiConnectedIndicator,
  kWebXrMidiConnectedIndicator,

  // This must be last.
  kNumUiElementNames,
};

VR_UI_EXPORT std::string UiElementNameToString(UiElementName name);

}  // namespace vr

#endif  // CHROME_BROWSER_VR_ELEMENTS_UI_ELEMENT_NAME_H_
